/*
SQLyog Ultimate v12.5.1 (64 bit)
MySQL - 10.3.16-MariaDB : Database - aps_badilag
*********************************************************************
*/

/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
CREATE DATABASE /*!32312 IF NOT EXISTS*/`aps_badilag` /*!40100 DEFAULT CHARACTER SET latin1 */;

USE `aps_badilag`;

/*Table structure for table `abt_config` */

DROP TABLE IF EXISTS `abt_config`;

CREATE TABLE `abt_config` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `category` varchar(50) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `value` text DEFAULT NULL,
  `information` varchar(100) DEFAULT NULL,
  `modifier` varchar(30) DEFAULT NULL,
  `modified` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

/*Data for the table `abt_config` */

insert  into `abt_config`(`id`,`category`,`name`,`value`,`information`,`modifier`,`modified`) values 
(1,'system','validasi_data_bas','0','Enable Disable Validasi BAS','admin','2019-08-24 10:19:52'),
(2,'system','nama_pengadilan','pa-majene','Defenisi Nama Pengadilan di Dirput','admin','2019-08-24 13:31:26'),
(3,'system','jenis_kertas','A4s','Jenis Ukuran Kertas Yang Digunakan',NULL,'2019-08-05 12:40:33'),
(4,'system','new_versi','','Deteksi Update Baru','iwan','2019-08-24 09:19:13');

/*Table structure for table `abt_data_dirput` */

DROP TABLE IF EXISTS `abt_data_dirput`;

CREATE TABLE `abt_data_dirput` (
  `nomor_perkara` char(50) NOT NULL,
  `nomor` smallint(6) NOT NULL,
  `pdt` char(5) DEFAULT NULL,
  `tahun` smallint(6) DEFAULT NULL,
  `kode` char(10) DEFAULT NULL,
  `link_perkara` char(50) DEFAULT NULL,
  `modifier` varchar(30) DEFAULT NULL,
  `modified` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`nomor_perkara`),
  UNIQUE KEY `link_perkara` (`link_perkara`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `abt_data_dirput` */

/*Table structure for table `abt_data_tanggal` */

DROP TABLE IF EXISTS `abt_data_tanggal`;

CREATE TABLE `abt_data_tanggal` (
  `no_var` int(4) unsigned zerofill NOT NULL,
  `perkara_id` bigint(20) NOT NULL,
  `data` date DEFAULT NULL,
  `modifier` varchar(30) DEFAULT NULL,
  `modified` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`no_var`,`perkara_id`),
  CONSTRAINT `FK_abt_data_tanggal` FOREIGN KEY (`no_var`) REFERENCES `abt_variabel` (`no_var`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `abt_data_tanggal` */

/*Table structure for table `abt_data_teks` */

DROP TABLE IF EXISTS `abt_data_teks`;

CREATE TABLE `abt_data_teks` (
  `no_var` int(4) unsigned zerofill NOT NULL,
  `perkara_id` bigint(20) NOT NULL,
  `data` text DEFAULT NULL,
  `modifier` varchar(30) DEFAULT NULL,
  `modified` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`no_var`,`perkara_id`),
  CONSTRAINT `FK_abt_data_teks` FOREIGN KEY (`no_var`) REFERENCES `abt_variabel` (`no_var`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `abt_data_teks` */

/*Table structure for table `abt_data_validasi_bas` */

DROP TABLE IF EXISTS `abt_data_validasi_bas`;

CREATE TABLE `abt_data_validasi_bas` (
  `id` bigint(20) unsigned NOT NULL,
  `perkara_id` bigint(20) unsigned NOT NULL,
  `sidang_ke` tinyint(3) unsigned NOT NULL,
  `file_name` char(250) DEFAULT NULL,
  `tgl_sidang` char(50) NOT NULL,
  `dir_blangko` varchar(500) DEFAULT NULL,
  `direktori` varchar(1000) DEFAULT NULL,
  `dibuat_oleh` varchar(500) DEFAULT NULL,
  `dibuat_tanggal` datetime DEFAULT NULL,
  `validasi_oleh` varchar(500) DEFAULT NULL,
  `validasi_tanggal` datetime DEFAULT NULL,
  `status` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `modifier` varchar(30) DEFAULT NULL,
  `modified` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `perkara_id_sidang_ke` (`perkara_id`,`sidang_ke`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `abt_data_validasi_bas` */

/*Table structure for table `abt_keterangan_saksi` */

DROP TABLE IF EXISTS `abt_keterangan_saksi`;

CREATE TABLE `abt_keterangan_saksi` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `perkara_id` bigint(20) DEFAULT NULL,
  `sidang_id` bigint(20) DEFAULT NULL,
  `penanya_id` char(1) DEFAULT NULL COMMENT '1: Ketua Majelis; 2:Hakim Anggota 1; 3: Hakim Anggota 2; 4; Hakim Anggota :3; 5 Hakim Anggota 4',
  `saksi_id` int(11) DEFAULT NULL COMMENT 'refer perkara_pihak_5',
  `urutan_pertanyaan` int(11) DEFAULT NULL,
  `pertanyaan` text DEFAULT NULL,
  `jawaban` text DEFAULT NULL,
  `diinput_oleh` varchar(30) DEFAULT NULL,
  `diinput_tanggal` datetime DEFAULT NULL,
  `diperbaharui_oleh` varchar(30) DEFAULT NULL,
  `diperbaharui_tanggal` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `perkara_id` (`perkara_id`,`sidang_id`,`saksi_id`,`urutan_pertanyaan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `abt_keterangan_saksi` */

/*Table structure for table `abt_keterangan_terdakwa` */

DROP TABLE IF EXISTS `abt_keterangan_terdakwa`;

CREATE TABLE `abt_keterangan_terdakwa` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `perkara_id` bigint(20) NOT NULL,
  `sidang_id` bigint(20) NOT NULL,
  `penanya_id` char(1) DEFAULT NULL COMMENT '1: Ketua Majelis; 2:Hakim Anggota 1; 3: Hakim Anggota 2; 4; Hakim Anggota :3; 5 Hakim Anggota 4',
  `pihak_id` bigint(20) NOT NULL COMMENT 'refer ke id perkara_pihak_2',
  `urutan_pertanyaan` int(11) DEFAULT NULL,
  `pertanyaan` text DEFAULT NULL,
  `jawaban` text DEFAULT NULL,
  `diinput_oleh` varchar(30) DEFAULT NULL,
  `diinput_tanggal` datetime DEFAULT NULL,
  `diperbaharui_oleh` varchar(30) DEFAULT NULL,
  `diperbaharui_tanggal` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `perkara_id` (`perkara_id`,`sidang_id`,`pihak_id`,`urutan_pertanyaan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `abt_keterangan_terdakwa` */

/*Table structure for table `abt_menu` */

DROP TABLE IF EXISTS `abt_menu`;

CREATE TABLE `abt_menu` (
  `id` int(4) unsigned NOT NULL,
  `nama` varchar(200) NOT NULL,
  `nama_alias` varchar(200) NOT NULL,
  `direktori` varchar(500) NOT NULL,
  `parent_direktori` varchar(500) NOT NULL,
  `proses_id_min` int(10) unsigned NOT NULL,
  `proses_id_max` int(10) unsigned NOT NULL,
  `perkara_id_min` int(10) unsigned DEFAULT NULL,
  `perkara_id_max` int(10) unsigned DEFAULT NULL,
  `perkara_id_referensi` char(50) DEFAULT NULL,
  `user_cek` tinyint(1) unsigned NOT NULL DEFAULT 0 COMMENT '3 = user perkara sj, 2 = user grup dan user perkara tanpa user grup,  1= user grup dan user perkara',
  `user_grup_id` char(50) DEFAULT NULL,
  `user_top_id` char(50) DEFAULT NULL,
  `user_validator` char(50) DEFAULT NULL,
  `modified` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `direktori_parent_direktori` (`direktori`,`parent_direktori`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `abt_menu` */

insert  into `abt_menu`(`id`,`nama`,`nama_alias`,`direktori`,`parent_direktori`,`proses_id_min`,`proses_id_max`,`perkara_id_min`,`perkara_id_max`,`perkara_id_referensi`,`user_cek`,`user_grup_id`,`user_top_id`,`user_validator`,`modified`) values 
(1,'Blangko Gugatan & Permohonan','Gugatan & Permohonan','1_gugatan_permohonan','_blangko_abt',0,10,NULL,NULL,NULL,1,'30|500|430|1000|1010|1020|1032|1001|1011','1',NULL,'2019-08-10 15:46:54'),
(2,'Penetapan Majelis Hakim (PMH) & Penetapan Hakim Tunggal (PHT)','PMH & PHT','A.1 PMH - PHT','2_formulir_kepaniteraan',20,200,15,16,'alur_perkara_id',3,'440|500|30|1000|430|1020|1030|1010|420','1|10',NULL,'2019-08-08 09:05:08'),
(3,'Penunjukan Panitera / Panitera Pengganti','Penunjukan PP','A.2 Penunjukan PP','2_formulir_kepaniteraan',30,200,15,16,'alur_perkara_id',3,'440|500|30|1000|430|1020|1030|1010|420','1|30',NULL,'2019-08-08 09:05:32'),
(4,'Penunjukan Jurusita / Jurusita Pengganti','Penunjukan Jurusita/JSP','A.3 Penunjukan JS-JSP','2_formulir_kepaniteraan',40,200,15,16,'alur_perkara_id',3,'440|500|30|1000|430|1020|1030|1010|420','1|30',NULL,'2019-08-08 09:05:49'),
(5,'Penetapan Hari Sidang (PHS)','P H S','A.4 Penetapan Hari Sidang (PHS)','2_formulir_kepaniteraan',80,200,15,16,'alur_perkara_id',3,'440|500|20|30|1000|430|1020|1030|1010|420','1|10',NULL,'2019-08-08 09:07:04'),
(6,'Relaas Panggilan','Relaas Panggilan','A.5 Relaas Panggilan','2_formulir_kepaniteraan',80,200,15,16,'alur_perkara_id',3,'600|650','1|10|30',NULL,'2019-08-08 09:10:07'),
(7,'Surat Kuasa Insidentil','Kuasa Insidentil','A.6 Kuasa Insidentil','2_formulir_kepaniteraan',10,200,15,16,'alur_perkara_id',3,'500|430|1000|1010|1020','1|10|30',NULL,'2019-08-08 09:17:05'),
(8,'Formulir Permohonan Banding','Permohonan Banding','B. Formulir Permohonan Banding','2_formulir_kepaniteraan',300,400,15,16,'alur_perkara_id',2,'30|430|500|600|1000|1010','1|10|30',NULL,'2019-08-08 09:17:40'),
(9,'Formulir Permohonan Kasasi','Permohonan Kasasi','C. Formulir Permohonan Kasasi','2_formulir_kepaniteraan',410,500,15,16,'alur_perkara_id',2,'30|430|500|600|1000|1010','1|10|30',NULL,'2019-08-08 09:17:42'),
(10,'Formulir Permohonan Peninjauan Kembali','Permohonan PK','D. Formulir Permohonan PK','2_formulir_kepaniteraan',510,590,15,16,'alur_perkara_id',2,'30|430|500|600|1000|1010','1|10|30',NULL,'2019-08-08 09:18:05'),
(11,'Formulir Konsinyasi','Formulir Konsinyasi','F. Formulir Konsinyasi','2_formulir_kepaniteraan',0,1000,15,16,'alur_perkara_id',2,'30|430|500|600|1000|1010','1|10|30',NULL,'2019-08-08 09:18:07'),
(12,'Formulir Titipan','Formulir Titipan','G. Formulir Titipan','2_formulir_kepaniteraan',0,1000,15,16,'alur_perkara_id',2,'30|430|500|600|1000|1010','1|10|30',NULL,'2019-08-08 09:18:14'),
(13,'Formulir Kepaniteraan Lainnya','Lain-Lain','H. Lain-lain','2_formulir_kepaniteraan',0,1000,15,16,'alur_perkara_id',0,NULL,NULL,NULL,'2019-08-04 07:00:26'),
(14,'Penetapan & Penunjukan','Penetapan & Penunjukan','1 Penetapan & Penunjukan','3_formulir_jinayat',20,210,122,123,'alur_perkara_id',1,'440|500|30|1000|430|1020|1030|1010|420','1|10|30',NULL,'2019-08-08 09:19:08'),
(15,'Formulir Permohonan Banding','Permohonan Banding','2 Permohonan Banding','3_formulir_jinayat',300,400,122,123,'alur_perkara_id',0,'440|500|30|1000|430|1020|1030|1010|420','1|10|30',NULL,'2019-08-08 09:19:09'),
(16,'Formulir Permohonan Kasasi','Permohonan Kasasi','3 Permohonan Kasasi','3_formulir_jinayat',410,500,122,123,'alur_perkara_id',0,'440|500|30|1000|430|1020|1030|1010|420','1|10|30',NULL,'2019-08-08 09:19:13'),
(17,'Formulir Permohonan Peninjauan Kembali','Permohonan PK','4 Permohonan Peninjauan Kembali','3_formulir_jinayat',510,590,122,123,'alur_perkara_id',0,'440|500|30|1000|430|1020|1030|1010|420','1|10|30',NULL,'2019-08-08 09:19:14'),
(18,'Berita Acara Sidang','Berita Acara Sidang','4_berita_acara_sidang','_blangko_abt',80,220,NULL,NULL,NULL,3,'500|430|1000|1010|1020','1|10|30','10|20','2019-08-08 09:09:08'),
(19,'Mediasi','Mediasi','5_mediasi','_blangko_abt',120,220,15,15,'alur_perkara_id',1,'20|30|500|430|1000|1010|1020','1|10',NULL,'2019-08-22 15:11:52'),
(20,'Putusan dan Penetapan','Putusan & Penetapan','6_putusan_penetapan','_blangko_abt',80,220,NULL,NULL,NULL,3,'20','1|10',NULL,'2019-08-08 09:09:25'),
(21,'Blangko Ikrar Talak','Blangko Ikrar Talak','7_ikrar_talak','_blangko_abt',80,295,346,346,'jenis_perkara_id',2,'10|30|500|430|1000|1010|1020','1|10|30',NULL,'2019-08-08 09:09:46'),
(22,'Blangko e-Court','Blangko e-Court','8_e-court','_blangko_abt',0,1000,NULL,NULL,NULL,3,'500|430|600|650|1000|1010|1020','1|10|30',NULL,'2019-08-08 09:20:18'),
(23,'Blangko-Blangko Lainnya','Lain-lain','9_blangko_lainnya','_blangko_abt',0,1000,NULL,NULL,NULL,0,NULL,NULL,NULL,'2019-08-08 09:21:43');

/*Table structure for table `abt_menu_grup` */

DROP TABLE IF EXISTS `abt_menu_grup`;

CREATE TABLE `abt_menu_grup` (
  `id` int(4) unsigned NOT NULL,
  `nama` varchar(200) NOT NULL,
  `direktori` varchar(500) NOT NULL,
  `sub_menu` char(1) NOT NULL,
  `ms_only` tinyint(1) NOT NULL,
  `modified` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `direktori` (`direktori`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `abt_menu_grup` */

insert  into `abt_menu_grup`(`id`,`nama`,`direktori`,`sub_menu`,`ms_only`,`modified`) values 
(1,'Gugatan & Permohonan','1_gugatan_permohonan','T',0,'2019-08-05 12:41:20'),
(2,'Blangko Standar Kepaniteraan','2_formulir_kepaniteraan','Y',0,'2019-05-07 11:40:12'),
(3,'Blangko Standar Jinayat','3_formulir_jinayat','Y',1,'2019-05-07 12:27:26'),
(4,'Berita Acara Sidang','4_berita_acara_sidang','T',0,'2019-05-07 15:33:09'),
(5,'Mediasi','5_mediasi','T',0,'2019-05-15 11:00:26'),
(6,'Putusan & Penetapan','6_putusan_penetapan','T',0,'2019-05-15 11:00:32'),
(7,'Ikrar Talak','7_ikrar_talak','T',0,'2019-05-15 11:00:34'),
(8,'Blangko E-court','8_e-court','T',0,'2019-07-08 09:06:48'),
(9,'Blangko Lainnya','9_blangko_lainnya','T',0,'2019-07-08 09:06:20');

/*Table structure for table `abt_tanyajawab_id` */

DROP TABLE IF EXISTS `abt_tanyajawab_id`;

CREATE TABLE `abt_tanyajawab_id` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `jenis_perkara_id` int(10) DEFAULT NULL,
  `kode` char(5) DEFAULT NULL,
  `nama` varchar(100) DEFAULT NULL,
  `modifier` varchar(30) DEFAULT NULL,
  `modified` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `kode_jenis_perkara_id` (`kode`,`jenis_perkara_id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=latin1;

/*Data for the table `abt_tanyajawab_id` */

insert  into `abt_tanyajawab_id`(`id`,`jenis_perkara_id`,`kode`,`nama`,`modifier`,`modified`) values 
(1,360,'IN2','Pertanyaan Saksi IN 2P',NULL,'2018-03-25 17:14:37'),
(2,362,'DK2','Pertanyaan Saksi DK 2P',NULL,'2018-03-25 16:01:04'),
(3,347,'A1','Pertanyaan Saksi P CG',NULL,'2018-03-25 15:26:02'),
(4,346,'A1','Pertanyaan Saksi P CT',NULL,'2018-03-25 15:26:08'),
(5,347,'A2','Pertanyaan Saksi T CG',NULL,'2018-08-01 13:37:45'),
(6,346,'A2','Pertanyaan Saksi T CT',NULL,'2018-03-25 15:25:38'),
(7,369,'PB1','Pertanyaan Saksi Perubahan Biodata 1P',NULL,'2018-03-27 10:41:47'),
(8,363,'WA','Pertanyaan Saksi WA',NULL,'2018-03-25 17:14:52'),
(9,352,'PA','Pertanyaan Saksi Pengangkatan Anak',NULL,'2018-03-25 15:50:41'),
(10,362,'DK1','Pertanyaan Saksi DK 1P',NULL,'2018-03-25 16:05:10'),
(11,360,'IN1','Pertanyaan Saksi IN 1P',NULL,'2018-03-25 17:14:31'),
(12,371,'PAW','Pertanyaan Saksi PAW',NULL,'2018-03-25 16:19:29'),
(13,346,'01','Jawaban Lisan T',NULL,'2018-03-26 14:49:39'),
(14,347,'01','Jawaban Lisan T',NULL,'2018-03-26 14:49:49'),
(15,346,'02','Replik Lisan P',NULL,'2018-03-26 14:50:56'),
(16,347,'02','Replik Lisan P',NULL,'2018-03-26 14:51:02'),
(17,346,'03','Duplik Lisan T',NULL,'2018-03-26 14:51:10'),
(18,347,'03','Duplik Lisan T',NULL,'2018-03-26 14:51:16'),
(19,369,'PB2','Pertanyaan Saksi Perubahan Biodata 2P',NULL,'2018-03-27 10:41:54'),
(20,341,'IP','Pertanyaan Saksi Izin Poligami',NULL,'2018-04-05 15:30:26'),
(21,347,'A3','Pertanyaan Saksi P CG+IN',NULL,'2018-08-02 10:02:23'),
(22,346,'A3','Pertanyaan Saksi P CT+IN',NULL,'2018-08-02 10:59:59'),
(23,360,'IN3','Tanya Jawab Saksi IN 2P - Sidkel',NULL,'2019-07-27 14:27:59');

/*Table structure for table `abt_tanyajawab_template` */

DROP TABLE IF EXISTS `abt_tanyajawab_template`;

CREATE TABLE `abt_tanyajawab_template` (
  `kode_tanyajawab` char(5) NOT NULL,
  `urutan_pertanyaan` int(5) DEFAULT NULL,
  `pertanyaan` text DEFAULT NULL,
  `jawaban` text DEFAULT NULL,
  `modifier` varchar(30) DEFAULT NULL,
  `modified` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  UNIQUE KEY `id_tanyajawab_urutan_pertanyaan` (`kode_tanyajawab`,`urutan_pertanyaan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `abt_tanyajawab_template` */

insert  into `abt_tanyajawab_template`(`kode_tanyajawab`,`urutan_pertanyaan`,`pertanyaan`,`jawaban`,`modifier`,`modified`) values 
('IN',1,'Apakah Saudara mengenal #0046# I dan #0046# II?','Ya, saya mengenal #0046# I dan #0046# II;',NULL,'2018-03-25 12:47:04'),
('IN',2,'Ada hubungan keluarga apa Saudara dengan #0046# I dan #0046# II?','Saya adalah ........... #0046# ...; <br>Saya tidak punya hubungan keluarga dengan #0046# I dan Pemohon II, saya hanya bertetangga;',NULL,'2018-03-25 12:47:04'),
('03',1,'Kepada #0047#:','',NULL,'2018-03-26 14:56:13'),
('03',2,'Apakah Saudara mengerti maksud replik #0046#?','Ya, saya sudah mengerti;',NULL,'2018-03-26 14:56:13'),
('03',3,'Apakah Saudara sudah siap mengajukan duplik pada hari ini?','Ya, siap;',NULL,'2018-03-26 14:56:13'),
('03',4,'Apakah Saudara akan menyampaikan duplik secara lisan atau tertulis?','Saya akan mengajukan duplik secara lisan;',NULL,'2018-03-26 14:56:13'),
('03',5,'Apakah ....? (pertanyaan mengacu pada dalil #0053#','...',NULL,'2018-03-26 14:56:13'),
('03',6,'Apakah ....? dst','...',NULL,'2018-03-26 14:56:13'),
('PA',1,'Kepada Saksi;','',NULL,'2018-03-26 17:22:24'),
('PA',2,'Apakah Saudara kenal dengan Pemohon ?','Ya, saya mengenal Pemohon sejak lama.',NULL,'2018-03-26 17:22:24'),
('PA',3,'Apakah Saudara  mengetahui maksud Pemohon datang ke Pengadilan ini ?','Ya, Pemohon bermaksud meminta penetapan perwalian anak.',NULL,'2018-03-26 17:22:24'),
('PA',4,'Berapa orang anak yang mau dimintakan penetapan perwalian oleh Pemohon ?','Yang mau dimintakan penetapan perwalian oleh Pemohon adalah 1 orang anak.',NULL,'2018-03-26 17:22:24'),
('PA',5,'Apakah Saudara mengetahui nama dan umur anak tersebut ?','Ya, namanya #0007#.',NULL,'2018-03-26 17:22:24'),
('PA',6,'Siapakah orang tua kandung anak tersebut ?','Anak tersebut adalah anak #0046# dengan #1029#.',NULL,'2018-03-26 17:22:24'),
('PA',7,'Apakah suami/istri Pemohon tersebut telah meninggal dunia ?','Ya, suami/istri Pemohon tersebut telah meninggal dunia pada tanggal #1230#.',NULL,'2018-03-26 17:22:24'),
('PA',8,'Dimana suami/istri Pemohon tersebut meninggal dunia dan apa sebab ia meninggal ?','di #1509# karena #1245#.',NULL,'2018-03-26 17:22:24'),
('PA',9,'Dalam pengasuhan siapa anak tersebut setelah suami/istri Pemohon meninggal dunia ?','Setelah suami/istri #0046# meninggal dunia, anak tersebut berada di bawah pengasuhan #0046#.',NULL,'2018-03-26 17:22:24'),
('PA',10,'Apakah selama dalam pengasuhan Pemohon anak tersebut terurus dengan baik ?','Ya, selama dalam pengasuhan Pemohon anak tersebut tetap terurus dengan baik.',NULL,'2018-03-26 17:22:24'),
('PA',11,'Apakah Saudara pernah mendengar adanya tindak kekerasan atas anak tersebut selama dalam pengasuhan &lt;&lt;0046 ?','Tidak, saya tidak pernah mendengar adanya tindak kekerasan atas anak tersebut selama dalam pengasuhan #0046#.',NULL,'2018-03-26 17:22:24'),
('PA',12,'Apakah Saudara mengetahui untuk keperluan apa Pemohon mengajukan permohonan perwalian ?','Ya,  tujuan #0046# mengajukan permohonan perwalian adalah untuk #8171#.',NULL,'2018-03-26 17:22:24'),
('PA',13,'Apakah masih ada yang ingin Saudara sampaikan ?','Sudah cukup.',NULL,'2018-03-26 17:22:24'),
('PAW',1,'Kepada Saksi;','',NULL,'2018-04-05 19:22:17'),
('PAW',2,'Apakah Saudara mengenal #4046#?','Ya, saya mengenal #4046# sejak lama;',NULL,'2018-04-05 19:22:17'),
('PAW',3,'Ada hubungan keluarga apa Saudara dengan para Pemohon?','Saya adalah ….. Pemohon ...;',NULL,'2018-04-05 19:22:17'),
('PAW',4,'Apakah Saudara  mengetahui maksud para Pemohon datang ke Pengadilan ini?','Ya, para Pemohon bermaksud meminta penetapan ahli waris;',NULL,'2018-04-05 19:22:17'),
('PAW',5,'Adakah seseorang yang meninggal dunia?','Ya, telah meninggal dunia #1025# pada tanggal #1246#;',NULL,'2018-04-05 19:22:17'),
('PAW',6,'Dimana #1025# meninggal dunia dan apa sebab ia meninggal?','#1025# meninggal dunia di #1509# karena #1247#;',NULL,'2018-04-05 19:22:17'),
('PAW',7,'Apakah ada unsur penganiayaan sehingga #2026# meninggal dunia?','Tidak, #1025# meninggal dunia murni karena #1247# dan tidak ada unsur penganiayan;',NULL,'2018-04-05 19:22:17'),
('PAW',8,'Apakah ayah kandung dan ibu kandung #2026# masih hidup?','Tidak, ayah kandung dan ibu kandung #2026# telah lebih dahulu meninggal dunia; <br>Ayah kandung #2026# ... sedangkan ibu kandung #2026# ...; <br>Ayah kandung dan ibu kandung #2026# keduanya masih hidup;',NULL,'2018-04-05 19:22:17'),
('PAW',9,'Apakah kakek kandung dan nenek kandung #2026# masih hidup?','Tidak, kakek kandung dan nenek kandung #2026# telah lebih dahulu meninggal dunia;<br>Kakek kandung #2026# ... sedangkan nenek kandung #2026# ...; <br>Kakek kandung dan nenek kandung #2026# semua masih hidup;',NULL,'2018-04-05 19:22:17'),
('PAW',10,'Jadi, siapa-siapa ahli waris yang ditinggalkan #2026#?','#2026# meninggalkan seorang istri yaitu Pemohon I dan empat orang anak kandung yaitu Pemohon II sampai dengan Pemohon V; <br>#2026# hanya meninggalkan ....;',NULL,'2018-04-05 19:22:17'),
('PAW',11,'Apa\n  tujuan #4046# mengajukan permohonan penetapan ahli\n  waris?\n  \n \n\n\n','#4046# mengajukan penetapan ahli waris dimaksudkan untuk menentukan ahli waris yang sah dari #2026# #2026# serta keperluan lainnya',NULL,'2018-04-05 19:22:17'),
('PAW',12,'Apakah masih ada yang ingin Saudara sampaikan?','Sudah cukup;',NULL,'2018-04-05 19:22:17'),
('02',1,'Kepada #0046#:','',NULL,'2018-04-12 16:25:42'),
('02',2,'Apakah Saudara mengerti maksud jawaban #0047#?','Ya, saya sudah mengerti maksud jawaban #0047#;',NULL,'2018-04-12 16:25:42'),
('02',3,'Apakah Saudara sudah siap menyampaikan replik pada hari ini?','Ya, saya siap menyampaikan replik pada hari ini;',NULL,'2018-04-12 16:25:42'),
('02',4,'Apakah Saudara akan menyampaikan replik secara lisan atau tertulis?','Saya akan menyampaikan replik secara lisan;',NULL,'2018-04-12 16:25:42'),
('02',5,'Apakah ............ (pertanyaan mengacu pada jawaban #0047#)','...',NULL,'2018-04-12 16:25:42'),
('02',6,'Apakah ...? dst','...',NULL,'2018-04-12 16:25:42'),
('01',1,'Kepada #0047#:','',NULL,'2018-04-13 07:57:48'),
('01',2,'Apakah Saudara sudah mengerti maksud #0053# #0046#?','Ya, saya sudah mengerti maksud #0053# #0046#;',NULL,'2018-04-13 07:57:48'),
('01',3,'Apakah Saudara sudah siap mengajukan jawaban pada hari ini?','Ya, saya siap mengajukan jawaban pada hari ini;',NULL,'2018-04-13 07:57:48'),
('01',4,'Apakah Saudara akan menyampaikan jawaban secara lisan atau tertulis?','Saya akan menjawab secara lisan;',NULL,'2018-04-13 07:57:48'),
('01',5,'Apakah ....? (pertanyaan mengacu pada dalil #0053#','...',NULL,'2018-04-13 07:57:48'),
('01',6,'Apakah ....? dst','...',NULL,'2018-04-13 07:57:48'),
('01',7,'...','Saya juga bermaksud mengajukan gugat balik yaitu:1.',NULL,'2018-04-13 07:57:48'),
('IN1',1,'Apakah Saudara mengenal #0046#?','Saya mengenal #0046#;',NULL,'2018-05-28 13:13:39'),
('IN1',2,'Ada hubungan keluarga apa Saudara dengan Pemohon?','Saya adalah ........... Pemohon; Saya tidak punya hubungan keluarga dengan Pemohon, saya hanya bertetangga;',NULL,'2018-05-28 13:13:39'),
('IN1',3,'Apakah Saudara mengetahui maksud #0046# menghadap di persidangan ini?','#0046# menghadap di persidangan ini untuk mengesahkan pernikahannya;',NULL,'2018-05-28 13:13:39'),
('IN1',4,'Apakah Saudara mengetahui pernikahan #0046#?','Saya mengetahui #0046# telah menikah dengan seorang bernama #1025#?',NULL,'2018-05-28 13:13:39'),
('IN1',5,'Apakah Saudara hadir sewaktu #0046# dengan #1025# menikah?','Saya hadir sewaktu #0046# dengan #1025# menikah; <br>Tidak, saya tidak hadir sewaktu #0046# dengan #10259# menikah, namun saya mendapat informasi dari orang-orang yang hadir;',NULL,'2018-05-28 13:13:39'),
('IN1',6,'Kapan #0046# dengan #1025# menikah?','Kalau tidak salah #0046# dengan #1025# menikah pada #5197#;',NULL,'2018-05-28 13:13:39'),
('IN1',7,'Dimana #0046# dengan #1025# menikah?','#0046# dengan #1025# menikah di #5105#;',NULL,'2018-05-28 13:13:39'),
('IN1',8,'Siapa yang menjadi wali nikah #0046#/#1025# pada pernikahan tersebut?','Yang menjadi wali nikah #0046#/#1025# pada pernikahan tersebut adalah #1046# #0046#/#1025# bernama #1217##1357#;',NULL,'2018-05-28 13:13:39'),
('IN1',9,'Siapa yang menikahkan #0046# dengan #1025#?','Yang menikahkan #0046# dengan #1025# adalah #8087# yang bernama #9023#;',NULL,'2018-05-28 13:13:39'),
('IN1',10,'Apa mahar yang diberikan #0046# kepada #1025#? Apa mahar yang diberikan #1025# kepada #0046#?','Mahar yang diberikan #1025# kepada #0046# pada waktu itu berupa #1001#; <br>Mahar yang diberikan #0046# kepada #1025# pada waktu itu berupa #1001#;',NULL,'2018-05-28 13:13:39'),
('IN1',11,'Siapakah yang menjadi saksi nikah pada saat terjadinya ijab kabul antara #8087# dan #1025#/#0046#?','Yang menjadi saksi nikah pada saat terjadinya ijab kabul adalah #0650# dan #0651#;<br>Yang menjadi saksi nikah pada saat terjadinya ijab kabul adalah saya sendiri dengan #0650# / #0651#;',NULL,'2018-05-28 13:13:39'),
('IN1',12,'Apa status #0046# dan #1025# saat menikah?','Pada saat menikah #1025# berstatus #1002# dan #0046# berstatus #1003#; Pada saat menikah #0046# berstatus #1002# dan #1025# berstatus #1003#;',NULL,'2018-05-28 13:13:39'),
('IN1',13,'Apakah antara #0046# dan #1025# ada hubungan darah, semenda atau sesusuan yang menyebabkan terhalang untuk menikah?','#0046# dan #1025# tidak ada hubungan darah, semenda atau sesusuan yang menyebabkan keduanya tidak boleh menikah;',NULL,'2018-05-28 13:13:39'),
('IN1',14,'Pernahkah Saudara mendengar ada pihak lain yang keberatan atas pernikahan #0046# dengan #1025#?','Saya tidak pernah mendengar ada pihak lain yang keberatan atas pernikahan #0046# dengan #1025#;',NULL,'2018-05-28 13:13:39'),
('IN1',15,'Apakah #0046# dengan #1025# pernah bercerai?','#0046# dengan #1025# tidak pernah bercerai, keduanya hidup rukun hingga #1025# meninggal dunia pada tanggal #1230##1246# di #1509# karena #1245##1247#;',NULL,'2018-05-28 13:13:39'),
('IN1',16,'Apakah dari pernikahan tersebut #0046# dengan #2026# #1025# telah dikaruniai anak?','Dari pernikahan tersebut #0046# dengan #2026# #1025# #9003#;',NULL,'2018-05-28 13:13:39'),
('IN1',17,'Apa maksud #0046# mengajukan permohonan itsbat nikah?','Itsbat nikah para Pemohon dimaksudkan untuk #8171#;',NULL,'2018-05-28 13:13:39'),
('IN1',18,'Apakah masih ada yang ingin Saudara sampaikan ?','Sudah cukup;',NULL,'2018-05-28 13:13:39'),
('IN2',1,'Apakah Saudara mengenal #0046# I dan #0046# II ?','Ya, saya mengenal #4046#;',NULL,'2018-05-28 13:13:53'),
('IN2',2,'Ada hubungan keluarga apa Saudara dengan Pemohon I dan Pemohon II?','Saya adalah ........... Pemohon ...; <br>\nSaya tidak punya hubungan keluarga dengan Pemohon I dan Pemohon II, saya hanya bertetangga;',NULL,'2018-05-28 13:13:53'),
('IN2',3,'Apakah Saudara mengetahui maksud Pemohon I dan Pemohon II menghadap di persidangan ini?','Ya, #0046# I dan #0046# II menghadap di persidangan ini untuk mengesahkan pernikahannya;',NULL,'2018-05-28 13:13:53'),
('IN2',4,'Apakah Saudara hadir sewaktu Pemohon I dengan Pemohon II menikah?','Ya, saya hadir sewaktu #0046# I dengan #0046# II menikah;<br>\nTidak, saya tidak hadir sewaktu #0046# I dengan #0046# II menikah, namun saya mendapat informasi dari orang-orang yang hadir;',NULL,'2018-05-28 13:13:53'),
('IN2',5,'Dimana Pemohon I dengan Pemohon II menikah?','Pemohon I dengan Pemohon II menikah di #5105#, pada tanggal #5197#;',NULL,'2018-05-28 13:13:53'),
('IN2',6,'Siapa yang bertindak sebagai wali nikah Pemohon II pada pernikahan tersebut?','Yang bertindak sebagai wali nikah  adalah #1046# #0046# II bernama #1217##1357#;',NULL,'2018-05-28 13:13:53'),
('IN2',7,'Siapa yang menikahkan Pemohon I dengan Pemohon II?','Yang menikahkan #0046# I dengan #0046# II adalah #8087# bernama #9023#;<br>\nYang menikahkan #0046# I dengan #0046# II adalah saya sendiri sebagai wali nikah;',NULL,'2018-05-28 13:13:53'),
('IN2',8,'Siapakah yang bertindak sebagai saksi nikah pada saat terjadinya ijab kabul antara #8087# dan Pemohon I?','Yang bertindak sebagai saksi nikah pada saat terjadinya ijab kabul adalah #0650# dan #0651#;<br>Yang bertindak sebagai saksi nikah pada saat terjadinya ijab kabul adalah saya sendiri dengan #0650# / #0651#;',NULL,'2018-05-28 13:13:53'),
('IN2',9,'Apa mahar yang diberikan Pemohon I kepada Pemohon II?','Mahar yang diberikan #0046# I kepada #0046# II berupa #1001#;',NULL,'2018-05-28 13:13:53'),
('IN2',10,'Apa status Pemohon I dan Pemohon II saat menikah?','Sebelum menikah #0046# I berstatus #1002# dan #0046# II berstatus #1003#;',NULL,'2018-05-28 13:13:53'),
('IN2',11,'Apakah antara Pemohon I dan Pemohon II ada hubungan darah, semenda atau sesusuan yang menyebabkan terhalang untuk menikah?','#0046# I dan #0046# II tidak ada hubungan darah, semenda atau sesusuan yang menyebabkan terhalang untuk menikah;',NULL,'2018-05-28 13:13:53'),
('IN2',12,'Pernahkah Saudara mendengar ada pihak lain yang keberatan atas pernikahan Pemohon I dengan Pemohon II?','Saya tidak pernah mendengar ada pihak lain yang keberatan atas pernikahan Pemohon I dengan Pemohon II;',NULL,'2018-05-28 13:13:53'),
('IN2',13,'Apakah Pemohon I dengan Pemohon II pernah bercerai?','Pemohon I dengan Pemohon II tidak pernah bercerai, keduanya hidup rukun sampai saat ini;',NULL,'2018-05-28 13:13:53'),
('IN2',14,'Apakah dari pernikahan tersebut Pemohon I dengan Pemohon II telah dikaruniai anak?','Dari pernikahan tersebut #0046# I dengan #0046# II #0007#;',NULL,'2018-05-28 13:13:53'),
('IN2',15,'Apa tujuan Pemohon I dan Pemohon II mengajukan permohonan itsbat nikah?','Itsbat nikah para pemohon dimaksudkan untuk  untuk #8171#;',NULL,'2018-05-28 13:13:53'),
('IN2',16,'Apakah masih ada yang ingin Saudara sampaikan?','Sudah cukup;',NULL,'2018-05-28 13:13:53'),
('DK2',1,'Apakah Saudara kenal dengan para Pemohon?','Ya, saya mengenal para Pemohon;',NULL,'2018-05-28 13:14:35'),
('DK2',2,'Ada hubungan keluarga apa Saudara dengan para Pemohon?','Saya adalah ….. Pemohon I sedangkan Pemohon II ……; <br>Saya tidak ada hubungan keluarga dengan para Pemohon hanya bertetangga;',NULL,'2018-05-28 13:14:35'),
('DK2',3,'Apakah Saudara mengetahui maksud para Pemohon datang ke Pengadilan ini?','Ya, para Pemohon datang ke Pengadilan ini untuk meminta dispensasi kawin;',NULL,'2018-05-28 13:14:35'),
('DK2',4,'Kenapa para Pemohon mau meminta dispensasi kawin?','Karena para Pemohon mau menikahkan anak Pemohon I dengan anak Pemohon II namun ditolak oleh KUA Kecamatan #1005# karena keduanya belum cukup umur;',NULL,'2018-05-28 13:14:35'),
('DK2',5,'Apakah Saudara mengenal anak Pemohon I?','Ya, saya mengenal anak Pemohon I bernama #0600#;',NULL,'2018-05-28 13:14:35'),
('DK2',6,'Berapa umur anak Pemohon I sekarang?','Anak Pemohon sekarang berumur #0601# tahun;',NULL,'2018-05-28 13:14:35'),
('DK2',7,'Apakah Saudara mengenal anak Pemohon II?','Ya, saya mengenal anak Pemohon II bernama #0606#;',NULL,'2018-05-28 13:14:35'),
('DK2',8,'Berapa umur anak Pemohon II sekarang?','Anak Pemohon II sekarang berumur #0607# tahun;',NULL,'2018-05-28 13:14:35'),
('DK2',9,'Apakah anak Pemohon I dengan anak Pemohon II sudah saling mengenal?','Ya, anak Pemohon I dengan anak Pemohon II sudah saling mengenal;',NULL,'2018-05-28 13:14:35'),
('DK2',10,'Apakah anak Pemohon I dengan anak Pemohon II sudah mempunyai kedekatan satu sama lain?','Ya, anak Pemohon I dengan anak Pemohon II #1014#;',NULL,'2018-05-28 13:14:35'),
('DK2',11,'Apakah antara anak Pemohon I dan anak Pemohon II tidak ada hubungan darah, semenda atau susuan yang menyebabkan tidak boleh menikah?','Setahu saya, antara anak Pemohon I dan anak Pemohon II tidak ada hubungan darah, semenda atau susuan yang menyebabkan tidak boleh menikah;',NULL,'2018-05-28 13:14:35'),
('DK2',12,'Apa status anak Pemohon I dan apa status anak Pemohon II?','Anak Pemohon I berstatus bujang dan anak Pemohon II berstatus gadis;',NULL,'2018-05-28 13:14:35'),
('DK2',13,'Apakah keluarga kedua belah pihak telah merestui rencana pernikahan tersebut?','Ya, keluarga kedua belah pihak telah sepakat mau menikahkan keduanya;',NULL,'2018-05-28 13:14:35'),
('DK2',14,'Apakah tidak ada pihak lain yang keberatan atas rencana pernikahan tersebut?','Ya,  tidak ada saya dengar pihak lain yang keberatan atas rencana pernikahan tersebut;',NULL,'2018-05-28 13:14:35'),
('DK2',15,'Apakah dalam kehidupan sehari-hari anak Pemohon I masih kelihatan bertingkah laku seperti anak-anak?','Tidak, anak Pemohon I sudah kelihatan bertingkah laku seperti orang dewasa;',NULL,'2018-05-28 13:14:35'),
('DK2',16,'Apakah anak Pemohon I sudah memiliki mata pencaharian?','Ya, anak Pemohon sudah memiliki mata pencaharian sebagai #0604#;',NULL,'2018-05-28 13:14:35'),
('DK2',17,'Apakah dalam kehidupan sehari-hari anak Pemohon II masih kelihatan bertingkah laku seperti anak-anak?','Tidak, anak Pemohon II sudah kelihatan bertingkah laku seperti orang dewasa;',NULL,'2018-05-28 13:14:35'),
('DK2',18,'Apakah anak Pemohon II sudah biasa mengerjakan pekerjaan ibu rumah tangga?','Ya, anak Pemohon II sudah biasa mengerjakan pekerjaan ibu rumah tangga;',NULL,'2018-05-28 13:14:35'),
('DK2',19,'Apakah masih ada yang ingin Saudara sampaikan ?','Sudah cukup.',NULL,'2018-05-28 13:14:35'),
('WA',1,'Apakah Saudara kenal dengan Pemohon ?','Ya, saya mengenal Pemohon sejak kecil;',NULL,'2018-05-28 13:15:01'),
('WA',2,'Apakah Saudara  mengetahui maksud Pemohon   mengajukan   permohonan Wali Adhal ?','Ya, Pemohon ingin melangsungkan pernikahan, namun walinya tidak mau memberikan perwalian;',NULL,'2018-05-28 13:15:01'),
('WA',3,'Apakah Saudara kenal dengan calon suami Pemohon ?','Ya, saya kenal calon suami Pemohon bernama #1029#;',NULL,'2018-05-28 13:15:01'),
('WA',4,'Berapa umur calon suami Pemohon ?','Calon suami Pemohon kira-kira berumu #1030# tahun;',NULL,'2018-05-28 13:15:01'),
('WA',5,'Apa hubungan Pemohon dengan wali Pemohon ?','Hubungan Pemohon dengan walinya adalah #1046#;',NULL,'2018-05-28 13:15:01'),
('WA',6,'Apakah ayah kandung Pemohon sudah meninggal dunia ?','Ya, Ayah kandung Pemohon sudah meninggal dunia;',NULL,'2018-05-28 13:15:01'),
('WA',7,'Apakah wali Pemohon tersebut sudah pernah dinasehati dan dimintai agar bersedia menjadi wali nikah Pemohon ?','Ya, wali Pemohon tersebut sudah pernah dinasehati dan dimintai agar bersedia menjadi wali nikah Pemohon oleh ...... namun tetap menolak menjadi wali nikah Pemohon;',NULL,'2018-05-28 13:15:01'),
('WA',8,'Apa sebabnya wali Pemohon tidak mau menjadi wali nikah dari Pemohon ?','Wali Pemohon enggang menjadi wali nikah dari Pemohon #6087#;',NULL,'2018-05-28 13:15:01'),
('WA',9,'Apakah antara Pemohon dengan calon suaminya  ada hubungan keluarga atau sesusuan yang dapat menyebabkan terhalang untuk menikah ?','Tidak, setahu saya, antara Pemohon dan #1029# tidak ada hubungan keluarga atau sesusuan yang menyebabkan terhalang untuk menikah;',NULL,'2018-05-28 13:15:01'),
('WA',10,'Apa status Pemohon dan calon suaminya saat ini ?','Pemohon berstatus #1003# sedangkan #1029# berstatus #1002#;',NULL,'2018-05-28 13:15:01'),
('WA',11,'Bagaimana  hubungan  Pemohon dengan calon suami Pemohon ?','Pemohon dengan calon suaminya sudah saling mengenal dan #1014#;',NULL,'2018-05-28 13:15:01'),
('WA',12,'Apakah masih ada yang ingin Saudara sampaikan ?','Sudah cukup;',NULL,'2018-05-28 13:15:01'),
('A2',1,'Apakah saudara kenal #0046# dan #0047# ?','Ya, saya kenal #0046# bernama #0098# sedangkan #0047# bernama #0102#;',NULL,'2018-12-18 15:38:12'),
('A2',2,'Apakah saudara mempunyai hubungan keluarga dengan #0046# dan #0047# ?','Ya, #0046# adalah ................. dan #0047# adalah .............; <br>Saya tidak ada hubungan keluarga dengan #0046# dan #0047# hanya bertetangga di kampung;',NULL,'2018-12-18 15:38:12'),
('A2',3,'Bagaimana keadaan rumah tangga #0046# dan #0047# setelah menikah ?','Setelah menikah rumah tangga #0046# dengan #0047# rukun-rukun dan bahagia bahkan telah dikaruniai ..... orang anak;',NULL,'2018-12-18 15:38:12'),
('A2',4,'Apakah #0046# dan #0047# masih rukun dan bahagia sekarang ?','Ya, #0046# dan #0047# tetap rukun dan bahagia ;',NULL,'2018-12-18 15:38:12'),
('A2',5,'Apakah saudara tahu jika #0046# dan #0047# biasa bertengkar ?','Ya, saya tahu kalau #0046# dan #0047# biasa bertengkar; <br>Tidak tahu dan saya juga tidak pernah melihat bertengkar;',NULL,'2018-12-18 15:38:12'),
('A2',6,'Apakah #0046# dan #0047# sudah berpisah tempat tinggal ?','Ya, #0046# dan #0047# sudah berpisah tempat tinggal; <br>Tidak benar karena masih sering datang bermalam;',NULL,'2018-12-18 15:38:12'),
('A2',7,'Apakah #0047# pernah memukul #0046# atau minum-minuman keras dan suka marah-marah biasa bertengkar ?','Ya terkadang memukul #0046# atau minum-minuman keras dan suka marah-marah biasa bertengkar; <br>Tidak pernah;',NULL,'2018-12-18 15:38:12'),
('A2',8,'Apakah #0046# dan #0047# pernah diupayakan untuk rukun kembali ?','Ya, #0046# dan #0047# pernah diupayakan untuk rukun kembali, namun tidak berhasil;',NULL,'2018-12-18 15:38:12'),
('A2',9,'Apakah masih ada keterangan yang saudara ingin sampaikan ?','Sudah cukup;',NULL,'2018-12-18 15:38:12'),
('A3',1,'Apakah Saudara kenal dengan #0046#?','Ya, Saya kenal;',NULL,'2018-12-18 15:38:39'),
('A3',2,'Apakah Saudara punya hubungan keluarga dengan #0046#?','Ya, #0046# adalah ..... saya;',NULL,'2018-12-18 15:38:39'),
('A3',3,'Apakah #0046# punya suami?','Ya, #0046# sudah mempunyai suami;',NULL,'2018-12-18 15:38:39'),
('A3',4,'Apakah Saudara kenal dengan suami #0046#?','Ya, saya kenal, suami #0046# bernama #0047#;',NULL,'2018-12-18 15:38:39'),
('A3',5,'Apakah Saudara punya hubungan keluarga dengan #0047#?','Tidak, saya tidak punya hubungan keluarga dengan #0047# kecuali sebagai menantu',NULL,'2018-12-18 15:38:39'),
('A3',6,'Kapan dan dimana #0046# dengan #0047# dahulu melangsungkan pernikahan ?','#0046# dengan #0047# menikah pada tanggal #5197#, di rumah saya di #5105#.',NULL,'2018-12-18 15:38:39'),
('A3',7,'Siapa yang menikahkan #0046# dengan #0047#?','#0046# dengan #0047# dinikahkan oleh #8087#, bernama #9023#;',NULL,'2018-12-18 15:38:39'),
('A3',8,'Siapa yang menjadi wali pernikahan #0046# dan #0047#?','Yang bertindak sebagai wali nikah adalah #0046# II bernama #1217#;<br>Saya sendiri sebagai ayah kandung dari #0046#;',NULL,'2018-12-18 15:38:39'),
('A3',9,'Siapa yang menjadi saudara pernikahan #0046# dengan #0047#?','Yang menjadi saya pernikahan #0046# dengan #0047# adalah #0650# dan #0651#;',NULL,'2018-12-18 15:38:39'),
('A3',10,'Apa mahar pernikahan yang diberikan #0047# kepada #0046#?','Mahar pernikahan yang diberikan #0047# kepada #0046# adalah #1001#;',NULL,'2018-12-18 15:38:39'),
('A3',11,'Apa status #0046# dengan #0047# sebelum mereka menikah?','#0046# berstatus #1002# dan saat itu yang saya tahu #0047# berstatus #1003#;',NULL,'2018-12-18 15:38:39'),
('A3',12,'Setelah menikah dimana #0046# dengan #0047# berdomisili?','Setelah menikah #0046# dengan #0047# #5126#.',NULL,'2018-12-18 15:38:39'),
('A3',13,'Bagaimana keadaan rumah tangga #0046# dengan #0047# setelah mereka menikah?','Pada dasarnya #0046# dengan #0047# tidak pernah rukun dalam membina rumah tangga meski keduanya sempat tinggal bersama;',NULL,'2018-12-18 15:38:39'),
('A3',14,'Apakah Saudara tahu apa yang menjadi penyebab ketidak rukunan rumah tangga #0046# dengan #0047#?','Yang saya tahu penyebab ketidak rukunan antara Penggugat dengan Tergugat adalah karena ...;',NULL,'2018-12-18 15:38:39'),
('A3',15,'Sudah berapa lama #0047# pergi meninggalkan #0046#?','Sudah ...;',NULL,'2018-12-18 15:38:39'),
('A3',16,'Selama #0047# pergi meninggalkan #0046# apakah #0047# pernah datang untuk menemui #0046# dan anaknya ?','.....',NULL,'2018-12-18 15:38:39'),
('A3',17,'Apakah #0047# pernah mengirim nafkah untuk #0046# dan anak #0047#?','Setahu saya tidak pernah;',NULL,'2018-12-18 15:38:39'),
('A3',18,'Selama #0046# dengan #0047# berpisah tempat tinggal apakah ada upaya Saudara atau keluarga yang lain untuk merukunkan #0046# dengan #00467#?','Tidak pernah;',NULL,'2018-12-18 15:38:39'),
('A3',19,'Menurut Saudara apakah antara #0046# dengan #0047# masih ada kemungkinan untuk dirukunkan kembali?','Saya rasa sudah sulit karena Penggugat dengan Tergugat sudah tidak saling memperdulikan selama lebih dari enam tahun;',NULL,'2018-12-18 15:38:39'),
('A3',20,'Apakah masih ada hal yang akan Saudara sampaikan?','Sudah cukup;',NULL,'2018-12-18 15:38:39'),
('DK1',1,'Apakah Saudara kenal dengan Pemohon?','Saya kenal dengan Pemohon karena saya adalah ...;',NULL,'2018-12-18 15:38:56'),
('DK1',2,'Ada hubungan keluarga apa Saudara dengan Pemohon?','Saya adalah ….. Pemohon; <br>Saya tidak ada hubungan keluarga dengan Pemohon hanya bertetangga;',NULL,'2018-12-18 15:38:56'),
('DK1',3,'Apakah Saudara mengetahui maksud Pemohon datang ke Pengadilan ini?','Ya, Pemohon datang ke Pengadilan ini untuk meminta dispensasi kawin;',NULL,'2018-12-18 15:38:56'),
('DK1',4,'Kenapa Pemohon mau meminta dispensasi kawin?','Pemohon meminta dispensasi kawin karena Pemohon mau menikahkan anaknya namun ditolak oleh KUA Kecamatan #1005# karena belum cukup umur;',NULL,'2018-12-18 15:38:56'),
('DK1',5,'Apakah Saudara mengenal anak Pemohon?','Ya, saya mengenal anak Pemohon bernama #0600#;',NULL,'2018-12-18 15:38:56'),
('DK1',6,'Berapa umur anak Pemohon sekarang?','Anak Pemohon tersebut sekarang berumur #0601# tahun;',NULL,'2018-12-18 15:38:56'),
('DK1',7,'Apakah Saudara mengenal calon isteri anak Pemohon?<br>Apakah Saudara mengenal calon suami anak Pemohon?','Ya, saya mengenal calon isteri anak Pemohon bernama #0606#; <br>Ya, saya mengenal calon anak Pemohon bernama #0600#;',NULL,'2018-12-18 15:38:56'),
('DK1',8,'Berapa umur calon isteri anak Pemohon sekarang?<br>Berapa umur calon suami anak Pemohon sekarang?','Calon isteri anak Pemohon sudah berumur #0607# tahun; <br>Calon suami anak Pemohon sudah berumur #0601# tahun;',NULL,'2018-12-18 15:38:56'),
('DK1',9,'Apakah anak Pemohon dengan calon isterinya sudah saling mengenal?<br>Apakah anak Pemohon dengan calon suaminya sudah saling mengenal?','Ya, anak Pemohon dengan calon isterinya sudah saling mengenal; <br>Ya, anak Pemohon dengan calon suaminya sudah saling mengenal;',NULL,'2018-12-18 15:38:56'),
('DK1',10,'Apakah anak Pemohon dengan calon isterinya sudah mempunyai kedekatan satu sama lain? Apakah anak Pemohon dengan calon suaminya sudah mempunyai kedekatan satu sama lain?','Ya, anak Pemohon dengan calon isterinya #1014#; <br>Ya, anak Pemohon dengan calon suaminya #1014#;',NULL,'2018-12-18 15:38:56'),
('DK1',11,'Apakah antara anak Pemohon dan calon isterinya / suaminya tidak ada hubungan darah, semenda atau susuan yang menyebabkan tidak boleh menikah?','Setahu saya, antara anak Pemohon dan calon isterinya / suaminya tidak ada hubungan darah, semenda atau susuan yang menyebabkan tidak boleh menikah;',NULL,'2018-12-18 15:38:56'),
('DK1',12,'Apa status anak Pemohon dan apa status calon isterinya?<br>Apa status anak Pemohon dan apa status calon suaminya?','Anak Pemohon berstatus bujang dan calon isterinya berstatus #1003#; <br>Anak Pemohon berstatus gadis dan calon suaminya berstatus #1002#;',NULL,'2018-12-18 15:38:56'),
('DK1',13,'Apakah keluarga kedua belah pihak telah merestui rencana pernikahan tersebut?','Ya, keluarga kedua belah pihak telah sepakat mau menikahkan keduanya;',NULL,'2018-12-18 15:38:56'),
('DK1',14,'Apakah tidak ada pihak lain yang keberatan atas rencana pernikahan tersebut?','Ya,  tidak ada saya dengar pihak lain yang keberatan atas rencana pernikahan tersebut;',NULL,'2018-12-18 15:38:56'),
('DK1',15,'Apakah dalam kehidupan sehari-hari anak Pemohon masih kelihatan bertingkah laku seperti anak-anak?','Tidak, anak Pemohon sudah kelihatan bertingkah laku seperti orang dewasa;',NULL,'2018-12-18 15:38:56'),
('DK1',16,'Apakah anak Pemohon sudah memiliki mata pencaharian?<br>Apakah anak Pemohon sudah biasa mengerjakan pekerjaan ibu rumah tangga?','Ya, anak Pemohon sudah memiliki mata pencaharian sebagai #0604#;<br>Ya, anak Pemohon sudah biasa mengerjakan pekerjaan ibu rumah tangga;',NULL,'2018-12-18 15:38:56'),
('DK1',17,'Apakah masih ada yang ingin Saudara sampaikan ?','Sudah cukup.',NULL,'2018-12-18 15:38:56'),
('IP',1,'Apakah saudara kenal dengan #0046# dan #0047#?','Saya kenal dengan #0046# dan #0047# karena saya adalah ...............................................;',NULL,'2018-12-18 15:40:31'),
('IP',2,'Apakah saudara mengetahui hubungan #0046# dan #0047#?','Saya tahu antara #0046# dan #0047# adalah suami isteri;',NULL,'2018-12-18 15:40:31'),
('IP',3,'Apakah #0046# dan #0047# sudah dikarunia anak?','#0046# dan #0047# sudah/belum dikaruniai ...... (........) orang anak;',NULL,'2018-12-18 15:40:31'),
('IP',4,'Bagaimana keadaan rumah tangga #0046# dan #0047# selama ini?','Kehidupan rumah tangga #0046# dan #0047# selama ini berjalan baik dan rukun;',NULL,'2018-12-18 15:40:31'),
('IP',5,'Apakah saudara mengetahui maksud #0046# datang ke pengadilan?','#0046# ke Pengadilan mengurus izin poligami karena #0046# mau menikah lagi dengan perempuan lain yang bernama....................',NULL,'2018-12-18 15:40:31'),
('IP',6,'Apakah saudara kenal dengan calon istri kedua #0046#?','Saya kenal dengan calon istri kedua #0046# .................................................................;',NULL,'2018-12-18 15:40:31'),
('IP',7,'Apakah saudara mengetahui status calon istri kedua #0046#?','Saya mengetahui calon istri kedua #0046# adalah gadis/janda;',NULL,'2018-12-18 15:40:31'),
('IP',8,'Apakah antara #0046#, calon istri kedua #0046# dan #0047# ada hubungan keluarga?','Antara #0046#, calon istri kedua #0046# dan #0047# tidak ada hubungan keluarga, bukan saudara dan bukan sesusuan;',NULL,'2018-12-18 15:40:31'),
('IP',9,'Apakah saudara mengetahui pekerjaan #0046#?','#0046# bekerja sebagai...................................................;',NULL,'2018-12-18 15:40:31'),
('IP',10,'Apakah saudara mengetahui penghasilan #0046# dari pekerjaannya tersebut?','SAya mengetahui/tidak mengetahui penghasilan #0046# setiap bulannya sebesar Rp. ................................;',NULL,'2018-12-18 15:40:31'),
('IP',11,'Apakah #0047# keberatan atas keinginan #0046# untuk menikah lagi?','Yang saya ketahui #0047# tidak keberatan atas keinginan #0046# untuk menikah lagi;',NULL,'2018-12-18 15:40:31'),
('IP',12,'Apakah saudara mengetahui alasan #0046# mau berpoligami?','Saya mengetahui alasan #0046# berpoligami karena: <br>- #0047# tidak mampu lagi menjalankan kewajibannya sebagai seorang istri secara maksimal melayani kebutuhan #0046#; <br>- #0047# cacat badan dan sakit yang susah untuk disemmbuhkan; <br>- #0047# tidak dapat melahirkan keturunan',NULL,'2018-12-18 15:40:31'),
('IP',13,'Apakah saudara mengetahui apa saja harta bersama #0046# dan #0047# sampai saat ini?','Yang saya ketahui #0046# dan #0047# mempunyai harta bersama berupa: ................................................... ..............................................................................',NULL,'2018-12-18 15:40:31'),
('PB1',1,'Apakah Saudara mengenal #0046#?','Ya, saya mengenal #0046#;',NULL,'2018-12-18 15:41:01'),
('PB1',2,'Apakah Saudara ada hubungan keluarga dengan Pemohon?','Ya, saya ada hubungan keluarga dengan Pemohon yaitu ...;',NULL,'2018-12-18 15:41:01'),
('PB1',3,'Apakah Saudara mengetahui maksud #0046# menghadap di persidangan ini?','Ya, #0046# menghadap di persidangan ini untuk merubah data pada buku nikahnya;',NULL,'2018-12-18 15:41:01'),
('PB1',4,'Apakah Saudara mengetahui pernikahan #0046# dengan #1025#?','Ya, saya mengetahui pernikahan #0046# dengan #1025#;',NULL,'2018-12-18 15:41:01'),
('PB1',5,'Apakah Saudara mengetahui\nKantor Urusan Agama yang telah menerbitkan buku nikah bagi pernikahan Pemohon\ndengan #1025# tersebut?','\n\nYa, Kantor Urusan Agama yang\ntelah menerbitkan buku nikah bagi pernikahan Pemohon dengan #1025#\nadalah #5178#;',NULL,'2018-12-18 15:41:01'),
('PB1',6,'Apakah Saudara mengetahui data yang perlu dirubah\ndalam buku nikah Pemohon dan #1025# tersebut?','Setahu saya, data yang perlu dirubah dalam buku\nnikah tersebut adalah<br>#6220#',NULL,'2018-12-18 15:41:01'),
('PB1',7,'Digunakan untuk apa perubahan\ndata pada buku nikah Pemohon?','Perubahan\ndata pada buku nikah Pemohon adalah untuk #8171#',NULL,'2018-12-18 15:41:01'),
('PB1',8,'Apa tujuan #0046# mengajukan permohonan perubahan data tersebut?','#4046# mengajukan permohonan perubahan data\ntersebut adalah untuk menjadi dasar memperbaiki data dalam Buku Kutipan Akta\nNikah tersebut dan selanjutnya perbaikan tersebut dapat dicatatkan pada #5180#;',NULL,'2018-12-18 15:41:01'),
('PB1',9,'Apakah masih ada yang ingin Saudara sampaikan ?','Sudah cukup;',NULL,'2018-12-18 15:41:01'),
('PB2',1,'Apakah Saudara mengenal #0046# I dan #0046# II?','Ya, saya mengenal #0046# I dan #0046# I;',NULL,'2018-12-18 15:41:15'),
('PB2',2,'Apakah Saudara ada hubungan keluarga dengan #0046# I dan #0046# II?','Ya, saya ada hubungan keluarga dengan Pemohon I yaitu ..., sedangkan #0046# II yaitu;',NULL,'2018-12-18 15:41:15'),
('PB2',3,'Apakah Saudara mengetahui maksud #0046# I dan #0046# II menghadap di persidangan ini?','Ya, #0046# I dan #0046# II menghadap di persidangan ini untuk merubah data pada buku nikahnya;',NULL,'2018-12-18 15:41:15'),
('PB2',4,'Apakah Saudara mengetahui pernikahan #0046# I dengan #0046# II?','Ya, saya mengetahui pernikahan #0046# I dengan #0046# II;',NULL,'2018-12-18 15:41:15'),
('PB2',5,'Apakah Saudara mengetahui Kantor Urusan Agama yang telah menerbitkan buku nikah bagi pernikahan #0046# I dengan #0046# II tersebut?','Ya, Kantor Urusan Agama yang telah menerbitkan buku nikah bagi pernikahan #0046# I dengan #0046# II tersebut adalah Kantor Urusan Agama Kecamatan #1005#;',NULL,'2018-12-18 15:41:15'),
('PB2',6,'Apakah Saudara mengetahui data yang perlu dirubah dalam buku nikah #0046# I dan #0046# II tersebut?','Setahu saya, data yang perlu dirubah dalam buku nikah tersebut adalah #6220#;',NULL,'2018-12-18 15:41:15'),
('PB2',7,'Digunakan untuk apa perubahan data pada buku nikah Pemohon?','Perubahan data pada buku nikah #4046# adalah untuk #8171#',NULL,'2018-12-18 15:41:15'),
('PB2',8,'Apa tujuan #0046# I dan #0046# II mengajukan permohonan perubahan data tersebut?','#4046# mengajukan permohonan perubahan data\ntersebut adalah untuk menjadi dasar memperbaiki data dalam Buku Kutipan Akta\nNikah tersebut dan selanjutnya perbaikan tersebut dapat dicatatkan pada #5180#;',NULL,'2018-12-18 15:41:15'),
('PB2',9,'Apakah masih ada yang ingin Saudara sampaikan ?','Sudah cukup;',NULL,'2018-12-18 15:41:15'),
('A1',1,'Apakah\nsaudara kenal dengan #0046# dan #0047#?','Saya kenal dengan #0046# dan #0047# karena saya adalah ...;',NULL,'2018-12-18 15:41:58'),
('A1',2,'Apakah saudara tahu hubungan #0046# dan #0047#?','Saya tahu antara #0046# dan #0047# adalah suami isteri;',NULL,'2018-12-18 15:41:58'),
('A1',3,'Dimana #0046# dan #0047# bertempat tinggal setelah menikah?','Setelah\nmenikah #0046# dan #0047# bertempat tinggal di ...;',NULL,'2018-12-18 15:41:58'),
('A1',4,'Apakah\n#0046# dan #0047# sudah dikarunia anak?','#0046# dan #0047# #0007#;',NULL,'2018-12-18 15:41:58'),
('A1',5,'Bagaimana\nkeadaan rumah tangga #0046# dan #0047# setelah menikah?','Kehidupan\nrumah tangga #0046# dan #0047# pada awalnya berjalan baik dan rukun, namun sekarang ini\nrumah tangga mereka tidak harmonis lagi karena sering terjadi perselisihan dan\npertengkaran yang terus menerus;',NULL,'2018-12-18 15:41:58'),
('A1',6,'Kapan mulai\nterjadi perselisihan dan pertengkaran antara #0046# dan #0047#?','Perselisihan\ndan pertengkaran #0046# dan #0047# terjadi sejak ................................',NULL,'2018-12-18 15:41:58'),
('A1',7,'Apakah saudara tahu penyebab perselisihan dan pertengkaran #0046# dan #0047#?','\n\npenyebab perselisihan dan pertengkaran #0046# dan #0047# karena.......................................................\n\n...................................................................................;',NULL,'2018-12-18 15:41:58'),
('A1',8,'Bagaimana saudara bisa mengetahui penyebab perselisihan dan pertengkaran tersebut?','Saya mengetahui\nkarena saya (melihat/mendengar sendiri) /\n(diberitahu..................................), tentang persitiwa perselisihan\ndan pertengkaran #0046# dan #0047# tersebut;',NULL,'2018-12-18 15:41:58'),
('A1',9,'Apakah\nmasih ada penyebab lain yang mengakibatkan perselisihan dan pertengkaran antara\n#0046# dan #0047#?','\n\nSebab lainnya yang saya ketahui adalah..... .........................................................................(atau);<br>Saya tidak tahu penyebab perselisihan dan pertengkaran antara #0046# dan #0047#;',NULL,'2018-12-18 15:41:58'),
('A1',10,'Berapa kali saudara melihat #0046# dan #0047# bertengkar ?','Saya melihat #0046# dan #0047# bertengkar Kurang lebih .......... kali;',NULL,'2018-12-18 15:41:58'),
('A1',11,'Apakah saat bertengkar, #0046# memukul #0047# ?','Ya, pada saat bertengkar #0046# memukul #0047# mengunakan tangan dan juga menendang pakai kaki;',NULL,'2018-12-18 15:41:58'),
('A1',12,'Apakah ada bekas pemukulan tersebut ?','Ya, ada bekasnya di bagian ........;',NULL,'2018-12-18 15:41:58'),
('A1',13,'Berapa kali saudara melihat #0047# memukul #0046# ?',' Saya melihat #0047# memukul #0046#, cuma ....... kali;',NULL,'2018-12-18 15:41:58'),
('A1',14,'Apakah #0046# melakukan visum ke dokter ?','Ya sudah melakukan visum oleh dokter;',NULL,'2018-12-18 15:41:58'),
('A1',15,'Kapan peristiwa tersebut terjadi ?',' Peristiwa tersebut terjadi sekitar bulan / tahun .............;',NULL,'2018-12-18 15:41:58'),
('A1',16,'Sekitar berapa jauh jarak rumah Saudara dengan rumah #0046# dan #0047# ?','Jarak antara rumah saya dengan rumah #0046# dan #0047# hanya kurang lebih ..... meter;',NULL,'2018-12-18 15:41:58'),
('A1',17,'Apakah saat ini #0046# dan #0047# masih tinggal serumah ?','#0046# dan #0047# sudah pisah tempat tinggal sejak .....................sampai sekarang sudah\nberjalan ....................tahun/bulan;',NULL,'2018-12-18 15:41:58'),
('A1',18,'Siapa yang meninggalkan tempat tinggal bersama ?','Yang meninggalkan kediaman bersama adalah #0046# / #0047#;',NULL,'2018-12-18 15:41:58'),
('A1',19,'Sudah berapa lama #0046# dan #0047# berpisah tempat tinggal ?','#0046# dan #0047# berpisah tempat tinggal sudah kurang lebih ..... bulan / tahun;',NULL,'2018-12-18 15:41:58'),
('A1',20,'Dimana #0046# dan #0047# bertempat tinggal setelah keduanya berpisah ?','Saat ini #0046# tinggal bersama orang tuanya dan #0047# juga kembali ke rumah orang tuanya;',NULL,'2018-12-18 15:41:58'),
('A1',21,'Apakah #0046# dan #0047# masih sering berkomunikasi selama berpisah ?','Selama berpisah  #0046# dan #0047# Sudah tidak pernah lagi berkomunikasi ; <br>Ya, #0046# dan #0047#  masih sering berkomunikasi;',NULL,'2018-12-18 15:41:58'),
('A1',22,'Apakah #0047# masih sering juga memberikan nafkah pada #0046# sejak berpisah ?','Selama\npisah #0047# tidak pernah datang, dan tidak pernah lagi memberi nafkah untuk #0046#, dan #0047# sudah tidak memperdulikan #0046# lagi;',NULL,'2018-12-18 15:41:58'),
('A1',23,'Apakah sejak ada masalah, #0046# dan #0047# pernah diupayakan untuk rukun kembali;','Ya, pernah diusahakan oleh ...... #0046#, namun tidak berhasil karena #0046# tidak mau rukun lagi;',NULL,'2018-12-18 15:41:58'),
('A1',24,'Apakah masih ada keterangan yang saudara akan sampaikan ?','Sudah cukup;',NULL,'2018-12-18 15:41:58'),
('IN3',1,'Apakah Saudara mengenal #0046# I dan #0046# II dan mengetahui pernikahan #4046#?','Ya, saya mengenal #4046# karena saya adalah ... #0046# ... dan saya mengetahui pernikahan #4046#;',NULL,'2019-07-28 18:03:40'),
('IN3',2,'Dimana Pemohon I dengan Pemohon II menikah?','Pemohon I dengan Pemohon II menikah di #5105#, pada tanggal #5197#;',NULL,'2019-07-28 18:03:40'),
('IN3',3,'Siapa yang bertindak sebagai wali nikah Pemohon II pada pernikahan tersebut?','Yang bertindak sebagai wali nikah  adalah #1046# #0046# II bernama #1217##1357#;',NULL,'2019-07-28 18:03:40'),
('IN3',4,'Siapa yang menikahkan Pemohon I dengan Pemohon II?','Yang menikahkan #0046# I dengan #0046# II adalah #8087# bernama #9023#;<br>\nYang menikahkan #0046# I dengan #0046# II adalah saya sendiri sebagai wali nikah;',NULL,'2019-07-28 18:03:40'),
('IN3',5,'Siapakah yang bertindak sebagai saksi nikah pada saat terjadinya ijab kabul antara #8087# dan Pemohon I?','Yang bertindak sebagai saksi nikah pada saat terjadinya ijab kabul adalah #0650# dan #0651#;<br>Yang bertindak sebagai saksi nikah pada saat terjadinya ijab kabul adalah saya sendiri dengan #0650# / #0651#;',NULL,'2019-07-28 18:03:40'),
('IN3',6,'Apa mahar yang diberikan Pemohon I kepada Pemohon II?','Mahar yang diberikan #0046# I kepada #0046# II berupa #1001#;',NULL,'2019-07-28 18:03:40'),
('IN3',7,'Apa status Pemohon I dan Pemohon II saat menikah?','Sebelum menikah #0046# I berstatus #1002# dan #0046# II berstatus #1003#;',NULL,'2019-07-28 18:03:40'),
('IN3',8,'Apakah antara Pemohon I dan Pemohon II mempunyai hubungan darah atau semenda yang menyebabkan terhalang untuk menikah?','#0046# I dan #0046# II tidak mempunyai hubungan darah atau semenda yang menyebabkan terhalang untuk menikah;',NULL,'2019-07-28 18:03:40'),
('IN3',9,'Apakah antara Pemohon I dan Pemohon II mempunyai hubungan susuan yang menyebabkan terhalang untuk menikah?','#0046# I dan #0046# II juga tidak mempunyai hubungan susuan yang menyebabkan terhalang untuk menikah;',NULL,'2019-07-28 18:03:40'),
('IN3',10,'Pernahkah Saudara mendengar ada pihak lain yang keberatan atas pernikahan Pemohon I dengan Pemohon II?','Saya tidak pernah mendengar ada pihak lain yang keberatan atas pernikahan Pemohon I dengan Pemohon II;',NULL,'2019-07-28 18:03:40'),
('IN3',11,'Apakah dari pernikahan tersebut #4046# telah dikaruniai anak?','Dari pernikahan tersebut #4046# #0007#;',NULL,'2019-07-28 18:03:40'),
('IN3',12,'Apa tujuan #4046# mengajukan permohonan itsbat nikah?','Itsbat nikah #4046# dimaksudkan untuk  untuk #8171#;',NULL,'2019-07-28 18:03:40'),
('IN3',13,'Apakah masih ada yang ingin Saudara sampaikan?','Sudah cukup;',NULL,'2019-07-28 18:03:40');

/*Table structure for table `abt_temp_data_perkara` */

DROP TABLE IF EXISTS `abt_temp_data_perkara`;

CREATE TABLE `abt_temp_data_perkara` (
  `id` bigint(20) NOT NULL,
  `nomor_sementara` varchar(50) NOT NULL,
  `alur_perkara_id` int(11) DEFAULT NULL,
  `jenis_perkara_id` int(11) DEFAULT NULL,
  `jenis_perkara_nama` varchar(500) DEFAULT NULL,
  `kategori_perkara` varchar(50) DEFAULT NULL,
  `tanggal_surat` date DEFAULT NULL,
  `modifier` varchar(30) DEFAULT NULL,
  `modified` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `nomor_perkara_kategori_perkara` (`nomor_sementara`,`alur_perkara_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `abt_temp_data_perkara` */

/*Table structure for table `abt_temp_data_pihak` */

DROP TABLE IF EXISTS `abt_temp_data_pihak`;

CREATE TABLE `abt_temp_data_pihak` (
  `id` bigint(20) NOT NULL,
  `pihak_ke` tinyint(3) NOT NULL,
  `urutan` tinyint(3) NOT NULL,
  `pihak_id` bigint(20) NOT NULL,
  `modifier` varchar(30) DEFAULT NULL,
  `modified` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`,`pihak_ke`,`urutan`),
  UNIQUE KEY `id_pihak_id` (`id`,`pihak_id`),
  CONSTRAINT `FK_abt_data_temp_pihak` FOREIGN KEY (`id`) REFERENCES `abt_temp_data_perkara` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `abt_temp_data_pihak` */

/*Table structure for table `abt_temp_data_tanggal` */

DROP TABLE IF EXISTS `abt_temp_data_tanggal`;

CREATE TABLE `abt_temp_data_tanggal` (
  `id` bigint(20) NOT NULL,
  `no_var` int(4) unsigned zerofill NOT NULL,
  `data` date DEFAULT NULL,
  `modifier` varchar(30) DEFAULT NULL,
  `modified` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`no_var`,`id`),
  KEY `FK_abt_data_temp_tanggal` (`id`),
  CONSTRAINT `FK_abt_data_temp_tanggal` FOREIGN KEY (`id`) REFERENCES `abt_temp_data_perkara` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `abt_temp_data_tanggal` */

/*Table structure for table `abt_temp_data_teks` */

DROP TABLE IF EXISTS `abt_temp_data_teks`;

CREATE TABLE `abt_temp_data_teks` (
  `id` bigint(20) NOT NULL,
  `no_var` int(4) unsigned zerofill NOT NULL,
  `data` text DEFAULT NULL,
  `modifier` varchar(30) DEFAULT NULL,
  `modified` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`no_var`,`id`),
  KEY `FK_abt_data_temp_teks` (`id`),
  CONSTRAINT `FK_abt_data_temp_teks` FOREIGN KEY (`id`) REFERENCES `abt_temp_data_perkara` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `abt_temp_data_teks` */

/*Table structure for table `abt_temp_variabel` */

DROP TABLE IF EXISTS `abt_temp_variabel`;

CREATE TABLE `abt_temp_variabel` (
  `no_var` int(4) unsigned zerofill NOT NULL,
  `data` char(100) NOT NULL,
  `keterangan` char(100) DEFAULT NULL,
  `modified` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`no_var`),
  KEY `nama` (`data`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `abt_temp_variabel` */

insert  into `abt_temp_variabel`(`no_var`,`data`,`keterangan`,`modified`) values 
(0001,'nomor_sementara',NULL,'2019-08-08 20:25:33'),
(0010,'pihak_1_2_agama','Agama P2','2019-08-09 16:43:33'),
(0011,'pihak_1_1_agama','Agama P','2019-08-09 16:42:40'),
(0017,'tanggal_surat',NULL,'2019-08-08 20:26:42'),
(0020,'pihak_2_1_agama','Agama T','2019-08-09 16:40:59'),
(0021,'pihak_1_1_pendidikan','Pendidikan P','2019-08-09 16:42:47'),
(0024,'pihak_2_1_pendidikan','Pendidikan T','2019-08-09 16:41:10'),
(0046,'pihak1_ket',NULL,'2019-08-08 20:29:32'),
(0047,'pihak2_ket',NULL,'2019-08-08 20:30:34'),
(0048,'jenis_perkara_nama',NULL,'2019-08-08 20:26:10'),
(0053,'gugatan_permohonan',NULL,'2019-08-08 20:29:56'),
(0098,'pihak_1_1_nama','Nama P','2019-08-09 16:39:25'),
(0099,'pihak_1_1_umur','Umur P','2019-08-09 16:42:36'),
(0100,'pihak_1_1_pekerjaan','Pekerjaan P','2019-08-09 16:42:53'),
(0101,'pihak_1_1_alamat','Alamat P','2019-08-09 16:43:04'),
(0102,'pihak_2_1_nama','Nama T','2019-08-09 16:40:17'),
(0103,'pihak_2_1_umur','Umur T','2019-08-09 16:40:56'),
(0104,'pihak_2_1_pekerjaan','Pekerjaan T','2019-08-09 16:41:16'),
(0105,'pihak_2_1_alamat','Alamat T','2019-08-09 16:41:29'),
(0194,'putusan_penetapan',NULL,'2019-08-08 20:29:56'),
(0335,'pihak_1_1_nomor_indentitas','No. NIK P','2019-08-09 16:42:11'),
(0336,'pihak_1_2_nomor_indentitas','No. NIK P2','2019-08-09 16:43:16'),
(0337,'pihak_2_1_nomor_indentitas','No. NIK T','2019-08-09 16:40:25'),
(0341,'pihak_1_1_tempat_lahir','Tempat Lahir P','2019-08-09 16:42:27'),
(0342,'pihak_1_2_tempat_lahir','Tempat Lahir P2','2019-08-09 16:43:20'),
(0343,'pihak_2_1_tempat_lahir','Tempat Lahir T','2019-08-09 16:40:35'),
(0345,'pihak_1_1_tanggal_lahir','Tgl. Lahir P','2019-08-09 16:42:31'),
(0346,'pihak_1_2_tanggal_lahir','Tgl. Lahir P2','2019-08-09 16:43:25'),
(0347,'pihak_2_1_tanggal_lahir','Tgl. Lahir T','2019-08-09 16:40:46'),
(1033,'pihak_1_2_nama','Nama P2','2019-08-09 16:43:08'),
(1034,'pihak_1_2_umur','Umur P2','2019-08-09 16:43:28'),
(1035,'pihak_1_2_pekerjaan','Pekerjaan P2','2019-08-09 16:43:44'),
(1036,'pihak_1_2_alamat','Alamat P2','2019-08-09 16:43:45'),
(1176,'pihak_1_2_pendidikan','Pendidikan P2','2019-08-09 16:43:39');

/*Table structure for table `abt_variabel` */

DROP TABLE IF EXISTS `abt_variabel`;

CREATE TABLE `abt_variabel` (
  `no_var` int(4) unsigned zerofill NOT NULL DEFAULT 0000,
  `nama` varchar(200) NOT NULL DEFAULT '',
  `data_type` char(20) DEFAULT NULL,
  `data_tabel` varchar(100) DEFAULT NULL,
  `data_kolom` varchar(100) DEFAULT NULL,
  `urutan_data` int(2) unsigned DEFAULT NULL,
  `referensi` int(4) unsigned zerofill DEFAULT NULL,
  `sql_query` text DEFAULT NULL,
  `default_data` text DEFAULT NULL,
  `multi_sidang` char(50) DEFAULT NULL,
  `locked` tinyint(1) NOT NULL,
  `modifier` varchar(30) DEFAULT NULL,
  `modified` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`no_var`),
  KEY `nama` (`nama`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `abt_variabel` */

insert  into `abt_variabel`(`no_var`,`nama`,`data_type`,`data_tabel`,`data_kolom`,`urutan_data`,`referensi`,`sql_query`,`default_data`,`multi_sidang`,`locked`,`modifier`,`modified`) values 
(0001,'No Perkara','data_sipp','perkara','nomor_perkara',NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 19:42:12'),
(0004,'Sebab konflik',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0007,'Telah Dikarunai Anak ','data_teks',NULL,NULL,NULL,NULL,NULL,'belum dikaruniai anak.\r\n\r\ntelah dikaruniai seorang anak, bernama ...\r\n\r\ntelah dikaruniai _ orang anak, masing-masing bernama :\r\n1.   ',NULL,0,'admin','2019-08-08 02:47:08'),
(0010,'Agama #0046# II','data_sql',NULL,NULL,NULL,NULL,'select c.nama as data\r\nfrom perkara_pihak1 a\r\njoin pihak b on a.pihak_id=b.id\r\njoin agama c on b.agama_id=c.id\r\nwhere a.urutan=2 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:42:18'),
(0011,'Agama #0046#','data_sql',NULL,NULL,NULL,NULL,'select c.nama as data\r\nfrom perkara_pihak1 a\r\njoin pihak b on a.pihak_id=b.id\r\njoin agama c on b.agama_id=c.id\r\nwhere a.urutan=1 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:42:23'),
(0012,'Nama #0668#','data_sql',NULL,NULL,NULL,NULL,'select b.nama_gelar as data from perkara_hakim_pn a\r\njoin hakim_pn b on a.hakim_id=b.id\r\nwhere a.aktif=\"Y\" and a.urutan=1 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:42:39'),
(0013,'Nama Hakim Anggota 1','data_sql',NULL,NULL,NULL,NULL,'select b.nama_gelar as data from perkara_hakim_pn a\r\njoin hakim_pn b on a.hakim_id=b.id\r\nwhere a.aktif=\"Y\" and a.urutan=2 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:43:26'),
(0014,'Nama Hakim Anggota 2','data_sql',NULL,NULL,NULL,NULL,'select b.nama_gelar as data from perkara_hakim_pn a\r\njoin hakim_pn b on a.hakim_id=b.id\r\nwhere a.aktif=\"Y\" and a.urutan=3 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:43:34'),
(0015,'Nama PP','data_sql',NULL,NULL,NULL,NULL,'select panitera_nama as data\r\nfrom perkara_panitera_pn \r\nwhere aktif=\"Y\" and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:43:39'),
(0016,'Hari Tgl. #0053#','tanggal_hari',NULL,NULL,NULL,0017,NULL,NULL,NULL,1,NULL,'2019-08-08 19:43:42'),
(0017,'Tgl. Surat #0053# #0046#','data_sipp','perkara','tanggal_surat',NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-01-01 04:00:00'),
(0018,'Nama Jurusita/JSP','data_sql',NULL,NULL,NULL,NULL,'select b.nama_gelar as data\r\nfrom perkara_jurusita a\r\njoin jurusita b on a.jurusita_id =b.id\r\nwhere a.aktif=\"Y\" and a.urutan=1 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:44:04'),
(0019,'Nama Jurusita/JSP 2','data_sql',NULL,NULL,NULL,NULL,'select b.nama_gelar as data\r\nfrom perkara_jurusita a\r\njoin jurusita b on a.jurusita_id =b.id\r\nwhere a.aktif=\"Y\" and a.urutan=2 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:44:06'),
(0020,'Agama #0047#','data_sql',NULL,NULL,NULL,NULL,'select c.nama as data from perkara_pihak2 a\r\njoin pihak b on a.pihak_id=b.id\r\njoin agama c on b.agama_id=c.id\r\nwhere urutan=1 and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:44:08'),
(0021,'Pendidikan #0046#','data_sql',NULL,NULL,NULL,NULL,'select c.kode as data from perkara_pihak1 a\r\njoin pihak b on a.pihak_id=b.id\r\njoin tingkat_pendidikan c on b.pendidikan_id=c.id\r\nwhere urutan=1 and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:44:10'),
(0022,'Hari Relaas #0046#','tanggal_hari',NULL,NULL,NULL,1076,NULL,NULL,NULL,1,NULL,'2019-08-08 19:44:17'),
(0023,'Hari Relaas #0047#','tanggal_hari',NULL,NULL,NULL,1077,NULL,NULL,NULL,1,NULL,'2019-08-08 19:44:19'),
(0024,'Pendidikan #0047#','data_sql',NULL,NULL,NULL,NULL,'select c.kode as data from perkara_pihak2 a\r\njoin pihak b on a.pihak_id=b.id\r\njoin tingkat_pendidikan c on b.pendidikan_id=c.id\r\nwhere urutan=1 and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:44:23'),
(0025,'Hari Tgl Putusan','tanggal_hari',NULL,NULL,NULL,1069,NULL,NULL,NULL,1,NULL,'2019-08-08 19:44:26'),
(0028,'Hari Sidang Ikrar Talak','tanggal_hari',NULL,NULL,NULL,1182,NULL,NULL,NULL,1,NULL,'2019-08-08 19:44:29'),
(0029,'Terbilang 1086','terbilang',NULL,NULL,NULL,1085,NULL,NULL,NULL,0,NULL,'2019-08-08 19:45:19'),
(0030,'Alamat Dubes',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0031,'Kota Dubes',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0032,'Hari Sidang','multi_sidang',NULL,NULL,NULL,NULL,NULL,NULL,'hari_sidang',1,NULL,'2019-08-08 19:45:28'),
(0033,'Tgl Sidang','multi_sidang',NULL,NULL,NULL,NULL,NULL,NULL,'tanggal_sidang',1,NULL,'2019-08-08 19:45:31'),
(0034,'Hari 4 hari sebelum sidang',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0035,'Tgl 4 hari sebelum sidang',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0036,'Tgl Pengiriman Berkas Banding',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0037,'Tgl Penerimaan Kembali Berkas Banding',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0038,'Hijriyah Tgl Putusan','tanggal_hijriah',NULL,NULL,NULL,1069,NULL,NULL,NULL,1,NULL,'2019-08-08 19:45:37'),
(0039,'Tgl Permohonan Eksekusi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0040,'Tgl Aanmaning',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0041,'Agenda Sidang Sebelumnya','multi_sidang',NULL,NULL,NULL,NULL,NULL,NULL,'agenda_sblmnya',1,NULL,'2019-08-08 19:45:42'),
(0042,'Umur calon Istri (dispensasi)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0043,'Terbilang gaji calon suami',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0044,'Sidang Lanjutan Ke -',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0046,'Pemohon/ Penggugat','data_sql',NULL,NULL,NULL,NULL,'select (case when alur_perkara_id=16 or jenis_perkara_id=346 or jenis_perkara_id=341 then \"Pemohon\"\r\nwhen alur_perkara_id=122 or alur_perkara_id=123  then \"Penuntut Umum\"\r\nelse \"Penggugat\" end) as data\r\nfrom perkara where perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:45:45'),
(0047,'Termohon/ Tergugat','data_sql',NULL,NULL,NULL,NULL,'select (case when alur_perkara_id=16 or jenis_perkara_id=346 or jenis_perkara_id=341 then \"Termohon\"\r\nwhen alur_perkara_id=122 or alur_perkara_id=123  then \"Terdakwa\"\r\nelse \"Tergugat\" end) as data\r\nfrom perkara where perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:45:47'),
(0048,'Jenis Perkara','data_sipp','perkara','jenis_perkara_nama',NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 19:45:53'),
(0049,'Sidang Lanjutan Ke-',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0050,'Persidangan ke-','multi_sidang',NULL,NULL,NULL,NULL,NULL,NULL,'urutan',1,NULL,'2019-08-08 19:46:07'),
(0051,'Tgl. Sidang I','data_sipp','perkara_penetapan','sidang_pertama',NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 19:46:12'),
(0052,'Terbilang PBP',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0053,'permohonan / gugatan','data_sql',NULL,NULL,NULL,NULL,'select (case when alur_perkara_id=16 or jenis_perkara_id=346 then \"permohonan\"\r\nelse \"gugatan\" end) as data\r\nfrom perkara where perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:46:23'),
(0054,'Hari PBT Isi Putusan','tanggal_hari',NULL,NULL,NULL,1071,NULL,NULL,NULL,1,NULL,'2019-08-08 19:47:20'),
(0055,'Tgl Penetapan Mediator','data_sipp','perkara_mediator','tanggal_penetapan',NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 19:47:26'),
(0056,'Nama Mediator','data_sipp','perkara_mediasi','mediator_text',NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 19:47:28'),
(0057,'Tgl Mediasi','data_sipp','perkara_mediasi','dimulai_mediasi',NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 19:47:33'),
(0058,'Hasil Mediasi','data_sql',NULL,NULL,NULL,NULL,'select (case\r\n\r\nwhen hasil_mediasi=\"Y1\"\r\nthen \"berhasil dengan kesepatakan\"\r\n\r\nwhen hasil_mediasi=\"Y2\"\r\nthen \"berhasil dengan pencabutan\"\r\n\r\nwhen hasil_mediasi=\"S\"\r\nthen \"berhasil sebagian\"\r\n\r\nwhen hasil_mediasi=\"T\"\r\nthen \"tidak berhasil mencapai kesepakatan\"\r\n\r\nwhen hasil_mediasi=\"D\"\r\nthen \"tidak dapat dilaksanakan\"\r\n\r\nend) data\r\nfrom perkara_mediasi where perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-19 11:07:41'),
(0059,'Hari Sidang I','tanggal_hari',NULL,NULL,NULL,0051,NULL,NULL,NULL,1,NULL,'2019-08-08 19:47:58'),
(0061,'Perceraian ke-',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0062,'Identitas Para <<0046',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0063,'identitas para <<0047',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0065,'Amar Putusan','data_sipp','perkara_putusan','amar_putusan',NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 19:48:11'),
(0066,'Nomor Putusan yg dimohonkan eksekusi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0069,'Pendidikan Kuasa #0046#','data_sql',NULL,NULL,NULL,NULL,'select c.kode as data from perkara_pengacara a\r\njoin pihak b on a.pihak_id=b.id\r\njoin tingkat_pendidikan c on b.pendidikan_id=c.id\r\nwhere a.pihak_ke=1 and a.urutan=1 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:48:21'),
(0070,'Pendidikan Kuasa #0047#','data_sql',NULL,NULL,NULL,NULL,'select c.kode as data from perkara_pengacara a\r\njoin pihak b on a.pihak_id=b.id\r\njoin tingkat_pendidikan c on b.pendidikan_id=c.id\r\nwhere a.pihak_ke=2 and a.urutan=1 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:48:23'),
(0076,'Alasan Tunda Sidang Sebelumnya','multi_sidang',NULL,NULL,NULL,NULL,NULL,NULL,'alasan_sblmnya',1,NULL,'2019-08-08 19:48:28'),
(0077,'Nomor Putusan Banding',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0078,'Nomor Putusan Kasasi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0079,'Alasan Tunda','multi_sidang',NULL,NULL,NULL,NULL,NULL,NULL,'alasan_ditunda',1,NULL,'2019-08-08 19:48:37'),
(0080,'Tgl. Eksepsi #0047#','data_tanggal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-21 05:00:47'),
(0081,'pert. kepada <<0046 & <<0047',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0082,'Tgl Penerimaan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0083,'Tgl Penyerahan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0084,'Tgl Penerimaan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0085,'NIP Kasir','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-01-01 04:00:00'),
(0086,'Nama Kasir','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-01-01 04:00:00'),
(0087,'Tgl Pengiriman Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0088,'Tgl Penerimaan Kembali Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0089,'Terbilang biaya penetapan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0090,'Dihadiri oleh','multi_sidang',NULL,NULL,NULL,NULL,NULL,NULL,'dihadiri_oleh',1,NULL,'2019-08-08 19:49:01'),
(0091,'dapat mengajukan kembali',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0092,'Tgl PBT Pernyataan Banding',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0093,'Tgl Pengiriman Berkas PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0094,'Tanya-Jawab',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0095,'Tgl Penerimaan Kembali Berkas PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0096,'Tgl Putusan PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0097,'Nomor Putusan PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0098,'Nama #0046#','data_sipp','perkara_pihak1','nama',1,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 19:49:07'),
(0099,'Umur #0046#','data_sql',NULL,NULL,NULL,NULL,'select (get_umur(b.tanggal_lahir,c.tanggal_pendaftaran))as data\r\nfrom perkara_pihak1 a\r\njoin pihak b on a.pihak_id=b.id\r\njoin perkara c on a.perkara_id=c.perkara_id\r\nwhere a.urutan=1 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-09 05:57:40'),
(0100,'Pekerjaan #0046#','data_sql',NULL,NULL,NULL,NULL,'select b.pekerjaan as data\r\nfrom perkara_pihak1 a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere a.urutan=1 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:49:10'),
(0101,'Alamat #0046#','data_sipp','perkara_pihak1','alamat ',1,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 19:49:12'),
(0102,'Nama #0047#','data_sipp','perkara_pihak2','nama',1,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 19:49:14'),
(0103,'Umur #0047#','data_sql',NULL,NULL,NULL,NULL,'select (get_umur(b.tanggal_lahir,c.tanggal_pendaftaran))as data\r\nfrom perkara_pihak2 a\r\njoin pihak b on a.pihak_id=b.id\r\njoin perkara c on a.perkara_id=c.perkara_id\r\nwhere a.urutan=1 and a.perkara_id=#perkara_id#\r\n\r\n',NULL,NULL,1,'admin','2019-08-09 06:00:02'),
(0104,'Pekerjaan #0047#','data_sql',NULL,NULL,NULL,NULL,'select b.pekerjaan as data\r\nfrom perkara_pihak2 a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere a.urutan=1 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:49:19'),
(0105,'Alamat #0047#','data_sipp','perkara_pihak2','alamat',1,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 19:49:20'),
(0106,'Nama Kuasa #0046#','data_sql',NULL,NULL,NULL,NULL,'select nama as data from perkara_pengacara\r\nwhere pihak_ke=1 and urutan=1 and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:49:21'),
(0107,'Umur Kuasa <<0046',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-08 19:49:28'),
(0108,'Pekerjaan Kuasa <<0046',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0109,'Alamat Kuasa #0046#','data_sql',NULL,NULL,NULL,NULL,'select alamat as data from perkara_pengacara\r\nwhere pihak_ke=1 and urutan=1 and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:49:36'),
(0110,'Nomor surat izin pengacara',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0111,'Tgl.Register Surat Kuasa #0046#','data_sql',NULL,NULL,NULL,NULL,'select tanggal_kuasa as data from perkara_pengacara\r\nwhere pihak_ke=1 and urutan=1 and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:49:40'),
(0112,'Tgl.Register Surat Kuasa #0047#','data_sql',NULL,NULL,NULL,NULL,'select tanggal_kuasa as data from perkara_pengacara\r\nwhere pihak_ke=2 and urutan=1 and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:49:43'),
(0113,'Nomor surat keterangan sebagai kuasa',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0114,'Tgl Surat Ket Pendaftaran Kuasa',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0115,'No. surat ijin khusus sebagai kuasa',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0116,'Tanggal surat ijin sebagai kuasa',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0117,'No. surat peng. relaas ulang P',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0118,'Tgl Relaas Ulang #0046#','data_sql',NULL,NULL,NULL,NULL,'select max(a.tanggal_relaas) data from perkara_pelaksanaan_relaas a\r\njoin v_pihak_perkara b on a.perkara_id=b.perkara_id and a.pihak_id=b.pihak_id\r\njoin perkara_jadwal_sidang c on a.perkara_id=c.perkara_id\r\nwhere c.ikrar_talak=\'T\' and b.urutan=1 and b.pihak_ke=1 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:50:01'),
(0119,'No. surat peng. relaas ulang T',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0120,'Tgl Relaas Ulang #0047#','data_sql',NULL,NULL,NULL,NULL,'select max(a.tanggal_relaas) data from perkara_pelaksanaan_relaas a\r\njoin v_pihak_perkara b on a.perkara_id=b.perkara_id and a.pihak_id=b.pihak_id\r\njoin perkara_jadwal_sidang c on a.perkara_id=c.perkara_id\r\nwhere c.ikrar_talak=\'T\' and b.urutan=1 and b.pihak_ke=2 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:50:03'),
(0121,'Hari Relaas Ulang #0046#','tanggal_hari',NULL,NULL,NULL,0118,NULL,NULL,NULL,1,NULL,'2019-08-08 19:50:07'),
(0122,'Hari Relaas Ulang #0047#','tanggal_hari',NULL,NULL,NULL,0120,NULL,NULL,NULL,1,NULL,'2019-08-08 19:50:08'),
(0124,'utk Ghoib','data_sql',NULL,NULL,NULL,NULL,'select (case\r\n\r\nwhen locate(\"dahulu\",\"#0105#\")>0 then\r\n\"\"\r\n\r\nelse\r\n\"tempat kediaman di \"\r\n\r\nend)\r\nas data',NULL,NULL,1,NULL,'2019-08-08 19:50:13'),
(0125,'Hak / kewajiban Penerima kuasa',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0126,'waktu pemanggilan pihak - pihak',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0127,'dengan Pe/Ter dan ia',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0128,'Keterangan Anak Pemohon (DK)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0129,'Keterangan Anak Pemohon 2 (DK)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0130,'hari legalisasi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0131,'Tgl Penyampaian Salinan Putusan PK dari MA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-19 02:48:22'),
(0132,'Tgl. Kuasa #0046#','data_tanggal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 19:50:33'),
(0133,'Hari Tunda Sidang','multi_sidang',NULL,NULL,NULL,NULL,NULL,NULL,'hari_ditunda',1,NULL,'2019-08-08 19:50:31'),
(0134,'Tgl Sidang Tunda','multi_sidang',NULL,NULL,NULL,NULL,NULL,NULL,'tanggal_ditunda',1,NULL,'2019-08-08 19:50:37'),
(0135,'Hari Sidang Pertama Ikrar Cerai Talak','tanggal_hari',NULL,NULL,NULL,0144,NULL,NULL,NULL,1,NULL,'2019-08-08 19:50:46'),
(0136,'Tgl PMH Sidang Ikrar','data_sipp','perkara_ikrar_talak','penetapan_majelis_hakim',NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 19:50:50'),
(0138,'a.n. Ter sebagai .......',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0141,'#0046# / Kuasanya Hadir','data_sql',NULL,NULL,NULL,NULL,'select (case\r\n\r\nwhen \"#0106#\"!=\"\" and \"#1033#\"!=\"\" then\r\n\"Para #0046# menghadap didampingi Kuasanya\"\r\n\r\nwhen \"#0106#\"!=\"\" then\r\n\"#0046# menghadap didampingi Kuasanya\"\r\n\r\nwhen \"#1033#\"!=\"\" then\r\n\"Para #0046# menghadap sendiri\"\r\n\r\nelse\r\n\"#0046# menghadap sendiri\"\r\n\r\nend) as data','#0046# menghadap sendiri',NULL,0,NULL,'2019-01-23 07:01:26'),
(0142,'#0047# / Kuasanya Hadir','data_sql',NULL,NULL,NULL,NULL,'select (case\r\n\r\nwhen \"#0170#\"!=\"\" and \"#1033#\"!=\"\" then\r\n\"Para #0047# menghadap didampingi Kuasanya\"\r\n\r\nwhen \"#0170#\"!=\"\" then\r\n\"#0047# menghadap didampingi Kuasanya\"\r\n\r\nwhen \"#5026#\"!=\"\" then\r\n\"Para #0047# menghadap sendiri\"\r\n\r\nelse\r\n\"#0047# menghadap sendiri\"\r\n\r\nend) as data',NULL,NULL,0,NULL,'2019-01-23 07:01:26'),
(0143,'Total Biaya Perkara','data_sql',NULL,NULL,NULL,NULL,'select (\r\n0#0279# + \r\n0#6060# + \r\n0#0312# + \r\n0#6063# + \r\n0#6061# + \r\n0#6062# +\r\n0#0281# + \r\n0#5223#)\r\nas data',NULL,NULL,0,NULL,'2019-07-18 11:43:57'),
(0144,'Tgl Ikrar Talak Pertama','data_sipp','perkara_ikrar_talak','tanggal_sidang_pertama',NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 19:51:20'),
(0146,'Kode Ketua Majelis','data_sql',NULL,NULL,NULL,NULL,'select hakim_kode as data\r\nfrom perkara_hakim_pn \r\nwhere aktif=\"Y\" and urutan=1 and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:51:13'),
(0147,'Kode Hakim Ang. 1','data_sql',NULL,NULL,NULL,NULL,'select hakim_kode as data\r\nfrom perkara_hakim_pn \r\nwhere aktif=\"Y\" and urutan=2 and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:51:14'),
(0148,'Kode Hakim Ang. 2','data_sql',NULL,NULL,NULL,NULL,'select hakim_kode as data\r\nfrom perkara_hakim_pn \r\nwhere aktif=\"Y\" and urutan=3 and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:51:24'),
(0149,'Kode PP',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0150,'Zona Waktu','data_sql',NULL,NULL,NULL,NULL,'select value as data from sys_config\r\nwhere name=\"ZonaWaktu\"',NULL,NULL,1,NULL,'2019-08-08 19:51:38'),
(0151,'Tgl Terima Memori',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0152,'Tgl Terima Kontra',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0153,'Tgl penyampaian Memori',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0154,'Tgl penyampaian Kontra',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0155,'Terbilang Biaya Perkara','terbilang',NULL,NULL,NULL,0143,NULL,NULL,NULL,1,NULL,'2019-08-08 19:51:49'),
(0156,'Kantor Kuasa #0046#','data_teks',NULL,NULL,NULL,NULL,NULL,' pada Kantor ...',NULL,0,NULL,'2019-07-22 07:09:07'),
(0157,'Kantor Kuasa #0047#','data_teks',NULL,NULL,NULL,NULL,NULL,'Kantor ...',NULL,0,NULL,'2019-05-19 07:36:08'),
(0158,'Tgl Putusan Banding',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0159,'Amar Lengkap Putusan Banding',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0160,'Susunan Majelis Hakim Tk. Banding',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0161,'Tgl PBT Putusan Banding',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0163,'Ruang Sidang','multi_sidang',NULL,NULL,NULL,NULL,NULL,NULL,'ruangan',1,NULL,'2019-08-08 19:52:00'),
(0164,'Nomor AC','data_sipp','perkara_akta_cerai','nomor_akta_cerai',NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 19:51:58'),
(0166,'Agama Kuasa #0046#','data_sql',NULL,NULL,NULL,NULL,'select c.nama as data\r\nfrom perkara_pengacara a\r\njoin pihak b on a.pengacara_id=b.id\r\njoin agama c on b.agama_id=c.id\r\nwhere a.pihak_ke=1 and a.urutan=1 and a.perkara_id=#perkara_id#','Islam',NULL,1,NULL,'2019-08-08 19:52:04'),
(0168,'Tgl BHT','data_sipp','perkara_putusan','tanggal_bht',NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 19:52:08'),
(0170,'Nama Kuasa #0047#','data_sql',NULL,NULL,NULL,NULL,'select nama as data from perkara_pengacara\r\nwhere pihak_ke=2 and urutan=1 and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:52:11'),
(0171,'Umur Kuasa <<0047',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0172,'Pekerjaan Kuasa <<0047',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0173,'Alamat Kuasa #0047#','data_sql',NULL,NULL,NULL,NULL,'select alamat as data from perkara_pengacara\r\nwhere pihak_ke=2 and urutan=1 and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:52:16'),
(0174,'Agama Kuasa <<0047',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0176,'Nomor Box',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0177,'Nomor Rak',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0178,'Daftar Isi Berkas',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0180,'Tgl Penetapan Penunjukan PP/JSP','data_sipp','perkara_penetapan','penetapan_panitera_pengganti',NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 19:52:20'),
(0182,'Tgl Pemberian Izin Kuasa Insidentil P',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0183,'Tgl Pemberian Izin Kuasa Insidentil T',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0184,'Tgl. Surat Kuasa #0046#','data_tanggal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-08 19:52:38'),
(0185,'Tgl. Surat Kuasa #0047#','data_tanggal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-08 19:52:39'),
(0186,'Alasan Kasasi tidak memenuhi syarat formil',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0187,'Tgl S.Ket Tidak memenuhi syarat formil P',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0188,'Tgl S.Ket Tidak memenuhi syarat formil T',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0189,'Tgl S.Ket Inzage P',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0190,'Tgl S.Ket Inzage T',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0191,'Tahun Perkara','data_sipp','v_perkara','tahun_pendaftaran',NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 19:53:00'),
(0192,'Status Prodeo',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0193,'Tgl. Sidang II','data_sipp','perkara_jadwal_sidang','tanggal_sidang',2,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 19:53:10'),
(0194,'putusan/ penetapan','data_sql',NULL,NULL,NULL,NULL,'select (case when alur_perkara_id=16 then \"penetapan\"\r\nelse \"putusan\" end) as data\r\nfrom perkara where perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:53:12'),
(0195,'Tgl. Cetak Duplikat AC',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0197,'No. Reg. Surat Kuasa #0046#','data_sql',NULL,NULL,NULL,NULL,'select nomor_kuasa as data from perkara_pengacara\r\nwhere pihak_ke=1 and urutan=1 and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:53:19'),
(0198,'No. Reg. Surat Kuasa #0047#','data_sql',NULL,NULL,NULL,NULL,'select nomor_kuasa as data from perkara_pengacara\r\nwhere pihak_ke=2 and urutan=1 and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:53:20'),
(0200,'Tgl. PHS Sita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0201,'Tgl. PHS Eksekusi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0202,'Tgl. PMH Sita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0203,'Tgl. PMH Eksekusi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0204,'Tgl. Penunjukan JS/JSP Sita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0205,'Tgl. Penunjukan JS/JSP Eksekusi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0211,'Alasan Penggantian Majelis Hakim','data_sql',NULL,NULL,NULL,NULL,'select keterangan as data from perkara_hakim_pn\r\nwhere aktif=\"Y\" and urutan=1 and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:53:26'),
(0212,'Alasan Penggantian Panitera/PP','data_sql',NULL,NULL,NULL,NULL,'select keterangan as data from perkara_panitera_pn\r\nwhere aktif=\"Y\" and urutan=1 and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:53:28'),
(0213,'Alasan Penggantian Jurusita/JSP','data_sql',NULL,NULL,NULL,NULL,'select keterangan as data from perkara_jurusita\r\nwhere aktif=\"Y\" and urutan=1 and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:53:29'),
(0214,'Alasan Penggantian Hari Sidang','data_sql',NULL,NULL,NULL,NULL,'select SUBSTRING_INDEX(keterangan,\"Alasan\",-1) as data from perkara_penetapan_hari_sidang\r\nwhere perkara_id=#perkara_id# and tanggal_penetapan=\"#1136#\"',NULL,NULL,1,NULL,'2019-08-08 19:53:31'),
(0215,'Tgl. Penetapan JSP awal','data_sql',NULL,NULL,NULL,NULL,'select tanggal as data from perkara_proses\r\nwhere proses_id=40 and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:53:33'),
(0216,'Tgl. Penetapan JSP baru','data_sql',NULL,NULL,NULL,NULL,'select tanggal as data from perkara_proses\r\nwhere proses_id=41 and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:53:34'),
(0252,'Terhitung Biaya Permintaan Bantuan','terbilang',NULL,NULL,NULL,5230,NULL,NULL,NULL,1,NULL,'2019-08-08 19:53:44'),
(0259,'Nomor SK Majelis Baru',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0260,'Tgl. SK Majelis Baru',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0279,'Biaya Pendaftaran','data_sql',NULL,NULL,NULL,NULL,'select jumlah as data from perkara_biaya\r\nwhere jenis_biaya_id=61 and perkara_id=#perkara_id#',NULL,NULL,0,NULL,'2018-01-01 04:00:00'),
(0280,'Tgl. Biaya Pendaftaran',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0281,'Biaya Redaksi','data_sql',NULL,NULL,NULL,NULL,'select \"10000.00\" as data',NULL,NULL,0,NULL,'2019-07-18 11:50:49'),
(0282,'Tgl Biaya Proses',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0283,'Tgl Biaya Panggilan #0046#','data_sql',NULL,NULL,NULL,NULL,'select max(tanggal_transaksi) as data from perkara_biaya\r\nwhere\r\njenis_biaya_id=13 and perkara_id=#perkara_id#\r\nor\r\njenis_biaya_id=12 and perkara_id=#perkara_id#',NULL,NULL,0,NULL,'2018-01-01 04:00:00'),
(0285,'Tgl Biaya Panggilan #0047#','data_sql',NULL,NULL,NULL,NULL,'select max(tanggal_transaksi) as data from perkara_biaya\r\nwhere\r\njenis_biaya_id=14 and perkara_id=#perkara_id#\r\nor\r\njenis_biaya_id=15 and perkara_id=#perkara_id#',NULL,NULL,0,NULL,'2018-01-01 04:00:00'),
(0287,'Tgl Biaya Panggilan Saksi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0288,'Biaya Panggilan Saksi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0289,'Tgl. Biaya Sita Konservatoir',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0291,'Tgl. Biaya Pendaftaran Sita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0292,'Biaya Pendaftaran Sita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0293,'Tgl. Biaya Pemeriksaan Setempat',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0294,'Biaya Pemeriksaan Setempat',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0295,'Tgl. Biaya Redaksi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0296,'Tgl. Biaya Meterai','data_teks',NULL,NULL,NULL,NULL,NULL,'0.00',NULL,0,NULL,'2019-04-15 04:09:22'),
(0297,'Hari Surat Kuasa #0046#','tanggal_hari',NULL,NULL,NULL,0184,NULL,NULL,NULL,0,NULL,'2019-08-08 19:54:27'),
(0298,'Hari Surat Kuasa #0047#','tanggal_hari',NULL,NULL,NULL,0185,NULL,NULL,NULL,0,NULL,'2019-08-08 19:54:28'),
(0302,'Hijriah Sidang Ikrar Talak','tanggal_hijriah',NULL,NULL,NULL,1182,NULL,NULL,NULL,1,NULL,'2019-08-08 19:54:32'),
(0303,'Tgl. Pengumuman','data_tanggal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-01-17 02:02:45'),
(0304,'Hari Pengumuman','tanggal_hari',NULL,NULL,NULL,0303,NULL,NULL,NULL,0,NULL,'2018-01-17 02:02:56'),
(0306,'Tgl. Daftar (tersebut)','data_sql',NULL,NULL,NULL,NULL,'select (case when\r\n\"#0017#\" = \"#1061#\" then \"tersebut\"\r\nelse \"#1061#\" end)\r\ndata',NULL,NULL,0,NULL,'2019-01-23 07:01:26'),
(0307,'hari/tanggal daftar (utk putusan)','data_sql',NULL,NULL,NULL,NULL,'select (case when\r\n\"#0017#\" = \"#1061#\" then \"hari\"\r\nelse \"tanggal\" end)\r\ndata',NULL,NULL,0,NULL,'2019-01-23 07:01:26'),
(0308,'Tgl. Daftar (pd hari itu jg)','data_sql',NULL,NULL,NULL,NULL,'select (case when\r\n\"#0017#\" = \"#1061#\" then \"itu juga\"\r\nelse \"#1061#\" end)\r\ndata',NULL,NULL,0,NULL,'2019-01-23 07:01:26'),
(0309,'Tgl. Daftar Tk. Pertama',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0310,'Biaya Panggil 1x #0046#','data_sql',NULL,NULL,NULL,NULL,'select max(jumlah) as data from perkara_biaya\r\nwhere \r\njenis_biaya_id=13 and  perkara_id=#perkara_id#\r\nor\r\njenis_biaya_id=12 and  perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:54:57'),
(0311,'Biaya Panggil 1x #0047#','data_sql',NULL,NULL,NULL,NULL,'select max(jumlah) as data from perkara_biaya\r\nwhere\r\njenis_biaya_id=14 and perkara_id=#perkara_id#\r\nor\r\njenis_biaya_id=15 and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:55:15'),
(0312,'Biaya Panggil #0046# + #0047#','data_sql',NULL,NULL,NULL,NULL,'select (0#1091# + 0#1092#)\r\nas data',NULL,NULL,1,NULL,'2019-08-08 19:55:16'),
(0313,'Hari Sidang Sita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0314,'Bahwa ada bukti surat IN 2 P','data_sql',NULL,NULL,NULL,NULL,'select (case\r\n\r\nwhen \"#1314#\"!=\"\" or \"#1321#\"!=\"\" or \"#1325#\"!=\"\" then\r\n\"Bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti tertulis berupa: \"\r\n\r\nelse \"\"\r\n\r\nend) as data',NULL,NULL,0,NULL,'2019-07-18 13:15:39'),
(0315,'Bukti IN 2P KTP (otomatis bas)','data_sql',NULL,NULL,NULL,NULL,'select (case\r\n\r\nwhen \"#1314#\"!=\"\" and \"#1316#\"!=\"\" and \"#1510#\"!=\"\" then\r\n\"1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\r\n4.   Asli Surat Keterangan Kematian Nomor #1316# tanggal #1317# yang dikeluarkan oleh #1342#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.4). Diberi tanggal dan paraf #0668#;\r\n5.   Asli Surat Keterangan Kematian Nomor #1510# tanggal #1511# yang dikeluarkan oleh #1512#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.5). Diberi tanggal dan paraf #0668#;\"\r\n\r\nwhen \"#1314#\"!=\"\" and \"#1316#\"!=\"\" and \"#1325#\"!=\"\" then\r\n\"1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\r\n4.   Asli Surat Keterangan Kematian Nomor #1316# tanggal #1317# yang dikeluarkan oleh #1342#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.4). Diberi tanggal dan paraf #0668#;\r\n5.   Fotokopi Akta Cerai Nomor #1325# tanggal #1329# yang dikeluarkan oleh #1331#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.5). Diberi tanggal dan paraf #0668#;\"\r\n\r\nwhen \"#1314#\"!=\"\" and \"#1321#\"!=\"\" and \"#1325#\"!=\"\" then\r\n\"1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\r\n4.   Fotokopi Akta Cerai Nomor #1321# tanggal #1322# yang dikeluarkan oleh #1324#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.4). Diberi tanggal dan paraf #0668#;\r\n5.   Fotokopi Akta Cerai Nomor #1325# tanggal #1329# yang dikeluarkan oleh #1331#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.5). Diberi tanggal dan paraf #0668#;\"\r\n\r\nwhen \"#1314#\"!=\"\" and \"#1321#\"!=\"\" and \"#1510#\"!=\"\" then\r\n\"1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\r\n4.   Fotokopi Akta Cerai Nomor #1321# tanggal #1322# yang dikeluarkan oleh #1324#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.4). Diberi tanggal dan paraf #0668#;\r\n5.   Asli Surat Keterangan Kematian Nomor #1510# tanggal #1511# yang dikeluarkan oleh #1512#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.5). Diberi tanggal dan paraf #0668#;\"\r\n\r\nwhen \"#1314#\"!=\"\" and \"#1316#\"!=\"\" then\r\n\"1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\r\n4.   Asli Surat Keterangan Kematian Nomor #1316# tanggal #1317# yang dikeluarkan oleh #1342#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.4). Diberi tanggal dan paraf #0668#;\"\r\n\r\nwhen \"#1314#\"!=\"\" and \"#1510#\"!=\"\" then\r\n\"1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\r\n4.  Asli Surat Keterangan Kematian Nomor #1510# tanggal #1511# yang dikeluarkan oleh #1512#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.4). Diberi tanggal dan paraf #0668#;\"\r\n\r\nwhen \"#1314#\"!=\"\" and \"#1321#\"!=\"\" then\r\n\"1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\r\n4.   Fotokopi Akta Cerai Nomor #1321# tanggal #1322# yang dikeluarkan oleh #1324#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.4). Diberi tanggal dan paraf #0668#;\"\r\n\r\nwhen \"#1314#\"!=\"\" and \"#1325#\"!=\"\" then\r\n\"1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\r\n4.   Fotokopi Akta Cerai Nomor #1325# tanggal #1329# yang dikeluarkan oleh #1331#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.4). Diberi tanggal dan paraf #0668#;\"\r\n\r\nwhen \"#1314#\"!=\"\" then\r\n\"1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\"\r\n\r\n\r\nelse \"\"\r\n\r\nend) data',NULL,NULL,0,NULL,'2019-07-20 04:00:54'),
(0316,'Pertimbngn Bukti Surat IN 2 P - KTP','data_sql',NULL,NULL,NULL,NULL,'select (case\r\n\r\nwhen \"#1316#\"!=\"\" and \"#1510#\"!=\"\" then \"\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.4 berupa Asli Surat Kematian yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup dan telah dicap pos, isi bukti tersebut menerangkan bahwa sebelum menikah Pemohon I telah menikah dengan seorang #2025# bernama #1025# dan telah meninggal dunia pada tanggal #1246# karena #1247#, relevan dengan dalil yang hendak dibuktikan oleh Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.5 berupa Asli Surat Kematian yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup dan telah dicap pos, isi bukti tersebut menerangkan bahwa sebelum menikah Pemohon II telah menikah dengan seorang #1516# bernama #1513# dan telah meninggal dunia pada tanggal #1514# karena #1515#, relevan dengan dalil yang hendak dibuktikan oleh Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;\"\r\n\r\nwhen \"#1316#\"!=\"\" and \"#1325#\"!=\"\" then \"\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.4 berupa Asli Surat Kematian yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup dan telah dicap pos, isi bukti tersebut menerangkan bahwa sebelum menikah Pemohon I telah menikah dengan seorang #2025# bernama #1025# dan telah meninggal dunia pada tanggal #1246# karena #1247#, relevan dengan dalil yang hendak dibuktikan oleh Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.5 berupa fotokopi Akta Cerai yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos dan cocok dengan aslinya, isi bukti tersebut menerangkan bahwa Pemohon II telah bercerai dengan #1330# pada tanggal #1329#, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;\"\r\n\r\nwhen \"#1321#\"!=\"\" and \"#1325#\"!=\"\" then \"\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.4 berupa fotokopi Akta Cerai yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos dan cocok dengan aslinya, isi bukti tersebut menerangkan bahwa Pemohon I telah bercerai dengan #1323# pada tanggal #1322#, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.5 berupa fotokopi Akta Cerai yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos dan cocok dengan aslinya, isi bukti tersebut menerangkan bahwa Pemohon II telah bercerai dengan #1330# pada tanggal #1329#, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;\"\r\n\r\nwhen \"#1321#\"!=\"\" and \"#1510#\"!=\"\" then \"\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.4 berupa fotokopi Akta Cerai yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos dan cocok dengan aslinya, isi bukti tersebut menerangkan bahwa Pemohon I telah bercerai dengan #1323# pada tanggal #1322#, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.5 berupa Asli Surat Kematian yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup dan telah dicap pos, isi bukti tersebut menerangkan bahwa sebelum menikah Pemohon II telah menikah dengan seorang #1516# bernama #1513# dan telah meninggal dunia pada tanggal #1514# karena #1515#, relevan dengan dalil yang hendak dibuktikan oleh Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;\"\r\n\r\nwhen \"#1316#\"!=\"\" then \"\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.4 berupa Asli Surat Kematian yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup dan telah dicap pos, isi bukti tersebut menerangkan bahwa sebelum menikah Pemohon I telah menikah dengan seorang #2025# bernama #1025# dan telah meninggal dunia pada tanggal #1246# karena #1247#, relevan dengan dalil yang hendak dibuktikan oleh Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;\"\r\n\r\nwhen \"#1510#\"!=\"\" then \"\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.4 berupa Asli Surat Kematian yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup dan telah dicap pos, isi bukti tersebut menerangkan bahwa sebelum menikah Pemohon II telah menikah dengan seorang #1516# bernama #1513# dan telah meninggal dunia pada tanggal #1514# karena #1515#, relevan dengan dalil yang hendak dibuktikan oleh Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;\"\r\n\r\nwhen \"#1321#\"!=\"\" then \"\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.4 berupa fotokopi Akta Cerai yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos dan cocok dengan aslinya, isi bukti tersebut menerangkan bahwa Pemohon I telah bercerai dengan #1323# pada tanggal #1322#, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;\"\r\n\r\nwhen \"#1325#\"!=\"\" then \"\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.4 berupa fotokopi Akta Cerai yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos dan cocok dengan aslinya, isi bukti tersebut menerangkan bahwa Pemohon II telah bercerai dengan #1330# pada tanggal #1329#, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;\"\r\n\r\nelse \"\"\r\n\r\nend) data',NULL,NULL,0,NULL,'2019-07-20 04:06:39'),
(0317,'Alasan dibolehkan IN 2 P','data_sql',NULL,NULL,NULL,NULL,'select (case\r\n\r\nwhen locate(\"hilang\",\"#1358#\")>0 or locate(\"rusak\",\"#1358#\")>0 or locate(\"terbakar\",\"#1358#\")>0 or locate(\"tenggelam\",\"#1358#\")>0 or locate(\"robek\",\"#1358#\")>0 or locate(\"hanyut\",\"#1358#\")>0 then\r\n\"menurut pengakuan para Pemohon pernah mempunyai Akta Nikah namun hilang/rusak, maka permohonan Itsbat Nikah dalam perkara ini juga telah memenuhi ketentuan Pasal 7 ayat (3) huruf (b) Kompilasi Hukum Islam\"\r\n\r\nwhen locate(\"1974\",\"#1358#\")>0 then\r\n\"pernikahan tersebut terjadi sebelum berlakunya Undang-undang Nomor 1 tahun 1974, maka permohonan Itsbat Nikah dalam perkara ini juga telah memenuhi ketentuan Pasal 7 ayat (3) huruf (d) Kompilasi Hukum Islam\"\r\n\r\nelse\r\n\"yang menikah tidak mempunyai halangan menikah menurut Undang-Undang Nomor 1 tahun 1974, maka permohonan Itsbat Nikah dalam perkara ini juga telah memenuhi ketentuan Pasal 7 ayat (3) huruf (e) Kompilasi Hukum Islam\"\r\n\r\nend)\r\nas data',NULL,NULL,0,NULL,'2019-01-23 07:01:26'),
(0318,'Bukti Surat DK Putra (otomatis)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0319,'Prtimbngn Bukti Surat DK Putra',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0320,'Ada atau Tiada Bukti Surat',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0321,'Bukti tersebut sebagai berikut:',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0322,'Bukti Surat DK Putri (otomatis)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0323,'Prtimbngn Bukti Surat DK Putri',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0324,'Bukti Surat DK 2 anak (otomatis)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0325,'Prtimbngn Bukti Surat DK 2 anak',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0326,'Bukti Surat IN 1 P (otomatis)','data_sql',NULL,NULL,NULL,NULL,'select (case\r\n\r\nwhen \"#1314#\"!=\"\" and \"#1316#\"!=\"\" then\r\n\"1. Fotokopi Kartu Keluarga Nomor #1314#, tanggal #1315#, yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2. Asli Surat Kematian, Nomor #1316#, tanggal #1317#, yang dikeluarkan oleh #1342#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\"\r\n\r\nwhen \"#1314#\"!=\"\" then\r\n\"Fotokopi Kartu Keluarga Nomor #1314#, tanggal #1315#, yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P). Diberi tanggal dan paraf #0668#;\"\r\n\r\nwhen \"#1316#\"!=\"\" then\r\n\"Asli Surat Kematian, Nomor #1316#, tanggal #1317#, yang dikeluarkan oleh #1342#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P). Diberi tanggal dan paraf #0668#;\"\r\n\r\nelse \"\"\r\n\r\nend) as data',NULL,NULL,0,NULL,'2019-05-16 11:32:48'),
(0327,'Pertimbngn Bukti Surat IN 1 P',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0328,'Alasan dibolehkan IN 1 P','data_sql',NULL,NULL,NULL,NULL,'select (case\r\n\r\nwhen locate(\"hilang\",\"#1358#\")>0 or locate(\"rusak\",\"#1358#\")>0 or locate(\"terbakar\",\"#1358#\")>0 or locate(\"tenggelam\",\"#1358#\")>0 or locate(\"robek\",\"#1358#\")>0 or locate(\"hanyut\",\"#1358#\")>0 then\r\n\"menurut pengakuan Pemohon pernah mempunyai Akta Nikah namun hilang/rusak, maka permohonan Itsbat Nikah dalam perkara ini juga telah memenuhi ketentuan Pasal 7 ayat (3) huruf (b) Kompilasi Hukum Islam\"\r\n\r\nwhen locate(\"1974\",\"#1358#\")>0 then\r\n\"pernikahan tersebut terjadi sebelum berlakunya Undang-undang Nomor 1 tahun 1974, maka permohonan Itsbat Nikah dalam perkara ini juga telah memenuhi ketentuan Pasal 7 ayat (3) huruf (d) Kompilasi Hukum Islam\"\r\n\r\nelse\r\n\"yang menikah tidak mempunyai halangan menikah menurut Undang-Undang Nomor 1 tahun 1974, maka permohonan Itsbat Nikah dalam perkara ini juga telah memenuhi ketentuan Pasal 7 ayat (3) huruf (e) Kompilasi Hukum Islam\"\r\n\r\nend)\r\nas data',NULL,NULL,0,NULL,'2019-01-23 07:01:26'),
(0329,'Pertimbngn Bukti Surat IN 1 P-','data_sql',NULL,NULL,NULL,NULL,'select (case\r\n\r\nwhen \"#1314#\"!=\"\" and \"#1316#\"!=\"\" then\r\n\"Menimbang, bahwa untuk membuktikan dalil-dalilnya, Pemohon telah mengajukan bukti P.1 berupa fotokopi Kartu Keluarga yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos, dan cocok dengan aslinya, isi bukti tersebut menerangkan bahwa Pemohon dengan #2026# #1025# adalah suami isteri dalam satu rumah tangga, relevan dengan dalil yang hendak dibuktikan oleh Pemohon, dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka berdasarkan bukti tersebut harus dinyatakan terbukti bahwa Pemohon dengan #2026# #1025# secara administrasi kependudukan telah terdaftar sebagai suami istri;\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, Pemohon telah mengajukan bukti P.2 berupa Asli Surat Kematian yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, isi bukti tersebut menerangkan bahwa #1025# telah meninggal dunia pada tanggal #1246# karena #1247#, relevan dengan dalil yang hendak dibuktikan oleh Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;\"\r\n\r\nwhen \"#1314#\"!=\"\" then\r\n\"Menimbang, bahwa untuk membuktikan dalil-dalilnya, Pemohon telah mengajukan bukti P berupa fotokopi Kartu Keluarga yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos, dan cocok dengan aslinya, isi bukti tersebut menerangkan bahwa Pemohon dengan #2026# #1025# adalah suami isteri dalam satu rumah tangga, relevan dengan dalil yang hendak dibuktikan oleh Pemohon, dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka berdasarkan bukti tersebut harus dinyatakan terbukti bahwa Pemohon dengan #2026# #1025# secara administrasi kependudukan telah terdaftar sebagai suami istri;\"\r\n\r\nwhen \"#1316#\"!=\"\" then\r\n\"Menimbang, bahwa untuk membuktikan dalil-dalilnya, Pemohon telah mengajukan bukti P berupa Asli Surat Kematian yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, isi bukti tersebut menerangkan bahwa #1025# telah meninggal dunia pada tanggal #1246# karena #1247#, relevan dengan dalil yang hendak dibuktikan oleh Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;\"\r\n\r\nelse \"\"\r\n\r\nend) as data',NULL,NULL,0,NULL,'2019-01-23 07:01:26'),
(0330,'Bukti Surt Pengktn Anak (otomtis)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0331,'Pertimbngn Bukti Pengktn Anak',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0334,'Bukti IN 2P KTP (otomatis Penetapan)','data_sql',NULL,NULL,NULL,NULL,'select (case\r\n\r\nwhen \"#1314#\"!=\"\" and \"#1316#\"!=\"\" and \"#1510#\"!=\"\" then\r\n\"1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\r\n4.   Asli Surat Keterangan Kematian Nomor #1316# tanggal #1317# yang dikeluarkan oleh #1342#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.4). Diberi tanggal dan paraf #0668#;\r\n5.   Asli Surat Keterangan Kematian Nomor #1510# tanggal #1511# yang dikeluarkan oleh #1512#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.5). Diberi tanggal dan paraf #0668#;\"\r\n\r\nwhen \"#1314#\"!=\"\" and \"#1316#\"!=\"\" and \"#1325#\"!=\"\" then\r\n\"1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\r\n4.   Asli Surat Keterangan Kematian Nomor #1316# tanggal #1317# yang dikeluarkan oleh #1342#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.4). Diberi tanggal dan paraf #0668#;\r\n5.   Fotokopi Akta Cerai Nomor #1325# tanggal #1329# yang dikeluarkan oleh #1331#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.5). Diberi tanggal dan paraf #0668#;\"\r\n\r\nwhen \"#1314#\"!=\"\" and \"#1321#\"!=\"\" and \"#1325#\"!=\"\" then\r\n\"1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\r\n4.   Fotokopi Akta Cerai Nomor #1321# tanggal #1322# yang dikeluarkan oleh #1324#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.4). Diberi tanggal dan paraf #0668#;\r\n5.   Fotokopi Akta Cerai Nomor #1325# tanggal #1329# yang dikeluarkan oleh #1331#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.5). Diberi tanggal dan paraf #0668#;\"\r\n\r\nwhen \"#1314#\"!=\"\" and \"#1321#\"!=\"\" and \"#1510#\"!=\"\" then\r\n\"1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\r\n4.   Fotokopi Akta Cerai Nomor #1321# tanggal #1322# yang dikeluarkan oleh #1324#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.4). Diberi tanggal dan paraf #0668#;\r\n5.   Asli Surat Keterangan Kematian Nomor #1510# tanggal #1511# yang dikeluarkan oleh #1512#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.5). Diberi tanggal dan paraf #0668#;\"\r\n\r\nwhen \"#1314#\"!=\"\" and \"#1316#\"!=\"\" then\r\n\"1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\r\n4.   Asli Surat Keterangan Kematian Nomor #1316# tanggal #1317# yang dikeluarkan oleh #1342#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.4). Diberi tanggal dan paraf #0668#;\"\r\n\r\nwhen \"#1314#\"!=\"\" and \"#1510#\"!=\"\" then\r\n\"1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\r\n4.  Asli Surat Keterangan Kematian Nomor #1510# tanggal #1511# yang dikeluarkan oleh #1512#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.4). Diberi tanggal dan paraf #0668#;\"\r\n\r\nwhen \"#1314#\"!=\"\" and \"#1321#\"!=\"\" then\r\n\"1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\r\n4.   Fotokopi Akta Cerai Nomor #1321# tanggal #1322# yang dikeluarkan oleh #1324#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.4). Diberi tanggal dan paraf #0668#;\"\r\n\r\nwhen \"#1314#\"!=\"\" and \"#1325#\"!=\"\" then\r\n\"1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\r\n4.   Fotokopi Akta Cerai Nomor #1325# tanggal #1329# yang dikeluarkan oleh #1331#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.4). Diberi tanggal dan paraf #0668#;\"\r\n\r\nwhen \"#1314#\"!=\"\" then\r\n\"1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\"\r\n\r\n\r\nelse \"\"\r\n\r\nend) data',NULL,NULL,0,NULL,'2019-07-20 03:59:40'),
(0335,'No. NIK #0046#','data_sql',NULL,NULL,NULL,NULL,'select b.nomor_indentitas as data from perkara_pihak1 a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere a.urutan=1 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:55:38'),
(0336,'No. NIK #0046# II','data_sql',NULL,NULL,NULL,NULL,'select b.nomor_indentitas as data from perkara_pihak1 a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere a.urutan=2 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:55:39'),
(0337,'No. NIK #0047#','data_sql',NULL,NULL,NULL,NULL,'select b.nomor_indentitas as data from perkara_pihak2 a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere a.urutan=1 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:55:40'),
(0338,'No. NIK Pria (Dispensasi)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0339,'No. NIK Wanita (Dispensasi)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0340,'Tempat Lahir Pria (Dispensasi)','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-21 13:38:21'),
(0341,'Tempat Lahir #0046# ','data_sql',NULL,NULL,NULL,NULL,'select b.tempat_lahir as data\r\nfrom perkara_pihak1 a join pihak b on a.pihak_id=b.id\r\nwhere a.urutan=1 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:55:48'),
(0342,'Tempat Lahir #0046# II','data_sql',NULL,NULL,NULL,NULL,'select b.tempat_lahir as data\r\nfrom perkara_pihak1 a join pihak b on a.pihak_id=b.id\r\nwhere a.urutan=2 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:55:49'),
(0343,'Tempat Lahir #0047#','data_sql',NULL,NULL,NULL,NULL,'select b.tempat_lahir as data\r\nfrom perkara_pihak2 a join pihak b on a.pihak_id=b.id\r\nwhere a.urutan=1 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:55:50'),
(0344,'Tempat Lahir Wanita (Dispensasi)','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-21 13:38:27'),
(0345,'Tgl. Lahir #0046#','data_sql',NULL,NULL,NULL,NULL,'select b.tanggal_lahir as data\r\nfrom perkara_pihak1 a join pihak b on a.pihak_id=b.id\r\nwhere a.urutan=1 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:55:54'),
(0346,'Tgl. Lahir #0046# II','data_sql',NULL,NULL,NULL,NULL,'select b.tanggal_lahir as data\r\nfrom perkara_pihak1 a join pihak b on a.pihak_id=b.id\r\nwhere a.urutan=2 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:55:55'),
(0347,'Tgl. Lahir #0047#','data_sql',NULL,NULL,NULL,NULL,'select b.tanggal_lahir as data\r\nfrom perkara_pihak2 a join pihak b on a.pihak_id=b.id\r\nwhere a.urutan=1 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:55:56'),
(0348,'Tgl. Lahir Pria (Dispensasi)','data_tanggal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-21 13:38:32'),
(0349,'Tgl. Lahir Wanita (Dispensasi)','data_tanggal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-21 13:38:37'),
(0350,'Tempat Lahir Saksi 1 P','data_sql',NULL,NULL,NULL,NULL,'select b.tempat_lahir as data\r\nfrom perkara_pihak5 a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere a.saksi_pihak_ke=1 and a.perkara_id=#perkara_id#\r\norder by a.urutan\r\nlimit 0,1',NULL,NULL,1,NULL,'2019-08-08 19:56:05'),
(0351,'Tgl. Lahir Saksi 1 P','data_sql',NULL,NULL,NULL,NULL,'select b.tanggal_lahir as data\r\nfrom perkara_pihak5 a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere a.saksi_pihak_ke=1 and a.perkara_id=#perkara_id#\r\norder by a.urutan\r\nlimit 0,1',NULL,NULL,1,NULL,'2019-08-08 19:56:06'),
(0352,'No. NIK Saksi 1 P','data_sql',NULL,NULL,NULL,NULL,'select b.nomor_indentitas as data\r\nfrom perkara_pihak5 a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere b.jenis_indentitas=4 and\r\na.saksi_pihak_ke=1 and a.perkara_id=#perkara_id#\r\norder by a.urutan\r\nlimit 0,1',NULL,NULL,1,NULL,'2019-08-08 19:56:07'),
(0353,'Tempat Lahir Saksi 2 P','data_sql',NULL,NULL,NULL,NULL,'select b.tempat_lahir as data\r\nfrom perkara_pihak5 a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere a.saksi_pihak_ke=1 and a.perkara_id=#perkara_id#\r\norder by a.urutan\r\nlimit 1,1',NULL,NULL,1,NULL,'2019-08-08 19:56:08'),
(0354,'Tgl. Lahir Saksi 2 P','data_sql',NULL,NULL,NULL,NULL,'select b.tanggal_lahir as data\r\nfrom perkara_pihak5 a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere a.saksi_pihak_ke=1 and a.perkara_id=#perkara_id#\r\norder by a.urutan\r\nlimit 1,1',NULL,NULL,1,NULL,'2019-08-08 19:56:09'),
(0355,'No. NIK Saksi 2 P','data_sql',NULL,NULL,NULL,NULL,'select b.nomor_indentitas as data\r\nfrom perkara_pihak5 a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere b.jenis_indentitas=4 and\r\na.saksi_pihak_ke=1 and a.perkara_id=#perkara_id#\r\norder by a.urutan\r\nlimit 1,1',NULL,NULL,1,NULL,'2019-08-08 19:56:11'),
(0356,'Tempat Lahir Saksi 1 T','data_sql',NULL,NULL,NULL,NULL,'select b.tempat_lahir as data\r\nfrom perkara_pihak5 a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere a.saksi_pihak_ke=2 and a.perkara_id=#perkara_id#\r\norder by a.urutan\r\nlimit 0,1',NULL,NULL,1,NULL,'2019-08-08 19:56:12'),
(0357,'Tgl. Lahir Saksi 1 T','data_sql',NULL,NULL,NULL,NULL,'select b.tanggal_lahir as data\r\nfrom perkara_pihak5 a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere a.saksi_pihak_ke=2 and a.perkara_id=#perkara_id#\r\nlimit 0,1',NULL,NULL,1,NULL,'2019-08-08 19:56:13'),
(0358,'No. NIK Saksi 1 T','data_sql',NULL,NULL,NULL,NULL,'select b.nomor_indentitas as data\r\nfrom perkara_pihak5 a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere b.jenis_indentitas=4 and\r\na.saksi_pihak_ke=2 and a.perkara_id=#perkara_id#\r\norder by a.urutan\r\nlimit 0,1',NULL,NULL,1,NULL,'2019-08-08 19:56:15'),
(0359,'Tempat Lahir Saksi 2 T','data_sql',NULL,NULL,NULL,NULL,'select b.tempat_lahir as data\r\nfrom perkara_pihak5 a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere a.saksi_pihak_ke=2 and a.perkara_id=#perkara_id#\r\norder by a.urutan\r\nlimit 1,1',NULL,NULL,1,NULL,'2019-08-08 19:56:16'),
(0360,'Tgl. Lahir Saksi 2 T','data_sql',NULL,NULL,NULL,NULL,'select b.tanggal_lahir as data\r\nfrom perkara_pihak5 a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere a.saksi_pihak_ke=2 and a.perkara_id=#perkara_id#\r\norder by a.urutan\r\nlimit 1,1',NULL,NULL,1,NULL,'2019-08-08 19:56:17'),
(0361,'No. NIK Saksi 2 T','data_sql',NULL,NULL,NULL,NULL,'select b.nomor_indentitas as data\r\nfrom perkara_pihak5 a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere b.jenis_indentitas=4 and\r\na.saksi_pihak_ke=2 and a.perkara_id=#perkara_id#\r\norder by a.urutan\r\nlimit 1,1',NULL,NULL,1,NULL,'2019-08-08 19:56:18'),
(0362,'NIK Kuasa #0046#','data_sql',NULL,NULL,NULL,NULL,'select b.nomor_indentitas as data from perkara_pengacara a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere a.pihak_ke=1 and a.urutan=1 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:56:19'),
(0363,'NIK Kuasa #0047#','data_sql',NULL,NULL,NULL,NULL,'select b.nomor_indentitas as data from perkara_pengacara a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere a.pihak_ke=2 and a.urutan=1 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:56:21'),
(0364,'Tgl. KTP #0046#','data_tanggal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-12 07:58:31'),
(0365,'Tgl. KTP #0047#','data_tanggal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-12 07:58:25'),
(0366,'Tgl. KTP #0046# II','data_tanggal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-12 07:58:46'),
(0368,'Tempat Lahir Kuasa #0046#','data_sql',NULL,NULL,NULL,NULL,'select b.tempat_lahir as data\r\nfrom perkara_pengacara a\r\njoin pihak b on a.pengacara_id=b.id\r\nwhere a.pihak_ke=1 and a.urutan=1 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:56:25'),
(0369,'Tgl. Lahir Kuasa #0046#','data_sql',NULL,NULL,NULL,NULL,'select b.tanggal_lahir as data\r\nfrom perkara_pengacara a\r\njoin pihak b on a.pengacara_id=b.id\r\nwhere a.pihak_ke=1 and a.urutan=1 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:56:26'),
(0370,'Email Kuasa #0046#','data_sql',NULL,NULL,NULL,NULL,'select b.email as data\r\nfrom perkara_pengacara a\r\njoin pihak b on a.pengacara_id=b.id\r\nwhere a.pihak_ke=1 and a.urutan=1 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:56:30'),
(0371,'No.HP Kuasa #0046#','data_sql',NULL,NULL,NULL,NULL,'select b.telepon as data\r\nfrom perkara_pengacara a\r\njoin pihak b on a.pengacara_id=b.id\r\nwhere a.pihak_ke=1 and a.urutan=1 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:56:32'),
(0372,'Email Kuasa #0047#','data_sql',NULL,NULL,NULL,NULL,'select b.email as data\r\nfrom perkara_pengacara a\r\njoin pihak b on a.pengacara_id=b.id\r\nwhere a.pihak_ke=2 and a.urutan=1 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:56:33'),
(0373,'No.Hp Kuasa #0047#','data_sql',NULL,NULL,NULL,NULL,'select b.telepon as data\r\nfrom perkara_pengacara a\r\njoin pihak b on a.pengacara_id=b.id\r\nwhere a.pihak_ke=2 and a.urutan=1 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:56:35'),
(0375,'Bukti Surat IN 2 P (otomatis BAS)','data_sql',NULL,NULL,NULL,NULL,'select (case\r\n\r\nwhen \"#1314#\"!=\"\" and \"#1321#\"!=\"\" and \"#1325#\"!=\"\" then\r\n\"1.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Akta Cerai Nomor #1321# tanggal #1322# yang dikeluarkan oleh #1324#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Akta Cerai Nomor #1325# tanggal #1329# yang dikeluarkan oleh #1331#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\"\r\n\r\nwhen \"#1314#\"!=\"\" and \"#1321#\"!=\"\" then\r\n\"1.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Akta Cerai Nomor #1321# tanggal #1322# yang dikeluarkan oleh #1324#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\"\r\n\r\nwhen \"#1314#\"!=\"\" and \"#1325#\"!=\"\" then\r\n\"1.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Akta Cerai Nomor #1325# tanggal #1329# yang dikeluarkan oleh #1331#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\"\r\n\r\nwhen \"#1321#\"!=\"\" and \"#1325#\"!=\"\" then\r\n\"1.   Fotokopi Akta Cerai Nomor #1321# tanggal #1322# yang dikeluarkan oleh #1324#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Akta Cerai Nomor #1325# tanggal #1329# yang dikeluarkan oleh #1331#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\"\r\n\r\nwhen \"#1314#\"!=\"\" and \"#1316#\"!=\"\" and \"#1510#\"!=\"\" then\r\n\"1.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Asli Surat Keterangan Kematian Nomor #1316# tanggal #1317# yang dikeluarkan oleh #1342#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Asli Surat Keterangan Kematian Nomor #1510# tanggal #1511# yang dikeluarkan oleh #1512#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\"\r\n\r\nwhen \"#1314#\"!=\"\" and \"#1316#\"!=\"\" then\r\n\"1.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Asli Surat Keterangan Kematian Nomor #1316# tanggal #1317# yang dikeluarkan oleh #1342#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\"\r\n\r\nwhen \"#1314#\"!=\"\" and \"#1510#\"!=\"\" then\r\n\"1.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Asli Surat Keterangan Kematian Nomor #1510# tanggal #1511# yang dikeluarkan oleh #1512#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\"\r\n\r\nwhen \"#1314#\"!=\"\" then\r\n\"Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P). Diberi tanggal dan paraf #0668#;\"\r\n\r\nwhen \"#1321#\"!=\"\" then\r\n\"Fotokopi Akta Cerai Nomor #1321# tanggal #1322# yang dikeluarkan oleh #1324#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P). Diberi tanggal dan paraf #0668#;\"\r\n\r\nwhen \"#1325#\"!=\"\" then\r\n\"Fotokopi Akta Cerai Nomor #1325# tanggal #1329# yang dikeluarkan oleh #1331#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P). Diberi tanggal dan paraf #0668#;\"\r\n\r\nelse \"\"\r\n\r\nend) as data',NULL,NULL,0,NULL,'2019-08-08 19:56:48'),
(0376,'Pertimbngn Bukti Surat IN 2 P','data_sql',NULL,NULL,NULL,NULL,'select (case\r\n\r\nwhen \"#1314#\"!=\"\" and \"#1321#\"!=\"\" and \"#1325#\"!=\"\" then\r\n\"Menimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.1 berupa fotokopi Kartu Keluarga yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos dan cocok dengan aslinya, isi bukti tersebut menerangkan adanya satu keluarga dimana Pemohon I sebagai kepala keluarga dan Pemohon II sebagai istri, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon, dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka berdasarkan bukti tersebut harus dinyatakan terbukti bahwa Pemohon I dengan Pemohon II secara administrasi kependudukan telah terdaftar sebagai suami istri;\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.2 berupa fotokopi Akta Cerai yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos dan cocok dengan aslinya, isi bukti tersebut menerangkan bahwa Pemohon I telah bercerai dengan #1323# pada tanggal #1322#, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.3 berupa fotokopi Akta Cerai yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos dan cocok dengan aslinya, isi bukti tersebut menerangkan bahwa Pemohon II telah bercerai dengan #1330# pada tanggal #1329#, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;\"\r\n\r\nwhen \"#1314#\"!=\"\" and \"#1321#\"!=\"\" then\r\n\"Menimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.1 berupa fotokopi Kartu Keluarga yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos dan cocok dengan aslinya, isi bukti tersebut menerangkan adanya satu keluarga dimana Pemohon I sebagai kepala keluarga dan Pemohon II sebagai istri, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon, dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka berdasarkan bukti tersebut harus dinyatakan terbukti bahwa Pemohon I dengan Pemohon II secara administrasi kependudukan telah terdaftar sebagai suami istri;\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.2 berupa fotokopi Akta Cerai yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos dan cocok dengan aslinya, isi bukti tersebut menerangkan bahwa Pemohon I telah bercerai dengan #1323# pada tanggal #1322#, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;\"\r\n\r\nwhen \"#1314#\"!=\"\" and \"#1325#\"!=\"\" then\r\n\"Menimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.1 berupa fotokopi Kartu Keluarga yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos dan cocok dengan aslinya, isi bukti tersebut menerangkan adanya satu keluarga dimana Pemohon I sebagai kepala keluarga dan Pemohon II sebagai istri, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon, dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka berdasarkan bukti tersebut harus dinyatakan terbukti bahwa Pemohon I dengan Pemohon II secara administrasi kependudukan telah terdaftar sebagai suami istri;\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.2 berupa fotokopi Akta Cerai yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos dan cocok dengan aslinya, isi bukti tersebut menerangkan bahwa Pemohon II telah bercerai dengan #1330# pada tanggal #1329#, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;\"\r\n\r\nwhen \"#1321#\"!=\"\" and \"#1325#\"!=\"\" then\r\n\"Menimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.1 berupa fotokopi Akta Cerai yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos, dan cocok dengan aslinya, isi bukti tersebut menerangkan bahwa Pemohon I telah bercerai dengan #1323# pada tanggal #1322#, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.2 berupa fotokopi Akta Cerai yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos, dan cocok dengan aslinya, isi bukti tersebut menerangkan bahwa Pemohon II telah bercerai dengan #1330# pada tanggal #1329#, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;\"\r\n\r\nwhen \"#1314#\"!=\"\" and \"#1316#\"!=\"\" and \"#1510#\"!=\"\" then\r\n\"Menimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.1 berupa fotokopi Kartu Keluarga yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos dan cocok dengan aslinya, isi bukti tersebut menerangkan adanya satu keluarga dimana Pemohon I sebagai kepala keluarga dan Pemohon II sebagai istri, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon, dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka berdasarkan bukti tersebut harus dinyatakan terbukti bahwa Pemohon I dengan Pemohon II secara administrasi kependudukan telah terdaftar sebagai suami istri;\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.2 berupa Asli Surat Kematian yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup dan telah dicap pos, isi bukti tersebut menerangkan bahwa sebelum menikah Pemohon I telah menikah dengan seorang #2025# bernama #1025# dan telah meninggal dunia pada tanggal #1246# karena #1247#, relevan dengan dalil yang hendak dibuktikan oleh Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.3 berupa Asli Surat Kematian yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup dan telah dicap pos, isi bukti tersebut menerangkan bahwa sebelum menikah Pemohon II telah menikah dengan seorang #1516# bernama #1513# dan telah meninggal dunia pada tanggal #1514# karena #1515#, relevan dengan dalil yang hendak dibuktikan oleh Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;\"\r\n\r\nwhen \"#1314#\"!=\"\" and \"#1316#\"!=\"\" then\r\n\"Menimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.1 berupa fotokopi Kartu Keluarga yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos, dan cocok dengan aslinya, isi bukti tersebut menerangkan adanya satu keluarga dimana Pemohon I sebagai kepala keluarga dan Pemohon II sebagai istri, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon, dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka berdasarkan bukti tersebut harus dinyatakan terbukti bahwa Pemohon I dengan Pemohon II secara administrasi kependudukan telah terdaftar sebagai suami istri;\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.2 berupa Asli Surat Kematian yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup dan telah dicap pos, isi bukti tersebut menerangkan bahwa sebelum menikah Pemohon I telah menikah dengan seorang #2025# bernama #1025# dan telah meninggal dunia pada tanggal #1246# karena #1247#, relevan dengan dalil yang hendak dibuktikan oleh Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;\" \r\n\r\nwhen \"#1314#\"!=\"\" and \"#1510#\"!=\"\" then\r\n\"Menimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.1 berupa fotokopi Kartu Keluarga yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos, dan cocok dengan aslinya, isi bukti tersebut menerangkan adanya satu keluarga dimana Pemohon I sebagai kepala keluarga dan Pemohon II sebagai istri, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon, dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka berdasarkan bukti tersebut harus dinyatakan terbukti bahwa Pemohon I dengan Pemohon II secara administrasi kependudukan telah terdaftar sebagai suami istri;\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.2 berupa Asli Surat Kematian yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup dan telah dicap pos, isi bukti tersebut menerangkan bahwa sebelum menikah Pemohon II telah menikah dengan seorang #1516# bernama #1513# dan telah meninggal dunia pada tanggal #1514# karena #1515#, relevan dengan dalil yang hendak dibuktikan oleh Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;\"\r\n\r\nwhen \"#1314#\"!=\"\" then\r\n\"Menimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P berupa fotokopi Kartu Keluarga yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos dan cocok dengan aslinya, isi bukti tersebut menerangkan adanya satu keluarga dimana Pemohon I sebagai kepala keluarga dan Pemohon II sebagai istri, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon, dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka berdasarkan bukti tersebut harus dinyatakan terbukti bahwa Pemohon I dengan Pemohon II secara administrasi kependudukan telah terdaftar sebagai suami istri;\"\r\n\r\nwhen \"#1321#\"!=\"\" then\r\n\"Menimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P berupa fotokopi Akta Cerai yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos dan cocok dengan aslinya, isi bukti tersebut menerangkan bahwa Pemohon I telah bercerai dengan #1323# pada tanggal #1322#, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;\"\r\n\r\nwhen \"#1325#\"!=\"\" then\r\n\"Menimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P berupa fotokopi Akta Cerai yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos dan cocok dengan aslinya, isi bukti tersebut menerangkan bahwa Pemohon II telah bercerai dengan #1330# pada tanggal #1329#, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;\"\r\n\r\nelse \"\"\r\n\r\nend) as data',NULL,NULL,0,NULL,'2019-08-08 19:56:56'),
(0377,'Bukti Surat IN 2 P (otomatis Penetapan)','data_sql',NULL,NULL,NULL,NULL,'select (case\r\n\r\nwhen \"#1314#\"!=\"\" and \"#1321#\"!=\"\" and \"#1325#\"!=\"\" then\r\n\"1.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#, telah bermeterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya, lalu diberi kode P.1;\r\n2.   Fotokopi Akta Cerai Nomor #1321# tanggal #1322# yang dikeluarkan oleh #1324#, telah bermeterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya, lalu diberi kode P.2;\r\n3.   Fotokopi Akta Cerai Nomor #1325# tanggal #1329# yang dikeluarkan oleh #1331#, telah bermeterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya, lalu diberi kode P.3;\"\r\n\r\nwhen \"#1314#\"!=\"\" and \"#1321#\"!=\"\" then\r\n\"1.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#, telah bermeterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya, lalu diberi kode P.1;\r\n2.   Fotokopi Akta Cerai Nomor #1321# tanggal #1322# yang dikeluarkan oleh #1324#, telah bermeterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya, lalu diberi kode P.2;\"\r\n\r\nwhen \"#1314#\"!=\"\" and \"#1325#\"!=\"\" then\r\n\"1.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#, telah bermeterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya, lalu diberi kode P.1;\r\n2.   Fotokopi Akta Cerai Nomor #1325# tanggal #1329# yang dikeluarkan oleh #1331#, telah bermeterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya, lalu diberi kode P.2;\"\r\n\r\nwhen \"#1321#\"!=\"\" and \"#1325#\"!=\"\" then\r\n\"1.   Fotokopi Akta Cerai Nomor #1321# tanggal #1322# yang dikeluarkan oleh #1324#, telah bermeterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya, lalu diberi kode P.1;\r\n2.   Fotokopi Akta Cerai Nomor #1325# tanggal #1329# yang dikeluarkan oleh #1331#, telah bermeterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya, lalu diberi kode P.2;\"\r\n\r\nwhen \"#1314#\"!=\"\" and \"#1316#\"!=\"\" and \"#1510#\"!=\"\" then\r\n\"1.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#, telah bermeterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya, lalu diberi kode P.1;\r\n2.   Asli Surat Keterangan Kematian Nomor #1316# tanggal #1317# yang dikeluarkan oleh #1342#, telah bermeterai cukup dan telah dicap pos (nazegelen), lalu diberi kode P.2;\r\n3.   Asli Surat Keterangan Kematian Nomor #1510# tanggal #1511# yang dikeluarkan oleh #1512#, telah bermeterai cukup dan telah dicap pos (nazegelen), lalu diberi kode P.3;\"\r\n\r\nwhen \"#1314#\"!=\"\" and \"#1316#\"!=\"\" then\r\n\"1.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#, telah bermeterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya, lalu diberi kode P.1;\r\n2.   Asli Surat Keterangan Kematian Nomor #1316# tanggal #1317# yang dikeluarkan oleh #1342#, telah bermeterai cukup dan telah dicap pos (nazegelen), lalu diberi kode P.2;\"\r\n\r\nwhen \"#1314#\"!=\"\" and \"#1510#\"!=\"\" then\r\n\"1.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#, telah bermeterai cukup, telah dicap pos, dan telah dicocokkan dengan aslinya, lalu diberi kode P.1;\r\n2.   Asli Surat Keterangan Kematian Nomor #1510# tanggal #1511# yang dikeluarkan oleh #1512#, telah bermeterai cukup dan telah dicap pos (nazegelen), lalu diberi kode P.2;\"\r\n\r\nwhen \"#1314#\"!=\"\" then\r\n\"Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#, telah bermeterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya, lalu diberi kode P;\"\r\n\r\nwhen \"#1321#\"!=\"\" then\r\n\"Fotokopi Akta Cerai Nomor #1321# tanggal #1322# yang dikeluarkan oleh #1324#, telah bermeterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya, lalu diberi kode P;\"\r\n\r\nwhen \"#1325#\"!=\"\" then\r\n\"Fotokopi Akta Cerai Nomor #1325# tanggal #1329# yang dikeluarkan oleh #1331#, telah bermeterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya, lalu diberi kode P;\"\r\n\r\nelse \"\"\r\n\r\nend) as data',NULL,NULL,0,NULL,'2019-07-18 12:56:05'),
(0378,'Bukti Surat IN','data_teks',NULL,NULL,NULL,NULL,NULL,'1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\r\n4.   Asli Surat Keterangan Kematian Nomor #1316# tanggal #1317# yang dikeluarkan oleh #1342#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.4). Diberi tanggal dan paraf #0668#;\r\n5.   Asli Surat Keterangan Kematian Nomor #1510# tanggal #1511# yang dikeluarkan oleh #1512#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.5). Diberi tanggal dan paraf #0668#;\r\n6.   Fotokopi Akta Cerai Nomor #1321# tanggal #1322# yang dikeluarkan oleh #1324#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.4). Diberi tanggal dan paraf #0668#;\r\n7.   Fotokopi Akta Cerai Nomor #1325# tanggal #1329# yang dikeluarkan oleh #1331#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.5). Diberi tanggal dan paraf #0668#;',NULL,0,NULL,'2019-05-16 11:29:50'),
(0600,'Nama Pria (Dispensasi)','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-03-02 02:53:30'),
(0601,'Umur Pria (dispensasi)','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-03-02 02:53:37'),
(0602,'Agama Pria (dispensasi)','data_teks',NULL,NULL,NULL,NULL,NULL,'Islam',NULL,0,NULL,'2018-03-05 03:47:22'),
(0603,'Pendidikan Pria (dispensasi)','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-03-02 02:54:08'),
(0604,'Pekerjaan Pria (dispensasi)','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-03-02 02:54:16'),
(0605,'Alamat Pria (dispensasi)','data_teks',NULL,NULL,NULL,NULL,NULL,'Lingkungan _, Kelurahan _, Kecamatan _, Kabupaten ...\r\nDusun _, Desa _, Kecamatan _, Kabupaten ...\r\n#0101#',NULL,0,NULL,'2018-03-02 02:54:23'),
(0606,'Nama Wanita (Dispensasi)','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-03-02 02:52:19'),
(0607,'Umur Wanita (dispensasi)','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-03-02 02:52:28'),
(0608,'Agama Wanita (dispensasi)','data_teks',NULL,NULL,NULL,NULL,NULL,'Islam',NULL,0,NULL,'2018-01-01 04:00:00'),
(0609,'Pendidikan Wanita (dispensasi)','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-03-02 02:52:40'),
(0610,'Pekerjaan Wanita (dispensasi)','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-03-02 02:52:47'),
(0611,'Alamat Wanita (dispensasi)','data_teks',NULL,NULL,NULL,NULL,NULL,'Lingkungan _, Kelurahan _, Kecamatan _, Kabupaten ...\r\nDusun _, Desa _, Kecamatan _, Kabupaten ...\r\n#0101#',NULL,0,NULL,'2018-03-02 02:53:24'),
(0612,'Inti Permasalahan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0613,'Mulai Berselisih/Bertengar',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0650,'Saksi Nikah 1','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 19:57:18'),
(0651,'Saksi Nikah 2','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 19:57:19'),
(0652,'No. Surat Penolakan KUA','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-08 19:57:33'),
(0653,'Tgl. Surat Penolakan KUA','data_tanggal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-08 19:57:34'),
(0654,'No. Surat Ket. KUA','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-03-16 08:53:10'),
(0655,'Tgl. Surat Ket. KUA','data_tanggal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-03-16 08:53:16'),
(0658,'No. Surat Izin Cerai','data_sipp','perkara_izin_cerai','nomor_surat',NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 19:57:39'),
(0659,'Tgl. Surat Izin Cerai','data_sipp','perkara_izin_cerai','tanggal_surat',NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 19:57:41'),
(0660,'Izin Atasan oleh','data_sipp','perkara_izin_cerai','jabatan_pejabat',NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 19:57:43'),
(0661,'No. SK Prodeo',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0662,'Tgl. Penetapan/SK Prodeo',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0663,'Tgl. Pertimbangan/Penetapan Prodeo','data_tanggal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-03-28 05:18:16'),
(0664,'Tgl. Penunjukan Plt. Ketua',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0665,'Hakim Plt. Ketua','data_sql',NULL,NULL,NULL,NULL,'select value as data from sys_config\r\nwhere name=\"PltKetua\"',NULL,NULL,1,NULL,'2019-08-08 19:58:01'),
(0666,'Hakim Plh. Ketua','data_sql',NULL,NULL,NULL,NULL,'select value as data from sys_config\r\nwhere name=\"PlhKetua\"',NULL,NULL,1,NULL,'2019-08-08 19:58:02'),
(0667,'Majelis Hakim / Hakim','data_sql',NULL,NULL,NULL,NULL,'select (case when max(jabatan_hakim_id)<3 then \"Majelis Hakim\" else \"Hakim\" end) as data from perkara_hakim_pn\r\nwhere aktif=\"Y\" and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:58:03'),
(0668,'Ketua Majelis / Hakim','data_sql',NULL,NULL,NULL,NULL,'select (case when min(jabatan_hakim_id)=1 then \"Ketua Majelis\" else \"Hakim\" end) as data from perkara_hakim_pn\r\nwhere aktif=\"Y\" and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:58:04'),
(0670,'Radio yg ditunjuk (ghoib)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0703,'Posita 3 Peng.  Anak',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0704,'Hubungan dg. Orgtua Anak',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0705,'Alasan Orgtua Serahkan Anak',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0706,'Kedekatan Pemohon dg. Anak',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(0707,'Sikap Keluarga atas Pengktn Anak',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1001,'Mas kawin','data_teks',NULL,NULL,NULL,NULL,NULL,'_ dibayar tunai',NULL,0,NULL,'2018-01-05 10:03:51'),
(1002,'Status #0046# sblm nikah (IN)','data_teks',NULL,NULL,NULL,NULL,NULL,'bujang\r\nduda cerai\r\nduda mati\r\n\r\ngadis\r\njanda cerai\r\njanda mati',NULL,0,NULL,'2018-01-06 05:03:35'),
(1003,'Status #2027# sblm nikah (IN)','data_teks',NULL,NULL,NULL,NULL,NULL,'gadis\r\njanda cerai\r\njanda mati\r\n\r\nbujang\r\nduda cerai\r\nduda mati',NULL,0,NULL,'2018-05-30 03:11:34'),
(1004,'Nomor Kutipan Akta Nikah','data_sipp','perkara_data_pernikahan','no_kutipan_akta_nikah',NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 19:58:34'),
(1005,'Kantor Urusan Agama (KUA)','data_sipp','perkara_data_pernikahan','kua_tempat_nikah',NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 19:58:35'),
(1006,'Tempat tinggal setelah nikah',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1007,'Jumlah anak',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1008,'Akibat dari konflik',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1009,'Alasan orang tua menolak lamaran',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1010,'Tempat nikah ke 2 (poligami)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1011,'Tanggal Nikah','data_sipp','perkara_data_pernikahan','tgl_nikah',NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 19:58:46'),
(1012,'Tanggal Surat Nikah','data_sipp','perkara_data_pernikahan','tgl_kutipan_akta_nikah',NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 19:58:47'),
(1013,'Gaji suami / calon suami / hari/bulan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1014,'Eratnya Hubungan Calon','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-03-02 02:55:43'),
(1015,'Nama Ketua Majelis Banding',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1016,'Nama Hakim 1 Banding',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1017,'Nama Hakim 2 Banding',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1018,'Nama PP Banding',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1019,'Tgl Penetapan Eksekusi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1020,'Tgl Pelaksanaan Eksekusi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1021,'Nama Istri Pertama',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1022,'Umur Istri Pertama',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1023,'Pekerjaan Istri Pertama','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-04-05 08:48:35'),
(1024,'Alamat Istri Pertama',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1025,'Nama Almarhum / Almarhumah','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-05-30 03:04:16'),
(1026,'Umur #2025#','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-04-05 08:19:53'),
(1027,'Pekerjaan #2025#','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-01-06 02:22:39'),
(1028,'Alamat #2025#','data_teks',NULL,NULL,NULL,NULL,NULL,'#0101#',NULL,0,NULL,'2018-04-05 08:20:55'),
(1030,'Umur Suami',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1031,'Pekerjaan Suami',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1032,'Alamat Suami',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1033,'Nama #0046# II','data_sql',NULL,NULL,NULL,NULL,'select nama as data from perkara_pihak1\r\nwhere urutan=2 and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:58:54'),
(1034,'Umur #0046# II','data_sql',NULL,NULL,NULL,NULL,'select (get_umur(b.tanggal_lahir,c.tanggal_pendaftaran))as data\r\nfrom perkara_pihak1 a\r\njoin pihak b on a.pihak_id=b.id\r\njoin perkara c on a.perkara_id=c.perkara_id\r\nwhere a.urutan=2 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-09 06:01:05'),
(1035,'Pekerjaan #0046# II','data_sql',NULL,NULL,NULL,NULL,'select b.pekerjaan as data from perkara_pihak1 a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere a.urutan=2 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:58:58'),
(1036,'Alamat #0046# II','data_sipp','perkara_pihak1','alamat',2,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 19:58:59'),
(1037,'Identitas Wali Nikah',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1038,'Nama Ayah Kandung',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1039,'Umur Ayah Kandung',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1040,'Pekerjaan Ayah Kandung',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1041,'Alamat Ayah Kandung',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1042,'Nama Ibu Kandung',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1043,'Umur Ibu Kandung',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1044,'Pekerjaan Ibu Kandung',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1045,'Alamat Ibu Kandung',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1046,'Status Wali Nikah','data_teks',NULL,NULL,NULL,NULL,NULL,'ayah kandung\r\nsaudara kandung\r\nkakek kandung (ayah dari ayah)\r\npaman kandung (saudara ayah)',NULL,0,NULL,'2018-01-06 03:06:03'),
(1047,'Panjar Biaya Perkara','data_sql',NULL,NULL,NULL,NULL,'select jumlah as data from perkara_biaya\r\nwhere jenis_biaya_id=1 and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:59:16'),
(1048,'Nama Almarhum',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1049,'Tgl Daftar Kuasa T',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1050,'Tgl Penyampaian Salinan Putusan PK dari MA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1051,'Tgl PBT Bunyi Putusan PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1060,'Tgl PMH','data_sipp','perkara_penetapan','penetapan_majelis_hakim',NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 19:59:32'),
(1061,'Tgl. Daftar Perkara','data_sipp','perkara','tanggal_pendaftaran',NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 19:59:33'),
(1062,'Hari Tgl. Daftar','tanggal_hari',NULL,NULL,NULL,1061,NULL,NULL,NULL,1,NULL,'2019-08-08 19:59:35'),
(1064,'Tgl PHS','data_sipp','perkara_penetapan','penetapan_hari_sidang',NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 19:59:36'),
(1065,'Nomor surat pengantar relaas',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1066,'PA Lain Ter','data_sql',NULL,NULL,NULL,NULL,'select CONCAT(\"Pengadilan Agama \",SUBSTRING_INDEX(SUBSTRING_INDEX(\"#0105#\",\"Kota\",-1),\"Kabupaten\",-1))data',NULL,NULL,0,NULL,'2019-01-23 06:54:46'),
(1067,'Nomor surat peng. pemb. isi putusan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1068,'PA lain Pe','data_sql',NULL,NULL,NULL,NULL,'select CONCAT(\"Pengadilan Agama \",SUBSTRING_INDEX(SUBSTRING_INDEX(\"#0101#\",\"Kota\",-1),\"Kabupaten\",-1))data',NULL,NULL,0,NULL,'2019-01-23 06:55:10'),
(1069,'Tgl Putusan','data_sipp','perkara_putusan','tanggal_putusan',NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 19:59:43'),
(1071,'Tgl PBT Isi Putusan','data_sipp','perkara_putusan_pemberitahuan_putusan','max(tanggal_pemberitahuan_putusan)',NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 19:59:45'),
(1072,'Kehadiran #0046#','data_sql',NULL,NULL,NULL,NULL,'select (case\r\n\r\nwhen\r\na.dihadiri_oleh>=3 and b.dihadiri_oleh>=3 or a.dihadiri_oleh>=3 and 1=#0050#\r\nthen\r\n\"#4046# tidak menghadap di persidangan atau menyuruh orang lain sebagai wakilnya yang sah, meskipun menurut relaas Nomor #0001#, tanggal #0118# yang dibacakan di persidangan, #4046# telah dipanggil secara resmi dan patut untuk menghadap di persidangan, dan tidak ternyata ketidakdatangannya tersebut bukan disebabkan alasan yang sah\"\r\n\r\nwhen\r\na.dihadiri_oleh>=3 and b.dihadiri_oleh<=2\r\nthen\r\n\"#4046# tidak menghadap ke persidangan atau menyuruh orang lain untuk menghadap sebagai kuasanya, meskipun telah diperintahkan langsung pada sidang yang lalu untuk datang menghadap pada sidang hari ini\"\r\n\r\nelse\r\n\"#0141#\"\r\nend) data\r\nfrom perkara_jadwal_sidang a\r\nleft join perkara_jadwal_sidang b on a.perkara_id=b.perkara_id and b.urutan=#0050#\r\nwhere a.perkara_id=#perkara_id# and a.urutan=#0050#',NULL,NULL,1,NULL,'2019-08-08 19:59:55'),
(1073,'Kehadiran #0047#','data_sql',NULL,NULL,NULL,NULL,'select (case \r\n\r\nwhen \r\na.dihadiri_oleh %2 = 0 and b.dihadiri_oleh %2 = 0 or a.dihadiri_oleh %2 = 0 and 1=#0050#\r\nthen \r\n\"#4047# tidak menghadap di persidangan atau menyuruh orang lain sebagai wakilnya yang sah, meskipun menurut relaas Nomor #0001#, tanggal #0120# yang dibacakan di persidangan, #4047# telah dipanggil secara resmi dan patut untuk menghadap ke persidangan dan tidak ternyata ketidakdatangannya tersebut bukan disebabkan alasan yang sah\"\r\n\r\nwhen \r\na.dihadiri_oleh %2 = 0 and b.dihadiri_oleh %2 = 1\r\nthen \r\n\"#4047# tidak menghadap ke persidangan atau menyuruh orang lain untuk menghadap sebagai kuasanya, meskipun telah diperintahkan langsung pada sidang yang lalu untuk datang menghadap pada sidang hari ini\"\r\n\r\nelse\r\n\"#0142#\"\r\nend) data\r\nfrom perkara_jadwal_sidang a\r\nleft join perkara_jadwal_sidang b on a.perkara_id=b.perkara_id and b.urutan=#0050#-1\r\nwhere a.perkara_id=#perkara_id# and a.urutan=#0050#',NULL,NULL,1,NULL,'2019-08-08 19:59:56'),
(1076,'Tgl Relaas #0046#','data_sql',NULL,NULL,NULL,NULL,'select min(a.tanggal_relaas) data from perkara_pelaksanaan_relaas a\r\njoin v_pihak_perkara b on a.perkara_id=b.perkara_id and a.pihak_id=b.pihak_id\r\njoin perkara_jadwal_sidang c on a.perkara_id=c.perkara_id\r\nwhere c.ikrar_talak=\'T\' and b.urutan=1 and b.pihak_ke=1 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:59:58'),
(1077,'Tgl Relaas #0047#','data_sql',NULL,NULL,NULL,NULL,'select min(a.tanggal_relaas) data from perkara_pelaksanaan_relaas a\r\njoin v_pihak_perkara b on a.perkara_id=b.perkara_id and a.pihak_id=b.pihak_id\r\njoin perkara_jadwal_sidang c on a.perkara_id=c.perkara_id\r\nwhere c.ikrar_talak=\'T\' and b.urutan=1 and b.pihak_ke=2 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 19:59:59'),
(1079,'Tgl Relaas Ikrar Talak #0046#','data_sql',NULL,NULL,NULL,NULL,'select min(a.tanggal_relaas) data from perkara_pelaksanaan_relaas a\r\njoin v_pihak_perkara b on a.perkara_id=b.perkara_id and a.pihak_id=b.pihak_id\r\njoin perkara_jadwal_sidang c on a.perkara_id=c.perkara_id\r\nwhere c.ikrar_talak=\'Y\' and b.urutan=1 and b.pihak_ke=1 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 20:00:01'),
(1080,'Tgl Relaas Ikrar Talak #0047#','data_sql',NULL,NULL,NULL,NULL,'select min(a.tanggal_relaas) data from perkara_pelaksanaan_relaas a\r\njoin v_pihak_perkara b on a.perkara_id=b.perkara_id and a.pihak_id=b.pihak_id\r\njoin perkara_jadwal_sidang c on a.perkara_id=c.perkara_id\r\nwhere c.ikrar_talak=\'Y\' and b.urutan=1 and b.pihak_ke=2 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 20:00:02'),
(1081,'Tgl. PHS Baru Ikrar Talak','data_tanggal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-08 13:53:10'),
(1082,'No. surat pengantar relaas sidang ikrar Pe',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1083,'Nomor surat teguran membayar kekurangan Panjar',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1084,'Tanggal surat tegoran',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1085,'Tambahan Panjar Biaya Perkara','data_sql',NULL,NULL,NULL,NULL,'select jumlah as data from perkara_biaya\r\nwhere jenis_biaya_id=224 and perkara_id=#perkara_id#',NULL,NULL,0,NULL,'2019-08-08 20:00:28'),
(1086,'Tambah Panjar',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1087,'Batas tanggal membayar kekurangan PBP',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1088,'Tanggal pencoretan perkara',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1089,'Negara Duta Besar',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1090,'Biaya Panggilan #0046# 1x','data_sql',NULL,NULL,NULL,NULL,'select jumlah as data from perkara_biaya\r\nwhere\r\njenis_biaya_id=12 and perkara_id=#perkara_id#\r\nor\r\njenis_biaya_id=13 and perkara_id=#perkara_id#\r\nORDER BY tanggal_transaksi DESC LIMIT 1;',NULL,NULL,1,NULL,'2019-08-08 20:00:33'),
(1091,'Biaya Panggilan #0046#','data_sql',NULL,NULL,NULL,NULL,'select sum(jumlah) as data from perkara_biaya\r\nwhere\r\njenis_biaya_id=12 and perkara_id=#perkara_id#\r\nor\r\njenis_biaya_id=13 and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 20:00:42'),
(1092,'Biaya Panggilan #0047#','data_sql',NULL,NULL,NULL,NULL,'select sum(jumlah) as data from perkara_biaya\r\nwhere \r\njenis_biaya_id=14 and  perkara_id=#perkara_id#\r\nor\r\njenis_biaya_id=15 and  perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 20:00:44'),
(1093,'Nomor surat pemberitahuan mengambil AC',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1094,'Tanggal surat pemberitahuan ambil AC',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1096,'Kecamatan tujuan s. pemberitahuan ambil AC',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1097,'Kabupaten tujuan s. pemberitahuan ambil AC',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1098,'Tgl AC','data_sipp','perkara_akta_cerai','tgl_akta_cerai',NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 20:00:52'),
(1099,'Tgl PHS Ikrar Talak','data_sipp','perkara_ikrar_talak','tanggal_penetapan_sidang_ikrar',NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 20:00:53'),
(1101,'Biaya Penetapan Ikrar Talak','data_sql',NULL,NULL,NULL,NULL,'select (0#1090# + 0#1164#)\r\nas data',NULL,NULL,0,NULL,'2018-02-21 00:37:57'),
(1103,'Ongkos / biaya pemberitahuan Pe',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1105,'Besar nafkah mut\'ah /bulan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1107,'Tanggal lahir istri (dispensasi kawin)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1108,'Nomor duplikat surat nikah','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-01-01 04:00:00'),
(1109,'Berapa kali calon suami melamar',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1110,'Tgl Inzage P',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1111,'Tgl Inzage T',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1112,'Tanggal surat pengantar sita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1113,'Nomor Surat Pengantar Sita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1114,'Tanggal penyitaan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1115,'Pelaksana sita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1116,'Tanggal surat perintah penyitaan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1117,'Nama saksi sita ke I',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1118,'Pekerjaan saksi sita ke I',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1119,'Alamat saksi sita ke I',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1120,'Nama saksi sita ke II',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1121,'Pekerjaan saksi sita ke II',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1126,'Keterangan dari para saksi Pe',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1127,'Pertimbangan lain (menimbang)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1129,'Tanggal surat ket. Peng. PNS',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1130,'Tempat bekerja PNS',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1131,'Kabupaten / kodya instansi PNS',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1134,'Tanggal penetapan putusan yg digugurkan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1135,'Tgl PHS awal','data_sql',NULL,NULL,NULL,NULL,'select min(tanggal_penetapan)data from perkara_penetapan_hari_sidang\r\nwhere perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 20:01:06'),
(1136,'Tgl PHS baru','data_sql',NULL,NULL,NULL,NULL,'select max(tanggal_penetapan)data from perkara_penetapan_hari_sidang\r\nwhere perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 20:01:07'),
(1137,'Tgl Sidang Awal','data_sql',NULL,NULL,NULL,NULL,'select min(tanggal_sidang)data from perkara_penetapan_hari_sidang\r\nwhere perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 20:01:08'),
(1138,'Tgl Sidang Baru','data_sql',NULL,NULL,NULL,NULL,'select max(tanggal_sidang)data from perkara_penetapan_hari_sidang\r\nwhere perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 20:01:09'),
(1139,'Tgl PHS baru 5',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1142,'Agenda Sidang','multi_sidang',NULL,NULL,NULL,NULL,NULL,NULL,'agenda',1,NULL,'2019-08-08 20:01:11'),
(1143,'Tgl PMH awal','data_sql',NULL,NULL,NULL,NULL,'select tanggal as data from perkara_proses\r\nwhere proses_id=20 and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 20:01:13'),
(1144,'Tgl PMH baru','data_sql',NULL,NULL,NULL,NULL,'select tanggal as data from perkara_proses\r\nwhere proses_id=21 and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 20:01:14'),
(1145,'Tgl Penunjukan PP awal','data_sql',NULL,NULL,NULL,NULL,'select tanggal as data from perkara_proses\r\nwhere proses_id=30 and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 20:01:15'),
(1146,'Tgl Penunjukan PP baru','data_sql',NULL,NULL,NULL,NULL,'select tanggal as data from perkara_proses\r\nwhere proses_id=31 and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 20:01:16'),
(1147,'Tgl PMH baru 5',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1148,'Tgl Penetapan Sita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1149,'Yang menerima pendaftaran lisan','data_teks',NULL,NULL,NULL,NULL,NULL,'Dwi Anugerah, S.H.I., M.H.',NULL,0,NULL,'2017-12-01 04:00:00'),
(1151,'Telah / belum hidup rukun ...',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1152,'Alasan poligami','data_teks',NULL,NULL,NULL,NULL,NULL,'karena #0047# tidak bisa memberi keturunan/anak, padahal #0046# sangat merindukan kehadiran anak sebagai penerus keluarganya\r\n\r\nkarena #0046# mempunyai nafsu sex yang besar, dan #0047# kurang dapat melayani #0046# dengan baik dengan alasan terlalu letih\r\n\r\nkarena #0047# dalam keadaan sakit tumor kandungan / kandungan pernah dikiret sehingga menurut hasil medis, #0047# tidak bisa mengandung/hamil',NULL,0,NULL,'2018-04-05 08:22:44'),
(1153,'Jabatan penerima permohonan lisan','data_teks',NULL,NULL,NULL,NULL,NULL,'Hakim',NULL,0,NULL,'2018-01-01 04:00:00'),
(1154,'Nomor surat peng. relaas PA lain Ter','data_teks',NULL,NULL,NULL,NULL,NULL,'W20-A11//Hk.05/ /#0191#',NULL,0,NULL,'2018-11-22 01:25:23'),
(1155,'Nomor surat peng. pemb. isi putusan Pe',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1156,'Nomor surat peng. pemb. isi putusan Ter',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1157,'Tanggal surat peng. pemb. isi putusan Pe',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1158,'Tanggal surat peng. pemb. isi putusan Ter',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1159,'No. surat pemb. mengambil akta cerai Ter',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1160,'Tanggal surat pemb. ambil akta cerai Ter',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1162,'Kecamatan tujuan surat pemb. mengambil AC Ter',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1163,'Kabupaten tujuan surat pemb. mengambil AC Ter',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1164,'Biaya Panggilan #0047# 1x','data_sql',NULL,NULL,NULL,NULL,'select jumlah as data from perkara_biaya\r\nwhere\r\njenis_biaya_id=14 and perkara_id=#perkara_id#\r\nor\r\njenis_biaya_id=15 and perkara_id=#perkara_id#\r\nORDER BY tanggal_transaksi DESC LIMIT 1;',NULL,NULL,0,NULL,'2018-02-21 00:37:06'),
(1165,'Ongkos / biaya Pemberitahuan Ter',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1166,'Kab/Kodya Pe',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1167,'Kab/Kodya Ter','data_sql',NULL,NULL,NULL,NULL,'select SUBSTRING_INDEX(\"#0105#\",\",\",-1) data',NULL,NULL,0,NULL,'2019-01-23 06:55:58'),
(1169,'Tidak mau melakukan hubungan karena',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1170,'Akibat dari kejadian tersebut',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1171,'Identitas ayah Pemohon I',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1172,'Identitas ibu Pemohon I',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1173,'Warga Negara #0046#','data_sql',NULL,NULL,NULL,NULL,'select c.nama as data\r\nfrom perkara_pihak1 a\r\njoin pihak b on a.pihak_id=b.id\r\njoin negara c on b.warga_negara_id=c.id\r\nwhere a.urutan=1 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 20:01:46'),
(1174,'Warga Negara #0046# II','data_sql',NULL,NULL,NULL,NULL,'select c.nama as data\r\nfrom perkara_pihak1 a\r\njoin pihak b on a.pihak_id=b.id\r\njoin negara c on b.warga_negara_id=c.id\r\nwhere a.urutan=2 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 20:01:47'),
(1175,'Pendidikan terakhir Pemohon I',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1176,'Pendidikan #0046# II','data_sql',NULL,NULL,NULL,NULL,'select c.kode as data from perkara_pihak1 a\r\njoin pihak b on a.pihak_id=b.id\r\njoin tingkat_pendidikan c on b.pendidikan_id=c.id\r\nwhere urutan=2 and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 20:01:54'),
(1177,'Identitas ayah Pemohon II',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1178,'Identitas ibu Pemohon II',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1180,'Kedua belah pihak / Pemohon',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1181,'Keadaan Istri (Termohon) saat ikrar','data_sql',NULL,NULL,NULL,NULL,'select (case\r\nwhen keadaan_istri = 1 then \"Suci\"\r\nwhen keadaan_istri = 2 then \"Haid\"\r\nwhen keadaan_istri = 3 then \"Sedang Hamil\"\r\nelse \"Tidak Diketahui\" end) data\r\nfrom perkara_akta_cerai where perkara_id=#perkara_id#',NULL,NULL,0,NULL,'2019-06-19 06:35:44'),
(1182,'Tgl Sidang Ikrar Talak','data_sipp','perkara_ikrar_talak','tgl_ikrar_talak',NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 20:02:03'),
(1183,'Tgl. Batas Waktu Ikrar Talak','data_tanggal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-08 13:33:57'),
(1186,'Kehadiran Pemohon',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1187,'Kehadiran Termohon',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1188,'Diwakili oleh .... nya',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1189,'Nama Wakil untuk yang gila',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1190,'Umur Wakil untuk yang gila',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1191,'Pekerjaan Wakil untuk yang gila',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1192,'Tempat kediaman Wakil yang gila',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1197,'Nama Saksi 1 P','data_sql',NULL,NULL,NULL,NULL,'select nama as data from perkara_pihak5\r\nwhere saksi_pihak_ke=1 and perkara_id=#perkara_id#\r\norder by urutan\r\nlimit 0,1',NULL,NULL,1,NULL,'2019-08-08 20:02:23'),
(1198,'Umur Saksi 1 P','data_sql',NULL,NULL,NULL,NULL,'select (get_umur(b.tanggal_lahir,a.diinput_tanggal))as data\r\nfrom perkara_pihak5 a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere a.saksi_pihak_ke=1 and a.perkara_id=#perkara_id#\r\norder by a.urutan\r\nlimit 0,1',NULL,NULL,1,NULL,'2019-08-08 20:02:24'),
(1199,'Agama Saksi 1 P','data_sql',NULL,NULL,NULL,NULL,'select c.nama as data\r\nfrom perkara_pihak5 a\r\njoin pihak b on a.pihak_id=b.id\r\njoin agama c on b.agama_id=c.id\r\nwhere a.saksi_pihak_ke=1 and a.perkara_id=#perkara_id#\r\norder by a.urutan\r\nlimit 0,1',NULL,NULL,1,NULL,'2019-08-08 20:02:25'),
(1200,'Pendidikan Saksi 1 P','data_sql',NULL,NULL,NULL,NULL,'select c.kode as data from perkara_pihak5 a\r\njoin pihak b on a.pihak_id=b.id\r\njoin tingkat_pendidikan c on b.pendidikan_id=c.id\r\nwhere a.saksi_pihak_ke=1 and a.perkara_id=#perkara_id#\r\norder by a.urutan\r\nlimit 0,1',NULL,NULL,1,NULL,'2019-08-08 20:02:26'),
(1201,'Pekerjaan Saksi 1 P','data_sql',NULL,NULL,NULL,NULL,'select b.pekerjaan as data\r\nfrom perkara_pihak5 a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere a.saksi_pihak_ke=1 and a.perkara_id=#perkara_id#\r\norder by a.urutan\r\nlimit 0,1',NULL,NULL,1,NULL,'2019-08-08 20:02:27'),
(1202,'Alamat Saksi 1 P','data_sql',NULL,NULL,NULL,NULL,'select alamat as data from perkara_pihak5\r\nwhere saksi_pihak_ke=1 and perkara_id=#perkara_id#\r\norder by urutan\r\nlimit 0,1',NULL,NULL,1,NULL,'2019-08-08 20:02:28'),
(1203,'Nama Saksi 2 P','data_sql',NULL,NULL,NULL,NULL,'select nama as data from perkara_pihak5\r\nwhere saksi_pihak_ke=1 and perkara_id=#perkara_id#\r\norder by urutan\r\nlimit 1,1',NULL,NULL,1,NULL,'2019-08-08 20:02:29'),
(1204,'Umur Saksi 2 P','data_sql',NULL,NULL,NULL,NULL,'select (get_umur(b.tanggal_lahir,a.diinput_tanggal))as data\r\nfrom perkara_pihak5 a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere a.saksi_pihak_ke=1 and a.perkara_id=#perkara_id#\r\norder by a.urutan\r\nlimit 1,1',NULL,NULL,1,NULL,'2019-08-08 20:02:30'),
(1205,'Agama Saksi 2 P','data_sql',NULL,NULL,NULL,NULL,'select c.nama as data\r\nfrom perkara_pihak5 a\r\njoin pihak b on a.pihak_id=b.id\r\njoin agama c on b.agama_id=c.id\r\nwhere a.saksi_pihak_ke=1 and a.perkara_id=#perkara_id#\r\norder by a.urutan\r\nlimit 1,1',NULL,NULL,1,NULL,'2019-08-08 20:02:31'),
(1206,'Pendidikan Saksi 2 P','data_sql',NULL,NULL,NULL,NULL,'select c.kode as data from perkara_pihak5 a\r\njoin pihak b on a.pihak_id=b.id\r\njoin tingkat_pendidikan c on b.pendidikan_id=c.id\r\nwhere a.saksi_pihak_ke=1 and a.perkara_id=#perkara_id#\r\norder by a.urutan\r\nlimit 1,1',NULL,NULL,1,NULL,'2019-08-08 20:02:32'),
(1207,'Pekerjaan Saksi 2 P','data_sql',NULL,NULL,NULL,NULL,'select b.pekerjaan as data\r\nfrom perkara_pihak5 a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere a.saksi_pihak_ke=1 and a.perkara_id=#perkara_id#\r\norder by a.urutan\r\nlimit 1,1',NULL,NULL,1,NULL,'2019-08-08 20:02:32'),
(1208,'Alamat Saksi 2 P','data_sql',NULL,NULL,NULL,NULL,'select alamat as data from perkara_pihak5\r\nwhere saksi_pihak_ke=1 and perkara_id=#perkara_id#\r\norder by urutan\r\nlimit 1,1',NULL,NULL,1,NULL,'2019-08-08 20:02:36'),
(1209,'Dipanggil masuk kel. Pe',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1210,'Dipanggil masuk kel. Ter',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1211,'\"Atas pertanyaan Ketua,\"',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1212,'Pertanyaan Kel. Pe/Ter',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1213,'Iwadl ...',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1214,'Alat-alat bukti CG/CT','data_teks',NULL,NULL,NULL,NULL,NULL,'1.Fotokopi Kutipan Akta Nikah dari #1005#, Nomor #1004# Tanggal #1012#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.Fotokopi ... Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;',NULL,0,NULL,'2019-05-16 11:28:18'),
(1215,'Keterangan saksi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1216,'Hari Putusan','tanggal_hari',NULL,NULL,NULL,1069,NULL,NULL,NULL,1,NULL,'2019-08-08 20:02:44'),
(1217,'Nama Wali Nikah','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-01-01 04:00:00'),
(1218,'Pegawai Pencatat Nikah',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1219,'Pembantu PPN/Kaur Kesra',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1220,'Tanggal2 pemanggilan pihak2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1221,'kemudian Pe pergi ke ....',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1222,'Tanggal sidang pihak2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1223,'Kelurahan / Desa ...',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1224,'Camat Kepala Wilayah ........',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1225,'Nomor SK tidak mampu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1226,'Tanggal SK tidak mampu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1230,'Tanggal meninggalnya suami',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1236,'Harta waris total berupa ....',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1237,'Harga harta waris total',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1238,'Harga dan Bentuk harta waris masing-masing',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1239,'Identitas Ter secara vertikal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1241,'Hbgn. Saksi1 P dg. Pihak',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1242,'Hbgn. Saksi2 P dg. Pihak',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1244,'Keterangan Status',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1245,'Sebab meninggalnya suami',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1246,'Tanggal meninggalnya #2026#','data_tanggal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-01-06 02:07:33'),
(1247,'Sebab meninggalnya #2026#','data_teks',NULL,NULL,NULL,NULL,NULL,'sakit',NULL,0,NULL,'2018-01-06 03:09:49'),
(1248,'Hubungan dengan almarhum/almarhumah',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1249,'Hubungan Pihak dg. Majelis',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1250,'Hubungan Pihak dg. PP',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1251,'Hbgn. Saksi1 T dg. Pihak',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1252,'Hbgn. Saksi2 T dg. Pihak',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1253,'Pelanggaran Ta\'lik Talak (No...)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1254,'Tanggal perubahan sidang',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1255,'Diberitahukan kepada ....',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1256,'Berada di rumah (..... Ter)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1257,'Tempat tinggal dahulu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1258,'Tempat Sidang dilangsungkan','multi_sidang',NULL,NULL,NULL,NULL,NULL,NULL,'ruangan',1,NULL,'2019-08-08 20:03:09'),
(1259,'Alamat Tempat Sidang',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1260,'Tempat Sidang (Relaas)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1261,'Pengadilan tsb (BAS)','data_sql',NULL,NULL,NULL,NULL,'select (case\r\n\r\nwhen sidang_keliling = \"Y\"\r\nthen ruangan\r\n\r\nelse (\"ruang sidang Pengadilan Agama tersebut\")\r\n\r\nend) data\r\nfrom perkara_jadwal_sidang\r\nwhere tanggal_sidang=\"#0033#\" and perkara_id=#perkara_id#',NULL,NULL,0,NULL,'2019-05-21 08:47:54'),
(1262,'Alat Bukti #0047#','data_teks',NULL,NULL,NULL,NULL,NULL,'1.Fotokopi ... Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.Fotokopi ... Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;',NULL,0,NULL,'2019-05-16 11:28:47'),
(1263,'No. Seri AC','data_sipp','perkara_akta_cerai','no_seri_akta_cerai',NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 20:03:14'),
(1278,'Tanggal Minutasi','data_sipp','perkara_putusan','tanggal_minutasi',NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 20:03:15'),
(1279,'Identitas Turut <<0047 lebih dari satu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1280,'Nama pewaris pria',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1281,'Tanggal meninggalnya pewaris pria',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1282,'Hari meninggal suami',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1283,'Nama pewaris wanita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1284,'Tanggal meninggalnya pewaris wanita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1285,'Hari Meninggalnya #2026#','tanggal_hari',NULL,NULL,NULL,1246,NULL,NULL,NULL,0,NULL,'2018-01-06 02:07:51'),
(1286,'Indeks berkas disposisi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1295,'Tgl. Tambah Panjar','data_sql',NULL,NULL,NULL,NULL,'select tanggal_transaksi as data from perkara_biaya\r\nwhere jenis_biaya_id=224 and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 20:03:26'),
(1313,'NIP Pejabat KUA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1314,'No. Kartu Keluarga','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-01-01 04:00:00'),
(1315,'Tgl. Kartu Keluarga','data_tanggal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-01-01 04:00:00'),
(1316,'No. Surat Kematian (bukti Pemohon1)','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-05-30 03:53:53'),
(1317,'Tgl. Surat Kematian (bukti Pemohon1)','data_tanggal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-05-30 03:53:50'),
(1318,'No. Akta Kelahiran','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-01-01 04:00:00'),
(1319,'Tgl. Akta Kelahiran','data_tanggal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-01-01 04:00:00'),
(1320,'Tgl. Surat Ket. Tidak Mampu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1321,'No. Akta Cerai P I (Bukti)','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-05-30 02:43:29'),
(1322,'Tgl. Akta Cerai P I (Bukti)','data_tanggal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-05-30 02:44:01'),
(1323,'Bekas Isteri P I dlm AC (Bukti)','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-05-30 02:44:10'),
(1324,'Penerbit Akta Cerai P I (Bukti)','data_teks',NULL,NULL,NULL,NULL,NULL,'Pengadilan Agama ...',NULL,0,NULL,'2018-05-30 02:44:27'),
(1325,'No. Akta Cerai P II (Bukti)','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-05-30 02:44:33'),
(1326,'Tgl Surat Gugatan/Permohonan Lisan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1327,'Hari #1183#','tanggal_hari',NULL,NULL,NULL,1183,NULL,NULL,NULL,0,NULL,'2019-07-08 08:38:59'),
(1328,'Dimuka sidang',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1329,'Tgl. Akta Cerai P II (Bukti)','data_tanggal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-05-30 02:44:46'),
(1330,'Bekas Suami P II dlm AC (Bukti)','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-05-30 02:44:52'),
(1331,'Penerbit Akta Cerai P II (Bukti)','data_teks',NULL,NULL,NULL,NULL,NULL,'Pengadilan Agama ...',NULL,0,NULL,'2018-05-30 02:45:06'),
(1332,'Jenis Alat Bukti Tgl. Lahir Putra','data_teks',NULL,NULL,NULL,NULL,NULL,'Kutipan Akta Kelahiran\r\nIjazah SD\r\nIjazah SMP\r\nIjazah SMA\r\nKeterangan Lahir',NULL,0,NULL,'2018-03-05 03:45:17'),
(1333,'No. Alat Bukti Tgl. Lahir Putra','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-03-05 03:42:51'),
(1334,'Tgl. Alat Bukti Tgl. Lahir Putra','data_tanggal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-03-05 03:42:59'),
(1335,'Pnrbit Alat Bukti Tgl. Lahir Putra','data_teks',NULL,NULL,NULL,NULL,NULL,'Kepala Dinas Kependudukan dan Pencatatan Sipil Kabupaten Majene\r\nKepala Sekolah .....\r\nBidan atas nama .....',NULL,0,NULL,'2017-08-08 00:46:28'),
(1336,'Jenis Alat Bukti Tgl. Lahir Putri','data_teks',NULL,NULL,NULL,NULL,NULL,'Kutipan Akta Kelahiran\r\nIjazah SD\r\nIjazah SMP\r\nIjazah SMA\r\nKeterangan Lahir',NULL,0,NULL,'2018-03-02 02:58:00'),
(1337,'No. Alat Bukti Tgl. Lahir Putri','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-03-02 02:58:48'),
(1338,'Tgl. Alat Bukti Tgl. Lahir Putri','data_tanggal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-03-02 02:58:41'),
(1339,'Pnrbit Alat Bukti Tgl. Lahir Putri','data_teks',NULL,NULL,NULL,NULL,NULL,'Kepala Pejabat Pembuat Akta Catatan Sipil Kabupaten .....\r\nKepala Sekolah .....\r\nBidan atas nama .....',NULL,0,NULL,'2018-03-02 02:58:34'),
(1340,'No. Kartu Keluarga Pemohon II','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-03-05 03:42:27'),
(1341,'Tgl. Kartu Keluarga Pemohon II','data_tanggal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-03-05 03:42:33'),
(1342,'Penerbit Surat Kematian (bukti Pemohon1)','data_teks',NULL,NULL,NULL,NULL,NULL,'Kepala Desa ...',NULL,0,NULL,'2018-05-30 03:53:45'),
(1343,'Jenis Alat Bukti Lain 1','data_teks',NULL,NULL,NULL,NULL,NULL,'SK Veteran\r\nSK PNS\r\nSK Pensiun\r\nAkta Cerai',NULL,0,NULL,'2018-02-21 03:12:40'),
(1344,'No. Alat Bukti Lain 1','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-02-21 03:10:20'),
(1345,'Tgl. Alat Bukti Lain 1','data_tanggal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-02-21 03:10:39'),
(1346,'Penerbit Alat Bukti Lain 1','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-02-21 03:11:00'),
(1347,'Isi Pokok Alat Bukti Lain 1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1348,'Jenis Alat Bukti Lain 2','data_teks',NULL,NULL,NULL,NULL,NULL,'KARIP (Kartu Identitas Pensiun)',NULL,0,NULL,'2018-02-21 03:12:17'),
(1349,'No. Alat Bukti Lain 2','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-02-21 03:11:40'),
(1350,'Tgl. Alat Bukti Lain 2','data_tanggal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-02-21 03:11:46'),
(1351,'Penerbit Alat Bukti Lain 2','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-02-21 03:11:54'),
(1352,'Isi Pokok Alat Bukti Lain 2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1353,'Jenis Alat Bukti Lain 3','data_teks',NULL,NULL,NULL,NULL,NULL,'SK Veteran\r\nSK PNS\r\nSK Pensiun\r\nAkta Cerai',NULL,0,NULL,'2018-02-21 03:12:49'),
(1354,'No. Alat Bukti Lain 3','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-02-21 03:12:55'),
(1355,'Tgl. Alat Bukti Lain 3','data_tanggal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-02-21 03:13:02'),
(1356,'Alasan/dalil gugatan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1357,'Alasan Wali Nikah (kosongkan)','data_teks',NULL,NULL,NULL,NULL,NULL,', karena ...',NULL,0,NULL,'2018-01-01 04:00:00'),
(1358,'Alasan tiada Buku Nikah','data_teks',NULL,NULL,NULL,NULL,NULL,'Bahwa #0046# I dan #0046# II telah melaporkan pernikahannya kepada pak imam untuk didaftarkan pada Kantor Urusan Agama, namun pak imam tersebut tidak melanjutkan pendaftarannya ke Pembantu Pegawai Pencatat Nikah Kantor Urusan Agama\r\n\r\nBahwa #0046# I dan #0046# II telah melaporkan pernikahannya ke Pembantu Pegawai Pencatat Nikah setempat, namun Pembantu Pegawai Pencatat Nikah tersebut tidak melaporkan pencatatan pernikahan tersebut ke Kantor Urusan Agama\r\n\r\nBahwa #0046# I dan #0046# II telah melaporkan pernikahannya ke Kantor Urusan Agama, namun pihak Kantor Urusan Agama belum menerbitkan Buku Kutipan Akta Nikah padahal seluruh persyaratan administrasi telah dipenuhi\r\n\r\nBahwa #0046# I dan #0046# II tidak melaporkan pernikahannya ke Pembantu Pegawai Pencatat Nikah setempat, sehingga Pembantu Pegawai Pencatat Nikah tidak mendaftarkan pernikahan tersebut di Kantor Urusan Agama\r\n\r\nBahwa #0046# I dan #0046# II menikah sebelum Tahun 1974, dimana pada saat itu pencatatan nikah belum tertib\r\n\r\nBahwa #0046# I dan #0046# II pernah memiliki Buku Kutipan Akta Nikah namun hilang/rusak',NULL,0,NULL,'2018-01-05 10:27:01'),
(1359,'Petitum','data_sipp','perkara','petitum',NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-01-01 04:00:00'),
(1360,'Penerbit Alat Bukti Lain 3','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-02-21 03:13:07'),
(1361,'Isi Pokok Alat Bukti Lain 3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1362,'Jenis Alat Bukti Lain 4','data_teks',NULL,NULL,NULL,NULL,NULL,'SK Veteran\r\nSK PNS\r\nSK Pensiun\r\nAkta Cerai',NULL,0,NULL,'2018-02-21 03:13:14'),
(1363,'No. Alat Bukti Lain 4','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-02-21 03:13:19'),
(1364,'Tgl. Alat Bukti Lain 4','data_tanggal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-02-21 03:13:25'),
(1365,'Penerbit Alat Bukti Lain 4','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-02-21 03:13:30'),
(1366,'Isi Pokok Alat Bukti Lain 4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1367,'Jenis Alat Bukti Lain 5','data_teks',NULL,NULL,NULL,NULL,NULL,'SK Veteran\r\nSK PNS\r\nSK Pensiun\r\nAkta Cerai',NULL,0,NULL,'2018-02-21 03:13:38'),
(1368,'No. Alat Bukti Lain 5','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-02-21 03:13:43'),
(1369,'Tgl. Alat Bukti Lain 5','data_tanggal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-02-21 03:13:50'),
(1370,'Penerbit Alat Bukti Lain 5','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-02-21 03:16:11'),
(1371,'Isi Pokok Alat Bukti Lain 5',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1372,'Penerbit Kartu Keluarga','data_teks',NULL,NULL,NULL,NULL,NULL,'Kepala Dinas Kependudukan dan Pencatatan Sipil Kabupaten Majene',NULL,0,NULL,'2017-12-01 01:33:25'),
(1373,'Isi Pokok Kartu Keluarga',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(1509,'Tempat Meninggal Dunia','data_teks',NULL,NULL,NULL,NULL,NULL,'Lingkungan _, Kelurahan _, Kecamatan _, Kabupaten ...\r\nDusun _, Desa _, Kecamatan _, Kabupaten ...\r\n#0101#',NULL,0,NULL,'2018-01-17 07:02:25'),
(1510,'No. Surat Kematian (bukti Pemohon2)','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-05-30 03:54:05'),
(1511,'Tgl. Surat Kematian (bukti Pemohon2)','data_tanggal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-05-30 03:53:59'),
(1512,'Penerbit Surat Kematian (bukti Pemohon2)','data_teks',NULL,NULL,NULL,NULL,NULL,'Kepala Desa ...',NULL,0,NULL,'2018-05-30 03:53:56'),
(1513,'Nama Suami Meninggal (bukti Pemohon2)','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-05-30 04:34:36'),
(1514,'Tanggal Suami Meninggal (bukti Pemohon2)','data_tanggal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-05-30 04:34:44'),
(1515,'Penyebab Suami Meninggal (bukti Pemohon2)','data_teks',NULL,NULL,NULL,NULL,NULL,'sakit',NULL,0,NULL,'2018-05-30 04:34:57'),
(1516,'Pria / Wanita (1513)','data_sql',NULL,NULL,NULL,NULL,'select\r\n(case when \"#1513#\" like \"%binti%\" then \"Wanita\"\r\nelse \"Pria\" end)\r\nas data',NULL,NULL,0,NULL,'2019-01-23 07:01:26'),
(1517,'Jenis Kelamin #0046#','data_sql',NULL,NULL,NULL,NULL,'select (case when b.jenis_kelamin = \"L\" then \"Laki-laki\" else \"Perempuan\" end) as data from perkara_pihak1 a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere urutan=1 and perkara_id=#perkara_id#',NULL,NULL,0,NULL,'2019-06-19 06:35:44'),
(1518,'Jenis Kelamin #0047#','data_sql',NULL,NULL,NULL,NULL,'select (case when b.jenis_kelamin = \"L\" then \"Laki-laki\" else \"Perempuan\" end) as data from perkara_pihak2 a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere urutan=1 and perkara_id=#perkara_id#',NULL,NULL,0,NULL,'2019-06-19 06:35:44'),
(2003,'Hari Tgl. Mediasi','tanggal_hari',NULL,NULL,NULL,0057,NULL,NULL,NULL,0,NULL,'2018-12-26 06:41:01'),
(2004,'kini anak tersebut diasuh oleh',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(2006,'Pendidikan Istri Pertama',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(2007,'Pendidikan Calon Istri','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-04-05 08:20:40'),
(2011,'Kesimpulan Bukti & Saksi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(2012,'Hari AC',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(2013,'Hijriah AC',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(2018,'Keterangan Jawaban Lisan #0047#','tanya_jawab',NULL,NULL,NULL,0102,NULL,NULL,'keterangan',1,NULL,'2019-08-08 20:04:47'),
(2019,'Keterangan Replik Lisan #0046#','tanya_jawab',NULL,NULL,NULL,0098,NULL,NULL,'keterangan',1,NULL,'2019-08-08 20:04:48'),
(2020,'Keterangan Duplik Lisan #0047#','tanya_jawab',NULL,NULL,NULL,0102,NULL,NULL,'keterangan',1,NULL,'2019-08-08 20:04:50'),
(2021,'Keterangan Saksi 1 P','tanya_jawab',NULL,NULL,NULL,1197,NULL,NULL,'keterangan',1,NULL,'2019-08-08 20:04:52'),
(2022,'Keterangan Saksi 2 P','tanya_jawab',NULL,NULL,NULL,1203,NULL,NULL,'keterangan',1,NULL,'2019-08-08 20:04:53'),
(2023,'Keterangan Saksi 1 T','tanya_jawab',NULL,NULL,NULL,6100,NULL,NULL,'keterangan',1,NULL,'2019-08-08 20:04:54'),
(2024,'Keterangan Saksi 2 T','tanya_jawab',NULL,NULL,NULL,6106,NULL,NULL,'keterangan',1,NULL,'2019-08-08 20:04:58'),
(2025,'Pria / Wanita (almarhum)','data_sql',NULL,NULL,NULL,NULL,'select\r\n(case when \"#1025#\" like \"%binti%\" then \"Wanita\"\r\nelse \"Pria\" end)\r\nas data',NULL,NULL,0,NULL,'2019-01-23 07:01:26'),
(2026,'dgn. Almarhum / Almarhumah','data_sql',NULL,NULL,NULL,NULL,'select\r\n(case when \"#1025#\" like \"%binti%\" then \"Almarhumah\"\r\nelse \"Almarhum\" end)\r\nas data',NULL,NULL,0,NULL,'2019-01-23 07:01:26'),
(2027,'Pria / Wanita (#0046# II)','data_sql',NULL,NULL,NULL,NULL,'select\r\n(case when \"#1033#\" like \"%binti%\" or \"#0102#\" like \"%binti%\" \r\nthen \"Wanita\"\r\nelse \"Pria\" end)\r\nas data',NULL,NULL,0,NULL,'2019-01-23 07:01:26'),
(2028,'Status #2026# sblm nikah','data_teks',NULL,NULL,NULL,NULL,NULL,'bujang\r\nduda cerai\r\nduda mati\r\n\r\ngadis\r\njanda cerai\r\njanda mati',NULL,0,NULL,'2018-08-02 03:26:10'),
(2029,'Status Anak Pria (DK)','data_teks',NULL,NULL,NULL,NULL,NULL,'bujang\r\nduda cerai\r\nduda mati',NULL,0,NULL,'2018-08-02 07:16:27'),
(2030,'Status Anak Wanita (DK)','data_teks',NULL,NULL,NULL,NULL,NULL,'gadis\r\njanda cerai\r\njanda mati',NULL,0,NULL,'2018-08-02 07:16:35'),
(2031,'Keterangan Saksi 3 P','tanya_jawab',NULL,NULL,NULL,6132,NULL,NULL,'keterangan',1,NULL,'2019-08-08 20:05:09'),
(2032,'Keterangan Saksi 3 T','tanya_jawab',NULL,NULL,NULL,6138,NULL,NULL,'keterangan',1,NULL,'2019-08-08 20:05:10'),
(2040,'Jika tiada Bukti Surat HAPUS ini',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(2041,'Saksi 1 P - bersumpah/berjanji','data_sql',NULL,NULL,NULL,NULL,'select (case when \"#1199#\" = \"Protestan\" or \"#1199#\" = \"Katolik\" then \"berjanji\"\r\nelse \"bersumpah\" end) as data',NULL,NULL,1,NULL,'2019-08-08 20:05:14'),
(2042,'Saksi 2 P - bersumpah/berjanji','data_sql',NULL,NULL,NULL,NULL,'select (case when \"#1205#\" = \"Protestan\" or \"#1205#\" = \"Katolik\" then \"berjanji\"\r\nelse \"bersumpah\" end) as data',NULL,NULL,1,NULL,'2019-08-08 20:05:15'),
(2043,'Saksi 1 T - bersumpah/berjanji','data_sql',NULL,NULL,NULL,NULL,'select (case when \"#6102#\" = \"Protestan\" or \"#6102#\" = \"Katolik\" then \"berjanji\"\r\nelse \"bersumpah\" end) as data',NULL,NULL,1,NULL,'2019-08-08 20:05:16'),
(2044,'Saksi 2 T - bersumpah/berjanji','data_sql',NULL,NULL,NULL,NULL,'select (case when \"#6108#\" = \"Protestan\" or \"#6108#\" = \"Katolik\" then \"berjanji\"\r\nelse \"bersumpah\" end) as data',NULL,NULL,1,NULL,'2019-08-08 20:05:17'),
(2050,'Terbilang Biaya Ikrar','terbilang',NULL,NULL,NULL,1101,NULL,NULL,NULL,0,NULL,'2019-05-12 04:14:17'),
(2063,'Amar Pen. Ikrar Talak','data_sipp','perkara_ikrar_talak','amar_ikrar_talak',NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-01-01 04:00:00'),
(2098,'Hari Sidang PHS Awal','tanggal_hari',NULL,NULL,NULL,1137,NULL,NULL,NULL,1,NULL,'2019-08-08 20:05:26'),
(2099,'Hari Sidang PHS Baru','tanggal_hari',NULL,NULL,NULL,1138,NULL,NULL,NULL,1,NULL,'2019-08-08 20:05:28'),
(2102,'Hari Relaas Ikrar Talak #0046#','tanggal_hari',NULL,NULL,NULL,1079,NULL,NULL,NULL,1,NULL,'2019-08-08 20:05:29'),
(2103,'Hari Relaas Ikrar Talak #0047#','tanggal_hari',NULL,NULL,NULL,1080,NULL,NULL,NULL,1,NULL,'2019-08-08 20:05:30'),
(2110,'Zona Waktu','data_sql',NULL,NULL,NULL,NULL,'select value as data from sys_config\r\nwhere name=\"ZonaWaktu\"',NULL,NULL,1,NULL,'2019-08-08 20:05:49'),
(2173,'Warga Negara #0047#','data_sql',NULL,NULL,NULL,NULL,'select c.nama as data\r\nfrom perkara_pihak2 a\r\njoin pihak b on a.pihak_id=b.id\r\njoin negara c on b.warga_negara_id=c.id\r\nwhere a.urutan=1 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 20:05:56'),
(3001,'Tgl. Akta Pernyataan Perm. Kasasi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(3011,'Agama Pembanding','data_sql',NULL,NULL,NULL,NULL,'select c.nama as data\r\nfrom perkara_banding_detil a\r\njoin pihak b on a.pihak_id=b.id\r\njoin agama c on b.agama_id=c.id\r\nwhere a.status_pihak_id=1 and a.urutan_banding=1 and a.perkara_id=#perkara_id#',NULL,NULL,0,NULL,'2019-05-16 01:57:43'),
(3021,'Pendidikan Pembanding','data_sql',NULL,NULL,NULL,NULL,'select c.kode as data from perkara_banding_detil a\r\njoin pihak b on a.pihak_id=b.id\r\njoin tingkat_pendidikan c on b.pendidikan_id=c.id\r\nwhere a.status_pihak_id=1 and a.urutan_banding=1 and a.perkara_id=#perkara_id#',NULL,NULL,0,NULL,'2019-05-16 01:57:57'),
(3046,'Dahulu Pembanding sebagai','data_sql',NULL,NULL,NULL,NULL,'select status_pihak_text as data from perkara_banding_detil where \r\nstatus_pihak_id=1 and urutan_banding=1 and perkara_id=#perkara_id#','select status_pihak_text as data from perkara_banding_detil where \r\nstatus_pihak_id=1 and urutan_banding=1 and perkara_id=#perkara_id#',NULL,0,NULL,'2019-05-16 02:02:34'),
(3047,'Terbanding / Termohon Kasasi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(3098,'Nama Pembanding','data_sql',NULL,NULL,NULL,NULL,'select pihak_nama as data from perkara_banding_detil where \r\nstatus_pihak_id=1 and urutan_banding=1 and perkara_id=#perkara_id#',NULL,NULL,0,NULL,'2019-05-16 01:58:18'),
(3100,'Pekerjaan Pembanding','data_sql',NULL,NULL,NULL,NULL,'select b.pekerjaan as data\r\nfrom perkara_banding_detil a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere a.status_pihak_id=1 and a.urutan_banding=1 and a.perkara_id=#perkara_id#',NULL,NULL,0,NULL,'2019-05-16 01:58:29'),
(3101,'Alamat Pembanding','data_sql',NULL,NULL,NULL,NULL,'select pemohon_alamat as data from perkara_banding_detil where \r\nstatus_pihak_id=1 and urutan_banding=1 and perkara_id=270',NULL,NULL,0,NULL,'2019-05-16 02:11:46'),
(3335,'No. NIK Pembanding','data_sql',NULL,NULL,NULL,NULL,'select b.nomor_indentitas as data from perkara_banding_detil a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere a.status_pihak_id=1 and a.urutan_banding=1 and a.perkara_id=#perkara_id#',NULL,NULL,0,NULL,'2019-05-16 02:09:58'),
(3341,'Tempat Lahir Pembanding','data_sql',NULL,NULL,NULL,NULL,'select b.tempat_lahir as data\r\nfrom perkara_banding_detil a join pihak b on a.pihak_id=b.id\r\nwhere a.status_pihak_id=1 and a.urutan_banding=1 and a.perkara_id=#perkara_id#',NULL,NULL,0,NULL,'2019-05-16 01:58:49'),
(3345,'Tgl. Lahir Pembanding','data_sql',NULL,NULL,NULL,NULL,'select b.tanggal_lahir as data\r\nfrom perkara_banding_detil a join pihak b on a.pihak_id=b.id\r\nwhere a.status_pihak_id=1 and a.urutan_banding=1 and a.perkara_id=#perkara_id#',NULL,NULL,0,NULL,'2019-05-16 01:58:57'),
(3502,'No.Surat Ket.Desa ttg Hub.Nasab',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(3503,'Tgl.Surat Ket.Desa ttg Hub.Nasab',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(3504,'Tanggal & Nomor SK Jurusita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(3505,'Lurah / Kades #0046#','data_sql',NULL,NULL,NULL,NULL,'select replace(replace(\"#5214#\",\"Kelurahan\",\"Lurah\"),\"Desa\",\"Kepala Desa\") data',NULL,NULL,0,NULL,'2019-01-23 07:01:26'),
(3506,'Lurah / Kades #0047#','data_sql',NULL,NULL,NULL,NULL,'select replace(replace(\"#5220#\",\"Kelurahan\",\"Lurah\"),\"Desa\",\"Kepala Desa\") data',NULL,NULL,0,NULL,'2019-01-23 07:01:26'),
(4046,'#0046# dan Kuasanya','data_sql',NULL,NULL,NULL,NULL,'select (case\r\n\r\nwhen \"#0106#\"!=\"\" and \"#1033#\"!=\"\" then\r\n\"Para #0046# dan Kuasanya\"\r\n\r\nwhen \"#0106#\"!=\"\" then\r\n\"#0046# dan Kuasanya\"\r\n\r\nwhen \"#1033#\"!=\"\" then\r\n\"Para #0046#\"\r\n\r\nelse\r\n\"#0046#\"\r\n\r\nend) as data',NULL,NULL,0,NULL,'2019-01-23 07:01:26'),
(4047,'#0047# dan Kuasanya','data_sql',NULL,NULL,NULL,NULL,'select (case\r\n\r\nwhen \"#0170#\"=\"\" then\r\n\"#0047#\"\r\n\r\nelse\r\n\"#0047# dan Kuasanya\"\r\n\r\nend) data',NULL,NULL,0,NULL,'2019-01-23 07:01:26'),
(4048,'Nama #0046# (tanpa bin)','data_sql',NULL,NULL,NULL,NULL,'select SUBSTRING_INDEX(SUBSTRING_INDEX(\"#0098#\", \" bin \", 1), \" binti \", 1) data',NULL,NULL,0,NULL,'2019-06-19 06:35:44'),
(4049,'Nama #0046# II (tanpa bin)','data_sql',NULL,NULL,NULL,NULL,'select SUBSTRING_INDEX(SUBSTRING_INDEX(\"#1033#\", \" bin \", 1), \" binti \", 1) data',NULL,NULL,0,NULL,'2019-06-19 06:35:44'),
(4050,'Nama #0047# (tanpa bin)','data_sql',NULL,NULL,NULL,NULL,'select SUBSTRING_INDEX(SUBSTRING_INDEX(\"#0102#\", \" bin \", 1), \" binti \", 1) data',NULL,NULL,0,NULL,'2019-06-19 06:35:44'),
(5001,'Sebutan Perangkat Desa',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5002,'Pekerjaan suami/ayah',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5003,'Tgl meninggal suami/ayah',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5004,'Sebab meninggal (karena ...)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5005,'Ternyata pernikahan tsb ....',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5007,'\"Ayat-ayat Al-Qur\'an, Hadist & Kitab lain\"',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5008,'\"Ayat-ayat Al-Qur\'an, Hadist & Kitab lain (2)\"',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5009,'Tempat menikah',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5010,'Wujud/perilaku gila',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5011,'Tempat pengobatan non paramedis',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5012,'Kenyataan bahwa Ter adalah ...',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5013,'Karena Ter adalah ....',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5014,'Pengucapan ijab',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5015,'Tgl meninggal isteri/ibu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5016,'Sebab meninggal isteri/ibu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5017,'Tanda bukti (PI dst..)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5018,'Diperintahkan kepada',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5019,'Pendidikan #0047# II','data_sql',NULL,NULL,NULL,NULL,'select c.kode as data from perkara_pihak2 a\r\njoin pihak b on a.pihak_id=b.id\r\njoin tingkat_pendidikan c on b.pendidikan_id=c.id\r\nwhere urutan=2 and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 20:06:43'),
(5020,'Tgl Penetapan coret',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5021,'Tgl Pemberitahuan coret','data_tanggal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-03-20 01:18:21'),
(5023,'KUA Nikah Ter. II',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5024,'Tgl Nikah Ter. II',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5025,'Nomor Nikah Ter. II',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5026,'Nama #0047# II','data_sipp','perkara_pihak2','nama',2,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 20:06:54'),
(5027,'Umur #0047# II','data_sql',NULL,NULL,NULL,NULL,'select (get_umur(b.tanggal_lahir,c.tanggal_pendaftaran))as data\r\nfrom perkara_pihak2 a\r\njoin pihak b on a.pihak_id=b.id\r\njoin perkara c on a.perkara_id=c.perkara_id\r\nwhere a.urutan=2 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-09 06:02:27'),
(5028,'Pekerjaan #0047# II','data_sql',NULL,NULL,NULL,NULL,'select b.pekerjaan as data\r\nfrom perkara_pihak2 a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere a.urutan=2 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 20:06:57'),
(5029,'Alamat #0047# II','data_sipp','perkara_pihak2','alamat ',2,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 20:06:58'),
(5030,'Pembayaran Pemohon dlm ikrar',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5031,'Barang-barang bawaan Penggugat',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5032,'Harta bersama/gono-gini',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5033,'Harta bersama/gono-gini 2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5034,'Keterangan harta bawaan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5035,'Al Baqarah : 227',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5036,'Al Baqarah : 229',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5038,'Ghoyatul Marom',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5040,'Al Anwar II : 422',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5047,'Asybah wan Nadhaair',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5048,'TanyaJwb Saksi 1 T (F9)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5049,'TanyaJwb Saksi 2 T (F9)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5053,'Hadist Rasulullah SAW',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5054,'Kifayatul Ahkyar III : 36',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5055,'Perincian nafkah',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5056,'Posita nafkah I',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5057,'Posita nafkah II',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5058,'TanyaJwb Saksi 1 P','tanya_jawab',NULL,NULL,NULL,1197,NULL,NULL,'tanyajawab',1,NULL,'2019-08-08 20:07:04'),
(5059,'TanyaJwb Saksi 2 P','tanya_jawab',NULL,NULL,NULL,1203,NULL,NULL,'tanyajawab',1,NULL,'2019-08-08 20:07:05'),
(5060,'TanyaJwb Saksi 3 P','tanya_jawab',NULL,NULL,NULL,6132,NULL,NULL,'tanyajawab',1,NULL,'2019-08-08 20:07:06'),
(5061,'Pertanyaan kepada keluarga T.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5062,'Surat jawaban...(sudah/belum)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5063,'Tertanggal cap pos ...',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5064,'Biaya panggilan ... (telah)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5065,'Tanggal pengiriman surat yl',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5066,'Tgl Sidang Sita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5067,'Bukti permohonan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5068,'Posita gono-gini KE 4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5069,'Posita gono-gini KE 5',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5070,'Posita gono-gini KE 6',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5071,'Identitas Pe secara vertikal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5072,'Nama Pe secara vertikal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5073,'Nama Ter secara vertikal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5074,'Identitas para Pe',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5075,'Identitas para Ter',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5076,'Tahun AC',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5077,'Tgl. Pengembalian Buku Nikah ke Pihak',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5100,'PANITERA / PP','data_sql',NULL,NULL,NULL,NULL,'select (case when \"#0015#\"=\"#8004#\" then \"PANITERA\"\r\nelse \"PANITERA PENGGANTI\" end) as data',NULL,NULL,1,NULL,'2019-08-08 20:07:12'),
(5101,'JURUSITA / JSP','data_sql',NULL,NULL,NULL,NULL,'select\r\n(case when b.jabatan = 1 then \"JURUSITA\"\r\nelse \"JURUSITA PENGGANTI\" end) data\r\nfrom perkara_jurusita a\r\njoin jurusita b on a.jurusita_id=b.id\r\nwhere a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 20:07:13'),
(5105,'Alamat Tempat Menikah','data_teks',NULL,NULL,NULL,NULL,NULL,'Lingkungan _, Kelurahan _, Kecamatan _, Kabupaten ...\r\nDusun _, Desa _, Kecamatan _, Kabupaten ...\r\n#0101#',NULL,0,NULL,'2018-01-08 06:43:11'),
(5108,'suami / istri #0046#','data_sql',NULL,NULL,NULL,NULL,'select (case when jenis_perkara_id=346 then \"istri #0046#\"\r\nelse \"suami #0046#\" end) as data\r\nfrom perkara where perkara_id=#perkara_id#',NULL,NULL,0,NULL,'2019-01-23 07:01:26'),
(5109,'suami / istri #0047#','data_sql',NULL,NULL,NULL,NULL,'select (case when jenis_perkara_id=346 then \"suami #0047#\"\r\nelse \"istri #0047#\" end) as data\r\nfrom perkara where perkara_id=#perkara_id#',NULL,NULL,0,NULL,'2019-01-23 07:01:26'),
(5110,'Nama anak','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'iwan','2019-08-11 08:04:11'),
(5111,'Umur anak',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5112,'Pekerjaan anak',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5113,'Tempat tinggal anak',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5119,'MENGADILI / MENETAPKAN','data_sql',NULL,NULL,NULL,NULL,'select (case when alur_perkara_id=16 then \"MENETAPKAN:\"\r\nelse \"MENGADILI:\" end) as data\r\nfrom perkara where perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 20:07:30'),
(5120,'Mengadili/Menetapkan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5121,'Tanggal Perceraian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5123,'\"Pertanyaan Ketua (verstek),\"',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5124,'Letak rumah Ter',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5125,'POSITA LENGKAP','data_sipp','perkara','posita',NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 20:07:34'),
(5126,'Setelah Nikah, #0046# dan #0047#','data_teks',NULL,NULL,NULL,NULL,NULL,'tidak pernah tinggal bersama\r\ntinggal bersama di ..... selama .....\r\ntinggal bersama di ..... selama ..... dan terakhir tinggal bersama di ..... selama .....',NULL,0,NULL,'2018-03-26 01:06:51'),
(5127,'Alasan-Alasan Cerai Gugat ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5128,'Alasan-Alasan #0048#','data_teks',NULL,NULL,NULL,NULL,NULL,'Bahwa sejak semula pernikahan #0046# dengan #0047# dilaksanakan secara terpaksa karena ??;\r\nBahwa sejak semula pernikahan #0046# dengan #0047# bukan atas dasar saling mencintai melainkan hanya dijodohkan oleh orang tua kedua belah pihak;\r\nBahwa sejak semula pernikahan #0046# dengan #0047# tidak direstui oleh orang tua ?? sehingga ??;\r\nBahwa #0046# dengan #0047# hidup berjauhan sejak ?.... karena ?.... dan hanya biasa berkumpul ketemu ....... kali dalam......;\r\nBahwa pada ?? telah terjadi perselisihan antara Pernggugat dan #0047# karena ??;\r\nBahwa pada ?? terjadi kembali perselisihan antara #0046# dan #0047# karena ..?.;\r\nBahwa sejak ?? antara #0046# dan #0047# sering terjadi perselisihan karena ??;\r\nBahwa kemelut rumah tangga antara #0046# dan #0047# mulai muncul pada ....... karena ...?;\r\nBahwa #0047# sering mengucapkan kata-kata hinaan seperti ....... / mengucapkan kata-kata cerai / melakukan kekerasan pisik kepada #0046# ketika marah;\r\nBahwa puncak perselisihan / kemelut rumah tangga antara #0046# dan #0047# terjadi pada ?? karena ?? akibatnya ??;\r\nBahwa #0046# dengan #0047# tidak pernah dapat melakukan hubungan suami istri (qabladdukhul) karena ??;\r\nBahwa pada ??. #0047# pergi ke ?? untuk ?? namun sudah sekitar ??. tidak pernah ada kabar beritanya dan tidak diketahui lagi keberadaannya;\r\nBahwa pada ?.? #0047# pergi ke ?? untuk .?.. namun tidak pernah kembali lagi untuk hidup bersama dengan #0046#;\r\nBahwa #0047# telah pergi meninggalkan #0046# sejak ?? dan tidak pernah kembali lagi untuk hidup bersama dengan #0046#;\r\nBahwa #0046# telah meninggalkan #0047# sejak ?? karena ??;\r\nBahwa #0047# sudah tidak diketahui alamat keberadaannya oleh #0046#;\r\nBahwa #0046# dengan #0047# sudah tidak pernah satu ranjang selama ??;\r\nBahwa #0046# dengan #0047# sudah berpisah tempat tinggal selama ??;\r\nBahwa #0047# tidak pernah lagi datang mengunjungi #0046# sudah sekitar ?? tahun;\r\nBahwa antara #0046# dan #0047# sudah tidak pernah ada komunikasi selama ??;\r\nBahwa #0046# dengan #0047# sudah tidak saling mempedulikan selama ??.;\r\nBahwa #0046# dengan #0047# sudah pernah diupayakan untuk dirukunkan oleh ?? namun tidak berhasil;\r\nBahwa #0046# sudah berusaha mencari tahu keberadaan #0047# dengan ?? namun tidak berhasil;',NULL,0,NULL,'2018-11-05 00:54:14'),
(5130,'Tgl Penetapan Tegoran',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5131,'Tempo memanggil (....) hari',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5133,'Supaya ...... datang',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5134,'Tgl Panggilan Tegoran','data_tanggal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-15 15:47:06'),
(5135,'PUTUSAN/PENETAPAN','data_sql',NULL,NULL,NULL,NULL,'select (case when alur_perkara_id=16 then \"PENETAPAN\"\r\nelse \"PUTUSAN\" end) as data\r\nfrom perkara where perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 20:07:45'),
(5136,'Alasan verzet',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5137,'Sita ..... (konservaoir/eksekusi)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5138,'Barang di ... (tangan/kepunyaan)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5139,'Dihukum untuk ....',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5140,'Obyek Sengketa',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5141,'Yang ditunjuk untuk menyimpan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5142,'Yang membuat BAP penyitaan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5143,'Umur saksi sita I',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5144,'Umur saksi sita II',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5145,'Nama Kepala Desa/Lurah',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5146,'Biaya penyitaan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5147,'Uang harian Panitera/Jurusita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5148,'Upah saksi-saksi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5149,'Biaya jalan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5150,'Biaya keamanan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5151,'Biaya Sita Konservatoir',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5152,'Kepala BPN .......',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5153,'Umur Kepala Desa/Lurah',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5154,'Pekerjaan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5155,'Tempat tinggal KADES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5156,'Para Ter',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5157,'Kantor Lelang ......',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5158,'Nama Petugas kantor lelang',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5159,'Identitas penawar lelang tertinggi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5160,'Harga lelang tertinggi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5161,'terbilang harga lelang',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5162,'Pemberitahuan kpd Ka.BPN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5163,'Perintah Panitera/Jurusita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5164,'Tempat sengketa',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5165,'Obyek sengketa II',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5167,'Perjanjian Perkawinan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5168,'Status wali Pe',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5169,'Identitas wali jika bukan ayah Pe',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5170,'Status Pe thd wali',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5171,'Penghasilan #0046# Perbulan','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-04-05 08:49:00'),
(5172,'Nama lengkap wali pada petitum',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5174,'Ruang Sidang (PHS)','data_sql',NULL,NULL,NULL,NULL,'select (case\r\n\r\nwhen \"#0163#\" like \"%ruang sidang%\" then\r\n\"#0163# #8008#\"\r\n\r\nelse \"#0163#\"\r\n\r\nend) as data',NULL,NULL,1,NULL,'2019-08-08 20:07:54'),
(5176,'Nomor Buku Nikah','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-03-16 08:57:11'),
(5177,'Tanggal Buku Nikah','data_tanggal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-03-16 08:57:17'),
(5178,'KUA Kec.','data_teks',NULL,NULL,NULL,NULL,NULL,'Kantor Urusan Agama Kecamatan ... Kabupaten Majene',NULL,0,NULL,'2017-08-31 05:55:51'),
(5179,'Status Pengakuan Termohon I',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5180,'Tempat akan Dicatat Perubahan','data_teks',NULL,NULL,NULL,NULL,NULL,'Kantor Urusan Agama #1005#',NULL,0,NULL,'2018-02-21 03:38:05'),
(5182,'Posita 1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5183,'Posita 2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5184,'Posita XXX',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5185,'Posita 3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5186,'Posita 4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5187,'Posita 5',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5188,'Posita 6',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5189,'Posita 7',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5190,'Posita 8',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5191,'Posita 9',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5192,'Posita 10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5193,'Posita Batal Nikah 1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5194,'Posita Batal Nikah 2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5197,'Tgl Nikah','data_tanggal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-04-05 07:58:31'),
(5198,'Radius Pe',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5200,'Radius Ter',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5202,'Pasal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5204,'Pertimbangan Hukum',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5205,'Pertimbangn Bukti Surat IN Sidkl',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5206,'Alasan dibolehkan Itsbat Nikah',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5207,'Identitas Kuasa Pe secara vertikal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5208,'Rumusn Pokok Perkara IN 2 P',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5209,'Pertimbngan Bukti Surat IN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5210,'Pertimbngn Dasar Hukum IN ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5214,'Desa / Kelurahan #0046#','data_sql',NULL,NULL,NULL,NULL,'select (case \r\n\r\nwhen locate(\"Desa\",\"#0101#\")>0 then\r\nSUBSTRING_INDEX(SUBSTRING(\"#0101#\",position(\"Desa\" IN \"#0101#\")),\",\",1)\r\n\r\nwhen locate(\"Kelurahan\",\"#0101#\")>0 then\r\nSUBSTRING_INDEX(SUBSTRING(\"#0101#\",position(\"Kelurahan\" IN \"#0101#\")),\",\",1)\r\n\r\nend)data',NULL,NULL,0,NULL,'2019-01-23 07:01:26'),
(5215,'Kecamatan #0046#','data_sql',NULL,NULL,NULL,NULL,'select SUBSTRING_INDEX(SUBSTRING_INDEX(\"#0101#\",\",\",3),\",\",-1) data',NULL,NULL,0,NULL,'2019-01-23 07:01:26'),
(5216,'Kota / Kabupaten #0046#','data_sql',NULL,NULL,NULL,NULL,'select SUBSTRING_INDEX(SUBSTRING_INDEX(\"#0101#\",\",\",4),\",\",-1) data',NULL,NULL,0,NULL,'2019-01-23 07:01:26'),
(5220,'Desa / Kelurahan #0047#','data_sql',NULL,NULL,NULL,NULL,'select (case \r\n\r\nwhen locate(\"Desa\",\"#0105#\")>0 then\r\nSUBSTRING_INDEX(SUBSTRING(\"#0105#\",position(\"Desa\" IN \"#0105#\")),\",\",1)\r\n\r\nwhen locate(\"Kelurahan\",\"#0105#\")>0 then\r\nSUBSTRING_INDEX(SUBSTRING(\"#0105#\",position(\"Kelurahan\" IN \"#0105#\")),\",\",1)\r\n\r\nend)data',NULL,NULL,0,NULL,'2019-01-23 07:01:26'),
(5221,'Kecamatan #0047#','data_sql',NULL,NULL,NULL,NULL,'select SUBSTRING_INDEX(SUBSTRING_INDEX(\"#0105#\",\",\",3),\",\",-1) data',NULL,NULL,0,NULL,'2019-01-23 07:01:26'),
(5222,'Kota / Kabupaten #0047#','data_sql',NULL,NULL,NULL,NULL,'select SUBSTRING_INDEX(SUBSTRING_INDEX(\"#0105#\",\",\",4),\",\",-1) data',NULL,NULL,0,NULL,'2019-01-23 07:01:26'),
(5223,'Biaya Meterai','data_sql',NULL,NULL,NULL,NULL,'select \"6000.00\"as data',NULL,NULL,0,NULL,'2019-01-23 07:01:26'),
(5224,'Jumlah biaya meterai & penetapan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5225,'Iwadl',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5226,'Terbilang Iwadl',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5230,'Ongkos Panggilan Permintaan Bantuan','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-01-30 02:52:35'),
(5231,'Pertimbangan adanya mutasi ......',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5232,'Jumlah Buku Nikah/Duplikat',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5233,'Hijriyah Tgl. Cerai',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5234,'Nama sebenarnya',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5235,'Surat Keterangan Desa',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5236,'No. Surat Ket. Tidak Mampu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5237,'KUA tempat tinggal <<0046',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5238,'KUA tempat tinggal <<0047',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5239,'Keterangan perkawinan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5240,'Sebutan status Pe',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5241,'Sebutan status Ter',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5242,'Tanggal panjar biaya perkara','data_sql',NULL,NULL,NULL,NULL,'select tanggal_transaksi as data from perkara_biaya\r\nwhere jenis_biaya_id=1 and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 20:08:26'),
(5243,'Tanggal PSP',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(5368,'Putusan / Penetapan','data_sql',NULL,NULL,NULL,NULL,'select (case when alur_perkara_id=16 then \"Penetapan\"\r\nelse \"Putusan\" end) as data\r\nfrom perkara where perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 20:08:24'),
(5369,'Jenis Putusan Teks','data_sql',NULL,NULL,NULL,NULL,'select nama as data from perkara_putusan a\r\njoin status_putusan b on a.status_putusan_id=b.id\r\nwhere perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 20:08:31'),
(5401,'Jenis AC','data_sql',NULL,NULL,NULL,NULL,'select (case\r\n\r\nwhen \"#0048#\"=\"Cerai Talak\" \r\nthen \"raj’i\"\r\n\r\nwhen \"#0048#\"=\"Cerai Gugat\" and \"#0065#\" like \"%iwadl%\" \r\nthen \"khul’i\"\r\n\r\nelse \"ba’in sughro\"\r\n\r\nend) as data',NULL,NULL,1,NULL,'2019-08-08 20:08:34'),
(6004,'Semula P sebagai',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6005,'Semula T Sebagai',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6006,'Nomor surat pengantar',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6007,'Nomor surat pengantar memeriksa berkas',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6008,'Tanggal SP memeriksa berkas',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6009,'Tanggal pencabutan permohonan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6010,'Hari pencabutan permohonan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6011,'No Surat PBT Penyerahan Kontra',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6012,'Tgl PBT Penyerahan Kontra',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6013,'No SP PBT Penyerahan Memori',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6014,'Tgl SP PBT Penyerahan Memori',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6015,'Nomor Gugatan/Permohonan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6027,'Tahun pergi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6028,'Nama si Mafqud',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6029,'Alasan pergi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6030,'Hijriyah Tgl Nikah','tanggal_hijriah',NULL,NULL,NULL,1011,NULL,NULL,NULL,1,NULL,'2019-08-08 20:08:53'),
(6031,'Jurusita (JSP)','data_sql',NULL,NULL,NULL,NULL,'select \"#0018#\" as data',NULL,NULL,1,NULL,'2019-08-08 20:08:57'),
(6032,'Jurusita/Jurusita Pengganti','data_sql',NULL,NULL,NULL,NULL,'select\r\n(case when b.jabatan = 1 then \"Jurusita\"\r\nelse \"Jurusita Pengganti\" end) data\r\nfrom perkara_jurusita a\r\njoin jurusita b on a.jurusita_id=b.id\r\nwhere a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 20:08:59'),
(6033,'Panitera (PP)','data_sql',NULL,NULL,NULL,NULL,'select \"#0015#\" as data',NULL,NULL,1,NULL,'2019-08-08 20:09:00'),
(6034,'Panitera/Panitera Pengganti','data_sql',NULL,NULL,NULL,NULL,'select (case when \"#0015#\"=\"#8004#\" then \"Panitera\"\r\nelse \"Panitera Pengganti\" end) as data',NULL,NULL,1,NULL,'2019-08-08 20:09:01'),
(6035,'Saudara (i) PP','data_sql',NULL,NULL,NULL,NULL,'select (case when \r\n\r\n\"#0015#\" like \"%asmah%\" or \r\n\"#0015#\" like \"%nasriah%\" or \r\n\"#0015#\" like \"%thahirah%\" \r\n\r\nthen \"Saudari\"\r\nelse \"Saudara\" end)data',NULL,NULL,0,NULL,'2019-01-23 07:01:26'),
(6036,'Saudara (i) JSP','data_sql',NULL,NULL,NULL,NULL,'select (case when \r\n\r\n\"#0018#\" like \"%fahmiyan%\" \r\n\r\nthen \"Saudari\"\r\nelse \"Saudara\" end)data',NULL,NULL,0,NULL,'2019-01-23 07:01:26'),
(6037,'Saudara (i) Mediator','data_sql',NULL,NULL,NULL,NULL,'select (case\r\nwhen \"#0056#\" like \"%dewi%\"\r\nor \"#0056#\" like \"%wahyuni%\"\r\n\r\nthen \"Saudari\"\r\nelse \"Saudara\" end)data',NULL,NULL,0,NULL,'2019-05-27 03:35:03'),
(6054,'Nafkah iddah',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6055,'Mut\'ah',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6056,'Nafkah iddah (terbilang)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6057,'Mut\'ah (terbilang)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6058,'Pe & Ter pisah selama',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6059,'Melanggar taklik talak point',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6060,'Biaya Proses','data_sql',NULL,NULL,NULL,NULL,'select jumlah as data from perkara_biaya\r\nwhere jenis_biaya_id=155 and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 20:09:17'),
(6061,'Biaya Sumpah','data_sql',NULL,NULL,NULL,NULL,'select sum(jumlah) as data from perkara_biaya\r\nwhere kategori_id=9 and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 20:09:53'),
(6062,'Biaya Penerjemah','data_sql',NULL,NULL,NULL,NULL,'select sum(jumlah) as data from perkara_biaya\r\nwhere kategori_id=10 and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 20:09:54'),
(6063,'Biaya PNBP Panggilan Pertama','data_sql',NULL,NULL,NULL,NULL,'select sum(jumlah) as data from perkara_biaya\r\nwhere jenis_biaya_id=236 and perkara_id=#perkara_id#\r\nor jenis_biaya_id=237 and perkara_id=#perkara_id#\r\nor jenis_biaya_id=253 and perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 20:09:56'),
(6064,'Fakta di persidangan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6065,'Fakta Hukum',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6087,'Alasan Wali Nikah Menolak',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6088,'Alasan KUA menikahkan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6090,'Hari Sidang Sebelumnya','multi_sidang',NULL,NULL,NULL,NULL,NULL,NULL,'hari_sblmnya',1,NULL,'2019-08-08 20:09:59'),
(6091,'Tgl. Sidang Sebelumnya','multi_sidang',NULL,NULL,NULL,NULL,NULL,NULL,'tanggal_sblmnya',1,NULL,'2019-08-08 20:10:00'),
(6092,'alamat sekarang',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6094,'lamanya tidak memberi nafkah',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6095,'Penerimaan Negara Bukan Pajak',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6096,'Tanggal setor PNBP',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6097,'Terbilang PNBP',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6098,'Tanggal Panjar PNBP',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6099,'Calon Isteri',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6100,'Nama Saksi 1 T','data_sql',NULL,NULL,NULL,NULL,'select nama as data from perkara_pihak5\r\nwhere saksi_pihak_ke=2 and perkara_id=#perkara_id#\r\norder by urutan\r\nlimit 0,1',NULL,NULL,1,NULL,'2019-08-08 20:10:05'),
(6101,'Umur Saksi 1 T','data_sql',NULL,NULL,NULL,NULL,'select (get_umur(b.tanggal_lahir,a.diinput_tanggal))as data\r\nfrom perkara_pihak5 a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere a.saksi_pihak_ke=2 and a.perkara_id=#perkara_id#\r\norder by a.urutan\r\nlimit 0,1',NULL,NULL,1,NULL,'2019-08-08 20:10:06'),
(6102,'Agama Saksi 1 T','data_sql',NULL,NULL,NULL,NULL,'select c.nama as data\r\nfrom perkara_pihak5 a\r\njoin pihak b on a.pihak_id=b.id\r\njoin agama c on b.agama_id=c.id\r\nwhere a.saksi_pihak_ke=2 and a.perkara_id=#perkara_id#\r\norder by a.urutan\r\nlimit 0,1',NULL,NULL,1,NULL,'2019-08-08 20:10:07'),
(6103,'Pendidikan Saksi 1 T','data_sql',NULL,NULL,NULL,NULL,'select c.kode as data from perkara_pihak5 a\r\njoin pihak b on a.pihak_id=b.id\r\njoin tingkat_pendidikan c on b.pendidikan_id=c.id\r\nwhere a.saksi_pihak_ke=2 and a.perkara_id=#perkara_id#\r\norder by a.urutan\r\nlimit 0,1',NULL,NULL,1,NULL,'2019-08-08 20:10:08'),
(6104,'Pekerjaan Saksi 1 T','data_sql',NULL,NULL,NULL,NULL,'select b.pekerjaan as data\r\nfrom perkara_pihak5 a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere a.saksi_pihak_ke=2 and a.perkara_id=#perkara_id#\r\norder by a.urutan\r\nlimit 0,1',NULL,NULL,1,NULL,'2019-08-08 20:10:09'),
(6105,'Alamat Saksi 1 T','data_sql',NULL,NULL,NULL,NULL,'select alamat as data from perkara_pihak5\r\nwhere saksi_pihak_ke=2 and perkara_id=#perkara_id#\r\norder by urutan\r\nlimit 0,1',NULL,NULL,1,NULL,'2019-08-08 20:10:09'),
(6106,'Nama Saksi 2 T','data_sql',NULL,NULL,NULL,NULL,'select nama as data from perkara_pihak5\r\nwhere saksi_pihak_ke=2 and perkara_id=#perkara_id#\r\norder by urutan\r\nlimit 1,1',NULL,NULL,1,NULL,'2019-08-08 20:10:10'),
(6107,'Umur Saksi 2 T','data_sql',NULL,NULL,NULL,NULL,'select (get_umur(b.tanggal_lahir,a.diinput_tanggal))as data\r\nfrom perkara_pihak5 a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere a.saksi_pihak_ke=2 and a.perkara_id=#perkara_id#\r\norder by a.urutan\r\nlimit 1,1',NULL,NULL,1,NULL,'2019-08-08 20:10:11'),
(6108,'Agama Saksi 2 T','data_sql',NULL,NULL,NULL,NULL,'select c.nama as data\r\nfrom perkara_pihak5 a\r\njoin pihak b on a.pihak_id=b.id\r\njoin agama c on b.agama_id=c.id\r\nwhere a.saksi_pihak_ke=2 and a.perkara_id=#perkara_id#\r\norder by a.urutan\r\nlimit 1,1',NULL,NULL,1,NULL,'2019-08-08 20:10:12'),
(6109,'Pendidikan Saksi 2 T','data_sql',NULL,NULL,NULL,NULL,'select c.kode as data from perkara_pihak5 a\r\njoin pihak b on a.pihak_id=b.id\r\njoin tingkat_pendidikan c on b.pendidikan_id=c.id\r\nwhere a.saksi_pihak_ke=2 and a.perkara_id=#perkara_id#\r\norder by a.urutan\r\nlimit 1,1',NULL,NULL,1,NULL,'2019-08-08 20:10:12'),
(6110,'Pekerjaan Saksi 2 T','data_sql',NULL,NULL,NULL,NULL,'select b.pekerjaan as data\r\nfrom perkara_pihak5 a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere a.saksi_pihak_ke=2 and a.perkara_id=#perkara_id#\r\norder by a.urutan\r\nlimit 1,1',NULL,NULL,1,NULL,'2019-08-08 20:10:13'),
(6111,'Alamat Saksi 2 T','data_sql',NULL,NULL,NULL,NULL,'select alamat as data from perkara_pihak5\r\nwhere saksi_pihak_ke=2 and perkara_id=#perkara_id#\r\norder by urutan\r\nlimit 1,1',NULL,NULL,1,NULL,'2019-08-08 20:10:15'),
(6112,'Jawaban Lisan #0047#','tanya_jawab',NULL,NULL,NULL,0102,NULL,NULL,'tanyajawab',1,NULL,'2019-08-08 20:10:16'),
(6113,'Replik Lisan #0046#','tanya_jawab',NULL,NULL,NULL,0098,NULL,NULL,'tanyajawab',1,NULL,'2019-08-08 20:10:17'),
(6114,'Duplik Lisan #0047#','tanya_jawab',NULL,NULL,NULL,0102,NULL,NULL,'tanyajawab',1,NULL,'2019-08-08 20:10:18'),
(6117,'Tanya kpd. Anak Pemohon - DK (F9)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6118,'Tanya P kpd. Saksi1 P (F8)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6119,'Tanya P kpd. Saksi2 P (F8)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6120,'TanyaJwb Saksi 1 T','tanya_jawab',NULL,NULL,NULL,6100,NULL,NULL,'tanyajawab',1,NULL,'2019-08-08 20:10:34'),
(6121,'TanyaJwb Saksi 2 T','tanya_jawab',NULL,NULL,NULL,6106,NULL,NULL,'tanyajawab',1,NULL,'2019-08-08 20:10:35'),
(6122,'TanyaJwb Saksi 3 T','tanya_jawab',NULL,NULL,NULL,6138,NULL,NULL,'tanyajawab',1,NULL,'2019-08-08 20:10:36'),
(6123,'Tanya kpd. Anak Pemohon 2 - DK (F9)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6125,'Tanya kpd. Anak P (Perempuan) (F7)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6126,'TanyaJwb Saksi1 P (F8)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6127,'TanyaJwb Saksi2 P (F8)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6128,'Tanya P kpd. Saksi1 (F9)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6129,'Tanya P kpd. Saksi2 (F9)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6130,'Tanya kpd. Ayah Anak (F6)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6131,'Tanya kpd. Ibu Anak (F7)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6132,'Nama Saksi 3 P','data_sql',NULL,NULL,NULL,NULL,'select nama as data from perkara_pihak5\r\nwhere saksi_pihak_ke=1 and perkara_id=#perkara_id#\r\norder by urutan\r\nlimit 2,1',NULL,NULL,1,NULL,'2019-08-08 20:10:41'),
(6133,'Umur Saksi 3 P','data_sql',NULL,NULL,NULL,NULL,'select (get_umur(b.tanggal_lahir,a.diinput_tanggal))as data\r\nfrom perkara_pihak5 a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere a.saksi_pihak_ke=1 and a.perkara_id=#perkara_id#\r\norder by a.urutan\r\nlimit 2,1',NULL,NULL,1,NULL,'2019-08-08 20:10:42'),
(6134,'Agama Saksi 3 P','data_sql',NULL,NULL,NULL,NULL,'select c.nama as data\r\nfrom perkara_pihak5 a\r\njoin pihak b on a.pihak_id=b.id\r\njoin agama c on b.agama_id=c.id\r\nwhere a.saksi_pihak_ke=1 and a.perkara_id=#perkara_id#\r\norder by a.urutan\r\nlimit 2,1',NULL,NULL,1,NULL,'2019-08-08 20:10:43'),
(6135,'Pendidikan Saksi 3 P','data_sql',NULL,NULL,NULL,NULL,'select c.kode as data from perkara_pihak5 a\r\njoin pihak b on a.pihak_id=b.id\r\njoin tingkat_pendidikan c on b.pendidikan_id=c.id\r\nwhere a.saksi_pihak_ke=1 and a.perkara_id=#perkara_id#\r\norder by a.urutan\r\nlimit 2,1',NULL,NULL,1,NULL,'2019-08-08 20:10:43'),
(6136,'Pekerjaan Saksi 3 P','data_sql',NULL,NULL,NULL,NULL,'select b.pekerjaan as data\r\nfrom perkara_pihak5 a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere a.saksi_pihak_ke=1 and a.perkara_id=#perkara_id#\r\norder by a.urutan\r\nlimit 2,1',NULL,NULL,1,NULL,'2019-08-08 20:10:44'),
(6137,'Alamat Saksi 3 P','data_sql',NULL,NULL,NULL,NULL,'select alamat as data from perkara_pihak5\r\nwhere saksi_pihak_ke=1 and perkara_id=#perkara_id#\r\norder by urutan\r\nlimit 2,1',NULL,NULL,1,NULL,'2019-08-08 20:10:45'),
(6138,'Nama Saksi 3 T','data_sql',NULL,NULL,NULL,NULL,'select nama as data from perkara_pihak5\r\nwhere saksi_pihak_ke=2 and perkara_id=#perkara_id#\r\norder by urutan\r\nlimit 2,1',NULL,NULL,1,NULL,'2019-08-08 20:10:46'),
(6139,'Umur Saksi 3 T','data_sql',NULL,NULL,NULL,NULL,'select (get_umur(b.tanggal_lahir,a.diinput_tanggal))as data\r\nfrom perkara_pihak5 a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere a.saksi_pihak_ke=2 and a.perkara_id=#perkara_id#\r\norder by a.urutan\r\nlimit 2,1',NULL,NULL,1,NULL,'2019-08-08 20:10:47'),
(6140,'Agama Saksi 3 T','data_sql',NULL,NULL,NULL,NULL,'select c.nama as data\r\nfrom perkara_pihak5 a\r\njoin pihak b on a.pihak_id=b.id\r\njoin agama c on b.agama_id=c.id\r\nwhere a.saksi_pihak_ke=2 and a.perkara_id=#perkara_id#\r\norder by a.urutan\r\nlimit 2,1',NULL,NULL,1,NULL,'2019-08-08 20:10:48'),
(6141,'Pendidikan Saksi 3 T','data_sql',NULL,NULL,NULL,NULL,'select c.kode as data from perkara_pihak5 a\r\njoin pihak b on a.pihak_id=b.id\r\njoin tingkat_pendidikan c on b.pendidikan_id=c.id\r\nwhere a.saksi_pihak_ke=2 and a.perkara_id=#perkara_id#\r\norder by a.urutan\r\nlimit 2,1',NULL,NULL,1,NULL,'2019-08-08 20:10:49'),
(6142,'Pekerjaan Saksi 3 T','data_sql',NULL,NULL,NULL,NULL,'select b.pekerjaan as data\r\nfrom perkara_pihak5 a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere a.saksi_pihak_ke=2 and a.perkara_id=#perkara_id#\r\norder by a.urutan\r\nlimit 2,1',NULL,NULL,1,NULL,'2019-08-08 20:10:49'),
(6143,'Alamat Saksi 3 T','data_sql',NULL,NULL,NULL,NULL,'select alamat as data from perkara_pihak5\r\nwhere saksi_pihak_ke=2 and perkara_id=#perkara_id#\r\norder by urutan\r\nlimit 2,1',NULL,NULL,1,NULL,'2019-08-08 20:10:50'),
(6200,'Tanya P kpd. Saksi1 T (F8)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6201,'Tanya P kpd. Saksi2 T (F8)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6202,'Tanya T kpd. Saksi1 P (F9)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6203,'Tanya T kpd. Saksi2 P (F9)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6204,'Tanya T kpd. Saksi1 T (F9)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6205,'Tanya T kpd. Saksi2 T (F9)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(6220,'Data Yang Diubah','data_teks',NULL,NULL,NULL,NULL,NULL,'-... tertulis... sebenarnya adalah ..\r\n-...',NULL,0,NULL,'2019-05-16 04:42:39'),
(7000,'Nama Kejaksaan Perkara Jinayat','data_sql',NULL,NULL,NULL,NULL,'select b.kejaksaan as data from perkara_pihak1 a\r\njoin pihak_jaksa b on a.pihak_id=b.pihak_id\r\nwhere a.urutan=1 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 20:11:30'),
(7001,'Tgl. Surat Perkara','data_sipp','perkara','tanggal_surat',NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 20:11:12'),
(7002,'No. Surat Perkara','data_sipp','perkara','nomor_surat',NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 20:11:26'),
(7003,'NIP. Jaksa Penuntut Umum','data_sql',NULL,NULL,NULL,NULL,'select b.NIP as data from perkara_pihak1 a\r\njoin pihak_jaksa b on a.pihak_id=b.pihak_id\r\nwhere a.urutan=1 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 20:11:40'),
(7004,'Jabatan Jaksa Penuntut Umum','data_sql',NULL,NULL,NULL,NULL,'select b.jabatan as data from perkara_pihak1 a\r\njoin pihak_jaksa b on a.pihak_id=b.pihak_id\r\nwhere a.urutan=1 and a.perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 20:11:41'),
(8000,'Nama Ketua PA','data_sql',NULL,NULL,NULL,NULL,'select value as data from sys_config\r\nwhere name=\"KetuaPNNama\"',NULL,NULL,1,NULL,'2019-08-08 20:11:44'),
(8001,'NIP Ketua PA','data_sql',NULL,NULL,NULL,NULL,'select value as data from sys_config\r\nwhere name=\"KetuaPNNIP\"',NULL,NULL,1,NULL,'2019-08-08 20:11:45'),
(8002,'Wakil Ketua PA','data_sql',NULL,NULL,NULL,NULL,'select value as data from sys_config\r\nwhere name=\"WakilKetuaPNNama\"',NULL,NULL,1,NULL,'2019-08-08 20:11:50'),
(8003,'NIP Wakil Ketua PA','data_sql',NULL,NULL,NULL,NULL,'select value as data from sys_config\r\nwhere name=\"WakilKetuaPNNIP\"',NULL,NULL,1,NULL,'2019-08-08 20:11:51'),
(8004,'Nama Panitera PA','data_sql',NULL,NULL,NULL,NULL,'select value as data from sys_config\r\nwhere name=\"PanSekNama\"',NULL,NULL,1,NULL,'2019-08-08 20:11:52'),
(8005,'NIP Panitera PA','data_sql',NULL,NULL,NULL,NULL,'select value as data from sys_config\r\nwhere name=\"PanSekNIP\"',NULL,NULL,1,NULL,'2019-08-08 20:11:53'),
(8006,'Jabatan Ketua/Wakil Ketua',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(8007,'Jabatan Pansek/Wapan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(8008,'Nama Satker','data_sql',NULL,NULL,NULL,NULL,'select value as data from sys_config\r\nwhere name=\"NamaPN\"',NULL,NULL,1,NULL,'2019-08-08 20:11:55'),
(8009,'Alamat Satker','data_sql',NULL,NULL,NULL,NULL,'select value as data from sys_config\r\nwhere name=\"AlamatPN\"',NULL,NULL,1,NULL,'2019-08-08 20:11:59'),
(8011,'Kota/Kabupaten Satker','data_sql',NULL,NULL,NULL,NULL,'select REPLACE(value,SUBSTRING_INDEX(value,\" \",2),\"\") as data from sys_config\r\nwhere name=\"NamaPN\"',NULL,NULL,1,NULL,'2019-08-08 20:12:04'),
(8012,'Tanggal Laporan Mediasi','data_sipp','perkara_mediasi','tgl_laporan_mediator',NULL,NULL,NULL,NULL,NULL,1,NULL,'2019-08-08 20:12:10'),
(8014,'Jumlah PSP',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(8015,'Terbilang Jumlah PSP',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(8016,'Hari Mediasi','tanggal_hari',NULL,NULL,NULL,8012,NULL,NULL,NULL,1,NULL,'2019-08-08 20:12:12'),
(8017,'Kesepakatan Mediator','data_sql',NULL,NULL,NULL,NULL,'select (\r\ncase when uraian=\"sepakat memilih Mediator\" then \"sepakat memilih #6037# #0056# sebagai mediator\"\r\nelse \"sepakat menyerahkan kepada majelis untuk menunjuk mediator\"\r\nend) data from perkara_data_dukung_mediasi\r\nwhere perkara_id=#perkara_id# limit 1',NULL,NULL,1,NULL,'2019-08-08 20:12:15'),
(8018,'Tgl. Penunjukan PP/JSP',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(8019,'Juru Sita/Juru Sita Pengganti',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(8020,'Tanggal PMH IT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(8021,'menunjuk/menetapkan mediator','data_sql',NULL,NULL,NULL,NULL,'select (\r\ncase when uraian=\"sepakat memilih Mediator\" then \"menetapkan mediator\"\r\nelse \"menunjuk mediator\"\r\nend) data from perkara_data_dukung_mediasi\r\nwhere perkara_id=#perkara_id# limit 1',NULL,NULL,1,NULL,'2019-08-08 20:12:18'),
(8022,'Uraian Mediator','data_sql',NULL,NULL,NULL,NULL,'select (\r\ncase when uraian=\"sepakat memilih Mediator\" then \"menetapkan mediator tersebut\"\r\nelse \"menunjuk #6037# #0056#, sebagai mediator\"\r\nend) data from perkara_data_dukung_mediasi\r\nwhere perkara_id=#perkara_id# limit 1',NULL,NULL,1,NULL,'2019-08-08 20:12:20'),
(8087,'Yang Menikahkan','data_teks',NULL,NULL,NULL,NULL,NULL,'Imam Dusun _\r\nImam Masjid _',NULL,0,NULL,'2018-01-05 10:02:46'),
(8131,'Alat Bukti Perwalian Anak',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(8132,'Alat Bukti PAW','data_teks',NULL,NULL,NULL,NULL,NULL,'1.Fotokopi Silsilah Keluarga yang dibuat oleh ... diketahui Lurah / Kepala Desa ... dan Camat ..., bermeterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya yang ternyata sesuai, lalu oleh Ketua Majelis diberi kode P1;\r\n2.Fotokopi Kartu Keluarga, Nomor ..., tanggal ..., yang dikeluarkan oleh Kepala Dinas Kependudukan dan Catatan Sipil Kabupaten ..., bermeterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya yang ternyata sesuai, lalu oleh Ketua Majelis diberi kode P2;\r\n3.Fotokopi Kutipan Akta Nikah dari Kantor Urusan Agama Kecamatan ..., Nomor.... Tanggal ..., bukti surat tersebut telah diberi meterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya yang ternyata sesuai, lalu oleh Ketua Majelis diberi kode P3;\r\n4.Fotokopi Kutipan Akta Kelahiran atas nama ... berdasarkan Akta Kelahiran Nomor ..., Tanggal ..., yang dikeluarkan Kepala Pejabat Pembuat Akte Catatan Sipil Kabupaten ..., bermeterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya yang ternyata sesuai, lalu oleh Ketua Majelis diberi kode P4;\r\n5.Fotokopi Surat Kematian an. #1025#, Nomor ..., tanggal ..., yang dikeluarkan oleh ..., bermeterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya yang ternyata sesuai, lalu oleh Ketua Majelis diberi kode P5;',NULL,0,NULL,'2019-05-16 04:43:26'),
(8134,'Alat Bukti Pengangkatan Anak',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(8135,'Bukti Surat Perubahan Data','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-03-27 02:32:07'),
(8136,'Bukti - bukti ...','data_sql',NULL,NULL,NULL,NULL,'select (case\r\n\r\nwhen \"#0315#\" like \"%P.2%\" then\r\n\"Bukti-bukti\"\r\n\r\nelse \"Bukti\"\r\n\r\nend) as data',NULL,NULL,0,NULL,'2019-01-23 07:01:26'),
(8146,'PEMOHON / PENGGUGAT','data_sql',NULL,NULL,NULL,NULL,'select (case when alur_perkara_id=16 or jenis_perkara_id=346 then \"PEMOHON\"\r\nelse \"PENGGUGAT\" end) as data\r\nfrom perkara where perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 20:12:34'),
(8147,'TERMOHON / TERGUGAT','data_sql',NULL,NULL,NULL,NULL,'select (case when alur_perkara_id=16 or jenis_perkara_id=346 then \"TERMOHON\"\r\nelse \"TERGUGAT\" end) as data\r\nfrom perkara where perkara_id=#perkara_id#',NULL,NULL,1,NULL,'2019-08-08 20:12:35'),
(8171,'Alasan Permohonan untuk','data_teks',NULL,NULL,NULL,NULL,NULL,'mengurus akta kelahiran anak #4046# serta keperluan lainnya\r\nkeperluan pengurusan administrasi K2 #0046# I dan keperluan lainnya\r\nmendapatkan tunjangan pensiunan Veteran RI serta keperluan lainnya\r\nmendapatkan tunjangan pensiunan janda Veteran RI serta keperluan lainnya\r\npengurusan hak-hak #2026# #1025# pada tabungan Bank ... serta keperluan lainnya\r\npenerbitan akta nikah #4046# serta keperluan lainnya',NULL,0,NULL,'2018-01-31 03:17:15'),
(8181,'Hari Nikah','tanggal_hari',NULL,NULL,NULL,5197,NULL,NULL,NULL,1,NULL,'2019-08-08 20:12:45'),
(8183,'Hijriyah Nikah','tanggal_hijriah',NULL,NULL,NULL,5197,NULL,NULL,NULL,1,NULL,'2019-08-08 20:12:47'),
(8184,'Hijriyah Tgl. Sidang',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(8426,'Nama Pelawan (DV)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(8427,'Umur Pelawan (DV)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(8428,'Agama Pelawan (DV)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(8429,'Pekerjaan Pelawan (DV)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(8430,'Pendidikan Pelawan (DV)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(8431,'Tempat Tinggal Pelawan (DV)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(8432,'Hasil Perdamaian Mediasi <<0046 dan <<0047',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(8433,'Alasan Cabut Perkara','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-20 12:35:03'),
(8437,'Kesimpulan oleh #0047#','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-03-09 08:50:26'),
(9001,'Hari Nikah Otomatis','tanggal_hari',NULL,NULL,NULL,1011,NULL,NULL,NULL,1,NULL,'2019-08-08 20:12:59'),
(9003,'Sidang Pertama / Lanjutan','data_sql',NULL,NULL,NULL,NULL,'select (case when #0050# = 1 then \"Sidang Pertama\" else \"Lanjutan\" end) data',NULL,NULL,1,NULL,'2019-08-08 20:13:13'),
(9007,'Kode Majelis A',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(9008,'Kode Majelis B',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(9009,'Kode Majelis C1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(9010,'Kode Majelis C2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(9011,'Kode Majelis C3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(9012,'Kode Majelis C4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(9013,'Kode Majelis C5',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(9014,'Kode Majelis C6',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(9015,'Kode Majelis C7',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(9016,'Kode Majelis C8',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(9017,'Kode Majelis C9',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(9018,'Panitera (tkn bawah utk daftar)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00'),
(9023,'Nama Yg Menikahkan','data_teks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-01-01 04:00:00'),
(9026,'Kode Majelis C10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2017-12-01 04:00:00');

/*Table structure for table `abt_variabel_tipe` */

DROP TABLE IF EXISTS `abt_variabel_tipe`;

CREATE TABLE `abt_variabel_tipe` (
  `id` int(2) NOT NULL,
  `nama` char(100) NOT NULL,
  `value` char(100) DEFAULT NULL,
  `modified` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `nama` (`nama`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `abt_variabel_tipe` */

insert  into `abt_variabel_tipe`(`id`,`nama`,`value`,`modified`) values 
(0,'- pilih tipe data -',NULL,'2019-08-05 12:41:59'),
(1,'Query MySql','data_sql','2019-08-05 12:41:59'),
(2,'Data SIPP','data_sipp','2019-08-05 12:41:59'),
(3,'Data Teks','data_teks','2019-08-05 12:41:59'),
(4,'Data Tanggal','data_tanggal','2019-08-05 12:41:59'),
(5,'Hari Tanggal','tanggal_hari','2019-08-05 12:41:59'),
(6,'Hijriah Tanggal','tanggal_hijriah','2019-08-05 12:41:59'),
(7,'Terbilang','terbilang','2019-08-05 12:41:59'),
(8,'Multi Sidang','multi_sidang','2019-08-05 12:41:59'),
(9,'Tanya Jawab','tanya_jawab','2019-08-05 12:41:59');

/*Table structure for table `keu_biaya` */

DROP TABLE IF EXISTS `keu_biaya`;

CREATE TABLE `keu_biaya` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary key: (by system)',
  `id_satker` varchar(11) DEFAULT NULL,
  `id_pendukung` int(11) DEFAULT NULL,
  `id_pembiayaan` tinyint(1) DEFAULT NULL COMMENT '1:reguler;2:Prodeo DIPA;3:Prodeo Murni',
  `perkara_id` bigint(20) unsigned DEFAULT NULL COMMENT 'Id Perkara: merujuk ke tabel perkara kolom perkara_id (by system)',
  `tahapan_id` int(11) unsigned DEFAULT NULL COMMENT 'Tahapan Proses : merujuk ke tabel tahapan_proses (by system)',
  `kategori_id` int(11) unsigned DEFAULT NULL COMMENT 'Kategori Biaya: merujuk ke tabel kategori_biaya kolom id',
  `jenis_biaya_id` int(11) unsigned DEFAULT NULL COMMENT 'Jenis Biaya: merujuk ke tabel jenis_biaya kolom id',
  `pihak_id` bigint(20) DEFAULT NULL COMMENT 'ID Pihak pembayar',
  `pihak_ke` int(11) DEFAULT NULL COMMENT 'Pihak Pembayar ke (1=Penggugat, 2=Tergugat)',
  `urutan` int(11) unsigned DEFAULT NULL,
  `jenis_transaksi` tinyint(1) NOT NULL COMMENT 'Jenis Transaksi: -1=Pengeluaran; 1=Penerimaan',
  `tanggal_transaksi` date NOT NULL COMMENT 'Tanggal Tansaksi: isian tanggal',
  `uraian` varchar(500) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL DEFAULT '' COMMENT 'Uraian Transaksi: isian bebas',
  `jumlah` decimal(16,2) unsigned NOT NULL COMMENT 'Jumlah nominal tansaksi(dalam Rp)',
  `sisa` decimal(16,2) unsigned DEFAULT NULL COMMENT 'Jumlah Nominal Sisa: isian bilangan (Rp)',
  `keterangan` varchar(500) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL COMMENT 'Keterangan: isian bebas',
  `diinput_oleh` varchar(30) DEFAULT NULL COMMENT 'Diinput Oleh: (by system)',
  `diinput_tanggal` datetime DEFAULT NULL COMMENT 'Diinput Tanggal: (by system)',
  PRIMARY KEY (`id`),
  KEY `perkara_id` (`perkara_id`),
  KEY `jenis_biaya_id` (`jenis_biaya_id`),
  KEY `jumlah` (`jumlah`),
  KEY `urutan` (`urutan`),
  KEY `tahapan_id` (`tahapan_id`),
  KEY `kategori_id` (`kategori_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='Data Biaya Perkara';

/*Data for the table `keu_biaya` */

/*Table structure for table `keu_config` */

DROP TABLE IF EXISTS `keu_config`;

CREATE TABLE `keu_config` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primari Key',
  `category` varchar(50) NOT NULL DEFAULT 'System' COMMENT 'Kategori Konfigurasi',
  `kd` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT 'Nama Konfigurasi',
  `value` varchar(255) DEFAULT NULL,
  `ordering` int(11) unsigned NOT NULL DEFAULT 0 COMMENT 'Urutan',
  `hidden` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=111 DEFAULT CHARSET=latin1 COMMENT='Data Konfigurasi Sistem';

/*Data for the table `keu_config` */

insert  into `keu_config`(`id`,`category`,`kd`,`name`,`value`,`ordering`,`hidden`) values 
(55,'posisi_saldo','saldo_uang_panggilan','Saldo Uang Panggilan','0',0,1),
(56,'posisi_saldo','saldo_uang_atk','Saldo Uang ATK','0',0,1),
(57,'posisi_saldo','saldo_uang_hhk','Saldo Uang HHK & HHKL','0',0,1),
(58,'posisi_saldo','saldo_uang_iwadl','Saldo Uang Iwadl','0',0,1),
(59,'posisi_saldo','saldo_uang_konsignasi','Saldo Uang Konsignasi','0',0,1),
(60,'posisi_saldo','saldo_uang_ekseksui','Saldo Uang Eksekusi','0',0,1),
(61,'posisi_saldo','saldo_uang_delegasi','Saldo Uang Delegasi','0',0,1),
(62,'posisi_saldo','tambah_panjar','Posisi Tambah Panjar','0',0,1),
(100,'System','kd_satker','Kode Satker','PA.Anda',0,0),
(101,'System','sys_version','System Versi','1.0',0,1),
(102,'System','kota','Kota','Kota Mana',0,0),
(103,'System','nm_kasir','Nama Kasir','-',0,0),
(104,'System','nip_kasir','NIP Kasir','-',0,0),
(106,'System','nm_bank','Nama Bank','-',0,0),
(107,'System','no_rek','No Rekening Giro','-',0,0),
(108,'System','folder_sipp','Nama Folder SIPP','SIPP',0,0),
(109,'System','url_kirim_pta','URL Kirim PTA','http://180.250.107.27/keuangan_pta_smg/',0,1),
(110,'System','url_server_update','URL Server Update','http://180.250.107.27/monitoring_aps/',0,1);

/*Table structure for table `keu_jenis_biaya_tambahan` */

DROP TABLE IF EXISTS `keu_jenis_biaya_tambahan`;

CREATE TABLE `keu_jenis_biaya_tambahan` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary key: (by system)',
  `kategori_id` int(11) unsigned NOT NULL COMMENT 'Kategori Biaya: merujuk ke tabel kategori kolom id',
  `tahapan_id` int(11) unsigned NOT NULL DEFAULT 99 COMMENT 'Biaya Proses Tingkat: 10=Tingkat Pertama; 20= Banding; 30=Kasasi; 40=PK; 50=Eksekusi; 99=All',
  `jenis_transaksi` tinyint(1) NOT NULL DEFAULT 1 COMMENT 'Jenis Transaksi: 1=Penerimaan; -1=Pengeluaran',
  `jenis_transaksi_bku` tinyint(1) DEFAULT 1,
  `kategori_debet_bku` varchar(10) DEFAULT '',
  `kategori_kredit_bku` varchar(10) DEFAULT '',
  `kategori_debet_buku_bantu` varchar(10) DEFAULT '',
  `nama` varchar(100) DEFAULT '' COMMENT 'Nama Jenis Biaya: isian bebas',
  `jumlah` decimal(16,2) unsigned NOT NULL DEFAULT 0.00 COMMENT 'Jumlah Nominal: (dalam rupiah)',
  `keterangan` varchar(500) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT '' COMMENT 'Keterangan: isian bebas',
  `aktif` char(1) NOT NULL DEFAULT 'Y' COMMENT 'Aktif: pilihan(Y=Aktif; T=Tidak Aktif)',
  `diedit_oleh` varchar(30) DEFAULT '' COMMENT 'Diedit Oleh: (by system)',
  `diedit_tanggal` datetime DEFAULT NULL COMMENT 'Diedit Tanggal: (by system)',
  `diinput_oleh` varchar(30) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT '' COMMENT 'Diinput Oleh: (by system)',
  `diinput_tanggal` datetime DEFAULT NULL COMMENT 'Diinput Tanggal: (by system)',
  `diperbaharui_oleh` varchar(30) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT '' COMMENT 'Diperbaharui Oleh: (by system)',
  `diperbaharui_tanggal` datetime DEFAULT NULL COMMENT 'Diperbaharui Tanggal: (by system)',
  `kategori_kredit_buku_bantu` varchar(10) DEFAULT '',
  `kode` varchar(20) DEFAULT '' COMMENT 'Kode Jenis Biaya: isian bebas',
  PRIMARY KEY (`id`),
  KEY `kategori_id` (`kategori_id`),
  KEY `tahapan_id` (`tahapan_id`),
  KEY `kode` (`kode`),
  KEY `nama` (`nama`),
  KEY `aktif` (`aktif`),
  KEY `diinput_tanggal` (`diinput_tanggal`),
  KEY `diperbaharui_tanggal` (`diperbaharui_tanggal`)
) ENGINE=InnoDB AUTO_INCREMENT=531 DEFAULT CHARSET=latin1 COMMENT='Referensi jenis biaya perkara';

/*Data for the table `keu_jenis_biaya_tambahan` */

insert  into `keu_jenis_biaya_tambahan`(`id`,`kategori_id`,`tahapan_id`,`jenis_transaksi`,`jenis_transaksi_bku`,`kategori_debet_bku`,`kategori_kredit_bku`,`kategori_debet_buku_bantu`,`nama`,`jumlah`,`keterangan`,`aktif`,`diedit_oleh`,`diedit_tanggal`,`diinput_oleh`,`diinput_tanggal`,`diperbaharui_oleh`,`diperbaharui_tanggal`,`kategori_kredit_buku_bantu`,`kode`) values 
(1,1,10,1,1,'A2',NULL,'','Panjar Biaya Perkara',0.00,'Panjar Biaya Perkara','T','',NULL,'system','2012-04-23 10:25:15','admin','2012-11-16 19:16:22','','PJR A1'),
(2,1,20,1,1,'A2',NULL,'','Panjar Biaya Perkara Banding',0.00,'Panjar Biaya Perkara Banding','T','',NULL,'system','2012-04-23 10:25:54','admin','2012-11-16 19:19:03','','PJR B1'),
(4,1,30,1,1,'A2',NULL,'','Panjar Biaya Perkara Kasasi',0.00,'Panjar Biaya Perkara Kasasi','T','',NULL,'system','2012-04-23 10:27:40','admin','2012-11-16 19:21:41','','PJR C1'),
(6,1,40,1,1,'A2',NULL,'','Panjar Biaya Perkara PK',0.00,'Panjar Biaya Perkara PK','T','',NULL,'system','2012-04-23 10:28:50','admin','2012-11-16 19:24:23','','PJR D1'),
(9,3,20,-1,-1,'','A1','','Pengiriman Biaya Banding',0.00,'Biaya Pengiriman Biaya Banding','T','',NULL,'system','2012-04-23 10:30:28','admin','2012-11-17 23:17:27','','KRB B1'),
(10,3,30,-1,-1,'','A1','','Pengiriman Biaya Kasasi',0.00,'Biaya Pengiriman Biaya Kasasi','T','',NULL,'system','2012-04-23 10:31:12','admin','2012-11-17 23:17:52','','KRB C1'),
(11,3,40,-1,-1,'','A1','','Pengiriman Biaya PK',0.00,'Biaya Pengiriman Biaya PK','T','',NULL,'system','2012-04-23 10:31:44','admin','2012-11-17 23:18:04','','KRB D1'),
(12,4,10,-1,-1,'','A1','','Biaya Panggilan Penggugat/Pelawan/Terlawan',0.00,'Biaya Panggilan Penggugat/Pelawan/Terlawan','T','',NULL,'system','2012-04-23 10:32:28','admin','2012-11-16 19:46:16','','PGL A1'),
(13,4,10,-1,-1,'','A1','','Panggilan Pemohon',0.00,'Biaya Panggilan Pemohon','T','',NULL,'system','2012-04-23 10:32:00','admin','2012-11-16 19:46:28','','PGL A1'),
(14,4,10,-1,-1,'','A1','','Biaya Panggilan Tergugat/Terlawan/Pelawan/Iklan/Radio/Pengumuman',0.00,'Biaya Panggilan Tergugat/Terlawan/Pelawan/Iklan/Radio/Pengumuman','T','',NULL,'system','2012-04-23 10:32:57','admin','2012-11-16 19:46:39','','PGL A2'),
(15,4,10,-1,-1,'','A1','','Biaya Panggilan Termohon/Iklan/Radio/Pengumuman',0.00,'Biaya Panggilan Termohon/Iklan/Radio/Pengumuman','T','',NULL,'system','2012-04-23 10:32:00','admin','2012-11-16 19:46:49','','PGL A2'),
(16,4,10,-1,-1,'','A1','','Biaya Panggilan Saksi Penggugat',0.00,'Biaya Panggilan Saksi Penggugat','T','',NULL,'system','2012-04-23 10:33:24','admin','2012-11-16 19:47:01','','PGL A3'),
(25,5,10,-1,-1,'','A1','','Biaya Pelaksanaan Penyitaan/CB',0.00,'Biaya Pelaksanaan Penyitaan/CB','T','',NULL,'system','2012-04-23 10:34:17','admin','2012-11-17 23:08:24','','JST A1'),
(26,5,10,-1,-1,'','A1','','Biaya Pelaksanaan Penyitaan/RB',0.00,'Biaya Pelaksanaan Penyitaan/RB','T','',NULL,'system','2012-04-23 10:34:42','admin','2012-11-17 23:08:13','','JST A2'),
(27,5,10,-1,-1,'','A1','','Biaya Pelaksanaan Pencabutan Sita/CB',0.00,'Biaya Pelaksanaan Pencabutan Sita/CB','T','',NULL,'system','2012-04-23 10:35:03','admin','2012-11-17 23:08:01','','JST A3'),
(28,6,10,-1,-1,'','A1','','Pemberitahuan Putusan Gugur',0.00,'Biaya Pemberitahuan Putusan Gugur','T','',NULL,'system','2012-04-23 10:35:35','',NULL,'','PBT A1'),
(29,6,10,-1,-1,'','A1','','Biaya Pemberitahuan/Penyampaian Putusan/Iklan',0.00,'Biaya Pemberitahuan/Penyampaian Putusan/Iklan','T','',NULL,'system','2012-04-23 10:36:00','admin','2012-11-17 22:42:07','','PBT A2'),
(30,6,10,-1,-1,'','A1','','Pemberitahuan Putusan Diluar Hadir',0.00,'Biaya Pemberitahuan Putusan Diluar Hadir','T','',NULL,'system','2012-04-23 10:36:33','admin','2012-11-17 22:41:36','','PBT A3'),
(31,6,20,-1,-1,'','A1','','Biaya Pemberitahuan Pernyataan Banding',0.00,'Biaya Pemberitahuan Pernyataan Banding','T','',NULL,'system','2012-04-23 10:37:01','admin','2012-11-17 22:44:47','','PBT B1'),
(32,6,20,-1,-1,'','A1','','Biaya Penyerahan Memori Banding',0.00,'Biaya Penyerahan Memori Banding','T','',NULL,'system','2012-04-23 10:37:25','admin','2012-11-17 23:36:24','','PBT B2'),
(33,6,20,-1,-1,'','A1','','Biaya Penyerahan Kontra Memori Banding',0.00,'Biaya Penyerahan Kontra Memori Banding','T','',NULL,'system','2012-04-23 10:37:48','admin','2012-11-17 23:36:56','','PBT B3'),
(34,6,20,-1,-1,'','A1','','Biaya Pemberitahuan Inzage Kepada Pembanding',0.00,'Biaya Pemberitahuan Inzage Kepada Pembanding','T','',NULL,'system','2012-04-23 10:38:13','admin','2012-11-17 22:45:31','','PBT B4'),
(35,6,20,-1,-1,'','A1','','Biaya Pemberitahuan Putusan Kepada Pembanding',0.00,'Biaya Pemberitahuan Putusan Kepada Pembanding','T','',NULL,'system','2012-04-23 10:38:40','admin','2012-11-17 22:48:49','','PBT B5'),
(36,6,30,-1,-1,'','A1','','Biaya Pemberitahuan Pernyataan Kasasi',0.00,'Biaya Pemberitahuan Pernyataan Kasasi','T','',NULL,'system','2012-04-23 10:39:41','admin','2012-11-17 22:54:56','','PBT C1'),
(37,6,30,-1,-1,'','A1','','Biaya Penyerahan Memori Kasasi',0.00,'Biaya Penyerahan Memori Kasasi','T','',NULL,'system','2012-04-23 10:40:19','admin','2012-11-17 23:38:07','','PBT C2'),
(38,6,30,-1,-1,'','A1','','Biaya Penyerahan Kontra Memori Kasasi',0.00,'Biaya Penyerahan Kontra Memori Kasasi','T','',NULL,'system','2012-04-23 10:40:39','admin','2012-11-17 23:38:44','','PBT C3'),
(39,6,30,-1,-1,'','A1','','Biaya Pemberitahuan Putusan Kepada Pemohon Kasasi',0.00,'Biaya Pemberitahuan Putusan Kepada Pemohon Kasasi','T','',NULL,'system','2012-04-23 10:41:02','admin','2012-11-17 22:51:38','','PBT C4'),
(40,6,30,-1,-1,'','A1','','Biaya Pemberitahuan Putusan Kepada Termohon Kasasi',0.00,'Biaya Pemberitahuan Putusan Kepada Termohon Kasasi','T','',NULL,'system','2012-04-23 10:41:23','admin','2012-11-17 22:52:33','','PBT C5'),
(41,6,40,-1,-1,'','A1','','Biaya Pemberitahuan Pernyataan PK dan Penyerahan Memori PK',0.00,'Biaya Pemberitahuan Pernyataan PK dan Penyerahan Memori PK','T','',NULL,'system','2012-04-23 10:42:05','admin','2012-11-17 22:54:17','','PBT D1'),
(42,6,40,-1,-1,'','A1','','Biaya Penyerahan Kontra Memori PK',0.00,'Biaya Penyerahan Kontra Memori PK','T','',NULL,'system','2012-04-23 10:42:36','admin','2012-11-17 23:39:59','','PBT D2'),
(43,6,40,-1,-1,'','A1','','Biaya Pemberitahuan Putusan Kepada Pemohon PK',0.00,'Biaya Pemberitahuan Putusan Kepada Pemohon PK','T','',NULL,'system','2012-04-23 10:43:01','system','2012-11-30 18:09:52','','PBT D3'),
(44,6,40,-1,-1,'','A1','','Biaya Pemberitahuan Putusan Kepada Termohon PK',0.00,'Biaya Pemberitahuan Putusan Kepada Termohon PK','T','',NULL,'system','2012-04-23 10:43:24','admin','2012-11-17 22:57:00','','PBT D4'),
(45,7,10,-1,-1,'','A1','','Pemeriksaan Setempat',0.00,'Biaya Pemeriksaan Setempat','T','',NULL,'system','2012-04-23 10:44:17','admin','2012-11-17 23:03:48','','PST A1'),
(61,11,10,-1,0,'B9','B1','','Biaya Pendaftaran/PNBP',0.00,'Biaya Pendaftaran/PNBP','T','',NULL,'system','2012-04-23 10:46:06','system','2012-11-30 17:20:44','','PNBP A01'),
(62,11,20,-1,0,'B9','B1','','Biaya Pendaftaran/PNBP Perkara Banding',0.00,'Biaya Pendaftaran/PNBP Perkara Banding','T','',NULL,'system','2012-04-23 10:46:00','system','2012-11-30 17:24:08','','PNBP B01'),
(63,11,30,-1,0,'B9','B1','','Biaya Pendaftaran/PNBP Perkara Kasasi',0.00,'Biaya Pendaftaran/PNBP Perkara Kasasi','T','',NULL,'system','2012-04-23 10:46:00','system','2012-11-30 17:25:36','','PNBP C01'),
(64,11,40,-1,0,'B9','B1','','Biaya Pendaftaran/PNBP Perkara PK',0.00,'Biaya Pendaftaran/PNBP Perkara PK','T','',NULL,'system','2012-04-23 10:46:00','system','2012-11-30 17:26:41','','PNBP D01'),
(65,11,50,-1,0,'B9','B1','','Biaya Pendaftaran Eksekusi',0.00,'Biaya Pendaftaran Eksekusi','T','',NULL,'system','2012-04-23 10:46:00','system','2012-11-30 17:27:34','','PNBP E01'),
(141,13,99,-1,1,'A1',NULL,'','Upah Tulis',0.00,'Biaya Upah Tulis','T','',NULL,'system','2012-04-23 10:47:04','',NULL,'','HHK 1'),
(143,13,20,-1,0,'B9','B1','','Pencatatan Permohonan Banding',0.00,'Biaya Pencatatan Permohonan Banding','T','',NULL,'system','2012-04-23 10:47:52','system','2012-11-30 16:26:41','','HHK B3'),
(144,13,30,-1,0,'B9','B1','','Pencatatan Permohonan Kasasi',0.00,'Biaya Pencatatan Permohonan Kasasi','T','',NULL,'system','2012-04-23 10:48:24','system','2012-11-30 16:27:45','','HHK C4'),
(145,13,40,-1,0,'B9','B1','','Pencatatan Permohonan PK',0.00,'Biaya Pencatatan Permohonan PK','T','',NULL,'system','2012-04-23 10:48:54','system','2012-11-30 16:29:03','','HHK D5'),
(146,13,99,-1,1,'A1',NULL,'','Pencatatan pembuatan akta atau berita acara penyumpahan atau dari putusan-putusan lainnya ',0.00,'Pencatatan pembuatan akta atau berita acara penyumpahan atau dari putusan-putusan lainnya yang bukan sebagai akibat keputusan Pengadilan  (PP No. 53 Tahun 2008 E.10)','T','',NULL,'system','2012-04-23 10:49:23','system','2012-11-15 23:53:01','','HHK 2'),
(150,14,99,-1,-1,'A1','','','Lain-lain',0.00,'Biaya Lain-lain','T','',NULL,'system','2012-04-23 10:50:51','',NULL,'','LLN'),
(151,2,10,-1,-1,'','A1','','Pengembalian Sisa Panjar',0.00,'Pengembalian Sisa Panjar','T','',NULL,'system','2012-04-23 10:29:35','admin','2012-11-16 23:35:47','','SPJR A1'),
(152,8,10,-1,-1,'B1','B11','','Meterai',0.00,'Biaya Materai','T','',NULL,'system','2012-04-23 10:44:45','admin','2012-11-17 22:26:04','','MTR A1'),
(153,9,10,-1,-1,'','A1','','Sumpah',0.00,'Biaya Penyumpahan','T','',NULL,'system','2012-04-23 10:45:13','',NULL,'','SMP'),
(154,10,10,-1,-1,'','A1','','Penerjemah',0.00,'Biaya Penerjemah','T','',NULL,'system','2012-04-23 10:45:40','admin','2012-11-17 23:00:15','','PNJ A1'),
(155,12,10,-1,0,'A8','B1','','Biaya Pemberkasan/ATK',0.00,'Biaya Pemberkasan/ATK','T','',NULL,'system','2012-04-23 10:46:30','admin','2012-11-16 19:34:52','','ATK'),
(156,13,10,-1,0,'B9','B1','','Upah Tulis',0.00,'Biaya Upah Tulis','T','',NULL,'system','2012-04-23 10:47:04','system','2012-11-30 16:25:08','','HHK A1'),
(157,13,10,-1,0,'B9','B1','','Redaksi',0.00,'Biaya Redaksi','T','',NULL,'system','2012-04-23 10:47:23','system','2012-11-30 16:25:31','','HHK A2'),
(159,13,10,-1,0,'B9','B1','','Pencatatan Permohonan Sita Konservatoir',0.00,'Biaya Pencatatan Permohonan Sita Konservatoir','T','',NULL,'system','2012-04-23 10:49:47','system','2012-11-30 16:25:50','','HHK A7'),
(160,13,10,-1,0,'B9','B1','','Pencatatan Permohonan Sita Revindikatoir',0.00,'Biaya Pencatatan Permohonan Sita Revindikatoir','T','',NULL,'system','2012-04-23 10:50:07','system','2012-11-30 16:25:57','','HHK A8'),
(161,13,10,-1,0,'B9','B1','','Permohonan Pencabutan Sita',0.00,'Biaya Permohonan Pencabutan Sita','T','',NULL,'system','2012-04-23 10:50:31','system','2012-11-30 16:26:05','','HHK A9'),
(162,14,10,-1,-1,'','A1','','Lain-lain',0.00,'Biaya Lain-lain','T','',NULL,'system','2012-04-23 10:50:51','',NULL,'','LLN'),
(166,2,20,-1,-1,'','A1','','Pengembalian Sisa Panjar',0.00,'Pengembalian Sisa Panjar','T','',NULL,'system','2012-04-23 10:29:35','admin','2012-11-16 23:36:01','','SPJR B1'),
(167,8,20,-1,-1,'B1','B11','','Meterai',0.00,'Biaya Materai','T','',NULL,'system','2012-04-23 10:44:45','admin','2012-11-17 22:26:16','','MTR B1'),
(168,9,20,-1,-1,'','A1','','Sumpah',0.00,'Biaya Penyumpahan','T','',NULL,'system','2012-04-23 10:45:13','',NULL,'','SMP'),
(169,10,20,-1,-1,'','A1','','Penerjemah',0.00,'Biaya Penerjemah','T','',NULL,'system','2012-04-23 10:45:40','admin','2012-11-17 23:00:45','','PNJ B1'),
(170,12,20,-1,0,'A8','B1','','Biaya Pemberkasan/ATK',0.00,'Biaya Pemberkasan/ATK','T','',NULL,'system','2012-04-23 10:46:30','admin','2012-11-16 19:35:26','','ATK'),
(171,13,20,-1,0,'B9','B1','','Upah Tulis',0.00,'Biaya Upah Tulis','T','',NULL,'system','2012-04-23 10:47:04','system','2012-11-30 16:26:20','','HHK B1'),
(172,13,20,-1,0,'B9','B1','','Redaksi',0.00,'Biaya Redaksi','T','',NULL,'system','2012-04-23 10:47:23','system','2012-11-30 16:26:31','','HHK B2'),
(174,13,20,-1,0,'B9','B1','','Pencatatan Permohonan Sita Konservatoir',0.00,'Biaya Pencatatan Permohonan Sita Konservatoir','T','',NULL,'system','2012-04-23 10:49:47','system','2012-11-30 16:26:51','','HHK B7'),
(175,13,20,-1,0,'B9','B1','','Pencatatan Permohonan Sita Revindikatoir',0.00,'Biaya Pencatatan Permohonan Sita Revindikatoir','T','',NULL,'system','2012-04-23 10:50:07','system','2012-11-30 16:27:02','','HHK B8'),
(176,13,20,-1,0,'B9','B1','','Permohonan Pencabutan Sita',0.00,'Biaya Permohonan Pencabutan Sita','T','',NULL,'system','2012-04-23 10:50:31','system','2012-11-30 16:27:12','','HHK B9'),
(177,14,20,-1,-1,'','A1','','Lain-lain',0.00,'Biaya Lain-lain','T','',NULL,'system','2012-04-23 10:50:51','',NULL,'','LLN'),
(181,2,30,-1,-1,'','A1','','Pengembalian Sisa Panjar',0.00,'Pengembalian Sisa Panjar','T','',NULL,'system','2012-04-23 10:29:35','admin','2012-11-16 23:36:17','','SPJR C1'),
(182,8,30,-1,-1,'B1','B11','','Meterai',0.00,'Biaya Materai','T','',NULL,'system','2012-04-23 10:44:45','admin','2012-11-17 22:26:29','','MTR C1'),
(183,9,30,-1,-1,'','A1','','Sumpah',0.00,'Biaya Penyumpahan','T','',NULL,'system','2012-04-23 10:45:13','',NULL,'','SMP'),
(184,10,30,-1,-1,'','A1','','Penerjemah',0.00,'Biaya Penerjemah','T','',NULL,'system','2012-04-23 10:45:40','admin','2012-11-17 23:01:17','','PNJ C1'),
(185,12,30,-1,0,'A8','B1','','Biaya Pemberkasan/ATK',0.00,'Biaya Pemberkasan/ATK','T','',NULL,'system','2012-04-23 10:46:30','admin','2012-11-16 19:35:39','','ATK'),
(186,13,30,-1,0,'B9','B1','','Upah Tulis',0.00,'Biaya Upah Tulis','T','',NULL,'system','2012-04-23 10:47:04','system','2012-11-30 16:27:26','','HHK C1'),
(187,13,30,-1,0,'B9','B1','','Redaksi',0.00,'Biaya Redaksi','T','',NULL,'system','2012-04-23 10:47:23','system','2012-11-30 16:27:35','','HHK C2'),
(189,13,30,-1,0,'B9','B1','','Pencatatan Permohonan Sita Konservatoir',0.00,'Biaya Pencatatan Permohonan Sita Konservatoir','T','',NULL,'system','2012-04-23 10:49:47','system','2012-11-30 16:27:53','','HHK C7'),
(190,13,30,-1,0,'B9','B1','','Pencatatan Permohonan Sita Revindikatoir',0.00,'Biaya Pencatatan Permohonan Sita Revindikatoir','T','',NULL,'system','2012-04-23 10:50:07','system','2012-11-30 16:28:02','','HHK C8'),
(191,13,30,-1,0,'B9','B1','','Permohonan Pencabutan Sita',0.00,'Biaya Permohonan Pencabutan Sita','T','',NULL,'system','2012-04-23 10:50:31','system','2012-11-30 16:28:13','','HHK C9'),
(192,14,30,-1,-1,'','A1','','Lain-lain',0.00,'Biaya Lain-lain','T','',NULL,'system','2012-04-23 10:50:51','',NULL,'','LLN'),
(196,2,40,-1,-1,'','A1','','Pengembalian Sisa Panjar',0.00,'Pengembalian Sisa Panjar','T','',NULL,'system','2012-04-23 10:29:35','admin','2012-11-16 23:36:31','','SPJR D1'),
(197,8,40,-1,-1,'B1','B11','','Meterai',0.00,'Biaya Materai','T','',NULL,'system','2012-04-23 10:44:45','admin','2012-11-17 22:26:41','','MTR D1'),
(198,9,40,-1,-1,'','A1','','Sumpah',0.00,'Biaya Penyumpahan','T','',NULL,'system','2012-04-23 10:45:13','',NULL,'','SMP'),
(199,10,40,-1,-1,'','A1','','Penerjemah',0.00,'Biaya Penerjemah','T','',NULL,'system','2012-04-23 10:45:40','admin','2012-11-17 23:01:30','','PNJ D1'),
(200,12,40,-1,0,'A8','B1','','Biaya Pemberkasan/ATK',0.00,'Biaya Pemberkasan/ATK','T','',NULL,'system','2012-04-23 10:46:30','admin','2012-11-16 19:35:51','','ATK'),
(201,13,40,-1,0,'B9','B1','','Upah Tulis',0.00,'Biaya Upah Tulis','T','',NULL,'system','2012-04-23 10:47:04','system','2012-11-30 16:28:41','','HHK D1'),
(202,13,40,-1,0,'B9','B1','','Redaksi',0.00,'Biaya Redaksi','T','',NULL,'system','2012-04-23 10:47:23','system','2012-11-30 16:28:52','','HHK D2'),
(204,13,40,-1,0,'B9','B1','','Pencatatan Permohonan Sita Konservatoir',0.00,'Biaya Pencatatan Permohonan Sita Konservatoir','T','',NULL,'system','2012-04-23 10:49:47','system','2012-11-30 16:29:12','','HHK D7'),
(205,13,40,-1,0,'B9','B1','','Pencatatan Permohonan Sita Revindikatoir',0.00,'Biaya Pencatatan Permohonan Sita Revindikatoir','T','',NULL,'system','2012-04-23 10:50:07','system','2012-11-30 16:29:21','','HHK D8'),
(206,13,40,-1,0,'B9','B1','','Permohonan Pencabutan Sita',0.00,'Biaya Permohonan Pencabutan Sita','T','',NULL,'system','2012-04-23 10:50:31','system','2012-11-30 16:29:31','','HHK D9'),
(207,14,40,-1,-1,'','A1','','Lain-lain',0.00,'Biaya Lain-lain','T','',NULL,'system','2012-04-23 10:50:51','',NULL,'','LLN'),
(211,2,50,-1,-1,'','A1','','Pengembalian Sisa Panjar',0.00,'Pengembalian Sisa Panjar','T','',NULL,'system','2012-04-23 10:29:35','admin','2012-11-16 23:36:47','','SPJR E1'),
(212,8,50,-1,-1,'B1','B11','','Meterai',0.00,'Biaya Materai','T','',NULL,'system','2012-04-23 10:44:45','admin','2012-11-17 22:26:54','','MTR E1'),
(213,9,50,-1,-1,'','A1','','Sumpah',0.00,'Biaya Penyumpahan','T','',NULL,'system','2012-04-23 10:45:13','',NULL,'','SMP'),
(214,10,50,-1,-1,'','A1','','Penerjemah',0.00,'Biaya Penerjemah','T','',NULL,'system','2012-04-23 10:45:40','admin','2012-11-17 23:01:41','','PNJ E1'),
(215,12,50,-1,0,'A8','B1','','Biaya ATK/Proses',0.00,'Biaya ATK/Proses','T','',NULL,'system','2012-04-23 10:46:30','admin','2012-11-16 19:37:08','','ATK'),
(216,13,50,-1,0,'B9','B1','','Upah Tulis',0.00,'Biaya Upah Tulis','T','',NULL,'system','2012-04-23 10:47:04','system','2012-11-30 16:29:49','','HHK E1'),
(217,13,50,-1,0,'B9','B1','','Redaksi',0.00,'Biaya Redaksi','T','',NULL,'system','2012-04-23 10:47:23','system','2012-11-30 16:29:57','','HHK E2'),
(219,13,50,-1,0,'B9','B1','','Pencatatan Permohonan Sita Konservatoir',0.00,'Biaya Pencatatan Permohonan Sita Konservatoir','T','',NULL,'system','2012-04-23 10:49:47','system','2012-11-30 16:30:05','','HHK E7'),
(220,13,50,-1,0,'B9','B1','','Pencatatan Permohonan Sita Revindikatoir',0.00,'Biaya Pencatatan Permohonan Sita Revindikatoir','T','',NULL,'system','2012-04-23 10:50:07','system','2012-11-30 16:30:13','','HHK E8'),
(221,13,50,-1,0,'B9','B1','','Permohonan Pencabutan Sita',0.00,'Biaya Permohonan Pencabutan Sita','T','',NULL,'system','2012-04-23 10:50:31','system','2012-11-30 16:30:22','','HHK E9'),
(222,14,50,-1,-1,'','A1','','Lain-lain',0.00,'Biaya Lain-lain','T','',NULL,'system','2012-04-23 10:50:51','',NULL,'','LLN'),
(223,1,50,1,1,'A2',NULL,'','Panjar Biaya Eksekusi',0.00,'Panjar Biaya Eksekusi','T','',NULL,'system','2012-09-20 05:56:43','admin','2012-11-16 19:27:34','','PJR E1'),
(224,1,10,1,1,'A2',NULL,'','Tambahan Panjar Biaya Perkara',0.00,'Tambahan Panjar Biaya Perkara','T','',NULL,'admin','2012-11-16 19:15:28','',NULL,'','PJR A2'),
(225,1,20,1,1,'A2',NULL,'','Tambahan Panjar Biaya Perkara Banding',0.00,'Tambahan Panjar Biaya Perkara Banding','T','',NULL,'admin','2012-11-16 19:19:51','',NULL,'','PJR B2'),
(226,1,30,1,1,'A2',NULL,'','Tambahan Panjar Biaya Perkara Kasasi',0.00,'Tambahan Panjar Biaya Perkara Kasasi','T','',NULL,'admin','2012-11-16 19:22:32','',NULL,'','PJR C2'),
(227,1,40,1,1,'A2',NULL,'','Tambahan Panjar Biaya Perkara PK',0.00,'Tambahan Panjar Biaya Perkara PK','T','',NULL,'admin','2012-11-16 19:26:06','',NULL,'','PJR D2'),
(228,1,50,1,1,'A2',NULL,'','Tambahan Panjar Biaya Eksekusi',0.00,'Tambahan Panjar Biaya Eksekusi','T','',NULL,'admin','2012-11-16 19:28:21','',NULL,'','PJR E2'),
(229,4,10,-1,-1,'','A1','','Biaya Panggilan Saksi Tergugat',0.00,'Biaya Panggilan Saksi Tergugat','T','',NULL,'admin','2012-11-16 19:45:40','',NULL,'','PGL A4'),
(230,4,10,-1,-1,'','A1','','Biaya Panggilan Ahli Penggugat',0.00,'Biaya Panggilan Ahli Penggugat','T','',NULL,'admin','2012-11-16 19:48:01','admin','2012-11-16 19:48:40','','PGL A5'),
(231,4,10,-1,-1,'','A1','','Biaya Panggilan Ahli Tergugat',0.00,'Biaya Panggilan Ahli Tergugat','T','',NULL,'admin','2012-11-16 19:49:30','',NULL,'','PGL A6'),
(232,4,10,-1,-1,'','A1','','Biaya Panggilan Saksi Pemohon',0.00,'Biaya Panggilan Saksi Pemohon','T','',NULL,'admin','2012-11-16 19:50:39','',NULL,'','PGL A3'),
(233,4,10,-1,-1,'','A1','','Biaya Panggilan Saksi Termohon',0.00,'Biaya Panggilan Saksi Termohon','T','',NULL,'admin','2012-11-16 19:51:23','',NULL,'','PGL A4'),
(234,4,10,-1,-1,'','A1','','Biaya Panggilan Ahli Pemohon',0.00,'Biaya Panggilan Ahli Pemohon','T','',NULL,'admin','2012-11-16 19:52:17','',NULL,'','PGL A5'),
(235,4,10,-1,-1,'','A1','','Biaya Panggilan Ahli Termohon',0.00,'Biaya Panggilan Ahli Termohon','T','',NULL,'admin','2012-11-16 19:53:02','',NULL,'','PGL A6'),
(236,11,10,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Panggilan Pertama Penggugat/Pelawan/Terlawan',0.00,'Biaya PNBP Penyerahan Akta Panggilan Pertama Penggugat/Pelawan/Terlawan','T','',NULL,'admin','2012-11-17 21:32:52','system','2012-11-30 17:21:01','','PNBP A02'),
(237,11,10,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Panggilan Pertama Tergugat/Terlawan/Pelawan',0.00,'Biaya PNBP Penyerahan Akta Panggilan Pertama Tergugat/Terlawan/Pelawan','T','',NULL,'admin','2012-11-17 21:34:02','system','2012-11-30 17:21:51','','PNBP A03'),
(238,11,10,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Pemberitahuan Putusan Sela Kepada Penggugat',0.00,'Biaya PNBP Penyerahan Akta Pemberitahuan Putusan Sela Kepada Penggugat','T','',NULL,'admin','2012-11-17 21:35:05','system','2012-11-30 17:22:15','','PNBP A04'),
(239,11,10,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Pemberitahuan Putusan Sela Kepada Tergugat',0.00,'Biaya PNBP Penyerahan Akta Pemberitahuan Putusan Sela Kepada Tergugat','T','',NULL,'admin','2012-11-17 21:36:14','system','2012-11-30 17:22:25','','PNBP A05'),
(240,11,10,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Panggilan Saksi Penggugat',0.00,'Biaya PNBP Penyerahan Akta Panggilan Saksi Penggugat','T','',NULL,'admin','2012-11-17 21:37:04','system','2012-11-30 17:22:53','','PNBP A06'),
(241,11,10,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Panggilan Saksi Tergugat',0.00,'Biaya PNBP Penyerahan Akta Panggilan Saksi Tergugat','T','',NULL,'admin','2012-11-17 21:38:20','system','2012-11-30 17:23:02','','PNBP A07'),
(242,11,10,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Panggilan Ahli Penggugat',0.00,'Biaya PNBP Penyerahan Akta Panggilan Ahli Penggugat','T','',NULL,'admin','2012-11-17 21:39:23','system','2012-11-30 17:23:20','','PNBP A08'),
(243,11,10,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Panggilan Ahli Tergugat',0.00,'Biaya PNBP Penyerahan Akta Panggilan Ahli Tergugat','T','',NULL,'admin','2012-11-17 21:40:29','system','2012-11-30 17:23:48','','PNBP A09'),
(244,11,10,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Penyitaan/CB',0.00,'Biaya PNBP Penyerahan Akta Penyitaan/CB','T','',NULL,'admin','2012-11-17 21:41:28','',NULL,'','PNBP A10'),
(245,11,10,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Pelaksanaan Penyitaan/CB',0.00,'Biaya PNBP Penyerahan Akta Pelaksanaan Penyitaan/CB','T','',NULL,'admin','2012-11-17 21:42:30','',NULL,'','PNBP A11'),
(246,11,10,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Penyitaan/RB',0.00,'Biaya PNBP Penyerahan Akta Penyitaan/RB','T','',NULL,'admin','2012-11-17 21:43:14','',NULL,'','PNBP A12'),
(247,11,10,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Pelaksanaan Penyitaan/RB',0.00,'Biaya PNBP Penyerahan Akta Pelaksanaan Penyitaan/RB','T','',NULL,'admin','2012-11-17 21:44:26','',NULL,'','PNBP A13'),
(248,11,10,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Pencabutan Sita/CB',0.00,'Biaya PNBP Penyerahan Akta Pencabutan Sita/CB','T','',NULL,'admin','2012-11-17 21:45:16','',NULL,'','PNBP A14'),
(249,11,10,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Pelaksanaan Pencabutan Sita/CB',0.00,'Biaya PNBP Penyerahan Akta Pelaksanaan Pencabutan Sita/CB','T','',NULL,'admin','2012-11-17 21:46:04','',NULL,'','PNBP A15'),
(250,11,10,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Pencabutan Sita/RB',0.00,'Biaya PNBP Penyerahan Akta Pencabutan Sita/RB','T','',NULL,'admin','2012-11-17 21:46:48','',NULL,'','PNBP A16'),
(251,11,10,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Pelaksanaan Pencabutan Sita/RB',0.00,'Biaya PNBP Penyerahan Akta Pelaksanaan Pencabutan Sita/RB','T','',NULL,'admin','2012-11-17 21:48:22','',NULL,'','PNBP A17'),
(252,11,10,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Pemberitahuan/Penyampaian Putusan/Iklan',0.00,'Biaya PNBP Penyerahan Akta Pemberitahuan/Penyampaian Putusan/Iklan','T','',NULL,'admin','2012-11-17 21:49:15','',NULL,'','PNBP A18'),
(253,11,10,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Panggilan Pemohon',0.00,'Biaya PNBP Penyerahan Akta Panggilan Pemohon','T','',NULL,'admin','2012-11-17 21:50:04','system','2012-11-30 17:21:23','','PNBP A02'),
(254,11,10,-1,0,'B9','B1','','Biaya PNBP Akta Panggilan Termohon/Iklan/Radio/Pengumuman',0.00,'Biaya PNBP Akta Panggilan Termohon/Iklan/Radio/Pengumuman','T','',NULL,'admin','2012-11-17 21:50:49','system','2012-11-30 17:21:39','','PNBP A03'),
(255,11,10,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Panggilan Saksi Pemohon',0.00,'Biaya PNBP Penyerahan Akta Panggilan Saksi Pemohon','T','',NULL,'admin','2012-11-17 21:51:39','system','2012-11-30 17:22:02','','PNBP A04'),
(256,11,10,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Panggilan Saksi Termohon',0.00,'Biaya PNBP Penyerahan Akta Panggilan Saksi Termohon','T','',NULL,'admin','2012-11-17 21:52:22','system','2012-11-30 17:22:34','','PNBP A05'),
(257,11,10,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Panggilan Penerjemah',0.00,'Biaya PNBP Penyerahan Akta Panggilan Penerjemah','T','',NULL,'admin','2012-11-17 21:53:04','system','2012-11-30 17:22:44','','PNBP A06'),
(258,11,10,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Panggilan Ahli Pemohon',0.00,'Biaya PNBP Penyerahan Akta Panggilan Ahli Pemohon','T','',NULL,'admin','2012-11-17 21:53:42','system','2012-11-30 17:23:11','','PNBP A07'),
(259,11,10,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Panggilan Ahli Termohon',0.00,'Biaya PNBP Penyerahan Akta Panggilan Ahli Termohon','T','',NULL,'admin','2012-11-17 21:54:26','system','2012-11-30 17:23:30','','PNBP A08'),
(260,11,10,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Pemberitahuan/Penyampaian Putusan/Iklan',0.00,'Biaya PNBP Penyerahan Akta Pemberitahuan/Penyampaian Putusan/Iklan','T','',NULL,'admin','2012-11-17 21:55:14','system','2012-11-30 17:23:39','','PNBP A09'),
(261,11,20,-1,0,'B9','B1','','Biaya PNBP Pencatatan Akta Banding',0.00,'Biaya PNBP Pencatatan Akta Banding','T','',NULL,'admin','2012-11-17 21:55:58','system','2012-11-30 17:24:19','','PNBP B02'),
(262,11,20,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Pemberitahuan Pernyataan Banding',0.00,'Biaya PNBP Penyerahan Akta Pemberitahuan Pernyataan Banding','T','',NULL,'admin','2012-11-17 21:56:47','system','2012-11-30 17:24:30','','PNBP B03'),
(263,11,20,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Memori Banding',0.00,'Biaya PNBP Penyerahan Akta Memori Banding','T','',NULL,'admin','2012-11-17 21:57:30','system','2012-11-30 17:24:38','','PNBP B04'),
(264,11,20,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Kontra Memori Banding',0.00,'Biaya PNBP Penyerahan Akta Kontra Memori Banding','T','',NULL,'admin','2012-11-17 21:59:04','system','2012-11-30 17:24:48','','PNBP B05'),
(265,11,20,-1,0,'B9','B1','','Biaya PNBP Akta Pemberitahuan Inzage Kepada Pembanding',0.00,'Biaya PNBP Akta Pemberitahuan Inzage Kepada Pembanding','T','',NULL,'admin','2012-11-17 21:59:52','system','2012-11-30 17:24:57','','PNBP B06'),
(266,11,20,-1,0,'B9','B1','','Biaya PNBP Akta Pemberitahuan Inzage Kepada Terbanding',0.00,'Biaya PNBP Akta Pemberitahuan Inzage Kepada Terbanding','T','',NULL,'admin','2012-11-17 22:01:14','system','2012-11-30 17:25:07','','PNBP B07'),
(267,11,20,-1,0,'B9','B1','','Biaya PNBP Akta Pemberitahuan Putusan Sela Kepada Pembanding',0.00,'Biaya PNBP Akta Pemberitahuan Putusan Sela Kepada Pembanding','T','',NULL,'admin','2012-11-17 22:02:10','system','2012-11-30 17:25:15','','PNBP B08'),
(268,11,20,-1,0,'B9','B1','','Biaya PNBP Akta Pemberitahuan Putusan Sela Kepada Terbanding',0.00,'Biaya PNBP Akta Pemberitahuan Putusan Sela Kepada Terbanding','T','',NULL,'admin','2012-11-17 22:02:59','system','2012-11-30 17:25:25','','PNBP B09'),
(269,11,20,-1,0,'B9','B1','','Biaya PNBP Akta Pemberitahuan Putusan Kepada Pembanding',0.00,'Biaya PNBP Akta Pemberitahuan Putusan Kepada Pembanding','T','',NULL,'admin','2012-11-17 22:03:48','',NULL,'','PNBP B10'),
(270,11,20,-1,0,'B9','B1','','Biaya PNBP Akta Pemberitahuan Putusan Kepada Terbanding',0.00,'Biaya PNBP Akta Pemberitahuan Putusan Kepada Terbanding','T','',NULL,'admin','2012-11-17 22:04:31','',NULL,'','PNBP B11'),
(271,11,30,-1,0,'B9','B1','','Biaya PNBP Pencatatan Akta Kasasi',0.00,'Biaya PNBP Pencatatan Akta Kasasi','T','',NULL,'admin','2012-11-17 22:05:29','system','2012-11-30 17:25:46','','PNBP C02'),
(272,11,30,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Pemberitahuan Pernyataan Kasasi',0.00,'Biaya PNBP Penyerahan Akta Pemberitahuan Pernyataan Kasasi','T','',NULL,'admin','2012-11-17 22:06:12','system','2012-11-30 17:25:55','','PNBP C03'),
(273,11,30,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Memori Kasasi',0.00,'Biaya PNBP Penyerahan Akta Memori Kasasi','T','',NULL,'admin','2012-11-17 22:07:03','system','2012-11-30 17:26:03','','PNBP C04'),
(274,11,30,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Kontra Memori Kasasi',0.00,'Biaya PNBP Penyerahan Akta Kontra Memori Kasasi','T','',NULL,'admin','2012-11-17 22:07:49','system','2012-11-30 17:26:14','','PNBP C05'),
(275,11,30,-1,0,'B9','B1','','Biaya PNBP Pemberitahuan Akta Putusan Kepada Pemohon Kasasi',0.00,'Biaya PNBP Pemberitahuan Akta Putusan Kepada Pemohon Kasasi','T','',NULL,'admin','2012-11-17 22:08:36','system','2012-11-30 17:26:23','','PNBP C06'),
(276,11,30,-1,0,'B9','B1','','Biaya PNBP Pemberitahuan Akta Putusan Kepada Termohon Kasasi',0.00,'Biaya PNBP Pemberitahuan Akta Putusan Kepada Termohon Kasasi','T','',NULL,'admin','2012-11-17 22:09:23','system','2012-11-30 17:26:32','','PNBP C07'),
(277,11,40,-1,0,'B9','B1','','Biaya PNBP Pencatatan Akta PK',0.00,'Biaya PNBP Pencatatan Akta PK','T','',NULL,'admin','2012-11-17 22:10:15','system','2012-11-30 17:26:54','','PNBP D02'),
(278,11,40,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Pemberitahuan Pernyataan PK dan Penyerahan Memori PK',0.00,'Biaya PNBP Penyerahan Akta Pemberitahuan Pernyataan PK dan Penyerahan Memori PK','T','',NULL,'admin','2012-11-17 22:11:08','system','2012-11-30 17:27:02','','PNBP D03'),
(279,11,40,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Kontra Memori PK',0.00,'Biaya PNBP Penyerahan Akta Kontra Memori PK','T','',NULL,'admin','2012-11-17 22:11:55','system','2012-11-30 17:27:09','','PNBP D04'),
(280,11,40,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Pemberitahuan Putusan Kepada Pemohon PK',0.00,'Biaya PNBP Penyerahan Akta Pemberitahuan Putusan Kepada Pemohon PK','T','',NULL,'admin','2012-11-17 22:12:43','system','2012-11-30 17:27:17','','PNBP D05'),
(281,11,40,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Pemberitahuan Putusan Kepada Termohon PK',0.00,'Biaya PNBP Penyerahan Akta Pemberitahuan Putusan Kepada Termohon PK','T','',NULL,'admin','2012-11-17 22:14:04','system','2012-11-30 17:27:26','','PNBP D06'),
(282,11,50,-1,0,'B9','B1','','Biaya PNBP Penetapan Aanmaning',0.00,'Biaya PNBP Penetapan Aanmaning','T','',NULL,'admin','2012-11-17 22:14:55','system','2012-11-30 17:27:46','','PNBP E02'),
(283,11,50,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Panggilan Terhadap Termohon Eksekusi',0.00,'Biaya PNBP Penyerahan Akta Panggilan Terhadap Termohon Eksekusi','T','',NULL,'admin','2012-11-17 22:15:42','system','2012-11-30 17:27:54','','PNBP E03'),
(284,11,50,-1,0,'B9','B1','','Biaya PNBP Penetapan Sita Eksekusi',0.00,'Biaya PNBP Penetapan Sita Eksekusi','T','',NULL,'admin','2012-11-17 22:16:39','system','2012-11-30 17:28:02','','PNBP E04'),
(285,11,50,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Pelaksanaan Sita Eksekusi',0.00,'Biaya PNBP Penyerahan Akta Pelaksanaan Sita Eksekusi','T','',NULL,'admin','2012-11-17 22:17:23','system','2012-11-30 17:28:11','','PNBP E05'),
(286,11,50,-1,0,'B9','B1','','Biaya PNBP Penetapan Perintah Pengangkatan/Pencabutan Sita Eksekusi',0.00,'Biaya PNBP Penetapan Perintah Pengangkatan/Pencabutan Sita Eksekusi','T','',NULL,'admin','2012-11-17 22:18:04','system','2012-11-30 17:28:19','','PNBP E06'),
(287,11,50,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Pelaksanaan Pengangkatan/ Pencabutan Sita Eksekusi',0.00,'Biaya PNBP Penyerahan Akta Pelaksanaan Pengangkatan/ Pencabutan Sita Eksekusi','T','',NULL,'admin','2012-11-17 22:18:44','system','2012-11-30 17:28:29','','PNBP E07'),
(288,11,50,-1,0,'B9','B1','','Biaya PNBP Penetapan Perintah Penjualan Lelang',0.00,'Biaya PNBP Penetapan Perintah Penjualan Lelang','T','',NULL,'admin','2012-11-17 22:19:28','system','2012-11-30 17:28:36','','PNBP E08'),
(289,11,50,-1,0,'B9','B1','','Biaya PNBP Penyerahan Surat dari Berkas Perkara Untuk Kepentingan Lelang',0.00,'Biaya PNBP Penyerahan Surat dari Berkas Perkara Untuk Kepentingan Lelang','T','',NULL,'admin','2012-11-17 22:20:28','system','2012-11-30 17:28:42','','PNBP E09'),
(290,11,50,-1,0,'B9','B1','','Biaya PNBP Penetapan Pengosongan',0.00,'Biaya PNBP Penetapan Pengosongan','T','',NULL,'admin','2012-11-17 22:21:09','',NULL,'','PNBP E10'),
(291,11,50,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Pelaksanaan Pengosongan',0.00,'Biaya PNBP Penyerahan Akta Pelaksanaan Pengosongan','T','',NULL,'admin','2012-11-17 22:21:51','',NULL,'','PNBP E11'),
(292,11,50,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Pengosongan Kepada Pemohon',0.00,'Biaya PNBP Penyerahan Akta Pengosongan Kepada Pemohon','T','',NULL,'admin','2012-11-17 22:22:44','',NULL,'','PNBP E12'),
(293,11,50,-1,0,'B9','B1','','Biaya PNBP Penyerahan Akta Pengosongan Kepada Termohon',0.00,'Biaya PNBP Penyerahan Akta Pengosongan Kepada Termohon','T','',NULL,'admin','2012-11-17 22:23:26','',NULL,'','PNBP E13'),
(294,8,10,-1,-1,'B1','B11','','Biaya Meterai Penyitaan/CB',0.00,'Biaya Materai Penyitaan/CB','T','',NULL,'admin','2012-11-17 22:27:29','',NULL,'','MTR A2'),
(295,8,10,-1,-1,'B1','B11','','Biaya Meterai Penyitaan/RB',0.00,'Biaya Materai Penyitaan/RB','T','',NULL,'admin','2012-11-17 22:28:10','',NULL,'','MTR A3'),
(296,8,10,-1,-1,'B1','B11','','Biaya Meterai Pencabutan Sita/CB',0.00,'Biaya Materai Pencabutan Sita/CB','T','',NULL,'admin','2012-11-17 22:28:51','',NULL,'','MTR A4'),
(297,8,10,-1,-1,'B1','B11','','Biaya Meterai Pencabutan Sita/RB',0.00,'Biaya Materai Pencabutan Sita/RB','T','',NULL,'admin','2012-11-17 22:29:28','',NULL,'','MTR A5'),
(298,8,50,-1,-1,'B1','B11','','Biaya Meterai Penetapan Aanmaning',0.00,'Biaya Materai Penetapan Aanmaning','T','',NULL,'admin','2012-11-17 22:33:26','',NULL,'','MTR E2'),
(299,8,50,-1,-1,'B1','B11','','Biaya Meterai Sita Eksekusi',0.00,'Biaya Materai Sita Eksekusi','T','',NULL,'admin','2012-11-17 22:34:13','',NULL,'','MTR E3'),
(300,8,50,-1,-1,'B1','B11','','Biaya Meterai Penetapan Perintah Sita Eksekusi',0.00,'Biaya Materai Penetapan Perintah Sita Eksekusi','T','',NULL,'admin','2012-11-17 22:34:54','',NULL,'','MTR E4'),
(301,8,50,-1,-1,'B1','B11','','Biaya Meterai Berita Acara Sita Eksekusi',0.00,'Biaya Materai Berita Acara Sita Eksekusi','T','',NULL,'admin','2012-11-17 22:35:41','',NULL,'','MTR E5'),
(302,8,50,-1,-1,'B1','B11','','Biaya Meterai Penetapan Perintah Pengangkatan/Pencabutan Sita Eksekusi',0.00,'Biaya Materai Penetapan Perintah Pengangkatan/Pencabutan Sita Eksekusi','T','',NULL,'admin','2012-11-17 22:36:33','',NULL,'','MTR E6'),
(303,8,50,-1,-1,'B1','B11','','Biaya Meterai Akta Pelaksanaan Pengangkatan/ Pencabutan Sita Eksekusi',0.00,'Biaya Materai Akta Pelaksanaan Pengangkatan/ Pencabutan Sita Eksekusi','T','',NULL,'admin','2012-11-17 22:37:17','',NULL,'','MTR E7'),
(304,8,50,-1,-1,'B1','B11','','Biaya Meterai Penetapan Perintah Penjualan Lelang',0.00,'Biaya Materai Penetapan Perintah Penjualan Lelang','T','',NULL,'admin','2012-11-17 22:37:58','',NULL,'','MTR E8'),
(305,8,50,-1,-1,'B1','B11','','Biaya Meterai Penetapan Pengosongan',0.00,'Biaya Materai Penetapan Pengosongan','T','',NULL,'admin','2012-11-17 22:38:44','',NULL,'','MTR E9'),
(306,8,50,-1,-1,'B1','B11','','Biaya Meterai Akta Pelaksanaan Penetapan Pengosongan',0.00,'Biaya Materai Akta Pelaksanaan Penetapan Pengosongan','T','',NULL,'admin','2012-11-17 22:39:43','',NULL,'','MTR E10'),
(307,6,10,-1,-1,'','A1','','Biaya Pemberitahuan Putusan Sela Kepada Penggugat',0.00,'Biaya Pemberitahuan Putusan Sela Kepada Penggugat','T','',NULL,'admin','2012-11-17 22:42:52','system','2012-11-30 16:39:24','','PBT A2'),
(308,6,10,-1,-1,'','A1','','Biaya Pemberitahuan Putusan Sela Kepada Tergugat',0.00,'Biaya Pemberitahuan Putusan Sela Kepada Tergugat','T','',NULL,'admin','2012-11-17 22:43:51','',NULL,'','PBT A4'),
(309,6,20,-1,-1,'','A1','','Biaya Pemberitahuan Inzage Kepada Terbanding',0.00,'Biaya Pemberitahuan Inzage Kepada Terbanding','T','',NULL,'admin','2012-11-17 22:46:21','',NULL,'','PBT B6'),
(310,6,20,-1,-1,'','A1','','Biaya Pemberitahuan Putusan Sela Kepada Pembanding',0.00,'Biaya Pemberitahuan Putusan Sela Kepada Pembanding','T','',NULL,'admin','2012-11-17 22:47:05','',NULL,'','PBT B7'),
(311,6,20,-1,-1,'','A1','','Biaya Pemberitahuan Putusan Sela Kepada Terbanding',0.00,'Biaya Pemberitahuan Putusan Sela Kepada Terbanding','T','',NULL,'admin','2012-11-17 22:47:53','',NULL,'','PBT B8'),
(312,6,20,-1,-1,'','A1','','Biaya Pemberitahuan Putusan Kepada Terbanding',0.00,'Biaya Pemberitahuan Putusan Kepada Terbanding','T','',NULL,'admin','2012-11-17 22:49:40','',NULL,'','PBT B9'),
(313,6,50,-1,-1,'','A1','','Biaya Pemberitahuan Lelang/Iklan',0.00,'Biaya Pemberitahuan Lelang/Iklan','T','',NULL,'admin','2012-11-17 22:58:25','',NULL,'','PBT E1'),
(314,6,50,-1,-1,'','A1','','Biaya Pemberitahuan Pengosongan Kepada Termohon',0.00,'Biaya Pemberitahuan Pengosongan Kepada Termohon','T','',NULL,'admin','2012-11-17 22:59:16','',NULL,'','PBT E2'),
(315,7,20,-1,-1,'','A1','','Biaya Pemeriksaan Banding',0.00,'Biaya Pemeriksaan Banding','T','',NULL,'admin','2012-11-17 23:04:33','system','2012-11-30 16:53:38','','PST B1'),
(316,5,10,-1,-1,'','A1','','Biaya Pelaksanaan Pencabutan Sita/RB',0.00,'Biaya Pelaksanaan Pencabutan Sita/RB','T','',NULL,'admin','2012-11-17 23:10:06','',NULL,'','JST A4'),
(317,5,50,-1,-1,'','A1','','Biaya Pelaksanaan Sita Eksekusi',0.00,'Biaya Pelaksanaan Sita Eksekusi','T','',NULL,'admin','2012-11-17 23:12:15','',NULL,'','JST E1'),
(318,5,50,-1,-1,'','A1','','Biaya Pengangkatan/Pencabutan Sita Eksekusi',0.00,'Biaya Pengangkatan/Pencabutan Sita Eksekusi','T','',NULL,'admin','2012-11-17 23:13:07','',NULL,'','JST E2'),
(319,5,50,-1,-1,'','A1','','Biaya Pelaksanaan Pengangkatan/ Pencabutan Sita Eksekusi',0.00,'Biaya Pelaksanaan Pengangkatan/ Pencabutan Sita Eksekusi','T','',NULL,'admin','2012-11-17 23:13:55','',NULL,'','JST E3'),
(320,5,50,-1,-1,'','A1','','Biaya Pelaksanaan Lelang',0.00,'Biaya Pelaksanaan Lelang','T','',NULL,'admin','2012-11-17 23:29:53','admin','2012-11-17 23:30:09','','JST E4'),
(321,5,50,-1,-1,'','A1','','Biaya Pelaksanaan Pengosongan',0.00,'Biaya Pelaksanaan Pengosongan','T','',NULL,'admin','2012-11-17 23:31:17','',NULL,'','JST E5'),
(322,6,40,-1,-1,'','A1','','Biaya Penyerahan Kontra Memori PK',0.00,'Biaya Penyerahan Kontra Memori PK','T','',NULL,'admin','2012-11-17 23:33:25','admin','2012-11-17 23:39:35','','PBT D5'),
(323,6,30,-1,-1,'','A1','','Biaya Penyerahan Memori Kasasi',0.00,'Biaya Penyerahan Memori Kasasi','T','',NULL,'admin','2012-11-17 23:34:41','admin','2012-11-17 23:37:48','','PBT C6'),
(324,6,30,-1,-1,'','A1','','Biaya Penyerahan Kontra Memori Kasasi',0.00,'Biaya Penyerahan Kontra Memori Kasasi','T','',NULL,'admin','2012-11-17 23:35:19','admin','2012-11-17 23:38:23','','PBT C7'),
(325,6,50,-1,-1,'','A1','','Biaya Panggilan Terhadap Termohon Eksekusi',0.00,'Biaya Panggilan Terhadap Termohon Eksekusi','T','',NULL,'admin','2012-11-17 23:41:13','',NULL,'','PBT E3'),
(326,7,30,-1,-1,'','A1','','Biaya Pemeriksaan Kasasi',0.00,'Biaya Pemeriksaan Kasasi','T','',NULL,'system','2012-11-30 16:53:13','',NULL,'','PST C1'),
(327,7,40,-1,-1,'','A1','','Biaya Pemeriksaan PK',0.00,'Biaya Pemeriksaan PK','T','',NULL,'system','2012-11-30 16:54:50','',NULL,'','PST D1'),
(328,13,99,-1,1,'A1','','','Memperlihatkan surat kepada yang berkepentingan mengenai surat-surat yang tersimpan di kepaniteraan ',0.00,'Memperlihatkan surat kepada yang berkepentingan mengenai surat-surat yang tersimpan di kepaniteraan (PP No. 53 Tahun 2008 E.3)','T','',NULL,'admin','2013-02-13 18:11:07','',NULL,'','HHK 3'),
(329,13,99,-1,1,'A1',NULL,'','Penyitaan/eksekusi barang yang bergerak atau yang tidak bergerak dan untuk pencatatan pencabutan',0.00,'Penyitaan/eksekusi barang yang bergerak atau yang tidak bergerak dan untuk pencatatan pencabutan suatu penyitaan di dalam berita acara turunan  (PP No. 53 Tahun 2008 E.6)','T','',NULL,'admin','2013-02-13 18:12:54','',NULL,'','HHK 4'),
(330,13,99,-1,1,'A1',NULL,'','Pengesahan Surat dibawah tangan (PP No. 53 Tahun 2008 E.16)',0.00,'Pengesahan Surat dibawah tangan (PP No. 53 Tahun 2008 E.16)','T','',NULL,'admin','2013-02-13 18:16:55','',NULL,'','HHK 9'),
(331,13,99,-1,1,'A1',NULL,'','Melakukan penjualan dimuka umum/lelang atas perintah pengadilan (PP No. 53 Tahun 2008 E.7)',0.00,'Melakukan penjualan dimuka umum/lelang atas perintah pengadilan (PP No. 53 Tahun 2008 E.7)','T','',NULL,'admin','2013-02-13 18:41:54','',NULL,'','HHK 5'),
(332,13,99,-1,1,'A1',NULL,'','Penyerahan akta di Kepaniteraan yang dilakukan di dalam hal yang diharuskan menurut hukum',0.00,'Penyerahan akta di Kepaniteraan yang dilakukan di dalam hal yang diharuskan menurut hukum (PP No. 53 Tahun 2008 E.11.1)','T','',NULL,'admin','2013-02-13 18:48:09','',NULL,'','HHK 6'),
(333,13,99,-1,1,'A1',NULL,'','Penyerahan surat dari berkas perkara (PP No. 53 Tahun 2008 E.11.3)',0.00,'Penyerahan surat dari berkas perkara (PP No. 53 Tahun 2008 E.11.3)','T','',NULL,'admin','2013-02-13 18:56:29','',NULL,'','HHK 7'),
(334,13,99,-1,1,'A1',NULL,'','Akta asli yang dibuat di Kepaniteraan, dikecualikan penyimpanan akta catatan sipil',0.00,'Akta asli yang dibuat di Kepaniteraan, dikecualikan penyimpanan akta catatan sipil dan pemasukan atau pemindahan sesuatu akta tersebut begitu pula dari segala keterangan-keterangan tertulis yang dikeluarkan oleh Panitera dalam hal yang diharuskan menurut ','T','',NULL,'admin','2013-02-13 18:57:19','',NULL,'','HHK 8'),
(335,13,99,-1,1,'A1',NULL,'','Legalisasi dari satu atau lebih tanda tangan di dalam akta termasuk akta catatan sipil',0.00,'Legalisasi dari satu atau lebih tanda tangan di dalam akta termasuk akta catatan sipil, dengan tidak mengurangi yang telah ditetapkan dalam ord. S.1916 No. 46 (PP No. 53 Tahun 2008 E.13)','T','',NULL,'admin','2013-02-13 18:58:05','',NULL,'','HHK 12'),
(336,13,99,-1,1,'A1',NULL,'','Pendaftaran surat kuasa untuk mewakili pihak yang berperkara di Pengadilan',0.00,'Pendaftaran surat kuasa untuk mewakili pihak yang berperkara di Pengadilan (PP No. 53 Tahun 2008 E.14)','T','',NULL,'admin','2013-02-13 18:58:54','',NULL,'','HHK 10'),
(337,13,99,-1,1,'A1',NULL,'','Pembuatan surat kuasa insidentil  (PP No. 53 Tahun 2008 E.15)',0.00,'Pembuatan surat kuasa insidentil  (PP No. 53 Tahun 2008 E.15)','T','',NULL,'admin','2013-02-13 18:59:35','',NULL,'','HHK 11'),
(338,2,10,-1,-1,'','A1','','Pengembalian Kepada Negara',0.00,'Pengembalian Kepada Negara','T','',NULL,'admin','2013-02-14 11:41:04','admin','2013-02-14 11:41:33','','SPJR A2'),
(339,2,20,-1,-1,'','A1','','Pengembalian Kepada Negara',0.00,'Pengembalian Kepada Negara','T','',NULL,'admin','2013-02-14 11:42:42','',NULL,'','SPJR B2'),
(340,2,30,-1,-1,'','A1','','Pengembalian Kepada Negara',0.00,'Pengembalian Kepada Negara','T','',NULL,'admin','2013-02-14 11:43:09','',NULL,'','SPJR C2'),
(341,2,40,-1,-1,'','A1','','Pengembalian Kepada Negara',0.00,'Pengembalian Kepada Negara','T','',NULL,'admin','2013-02-14 11:44:20','admin','2013-02-14 11:44:38','','SPJR D2'),
(342,2,50,-1,-1,'','A1','','Pengembalian Kepada Negara',0.00,'Pengembalian Kepada Negara','T','',NULL,'admin','2013-02-14 11:45:39','',NULL,'','SPJR E2'),
(343,13,10,-1,0,'B9','B1','','Leges',0.00,'Biaya Leges','T','',NULL,'admin','2013-03-01 17:09:55','',NULL,'','HHK A3'),
(344,13,20,-1,0,'B9','B1','','Leges',0.00,'Biaya Leges','T','',NULL,'admin','2013-03-01 17:10:42','',NULL,'','HHK B3'),
(345,13,30,-1,0,'B9','B1','','Leges',0.00,'Biaya Leges','T','',NULL,'admin','2013-03-01 17:11:08','',NULL,'','HHK C3'),
(346,13,40,-1,0,'B9','B1','','Leges',0.00,'Biaya Leges','T','',NULL,'admin','2013-03-01 17:11:45','',NULL,'','HHK D3'),
(347,13,50,-1,0,'B9','B1','','Leges',0.00,'Biaya Leges','T','',NULL,'admin','2013-03-01 17:12:13','',NULL,'','HHK E3'),
(348,13,99,-1,1,'A1','','','Penyerahan Turunan / Salinan / Putusan Penetapan Pengadilan (PP No. 53 Tahun 2008 E.1)',0.00,'Penyerahan Turunan / Salinan / Putusan Penetapan Pengadilan (PP No. 53 Tahun 2008 E.1)','T','',NULL,'angga','2013-03-25 11:42:19','',NULL,'','HHK 1'),
(349,14,50,-1,-1,'','A1','','Saksi',0.00,'Saksi','T','',NULL,'angga','2013-03-26 11:44:15','',NULL,'','LLN 01'),
(350,14,50,-1,-1,'','A1','','Keamanan',0.00,'Keamanan','T','',NULL,'angga','2013-03-26 11:44:59','',NULL,'','LLN 02'),
(351,13,99,-1,1,'A1',NULL,'','Upah Tulis',0.00,'Biaya Upah Tulis','T',NULL,NULL,'system','2012-04-23 10:47:04',NULL,NULL,'','HHK 1'),
(352,13,99,-1,1,'A1',NULL,'','Pencatatan pembuatan akta atau berita acara penyumpahan atau dari putusan-putusan lainnya ',0.00,'Pencatatan pembuatan akta atau berita acara penyumpahan atau dari putusan-putusan lainnya yang bukan sebagai akibat keputusan Pengadilan  (PP No. 53 Tahun 2008 E.10)','T',NULL,NULL,'system','2012-04-23 10:49:23','system','2012-11-15 23:53:01','','HHK 2'),
(353,13,99,-1,1,'A1',NULL,'','Memperlihatkan surat kepada yang berkepentingan mengenai surat-surat yang tersimpan di kepaniteraan ',0.00,'Memperlihatkan surat kepada yang berkepentingan mengenai surat-surat yang tersimpan di kepaniteraan (PP No. 53 Tahun 2008 E.3)','T',NULL,NULL,'admin','2013-02-13 18:11:07',NULL,NULL,'','HHK 3'),
(354,13,99,-1,1,'A1',NULL,'','Penyitaan/eksekusi barang yang bergerak atau yang tidak bergerak dan untuk pencatatan pencabutan',0.00,'Penyitaan/eksekusi barang yang bergerak atau yang tidak bergerak dan untuk pencatatan pencabutan suatu penyitaan di dalam berita acara turunan  (PP No. 53 Tahun 2008 E.6)','T',NULL,NULL,'admin','2013-02-13 18:12:54',NULL,NULL,'','HHK 4'),
(355,13,99,-1,1,'A1',NULL,'','Pengesahan Surat dibawah tangan (PP No. 53 Tahun 2008 E.16)',0.00,'Pengesahan Surat dibawah tangan (PP No. 53 Tahun 2008 E.16)','T',NULL,NULL,'admin','2013-02-13 18:16:55',NULL,NULL,'','HHK 9'),
(356,13,99,-1,1,'A1',NULL,'','Melakukan penjualan dimuka umum/lelang atas perintah pengadilan (PP No. 53 Tahun 2008 E.7)',0.00,'Melakukan penjualan dimuka umum/lelang atas perintah pengadilan (PP No. 53 Tahun 2008 E.7)','T',NULL,NULL,'admin','2013-02-13 18:41:54',NULL,NULL,'','HHK 5'),
(357,13,99,-1,1,'A1',NULL,'','Penyerahan akta di Kepaniteraan yang dilakukan di dalam hal yang diharuskan menurut hukum',0.00,'Penyerahan akta di Kepaniteraan yang dilakukan di dalam hal yang diharuskan menurut hukum (PP No. 53 Tahun 2008 E.11.1)','T',NULL,NULL,'admin','2013-02-13 18:48:09',NULL,NULL,'','HHK 6'),
(358,13,99,-1,1,'A1',NULL,'','Penyerahan surat dari berkas perkara (PP No. 53 Tahun 2008 E.11.3)',0.00,'Penyerahan surat dari berkas perkara (PP No. 53 Tahun 2008 E.11.3)','T',NULL,NULL,'admin','2013-02-13 18:56:29',NULL,NULL,'','HHK 7'),
(359,13,99,-1,1,'A1',NULL,'','Akta asli yang dibuat di Kepaniteraan, dikecualikan penyimpanan akta catatan sipil',0.00,'Akta asli yang dibuat di Kepaniteraan, dikecualikan penyimpanan akta catatan sipil dan pemasukan atau pemindahan sesuatu akta tersebut begitu pula dari segala keterangan-keterangan tertulis yang dikeluarkan oleh Panitera dalam hal yang diharuskan menurut ','T',NULL,NULL,'admin','2013-02-13 18:57:19',NULL,NULL,'','HHK 8'),
(360,13,99,-1,1,'A1',NULL,'','Legalisasi dari satu atau lebih tanda tangan di dalam akta termasuk akta catatan sipil',0.00,'Legalisasi dari satu atau lebih tanda tangan di dalam akta termasuk akta catatan sipil, dengan tidak mengurangi yang telah ditetapkan dalam ord. S.1916 No. 46 (PP No. 53 Tahun 2008 E.13)','T',NULL,NULL,'admin','2013-02-13 18:58:05',NULL,NULL,'','HHK 12'),
(361,13,99,-1,1,'A1',NULL,'','Pendaftaran surat kuasa untuk mewakili pihak yang berperkara di Pengadilan',0.00,'Pendaftaran surat kuasa untuk mewakili pihak yang berperkara di Pengadilan (PP No. 53 Tahun 2008 E.14)','T',NULL,NULL,'admin','2013-02-13 18:58:54',NULL,NULL,'','HHK 10'),
(362,13,99,-1,1,'A1',NULL,'','Pembuatan surat kuasa insidentil  (PP No. 53 Tahun 2008 E.15)',0.00,'Pembuatan surat kuasa insidentil  (PP No. 53 Tahun 2008 E.15)','T',NULL,NULL,'admin','2013-02-13 18:59:35',NULL,NULL,'','HHK 11'),
(363,13,99,-1,1,'A1',NULL,'','Penyerahan Turunan / Salinan / Putusan Penetapan Pengadilan (PP No. 53 Tahun 2008 E.1)',0.00,'Penyerahan Turunan / Salinan / Putusan Penetapan Pengadilan (PP No. 53 Tahun 2008 E.1)','T',NULL,NULL,'angga','2013-03-25 11:42:19',NULL,NULL,'','HHK 1'),
(364,13,99,-1,1,'A1',NULL,'','Upah Tulis',0.00,'Biaya Upah Tulis','T',NULL,NULL,'system','2012-04-23 10:47:04',NULL,NULL,'','HHK 1'),
(365,13,99,-1,1,'A1',NULL,'','Pencatatan pembuatan akta atau berita acara penyumpahan atau dari putusan-putusan lainnya ',0.00,'Pencatatan pembuatan akta atau berita acara penyumpahan atau dari putusan-putusan lainnya yang bukan sebagai akibat keputusan Pengadilan  (PP No. 53 Tahun 2008 E.10)','T',NULL,NULL,'system','2012-04-23 10:49:23','system','2012-11-15 23:53:01','','HHK 2'),
(366,13,99,-1,1,'A1',NULL,'','Memperlihatkan surat kepada yang berkepentingan mengenai surat-surat yang tersimpan di kepaniteraan ',0.00,'Memperlihatkan surat kepada yang berkepentingan mengenai surat-surat yang tersimpan di kepaniteraan (PP No. 53 Tahun 2008 E.3)','T',NULL,NULL,'admin','2013-02-13 18:11:07',NULL,NULL,'','HHK 3'),
(367,13,99,-1,1,'A1',NULL,'','Penyitaan/eksekusi barang yang bergerak atau yang tidak bergerak dan untuk pencatatan pencabutan',0.00,'Penyitaan/eksekusi barang yang bergerak atau yang tidak bergerak dan untuk pencatatan pencabutan suatu penyitaan di dalam berita acara turunan  (PP No. 53 Tahun 2008 E.6)','T',NULL,NULL,'admin','2013-02-13 18:12:54',NULL,NULL,'','HHK 4'),
(368,13,99,-1,1,'A1',NULL,'','Pengesahan Surat dibawah tangan (PP No. 53 Tahun 2008 E.16)',0.00,'Pengesahan Surat dibawah tangan (PP No. 53 Tahun 2008 E.16)','T',NULL,NULL,'admin','2013-02-13 18:16:55',NULL,NULL,'','HHK 9'),
(369,13,99,-1,1,'A1',NULL,'','Melakukan penjualan dimuka umum/lelang atas perintah pengadilan (PP No. 53 Tahun 2008 E.7)',0.00,'Melakukan penjualan dimuka umum/lelang atas perintah pengadilan (PP No. 53 Tahun 2008 E.7)','T',NULL,NULL,'admin','2013-02-13 18:41:54',NULL,NULL,'','HHK 5'),
(370,13,99,-1,1,'A1',NULL,'','Penyerahan akta di Kepaniteraan yang dilakukan di dalam hal yang diharuskan menurut hukum',0.00,'Penyerahan akta di Kepaniteraan yang dilakukan di dalam hal yang diharuskan menurut hukum (PP No. 53 Tahun 2008 E.11.1)','T',NULL,NULL,'admin','2013-02-13 18:48:09',NULL,NULL,'','HHK 6'),
(371,13,99,-1,1,'A1',NULL,'','Penyerahan surat dari berkas perkara (PP No. 53 Tahun 2008 E.11.3)',0.00,'Penyerahan surat dari berkas perkara (PP No. 53 Tahun 2008 E.11.3)','T',NULL,NULL,'admin','2013-02-13 18:56:29',NULL,NULL,'','HHK 7'),
(372,13,99,-1,1,'A1',NULL,'','Akta asli yang dibuat di Kepaniteraan, dikecualikan penyimpanan akta catatan sipil',0.00,'Akta asli yang dibuat di Kepaniteraan, dikecualikan penyimpanan akta catatan sipil dan pemasukan atau pemindahan sesuatu akta tersebut begitu pula dari segala keterangan-keterangan tertulis yang dikeluarkan oleh Panitera dalam hal yang diharuskan menurut ','T',NULL,NULL,'admin','2013-02-13 18:57:19',NULL,NULL,'','HHK 8'),
(373,13,99,-1,1,'A1',NULL,'','Legalisasi dari satu atau lebih tanda tangan di dalam akta termasuk akta catatan sipil',0.00,'Legalisasi dari satu atau lebih tanda tangan di dalam akta termasuk akta catatan sipil, dengan tidak mengurangi yang telah ditetapkan dalam ord. S.1916 No. 46 (PP No. 53 Tahun 2008 E.13)','T',NULL,NULL,'admin','2013-02-13 18:58:05',NULL,NULL,'','HHK 12'),
(374,13,99,-1,1,'A1',NULL,'','Pendaftaran surat kuasa untuk mewakili pihak yang berperkara di Pengadilan',0.00,'Pendaftaran surat kuasa untuk mewakili pihak yang berperkara di Pengadilan (PP No. 53 Tahun 2008 E.14)','T',NULL,NULL,'admin','2013-02-13 18:58:54',NULL,NULL,'','HHK 10'),
(375,13,99,-1,1,'A1',NULL,'','Pembuatan surat kuasa insidentil  (PP No. 53 Tahun 2008 E.15)',0.00,'Pembuatan surat kuasa insidentil  (PP No. 53 Tahun 2008 E.15)','T',NULL,NULL,'admin','2013-02-13 18:59:35',NULL,NULL,'','HHK 11'),
(376,13,99,-1,1,'A1',NULL,'','Penyerahan Turunan / Salinan / Putusan Penetapan Pengadilan (PP No. 53 Tahun 2008 E.1)',0.00,'Penyerahan Turunan / Salinan / Putusan Penetapan Pengadilan (PP No. 53 Tahun 2008 E.1)','T',NULL,NULL,'angga','2013-03-25 11:42:19',NULL,NULL,'','HHK 1'),
(377,7,50,-1,-1,'','A1','','Pemeriksaan Setempat',0.00,'Biaya Pemeriksaan Setempat','T','',NULL,'system','2016-10-11 10:44:17','admin','2016-10-11 23:03:48','','PST A1'),
(378,4,50,-1,-1,'','A1','','Biaya Panggilan Pemohon',0.00,'Biaya Panggilan Pemohon','T','',NULL,'system','2016-11-09 10:32:28','',NULL,'',''),
(379,4,50,-1,-1,'','A1','','Biaya Panggilan Termohon',0.00,'Biaya Panggilan Termohon','T','',NULL,'system','2016-11-09 10:32:57','',NULL,'',''),
(380,4,10,-1,-1,'','A1','','Biaya Panggilan Mediasi Penggugat',0.00,'Biaya Panggilan Mediasi Penggugat','T','',NULL,'admin','2016-11-24 10:32:57','',NULL,'',''),
(381,4,10,-1,-1,'','A1','','Biaya Panggilan Mediasi Tergugat',0.00,'Biaya Panggilan Mediasi Tergugat','T','',NULL,'admin','2016-11-24 10:32:57','',NULL,'',''),
(500,0,200,1,0,'B11','A1','','Pembelian Materai',0.00,'Pembelian materai (nilai persediaan materai bertambah)','T','',NULL,'',NULL,'',NULL,'','MTR T1'),
(501,0,200,-1,-1,'A1','B11','','Pembelian materai (nilai Kas tunai berkurang)',0.00,'Pembelian materai (nilai Kas tunai berkurang)','T','',NULL,'',NULL,'',NULL,'','MTR T2'),
(502,51,200,1,1,'A1','','','Penerimaan Uang Iwadl',0.00,'Penerimaan Uang Iwadl','Y','',NULL,'',NULL,'',NULL,'','IWD T1'),
(503,51,200,-1,-1,'','A1','','Penyetoran Uang Iwadl',0.00,'Setor Uang Iwad','Y','',NULL,'',NULL,'',NULL,'','IWD T2'),
(504,52,200,1,1,'A2',NULL,'','Penerimaan Uang Konsignasi',0.00,'Penerimaan Uang Konsignasi','Y','',NULL,'',NULL,'',NULL,'','KON 1'),
(505,52,200,-1,-1,'','A1','','Penyerahan Uang Konsignasi',0.00,'Penyerahan Uang Konsignasi','Y','',NULL,'',NULL,'',NULL,'','KON 2'),
(506,53,200,1,1,'A2',NULL,'','Penerimaan Uang Eksekusi',0.00,'Penerimaan Uang Eksekusi','Y','',NULL,'',NULL,'',NULL,'','JTS T1'),
(507,53,200,-1,-1,'','A1','','Penyerahan Uang Eksekusi',0.00,'Penyerahan Uang Eksekusi','Y','',NULL,'',NULL,'',NULL,'','JTS T2'),
(508,12,200,1,-1,'','A1','','Pembelian ATK',0.00,'Pembelian ATK','Y','',NULL,'',NULL,'',NULL,'','ATK T1'),
(509,12,200,-1,-1,'B8',NULL,'','Penggunaan ATK',0.00,'Penggunaan ATK','T','',NULL,'',NULL,'',NULL,'','ATK T2'),
(510,0,200,1,0,'A1','A2','','Tarik Tunai',0.00,'Tarik Tunai','T','',NULL,'',NULL,'',NULL,'','BNK 01'),
(511,0,200,1,0,'A2','A1','','Setor Bank ',0.00,'Yang dimaksud Setor Bank adalah Bukan Penyetoran HHK/PNBP tetapi Uang Tunai atau Lainnya yang disetor ke Bank','T','',NULL,'',NULL,'',NULL,'','BNK 02'),
(512,0,200,-1,-1,'','A1','','Setor HAK-HAK KEPANITERAAN/PNBP',0.00,'Setor HAK-HAK KEPANITERAAN/PNBP','T','',NULL,'',NULL,'',NULL,'','SHHKP 1'),
(513,7,20,1,-1,'','A1','','Pengiriman Biaya Perkara Ke Tingkat Banding',0.00,'Pengiriman Biaya Perkara Ke Tingkat Banding','T','',NULL,'',NULL,'',NULL,'','KRB II'),
(514,7,30,1,-1,'','A1','','Pengiriman Biaya Perkara Kasasi',0.00,'Pengiriman Biaya Perkara Kasasi','T','',NULL,'',NULL,'',NULL,'','KRB III'),
(516,4,200,1,1,'JSP','JSP','','Bayar JSP',0.00,'Bayar JSP','Y','',NULL,'',NULL,'',NULL,'','JSP A1'),
(517,54,200,1,1,'DGS','DGS','','Penerimaan Uang Delegasi',0.00,'Penerimaan Uang Delegasi','Y','',NULL,'',NULL,'',NULL,'','DGS A1'),
(518,54,200,-1,-1,'DGS','DGS','','Pembayaran Uang Delegasi',0.00,'Penyerahan Uang Delegasi','Y','',NULL,'',NULL,'',NULL,'','DGS T1'),
(519,55,200,1,1,'VAL','VAL','','Penerimaan Perkara Belum Daftar',0.00,'Perkara Belum Daftar','Y','',NULL,'',NULL,'',NULL,'','VAL A1'),
(520,55,200,-1,-1,'VAL','VAL','','Pengeluaran Perkara Belum Didaftar',0.00,'Pengeluaran Perkara Belum Didaftar','Y','',NULL,'',NULL,'',NULL,'','VAL A2'),
(521,13,200,1,1,'PNBP','PNBP','','Setor Kas Negara',0.00,'','Y','',NULL,'',NULL,'',NULL,'','PNBP'),
(522,12,200,1,1,'FKP','Penggandaa','','Penggandaan (Fotokopi)',0.00,'','Y','',NULL,'',NULL,'',NULL,'','FKP'),
(523,1,200,1,1,'EKS','EKS','','Panjar Eksekusi (Jika tidak ada di SIPP)',0.00,'','Y','',NULL,'',NULL,'',NULL,'','EKS'),
(524,1,200,-1,-1,'','','','Penggunaan Panjar Eksekusi',0.00,'','Y','',NULL,'',NULL,'',NULL,'','EKS'),
(525,100,200,2,2,'TRK','TRK','','Penarikan Tunai dari Bank',0.00,'Penarikan Uang Tunai dari BANK','Y','',NULL,'',NULL,'',NULL,'','TRK'),
(526,100,200,-2,-2,'STR','STR','','Penyetoran Tunai ke Bank',0.00,'Penyetoran Uang Tunai ke BANK','Y','',NULL,'',NULL,'',NULL,'','STR'),
(527,101,200,1,1,'MTR','MTR','','Pembelian Materai',0.00,'Pembelian Materai (Mengurangi Buku Kas Tunai)','Y','',NULL,'',NULL,'',NULL,'','MTR'),
(528,13,99,-1,-1,'PNBP A12','PNBP A12','','Penerimaan PNBP Jasa Giro BANK',0.00,'Penerimaan PNBP Jasa Giro BANK','Y','',NULL,'',NULL,'',NULL,'','PNBP'),
(529,13,20,-1,-1,'PNBP A13','PNBP A13','','Penerimaan PNBP Penyerahan Akta Panggilan Pertama Tingkat Banding',0.00,'Penerimaan PNBP Penyerahan Akta Panggilan Pertama Tingkat Banding','Y','',NULL,'',NULL,'',NULL,'','PNBP'),
(530,13,10,-1,-1,'PNBP A14','PNBP A14','','Penerimaan PNBP Penyerahan Akta Panggilan Pertama Tingkat Kasasi',0.00,'Penerimaan PNBP Penyerahan Akta Panggilan Pertama Tingkat Kasasi','Y','',NULL,'',NULL,'',NULL,'','PNBP');

/*Table structure for table `keu_kategori_biaya_tambahan` */

DROP TABLE IF EXISTS `keu_kategori_biaya_tambahan`;

CREATE TABLE `keu_kategori_biaya_tambahan` (
  `id` int(11) unsigned NOT NULL COMMENT 'Primary key: (by system)',
  `kode` varchar(20) DEFAULT NULL COMMENT 'Kode Kategori Biaya: isian bebas',
  `nama` varchar(100) DEFAULT '' COMMENT 'Nama Kategori Biaya: isian bebas',
  `keterangan` varchar(500) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT '' COMMENT 'Keterangan: isian bebas',
  `aktif` char(1) NOT NULL DEFAULT 'Y' COMMENT 'Aktif: pilihan (Y=Aktif; T=Tidak Aktif)',
  `urutan` int(11) unsigned DEFAULT NULL,
  `diedit_oleh` varchar(30) DEFAULT '' COMMENT 'Diedit Oleh: (by system)',
  `diedit_tanggal` datetime DEFAULT NULL COMMENT 'Diedit Tanggal: (by system)',
  `diinput_oleh` varchar(30) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT '' COMMENT 'Diinput Oleh: (by system)',
  `diinput_tanggal` datetime DEFAULT NULL COMMENT 'Diinput Tanggal: (by system)',
  `diperbaharui_oleh` varchar(30) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT '' COMMENT 'Diperbaharui Oleh: (by system)',
  `diperbaharui_tanggal` datetime DEFAULT NULL COMMENT 'Diperbaharui Tanggal: (by system)',
  PRIMARY KEY (`id`),
  KEY `nama` (`nama`),
  KEY `diinput_tanggal` (`diinput_tanggal`),
  KEY `diperbaharui_tanggal` (`diperbaharui_tanggal`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='Referensi kategori biaya perkara';

/*Data for the table `keu_kategori_biaya_tambahan` */

insert  into `keu_kategori_biaya_tambahan`(`id`,`kode`,`nama`,`keterangan`,`aktif`,`urutan`,`diedit_oleh`,`diedit_tanggal`,`diinput_oleh`,`diinput_tanggal`,`diperbaharui_oleh`,`diperbaharui_tanggal`) values 
(1,'PJR','Panjar Perkara','Biaya Panjar Perkara','Y',1,'',NULL,'','2012-04-23 09:52:01','system','2012-04-23 10:16:08'),
(2,'SPJR','Sisa Panjar','Sisa Panjar Perkara','Y',14,'',NULL,'system','2012-04-23 10:07:02','',NULL),
(3,'KRB','Pengiriman','Biaya Pengiriman','Y',9,'',NULL,'system','2012-04-23 10:09:08','system','2012-04-23 10:16:19'),
(4,'PGL','Panggilan','Biaya Panggilan','Y',4,'',NULL,'system','2012-04-23 10:11:50','',NULL),
(5,'JST','Sita','Biaya Sita','Y',5,'',NULL,'system','2012-04-23 10:12:11','',NULL),
(6,'PBT','Pemberitahuan','Biaya Pemberitahuan','Y',8,'',NULL,'system','2012-04-23 10:12:32','',NULL),
(7,'PST','Pemeriksaan Setempat','Biaya Pemeriksaan Setempat','Y',7,'',NULL,'system','2012-04-23 10:13:03','',NULL),
(8,'MTR','Meterai','Biaya Meterai','Y',10,'admin','2012-10-18 09:22:18','system','2012-04-23 10:13:26','',NULL),
(9,'SMP','Sumpah','Biaya Penyumpahan','Y',6,'',NULL,'system','2012-04-23 10:13:42','',NULL),
(10,'PNJ','Penerjemah','Biaya Penerjemah','Y',11,'',NULL,'system','2012-04-23 10:13:59','',NULL),
(11,'PNBP','PNBP','Biaya Penerimaan Negara Bukan Pajak','Y',2,'',NULL,'system','2012-04-23 10:14:25','admin','2012-11-06 16:08:40'),
(12,'ATK','Alat Tulis Kantor','Biaya Alat Tulis Kantor','Y',3,'',NULL,'system','2012-04-23 10:14:49','',NULL),
(13,'HHK','Hak-Hak Kepaniteraan','Biaya Hak-Hak Kepaniteraan','Y',12,'',NULL,'system','2012-04-23 10:15:08','',NULL),
(14,'LLN','Lain-lain','Biaya Lain-lain','Y',13,'',NULL,'system','2012-04-23 10:15:27','',NULL),
(51,'IWDL','Iwadl','Uang Iwadl','Y',14,'',NULL,'','2018-11-28 16:42:43','',NULL),
(52,'KON','Konsignasi','Uang Konsignasi','Y',15,'',NULL,'',NULL,'',NULL),
(53,'EKS','Eksekusi','Uang Eksekusi','Y',16,'',NULL,'',NULL,'',NULL),
(54,'DGS','Delegasi','Uang Delegasi','Y',17,'',NULL,'',NULL,'',NULL),
(55,'BD','Perkara Belum Daftar','Perkara Belum Daftar','Y',18,'',NULL,'',NULL,'',NULL),
(100,'TRK','Transaksi BANK','Penarikan dan Setor Tunai Bank','Y',19,'',NULL,'',NULL,'',NULL),
(101,'MTR','Materai','Persediaan Materai','Y',19,'',NULL,'',NULL,'',NULL);

/*Table structure for table `keu_laporan_rekon` */

DROP TABLE IF EXISTS `keu_laporan_rekon`;

CREATE TABLE `keu_laporan_rekon` (
  `id` int(50) NOT NULL AUTO_INCREMENT,
  `tgl_start` date NOT NULL,
  `tgl_finish` date NOT NULL,
  `saldo_panjar_pa` decimal(16,2) DEFAULT NULL,
  `saldo_panjar_banding` decimal(16,2) DEFAULT NULL,
  `saldo_panjar_kasasi` decimal(16,2) DEFAULT NULL,
  `saldo_panjar_pk` decimal(16,2) DEFAULT NULL,
  `saldo_panjar_eksekusi` decimal(16,2) DEFAULT NULL,
  `spj_pa` decimal(16,2) DEFAULT NULL,
  `spj_banding` decimal(16,2) DEFAULT NULL,
  `spj_kasasi` decimal(16,2) DEFAULT NULL,
  `spj_pk` decimal(16,2) DEFAULT NULL,
  `spj_eksekusi` decimal(16,2) DEFAULT NULL,
  `saldo_atk` decimal(16,2) DEFAULT NULL,
  `saldo_panggilan` decimal(16,2) DEFAULT NULL,
  `saldo_hhk` decimal(16,2) DEFAULT NULL,
  `saldo_iwadl` decimal(16,2) DEFAULT NULL,
  `saldo_konsignasi` decimal(16,2) DEFAULT NULL,
  `saldo_eksekusi` decimal(16,2) DEFAULT NULL,
  `saldo_delegasi` decimal(16,2) DEFAULT NULL,
  `saldo_belum_daftar` decimal(16,2) DEFAULT NULL,
  `uang_tunai` decimal(16,2) unsigned DEFAULT NULL,
  `jml_materai` int(11) unsigned DEFAULT NULL,
  `uang_bank` decimal(16,2) unsigned DEFAULT NULL,
  `penjelasan_selisih_kas` varchar(250) DEFAULT '',
  `diedit_oleh` varchar(30) DEFAULT '',
  `diedit_tanggal` datetime DEFAULT NULL,
  `diinput_oleh` varchar(30) DEFAULT '',
  `diinput_tanggal` datetime DEFAULT NULL,
  `diperbaharui_oleh` varchar(30) DEFAULT '',
  `diperbaharui_tanggal` datetime DEFAULT NULL,
  `saldo_panjar_konsignasi` decimal(16,2) DEFAULT NULL,
  `st_kirim` int(2) DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `tgl_ba` (`tgl_finish`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `keu_laporan_rekon` */

/*Table structure for table `keu_master_radius` */

DROP TABLE IF EXISTS `keu_master_radius`;

CREATE TABLE `keu_master_radius` (
  `id` tinyint(5) NOT NULL AUTO_INCREMENT,
  `nama` varchar(50) NOT NULL,
  `nilai` decimal(16,2) DEFAULT 0.00,
  `keterangan` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `keu_master_radius` */

/*Table structure for table `keu_menus` */

DROP TABLE IF EXISTS `keu_menus`;

CREATE TABLE `keu_menus` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: (by system)',
  `menutype` varchar(24) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT 'Type Menu: merujuk ke tabel sys_menu_type kolom menutype',
  `parent_id` int(11) unsigned DEFAULT NULL COMMENT 'Induk Menu: merujuk ke tabel sys_menus kolom id (tree)',
  `level` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Level: (by system)',
  `title` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT 'Judul Menu: isian text bebas',
  `link` varchar(255) NOT NULL,
  `icon` varchar(255) DEFAULT NULL,
  `params` varchar(255) DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'The published state of the menu link.',
  `ordering` int(11) NOT NULL DEFAULT 0 COMMENT 'The relative ordering of the menu item in the tree.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `parent_id` (`parent_id`,`title`),
  KEY `menutype` (`menutype`),
  KEY `parent_id_2` (`parent_id`),
  KEY `level` (`level`),
  KEY `ordering` (`ordering`),
  KEY `published` (`published`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=378 COMMENT='Data Menu Aplikasi';

/*Data for the table `keu_menus` */

/*Table structure for table `keu_perkara_biaya_tambahan` */

DROP TABLE IF EXISTS `keu_perkara_biaya_tambahan`;

CREATE TABLE `keu_perkara_biaya_tambahan` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary key: (by system)',
  `id_pembiayaan` tinyint(1) DEFAULT 1 COMMENT '1:reguler;2:Prodeo DIPA;3:Prodeo Murni',
  `perkara_id` bigint(20) unsigned DEFAULT NULL COMMENT 'Id Perkara: merujuk ke tabel perkara kolom perkara_id (by system)',
  `tahapan_id` int(11) unsigned DEFAULT NULL COMMENT 'Tahapan Proses : merujuk ke tabel tahapan_proses (by system)',
  `kategori_id` int(11) unsigned DEFAULT NULL COMMENT 'Kategori Biaya: merujuk ke tabel kategori_biaya kolom id',
  `jenis_biaya_id` int(11) unsigned DEFAULT NULL COMMENT 'Jenis Biaya: merujuk ke tabel jenis_biaya kolom id',
  `pihak_id` bigint(20) DEFAULT NULL COMMENT 'ID Pihak pembayar',
  `pihak_ke` int(11) DEFAULT NULL COMMENT 'Pihak Pembayar ke (1=Penggugat, 2=Tergugat)',
  `urutan` int(11) unsigned DEFAULT NULL,
  `jenis_transaksi` tinyint(1) NOT NULL COMMENT 'Jenis Transaksi: -1=Pengeluaran; 1=Penerimaan',
  `tanggal_transaksi` date NOT NULL COMMENT 'Tanggal Tansaksi: isian tanggal',
  `uraian` varchar(500) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL DEFAULT '' COMMENT 'Uraian Transaksi: isian bebas',
  `jumlah` decimal(16,2) unsigned NOT NULL COMMENT 'Jumlah nominal tansaksi(dalam Rp)',
  `sisa` decimal(16,2) unsigned DEFAULT NULL COMMENT 'Jumlah Nominal Sisa: isian bilangan (Rp)',
  `keterangan` varchar(500) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL COMMENT 'Keterangan: isian bebas',
  `diedit_oleh` varchar(30) DEFAULT NULL COMMENT 'Diedit Oleh: (by system)',
  `diedit_tanggal` datetime DEFAULT NULL COMMENT 'Diedit Tanggal: (by system)',
  `diinput_oleh` varchar(30) DEFAULT NULL COMMENT 'Diinput Oleh: (by system)',
  `diinput_tanggal` datetime DEFAULT NULL COMMENT 'Diinput Tanggal: (by system)',
  `diperbaharui_oleh` varchar(30) DEFAULT NULL COMMENT 'Diperbaharui Oleh: (by system)',
  `diperbaharui_tanggal` datetime DEFAULT NULL COMMENT 'Diperbaharui Tanggal: (by system)',
  PRIMARY KEY (`id`),
  KEY `perkara_id` (`perkara_id`),
  KEY `jenis_biaya_id` (`jenis_biaya_id`),
  KEY `jumlah` (`jumlah`),
  KEY `urutan` (`urutan`),
  KEY `tahapan_id` (`tahapan_id`),
  KEY `kategori_id` (`kategori_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='Data Biaya Perkara';

/*Data for the table `keu_perkara_biaya_tambahan` */

/*Table structure for table `keu_perkara_masuk` */

DROP TABLE IF EXISTS `keu_perkara_masuk`;

CREATE TABLE `keu_perkara_masuk` (
  `perkara_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary key (by system)',
  `tanggal_pendaftaran` date DEFAULT NULL COMMENT 'Tanggal Pendaftaran: isian tanggal',
  `nomor_urut_register` int(11) unsigned DEFAULT NULL COMMENT 'Nomor Urut Buku Register: Reset per bulan',
  `nomor_urut_perkara` int(11) unsigned DEFAULT NULL COMMENT 'Nomor Urut Perkara: reset per tahun untuk tiap alur_perkara_id (manual/by system)',
  `tahun_perkara` int(11) DEFAULT NULL,
  `nomor_perkara` varchar(50) NOT NULL COMMENT 'Nomor Perkara: (manual/by system)',
  `nomor_indeks` varchar(50) DEFAULT NULL COMMENT 'Nomor Indeks Perkara: untuk keperluan pengurutan data berdasarkan tahun,alur perkara dan nomor urut perkara (by system)',
  `para_pihak` text DEFAULT NULL,
  `jenis_perkara` int(10) DEFAULT NULL,
  `keterangan` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`perkara_id`),
  UNIQUE KEY `nomor_perkara` (`nomor_perkara`),
  KEY `nomor_indeks` (`nomor_indeks`),
  KEY `tanggal_pendaftaran` (`tanggal_pendaftaran`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='Data Induk Perkara';

/*Data for the table `keu_perkara_masuk` */

/*Table structure for table `keu_perkara_putus` */

DROP TABLE IF EXISTS `keu_perkara_putus`;

CREATE TABLE `keu_perkara_putus` (
  `perkara_id` bigint(20) unsigned NOT NULL COMMENT 'Primary key (by system)',
  `tanggal_putusan` date NOT NULL,
  PRIMARY KEY (`perkara_id`,`tanggal_putusan`),
  KEY `tanggal_putusan` (`tanggal_putusan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='Data Putusan Perkara';

/*Data for the table `keu_perkara_putus` */

/*Table structure for table `keu_register_kas` */

DROP TABLE IF EXISTS `keu_register_kas`;

CREATE TABLE `keu_register_kas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_ba` int(11) NOT NULL,
  `100ribuan` int(11) NOT NULL DEFAULT 0,
  `50ribuan` int(11) NOT NULL DEFAULT 0,
  `20ribuan` int(11) NOT NULL DEFAULT 0,
  `10ribuan` int(11) NOT NULL DEFAULT 0,
  `5ribuan` int(11) NOT NULL DEFAULT 0,
  `1ribuan` int(11) NOT NULL DEFAULT 0,
  `5ratusan` int(11) NOT NULL DEFAULT 0,
  `1ratusan` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `keu_register_kas` */

/*Table structure for table `keu_rencana_pemanggilan` */

DROP TABLE IF EXISTS `keu_rencana_pemanggilan`;

CREATE TABLE `keu_rencana_pemanggilan` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `jsp_id` int(10) NOT NULL,
  `sidang_id` int(10) NOT NULL,
  `pihak_id` int(11) DEFAULT NULL,
  `tgl_rencana` date NOT NULL,
  `jns_pgl` tinyint(2) DEFAULT NULL,
  `biaya_panggilan` decimal(16,2) DEFAULT NULL,
  `keterangan` text DEFAULT NULL,
  `tgl_pelaksanaan` date DEFAULT NULL,
  `status_pembayaran` tinyint(5) NOT NULL DEFAULT 0,
  `ket_temu` varchar(2) DEFAULT NULL,
  `ket_pelaksanaan` text DEFAULT NULL,
  `tgl_pembayaran` date DEFAULT NULL,
  `diinput_tanggal` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `keu_rencana_pemanggilan` */

/*Table structure for table `keu_saldo_awal_bku` */

DROP TABLE IF EXISTS `keu_saldo_awal_bku`;

CREATE TABLE `keu_saldo_awal_bku` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `saldo_awal_tanggal` date DEFAULT NULL,
  `saldo_awal_kas_tunai` decimal(16,2) unsigned DEFAULT 0.00,
  `saldo_awal_bank` decimal(16,2) unsigned DEFAULT 0.00,
  `saldo_awal_meterai` int(10) unsigned DEFAULT 0,
  `saldo_awal_panjar_pa` decimal(16,2) DEFAULT 0.00,
  `saldo_awal_spj_pa` decimal(16,2) unsigned DEFAULT 0.00,
  `saldo_awal_panjar_banding` decimal(16,2) unsigned DEFAULT 0.00,
  `saldo_awal_spj_banding` decimal(16,2) DEFAULT 0.00,
  `saldo_awal_panjar_kasasi` decimal(16,2) unsigned DEFAULT 0.00,
  `saldo_awal_spj_kasasi` decimal(16,2) DEFAULT 0.00,
  `saldo_awal_panjar_pk` decimal(16,2) unsigned DEFAULT 0.00,
  `saldo_awal_spj_pk` decimal(16,2) DEFAULT 0.00,
  `saldo_awal_panjar_eksekusi` decimal(16,2) DEFAULT 0.00,
  `saldo_awal_spj_eksekusi` decimal(16,2) DEFAULT 0.00,
  `saldo_awal_uang_panggilan` decimal(16,2) DEFAULT 0.00,
  `saldo_awal_atk` decimal(16,2) unsigned DEFAULT 0.00,
  `saldo_awal_iwadl` decimal(16,2) unsigned DEFAULT 0.00,
  `saldo_awal_hhk_pnbp` decimal(16,2) unsigned DEFAULT 0.00,
  `saldo_awal_uang_eksekusi` decimal(16,2) unsigned DEFAULT 0.00,
  `saldo_awal_uang_konsignasi` decimal(16,2) unsigned DEFAULT 0.00,
  `saldo_awal_delegasi` decimal(16,2) DEFAULT 0.00,
  `saldo_awal_perkara_belum_daftar` decimal(16,2) unsigned DEFAULT 0.00,
  `saldo_awal_keterangan` varchar(100) DEFAULT '',
  `saldo_awal_panjar_konsignasi` decimal(16,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`),
  UNIQUE KEY `saldo_awal_tanggal` (`saldo_awal_tanggal`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `keu_saldo_awal_bku` */

/*Table structure for table `master_radius` */

DROP TABLE IF EXISTS `master_radius`;

CREATE TABLE `master_radius` (
  `id` tinyint(5) NOT NULL AUTO_INCREMENT,
  `nama` varchar(50) NOT NULL,
  `nilai` decimal(16,2) DEFAULT 0.00,
  `keterangan` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

/*Data for the table `master_radius` */

insert  into `master_radius`(`id`,`nama`,`nilai`,`keterangan`) values 
(1,'Radius I',100000.00,NULL),
(2,'Radius II',150000.00,NULL),
(3,'Radius III',200000.00,NULL),
(4,'Luar Kota',250000.00,NULL);

/*Table structure for table `register_m_jenis_register` */

DROP TABLE IF EXISTS `register_m_jenis_register`;

CREATE TABLE `register_m_jenis_register` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `register_kode` varchar(10) NOT NULL,
  `register_nama` varchar(200) NOT NULL,
  `keterangan` varchar(500) NOT NULL,
  `aktif` char(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

/*Data for the table `register_m_jenis_register` */

/*Table structure for table `register_perkara_masuk` */

DROP TABLE IF EXISTS `register_perkara_masuk`;

CREATE TABLE `register_perkara_masuk` (
  `perkara_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary key (by system)',
  `tanggal_pendaftaran` date DEFAULT NULL COMMENT 'Tanggal Pendaftaran: isian tanggal',
  `nomor_urut_register` int(11) unsigned DEFAULT NULL COMMENT 'Nomor Urut Buku Register: Reset per bulan',
  `nomor_urut_perkara` int(11) unsigned DEFAULT NULL COMMENT 'Nomor Urut Perkara: reset per tahun untuk tiap alur_perkara_id (manual/by system)',
  `tahun_perkara` int(11) DEFAULT NULL,
  `nomor_perkara` varchar(50) NOT NULL COMMENT 'Nomor Perkara: (manual/by system)',
  `nomor_indeks` varchar(50) DEFAULT NULL COMMENT 'Nomor Indeks Perkara: untuk keperluan pengurutan data berdasarkan tahun,alur perkara dan nomor urut perkara (by system)',
  `para_pihak` text DEFAULT NULL,
  `jenis_perkara_id` int(10) DEFAULT NULL,
  `keterangan` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`perkara_id`),
  UNIQUE KEY `nomor_perkara` (`nomor_perkara`),
  KEY `nomor_indeks` (`nomor_indeks`),
  KEY `tanggal_pendaftaran` (`tanggal_pendaftaran`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='Data Induk Perkara';

/*Data for the table `register_perkara_masuk` */

/*Table structure for table `register_perkara_putus` */

DROP TABLE IF EXISTS `register_perkara_putus`;

CREATE TABLE `register_perkara_putus` (
  `perkara_id` bigint(20) unsigned NOT NULL COMMENT 'Primary key (by system)',
  `tanggal_putusan` date NOT NULL,
  PRIMARY KEY (`perkara_id`,`tanggal_putusan`),
  KEY `tanggal_putusan` (`tanggal_putusan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='Data Putusan Perkara';

/*Data for the table `register_perkara_putus` */

/*Table structure for table `register_permohonan_penetapan_ikrh` */

DROP TABLE IF EXISTS `register_permohonan_penetapan_ikrh`;

CREATE TABLE `register_permohonan_penetapan_ikrh` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `urutan` int(11) NOT NULL,
  `nomor_permohonan` varchar(50) NOT NULL,
  `tanggal_pendaftaran` date NOT NULL,
  `nama_pemohon` varchar(500) NOT NULL,
  `keterangan_singkat_isi_permohonan` mediumtext NOT NULL,
  `tanggal_penetapan_hakim` date NOT NULL,
  `nama_hakim` varchar(500) NOT NULL,
  `nama_panitera` varchar(500) NOT NULL,
  `tanggal_pelaksanaan` date NOT NULL,
  `tempat_pelaksanaan` varchar(250) NOT NULL,
  `tanggal_penetapan` date NOT NULL,
  `isi_penetapan` mediumtext NOT NULL,
  `keterangan` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

/*Data for the table `register_permohonan_penetapan_ikrh` */

/*Table structure for table `register_validasi` */

DROP TABLE IF EXISTS `register_validasi`;

CREATE TABLE `register_validasi` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `validator_id` int(11) NOT NULL,
  `validator_username` varchar(100) NOT NULL,
  `validator_nama` varchar(100) NOT NULL,
  `validator_jabatan` varchar(100) NOT NULL,
  `perkara_masuk` int(10) unsigned NOT NULL,
  `perkara_diputus` int(10) unsigned NOT NULL,
  `catatan` mediumtext NOT NULL,
  `waktu_validasi` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

/*Data for the table `register_validasi` */

/*Table structure for table `register_validasi_backup` */

DROP TABLE IF EXISTS `register_validasi_backup`;

CREATE TABLE `register_validasi_backup` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `validator_id` int(11) NOT NULL,
  `validator_username` varchar(100) NOT NULL,
  `validator_nama` varchar(100) NOT NULL,
  `validator_jabatan` varchar(100) NOT NULL,
  `catatan` mediumtext NOT NULL,
  `perkara_masuk` varchar(1000) DEFAULT NULL,
  `perkara_diputus` varchar(1000) DEFAULT NULL,
  `waktu_validasi` datetime NOT NULL,
  `waktu_penghapusan` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

/*Data for the table `register_validasi_backup` */

/*Table structure for table `rencana_pemanggilan` */

DROP TABLE IF EXISTS `rencana_pemanggilan`;

CREATE TABLE `rencana_pemanggilan` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `jsp_id` int(10) NOT NULL,
  `sidang_id` int(10) NOT NULL,
  `pihak_id` int(11) DEFAULT NULL,
  `tgl_rencana` date NOT NULL,
  `jns_pgl` tinyint(2) DEFAULT NULL,
  `biaya_panggilan` decimal(16,2) DEFAULT NULL,
  `keterangan` text DEFAULT NULL,
  `tgl_pelaksanaan` date DEFAULT NULL,
  `status_pembayaran` tinyint(5) NOT NULL DEFAULT 0,
  `ket_temu` varchar(2) DEFAULT NULL,
  `ket_pelaksanaan` text DEFAULT NULL,
  `tgl_pembayaran` date DEFAULT NULL,
  `diinput_tanggal` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=latin1;

/*Data for the table `rencana_pemanggilan` */

/*Table structure for table `sys_config` */

DROP TABLE IF EXISTS `sys_config`;

CREATE TABLE `sys_config` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primari Key',
  `category` varchar(50) NOT NULL DEFAULT 'System' COMMENT 'Kategori Konfigurasi',
  `kd` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT 'Nama Konfigurasi',
  `value` varchar(255) DEFAULT NULL,
  `ordering` int(11) unsigned NOT NULL DEFAULT 0 COMMENT 'Urutan',
  `hidden` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=108 DEFAULT CHARSET=latin1 COMMENT='Data Konfigurasi Sistem';

/*Data for the table `sys_config` */

insert  into `sys_config`(`id`,`category`,`kd`,`name`,`value`,`ordering`,`hidden`) values 
(100,'System','kd_satker','Kode Satker','',0,0),
(101,'System','sys_version','System Versi','1.1',0,1),
(102,'System','kota','Kota','',0,0),
(103,'System','nm_kasir','Nama Kasir','',0,0),
(104,'System','nip_kasir','NIP Kasir','',0,0),
(106,'System','nm_bank','Nama Bank','',0,0),
(107,'System','no_rek','No Rekening Giro','',0,0);

/* Function  structure for function  `bulan_romawi` */

/*!50003 DROP FUNCTION IF EXISTS `bulan_romawi` */;
DELIMITER $$

/*!50003 CREATE DEFINER=`root`@`localhost` FUNCTION `bulan_romawi`(bln INT(2)) RETURNS varchar(4) CHARSET latin1
RETURN
							  CASE
							    WHEN bln = 1 THEN 'I'
							    WHEN bln = 2 THEN 'II'
							    WHEN bln = 3 THEN 'III'
							    WHEN bln = 4 THEN 'IV'
							    WHEN bln = 5 THEN 'V'
							    WHEN bln = 6 THEN 'VI'
							    WHEN bln = 7 THEN 'VII'
							    WHEN bln = 8 THEN 'VIII'
							    WHEN bln = 9 THEN 'IX'
							    WHEN bln = 10 THEN 'X'
							    WHEN bln = 11 THEN 'XI'
							    WHEN bln = 12 THEN 'XII'
							    END */$$
DELIMITER ;

/* Function  structure for function  `convert_tanggal_indonesia` */

/*!50003 DROP FUNCTION IF EXISTS `convert_tanggal_indonesia` */;
DELIMITER $$

/*!50003 CREATE DEFINER=`root`@`localhost` FUNCTION `convert_tanggal_indonesia`(tmp DATE) RETURNS varchar(18) CHARSET latin1
RETURN
							  CONCAT_WS(' ',RIGHT(tmp,2),nama_bulan(SUBSTRING(tmp,6,2)),LEFT(tmp,4)) */$$
DELIMITER ;

/* Function  structure for function  `nama_bulan` */

/*!50003 DROP FUNCTION IF EXISTS `nama_bulan` */;
DELIMITER $$

/*!50003 CREATE DEFINER=`root`@`localhost` FUNCTION `nama_bulan`(bln INT(2)) RETURNS varchar(10) CHARSET latin1
RETURN
							  CASE
							WHEN bln = 1 THEN 'Januari'
							    WHEN bln = 2 THEN 'Februari'
							    WHEN bln = 3 THEN 'Maret'
							    WHEN bln = 4 THEN 'April'
							    WHEN bln = 5 THEN 'Mei'
							    WHEN bln = 6 THEN 'Juni'
							    WHEN bln = 7 THEN 'Juli'
							    WHEN bln = 8 THEN 'Agustus'
							    WHEN bln = 9 THEN 'September'
							    WHEN bln = 10 THEN 'Oktober'
							    WHEN bln = 11 THEN 'November'
							    WHEN bln = 12 THEN 'Desember'
							    END */$$
DELIMITER ;

/* Function  structure for function  `nama_hari` */

/*!50003 DROP FUNCTION IF EXISTS `nama_hari` */;
DELIMITER $$

/*!50003 CREATE DEFINER=`root`@`localhost` FUNCTION `nama_hari`(tanggal DATE) RETURNS varchar(10) CHARSET latin1
RETURN
							  CASE WEEKDAY(tanggal)
							    WHEN 0 THEN 'Senin'
							    WHEN 1 THEN 'Selasa'
							    WHEN 2 THEN 'Rabu'
							    WHEN 3 THEN 'Kamis'
							    WHEN 4 THEN 'Jumat'
							    WHEN 5 THEN 'Sabtu'
							    WHEN 6 THEN 'Minggu'
							    END */$$
DELIMITER ;

/*Table structure for table `keu_v_perkara_biaya` */

DROP TABLE IF EXISTS `keu_v_perkara_biaya`;

/*!50001 DROP VIEW IF EXISTS `keu_v_perkara_biaya` */;
/*!50001 DROP TABLE IF EXISTS `keu_v_perkara_biaya` */;

/*!50001 CREATE TABLE  `keu_v_perkara_biaya`(
 `id` int(11) unsigned ,
 `perkara_id` bigint(20) unsigned ,
 `tahapan_id` int(11) unsigned ,
 `kategori_id` int(11) unsigned ,
 `kategori_kode` varchar(20) ,
 `kategori_nama` varchar(100) ,
 `jenis_biaya_id` int(11) unsigned ,
 `jenis_biaya_kode` varchar(20) ,
 `jenis_biaya_nama` varchar(100) ,
 `jenis_transaksi_bku` tinyint(1) ,
 `tanggal_transaksi` date ,
 `jenis_transaksi` tinyint(1) ,
 `uraian` varchar(500) ,
 `jumlah` decimal(16,2) unsigned ,
 `keterangan` varchar(500) 
)*/;

/*View structure for view keu_v_perkara_biaya */

/*!50001 DROP TABLE IF EXISTS `keu_v_perkara_biaya` */;
/*!50001 DROP VIEW IF EXISTS `keu_v_perkara_biaya` */;

/*!50001 CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `keu_v_perkara_biaya` AS (select `keu_perkara_biaya_tambahan`.`id` AS `id`,`keu_perkara_biaya_tambahan`.`perkara_id` AS `perkara_id`,`keu_perkara_biaya_tambahan`.`tahapan_id` AS `tahapan_id`,`keu_perkara_biaya_tambahan`.`kategori_id` AS `kategori_id`,`keu_kategori_biaya_tambahan`.`kode` AS `kategori_kode`,`keu_kategori_biaya_tambahan`.`nama` AS `kategori_nama`,`keu_perkara_biaya_tambahan`.`jenis_biaya_id` AS `jenis_biaya_id`,`keu_jenis_biaya_tambahan`.`kode` AS `jenis_biaya_kode`,`keu_jenis_biaya_tambahan`.`nama` AS `jenis_biaya_nama`,`keu_jenis_biaya_tambahan`.`jenis_transaksi_bku` AS `jenis_transaksi_bku`,`keu_perkara_biaya_tambahan`.`tanggal_transaksi` AS `tanggal_transaksi`,`keu_perkara_biaya_tambahan`.`jenis_transaksi` AS `jenis_transaksi`,`keu_perkara_biaya_tambahan`.`uraian` AS `uraian`,`keu_perkara_biaya_tambahan`.`jumlah` AS `jumlah`,`keu_perkara_biaya_tambahan`.`keterangan` AS `keterangan` from ((`keu_perkara_biaya_tambahan` left join `keu_jenis_biaya_tambahan` on(`keu_perkara_biaya_tambahan`.`jenis_biaya_id` = `keu_jenis_biaya_tambahan`.`id`)) left join `keu_kategori_biaya_tambahan` on(`keu_perkara_biaya_tambahan`.`kategori_id` = `keu_kategori_biaya_tambahan`.`id`))) */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
