-- --------------------------------------------------------
-- Host:                         localhost
-- Server version:               5.6.26 - MySQL Community Server (GPL)
-- Server OS:                    Linux
-- Date/time:                    2019-09-15 17:00:00 WITA
-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `abt_config` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `category` varchar(50) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `value` text,
  `information` varchar(100) DEFAULT NULL,
  `modifier` varchar(30) DEFAULT NULL,
  `modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
);;

REPLACE INTO `abt_config` (`id`, `category`, `name`, `value`, `information`, `modifier`, `modified`) VALUES
	(1, 'system', 'app_name_full', 'Blangko Terintegrasi SIPP', 'Nama App', NULL, NULL),
	(2, 'system', 'app_name_singkat', 'ABT SIPP', 'Singkatan App', NULL, NULL),
	(3, 'system', 'sipp_web', NULL, 'Enkripsi URL SIPP Web', NULL, NULL),
	(4, 'system', 'item_perhalaman', '150', 'Batas Pagination', NULL, NULL),
	(5, 'system', 'jenis_kertas', 'A4', 'Jenis Ukuran Kertas Yang Digunakan', NULL, NULL),
	(6, 'system', 'nama_pengadilan', NULL, 'Defenisi Nama Pengadilan di Dirput', NULL, NULL),
	(7, 'system', 'validasi_data_bas', '0', 'Enable Disable Validasi BAS', NULL, NULL),
	(8, 'system_aps', 'new_versi', NULL, 'Deteksi Update Baru', NULL, NULL),
	(9, 'system_aps', 'last_login_abt', NULL, 'Login Terakhir ABT', NULL, NULL),
	(10, 'system_aps', 'last_login_keuangan', NULL, 'Login Terakhir e-Keuangan', NULL, NULL),
	(11, 'system_aps', 'last_login_register', NULL, 'Login Terakhir e-Register', NULL, NULL);;


CREATE TABLE IF NOT EXISTS `abt_variabel_tipe` (
  `id` int(2) NOT NULL,
  `nama` char(100) NOT NULL,
  `value` char(100) DEFAULT NULL,
  `modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `nama` (`nama`)
);;

INSERT IGNORE INTO `abt_variabel_tipe` (`id`, `nama`, `value`, `modified`) VALUES
	(0, '- pilih tipe data -', NULL, '2019-08-05 12:41:59'),
	(1, 'Query MySql', 'data_sql', '2019-08-05 12:41:59'),
	(2, 'Data SIPP', 'data_sipp', '2019-08-05 12:41:59'),
	(3, 'Data Teks', 'data_teks', '2019-08-05 12:41:59'),
	(4, 'Data Tanggal', 'data_tanggal', '2019-08-05 12:41:59'),
	(5, 'Hari Tanggal', 'tanggal_hari', '2019-08-05 12:41:59'),
	(6, 'Hijriah Tanggal', 'tanggal_hijriah', '2019-08-05 12:41:59'),
	(7, 'Terbilang', 'terbilang', '2019-08-05 12:41:59'),
	(8, 'Multi Sidang', 'multi_sidang', '2019-08-05 12:41:59'),
	(9, 'Tanya Jawab', 'tanya_jawab', '2019-08-05 12:41:59');;


CREATE TABLE IF NOT EXISTS `abt_variabel` (
  `no_var` int(4) unsigned zerofill NOT NULL DEFAULT '0000',
  `nama` varchar(200) NOT NULL DEFAULT '',
  `data_type` char(20) DEFAULT NULL,
  `data_tabel` varchar(100) DEFAULT NULL,
  `data_kolom` varchar(100) DEFAULT NULL,
  `urutan_data` int(2) unsigned DEFAULT NULL,
  `referensi` int(4) unsigned zerofill DEFAULT NULL,
  `sql_query` text,
  `default_data` text,
  `multi_sidang` char(50) DEFAULT NULL,
  `locked` tinyint(1) NOT NULL,
  `modifier` varchar(30) DEFAULT NULL,
  `modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`no_var`),
  KEY `nama` (`nama`)
);;


INSERT IGNORE INTO `abt_variabel` (`no_var`, `nama`, `data_type`, `data_tabel`, `data_kolom`, `urutan_data`, `referensi`, `sql_query`, `default_data`, `multi_sidang`, `locked`, `modifier`, `modified`) VALUES
	(0004, 'Sebab konflik', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0007, 'Telah Dikarunai Anak ', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'belum dikaruniai anak.\r\n\r\ntelah dikaruniai seorang anak, bernama ...\r\n\r\ntelah dikaruniai _ orang anak, masing-masing bernama :\r\n1.   ', NULL, 0, 'admin', '2019-08-08 02:47:08'),
	(0017, 'Tgl. Surat #0053# #0046#', 'data_sipp', 'perkara', 'tanggal_surat', NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-01-01 04:00:00'),
	(0029, 'Terbilang 1086', 'terbilang', NULL, NULL, NULL, 1085, NULL, NULL, NULL, 0, NULL, '2019-08-08 19:45:19'),
	(0030, 'Alamat Dubes', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0031, 'Kota Dubes', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0034, 'Hari 4 hari sebelum sidang', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0035, 'Tgl 4 hari sebelum sidang', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0036, 'Tgl Pengiriman Berkas Banding', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0037, 'Tgl Penerimaan Kembali Berkas Banding', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0039, 'Tgl Permohonan Eksekusi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0040, 'Tgl Aanmaning', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0042, 'Umur calon Istri (dispensasi)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0043, 'Terbilang gaji calon suami', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0044, 'Sidang Lanjutan Ke -', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0049, 'Sidang Lanjutan Ke-', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0052, 'Terbilang PBP', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0061, 'Perceraian ke-', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0062, 'Identitas Para <<0046', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0063, 'identitas para <<0047', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0066, 'Nomor Putusan yg dimohonkan eksekusi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0077, 'Nomor Putusan Banding', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0078, 'Nomor Putusan Kasasi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0080, 'Tgl. Eksepsi #0047#', 'data_tanggal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2019-05-21 05:00:47'),
	(0081, 'pert. kepada <<0046 & <<0047', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0082, 'Tgl Penerimaan Memori Kasasi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0083, 'Tgl Penyerahan Memori Kasasi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0084, 'Tgl Penerimaan Kontra Memori Kasasi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0085, 'NIP Kasir', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-01-01 04:00:00'),
	(0086, 'Nama Kasir', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-01-01 04:00:00'),
	(0087, 'Tgl Pengiriman Berkas Kasasi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0088, 'Tgl Penerimaan Kembali Berkas Kasasi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0089, 'Terbilang biaya penetapan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0091, 'dapat mengajukan kembali', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0092, 'Tgl PBT Pernyataan Banding', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0093, 'Tgl Pengiriman Berkas PK', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0094, 'Tanya-Jawab', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0095, 'Tgl Penerimaan Kembali Berkas PK', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0096, 'Tgl Putusan PK', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0097, 'Nomor Putusan PK', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0107, 'Umur Kuasa <<0046', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2019-08-08 19:49:28'),
	(0108, 'Pekerjaan Kuasa <<0046', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0110, 'Nomor surat izin pengacara', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0113, 'Nomor surat keterangan sebagai kuasa', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0114, 'Tgl Surat Ket Pendaftaran Kuasa', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0115, 'No. surat ijin khusus sebagai kuasa', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0116, 'Tanggal surat ijin sebagai kuasa', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0117, 'No. surat peng. relaas ulang P', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0119, 'No. surat peng. relaas ulang T', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0125, 'Hak / kewajiban Penerima kuasa', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0126, 'waktu pemanggilan pihak - pihak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0127, 'dengan Pe/Ter dan ia', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0128, 'Keterangan Anak Pemohon (DK)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0129, 'Keterangan Anak Pemohon 2 (DK)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0130, 'hari legalisasi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0131, 'Tgl Penyampaian Salinan Putusan PK dari MA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2019-05-19 02:48:22'),
	(0138, 'a.n. Ter sebagai .......', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0141, '#0046# / Kuasanya Hadir', 'data_sql', NULL, NULL, NULL, NULL, 'select (case\r\n\r\nwhen "#0106#"!="" and "#1033#"!="" then\r\n"Para #0046# menghadap didampingi Kuasanya"\r\n\r\nwhen "#0106#"!="" then\r\n"#0046# menghadap didampingi Kuasanya"\r\n\r\nwhen "#1033#"!="" then\r\n"Para #0046# menghadap sendiri"\r\n\r\nelse\r\n"#0046# menghadap sendiri"\r\n\r\nend) as data', '#0046# menghadap sendiri', NULL, 0, NULL, '2019-01-23 07:01:26'),
	(0142, '#0047# / Kuasanya Hadir', 'data_sql', NULL, NULL, NULL, NULL, 'select (case\r\n\r\nwhen "#0170#"!="" and "#1033#"!="" then\r\n"Para #0047# menghadap didampingi Kuasanya"\r\n\r\nwhen "#0170#"!="" then\r\n"#0047# menghadap didampingi Kuasanya"\r\n\r\nwhen "#5026#"!="" then\r\n"Para #0047# menghadap sendiri"\r\n\r\nelse\r\n"#0047# menghadap sendiri"\r\n\r\nend) as data', NULL, NULL, 0, NULL, '2019-01-23 07:01:26'),
	(0143, 'Total Biaya Perkara', 'data_sql', NULL, NULL, NULL, NULL, 'select (\r\n0#0279# + \r\n0#6060# + \r\n0#0312# + \r\n0#6063# + \r\n0#6061# + \r\n0#6062# +\r\n0#0281# + \r\n0#5223#)\r\nas data', NULL, NULL, 0, NULL, '2019-07-18 11:43:57'),
	(0149, 'Kode PP', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0151, 'Tgl Terima Memori', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0152, 'Tgl Terima Kontra', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0153, 'Tgl penyampaian Memori', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0154, 'Tgl penyampaian Kontra', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0156, 'Kantor Kuasa #0046#', 'data_teks', NULL, NULL, NULL, NULL, NULL, ' pada Kantor ...', NULL, 0, NULL, '2019-07-22 07:09:07'),
	(0157, 'Kantor Kuasa #0047#', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'Kantor ...', NULL, 0, NULL, '2019-05-19 07:36:08'),
	(0158, 'Tgl Putusan Banding', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0159, 'Amar Lengkap Putusan Banding', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0160, 'Susunan Majelis Hakim Tk. Banding', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0161, 'Tgl PBT Putusan Banding', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0171, 'Umur Kuasa <<0047', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0172, 'Pekerjaan Kuasa <<0047', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0174, 'Agama Kuasa <<0047', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0176, 'Nomor Box', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0177, 'Nomor Rak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0178, 'Daftar Isi Berkas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0182, 'Tgl Pemberian Izin Kuasa Insidentil P', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0183, 'Tgl Pemberian Izin Kuasa Insidentil T', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0184, 'Tgl. Surat Kuasa #0046#', 'data_tanggal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2019-08-08 19:52:38'),
	(0185, 'Tgl. Surat Kuasa #0047#', 'data_tanggal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2019-08-08 19:52:39'),
	(0186, 'Alasan Kasasi tidak memenuhi syarat formil', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0187, 'Tgl S.Ket Tidak memenuhi syarat formil P', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0188, 'Tgl S.Ket Tidak memenuhi syarat formil T', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0189, 'Tgl S.Ket Inzage P', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0190, 'Tgl S.Ket Inzage T', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0192, 'Status Prodeo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0195, 'Tgl. Cetak Duplikat AC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0200, 'Tgl. PHS Sita', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0201, 'Tgl. PHS Eksekusi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0202, 'Tgl. PMH Sita', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0203, 'Tgl. PMH Eksekusi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0204, 'Tgl. Penunjukan JS/JSP Sita', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0205, 'Tgl. Penunjukan JS/JSP Eksekusi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0259, 'Nomor SK Majelis Baru', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0260, 'Tgl. SK Majelis Baru', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0279, 'Biaya Pendaftaran', 'data_sql', NULL, NULL, NULL, NULL, 'select jumlah as data from perkara_biaya\r\nwhere jenis_biaya_id=61 and perkara_id=#perkara_id#', NULL, NULL, 0, NULL, '2018-01-01 04:00:00'),
	(0280, 'Tgl. Biaya Pendaftaran', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0281, 'Biaya Redaksi', 'data_sql', NULL, NULL, NULL, NULL, 'select "10000.00" as data', NULL, NULL, 0, NULL, '2019-07-18 11:50:49'),
	(0282, 'Tgl Biaya Proses', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0283, 'Tgl Biaya Panggilan #0046#', 'data_sql', NULL, NULL, NULL, NULL, 'select max(tanggal_transaksi) as data from perkara_biaya\r\nwhere\r\njenis_biaya_id=13 and perkara_id=#perkara_id#\r\nor\r\njenis_biaya_id=12 and perkara_id=#perkara_id#', NULL, NULL, 0, NULL, '2018-01-01 04:00:00'),
	(0285, 'Tgl Biaya Panggilan #0047#', 'data_sql', NULL, NULL, NULL, NULL, 'select max(tanggal_transaksi) as data from perkara_biaya\r\nwhere\r\njenis_biaya_id=14 and perkara_id=#perkara_id#\r\nor\r\njenis_biaya_id=15 and perkara_id=#perkara_id#', NULL, NULL, 0, NULL, '2018-01-01 04:00:00'),
	(0287, 'Tgl Biaya Panggilan Saksi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0288, 'Biaya Panggilan Saksi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0289, 'Tgl. Biaya Sita Konservatoir', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0291, 'Tgl. Biaya Pendaftaran Sita', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0292, 'Biaya Pendaftaran Sita', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0293, 'Tgl. Biaya Pemeriksaan Setempat', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0294, 'Biaya Pemeriksaan Setempat', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0295, 'Tgl. Biaya Redaksi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0296, 'Tgl. Biaya Meterai', 'data_teks', NULL, NULL, NULL, NULL, NULL, '0.00', NULL, 0, NULL, '2019-04-15 04:09:22'),
	(0297, 'Hari Surat Kuasa #0046#', 'tanggal_hari', NULL, NULL, NULL, 0184, NULL, NULL, NULL, 0, NULL, '2019-08-08 19:54:27'),
	(0298, 'Hari Surat Kuasa #0047#', 'tanggal_hari', NULL, NULL, NULL, 0185, NULL, NULL, NULL, 0, NULL, '2019-08-08 19:54:28'),
	(0303, 'Tgl. Pengumuman', 'data_tanggal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-01-17 02:02:45'),
	(0304, 'Hari Pengumuman', 'tanggal_hari', NULL, NULL, NULL, 0303, NULL, NULL, NULL, 0, NULL, '2018-01-17 02:02:56'),
	(0306, 'Tgl. Daftar (tersebut)', 'data_sql', NULL, NULL, NULL, NULL, 'select (case when\r\n"#0017#" = "#1061#" then "tersebut"\r\nelse "#1061#" end)\r\ndata', NULL, NULL, 0, NULL, '2019-01-23 07:01:26'),
	(0307, 'hari/tanggal daftar (utk putusan)', 'data_sql', NULL, NULL, NULL, NULL, 'select (case when\r\n"#0017#" = "#1061#" then "hari"\r\nelse "tanggal" end)\r\ndata', NULL, NULL, 0, NULL, '2019-01-23 07:01:26'),
	(0308, 'Tgl. Daftar (pd hari itu jg)', 'data_sql', NULL, NULL, NULL, NULL, 'select (case when\r\n"#0017#" = "#1061#" then "itu juga"\r\nelse "#1061#" end)\r\ndata', NULL, NULL, 0, NULL, '2019-01-23 07:01:26'),
	(0309, 'Tgl. Daftar Tk. Pertama', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0313, 'Hari Sidang Sita', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0314, 'Bahwa ada bukti surat IN 2 P', 'data_sql', NULL, NULL, NULL, NULL, 'select (case\r\n\r\nwhen "#1314#"!="" or "#1321#"!="" or "#1325#"!="" then\r\n"Bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti tertulis berupa: "\r\n\r\nelse ""\r\n\r\nend) as data', NULL, NULL, 0, NULL, '2019-07-18 13:15:39'),
	(0315, 'Bukti IN 2P KTP (otomatis bas)', 'data_sql', NULL, NULL, NULL, NULL, 'select (case\r\n\r\nwhen "#1314#"!="" and "#1316#"!="" and "#1510#"!="" then\r\n"1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\r\n4.   Asli Surat Keterangan Kematian Nomor #1316# tanggal #1317# yang dikeluarkan oleh #1342#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.4). Diberi tanggal dan paraf #0668#;\r\n5.   Asli Surat Keterangan Kematian Nomor #1510# tanggal #1511# yang dikeluarkan oleh #1512#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.5). Diberi tanggal dan paraf #0668#;"\r\n\r\nwhen "#1314#"!="" and "#1316#"!="" and "#1325#"!="" then\r\n"1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\r\n4.   Asli Surat Keterangan Kematian Nomor #1316# tanggal #1317# yang dikeluarkan oleh #1342#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.4). Diberi tanggal dan paraf #0668#;\r\n5.   Fotokopi Akta Cerai Nomor #1325# tanggal #1329# yang dikeluarkan oleh #1331#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.5). Diberi tanggal dan paraf #0668#;"\r\n\r\nwhen "#1314#"!="" and "#1321#"!="" and "#1325#"!="" then\r\n"1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\r\n4.   Fotokopi Akta Cerai Nomor #1321# tanggal #1322# yang dikeluarkan oleh #1324#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.4). Diberi tanggal dan paraf #0668#;\r\n5.   Fotokopi Akta Cerai Nomor #1325# tanggal #1329# yang dikeluarkan oleh #1331#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.5). Diberi tanggal dan paraf #0668#;"\r\n\r\nwhen "#1314#"!="" and "#1321#"!="" and "#1510#"!="" then\r\n"1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\r\n4.   Fotokopi Akta Cerai Nomor #1321# tanggal #1322# yang dikeluarkan oleh #1324#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.4). Diberi tanggal dan paraf #0668#;\r\n5.   Asli Surat Keterangan Kematian Nomor #1510# tanggal #1511# yang dikeluarkan oleh #1512#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.5). Diberi tanggal dan paraf #0668#;"\r\n\r\nwhen "#1314#"!="" and "#1316#"!="" then\r\n"1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\r\n4.   Asli Surat Keterangan Kematian Nomor #1316# tanggal #1317# yang dikeluarkan oleh #1342#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.4). Diberi tanggal dan paraf #0668#;"\r\n\r\nwhen "#1314#"!="" and "#1510#"!="" then\r\n"1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\r\n4.  Asli Surat Keterangan Kematian Nomor #1510# tanggal #1511# yang dikeluarkan oleh #1512#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.4). Diberi tanggal dan paraf #0668#;"\r\n\r\nwhen "#1314#"!="" and "#1321#"!="" then\r\n"1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\r\n4.   Fotokopi Akta Cerai Nomor #1321# tanggal #1322# yang dikeluarkan oleh #1324#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.4). Diberi tanggal dan paraf #0668#;"\r\n\r\nwhen "#1314#"!="" and "#1325#"!="" then\r\n"1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\r\n4.   Fotokopi Akta Cerai Nomor #1325# tanggal #1329# yang dikeluarkan oleh #1331#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.4). Diberi tanggal dan paraf #0668#;"\r\n\r\nwhen "#1314#"!="" then\r\n"1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;"\r\n\r\n\r\nelse ""\r\n\r\nend) data', NULL, NULL, 0, NULL, '2019-07-20 04:00:54'),
	(0316, 'Pertimbngn Bukti Surat IN 2 P - KTP', 'data_sql', NULL, NULL, NULL, NULL, 'select (case\r\n\r\nwhen "#1316#"!="" and "#1510#"!="" then "\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.4 berupa Asli Surat Kematian yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup dan telah dicap pos, isi bukti tersebut menerangkan bahwa sebelum menikah Pemohon I telah menikah dengan seorang #2025# bernama #1025# dan telah meninggal dunia pada tanggal #1246# karena #1247#, relevan dengan dalil yang hendak dibuktikan oleh Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.5 berupa Asli Surat Kematian yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup dan telah dicap pos, isi bukti tersebut menerangkan bahwa sebelum menikah Pemohon II telah menikah dengan seorang #1516# bernama #1513# dan telah meninggal dunia pada tanggal #1514# karena #1515#, relevan dengan dalil yang hendak dibuktikan oleh Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;"\r\n\r\nwhen "#1316#"!="" and "#1325#"!="" then "\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.4 berupa Asli Surat Kematian yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup dan telah dicap pos, isi bukti tersebut menerangkan bahwa sebelum menikah Pemohon I telah menikah dengan seorang #2025# bernama #1025# dan telah meninggal dunia pada tanggal #1246# karena #1247#, relevan dengan dalil yang hendak dibuktikan oleh Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.5 berupa fotokopi Akta Cerai yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos dan cocok dengan aslinya, isi bukti tersebut menerangkan bahwa Pemohon II telah bercerai dengan #1330# pada tanggal #1329#, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;"\r\n\r\nwhen "#1321#"!="" and "#1325#"!="" then "\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.4 berupa fotokopi Akta Cerai yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos dan cocok dengan aslinya, isi bukti tersebut menerangkan bahwa Pemohon I telah bercerai dengan #1323# pada tanggal #1322#, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.5 berupa fotokopi Akta Cerai yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos dan cocok dengan aslinya, isi bukti tersebut menerangkan bahwa Pemohon II telah bercerai dengan #1330# pada tanggal #1329#, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;"\r\n\r\nwhen "#1321#"!="" and "#1510#"!="" then "\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.4 berupa fotokopi Akta Cerai yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos dan cocok dengan aslinya, isi bukti tersebut menerangkan bahwa Pemohon I telah bercerai dengan #1323# pada tanggal #1322#, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.5 berupa Asli Surat Kematian yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup dan telah dicap pos, isi bukti tersebut menerangkan bahwa sebelum menikah Pemohon II telah menikah dengan seorang #1516# bernama #1513# dan telah meninggal dunia pada tanggal #1514# karena #1515#, relevan dengan dalil yang hendak dibuktikan oleh Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;"\r\n\r\nwhen "#1316#"!="" then "\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.4 berupa Asli Surat Kematian yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup dan telah dicap pos, isi bukti tersebut menerangkan bahwa sebelum menikah Pemohon I telah menikah dengan seorang #2025# bernama #1025# dan telah meninggal dunia pada tanggal #1246# karena #1247#, relevan dengan dalil yang hendak dibuktikan oleh Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;"\r\n\r\nwhen "#1510#"!="" then "\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.4 berupa Asli Surat Kematian yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup dan telah dicap pos, isi bukti tersebut menerangkan bahwa sebelum menikah Pemohon II telah menikah dengan seorang #1516# bernama #1513# dan telah meninggal dunia pada tanggal #1514# karena #1515#, relevan dengan dalil yang hendak dibuktikan oleh Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;"\r\n\r\nwhen "#1321#"!="" then "\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.4 berupa fotokopi Akta Cerai yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos dan cocok dengan aslinya, isi bukti tersebut menerangkan bahwa Pemohon I telah bercerai dengan #1323# pada tanggal #1322#, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;"\r\n\r\nwhen "#1325#"!="" then "\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.4 berupa fotokopi Akta Cerai yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos dan cocok dengan aslinya, isi bukti tersebut menerangkan bahwa Pemohon II telah bercerai dengan #1330# pada tanggal #1329#, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;"\r\n\r\nelse ""\r\n\r\nend) data', NULL, NULL, 0, NULL, '2019-07-20 04:06:39'),
	(0317, 'Alasan dibolehkan IN 2 P', 'data_sql', NULL, NULL, NULL, NULL, 'select (case\r\n\r\nwhen locate("hilang","#1358#")>0 or locate("rusak","#1358#")>0 or locate("terbakar","#1358#")>0 or locate("tenggelam","#1358#")>0 or locate("robek","#1358#")>0 or locate("hanyut","#1358#")>0 then\r\n"menurut pengakuan para Pemohon pernah mempunyai Akta Nikah namun hilang/rusak, maka permohonan Itsbat Nikah dalam perkara ini juga telah memenuhi ketentuan Pasal 7 ayat (3) huruf (b) Kompilasi Hukum Islam"\r\n\r\nwhen locate("1974","#1358#")>0 then\r\n"pernikahan tersebut terjadi sebelum berlakunya Undang-undang Nomor 1 tahun 1974, maka permohonan Itsbat Nikah dalam perkara ini juga telah memenuhi ketentuan Pasal 7 ayat (3) huruf (d) Kompilasi Hukum Islam"\r\n\r\nelse\r\n"yang menikah tidak mempunyai halangan menikah menurut Undang-Undang Nomor 1 tahun 1974, maka permohonan Itsbat Nikah dalam perkara ini juga telah memenuhi ketentuan Pasal 7 ayat (3) huruf (e) Kompilasi Hukum Islam"\r\n\r\nend)\r\nas data', NULL, NULL, 0, NULL, '2019-01-23 07:01:26'),
	(0318, 'Bukti Surat DK Putra (otomatis)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0319, 'Prtimbngn Bukti Surat DK Putra', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0320, 'Ada atau Tiada Bukti Surat', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0321, 'Bukti tersebut sebagai berikut:', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0322, 'Bukti Surat DK Putri (otomatis)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0323, 'Prtimbngn Bukti Surat DK Putri', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0324, 'Bukti Surat DK 2 anak (otomatis)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0325, 'Prtimbngn Bukti Surat DK 2 anak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0326, 'Bukti Surat IN 1 P (otomatis)', 'data_sql', NULL, NULL, NULL, NULL, 'select (case\r\n\r\nwhen "#1314#"!="" and "#1316#"!="" then\r\n"1. Fotokopi Kartu Keluarga Nomor #1314#, tanggal #1315#, yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2. Asli Surat Kematian, Nomor #1316#, tanggal #1317#, yang dikeluarkan oleh #1342#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;"\r\n\r\nwhen "#1314#"!="" then\r\n"Fotokopi Kartu Keluarga Nomor #1314#, tanggal #1315#, yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P). Diberi tanggal dan paraf #0668#;"\r\n\r\nwhen "#1316#"!="" then\r\n"Asli Surat Kematian, Nomor #1316#, tanggal #1317#, yang dikeluarkan oleh #1342#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P). Diberi tanggal dan paraf #0668#;"\r\n\r\nelse ""\r\n\r\nend) as data', NULL, NULL, 0, NULL, '2019-05-16 11:32:48'),
	(0327, 'Pertimbngn Bukti Surat IN 1 P', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0328, 'Alasan dibolehkan IN 1 P', 'data_sql', NULL, NULL, NULL, NULL, 'select (case\r\n\r\nwhen locate("hilang","#1358#")>0 or locate("rusak","#1358#")>0 or locate("terbakar","#1358#")>0 or locate("tenggelam","#1358#")>0 or locate("robek","#1358#")>0 or locate("hanyut","#1358#")>0 then\r\n"menurut pengakuan Pemohon pernah mempunyai Akta Nikah namun hilang/rusak, maka permohonan Itsbat Nikah dalam perkara ini juga telah memenuhi ketentuan Pasal 7 ayat (3) huruf (b) Kompilasi Hukum Islam"\r\n\r\nwhen locate("1974","#1358#")>0 then\r\n"pernikahan tersebut terjadi sebelum berlakunya Undang-undang Nomor 1 tahun 1974, maka permohonan Itsbat Nikah dalam perkara ini juga telah memenuhi ketentuan Pasal 7 ayat (3) huruf (d) Kompilasi Hukum Islam"\r\n\r\nelse\r\n"yang menikah tidak mempunyai halangan menikah menurut Undang-Undang Nomor 1 tahun 1974, maka permohonan Itsbat Nikah dalam perkara ini juga telah memenuhi ketentuan Pasal 7 ayat (3) huruf (e) Kompilasi Hukum Islam"\r\n\r\nend)\r\nas data', NULL, NULL, 0, NULL, '2019-01-23 07:01:26'),
	(0329, 'Pertimbngn Bukti Surat IN 1 P-', 'data_sql', NULL, NULL, NULL, NULL, 'select (case\r\n\r\nwhen "#1314#"!="" and "#1316#"!="" then\r\n"Menimbang, bahwa untuk membuktikan dalil-dalilnya, Pemohon telah mengajukan bukti P.1 berupa fotokopi Kartu Keluarga yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos, dan cocok dengan aslinya, isi bukti tersebut menerangkan bahwa Pemohon dengan #2026# #1025# adalah suami isteri dalam satu rumah tangga, relevan dengan dalil yang hendak dibuktikan oleh Pemohon, dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka berdasarkan bukti tersebut harus dinyatakan terbukti bahwa Pemohon dengan #2026# #1025# secara administrasi kependudukan telah terdaftar sebagai suami istri;\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, Pemohon telah mengajukan bukti P.2 berupa Asli Surat Kematian yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, isi bukti tersebut menerangkan bahwa #1025# telah meninggal dunia pada tanggal #1246# karena #1247#, relevan dengan dalil yang hendak dibuktikan oleh Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;"\r\n\r\nwhen "#1314#"!="" then\r\n"Menimbang, bahwa untuk membuktikan dalil-dalilnya, Pemohon telah mengajukan bukti P berupa fotokopi Kartu Keluarga yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos, dan cocok dengan aslinya, isi bukti tersebut menerangkan bahwa Pemohon dengan #2026# #1025# adalah suami isteri dalam satu rumah tangga, relevan dengan dalil yang hendak dibuktikan oleh Pemohon, dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka berdasarkan bukti tersebut harus dinyatakan terbukti bahwa Pemohon dengan #2026# #1025# secara administrasi kependudukan telah terdaftar sebagai suami istri;"\r\n\r\nwhen "#1316#"!="" then\r\n"Menimbang, bahwa untuk membuktikan dalil-dalilnya, Pemohon telah mengajukan bukti P berupa Asli Surat Kematian yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, isi bukti tersebut menerangkan bahwa #1025# telah meninggal dunia pada tanggal #1246# karena #1247#, relevan dengan dalil yang hendak dibuktikan oleh Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;"\r\n\r\nelse ""\r\n\r\nend) as data', NULL, NULL, 0, NULL, '2019-01-23 07:01:26'),
	(0330, 'Bukti Surt Pengktn Anak (otomtis)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0331, 'Pertimbngn Bukti Pengktn Anak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0334, 'Bukti IN 2P KTP (otomatis Penetapan)', 'data_sql', NULL, NULL, NULL, NULL, 'select (case\r\n\r\nwhen "#1314#"!="" and "#1316#"!="" and "#1510#"!="" then\r\n"1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\r\n4.   Asli Surat Keterangan Kematian Nomor #1316# tanggal #1317# yang dikeluarkan oleh #1342#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.4). Diberi tanggal dan paraf #0668#;\r\n5.   Asli Surat Keterangan Kematian Nomor #1510# tanggal #1511# yang dikeluarkan oleh #1512#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.5). Diberi tanggal dan paraf #0668#;"\r\n\r\nwhen "#1314#"!="" and "#1316#"!="" and "#1325#"!="" then\r\n"1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\r\n4.   Asli Surat Keterangan Kematian Nomor #1316# tanggal #1317# yang dikeluarkan oleh #1342#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.4). Diberi tanggal dan paraf #0668#;\r\n5.   Fotokopi Akta Cerai Nomor #1325# tanggal #1329# yang dikeluarkan oleh #1331#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.5). Diberi tanggal dan paraf #0668#;"\r\n\r\nwhen "#1314#"!="" and "#1321#"!="" and "#1325#"!="" then\r\n"1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\r\n4.   Fotokopi Akta Cerai Nomor #1321# tanggal #1322# yang dikeluarkan oleh #1324#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.4). Diberi tanggal dan paraf #0668#;\r\n5.   Fotokopi Akta Cerai Nomor #1325# tanggal #1329# yang dikeluarkan oleh #1331#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.5). Diberi tanggal dan paraf #0668#;"\r\n\r\nwhen "#1314#"!="" and "#1321#"!="" and "#1510#"!="" then\r\n"1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\r\n4.   Fotokopi Akta Cerai Nomor #1321# tanggal #1322# yang dikeluarkan oleh #1324#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.4). Diberi tanggal dan paraf #0668#;\r\n5.   Asli Surat Keterangan Kematian Nomor #1510# tanggal #1511# yang dikeluarkan oleh #1512#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.5). Diberi tanggal dan paraf #0668#;"\r\n\r\nwhen "#1314#"!="" and "#1316#"!="" then\r\n"1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\r\n4.   Asli Surat Keterangan Kematian Nomor #1316# tanggal #1317# yang dikeluarkan oleh #1342#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.4). Diberi tanggal dan paraf #0668#;"\r\n\r\nwhen "#1314#"!="" and "#1510#"!="" then\r\n"1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\r\n4.  Asli Surat Keterangan Kematian Nomor #1510# tanggal #1511# yang dikeluarkan oleh #1512#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.4). Diberi tanggal dan paraf #0668#;"\r\n\r\nwhen "#1314#"!="" and "#1321#"!="" then\r\n"1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\r\n4.   Fotokopi Akta Cerai Nomor #1321# tanggal #1322# yang dikeluarkan oleh #1324#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.4). Diberi tanggal dan paraf #0668#;"\r\n\r\nwhen "#1314#"!="" and "#1325#"!="" then\r\n"1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\r\n4.   Fotokopi Akta Cerai Nomor #1325# tanggal #1329# yang dikeluarkan oleh #1331#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.4). Diberi tanggal dan paraf #0668#;"\r\n\r\nwhen "#1314#"!="" then\r\n"1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;"\r\n\r\n\r\nelse ""\r\n\r\nend) data', NULL, NULL, 0, NULL, '2019-07-20 03:59:40'),
	(0338, 'No. NIK Pria (Dispensasi)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0339, 'No. NIK Wanita (Dispensasi)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0340, 'Tempat Lahir Pria (Dispensasi)', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2019-05-21 13:38:21'),
	(0344, 'Tempat Lahir Wanita (Dispensasi)', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2019-05-21 13:38:27'),
	(0348, 'Tgl. Lahir Pria (Dispensasi)', 'data_tanggal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2019-05-21 13:38:32'),
	(0349, 'Tgl. Lahir Wanita (Dispensasi)', 'data_tanggal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2019-05-21 13:38:37'),
	(0364, 'Tgl. KTP #0046#', 'data_tanggal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2019-03-12 07:58:31'),
	(0365, 'Tgl. KTP #0047#', 'data_tanggal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2019-03-12 07:58:25'),
	(0366, 'Tgl. KTP #0046# II', 'data_tanggal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2019-03-12 07:58:46'),
	(0375, 'Bukti Surat IN 2 P (otomatis BAS)', 'data_sql', NULL, NULL, NULL, NULL, 'select (case\r\n\r\nwhen "#1314#"!="" and "#1321#"!="" and "#1325#"!="" then\r\n"1.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Akta Cerai Nomor #1321# tanggal #1322# yang dikeluarkan oleh #1324#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Akta Cerai Nomor #1325# tanggal #1329# yang dikeluarkan oleh #1331#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;"\r\n\r\nwhen "#1314#"!="" and "#1321#"!="" then\r\n"1.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Akta Cerai Nomor #1321# tanggal #1322# yang dikeluarkan oleh #1324#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;"\r\n\r\nwhen "#1314#"!="" and "#1325#"!="" then\r\n"1.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Akta Cerai Nomor #1325# tanggal #1329# yang dikeluarkan oleh #1331#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;"\r\n\r\nwhen "#1321#"!="" and "#1325#"!="" then\r\n"1.   Fotokopi Akta Cerai Nomor #1321# tanggal #1322# yang dikeluarkan oleh #1324#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Akta Cerai Nomor #1325# tanggal #1329# yang dikeluarkan oleh #1331#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;"\r\n\r\nwhen "#1314#"!="" and "#1316#"!="" and "#1510#"!="" then\r\n"1.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Asli Surat Keterangan Kematian Nomor #1316# tanggal #1317# yang dikeluarkan oleh #1342#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Asli Surat Keterangan Kematian Nomor #1510# tanggal #1511# yang dikeluarkan oleh #1512#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;"\r\n\r\nwhen "#1314#"!="" and "#1316#"!="" then\r\n"1.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Asli Surat Keterangan Kematian Nomor #1316# tanggal #1317# yang dikeluarkan oleh #1342#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;"\r\n\r\nwhen "#1314#"!="" and "#1510#"!="" then\r\n"1.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Asli Surat Keterangan Kematian Nomor #1510# tanggal #1511# yang dikeluarkan oleh #1512#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;"\r\n\r\nwhen "#1314#"!="" then\r\n"Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P). Diberi tanggal dan paraf #0668#;"\r\n\r\nwhen "#1321#"!="" then\r\n"Fotokopi Akta Cerai Nomor #1321# tanggal #1322# yang dikeluarkan oleh #1324#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P). Diberi tanggal dan paraf #0668#;"\r\n\r\nwhen "#1325#"!="" then\r\n"Fotokopi Akta Cerai Nomor #1325# tanggal #1329# yang dikeluarkan oleh #1331#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P). Diberi tanggal dan paraf #0668#;"\r\n\r\nelse ""\r\n\r\nend) as data', NULL, NULL, 0, NULL, '2019-08-08 19:56:48'),
	(0376, 'Pertimbngn Bukti Surat IN 2 P', 'data_sql', NULL, NULL, NULL, NULL, 'select (case\r\n\r\nwhen "#1314#"!="" and "#1321#"!="" and "#1325#"!="" then\r\n"Menimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.1 berupa fotokopi Kartu Keluarga yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos dan cocok dengan aslinya, isi bukti tersebut menerangkan adanya satu keluarga dimana Pemohon I sebagai kepala keluarga dan Pemohon II sebagai istri, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon, dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka berdasarkan bukti tersebut harus dinyatakan terbukti bahwa Pemohon I dengan Pemohon II secara administrasi kependudukan telah terdaftar sebagai suami istri;\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.2 berupa fotokopi Akta Cerai yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos dan cocok dengan aslinya, isi bukti tersebut menerangkan bahwa Pemohon I telah bercerai dengan #1323# pada tanggal #1322#, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.3 berupa fotokopi Akta Cerai yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos dan cocok dengan aslinya, isi bukti tersebut menerangkan bahwa Pemohon II telah bercerai dengan #1330# pada tanggal #1329#, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;"\r\n\r\nwhen "#1314#"!="" and "#1321#"!="" then\r\n"Menimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.1 berupa fotokopi Kartu Keluarga yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos dan cocok dengan aslinya, isi bukti tersebut menerangkan adanya satu keluarga dimana Pemohon I sebagai kepala keluarga dan Pemohon II sebagai istri, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon, dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka berdasarkan bukti tersebut harus dinyatakan terbukti bahwa Pemohon I dengan Pemohon II secara administrasi kependudukan telah terdaftar sebagai suami istri;\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.2 berupa fotokopi Akta Cerai yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos dan cocok dengan aslinya, isi bukti tersebut menerangkan bahwa Pemohon I telah bercerai dengan #1323# pada tanggal #1322#, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;"\r\n\r\nwhen "#1314#"!="" and "#1325#"!="" then\r\n"Menimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.1 berupa fotokopi Kartu Keluarga yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos dan cocok dengan aslinya, isi bukti tersebut menerangkan adanya satu keluarga dimana Pemohon I sebagai kepala keluarga dan Pemohon II sebagai istri, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon, dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka berdasarkan bukti tersebut harus dinyatakan terbukti bahwa Pemohon I dengan Pemohon II secara administrasi kependudukan telah terdaftar sebagai suami istri;\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.2 berupa fotokopi Akta Cerai yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos dan cocok dengan aslinya, isi bukti tersebut menerangkan bahwa Pemohon II telah bercerai dengan #1330# pada tanggal #1329#, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;"\r\n\r\nwhen "#1321#"!="" and "#1325#"!="" then\r\n"Menimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.1 berupa fotokopi Akta Cerai yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos, dan cocok dengan aslinya, isi bukti tersebut menerangkan bahwa Pemohon I telah bercerai dengan #1323# pada tanggal #1322#, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.2 berupa fotokopi Akta Cerai yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos, dan cocok dengan aslinya, isi bukti tersebut menerangkan bahwa Pemohon II telah bercerai dengan #1330# pada tanggal #1329#, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;"\r\n\r\nwhen "#1314#"!="" and "#1316#"!="" and "#1510#"!="" then\r\n"Menimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.1 berupa fotokopi Kartu Keluarga yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos dan cocok dengan aslinya, isi bukti tersebut menerangkan adanya satu keluarga dimana Pemohon I sebagai kepala keluarga dan Pemohon II sebagai istri, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon, dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka berdasarkan bukti tersebut harus dinyatakan terbukti bahwa Pemohon I dengan Pemohon II secara administrasi kependudukan telah terdaftar sebagai suami istri;\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.2 berupa Asli Surat Kematian yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup dan telah dicap pos, isi bukti tersebut menerangkan bahwa sebelum menikah Pemohon I telah menikah dengan seorang #2025# bernama #1025# dan telah meninggal dunia pada tanggal #1246# karena #1247#, relevan dengan dalil yang hendak dibuktikan oleh Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.3 berupa Asli Surat Kematian yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup dan telah dicap pos, isi bukti tersebut menerangkan bahwa sebelum menikah Pemohon II telah menikah dengan seorang #1516# bernama #1513# dan telah meninggal dunia pada tanggal #1514# karena #1515#, relevan dengan dalil yang hendak dibuktikan oleh Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;"\r\n\r\nwhen "#1314#"!="" and "#1316#"!="" then\r\n"Menimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.1 berupa fotokopi Kartu Keluarga yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos, dan cocok dengan aslinya, isi bukti tersebut menerangkan adanya satu keluarga dimana Pemohon I sebagai kepala keluarga dan Pemohon II sebagai istri, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon, dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka berdasarkan bukti tersebut harus dinyatakan terbukti bahwa Pemohon I dengan Pemohon II secara administrasi kependudukan telah terdaftar sebagai suami istri;\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.2 berupa Asli Surat Kematian yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup dan telah dicap pos, isi bukti tersebut menerangkan bahwa sebelum menikah Pemohon I telah menikah dengan seorang #2025# bernama #1025# dan telah meninggal dunia pada tanggal #1246# karena #1247#, relevan dengan dalil yang hendak dibuktikan oleh Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;" \r\n\r\nwhen "#1314#"!="" and "#1510#"!="" then\r\n"Menimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.1 berupa fotokopi Kartu Keluarga yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos, dan cocok dengan aslinya, isi bukti tersebut menerangkan adanya satu keluarga dimana Pemohon I sebagai kepala keluarga dan Pemohon II sebagai istri, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon, dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka berdasarkan bukti tersebut harus dinyatakan terbukti bahwa Pemohon I dengan Pemohon II secara administrasi kependudukan telah terdaftar sebagai suami istri;\r\nMenimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P.2 berupa Asli Surat Kematian yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup dan telah dicap pos, isi bukti tersebut menerangkan bahwa sebelum menikah Pemohon II telah menikah dengan seorang #1516# bernama #1513# dan telah meninggal dunia pada tanggal #1514# karena #1515#, relevan dengan dalil yang hendak dibuktikan oleh Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;"\r\n\r\nwhen "#1314#"!="" then\r\n"Menimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P berupa fotokopi Kartu Keluarga yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos dan cocok dengan aslinya, isi bukti tersebut menerangkan adanya satu keluarga dimana Pemohon I sebagai kepala keluarga dan Pemohon II sebagai istri, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon, dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka berdasarkan bukti tersebut harus dinyatakan terbukti bahwa Pemohon I dengan Pemohon II secara administrasi kependudukan telah terdaftar sebagai suami istri;"\r\n\r\nwhen "#1321#"!="" then\r\n"Menimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P berupa fotokopi Akta Cerai yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos dan cocok dengan aslinya, isi bukti tersebut menerangkan bahwa Pemohon I telah bercerai dengan #1323# pada tanggal #1322#, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;"\r\n\r\nwhen "#1325#"!="" then\r\n"Menimbang, bahwa untuk membuktikan dalil-dalilnya, para Pemohon telah mengajukan bukti P berupa fotokopi Akta Cerai yang dikeluarkan oleh Pejabat yang berwenang sebagai akta autentik, bermeterai cukup, telah dicap pos dan cocok dengan aslinya, isi bukti tersebut menerangkan bahwa Pemohon II telah bercerai dengan #1330# pada tanggal #1329#, relevan dengan dalil yang hendak dibuktikan oleh para Pemohon dan tidak ditemukan sesuatu yang membatalkan bukti tersebut, maka alat bukti tersebut telah memenuhi syarat formil dan materil dan sebagai akta autentik memiliki kekuatan pembuktian yang sempurna dan mengikat, maka dalil yang relevan dengan bukti tersebut harus dinyatakan terbukti;"\r\n\r\nelse ""\r\n\r\nend) as data', NULL, NULL, 0, NULL, '2019-08-08 19:56:56'),
	(0377, 'Bukti Surat IN 2 P (otomatis Penetapan)', 'data_sql', NULL, NULL, NULL, NULL, 'select (case\r\n\r\nwhen "#1314#"!="" and "#1321#"!="" and "#1325#"!="" then\r\n"1.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#, telah bermeterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya, lalu diberi kode P.1;\r\n2.   Fotokopi Akta Cerai Nomor #1321# tanggal #1322# yang dikeluarkan oleh #1324#, telah bermeterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya, lalu diberi kode P.2;\r\n3.   Fotokopi Akta Cerai Nomor #1325# tanggal #1329# yang dikeluarkan oleh #1331#, telah bermeterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya, lalu diberi kode P.3;"\r\n\r\nwhen "#1314#"!="" and "#1321#"!="" then\r\n"1.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#, telah bermeterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya, lalu diberi kode P.1;\r\n2.   Fotokopi Akta Cerai Nomor #1321# tanggal #1322# yang dikeluarkan oleh #1324#, telah bermeterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya, lalu diberi kode P.2;"\r\n\r\nwhen "#1314#"!="" and "#1325#"!="" then\r\n"1.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#, telah bermeterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya, lalu diberi kode P.1;\r\n2.   Fotokopi Akta Cerai Nomor #1325# tanggal #1329# yang dikeluarkan oleh #1331#, telah bermeterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya, lalu diberi kode P.2;"\r\n\r\nwhen "#1321#"!="" and "#1325#"!="" then\r\n"1.   Fotokopi Akta Cerai Nomor #1321# tanggal #1322# yang dikeluarkan oleh #1324#, telah bermeterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya, lalu diberi kode P.1;\r\n2.   Fotokopi Akta Cerai Nomor #1325# tanggal #1329# yang dikeluarkan oleh #1331#, telah bermeterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya, lalu diberi kode P.2;"\r\n\r\nwhen "#1314#"!="" and "#1316#"!="" and "#1510#"!="" then\r\n"1.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#, telah bermeterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya, lalu diberi kode P.1;\r\n2.   Asli Surat Keterangan Kematian Nomor #1316# tanggal #1317# yang dikeluarkan oleh #1342#, telah bermeterai cukup dan telah dicap pos (nazegelen), lalu diberi kode P.2;\r\n3.   Asli Surat Keterangan Kematian Nomor #1510# tanggal #1511# yang dikeluarkan oleh #1512#, telah bermeterai cukup dan telah dicap pos (nazegelen), lalu diberi kode P.3;"\r\n\r\nwhen "#1314#"!="" and "#1316#"!="" then\r\n"1.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#, telah bermeterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya, lalu diberi kode P.1;\r\n2.   Asli Surat Keterangan Kematian Nomor #1316# tanggal #1317# yang dikeluarkan oleh #1342#, telah bermeterai cukup dan telah dicap pos (nazegelen), lalu diberi kode P.2;"\r\n\r\nwhen "#1314#"!="" and "#1510#"!="" then\r\n"1.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#, telah bermeterai cukup, telah dicap pos, dan telah dicocokkan dengan aslinya, lalu diberi kode P.1;\r\n2.   Asli Surat Keterangan Kematian Nomor #1510# tanggal #1511# yang dikeluarkan oleh #1512#, telah bermeterai cukup dan telah dicap pos (nazegelen), lalu diberi kode P.2;"\r\n\r\nwhen "#1314#"!="" then\r\n"Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#, telah bermeterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya, lalu diberi kode P;"\r\n\r\nwhen "#1321#"!="" then\r\n"Fotokopi Akta Cerai Nomor #1321# tanggal #1322# yang dikeluarkan oleh #1324#, telah bermeterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya, lalu diberi kode P;"\r\n\r\nwhen "#1325#"!="" then\r\n"Fotokopi Akta Cerai Nomor #1325# tanggal #1329# yang dikeluarkan oleh #1331#, telah bermeterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya, lalu diberi kode P;"\r\n\r\nelse ""\r\n\r\nend) as data', NULL, NULL, 0, NULL, '2019-07-18 12:56:05'),
	(0378, 'Bukti Surat IN', 'data_teks', NULL, NULL, NULL, NULL, NULL, '1.   Fotokopi Kartu Tanda Penduduk dengan NIK #0335# atas nama #4048#, tanggal #0364# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.   Fotokopi Kartu Tanda Penduduk dengan NIK #0336# atas nama #4049#, tanggal #0366# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;\r\n3.   Fotokopi Kartu Keluarga Nomor #1314# tanggal #1315# yang dikeluarkan oleh #1372#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.3). Diberi tanggal dan paraf #0668#;\r\n4.   Asli Surat Keterangan Kematian Nomor #1316# tanggal #1317# yang dikeluarkan oleh #1342#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.4). Diberi tanggal dan paraf #0668#;\r\n5.   Asli Surat Keterangan Kematian Nomor #1510# tanggal #1511# yang dikeluarkan oleh #1512#. Bukti surat tersebut telah diperiksa oleh #0667# dan telah dinazegelen, kemudian diberi kode bukti (P.5). Diberi tanggal dan paraf #0668#;\r\n6.   Fotokopi Akta Cerai Nomor #1321# tanggal #1322# yang dikeluarkan oleh #1324#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.4). Diberi tanggal dan paraf #0668#;\r\n7.   Fotokopi Akta Cerai Nomor #1325# tanggal #1329# yang dikeluarkan oleh #1331#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.5). Diberi tanggal dan paraf #0668#;', NULL, 0, NULL, '2019-05-16 11:29:50'),
	(0600, 'Nama Pria (Dispensasi)', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-03-02 02:53:30'),
	(0601, 'Umur Pria (dispensasi)', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-03-02 02:53:37'),
	(0602, 'Agama Pria (dispensasi)', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'Islam', NULL, 0, NULL, '2018-03-05 03:47:22'),
	(0603, 'Pendidikan Pria (dispensasi)', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-03-02 02:54:08'),
	(0604, 'Pekerjaan Pria (dispensasi)', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-03-02 02:54:16'),
	(0605, 'Alamat Pria (dispensasi)', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'Lingkungan _, Kelurahan _, Kecamatan _, Kabupaten ...\r\nDusun _, Desa _, Kecamatan _, Kabupaten ...\r\n#0101#', NULL, 0, NULL, '2018-03-02 02:54:23'),
	(0606, 'Nama Wanita (Dispensasi)', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-03-02 02:52:19'),
	(0607, 'Umur Wanita (dispensasi)', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-03-02 02:52:28'),
	(0608, 'Agama Wanita (dispensasi)', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'Islam', NULL, 0, NULL, '2018-01-01 04:00:00'),
	(0609, 'Pendidikan Wanita (dispensasi)', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-03-02 02:52:40'),
	(0610, 'Pekerjaan Wanita (dispensasi)', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-03-02 02:52:47'),
	(0611, 'Alamat Wanita (dispensasi)', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'Lingkungan _, Kelurahan _, Kecamatan _, Kabupaten ...\r\nDusun _, Desa _, Kecamatan _, Kabupaten ...\r\n#0101#', NULL, 0, NULL, '2018-03-02 02:53:24'),
	(0612, 'Inti Permasalahan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0613, 'Mulai Berselisih/Bertengar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0652, 'No. Surat Penolakan KUA', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2019-08-08 19:57:33'),
	(0653, 'Tgl. Surat Penolakan KUA', 'data_tanggal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2019-08-08 19:57:34'),
	(0654, 'No. Surat Ket. KUA', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-03-16 08:53:10'),
	(0655, 'Tgl. Surat Ket. KUA', 'data_tanggal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-03-16 08:53:16'),
	(0661, 'No. SK Prodeo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0662, 'Tgl. Penetapan/SK Prodeo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0663, 'Tgl. Pertimbangan/Penetapan Prodeo', 'data_tanggal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-03-28 05:18:16'),
	(0664, 'Tgl. Penunjukan Plt. Ketua', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0670, 'Radio yg ditunjuk (ghoib)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0703, 'Posita 3 Peng.  Anak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0704, 'Hubungan dg. Orgtua Anak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0705, 'Alasan Orgtua Serahkan Anak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0706, 'Kedekatan Pemohon dg. Anak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(0707, 'Sikap Keluarga atas Pengktn Anak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1001, 'Mas kawin', 'data_teks', NULL, NULL, NULL, NULL, NULL, '_ dibayar tunai', NULL, 0, NULL, '2018-01-05 10:03:51'),
	(1002, 'Status #0046# sblm nikah (IN)', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'bujang\r\nduda cerai\r\nduda mati\r\n\r\ngadis\r\njanda cerai\r\njanda mati', NULL, 0, NULL, '2018-01-06 05:03:35'),
	(1003, 'Status #2027# sblm nikah (IN)', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'gadis\r\njanda cerai\r\njanda mati\r\n\r\nbujang\r\nduda cerai\r\nduda mati', NULL, 0, NULL, '2018-05-30 03:11:34'),
	(1006, 'Tempat tinggal setelah nikah', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1007, 'Jumlah anak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1008, 'Akibat dari konflik', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1009, 'Alasan orang tua menolak lamaran', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1010, 'Tempat nikah ke 2 (poligami)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1013, 'Gaji suami / calon suami / hari/bulan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1014, 'Eratnya Hubungan Calon', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-03-02 02:55:43'),
	(1015, 'Nama Ketua Majelis Banding', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1016, 'Nama Hakim 1 Banding', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1017, 'Nama Hakim 2 Banding', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1018, 'Nama PP Banding', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1019, 'Tgl Penetapan Eksekusi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1020, 'Tgl Pelaksanaan Eksekusi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1021, 'Nama Istri Pertama', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1022, 'Umur Istri Pertama', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1023, 'Pekerjaan Istri Pertama', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-04-05 08:48:35'),
	(1024, 'Alamat Istri Pertama', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1025, 'Nama Almarhum / Almarhumah', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-05-30 03:04:16'),
	(1026, 'Umur #2025#', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-04-05 08:19:53'),
	(1027, 'Pekerjaan #2025#', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-01-06 02:22:39'),
	(1028, 'Alamat #2025#', 'data_teks', NULL, NULL, NULL, NULL, NULL, '#0101#', NULL, 0, NULL, '2018-04-05 08:20:55'),
	(1030, 'Umur Suami', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1031, 'Pekerjaan Suami', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1032, 'Alamat Suami', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1037, 'Identitas Wali Nikah', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1038, 'Nama Ayah Kandung', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1039, 'Umur Ayah Kandung', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1040, 'Pekerjaan Ayah Kandung', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1041, 'Alamat Ayah Kandung', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1042, 'Nama Ibu Kandung', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1043, 'Umur Ibu Kandung', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1044, 'Pekerjaan Ibu Kandung', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1045, 'Alamat Ibu Kandung', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1046, 'Status Wali Nikah', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'ayah kandung\r\nsaudara kandung\r\nkakek kandung (ayah dari ayah)\r\npaman kandung (saudara ayah)', NULL, 0, NULL, '2018-01-06 03:06:03'),
	(1048, 'Nama Almarhum', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1049, 'Tgl Daftar Kuasa T', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1050, 'Tgl Penyampaian Salinan Putusan PK dari MA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1051, 'Tgl PBT Bunyi Putusan PK', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1065, 'Nomor surat pengantar relaas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1066, 'PA Lain Ter', 'data_sql', NULL, NULL, NULL, NULL, 'select CONCAT("Pengadilan Agama ",SUBSTRING_INDEX(SUBSTRING_INDEX("#0105#","Kota",-1),"Kabupaten",-1))data', NULL, NULL, 0, NULL, '2019-01-23 06:54:46'),
	(1067, 'Nomor surat peng. pemb. isi putusan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1068, 'PA lain Pe', 'data_sql', NULL, NULL, NULL, NULL, 'select CONCAT("Pengadilan Agama ",SUBSTRING_INDEX(SUBSTRING_INDEX("#0101#","Kota",-1),"Kabupaten",-1))data', NULL, NULL, 0, NULL, '2019-01-23 06:55:10'),
	(1081, 'Tgl. PHS Baru Ikrar Talak', 'data_tanggal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2019-05-08 13:53:10'),
	(1082, 'No. surat pengantar relaas sidang ikrar Pe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1083, 'Nomor surat teguran membayar kekurangan Panjar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1084, 'Tanggal surat tegoran', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1085, 'Tambahan Panjar Biaya Perkara', 'data_sql', NULL, NULL, NULL, NULL, 'select jumlah as data from perkara_biaya\r\nwhere jenis_biaya_id=224 and perkara_id=#perkara_id#', NULL, NULL, 0, NULL, '2019-08-08 20:00:28'),
	(1086, 'Tambah Panjar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1087, 'Batas tanggal membayar kekurangan PBP', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1088, 'Tanggal pencoretan perkara', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1089, 'Negara Duta Besar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1093, 'Nomor surat pemberitahuan mengambil AC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1094, 'Tanggal surat pemberitahuan ambil AC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1096, 'Kecamatan tujuan s. pemberitahuan ambil AC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1097, 'Kabupaten tujuan s. pemberitahuan ambil AC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1101, 'Biaya Penetapan Ikrar Talak', 'data_sql', NULL, NULL, NULL, NULL, 'select (0#1090# + 0#1164#)\r\nas data', NULL, NULL, 0, NULL, '2018-02-21 00:37:57'),
	(1103, 'Ongkos / biaya pemberitahuan Pe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1105, 'Besar nafkah mut\'ah /bulan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1107, 'Tanggal lahir istri (dispensasi kawin)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1108, 'Nomor duplikat surat nikah', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-01-01 04:00:00'),
	(1109, 'Berapa kali calon suami melamar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1110, 'Tgl Inzage P', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1111, 'Tgl Inzage T', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1112, 'Tanggal surat pengantar sita', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1113, 'Nomor Surat Pengantar Sita', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1114, 'Tanggal penyitaan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1115, 'Pelaksana sita', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1116, 'Tanggal surat perintah penyitaan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1117, 'Nama saksi sita ke I', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1118, 'Pekerjaan saksi sita ke I', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1119, 'Alamat saksi sita ke I', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1120, 'Nama saksi sita ke II', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1121, 'Pekerjaan saksi sita ke II', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1126, 'Keterangan dari para saksi Pe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1127, 'Pertimbangan lain (menimbang)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1129, 'Tanggal surat ket. Peng. PNS', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1130, 'Tempat bekerja PNS', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1131, 'Kabupaten / kodya instansi PNS', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1134, 'Tanggal penetapan putusan yg digugurkan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1139, 'Tgl PHS baru 5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1147, 'Tgl PMH baru 5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1148, 'Tgl Penetapan Sita', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1149, 'Yang menerima pendaftaran lisan', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'Dwi Anugerah, S.H.I., M.H.', NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1151, 'Telah / belum hidup rukun ...', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1152, 'Alasan poligami', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'karena #0047# tidak bisa memberi keturunan/anak, padahal #0046# sangat merindukan kehadiran anak sebagai penerus keluarganya\r\n\r\nkarena #0046# mempunyai nafsu sex yang besar, dan #0047# kurang dapat melayani #0046# dengan baik dengan alasan terlalu letih\r\n\r\nkarena #0047# dalam keadaan sakit tumor kandungan / kandungan pernah dikiret sehingga menurut hasil medis, #0047# tidak bisa mengandung/hamil', NULL, 0, NULL, '2018-04-05 08:22:44'),
	(1153, 'Jabatan penerima permohonan lisan', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'Hakim', NULL, 0, NULL, '2018-01-01 04:00:00'),
	(1154, 'Nomor surat peng. relaas PA lain Ter', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'W20-A11//Hk.05/ /#0191#', NULL, 0, NULL, '2018-11-22 01:25:23'),
	(1155, 'Nomor surat peng. pemb. isi putusan Pe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1156, 'Nomor surat peng. pemb. isi putusan Ter', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1157, 'Tanggal surat peng. pemb. isi putusan Pe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1158, 'Tanggal surat peng. pemb. isi putusan Ter', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1159, 'No. surat pemb. mengambil akta cerai Ter', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1160, 'Tanggal surat pemb. ambil akta cerai Ter', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1162, 'Kecamatan tujuan surat pemb. mengambil AC Ter', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1163, 'Kabupaten tujuan surat pemb. mengambil AC Ter', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1164, 'Biaya Panggilan #0047# 1x', 'data_sql', NULL, NULL, NULL, NULL, 'select jumlah as data from perkara_biaya\r\nwhere\r\njenis_biaya_id=14 and perkara_id=#perkara_id#\r\nor\r\njenis_biaya_id=15 and perkara_id=#perkara_id#\r\nORDER BY tanggal_transaksi DESC LIMIT 1;', NULL, NULL, 0, NULL, '2018-02-21 00:37:06'),
	(1165, 'Ongkos / biaya Pemberitahuan Ter', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1166, 'Kab/Kodya Pe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1167, 'Kab/Kodya Ter', 'data_sql', NULL, NULL, NULL, NULL, 'select SUBSTRING_INDEX("#0105#",",",-1) data', NULL, NULL, 0, NULL, '2019-01-23 06:55:58'),
	(1169, 'Tidak mau melakukan hubungan karena', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1170, 'Akibat dari kejadian tersebut', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1171, 'Identitas ayah Pemohon I', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1172, 'Identitas ibu Pemohon I', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1175, 'Pendidikan terakhir Pemohon I', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1177, 'Identitas ayah Pemohon II', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1178, 'Identitas ibu Pemohon II', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1180, 'Kedua belah pihak / Pemohon', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1181, 'Keadaan Istri (Termohon) saat ikrar', 'data_sql', NULL, NULL, NULL, NULL, 'select (case\r\nwhen keadaan_istri = 1 then "Suci"\r\nwhen keadaan_istri = 2 then "Haid"\r\nwhen keadaan_istri = 3 then "Sedang Hamil"\r\nelse "Tidak Diketahui" end) data\r\nfrom perkara_akta_cerai where perkara_id=#perkara_id#', NULL, NULL, 0, NULL, '2019-06-19 06:35:44'),
	(1183, 'Tgl. Batas Waktu Ikrar Talak', 'data_tanggal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2019-05-08 13:33:57'),
	(1186, 'Kehadiran Pemohon', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1187, 'Kehadiran Termohon', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1188, 'Diwakili oleh .... nya', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1189, 'Nama Wakil untuk yang gila', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1190, 'Umur Wakil untuk yang gila', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1191, 'Pekerjaan Wakil untuk yang gila', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1192, 'Tempat kediaman Wakil yang gila', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1209, 'Dipanggil masuk kel. Pe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1210, 'Dipanggil masuk kel. Ter', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1211, '"Atas pertanyaan Ketua,"', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1212, 'Pertanyaan Kel. Pe/Ter', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1213, 'Iwadl ...', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1214, 'Alat-alat bukti CG/CT', 'data_teks', NULL, NULL, NULL, NULL, NULL, '1.Fotokopi Kutipan Akta Nikah dari #1005#, Nomor #1004# Tanggal #1012#. Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.Fotokopi ... Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;', NULL, 0, NULL, '2019-05-16 11:28:18'),
	(1215, 'Keterangan saksi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1217, 'Nama Wali Nikah', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-01-01 04:00:00'),
	(1218, 'Pegawai Pencatat Nikah', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1219, 'Pembantu PPN/Kaur Kesra', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1220, 'Tanggal2 pemanggilan pihak2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1221, 'kemudian Pe pergi ke ....', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1222, 'Tanggal sidang pihak2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1223, 'Kelurahan / Desa ...', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1224, 'Camat Kepala Wilayah ........', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1225, 'Nomor SK tidak mampu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1226, 'Tanggal SK tidak mampu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1230, 'Tanggal meninggalnya suami', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1236, 'Harta waris total berupa ....', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1237, 'Harga harta waris total', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1238, 'Harga dan Bentuk harta waris masing-masing', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1239, 'Identitas Ter secara vertikal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1241, 'Hbgn. Saksi1 P dg. Pihak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1242, 'Hbgn. Saksi2 P dg. Pihak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1244, 'Keterangan Status', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1245, 'Sebab meninggalnya suami', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1246, 'Tanggal meninggalnya #2026#', 'data_tanggal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-01-06 02:07:33'),
	(1247, 'Sebab meninggalnya #2026#', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'sakit', NULL, 0, NULL, '2018-01-06 03:09:49'),
	(1248, 'Hubungan dengan almarhum/almarhumah', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1249, 'Hubungan Pihak dg. Majelis', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1250, 'Hubungan Pihak dg. PP', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1251, 'Hbgn. Saksi1 T dg. Pihak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1252, 'Hbgn. Saksi2 T dg. Pihak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1253, 'Pelanggaran Ta\'lik Talak (No...)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1254, 'Tanggal perubahan sidang', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1255, 'Diberitahukan kepada ....', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1256, 'Berada di rumah (..... Ter)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1257, 'Tempat tinggal dahulu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1259, 'Alamat Tempat Sidang', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1260, 'Tempat Sidang (Relaas)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1261, 'Pengadilan tsb (BAS)', 'data_sql', NULL, NULL, NULL, NULL, 'select (case\r\n\r\nwhen sidang_keliling = "Y"\r\nthen ruangan\r\n\r\nelse ("ruang sidang Pengadilan Agama tersebut")\r\n\r\nend) data\r\nfrom perkara_jadwal_sidang\r\nwhere tanggal_sidang="#0033#" and perkara_id=#perkara_id#', NULL, NULL, 0, NULL, '2019-05-21 08:47:54'),
	(1262, 'Alat Bukti #0047#', 'data_teks', NULL, NULL, NULL, NULL, NULL, '1.Fotokopi ... Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.1). Diberi tanggal dan paraf #0668#;\r\n2.Fotokopi ... Bukti surat tersebut telah diperiksa oleh #0667#, dicocokkan dengan aslinya yang ternyata sesuai dan telah dinazegelen, kemudian diberi kode bukti (P.2). Diberi tanggal dan paraf #0668#;', NULL, 0, NULL, '2019-05-16 11:28:47'),
	(1279, 'Identitas Turut <<0047 lebih dari satu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1280, 'Nama pewaris pria', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1281, 'Tanggal meninggalnya pewaris pria', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1282, 'Hari meninggal suami', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1283, 'Nama pewaris wanita', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1284, 'Tanggal meninggalnya pewaris wanita', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1285, 'Hari Meninggalnya #2026#', 'tanggal_hari', NULL, NULL, NULL, 1246, NULL, NULL, NULL, 0, NULL, '2018-01-06 02:07:51'),
	(1286, 'Indeks berkas disposisi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1313, 'NIP Pejabat KUA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1314, 'No. Kartu Keluarga', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-01-01 04:00:00'),
	(1315, 'Tgl. Kartu Keluarga', 'data_tanggal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-01-01 04:00:00'),
	(1316, 'No. Surat Kematian (bukti Pemohon1)', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-05-30 03:53:53'),
	(1317, 'Tgl. Surat Kematian (bukti Pemohon1)', 'data_tanggal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-05-30 03:53:50'),
	(1318, 'No. Akta Kelahiran', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-01-01 04:00:00'),
	(1319, 'Tgl. Akta Kelahiran', 'data_tanggal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-01-01 04:00:00'),
	(1320, 'Tgl. Surat Ket. Tidak Mampu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1321, 'No. Akta Cerai P I (Bukti)', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-05-30 02:43:29'),
	(1322, 'Tgl. Akta Cerai P I (Bukti)', 'data_tanggal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-05-30 02:44:01'),
	(1323, 'Bekas Isteri P I dlm AC (Bukti)', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-05-30 02:44:10'),
	(1324, 'Penerbit Akta Cerai P I (Bukti)', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'Pengadilan Agama ...', NULL, 0, NULL, '2018-05-30 02:44:27'),
	(1325, 'No. Akta Cerai P II (Bukti)', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-05-30 02:44:33'),
	(1326, 'Tgl Surat Gugatan/Permohonan Lisan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1327, 'Hari #1183#', 'tanggal_hari', NULL, NULL, NULL, 1183, NULL, NULL, NULL, 0, NULL, '2019-07-08 08:38:59'),
	(1329, 'Tgl. Akta Cerai P II (Bukti)', 'data_tanggal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-05-30 02:44:46'),
	(1330, 'Bekas Suami P II dlm AC (Bukti)', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-05-30 02:44:52'),
	(1331, 'Penerbit Akta Cerai P II (Bukti)', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'Pengadilan Agama ...', NULL, 0, NULL, '2018-05-30 02:45:06'),
	(1332, 'Jenis Alat Bukti Tgl. Lahir Putra', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'Kutipan Akta Kelahiran\r\nIjazah SD\r\nIjazah SMP\r\nIjazah SMA\r\nKeterangan Lahir', NULL, 0, NULL, '2018-03-05 03:45:17'),
	(1333, 'No. Alat Bukti Tgl. Lahir Putra', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-03-05 03:42:51'),
	(1334, 'Tgl. Alat Bukti Tgl. Lahir Putra', 'data_tanggal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-03-05 03:42:59'),
	(1335, 'Pnrbit Alat Bukti Tgl. Lahir Putra', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'Kepala Dinas Kependudukan dan Pencatatan Sipil Kabupaten Majene\r\nKepala Sekolah .....\r\nBidan atas nama .....', NULL, 0, NULL, '2017-08-08 00:46:28'),
	(1336, 'Jenis Alat Bukti Tgl. Lahir Putri', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'Kutipan Akta Kelahiran\r\nIjazah SD\r\nIjazah SMP\r\nIjazah SMA\r\nKeterangan Lahir', NULL, 0, NULL, '2018-03-02 02:58:00'),
	(1337, 'No. Alat Bukti Tgl. Lahir Putri', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-03-02 02:58:48'),
	(1338, 'Tgl. Alat Bukti Tgl. Lahir Putri', 'data_tanggal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-03-02 02:58:41'),
	(1339, 'Pnrbit Alat Bukti Tgl. Lahir Putri', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'Kepala Pejabat Pembuat Akta Catatan Sipil Kabupaten .....\r\nKepala Sekolah .....\r\nBidan atas nama .....', NULL, 0, NULL, '2018-03-02 02:58:34'),
	(1340, 'No. Kartu Keluarga Pemohon II', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-03-05 03:42:27'),
	(1341, 'Tgl. Kartu Keluarga Pemohon II', 'data_tanggal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-03-05 03:42:33'),
	(1342, 'Penerbit Surat Kematian (bukti Pemohon1)', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'Kepala Desa ...', NULL, 0, NULL, '2018-05-30 03:53:45'),
	(1343, 'Jenis Alat Bukti Lain 1', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'SK Veteran\r\nSK PNS\r\nSK Pensiun\r\nAkta Cerai', NULL, 0, NULL, '2018-02-21 03:12:40'),
	(1344, 'No. Alat Bukti Lain 1', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-02-21 03:10:20'),
	(1345, 'Tgl. Alat Bukti Lain 1', 'data_tanggal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-02-21 03:10:39'),
	(1346, 'Penerbit Alat Bukti Lain 1', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-02-21 03:11:00'),
	(1347, 'Isi Pokok Alat Bukti Lain 1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1348, 'Jenis Alat Bukti Lain 2', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'KARIP (Kartu Identitas Pensiun)', NULL, 0, NULL, '2018-02-21 03:12:17'),
	(1349, 'No. Alat Bukti Lain 2', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-02-21 03:11:40'),
	(1350, 'Tgl. Alat Bukti Lain 2', 'data_tanggal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-02-21 03:11:46'),
	(1351, 'Penerbit Alat Bukti Lain 2', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-02-21 03:11:54'),
	(1352, 'Isi Pokok Alat Bukti Lain 2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1353, 'Jenis Alat Bukti Lain 3', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'SK Veteran\r\nSK PNS\r\nSK Pensiun\r\nAkta Cerai', NULL, 0, NULL, '2018-02-21 03:12:49'),
	(1354, 'No. Alat Bukti Lain 3', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-02-21 03:12:55'),
	(1355, 'Tgl. Alat Bukti Lain 3', 'data_tanggal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-02-21 03:13:02'),
	(1356, 'Alasan/dalil gugatan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1357, 'Alasan Wali Nikah (kosongkan)', 'data_teks', NULL, NULL, NULL, NULL, NULL, ', karena ...', NULL, 0, NULL, '2018-01-01 04:00:00'),
	(1358, 'Alasan tiada Buku Nikah', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'Bahwa #0046# I dan #0046# II telah melaporkan pernikahannya kepada pak imam untuk didaftarkan pada Kantor Urusan Agama, namun pak imam tersebut tidak melanjutkan pendaftarannya ke Pembantu Pegawai Pencatat Nikah Kantor Urusan Agama\r\n\r\nBahwa #0046# I dan #0046# II telah melaporkan pernikahannya ke Pembantu Pegawai Pencatat Nikah setempat, namun Pembantu Pegawai Pencatat Nikah tersebut tidak melaporkan pencatatan pernikahan tersebut ke Kantor Urusan Agama\r\n\r\nBahwa #0046# I dan #0046# II telah melaporkan pernikahannya ke Kantor Urusan Agama, namun pihak Kantor Urusan Agama belum menerbitkan Buku Kutipan Akta Nikah padahal seluruh persyaratan administrasi telah dipenuhi\r\n\r\nBahwa #0046# I dan #0046# II tidak melaporkan pernikahannya ke Pembantu Pegawai Pencatat Nikah setempat, sehingga Pembantu Pegawai Pencatat Nikah tidak mendaftarkan pernikahan tersebut di Kantor Urusan Agama\r\n\r\nBahwa #0046# I dan #0046# II menikah sebelum Tahun 1974, dimana pada saat itu pencatatan nikah belum tertib\r\n\r\nBahwa #0046# I dan #0046# II pernah memiliki Buku Kutipan Akta Nikah namun hilang/rusak', NULL, 0, NULL, '2018-01-05 10:27:01'),
	(1359, 'Petitum', 'data_sipp', 'perkara', 'petitum', NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-01-01 04:00:00'),
	(1360, 'Penerbit Alat Bukti Lain 3', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-02-21 03:13:07'),
	(1361, 'Isi Pokok Alat Bukti Lain 3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1362, 'Jenis Alat Bukti Lain 4', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'SK Veteran\r\nSK PNS\r\nSK Pensiun\r\nAkta Cerai', NULL, 0, NULL, '2018-02-21 03:13:14'),
	(1363, 'No. Alat Bukti Lain 4', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-02-21 03:13:19'),
	(1364, 'Tgl. Alat Bukti Lain 4', 'data_tanggal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-02-21 03:13:25'),
	(1365, 'Penerbit Alat Bukti Lain 4', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-02-21 03:13:30'),
	(1366, 'Isi Pokok Alat Bukti Lain 4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1367, 'Jenis Alat Bukti Lain 5', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'SK Veteran\r\nSK PNS\r\nSK Pensiun\r\nAkta Cerai', NULL, 0, NULL, '2018-02-21 03:13:38'),
	(1368, 'No. Alat Bukti Lain 5', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-02-21 03:13:43'),
	(1369, 'Tgl. Alat Bukti Lain 5', 'data_tanggal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-02-21 03:13:50'),
	(1370, 'Penerbit Alat Bukti Lain 5', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-02-21 03:16:11'),
	(1371, 'Isi Pokok Alat Bukti Lain 5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1372, 'Penerbit Kartu Keluarga', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'Kepala Dinas Kependudukan dan Pencatatan Sipil Kabupaten Majene', NULL, 0, NULL, '2017-12-01 01:33:25'),
	(1373, 'Isi Pokok Kartu Keluarga', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(1509, 'Tempat Meninggal Dunia', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'Lingkungan _, Kelurahan _, Kecamatan _, Kabupaten ...\r\nDusun _, Desa _, Kecamatan _, Kabupaten ...\r\n#0101#', NULL, 0, NULL, '2018-01-17 07:02:25'),
	(1510, 'No. Surat Kematian (bukti Pemohon2)', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-05-30 03:54:05'),
	(1511, 'Tgl. Surat Kematian (bukti Pemohon2)', 'data_tanggal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-05-30 03:53:59'),
	(1512, 'Penerbit Surat Kematian (bukti Pemohon2)', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'Kepala Desa ...', NULL, 0, NULL, '2018-05-30 03:53:56'),
	(1513, 'Nama Suami Meninggal (bukti Pemohon2)', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-05-30 04:34:36'),
	(1514, 'Tanggal Suami Meninggal (bukti Pemohon2)', 'data_tanggal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-05-30 04:34:44'),
	(1515, 'Penyebab Suami Meninggal (bukti Pemohon2)', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'sakit', NULL, 0, NULL, '2018-05-30 04:34:57'),
	(1516, 'Pria / Wanita (1513)', 'data_sql', NULL, NULL, NULL, NULL, 'select\r\n(case when "#1513#" like "%binti%" then "Wanita"\r\nelse "Pria" end)\r\nas data', NULL, NULL, 0, NULL, '2019-01-23 07:01:26'),
	(1517, 'Jenis Kelamin #0046#', 'data_sql', NULL, NULL, NULL, NULL, 'select (case when b.jenis_kelamin = "L" then "Laki-laki" else "Perempuan" end) as data from perkara_pihak1 a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere urutan=1 and perkara_id=#perkara_id#', NULL, NULL, 0, NULL, '2019-06-19 06:35:44'),
	(1518, 'Jenis Kelamin #0047#', 'data_sql', NULL, NULL, NULL, NULL, 'select (case when b.jenis_kelamin = "L" then "Laki-laki" else "Perempuan" end) as data from perkara_pihak2 a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere urutan=1 and perkara_id=#perkara_id#', NULL, NULL, 0, NULL, '2019-06-19 06:35:44'),
	(2003, 'Hari Tgl. Mediasi', 'tanggal_hari', NULL, NULL, NULL, 0057, NULL, NULL, NULL, 0, NULL, '2018-12-26 06:41:01'),
	(2004, 'kini anak tersebut diasuh oleh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(2006, 'Pendidikan Istri Pertama', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(2007, 'Pendidikan Calon Istri', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-04-05 08:20:40'),
	(2011, 'Kesimpulan Bukti & Saksi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(2025, 'Pria / Wanita (almarhum)', 'data_sql', NULL, NULL, NULL, NULL, 'select\r\n(case when "#1025#" like "%binti%" then "Wanita"\r\nelse "Pria" end)\r\nas data', NULL, NULL, 0, NULL, '2019-01-23 07:01:26'),
	(2026, 'dgn. Almarhum / Almarhumah', 'data_sql', NULL, NULL, NULL, NULL, 'select\r\n(case when "#1025#" like "%binti%" then "Almarhumah"\r\nelse "Almarhum" end)\r\nas data', NULL, NULL, 0, NULL, '2019-01-23 07:01:26'),
	(2027, 'Pria / Wanita (#0046# II)', 'data_sql', NULL, NULL, NULL, NULL, 'select\r\n(case when "#1033#" like "%binti%" or "#0102#" like "%binti%" \r\nthen "Wanita"\r\nelse "Pria" end)\r\nas data', NULL, NULL, 0, NULL, '2019-01-23 07:01:26'),
	(2028, 'Status #2026# sblm nikah', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'bujang\r\nduda cerai\r\nduda mati\r\n\r\ngadis\r\njanda cerai\r\njanda mati', NULL, 0, NULL, '2018-08-02 03:26:10'),
	(2029, 'Status Anak Pria (DK)', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'bujang\r\nduda cerai\r\nduda mati', NULL, 0, NULL, '2018-08-02 07:16:27'),
	(2030, 'Status Anak Wanita (DK)', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'gadis\r\njanda cerai\r\njanda mati', NULL, 0, NULL, '2018-08-02 07:16:35'),
	(2040, 'Jika tiada Bukti Surat HAPUS ini', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(2050, 'Terbilang Biaya Ikrar', 'terbilang', NULL, NULL, NULL, 1101, NULL, NULL, NULL, 0, NULL, '2019-05-12 04:14:17'),
	(2063, 'Amar Pen. Ikrar Talak', 'data_sipp', 'perkara_ikrar_talak', 'amar_ikrar_talak', NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-01-01 04:00:00'),
	(3001, 'Tgl. Akta Pernyataan Perm. Kasasi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(3011, 'Agama Pembanding', 'data_sql', NULL, NULL, NULL, NULL, 'select c.nama as data\r\nfrom perkara_banding_detil a\r\njoin pihak b on a.pihak_id=b.id\r\njoin agama c on b.agama_id=c.id\r\nwhere a.status_pihak_id=1 and a.urutan_banding=1 and a.perkara_id=#perkara_id#', NULL, NULL, 0, NULL, '2019-05-16 01:57:43'),
	(3021, 'Pendidikan Pembanding', 'data_sql', NULL, NULL, NULL, NULL, 'select c.kode as data from perkara_banding_detil a\r\njoin pihak b on a.pihak_id=b.id\r\njoin tingkat_pendidikan c on b.pendidikan_id=c.id\r\nwhere a.status_pihak_id=1 and a.urutan_banding=1 and a.perkara_id=#perkara_id#', NULL, NULL, 0, NULL, '2019-05-16 01:57:57'),
	(3046, 'Dahulu Pembanding sebagai', 'data_sql', NULL, NULL, NULL, NULL, 'select status_pihak_text as data from perkara_banding_detil where \r\nstatus_pihak_id=1 and urutan_banding=1 and perkara_id=#perkara_id#', 'select status_pihak_text as data from perkara_banding_detil where \r\nstatus_pihak_id=1 and urutan_banding=1 and perkara_id=#perkara_id#', NULL, 0, NULL, '2019-05-16 02:02:34'),
	(3047, 'Terbanding / Termohon Kasasi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(3098, 'Nama Pembanding', 'data_sql', NULL, NULL, NULL, NULL, 'select pihak_nama as data from perkara_banding_detil where \r\nstatus_pihak_id=1 and urutan_banding=1 and perkara_id=#perkara_id#', NULL, NULL, 0, NULL, '2019-05-16 01:58:18'),
	(3100, 'Pekerjaan Pembanding', 'data_sql', NULL, NULL, NULL, NULL, 'select b.pekerjaan as data\r\nfrom perkara_banding_detil a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere a.status_pihak_id=1 and a.urutan_banding=1 and a.perkara_id=#perkara_id#', NULL, NULL, 0, NULL, '2019-05-16 01:58:29'),
	(3101, 'Alamat Pembanding', 'data_sql', NULL, NULL, NULL, NULL, 'select pemohon_alamat as data from perkara_banding_detil where \r\nstatus_pihak_id=1 and urutan_banding=1 and perkara_id=270', NULL, NULL, 0, NULL, '2019-05-16 02:11:46'),
	(3335, 'No. NIK Pembanding', 'data_sql', NULL, NULL, NULL, NULL, 'select b.nomor_indentitas as data from perkara_banding_detil a\r\njoin pihak b on a.pihak_id=b.id\r\nwhere a.status_pihak_id=1 and a.urutan_banding=1 and a.perkara_id=#perkara_id#', NULL, NULL, 0, NULL, '2019-05-16 02:09:58'),
	(3341, 'Tempat Lahir Pembanding', 'data_sql', NULL, NULL, NULL, NULL, 'select b.tempat_lahir as data\r\nfrom perkara_banding_detil a join pihak b on a.pihak_id=b.id\r\nwhere a.status_pihak_id=1 and a.urutan_banding=1 and a.perkara_id=#perkara_id#', NULL, NULL, 0, NULL, '2019-05-16 01:58:49'),
	(3345, 'Tgl. Lahir Pembanding', 'data_sql', NULL, NULL, NULL, NULL, 'select b.tanggal_lahir as data\r\nfrom perkara_banding_detil a join pihak b on a.pihak_id=b.id\r\nwhere a.status_pihak_id=1 and a.urutan_banding=1 and a.perkara_id=#perkara_id#', NULL, NULL, 0, NULL, '2019-05-16 01:58:57'),
	(3502, 'No.Surat Ket.Desa ttg Hub.Nasab', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(3503, 'Tgl.Surat Ket.Desa ttg Hub.Nasab', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(3504, 'Tanggal & Nomor SK Jurusita', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(3505, 'Lurah / Kades #0046#', 'data_sql', NULL, NULL, NULL, NULL, 'select replace(replace("#5214#","Kelurahan","Lurah"),"Desa","Kepala Desa") data', NULL, NULL, 0, NULL, '2019-01-23 07:01:26'),
	(3506, 'Lurah / Kades #0047#', 'data_sql', NULL, NULL, NULL, NULL, 'select replace(replace("#5220#","Kelurahan","Lurah"),"Desa","Kepala Desa") data', NULL, NULL, 0, NULL, '2019-01-23 07:01:26'),
	(4046, '#0046# dan Kuasanya', 'data_sql', NULL, NULL, NULL, NULL, 'select (case\r\n\r\nwhen "#0106#"!="" and "#1033#"!="" then\r\n"Para #0046# dan Kuasanya"\r\n\r\nwhen "#0106#"!="" then\r\n"#0046# dan Kuasanya"\r\n\r\nwhen "#1033#"!="" then\r\n"Para #0046#"\r\n\r\nelse\r\n"#0046#"\r\n\r\nend) as data', NULL, NULL, 0, NULL, '2019-01-23 07:01:26'),
	(4047, '#0047# dan Kuasanya', 'data_sql', NULL, NULL, NULL, NULL, 'select (case\r\n\r\nwhen "#0170#"="" then\r\n"#0047#"\r\n\r\nelse\r\n"#0047# dan Kuasanya"\r\n\r\nend) data', NULL, NULL, 0, NULL, '2019-01-23 07:01:26'),
	(4048, 'Nama #0046# (tanpa bin)', 'data_sql', NULL, NULL, NULL, NULL, 'select SUBSTRING_INDEX(SUBSTRING_INDEX("#0098#", " bin ", 1), " binti ", 1) data', NULL, NULL, 0, NULL, '2019-06-19 06:35:44'),
	(4049, 'Nama #0046# II (tanpa bin)', 'data_sql', NULL, NULL, NULL, NULL, 'select SUBSTRING_INDEX(SUBSTRING_INDEX("#1033#", " bin ", 1), " binti ", 1) data', NULL, NULL, 0, NULL, '2019-06-19 06:35:44'),
	(4050, 'Nama #0047# (tanpa bin)', 'data_sql', NULL, NULL, NULL, NULL, 'select SUBSTRING_INDEX(SUBSTRING_INDEX("#0102#", " bin ", 1), " binti ", 1) data', NULL, NULL, 0, NULL, '2019-06-19 06:35:44'),
	(5001, 'Sebutan Perangkat Desa', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5002, 'Pekerjaan suami/ayah', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5003, 'Tgl meninggal suami/ayah', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5004, 'Sebab meninggal (karena ...)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5005, 'Ternyata pernikahan tsb ....', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5007, '"Ayat-ayat Al-Qur\'an, Hadist & Kitab lain"', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5008, '"Ayat-ayat Al-Qur\'an, Hadist & Kitab lain (2)"', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5009, 'Tempat menikah', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5010, 'Wujud/perilaku gila', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5011, 'Tempat pengobatan non paramedis', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5012, 'Kenyataan bahwa Ter adalah ...', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5013, 'Karena Ter adalah ....', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5014, 'Pengucapan ijab', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5015, 'Tgl meninggal isteri/ibu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5016, 'Sebab meninggal isteri/ibu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5017, 'Tanda bukti (PI dst..)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5018, 'Diperintahkan kepada', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5020, 'Tgl Penetapan coret', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5021, 'Tgl Pemberitahuan coret', 'data_tanggal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-03-20 01:18:21'),
	(5023, 'KUA Nikah Ter. II', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5024, 'Tgl Nikah Ter. II', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5025, 'Nomor Nikah Ter. II', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5030, 'Pembayaran Pemohon dlm ikrar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5031, 'Barang-barang bawaan Penggugat', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5032, 'Harta bersama/gono-gini', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5033, 'Harta bersama/gono-gini 2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5034, 'Keterangan harta bawaan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5035, 'Al Baqarah : 227', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5036, 'Al Baqarah : 229', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5038, 'Ghoyatul Marom', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5040, 'Al Anwar II : 422', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5047, 'Asybah wan Nadhaair', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5048, 'TanyaJwb Saksi 1 T (F9)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5049, 'TanyaJwb Saksi 2 T (F9)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5053, 'Hadist Rasulullah SAW', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5054, 'Kifayatul Ahkyar III : 36', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5055, 'Perincian nafkah', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5056, 'Posita nafkah I', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5057, 'Posita nafkah II', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5061, 'Pertanyaan kepada keluarga T.', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5062, 'Surat jawaban...(sudah/belum)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5063, 'Tertanggal cap pos ...', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5064, 'Biaya panggilan ... (telah)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5065, 'Tanggal pengiriman surat yl', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5066, 'Tgl Sidang Sita', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5067, 'Bukti permohonan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5068, 'Posita gono-gini KE 4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5069, 'Posita gono-gini KE 5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5070, 'Posita gono-gini KE 6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5071, 'Identitas Pe secara vertikal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5072, 'Nama Pe secara vertikal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5073, 'Nama Ter secara vertikal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5074, 'Identitas para Pe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5075, 'Identitas para Ter', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5076, 'Tahun AC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5077, 'Tgl. Pengembalian Buku Nikah ke Pihak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5105, 'Alamat Tempat Menikah', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'Lingkungan _, Kelurahan _, Kecamatan _, Kabupaten ...\r\nDusun _, Desa _, Kecamatan _, Kabupaten ...\r\n#0101#', NULL, 0, NULL, '2018-01-08 06:43:11'),
	(5108, 'suami / istri #0046#', 'data_sql', NULL, NULL, NULL, NULL, 'select (case when jenis_perkara_id=346 then "istri #0046#"\r\nelse "suami #0046#" end) as data\r\nfrom perkara where perkara_id=#perkara_id#', NULL, NULL, 0, NULL, '2019-01-23 07:01:26'),
	(5109, 'suami / istri #0047#', 'data_sql', NULL, NULL, NULL, NULL, 'select (case when jenis_perkara_id=346 then "suami #0047#"\r\nelse "istri #0047#" end) as data\r\nfrom perkara where perkara_id=#perkara_id#', NULL, NULL, 0, NULL, '2019-01-23 07:01:26'),
	(5110, 'Nama anak', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 'iwan', '2019-08-11 08:04:11'),
	(5111, 'Umur anak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5112, 'Pekerjaan anak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5113, 'Tempat tinggal anak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5120, 'Mengadili/Menetapkan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5121, 'Tanggal Perceraian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5123, '"Pertanyaan Ketua (verstek),"', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5124, 'Letak rumah Ter', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5126, 'Setelah Nikah, #0046# dan #0047#', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'tidak pernah tinggal bersama\r\ntinggal bersama di ..... selama .....\r\ntinggal bersama di ..... selama ..... dan terakhir tinggal bersama di ..... selama .....', NULL, 0, NULL, '2018-03-26 01:06:51'),
	(5127, 'Alasan-Alasan Cerai Gugat ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5128, 'Alasan-Alasan #0048#', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'Bahwa sejak semula pernikahan #0046# dengan #0047# dilaksanakan secara terpaksa karena ??;\r\nBahwa sejak semula pernikahan #0046# dengan #0047# bukan atas dasar saling mencintai melainkan hanya dijodohkan oleh orang tua kedua belah pihak;\r\nBahwa sejak semula pernikahan #0046# dengan #0047# tidak direstui oleh orang tua ?? sehingga ??;\r\nBahwa #0046# dengan #0047# hidup berjauhan sejak ?.... karena ?.... dan hanya biasa berkumpul ketemu ....... kali dalam......;\r\nBahwa pada ?? telah terjadi perselisihan antara Pernggugat dan #0047# karena ??;\r\nBahwa pada ?? terjadi kembali perselisihan antara #0046# dan #0047# karena ..?.;\r\nBahwa sejak ?? antara #0046# dan #0047# sering terjadi perselisihan karena ??;\r\nBahwa kemelut rumah tangga antara #0046# dan #0047# mulai muncul pada ....... karena ...?;\r\nBahwa #0047# sering mengucapkan kata-kata hinaan seperti ....... / mengucapkan kata-kata cerai / melakukan kekerasan pisik kepada #0046# ketika marah;\r\nBahwa puncak perselisihan / kemelut rumah tangga antara #0046# dan #0047# terjadi pada ?? karena ?? akibatnya ??;\r\nBahwa #0046# dengan #0047# tidak pernah dapat melakukan hubungan suami istri (qabladdukhul) karena ??;\r\nBahwa pada ??. #0047# pergi ke ?? untuk ?? namun sudah sekitar ??. tidak pernah ada kabar beritanya dan tidak diketahui lagi keberadaannya;\r\nBahwa pada ?.? #0047# pergi ke ?? untuk .?.. namun tidak pernah kembali lagi untuk hidup bersama dengan #0046#;\r\nBahwa #0047# telah pergi meninggalkan #0046# sejak ?? dan tidak pernah kembali lagi untuk hidup bersama dengan #0046#;\r\nBahwa #0046# telah meninggalkan #0047# sejak ?? karena ??;\r\nBahwa #0047# sudah tidak diketahui alamat keberadaannya oleh #0046#;\r\nBahwa #0046# dengan #0047# sudah tidak pernah satu ranjang selama ??;\r\nBahwa #0046# dengan #0047# sudah berpisah tempat tinggal selama ??;\r\nBahwa #0047# tidak pernah lagi datang mengunjungi #0046# sudah sekitar ?? tahun;\r\nBahwa antara #0046# dan #0047# sudah tidak pernah ada komunikasi selama ??;\r\nBahwa #0046# dengan #0047# sudah tidak saling mempedulikan selama ??.;\r\nBahwa #0046# dengan #0047# sudah pernah diupayakan untuk dirukunkan oleh ?? namun tidak berhasil;\r\nBahwa #0046# sudah berusaha mencari tahu keberadaan #0047# dengan ?? namun tidak berhasil;', NULL, 0, NULL, '2018-11-05 00:54:14'),
	(5130, 'Tgl Penetapan Tegoran', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5131, 'Tempo memanggil (....) hari', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5133, 'Supaya ...... datang', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5134, 'Tgl Panggilan Tegoran', 'data_tanggal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2019-05-15 15:47:06'),
	(5136, 'Alasan verzet', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5137, 'Sita ..... (konservaoir/eksekusi)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5138, 'Barang di ... (tangan/kepunyaan)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5139, 'Dihukum untuk ....', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5140, 'Obyek Sengketa', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5141, 'Yang ditunjuk untuk menyimpan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5142, 'Yang membuat BAP penyitaan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5143, 'Umur saksi sita I', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5144, 'Umur saksi sita II', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5145, 'Nama Kepala Desa/Lurah', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5146, 'Biaya penyitaan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5147, 'Uang harian Panitera/Jurusita', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5148, 'Upah saksi-saksi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5149, 'Biaya jalan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5150, 'Biaya keamanan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5151, 'Biaya Sita Konservatoir', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5152, 'Kepala BPN .......', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5153, 'Umur Kepala Desa/Lurah', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5154, 'Pekerjaan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5155, 'Tempat tinggal KADES', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5156, 'Para Ter', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5157, 'Kantor Lelang ......', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5158, 'Nama Petugas kantor lelang', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5159, 'Identitas penawar lelang tertinggi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5160, 'Harga lelang tertinggi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5161, 'terbilang harga lelang', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5162, 'Pemberitahuan kpd Ka.BPN', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5163, 'Perintah Panitera/Jurusita', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5164, 'Tempat sengketa', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5165, 'Obyek sengketa II', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5167, 'Perjanjian Perkawinan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5168, 'Status wali Pe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5169, 'Identitas wali jika bukan ayah Pe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5170, 'Status Pe thd wali', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5171, 'Penghasilan #0046# Perbulan', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-04-05 08:49:00'),
	(5172, 'Nama lengkap wali pada petitum', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5176, 'Nomor Buku Nikah', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-03-16 08:57:11'),
	(5177, 'Tanggal Buku Nikah', 'data_tanggal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-03-16 08:57:17'),
	(5178, 'KUA Kec.', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'Kantor Urusan Agama Kecamatan ... Kabupaten Majene', NULL, 0, NULL, '2017-08-31 05:55:51'),
	(5179, 'Status Pengakuan Termohon I', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5180, 'Tempat akan Dicatat Perubahan', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'Kantor Urusan Agama #1005#', NULL, 0, NULL, '2018-02-21 03:38:05'),
	(5182, 'Posita 1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5183, 'Posita 2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5184, 'Posita XXX', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5185, 'Posita 3', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5186, 'Posita 4', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5187, 'Posita 5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5188, 'Posita 6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5189, 'Posita 7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5190, 'Posita 8', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5191, 'Posita 9', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5192, 'Posita 10', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5193, 'Posita Batal Nikah 1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5194, 'Posita Batal Nikah 2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5197, 'Tgl Nikah', 'data_tanggal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-04-05 07:58:31'),
	(5198, 'Radius Pe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5200, 'Radius Ter', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5202, 'Pasal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5204, 'Pertimbangan Hukum', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5205, 'Pertimbangn Bukti Surat IN Sidkl', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5206, 'Alasan dibolehkan Itsbat Nikah', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5207, 'Identitas Kuasa Pe secara vertikal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5208, 'Rumusn Pokok Perkara IN 2 P', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5209, 'Pertimbngan Bukti Surat IN', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5210, 'Pertimbngn Dasar Hukum IN ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5214, 'Desa / Kelurahan #0046#', 'data_sql', NULL, NULL, NULL, NULL, 'select (case \r\n\r\nwhen locate("Desa","#0101#")>0 then\r\nSUBSTRING_INDEX(SUBSTRING("#0101#",position("Desa" IN "#0101#")),",",1)\r\n\r\nwhen locate("Kelurahan","#0101#")>0 then\r\nSUBSTRING_INDEX(SUBSTRING("#0101#",position("Kelurahan" IN "#0101#")),",",1)\r\n\r\nend)data', NULL, NULL, 0, NULL, '2019-01-23 07:01:26'),
	(5215, 'Kecamatan #0046#', 'data_sql', NULL, NULL, NULL, NULL, 'select SUBSTRING_INDEX(SUBSTRING_INDEX("#0101#",",",3),",",-1) data', NULL, NULL, 0, NULL, '2019-01-23 07:01:26'),
	(5216, 'Kota / Kabupaten #0046#', 'data_sql', NULL, NULL, NULL, NULL, 'select SUBSTRING_INDEX(SUBSTRING_INDEX("#0101#",",",4),",",-1) data', NULL, NULL, 0, NULL, '2019-01-23 07:01:26'),
	(5220, 'Desa / Kelurahan #0047#', 'data_sql', NULL, NULL, NULL, NULL, 'select (case \r\n\r\nwhen locate("Desa","#0105#")>0 then\r\nSUBSTRING_INDEX(SUBSTRING("#0105#",position("Desa" IN "#0105#")),",",1)\r\n\r\nwhen locate("Kelurahan","#0105#")>0 then\r\nSUBSTRING_INDEX(SUBSTRING("#0105#",position("Kelurahan" IN "#0105#")),",",1)\r\n\r\nend)data', NULL, NULL, 0, NULL, '2019-01-23 07:01:26'),
	(5221, 'Kecamatan #0047#', 'data_sql', NULL, NULL, NULL, NULL, 'select SUBSTRING_INDEX(SUBSTRING_INDEX("#0105#",",",3),",",-1) data', NULL, NULL, 0, NULL, '2019-01-23 07:01:26'),
	(5222, 'Kota / Kabupaten #0047#', 'data_sql', NULL, NULL, NULL, NULL, 'select SUBSTRING_INDEX(SUBSTRING_INDEX("#0105#",",",4),",",-1) data', NULL, NULL, 0, NULL, '2019-01-23 07:01:26'),
	(5223, 'Biaya Meterai', 'data_sql', NULL, NULL, NULL, NULL, 'select "6000.00"as data', NULL, NULL, 0, NULL, '2019-01-23 07:01:26'),
	(5224, 'Jumlah biaya meterai & penetapan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5225, 'Iwadl', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5226, 'Terbilang Iwadl', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5230, 'Ongkos Panggilan Permintaan Bantuan', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-01-30 02:52:35'),
	(5231, 'Pertimbangan adanya mutasi ......', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5232, 'Jumlah Buku Nikah/Duplikat', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5233, 'Hijriyah Tgl. Cerai', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5234, 'Nama sebenarnya', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5235, 'Surat Keterangan Desa', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5236, 'No. Surat Ket. Tidak Mampu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5237, 'KUA tempat tinggal <<0046', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5238, 'KUA tempat tinggal <<0047', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5239, 'Keterangan perkawinan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5240, 'Sebutan status Pe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5241, 'Sebutan status Ter', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(5243, 'Tanggal PSP', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6004, 'Semula P sebagai', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6005, 'Semula T Sebagai', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6006, 'Nomor surat pengantar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6007, 'Nomor surat pengantar memeriksa berkas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6008, 'Tanggal SP memeriksa berkas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6009, 'Tanggal pencabutan permohonan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6010, 'Hari pencabutan permohonan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6011, 'No Surat PBT Penyerahan Kontra', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6012, 'Tgl PBT Penyerahan Kontra', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6013, 'No SP PBT Penyerahan Memori', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6014, 'Tgl SP PBT Penyerahan Memori', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6015, 'Nomor Gugatan/Permohonan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6027, 'Tahun pergi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6028, 'Nama si Mafqud', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6029, 'Alasan pergi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6035, 'Saudara (i) PP', 'data_sql', NULL, NULL, NULL, NULL, 'select (case when \r\n\r\n"#0015#" like "%asmah%" or \r\n"#0015#" like "%nasriah%" or \r\n"#0015#" like "%thahirah%" \r\n\r\nthen "Saudari"\r\nelse "Saudara" end)data', NULL, NULL, 0, NULL, '2019-01-23 07:01:26'),
	(6036, 'Saudara (i) JSP', 'data_sql', NULL, NULL, NULL, NULL, 'select (case when \r\n\r\n"#0018#" like "%fahmiyan%" \r\n\r\nthen "Saudari"\r\nelse "Saudara" end)data', NULL, NULL, 0, NULL, '2019-01-23 07:01:26'),
	(6037, 'Saudara (i) Mediator', 'data_sql', NULL, NULL, NULL, NULL, 'select (case\r\nwhen "#0056#" like "%dewi%"\r\nor "#0056#" like "%wahyuni%"\r\n\r\nthen "Saudari"\r\nelse "Saudara" end)data', NULL, NULL, 0, NULL, '2019-05-27 03:35:03'),
	(6054, 'Nafkah iddah', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6055, 'Mut\'ah', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6056, 'Nafkah iddah (terbilang)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6057, 'Mut\'ah (terbilang)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6058, 'Pe & Ter pisah selama', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6059, 'Melanggar taklik talak point', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6064, 'Fakta di persidangan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6065, 'Fakta Hukum', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6087, 'Alasan Wali Nikah Menolak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6088, 'Alasan KUA menikahkan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6092, 'alamat sekarang', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6094, 'lamanya tidak memberi nafkah', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6095, 'Penerimaan Negara Bukan Pajak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6096, 'Tanggal setor PNBP', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6097, 'Terbilang PNBP', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6098, 'Tanggal Panjar PNBP', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6099, 'Calon Isteri', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6117, 'Tanya kpd. Anak Pemohon - DK (F9)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6118, 'Tanya P kpd. Saksi1 P (F8)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6119, 'Tanya P kpd. Saksi2 P (F8)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6123, 'Tanya kpd. Anak Pemohon 2 - DK (F9)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6125, 'Tanya kpd. Anak P (Perempuan) (F7)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6126, 'TanyaJwb Saksi1 P (F8)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6127, 'TanyaJwb Saksi2 P (F8)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6128, 'Tanya P kpd. Saksi1 (F9)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6129, 'Tanya P kpd. Saksi2 (F9)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6130, 'Tanya kpd. Ayah Anak (F6)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6131, 'Tanya kpd. Ibu Anak (F7)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6200, 'Tanya P kpd. Saksi1 T (F8)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6201, 'Tanya P kpd. Saksi2 T (F8)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6202, 'Tanya T kpd. Saksi1 P (F9)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6203, 'Tanya T kpd. Saksi2 P (F9)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6204, 'Tanya T kpd. Saksi1 T (F9)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6205, 'Tanya T kpd. Saksi2 T (F9)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(6220, 'Data Yang Diubah', 'data_teks', NULL, NULL, NULL, NULL, NULL, '-... tertulis... sebenarnya adalah ..\r\n-...', NULL, 0, NULL, '2019-05-16 04:42:39'),
	(8006, 'Jabatan Ketua/Wakil Ketua', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(8007, 'Jabatan Pansek/Wapan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(8014, 'Jumlah PSP', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(8015, 'Terbilang Jumlah PSP', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(8018, 'Tgl. Penunjukan PP/JSP', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(8019, 'Juru Sita/Juru Sita Pengganti', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(8020, 'Tanggal PMH IT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(8087, 'Yang Menikahkan', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'Imam Dusun _\r\nImam Masjid _', NULL, 0, NULL, '2018-01-05 10:02:46'),
	(8131, 'Alat Bukti Perwalian Anak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(8132, 'Alat Bukti PAW', 'data_teks', NULL, NULL, NULL, NULL, NULL, '1.Fotokopi Silsilah Keluarga yang dibuat oleh ... diketahui Lurah / Kepala Desa ... dan Camat ..., bermeterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya yang ternyata sesuai, lalu oleh Ketua Majelis diberi kode P1;\r\n2.Fotokopi Kartu Keluarga, Nomor ..., tanggal ..., yang dikeluarkan oleh Kepala Dinas Kependudukan dan Catatan Sipil Kabupaten ..., bermeterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya yang ternyata sesuai, lalu oleh Ketua Majelis diberi kode P2;\r\n3.Fotokopi Kutipan Akta Nikah dari Kantor Urusan Agama Kecamatan ..., Nomor.... Tanggal ..., bukti surat tersebut telah diberi meterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya yang ternyata sesuai, lalu oleh Ketua Majelis diberi kode P3;\r\n4.Fotokopi Kutipan Akta Kelahiran atas nama ... berdasarkan Akta Kelahiran Nomor ..., Tanggal ..., yang dikeluarkan Kepala Pejabat Pembuat Akte Catatan Sipil Kabupaten ..., bermeterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya yang ternyata sesuai, lalu oleh Ketua Majelis diberi kode P4;\r\n5.Fotokopi Surat Kematian an. #1025#, Nomor ..., tanggal ..., yang dikeluarkan oleh ..., bermeterai cukup, telah dicap pos dan telah dicocokkan dengan aslinya yang ternyata sesuai, lalu oleh Ketua Majelis diberi kode P5;', NULL, 0, NULL, '2019-05-16 04:43:26'),
	(8134, 'Alat Bukti Pengangkatan Anak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(8135, 'Bukti Surat Perubahan Data', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-03-27 02:32:07'),
	(8136, 'Bukti - bukti ...', 'data_sql', NULL, NULL, NULL, NULL, 'select (case\r\n\r\nwhen "#0315#" like "%P.2%" then\r\n"Bukti-bukti"\r\n\r\nelse "Bukti"\r\n\r\nend) as data', NULL, NULL, 0, NULL, '2019-01-23 07:01:26'),
	(8171, 'Alasan Permohonan untuk', 'data_teks', NULL, NULL, NULL, NULL, NULL, 'mengurus akta kelahiran anak #4046# serta keperluan lainnya\r\nkeperluan pengurusan administrasi K2 #0046# I dan keperluan lainnya\r\nmendapatkan tunjangan pensiunan Veteran RI serta keperluan lainnya\r\nmendapatkan tunjangan pensiunan janda Veteran RI serta keperluan lainnya\r\npengurusan hak-hak #2026# #1025# pada tabungan Bank ... serta keperluan lainnya\r\npenerbitan akta nikah #4046# serta keperluan lainnya', NULL, 0, NULL, '2018-01-31 03:17:15'),
	(8184, 'Hijriyah Tgl. Sidang', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(8426, 'Nama Pelawan (DV)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(8427, 'Umur Pelawan (DV)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(8428, 'Agama Pelawan (DV)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(8429, 'Pekerjaan Pelawan (DV)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(8430, 'Pendidikan Pelawan (DV)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(8431, 'Tempat Tinggal Pelawan (DV)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(8432, 'Hasil Perdamaian Mediasi <<0046 dan <<0047', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2017-12-01 04:00:00'),
	(8433, 'Alasan Cabut Perkara', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2019-05-20 12:35:03'),
	(8437, 'Kesimpulan oleh #0047#', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-03-09 08:50:26'),
	(9023, 'Nama Yg Menikahkan', 'data_teks', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '2018-01-01 04:00:00');;
	

CREATE TABLE IF NOT EXISTS `abt_tanyajawab_id` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `jenis_perkara_id` int(10) DEFAULT NULL,
  `kode` char(5) DEFAULT NULL,
  `nama` varchar(100) DEFAULT NULL,
  `modifier` varchar(30) DEFAULT NULL,
  `modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `kode_jenis_perkara_id` (`kode`,`jenis_perkara_id`)
);;

INSERT IGNORE INTO `abt_tanyajawab_id` (`id`, `jenis_perkara_id`, `kode`, `nama`, `modifier`, `modified`) VALUES
	(1, 360, 'IN2', 'Pertanyaan Saksi IN 2P', NULL, '2018-03-25 17:14:37'),
	(2, 362, 'DK2', 'Pertanyaan Saksi DK 2P', NULL, '2018-03-25 16:01:04'),
	(3, 347, 'A1', 'Pertanyaan Saksi P CG', NULL, '2018-03-25 15:26:02'),
	(4, 346, 'A1', 'Pertanyaan Saksi P CT', NULL, '2018-03-25 15:26:08'),
	(5, 347, 'A2', 'Pertanyaan Saksi T CG', NULL, '2018-08-01 13:37:45'),
	(6, 346, 'A2', 'Pertanyaan Saksi T CT', NULL, '2018-03-25 15:25:38'),
	(7, 369, 'PB1', 'Pertanyaan Saksi Perubahan Biodata 1P', NULL, '2018-03-27 10:41:47'),
	(8, 363, 'WA', 'Pertanyaan Saksi WA', NULL, '2018-03-25 17:14:52'),
	(9, 352, 'PA', 'Pertanyaan Saksi Pengangkatan Anak', NULL, '2018-03-25 15:50:41'),
	(10, 362, 'DK1', 'Pertanyaan Saksi DK 1P', NULL, '2018-03-25 16:05:10'),
	(11, 360, 'IN1', 'Pertanyaan Saksi IN 1P', NULL, '2018-03-25 17:14:31'),
	(12, 371, 'PAW', 'Pertanyaan Saksi PAW', NULL, '2018-03-25 16:19:29'),
	(13, 346, '01', 'Jawaban Lisan T', NULL, '2018-03-26 14:49:39'),
	(14, 347, '01', 'Jawaban Lisan T', NULL, '2018-03-26 14:49:49'),
	(15, 346, '02', 'Replik Lisan P', NULL, '2018-03-26 14:50:56'),
	(16, 347, '02', 'Replik Lisan P', NULL, '2018-03-26 14:51:02'),
	(17, 346, '03', 'Duplik Lisan T', NULL, '2018-03-26 14:51:10'),
	(18, 347, '03', 'Duplik Lisan T', NULL, '2018-03-26 14:51:16'),
	(19, 369, 'PB2', 'Pertanyaan Saksi Perubahan Biodata 2P', NULL, '2018-03-27 10:41:54'),
	(20, 341, 'IP', 'Pertanyaan Saksi Izin Poligami', NULL, '2018-04-05 15:30:26'),
	(21, 347, 'A3', 'Pertanyaan Saksi P CG+IN', NULL, '2018-08-02 10:02:23'),
	(22, 346, 'A3', 'Pertanyaan Saksi P CT+IN', NULL, '2018-08-02 10:59:59'),
	(23, 360, 'IN3', 'Tanya Jawab Saksi IN 2P - Sidkel', NULL, '2019-07-27 14:27:59');;


CREATE TABLE IF NOT EXISTS `abt_tanyajawab_template` (
  `kode_tanyajawab` char(5) NOT NULL,
  `urutan_pertanyaan` int(5) DEFAULT NULL,
  `pertanyaan` text,
  `jawaban` text,
  `modifier` varchar(30) DEFAULT NULL,
  `modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  UNIQUE KEY `id_tanyajawab_urutan_pertanyaan` (`kode_tanyajawab`,`urutan_pertanyaan`)
);;

INSERT IGNORE INTO `abt_tanyajawab_template` (`kode_tanyajawab`, `urutan_pertanyaan`, `pertanyaan`, `jawaban`, `modifier`, `modified`) VALUES
	('IN', 1, 'Apakah Saudara mengenal #0046# I dan #0046# II?', 'Ya, saya mengenal #0046# I dan #0046# II;', NULL, '2018-03-25 12:47:04'),
	('IN', 2, 'Ada hubungan keluarga apa Saudara dengan #0046# I dan #0046# II?', 'Saya adalah ........... #0046# ...; <br>Saya tidak punya hubungan keluarga dengan #0046# I dan Pemohon II, saya hanya bertetangga;', NULL, '2018-03-25 12:47:04'),
	('03', 1, 'Kepada #0047#:', '', NULL, '2018-03-26 14:56:13'),
	('03', 2, 'Apakah Saudara mengerti maksud replik #0046#?', 'Ya, saya sudah mengerti;', NULL, '2018-03-26 14:56:13'),
	('03', 3, 'Apakah Saudara sudah siap mengajukan duplik pada hari ini?', 'Ya, siap;', NULL, '2018-03-26 14:56:13'),
	('03', 4, 'Apakah Saudara akan menyampaikan duplik secara lisan atau tertulis?', 'Saya akan mengajukan duplik secara lisan;', NULL, '2018-03-26 14:56:13'),
	('03', 5, 'Apakah ....? (pertanyaan mengacu pada dalil #0053#', '...', NULL, '2018-03-26 14:56:13'),
	('03', 6, 'Apakah ....? dst', '...', NULL, '2018-03-26 14:56:13'),
	('PA', 1, 'Kepada Saksi;', '', NULL, '2018-03-26 17:22:24'),
	('PA', 2, 'Apakah Saudara kenal dengan Pemohon ?', 'Ya, saya mengenal Pemohon sejak lama.', NULL, '2018-03-26 17:22:24'),
	('PA', 3, 'Apakah Saudara  mengetahui maksud Pemohon datang ke Pengadilan ini ?', 'Ya, Pemohon bermaksud meminta penetapan perwalian anak.', NULL, '2018-03-26 17:22:24'),
	('PA', 4, 'Berapa orang anak yang mau dimintakan penetapan perwalian oleh Pemohon ?', 'Yang mau dimintakan penetapan perwalian oleh Pemohon adalah 1 orang anak.', NULL, '2018-03-26 17:22:24'),
	('PA', 5, 'Apakah Saudara mengetahui nama dan umur anak tersebut ?', 'Ya, namanya #0007#.', NULL, '2018-03-26 17:22:24'),
	('PA', 6, 'Siapakah orang tua kandung anak tersebut ?', 'Anak tersebut adalah anak #0046# dengan #1029#.', NULL, '2018-03-26 17:22:24'),
	('PA', 7, 'Apakah suami/istri Pemohon tersebut telah meninggal dunia ?', 'Ya, suami/istri Pemohon tersebut telah meninggal dunia pada tanggal #1230#.', NULL, '2018-03-26 17:22:24'),
	('PA', 8, 'Dimana suami/istri Pemohon tersebut meninggal dunia dan apa sebab ia meninggal ?', 'di #1509# karena #1245#.', NULL, '2018-03-26 17:22:24'),
	('PA', 9, 'Dalam pengasuhan siapa anak tersebut setelah suami/istri Pemohon meninggal dunia ?', 'Setelah suami/istri #0046# meninggal dunia, anak tersebut berada di bawah pengasuhan #0046#.', NULL, '2018-03-26 17:22:24'),
	('PA', 10, 'Apakah selama dalam pengasuhan Pemohon anak tersebut terurus dengan baik ?', 'Ya, selama dalam pengasuhan Pemohon anak tersebut tetap terurus dengan baik.', NULL, '2018-03-26 17:22:24'),
	('PA', 11, 'Apakah Saudara pernah mendengar adanya tindak kekerasan atas anak tersebut selama dalam pengasuhan &lt;&lt;0046 ?', 'Tidak, saya tidak pernah mendengar adanya tindak kekerasan atas anak tersebut selama dalam pengasuhan #0046#.', NULL, '2018-03-26 17:22:24'),
	('PA', 12, 'Apakah Saudara mengetahui untuk keperluan apa Pemohon mengajukan permohonan perwalian ?', 'Ya,  tujuan #0046# mengajukan permohonan perwalian adalah untuk #8171#.', NULL, '2018-03-26 17:22:24'),
	('PA', 13, 'Apakah masih ada yang ingin Saudara sampaikan ?', 'Sudah cukup.', NULL, '2018-03-26 17:22:24'),
	('PAW', 1, 'Kepada Saksi;', '', NULL, '2018-04-05 19:22:17'),
	('PAW', 2, 'Apakah Saudara mengenal #4046#?', 'Ya, saya mengenal #4046# sejak lama;', NULL, '2018-04-05 19:22:17'),
	('PAW', 3, 'Ada hubungan keluarga apa Saudara dengan para Pemohon?', 'Saya adalah ….. Pemohon ...;', NULL, '2018-04-05 19:22:17'),
	('PAW', 4, 'Apakah Saudara  mengetahui maksud para Pemohon datang ke Pengadilan ini?', 'Ya, para Pemohon bermaksud meminta penetapan ahli waris;', NULL, '2018-04-05 19:22:17'),
	('PAW', 5, 'Adakah seseorang yang meninggal dunia?', 'Ya, telah meninggal dunia #1025# pada tanggal #1246#;', NULL, '2018-04-05 19:22:17'),
	('PAW', 6, 'Dimana #1025# meninggal dunia dan apa sebab ia meninggal?', '#1025# meninggal dunia di #1509# karena #1247#;', NULL, '2018-04-05 19:22:17'),
	('PAW', 7, 'Apakah ada unsur penganiayaan sehingga #2026# meninggal dunia?', 'Tidak, #1025# meninggal dunia murni karena #1247# dan tidak ada unsur penganiayan;', NULL, '2018-04-05 19:22:17'),
	('PAW', 8, 'Apakah ayah kandung dan ibu kandung #2026# masih hidup?', 'Tidak, ayah kandung dan ibu kandung #2026# telah lebih dahulu meninggal dunia; <br>Ayah kandung #2026# ... sedangkan ibu kandung #2026# ...; <br>Ayah kandung dan ibu kandung #2026# keduanya masih hidup;', NULL, '2018-04-05 19:22:17'),
	('PAW', 9, 'Apakah kakek kandung dan nenek kandung #2026# masih hidup?', 'Tidak, kakek kandung dan nenek kandung #2026# telah lebih dahulu meninggal dunia;<br>Kakek kandung #2026# ... sedangkan nenek kandung #2026# ...; <br>Kakek kandung dan nenek kandung #2026# semua masih hidup;', NULL, '2018-04-05 19:22:17'),
	('PAW', 10, 'Jadi, siapa-siapa ahli waris yang ditinggalkan #2026#?', '#2026# meninggalkan seorang istri yaitu Pemohon I dan empat orang anak kandung yaitu Pemohon II sampai dengan Pemohon V; <br>#2026# hanya meninggalkan ....;', NULL, '2018-04-05 19:22:17'),
	('PAW', 11, 'Apa\n  tujuan #4046# mengajukan permohonan penetapan ahli\n  waris?\n  \n \n\n\n', '#4046# mengajukan penetapan ahli waris dimaksudkan untuk menentukan ahli waris yang sah dari #2026# #2026# serta keperluan lainnya', NULL, '2018-04-05 19:22:17'),
	('PAW', 12, 'Apakah masih ada yang ingin Saudara sampaikan?', 'Sudah cukup;', NULL, '2018-04-05 19:22:17'),
	('02', 1, 'Kepada #0046#:', '', NULL, '2018-04-12 16:25:42'),
	('02', 2, 'Apakah Saudara mengerti maksud jawaban #0047#?', 'Ya, saya sudah mengerti maksud jawaban #0047#;', NULL, '2018-04-12 16:25:42'),
	('02', 3, 'Apakah Saudara sudah siap menyampaikan replik pada hari ini?', 'Ya, saya siap menyampaikan replik pada hari ini;', NULL, '2018-04-12 16:25:42'),
	('02', 4, 'Apakah Saudara akan menyampaikan replik secara lisan atau tertulis?', 'Saya akan menyampaikan replik secara lisan;', NULL, '2018-04-12 16:25:42'),
	('02', 5, 'Apakah ............ (pertanyaan mengacu pada jawaban #0047#)', '...', NULL, '2018-04-12 16:25:42'),
	('02', 6, 'Apakah ...? dst', '...', NULL, '2018-04-12 16:25:42'),
	('01', 1, 'Kepada #0047#:', '', NULL, '2018-04-13 07:57:48'),
	('01', 2, 'Apakah Saudara sudah mengerti maksud #0053# #0046#?', 'Ya, saya sudah mengerti maksud #0053# #0046#;', NULL, '2018-04-13 07:57:48'),
	('01', 3, 'Apakah Saudara sudah siap mengajukan jawaban pada hari ini?', 'Ya, saya siap mengajukan jawaban pada hari ini;', NULL, '2018-04-13 07:57:48'),
	('01', 4, 'Apakah Saudara akan menyampaikan jawaban secara lisan atau tertulis?', 'Saya akan menjawab secara lisan;', NULL, '2018-04-13 07:57:48'),
	('01', 5, 'Apakah ....? (pertanyaan mengacu pada dalil #0053#', '...', NULL, '2018-04-13 07:57:48'),
	('01', 6, 'Apakah ....? dst', '...', NULL, '2018-04-13 07:57:48'),
	('01', 7, '...', 'Saya juga bermaksud mengajukan gugat balik yaitu:1.', NULL, '2018-04-13 07:57:48'),
	('IN1', 1, 'Apakah Saudara mengenal #0046#?', 'Saya mengenal #0046#;', NULL, '2018-05-28 13:13:39'),
	('IN1', 2, 'Ada hubungan keluarga apa Saudara dengan Pemohon?', 'Saya adalah ........... Pemohon; Saya tidak punya hubungan keluarga dengan Pemohon, saya hanya bertetangga;', NULL, '2018-05-28 13:13:39'),
	('IN1', 3, 'Apakah Saudara mengetahui maksud #0046# menghadap di persidangan ini?', '#0046# menghadap di persidangan ini untuk mengesahkan pernikahannya;', NULL, '2018-05-28 13:13:39'),
	('IN1', 4, 'Apakah Saudara mengetahui pernikahan #0046#?', 'Saya mengetahui #0046# telah menikah dengan seorang bernama #1025#?', NULL, '2018-05-28 13:13:39'),
	('IN1', 5, 'Apakah Saudara hadir sewaktu #0046# dengan #1025# menikah?', 'Saya hadir sewaktu #0046# dengan #1025# menikah; <br>Tidak, saya tidak hadir sewaktu #0046# dengan #10259# menikah, namun saya mendapat informasi dari orang-orang yang hadir;', NULL, '2018-05-28 13:13:39'),
	('IN1', 6, 'Kapan #0046# dengan #1025# menikah?', 'Kalau tidak salah #0046# dengan #1025# menikah pada #5197#;', NULL, '2018-05-28 13:13:39'),
	('IN1', 7, 'Dimana #0046# dengan #1025# menikah?', '#0046# dengan #1025# menikah di #5105#;', NULL, '2018-05-28 13:13:39'),
	('IN1', 8, 'Siapa yang menjadi wali nikah #0046#/#1025# pada pernikahan tersebut?', 'Yang menjadi wali nikah #0046#/#1025# pada pernikahan tersebut adalah #1046# #0046#/#1025# bernama #1217##1357#;', NULL, '2018-05-28 13:13:39'),
	('IN1', 9, 'Siapa yang menikahkan #0046# dengan #1025#?', 'Yang menikahkan #0046# dengan #1025# adalah #8087# yang bernama #9023#;', NULL, '2018-05-28 13:13:39'),
	('IN1', 10, 'Apa mahar yang diberikan #0046# kepada #1025#? Apa mahar yang diberikan #1025# kepada #0046#?', 'Mahar yang diberikan #1025# kepada #0046# pada waktu itu berupa #1001#; <br>Mahar yang diberikan #0046# kepada #1025# pada waktu itu berupa #1001#;', NULL, '2018-05-28 13:13:39'),
	('IN1', 11, 'Siapakah yang menjadi saksi nikah pada saat terjadinya ijab kabul antara #8087# dan #1025#/#0046#?', 'Yang menjadi saksi nikah pada saat terjadinya ijab kabul adalah #0650# dan #0651#;<br>Yang menjadi saksi nikah pada saat terjadinya ijab kabul adalah saya sendiri dengan #0650# / #0651#;', NULL, '2018-05-28 13:13:39'),
	('IN1', 12, 'Apa status #0046# dan #1025# saat menikah?', 'Pada saat menikah #1025# berstatus #1002# dan #0046# berstatus #1003#; Pada saat menikah #0046# berstatus #1002# dan #1025# berstatus #1003#;', NULL, '2018-05-28 13:13:39'),
	('IN1', 13, 'Apakah antara #0046# dan #1025# ada hubungan darah, semenda atau sesusuan yang menyebabkan terhalang untuk menikah?', '#0046# dan #1025# tidak ada hubungan darah, semenda atau sesusuan yang menyebabkan keduanya tidak boleh menikah;', NULL, '2018-05-28 13:13:39'),
	('IN1', 14, 'Pernahkah Saudara mendengar ada pihak lain yang keberatan atas pernikahan #0046# dengan #1025#?', 'Saya tidak pernah mendengar ada pihak lain yang keberatan atas pernikahan #0046# dengan #1025#;', NULL, '2018-05-28 13:13:39'),
	('IN1', 15, 'Apakah #0046# dengan #1025# pernah bercerai?', '#0046# dengan #1025# tidak pernah bercerai, keduanya hidup rukun hingga #1025# meninggal dunia pada tanggal #1230##1246# di #1509# karena #1245##1247#;', NULL, '2018-05-28 13:13:39'),
	('IN1', 16, 'Apakah dari pernikahan tersebut #0046# dengan #2026# #1025# telah dikaruniai anak?', 'Dari pernikahan tersebut #0046# dengan #2026# #1025# #9003#;', NULL, '2018-05-28 13:13:39'),
	('IN1', 17, 'Apa maksud #0046# mengajukan permohonan itsbat nikah?', 'Itsbat nikah para Pemohon dimaksudkan untuk #8171#;', NULL, '2018-05-28 13:13:39'),
	('IN1', 18, 'Apakah masih ada yang ingin Saudara sampaikan ?', 'Sudah cukup;', NULL, '2018-05-28 13:13:39'),
	('IN2', 1, 'Apakah Saudara mengenal #0046# I dan #0046# II ?', 'Ya, saya mengenal #4046#;', NULL, '2018-05-28 13:13:53'),
	('IN2', 2, 'Ada hubungan keluarga apa Saudara dengan Pemohon I dan Pemohon II?', 'Saya adalah ........... Pemohon ...; <br>\nSaya tidak punya hubungan keluarga dengan Pemohon I dan Pemohon II, saya hanya bertetangga;', NULL, '2018-05-28 13:13:53'),
	('IN2', 3, 'Apakah Saudara mengetahui maksud Pemohon I dan Pemohon II menghadap di persidangan ini?', 'Ya, #0046# I dan #0046# II menghadap di persidangan ini untuk mengesahkan pernikahannya;', NULL, '2018-05-28 13:13:53'),
	('IN2', 4, 'Apakah Saudara hadir sewaktu Pemohon I dengan Pemohon II menikah?', 'Ya, saya hadir sewaktu #0046# I dengan #0046# II menikah;<br>\nTidak, saya tidak hadir sewaktu #0046# I dengan #0046# II menikah, namun saya mendapat informasi dari orang-orang yang hadir;', NULL, '2018-05-28 13:13:53'),
	('IN2', 5, 'Dimana Pemohon I dengan Pemohon II menikah?', 'Pemohon I dengan Pemohon II menikah di #5105#, pada tanggal #5197#;', NULL, '2018-05-28 13:13:53'),
	('IN2', 6, 'Siapa yang bertindak sebagai wali nikah Pemohon II pada pernikahan tersebut?', 'Yang bertindak sebagai wali nikah  adalah #1046# #0046# II bernama #1217##1357#;', NULL, '2018-05-28 13:13:53'),
	('IN2', 7, 'Siapa yang menikahkan Pemohon I dengan Pemohon II?', 'Yang menikahkan #0046# I dengan #0046# II adalah #8087# bernama #9023#;<br>\nYang menikahkan #0046# I dengan #0046# II adalah saya sendiri sebagai wali nikah;', NULL, '2018-05-28 13:13:53'),
	('IN2', 8, 'Siapakah yang bertindak sebagai saksi nikah pada saat terjadinya ijab kabul antara #8087# dan Pemohon I?', 'Yang bertindak sebagai saksi nikah pada saat terjadinya ijab kabul adalah #0650# dan #0651#;<br>Yang bertindak sebagai saksi nikah pada saat terjadinya ijab kabul adalah saya sendiri dengan #0650# / #0651#;', NULL, '2018-05-28 13:13:53'),
	('IN2', 9, 'Apa mahar yang diberikan Pemohon I kepada Pemohon II?', 'Mahar yang diberikan #0046# I kepada #0046# II berupa #1001#;', NULL, '2018-05-28 13:13:53'),
	('IN2', 10, 'Apa status Pemohon I dan Pemohon II saat menikah?', 'Sebelum menikah #0046# I berstatus #1002# dan #0046# II berstatus #1003#;', NULL, '2018-05-28 13:13:53'),
	('IN2', 11, 'Apakah antara Pemohon I dan Pemohon II ada hubungan darah, semenda atau sesusuan yang menyebabkan terhalang untuk menikah?', '#0046# I dan #0046# II tidak ada hubungan darah, semenda atau sesusuan yang menyebabkan terhalang untuk menikah;', NULL, '2018-05-28 13:13:53'),
	('IN2', 12, 'Pernahkah Saudara mendengar ada pihak lain yang keberatan atas pernikahan Pemohon I dengan Pemohon II?', 'Saya tidak pernah mendengar ada pihak lain yang keberatan atas pernikahan Pemohon I dengan Pemohon II;', NULL, '2018-05-28 13:13:53'),
	('IN2', 13, 'Apakah Pemohon I dengan Pemohon II pernah bercerai?', 'Pemohon I dengan Pemohon II tidak pernah bercerai, keduanya hidup rukun sampai saat ini;', NULL, '2018-05-28 13:13:53'),
	('IN2', 14, 'Apakah dari pernikahan tersebut Pemohon I dengan Pemohon II telah dikaruniai anak?', 'Dari pernikahan tersebut #0046# I dengan #0046# II #0007#;', NULL, '2018-05-28 13:13:53'),
	('IN2', 15, 'Apa tujuan Pemohon I dan Pemohon II mengajukan permohonan itsbat nikah?', 'Itsbat nikah para pemohon dimaksudkan untuk  untuk #8171#;', NULL, '2018-05-28 13:13:53'),
	('IN2', 16, 'Apakah masih ada yang ingin Saudara sampaikan?', 'Sudah cukup;', NULL, '2018-05-28 13:13:53'),
	('DK2', 1, 'Apakah Saudara kenal dengan para Pemohon?', 'Ya, saya mengenal para Pemohon;', NULL, '2018-05-28 13:14:35'),
	('DK2', 2, 'Ada hubungan keluarga apa Saudara dengan para Pemohon?', 'Saya adalah ….. Pemohon I sedangkan Pemohon II ……; <br>Saya tidak ada hubungan keluarga dengan para Pemohon hanya bertetangga;', NULL, '2018-05-28 13:14:35'),
	('DK2', 3, 'Apakah Saudara mengetahui maksud para Pemohon datang ke Pengadilan ini?', 'Ya, para Pemohon datang ke Pengadilan ini untuk meminta dispensasi kawin;', NULL, '2018-05-28 13:14:35'),
	('DK2', 4, 'Kenapa para Pemohon mau meminta dispensasi kawin?', 'Karena para Pemohon mau menikahkan anak Pemohon I dengan anak Pemohon II namun ditolak oleh KUA Kecamatan #1005# karena keduanya belum cukup umur;', NULL, '2018-05-28 13:14:35'),
	('DK2', 5, 'Apakah Saudara mengenal anak Pemohon I?', 'Ya, saya mengenal anak Pemohon I bernama #0600#;', NULL, '2018-05-28 13:14:35'),
	('DK2', 6, 'Berapa umur anak Pemohon I sekarang?', 'Anak Pemohon sekarang berumur #0601# tahun;', NULL, '2018-05-28 13:14:35'),
	('DK2', 7, 'Apakah Saudara mengenal anak Pemohon II?', 'Ya, saya mengenal anak Pemohon II bernama #0606#;', NULL, '2018-05-28 13:14:35'),
	('DK2', 8, 'Berapa umur anak Pemohon II sekarang?', 'Anak Pemohon II sekarang berumur #0607# tahun;', NULL, '2018-05-28 13:14:35'),
	('DK2', 9, 'Apakah anak Pemohon I dengan anak Pemohon II sudah saling mengenal?', 'Ya, anak Pemohon I dengan anak Pemohon II sudah saling mengenal;', NULL, '2018-05-28 13:14:35'),
	('DK2', 10, 'Apakah anak Pemohon I dengan anak Pemohon II sudah mempunyai kedekatan satu sama lain?', 'Ya, anak Pemohon I dengan anak Pemohon II #1014#;', NULL, '2018-05-28 13:14:35'),
	('DK2', 11, 'Apakah antara anak Pemohon I dan anak Pemohon II tidak ada hubungan darah, semenda atau susuan yang menyebabkan tidak boleh menikah?', 'Setahu saya, antara anak Pemohon I dan anak Pemohon II tidak ada hubungan darah, semenda atau susuan yang menyebabkan tidak boleh menikah;', NULL, '2018-05-28 13:14:35'),
	('DK2', 12, 'Apa status anak Pemohon I dan apa status anak Pemohon II?', 'Anak Pemohon I berstatus bujang dan anak Pemohon II berstatus gadis;', NULL, '2018-05-28 13:14:35'),
	('DK2', 13, 'Apakah keluarga kedua belah pihak telah merestui rencana pernikahan tersebut?', 'Ya, keluarga kedua belah pihak telah sepakat mau menikahkan keduanya;', NULL, '2018-05-28 13:14:35'),
	('DK2', 14, 'Apakah tidak ada pihak lain yang keberatan atas rencana pernikahan tersebut?', 'Ya,  tidak ada saya dengar pihak lain yang keberatan atas rencana pernikahan tersebut;', NULL, '2018-05-28 13:14:35'),
	('DK2', 15, 'Apakah dalam kehidupan sehari-hari anak Pemohon I masih kelihatan bertingkah laku seperti anak-anak?', 'Tidak, anak Pemohon I sudah kelihatan bertingkah laku seperti orang dewasa;', NULL, '2018-05-28 13:14:35'),
	('DK2', 16, 'Apakah anak Pemohon I sudah memiliki mata pencaharian?', 'Ya, anak Pemohon sudah memiliki mata pencaharian sebagai #0604#;', NULL, '2018-05-28 13:14:35'),
	('DK2', 17, 'Apakah dalam kehidupan sehari-hari anak Pemohon II masih kelihatan bertingkah laku seperti anak-anak?', 'Tidak, anak Pemohon II sudah kelihatan bertingkah laku seperti orang dewasa;', NULL, '2018-05-28 13:14:35'),
	('DK2', 18, 'Apakah anak Pemohon II sudah biasa mengerjakan pekerjaan ibu rumah tangga?', 'Ya, anak Pemohon II sudah biasa mengerjakan pekerjaan ibu rumah tangga;', NULL, '2018-05-28 13:14:35'),
	('DK2', 19, 'Apakah masih ada yang ingin Saudara sampaikan ?', 'Sudah cukup.', NULL, '2018-05-28 13:14:35'),
	('WA', 1, 'Apakah Saudara kenal dengan Pemohon ?', 'Ya, saya mengenal Pemohon sejak kecil;', NULL, '2018-05-28 13:15:01'),
	('WA', 2, 'Apakah Saudara  mengetahui maksud Pemohon   mengajukan   permohonan Wali Adhal ?', 'Ya, Pemohon ingin melangsungkan pernikahan, namun walinya tidak mau memberikan perwalian;', NULL, '2018-05-28 13:15:01'),
	('WA', 3, 'Apakah Saudara kenal dengan calon suami Pemohon ?', 'Ya, saya kenal calon suami Pemohon bernama #1029#;', NULL, '2018-05-28 13:15:01'),
	('WA', 4, 'Berapa umur calon suami Pemohon ?', 'Calon suami Pemohon kira-kira berumu #1030# tahun;', NULL, '2018-05-28 13:15:01'),
	('WA', 5, 'Apa hubungan Pemohon dengan wali Pemohon ?', 'Hubungan Pemohon dengan walinya adalah #1046#;', NULL, '2018-05-28 13:15:01'),
	('WA', 6, 'Apakah ayah kandung Pemohon sudah meninggal dunia ?', 'Ya, Ayah kandung Pemohon sudah meninggal dunia;', NULL, '2018-05-28 13:15:01'),
	('WA', 7, 'Apakah wali Pemohon tersebut sudah pernah dinasehati dan dimintai agar bersedia menjadi wali nikah Pemohon ?', 'Ya, wali Pemohon tersebut sudah pernah dinasehati dan dimintai agar bersedia menjadi wali nikah Pemohon oleh ...... namun tetap menolak menjadi wali nikah Pemohon;', NULL, '2018-05-28 13:15:01'),
	('WA', 8, 'Apa sebabnya wali Pemohon tidak mau menjadi wali nikah dari Pemohon ?', 'Wali Pemohon enggang menjadi wali nikah dari Pemohon #6087#;', NULL, '2018-05-28 13:15:01'),
	('WA', 9, 'Apakah antara Pemohon dengan calon suaminya  ada hubungan keluarga atau sesusuan yang dapat menyebabkan terhalang untuk menikah ?', 'Tidak, setahu saya, antara Pemohon dan #1029# tidak ada hubungan keluarga atau sesusuan yang menyebabkan terhalang untuk menikah;', NULL, '2018-05-28 13:15:01'),
	('WA', 10, 'Apa status Pemohon dan calon suaminya saat ini ?', 'Pemohon berstatus #1003# sedangkan #1029# berstatus #1002#;', NULL, '2018-05-28 13:15:01'),
	('WA', 11, 'Bagaimana  hubungan  Pemohon dengan calon suami Pemohon ?', 'Pemohon dengan calon suaminya sudah saling mengenal dan #1014#;', NULL, '2018-05-28 13:15:01'),
	('WA', 12, 'Apakah masih ada yang ingin Saudara sampaikan ?', 'Sudah cukup;', NULL, '2018-05-28 13:15:01'),
	('A2', 1, 'Apakah saudara kenal #0046# dan #0047# ?', 'Ya, saya kenal #0046# bernama #0098# sedangkan #0047# bernama #0102#;', NULL, '2018-12-18 15:38:12'),
	('A2', 2, 'Apakah saudara mempunyai hubungan keluarga dengan #0046# dan #0047# ?', 'Ya, #0046# adalah ................. dan #0047# adalah .............; <br>Saya tidak ada hubungan keluarga dengan #0046# dan #0047# hanya bertetangga di kampung;', NULL, '2018-12-18 15:38:12'),
	('A2', 3, 'Bagaimana keadaan rumah tangga #0046# dan #0047# setelah menikah ?', 'Setelah menikah rumah tangga #0046# dengan #0047# rukun-rukun dan bahagia bahkan telah dikaruniai ..... orang anak;', NULL, '2018-12-18 15:38:12'),
	('A2', 4, 'Apakah #0046# dan #0047# masih rukun dan bahagia sekarang ?', 'Ya, #0046# dan #0047# tetap rukun dan bahagia ;', NULL, '2018-12-18 15:38:12'),
	('A2', 5, 'Apakah saudara tahu jika #0046# dan #0047# biasa bertengkar ?', 'Ya, saya tahu kalau #0046# dan #0047# biasa bertengkar; <br>Tidak tahu dan saya juga tidak pernah melihat bertengkar;', NULL, '2018-12-18 15:38:12'),
	('A2', 6, 'Apakah #0046# dan #0047# sudah berpisah tempat tinggal ?', 'Ya, #0046# dan #0047# sudah berpisah tempat tinggal; <br>Tidak benar karena masih sering datang bermalam;', NULL, '2018-12-18 15:38:12'),
	('A2', 7, 'Apakah #0047# pernah memukul #0046# atau minum-minuman keras dan suka marah-marah biasa bertengkar ?', 'Ya terkadang memukul #0046# atau minum-minuman keras dan suka marah-marah biasa bertengkar; <br>Tidak pernah;', NULL, '2018-12-18 15:38:12'),
	('A2', 8, 'Apakah #0046# dan #0047# pernah diupayakan untuk rukun kembali ?', 'Ya, #0046# dan #0047# pernah diupayakan untuk rukun kembali, namun tidak berhasil;', NULL, '2018-12-18 15:38:12'),
	('A2', 9, 'Apakah masih ada keterangan yang saudara ingin sampaikan ?', 'Sudah cukup;', NULL, '2018-12-18 15:38:12'),
	('A3', 1, 'Apakah Saudara kenal dengan #0046#?', 'Ya, Saya kenal;', NULL, '2018-12-18 15:38:39'),
	('A3', 2, 'Apakah Saudara punya hubungan keluarga dengan #0046#?', 'Ya, #0046# adalah ..... saya;', NULL, '2018-12-18 15:38:39'),
	('A3', 3, 'Apakah #0046# punya suami?', 'Ya, #0046# sudah mempunyai suami;', NULL, '2018-12-18 15:38:39'),
	('A3', 4, 'Apakah Saudara kenal dengan suami #0046#?', 'Ya, saya kenal, suami #0046# bernama #0047#;', NULL, '2018-12-18 15:38:39'),
	('A3', 5, 'Apakah Saudara punya hubungan keluarga dengan #0047#?', 'Tidak, saya tidak punya hubungan keluarga dengan #0047# kecuali sebagai menantu', NULL, '2018-12-18 15:38:39'),
	('A3', 6, 'Kapan dan dimana #0046# dengan #0047# dahulu melangsungkan pernikahan ?', '#0046# dengan #0047# menikah pada tanggal #5197#, di rumah saya di #5105#.', NULL, '2018-12-18 15:38:39'),
	('A3', 7, 'Siapa yang menikahkan #0046# dengan #0047#?', '#0046# dengan #0047# dinikahkan oleh #8087#, bernama #9023#;', NULL, '2018-12-18 15:38:39'),
	('A3', 8, 'Siapa yang menjadi wali pernikahan #0046# dan #0047#?', 'Yang bertindak sebagai wali nikah adalah #0046# II bernama #1217#;<br>Saya sendiri sebagai ayah kandung dari #0046#;', NULL, '2018-12-18 15:38:39'),
	('A3', 9, 'Siapa yang menjadi saudara pernikahan #0046# dengan #0047#?', 'Yang menjadi saya pernikahan #0046# dengan #0047# adalah #0650# dan #0651#;', NULL, '2018-12-18 15:38:39'),
	('A3', 10, 'Apa mahar pernikahan yang diberikan #0047# kepada #0046#?', 'Mahar pernikahan yang diberikan #0047# kepada #0046# adalah #1001#;', NULL, '2018-12-18 15:38:39'),
	('A3', 11, 'Apa status #0046# dengan #0047# sebelum mereka menikah?', '#0046# berstatus #1002# dan saat itu yang saya tahu #0047# berstatus #1003#;', NULL, '2018-12-18 15:38:39'),
	('A3', 12, 'Setelah menikah dimana #0046# dengan #0047# berdomisili?', 'Setelah menikah #0046# dengan #0047# #5126#.', NULL, '2018-12-18 15:38:39'),
	('A3', 13, 'Bagaimana keadaan rumah tangga #0046# dengan #0047# setelah mereka menikah?', 'Pada dasarnya #0046# dengan #0047# tidak pernah rukun dalam membina rumah tangga meski keduanya sempat tinggal bersama;', NULL, '2018-12-18 15:38:39'),
	('A3', 14, 'Apakah Saudara tahu apa yang menjadi penyebab ketidak rukunan rumah tangga #0046# dengan #0047#?', 'Yang saya tahu penyebab ketidak rukunan antara Penggugat dengan Tergugat adalah karena ...;', NULL, '2018-12-18 15:38:39'),
	('A3', 15, 'Sudah berapa lama #0047# pergi meninggalkan #0046#?', 'Sudah ...;', NULL, '2018-12-18 15:38:39'),
	('A3', 16, 'Selama #0047# pergi meninggalkan #0046# apakah #0047# pernah datang untuk menemui #0046# dan anaknya ?', '.....', NULL, '2018-12-18 15:38:39'),
	('A3', 17, 'Apakah #0047# pernah mengirim nafkah untuk #0046# dan anak #0047#?', 'Setahu saya tidak pernah;', NULL, '2018-12-18 15:38:39'),
	('A3', 18, 'Selama #0046# dengan #0047# berpisah tempat tinggal apakah ada upaya Saudara atau keluarga yang lain untuk merukunkan #0046# dengan #00467#?', 'Tidak pernah;', NULL, '2018-12-18 15:38:39'),
	('A3', 19, 'Menurut Saudara apakah antara #0046# dengan #0047# masih ada kemungkinan untuk dirukunkan kembali?', 'Saya rasa sudah sulit karena Penggugat dengan Tergugat sudah tidak saling memperdulikan selama lebih dari enam tahun;', NULL, '2018-12-18 15:38:39'),
	('A3', 20, 'Apakah masih ada hal yang akan Saudara sampaikan?', 'Sudah cukup;', NULL, '2018-12-18 15:38:39'),
	('DK1', 1, 'Apakah Saudara kenal dengan Pemohon?', 'Saya kenal dengan Pemohon karena saya adalah ...;', NULL, '2018-12-18 15:38:56'),
	('DK1', 2, 'Ada hubungan keluarga apa Saudara dengan Pemohon?', 'Saya adalah ….. Pemohon; <br>Saya tidak ada hubungan keluarga dengan Pemohon hanya bertetangga;', NULL, '2018-12-18 15:38:56'),
	('DK1', 3, 'Apakah Saudara mengetahui maksud Pemohon datang ke Pengadilan ini?', 'Ya, Pemohon datang ke Pengadilan ini untuk meminta dispensasi kawin;', NULL, '2018-12-18 15:38:56'),
	('DK1', 4, 'Kenapa Pemohon mau meminta dispensasi kawin?', 'Pemohon meminta dispensasi kawin karena Pemohon mau menikahkan anaknya namun ditolak oleh KUA Kecamatan #1005# karena belum cukup umur;', NULL, '2018-12-18 15:38:56'),
	('DK1', 5, 'Apakah Saudara mengenal anak Pemohon?', 'Ya, saya mengenal anak Pemohon bernama #0600#;', NULL, '2018-12-18 15:38:56'),
	('DK1', 6, 'Berapa umur anak Pemohon sekarang?', 'Anak Pemohon tersebut sekarang berumur #0601# tahun;', NULL, '2018-12-18 15:38:56'),
	('DK1', 7, 'Apakah Saudara mengenal calon isteri anak Pemohon?<br>Apakah Saudara mengenal calon suami anak Pemohon?', 'Ya, saya mengenal calon isteri anak Pemohon bernama #0606#; <br>Ya, saya mengenal calon anak Pemohon bernama #0600#;', NULL, '2018-12-18 15:38:56'),
	('DK1', 8, 'Berapa umur calon isteri anak Pemohon sekarang?<br>Berapa umur calon suami anak Pemohon sekarang?', 'Calon isteri anak Pemohon sudah berumur #0607# tahun; <br>Calon suami anak Pemohon sudah berumur #0601# tahun;', NULL, '2018-12-18 15:38:56'),
	('DK1', 9, 'Apakah anak Pemohon dengan calon isterinya sudah saling mengenal?<br>Apakah anak Pemohon dengan calon suaminya sudah saling mengenal?', 'Ya, anak Pemohon dengan calon isterinya sudah saling mengenal; <br>Ya, anak Pemohon dengan calon suaminya sudah saling mengenal;', NULL, '2018-12-18 15:38:56'),
	('DK1', 10, 'Apakah anak Pemohon dengan calon isterinya sudah mempunyai kedekatan satu sama lain? Apakah anak Pemohon dengan calon suaminya sudah mempunyai kedekatan satu sama lain?', 'Ya, anak Pemohon dengan calon isterinya #1014#; <br>Ya, anak Pemohon dengan calon suaminya #1014#;', NULL, '2018-12-18 15:38:56'),
	('DK1', 11, 'Apakah antara anak Pemohon dan calon isterinya / suaminya tidak ada hubungan darah, semenda atau susuan yang menyebabkan tidak boleh menikah?', 'Setahu saya, antara anak Pemohon dan calon isterinya / suaminya tidak ada hubungan darah, semenda atau susuan yang menyebabkan tidak boleh menikah;', NULL, '2018-12-18 15:38:56'),
	('DK1', 12, 'Apa status anak Pemohon dan apa status calon isterinya?<br>Apa status anak Pemohon dan apa status calon suaminya?', 'Anak Pemohon berstatus bujang dan calon isterinya berstatus #1003#; <br>Anak Pemohon berstatus gadis dan calon suaminya berstatus #1002#;', NULL, '2018-12-18 15:38:56'),
	('DK1', 13, 'Apakah keluarga kedua belah pihak telah merestui rencana pernikahan tersebut?', 'Ya, keluarga kedua belah pihak telah sepakat mau menikahkan keduanya;', NULL, '2018-12-18 15:38:56'),
	('DK1', 14, 'Apakah tidak ada pihak lain yang keberatan atas rencana pernikahan tersebut?', 'Ya,  tidak ada saya dengar pihak lain yang keberatan atas rencana pernikahan tersebut;', NULL, '2018-12-18 15:38:56'),
	('DK1', 15, 'Apakah dalam kehidupan sehari-hari anak Pemohon masih kelihatan bertingkah laku seperti anak-anak?', 'Tidak, anak Pemohon sudah kelihatan bertingkah laku seperti orang dewasa;', NULL, '2018-12-18 15:38:56'),
	('DK1', 16, 'Apakah anak Pemohon sudah memiliki mata pencaharian?<br>Apakah anak Pemohon sudah biasa mengerjakan pekerjaan ibu rumah tangga?', 'Ya, anak Pemohon sudah memiliki mata pencaharian sebagai #0604#;<br>Ya, anak Pemohon sudah biasa mengerjakan pekerjaan ibu rumah tangga;', NULL, '2018-12-18 15:38:56'),
	('DK1', 17, 'Apakah masih ada yang ingin Saudara sampaikan ?', 'Sudah cukup.', NULL, '2018-12-18 15:38:56'),
	('IP', 1, 'Apakah saudara kenal dengan #0046# dan #0047#?', 'Saya kenal dengan #0046# dan #0047# karena saya adalah ...............................................;', NULL, '2018-12-18 15:40:31'),
	('IP', 2, 'Apakah saudara mengetahui hubungan #0046# dan #0047#?', 'Saya tahu antara #0046# dan #0047# adalah suami isteri;', NULL, '2018-12-18 15:40:31'),
	('IP', 3, 'Apakah #0046# dan #0047# sudah dikarunia anak?', '#0046# dan #0047# sudah/belum dikaruniai ...... (........) orang anak;', NULL, '2018-12-18 15:40:31'),
	('IP', 4, 'Bagaimana keadaan rumah tangga #0046# dan #0047# selama ini?', 'Kehidupan rumah tangga #0046# dan #0047# selama ini berjalan baik dan rukun;', NULL, '2018-12-18 15:40:31'),
	('IP', 5, 'Apakah saudara mengetahui maksud #0046# datang ke pengadilan?', '#0046# ke Pengadilan mengurus izin poligami karena #0046# mau menikah lagi dengan perempuan lain yang bernama....................', NULL, '2018-12-18 15:40:31'),
	('IP', 6, 'Apakah saudara kenal dengan calon istri kedua #0046#?', 'Saya kenal dengan calon istri kedua #0046# .................................................................;', NULL, '2018-12-18 15:40:31'),
	('IP', 7, 'Apakah saudara mengetahui status calon istri kedua #0046#?', 'Saya mengetahui calon istri kedua #0046# adalah gadis/janda;', NULL, '2018-12-18 15:40:31'),
	('IP', 8, 'Apakah antara #0046#, calon istri kedua #0046# dan #0047# ada hubungan keluarga?', 'Antara #0046#, calon istri kedua #0046# dan #0047# tidak ada hubungan keluarga, bukan saudara dan bukan sesusuan;', NULL, '2018-12-18 15:40:31'),
	('IP', 9, 'Apakah saudara mengetahui pekerjaan #0046#?', '#0046# bekerja sebagai...................................................;', NULL, '2018-12-18 15:40:31'),
	('IP', 10, 'Apakah saudara mengetahui penghasilan #0046# dari pekerjaannya tersebut?', 'SAya mengetahui/tidak mengetahui penghasilan #0046# setiap bulannya sebesar Rp. ................................;', NULL, '2018-12-18 15:40:31'),
	('IP', 11, 'Apakah #0047# keberatan atas keinginan #0046# untuk menikah lagi?', 'Yang saya ketahui #0047# tidak keberatan atas keinginan #0046# untuk menikah lagi;', NULL, '2018-12-18 15:40:31'),
	('IP', 12, 'Apakah saudara mengetahui alasan #0046# mau berpoligami?', 'Saya mengetahui alasan #0046# berpoligami karena: <br>- #0047# tidak mampu lagi menjalankan kewajibannya sebagai seorang istri secara maksimal melayani kebutuhan #0046#; <br>- #0047# cacat badan dan sakit yang susah untuk disemmbuhkan; <br>- #0047# tidak dapat melahirkan keturunan', NULL, '2018-12-18 15:40:31'),
	('IP', 13, 'Apakah saudara mengetahui apa saja harta bersama #0046# dan #0047# sampai saat ini?', 'Yang saya ketahui #0046# dan #0047# mempunyai harta bersama berupa: ................................................... ..............................................................................', NULL, '2018-12-18 15:40:31'),
	('PB1', 1, 'Apakah Saudara mengenal #0046#?', 'Ya, saya mengenal #0046#;', NULL, '2018-12-18 15:41:01'),
	('PB1', 2, 'Apakah Saudara ada hubungan keluarga dengan Pemohon?', 'Ya, saya ada hubungan keluarga dengan Pemohon yaitu ...;', NULL, '2018-12-18 15:41:01'),
	('PB1', 3, 'Apakah Saudara mengetahui maksud #0046# menghadap di persidangan ini?', 'Ya, #0046# menghadap di persidangan ini untuk merubah data pada buku nikahnya;', NULL, '2018-12-18 15:41:01'),
	('PB1', 4, 'Apakah Saudara mengetahui pernikahan #0046# dengan #1025#?', 'Ya, saya mengetahui pernikahan #0046# dengan #1025#;', NULL, '2018-12-18 15:41:01'),
	('PB1', 5, 'Apakah Saudara mengetahui\nKantor Urusan Agama yang telah menerbitkan buku nikah bagi pernikahan Pemohon\ndengan #1025# tersebut?', '\n\nYa, Kantor Urusan Agama yang\ntelah menerbitkan buku nikah bagi pernikahan Pemohon dengan #1025#\nadalah #5178#;', NULL, '2018-12-18 15:41:01'),
	('PB1', 6, 'Apakah Saudara mengetahui data yang perlu dirubah\ndalam buku nikah Pemohon dan #1025# tersebut?', 'Setahu saya, data yang perlu dirubah dalam buku\nnikah tersebut adalah<br>#6220#', NULL, '2018-12-18 15:41:01'),
	('PB1', 7, 'Digunakan untuk apa perubahan\ndata pada buku nikah Pemohon?', 'Perubahan\ndata pada buku nikah Pemohon adalah untuk #8171#', NULL, '2018-12-18 15:41:01'),
	('PB1', 8, 'Apa tujuan #0046# mengajukan permohonan perubahan data tersebut?', '#4046# mengajukan permohonan perubahan data\ntersebut adalah untuk menjadi dasar memperbaiki data dalam Buku Kutipan Akta\nNikah tersebut dan selanjutnya perbaikan tersebut dapat dicatatkan pada #5180#;', NULL, '2018-12-18 15:41:01'),
	('PB1', 9, 'Apakah masih ada yang ingin Saudara sampaikan ?', 'Sudah cukup;', NULL, '2018-12-18 15:41:01'),
	('PB2', 1, 'Apakah Saudara mengenal #0046# I dan #0046# II?', 'Ya, saya mengenal #0046# I dan #0046# I;', NULL, '2018-12-18 15:41:15'),
	('PB2', 2, 'Apakah Saudara ada hubungan keluarga dengan #0046# I dan #0046# II?', 'Ya, saya ada hubungan keluarga dengan Pemohon I yaitu ..., sedangkan #0046# II yaitu;', NULL, '2018-12-18 15:41:15'),
	('PB2', 3, 'Apakah Saudara mengetahui maksud #0046# I dan #0046# II menghadap di persidangan ini?', 'Ya, #0046# I dan #0046# II menghadap di persidangan ini untuk merubah data pada buku nikahnya;', NULL, '2018-12-18 15:41:15'),
	('PB2', 4, 'Apakah Saudara mengetahui pernikahan #0046# I dengan #0046# II?', 'Ya, saya mengetahui pernikahan #0046# I dengan #0046# II;', NULL, '2018-12-18 15:41:15'),
	('PB2', 5, 'Apakah Saudara mengetahui Kantor Urusan Agama yang telah menerbitkan buku nikah bagi pernikahan #0046# I dengan #0046# II tersebut?', 'Ya, Kantor Urusan Agama yang telah menerbitkan buku nikah bagi pernikahan #0046# I dengan #0046# II tersebut adalah Kantor Urusan Agama Kecamatan #1005#;', NULL, '2018-12-18 15:41:15'),
	('PB2', 6, 'Apakah Saudara mengetahui data yang perlu dirubah dalam buku nikah #0046# I dan #0046# II tersebut?', 'Setahu saya, data yang perlu dirubah dalam buku nikah tersebut adalah #6220#;', NULL, '2018-12-18 15:41:15'),
	('PB2', 7, 'Digunakan untuk apa perubahan data pada buku nikah Pemohon?', 'Perubahan data pada buku nikah #4046# adalah untuk #8171#', NULL, '2018-12-18 15:41:15'),
	('PB2', 8, 'Apa tujuan #0046# I dan #0046# II mengajukan permohonan perubahan data tersebut?', '#4046# mengajukan permohonan perubahan data\ntersebut adalah untuk menjadi dasar memperbaiki data dalam Buku Kutipan Akta\nNikah tersebut dan selanjutnya perbaikan tersebut dapat dicatatkan pada #5180#;', NULL, '2018-12-18 15:41:15'),
	('PB2', 9, 'Apakah masih ada yang ingin Saudara sampaikan ?', 'Sudah cukup;', NULL, '2018-12-18 15:41:15'),
	('A1', 1, 'Apakah\nsaudara kenal dengan #0046# dan #0047#?', 'Saya kenal dengan #0046# dan #0047# karena saya adalah ...;', NULL, '2018-12-18 15:41:58'),
	('A1', 2, 'Apakah saudara tahu hubungan #0046# dan #0047#?', 'Saya tahu antara #0046# dan #0047# adalah suami isteri;', NULL, '2018-12-18 15:41:58'),
	('A1', 3, 'Dimana #0046# dan #0047# bertempat tinggal setelah menikah?', 'Setelah\nmenikah #0046# dan #0047# bertempat tinggal di ...;', NULL, '2018-12-18 15:41:58'),
	('A1', 4, 'Apakah\n#0046# dan #0047# sudah dikarunia anak?', '#0046# dan #0047# #0007#;', NULL, '2018-12-18 15:41:58'),
	('A1', 5, 'Bagaimana\nkeadaan rumah tangga #0046# dan #0047# setelah menikah?', 'Kehidupan\nrumah tangga #0046# dan #0047# pada awalnya berjalan baik dan rukun, namun sekarang ini\nrumah tangga mereka tidak harmonis lagi karena sering terjadi perselisihan dan\npertengkaran yang terus menerus;', NULL, '2018-12-18 15:41:58'),
	('A1', 6, 'Kapan mulai\nterjadi perselisihan dan pertengkaran antara #0046# dan #0047#?', 'Perselisihan\ndan pertengkaran #0046# dan #0047# terjadi sejak ................................', NULL, '2018-12-18 15:41:58'),
	('A1', 7, 'Apakah saudara tahu penyebab perselisihan dan pertengkaran #0046# dan #0047#?', '\n\npenyebab perselisihan dan pertengkaran #0046# dan #0047# karena.......................................................\n\n...................................................................................;', NULL, '2018-12-18 15:41:58'),
	('A1', 8, 'Bagaimana saudara bisa mengetahui penyebab perselisihan dan pertengkaran tersebut?', 'Saya mengetahui\nkarena saya (melihat/mendengar sendiri) /\n(diberitahu..................................), tentang persitiwa perselisihan\ndan pertengkaran #0046# dan #0047# tersebut;', NULL, '2018-12-18 15:41:58'),
	('A1', 9, 'Apakah\nmasih ada penyebab lain yang mengakibatkan perselisihan dan pertengkaran antara\n#0046# dan #0047#?', '\n\nSebab lainnya yang saya ketahui adalah..... .........................................................................(atau);<br>Saya tidak tahu penyebab perselisihan dan pertengkaran antara #0046# dan #0047#;', NULL, '2018-12-18 15:41:58'),
	('A1', 10, 'Berapa kali saudara melihat #0046# dan #0047# bertengkar ?', 'Saya melihat #0046# dan #0047# bertengkar Kurang lebih .......... kali;', NULL, '2018-12-18 15:41:58'),
	('A1', 11, 'Apakah saat bertengkar, #0046# memukul #0047# ?', 'Ya, pada saat bertengkar #0046# memukul #0047# mengunakan tangan dan juga menendang pakai kaki;', NULL, '2018-12-18 15:41:58'),
	('A1', 12, 'Apakah ada bekas pemukulan tersebut ?', 'Ya, ada bekasnya di bagian ........;', NULL, '2018-12-18 15:41:58'),
	('A1', 13, 'Berapa kali saudara melihat #0047# memukul #0046# ?', ' Saya melihat #0047# memukul #0046#, cuma ....... kali;', NULL, '2018-12-18 15:41:58'),
	('A1', 14, 'Apakah #0046# melakukan visum ke dokter ?', 'Ya sudah melakukan visum oleh dokter;', NULL, '2018-12-18 15:41:58'),
	('A1', 15, 'Kapan peristiwa tersebut terjadi ?', ' Peristiwa tersebut terjadi sekitar bulan / tahun .............;', NULL, '2018-12-18 15:41:58'),
	('A1', 16, 'Sekitar berapa jauh jarak rumah Saudara dengan rumah #0046# dan #0047# ?', 'Jarak antara rumah saya dengan rumah #0046# dan #0047# hanya kurang lebih ..... meter;', NULL, '2018-12-18 15:41:58'),
	('A1', 17, 'Apakah saat ini #0046# dan #0047# masih tinggal serumah ?', '#0046# dan #0047# sudah pisah tempat tinggal sejak .....................sampai sekarang sudah\nberjalan ....................tahun/bulan;', NULL, '2018-12-18 15:41:58'),
	('A1', 18, 'Siapa yang meninggalkan tempat tinggal bersama ?', 'Yang meninggalkan kediaman bersama adalah #0046# / #0047#;', NULL, '2018-12-18 15:41:58'),
	('A1', 19, 'Sudah berapa lama #0046# dan #0047# berpisah tempat tinggal ?', '#0046# dan #0047# berpisah tempat tinggal sudah kurang lebih ..... bulan / tahun;', NULL, '2018-12-18 15:41:58'),
	('A1', 20, 'Dimana #0046# dan #0047# bertempat tinggal setelah keduanya berpisah ?', 'Saat ini #0046# tinggal bersama orang tuanya dan #0047# juga kembali ke rumah orang tuanya;', NULL, '2018-12-18 15:41:58'),
	('A1', 21, 'Apakah #0046# dan #0047# masih sering berkomunikasi selama berpisah ?', 'Selama berpisah  #0046# dan #0047# Sudah tidak pernah lagi berkomunikasi ; <br>Ya, #0046# dan #0047#  masih sering berkomunikasi;', NULL, '2018-12-18 15:41:58'),
	('A1', 22, 'Apakah #0047# masih sering juga memberikan nafkah pada #0046# sejak berpisah ?', 'Selama\npisah #0047# tidak pernah datang, dan tidak pernah lagi memberi nafkah untuk #0046#, dan #0047# sudah tidak memperdulikan #0046# lagi;', NULL, '2018-12-18 15:41:58'),
	('A1', 23, 'Apakah sejak ada masalah, #0046# dan #0047# pernah diupayakan untuk rukun kembali;', 'Ya, pernah diusahakan oleh ...... #0046#, namun tidak berhasil karena #0046# tidak mau rukun lagi;', NULL, '2018-12-18 15:41:58'),
	('A1', 24, 'Apakah masih ada keterangan yang saudara akan sampaikan ?', 'Sudah cukup;', NULL, '2018-12-18 15:41:58'),
	('IN3', 1, 'Apakah Saudara mengenal #0046# I dan #0046# II dan mengetahui pernikahan #4046#?', 'Ya, saya mengenal #4046# karena saya adalah ... #0046# ... dan saya mengetahui pernikahan #4046#;', NULL, '2019-07-28 18:03:40'),
	('IN3', 2, 'Dimana Pemohon I dengan Pemohon II menikah?', 'Pemohon I dengan Pemohon II menikah di #5105#, pada tanggal #5197#;', NULL, '2019-07-28 18:03:40'),
	('IN3', 3, 'Siapa yang bertindak sebagai wali nikah Pemohon II pada pernikahan tersebut?', 'Yang bertindak sebagai wali nikah  adalah #1046# #0046# II bernama #1217##1357#;', NULL, '2019-07-28 18:03:40'),
	('IN3', 4, 'Siapa yang menikahkan Pemohon I dengan Pemohon II?', 'Yang menikahkan #0046# I dengan #0046# II adalah #8087# bernama #9023#;<br>\nYang menikahkan #0046# I dengan #0046# II adalah saya sendiri sebagai wali nikah;', NULL, '2019-07-28 18:03:40'),
	('IN3', 5, 'Siapakah yang bertindak sebagai saksi nikah pada saat terjadinya ijab kabul antara #8087# dan Pemohon I?', 'Yang bertindak sebagai saksi nikah pada saat terjadinya ijab kabul adalah #0650# dan #0651#;<br>Yang bertindak sebagai saksi nikah pada saat terjadinya ijab kabul adalah saya sendiri dengan #0650# / #0651#;', NULL, '2019-07-28 18:03:40'),
	('IN3', 6, 'Apa mahar yang diberikan Pemohon I kepada Pemohon II?', 'Mahar yang diberikan #0046# I kepada #0046# II berupa #1001#;', NULL, '2019-07-28 18:03:40'),
	('IN3', 7, 'Apa status Pemohon I dan Pemohon II saat menikah?', 'Sebelum menikah #0046# I berstatus #1002# dan #0046# II berstatus #1003#;', NULL, '2019-07-28 18:03:40'),
	('IN3', 8, 'Apakah antara Pemohon I dan Pemohon II mempunyai hubungan darah atau semenda yang menyebabkan terhalang untuk menikah?', '#0046# I dan #0046# II tidak mempunyai hubungan darah atau semenda yang menyebabkan terhalang untuk menikah;', NULL, '2019-07-28 18:03:40'),
	('IN3', 9, 'Apakah antara Pemohon I dan Pemohon II mempunyai hubungan susuan yang menyebabkan terhalang untuk menikah?', '#0046# I dan #0046# II juga tidak mempunyai hubungan susuan yang menyebabkan terhalang untuk menikah;', NULL, '2019-07-28 18:03:40'),
	('IN3', 10, 'Pernahkah Saudara mendengar ada pihak lain yang keberatan atas pernikahan Pemohon I dengan Pemohon II?', 'Saya tidak pernah mendengar ada pihak lain yang keberatan atas pernikahan Pemohon I dengan Pemohon II;', NULL, '2019-07-28 18:03:40'),
	('IN3', 11, 'Apakah dari pernikahan tersebut #4046# telah dikaruniai anak?', 'Dari pernikahan tersebut #4046# #0007#;', NULL, '2019-07-28 18:03:40'),
	('IN3', 12, 'Apa tujuan #4046# mengajukan permohonan itsbat nikah?', 'Itsbat nikah #4046# dimaksudkan untuk  untuk #8171#;', NULL, '2019-07-28 18:03:40'),
	('IN3', 13, 'Apakah masih ada yang ingin Saudara sampaikan?', 'Sudah cukup;', NULL, '2019-07-28 18:03:40');;


CREATE TABLE IF NOT EXISTS `abt_menu_grup` (
  `id` int(4) unsigned NOT NULL,
  `nama` varchar(200) NOT NULL,
  `direktori` varchar(500) NOT NULL,
  `sub_menu` char(1) NOT NULL,
  `ms_only` tinyint(1) NOT NULL,
  `modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `direktori` (`direktori`)
);;

REPLACE INTO `abt_menu_grup` (`id`, `nama`, `direktori`, `sub_menu`, `ms_only`, `modified`) VALUES
	(1, 'Gugatan & Permohonan', '1_gugatan_permohonan', 'T', 0, '2019-08-05 12:41:20'),
	(2, 'Blangko Standar Kepaniteraan', '2_formulir_kepaniteraan', 'Y', 0, '2019-05-07 11:40:12'),
	(3, 'Blangko Standar Jinayat', '3_formulir_jinayat', 'Y', 1, '2019-05-07 12:27:26'),
	(4, 'Berita Acara Sidang', '4_berita_acara_sidang', 'T', 0, '2019-05-07 15:33:09'),
	(5, 'Mediasi', '5_mediasi', 'T', 0, '2019-05-15 11:00:26'),
	(6, 'Putusan & Penetapan', '6_putusan_penetapan', 'T', 0, '2019-05-15 11:00:32'),
	(7, 'Ikrar Talak', '7_ikrar_talak', 'T', 0, '2019-05-15 11:00:34'),
	(8, 'Akta Cerai', '8_aktacerai', 'T', 0, '2019-08-31 23:55:04'),
	(9, 'Blangko E-court', '9_e-court', 'T', 0, '2019-08-30 20:14:51'),
	(10, 'Blangko Lainnya', '10_blangko_lainnya', 'T', 0, '2019-08-30 20:14:54');;


CREATE TABLE IF NOT EXISTS `abt_menu` (
  `id` int(4) unsigned NOT NULL,
  `nama` varchar(200) NOT NULL,
  `nama_alias` varchar(200) NOT NULL,
  `direktori` varchar(500) NOT NULL,
  `parent_direktori` varchar(500) NOT NULL,
  `proses_id_min` int(10) unsigned NOT NULL,
  `proses_id_max` int(10) unsigned NOT NULL,
  `perkara_id_min` int(10) unsigned DEFAULT NULL,
  `perkara_id_max` int(10) unsigned DEFAULT NULL,
  `perkara_id_referensi` char(50) DEFAULT NULL,
  `user_cek` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '3 = user perkara sj, 2 = user grup dan user perkara tanpa user grup,  1= user grup dan user perkara',
  `user_grup_id` char(50) DEFAULT NULL,
  `user_top_id` char(50) DEFAULT NULL,
  `user_validator` char(50) DEFAULT NULL,
  `modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `direktori_parent_direktori` (`direktori`,`parent_direktori`)
);;

REPLACE INTO `abt_menu` (`id`, `nama`, `nama_alias`, `direktori`, `parent_direktori`, `proses_id_min`, `proses_id_max`, `perkara_id_min`, `perkara_id_max`, `perkara_id_referensi`, `user_cek`, `user_grup_id`, `user_top_id`, `user_validator`, `modified`) VALUES
	(1, 'Blangko Gugatan & Permohonan', 'Gugatan & Permohonan', '1_gugatan_permohonan', '_blangko_abt', 0, 1000, NULL, NULL, NULL, 1, '30|500|430|1000|1010|1020|1032|1001|1011', '1', NULL, '2019-09-08 11:51:21'),
	(2, 'Penetapan Majelis Hakim (PMH) & Penetapan Hakim Tunggal (PHT)', 'PMH & PHT', 'A.1 PMH - PHT', '2_formulir_kepaniteraan', 20, 200, 15, 16, 'alur_perkara_id', 3, '440|500|30|1000|430|1020|1030|1010|420', '1|10', NULL, '2019-08-08 09:05:08'),
	(3, 'Penunjukan Panitera / Panitera Pengganti', 'Penunjukan PP', 'A.2 Penunjukan PP', '2_formulir_kepaniteraan', 30, 200, 15, 16, 'alur_perkara_id', 3, '440|500|30|1000|430|1020|1030|1010|420', '1|30', NULL, '2019-08-08 09:05:32'),
	(4, 'Penunjukan Jurusita / Jurusita Pengganti', 'Penunjukan Jurusita/JSP', 'A.3 Penunjukan JS-JSP', '2_formulir_kepaniteraan', 40, 200, 15, 16, 'alur_perkara_id', 3, '440|500|30|1000|430|1020|1030|1010|420', '1|30', NULL, '2019-08-08 09:05:49'),
	(5, 'Penetapan Hari Sidang (PHS)', 'P H S', 'A.4 Penetapan Hari Sidang (PHS)', '2_formulir_kepaniteraan', 80, 200, 15, 16, 'alur_perkara_id', 3, '440|500|20|30|1000|430|1020|1030|1010|420', '1|10', NULL, '2019-08-08 09:07:04'),
	(6, 'Relaas Panggilan', 'Relaas Panggilan', 'A.5 Relaas Panggilan', '2_formulir_kepaniteraan', 80, 200, 15, 16, 'alur_perkara_id', 3, '600|650', '1|10|30', NULL, '2019-08-08 09:10:07'),
	(7, 'Surat Kuasa Insidentil', 'Kuasa Insidentil', 'A.6 Kuasa Insidentil', '2_formulir_kepaniteraan', 10, 200, 15, 16, 'alur_perkara_id', 3, '500|430|1000|1010|1020', '1|10|30', NULL, '2019-08-08 09:17:05'),
	(8, 'Formulir Permohonan Banding', 'Permohonan Banding', 'B. Formulir Permohonan Banding', '2_formulir_kepaniteraan', 300, 400, 15, 16, 'alur_perkara_id', 2, '30|430|500|600|1000|1010', '1|10|30', NULL, '2019-08-08 09:17:40'),
	(9, 'Formulir Permohonan Kasasi', 'Permohonan Kasasi', 'C. Formulir Permohonan Kasasi', '2_formulir_kepaniteraan', 410, 500, 15, 16, 'alur_perkara_id', 2, '30|430|500|600|1000|1010', '1|10|30', NULL, '2019-08-08 09:17:42'),
	(10, 'Formulir Permohonan Peninjauan Kembali', 'Permohonan PK', 'D. Formulir Permohonan PK', '2_formulir_kepaniteraan', 510, 590, 15, 16, 'alur_perkara_id', 2, '30|430|500|600|1000|1010', '1|10|30', NULL, '2019-08-08 09:18:05'),
	(11, 'Formulir Konsinyasi', 'Formulir Konsinyasi', 'F. Formulir Konsinyasi', '2_formulir_kepaniteraan', 0, 1000, 15, 16, 'alur_perkara_id', 2, '30|430|500|600|1000|1010', '1|10|30', NULL, '2019-08-08 09:18:07'),
	(12, 'Formulir Titipan', 'Formulir Titipan', 'G. Formulir Titipan', '2_formulir_kepaniteraan', 0, 1000, 15, 16, 'alur_perkara_id', 2, '30|430|500|600|1000|1010', '1|10|30', NULL, '2019-08-08 09:18:14'),
	(13, 'Penetapan & Penunjukan', 'Penetapan & Penunjukan', '1 Penetapan & Penunjukan', '3_formulir_jinayat', 20, 210, 122, 123, 'alur_perkara_id', 1, '440|500|30|1000|430|1020|1030|1010|420', '1|10|30', NULL, '2019-09-08 11:52:42'),
	(14, 'Formulir Permohonan Banding', 'Permohonan Banding', '2 Permohonan Banding', '3_formulir_jinayat', 300, 400, 122, 123, 'alur_perkara_id', 0, '440|500|30|1000|430|1020|1030|1010|420', '1|10|30', NULL, '2019-09-08 11:52:44'),
	(15, 'Formulir Permohonan Kasasi', 'Permohonan Kasasi', '3 Permohonan Kasasi', '3_formulir_jinayat', 410, 500, 122, 123, 'alur_perkara_id', 0, '440|500|30|1000|430|1020|1030|1010|420', '1|10|30', NULL, '2019-09-08 11:52:54'),
	(16, 'Formulir Permohonan Peninjauan Kembali', 'Permohonan PK', '4 Permohonan Peninjauan Kembali', '3_formulir_jinayat', 510, 590, 122, 123, 'alur_perkara_id', 0, '440|500|30|1000|430|1020|1030|1010|420', '1|10|30', NULL, '2019-09-08 11:52:56'),
	(17, 'Berita Acara Sidang', 'Berita Acara Sidang', '4_berita_acara_sidang', '_blangko_abt', 80, 220, NULL, NULL, NULL, 3, '500|430|1000|1010|1020', '1|10|30', '10|20', '2019-09-08 11:52:57'),
	(18, 'Mediasi', 'Mediasi', '5_mediasi', '_blangko_abt', 120, 200, 15, 15, 'alur_perkara_id', 1, '20|30|500|430|1000|1010|1020', '1|10', NULL, '2019-09-08 11:57:16'),
	(19, 'Putusan dan Penetapan', 'Putusan & Penetapan', '6_putusan_penetapan', '_blangko_abt', 80, 220, NULL, NULL, NULL, 3, '20', '1|10', NULL, '2019-09-08 11:53:02'),
	(20, 'Blangko Ikrar Talak', 'Blangko Ikrar Talak', '7_ikrar_talak', '_blangko_abt', 80, 295, 346, 346, 'jenis_perkara_id', 2, '10|30|500|430|1000|1010|1020', '1|10|30', NULL, '2019-09-08 11:53:03'),
	(21, 'Blangko Akta Cerai - CG', 'Blangko Akta Cerai - CG', 'Cerai Gugat', '8_aktacerai', 296, 296, 347, 347, 'jenis_perkara_id', 3, '430|431|1000|1003', '1|10|30', NULL, '2019-09-08 11:53:05'),
	(22, 'Blangko Akta Cerai - CT', 'Blangko Akta Cerai - CT', 'Cerai Talak', '8_aktacerai', 296, 296, 346, 346, 'jenis_perkara_id', 3, '430|431|1000|1003', '1|10|30', NULL, '2019-09-08 11:53:06'),
	(23, 'Blangko e-Court', 'Blangko e-Court', '9_e-court', '_blangko_abt', 0, 1000, NULL, NULL, NULL, 3, '500|430|600|650|1000|1010|1020', '1|10|30', NULL, '2019-09-08 11:53:07'),
	(24, 'Blangko-Blangko Lainnya', 'Lain-lain', '10_blangko_lainnya', '_blangko_abt', 0, 1000, NULL, NULL, NULL, 0, NULL, NULL, NULL, '2019-09-08 11:53:09');;


CREATE TABLE IF NOT EXISTS `abt_data_dirput` (
  `nomor_perkara` char(50) NOT NULL,
  `nomor` smallint(6) NOT NULL,
  `pdt` char(5) DEFAULT NULL,
  `tahun` smallint(6) DEFAULT NULL,
  `kode` char(10) DEFAULT NULL,
  `link_perkara` char(50) DEFAULT NULL,
  `modifier` varchar(30) DEFAULT NULL,
  `modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`nomor_perkara`),
  UNIQUE KEY `link_perkara` (`link_perkara`)
);;


CREATE TABLE IF NOT EXISTS `abt_data_tanggal` (
  `no_var` int(4) unsigned zerofill NOT NULL,
  `perkara_id` bigint(20) NOT NULL,
  `data` date DEFAULT NULL,
  `modifier` varchar(30) DEFAULT NULL,
  `modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`no_var`,`perkara_id`),
  CONSTRAINT `FK_abt_data_tanggal` FOREIGN KEY (`no_var`) REFERENCES `abt_variabel` (`no_var`) ON DELETE CASCADE
);;

CREATE TABLE IF NOT EXISTS `abt_data_teks` (
  `no_var` int(4) unsigned zerofill NOT NULL,
  `perkara_id` bigint(20) NOT NULL,
  `data` text,
  `modifier` varchar(30) DEFAULT NULL,
  `modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`no_var`,`perkara_id`),
  CONSTRAINT `FK_abt_data_teks` FOREIGN KEY (`no_var`) REFERENCES `abt_variabel` (`no_var`) ON DELETE CASCADE
);;


CREATE TABLE IF NOT EXISTS `abt_data_validasi_bas` (
  `id` bigint(20) unsigned NOT NULL,
  `perkara_id` bigint(20) unsigned NOT NULL,
  `sidang_ke` tinyint(3) unsigned NOT NULL,
  `file_name` char(250) DEFAULT NULL,
  `tgl_sidang` char(50) NOT NULL,
  `dir_blangko` varchar(500) DEFAULT NULL,
  `direktori` varchar(1000) DEFAULT NULL,
  `dibuat_oleh` varchar(500) DEFAULT NULL,
  `dibuat_tanggal` datetime DEFAULT NULL,
  `validasi_oleh` varchar(500) DEFAULT NULL,
  `validasi_tanggal` datetime DEFAULT NULL,
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `modifier` varchar(30) DEFAULT NULL,
  `modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `perkara_id_sidang_ke` (`perkara_id`,`sidang_ke`)
);;


CREATE TABLE IF NOT EXISTS `abt_keterangan_saksi` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `perkara_id` bigint(20) DEFAULT NULL,
  `sidang_id` bigint(20) DEFAULT NULL,
  `penanya_id` char(1) DEFAULT NULL COMMENT '1: Ketua Majelis; 2:Hakim Anggota 1; 3: Hakim Anggota 2; 4; Hakim Anggota :3; 5 Hakim Anggota 4',
  `saksi_id` int(11) DEFAULT NULL COMMENT 'refer perkara_pihak_5',
  `urutan_pertanyaan` int(11) DEFAULT NULL,
  `pertanyaan` text,
  `jawaban` text,
  `diinput_oleh` varchar(30) DEFAULT NULL,
  `diinput_tanggal` datetime DEFAULT NULL,
  `diperbaharui_oleh` varchar(30) DEFAULT NULL,
  `diperbaharui_tanggal` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `perkara_id` (`perkara_id`,`sidang_id`,`saksi_id`,`urutan_pertanyaan`)
);;


CREATE TABLE IF NOT EXISTS `abt_keterangan_terdakwa` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `perkara_id` bigint(20) NOT NULL,
  `sidang_id` bigint(20) NOT NULL,
  `penanya_id` char(1) DEFAULT NULL COMMENT '1: Ketua Majelis; 2:Hakim Anggota 1; 3: Hakim Anggota 2; 4; Hakim Anggota :3; 5 Hakim Anggota 4',
  `pihak_id` bigint(20) NOT NULL COMMENT 'refer ke id perkara_pihak_2',
  `urutan_pertanyaan` int(11) DEFAULT NULL,
  `pertanyaan` text,
  `jawaban` text,
  `diinput_oleh` varchar(30) DEFAULT NULL,
  `diinput_tanggal` datetime DEFAULT NULL,
  `diperbaharui_oleh` varchar(30) DEFAULT NULL,
  `diperbaharui_tanggal` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `perkara_id` (`perkara_id`,`sidang_id`,`pihak_id`,`urutan_pertanyaan`)
);;
CREATE TABLE IF NOT EXISTS `abt_temp_variabel` (
  `no_var` int(4) unsigned zerofill NOT NULL,
  `data` char(100) NOT NULL,
  `keterangan` char(100) DEFAULT NULL,
  `modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`no_var`),
  KEY `nama` (`data`)
);;

REPLACE INTO `abt_temp_variabel` (`no_var`, `data`, `keterangan`, `modified`) VALUES
	(0001, 'nomor_sementara', NULL, '2019-08-08 20:25:33'),
	(0010, 'pihak_1_2_agama', 'Agama P2', '2019-08-09 16:43:33'),
	(0011, 'pihak_1_1_agama', 'Agama P', '2019-08-09 16:42:40'),
	(0017, 'tanggal_surat', NULL, '2019-08-08 20:26:42'),
	(0020, 'pihak_2_1_agama', 'Agama T', '2019-08-09 16:40:59'),
	(0021, 'pihak_1_1_pendidikan', 'Pendidikan P', '2019-08-09 16:42:47'),
	(0024, 'pihak_2_1_pendidikan', 'Pendidikan T', '2019-08-09 16:41:10'),
	(0046, 'pihak1_ket', NULL, '2019-08-08 20:29:32'),
	(0047, 'pihak2_ket', NULL, '2019-08-08 20:30:34'),
	(0048, 'jenis_perkara_nama', NULL, '2019-08-08 20:26:10'),
	(0053, 'gugatan_permohonan', NULL, '2019-08-08 20:29:56'),
	(0098, 'pihak_1_1_nama', 'Nama P', '2019-08-09 16:39:25'),
	(0099, 'pihak_1_1_umur', 'Umur P', '2019-08-09 16:42:36'),
	(0100, 'pihak_1_1_pekerjaan', 'Pekerjaan P', '2019-08-09 16:42:53'),
	(0101, 'pihak_1_1_alamat', 'Alamat P', '2019-08-09 16:43:04'),
	(0102, 'pihak_2_1_nama', 'Nama T', '2019-08-09 16:40:17'),
	(0103, 'pihak_2_1_umur', 'Umur T', '2019-08-09 16:40:56'),
	(0104, 'pihak_2_1_pekerjaan', 'Pekerjaan T', '2019-08-09 16:41:16'),
	(0105, 'pihak_2_1_alamat', 'Alamat T', '2019-08-09 16:41:29'),
	(0194, 'putusan_penetapan', NULL, '2019-08-08 20:29:56'),
	(0335, 'pihak_1_1_nomor_indentitas', 'No. NIK P', '2019-08-09 16:42:11'),
	(0336, 'pihak_1_2_nomor_indentitas', 'No. NIK P2', '2019-08-09 16:43:16'),
	(0337, 'pihak_2_1_nomor_indentitas', 'No. NIK T', '2019-08-09 16:40:25'),
	(0341, 'pihak_1_1_tempat_lahir', 'Tempat Lahir P', '2019-08-09 16:42:27'),
	(0342, 'pihak_1_2_tempat_lahir', 'Tempat Lahir P2', '2019-08-09 16:43:20'),
	(0343, 'pihak_2_1_tempat_lahir', 'Tempat Lahir T', '2019-08-09 16:40:35'),
	(0345, 'pihak_1_1_tanggal_lahir', 'Tgl. Lahir P', '2019-08-09 16:42:31'),
	(0346, 'pihak_1_2_tanggal_lahir', 'Tgl. Lahir P2', '2019-08-09 16:43:25'),
	(0347, 'pihak_2_1_tanggal_lahir', 'Tgl. Lahir T', '2019-08-09 16:40:46'),
	(1033, 'pihak_1_2_nama', 'Nama P2', '2019-08-09 16:43:08'),
	(1034, 'pihak_1_2_umur', 'Umur P2', '2019-08-09 16:43:28'),
	(1035, 'pihak_1_2_pekerjaan', 'Pekerjaan P2', '2019-08-09 16:43:44'),
	(1036, 'pihak_1_2_alamat', 'Alamat P2', '2019-08-09 16:43:45'),
	(1176, 'pihak_1_2_pendidikan', 'Pendidikan P2', '2019-08-09 16:43:39');;

CREATE TABLE IF NOT EXISTS `abt_temp_data_perkara` (
  `id` bigint(20) NOT NULL,
  `nomor_sementara` varchar(50) NOT NULL,
  `alur_perkara_id` int(11) DEFAULT NULL,
  `jenis_perkara_id` int(11) DEFAULT NULL,
  `jenis_perkara_nama` varchar(500) DEFAULT NULL,
  `kategori_perkara` varchar(50) DEFAULT NULL,
  `tanggal_surat` date DEFAULT NULL,
  `modifier` varchar(30) DEFAULT NULL,
  `modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nomor_perkara_kategori_perkara` (`nomor_sementara`,`alur_perkara_id`)
);;

CREATE TABLE IF NOT EXISTS `abt_temp_data_pihak` (
  `id` bigint(20) NOT NULL,
  `pihak_ke` tinyint(3) NOT NULL,
  `urutan` tinyint(3) NOT NULL,
  `pihak_id` bigint(20) NOT NULL,
  `modifier` varchar(30) DEFAULT NULL,
  `modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`pihak_ke`,`urutan`),
  UNIQUE KEY `id_pihak_id` (`id`,`pihak_id`),
  CONSTRAINT `FK_abt_data_temp_pihak` FOREIGN KEY (`id`) REFERENCES `abt_temp_data_perkara` (`id`) ON DELETE CASCADE
);;

CREATE TABLE IF NOT EXISTS `abt_temp_data_tanggal` (
  `id` bigint(20) NOT NULL,
  `no_var` int(4) unsigned zerofill NOT NULL,
  `data` date DEFAULT NULL,
  `modifier` varchar(30) DEFAULT NULL,
  `modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`no_var`,`id`),
  KEY `FK_abt_data_temp_tanggal` (`id`),
  CONSTRAINT `FK_abt_data_temp_tanggal` FOREIGN KEY (`id`) REFERENCES `abt_temp_data_perkara` (`id`) ON DELETE CASCADE
);;

CREATE TABLE IF NOT EXISTS `abt_temp_data_teks` (
  `id` bigint(20) NOT NULL,
  `no_var` int(4) unsigned zerofill NOT NULL,
  `data` text,
  `modifier` varchar(30) DEFAULT NULL,
  `modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`no_var`,`id`),
  KEY `FK_abt_data_temp_teks` (`id`),
  CONSTRAINT `FK_abt_data_temp_teks` FOREIGN KEY (`id`) REFERENCES `abt_temp_data_perkara` (`id`) ON DELETE CASCADE
);;




/*NOMOR VARIABEL 0001*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0001);;
update abt_variabel set nama="No Perkara" where no_var=0001;;
update abt_variabel set data_type="data_sipp" where no_var=0001;;
update abt_variabel set data_tabel="perkara" where no_var=0001;;
update abt_variabel set data_kolom="nomor_perkara" where no_var=0001;;
update abt_variabel set urutan_data=NULL where no_var=0001;;
update abt_variabel set referensi=NULL where no_var=0001;;
update abt_variabel set sql_query=NULL where no_var=0001;;
update abt_variabel set default_data=NULL where no_var=0001;;
update abt_variabel set multi_sidang=NULL where no_var=0001;;
update abt_variabel set locked="1" where no_var=0001;;
update abt_variabel set modifier=NULL where no_var=0001;;
update abt_variabel set modified="2019-08-08 19:42:12" where no_var=0001;;


/*NOMOR VARIABEL 0002*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0002);;
update abt_variabel set nama="QR_Code" where no_var=0002;;
update abt_variabel set data_type="qrcode" where no_var=0002;;
update abt_variabel set data_tabel=NULL where no_var=0002;;
update abt_variabel set data_kolom=NULL where no_var=0002;;
update abt_variabel set urutan_data=NULL where no_var=0002;;
update abt_variabel set referensi="0001" where no_var=0002;;
update abt_variabel set sql_query=NULL where no_var=0002;;
update abt_variabel set default_data=NULL where no_var=0002;;
update abt_variabel set multi_sidang=NULL where no_var=0002;;
update abt_variabel set locked="1" where no_var=0002;;
update abt_variabel set modifier=NULL where no_var=0002;;
update abt_variabel set modified="2019-09-08 12:22:30" where no_var=0002;;


/*NOMOR VARIABEL 0010*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0010);;
update abt_variabel set nama="Agama #0046# II" where no_var=0010;;
update abt_variabel set data_type="data_sql" where no_var=0010;;
update abt_variabel set data_tabel=NULL where no_var=0010;;
update abt_variabel set data_kolom=NULL where no_var=0010;;
update abt_variabel set urutan_data=NULL where no_var=0010;;
update abt_variabel set referensi=NULL where no_var=0010;;
update abt_variabel set sql_query="select c.nama as data
from perkara_pihak1 a
join pihak b on a.pihak_id=b.id
join agama c on b.agama_id=c.id
where a.urutan=2 and a.perkara_id=#perkara_id#" where no_var=0010;;
update abt_variabel set default_data=NULL where no_var=0010;;
update abt_variabel set multi_sidang=NULL where no_var=0010;;
update abt_variabel set locked="1" where no_var=0010;;
update abt_variabel set modifier=NULL where no_var=0010;;
update abt_variabel set modified="2019-08-08 19:42:18" where no_var=0010;;


/*NOMOR VARIABEL 0011*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0011);;
update abt_variabel set nama="Agama #0046#" where no_var=0011;;
update abt_variabel set data_type="data_sql" where no_var=0011;;
update abt_variabel set data_tabel=NULL where no_var=0011;;
update abt_variabel set data_kolom=NULL where no_var=0011;;
update abt_variabel set urutan_data=NULL where no_var=0011;;
update abt_variabel set referensi=NULL where no_var=0011;;
update abt_variabel set sql_query="select c.nama as data
from perkara_pihak1 a
join pihak b on a.pihak_id=b.id
join agama c on b.agama_id=c.id
where a.urutan=1 and a.perkara_id=#perkara_id#" where no_var=0011;;
update abt_variabel set default_data=NULL where no_var=0011;;
update abt_variabel set multi_sidang=NULL where no_var=0011;;
update abt_variabel set locked="1" where no_var=0011;;
update abt_variabel set modifier=NULL where no_var=0011;;
update abt_variabel set modified="2019-08-08 19:42:23" where no_var=0011;;


/*NOMOR VARIABEL 0012*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0012);;
update abt_variabel set nama="Nama #0668#" where no_var=0012;;
update abt_variabel set data_type="data_sql" where no_var=0012;;
update abt_variabel set data_tabel=NULL where no_var=0012;;
update abt_variabel set data_kolom=NULL where no_var=0012;;
update abt_variabel set urutan_data=NULL where no_var=0012;;
update abt_variabel set referensi=NULL where no_var=0012;;
update abt_variabel set sql_query="select b.nama_gelar as data from perkara_hakim_pn a
join hakim_pn b on a.hakim_id=b.id
where a.aktif=""Y"" and a.urutan=1 and a.perkara_id=#perkara_id#" where no_var=0012;;
update abt_variabel set default_data=NULL where no_var=0012;;
update abt_variabel set multi_sidang=NULL where no_var=0012;;
update abt_variabel set locked="1" where no_var=0012;;
update abt_variabel set modifier=NULL where no_var=0012;;
update abt_variabel set modified="2019-09-15 12:39:52" where no_var=0012;;


/*NOMOR VARIABEL 0013*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0013);;
update abt_variabel set nama="Nama Hakim Anggota 1" where no_var=0013;;
update abt_variabel set data_type="data_sql" where no_var=0013;;
update abt_variabel set data_tabel=NULL where no_var=0013;;
update abt_variabel set data_kolom=NULL where no_var=0013;;
update abt_variabel set urutan_data=NULL where no_var=0013;;
update abt_variabel set referensi=NULL where no_var=0013;;
update abt_variabel set sql_query="select b.nama_gelar as data from perkara_hakim_pn a
join hakim_pn b on a.hakim_id=b.id
where a.aktif=""Y"" and a.urutan=2 and a.perkara_id=#perkara_id#" where no_var=0013;;
update abt_variabel set default_data=NULL where no_var=0013;;
update abt_variabel set multi_sidang=NULL where no_var=0013;;
update abt_variabel set locked="1" where no_var=0013;;
update abt_variabel set modifier=NULL where no_var=0013;;
update abt_variabel set modified="2019-09-15 12:39:52" where no_var=0013;;


/*NOMOR VARIABEL 0014*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0014);;
update abt_variabel set nama="Nama Hakim Anggota 2" where no_var=0014;;
update abt_variabel set data_type="data_sql" where no_var=0014;;
update abt_variabel set data_tabel=NULL where no_var=0014;;
update abt_variabel set data_kolom=NULL where no_var=0014;;
update abt_variabel set urutan_data=NULL where no_var=0014;;
update abt_variabel set referensi=NULL where no_var=0014;;
update abt_variabel set sql_query="select b.nama_gelar as data from perkara_hakim_pn a
join hakim_pn b on a.hakim_id=b.id
where a.aktif=""Y"" and a.urutan=3 and a.perkara_id=#perkara_id#" where no_var=0014;;
update abt_variabel set default_data=NULL where no_var=0014;;
update abt_variabel set multi_sidang=NULL where no_var=0014;;
update abt_variabel set locked="1" where no_var=0014;;
update abt_variabel set modifier=NULL where no_var=0014;;
update abt_variabel set modified="2019-09-15 12:39:52" where no_var=0014;;


/*NOMOR VARIABEL 0015*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0015);;
update abt_variabel set nama="Nama PP" where no_var=0015;;
update abt_variabel set data_type="data_sql" where no_var=0015;;
update abt_variabel set data_tabel=NULL where no_var=0015;;
update abt_variabel set data_kolom=NULL where no_var=0015;;
update abt_variabel set urutan_data=NULL where no_var=0015;;
update abt_variabel set referensi=NULL where no_var=0015;;
update abt_variabel set sql_query="select panitera_nama as data
from perkara_panitera_pn 
where aktif=""Y"" and perkara_id=#perkara_id#" where no_var=0015;;
update abt_variabel set default_data=NULL where no_var=0015;;
update abt_variabel set multi_sidang=NULL where no_var=0015;;
update abt_variabel set locked="1" where no_var=0015;;
update abt_variabel set modifier=NULL where no_var=0015;;
update abt_variabel set modified="2019-09-15 12:39:52" where no_var=0015;;


/*NOMOR VARIABEL 0016*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0016);;
update abt_variabel set nama="Hari Tgl. #0053#" where no_var=0016;;
update abt_variabel set data_type="tanggal_hari" where no_var=0016;;
update abt_variabel set data_tabel=NULL where no_var=0016;;
update abt_variabel set data_kolom=NULL where no_var=0016;;
update abt_variabel set urutan_data=NULL where no_var=0016;;
update abt_variabel set referensi="0017" where no_var=0016;;
update abt_variabel set sql_query=NULL where no_var=0016;;
update abt_variabel set default_data=NULL where no_var=0016;;
update abt_variabel set multi_sidang=NULL where no_var=0016;;
update abt_variabel set locked="1" where no_var=0016;;
update abt_variabel set modifier=NULL where no_var=0016;;
update abt_variabel set modified="2019-08-08 19:43:42" where no_var=0016;;


/*NOMOR VARIABEL 0018*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0018);;
update abt_variabel set nama="Nama Jurusita/JSP" where no_var=0018;;
update abt_variabel set data_type="data_sql" where no_var=0018;;
update abt_variabel set data_tabel=NULL where no_var=0018;;
update abt_variabel set data_kolom=NULL where no_var=0018;;
update abt_variabel set urutan_data=NULL where no_var=0018;;
update abt_variabel set referensi=NULL where no_var=0018;;
update abt_variabel set sql_query="select b.nama_gelar as data
from perkara_jurusita a
join jurusita b on a.jurusita_id =b.id
where a.aktif=""Y"" and a.urutan=1 and a.perkara_id=#perkara_id#" where no_var=0018;;
update abt_variabel set default_data=NULL where no_var=0018;;
update abt_variabel set multi_sidang=NULL where no_var=0018;;
update abt_variabel set locked="1" where no_var=0018;;
update abt_variabel set modifier=NULL where no_var=0018;;
update abt_variabel set modified="2019-09-15 12:39:52" where no_var=0018;;


/*NOMOR VARIABEL 0019*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0019);;
update abt_variabel set nama="Nama Jurusita/JSP 2" where no_var=0019;;
update abt_variabel set data_type="data_sql" where no_var=0019;;
update abt_variabel set data_tabel=NULL where no_var=0019;;
update abt_variabel set data_kolom=NULL where no_var=0019;;
update abt_variabel set urutan_data=NULL where no_var=0019;;
update abt_variabel set referensi=NULL where no_var=0019;;
update abt_variabel set sql_query="select b.nama_gelar as data
from perkara_jurusita a
join jurusita b on a.jurusita_id =b.id
where a.aktif=""Y"" and a.urutan=2 and a.perkara_id=#perkara_id#" where no_var=0019;;
update abt_variabel set default_data=NULL where no_var=0019;;
update abt_variabel set multi_sidang=NULL where no_var=0019;;
update abt_variabel set locked="1" where no_var=0019;;
update abt_variabel set modifier=NULL where no_var=0019;;
update abt_variabel set modified="2019-09-15 12:39:52" where no_var=0019;;


/*NOMOR VARIABEL 0020*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0020);;
update abt_variabel set nama="Agama #0047#" where no_var=0020;;
update abt_variabel set data_type="data_sql" where no_var=0020;;
update abt_variabel set data_tabel=NULL where no_var=0020;;
update abt_variabel set data_kolom=NULL where no_var=0020;;
update abt_variabel set urutan_data=NULL where no_var=0020;;
update abt_variabel set referensi=NULL where no_var=0020;;
update abt_variabel set sql_query="select c.nama as data from perkara_pihak2 a
join pihak b on a.pihak_id=b.id
join agama c on b.agama_id=c.id
where urutan=1 and perkara_id=#perkara_id#" where no_var=0020;;
update abt_variabel set default_data=NULL where no_var=0020;;
update abt_variabel set multi_sidang=NULL where no_var=0020;;
update abt_variabel set locked="1" where no_var=0020;;
update abt_variabel set modifier=NULL where no_var=0020;;
update abt_variabel set modified="2019-08-08 19:44:08" where no_var=0020;;


/*NOMOR VARIABEL 0021*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0021);;
update abt_variabel set nama="Pendidikan #0046#" where no_var=0021;;
update abt_variabel set data_type="data_sql" where no_var=0021;;
update abt_variabel set data_tabel=NULL where no_var=0021;;
update abt_variabel set data_kolom=NULL where no_var=0021;;
update abt_variabel set urutan_data=NULL where no_var=0021;;
update abt_variabel set referensi=NULL where no_var=0021;;
update abt_variabel set sql_query="select c.kode as data from perkara_pihak1 a
join pihak b on a.pihak_id=b.id
join tingkat_pendidikan c on b.pendidikan_id=c.id
where urutan=1 and perkara_id=#perkara_id#" where no_var=0021;;
update abt_variabel set default_data=NULL where no_var=0021;;
update abt_variabel set multi_sidang=NULL where no_var=0021;;
update abt_variabel set locked="1" where no_var=0021;;
update abt_variabel set modifier=NULL where no_var=0021;;
update abt_variabel set modified="2019-08-08 19:44:10" where no_var=0021;;


/*NOMOR VARIABEL 0022*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0022);;
update abt_variabel set nama="Hari Relaas #0046#" where no_var=0022;;
update abt_variabel set data_type="tanggal_hari" where no_var=0022;;
update abt_variabel set data_tabel=NULL where no_var=0022;;
update abt_variabel set data_kolom=NULL where no_var=0022;;
update abt_variabel set urutan_data=NULL where no_var=0022;;
update abt_variabel set referensi="1076" where no_var=0022;;
update abt_variabel set sql_query=NULL where no_var=0022;;
update abt_variabel set default_data=NULL where no_var=0022;;
update abt_variabel set multi_sidang=NULL where no_var=0022;;
update abt_variabel set locked="1" where no_var=0022;;
update abt_variabel set modifier=NULL where no_var=0022;;
update abt_variabel set modified="2019-08-08 19:44:17" where no_var=0022;;


/*NOMOR VARIABEL 0023*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0023);;
update abt_variabel set nama="Hari Relaas #0047#" where no_var=0023;;
update abt_variabel set data_type="tanggal_hari" where no_var=0023;;
update abt_variabel set data_tabel=NULL where no_var=0023;;
update abt_variabel set data_kolom=NULL where no_var=0023;;
update abt_variabel set urutan_data=NULL where no_var=0023;;
update abt_variabel set referensi="1077" where no_var=0023;;
update abt_variabel set sql_query=NULL where no_var=0023;;
update abt_variabel set default_data=NULL where no_var=0023;;
update abt_variabel set multi_sidang=NULL where no_var=0023;;
update abt_variabel set locked="1" where no_var=0023;;
update abt_variabel set modifier=NULL where no_var=0023;;
update abt_variabel set modified="2019-08-08 19:44:19" where no_var=0023;;


/*NOMOR VARIABEL 0024*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0024);;
update abt_variabel set nama="Pendidikan #0047#" where no_var=0024;;
update abt_variabel set data_type="data_sql" where no_var=0024;;
update abt_variabel set data_tabel=NULL where no_var=0024;;
update abt_variabel set data_kolom=NULL where no_var=0024;;
update abt_variabel set urutan_data=NULL where no_var=0024;;
update abt_variabel set referensi=NULL where no_var=0024;;
update abt_variabel set sql_query="select c.kode as data from perkara_pihak2 a
join pihak b on a.pihak_id=b.id
join tingkat_pendidikan c on b.pendidikan_id=c.id
where urutan=1 and perkara_id=#perkara_id#" where no_var=0024;;
update abt_variabel set default_data=NULL where no_var=0024;;
update abt_variabel set multi_sidang=NULL where no_var=0024;;
update abt_variabel set locked="1" where no_var=0024;;
update abt_variabel set modifier=NULL where no_var=0024;;
update abt_variabel set modified="2019-08-08 19:44:23" where no_var=0024;;


/*NOMOR VARIABEL 0025*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0025);;
update abt_variabel set nama="Hari Tgl Putusan" where no_var=0025;;
update abt_variabel set data_type="tanggal_hari" where no_var=0025;;
update abt_variabel set data_tabel=NULL where no_var=0025;;
update abt_variabel set data_kolom=NULL where no_var=0025;;
update abt_variabel set urutan_data=NULL where no_var=0025;;
update abt_variabel set referensi="1069" where no_var=0025;;
update abt_variabel set sql_query=NULL where no_var=0025;;
update abt_variabel set default_data=NULL where no_var=0025;;
update abt_variabel set multi_sidang=NULL where no_var=0025;;
update abt_variabel set locked="1" where no_var=0025;;
update abt_variabel set modifier=NULL where no_var=0025;;
update abt_variabel set modified="2019-08-08 19:44:26" where no_var=0025;;


/*NOMOR VARIABEL 0028*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0028);;
update abt_variabel set nama="Hari Sidang Ikrar Talak" where no_var=0028;;
update abt_variabel set data_type="tanggal_hari" where no_var=0028;;
update abt_variabel set data_tabel=NULL where no_var=0028;;
update abt_variabel set data_kolom=NULL where no_var=0028;;
update abt_variabel set urutan_data=NULL where no_var=0028;;
update abt_variabel set referensi="1182" where no_var=0028;;
update abt_variabel set sql_query=NULL where no_var=0028;;
update abt_variabel set default_data=NULL where no_var=0028;;
update abt_variabel set multi_sidang=NULL where no_var=0028;;
update abt_variabel set locked="1" where no_var=0028;;
update abt_variabel set modifier=NULL where no_var=0028;;
update abt_variabel set modified="2019-08-08 19:44:29" where no_var=0028;;


/*NOMOR VARIABEL 0032*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0032);;
update abt_variabel set nama="Hari Sidang" where no_var=0032;;
update abt_variabel set data_type="multi_sidang" where no_var=0032;;
update abt_variabel set data_tabel=NULL where no_var=0032;;
update abt_variabel set data_kolom=NULL where no_var=0032;;
update abt_variabel set urutan_data=NULL where no_var=0032;;
update abt_variabel set referensi=NULL where no_var=0032;;
update abt_variabel set sql_query=NULL where no_var=0032;;
update abt_variabel set default_data=NULL where no_var=0032;;
update abt_variabel set multi_sidang="hari_sidang" where no_var=0032;;
update abt_variabel set locked="1" where no_var=0032;;
update abt_variabel set modifier=NULL where no_var=0032;;
update abt_variabel set modified="2019-08-08 19:45:28" where no_var=0032;;


/*NOMOR VARIABEL 0033*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0033);;
update abt_variabel set nama="Tgl Sidang" where no_var=0033;;
update abt_variabel set data_type="multi_sidang" where no_var=0033;;
update abt_variabel set data_tabel=NULL where no_var=0033;;
update abt_variabel set data_kolom=NULL where no_var=0033;;
update abt_variabel set urutan_data=NULL where no_var=0033;;
update abt_variabel set referensi=NULL where no_var=0033;;
update abt_variabel set sql_query=NULL where no_var=0033;;
update abt_variabel set default_data=NULL where no_var=0033;;
update abt_variabel set multi_sidang="tanggal_sidang" where no_var=0033;;
update abt_variabel set locked="1" where no_var=0033;;
update abt_variabel set modifier=NULL where no_var=0033;;
update abt_variabel set modified="2019-08-08 19:45:31" where no_var=0033;;


/*NOMOR VARIABEL 0038*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0038);;
update abt_variabel set nama="Hijriyah Tgl Putusan" where no_var=0038;;
update abt_variabel set data_type="tanggal_hijriah" where no_var=0038;;
update abt_variabel set data_tabel=NULL where no_var=0038;;
update abt_variabel set data_kolom=NULL where no_var=0038;;
update abt_variabel set urutan_data=NULL where no_var=0038;;
update abt_variabel set referensi="1069" where no_var=0038;;
update abt_variabel set sql_query=NULL where no_var=0038;;
update abt_variabel set default_data=NULL where no_var=0038;;
update abt_variabel set multi_sidang=NULL where no_var=0038;;
update abt_variabel set locked="1" where no_var=0038;;
update abt_variabel set modifier=NULL where no_var=0038;;
update abt_variabel set modified="2019-08-08 19:45:37" where no_var=0038;;


/*NOMOR VARIABEL 0041*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0041);;
update abt_variabel set nama="Agenda Sidang Sebelumnya" where no_var=0041;;
update abt_variabel set data_type="multi_sidang" where no_var=0041;;
update abt_variabel set data_tabel=NULL where no_var=0041;;
update abt_variabel set data_kolom=NULL where no_var=0041;;
update abt_variabel set urutan_data=NULL where no_var=0041;;
update abt_variabel set referensi=NULL where no_var=0041;;
update abt_variabel set sql_query=NULL where no_var=0041;;
update abt_variabel set default_data=NULL where no_var=0041;;
update abt_variabel set multi_sidang="agenda_sblmnya" where no_var=0041;;
update abt_variabel set locked="1" where no_var=0041;;
update abt_variabel set modifier=NULL where no_var=0041;;
update abt_variabel set modified="2019-08-08 19:45:42" where no_var=0041;;


/*NOMOR VARIABEL 0046*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0046);;
update abt_variabel set nama="Pemohon/ Penggugat" where no_var=0046;;
update abt_variabel set data_type="data_sql" where no_var=0046;;
update abt_variabel set data_tabel=NULL where no_var=0046;;
update abt_variabel set data_kolom=NULL where no_var=0046;;
update abt_variabel set urutan_data=NULL where no_var=0046;;
update abt_variabel set referensi=NULL where no_var=0046;;
update abt_variabel set sql_query="select (case when alur_perkara_id=16 or jenis_perkara_id=346 or jenis_perkara_id=341 then ""Pemohon""
when alur_perkara_id=122 or alur_perkara_id=123  then ""Penuntut Umum""
else ""Penggugat"" end) as data
from perkara where perkara_id=#perkara_id#" where no_var=0046;;
update abt_variabel set default_data=NULL where no_var=0046;;
update abt_variabel set multi_sidang=NULL where no_var=0046;;
update abt_variabel set locked="1" where no_var=0046;;
update abt_variabel set modifier=NULL where no_var=0046;;
update abt_variabel set modified="2019-08-08 19:45:45" where no_var=0046;;


/*NOMOR VARIABEL 0047*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0047);;
update abt_variabel set nama="Termohon/ Tergugat" where no_var=0047;;
update abt_variabel set data_type="data_sql" where no_var=0047;;
update abt_variabel set data_tabel=NULL where no_var=0047;;
update abt_variabel set data_kolom=NULL where no_var=0047;;
update abt_variabel set urutan_data=NULL where no_var=0047;;
update abt_variabel set referensi=NULL where no_var=0047;;
update abt_variabel set sql_query="select (case when alur_perkara_id=16 or jenis_perkara_id=346 or jenis_perkara_id=341 then ""Termohon""
when alur_perkara_id=122 or alur_perkara_id=123  then ""Terdakwa""
else ""Tergugat"" end) as data
from perkara where perkara_id=#perkara_id#" where no_var=0047;;
update abt_variabel set default_data=NULL where no_var=0047;;
update abt_variabel set multi_sidang=NULL where no_var=0047;;
update abt_variabel set locked="1" where no_var=0047;;
update abt_variabel set modifier=NULL where no_var=0047;;
update abt_variabel set modified="2019-08-08 19:45:47" where no_var=0047;;


/*NOMOR VARIABEL 0048*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0048);;
update abt_variabel set nama="Jenis Perkara" where no_var=0048;;
update abt_variabel set data_type="data_sipp" where no_var=0048;;
update abt_variabel set data_tabel="perkara" where no_var=0048;;
update abt_variabel set data_kolom="jenis_perkara_nama" where no_var=0048;;
update abt_variabel set urutan_data=NULL where no_var=0048;;
update abt_variabel set referensi=NULL where no_var=0048;;
update abt_variabel set sql_query=NULL where no_var=0048;;
update abt_variabel set default_data=NULL where no_var=0048;;
update abt_variabel set multi_sidang=NULL where no_var=0048;;
update abt_variabel set locked="1" where no_var=0048;;
update abt_variabel set modifier=NULL where no_var=0048;;
update abt_variabel set modified="2019-08-08 19:45:53" where no_var=0048;;


/*NOMOR VARIABEL 0050*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0050);;
update abt_variabel set nama="Persidangan ke-" where no_var=0050;;
update abt_variabel set data_type="multi_sidang" where no_var=0050;;
update abt_variabel set data_tabel=NULL where no_var=0050;;
update abt_variabel set data_kolom=NULL where no_var=0050;;
update abt_variabel set urutan_data=NULL where no_var=0050;;
update abt_variabel set referensi=NULL where no_var=0050;;
update abt_variabel set sql_query=NULL where no_var=0050;;
update abt_variabel set default_data=NULL where no_var=0050;;
update abt_variabel set multi_sidang="urutan" where no_var=0050;;
update abt_variabel set locked="1" where no_var=0050;;
update abt_variabel set modifier=NULL where no_var=0050;;
update abt_variabel set modified="2019-08-08 19:46:07" where no_var=0050;;


/*NOMOR VARIABEL 0051*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0051);;
update abt_variabel set nama="Tgl. Sidang I" where no_var=0051;;
update abt_variabel set data_type="data_sipp" where no_var=0051;;
update abt_variabel set data_tabel="perkara_penetapan" where no_var=0051;;
update abt_variabel set data_kolom="sidang_pertama" where no_var=0051;;
update abt_variabel set urutan_data=NULL where no_var=0051;;
update abt_variabel set referensi=NULL where no_var=0051;;
update abt_variabel set sql_query=NULL where no_var=0051;;
update abt_variabel set default_data=NULL where no_var=0051;;
update abt_variabel set multi_sidang=NULL where no_var=0051;;
update abt_variabel set locked="1" where no_var=0051;;
update abt_variabel set modifier=NULL where no_var=0051;;
update abt_variabel set modified="2019-08-08 19:46:12" where no_var=0051;;


/*NOMOR VARIABEL 0053*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0053);;
update abt_variabel set nama="permohonan / gugatan" where no_var=0053;;
update abt_variabel set data_type="data_sql" where no_var=0053;;
update abt_variabel set data_tabel=NULL where no_var=0053;;
update abt_variabel set data_kolom=NULL where no_var=0053;;
update abt_variabel set urutan_data=NULL where no_var=0053;;
update abt_variabel set referensi=NULL where no_var=0053;;
update abt_variabel set sql_query="select (case when alur_perkara_id=16 or jenis_perkara_id=346 then ""permohonan""
else ""gugatan"" end) as data
from perkara where perkara_id=#perkara_id#" where no_var=0053;;
update abt_variabel set default_data=NULL where no_var=0053;;
update abt_variabel set multi_sidang=NULL where no_var=0053;;
update abt_variabel set locked="1" where no_var=0053;;
update abt_variabel set modifier=NULL where no_var=0053;;
update abt_variabel set modified="2019-08-08 19:46:23" where no_var=0053;;


/*NOMOR VARIABEL 0054*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0054);;
update abt_variabel set nama="Hari PBT Isi Putusan" where no_var=0054;;
update abt_variabel set data_type="tanggal_hari" where no_var=0054;;
update abt_variabel set data_tabel=NULL where no_var=0054;;
update abt_variabel set data_kolom=NULL where no_var=0054;;
update abt_variabel set urutan_data=NULL where no_var=0054;;
update abt_variabel set referensi="1071" where no_var=0054;;
update abt_variabel set sql_query=NULL where no_var=0054;;
update abt_variabel set default_data=NULL where no_var=0054;;
update abt_variabel set multi_sidang=NULL where no_var=0054;;
update abt_variabel set locked="1" where no_var=0054;;
update abt_variabel set modifier=NULL where no_var=0054;;
update abt_variabel set modified="2019-08-08 19:47:20" where no_var=0054;;


/*NOMOR VARIABEL 0055*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0055);;
update abt_variabel set nama="Tgl Penetapan Mediator" where no_var=0055;;
update abt_variabel set data_type="data_sipp" where no_var=0055;;
update abt_variabel set data_tabel="perkara_mediator" where no_var=0055;;
update abt_variabel set data_kolom="tanggal_penetapan" where no_var=0055;;
update abt_variabel set urutan_data=NULL where no_var=0055;;
update abt_variabel set referensi=NULL where no_var=0055;;
update abt_variabel set sql_query=NULL where no_var=0055;;
update abt_variabel set default_data=NULL where no_var=0055;;
update abt_variabel set multi_sidang=NULL where no_var=0055;;
update abt_variabel set locked="1" where no_var=0055;;
update abt_variabel set modifier=NULL where no_var=0055;;
update abt_variabel set modified="2019-08-08 19:47:26" where no_var=0055;;


/*NOMOR VARIABEL 0056*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0056);;
update abt_variabel set nama="Nama Mediator" where no_var=0056;;
update abt_variabel set data_type="data_sipp" where no_var=0056;;
update abt_variabel set data_tabel="perkara_mediasi" where no_var=0056;;
update abt_variabel set data_kolom="mediator_text" where no_var=0056;;
update abt_variabel set urutan_data=NULL where no_var=0056;;
update abt_variabel set referensi=NULL where no_var=0056;;
update abt_variabel set sql_query=NULL where no_var=0056;;
update abt_variabel set default_data=NULL where no_var=0056;;
update abt_variabel set multi_sidang=NULL where no_var=0056;;
update abt_variabel set locked="1" where no_var=0056;;
update abt_variabel set modifier=NULL where no_var=0056;;
update abt_variabel set modified="2019-08-08 19:47:28" where no_var=0056;;


/*NOMOR VARIABEL 0057*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0057);;
update abt_variabel set nama="Tgl Mediasi" where no_var=0057;;
update abt_variabel set data_type="data_sipp" where no_var=0057;;
update abt_variabel set data_tabel="perkara_mediasi" where no_var=0057;;
update abt_variabel set data_kolom="dimulai_mediasi" where no_var=0057;;
update abt_variabel set urutan_data=NULL where no_var=0057;;
update abt_variabel set referensi=NULL where no_var=0057;;
update abt_variabel set sql_query=NULL where no_var=0057;;
update abt_variabel set default_data=NULL where no_var=0057;;
update abt_variabel set multi_sidang=NULL where no_var=0057;;
update abt_variabel set locked="1" where no_var=0057;;
update abt_variabel set modifier=NULL where no_var=0057;;
update abt_variabel set modified="2019-08-08 19:47:33" where no_var=0057;;


/*NOMOR VARIABEL 0058*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0058);;
update abt_variabel set nama="Hasil Mediasi" where no_var=0058;;
update abt_variabel set data_type="data_sql" where no_var=0058;;
update abt_variabel set data_tabel=NULL where no_var=0058;;
update abt_variabel set data_kolom=NULL where no_var=0058;;
update abt_variabel set urutan_data=NULL where no_var=0058;;
update abt_variabel set referensi=NULL where no_var=0058;;
update abt_variabel set sql_query="select (case

when hasil_mediasi=""Y1""
then ""berhasil dengan kesepatakan""

when hasil_mediasi=""Y2""
then ""berhasil dengan pencabutan""

when hasil_mediasi=""S""
then ""berhasil sebagian""

when hasil_mediasi=""T""
then ""tidak berhasil mencapai kesepakatan""

when hasil_mediasi=""D""
then ""tidak dapat dilaksanakan""

end) data
from perkara_mediasi where perkara_id=#perkara_id#" where no_var=0058;;
update abt_variabel set default_data=NULL where no_var=0058;;
update abt_variabel set multi_sidang=NULL where no_var=0058;;
update abt_variabel set locked="1" where no_var=0058;;
update abt_variabel set modifier=NULL where no_var=0058;;
update abt_variabel set modified="2019-08-19 11:07:41" where no_var=0058;;


/*NOMOR VARIABEL 0059*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0059);;
update abt_variabel set nama="Hari Sidang I" where no_var=0059;;
update abt_variabel set data_type="tanggal_hari" where no_var=0059;;
update abt_variabel set data_tabel=NULL where no_var=0059;;
update abt_variabel set data_kolom=NULL where no_var=0059;;
update abt_variabel set urutan_data=NULL where no_var=0059;;
update abt_variabel set referensi="0051" where no_var=0059;;
update abt_variabel set sql_query=NULL where no_var=0059;;
update abt_variabel set default_data=NULL where no_var=0059;;
update abt_variabel set multi_sidang=NULL where no_var=0059;;
update abt_variabel set locked="1" where no_var=0059;;
update abt_variabel set modifier=NULL where no_var=0059;;
update abt_variabel set modified="2019-08-08 19:47:58" where no_var=0059;;


/*NOMOR VARIABEL 0065*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0065);;
update abt_variabel set nama="Amar Putusan" where no_var=0065;;
update abt_variabel set data_type="data_sipp" where no_var=0065;;
update abt_variabel set data_tabel="perkara_putusan" where no_var=0065;;
update abt_variabel set data_kolom="amar_putusan" where no_var=0065;;
update abt_variabel set urutan_data=NULL where no_var=0065;;
update abt_variabel set referensi=NULL where no_var=0065;;
update abt_variabel set sql_query=NULL where no_var=0065;;
update abt_variabel set default_data=NULL where no_var=0065;;
update abt_variabel set multi_sidang=NULL where no_var=0065;;
update abt_variabel set locked="1" where no_var=0065;;
update abt_variabel set modifier=NULL where no_var=0065;;
update abt_variabel set modified="2019-08-08 19:48:11" where no_var=0065;;


/*NOMOR VARIABEL 0069*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0069);;
update abt_variabel set nama="Pendidikan Kuasa #0046#" where no_var=0069;;
update abt_variabel set data_type="data_sql" where no_var=0069;;
update abt_variabel set data_tabel=NULL where no_var=0069;;
update abt_variabel set data_kolom=NULL where no_var=0069;;
update abt_variabel set urutan_data=NULL where no_var=0069;;
update abt_variabel set referensi=NULL where no_var=0069;;
update abt_variabel set sql_query="select c.kode as data from perkara_pengacara a
join pihak b on a.pihak_id=b.id
join tingkat_pendidikan c on b.pendidikan_id=c.id
where a.pihak_ke=1 and a.urutan=1 and a.perkara_id=#perkara_id#" where no_var=0069;;
update abt_variabel set default_data=NULL where no_var=0069;;
update abt_variabel set multi_sidang=NULL where no_var=0069;;
update abt_variabel set locked="1" where no_var=0069;;
update abt_variabel set modifier=NULL where no_var=0069;;
update abt_variabel set modified="2019-08-08 19:48:21" where no_var=0069;;


/*NOMOR VARIABEL 0070*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0070);;
update abt_variabel set nama="Pendidikan Kuasa #0047#" where no_var=0070;;
update abt_variabel set data_type="data_sql" where no_var=0070;;
update abt_variabel set data_tabel=NULL where no_var=0070;;
update abt_variabel set data_kolom=NULL where no_var=0070;;
update abt_variabel set urutan_data=NULL where no_var=0070;;
update abt_variabel set referensi=NULL where no_var=0070;;
update abt_variabel set sql_query="select c.kode as data from perkara_pengacara a
join pihak b on a.pihak_id=b.id
join tingkat_pendidikan c on b.pendidikan_id=c.id
where a.pihak_ke=2 and a.urutan=1 and a.perkara_id=#perkara_id#" where no_var=0070;;
update abt_variabel set default_data=NULL where no_var=0070;;
update abt_variabel set multi_sidang=NULL where no_var=0070;;
update abt_variabel set locked="1" where no_var=0070;;
update abt_variabel set modifier=NULL where no_var=0070;;
update abt_variabel set modified="2019-08-08 19:48:23" where no_var=0070;;


/*NOMOR VARIABEL 0076*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0076);;
update abt_variabel set nama="Alasan Tunda Sidang Sebelumnya" where no_var=0076;;
update abt_variabel set data_type="multi_sidang" where no_var=0076;;
update abt_variabel set data_tabel=NULL where no_var=0076;;
update abt_variabel set data_kolom=NULL where no_var=0076;;
update abt_variabel set urutan_data=NULL where no_var=0076;;
update abt_variabel set referensi=NULL where no_var=0076;;
update abt_variabel set sql_query=NULL where no_var=0076;;
update abt_variabel set default_data=NULL where no_var=0076;;
update abt_variabel set multi_sidang="alasan_sblmnya" where no_var=0076;;
update abt_variabel set locked="1" where no_var=0076;;
update abt_variabel set modifier=NULL where no_var=0076;;
update abt_variabel set modified="2019-08-08 19:48:28" where no_var=0076;;


/*NOMOR VARIABEL 0079*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0079);;
update abt_variabel set nama="Alasan Tunda" where no_var=0079;;
update abt_variabel set data_type="multi_sidang" where no_var=0079;;
update abt_variabel set data_tabel=NULL where no_var=0079;;
update abt_variabel set data_kolom=NULL where no_var=0079;;
update abt_variabel set urutan_data=NULL where no_var=0079;;
update abt_variabel set referensi=NULL where no_var=0079;;
update abt_variabel set sql_query=NULL where no_var=0079;;
update abt_variabel set default_data=NULL where no_var=0079;;
update abt_variabel set multi_sidang="alasan_ditunda" where no_var=0079;;
update abt_variabel set locked="1" where no_var=0079;;
update abt_variabel set modifier=NULL where no_var=0079;;
update abt_variabel set modified="2019-08-08 19:48:37" where no_var=0079;;


/*NOMOR VARIABEL 0090*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0090);;
update abt_variabel set nama="Dihadiri oleh" where no_var=0090;;
update abt_variabel set data_type="multi_sidang" where no_var=0090;;
update abt_variabel set data_tabel=NULL where no_var=0090;;
update abt_variabel set data_kolom=NULL where no_var=0090;;
update abt_variabel set urutan_data=NULL where no_var=0090;;
update abt_variabel set referensi=NULL where no_var=0090;;
update abt_variabel set sql_query=NULL where no_var=0090;;
update abt_variabel set default_data=NULL where no_var=0090;;
update abt_variabel set multi_sidang="dihadiri_oleh" where no_var=0090;;
update abt_variabel set locked="1" where no_var=0090;;
update abt_variabel set modifier=NULL where no_var=0090;;
update abt_variabel set modified="2019-08-08 19:49:01" where no_var=0090;;


/*NOMOR VARIABEL 0098*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0098);;
update abt_variabel set nama="Nama #0046#" where no_var=0098;;
update abt_variabel set data_type="data_sipp" where no_var=0098;;
update abt_variabel set data_tabel="perkara_pihak1" where no_var=0098;;
update abt_variabel set data_kolom="nama" where no_var=0098;;
update abt_variabel set urutan_data="1" where no_var=0098;;
update abt_variabel set referensi=NULL where no_var=0098;;
update abt_variabel set sql_query=NULL where no_var=0098;;
update abt_variabel set default_data=NULL where no_var=0098;;
update abt_variabel set multi_sidang=NULL where no_var=0098;;
update abt_variabel set locked="1" where no_var=0098;;
update abt_variabel set modifier=NULL where no_var=0098;;
update abt_variabel set modified="2019-08-08 19:49:07" where no_var=0098;;


/*NOMOR VARIABEL 0099*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0099);;
update abt_variabel set nama="Umur #0046#" where no_var=0099;;
update abt_variabel set data_type="data_sql" where no_var=0099;;
update abt_variabel set data_tabel=NULL where no_var=0099;;
update abt_variabel set data_kolom=NULL where no_var=0099;;
update abt_variabel set urutan_data=NULL where no_var=0099;;
update abt_variabel set referensi=NULL where no_var=0099;;
update abt_variabel set sql_query="select (get_umur(b.tanggal_lahir,c.tanggal_pendaftaran))as data
from perkara_pihak1 a
join pihak b on a.pihak_id=b.id
join perkara c on a.perkara_id=c.perkara_id
where a.urutan=1 and a.perkara_id=#perkara_id#" where no_var=0099;;
update abt_variabel set default_data=NULL where no_var=0099;;
update abt_variabel set multi_sidang=NULL where no_var=0099;;
update abt_variabel set locked="1" where no_var=0099;;
update abt_variabel set modifier=NULL where no_var=0099;;
update abt_variabel set modified="2019-08-09 05:57:40" where no_var=0099;;


/*NOMOR VARIABEL 0100*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0100);;
update abt_variabel set nama="Pekerjaan #0046#" where no_var=0100;;
update abt_variabel set data_type="data_sql" where no_var=0100;;
update abt_variabel set data_tabel=NULL where no_var=0100;;
update abt_variabel set data_kolom=NULL where no_var=0100;;
update abt_variabel set urutan_data=NULL where no_var=0100;;
update abt_variabel set referensi=NULL where no_var=0100;;
update abt_variabel set sql_query="select b.pekerjaan as data
from perkara_pihak1 a
join pihak b on a.pihak_id=b.id
where a.urutan=1 and a.perkara_id=#perkara_id#" where no_var=0100;;
update abt_variabel set default_data=NULL where no_var=0100;;
update abt_variabel set multi_sidang=NULL where no_var=0100;;
update abt_variabel set locked="1" where no_var=0100;;
update abt_variabel set modifier=NULL where no_var=0100;;
update abt_variabel set modified="2019-08-08 19:49:10" where no_var=0100;;


/*NOMOR VARIABEL 0101*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0101);;
update abt_variabel set nama="Alamat #0046#" where no_var=0101;;
update abt_variabel set data_type="data_sipp" where no_var=0101;;
update abt_variabel set data_tabel="perkara_pihak1" where no_var=0101;;
update abt_variabel set data_kolom="alamat " where no_var=0101;;
update abt_variabel set urutan_data="1" where no_var=0101;;
update abt_variabel set referensi=NULL where no_var=0101;;
update abt_variabel set sql_query=NULL where no_var=0101;;
update abt_variabel set default_data=NULL where no_var=0101;;
update abt_variabel set multi_sidang=NULL where no_var=0101;;
update abt_variabel set locked="1" where no_var=0101;;
update abt_variabel set modifier=NULL where no_var=0101;;
update abt_variabel set modified="2019-08-08 19:49:12" where no_var=0101;;


/*NOMOR VARIABEL 0102*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0102);;
update abt_variabel set nama="Nama #0047#" where no_var=0102;;
update abt_variabel set data_type="data_sipp" where no_var=0102;;
update abt_variabel set data_tabel="perkara_pihak2" where no_var=0102;;
update abt_variabel set data_kolom="nama" where no_var=0102;;
update abt_variabel set urutan_data="1" where no_var=0102;;
update abt_variabel set referensi=NULL where no_var=0102;;
update abt_variabel set sql_query=NULL where no_var=0102;;
update abt_variabel set default_data=NULL where no_var=0102;;
update abt_variabel set multi_sidang=NULL where no_var=0102;;
update abt_variabel set locked="1" where no_var=0102;;
update abt_variabel set modifier=NULL where no_var=0102;;
update abt_variabel set modified="2019-08-08 19:49:14" where no_var=0102;;


/*NOMOR VARIABEL 0103*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0103);;
update abt_variabel set nama="Umur #0047#" where no_var=0103;;
update abt_variabel set data_type="data_sql" where no_var=0103;;
update abt_variabel set data_tabel=NULL where no_var=0103;;
update abt_variabel set data_kolom=NULL where no_var=0103;;
update abt_variabel set urutan_data=NULL where no_var=0103;;
update abt_variabel set referensi=NULL where no_var=0103;;
update abt_variabel set sql_query="select (get_umur(b.tanggal_lahir,c.tanggal_pendaftaran))as data
from perkara_pihak2 a
join pihak b on a.pihak_id=b.id
join perkara c on a.perkara_id=c.perkara_id
where a.urutan=1 and a.perkara_id=#perkara_id#

" where no_var=0103;;
update abt_variabel set default_data=NULL where no_var=0103;;
update abt_variabel set multi_sidang=NULL where no_var=0103;;
update abt_variabel set locked="1" where no_var=0103;;
update abt_variabel set modifier="admin" where no_var=0103;;
update abt_variabel set modified="2019-08-09 06:00:02" where no_var=0103;;


/*NOMOR VARIABEL 0104*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0104);;
update abt_variabel set nama="Pekerjaan #0047#" where no_var=0104;;
update abt_variabel set data_type="data_sql" where no_var=0104;;
update abt_variabel set data_tabel=NULL where no_var=0104;;
update abt_variabel set data_kolom=NULL where no_var=0104;;
update abt_variabel set urutan_data=NULL where no_var=0104;;
update abt_variabel set referensi=NULL where no_var=0104;;
update abt_variabel set sql_query="select b.pekerjaan as data
from perkara_pihak2 a
join pihak b on a.pihak_id=b.id
where a.urutan=1 and a.perkara_id=#perkara_id#" where no_var=0104;;
update abt_variabel set default_data=NULL where no_var=0104;;
update abt_variabel set multi_sidang=NULL where no_var=0104;;
update abt_variabel set locked="1" where no_var=0104;;
update abt_variabel set modifier=NULL where no_var=0104;;
update abt_variabel set modified="2019-08-08 19:49:19" where no_var=0104;;


/*NOMOR VARIABEL 0105*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0105);;
update abt_variabel set nama="Alamat #0047#" where no_var=0105;;
update abt_variabel set data_type="data_sipp" where no_var=0105;;
update abt_variabel set data_tabel="perkara_pihak2" where no_var=0105;;
update abt_variabel set data_kolom="alamat" where no_var=0105;;
update abt_variabel set urutan_data="1" where no_var=0105;;
update abt_variabel set referensi=NULL where no_var=0105;;
update abt_variabel set sql_query=NULL where no_var=0105;;
update abt_variabel set default_data=NULL where no_var=0105;;
update abt_variabel set multi_sidang=NULL where no_var=0105;;
update abt_variabel set locked="1" where no_var=0105;;
update abt_variabel set modifier=NULL where no_var=0105;;
update abt_variabel set modified="2019-08-08 19:49:20" where no_var=0105;;


/*NOMOR VARIABEL 0106*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0106);;
update abt_variabel set nama="Nama Kuasa #0046#" where no_var=0106;;
update abt_variabel set data_type="data_sql" where no_var=0106;;
update abt_variabel set data_tabel=NULL where no_var=0106;;
update abt_variabel set data_kolom=NULL where no_var=0106;;
update abt_variabel set urutan_data=NULL where no_var=0106;;
update abt_variabel set referensi=NULL where no_var=0106;;
update abt_variabel set sql_query="select nama as data from perkara_pengacara
where pihak_ke=1 and urutan=1 and perkara_id=#perkara_id#" where no_var=0106;;
update abt_variabel set default_data=NULL where no_var=0106;;
update abt_variabel set multi_sidang=NULL where no_var=0106;;
update abt_variabel set locked="1" where no_var=0106;;
update abt_variabel set modifier=NULL where no_var=0106;;
update abt_variabel set modified="2019-08-08 19:49:21" where no_var=0106;;


/*NOMOR VARIABEL 0109*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0109);;
update abt_variabel set nama="Alamat Kuasa #0046#" where no_var=0109;;
update abt_variabel set data_type="data_sql" where no_var=0109;;
update abt_variabel set data_tabel=NULL where no_var=0109;;
update abt_variabel set data_kolom=NULL where no_var=0109;;
update abt_variabel set urutan_data=NULL where no_var=0109;;
update abt_variabel set referensi=NULL where no_var=0109;;
update abt_variabel set sql_query="select alamat as data from perkara_pengacara
where pihak_ke=1 and urutan=1 and perkara_id=#perkara_id#" where no_var=0109;;
update abt_variabel set default_data=NULL where no_var=0109;;
update abt_variabel set multi_sidang=NULL where no_var=0109;;
update abt_variabel set locked="1" where no_var=0109;;
update abt_variabel set modifier=NULL where no_var=0109;;
update abt_variabel set modified="2019-08-08 19:49:36" where no_var=0109;;


/*NOMOR VARIABEL 0111*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0111);;
update abt_variabel set nama="Tgl.Register Surat Kuasa #0046#" where no_var=0111;;
update abt_variabel set data_type="data_sql" where no_var=0111;;
update abt_variabel set data_tabel=NULL where no_var=0111;;
update abt_variabel set data_kolom=NULL where no_var=0111;;
update abt_variabel set urutan_data=NULL where no_var=0111;;
update abt_variabel set referensi=NULL where no_var=0111;;
update abt_variabel set sql_query="select tanggal_kuasa as data from perkara_pengacara
where pihak_ke=1 and urutan=1 and perkara_id=#perkara_id#" where no_var=0111;;
update abt_variabel set default_data=NULL where no_var=0111;;
update abt_variabel set multi_sidang=NULL where no_var=0111;;
update abt_variabel set locked="1" where no_var=0111;;
update abt_variabel set modifier=NULL where no_var=0111;;
update abt_variabel set modified="2019-08-08 19:49:40" where no_var=0111;;


/*NOMOR VARIABEL 0112*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0112);;
update abt_variabel set nama="Tgl.Register Surat Kuasa #0047#" where no_var=0112;;
update abt_variabel set data_type="data_sql" where no_var=0112;;
update abt_variabel set data_tabel=NULL where no_var=0112;;
update abt_variabel set data_kolom=NULL where no_var=0112;;
update abt_variabel set urutan_data=NULL where no_var=0112;;
update abt_variabel set referensi=NULL where no_var=0112;;
update abt_variabel set sql_query="select tanggal_kuasa as data from perkara_pengacara
where pihak_ke=2 and urutan=1 and perkara_id=#perkara_id#" where no_var=0112;;
update abt_variabel set default_data=NULL where no_var=0112;;
update abt_variabel set multi_sidang=NULL where no_var=0112;;
update abt_variabel set locked="1" where no_var=0112;;
update abt_variabel set modifier=NULL where no_var=0112;;
update abt_variabel set modified="2019-08-08 19:49:43" where no_var=0112;;


/*NOMOR VARIABEL 0118*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0118);;
update abt_variabel set nama="Tgl Relaas Ulang #0046#" where no_var=0118;;
update abt_variabel set data_type="data_sql" where no_var=0118;;
update abt_variabel set data_tabel=NULL where no_var=0118;;
update abt_variabel set data_kolom=NULL where no_var=0118;;
update abt_variabel set urutan_data=NULL where no_var=0118;;
update abt_variabel set referensi=NULL where no_var=0118;;
update abt_variabel set sql_query="select max(a.tanggal_relaas) data from perkara_pelaksanaan_relaas a
join v_pihak_perkara b on a.perkara_id=b.perkara_id and a.pihak_id=b.pihak_id
join perkara_jadwal_sidang c on a.perkara_id=c.perkara_id
where c.ikrar_talak=""T"" and b.urutan=1 and b.pihak_ke=1 and a.perkara_id=#perkara_id#" where no_var=0118;;
update abt_variabel set default_data=NULL where no_var=0118;;
update abt_variabel set multi_sidang=NULL where no_var=0118;;
update abt_variabel set locked="1" where no_var=0118;;
update abt_variabel set modifier=NULL where no_var=0118;;
update abt_variabel set modified="2019-09-15 12:39:52" where no_var=0118;;


/*NOMOR VARIABEL 0120*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0120);;
update abt_variabel set nama="Tgl Relaas Ulang #0047#" where no_var=0120;;
update abt_variabel set data_type="data_sql" where no_var=0120;;
update abt_variabel set data_tabel=NULL where no_var=0120;;
update abt_variabel set data_kolom=NULL where no_var=0120;;
update abt_variabel set urutan_data=NULL where no_var=0120;;
update abt_variabel set referensi=NULL where no_var=0120;;
update abt_variabel set sql_query="select max(a.tanggal_relaas) data from perkara_pelaksanaan_relaas a
join v_pihak_perkara b on a.perkara_id=b.perkara_id and a.pihak_id=b.pihak_id
join perkara_jadwal_sidang c on a.perkara_id=c.perkara_id
where c.ikrar_talak=""T"" and b.urutan=1 and b.pihak_ke=2 and a.perkara_id=#perkara_id#" where no_var=0120;;
update abt_variabel set default_data=NULL where no_var=0120;;
update abt_variabel set multi_sidang=NULL where no_var=0120;;
update abt_variabel set locked="1" where no_var=0120;;
update abt_variabel set modifier=NULL where no_var=0120;;
update abt_variabel set modified="2019-09-15 12:39:52" where no_var=0120;;


/*NOMOR VARIABEL 0121*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0121);;
update abt_variabel set nama="Hari Relaas Ulang #0046#" where no_var=0121;;
update abt_variabel set data_type="tanggal_hari" where no_var=0121;;
update abt_variabel set data_tabel=NULL where no_var=0121;;
update abt_variabel set data_kolom=NULL where no_var=0121;;
update abt_variabel set urutan_data=NULL where no_var=0121;;
update abt_variabel set referensi="0118" where no_var=0121;;
update abt_variabel set sql_query=NULL where no_var=0121;;
update abt_variabel set default_data=NULL where no_var=0121;;
update abt_variabel set multi_sidang=NULL where no_var=0121;;
update abt_variabel set locked="1" where no_var=0121;;
update abt_variabel set modifier=NULL where no_var=0121;;
update abt_variabel set modified="2019-08-08 19:50:07" where no_var=0121;;


/*NOMOR VARIABEL 0122*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0122);;
update abt_variabel set nama="Hari Relaas Ulang #0047#" where no_var=0122;;
update abt_variabel set data_type="tanggal_hari" where no_var=0122;;
update abt_variabel set data_tabel=NULL where no_var=0122;;
update abt_variabel set data_kolom=NULL where no_var=0122;;
update abt_variabel set urutan_data=NULL where no_var=0122;;
update abt_variabel set referensi="0120" where no_var=0122;;
update abt_variabel set sql_query=NULL where no_var=0122;;
update abt_variabel set default_data=NULL where no_var=0122;;
update abt_variabel set multi_sidang=NULL where no_var=0122;;
update abt_variabel set locked="1" where no_var=0122;;
update abt_variabel set modifier=NULL where no_var=0122;;
update abt_variabel set modified="2019-08-08 19:50:08" where no_var=0122;;


/*NOMOR VARIABEL 0124*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0124);;
update abt_variabel set nama="utk Ghoib" where no_var=0124;;
update abt_variabel set data_type="data_sql" where no_var=0124;;
update abt_variabel set data_tabel=NULL where no_var=0124;;
update abt_variabel set data_kolom=NULL where no_var=0124;;
update abt_variabel set urutan_data=NULL where no_var=0124;;
update abt_variabel set referensi=NULL where no_var=0124;;
update abt_variabel set sql_query="select (case

when locate(""dahulu"",""#0105#"")>0 then
""""

else
""tempat kediaman di ""

end)
as data" where no_var=0124;;
update abt_variabel set default_data=NULL where no_var=0124;;
update abt_variabel set multi_sidang=NULL where no_var=0124;;
update abt_variabel set locked="1" where no_var=0124;;
update abt_variabel set modifier=NULL where no_var=0124;;
update abt_variabel set modified="2019-08-08 19:50:13" where no_var=0124;;


/*NOMOR VARIABEL 0132*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0132);;
update abt_variabel set nama="Tgl. Kuasa #0046#" where no_var=0132;;
update abt_variabel set data_type="data_tanggal" where no_var=0132;;
update abt_variabel set data_tabel=NULL where no_var=0132;;
update abt_variabel set data_kolom=NULL where no_var=0132;;
update abt_variabel set urutan_data=NULL where no_var=0132;;
update abt_variabel set referensi=NULL where no_var=0132;;
update abt_variabel set sql_query=NULL where no_var=0132;;
update abt_variabel set default_data=NULL where no_var=0132;;
update abt_variabel set multi_sidang=NULL where no_var=0132;;
update abt_variabel set locked="1" where no_var=0132;;
update abt_variabel set modifier=NULL where no_var=0132;;
update abt_variabel set modified="2019-08-08 19:50:33" where no_var=0132;;


/*NOMOR VARIABEL 0133*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0133);;
update abt_variabel set nama="Hari Tunda Sidang" where no_var=0133;;
update abt_variabel set data_type="multi_sidang" where no_var=0133;;
update abt_variabel set data_tabel=NULL where no_var=0133;;
update abt_variabel set data_kolom=NULL where no_var=0133;;
update abt_variabel set urutan_data=NULL where no_var=0133;;
update abt_variabel set referensi=NULL where no_var=0133;;
update abt_variabel set sql_query=NULL where no_var=0133;;
update abt_variabel set default_data=NULL where no_var=0133;;
update abt_variabel set multi_sidang="hari_ditunda" where no_var=0133;;
update abt_variabel set locked="1" where no_var=0133;;
update abt_variabel set modifier=NULL where no_var=0133;;
update abt_variabel set modified="2019-08-08 19:50:31" where no_var=0133;;


/*NOMOR VARIABEL 0134*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0134);;
update abt_variabel set nama="Tgl Sidang Tunda" where no_var=0134;;
update abt_variabel set data_type="multi_sidang" where no_var=0134;;
update abt_variabel set data_tabel=NULL where no_var=0134;;
update abt_variabel set data_kolom=NULL where no_var=0134;;
update abt_variabel set urutan_data=NULL where no_var=0134;;
update abt_variabel set referensi=NULL where no_var=0134;;
update abt_variabel set sql_query=NULL where no_var=0134;;
update abt_variabel set default_data=NULL where no_var=0134;;
update abt_variabel set multi_sidang="tanggal_ditunda" where no_var=0134;;
update abt_variabel set locked="1" where no_var=0134;;
update abt_variabel set modifier=NULL where no_var=0134;;
update abt_variabel set modified="2019-08-08 19:50:37" where no_var=0134;;


/*NOMOR VARIABEL 0135*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0135);;
update abt_variabel set nama="Hari Sidang Pertama Ikrar Cerai Talak" where no_var=0135;;
update abt_variabel set data_type="tanggal_hari" where no_var=0135;;
update abt_variabel set data_tabel=NULL where no_var=0135;;
update abt_variabel set data_kolom=NULL where no_var=0135;;
update abt_variabel set urutan_data=NULL where no_var=0135;;
update abt_variabel set referensi="0144" where no_var=0135;;
update abt_variabel set sql_query=NULL where no_var=0135;;
update abt_variabel set default_data=NULL where no_var=0135;;
update abt_variabel set multi_sidang=NULL where no_var=0135;;
update abt_variabel set locked="1" where no_var=0135;;
update abt_variabel set modifier=NULL where no_var=0135;;
update abt_variabel set modified="2019-08-08 19:50:46" where no_var=0135;;


/*NOMOR VARIABEL 0136*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0136);;
update abt_variabel set nama="Tgl PMH Sidang Ikrar" where no_var=0136;;
update abt_variabel set data_type="data_sipp" where no_var=0136;;
update abt_variabel set data_tabel="perkara_ikrar_talak" where no_var=0136;;
update abt_variabel set data_kolom="penetapan_majelis_hakim" where no_var=0136;;
update abt_variabel set urutan_data=NULL where no_var=0136;;
update abt_variabel set referensi=NULL where no_var=0136;;
update abt_variabel set sql_query=NULL where no_var=0136;;
update abt_variabel set default_data=NULL where no_var=0136;;
update abt_variabel set multi_sidang=NULL where no_var=0136;;
update abt_variabel set locked="1" where no_var=0136;;
update abt_variabel set modifier=NULL where no_var=0136;;
update abt_variabel set modified="2019-08-08 19:50:50" where no_var=0136;;


/*NOMOR VARIABEL 0144*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0144);;
update abt_variabel set nama="Tgl Ikrar Talak Pertama" where no_var=0144;;
update abt_variabel set data_type="data_sipp" where no_var=0144;;
update abt_variabel set data_tabel="perkara_ikrar_talak" where no_var=0144;;
update abt_variabel set data_kolom="tanggal_sidang_pertama" where no_var=0144;;
update abt_variabel set urutan_data=NULL where no_var=0144;;
update abt_variabel set referensi=NULL where no_var=0144;;
update abt_variabel set sql_query=NULL where no_var=0144;;
update abt_variabel set default_data=NULL where no_var=0144;;
update abt_variabel set multi_sidang=NULL where no_var=0144;;
update abt_variabel set locked="1" where no_var=0144;;
update abt_variabel set modifier=NULL where no_var=0144;;
update abt_variabel set modified="2019-08-08 19:51:20" where no_var=0144;;


/*NOMOR VARIABEL 0146*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0146);;
update abt_variabel set nama="Kode Ketua Majelis" where no_var=0146;;
update abt_variabel set data_type="data_sql" where no_var=0146;;
update abt_variabel set data_tabel=NULL where no_var=0146;;
update abt_variabel set data_kolom=NULL where no_var=0146;;
update abt_variabel set urutan_data=NULL where no_var=0146;;
update abt_variabel set referensi=NULL where no_var=0146;;
update abt_variabel set sql_query="select hakim_kode as data
from perkara_hakim_pn 
where aktif=""Y"" and urutan=1 and perkara_id=#perkara_id#" where no_var=0146;;
update abt_variabel set default_data=NULL where no_var=0146;;
update abt_variabel set multi_sidang=NULL where no_var=0146;;
update abt_variabel set locked="1" where no_var=0146;;
update abt_variabel set modifier=NULL where no_var=0146;;
update abt_variabel set modified="2019-09-15 12:39:52" where no_var=0146;;


/*NOMOR VARIABEL 0147*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0147);;
update abt_variabel set nama="Kode Hakim Ang. 1" where no_var=0147;;
update abt_variabel set data_type="data_sql" where no_var=0147;;
update abt_variabel set data_tabel=NULL where no_var=0147;;
update abt_variabel set data_kolom=NULL where no_var=0147;;
update abt_variabel set urutan_data=NULL where no_var=0147;;
update abt_variabel set referensi=NULL where no_var=0147;;
update abt_variabel set sql_query="select hakim_kode as data
from perkara_hakim_pn 
where aktif=""Y"" and urutan=2 and perkara_id=#perkara_id#" where no_var=0147;;
update abt_variabel set default_data=NULL where no_var=0147;;
update abt_variabel set multi_sidang=NULL where no_var=0147;;
update abt_variabel set locked="1" where no_var=0147;;
update abt_variabel set modifier=NULL where no_var=0147;;
update abt_variabel set modified="2019-09-15 12:39:52" where no_var=0147;;


/*NOMOR VARIABEL 0148*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0148);;
update abt_variabel set nama="Kode Hakim Ang. 2" where no_var=0148;;
update abt_variabel set data_type="data_sql" where no_var=0148;;
update abt_variabel set data_tabel=NULL where no_var=0148;;
update abt_variabel set data_kolom=NULL where no_var=0148;;
update abt_variabel set urutan_data=NULL where no_var=0148;;
update abt_variabel set referensi=NULL where no_var=0148;;
update abt_variabel set sql_query="select hakim_kode as data
from perkara_hakim_pn 
where aktif=""Y"" and urutan=3 and perkara_id=#perkara_id#" where no_var=0148;;
update abt_variabel set default_data=NULL where no_var=0148;;
update abt_variabel set multi_sidang=NULL where no_var=0148;;
update abt_variabel set locked="1" where no_var=0148;;
update abt_variabel set modifier=NULL where no_var=0148;;
update abt_variabel set modified="2019-09-15 12:39:52" where no_var=0148;;


/*NOMOR VARIABEL 0150*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0150);;
update abt_variabel set nama="Zona Waktu" where no_var=0150;;
update abt_variabel set data_type="data_sql" where no_var=0150;;
update abt_variabel set data_tabel=NULL where no_var=0150;;
update abt_variabel set data_kolom=NULL where no_var=0150;;
update abt_variabel set urutan_data=NULL where no_var=0150;;
update abt_variabel set referensi=NULL where no_var=0150;;
update abt_variabel set sql_query="select value as data from sys_config
where name=""ZonaWaktu""" where no_var=0150;;
update abt_variabel set default_data=NULL where no_var=0150;;
update abt_variabel set multi_sidang=NULL where no_var=0150;;
update abt_variabel set locked="1" where no_var=0150;;
update abt_variabel set modifier=NULL where no_var=0150;;
update abt_variabel set modified="2019-09-15 12:39:52" where no_var=0150;;


/*NOMOR VARIABEL 0155*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0155);;
update abt_variabel set nama="Terbilang Biaya Perkara" where no_var=0155;;
update abt_variabel set data_type="terbilang" where no_var=0155;;
update abt_variabel set data_tabel=NULL where no_var=0155;;
update abt_variabel set data_kolom=NULL where no_var=0155;;
update abt_variabel set urutan_data=NULL where no_var=0155;;
update abt_variabel set referensi="0143" where no_var=0155;;
update abt_variabel set sql_query=NULL where no_var=0155;;
update abt_variabel set default_data=NULL where no_var=0155;;
update abt_variabel set multi_sidang=NULL where no_var=0155;;
update abt_variabel set locked="1" where no_var=0155;;
update abt_variabel set modifier=NULL where no_var=0155;;
update abt_variabel set modified="2019-08-08 19:51:49" where no_var=0155;;


/*NOMOR VARIABEL 0163*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0163);;
update abt_variabel set nama="Ruang Sidang" where no_var=0163;;
update abt_variabel set data_type="multi_sidang" where no_var=0163;;
update abt_variabel set data_tabel=NULL where no_var=0163;;
update abt_variabel set data_kolom=NULL where no_var=0163;;
update abt_variabel set urutan_data=NULL where no_var=0163;;
update abt_variabel set referensi=NULL where no_var=0163;;
update abt_variabel set sql_query=NULL where no_var=0163;;
update abt_variabel set default_data=NULL where no_var=0163;;
update abt_variabel set multi_sidang="ruangan" where no_var=0163;;
update abt_variabel set locked="1" where no_var=0163;;
update abt_variabel set modifier=NULL where no_var=0163;;
update abt_variabel set modified="2019-08-08 19:52:00" where no_var=0163;;


/*NOMOR VARIABEL 0164*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0164);;
update abt_variabel set nama="Nomor AC" where no_var=0164;;
update abt_variabel set data_type="data_sipp" where no_var=0164;;
update abt_variabel set data_tabel="perkara_akta_cerai" where no_var=0164;;
update abt_variabel set data_kolom="nomor_akta_cerai" where no_var=0164;;
update abt_variabel set urutan_data=NULL where no_var=0164;;
update abt_variabel set referensi=NULL where no_var=0164;;
update abt_variabel set sql_query=NULL where no_var=0164;;
update abt_variabel set default_data=NULL where no_var=0164;;
update abt_variabel set multi_sidang=NULL where no_var=0164;;
update abt_variabel set locked="1" where no_var=0164;;
update abt_variabel set modifier=NULL where no_var=0164;;
update abt_variabel set modified="2019-08-08 19:51:58" where no_var=0164;;


/*NOMOR VARIABEL 0166*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0166);;
update abt_variabel set nama="Agama Kuasa #0046#" where no_var=0166;;
update abt_variabel set data_type="data_sql" where no_var=0166;;
update abt_variabel set data_tabel=NULL where no_var=0166;;
update abt_variabel set data_kolom=NULL where no_var=0166;;
update abt_variabel set urutan_data=NULL where no_var=0166;;
update abt_variabel set referensi=NULL where no_var=0166;;
update abt_variabel set sql_query="select c.nama as data
from perkara_pengacara a
join pihak b on a.pengacara_id=b.id
join agama c on b.agama_id=c.id
where a.pihak_ke=1 and a.urutan=1 and a.perkara_id=#perkara_id#" where no_var=0166;;
update abt_variabel set default_data="Islam" where no_var=0166;;
update abt_variabel set multi_sidang=NULL where no_var=0166;;
update abt_variabel set locked="1" where no_var=0166;;
update abt_variabel set modifier=NULL where no_var=0166;;
update abt_variabel set modified="2019-08-08 19:52:04" where no_var=0166;;


/*NOMOR VARIABEL 0167*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0167);;
update abt_variabel set nama="Hari BHT" where no_var=0167;;
update abt_variabel set data_type="tanggal_hari" where no_var=0167;;
update abt_variabel set data_tabel=NULL where no_var=0167;;
update abt_variabel set data_kolom=NULL where no_var=0167;;
update abt_variabel set urutan_data=NULL where no_var=0167;;
update abt_variabel set referensi="0168" where no_var=0167;;
update abt_variabel set sql_query=NULL where no_var=0167;;
update abt_variabel set default_data=NULL where no_var=0167;;
update abt_variabel set multi_sidang=NULL where no_var=0167;;
update abt_variabel set locked="1" where no_var=0167;;
update abt_variabel set modifier="admin" where no_var=0167;;
update abt_variabel set modified="2019-09-15 12:19:29" where no_var=0167;;


/*NOMOR VARIABEL 0168*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0168);;
update abt_variabel set nama="Tgl BHT" where no_var=0168;;
update abt_variabel set data_type="data_sipp" where no_var=0168;;
update abt_variabel set data_tabel="perkara_putusan" where no_var=0168;;
update abt_variabel set data_kolom="tanggal_bht" where no_var=0168;;
update abt_variabel set urutan_data=NULL where no_var=0168;;
update abt_variabel set referensi=NULL where no_var=0168;;
update abt_variabel set sql_query=NULL where no_var=0168;;
update abt_variabel set default_data=NULL where no_var=0168;;
update abt_variabel set multi_sidang=NULL where no_var=0168;;
update abt_variabel set locked="1" where no_var=0168;;
update abt_variabel set modifier=NULL where no_var=0168;;
update abt_variabel set modified="2019-08-08 19:52:08" where no_var=0168;;


/*NOMOR VARIABEL 0170*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0170);;
update abt_variabel set nama="Nama Kuasa #0047#" where no_var=0170;;
update abt_variabel set data_type="data_sql" where no_var=0170;;
update abt_variabel set data_tabel=NULL where no_var=0170;;
update abt_variabel set data_kolom=NULL where no_var=0170;;
update abt_variabel set urutan_data=NULL where no_var=0170;;
update abt_variabel set referensi=NULL where no_var=0170;;
update abt_variabel set sql_query="select nama as data from perkara_pengacara
where pihak_ke=2 and urutan=1 and perkara_id=#perkara_id#" where no_var=0170;;
update abt_variabel set default_data=NULL where no_var=0170;;
update abt_variabel set multi_sidang=NULL where no_var=0170;;
update abt_variabel set locked="1" where no_var=0170;;
update abt_variabel set modifier=NULL where no_var=0170;;
update abt_variabel set modified="2019-08-08 19:52:11" where no_var=0170;;


/*NOMOR VARIABEL 0173*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0173);;
update abt_variabel set nama="Alamat Kuasa #0047#" where no_var=0173;;
update abt_variabel set data_type="data_sql" where no_var=0173;;
update abt_variabel set data_tabel=NULL where no_var=0173;;
update abt_variabel set data_kolom=NULL where no_var=0173;;
update abt_variabel set urutan_data=NULL where no_var=0173;;
update abt_variabel set referensi=NULL where no_var=0173;;
update abt_variabel set sql_query="select alamat as data from perkara_pengacara
where pihak_ke=2 and urutan=1 and perkara_id=#perkara_id#" where no_var=0173;;
update abt_variabel set default_data=NULL where no_var=0173;;
update abt_variabel set multi_sidang=NULL where no_var=0173;;
update abt_variabel set locked="1" where no_var=0173;;
update abt_variabel set modifier=NULL where no_var=0173;;
update abt_variabel set modified="2019-08-08 19:52:16" where no_var=0173;;


/*NOMOR VARIABEL 0180*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0180);;
update abt_variabel set nama="Tgl Penetapan Penunjukan PP/JSP" where no_var=0180;;
update abt_variabel set data_type="data_sipp" where no_var=0180;;
update abt_variabel set data_tabel="perkara_penetapan" where no_var=0180;;
update abt_variabel set data_kolom="penetapan_panitera_pengganti" where no_var=0180;;
update abt_variabel set urutan_data=NULL where no_var=0180;;
update abt_variabel set referensi=NULL where no_var=0180;;
update abt_variabel set sql_query=NULL where no_var=0180;;
update abt_variabel set default_data=NULL where no_var=0180;;
update abt_variabel set multi_sidang=NULL where no_var=0180;;
update abt_variabel set locked="1" where no_var=0180;;
update abt_variabel set modifier=NULL where no_var=0180;;
update abt_variabel set modified="2019-08-08 19:52:20" where no_var=0180;;


/*NOMOR VARIABEL 0191*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0191);;
update abt_variabel set nama="Tahun Perkara" where no_var=0191;;
update abt_variabel set data_type="data_sipp" where no_var=0191;;
update abt_variabel set data_tabel="v_perkara" where no_var=0191;;
update abt_variabel set data_kolom="tahun_pendaftaran" where no_var=0191;;
update abt_variabel set urutan_data=NULL where no_var=0191;;
update abt_variabel set referensi=NULL where no_var=0191;;
update abt_variabel set sql_query=NULL where no_var=0191;;
update abt_variabel set default_data=NULL where no_var=0191;;
update abt_variabel set multi_sidang=NULL where no_var=0191;;
update abt_variabel set locked="1" where no_var=0191;;
update abt_variabel set modifier=NULL where no_var=0191;;
update abt_variabel set modified="2019-08-08 19:53:00" where no_var=0191;;


/*NOMOR VARIABEL 0193*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0193);;
update abt_variabel set nama="Tgl. Sidang II" where no_var=0193;;
update abt_variabel set data_type="data_sipp" where no_var=0193;;
update abt_variabel set data_tabel="perkara_jadwal_sidang" where no_var=0193;;
update abt_variabel set data_kolom="tanggal_sidang" where no_var=0193;;
update abt_variabel set urutan_data="2" where no_var=0193;;
update abt_variabel set referensi=NULL where no_var=0193;;
update abt_variabel set sql_query=NULL where no_var=0193;;
update abt_variabel set default_data=NULL where no_var=0193;;
update abt_variabel set multi_sidang=NULL where no_var=0193;;
update abt_variabel set locked="1" where no_var=0193;;
update abt_variabel set modifier=NULL where no_var=0193;;
update abt_variabel set modified="2019-08-08 19:53:10" where no_var=0193;;


/*NOMOR VARIABEL 0194*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0194);;
update abt_variabel set nama="putusan/ penetapan" where no_var=0194;;
update abt_variabel set data_type="data_sql" where no_var=0194;;
update abt_variabel set data_tabel=NULL where no_var=0194;;
update abt_variabel set data_kolom=NULL where no_var=0194;;
update abt_variabel set urutan_data=NULL where no_var=0194;;
update abt_variabel set referensi=NULL where no_var=0194;;
update abt_variabel set sql_query="select (case when alur_perkara_id=16 then ""penetapan""
else ""putusan"" end) as data
from perkara where perkara_id=#perkara_id#" where no_var=0194;;
update abt_variabel set default_data=NULL where no_var=0194;;
update abt_variabel set multi_sidang=NULL where no_var=0194;;
update abt_variabel set locked="1" where no_var=0194;;
update abt_variabel set modifier=NULL where no_var=0194;;
update abt_variabel set modified="2019-08-08 19:53:12" where no_var=0194;;


/*NOMOR VARIABEL 0197*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0197);;
update abt_variabel set nama="No. Reg. Surat Kuasa #0046#" where no_var=0197;;
update abt_variabel set data_type="data_sql" where no_var=0197;;
update abt_variabel set data_tabel=NULL where no_var=0197;;
update abt_variabel set data_kolom=NULL where no_var=0197;;
update abt_variabel set urutan_data=NULL where no_var=0197;;
update abt_variabel set referensi=NULL where no_var=0197;;
update abt_variabel set sql_query="select nomor_kuasa as data from perkara_pengacara
where pihak_ke=1 and urutan=1 and perkara_id=#perkara_id#" where no_var=0197;;
update abt_variabel set default_data=NULL where no_var=0197;;
update abt_variabel set multi_sidang=NULL where no_var=0197;;
update abt_variabel set locked="1" where no_var=0197;;
update abt_variabel set modifier=NULL where no_var=0197;;
update abt_variabel set modified="2019-08-08 19:53:19" where no_var=0197;;


/*NOMOR VARIABEL 0198*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0198);;
update abt_variabel set nama="No. Reg. Surat Kuasa #0047#" where no_var=0198;;
update abt_variabel set data_type="data_sql" where no_var=0198;;
update abt_variabel set data_tabel=NULL where no_var=0198;;
update abt_variabel set data_kolom=NULL where no_var=0198;;
update abt_variabel set urutan_data=NULL where no_var=0198;;
update abt_variabel set referensi=NULL where no_var=0198;;
update abt_variabel set sql_query="select nomor_kuasa as data from perkara_pengacara
where pihak_ke=2 and urutan=1 and perkara_id=#perkara_id#" where no_var=0198;;
update abt_variabel set default_data=NULL where no_var=0198;;
update abt_variabel set multi_sidang=NULL where no_var=0198;;
update abt_variabel set locked="1" where no_var=0198;;
update abt_variabel set modifier=NULL where no_var=0198;;
update abt_variabel set modified="2019-08-08 19:53:20" where no_var=0198;;


/*NOMOR VARIABEL 0211*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0211);;
update abt_variabel set nama="Alasan Penggantian Majelis Hakim" where no_var=0211;;
update abt_variabel set data_type="data_sql" where no_var=0211;;
update abt_variabel set data_tabel=NULL where no_var=0211;;
update abt_variabel set data_kolom=NULL where no_var=0211;;
update abt_variabel set urutan_data=NULL where no_var=0211;;
update abt_variabel set referensi=NULL where no_var=0211;;
update abt_variabel set sql_query="select keterangan as data from perkara_hakim_pn
where aktif=""Y"" and urutan=1 and perkara_id=#perkara_id#" where no_var=0211;;
update abt_variabel set default_data=NULL where no_var=0211;;
update abt_variabel set multi_sidang=NULL where no_var=0211;;
update abt_variabel set locked="1" where no_var=0211;;
update abt_variabel set modifier=NULL where no_var=0211;;
update abt_variabel set modified="2019-08-08 19:53:26" where no_var=0211;;


/*NOMOR VARIABEL 0212*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0212);;
update abt_variabel set nama="Alasan Penggantian Panitera/PP" where no_var=0212;;
update abt_variabel set data_type="data_sql" where no_var=0212;;
update abt_variabel set data_tabel=NULL where no_var=0212;;
update abt_variabel set data_kolom=NULL where no_var=0212;;
update abt_variabel set urutan_data=NULL where no_var=0212;;
update abt_variabel set referensi=NULL where no_var=0212;;
update abt_variabel set sql_query="select keterangan as data from perkara_panitera_pn
where aktif=""Y"" and urutan=1 and perkara_id=#perkara_id#" where no_var=0212;;
update abt_variabel set default_data=NULL where no_var=0212;;
update abt_variabel set multi_sidang=NULL where no_var=0212;;
update abt_variabel set locked="1" where no_var=0212;;
update abt_variabel set modifier=NULL where no_var=0212;;
update abt_variabel set modified="2019-08-08 19:53:28" where no_var=0212;;


/*NOMOR VARIABEL 0213*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0213);;
update abt_variabel set nama="Alasan Penggantian Jurusita/JSP" where no_var=0213;;
update abt_variabel set data_type="data_sql" where no_var=0213;;
update abt_variabel set data_tabel=NULL where no_var=0213;;
update abt_variabel set data_kolom=NULL where no_var=0213;;
update abt_variabel set urutan_data=NULL where no_var=0213;;
update abt_variabel set referensi=NULL where no_var=0213;;
update abt_variabel set sql_query="select keterangan as data from perkara_jurusita
where aktif=""Y"" and urutan=1 and perkara_id=#perkara_id#" where no_var=0213;;
update abt_variabel set default_data=NULL where no_var=0213;;
update abt_variabel set multi_sidang=NULL where no_var=0213;;
update abt_variabel set locked="1" where no_var=0213;;
update abt_variabel set modifier=NULL where no_var=0213;;
update abt_variabel set modified="2019-08-08 19:53:29" where no_var=0213;;


/*NOMOR VARIABEL 0214*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0214);;
update abt_variabel set nama="Alasan Penggantian Hari Sidang" where no_var=0214;;
update abt_variabel set data_type="data_sql" where no_var=0214;;
update abt_variabel set data_tabel=NULL where no_var=0214;;
update abt_variabel set data_kolom=NULL where no_var=0214;;
update abt_variabel set urutan_data=NULL where no_var=0214;;
update abt_variabel set referensi=NULL where no_var=0214;;
update abt_variabel set sql_query="select SUBSTRING_INDEX(keterangan,""Alasan"",-1) as data from perkara_penetapan_hari_sidang
where perkara_id=#perkara_id# and tanggal_penetapan=""#1136#""" where no_var=0214;;
update abt_variabel set default_data=NULL where no_var=0214;;
update abt_variabel set multi_sidang=NULL where no_var=0214;;
update abt_variabel set locked="1" where no_var=0214;;
update abt_variabel set modifier=NULL where no_var=0214;;
update abt_variabel set modified="2019-08-08 19:53:31" where no_var=0214;;


/*NOMOR VARIABEL 0215*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0215);;
update abt_variabel set nama="Tgl. Penetapan JSP awal" where no_var=0215;;
update abt_variabel set data_type="data_sql" where no_var=0215;;
update abt_variabel set data_tabel=NULL where no_var=0215;;
update abt_variabel set data_kolom=NULL where no_var=0215;;
update abt_variabel set urutan_data=NULL where no_var=0215;;
update abt_variabel set referensi=NULL where no_var=0215;;
update abt_variabel set sql_query="select tanggal as data from perkara_proses
where proses_id=40 and perkara_id=#perkara_id#" where no_var=0215;;
update abt_variabel set default_data=NULL where no_var=0215;;
update abt_variabel set multi_sidang=NULL where no_var=0215;;
update abt_variabel set locked="1" where no_var=0215;;
update abt_variabel set modifier=NULL where no_var=0215;;
update abt_variabel set modified="2019-08-08 19:53:33" where no_var=0215;;


/*NOMOR VARIABEL 0216*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0216);;
update abt_variabel set nama="Tgl. Penetapan JSP baru" where no_var=0216;;
update abt_variabel set data_type="data_sql" where no_var=0216;;
update abt_variabel set data_tabel=NULL where no_var=0216;;
update abt_variabel set data_kolom=NULL where no_var=0216;;
update abt_variabel set urutan_data=NULL where no_var=0216;;
update abt_variabel set referensi=NULL where no_var=0216;;
update abt_variabel set sql_query="select tanggal as data from perkara_proses
where proses_id=41 and perkara_id=#perkara_id#" where no_var=0216;;
update abt_variabel set default_data=NULL where no_var=0216;;
update abt_variabel set multi_sidang=NULL where no_var=0216;;
update abt_variabel set locked="1" where no_var=0216;;
update abt_variabel set modifier=NULL where no_var=0216;;
update abt_variabel set modified="2019-08-08 19:53:34" where no_var=0216;;


/*NOMOR VARIABEL 0252*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0252);;
update abt_variabel set nama="Terhitung Biaya Permintaan Bantuan" where no_var=0252;;
update abt_variabel set data_type="terbilang" where no_var=0252;;
update abt_variabel set data_tabel=NULL where no_var=0252;;
update abt_variabel set data_kolom=NULL where no_var=0252;;
update abt_variabel set urutan_data=NULL where no_var=0252;;
update abt_variabel set referensi="5230" where no_var=0252;;
update abt_variabel set sql_query=NULL where no_var=0252;;
update abt_variabel set default_data=NULL where no_var=0252;;
update abt_variabel set multi_sidang=NULL where no_var=0252;;
update abt_variabel set locked="1" where no_var=0252;;
update abt_variabel set modifier=NULL where no_var=0252;;
update abt_variabel set modified="2019-08-08 19:53:44" where no_var=0252;;


/*NOMOR VARIABEL 0302*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0302);;
update abt_variabel set nama="Hijriah Sidang Ikrar Talak" where no_var=0302;;
update abt_variabel set data_type="tanggal_hijriah" where no_var=0302;;
update abt_variabel set data_tabel=NULL where no_var=0302;;
update abt_variabel set data_kolom=NULL where no_var=0302;;
update abt_variabel set urutan_data=NULL where no_var=0302;;
update abt_variabel set referensi="1182" where no_var=0302;;
update abt_variabel set sql_query=NULL where no_var=0302;;
update abt_variabel set default_data=NULL where no_var=0302;;
update abt_variabel set multi_sidang=NULL where no_var=0302;;
update abt_variabel set locked="1" where no_var=0302;;
update abt_variabel set modifier=NULL where no_var=0302;;
update abt_variabel set modified="2019-08-08 19:54:32" where no_var=0302;;


/*NOMOR VARIABEL 0310*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0310);;
update abt_variabel set nama="Biaya Panggil 1x #0046#" where no_var=0310;;
update abt_variabel set data_type="data_sql" where no_var=0310;;
update abt_variabel set data_tabel=NULL where no_var=0310;;
update abt_variabel set data_kolom=NULL where no_var=0310;;
update abt_variabel set urutan_data=NULL where no_var=0310;;
update abt_variabel set referensi=NULL where no_var=0310;;
update abt_variabel set sql_query="select max(jumlah) as data from perkara_biaya
where 
jenis_biaya_id=13 and  perkara_id=#perkara_id#
or
jenis_biaya_id=12 and  perkara_id=#perkara_id#" where no_var=0310;;
update abt_variabel set default_data=NULL where no_var=0310;;
update abt_variabel set multi_sidang=NULL where no_var=0310;;
update abt_variabel set locked="1" where no_var=0310;;
update abt_variabel set modifier=NULL where no_var=0310;;
update abt_variabel set modified="2019-08-08 19:54:57" where no_var=0310;;


/*NOMOR VARIABEL 0311*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0311);;
update abt_variabel set nama="Biaya Panggil 1x #0047#" where no_var=0311;;
update abt_variabel set data_type="data_sql" where no_var=0311;;
update abt_variabel set data_tabel=NULL where no_var=0311;;
update abt_variabel set data_kolom=NULL where no_var=0311;;
update abt_variabel set urutan_data=NULL where no_var=0311;;
update abt_variabel set referensi=NULL where no_var=0311;;
update abt_variabel set sql_query="select max(jumlah) as data from perkara_biaya
where
jenis_biaya_id=14 and perkara_id=#perkara_id#
or
jenis_biaya_id=15 and perkara_id=#perkara_id#" where no_var=0311;;
update abt_variabel set default_data=NULL where no_var=0311;;
update abt_variabel set multi_sidang=NULL where no_var=0311;;
update abt_variabel set locked="1" where no_var=0311;;
update abt_variabel set modifier=NULL where no_var=0311;;
update abt_variabel set modified="2019-08-08 19:55:15" where no_var=0311;;


/*NOMOR VARIABEL 0312*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0312);;
update abt_variabel set nama="Biaya Panggil #0046# + #0047#" where no_var=0312;;
update abt_variabel set data_type="data_sql" where no_var=0312;;
update abt_variabel set data_tabel=NULL where no_var=0312;;
update abt_variabel set data_kolom=NULL where no_var=0312;;
update abt_variabel set urutan_data=NULL where no_var=0312;;
update abt_variabel set referensi=NULL where no_var=0312;;
update abt_variabel set sql_query="select (0#1091# + 0#1092#)
as data" where no_var=0312;;
update abt_variabel set default_data=NULL where no_var=0312;;
update abt_variabel set multi_sidang=NULL where no_var=0312;;
update abt_variabel set locked="1" where no_var=0312;;
update abt_variabel set modifier=NULL where no_var=0312;;
update abt_variabel set modified="2019-08-08 19:55:16" where no_var=0312;;


/*NOMOR VARIABEL 0335*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0335);;
update abt_variabel set nama="No. NIK #0046#" where no_var=0335;;
update abt_variabel set data_type="data_sql" where no_var=0335;;
update abt_variabel set data_tabel=NULL where no_var=0335;;
update abt_variabel set data_kolom=NULL where no_var=0335;;
update abt_variabel set urutan_data=NULL where no_var=0335;;
update abt_variabel set referensi=NULL where no_var=0335;;
update abt_variabel set sql_query="select b.nomor_indentitas as data from perkara_pihak1 a
join pihak b on a.pihak_id=b.id
where a.urutan=1 and a.perkara_id=#perkara_id#" where no_var=0335;;
update abt_variabel set default_data=NULL where no_var=0335;;
update abt_variabel set multi_sidang=NULL where no_var=0335;;
update abt_variabel set locked="1" where no_var=0335;;
update abt_variabel set modifier=NULL where no_var=0335;;
update abt_variabel set modified="2019-08-08 19:55:38" where no_var=0335;;


/*NOMOR VARIABEL 0336*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0336);;
update abt_variabel set nama="No. NIK #0046# II" where no_var=0336;;
update abt_variabel set data_type="data_sql" where no_var=0336;;
update abt_variabel set data_tabel=NULL where no_var=0336;;
update abt_variabel set data_kolom=NULL where no_var=0336;;
update abt_variabel set urutan_data=NULL where no_var=0336;;
update abt_variabel set referensi=NULL where no_var=0336;;
update abt_variabel set sql_query="select b.nomor_indentitas as data from perkara_pihak1 a
join pihak b on a.pihak_id=b.id
where a.urutan=2 and a.perkara_id=#perkara_id#" where no_var=0336;;
update abt_variabel set default_data=NULL where no_var=0336;;
update abt_variabel set multi_sidang=NULL where no_var=0336;;
update abt_variabel set locked="1" where no_var=0336;;
update abt_variabel set modifier=NULL where no_var=0336;;
update abt_variabel set modified="2019-08-08 19:55:39" where no_var=0336;;


/*NOMOR VARIABEL 0337*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0337);;
update abt_variabel set nama="No. NIK #0047#" where no_var=0337;;
update abt_variabel set data_type="data_sql" where no_var=0337;;
update abt_variabel set data_tabel=NULL where no_var=0337;;
update abt_variabel set data_kolom=NULL where no_var=0337;;
update abt_variabel set urutan_data=NULL where no_var=0337;;
update abt_variabel set referensi=NULL where no_var=0337;;
update abt_variabel set sql_query="select b.nomor_indentitas as data from perkara_pihak2 a
join pihak b on a.pihak_id=b.id
where a.urutan=1 and a.perkara_id=#perkara_id#" where no_var=0337;;
update abt_variabel set default_data=NULL where no_var=0337;;
update abt_variabel set multi_sidang=NULL where no_var=0337;;
update abt_variabel set locked="1" where no_var=0337;;
update abt_variabel set modifier=NULL where no_var=0337;;
update abt_variabel set modified="2019-08-08 19:55:40" where no_var=0337;;


/*NOMOR VARIABEL 0341*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0341);;
update abt_variabel set nama="Tempat Lahir #0046# " where no_var=0341;;
update abt_variabel set data_type="data_sql" where no_var=0341;;
update abt_variabel set data_tabel=NULL where no_var=0341;;
update abt_variabel set data_kolom=NULL where no_var=0341;;
update abt_variabel set urutan_data=NULL where no_var=0341;;
update abt_variabel set referensi=NULL where no_var=0341;;
update abt_variabel set sql_query="select b.tempat_lahir as data
from perkara_pihak1 a join pihak b on a.pihak_id=b.id
where a.urutan=1 and a.perkara_id=#perkara_id#" where no_var=0341;;
update abt_variabel set default_data=NULL where no_var=0341;;
update abt_variabel set multi_sidang=NULL where no_var=0341;;
update abt_variabel set locked="1" where no_var=0341;;
update abt_variabel set modifier=NULL where no_var=0341;;
update abt_variabel set modified="2019-08-08 19:55:48" where no_var=0341;;


/*NOMOR VARIABEL 0342*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0342);;
update abt_variabel set nama="Tempat Lahir #0046# II" where no_var=0342;;
update abt_variabel set data_type="data_sql" where no_var=0342;;
update abt_variabel set data_tabel=NULL where no_var=0342;;
update abt_variabel set data_kolom=NULL where no_var=0342;;
update abt_variabel set urutan_data=NULL where no_var=0342;;
update abt_variabel set referensi=NULL where no_var=0342;;
update abt_variabel set sql_query="select b.tempat_lahir as data
from perkara_pihak1 a join pihak b on a.pihak_id=b.id
where a.urutan=2 and a.perkara_id=#perkara_id#" where no_var=0342;;
update abt_variabel set default_data=NULL where no_var=0342;;
update abt_variabel set multi_sidang=NULL where no_var=0342;;
update abt_variabel set locked="1" where no_var=0342;;
update abt_variabel set modifier=NULL where no_var=0342;;
update abt_variabel set modified="2019-08-08 19:55:49" where no_var=0342;;


/*NOMOR VARIABEL 0343*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0343);;
update abt_variabel set nama="Tempat Lahir #0047#" where no_var=0343;;
update abt_variabel set data_type="data_sql" where no_var=0343;;
update abt_variabel set data_tabel=NULL where no_var=0343;;
update abt_variabel set data_kolom=NULL where no_var=0343;;
update abt_variabel set urutan_data=NULL where no_var=0343;;
update abt_variabel set referensi=NULL where no_var=0343;;
update abt_variabel set sql_query="select b.tempat_lahir as data
from perkara_pihak2 a join pihak b on a.pihak_id=b.id
where a.urutan=1 and a.perkara_id=#perkara_id#" where no_var=0343;;
update abt_variabel set default_data=NULL where no_var=0343;;
update abt_variabel set multi_sidang=NULL where no_var=0343;;
update abt_variabel set locked="1" where no_var=0343;;
update abt_variabel set modifier=NULL where no_var=0343;;
update abt_variabel set modified="2019-08-08 19:55:50" where no_var=0343;;


/*NOMOR VARIABEL 0345*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0345);;
update abt_variabel set nama="Tgl. Lahir #0046#" where no_var=0345;;
update abt_variabel set data_type="data_sql" where no_var=0345;;
update abt_variabel set data_tabel=NULL where no_var=0345;;
update abt_variabel set data_kolom=NULL where no_var=0345;;
update abt_variabel set urutan_data=NULL where no_var=0345;;
update abt_variabel set referensi=NULL where no_var=0345;;
update abt_variabel set sql_query="select b.tanggal_lahir as data
from perkara_pihak1 a join pihak b on a.pihak_id=b.id
where a.urutan=1 and a.perkara_id=#perkara_id#" where no_var=0345;;
update abt_variabel set default_data=NULL where no_var=0345;;
update abt_variabel set multi_sidang=NULL where no_var=0345;;
update abt_variabel set locked="1" where no_var=0345;;
update abt_variabel set modifier=NULL where no_var=0345;;
update abt_variabel set modified="2019-08-08 19:55:54" where no_var=0345;;


/*NOMOR VARIABEL 0346*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0346);;
update abt_variabel set nama="Tgl. Lahir #0046# II" where no_var=0346;;
update abt_variabel set data_type="data_sql" where no_var=0346;;
update abt_variabel set data_tabel=NULL where no_var=0346;;
update abt_variabel set data_kolom=NULL where no_var=0346;;
update abt_variabel set urutan_data=NULL where no_var=0346;;
update abt_variabel set referensi=NULL where no_var=0346;;
update abt_variabel set sql_query="select b.tanggal_lahir as data
from perkara_pihak1 a join pihak b on a.pihak_id=b.id
where a.urutan=2 and a.perkara_id=#perkara_id#" where no_var=0346;;
update abt_variabel set default_data=NULL where no_var=0346;;
update abt_variabel set multi_sidang=NULL where no_var=0346;;
update abt_variabel set locked="1" where no_var=0346;;
update abt_variabel set modifier=NULL where no_var=0346;;
update abt_variabel set modified="2019-08-08 19:55:55" where no_var=0346;;


/*NOMOR VARIABEL 0347*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0347);;
update abt_variabel set nama="Tgl. Lahir #0047#" where no_var=0347;;
update abt_variabel set data_type="data_sql" where no_var=0347;;
update abt_variabel set data_tabel=NULL where no_var=0347;;
update abt_variabel set data_kolom=NULL where no_var=0347;;
update abt_variabel set urutan_data=NULL where no_var=0347;;
update abt_variabel set referensi=NULL where no_var=0347;;
update abt_variabel set sql_query="select b.tanggal_lahir as data
from perkara_pihak2 a join pihak b on a.pihak_id=b.id
where a.urutan=1 and a.perkara_id=#perkara_id#" where no_var=0347;;
update abt_variabel set default_data=NULL where no_var=0347;;
update abt_variabel set multi_sidang=NULL where no_var=0347;;
update abt_variabel set locked="1" where no_var=0347;;
update abt_variabel set modifier=NULL where no_var=0347;;
update abt_variabel set modified="2019-08-08 19:55:56" where no_var=0347;;


/*NOMOR VARIABEL 0350*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0350);;
update abt_variabel set nama="Tempat Lahir Saksi 1 P" where no_var=0350;;
update abt_variabel set data_type="data_sql" where no_var=0350;;
update abt_variabel set data_tabel=NULL where no_var=0350;;
update abt_variabel set data_kolom=NULL where no_var=0350;;
update abt_variabel set urutan_data=NULL where no_var=0350;;
update abt_variabel set referensi=NULL where no_var=0350;;
update abt_variabel set sql_query="select b.tempat_lahir as data
from perkara_pihak5 a
join pihak b on a.pihak_id=b.id
where a.saksi_pihak_ke=1 and a.perkara_id=#perkara_id#
order by a.urutan
limit 0,1" where no_var=0350;;
update abt_variabel set default_data=NULL where no_var=0350;;
update abt_variabel set multi_sidang=NULL where no_var=0350;;
update abt_variabel set locked="1" where no_var=0350;;
update abt_variabel set modifier=NULL where no_var=0350;;
update abt_variabel set modified="2019-08-08 19:56:05" where no_var=0350;;


/*NOMOR VARIABEL 0351*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0351);;
update abt_variabel set nama="Tgl. Lahir Saksi 1 P" where no_var=0351;;
update abt_variabel set data_type="data_sql" where no_var=0351;;
update abt_variabel set data_tabel=NULL where no_var=0351;;
update abt_variabel set data_kolom=NULL where no_var=0351;;
update abt_variabel set urutan_data=NULL where no_var=0351;;
update abt_variabel set referensi=NULL where no_var=0351;;
update abt_variabel set sql_query="select b.tanggal_lahir as data
from perkara_pihak5 a
join pihak b on a.pihak_id=b.id
where a.saksi_pihak_ke=1 and a.perkara_id=#perkara_id#
order by a.urutan
limit 0,1" where no_var=0351;;
update abt_variabel set default_data=NULL where no_var=0351;;
update abt_variabel set multi_sidang=NULL where no_var=0351;;
update abt_variabel set locked="1" where no_var=0351;;
update abt_variabel set modifier=NULL where no_var=0351;;
update abt_variabel set modified="2019-08-08 19:56:06" where no_var=0351;;


/*NOMOR VARIABEL 0352*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0352);;
update abt_variabel set nama="No. NIK Saksi 1 P" where no_var=0352;;
update abt_variabel set data_type="data_sql" where no_var=0352;;
update abt_variabel set data_tabel=NULL where no_var=0352;;
update abt_variabel set data_kolom=NULL where no_var=0352;;
update abt_variabel set urutan_data=NULL where no_var=0352;;
update abt_variabel set referensi=NULL where no_var=0352;;
update abt_variabel set sql_query="select b.nomor_indentitas as data
from perkara_pihak5 a
join pihak b on a.pihak_id=b.id
where b.jenis_indentitas=4 and
a.saksi_pihak_ke=1 and a.perkara_id=#perkara_id#
order by a.urutan
limit 0,1" where no_var=0352;;
update abt_variabel set default_data=NULL where no_var=0352;;
update abt_variabel set multi_sidang=NULL where no_var=0352;;
update abt_variabel set locked="1" where no_var=0352;;
update abt_variabel set modifier=NULL where no_var=0352;;
update abt_variabel set modified="2019-08-08 19:56:07" where no_var=0352;;


/*NOMOR VARIABEL 0353*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0353);;
update abt_variabel set nama="Tempat Lahir Saksi 2 P" where no_var=0353;;
update abt_variabel set data_type="data_sql" where no_var=0353;;
update abt_variabel set data_tabel=NULL where no_var=0353;;
update abt_variabel set data_kolom=NULL where no_var=0353;;
update abt_variabel set urutan_data=NULL where no_var=0353;;
update abt_variabel set referensi=NULL where no_var=0353;;
update abt_variabel set sql_query="select b.tempat_lahir as data
from perkara_pihak5 a
join pihak b on a.pihak_id=b.id
where a.saksi_pihak_ke=1 and a.perkara_id=#perkara_id#
order by a.urutan
limit 1,1" where no_var=0353;;
update abt_variabel set default_data=NULL where no_var=0353;;
update abt_variabel set multi_sidang=NULL where no_var=0353;;
update abt_variabel set locked="1" where no_var=0353;;
update abt_variabel set modifier=NULL where no_var=0353;;
update abt_variabel set modified="2019-08-08 19:56:08" where no_var=0353;;


/*NOMOR VARIABEL 0354*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0354);;
update abt_variabel set nama="Tgl. Lahir Saksi 2 P" where no_var=0354;;
update abt_variabel set data_type="data_sql" where no_var=0354;;
update abt_variabel set data_tabel=NULL where no_var=0354;;
update abt_variabel set data_kolom=NULL where no_var=0354;;
update abt_variabel set urutan_data=NULL where no_var=0354;;
update abt_variabel set referensi=NULL where no_var=0354;;
update abt_variabel set sql_query="select b.tanggal_lahir as data
from perkara_pihak5 a
join pihak b on a.pihak_id=b.id
where a.saksi_pihak_ke=1 and a.perkara_id=#perkara_id#
order by a.urutan
limit 1,1" where no_var=0354;;
update abt_variabel set default_data=NULL where no_var=0354;;
update abt_variabel set multi_sidang=NULL where no_var=0354;;
update abt_variabel set locked="1" where no_var=0354;;
update abt_variabel set modifier=NULL where no_var=0354;;
update abt_variabel set modified="2019-08-08 19:56:09" where no_var=0354;;


/*NOMOR VARIABEL 0355*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0355);;
update abt_variabel set nama="No. NIK Saksi 2 P" where no_var=0355;;
update abt_variabel set data_type="data_sql" where no_var=0355;;
update abt_variabel set data_tabel=NULL where no_var=0355;;
update abt_variabel set data_kolom=NULL where no_var=0355;;
update abt_variabel set urutan_data=NULL where no_var=0355;;
update abt_variabel set referensi=NULL where no_var=0355;;
update abt_variabel set sql_query="select b.nomor_indentitas as data
from perkara_pihak5 a
join pihak b on a.pihak_id=b.id
where b.jenis_indentitas=4 and
a.saksi_pihak_ke=1 and a.perkara_id=#perkara_id#
order by a.urutan
limit 1,1" where no_var=0355;;
update abt_variabel set default_data=NULL where no_var=0355;;
update abt_variabel set multi_sidang=NULL where no_var=0355;;
update abt_variabel set locked="1" where no_var=0355;;
update abt_variabel set modifier=NULL where no_var=0355;;
update abt_variabel set modified="2019-08-08 19:56:11" where no_var=0355;;


/*NOMOR VARIABEL 0356*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0356);;
update abt_variabel set nama="Tempat Lahir Saksi 1 T" where no_var=0356;;
update abt_variabel set data_type="data_sql" where no_var=0356;;
update abt_variabel set data_tabel=NULL where no_var=0356;;
update abt_variabel set data_kolom=NULL where no_var=0356;;
update abt_variabel set urutan_data=NULL where no_var=0356;;
update abt_variabel set referensi=NULL where no_var=0356;;
update abt_variabel set sql_query="select b.tempat_lahir as data
from perkara_pihak5 a
join pihak b on a.pihak_id=b.id
where a.saksi_pihak_ke=2 and a.perkara_id=#perkara_id#
order by a.urutan
limit 0,1" where no_var=0356;;
update abt_variabel set default_data=NULL where no_var=0356;;
update abt_variabel set multi_sidang=NULL where no_var=0356;;
update abt_variabel set locked="1" where no_var=0356;;
update abt_variabel set modifier=NULL where no_var=0356;;
update abt_variabel set modified="2019-08-08 19:56:12" where no_var=0356;;


/*NOMOR VARIABEL 0357*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0357);;
update abt_variabel set nama="Tgl. Lahir Saksi 1 T" where no_var=0357;;
update abt_variabel set data_type="data_sql" where no_var=0357;;
update abt_variabel set data_tabel=NULL where no_var=0357;;
update abt_variabel set data_kolom=NULL where no_var=0357;;
update abt_variabel set urutan_data=NULL where no_var=0357;;
update abt_variabel set referensi=NULL where no_var=0357;;
update abt_variabel set sql_query="select b.tanggal_lahir as data
from perkara_pihak5 a
join pihak b on a.pihak_id=b.id
where a.saksi_pihak_ke=2 and a.perkara_id=#perkara_id#
limit 0,1" where no_var=0357;;
update abt_variabel set default_data=NULL where no_var=0357;;
update abt_variabel set multi_sidang=NULL where no_var=0357;;
update abt_variabel set locked="1" where no_var=0357;;
update abt_variabel set modifier=NULL where no_var=0357;;
update abt_variabel set modified="2019-08-08 19:56:13" where no_var=0357;;


/*NOMOR VARIABEL 0358*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0358);;
update abt_variabel set nama="No. NIK Saksi 1 T" where no_var=0358;;
update abt_variabel set data_type="data_sql" where no_var=0358;;
update abt_variabel set data_tabel=NULL where no_var=0358;;
update abt_variabel set data_kolom=NULL where no_var=0358;;
update abt_variabel set urutan_data=NULL where no_var=0358;;
update abt_variabel set referensi=NULL where no_var=0358;;
update abt_variabel set sql_query="select b.nomor_indentitas as data
from perkara_pihak5 a
join pihak b on a.pihak_id=b.id
where b.jenis_indentitas=4 and
a.saksi_pihak_ke=2 and a.perkara_id=#perkara_id#
order by a.urutan
limit 0,1" where no_var=0358;;
update abt_variabel set default_data=NULL where no_var=0358;;
update abt_variabel set multi_sidang=NULL where no_var=0358;;
update abt_variabel set locked="1" where no_var=0358;;
update abt_variabel set modifier=NULL where no_var=0358;;
update abt_variabel set modified="2019-08-08 19:56:15" where no_var=0358;;


/*NOMOR VARIABEL 0359*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0359);;
update abt_variabel set nama="Tempat Lahir Saksi 2 T" where no_var=0359;;
update abt_variabel set data_type="data_sql" where no_var=0359;;
update abt_variabel set data_tabel=NULL where no_var=0359;;
update abt_variabel set data_kolom=NULL where no_var=0359;;
update abt_variabel set urutan_data=NULL where no_var=0359;;
update abt_variabel set referensi=NULL where no_var=0359;;
update abt_variabel set sql_query="select b.tempat_lahir as data
from perkara_pihak5 a
join pihak b on a.pihak_id=b.id
where a.saksi_pihak_ke=2 and a.perkara_id=#perkara_id#
order by a.urutan
limit 1,1" where no_var=0359;;
update abt_variabel set default_data=NULL where no_var=0359;;
update abt_variabel set multi_sidang=NULL where no_var=0359;;
update abt_variabel set locked="1" where no_var=0359;;
update abt_variabel set modifier=NULL where no_var=0359;;
update abt_variabel set modified="2019-08-08 19:56:16" where no_var=0359;;


/*NOMOR VARIABEL 0360*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0360);;
update abt_variabel set nama="Tgl. Lahir Saksi 2 T" where no_var=0360;;
update abt_variabel set data_type="data_sql" where no_var=0360;;
update abt_variabel set data_tabel=NULL where no_var=0360;;
update abt_variabel set data_kolom=NULL where no_var=0360;;
update abt_variabel set urutan_data=NULL where no_var=0360;;
update abt_variabel set referensi=NULL where no_var=0360;;
update abt_variabel set sql_query="select b.tanggal_lahir as data
from perkara_pihak5 a
join pihak b on a.pihak_id=b.id
where a.saksi_pihak_ke=2 and a.perkara_id=#perkara_id#
order by a.urutan
limit 1,1" where no_var=0360;;
update abt_variabel set default_data=NULL where no_var=0360;;
update abt_variabel set multi_sidang=NULL where no_var=0360;;
update abt_variabel set locked="1" where no_var=0360;;
update abt_variabel set modifier=NULL where no_var=0360;;
update abt_variabel set modified="2019-08-08 19:56:17" where no_var=0360;;


/*NOMOR VARIABEL 0361*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0361);;
update abt_variabel set nama="No. NIK Saksi 2 T" where no_var=0361;;
update abt_variabel set data_type="data_sql" where no_var=0361;;
update abt_variabel set data_tabel=NULL where no_var=0361;;
update abt_variabel set data_kolom=NULL where no_var=0361;;
update abt_variabel set urutan_data=NULL where no_var=0361;;
update abt_variabel set referensi=NULL where no_var=0361;;
update abt_variabel set sql_query="select b.nomor_indentitas as data
from perkara_pihak5 a
join pihak b on a.pihak_id=b.id
where b.jenis_indentitas=4 and
a.saksi_pihak_ke=2 and a.perkara_id=#perkara_id#
order by a.urutan
limit 1,1" where no_var=0361;;
update abt_variabel set default_data=NULL where no_var=0361;;
update abt_variabel set multi_sidang=NULL where no_var=0361;;
update abt_variabel set locked="1" where no_var=0361;;
update abt_variabel set modifier=NULL where no_var=0361;;
update abt_variabel set modified="2019-08-08 19:56:18" where no_var=0361;;


/*NOMOR VARIABEL 0362*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0362);;
update abt_variabel set nama="NIK Kuasa #0046#" where no_var=0362;;
update abt_variabel set data_type="data_sql" where no_var=0362;;
update abt_variabel set data_tabel=NULL where no_var=0362;;
update abt_variabel set data_kolom=NULL where no_var=0362;;
update abt_variabel set urutan_data=NULL where no_var=0362;;
update abt_variabel set referensi=NULL where no_var=0362;;
update abt_variabel set sql_query="select b.nomor_indentitas as data from perkara_pengacara a
join pihak b on a.pihak_id=b.id
where a.pihak_ke=1 and a.urutan=1 and a.perkara_id=#perkara_id#" where no_var=0362;;
update abt_variabel set default_data=NULL where no_var=0362;;
update abt_variabel set multi_sidang=NULL where no_var=0362;;
update abt_variabel set locked="1" where no_var=0362;;
update abt_variabel set modifier=NULL where no_var=0362;;
update abt_variabel set modified="2019-08-08 19:56:19" where no_var=0362;;


/*NOMOR VARIABEL 0363*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0363);;
update abt_variabel set nama="NIK Kuasa #0047#" where no_var=0363;;
update abt_variabel set data_type="data_sql" where no_var=0363;;
update abt_variabel set data_tabel=NULL where no_var=0363;;
update abt_variabel set data_kolom=NULL where no_var=0363;;
update abt_variabel set urutan_data=NULL where no_var=0363;;
update abt_variabel set referensi=NULL where no_var=0363;;
update abt_variabel set sql_query="select b.nomor_indentitas as data from perkara_pengacara a
join pihak b on a.pihak_id=b.id
where a.pihak_ke=2 and a.urutan=1 and a.perkara_id=#perkara_id#" where no_var=0363;;
update abt_variabel set default_data=NULL where no_var=0363;;
update abt_variabel set multi_sidang=NULL where no_var=0363;;
update abt_variabel set locked="1" where no_var=0363;;
update abt_variabel set modifier=NULL where no_var=0363;;
update abt_variabel set modified="2019-08-08 19:56:21" where no_var=0363;;


/*NOMOR VARIABEL 0368*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0368);;
update abt_variabel set nama="Tempat Lahir Kuasa #0046#" where no_var=0368;;
update abt_variabel set data_type="data_sql" where no_var=0368;;
update abt_variabel set data_tabel=NULL where no_var=0368;;
update abt_variabel set data_kolom=NULL where no_var=0368;;
update abt_variabel set urutan_data=NULL where no_var=0368;;
update abt_variabel set referensi=NULL where no_var=0368;;
update abt_variabel set sql_query="select b.tempat_lahir as data
from perkara_pengacara a
join pihak b on a.pengacara_id=b.id
where a.pihak_ke=1 and a.urutan=1 and a.perkara_id=#perkara_id#" where no_var=0368;;
update abt_variabel set default_data=NULL where no_var=0368;;
update abt_variabel set multi_sidang=NULL where no_var=0368;;
update abt_variabel set locked="1" where no_var=0368;;
update abt_variabel set modifier=NULL where no_var=0368;;
update abt_variabel set modified="2019-08-08 19:56:25" where no_var=0368;;


/*NOMOR VARIABEL 0369*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0369);;
update abt_variabel set nama="Tgl. Lahir Kuasa #0046#" where no_var=0369;;
update abt_variabel set data_type="data_sql" where no_var=0369;;
update abt_variabel set data_tabel=NULL where no_var=0369;;
update abt_variabel set data_kolom=NULL where no_var=0369;;
update abt_variabel set urutan_data=NULL where no_var=0369;;
update abt_variabel set referensi=NULL where no_var=0369;;
update abt_variabel set sql_query="select b.tanggal_lahir as data
from perkara_pengacara a
join pihak b on a.pengacara_id=b.id
where a.pihak_ke=1 and a.urutan=1 and a.perkara_id=#perkara_id#" where no_var=0369;;
update abt_variabel set default_data=NULL where no_var=0369;;
update abt_variabel set multi_sidang=NULL where no_var=0369;;
update abt_variabel set locked="1" where no_var=0369;;
update abt_variabel set modifier=NULL where no_var=0369;;
update abt_variabel set modified="2019-08-08 19:56:26" where no_var=0369;;


/*NOMOR VARIABEL 0370*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0370);;
update abt_variabel set nama="Email Kuasa #0046#" where no_var=0370;;
update abt_variabel set data_type="data_sql" where no_var=0370;;
update abt_variabel set data_tabel=NULL where no_var=0370;;
update abt_variabel set data_kolom=NULL where no_var=0370;;
update abt_variabel set urutan_data=NULL where no_var=0370;;
update abt_variabel set referensi=NULL where no_var=0370;;
update abt_variabel set sql_query="select b.email as data
from perkara_pengacara a
join pihak b on a.pengacara_id=b.id
where a.pihak_ke=1 and a.urutan=1 and a.perkara_id=#perkara_id#" where no_var=0370;;
update abt_variabel set default_data=NULL where no_var=0370;;
update abt_variabel set multi_sidang=NULL where no_var=0370;;
update abt_variabel set locked="1" where no_var=0370;;
update abt_variabel set modifier=NULL where no_var=0370;;
update abt_variabel set modified="2019-08-08 19:56:30" where no_var=0370;;


/*NOMOR VARIABEL 0371*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0371);;
update abt_variabel set nama="No.HP Kuasa #0046#" where no_var=0371;;
update abt_variabel set data_type="data_sql" where no_var=0371;;
update abt_variabel set data_tabel=NULL where no_var=0371;;
update abt_variabel set data_kolom=NULL where no_var=0371;;
update abt_variabel set urutan_data=NULL where no_var=0371;;
update abt_variabel set referensi=NULL where no_var=0371;;
update abt_variabel set sql_query="select b.telepon as data
from perkara_pengacara a
join pihak b on a.pengacara_id=b.id
where a.pihak_ke=1 and a.urutan=1 and a.perkara_id=#perkara_id#" where no_var=0371;;
update abt_variabel set default_data=NULL where no_var=0371;;
update abt_variabel set multi_sidang=NULL where no_var=0371;;
update abt_variabel set locked="1" where no_var=0371;;
update abt_variabel set modifier=NULL where no_var=0371;;
update abt_variabel set modified="2019-08-08 19:56:32" where no_var=0371;;


/*NOMOR VARIABEL 0372*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0372);;
update abt_variabel set nama="Email Kuasa #0047#" where no_var=0372;;
update abt_variabel set data_type="data_sql" where no_var=0372;;
update abt_variabel set data_tabel=NULL where no_var=0372;;
update abt_variabel set data_kolom=NULL where no_var=0372;;
update abt_variabel set urutan_data=NULL where no_var=0372;;
update abt_variabel set referensi=NULL where no_var=0372;;
update abt_variabel set sql_query="select b.email as data
from perkara_pengacara a
join pihak b on a.pengacara_id=b.id
where a.pihak_ke=2 and a.urutan=1 and a.perkara_id=#perkara_id#" where no_var=0372;;
update abt_variabel set default_data=NULL where no_var=0372;;
update abt_variabel set multi_sidang=NULL where no_var=0372;;
update abt_variabel set locked="1" where no_var=0372;;
update abt_variabel set modifier=NULL where no_var=0372;;
update abt_variabel set modified="2019-08-08 19:56:33" where no_var=0372;;


/*NOMOR VARIABEL 0373*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0373);;
update abt_variabel set nama="No.Hp Kuasa #0047#" where no_var=0373;;
update abt_variabel set data_type="data_sql" where no_var=0373;;
update abt_variabel set data_tabel=NULL where no_var=0373;;
update abt_variabel set data_kolom=NULL where no_var=0373;;
update abt_variabel set urutan_data=NULL where no_var=0373;;
update abt_variabel set referensi=NULL where no_var=0373;;
update abt_variabel set sql_query="select b.telepon as data
from perkara_pengacara a
join pihak b on a.pengacara_id=b.id
where a.pihak_ke=2 and a.urutan=1 and a.perkara_id=#perkara_id#" where no_var=0373;;
update abt_variabel set default_data=NULL where no_var=0373;;
update abt_variabel set multi_sidang=NULL where no_var=0373;;
update abt_variabel set locked="1" where no_var=0373;;
update abt_variabel set modifier=NULL where no_var=0373;;
update abt_variabel set modified="2019-08-08 19:56:35" where no_var=0373;;


/*NOMOR VARIABEL 0650*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0650);;
update abt_variabel set nama="Saksi Nikah 1" where no_var=0650;;
update abt_variabel set data_type="data_teks" where no_var=0650;;
update abt_variabel set data_tabel=NULL where no_var=0650;;
update abt_variabel set data_kolom=NULL where no_var=0650;;
update abt_variabel set urutan_data=NULL where no_var=0650;;
update abt_variabel set referensi=NULL where no_var=0650;;
update abt_variabel set sql_query=NULL where no_var=0650;;
update abt_variabel set default_data=NULL where no_var=0650;;
update abt_variabel set multi_sidang=NULL where no_var=0650;;
update abt_variabel set locked="1" where no_var=0650;;
update abt_variabel set modifier=NULL where no_var=0650;;
update abt_variabel set modified="2019-08-08 19:57:18" where no_var=0650;;


/*NOMOR VARIABEL 0651*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0651);;
update abt_variabel set nama="Saksi Nikah 2" where no_var=0651;;
update abt_variabel set data_type="data_teks" where no_var=0651;;
update abt_variabel set data_tabel=NULL where no_var=0651;;
update abt_variabel set data_kolom=NULL where no_var=0651;;
update abt_variabel set urutan_data=NULL where no_var=0651;;
update abt_variabel set referensi=NULL where no_var=0651;;
update abt_variabel set sql_query=NULL where no_var=0651;;
update abt_variabel set default_data=NULL where no_var=0651;;
update abt_variabel set multi_sidang=NULL where no_var=0651;;
update abt_variabel set locked="1" where no_var=0651;;
update abt_variabel set modifier=NULL where no_var=0651;;
update abt_variabel set modified="2019-08-08 19:57:19" where no_var=0651;;


/*NOMOR VARIABEL 0658*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0658);;
update abt_variabel set nama="No. Surat Izin Cerai" where no_var=0658;;
update abt_variabel set data_type="data_sipp" where no_var=0658;;
update abt_variabel set data_tabel="perkara_izin_cerai" where no_var=0658;;
update abt_variabel set data_kolom="nomor_surat" where no_var=0658;;
update abt_variabel set urutan_data=NULL where no_var=0658;;
update abt_variabel set referensi=NULL where no_var=0658;;
update abt_variabel set sql_query=NULL where no_var=0658;;
update abt_variabel set default_data=NULL where no_var=0658;;
update abt_variabel set multi_sidang=NULL where no_var=0658;;
update abt_variabel set locked="1" where no_var=0658;;
update abt_variabel set modifier=NULL where no_var=0658;;
update abt_variabel set modified="2019-08-08 19:57:39" where no_var=0658;;


/*NOMOR VARIABEL 0659*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0659);;
update abt_variabel set nama="Tgl. Surat Izin Cerai" where no_var=0659;;
update abt_variabel set data_type="data_sipp" where no_var=0659;;
update abt_variabel set data_tabel="perkara_izin_cerai" where no_var=0659;;
update abt_variabel set data_kolom="tanggal_surat" where no_var=0659;;
update abt_variabel set urutan_data=NULL where no_var=0659;;
update abt_variabel set referensi=NULL where no_var=0659;;
update abt_variabel set sql_query=NULL where no_var=0659;;
update abt_variabel set default_data=NULL where no_var=0659;;
update abt_variabel set multi_sidang=NULL where no_var=0659;;
update abt_variabel set locked="1" where no_var=0659;;
update abt_variabel set modifier=NULL where no_var=0659;;
update abt_variabel set modified="2019-08-08 19:57:41" where no_var=0659;;


/*NOMOR VARIABEL 0660*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0660);;
update abt_variabel set nama="Izin Atasan oleh" where no_var=0660;;
update abt_variabel set data_type="data_sipp" where no_var=0660;;
update abt_variabel set data_tabel="perkara_izin_cerai" where no_var=0660;;
update abt_variabel set data_kolom="jabatan_pejabat" where no_var=0660;;
update abt_variabel set urutan_data=NULL where no_var=0660;;
update abt_variabel set referensi=NULL where no_var=0660;;
update abt_variabel set sql_query=NULL where no_var=0660;;
update abt_variabel set default_data=NULL where no_var=0660;;
update abt_variabel set multi_sidang=NULL where no_var=0660;;
update abt_variabel set locked="1" where no_var=0660;;
update abt_variabel set modifier=NULL where no_var=0660;;
update abt_variabel set modified="2019-08-08 19:57:43" where no_var=0660;;


/*NOMOR VARIABEL 0665*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0665);;
update abt_variabel set nama="Hakim Plt. Ketua" where no_var=0665;;
update abt_variabel set data_type="data_sql" where no_var=0665;;
update abt_variabel set data_tabel=NULL where no_var=0665;;
update abt_variabel set data_kolom=NULL where no_var=0665;;
update abt_variabel set urutan_data=NULL where no_var=0665;;
update abt_variabel set referensi=NULL where no_var=0665;;
update abt_variabel set sql_query="select value as data from sys_config
where name=""PltKetua""" where no_var=0665;;
update abt_variabel set default_data=NULL where no_var=0665;;
update abt_variabel set multi_sidang=NULL where no_var=0665;;
update abt_variabel set locked="1" where no_var=0665;;
update abt_variabel set modifier=NULL where no_var=0665;;
update abt_variabel set modified="2019-08-08 19:58:01" where no_var=0665;;


/*NOMOR VARIABEL 0666*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0666);;
update abt_variabel set nama="Hakim Plh. Ketua" where no_var=0666;;
update abt_variabel set data_type="data_sql" where no_var=0666;;
update abt_variabel set data_tabel=NULL where no_var=0666;;
update abt_variabel set data_kolom=NULL where no_var=0666;;
update abt_variabel set urutan_data=NULL where no_var=0666;;
update abt_variabel set referensi=NULL where no_var=0666;;
update abt_variabel set sql_query="select value as data from sys_config
where name=""PlhKetua""" where no_var=0666;;
update abt_variabel set default_data=NULL where no_var=0666;;
update abt_variabel set multi_sidang=NULL where no_var=0666;;
update abt_variabel set locked="1" where no_var=0666;;
update abt_variabel set modifier=NULL where no_var=0666;;
update abt_variabel set modified="2019-08-08 19:58:02" where no_var=0666;;


/*NOMOR VARIABEL 0667*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0667);;
update abt_variabel set nama="Majelis Hakim / Hakim" where no_var=0667;;
update abt_variabel set data_type="data_sql" where no_var=0667;;
update abt_variabel set data_tabel=NULL where no_var=0667;;
update abt_variabel set data_kolom=NULL where no_var=0667;;
update abt_variabel set urutan_data=NULL where no_var=0667;;
update abt_variabel set referensi=NULL where no_var=0667;;
update abt_variabel set sql_query="select (case when max(jabatan_hakim_id)<3 then ""Majelis Hakim"" else ""Hakim"" end) as data from perkara_hakim_pn
where aktif=""Y"" and perkara_id=#perkara_id#" where no_var=0667;;
update abt_variabel set default_data=NULL where no_var=0667;;
update abt_variabel set multi_sidang=NULL where no_var=0667;;
update abt_variabel set locked="1" where no_var=0667;;
update abt_variabel set modifier=NULL where no_var=0667;;
update abt_variabel set modified="2019-08-08 19:58:03" where no_var=0667;;


/*NOMOR VARIABEL 0668*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (0668);;
update abt_variabel set nama="Ketua Majelis / Hakim" where no_var=0668;;
update abt_variabel set data_type="data_sql" where no_var=0668;;
update abt_variabel set data_tabel=NULL where no_var=0668;;
update abt_variabel set data_kolom=NULL where no_var=0668;;
update abt_variabel set urutan_data=NULL where no_var=0668;;
update abt_variabel set referensi=NULL where no_var=0668;;
update abt_variabel set sql_query="select (case when min(jabatan_hakim_id)=1 then ""Ketua Majelis"" else ""Hakim"" end) as data from perkara_hakim_pn
where aktif=""Y"" and perkara_id=#perkara_id#" where no_var=0668;;
update abt_variabel set default_data=NULL where no_var=0668;;
update abt_variabel set multi_sidang=NULL where no_var=0668;;
update abt_variabel set locked="1" where no_var=0668;;
update abt_variabel set modifier=NULL where no_var=0668;;
update abt_variabel set modified="2019-08-08 19:58:04" where no_var=0668;;


/*NOMOR VARIABEL 1004*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1004);;
update abt_variabel set nama="Nomor Kutipan Akta Nikah" where no_var=1004;;
update abt_variabel set data_type="data_sipp" where no_var=1004;;
update abt_variabel set data_tabel="perkara_data_pernikahan" where no_var=1004;;
update abt_variabel set data_kolom="no_kutipan_akta_nikah" where no_var=1004;;
update abt_variabel set urutan_data=NULL where no_var=1004;;
update abt_variabel set referensi=NULL where no_var=1004;;
update abt_variabel set sql_query=NULL where no_var=1004;;
update abt_variabel set default_data=NULL where no_var=1004;;
update abt_variabel set multi_sidang=NULL where no_var=1004;;
update abt_variabel set locked="1" where no_var=1004;;
update abt_variabel set modifier=NULL where no_var=1004;;
update abt_variabel set modified="2019-08-08 19:58:34" where no_var=1004;;


/*NOMOR VARIABEL 1005*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1005);;
update abt_variabel set nama="Kantor Urusan Agama (KUA)" where no_var=1005;;
update abt_variabel set data_type="data_sipp" where no_var=1005;;
update abt_variabel set data_tabel="perkara_data_pernikahan" where no_var=1005;;
update abt_variabel set data_kolom="kua_tempat_nikah" where no_var=1005;;
update abt_variabel set urutan_data=NULL where no_var=1005;;
update abt_variabel set referensi=NULL where no_var=1005;;
update abt_variabel set sql_query=NULL where no_var=1005;;
update abt_variabel set default_data=NULL where no_var=1005;;
update abt_variabel set multi_sidang=NULL where no_var=1005;;
update abt_variabel set locked="1" where no_var=1005;;
update abt_variabel set modifier=NULL where no_var=1005;;
update abt_variabel set modified="2019-08-08 19:58:35" where no_var=1005;;


/*NOMOR VARIABEL 1011*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1011);;
update abt_variabel set nama="Tanggal Nikah" where no_var=1011;;
update abt_variabel set data_type="data_sipp" where no_var=1011;;
update abt_variabel set data_tabel="perkara_data_pernikahan" where no_var=1011;;
update abt_variabel set data_kolom="tgl_nikah" where no_var=1011;;
update abt_variabel set urutan_data=NULL where no_var=1011;;
update abt_variabel set referensi=NULL where no_var=1011;;
update abt_variabel set sql_query=NULL where no_var=1011;;
update abt_variabel set default_data=NULL where no_var=1011;;
update abt_variabel set multi_sidang=NULL where no_var=1011;;
update abt_variabel set locked="1" where no_var=1011;;
update abt_variabel set modifier=NULL where no_var=1011;;
update abt_variabel set modified="2019-08-08 19:58:46" where no_var=1011;;


/*NOMOR VARIABEL 1012*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1012);;
update abt_variabel set nama="Tanggal Surat Nikah" where no_var=1012;;
update abt_variabel set data_type="data_sipp" where no_var=1012;;
update abt_variabel set data_tabel="perkara_data_pernikahan" where no_var=1012;;
update abt_variabel set data_kolom="tgl_kutipan_akta_nikah" where no_var=1012;;
update abt_variabel set urutan_data=NULL where no_var=1012;;
update abt_variabel set referensi=NULL where no_var=1012;;
update abt_variabel set sql_query=NULL where no_var=1012;;
update abt_variabel set default_data=NULL where no_var=1012;;
update abt_variabel set multi_sidang=NULL where no_var=1012;;
update abt_variabel set locked="1" where no_var=1012;;
update abt_variabel set modifier=NULL where no_var=1012;;
update abt_variabel set modified="2019-08-08 19:58:47" where no_var=1012;;


/*NOMOR VARIABEL 1033*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1033);;
update abt_variabel set nama="Nama #0046# II" where no_var=1033;;
update abt_variabel set data_type="data_sql" where no_var=1033;;
update abt_variabel set data_tabel=NULL where no_var=1033;;
update abt_variabel set data_kolom=NULL where no_var=1033;;
update abt_variabel set urutan_data=NULL where no_var=1033;;
update abt_variabel set referensi=NULL where no_var=1033;;
update abt_variabel set sql_query="select nama as data from perkara_pihak1
where urutan=2 and perkara_id=#perkara_id#" where no_var=1033;;
update abt_variabel set default_data=NULL where no_var=1033;;
update abt_variabel set multi_sidang=NULL where no_var=1033;;
update abt_variabel set locked="1" where no_var=1033;;
update abt_variabel set modifier=NULL where no_var=1033;;
update abt_variabel set modified="2019-08-08 19:58:54" where no_var=1033;;


/*NOMOR VARIABEL 1034*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1034);;
update abt_variabel set nama="Umur #0046# II" where no_var=1034;;
update abt_variabel set data_type="data_sql" where no_var=1034;;
update abt_variabel set data_tabel=NULL where no_var=1034;;
update abt_variabel set data_kolom=NULL where no_var=1034;;
update abt_variabel set urutan_data=NULL where no_var=1034;;
update abt_variabel set referensi=NULL where no_var=1034;;
update abt_variabel set sql_query="select (get_umur(b.tanggal_lahir,c.tanggal_pendaftaran))as data
from perkara_pihak1 a
join pihak b on a.pihak_id=b.id
join perkara c on a.perkara_id=c.perkara_id
where a.urutan=2 and a.perkara_id=#perkara_id#" where no_var=1034;;
update abt_variabel set default_data=NULL where no_var=1034;;
update abt_variabel set multi_sidang=NULL where no_var=1034;;
update abt_variabel set locked="1" where no_var=1034;;
update abt_variabel set modifier=NULL where no_var=1034;;
update abt_variabel set modified="2019-08-09 06:01:05" where no_var=1034;;


/*NOMOR VARIABEL 1035*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1035);;
update abt_variabel set nama="Pekerjaan #0046# II" where no_var=1035;;
update abt_variabel set data_type="data_sql" where no_var=1035;;
update abt_variabel set data_tabel=NULL where no_var=1035;;
update abt_variabel set data_kolom=NULL where no_var=1035;;
update abt_variabel set urutan_data=NULL where no_var=1035;;
update abt_variabel set referensi=NULL where no_var=1035;;
update abt_variabel set sql_query="select b.pekerjaan as data from perkara_pihak1 a
join pihak b on a.pihak_id=b.id
where a.urutan=2 and a.perkara_id=#perkara_id#" where no_var=1035;;
update abt_variabel set default_data=NULL where no_var=1035;;
update abt_variabel set multi_sidang=NULL where no_var=1035;;
update abt_variabel set locked="1" where no_var=1035;;
update abt_variabel set modifier=NULL where no_var=1035;;
update abt_variabel set modified="2019-08-08 19:58:58" where no_var=1035;;


/*NOMOR VARIABEL 1036*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1036);;
update abt_variabel set nama="Alamat #0046# II" where no_var=1036;;
update abt_variabel set data_type="data_sipp" where no_var=1036;;
update abt_variabel set data_tabel="perkara_pihak1" where no_var=1036;;
update abt_variabel set data_kolom="alamat" where no_var=1036;;
update abt_variabel set urutan_data="2" where no_var=1036;;
update abt_variabel set referensi=NULL where no_var=1036;;
update abt_variabel set sql_query=NULL where no_var=1036;;
update abt_variabel set default_data=NULL where no_var=1036;;
update abt_variabel set multi_sidang=NULL where no_var=1036;;
update abt_variabel set locked="1" where no_var=1036;;
update abt_variabel set modifier=NULL where no_var=1036;;
update abt_variabel set modified="2019-08-08 19:58:59" where no_var=1036;;


/*NOMOR VARIABEL 1047*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1047);;
update abt_variabel set nama="Panjar Biaya Perkara" where no_var=1047;;
update abt_variabel set data_type="data_sql" where no_var=1047;;
update abt_variabel set data_tabel=NULL where no_var=1047;;
update abt_variabel set data_kolom=NULL where no_var=1047;;
update abt_variabel set urutan_data=NULL where no_var=1047;;
update abt_variabel set referensi=NULL where no_var=1047;;
update abt_variabel set sql_query="select jumlah as data from perkara_biaya
where jenis_biaya_id=1 and perkara_id=#perkara_id#" where no_var=1047;;
update abt_variabel set default_data=NULL where no_var=1047;;
update abt_variabel set multi_sidang=NULL where no_var=1047;;
update abt_variabel set locked="1" where no_var=1047;;
update abt_variabel set modifier=NULL where no_var=1047;;
update abt_variabel set modified="2019-08-08 19:59:16" where no_var=1047;;


/*NOMOR VARIABEL 1060*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1060);;
update abt_variabel set nama="Tgl PMH" where no_var=1060;;
update abt_variabel set data_type="data_sipp" where no_var=1060;;
update abt_variabel set data_tabel="perkara_penetapan" where no_var=1060;;
update abt_variabel set data_kolom="penetapan_majelis_hakim" where no_var=1060;;
update abt_variabel set urutan_data=NULL where no_var=1060;;
update abt_variabel set referensi=NULL where no_var=1060;;
update abt_variabel set sql_query=NULL where no_var=1060;;
update abt_variabel set default_data=NULL where no_var=1060;;
update abt_variabel set multi_sidang=NULL where no_var=1060;;
update abt_variabel set locked="1" where no_var=1060;;
update abt_variabel set modifier=NULL where no_var=1060;;
update abt_variabel set modified="2019-08-08 19:59:32" where no_var=1060;;


/*NOMOR VARIABEL 1061*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1061);;
update abt_variabel set nama="Tgl. Daftar Perkara" where no_var=1061;;
update abt_variabel set data_type="data_sipp" where no_var=1061;;
update abt_variabel set data_tabel="perkara" where no_var=1061;;
update abt_variabel set data_kolom="tanggal_pendaftaran" where no_var=1061;;
update abt_variabel set urutan_data=NULL where no_var=1061;;
update abt_variabel set referensi=NULL where no_var=1061;;
update abt_variabel set sql_query=NULL where no_var=1061;;
update abt_variabel set default_data=NULL where no_var=1061;;
update abt_variabel set multi_sidang=NULL where no_var=1061;;
update abt_variabel set locked="1" where no_var=1061;;
update abt_variabel set modifier=NULL where no_var=1061;;
update abt_variabel set modified="2019-08-08 19:59:33" where no_var=1061;;


/*NOMOR VARIABEL 1062*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1062);;
update abt_variabel set nama="Hari Tgl. Daftar" where no_var=1062;;
update abt_variabel set data_type="tanggal_hari" where no_var=1062;;
update abt_variabel set data_tabel=NULL where no_var=1062;;
update abt_variabel set data_kolom=NULL where no_var=1062;;
update abt_variabel set urutan_data=NULL where no_var=1062;;
update abt_variabel set referensi="1061" where no_var=1062;;
update abt_variabel set sql_query=NULL where no_var=1062;;
update abt_variabel set default_data=NULL where no_var=1062;;
update abt_variabel set multi_sidang=NULL where no_var=1062;;
update abt_variabel set locked="1" where no_var=1062;;
update abt_variabel set modifier=NULL where no_var=1062;;
update abt_variabel set modified="2019-08-08 19:59:35" where no_var=1062;;


/*NOMOR VARIABEL 1064*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1064);;
update abt_variabel set nama="Tgl PHS" where no_var=1064;;
update abt_variabel set data_type="data_sipp" where no_var=1064;;
update abt_variabel set data_tabel="perkara_penetapan" where no_var=1064;;
update abt_variabel set data_kolom="penetapan_hari_sidang" where no_var=1064;;
update abt_variabel set urutan_data=NULL where no_var=1064;;
update abt_variabel set referensi=NULL where no_var=1064;;
update abt_variabel set sql_query=NULL where no_var=1064;;
update abt_variabel set default_data=NULL where no_var=1064;;
update abt_variabel set multi_sidang=NULL where no_var=1064;;
update abt_variabel set locked="1" where no_var=1064;;
update abt_variabel set modifier=NULL where no_var=1064;;
update abt_variabel set modified="2019-08-08 19:59:36" where no_var=1064;;


/*NOMOR VARIABEL 1069*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1069);;
update abt_variabel set nama="Tgl Putusan" where no_var=1069;;
update abt_variabel set data_type="data_sipp" where no_var=1069;;
update abt_variabel set data_tabel="perkara_putusan" where no_var=1069;;
update abt_variabel set data_kolom="tanggal_putusan" where no_var=1069;;
update abt_variabel set urutan_data=NULL where no_var=1069;;
update abt_variabel set referensi=NULL where no_var=1069;;
update abt_variabel set sql_query=NULL where no_var=1069;;
update abt_variabel set default_data=NULL where no_var=1069;;
update abt_variabel set multi_sidang=NULL where no_var=1069;;
update abt_variabel set locked="1" where no_var=1069;;
update abt_variabel set modifier=NULL where no_var=1069;;
update abt_variabel set modified="2019-08-08 19:59:43" where no_var=1069;;


/*NOMOR VARIABEL 1071*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1071);;
update abt_variabel set nama="Tgl PBT Isi Putusan" where no_var=1071;;
update abt_variabel set data_type="data_sipp" where no_var=1071;;
update abt_variabel set data_tabel="perkara_putusan_pemberitahuan_putusan" where no_var=1071;;
update abt_variabel set data_kolom="max(tanggal_pemberitahuan_putusan)" where no_var=1071;;
update abt_variabel set urutan_data=NULL where no_var=1071;;
update abt_variabel set referensi=NULL where no_var=1071;;
update abt_variabel set sql_query=NULL where no_var=1071;;
update abt_variabel set default_data=NULL where no_var=1071;;
update abt_variabel set multi_sidang=NULL where no_var=1071;;
update abt_variabel set locked="1" where no_var=1071;;
update abt_variabel set modifier=NULL where no_var=1071;;
update abt_variabel set modified="2019-08-08 19:59:45" where no_var=1071;;


/*NOMOR VARIABEL 1072*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1072);;
update abt_variabel set nama="Kehadiran #0046#" where no_var=1072;;
update abt_variabel set data_type="data_sql" where no_var=1072;;
update abt_variabel set data_tabel=NULL where no_var=1072;;
update abt_variabel set data_kolom=NULL where no_var=1072;;
update abt_variabel set urutan_data=NULL where no_var=1072;;
update abt_variabel set referensi=NULL where no_var=1072;;
update abt_variabel set sql_query="select (case

when
a.dihadiri_oleh>=3 and b.dihadiri_oleh>=3 or a.dihadiri_oleh>=3 and 1=#0050#
then
""#4046# tidak menghadap di persidangan atau menyuruh orang lain sebagai wakilnya yang sah, meskipun menurut relaas Nomor #0001#, tanggal #0118# yang dibacakan di persidangan, #4046# telah dipanggil secara resmi dan patut untuk menghadap di persidangan, dan tidak ternyata ketidakdatangannya tersebut bukan disebabkan alasan yang sah""

when
a.dihadiri_oleh>=3 and b.dihadiri_oleh<=2
then
""#4046# tidak menghadap ke persidangan atau menyuruh orang lain untuk menghadap sebagai kuasanya, meskipun telah diperintahkan langsung pada sidang yang lalu untuk datang menghadap pada sidang hari ini""

else
""#0141#""
end) data
from perkara_jadwal_sidang a
left join perkara_jadwal_sidang b on a.perkara_id=b.perkara_id and b.urutan=#0050#
where a.perkara_id=#perkara_id# and a.urutan=#0050#" where no_var=1072;;
update abt_variabel set default_data=NULL where no_var=1072;;
update abt_variabel set multi_sidang=NULL where no_var=1072;;
update abt_variabel set locked="1" where no_var=1072;;
update abt_variabel set modifier=NULL where no_var=1072;;
update abt_variabel set modified="2019-08-08 19:59:55" where no_var=1072;;


/*NOMOR VARIABEL 1073*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1073);;
update abt_variabel set nama="Kehadiran #0047#" where no_var=1073;;
update abt_variabel set data_type="data_sql" where no_var=1073;;
update abt_variabel set data_tabel=NULL where no_var=1073;;
update abt_variabel set data_kolom=NULL where no_var=1073;;
update abt_variabel set urutan_data=NULL where no_var=1073;;
update abt_variabel set referensi=NULL where no_var=1073;;
update abt_variabel set sql_query="select (case 

when 
a.dihadiri_oleh %2 = 0 and b.dihadiri_oleh %2 = 0 or a.dihadiri_oleh %2 = 0 and 1=#0050#
then 
""#4047# tidak menghadap di persidangan atau menyuruh orang lain sebagai wakilnya yang sah, meskipun menurut relaas Nomor #0001#, tanggal #0120# yang dibacakan di persidangan, #4047# telah dipanggil secara resmi dan patut untuk menghadap ke persidangan dan tidak ternyata ketidakdatangannya tersebut bukan disebabkan alasan yang sah""

when 
a.dihadiri_oleh %2 = 0 and b.dihadiri_oleh %2 = 1
then 
""#4047# tidak menghadap ke persidangan atau menyuruh orang lain untuk menghadap sebagai kuasanya, meskipun telah diperintahkan langsung pada sidang yang lalu untuk datang menghadap pada sidang hari ini""

else
""#0142#""
end) data
from perkara_jadwal_sidang a
left join perkara_jadwal_sidang b on a.perkara_id=b.perkara_id and b.urutan=#0050#-1
where a.perkara_id=#perkara_id# and a.urutan=#0050#" where no_var=1073;;
update abt_variabel set default_data=NULL where no_var=1073;;
update abt_variabel set multi_sidang=NULL where no_var=1073;;
update abt_variabel set locked="1" where no_var=1073;;
update abt_variabel set modifier=NULL where no_var=1073;;
update abt_variabel set modified="2019-08-08 19:59:56" where no_var=1073;;


/*NOMOR VARIABEL 1076*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1076);;
update abt_variabel set nama="Tgl Relaas #0046#" where no_var=1076;;
update abt_variabel set data_type="data_sql" where no_var=1076;;
update abt_variabel set data_tabel=NULL where no_var=1076;;
update abt_variabel set data_kolom=NULL where no_var=1076;;
update abt_variabel set urutan_data=NULL where no_var=1076;;
update abt_variabel set referensi=NULL where no_var=1076;;
update abt_variabel set sql_query="select min(a.tanggal_relaas) data from perkara_pelaksanaan_relaas a
join v_pihak_perkara b on a.perkara_id=b.perkara_id and a.pihak_id=b.pihak_id
join perkara_jadwal_sidang c on a.perkara_id=c.perkara_id
where c.ikrar_talak=""T"" and b.urutan=1 and b.pihak_ke=1 and a.perkara_id=#perkara_id#" where no_var=1076;;
update abt_variabel set default_data=NULL where no_var=1076;;
update abt_variabel set multi_sidang=NULL where no_var=1076;;
update abt_variabel set locked="1" where no_var=1076;;
update abt_variabel set modifier=NULL where no_var=1076;;
update abt_variabel set modified="2019-09-15 12:39:52" where no_var=1076;;


/*NOMOR VARIABEL 1077*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1077);;
update abt_variabel set nama="Tgl Relaas #0047#" where no_var=1077;;
update abt_variabel set data_type="data_sql" where no_var=1077;;
update abt_variabel set data_tabel=NULL where no_var=1077;;
update abt_variabel set data_kolom=NULL where no_var=1077;;
update abt_variabel set urutan_data=NULL where no_var=1077;;
update abt_variabel set referensi=NULL where no_var=1077;;
update abt_variabel set sql_query="select min(a.tanggal_relaas) data from perkara_pelaksanaan_relaas a
join v_pihak_perkara b on a.perkara_id=b.perkara_id and a.pihak_id=b.pihak_id
join perkara_jadwal_sidang c on a.perkara_id=c.perkara_id
where c.ikrar_talak=""T"" and b.urutan=1 and b.pihak_ke=2 and a.perkara_id=#perkara_id#" where no_var=1077;;
update abt_variabel set default_data=NULL where no_var=1077;;
update abt_variabel set multi_sidang=NULL where no_var=1077;;
update abt_variabel set locked="1" where no_var=1077;;
update abt_variabel set modifier=NULL where no_var=1077;;
update abt_variabel set modified="2019-09-15 12:39:52" where no_var=1077;;


/*NOMOR VARIABEL 1079*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1079);;
update abt_variabel set nama="Tgl Relaas Ikrar Talak #0046#" where no_var=1079;;
update abt_variabel set data_type="data_sql" where no_var=1079;;
update abt_variabel set data_tabel=NULL where no_var=1079;;
update abt_variabel set data_kolom=NULL where no_var=1079;;
update abt_variabel set urutan_data=NULL where no_var=1079;;
update abt_variabel set referensi=NULL where no_var=1079;;
update abt_variabel set sql_query="select min(a.tanggal_relaas) data from perkara_pelaksanaan_relaas a
join v_pihak_perkara b on a.perkara_id=b.perkara_id and a.pihak_id=b.pihak_id
join perkara_jadwal_sidang c on a.perkara_id=c.perkara_id
where c.ikrar_talak=""Y"" and b.urutan=1 and b.pihak_ke=1 and a.perkara_id=#perkara_id#" where no_var=1079;;
update abt_variabel set default_data=NULL where no_var=1079;;
update abt_variabel set multi_sidang=NULL where no_var=1079;;
update abt_variabel set locked="1" where no_var=1079;;
update abt_variabel set modifier=NULL where no_var=1079;;
update abt_variabel set modified="2019-09-15 12:39:52" where no_var=1079;;


/*NOMOR VARIABEL 1080*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1080);;
update abt_variabel set nama="Tgl Relaas Ikrar Talak #0047#" where no_var=1080;;
update abt_variabel set data_type="data_sql" where no_var=1080;;
update abt_variabel set data_tabel=NULL where no_var=1080;;
update abt_variabel set data_kolom=NULL where no_var=1080;;
update abt_variabel set urutan_data=NULL where no_var=1080;;
update abt_variabel set referensi=NULL where no_var=1080;;
update abt_variabel set sql_query="select min(a.tanggal_relaas) data from perkara_pelaksanaan_relaas a
join v_pihak_perkara b on a.perkara_id=b.perkara_id and a.pihak_id=b.pihak_id
join perkara_jadwal_sidang c on a.perkara_id=c.perkara_id
where c.ikrar_talak=""Y"" and b.urutan=1 and b.pihak_ke=2 and a.perkara_id=#perkara_id#" where no_var=1080;;
update abt_variabel set default_data=NULL where no_var=1080;;
update abt_variabel set multi_sidang=NULL where no_var=1080;;
update abt_variabel set locked="1" where no_var=1080;;
update abt_variabel set modifier=NULL where no_var=1080;;
update abt_variabel set modified="2019-09-15 12:39:52" where no_var=1080;;


/*NOMOR VARIABEL 1090*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1090);;
update abt_variabel set nama="Biaya Panggilan #0046# 1x" where no_var=1090;;
update abt_variabel set data_type="data_sql" where no_var=1090;;
update abt_variabel set data_tabel=NULL where no_var=1090;;
update abt_variabel set data_kolom=NULL where no_var=1090;;
update abt_variabel set urutan_data=NULL where no_var=1090;;
update abt_variabel set referensi=NULL where no_var=1090;;
update abt_variabel set sql_query="select jumlah as data from perkara_biaya
where
jenis_biaya_id=12 and perkara_id=#perkara_id#
or
jenis_biaya_id=13 and perkara_id=#perkara_id#
ORDER BY tanggal_transaksi DESC LIMIT 1;" where no_var=1090;;
update abt_variabel set default_data=NULL where no_var=1090;;
update abt_variabel set multi_sidang=NULL where no_var=1090;;
update abt_variabel set locked="1" where no_var=1090;;
update abt_variabel set modifier=NULL where no_var=1090;;
update abt_variabel set modified="2019-08-08 20:00:33" where no_var=1090;;


/*NOMOR VARIABEL 1091*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1091);;
update abt_variabel set nama="Biaya Panggilan #0046#" where no_var=1091;;
update abt_variabel set data_type="data_sql" where no_var=1091;;
update abt_variabel set data_tabel=NULL where no_var=1091;;
update abt_variabel set data_kolom=NULL where no_var=1091;;
update abt_variabel set urutan_data=NULL where no_var=1091;;
update abt_variabel set referensi=NULL where no_var=1091;;
update abt_variabel set sql_query="select sum(jumlah) as data from perkara_biaya
where
jenis_biaya_id=12 and perkara_id=#perkara_id#
or
jenis_biaya_id=13 and perkara_id=#perkara_id#" where no_var=1091;;
update abt_variabel set default_data=NULL where no_var=1091;;
update abt_variabel set multi_sidang=NULL where no_var=1091;;
update abt_variabel set locked="1" where no_var=1091;;
update abt_variabel set modifier=NULL where no_var=1091;;
update abt_variabel set modified="2019-08-08 20:00:42" where no_var=1091;;


/*NOMOR VARIABEL 1092*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1092);;
update abt_variabel set nama="Biaya Panggilan #0047#" where no_var=1092;;
update abt_variabel set data_type="data_sql" where no_var=1092;;
update abt_variabel set data_tabel=NULL where no_var=1092;;
update abt_variabel set data_kolom=NULL where no_var=1092;;
update abt_variabel set urutan_data=NULL where no_var=1092;;
update abt_variabel set referensi=NULL where no_var=1092;;
update abt_variabel set sql_query="select sum(jumlah) as data from perkara_biaya
where 
jenis_biaya_id=14 and  perkara_id=#perkara_id#
or
jenis_biaya_id=15 and  perkara_id=#perkara_id#" where no_var=1092;;
update abt_variabel set default_data=NULL where no_var=1092;;
update abt_variabel set multi_sidang=NULL where no_var=1092;;
update abt_variabel set locked="1" where no_var=1092;;
update abt_variabel set modifier=NULL where no_var=1092;;
update abt_variabel set modified="2019-08-08 20:00:44" where no_var=1092;;


/*NOMOR VARIABEL 1098*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1098);;
update abt_variabel set nama="Tgl AC" where no_var=1098;;
update abt_variabel set data_type="data_sipp" where no_var=1098;;
update abt_variabel set data_tabel="perkara_akta_cerai" where no_var=1098;;
update abt_variabel set data_kolom="tgl_akta_cerai" where no_var=1098;;
update abt_variabel set urutan_data=NULL where no_var=1098;;
update abt_variabel set referensi=NULL where no_var=1098;;
update abt_variabel set sql_query=NULL where no_var=1098;;
update abt_variabel set default_data=NULL where no_var=1098;;
update abt_variabel set multi_sidang=NULL where no_var=1098;;
update abt_variabel set locked="1" where no_var=1098;;
update abt_variabel set modifier=NULL where no_var=1098;;
update abt_variabel set modified="2019-08-08 20:00:52" where no_var=1098;;


/*NOMOR VARIABEL 1099*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1099);;
update abt_variabel set nama="Tgl PHS Ikrar Talak" where no_var=1099;;
update abt_variabel set data_type="data_sipp" where no_var=1099;;
update abt_variabel set data_tabel="perkara_ikrar_talak" where no_var=1099;;
update abt_variabel set data_kolom="tanggal_penetapan_sidang_ikrar" where no_var=1099;;
update abt_variabel set urutan_data=NULL where no_var=1099;;
update abt_variabel set referensi=NULL where no_var=1099;;
update abt_variabel set sql_query=NULL where no_var=1099;;
update abt_variabel set default_data=NULL where no_var=1099;;
update abt_variabel set multi_sidang=NULL where no_var=1099;;
update abt_variabel set locked="1" where no_var=1099;;
update abt_variabel set modifier=NULL where no_var=1099;;
update abt_variabel set modified="2019-08-08 20:00:53" where no_var=1099;;


/*NOMOR VARIABEL 1135*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1135);;
update abt_variabel set nama="Tgl PHS awal" where no_var=1135;;
update abt_variabel set data_type="data_sql" where no_var=1135;;
update abt_variabel set data_tabel=NULL where no_var=1135;;
update abt_variabel set data_kolom=NULL where no_var=1135;;
update abt_variabel set urutan_data=NULL where no_var=1135;;
update abt_variabel set referensi=NULL where no_var=1135;;
update abt_variabel set sql_query="select min(tanggal_penetapan)data from perkara_penetapan_hari_sidang
where perkara_id=#perkara_id#" where no_var=1135;;
update abt_variabel set default_data=NULL where no_var=1135;;
update abt_variabel set multi_sidang=NULL where no_var=1135;;
update abt_variabel set locked="1" where no_var=1135;;
update abt_variabel set modifier=NULL where no_var=1135;;
update abt_variabel set modified="2019-08-08 20:01:06" where no_var=1135;;


/*NOMOR VARIABEL 1136*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1136);;
update abt_variabel set nama="Tgl PHS baru" where no_var=1136;;
update abt_variabel set data_type="data_sql" where no_var=1136;;
update abt_variabel set data_tabel=NULL where no_var=1136;;
update abt_variabel set data_kolom=NULL where no_var=1136;;
update abt_variabel set urutan_data=NULL where no_var=1136;;
update abt_variabel set referensi=NULL where no_var=1136;;
update abt_variabel set sql_query="select max(tanggal_penetapan)data from perkara_penetapan_hari_sidang
where perkara_id=#perkara_id#" where no_var=1136;;
update abt_variabel set default_data=NULL where no_var=1136;;
update abt_variabel set multi_sidang=NULL where no_var=1136;;
update abt_variabel set locked="1" where no_var=1136;;
update abt_variabel set modifier=NULL where no_var=1136;;
update abt_variabel set modified="2019-08-08 20:01:07" where no_var=1136;;


/*NOMOR VARIABEL 1137*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1137);;
update abt_variabel set nama="Tgl Sidang Awal" where no_var=1137;;
update abt_variabel set data_type="data_sql" where no_var=1137;;
update abt_variabel set data_tabel=NULL where no_var=1137;;
update abt_variabel set data_kolom=NULL where no_var=1137;;
update abt_variabel set urutan_data=NULL where no_var=1137;;
update abt_variabel set referensi=NULL where no_var=1137;;
update abt_variabel set sql_query="select min(tanggal_sidang)data from perkara_penetapan_hari_sidang
where perkara_id=#perkara_id#" where no_var=1137;;
update abt_variabel set default_data=NULL where no_var=1137;;
update abt_variabel set multi_sidang=NULL where no_var=1137;;
update abt_variabel set locked="1" where no_var=1137;;
update abt_variabel set modifier=NULL where no_var=1137;;
update abt_variabel set modified="2019-08-08 20:01:08" where no_var=1137;;


/*NOMOR VARIABEL 1138*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1138);;
update abt_variabel set nama="Tgl Sidang Baru" where no_var=1138;;
update abt_variabel set data_type="data_sql" where no_var=1138;;
update abt_variabel set data_tabel=NULL where no_var=1138;;
update abt_variabel set data_kolom=NULL where no_var=1138;;
update abt_variabel set urutan_data=NULL where no_var=1138;;
update abt_variabel set referensi=NULL where no_var=1138;;
update abt_variabel set sql_query="select max(tanggal_sidang)data from perkara_penetapan_hari_sidang
where perkara_id=#perkara_id#" where no_var=1138;;
update abt_variabel set default_data=NULL where no_var=1138;;
update abt_variabel set multi_sidang=NULL where no_var=1138;;
update abt_variabel set locked="1" where no_var=1138;;
update abt_variabel set modifier=NULL where no_var=1138;;
update abt_variabel set modified="2019-08-08 20:01:09" where no_var=1138;;


/*NOMOR VARIABEL 1142*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1142);;
update abt_variabel set nama="Agenda Sidang" where no_var=1142;;
update abt_variabel set data_type="multi_sidang" where no_var=1142;;
update abt_variabel set data_tabel=NULL where no_var=1142;;
update abt_variabel set data_kolom=NULL where no_var=1142;;
update abt_variabel set urutan_data=NULL where no_var=1142;;
update abt_variabel set referensi=NULL where no_var=1142;;
update abt_variabel set sql_query=NULL where no_var=1142;;
update abt_variabel set default_data=NULL where no_var=1142;;
update abt_variabel set multi_sidang="agenda" where no_var=1142;;
update abt_variabel set locked="1" where no_var=1142;;
update abt_variabel set modifier=NULL where no_var=1142;;
update abt_variabel set modified="2019-08-08 20:01:11" where no_var=1142;;


/*NOMOR VARIABEL 1143*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1143);;
update abt_variabel set nama="Tgl PMH awal" where no_var=1143;;
update abt_variabel set data_type="data_sql" where no_var=1143;;
update abt_variabel set data_tabel=NULL where no_var=1143;;
update abt_variabel set data_kolom=NULL where no_var=1143;;
update abt_variabel set urutan_data=NULL where no_var=1143;;
update abt_variabel set referensi=NULL where no_var=1143;;
update abt_variabel set sql_query="select tanggal as data from perkara_proses
where proses_id=20 and perkara_id=#perkara_id#" where no_var=1143;;
update abt_variabel set default_data=NULL where no_var=1143;;
update abt_variabel set multi_sidang=NULL where no_var=1143;;
update abt_variabel set locked="1" where no_var=1143;;
update abt_variabel set modifier=NULL where no_var=1143;;
update abt_variabel set modified="2019-08-08 20:01:13" where no_var=1143;;


/*NOMOR VARIABEL 1144*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1144);;
update abt_variabel set nama="Tgl PMH baru" where no_var=1144;;
update abt_variabel set data_type="data_sql" where no_var=1144;;
update abt_variabel set data_tabel=NULL where no_var=1144;;
update abt_variabel set data_kolom=NULL where no_var=1144;;
update abt_variabel set urutan_data=NULL where no_var=1144;;
update abt_variabel set referensi=NULL where no_var=1144;;
update abt_variabel set sql_query="select tanggal as data from perkara_proses
where proses_id=21 and perkara_id=#perkara_id#" where no_var=1144;;
update abt_variabel set default_data=NULL where no_var=1144;;
update abt_variabel set multi_sidang=NULL where no_var=1144;;
update abt_variabel set locked="1" where no_var=1144;;
update abt_variabel set modifier=NULL where no_var=1144;;
update abt_variabel set modified="2019-08-08 20:01:14" where no_var=1144;;


/*NOMOR VARIABEL 1145*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1145);;
update abt_variabel set nama="Tgl Penunjukan PP awal" where no_var=1145;;
update abt_variabel set data_type="data_sql" where no_var=1145;;
update abt_variabel set data_tabel=NULL where no_var=1145;;
update abt_variabel set data_kolom=NULL where no_var=1145;;
update abt_variabel set urutan_data=NULL where no_var=1145;;
update abt_variabel set referensi=NULL where no_var=1145;;
update abt_variabel set sql_query="select tanggal as data from perkara_proses
where proses_id=30 and perkara_id=#perkara_id#" where no_var=1145;;
update abt_variabel set default_data=NULL where no_var=1145;;
update abt_variabel set multi_sidang=NULL where no_var=1145;;
update abt_variabel set locked="1" where no_var=1145;;
update abt_variabel set modifier=NULL where no_var=1145;;
update abt_variabel set modified="2019-08-08 20:01:15" where no_var=1145;;


/*NOMOR VARIABEL 1146*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1146);;
update abt_variabel set nama="Tgl Penunjukan PP baru" where no_var=1146;;
update abt_variabel set data_type="data_sql" where no_var=1146;;
update abt_variabel set data_tabel=NULL where no_var=1146;;
update abt_variabel set data_kolom=NULL where no_var=1146;;
update abt_variabel set urutan_data=NULL where no_var=1146;;
update abt_variabel set referensi=NULL where no_var=1146;;
update abt_variabel set sql_query="select tanggal as data from perkara_proses
where proses_id=31 and perkara_id=#perkara_id#" where no_var=1146;;
update abt_variabel set default_data=NULL where no_var=1146;;
update abt_variabel set multi_sidang=NULL where no_var=1146;;
update abt_variabel set locked="1" where no_var=1146;;
update abt_variabel set modifier=NULL where no_var=1146;;
update abt_variabel set modified="2019-08-08 20:01:16" where no_var=1146;;


/*NOMOR VARIABEL 1173*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1173);;
update abt_variabel set nama="Warga Negara #0046#" where no_var=1173;;
update abt_variabel set data_type="data_sql" where no_var=1173;;
update abt_variabel set data_tabel=NULL where no_var=1173;;
update abt_variabel set data_kolom=NULL where no_var=1173;;
update abt_variabel set urutan_data=NULL where no_var=1173;;
update abt_variabel set referensi=NULL where no_var=1173;;
update abt_variabel set sql_query="select c.nama as data
from perkara_pihak1 a
join pihak b on a.pihak_id=b.id
join negara c on b.warga_negara_id=c.id
where a.urutan=1 and a.perkara_id=#perkara_id#" where no_var=1173;;
update abt_variabel set default_data=NULL where no_var=1173;;
update abt_variabel set multi_sidang=NULL where no_var=1173;;
update abt_variabel set locked="1" where no_var=1173;;
update abt_variabel set modifier=NULL where no_var=1173;;
update abt_variabel set modified="2019-08-08 20:01:46" where no_var=1173;;


/*NOMOR VARIABEL 1174*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1174);;
update abt_variabel set nama="Warga Negara #0046# II" where no_var=1174;;
update abt_variabel set data_type="data_sql" where no_var=1174;;
update abt_variabel set data_tabel=NULL where no_var=1174;;
update abt_variabel set data_kolom=NULL where no_var=1174;;
update abt_variabel set urutan_data=NULL where no_var=1174;;
update abt_variabel set referensi=NULL where no_var=1174;;
update abt_variabel set sql_query="select c.nama as data
from perkara_pihak1 a
join pihak b on a.pihak_id=b.id
join negara c on b.warga_negara_id=c.id
where a.urutan=2 and a.perkara_id=#perkara_id#" where no_var=1174;;
update abt_variabel set default_data=NULL where no_var=1174;;
update abt_variabel set multi_sidang=NULL where no_var=1174;;
update abt_variabel set locked="1" where no_var=1174;;
update abt_variabel set modifier=NULL where no_var=1174;;
update abt_variabel set modified="2019-08-08 20:01:47" where no_var=1174;;


/*NOMOR VARIABEL 1176*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1176);;
update abt_variabel set nama="Pendidikan #0046# II" where no_var=1176;;
update abt_variabel set data_type="data_sql" where no_var=1176;;
update abt_variabel set data_tabel=NULL where no_var=1176;;
update abt_variabel set data_kolom=NULL where no_var=1176;;
update abt_variabel set urutan_data=NULL where no_var=1176;;
update abt_variabel set referensi=NULL where no_var=1176;;
update abt_variabel set sql_query="select c.kode as data from perkara_pihak1 a
join pihak b on a.pihak_id=b.id
join tingkat_pendidikan c on b.pendidikan_id=c.id
where urutan=2 and perkara_id=#perkara_id#" where no_var=1176;;
update abt_variabel set default_data=NULL where no_var=1176;;
update abt_variabel set multi_sidang=NULL where no_var=1176;;
update abt_variabel set locked="1" where no_var=1176;;
update abt_variabel set modifier=NULL where no_var=1176;;
update abt_variabel set modified="2019-08-08 20:01:54" where no_var=1176;;


/*NOMOR VARIABEL 1182*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1182);;
update abt_variabel set nama="Tgl Sidang Ikrar Talak" where no_var=1182;;
update abt_variabel set data_type="data_sipp" where no_var=1182;;
update abt_variabel set data_tabel="perkara_ikrar_talak" where no_var=1182;;
update abt_variabel set data_kolom="tgl_ikrar_talak" where no_var=1182;;
update abt_variabel set urutan_data=NULL where no_var=1182;;
update abt_variabel set referensi=NULL where no_var=1182;;
update abt_variabel set sql_query=NULL where no_var=1182;;
update abt_variabel set default_data=NULL where no_var=1182;;
update abt_variabel set multi_sidang=NULL where no_var=1182;;
update abt_variabel set locked="1" where no_var=1182;;
update abt_variabel set modifier=NULL where no_var=1182;;
update abt_variabel set modified="2019-08-08 20:02:03" where no_var=1182;;


/*NOMOR VARIABEL 1197*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1197);;
update abt_variabel set nama="Nama Saksi 1 P" where no_var=1197;;
update abt_variabel set data_type="data_sql" where no_var=1197;;
update abt_variabel set data_tabel=NULL where no_var=1197;;
update abt_variabel set data_kolom=NULL where no_var=1197;;
update abt_variabel set urutan_data=NULL where no_var=1197;;
update abt_variabel set referensi=NULL where no_var=1197;;
update abt_variabel set sql_query="select nama as data from perkara_pihak5
where saksi_pihak_ke=1 and perkara_id=#perkara_id#
order by urutan
limit 0,1" where no_var=1197;;
update abt_variabel set default_data=NULL where no_var=1197;;
update abt_variabel set multi_sidang=NULL where no_var=1197;;
update abt_variabel set locked="1" where no_var=1197;;
update abt_variabel set modifier=NULL where no_var=1197;;
update abt_variabel set modified="2019-08-08 20:02:23" where no_var=1197;;


/*NOMOR VARIABEL 1198*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1198);;
update abt_variabel set nama="Umur Saksi 1 P" where no_var=1198;;
update abt_variabel set data_type="data_sql" where no_var=1198;;
update abt_variabel set data_tabel=NULL where no_var=1198;;
update abt_variabel set data_kolom=NULL where no_var=1198;;
update abt_variabel set urutan_data=NULL where no_var=1198;;
update abt_variabel set referensi=NULL where no_var=1198;;
update abt_variabel set sql_query="select (get_umur(b.tanggal_lahir,a.diinput_tanggal))as data
from perkara_pihak5 a
join pihak b on a.pihak_id=b.id
where a.saksi_pihak_ke=1 and a.perkara_id=#perkara_id#
order by a.urutan
limit 0,1" where no_var=1198;;
update abt_variabel set default_data=NULL where no_var=1198;;
update abt_variabel set multi_sidang=NULL where no_var=1198;;
update abt_variabel set locked="1" where no_var=1198;;
update abt_variabel set modifier=NULL where no_var=1198;;
update abt_variabel set modified="2019-08-08 20:02:24" where no_var=1198;;


/*NOMOR VARIABEL 1199*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1199);;
update abt_variabel set nama="Agama Saksi 1 P" where no_var=1199;;
update abt_variabel set data_type="data_sql" where no_var=1199;;
update abt_variabel set data_tabel=NULL where no_var=1199;;
update abt_variabel set data_kolom=NULL where no_var=1199;;
update abt_variabel set urutan_data=NULL where no_var=1199;;
update abt_variabel set referensi=NULL where no_var=1199;;
update abt_variabel set sql_query="select c.nama as data
from perkara_pihak5 a
join pihak b on a.pihak_id=b.id
join agama c on b.agama_id=c.id
where a.saksi_pihak_ke=1 and a.perkara_id=#perkara_id#
order by a.urutan
limit 0,1" where no_var=1199;;
update abt_variabel set default_data=NULL where no_var=1199;;
update abt_variabel set multi_sidang=NULL where no_var=1199;;
update abt_variabel set locked="1" where no_var=1199;;
update abt_variabel set modifier=NULL where no_var=1199;;
update abt_variabel set modified="2019-08-08 20:02:25" where no_var=1199;;


/*NOMOR VARIABEL 1200*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1200);;
update abt_variabel set nama="Pendidikan Saksi 1 P" where no_var=1200;;
update abt_variabel set data_type="data_sql" where no_var=1200;;
update abt_variabel set data_tabel=NULL where no_var=1200;;
update abt_variabel set data_kolom=NULL where no_var=1200;;
update abt_variabel set urutan_data=NULL where no_var=1200;;
update abt_variabel set referensi=NULL where no_var=1200;;
update abt_variabel set sql_query="select c.kode as data from perkara_pihak5 a
join pihak b on a.pihak_id=b.id
join tingkat_pendidikan c on b.pendidikan_id=c.id
where a.saksi_pihak_ke=1 and a.perkara_id=#perkara_id#
order by a.urutan
limit 0,1" where no_var=1200;;
update abt_variabel set default_data=NULL where no_var=1200;;
update abt_variabel set multi_sidang=NULL where no_var=1200;;
update abt_variabel set locked="1" where no_var=1200;;
update abt_variabel set modifier=NULL where no_var=1200;;
update abt_variabel set modified="2019-08-08 20:02:26" where no_var=1200;;


/*NOMOR VARIABEL 1201*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1201);;
update abt_variabel set nama="Pekerjaan Saksi 1 P" where no_var=1201;;
update abt_variabel set data_type="data_sql" where no_var=1201;;
update abt_variabel set data_tabel=NULL where no_var=1201;;
update abt_variabel set data_kolom=NULL where no_var=1201;;
update abt_variabel set urutan_data=NULL where no_var=1201;;
update abt_variabel set referensi=NULL where no_var=1201;;
update abt_variabel set sql_query="select b.pekerjaan as data
from perkara_pihak5 a
join pihak b on a.pihak_id=b.id
where a.saksi_pihak_ke=1 and a.perkara_id=#perkara_id#
order by a.urutan
limit 0,1" where no_var=1201;;
update abt_variabel set default_data=NULL where no_var=1201;;
update abt_variabel set multi_sidang=NULL where no_var=1201;;
update abt_variabel set locked="1" where no_var=1201;;
update abt_variabel set modifier=NULL where no_var=1201;;
update abt_variabel set modified="2019-08-08 20:02:27" where no_var=1201;;


/*NOMOR VARIABEL 1202*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1202);;
update abt_variabel set nama="Alamat Saksi 1 P" where no_var=1202;;
update abt_variabel set data_type="data_sql" where no_var=1202;;
update abt_variabel set data_tabel=NULL where no_var=1202;;
update abt_variabel set data_kolom=NULL where no_var=1202;;
update abt_variabel set urutan_data=NULL where no_var=1202;;
update abt_variabel set referensi=NULL where no_var=1202;;
update abt_variabel set sql_query="select alamat as data from perkara_pihak5
where saksi_pihak_ke=1 and perkara_id=#perkara_id#
order by urutan
limit 0,1" where no_var=1202;;
update abt_variabel set default_data=NULL where no_var=1202;;
update abt_variabel set multi_sidang=NULL where no_var=1202;;
update abt_variabel set locked="1" where no_var=1202;;
update abt_variabel set modifier=NULL where no_var=1202;;
update abt_variabel set modified="2019-08-08 20:02:28" where no_var=1202;;


/*NOMOR VARIABEL 1203*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1203);;
update abt_variabel set nama="Nama Saksi 2 P" where no_var=1203;;
update abt_variabel set data_type="data_sql" where no_var=1203;;
update abt_variabel set data_tabel=NULL where no_var=1203;;
update abt_variabel set data_kolom=NULL where no_var=1203;;
update abt_variabel set urutan_data=NULL where no_var=1203;;
update abt_variabel set referensi=NULL where no_var=1203;;
update abt_variabel set sql_query="select nama as data from perkara_pihak5
where saksi_pihak_ke=1 and perkara_id=#perkara_id#
order by urutan
limit 1,1" where no_var=1203;;
update abt_variabel set default_data=NULL where no_var=1203;;
update abt_variabel set multi_sidang=NULL where no_var=1203;;
update abt_variabel set locked="1" where no_var=1203;;
update abt_variabel set modifier=NULL where no_var=1203;;
update abt_variabel set modified="2019-08-08 20:02:29" where no_var=1203;;


/*NOMOR VARIABEL 1204*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1204);;
update abt_variabel set nama="Umur Saksi 2 P" where no_var=1204;;
update abt_variabel set data_type="data_sql" where no_var=1204;;
update abt_variabel set data_tabel=NULL where no_var=1204;;
update abt_variabel set data_kolom=NULL where no_var=1204;;
update abt_variabel set urutan_data=NULL where no_var=1204;;
update abt_variabel set referensi=NULL where no_var=1204;;
update abt_variabel set sql_query="select (get_umur(b.tanggal_lahir,a.diinput_tanggal))as data
from perkara_pihak5 a
join pihak b on a.pihak_id=b.id
where a.saksi_pihak_ke=1 and a.perkara_id=#perkara_id#
order by a.urutan
limit 1,1" where no_var=1204;;
update abt_variabel set default_data=NULL where no_var=1204;;
update abt_variabel set multi_sidang=NULL where no_var=1204;;
update abt_variabel set locked="1" where no_var=1204;;
update abt_variabel set modifier=NULL where no_var=1204;;
update abt_variabel set modified="2019-08-08 20:02:30" where no_var=1204;;


/*NOMOR VARIABEL 1205*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1205);;
update abt_variabel set nama="Agama Saksi 2 P" where no_var=1205;;
update abt_variabel set data_type="data_sql" where no_var=1205;;
update abt_variabel set data_tabel=NULL where no_var=1205;;
update abt_variabel set data_kolom=NULL where no_var=1205;;
update abt_variabel set urutan_data=NULL where no_var=1205;;
update abt_variabel set referensi=NULL where no_var=1205;;
update abt_variabel set sql_query="select c.nama as data
from perkara_pihak5 a
join pihak b on a.pihak_id=b.id
join agama c on b.agama_id=c.id
where a.saksi_pihak_ke=1 and a.perkara_id=#perkara_id#
order by a.urutan
limit 1,1" where no_var=1205;;
update abt_variabel set default_data=NULL where no_var=1205;;
update abt_variabel set multi_sidang=NULL where no_var=1205;;
update abt_variabel set locked="1" where no_var=1205;;
update abt_variabel set modifier=NULL where no_var=1205;;
update abt_variabel set modified="2019-08-08 20:02:31" where no_var=1205;;


/*NOMOR VARIABEL 1206*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1206);;
update abt_variabel set nama="Pendidikan Saksi 2 P" where no_var=1206;;
update abt_variabel set data_type="data_sql" where no_var=1206;;
update abt_variabel set data_tabel=NULL where no_var=1206;;
update abt_variabel set data_kolom=NULL where no_var=1206;;
update abt_variabel set urutan_data=NULL where no_var=1206;;
update abt_variabel set referensi=NULL where no_var=1206;;
update abt_variabel set sql_query="select c.kode as data from perkara_pihak5 a
join pihak b on a.pihak_id=b.id
join tingkat_pendidikan c on b.pendidikan_id=c.id
where a.saksi_pihak_ke=1 and a.perkara_id=#perkara_id#
order by a.urutan
limit 1,1" where no_var=1206;;
update abt_variabel set default_data=NULL where no_var=1206;;
update abt_variabel set multi_sidang=NULL where no_var=1206;;
update abt_variabel set locked="1" where no_var=1206;;
update abt_variabel set modifier=NULL where no_var=1206;;
update abt_variabel set modified="2019-08-08 20:02:32" where no_var=1206;;


/*NOMOR VARIABEL 1207*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1207);;
update abt_variabel set nama="Pekerjaan Saksi 2 P" where no_var=1207;;
update abt_variabel set data_type="data_sql" where no_var=1207;;
update abt_variabel set data_tabel=NULL where no_var=1207;;
update abt_variabel set data_kolom=NULL where no_var=1207;;
update abt_variabel set urutan_data=NULL where no_var=1207;;
update abt_variabel set referensi=NULL where no_var=1207;;
update abt_variabel set sql_query="select b.pekerjaan as data
from perkara_pihak5 a
join pihak b on a.pihak_id=b.id
where a.saksi_pihak_ke=1 and a.perkara_id=#perkara_id#
order by a.urutan
limit 1,1" where no_var=1207;;
update abt_variabel set default_data=NULL where no_var=1207;;
update abt_variabel set multi_sidang=NULL where no_var=1207;;
update abt_variabel set locked="1" where no_var=1207;;
update abt_variabel set modifier=NULL where no_var=1207;;
update abt_variabel set modified="2019-08-08 20:02:32" where no_var=1207;;


/*NOMOR VARIABEL 1208*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1208);;
update abt_variabel set nama="Alamat Saksi 2 P" where no_var=1208;;
update abt_variabel set data_type="data_sql" where no_var=1208;;
update abt_variabel set data_tabel=NULL where no_var=1208;;
update abt_variabel set data_kolom=NULL where no_var=1208;;
update abt_variabel set urutan_data=NULL where no_var=1208;;
update abt_variabel set referensi=NULL where no_var=1208;;
update abt_variabel set sql_query="select alamat as data from perkara_pihak5
where saksi_pihak_ke=1 and perkara_id=#perkara_id#
order by urutan
limit 1,1" where no_var=1208;;
update abt_variabel set default_data=NULL where no_var=1208;;
update abt_variabel set multi_sidang=NULL where no_var=1208;;
update abt_variabel set locked="1" where no_var=1208;;
update abt_variabel set modifier=NULL where no_var=1208;;
update abt_variabel set modified="2019-08-08 20:02:36" where no_var=1208;;


/*NOMOR VARIABEL 1216*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1216);;
update abt_variabel set nama="Hari Putusan" where no_var=1216;;
update abt_variabel set data_type="tanggal_hari" where no_var=1216;;
update abt_variabel set data_tabel=NULL where no_var=1216;;
update abt_variabel set data_kolom=NULL where no_var=1216;;
update abt_variabel set urutan_data=NULL where no_var=1216;;
update abt_variabel set referensi="1069" where no_var=1216;;
update abt_variabel set sql_query=NULL where no_var=1216;;
update abt_variabel set default_data=NULL where no_var=1216;;
update abt_variabel set multi_sidang=NULL where no_var=1216;;
update abt_variabel set locked="1" where no_var=1216;;
update abt_variabel set modifier=NULL where no_var=1216;;
update abt_variabel set modified="2019-08-08 20:02:44" where no_var=1216;;


/*NOMOR VARIABEL 1258*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1258);;
update abt_variabel set nama="Tempat Sidang dilangsungkan" where no_var=1258;;
update abt_variabel set data_type="multi_sidang" where no_var=1258;;
update abt_variabel set data_tabel=NULL where no_var=1258;;
update abt_variabel set data_kolom=NULL where no_var=1258;;
update abt_variabel set urutan_data=NULL where no_var=1258;;
update abt_variabel set referensi=NULL where no_var=1258;;
update abt_variabel set sql_query=NULL where no_var=1258;;
update abt_variabel set default_data=NULL where no_var=1258;;
update abt_variabel set multi_sidang="ruangan" where no_var=1258;;
update abt_variabel set locked="1" where no_var=1258;;
update abt_variabel set modifier=NULL where no_var=1258;;
update abt_variabel set modified="2019-08-08 20:03:09" where no_var=1258;;


/*NOMOR VARIABEL 1263*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1263);;
update abt_variabel set nama="No. Seri AC" where no_var=1263;;
update abt_variabel set data_type="data_sipp" where no_var=1263;;
update abt_variabel set data_tabel="perkara_akta_cerai" where no_var=1263;;
update abt_variabel set data_kolom="no_seri_akta_cerai" where no_var=1263;;
update abt_variabel set urutan_data=NULL where no_var=1263;;
update abt_variabel set referensi=NULL where no_var=1263;;
update abt_variabel set sql_query=NULL where no_var=1263;;
update abt_variabel set default_data=NULL where no_var=1263;;
update abt_variabel set multi_sidang=NULL where no_var=1263;;
update abt_variabel set locked="1" where no_var=1263;;
update abt_variabel set modifier=NULL where no_var=1263;;
update abt_variabel set modified="2019-08-08 20:03:14" where no_var=1263;;


/*NOMOR VARIABEL 1278*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1278);;
update abt_variabel set nama="Tanggal Minutasi" where no_var=1278;;
update abt_variabel set data_type="data_sipp" where no_var=1278;;
update abt_variabel set data_tabel="perkara_putusan" where no_var=1278;;
update abt_variabel set data_kolom="tanggal_minutasi" where no_var=1278;;
update abt_variabel set urutan_data=NULL where no_var=1278;;
update abt_variabel set referensi=NULL where no_var=1278;;
update abt_variabel set sql_query=NULL where no_var=1278;;
update abt_variabel set default_data=NULL where no_var=1278;;
update abt_variabel set multi_sidang=NULL where no_var=1278;;
update abt_variabel set locked="1" where no_var=1278;;
update abt_variabel set modifier=NULL where no_var=1278;;
update abt_variabel set modified="2019-08-08 20:03:15" where no_var=1278;;


/*NOMOR VARIABEL 1295*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1295);;
update abt_variabel set nama="Tgl. Tambah Panjar" where no_var=1295;;
update abt_variabel set data_type="data_sql" where no_var=1295;;
update abt_variabel set data_tabel=NULL where no_var=1295;;
update abt_variabel set data_kolom=NULL where no_var=1295;;
update abt_variabel set urutan_data=NULL where no_var=1295;;
update abt_variabel set referensi=NULL where no_var=1295;;
update abt_variabel set sql_query="select tanggal_transaksi as data from perkara_biaya
where jenis_biaya_id=224 and perkara_id=#perkara_id#" where no_var=1295;;
update abt_variabel set default_data=NULL where no_var=1295;;
update abt_variabel set multi_sidang=NULL where no_var=1295;;
update abt_variabel set locked="1" where no_var=1295;;
update abt_variabel set modifier=NULL where no_var=1295;;
update abt_variabel set modified="2019-08-08 20:03:26" where no_var=1295;;


/*NOMOR VARIABEL 1328*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (1328);;
update abt_variabel set nama="Saksi Meninggalan Tempat / Ruang Sidang" where no_var=1328;;
update abt_variabel set data_type="data_sql" where no_var=1328;;
update abt_variabel set data_tabel=NULL where no_var=1328;;
update abt_variabel set data_kolom=NULL where no_var=1328;;
update abt_variabel set urutan_data=NULL where no_var=1328;;
update abt_variabel set referensi=NULL where no_var=1328;;
update abt_variabel set sql_query="select (case when pihak_dipublikasikan=""T"" then ""meninggalkan ruang sidang"" 
else ""meninggalkan tempat atau kembali ketempat"" end) as data 
from perkara where perkara_id=#perkara_id#" where no_var=1328;;
update abt_variabel set default_data=NULL where no_var=1328;;
update abt_variabel set multi_sidang=NULL where no_var=1328;;
update abt_variabel set locked="1" where no_var=1328;;
update abt_variabel set modifier="admin" where no_var=1328;;
update abt_variabel set modified="2019-09-15 12:39:52" where no_var=1328;;


/*NOMOR VARIABEL 2012*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (2012);;
update abt_variabel set nama="Hari AC" where no_var=2012;;
update abt_variabel set data_type="tanggal_hari" where no_var=2012;;
update abt_variabel set data_tabel=NULL where no_var=2012;;
update abt_variabel set data_kolom=NULL where no_var=2012;;
update abt_variabel set urutan_data=NULL where no_var=2012;;
update abt_variabel set referensi="1098" where no_var=2012;;
update abt_variabel set sql_query=NULL where no_var=2012;;
update abt_variabel set default_data=NULL where no_var=2012;;
update abt_variabel set multi_sidang=NULL where no_var=2012;;
update abt_variabel set locked="1" where no_var=2012;;
update abt_variabel set modifier="admin" where no_var=2012;;
update abt_variabel set modified="2019-09-15 12:19:36" where no_var=2012;;


/*NOMOR VARIABEL 2013*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (2013);;
update abt_variabel set nama="Hijriah AC" where no_var=2013;;
update abt_variabel set data_type="tanggal_hijriah" where no_var=2013;;
update abt_variabel set data_tabel=NULL where no_var=2013;;
update abt_variabel set data_kolom=NULL where no_var=2013;;
update abt_variabel set urutan_data=NULL where no_var=2013;;
update abt_variabel set referensi="1098" where no_var=2013;;
update abt_variabel set sql_query=NULL where no_var=2013;;
update abt_variabel set default_data=NULL where no_var=2013;;
update abt_variabel set multi_sidang=NULL where no_var=2013;;
update abt_variabel set locked="1" where no_var=2013;;
update abt_variabel set modifier="admin" where no_var=2013;;
update abt_variabel set modified="2019-09-15 12:19:39" where no_var=2013;;


/*NOMOR VARIABEL 2018*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (2018);;
update abt_variabel set nama="Keterangan Jawaban Lisan #0047#" where no_var=2018;;
update abt_variabel set data_type="tanya_jawab" where no_var=2018;;
update abt_variabel set data_tabel=NULL where no_var=2018;;
update abt_variabel set data_kolom=NULL where no_var=2018;;
update abt_variabel set urutan_data=NULL where no_var=2018;;
update abt_variabel set referensi="0102" where no_var=2018;;
update abt_variabel set sql_query=NULL where no_var=2018;;
update abt_variabel set default_data=NULL where no_var=2018;;
update abt_variabel set multi_sidang="keterangan" where no_var=2018;;
update abt_variabel set locked="1" where no_var=2018;;
update abt_variabel set modifier=NULL where no_var=2018;;
update abt_variabel set modified="2019-08-08 20:04:47" where no_var=2018;;


/*NOMOR VARIABEL 2019*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (2019);;
update abt_variabel set nama="Keterangan Replik Lisan #0046#" where no_var=2019;;
update abt_variabel set data_type="tanya_jawab" where no_var=2019;;
update abt_variabel set data_tabel=NULL where no_var=2019;;
update abt_variabel set data_kolom=NULL where no_var=2019;;
update abt_variabel set urutan_data=NULL where no_var=2019;;
update abt_variabel set referensi="0098" where no_var=2019;;
update abt_variabel set sql_query=NULL where no_var=2019;;
update abt_variabel set default_data=NULL where no_var=2019;;
update abt_variabel set multi_sidang="keterangan" where no_var=2019;;
update abt_variabel set locked="1" where no_var=2019;;
update abt_variabel set modifier=NULL where no_var=2019;;
update abt_variabel set modified="2019-08-08 20:04:48" where no_var=2019;;


/*NOMOR VARIABEL 2020*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (2020);;
update abt_variabel set nama="Keterangan Duplik Lisan #0047#" where no_var=2020;;
update abt_variabel set data_type="tanya_jawab" where no_var=2020;;
update abt_variabel set data_tabel=NULL where no_var=2020;;
update abt_variabel set data_kolom=NULL where no_var=2020;;
update abt_variabel set urutan_data=NULL where no_var=2020;;
update abt_variabel set referensi="0102" where no_var=2020;;
update abt_variabel set sql_query=NULL where no_var=2020;;
update abt_variabel set default_data=NULL where no_var=2020;;
update abt_variabel set multi_sidang="keterangan" where no_var=2020;;
update abt_variabel set locked="1" where no_var=2020;;
update abt_variabel set modifier=NULL where no_var=2020;;
update abt_variabel set modified="2019-08-08 20:04:50" where no_var=2020;;


/*NOMOR VARIABEL 2021*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (2021);;
update abt_variabel set nama="Keterangan Saksi 1 P" where no_var=2021;;
update abt_variabel set data_type="tanya_jawab" where no_var=2021;;
update abt_variabel set data_tabel=NULL where no_var=2021;;
update abt_variabel set data_kolom=NULL where no_var=2021;;
update abt_variabel set urutan_data=NULL where no_var=2021;;
update abt_variabel set referensi="1197" where no_var=2021;;
update abt_variabel set sql_query=NULL where no_var=2021;;
update abt_variabel set default_data=NULL where no_var=2021;;
update abt_variabel set multi_sidang="keterangan" where no_var=2021;;
update abt_variabel set locked="1" where no_var=2021;;
update abt_variabel set modifier=NULL where no_var=2021;;
update abt_variabel set modified="2019-08-08 20:04:52" where no_var=2021;;


/*NOMOR VARIABEL 2022*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (2022);;
update abt_variabel set nama="Keterangan Saksi 2 P" where no_var=2022;;
update abt_variabel set data_type="tanya_jawab" where no_var=2022;;
update abt_variabel set data_tabel=NULL where no_var=2022;;
update abt_variabel set data_kolom=NULL where no_var=2022;;
update abt_variabel set urutan_data=NULL where no_var=2022;;
update abt_variabel set referensi="1203" where no_var=2022;;
update abt_variabel set sql_query=NULL where no_var=2022;;
update abt_variabel set default_data=NULL where no_var=2022;;
update abt_variabel set multi_sidang="keterangan" where no_var=2022;;
update abt_variabel set locked="1" where no_var=2022;;
update abt_variabel set modifier=NULL where no_var=2022;;
update abt_variabel set modified="2019-08-08 20:04:53" where no_var=2022;;


/*NOMOR VARIABEL 2023*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (2023);;
update abt_variabel set nama="Keterangan Saksi 1 T" where no_var=2023;;
update abt_variabel set data_type="tanya_jawab" where no_var=2023;;
update abt_variabel set data_tabel=NULL where no_var=2023;;
update abt_variabel set data_kolom=NULL where no_var=2023;;
update abt_variabel set urutan_data=NULL where no_var=2023;;
update abt_variabel set referensi="6100" where no_var=2023;;
update abt_variabel set sql_query=NULL where no_var=2023;;
update abt_variabel set default_data=NULL where no_var=2023;;
update abt_variabel set multi_sidang="keterangan" where no_var=2023;;
update abt_variabel set locked="1" where no_var=2023;;
update abt_variabel set modifier=NULL where no_var=2023;;
update abt_variabel set modified="2019-08-08 20:04:54" where no_var=2023;;


/*NOMOR VARIABEL 2024*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (2024);;
update abt_variabel set nama="Keterangan Saksi 2 T" where no_var=2024;;
update abt_variabel set data_type="tanya_jawab" where no_var=2024;;
update abt_variabel set data_tabel=NULL where no_var=2024;;
update abt_variabel set data_kolom=NULL where no_var=2024;;
update abt_variabel set urutan_data=NULL where no_var=2024;;
update abt_variabel set referensi="6106" where no_var=2024;;
update abt_variabel set sql_query=NULL where no_var=2024;;
update abt_variabel set default_data=NULL where no_var=2024;;
update abt_variabel set multi_sidang="keterangan" where no_var=2024;;
update abt_variabel set locked="1" where no_var=2024;;
update abt_variabel set modifier=NULL where no_var=2024;;
update abt_variabel set modified="2019-08-08 20:04:58" where no_var=2024;;


/*NOMOR VARIABEL 2031*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (2031);;
update abt_variabel set nama="Keterangan Saksi 3 P" where no_var=2031;;
update abt_variabel set data_type="tanya_jawab" where no_var=2031;;
update abt_variabel set data_tabel=NULL where no_var=2031;;
update abt_variabel set data_kolom=NULL where no_var=2031;;
update abt_variabel set urutan_data=NULL where no_var=2031;;
update abt_variabel set referensi="6132" where no_var=2031;;
update abt_variabel set sql_query=NULL where no_var=2031;;
update abt_variabel set default_data=NULL where no_var=2031;;
update abt_variabel set multi_sidang="keterangan" where no_var=2031;;
update abt_variabel set locked="1" where no_var=2031;;
update abt_variabel set modifier=NULL where no_var=2031;;
update abt_variabel set modified="2019-08-08 20:05:09" where no_var=2031;;


/*NOMOR VARIABEL 2032*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (2032);;
update abt_variabel set nama="Keterangan Saksi 3 T" where no_var=2032;;
update abt_variabel set data_type="tanya_jawab" where no_var=2032;;
update abt_variabel set data_tabel=NULL where no_var=2032;;
update abt_variabel set data_kolom=NULL where no_var=2032;;
update abt_variabel set urutan_data=NULL where no_var=2032;;
update abt_variabel set referensi="6138" where no_var=2032;;
update abt_variabel set sql_query=NULL where no_var=2032;;
update abt_variabel set default_data=NULL where no_var=2032;;
update abt_variabel set multi_sidang="keterangan" where no_var=2032;;
update abt_variabel set locked="1" where no_var=2032;;
update abt_variabel set modifier=NULL where no_var=2032;;
update abt_variabel set modified="2019-08-08 20:05:10" where no_var=2032;;


/*NOMOR VARIABEL 2041*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (2041);;
update abt_variabel set nama="Saksi 1 P - bersumpah/berjanji" where no_var=2041;;
update abt_variabel set data_type="data_sql" where no_var=2041;;
update abt_variabel set data_tabel=NULL where no_var=2041;;
update abt_variabel set data_kolom=NULL where no_var=2041;;
update abt_variabel set urutan_data=NULL where no_var=2041;;
update abt_variabel set referensi=NULL where no_var=2041;;
update abt_variabel set sql_query="select (case when ""#1199#"" = ""Protestan"" or ""#1199#"" = ""Katolik"" then ""berjanji""
else ""bersumpah"" end) as data" where no_var=2041;;
update abt_variabel set default_data=NULL where no_var=2041;;
update abt_variabel set multi_sidang=NULL where no_var=2041;;
update abt_variabel set locked="1" where no_var=2041;;
update abt_variabel set modifier=NULL where no_var=2041;;
update abt_variabel set modified="2019-08-08 20:05:14" where no_var=2041;;


/*NOMOR VARIABEL 2042*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (2042);;
update abt_variabel set nama="Saksi 2 P - bersumpah/berjanji" where no_var=2042;;
update abt_variabel set data_type="data_sql" where no_var=2042;;
update abt_variabel set data_tabel=NULL where no_var=2042;;
update abt_variabel set data_kolom=NULL where no_var=2042;;
update abt_variabel set urutan_data=NULL where no_var=2042;;
update abt_variabel set referensi=NULL where no_var=2042;;
update abt_variabel set sql_query="select (case when ""#1205#"" = ""Protestan"" or ""#1205#"" = ""Katolik"" then ""berjanji""
else ""bersumpah"" end) as data" where no_var=2042;;
update abt_variabel set default_data=NULL where no_var=2042;;
update abt_variabel set multi_sidang=NULL where no_var=2042;;
update abt_variabel set locked="1" where no_var=2042;;
update abt_variabel set modifier=NULL where no_var=2042;;
update abt_variabel set modified="2019-08-08 20:05:15" where no_var=2042;;


/*NOMOR VARIABEL 2043*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (2043);;
update abt_variabel set nama="Saksi 1 T - bersumpah/berjanji" where no_var=2043;;
update abt_variabel set data_type="data_sql" where no_var=2043;;
update abt_variabel set data_tabel=NULL where no_var=2043;;
update abt_variabel set data_kolom=NULL where no_var=2043;;
update abt_variabel set urutan_data=NULL where no_var=2043;;
update abt_variabel set referensi=NULL where no_var=2043;;
update abt_variabel set sql_query="select (case when ""#6102#"" = ""Protestan"" or ""#6102#"" = ""Katolik"" then ""berjanji""
else ""bersumpah"" end) as data" where no_var=2043;;
update abt_variabel set default_data=NULL where no_var=2043;;
update abt_variabel set multi_sidang=NULL where no_var=2043;;
update abt_variabel set locked="1" where no_var=2043;;
update abt_variabel set modifier=NULL where no_var=2043;;
update abt_variabel set modified="2019-08-08 20:05:16" where no_var=2043;;


/*NOMOR VARIABEL 2044*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (2044);;
update abt_variabel set nama="Saksi 2 T - bersumpah/berjanji" where no_var=2044;;
update abt_variabel set data_type="data_sql" where no_var=2044;;
update abt_variabel set data_tabel=NULL where no_var=2044;;
update abt_variabel set data_kolom=NULL where no_var=2044;;
update abt_variabel set urutan_data=NULL where no_var=2044;;
update abt_variabel set referensi=NULL where no_var=2044;;
update abt_variabel set sql_query="select (case when ""#6108#"" = ""Protestan"" or ""#6108#"" = ""Katolik"" then ""berjanji""
else ""bersumpah"" end) as data" where no_var=2044;;
update abt_variabel set default_data=NULL where no_var=2044;;
update abt_variabel set multi_sidang=NULL where no_var=2044;;
update abt_variabel set locked="1" where no_var=2044;;
update abt_variabel set modifier=NULL where no_var=2044;;
update abt_variabel set modified="2019-08-08 20:05:17" where no_var=2044;;


/*NOMOR VARIABEL 2098*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (2098);;
update abt_variabel set nama="Hari Sidang PHS Awal" where no_var=2098;;
update abt_variabel set data_type="tanggal_hari" where no_var=2098;;
update abt_variabel set data_tabel=NULL where no_var=2098;;
update abt_variabel set data_kolom=NULL where no_var=2098;;
update abt_variabel set urutan_data=NULL where no_var=2098;;
update abt_variabel set referensi="1137" where no_var=2098;;
update abt_variabel set sql_query=NULL where no_var=2098;;
update abt_variabel set default_data=NULL where no_var=2098;;
update abt_variabel set multi_sidang=NULL where no_var=2098;;
update abt_variabel set locked="1" where no_var=2098;;
update abt_variabel set modifier=NULL where no_var=2098;;
update abt_variabel set modified="2019-08-08 20:05:26" where no_var=2098;;


/*NOMOR VARIABEL 2099*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (2099);;
update abt_variabel set nama="Hari Sidang PHS Baru" where no_var=2099;;
update abt_variabel set data_type="tanggal_hari" where no_var=2099;;
update abt_variabel set data_tabel=NULL where no_var=2099;;
update abt_variabel set data_kolom=NULL where no_var=2099;;
update abt_variabel set urutan_data=NULL where no_var=2099;;
update abt_variabel set referensi="1138" where no_var=2099;;
update abt_variabel set sql_query=NULL where no_var=2099;;
update abt_variabel set default_data=NULL where no_var=2099;;
update abt_variabel set multi_sidang=NULL where no_var=2099;;
update abt_variabel set locked="1" where no_var=2099;;
update abt_variabel set modifier=NULL where no_var=2099;;
update abt_variabel set modified="2019-08-08 20:05:28" where no_var=2099;;


/*NOMOR VARIABEL 2102*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (2102);;
update abt_variabel set nama="Hari Relaas Ikrar Talak #0046#" where no_var=2102;;
update abt_variabel set data_type="tanggal_hari" where no_var=2102;;
update abt_variabel set data_tabel=NULL where no_var=2102;;
update abt_variabel set data_kolom=NULL where no_var=2102;;
update abt_variabel set urutan_data=NULL where no_var=2102;;
update abt_variabel set referensi="1079" where no_var=2102;;
update abt_variabel set sql_query=NULL where no_var=2102;;
update abt_variabel set default_data=NULL where no_var=2102;;
update abt_variabel set multi_sidang=NULL where no_var=2102;;
update abt_variabel set locked="1" where no_var=2102;;
update abt_variabel set modifier=NULL where no_var=2102;;
update abt_variabel set modified="2019-08-08 20:05:29" where no_var=2102;;


/*NOMOR VARIABEL 2103*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (2103);;
update abt_variabel set nama="Hari Relaas Ikrar Talak #0047#" where no_var=2103;;
update abt_variabel set data_type="tanggal_hari" where no_var=2103;;
update abt_variabel set data_tabel=NULL where no_var=2103;;
update abt_variabel set data_kolom=NULL where no_var=2103;;
update abt_variabel set urutan_data=NULL where no_var=2103;;
update abt_variabel set referensi="1080" where no_var=2103;;
update abt_variabel set sql_query=NULL where no_var=2103;;
update abt_variabel set default_data=NULL where no_var=2103;;
update abt_variabel set multi_sidang=NULL where no_var=2103;;
update abt_variabel set locked="1" where no_var=2103;;
update abt_variabel set modifier=NULL where no_var=2103;;
update abt_variabel set modified="2019-08-08 20:05:30" where no_var=2103;;


/*NOMOR VARIABEL 2110*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (2110);;
update abt_variabel set nama="Zona Waktu" where no_var=2110;;
update abt_variabel set data_type="data_sql" where no_var=2110;;
update abt_variabel set data_tabel=NULL where no_var=2110;;
update abt_variabel set data_kolom=NULL where no_var=2110;;
update abt_variabel set urutan_data=NULL where no_var=2110;;
update abt_variabel set referensi=NULL where no_var=2110;;
update abt_variabel set sql_query="select value as data from sys_config
where name=""ZonaWaktu""" where no_var=2110;;
update abt_variabel set default_data=NULL where no_var=2110;;
update abt_variabel set multi_sidang=NULL where no_var=2110;;
update abt_variabel set locked="1" where no_var=2110;;
update abt_variabel set modifier=NULL where no_var=2110;;
update abt_variabel set modified="2019-08-08 20:05:49" where no_var=2110;;


/*NOMOR VARIABEL 2173*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (2173);;
update abt_variabel set nama="Warga Negara #0047#" where no_var=2173;;
update abt_variabel set data_type="data_sql" where no_var=2173;;
update abt_variabel set data_tabel=NULL where no_var=2173;;
update abt_variabel set data_kolom=NULL where no_var=2173;;
update abt_variabel set urutan_data=NULL where no_var=2173;;
update abt_variabel set referensi=NULL where no_var=2173;;
update abt_variabel set sql_query="select c.nama as data
from perkara_pihak2 a
join pihak b on a.pihak_id=b.id
join negara c on b.warga_negara_id=c.id
where a.urutan=1 and a.perkara_id=#perkara_id#" where no_var=2173;;
update abt_variabel set default_data=NULL where no_var=2173;;
update abt_variabel set multi_sidang=NULL where no_var=2173;;
update abt_variabel set locked="1" where no_var=2173;;
update abt_variabel set modifier=NULL where no_var=2173;;
update abt_variabel set modified="2019-08-08 20:05:56" where no_var=2173;;


/*NOMOR VARIABEL 5019*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (5019);;
update abt_variabel set nama="Pendidikan #0047# II" where no_var=5019;;
update abt_variabel set data_type="data_sql" where no_var=5019;;
update abt_variabel set data_tabel=NULL where no_var=5019;;
update abt_variabel set data_kolom=NULL where no_var=5019;;
update abt_variabel set urutan_data=NULL where no_var=5019;;
update abt_variabel set referensi=NULL where no_var=5019;;
update abt_variabel set sql_query="select c.kode as data from perkara_pihak2 a
join pihak b on a.pihak_id=b.id
join tingkat_pendidikan c on b.pendidikan_id=c.id
where urutan=2 and perkara_id=#perkara_id#" where no_var=5019;;
update abt_variabel set default_data=NULL where no_var=5019;;
update abt_variabel set multi_sidang=NULL where no_var=5019;;
update abt_variabel set locked="1" where no_var=5019;;
update abt_variabel set modifier=NULL where no_var=5019;;
update abt_variabel set modified="2019-08-08 20:06:43" where no_var=5019;;


/*NOMOR VARIABEL 5026*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (5026);;
update abt_variabel set nama="Nama #0047# II" where no_var=5026;;
update abt_variabel set data_type="data_sipp" where no_var=5026;;
update abt_variabel set data_tabel="perkara_pihak2" where no_var=5026;;
update abt_variabel set data_kolom="nama" where no_var=5026;;
update abt_variabel set urutan_data="2" where no_var=5026;;
update abt_variabel set referensi=NULL where no_var=5026;;
update abt_variabel set sql_query=NULL where no_var=5026;;
update abt_variabel set default_data=NULL where no_var=5026;;
update abt_variabel set multi_sidang=NULL where no_var=5026;;
update abt_variabel set locked="1" where no_var=5026;;
update abt_variabel set modifier=NULL where no_var=5026;;
update abt_variabel set modified="2019-08-08 20:06:54" where no_var=5026;;


/*NOMOR VARIABEL 5027*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (5027);;
update abt_variabel set nama="Umur #0047# II" where no_var=5027;;
update abt_variabel set data_type="data_sql" where no_var=5027;;
update abt_variabel set data_tabel=NULL where no_var=5027;;
update abt_variabel set data_kolom=NULL where no_var=5027;;
update abt_variabel set urutan_data=NULL where no_var=5027;;
update abt_variabel set referensi=NULL where no_var=5027;;
update abt_variabel set sql_query="select (get_umur(b.tanggal_lahir,c.tanggal_pendaftaran))as data
from perkara_pihak2 a
join pihak b on a.pihak_id=b.id
join perkara c on a.perkara_id=c.perkara_id
where a.urutan=2 and a.perkara_id=#perkara_id#" where no_var=5027;;
update abt_variabel set default_data=NULL where no_var=5027;;
update abt_variabel set multi_sidang=NULL where no_var=5027;;
update abt_variabel set locked="1" where no_var=5027;;
update abt_variabel set modifier=NULL where no_var=5027;;
update abt_variabel set modified="2019-08-09 06:02:27" where no_var=5027;;


/*NOMOR VARIABEL 5028*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (5028);;
update abt_variabel set nama="Pekerjaan #0047# II" where no_var=5028;;
update abt_variabel set data_type="data_sql" where no_var=5028;;
update abt_variabel set data_tabel=NULL where no_var=5028;;
update abt_variabel set data_kolom=NULL where no_var=5028;;
update abt_variabel set urutan_data=NULL where no_var=5028;;
update abt_variabel set referensi=NULL where no_var=5028;;
update abt_variabel set sql_query="select b.pekerjaan as data
from perkara_pihak2 a
join pihak b on a.pihak_id=b.id
where a.urutan=2 and a.perkara_id=#perkara_id#" where no_var=5028;;
update abt_variabel set default_data=NULL where no_var=5028;;
update abt_variabel set multi_sidang=NULL where no_var=5028;;
update abt_variabel set locked="1" where no_var=5028;;
update abt_variabel set modifier=NULL where no_var=5028;;
update abt_variabel set modified="2019-08-08 20:06:57" where no_var=5028;;


/*NOMOR VARIABEL 5029*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (5029);;
update abt_variabel set nama="Alamat #0047# II" where no_var=5029;;
update abt_variabel set data_type="data_sipp" where no_var=5029;;
update abt_variabel set data_tabel="perkara_pihak2" where no_var=5029;;
update abt_variabel set data_kolom="alamat " where no_var=5029;;
update abt_variabel set urutan_data="2" where no_var=5029;;
update abt_variabel set referensi=NULL where no_var=5029;;
update abt_variabel set sql_query=NULL where no_var=5029;;
update abt_variabel set default_data=NULL where no_var=5029;;
update abt_variabel set multi_sidang=NULL where no_var=5029;;
update abt_variabel set locked="1" where no_var=5029;;
update abt_variabel set modifier=NULL where no_var=5029;;
update abt_variabel set modified="2019-08-08 20:06:58" where no_var=5029;;


/*NOMOR VARIABEL 5058*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (5058);;
update abt_variabel set nama="TanyaJwb Saksi 1 P" where no_var=5058;;
update abt_variabel set data_type="tanya_jawab" where no_var=5058;;
update abt_variabel set data_tabel=NULL where no_var=5058;;
update abt_variabel set data_kolom=NULL where no_var=5058;;
update abt_variabel set urutan_data=NULL where no_var=5058;;
update abt_variabel set referensi="1197" where no_var=5058;;
update abt_variabel set sql_query=NULL where no_var=5058;;
update abt_variabel set default_data=NULL where no_var=5058;;
update abt_variabel set multi_sidang="tanyajawab" where no_var=5058;;
update abt_variabel set locked="1" where no_var=5058;;
update abt_variabel set modifier=NULL where no_var=5058;;
update abt_variabel set modified="2019-08-08 20:07:04" where no_var=5058;;


/*NOMOR VARIABEL 5059*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (5059);;
update abt_variabel set nama="TanyaJwb Saksi 2 P" where no_var=5059;;
update abt_variabel set data_type="tanya_jawab" where no_var=5059;;
update abt_variabel set data_tabel=NULL where no_var=5059;;
update abt_variabel set data_kolom=NULL where no_var=5059;;
update abt_variabel set urutan_data=NULL where no_var=5059;;
update abt_variabel set referensi="1203" where no_var=5059;;
update abt_variabel set sql_query=NULL where no_var=5059;;
update abt_variabel set default_data=NULL where no_var=5059;;
update abt_variabel set multi_sidang="tanyajawab" where no_var=5059;;
update abt_variabel set locked="1" where no_var=5059;;
update abt_variabel set modifier=NULL where no_var=5059;;
update abt_variabel set modified="2019-08-08 20:07:05" where no_var=5059;;


/*NOMOR VARIABEL 5060*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (5060);;
update abt_variabel set nama="TanyaJwb Saksi 3 P" where no_var=5060;;
update abt_variabel set data_type="tanya_jawab" where no_var=5060;;
update abt_variabel set data_tabel=NULL where no_var=5060;;
update abt_variabel set data_kolom=NULL where no_var=5060;;
update abt_variabel set urutan_data=NULL where no_var=5060;;
update abt_variabel set referensi="6132" where no_var=5060;;
update abt_variabel set sql_query=NULL where no_var=5060;;
update abt_variabel set default_data=NULL where no_var=5060;;
update abt_variabel set multi_sidang="tanyajawab" where no_var=5060;;
update abt_variabel set locked="1" where no_var=5060;;
update abt_variabel set modifier=NULL where no_var=5060;;
update abt_variabel set modified="2019-08-08 20:07:06" where no_var=5060;;


/*NOMOR VARIABEL 5100*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (5100);;
update abt_variabel set nama="PANITERA / PP" where no_var=5100;;
update abt_variabel set data_type="data_sql" where no_var=5100;;
update abt_variabel set data_tabel=NULL where no_var=5100;;
update abt_variabel set data_kolom=NULL where no_var=5100;;
update abt_variabel set urutan_data=NULL where no_var=5100;;
update abt_variabel set referensi=NULL where no_var=5100;;
update abt_variabel set sql_query="select (case when ""#0015#""=""#8004#"" then ""PANITERA""
else ""PANITERA PENGGANTI"" end) as data" where no_var=5100;;
update abt_variabel set default_data=NULL where no_var=5100;;
update abt_variabel set multi_sidang=NULL where no_var=5100;;
update abt_variabel set locked="1" where no_var=5100;;
update abt_variabel set modifier=NULL where no_var=5100;;
update abt_variabel set modified="2019-08-08 20:07:12" where no_var=5100;;


/*NOMOR VARIABEL 5101*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (5101);;
update abt_variabel set nama="JURUSITA / JSP" where no_var=5101;;
update abt_variabel set data_type="data_sql" where no_var=5101;;
update abt_variabel set data_tabel=NULL where no_var=5101;;
update abt_variabel set data_kolom=NULL where no_var=5101;;
update abt_variabel set urutan_data=NULL where no_var=5101;;
update abt_variabel set referensi=NULL where no_var=5101;;
update abt_variabel set sql_query="select
(case when b.jabatan = 1 then ""JURUSITA""
else ""JURUSITA PENGGANTI"" end) data
from perkara_jurusita a
join jurusita b on a.jurusita_id=b.id
where a.perkara_id=#perkara_id#" where no_var=5101;;
update abt_variabel set default_data=NULL where no_var=5101;;
update abt_variabel set multi_sidang=NULL where no_var=5101;;
update abt_variabel set locked="1" where no_var=5101;;
update abt_variabel set modifier=NULL where no_var=5101;;
update abt_variabel set modified="2019-08-08 20:07:13" where no_var=5101;;


/*NOMOR VARIABEL 5119*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (5119);;
update abt_variabel set nama="MENGADILI / MENETAPKAN" where no_var=5119;;
update abt_variabel set data_type="data_sql" where no_var=5119;;
update abt_variabel set data_tabel=NULL where no_var=5119;;
update abt_variabel set data_kolom=NULL where no_var=5119;;
update abt_variabel set urutan_data=NULL where no_var=5119;;
update abt_variabel set referensi=NULL where no_var=5119;;
update abt_variabel set sql_query="select (case when alur_perkara_id=16 then ""MENETAPKAN:""
else ""MENGADILI:"" end) as data
from perkara where perkara_id=#perkara_id#" where no_var=5119;;
update abt_variabel set default_data=NULL where no_var=5119;;
update abt_variabel set multi_sidang=NULL where no_var=5119;;
update abt_variabel set locked="1" where no_var=5119;;
update abt_variabel set modifier=NULL where no_var=5119;;
update abt_variabel set modified="2019-08-08 20:07:30" where no_var=5119;;


/*NOMOR VARIABEL 5125*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (5125);;
update abt_variabel set nama="POSITA LENGKAP" where no_var=5125;;
update abt_variabel set data_type="data_sipp" where no_var=5125;;
update abt_variabel set data_tabel="perkara" where no_var=5125;;
update abt_variabel set data_kolom="posita" where no_var=5125;;
update abt_variabel set urutan_data=NULL where no_var=5125;;
update abt_variabel set referensi=NULL where no_var=5125;;
update abt_variabel set sql_query=NULL where no_var=5125;;
update abt_variabel set default_data=NULL where no_var=5125;;
update abt_variabel set multi_sidang=NULL where no_var=5125;;
update abt_variabel set locked="1" where no_var=5125;;
update abt_variabel set modifier=NULL where no_var=5125;;
update abt_variabel set modified="2019-08-08 20:07:34" where no_var=5125;;


/*NOMOR VARIABEL 5135*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (5135);;
update abt_variabel set nama="PUTUSAN/PENETAPAN" where no_var=5135;;
update abt_variabel set data_type="data_sql" where no_var=5135;;
update abt_variabel set data_tabel=NULL where no_var=5135;;
update abt_variabel set data_kolom=NULL where no_var=5135;;
update abt_variabel set urutan_data=NULL where no_var=5135;;
update abt_variabel set referensi=NULL where no_var=5135;;
update abt_variabel set sql_query="select (case when alur_perkara_id=16 then ""PENETAPAN""
else ""PUTUSAN"" end) as data
from perkara where perkara_id=#perkara_id#" where no_var=5135;;
update abt_variabel set default_data=NULL where no_var=5135;;
update abt_variabel set multi_sidang=NULL where no_var=5135;;
update abt_variabel set locked="1" where no_var=5135;;
update abt_variabel set modifier=NULL where no_var=5135;;
update abt_variabel set modified="2019-08-08 20:07:45" where no_var=5135;;


/*NOMOR VARIABEL 5174*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (5174);;
update abt_variabel set nama="Ruang Sidang (PHS)" where no_var=5174;;
update abt_variabel set data_type="data_sql" where no_var=5174;;
update abt_variabel set data_tabel=NULL where no_var=5174;;
update abt_variabel set data_kolom=NULL where no_var=5174;;
update abt_variabel set urutan_data=NULL where no_var=5174;;
update abt_variabel set referensi=NULL where no_var=5174;;
update abt_variabel set sql_query="select (case

when ""#0163#"" like ""%ruang sidang%"" then
""#0163# #8008#""

else ""#0163#""

end) as data" where no_var=5174;;
update abt_variabel set default_data=NULL where no_var=5174;;
update abt_variabel set multi_sidang=NULL where no_var=5174;;
update abt_variabel set locked="1" where no_var=5174;;
update abt_variabel set modifier=NULL where no_var=5174;;
update abt_variabel set modified="2019-08-08 20:07:54" where no_var=5174;;


/*NOMOR VARIABEL 5242*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (5242);;
update abt_variabel set nama="Tanggal panjar biaya perkara" where no_var=5242;;
update abt_variabel set data_type="data_sql" where no_var=5242;;
update abt_variabel set data_tabel=NULL where no_var=5242;;
update abt_variabel set data_kolom=NULL where no_var=5242;;
update abt_variabel set urutan_data=NULL where no_var=5242;;
update abt_variabel set referensi=NULL where no_var=5242;;
update abt_variabel set sql_query="select tanggal_transaksi as data from perkara_biaya
where jenis_biaya_id=1 and perkara_id=#perkara_id#" where no_var=5242;;
update abt_variabel set default_data=NULL where no_var=5242;;
update abt_variabel set multi_sidang=NULL where no_var=5242;;
update abt_variabel set locked="1" where no_var=5242;;
update abt_variabel set modifier=NULL where no_var=5242;;
update abt_variabel set modified="2019-08-08 20:08:26" where no_var=5242;;


/*NOMOR VARIABEL 5368*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (5368);;
update abt_variabel set nama="Putusan / Penetapan" where no_var=5368;;
update abt_variabel set data_type="data_sql" where no_var=5368;;
update abt_variabel set data_tabel=NULL where no_var=5368;;
update abt_variabel set data_kolom=NULL where no_var=5368;;
update abt_variabel set urutan_data=NULL where no_var=5368;;
update abt_variabel set referensi=NULL where no_var=5368;;
update abt_variabel set sql_query="select (case when alur_perkara_id=16 then ""Penetapan""
else ""Putusan"" end) as data
from perkara where perkara_id=#perkara_id#" where no_var=5368;;
update abt_variabel set default_data=NULL where no_var=5368;;
update abt_variabel set multi_sidang=NULL where no_var=5368;;
update abt_variabel set locked="1" where no_var=5368;;
update abt_variabel set modifier=NULL where no_var=5368;;
update abt_variabel set modified="2019-08-08 20:08:24" where no_var=5368;;


/*NOMOR VARIABEL 5369*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (5369);;
update abt_variabel set nama="Jenis Putusan Teks" where no_var=5369;;
update abt_variabel set data_type="data_sql" where no_var=5369;;
update abt_variabel set data_tabel=NULL where no_var=5369;;
update abt_variabel set data_kolom=NULL where no_var=5369;;
update abt_variabel set urutan_data=NULL where no_var=5369;;
update abt_variabel set referensi=NULL where no_var=5369;;
update abt_variabel set sql_query="select nama as data from perkara_putusan a
join status_putusan b on a.status_putusan_id=b.id
where perkara_id=#perkara_id#" where no_var=5369;;
update abt_variabel set default_data=NULL where no_var=5369;;
update abt_variabel set multi_sidang=NULL where no_var=5369;;
update abt_variabel set locked="1" where no_var=5369;;
update abt_variabel set modifier=NULL where no_var=5369;;
update abt_variabel set modified="2019-08-08 20:08:31" where no_var=5369;;


/*NOMOR VARIABEL 5400*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (5400);;
update abt_variabel set nama="Bada / Qobla Dukhul" where no_var=5400;;
update abt_variabel set data_type="data_sql" where no_var=5400;;
update abt_variabel set data_tabel=NULL where no_var=5400;;
update abt_variabel set data_kolom=NULL where no_var=5400;;
update abt_variabel set urutan_data=NULL where no_var=5400;;
update abt_variabel set referensi=NULL where no_var=5400;;
update abt_variabel set sql_query="select (case

when qobla_bada=0 
then ""ba'da dukhul""

when qobla_bada=1 
then ""qo'bla dukhul""

else NULL

end) as data from perkara_akta_cerai where perkara_id=#perkara_id#" where no_var=5400;;
update abt_variabel set default_data=NULL where no_var=5400;;
update abt_variabel set multi_sidang=NULL where no_var=5400;;
update abt_variabel set locked="1" where no_var=5400;;
update abt_variabel set modifier=NULL where no_var=5400;;
update abt_variabel set modified="2019-09-15 15:46:30" where no_var=5400;;


/*NOMOR VARIABEL 5401*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (5401);;
update abt_variabel set nama="Jenis AC" where no_var=5401;;
update abt_variabel set data_type="data_sql" where no_var=5401;;
update abt_variabel set data_tabel=NULL where no_var=5401;;
update abt_variabel set data_kolom=NULL where no_var=5401;;
update abt_variabel set urutan_data=NULL where no_var=5401;;
update abt_variabel set referensi=NULL where no_var=5401;;
update abt_variabel set sql_query="select (case

when ""#0048#""=""Cerai Talak"" 
then ""raj'i""

when ""#0048#""=""Cerai Gugat"" and ""#0065#"" like ""%iwadl%"" 
then ""khul'i""

else ""bain sughra""

end) as data" where no_var=5401;;
update abt_variabel set default_data=NULL where no_var=5401;;
update abt_variabel set multi_sidang=NULL where no_var=5401;;
update abt_variabel set locked="1" where no_var=5401;;
update abt_variabel set modifier=NULL where no_var=5401;;
update abt_variabel set modified="2019-09-15 15:46:30" where no_var=5401;;


/*NOMOR VARIABEL 6030*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6030);;
update abt_variabel set nama="Hijriyah Tgl Nikah" where no_var=6030;;
update abt_variabel set data_type="tanggal_hijriah" where no_var=6030;;
update abt_variabel set data_tabel=NULL where no_var=6030;;
update abt_variabel set data_kolom=NULL where no_var=6030;;
update abt_variabel set urutan_data=NULL where no_var=6030;;
update abt_variabel set referensi="1011" where no_var=6030;;
update abt_variabel set sql_query=NULL where no_var=6030;;
update abt_variabel set default_data=NULL where no_var=6030;;
update abt_variabel set multi_sidang=NULL where no_var=6030;;
update abt_variabel set locked="1" where no_var=6030;;
update abt_variabel set modifier=NULL where no_var=6030;;
update abt_variabel set modified="2019-08-08 20:08:53" where no_var=6030;;


/*NOMOR VARIABEL 6031*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6031);;
update abt_variabel set nama="Jurusita (JSP)" where no_var=6031;;
update abt_variabel set data_type="data_sql" where no_var=6031;;
update abt_variabel set data_tabel=NULL where no_var=6031;;
update abt_variabel set data_kolom=NULL where no_var=6031;;
update abt_variabel set urutan_data=NULL where no_var=6031;;
update abt_variabel set referensi=NULL where no_var=6031;;
update abt_variabel set sql_query="select ""#0018#"" as data" where no_var=6031;;
update abt_variabel set default_data=NULL where no_var=6031;;
update abt_variabel set multi_sidang=NULL where no_var=6031;;
update abt_variabel set locked="1" where no_var=6031;;
update abt_variabel set modifier=NULL where no_var=6031;;
update abt_variabel set modified="2019-08-08 20:08:57" where no_var=6031;;


/*NOMOR VARIABEL 6032*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6032);;
update abt_variabel set nama="Jurusita/Jurusita Pengganti" where no_var=6032;;
update abt_variabel set data_type="data_sql" where no_var=6032;;
update abt_variabel set data_tabel=NULL where no_var=6032;;
update abt_variabel set data_kolom=NULL where no_var=6032;;
update abt_variabel set urutan_data=NULL where no_var=6032;;
update abt_variabel set referensi=NULL where no_var=6032;;
update abt_variabel set sql_query="select
(case when b.jabatan = 1 then ""Jurusita""
else ""Jurusita Pengganti"" end) data
from perkara_jurusita a
join jurusita b on a.jurusita_id=b.id
where a.perkara_id=#perkara_id#" where no_var=6032;;
update abt_variabel set default_data=NULL where no_var=6032;;
update abt_variabel set multi_sidang=NULL where no_var=6032;;
update abt_variabel set locked="1" where no_var=6032;;
update abt_variabel set modifier=NULL where no_var=6032;;
update abt_variabel set modified="2019-08-08 20:08:59" where no_var=6032;;


/*NOMOR VARIABEL 6033*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6033);;
update abt_variabel set nama="Panitera (PP)" where no_var=6033;;
update abt_variabel set data_type="data_sql" where no_var=6033;;
update abt_variabel set data_tabel=NULL where no_var=6033;;
update abt_variabel set data_kolom=NULL where no_var=6033;;
update abt_variabel set urutan_data=NULL where no_var=6033;;
update abt_variabel set referensi=NULL where no_var=6033;;
update abt_variabel set sql_query="select ""#0015#"" as data" where no_var=6033;;
update abt_variabel set default_data=NULL where no_var=6033;;
update abt_variabel set multi_sidang=NULL where no_var=6033;;
update abt_variabel set locked="1" where no_var=6033;;
update abt_variabel set modifier=NULL where no_var=6033;;
update abt_variabel set modified="2019-08-08 20:09:00" where no_var=6033;;


/*NOMOR VARIABEL 6034*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6034);;
update abt_variabel set nama="Panitera/Panitera Pengganti" where no_var=6034;;
update abt_variabel set data_type="data_sql" where no_var=6034;;
update abt_variabel set data_tabel=NULL where no_var=6034;;
update abt_variabel set data_kolom=NULL where no_var=6034;;
update abt_variabel set urutan_data=NULL where no_var=6034;;
update abt_variabel set referensi=NULL where no_var=6034;;
update abt_variabel set sql_query="select (case when ""#0015#""=""#8004#"" then ""Panitera""
else ""Panitera Pengganti"" end) as data" where no_var=6034;;
update abt_variabel set default_data=NULL where no_var=6034;;
update abt_variabel set multi_sidang=NULL where no_var=6034;;
update abt_variabel set locked="1" where no_var=6034;;
update abt_variabel set modifier=NULL where no_var=6034;;
update abt_variabel set modified="2019-08-08 20:09:01" where no_var=6034;;


/*NOMOR VARIABEL 6060*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6060);;
update abt_variabel set nama="Biaya Proses" where no_var=6060;;
update abt_variabel set data_type="data_sql" where no_var=6060;;
update abt_variabel set data_tabel=NULL where no_var=6060;;
update abt_variabel set data_kolom=NULL where no_var=6060;;
update abt_variabel set urutan_data=NULL where no_var=6060;;
update abt_variabel set referensi=NULL where no_var=6060;;
update abt_variabel set sql_query="select jumlah as data from perkara_biaya
where jenis_biaya_id=155 and perkara_id=#perkara_id#" where no_var=6060;;
update abt_variabel set default_data=NULL where no_var=6060;;
update abt_variabel set multi_sidang=NULL where no_var=6060;;
update abt_variabel set locked="1" where no_var=6060;;
update abt_variabel set modifier=NULL where no_var=6060;;
update abt_variabel set modified="2019-08-08 20:09:17" where no_var=6060;;


/*NOMOR VARIABEL 6061*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6061);;
update abt_variabel set nama="Biaya Sumpah" where no_var=6061;;
update abt_variabel set data_type="data_sql" where no_var=6061;;
update abt_variabel set data_tabel=NULL where no_var=6061;;
update abt_variabel set data_kolom=NULL where no_var=6061;;
update abt_variabel set urutan_data=NULL where no_var=6061;;
update abt_variabel set referensi=NULL where no_var=6061;;
update abt_variabel set sql_query="select sum(jumlah) as data from perkara_biaya
where kategori_id=9 and perkara_id=#perkara_id#" where no_var=6061;;
update abt_variabel set default_data=NULL where no_var=6061;;
update abt_variabel set multi_sidang=NULL where no_var=6061;;
update abt_variabel set locked="1" where no_var=6061;;
update abt_variabel set modifier=NULL where no_var=6061;;
update abt_variabel set modified="2019-08-08 20:09:53" where no_var=6061;;


/*NOMOR VARIABEL 6062*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6062);;
update abt_variabel set nama="Biaya Penerjemah" where no_var=6062;;
update abt_variabel set data_type="data_sql" where no_var=6062;;
update abt_variabel set data_tabel=NULL where no_var=6062;;
update abt_variabel set data_kolom=NULL where no_var=6062;;
update abt_variabel set urutan_data=NULL where no_var=6062;;
update abt_variabel set referensi=NULL where no_var=6062;;
update abt_variabel set sql_query="select sum(jumlah) as data from perkara_biaya
where kategori_id=10 and perkara_id=#perkara_id#" where no_var=6062;;
update abt_variabel set default_data=NULL where no_var=6062;;
update abt_variabel set multi_sidang=NULL where no_var=6062;;
update abt_variabel set locked="1" where no_var=6062;;
update abt_variabel set modifier=NULL where no_var=6062;;
update abt_variabel set modified="2019-08-08 20:09:54" where no_var=6062;;


/*NOMOR VARIABEL 6063*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6063);;
update abt_variabel set nama="Biaya PNBP Panggilan Pertama" where no_var=6063;;
update abt_variabel set data_type="data_sql" where no_var=6063;;
update abt_variabel set data_tabel=NULL where no_var=6063;;
update abt_variabel set data_kolom=NULL where no_var=6063;;
update abt_variabel set urutan_data=NULL where no_var=6063;;
update abt_variabel set referensi=NULL where no_var=6063;;
update abt_variabel set sql_query="select sum(jumlah) as data from perkara_biaya
where jenis_biaya_id=236 and perkara_id=#perkara_id#
or jenis_biaya_id=237 and perkara_id=#perkara_id#
or jenis_biaya_id=253 and perkara_id=#perkara_id#" where no_var=6063;;
update abt_variabel set default_data=NULL where no_var=6063;;
update abt_variabel set multi_sidang=NULL where no_var=6063;;
update abt_variabel set locked="1" where no_var=6063;;
update abt_variabel set modifier=NULL where no_var=6063;;
update abt_variabel set modified="2019-08-08 20:09:56" where no_var=6063;;


/*NOMOR VARIABEL 6090*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6090);;
update abt_variabel set nama="Hari Sidang Sebelumnya" where no_var=6090;;
update abt_variabel set data_type="multi_sidang" where no_var=6090;;
update abt_variabel set data_tabel=NULL where no_var=6090;;
update abt_variabel set data_kolom=NULL where no_var=6090;;
update abt_variabel set urutan_data=NULL where no_var=6090;;
update abt_variabel set referensi=NULL where no_var=6090;;
update abt_variabel set sql_query=NULL where no_var=6090;;
update abt_variabel set default_data=NULL where no_var=6090;;
update abt_variabel set multi_sidang="hari_sblmnya" where no_var=6090;;
update abt_variabel set locked="1" where no_var=6090;;
update abt_variabel set modifier=NULL where no_var=6090;;
update abt_variabel set modified="2019-08-08 20:09:59" where no_var=6090;;


/*NOMOR VARIABEL 6091*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6091);;
update abt_variabel set nama="Tgl. Sidang Sebelumnya" where no_var=6091;;
update abt_variabel set data_type="multi_sidang" where no_var=6091;;
update abt_variabel set data_tabel=NULL where no_var=6091;;
update abt_variabel set data_kolom=NULL where no_var=6091;;
update abt_variabel set urutan_data=NULL where no_var=6091;;
update abt_variabel set referensi=NULL where no_var=6091;;
update abt_variabel set sql_query=NULL where no_var=6091;;
update abt_variabel set default_data=NULL where no_var=6091;;
update abt_variabel set multi_sidang="tanggal_sblmnya" where no_var=6091;;
update abt_variabel set locked="1" where no_var=6091;;
update abt_variabel set modifier=NULL where no_var=6091;;
update abt_variabel set modified="2019-08-08 20:10:00" where no_var=6091;;


/*NOMOR VARIABEL 6100*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6100);;
update abt_variabel set nama="Nama Saksi 1 T" where no_var=6100;;
update abt_variabel set data_type="data_sql" where no_var=6100;;
update abt_variabel set data_tabel=NULL where no_var=6100;;
update abt_variabel set data_kolom=NULL where no_var=6100;;
update abt_variabel set urutan_data=NULL where no_var=6100;;
update abt_variabel set referensi=NULL where no_var=6100;;
update abt_variabel set sql_query="select nama as data from perkara_pihak5
where saksi_pihak_ke=2 and perkara_id=#perkara_id#
order by urutan
limit 0,1" where no_var=6100;;
update abt_variabel set default_data=NULL where no_var=6100;;
update abt_variabel set multi_sidang=NULL where no_var=6100;;
update abt_variabel set locked="1" where no_var=6100;;
update abt_variabel set modifier=NULL where no_var=6100;;
update abt_variabel set modified="2019-08-08 20:10:05" where no_var=6100;;


/*NOMOR VARIABEL 6101*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6101);;
update abt_variabel set nama="Umur Saksi 1 T" where no_var=6101;;
update abt_variabel set data_type="data_sql" where no_var=6101;;
update abt_variabel set data_tabel=NULL where no_var=6101;;
update abt_variabel set data_kolom=NULL where no_var=6101;;
update abt_variabel set urutan_data=NULL where no_var=6101;;
update abt_variabel set referensi=NULL where no_var=6101;;
update abt_variabel set sql_query="select (get_umur(b.tanggal_lahir,a.diinput_tanggal))as data
from perkara_pihak5 a
join pihak b on a.pihak_id=b.id
where a.saksi_pihak_ke=2 and a.perkara_id=#perkara_id#
order by a.urutan
limit 0,1" where no_var=6101;;
update abt_variabel set default_data=NULL where no_var=6101;;
update abt_variabel set multi_sidang=NULL where no_var=6101;;
update abt_variabel set locked="1" where no_var=6101;;
update abt_variabel set modifier=NULL where no_var=6101;;
update abt_variabel set modified="2019-08-08 20:10:06" where no_var=6101;;


/*NOMOR VARIABEL 6102*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6102);;
update abt_variabel set nama="Agama Saksi 1 T" where no_var=6102;;
update abt_variabel set data_type="data_sql" where no_var=6102;;
update abt_variabel set data_tabel=NULL where no_var=6102;;
update abt_variabel set data_kolom=NULL where no_var=6102;;
update abt_variabel set urutan_data=NULL where no_var=6102;;
update abt_variabel set referensi=NULL where no_var=6102;;
update abt_variabel set sql_query="select c.nama as data
from perkara_pihak5 a
join pihak b on a.pihak_id=b.id
join agama c on b.agama_id=c.id
where a.saksi_pihak_ke=2 and a.perkara_id=#perkara_id#
order by a.urutan
limit 0,1" where no_var=6102;;
update abt_variabel set default_data=NULL where no_var=6102;;
update abt_variabel set multi_sidang=NULL where no_var=6102;;
update abt_variabel set locked="1" where no_var=6102;;
update abt_variabel set modifier=NULL where no_var=6102;;
update abt_variabel set modified="2019-08-08 20:10:07" where no_var=6102;;


/*NOMOR VARIABEL 6103*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6103);;
update abt_variabel set nama="Pendidikan Saksi 1 T" where no_var=6103;;
update abt_variabel set data_type="data_sql" where no_var=6103;;
update abt_variabel set data_tabel=NULL where no_var=6103;;
update abt_variabel set data_kolom=NULL where no_var=6103;;
update abt_variabel set urutan_data=NULL where no_var=6103;;
update abt_variabel set referensi=NULL where no_var=6103;;
update abt_variabel set sql_query="select c.kode as data from perkara_pihak5 a
join pihak b on a.pihak_id=b.id
join tingkat_pendidikan c on b.pendidikan_id=c.id
where a.saksi_pihak_ke=2 and a.perkara_id=#perkara_id#
order by a.urutan
limit 0,1" where no_var=6103;;
update abt_variabel set default_data=NULL where no_var=6103;;
update abt_variabel set multi_sidang=NULL where no_var=6103;;
update abt_variabel set locked="1" where no_var=6103;;
update abt_variabel set modifier=NULL where no_var=6103;;
update abt_variabel set modified="2019-08-08 20:10:08" where no_var=6103;;


/*NOMOR VARIABEL 6104*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6104);;
update abt_variabel set nama="Pekerjaan Saksi 1 T" where no_var=6104;;
update abt_variabel set data_type="data_sql" where no_var=6104;;
update abt_variabel set data_tabel=NULL where no_var=6104;;
update abt_variabel set data_kolom=NULL where no_var=6104;;
update abt_variabel set urutan_data=NULL where no_var=6104;;
update abt_variabel set referensi=NULL where no_var=6104;;
update abt_variabel set sql_query="select b.pekerjaan as data
from perkara_pihak5 a
join pihak b on a.pihak_id=b.id
where a.saksi_pihak_ke=2 and a.perkara_id=#perkara_id#
order by a.urutan
limit 0,1" where no_var=6104;;
update abt_variabel set default_data=NULL where no_var=6104;;
update abt_variabel set multi_sidang=NULL where no_var=6104;;
update abt_variabel set locked="1" where no_var=6104;;
update abt_variabel set modifier=NULL where no_var=6104;;
update abt_variabel set modified="2019-08-08 20:10:09" where no_var=6104;;


/*NOMOR VARIABEL 6105*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6105);;
update abt_variabel set nama="Alamat Saksi 1 T" where no_var=6105;;
update abt_variabel set data_type="data_sql" where no_var=6105;;
update abt_variabel set data_tabel=NULL where no_var=6105;;
update abt_variabel set data_kolom=NULL where no_var=6105;;
update abt_variabel set urutan_data=NULL where no_var=6105;;
update abt_variabel set referensi=NULL where no_var=6105;;
update abt_variabel set sql_query="select alamat as data from perkara_pihak5
where saksi_pihak_ke=2 and perkara_id=#perkara_id#
order by urutan
limit 0,1" where no_var=6105;;
update abt_variabel set default_data=NULL where no_var=6105;;
update abt_variabel set multi_sidang=NULL where no_var=6105;;
update abt_variabel set locked="1" where no_var=6105;;
update abt_variabel set modifier=NULL where no_var=6105;;
update abt_variabel set modified="2019-08-08 20:10:09" where no_var=6105;;


/*NOMOR VARIABEL 6106*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6106);;
update abt_variabel set nama="Nama Saksi 2 T" where no_var=6106;;
update abt_variabel set data_type="data_sql" where no_var=6106;;
update abt_variabel set data_tabel=NULL where no_var=6106;;
update abt_variabel set data_kolom=NULL where no_var=6106;;
update abt_variabel set urutan_data=NULL where no_var=6106;;
update abt_variabel set referensi=NULL where no_var=6106;;
update abt_variabel set sql_query="select nama as data from perkara_pihak5
where saksi_pihak_ke=2 and perkara_id=#perkara_id#
order by urutan
limit 1,1" where no_var=6106;;
update abt_variabel set default_data=NULL where no_var=6106;;
update abt_variabel set multi_sidang=NULL where no_var=6106;;
update abt_variabel set locked="1" where no_var=6106;;
update abt_variabel set modifier=NULL where no_var=6106;;
update abt_variabel set modified="2019-08-08 20:10:10" where no_var=6106;;


/*NOMOR VARIABEL 6107*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6107);;
update abt_variabel set nama="Umur Saksi 2 T" where no_var=6107;;
update abt_variabel set data_type="data_sql" where no_var=6107;;
update abt_variabel set data_tabel=NULL where no_var=6107;;
update abt_variabel set data_kolom=NULL where no_var=6107;;
update abt_variabel set urutan_data=NULL where no_var=6107;;
update abt_variabel set referensi=NULL where no_var=6107;;
update abt_variabel set sql_query="select (get_umur(b.tanggal_lahir,a.diinput_tanggal))as data
from perkara_pihak5 a
join pihak b on a.pihak_id=b.id
where a.saksi_pihak_ke=2 and a.perkara_id=#perkara_id#
order by a.urutan
limit 1,1" where no_var=6107;;
update abt_variabel set default_data=NULL where no_var=6107;;
update abt_variabel set multi_sidang=NULL where no_var=6107;;
update abt_variabel set locked="1" where no_var=6107;;
update abt_variabel set modifier=NULL where no_var=6107;;
update abt_variabel set modified="2019-08-08 20:10:11" where no_var=6107;;


/*NOMOR VARIABEL 6108*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6108);;
update abt_variabel set nama="Agama Saksi 2 T" where no_var=6108;;
update abt_variabel set data_type="data_sql" where no_var=6108;;
update abt_variabel set data_tabel=NULL where no_var=6108;;
update abt_variabel set data_kolom=NULL where no_var=6108;;
update abt_variabel set urutan_data=NULL where no_var=6108;;
update abt_variabel set referensi=NULL where no_var=6108;;
update abt_variabel set sql_query="select c.nama as data
from perkara_pihak5 a
join pihak b on a.pihak_id=b.id
join agama c on b.agama_id=c.id
where a.saksi_pihak_ke=2 and a.perkara_id=#perkara_id#
order by a.urutan
limit 1,1" where no_var=6108;;
update abt_variabel set default_data=NULL where no_var=6108;;
update abt_variabel set multi_sidang=NULL where no_var=6108;;
update abt_variabel set locked="1" where no_var=6108;;
update abt_variabel set modifier=NULL where no_var=6108;;
update abt_variabel set modified="2019-08-08 20:10:12" where no_var=6108;;


/*NOMOR VARIABEL 6109*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6109);;
update abt_variabel set nama="Pendidikan Saksi 2 T" where no_var=6109;;
update abt_variabel set data_type="data_sql" where no_var=6109;;
update abt_variabel set data_tabel=NULL where no_var=6109;;
update abt_variabel set data_kolom=NULL where no_var=6109;;
update abt_variabel set urutan_data=NULL where no_var=6109;;
update abt_variabel set referensi=NULL where no_var=6109;;
update abt_variabel set sql_query="select c.kode as data from perkara_pihak5 a
join pihak b on a.pihak_id=b.id
join tingkat_pendidikan c on b.pendidikan_id=c.id
where a.saksi_pihak_ke=2 and a.perkara_id=#perkara_id#
order by a.urutan
limit 1,1" where no_var=6109;;
update abt_variabel set default_data=NULL where no_var=6109;;
update abt_variabel set multi_sidang=NULL where no_var=6109;;
update abt_variabel set locked="1" where no_var=6109;;
update abt_variabel set modifier=NULL where no_var=6109;;
update abt_variabel set modified="2019-08-08 20:10:12" where no_var=6109;;


/*NOMOR VARIABEL 6110*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6110);;
update abt_variabel set nama="Pekerjaan Saksi 2 T" where no_var=6110;;
update abt_variabel set data_type="data_sql" where no_var=6110;;
update abt_variabel set data_tabel=NULL where no_var=6110;;
update abt_variabel set data_kolom=NULL where no_var=6110;;
update abt_variabel set urutan_data=NULL where no_var=6110;;
update abt_variabel set referensi=NULL where no_var=6110;;
update abt_variabel set sql_query="select b.pekerjaan as data
from perkara_pihak5 a
join pihak b on a.pihak_id=b.id
where a.saksi_pihak_ke=2 and a.perkara_id=#perkara_id#
order by a.urutan
limit 1,1" where no_var=6110;;
update abt_variabel set default_data=NULL where no_var=6110;;
update abt_variabel set multi_sidang=NULL where no_var=6110;;
update abt_variabel set locked="1" where no_var=6110;;
update abt_variabel set modifier=NULL where no_var=6110;;
update abt_variabel set modified="2019-08-08 20:10:13" where no_var=6110;;


/*NOMOR VARIABEL 6111*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6111);;
update abt_variabel set nama="Alamat Saksi 2 T" where no_var=6111;;
update abt_variabel set data_type="data_sql" where no_var=6111;;
update abt_variabel set data_tabel=NULL where no_var=6111;;
update abt_variabel set data_kolom=NULL where no_var=6111;;
update abt_variabel set urutan_data=NULL where no_var=6111;;
update abt_variabel set referensi=NULL where no_var=6111;;
update abt_variabel set sql_query="select alamat as data from perkara_pihak5
where saksi_pihak_ke=2 and perkara_id=#perkara_id#
order by urutan
limit 1,1" where no_var=6111;;
update abt_variabel set default_data=NULL where no_var=6111;;
update abt_variabel set multi_sidang=NULL where no_var=6111;;
update abt_variabel set locked="1" where no_var=6111;;
update abt_variabel set modifier=NULL where no_var=6111;;
update abt_variabel set modified="2019-08-08 20:10:15" where no_var=6111;;


/*NOMOR VARIABEL 6112*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6112);;
update abt_variabel set nama="Jawaban Lisan #0047#" where no_var=6112;;
update abt_variabel set data_type="tanya_jawab" where no_var=6112;;
update abt_variabel set data_tabel=NULL where no_var=6112;;
update abt_variabel set data_kolom=NULL where no_var=6112;;
update abt_variabel set urutan_data=NULL where no_var=6112;;
update abt_variabel set referensi="0102" where no_var=6112;;
update abt_variabel set sql_query=NULL where no_var=6112;;
update abt_variabel set default_data=NULL where no_var=6112;;
update abt_variabel set multi_sidang="tanyajawab" where no_var=6112;;
update abt_variabel set locked="1" where no_var=6112;;
update abt_variabel set modifier=NULL where no_var=6112;;
update abt_variabel set modified="2019-08-08 20:10:16" where no_var=6112;;


/*NOMOR VARIABEL 6113*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6113);;
update abt_variabel set nama="Replik Lisan #0046#" where no_var=6113;;
update abt_variabel set data_type="tanya_jawab" where no_var=6113;;
update abt_variabel set data_tabel=NULL where no_var=6113;;
update abt_variabel set data_kolom=NULL where no_var=6113;;
update abt_variabel set urutan_data=NULL where no_var=6113;;
update abt_variabel set referensi="0098" where no_var=6113;;
update abt_variabel set sql_query=NULL where no_var=6113;;
update abt_variabel set default_data=NULL where no_var=6113;;
update abt_variabel set multi_sidang="tanyajawab" where no_var=6113;;
update abt_variabel set locked="1" where no_var=6113;;
update abt_variabel set modifier=NULL where no_var=6113;;
update abt_variabel set modified="2019-08-08 20:10:17" where no_var=6113;;


/*NOMOR VARIABEL 6114*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6114);;
update abt_variabel set nama="Duplik Lisan #0047#" where no_var=6114;;
update abt_variabel set data_type="tanya_jawab" where no_var=6114;;
update abt_variabel set data_tabel=NULL where no_var=6114;;
update abt_variabel set data_kolom=NULL where no_var=6114;;
update abt_variabel set urutan_data=NULL where no_var=6114;;
update abt_variabel set referensi="0102" where no_var=6114;;
update abt_variabel set sql_query=NULL where no_var=6114;;
update abt_variabel set default_data=NULL where no_var=6114;;
update abt_variabel set multi_sidang="tanyajawab" where no_var=6114;;
update abt_variabel set locked="1" where no_var=6114;;
update abt_variabel set modifier=NULL where no_var=6114;;
update abt_variabel set modified="2019-08-08 20:10:18" where no_var=6114;;


/*NOMOR VARIABEL 6120*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6120);;
update abt_variabel set nama="TanyaJwb Saksi 1 T" where no_var=6120;;
update abt_variabel set data_type="tanya_jawab" where no_var=6120;;
update abt_variabel set data_tabel=NULL where no_var=6120;;
update abt_variabel set data_kolom=NULL where no_var=6120;;
update abt_variabel set urutan_data=NULL where no_var=6120;;
update abt_variabel set referensi="6100" where no_var=6120;;
update abt_variabel set sql_query=NULL where no_var=6120;;
update abt_variabel set default_data=NULL where no_var=6120;;
update abt_variabel set multi_sidang="tanyajawab" where no_var=6120;;
update abt_variabel set locked="1" where no_var=6120;;
update abt_variabel set modifier=NULL where no_var=6120;;
update abt_variabel set modified="2019-08-08 20:10:34" where no_var=6120;;


/*NOMOR VARIABEL 6121*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6121);;
update abt_variabel set nama="TanyaJwb Saksi 2 T" where no_var=6121;;
update abt_variabel set data_type="tanya_jawab" where no_var=6121;;
update abt_variabel set data_tabel=NULL where no_var=6121;;
update abt_variabel set data_kolom=NULL where no_var=6121;;
update abt_variabel set urutan_data=NULL where no_var=6121;;
update abt_variabel set referensi="6106" where no_var=6121;;
update abt_variabel set sql_query=NULL where no_var=6121;;
update abt_variabel set default_data=NULL where no_var=6121;;
update abt_variabel set multi_sidang="tanyajawab" where no_var=6121;;
update abt_variabel set locked="1" where no_var=6121;;
update abt_variabel set modifier=NULL where no_var=6121;;
update abt_variabel set modified="2019-08-08 20:10:35" where no_var=6121;;


/*NOMOR VARIABEL 6122*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6122);;
update abt_variabel set nama="TanyaJwb Saksi 3 T" where no_var=6122;;
update abt_variabel set data_type="tanya_jawab" where no_var=6122;;
update abt_variabel set data_tabel=NULL where no_var=6122;;
update abt_variabel set data_kolom=NULL where no_var=6122;;
update abt_variabel set urutan_data=NULL where no_var=6122;;
update abt_variabel set referensi="6138" where no_var=6122;;
update abt_variabel set sql_query=NULL where no_var=6122;;
update abt_variabel set default_data=NULL where no_var=6122;;
update abt_variabel set multi_sidang="tanyajawab" where no_var=6122;;
update abt_variabel set locked="1" where no_var=6122;;
update abt_variabel set modifier=NULL where no_var=6122;;
update abt_variabel set modified="2019-08-08 20:10:36" where no_var=6122;;


/*NOMOR VARIABEL 6132*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6132);;
update abt_variabel set nama="Nama Saksi 3 P" where no_var=6132;;
update abt_variabel set data_type="data_sql" where no_var=6132;;
update abt_variabel set data_tabel=NULL where no_var=6132;;
update abt_variabel set data_kolom=NULL where no_var=6132;;
update abt_variabel set urutan_data=NULL where no_var=6132;;
update abt_variabel set referensi=NULL where no_var=6132;;
update abt_variabel set sql_query="select nama as data from perkara_pihak5
where saksi_pihak_ke=1 and perkara_id=#perkara_id#
order by urutan
limit 2,1" where no_var=6132;;
update abt_variabel set default_data=NULL where no_var=6132;;
update abt_variabel set multi_sidang=NULL where no_var=6132;;
update abt_variabel set locked="1" where no_var=6132;;
update abt_variabel set modifier=NULL where no_var=6132;;
update abt_variabel set modified="2019-08-08 20:10:41" where no_var=6132;;


/*NOMOR VARIABEL 6133*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6133);;
update abt_variabel set nama="Umur Saksi 3 P" where no_var=6133;;
update abt_variabel set data_type="data_sql" where no_var=6133;;
update abt_variabel set data_tabel=NULL where no_var=6133;;
update abt_variabel set data_kolom=NULL where no_var=6133;;
update abt_variabel set urutan_data=NULL where no_var=6133;;
update abt_variabel set referensi=NULL where no_var=6133;;
update abt_variabel set sql_query="select (get_umur(b.tanggal_lahir,a.diinput_tanggal))as data
from perkara_pihak5 a
join pihak b on a.pihak_id=b.id
where a.saksi_pihak_ke=1 and a.perkara_id=#perkara_id#
order by a.urutan
limit 2,1" where no_var=6133;;
update abt_variabel set default_data=NULL where no_var=6133;;
update abt_variabel set multi_sidang=NULL where no_var=6133;;
update abt_variabel set locked="1" where no_var=6133;;
update abt_variabel set modifier=NULL where no_var=6133;;
update abt_variabel set modified="2019-08-08 20:10:42" where no_var=6133;;


/*NOMOR VARIABEL 6134*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6134);;
update abt_variabel set nama="Agama Saksi 3 P" where no_var=6134;;
update abt_variabel set data_type="data_sql" where no_var=6134;;
update abt_variabel set data_tabel=NULL where no_var=6134;;
update abt_variabel set data_kolom=NULL where no_var=6134;;
update abt_variabel set urutan_data=NULL where no_var=6134;;
update abt_variabel set referensi=NULL where no_var=6134;;
update abt_variabel set sql_query="select c.nama as data
from perkara_pihak5 a
join pihak b on a.pihak_id=b.id
join agama c on b.agama_id=c.id
where a.saksi_pihak_ke=1 and a.perkara_id=#perkara_id#
order by a.urutan
limit 2,1" where no_var=6134;;
update abt_variabel set default_data=NULL where no_var=6134;;
update abt_variabel set multi_sidang=NULL where no_var=6134;;
update abt_variabel set locked="1" where no_var=6134;;
update abt_variabel set modifier=NULL where no_var=6134;;
update abt_variabel set modified="2019-08-08 20:10:43" where no_var=6134;;


/*NOMOR VARIABEL 6135*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6135);;
update abt_variabel set nama="Pendidikan Saksi 3 P" where no_var=6135;;
update abt_variabel set data_type="data_sql" where no_var=6135;;
update abt_variabel set data_tabel=NULL where no_var=6135;;
update abt_variabel set data_kolom=NULL where no_var=6135;;
update abt_variabel set urutan_data=NULL where no_var=6135;;
update abt_variabel set referensi=NULL where no_var=6135;;
update abt_variabel set sql_query="select c.kode as data from perkara_pihak5 a
join pihak b on a.pihak_id=b.id
join tingkat_pendidikan c on b.pendidikan_id=c.id
where a.saksi_pihak_ke=1 and a.perkara_id=#perkara_id#
order by a.urutan
limit 2,1" where no_var=6135;;
update abt_variabel set default_data=NULL where no_var=6135;;
update abt_variabel set multi_sidang=NULL where no_var=6135;;
update abt_variabel set locked="1" where no_var=6135;;
update abt_variabel set modifier=NULL where no_var=6135;;
update abt_variabel set modified="2019-08-08 20:10:43" where no_var=6135;;


/*NOMOR VARIABEL 6136*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6136);;
update abt_variabel set nama="Pekerjaan Saksi 3 P" where no_var=6136;;
update abt_variabel set data_type="data_sql" where no_var=6136;;
update abt_variabel set data_tabel=NULL where no_var=6136;;
update abt_variabel set data_kolom=NULL where no_var=6136;;
update abt_variabel set urutan_data=NULL where no_var=6136;;
update abt_variabel set referensi=NULL where no_var=6136;;
update abt_variabel set sql_query="select b.pekerjaan as data
from perkara_pihak5 a
join pihak b on a.pihak_id=b.id
where a.saksi_pihak_ke=1 and a.perkara_id=#perkara_id#
order by a.urutan
limit 2,1" where no_var=6136;;
update abt_variabel set default_data=NULL where no_var=6136;;
update abt_variabel set multi_sidang=NULL where no_var=6136;;
update abt_variabel set locked="1" where no_var=6136;;
update abt_variabel set modifier=NULL where no_var=6136;;
update abt_variabel set modified="2019-08-08 20:10:44" where no_var=6136;;


/*NOMOR VARIABEL 6137*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6137);;
update abt_variabel set nama="Alamat Saksi 3 P" where no_var=6137;;
update abt_variabel set data_type="data_sql" where no_var=6137;;
update abt_variabel set data_tabel=NULL where no_var=6137;;
update abt_variabel set data_kolom=NULL where no_var=6137;;
update abt_variabel set urutan_data=NULL where no_var=6137;;
update abt_variabel set referensi=NULL where no_var=6137;;
update abt_variabel set sql_query="select alamat as data from perkara_pihak5
where saksi_pihak_ke=1 and perkara_id=#perkara_id#
order by urutan
limit 2,1" where no_var=6137;;
update abt_variabel set default_data=NULL where no_var=6137;;
update abt_variabel set multi_sidang=NULL where no_var=6137;;
update abt_variabel set locked="1" where no_var=6137;;
update abt_variabel set modifier=NULL where no_var=6137;;
update abt_variabel set modified="2019-08-08 20:10:45" where no_var=6137;;


/*NOMOR VARIABEL 6138*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6138);;
update abt_variabel set nama="Nama Saksi 3 T" where no_var=6138;;
update abt_variabel set data_type="data_sql" where no_var=6138;;
update abt_variabel set data_tabel=NULL where no_var=6138;;
update abt_variabel set data_kolom=NULL where no_var=6138;;
update abt_variabel set urutan_data=NULL where no_var=6138;;
update abt_variabel set referensi=NULL where no_var=6138;;
update abt_variabel set sql_query="select nama as data from perkara_pihak5
where saksi_pihak_ke=2 and perkara_id=#perkara_id#
order by urutan
limit 2,1" where no_var=6138;;
update abt_variabel set default_data=NULL where no_var=6138;;
update abt_variabel set multi_sidang=NULL where no_var=6138;;
update abt_variabel set locked="1" where no_var=6138;;
update abt_variabel set modifier=NULL where no_var=6138;;
update abt_variabel set modified="2019-08-08 20:10:46" where no_var=6138;;


/*NOMOR VARIABEL 6139*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6139);;
update abt_variabel set nama="Umur Saksi 3 T" where no_var=6139;;
update abt_variabel set data_type="data_sql" where no_var=6139;;
update abt_variabel set data_tabel=NULL where no_var=6139;;
update abt_variabel set data_kolom=NULL where no_var=6139;;
update abt_variabel set urutan_data=NULL where no_var=6139;;
update abt_variabel set referensi=NULL where no_var=6139;;
update abt_variabel set sql_query="select (get_umur(b.tanggal_lahir,a.diinput_tanggal))as data
from perkara_pihak5 a
join pihak b on a.pihak_id=b.id
where a.saksi_pihak_ke=2 and a.perkara_id=#perkara_id#
order by a.urutan
limit 2,1" where no_var=6139;;
update abt_variabel set default_data=NULL where no_var=6139;;
update abt_variabel set multi_sidang=NULL where no_var=6139;;
update abt_variabel set locked="1" where no_var=6139;;
update abt_variabel set modifier=NULL where no_var=6139;;
update abt_variabel set modified="2019-08-08 20:10:47" where no_var=6139;;


/*NOMOR VARIABEL 6140*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6140);;
update abt_variabel set nama="Agama Saksi 3 T" where no_var=6140;;
update abt_variabel set data_type="data_sql" where no_var=6140;;
update abt_variabel set data_tabel=NULL where no_var=6140;;
update abt_variabel set data_kolom=NULL where no_var=6140;;
update abt_variabel set urutan_data=NULL where no_var=6140;;
update abt_variabel set referensi=NULL where no_var=6140;;
update abt_variabel set sql_query="select c.nama as data
from perkara_pihak5 a
join pihak b on a.pihak_id=b.id
join agama c on b.agama_id=c.id
where a.saksi_pihak_ke=2 and a.perkara_id=#perkara_id#
order by a.urutan
limit 2,1" where no_var=6140;;
update abt_variabel set default_data=NULL where no_var=6140;;
update abt_variabel set multi_sidang=NULL where no_var=6140;;
update abt_variabel set locked="1" where no_var=6140;;
update abt_variabel set modifier=NULL where no_var=6140;;
update abt_variabel set modified="2019-08-08 20:10:48" where no_var=6140;;


/*NOMOR VARIABEL 6141*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6141);;
update abt_variabel set nama="Pendidikan Saksi 3 T" where no_var=6141;;
update abt_variabel set data_type="data_sql" where no_var=6141;;
update abt_variabel set data_tabel=NULL where no_var=6141;;
update abt_variabel set data_kolom=NULL where no_var=6141;;
update abt_variabel set urutan_data=NULL where no_var=6141;;
update abt_variabel set referensi=NULL where no_var=6141;;
update abt_variabel set sql_query="select c.kode as data from perkara_pihak5 a
join pihak b on a.pihak_id=b.id
join tingkat_pendidikan c on b.pendidikan_id=c.id
where a.saksi_pihak_ke=2 and a.perkara_id=#perkara_id#
order by a.urutan
limit 2,1" where no_var=6141;;
update abt_variabel set default_data=NULL where no_var=6141;;
update abt_variabel set multi_sidang=NULL where no_var=6141;;
update abt_variabel set locked="1" where no_var=6141;;
update abt_variabel set modifier=NULL where no_var=6141;;
update abt_variabel set modified="2019-08-08 20:10:49" where no_var=6141;;


/*NOMOR VARIABEL 6142*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6142);;
update abt_variabel set nama="Pekerjaan Saksi 3 T" where no_var=6142;;
update abt_variabel set data_type="data_sql" where no_var=6142;;
update abt_variabel set data_tabel=NULL where no_var=6142;;
update abt_variabel set data_kolom=NULL where no_var=6142;;
update abt_variabel set urutan_data=NULL where no_var=6142;;
update abt_variabel set referensi=NULL where no_var=6142;;
update abt_variabel set sql_query="select b.pekerjaan as data
from perkara_pihak5 a
join pihak b on a.pihak_id=b.id
where a.saksi_pihak_ke=2 and a.perkara_id=#perkara_id#
order by a.urutan
limit 2,1" where no_var=6142;;
update abt_variabel set default_data=NULL where no_var=6142;;
update abt_variabel set multi_sidang=NULL where no_var=6142;;
update abt_variabel set locked="1" where no_var=6142;;
update abt_variabel set modifier=NULL where no_var=6142;;
update abt_variabel set modified="2019-08-08 20:10:49" where no_var=6142;;


/*NOMOR VARIABEL 6143*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (6143);;
update abt_variabel set nama="Alamat Saksi 3 T" where no_var=6143;;
update abt_variabel set data_type="data_sql" where no_var=6143;;
update abt_variabel set data_tabel=NULL where no_var=6143;;
update abt_variabel set data_kolom=NULL where no_var=6143;;
update abt_variabel set urutan_data=NULL where no_var=6143;;
update abt_variabel set referensi=NULL where no_var=6143;;
update abt_variabel set sql_query="select alamat as data from perkara_pihak5
where saksi_pihak_ke=2 and perkara_id=#perkara_id#
order by urutan
limit 2,1" where no_var=6143;;
update abt_variabel set default_data=NULL where no_var=6143;;
update abt_variabel set multi_sidang=NULL where no_var=6143;;
update abt_variabel set locked="1" where no_var=6143;;
update abt_variabel set modifier=NULL where no_var=6143;;
update abt_variabel set modified="2019-08-08 20:10:50" where no_var=6143;;


/*NOMOR VARIABEL 7000*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (7000);;
update abt_variabel set nama="Nama Kejaksaan Perkara Jinayat" where no_var=7000;;
update abt_variabel set data_type="data_sql" where no_var=7000;;
update abt_variabel set data_tabel=NULL where no_var=7000;;
update abt_variabel set data_kolom=NULL where no_var=7000;;
update abt_variabel set urutan_data=NULL where no_var=7000;;
update abt_variabel set referensi=NULL where no_var=7000;;
update abt_variabel set sql_query="select b.kejaksaan as data from perkara_pihak1 a
join pihak_jaksa b on a.pihak_id=b.pihak_id
where a.urutan=1 and a.perkara_id=#perkara_id#" where no_var=7000;;
update abt_variabel set default_data=NULL where no_var=7000;;
update abt_variabel set multi_sidang=NULL where no_var=7000;;
update abt_variabel set locked="1" where no_var=7000;;
update abt_variabel set modifier=NULL where no_var=7000;;
update abt_variabel set modified="2019-08-08 20:11:30" where no_var=7000;;


/*NOMOR VARIABEL 7001*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (7001);;
update abt_variabel set nama="Tgl. Surat Perkara" where no_var=7001;;
update abt_variabel set data_type="data_sipp" where no_var=7001;;
update abt_variabel set data_tabel="perkara" where no_var=7001;;
update abt_variabel set data_kolom="tanggal_surat" where no_var=7001;;
update abt_variabel set urutan_data=NULL where no_var=7001;;
update abt_variabel set referensi=NULL where no_var=7001;;
update abt_variabel set sql_query=NULL where no_var=7001;;
update abt_variabel set default_data=NULL where no_var=7001;;
update abt_variabel set multi_sidang=NULL where no_var=7001;;
update abt_variabel set locked="1" where no_var=7001;;
update abt_variabel set modifier=NULL where no_var=7001;;
update abt_variabel set modified="2019-08-08 20:11:12" where no_var=7001;;


/*NOMOR VARIABEL 7002*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (7002);;
update abt_variabel set nama="No. Surat Perkara" where no_var=7002;;
update abt_variabel set data_type="data_sipp" where no_var=7002;;
update abt_variabel set data_tabel="perkara" where no_var=7002;;
update abt_variabel set data_kolom="nomor_surat" where no_var=7002;;
update abt_variabel set urutan_data=NULL where no_var=7002;;
update abt_variabel set referensi=NULL where no_var=7002;;
update abt_variabel set sql_query=NULL where no_var=7002;;
update abt_variabel set default_data=NULL where no_var=7002;;
update abt_variabel set multi_sidang=NULL where no_var=7002;;
update abt_variabel set locked="1" where no_var=7002;;
update abt_variabel set modifier=NULL where no_var=7002;;
update abt_variabel set modified="2019-08-08 20:11:26" where no_var=7002;;


/*NOMOR VARIABEL 7003*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (7003);;
update abt_variabel set nama="NIP. Jaksa Penuntut Umum" where no_var=7003;;
update abt_variabel set data_type="data_sql" where no_var=7003;;
update abt_variabel set data_tabel=NULL where no_var=7003;;
update abt_variabel set data_kolom=NULL where no_var=7003;;
update abt_variabel set urutan_data=NULL where no_var=7003;;
update abt_variabel set referensi=NULL where no_var=7003;;
update abt_variabel set sql_query="select b.NIP as data from perkara_pihak1 a
join pihak_jaksa b on a.pihak_id=b.pihak_id
where a.urutan=1 and a.perkara_id=#perkara_id#" where no_var=7003;;
update abt_variabel set default_data=NULL where no_var=7003;;
update abt_variabel set multi_sidang=NULL where no_var=7003;;
update abt_variabel set locked="1" where no_var=7003;;
update abt_variabel set modifier=NULL where no_var=7003;;
update abt_variabel set modified="2019-08-08 20:11:40" where no_var=7003;;


/*NOMOR VARIABEL 7004*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (7004);;
update abt_variabel set nama="Jabatan Jaksa Penuntut Umum" where no_var=7004;;
update abt_variabel set data_type="data_sql" where no_var=7004;;
update abt_variabel set data_tabel=NULL where no_var=7004;;
update abt_variabel set data_kolom=NULL where no_var=7004;;
update abt_variabel set urutan_data=NULL where no_var=7004;;
update abt_variabel set referensi=NULL where no_var=7004;;
update abt_variabel set sql_query="select b.jabatan as data from perkara_pihak1 a
join pihak_jaksa b on a.pihak_id=b.pihak_id
where a.urutan=1 and a.perkara_id=#perkara_id#" where no_var=7004;;
update abt_variabel set default_data=NULL where no_var=7004;;
update abt_variabel set multi_sidang=NULL where no_var=7004;;
update abt_variabel set locked="1" where no_var=7004;;
update abt_variabel set modifier=NULL where no_var=7004;;
update abt_variabel set modified="2019-08-08 20:11:41" where no_var=7004;;


/*NOMOR VARIABEL 8000*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (8000);;
update abt_variabel set nama="Nama Ketua PA" where no_var=8000;;
update abt_variabel set data_type="data_sql" where no_var=8000;;
update abt_variabel set data_tabel=NULL where no_var=8000;;
update abt_variabel set data_kolom=NULL where no_var=8000;;
update abt_variabel set urutan_data=NULL where no_var=8000;;
update abt_variabel set referensi=NULL where no_var=8000;;
update abt_variabel set sql_query="select value as data from sys_config
where name=""KetuaPNNama""" where no_var=8000;;
update abt_variabel set default_data=NULL where no_var=8000;;
update abt_variabel set multi_sidang=NULL where no_var=8000;;
update abt_variabel set locked="1" where no_var=8000;;
update abt_variabel set modifier=NULL where no_var=8000;;
update abt_variabel set modified="2019-08-08 20:11:44" where no_var=8000;;


/*NOMOR VARIABEL 8001*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (8001);;
update abt_variabel set nama="NIP Ketua PA" where no_var=8001;;
update abt_variabel set data_type="data_sql" where no_var=8001;;
update abt_variabel set data_tabel=NULL where no_var=8001;;
update abt_variabel set data_kolom=NULL where no_var=8001;;
update abt_variabel set urutan_data=NULL where no_var=8001;;
update abt_variabel set referensi=NULL where no_var=8001;;
update abt_variabel set sql_query="select value as data from sys_config
where name=""KetuaPNNIP""" where no_var=8001;;
update abt_variabel set default_data=NULL where no_var=8001;;
update abt_variabel set multi_sidang=NULL where no_var=8001;;
update abt_variabel set locked="1" where no_var=8001;;
update abt_variabel set modifier=NULL where no_var=8001;;
update abt_variabel set modified="2019-08-08 20:11:45" where no_var=8001;;


/*NOMOR VARIABEL 8002*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (8002);;
update abt_variabel set nama="Wakil Ketua PA" where no_var=8002;;
update abt_variabel set data_type="data_sql" where no_var=8002;;
update abt_variabel set data_tabel=NULL where no_var=8002;;
update abt_variabel set data_kolom=NULL where no_var=8002;;
update abt_variabel set urutan_data=NULL where no_var=8002;;
update abt_variabel set referensi=NULL where no_var=8002;;
update abt_variabel set sql_query="select value as data from sys_config
where name=""WakilKetuaPNNama""" where no_var=8002;;
update abt_variabel set default_data=NULL where no_var=8002;;
update abt_variabel set multi_sidang=NULL where no_var=8002;;
update abt_variabel set locked="1" where no_var=8002;;
update abt_variabel set modifier=NULL where no_var=8002;;
update abt_variabel set modified="2019-08-08 20:11:50" where no_var=8002;;


/*NOMOR VARIABEL 8003*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (8003);;
update abt_variabel set nama="NIP Wakil Ketua PA" where no_var=8003;;
update abt_variabel set data_type="data_sql" where no_var=8003;;
update abt_variabel set data_tabel=NULL where no_var=8003;;
update abt_variabel set data_kolom=NULL where no_var=8003;;
update abt_variabel set urutan_data=NULL where no_var=8003;;
update abt_variabel set referensi=NULL where no_var=8003;;
update abt_variabel set sql_query="select value as data from sys_config
where name=""WakilKetuaPNNIP""" where no_var=8003;;
update abt_variabel set default_data=NULL where no_var=8003;;
update abt_variabel set multi_sidang=NULL where no_var=8003;;
update abt_variabel set locked="1" where no_var=8003;;
update abt_variabel set modifier=NULL where no_var=8003;;
update abt_variabel set modified="2019-08-08 20:11:51" where no_var=8003;;


/*NOMOR VARIABEL 8004*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (8004);;
update abt_variabel set nama="Nama Panitera PA" where no_var=8004;;
update abt_variabel set data_type="data_sql" where no_var=8004;;
update abt_variabel set data_tabel=NULL where no_var=8004;;
update abt_variabel set data_kolom=NULL where no_var=8004;;
update abt_variabel set urutan_data=NULL where no_var=8004;;
update abt_variabel set referensi=NULL where no_var=8004;;
update abt_variabel set sql_query="select value as data from sys_config
where name=""PanSekNama""" where no_var=8004;;
update abt_variabel set default_data=NULL where no_var=8004;;
update abt_variabel set multi_sidang=NULL where no_var=8004;;
update abt_variabel set locked="1" where no_var=8004;;
update abt_variabel set modifier=NULL where no_var=8004;;
update abt_variabel set modified="2019-08-08 20:11:52" where no_var=8004;;


/*NOMOR VARIABEL 8005*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (8005);;
update abt_variabel set nama="NIP Panitera PA" where no_var=8005;;
update abt_variabel set data_type="data_sql" where no_var=8005;;
update abt_variabel set data_tabel=NULL where no_var=8005;;
update abt_variabel set data_kolom=NULL where no_var=8005;;
update abt_variabel set urutan_data=NULL where no_var=8005;;
update abt_variabel set referensi=NULL where no_var=8005;;
update abt_variabel set sql_query="select value as data from sys_config
where name=""PanSekNIP""" where no_var=8005;;
update abt_variabel set default_data=NULL where no_var=8005;;
update abt_variabel set multi_sidang=NULL where no_var=8005;;
update abt_variabel set locked="1" where no_var=8005;;
update abt_variabel set modifier=NULL where no_var=8005;;
update abt_variabel set modified="2019-08-08 20:11:53" where no_var=8005;;


/*NOMOR VARIABEL 8008*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (8008);;
update abt_variabel set nama="Nama Satker" where no_var=8008;;
update abt_variabel set data_type="data_sql" where no_var=8008;;
update abt_variabel set data_tabel=NULL where no_var=8008;;
update abt_variabel set data_kolom=NULL where no_var=8008;;
update abt_variabel set urutan_data=NULL where no_var=8008;;
update abt_variabel set referensi=NULL where no_var=8008;;
update abt_variabel set sql_query="select value as data from sys_config
where name=""NamaPN""" where no_var=8008;;
update abt_variabel set default_data=NULL where no_var=8008;;
update abt_variabel set multi_sidang=NULL where no_var=8008;;
update abt_variabel set locked="1" where no_var=8008;;
update abt_variabel set modifier=NULL where no_var=8008;;
update abt_variabel set modified="2019-08-08 20:11:55" where no_var=8008;;


/*NOMOR VARIABEL 8009*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (8009);;
update abt_variabel set nama="Alamat Satker" where no_var=8009;;
update abt_variabel set data_type="data_sql" where no_var=8009;;
update abt_variabel set data_tabel=NULL where no_var=8009;;
update abt_variabel set data_kolom=NULL where no_var=8009;;
update abt_variabel set urutan_data=NULL where no_var=8009;;
update abt_variabel set referensi=NULL where no_var=8009;;
update abt_variabel set sql_query="select value as data from sys_config
where name=""AlamatPN""" where no_var=8009;;
update abt_variabel set default_data=NULL where no_var=8009;;
update abt_variabel set multi_sidang=NULL where no_var=8009;;
update abt_variabel set locked="1" where no_var=8009;;
update abt_variabel set modifier=NULL where no_var=8009;;
update abt_variabel set modified="2019-08-08 20:11:59" where no_var=8009;;


/*NOMOR VARIABEL 8010*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (8010);;
update abt_variabel set nama="Nama Satker Huruf Besar" where no_var=8010;;
update abt_variabel set data_type="data_sql" where no_var=8010;;
update abt_variabel set data_tabel=NULL where no_var=8010;;
update abt_variabel set data_kolom=NULL where no_var=8010;;
update abt_variabel set urutan_data=NULL where no_var=8010;;
update abt_variabel set referensi=NULL where no_var=8010;;
update abt_variabel set sql_query="select value as data from sys_config
where name=""NamaPN""" where no_var=8010;;
update abt_variabel set default_data=NULL where no_var=8010;;
update abt_variabel set multi_sidang=NULL where no_var=8010;;
update abt_variabel set locked="1" where no_var=8010;;
update abt_variabel set modifier=NULL where no_var=8010;;
update abt_variabel set modified="2019-08-08 20:11:55" where no_var=8010;;


/*NOMOR VARIABEL 8011*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (8011);;
update abt_variabel set nama="Kota/Kabupaten Satker" where no_var=8011;;
update abt_variabel set data_type="data_sql" where no_var=8011;;
update abt_variabel set data_tabel=NULL where no_var=8011;;
update abt_variabel set data_kolom=NULL where no_var=8011;;
update abt_variabel set urutan_data=NULL where no_var=8011;;
update abt_variabel set referensi=NULL where no_var=8011;;
update abt_variabel set sql_query="select REPLACE(value,SUBSTRING_INDEX(value,"" "",2),"""") as data from sys_config
where name=""NamaPN""" where no_var=8011;;
update abt_variabel set default_data=NULL where no_var=8011;;
update abt_variabel set multi_sidang=NULL where no_var=8011;;
update abt_variabel set locked="1" where no_var=8011;;
update abt_variabel set modifier=NULL where no_var=8011;;
update abt_variabel set modified="2019-08-08 20:12:04" where no_var=8011;;


/*NOMOR VARIABEL 8012*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (8012);;
update abt_variabel set nama="Tanggal Laporan Mediasi" where no_var=8012;;
update abt_variabel set data_type="data_sipp" where no_var=8012;;
update abt_variabel set data_tabel="perkara_mediasi" where no_var=8012;;
update abt_variabel set data_kolom="tgl_laporan_mediator" where no_var=8012;;
update abt_variabel set urutan_data=NULL where no_var=8012;;
update abt_variabel set referensi=NULL where no_var=8012;;
update abt_variabel set sql_query=NULL where no_var=8012;;
update abt_variabel set default_data=NULL where no_var=8012;;
update abt_variabel set multi_sidang=NULL where no_var=8012;;
update abt_variabel set locked="1" where no_var=8012;;
update abt_variabel set modifier=NULL where no_var=8012;;
update abt_variabel set modified="2019-08-08 20:12:10" where no_var=8012;;


/*NOMOR VARIABEL 8016*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (8016);;
update abt_variabel set nama="Hari Mediasi" where no_var=8016;;
update abt_variabel set data_type="tanggal_hari" where no_var=8016;;
update abt_variabel set data_tabel=NULL where no_var=8016;;
update abt_variabel set data_kolom=NULL where no_var=8016;;
update abt_variabel set urutan_data=NULL where no_var=8016;;
update abt_variabel set referensi="8012" where no_var=8016;;
update abt_variabel set sql_query=NULL where no_var=8016;;
update abt_variabel set default_data=NULL where no_var=8016;;
update abt_variabel set multi_sidang=NULL where no_var=8016;;
update abt_variabel set locked="1" where no_var=8016;;
update abt_variabel set modifier=NULL where no_var=8016;;
update abt_variabel set modified="2019-08-08 20:12:12" where no_var=8016;;


/*NOMOR VARIABEL 8017*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (8017);;
update abt_variabel set nama="Kesepakatan Mediator" where no_var=8017;;
update abt_variabel set data_type="data_sql" where no_var=8017;;
update abt_variabel set data_tabel=NULL where no_var=8017;;
update abt_variabel set data_kolom=NULL where no_var=8017;;
update abt_variabel set urutan_data=NULL where no_var=8017;;
update abt_variabel set referensi=NULL where no_var=8017;;
update abt_variabel set sql_query="select (
case when uraian=""sepakat memilih Mediator"" then ""sepakat memilih #6037# #0056# sebagai mediator""
else ""sepakat menyerahkan kepada majelis untuk menunjuk mediator""
end) data from perkara_data_dukung_mediasi
where perkara_id=#perkara_id# limit 1" where no_var=8017;;
update abt_variabel set default_data=NULL where no_var=8017;;
update abt_variabel set multi_sidang=NULL where no_var=8017;;
update abt_variabel set locked="1" where no_var=8017;;
update abt_variabel set modifier=NULL where no_var=8017;;
update abt_variabel set modified="2019-08-08 20:12:15" where no_var=8017;;


/*NOMOR VARIABEL 8021*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (8021);;
update abt_variabel set nama="menunjuk/menetapkan mediator" where no_var=8021;;
update abt_variabel set data_type="data_sql" where no_var=8021;;
update abt_variabel set data_tabel=NULL where no_var=8021;;
update abt_variabel set data_kolom=NULL where no_var=8021;;
update abt_variabel set urutan_data=NULL where no_var=8021;;
update abt_variabel set referensi=NULL where no_var=8021;;
update abt_variabel set sql_query="select (
case when uraian=""sepakat memilih Mediator"" then ""menetapkan mediator""
else ""menunjuk mediator""
end) data from perkara_data_dukung_mediasi
where perkara_id=#perkara_id# limit 1" where no_var=8021;;
update abt_variabel set default_data=NULL where no_var=8021;;
update abt_variabel set multi_sidang=NULL where no_var=8021;;
update abt_variabel set locked="1" where no_var=8021;;
update abt_variabel set modifier=NULL where no_var=8021;;
update abt_variabel set modified="2019-08-08 20:12:18" where no_var=8021;;


/*NOMOR VARIABEL 8022*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (8022);;
update abt_variabel set nama="Uraian Mediator" where no_var=8022;;
update abt_variabel set data_type="data_sql" where no_var=8022;;
update abt_variabel set data_tabel=NULL where no_var=8022;;
update abt_variabel set data_kolom=NULL where no_var=8022;;
update abt_variabel set urutan_data=NULL where no_var=8022;;
update abt_variabel set referensi=NULL where no_var=8022;;
update abt_variabel set sql_query="select (
case when uraian=""sepakat memilih Mediator"" then ""menetapkan mediator tersebut""
else ""menunjuk #6037# #0056#, sebagai mediator""
end) data from perkara_data_dukung_mediasi
where perkara_id=#perkara_id# limit 1" where no_var=8022;;
update abt_variabel set default_data=NULL where no_var=8022;;
update abt_variabel set multi_sidang=NULL where no_var=8022;;
update abt_variabel set locked="1" where no_var=8022;;
update abt_variabel set modifier=NULL where no_var=8022;;
update abt_variabel set modified="2019-08-08 20:12:20" where no_var=8022;;


/*NOMOR VARIABEL 8146*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (8146);;
update abt_variabel set nama="PEMOHON / PENGGUGAT" where no_var=8146;;
update abt_variabel set data_type="data_sql" where no_var=8146;;
update abt_variabel set data_tabel=NULL where no_var=8146;;
update abt_variabel set data_kolom=NULL where no_var=8146;;
update abt_variabel set urutan_data=NULL where no_var=8146;;
update abt_variabel set referensi=NULL where no_var=8146;;
update abt_variabel set sql_query="select (case when alur_perkara_id=16 or jenis_perkara_id=346 then ""PEMOHON""
else ""PENGGUGAT"" end) as data
from perkara where perkara_id=#perkara_id#" where no_var=8146;;
update abt_variabel set default_data=NULL where no_var=8146;;
update abt_variabel set multi_sidang=NULL where no_var=8146;;
update abt_variabel set locked="1" where no_var=8146;;
update abt_variabel set modifier=NULL where no_var=8146;;
update abt_variabel set modified="2019-08-08 20:12:34" where no_var=8146;;


/*NOMOR VARIABEL 8147*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (8147);;
update abt_variabel set nama="TERMOHON / TERGUGAT" where no_var=8147;;
update abt_variabel set data_type="data_sql" where no_var=8147;;
update abt_variabel set data_tabel=NULL where no_var=8147;;
update abt_variabel set data_kolom=NULL where no_var=8147;;
update abt_variabel set urutan_data=NULL where no_var=8147;;
update abt_variabel set referensi=NULL where no_var=8147;;
update abt_variabel set sql_query="select (case when alur_perkara_id=16 or jenis_perkara_id=346 then ""TERMOHON""
else ""TERGUGAT"" end) as data
from perkara where perkara_id=#perkara_id#" where no_var=8147;;
update abt_variabel set default_data=NULL where no_var=8147;;
update abt_variabel set multi_sidang=NULL where no_var=8147;;
update abt_variabel set locked="1" where no_var=8147;;
update abt_variabel set modifier=NULL where no_var=8147;;
update abt_variabel set modified="2019-08-08 20:12:35" where no_var=8147;;


/*NOMOR VARIABEL 8181*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (8181);;
update abt_variabel set nama="Hari Nikah" where no_var=8181;;
update abt_variabel set data_type="tanggal_hari" where no_var=8181;;
update abt_variabel set data_tabel=NULL where no_var=8181;;
update abt_variabel set data_kolom=NULL where no_var=8181;;
update abt_variabel set urutan_data=NULL where no_var=8181;;
update abt_variabel set referensi="5197" where no_var=8181;;
update abt_variabel set sql_query=NULL where no_var=8181;;
update abt_variabel set default_data=NULL where no_var=8181;;
update abt_variabel set multi_sidang=NULL where no_var=8181;;
update abt_variabel set locked="1" where no_var=8181;;
update abt_variabel set modifier=NULL where no_var=8181;;
update abt_variabel set modified="2019-08-08 20:12:45" where no_var=8181;;


/*NOMOR VARIABEL 8183*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (8183);;
update abt_variabel set nama="Hijriyah Nikah" where no_var=8183;;
update abt_variabel set data_type="tanggal_hijriah" where no_var=8183;;
update abt_variabel set data_tabel=NULL where no_var=8183;;
update abt_variabel set data_kolom=NULL where no_var=8183;;
update abt_variabel set urutan_data=NULL where no_var=8183;;
update abt_variabel set referensi="5197" where no_var=8183;;
update abt_variabel set sql_query=NULL where no_var=8183;;
update abt_variabel set default_data=NULL where no_var=8183;;
update abt_variabel set multi_sidang=NULL where no_var=8183;;
update abt_variabel set locked="1" where no_var=8183;;
update abt_variabel set modifier=NULL where no_var=8183;;
update abt_variabel set modified="2019-08-08 20:12:47" where no_var=8183;;


/*NOMOR VARIABEL 9001*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (9001);;
update abt_variabel set nama="Hari Nikah Otomatis" where no_var=9001;;
update abt_variabel set data_type="tanggal_hari" where no_var=9001;;
update abt_variabel set data_tabel=NULL where no_var=9001;;
update abt_variabel set data_kolom=NULL where no_var=9001;;
update abt_variabel set urutan_data=NULL where no_var=9001;;
update abt_variabel set referensi="1011" where no_var=9001;;
update abt_variabel set sql_query=NULL where no_var=9001;;
update abt_variabel set default_data=NULL where no_var=9001;;
update abt_variabel set multi_sidang=NULL where no_var=9001;;
update abt_variabel set locked="1" where no_var=9001;;
update abt_variabel set modifier=NULL where no_var=9001;;
update abt_variabel set modified="2019-08-08 20:12:59" where no_var=9001;;


/*NOMOR VARIABEL 9003*/
INSERT IGNORE INTO `abt_variabel` (`no_var`) VALUES (9003);;
update abt_variabel set nama="Sidang Pertama / Lanjutan" where no_var=9003;;
update abt_variabel set data_type="data_sql" where no_var=9003;;
update abt_variabel set data_tabel=NULL where no_var=9003;;
update abt_variabel set data_kolom=NULL where no_var=9003;;
update abt_variabel set urutan_data=NULL where no_var=9003;;
update abt_variabel set referensi=NULL where no_var=9003;;
update abt_variabel set sql_query="select (case when #0050# = 1 then ""Sidang Pertama"" else ""Lanjutan"" end) data" where no_var=9003;;
update abt_variabel set default_data=NULL where no_var=9003;;
update abt_variabel set multi_sidang=NULL where no_var=9003;;
update abt_variabel set locked="1" where no_var=9003;;
update abt_variabel set modifier=NULL where no_var=9003;;
update abt_variabel set modified="2019-08-08 20:13:13" where no_var=9003;;