<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Perkara_sementara extends CI_Model {
private $dbsipp;

	function __construct() {
		parent::__construct();
		$this->dbsipp = $this->load->database('dbsipp', TRUE);
	}

	public function get_jenis_perkara($string,$limit) {
		return $this->dbsipp->query("select a.alur_perkara_id,a.jenis_perkara_id,c.nama as jns_perk,b.kode,b.nama as ket from jenis_alur_perkara a
			join alur_perkara b on a.alur_perkara_id=b.id join jenis_perkara c on a.jenis_perkara_id=c.id
			where b.jenis_pengadilan=4 and c.nama like \"%$string%\" limit $limit;")->result();
	}
 
	public function get_data_pihak($tgl,$pihak_id,$like=''){
		if($pihak_id){
			$where = "where a.id=$pihak_id";}
		else {
			$where = "where a.nama like \"%$like%\" or a.nomor_indentitas like \"%$like%\"";}
		$data = $this->dbsipp->query("select a.id pihak_id,(case when a.jenis_indentitas=4 then a.nomor_indentitas else NULL end)nomor_indentitas,
			a.nama,a.tempat_lahir,a.tanggal_lahir,(get_umur(a.tanggal_lahir,'$tgl'))as umur,a.jenis_kelamin,
			b.nama agama,c.nama pendidikan,a.pekerjaan,a.alamat from pihak a
			left join agama b on a.agama_id=b.id
			left join tingkat_pendidikan c on a.pendidikan_id=c.id
			$where
			order by (case when a.diperbaharui_tanggal then a.diperbaharui_tanggal else a.diinput_tanggal end) desc
			limit 15;");
		if($pihak_id){
			return $data->row_array();}
		else{
			return $data->result();}
	}
		
	public function get_pihak_perkara($id){
		$data = $this->db->query("select a.*,b.tanggal_surat,(case 
			when a.pihak_ke=1 then (case when b.alur_perkara_id=16 or b.jenis_perkara_id=346 or b.jenis_perkara_id=341 then 'Pemohon' else 'Penggugat' end)
			else (case when b.alur_perkara_id=16 or b.jenis_perkara_id=346 or b.jenis_perkara_id=341 then 'Termohon' else 'Tergugat' end) end) keterangan
			from abt_temp_data_pihak a join abt_temp_data_perkara b using(id) where a.id=$id order by a.pihak_ke,a.urutan;")->result_array();
		foreach($data as $key => $value){			
			$data_sipp = $this->get_data_pihak($value['tanggal_surat'],$value['pihak_id']);
			$data[$key] = array_merge($value,$data_sipp);}
		return $data;
	}
	
	public function get_perkara_sementara($id=NULL,$pihak=TRUE){
		if($id){
			$where = "where id=$id";}
		else{
			$where = NULL;}
		$data = $this->db->query("select id,nomor_sementara,jenis_perkara_nama,tanggal_surat,
			(case when alur_perkara_id=16 or jenis_perkara_id=346 or jenis_perkara_id=341 then 'Pemohon' else 'Penggugat' end)pihak1_ket,
			(case when alur_perkara_id=16 or jenis_perkara_id=346 or jenis_perkara_id=341 then 'Termohon' else 'Tergugat' end)pihak2_ket,
			(case when alur_perkara_id=16 or jenis_perkara_id=346 or jenis_perkara_id=341 then 'permohonan' else 'gugatan' end)gugatan_permohonan,
			(case when alur_perkara_id=16 then 'penetapan' else 'putusan' end)putusan_penetapan
			from abt_temp_data_perkara $where order by modified desc;")->result_array();
		if($pihak){foreach($data as $key => $value){
			$data[$key]['pihak'] = $this->get_pihak_perkara($value['id']);}}
		else if(!$pihak and $id){
			if($pihak1 = $this->pihak_perkara($id,1,$data[0]['tanggal_surat'])){
				$data[0] = array_merge($data[0],$pihak1);}
			if($pihak2 = $this->pihak_perkara($id,2,$data[0]['tanggal_surat'])){
				$data[0] = array_merge($data[0],$pihak2);}}
		if($id){
			return $data[0];}
		else{
			return $data;}
		}

	public function pihak_perkara($id,$pihak_ke,$tgl){
		if ($data_pihak = $this->db->query("select urutan,pihak_id from abt_temp_data_pihak where id=$id and pihak_ke=$pihak_ke order by urutan;")->result_array()){
		foreach($data_pihak as $dat){$data_pihak_perkara[$dat['urutan']] = $this->get_data_pihak($tgl,$dat['pihak_id']);}
		foreach($data_pihak_perkara as $keys => $values){
		foreach($values as $key => $value){
			$data['pihak_'.$pihak_ke.'_'.$keys.'_'.$key] = $value;}}
			return $data;}
		else{
			return NULL;}
	}
	
	public function get_urut_perkara($data){
		return $this->db->query("select count(id) as jml from abt_temp_data_perkara where tanggal_surat=CURDATE() and alur_perkara_id=$data;")->row('jml')+1;
	}
	
	public function get_nomor_sipp($id,$alur_perkara_id,$jenis_perkara_id){
		if($data = $this->get_perkara_sementara($id,FALSE)){
		if($data['pihak_1_2_pihak_id']){
			$pihak_1_2 = "and h.pihak_id=$data[pihak_1_2_pihak_id]";}
		else{
			$pihak_1_2 = "and h.pihak_id is NULL";}
		if($data['pihak_2_1_pihak_id']){
			$pihak_2_1 = "and i.pihak_id=$data[pihak_2_1_pihak_id]";}
		else{
			$pihak_2_1 = "and i.pihak_id is NULL";}			
		return $this->dbsipp->query("select f.perkara_id,f.nomor_perkara,f.jenis_perkara_nama,f.para_pihak,f.tahapan_terakhir_text,f.proses_terakhir_text from perkara f
			left join perkara_pihak1 g on f.perkara_id=g.perkara_id and g.urutan=1
			left join perkara_pihak1 h on f.perkara_id=h.perkara_id and h.urutan=2
			left join perkara_pihak2 i on f.perkara_id=i.perkara_id and i.urutan=1
			where f.alur_perkara_id=$alur_perkara_id
			and f.jenis_perkara_id=$jenis_perkara_id
			and g.pihak_id=$data[pihak_1_1_pihak_id]
			$pihak_1_2
			$pihak_2_1;")->row();}
		else{
			return NULL;
		}
	}
	
	public function ubah_ke_no_sipp($id,$perkara_id){
		$query1 = "replace into abt_data_teks (`no_var`,`perkara_id`,`data`,`modifier`,`modified`)
			select `no_var`,'$perkara_id' as perkara_id,`data`,`modifier`,`modified`
			from abt_temp_data_teks where id=$id;";
		$query2 = "	replace into abt_data_tanggal (`no_var`,`perkara_id`,`data`,`modifier`,`modified`)
			select `no_var`,'$perkara_id' as perkara_id,`data`,`modifier`,`modified`
			from abt_temp_data_tanggal where id=$id;";
		$query3 = "	delete from abt_temp_data_perkara where id=$id;";
		if($this->db->query($query1) and $this->db->query($query2)){
			$this->db->query($query3);
			return TRUE;}
		else{
			return FALSE;}
	}
	

} ?>