<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Anonimisasi extends CI_Model {
private $dbsipp;

	function __construct() {
		parent::__construct();
		$this->dbsipp = $this->load->database('dbsipp', TRUE);
	}
	
	public function get_nomor_perkara($string,$limit) {
		return $this->dbsipp->query("select b.perkara_id,b.nomor_perkara,b.jenis_perkara_nama from `perkara` b 
			where b.nomor_perkara like '$string%'
			order by b.tanggal_pendaftaran desc
			limit $limit;")->result();
	}
	
	public function get_nomor_perkara_putus($string,$limit) {
		return $this->dbsipp->query("select b.perkara_id,b.nomor_perkara,b.jenis_perkara_nama,c.nama as status_putusan from perkara_putusan a
			join `perkara` b using (perkara_id)
			join `status_putusan` c on a.status_putusan_id=c.id
			where b.nomor_perkara like '$string%'
			order by a.tanggal_putusan desc
			limit $limit;")->result();
	}
	
	public function info_perkara_pihak($perkara_id){
		return $this->dbsipp->query("select a.nomor_perkara,a.nama,b.pekerjaan,a.alamat, (case 
			when a.jenis_perkara_nama='Cerai Talak' and a.pihak_ke=1 or a.jenis_perkara_nama='Izin Poligami' and a.pihak_ke=1
			then 'Pemohon'
			when a.jenis_perkara_nama='Cerai Talak' and a.pihak_ke=2 or a.jenis_perkara_nama='Izin Poligami' and a.pihak_ke=2
			then 'Termohon'
			else a.status_perkara end) kategori_pihak,
			(case when (select max(c.urutan) from v_pihak_perkara c where c.pihak_ke=a.pihak_ke and c.perkara_id=a.perkara_id)=1 then NULL else concat(' ',a.urutan) end)urutan
			from v_pihak_perkara a join pihak b on a.pihak_id=b.id where a.perkara_id=$perkara_id order by a.pihak_ke,a.urutan;")->result_array();
	}	

	public function upload_putusan($perkara_no,$data_pihak){
		$anonim_ket  = array();
		$anonim_nama = array();
		$anonim_alamat = array();
		$anonim_alamat_pihak = array();
		$anonim_kota_kab = array();
		$anonim_sbg  = array();
		$alamat_explode = array('Kab.','Kabupaten','Kota','Kodya','Kotamadya','Kotamadia');

		foreach($data_pihak as $key => $value){
			$data_anonim_nama 		= array($data_pihak[$key]['nama']);
			$data_anonim_alamat_pihak = array($data_pihak[$key]['alamat']);
			$data_anonim_sbg 		= array(strtoupper($data_pihak[$key]['kategori_pihak']).$data_pihak[$key]['urutan']);
			$data_anonim_kota_kab	= array($this->explode_alamat($alamat_explode,$data_pihak[$key]['alamat']));
			$data_anonim_pekerjaan	= explode(',',$data_pihak[$key]['pekerjaan']);
			$data_anonim_alamat		= explode(',',$data_pihak[$key]['alamat']);
			$anonim_nama 	 	 = array_merge($anonim_nama,$data_anonim_nama);
			$anonim_sbg 	 	 = array_merge($anonim_sbg,$data_anonim_sbg);
			$anonim_kota_kab	 = array_merge($anonim_kota_kab,$data_anonim_kota_kab);
			$anonim_alamat 		 = array_merge($anonim_alamat,$data_anonim_alamat);
			$anonim_alamat_pihak = array_merge($anonim_alamat_pihak,$data_anonim_alamat_pihak);
			$anonim_ket			 = array_merge($anonim_ket,array_map('trim',$data_anonim_pekerjaan),array_map('trim',$data_anonim_alamat));}

		$data_anonim_nama 	= array_unique($anonim_nama);	
		$data_anonim_ket	= array_unique($anonim_ket);		
				
		foreach($data_anonim_ket as $keys => $value_anonim_ket){
			$replace_anonim_ket[$keys]	= preg_replace("[\S]", "x", $value_anonim_ket);}	
			$data_anonim 	= array_merge($anonim_alamat_pihak,$data_anonim_nama,$data_anonim_ket);
			$replace_anonim = array_merge($anonim_kota_kab,$anonim_sbg,$replace_anonim_ket);

		$perkara_no 				= str_replace(array('/','.',' '),'_',$perkara_no);
		$config['file_name'] 		= 'putusan_'.$perkara_no;
		$config['allowed_types']  	= 'docx|rtf';
		$config['upload_path'] 		= './assets/abt/';
		$config['overwrite'] 		= TRUE;
		$config['remove_spaces'] 	= TRUE;
		$config['file_ext_tolower'] = TRUE;
		$this->load->library('upload', $config);		
        if ( ! $this->upload->do_upload('file_putusan')){
			 $data['convert'] = FALSE;
			 $data['color']	  = 'red';
			 $data['msg']	  = $this->upload->display_errors();
			 $data['data']	  = NULL;
			 return $data;}
        else {
			$data	  = $this->upload->data();
			$conv_rtf = $data['full_path'];

if($this->convert_putusan($data['file_path'],$data['full_path'],$data['file_ext'])){
$file_rtf = file_get_contents($data['file_path'].$data['raw_name'].'.rtf');
$file_rtf = str_replace('
','',$file_rtf);
$file_rtf = str_replace('\hich\af1\dbch\af31505\loch\f0 ','',$file_rtf);
$file_rtf = str_replace('\hich\af1\dbch\af31505\loch\f1 ','',$file_rtf);
$data_rtf = str_replace($data_anonim,$replace_anonim,$file_rtf);

		$data['convert'] = TRUE;
		$data['msg']	 = 'Proses Anonim Berhasil';
		$data['color']	 = 'green';
		$data['data'] = array(
			'perkara_no' => $perkara_no,
			'data_rtf'	 => $data_rtf,
			'file_rtf'	 => $file_rtf,					
			'conv_rtf'	 => $conv_rtf);				
		return $data;}
	else{
		$data['convert'] = FALSE;
		$data['msg']	 = 'Proses Anonim Gagal, Pastikan Server SIPP menggunakan OS Linux Centos!<br>
		Atau unggah file RTF hasil edit Aplikasi AbleWord atau WPS Office.';
		$data['color']	 = 'red';
		$data['data']	 = NULL;
		@unlink($conv_rtf);
		return $data;}}
	}
	
	public function convert_putusan($path,$file,$ext){
		if (PHP_OS == 'Linux'){
			exec('soffice --convert-to rtf -env:UserInstallation=file:///tmp/.SIPP-rtf-${USER} --headless '.$file.' --outdir '.$path);
			return TRUE;}
		else if($ext=='.rtf'){
			return TRUE;}
		else {
			return FALSE;}
	}
	
	function explode_alamat($delimiters,$string) {
		$data = 'ALAMAT PIHAK';
		foreach ($delimiters as $key){			
			if(cekstring($string,$key)){
				$data = strtoupper($key.explode($key,$string)[1]);}}
		return $data;
		}
}
?>