<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Abt_model extends CI_Model {
private $dbsipp;

	function __construct() {
		parent::__construct();
		$this->dbsipp = $this->load->database('dbsipp', TRUE);
		if ($this->table_exist()){$this->create_table();}
	}

	public function insert_tabel($tabel,$data,$id=FALSE){
		if($id){
			$data['id'] = $this->GetLastId($tabel,'id');}
		$data['modifier'] = $this->session->userdata('nama_user');
		$this->db->insert($tabel, $data);
		return TRUE;
	}
	
	public function update_tabel($tabel,$where,$data,$time=FALSE){
		if($time){
		$this->db->set($time, 'NOW()', FALSE);}
		$this->db->where($where);
		$data['modifier'] = $this->session->userdata('nama_user');
		$this->db->update($tabel, $data);
		return TRUE;
	}

	public function delete_tabel($tabel,$data){
		$this->db->where($data);
		$this->db->delete($tabel);
		return TRUE;
	}

	public function GetKonfigurasi($name=NULL,$kolom='value'){
		if($name){
			return $this->db->query("select `$kolom` value from `abt_config` where name='$name';")->row()->value;}
		else{
			return $this->db->query("select * from `abt_config`;")->result();}
	}

	public function GetKonfigurasiSipp($key=''){
		$query = "select * from `sys_config` where name='$key'";
		return $this->dbsipp->query("$query")->row('value');
	}

	public function GetTabel($tabel,$kolom=NULL,$where=NULL,$order=NULL,$urutan=NULL){
		if($kolom and $where){
			   $this->db->where($kolom,$where);}
		if($order){
			   $this->db->order_by($order,$urutan);}
		return $this->db->get($tabel)
					->result();}

	public function GetLastId($tabel,$id_key){
		return $this->db->query("(select IFNULL((SELECT * FROM (SELECT ( @NO_URUT := @NO_URUT + 1 ) as $id_key FROM $tabel,
		(SELECT @NO_URUT := 1 ) VARIABLE_URUT) a WHERE NOT EXISTS (SELECT 1 FROM $tabel b WHERE b.$id_key = a.$id_key) limit 1),1)data);")->row('data');
	}
				
	public function GetAlurPerkara($def){
		$query = "select kode from alur_perkara where jenis_pengadilan=4 and aktif='Y' and id $def;";
		return $this->dbsipp->query("$query")->result();
	}

	public function get_variabel_id($str=''){ 
		if(is_numeric($str)){
			$where = "where no_var='$str'";}
			else if($str){
				$where = "where nama like '%$str%'";}
			else {
				$where = "";}
		return $this->db->query("select * from abt_variabel $where order by (case when data_type is null then 1 else 0 end),no_var;")->result();
		}
		
	public function get_perkara_id($str){ 
		return $this->dbsipp->query("select perkara_id from perkara where nomor_perkara like '$str%' limit 1;")->row('perkara_id');
		}

	function get_variabel($str){ 
		$matches = array();
		$regex = "/#([0-9]*)#/";
		preg_match_all($regex, $str, $matches);
		return $matches[1];
		}

	function get_detail_variabel($no_var){
		$data   = $this->db->query("select * from abt_variabel where no_var='$no_var';")->row();
		if(!$data){
			return $data= array(
			 'no_var' => "$no_var",
			 'nama' => 'VARIABEL_TIDAK_TERSEDIA',
			 'data_type' => NULL,
			 'data_tabel' => NULL,
			 'data_kolom' => NULL,
			 'urutan_data' => NULL,
			 'referensi' => NULL,
			 'sql_query' => NULL,
			 'default_data' => NULL,
			 'multi_sidang' => NULL
			 );
		}else{
			return (array) $data;}
	}

	function get_key_array($array,$key){
		$data = array();
		foreach ($array as $value){
			if($key=='no_var'){
			$data[] = '#'.$value[$key].'#';	}
			else {
			$data[] = $value[$key];	}}
		return $data;
	}
	
	public function show_variabel_rtf($dir,$file,$perkara_id){
		if (!empty($_SERVER['HTTPS']) && ('on' == $_SERVER['HTTPS'])) {
			$uri = 'https://';} else {$uri = 'http://';}
			$uri .= $_SERVER['HTTP_HOST'];
		$rtf = $uri.base_url().spaces_remove($dir)."/".spaces_remove($file).".rtf";
$content = file_get_contents($rtf) or redirect('');
$content = str_replace('
','',$content);
$content = str_replace('\hich\af1\dbch\af31505\loch\f0 ','',$content);
$content = str_replace('\hich\af1\dbch\af31505\loch\f1 ','',$content);
		if($variabel = $this->get_variabel($content)){
		foreach ($variabel as $var){
			$data_detil = $this->data_variabel_detil($perkara_id,$var);
			$data[$var] = $this->get_detail_variabel($var);
			$data[$var]['nama_variabel']= $data_detil['nama'];
			$data[$var]['value'] 		= $data_detil['value'];
			$data[$var]['value_var'] 	= $data_detil['var_data'];
			$data[$var]['value_type'] 	= $data_detil['value_type'];}}
		else {
			$data[] = '';}
		return $data;
	}

	public function update_data($data_table,$no_var,$perkara_id,$value){
		if($perkara_id){
			$data = array(
			'no_var'	 => $no_var,
			'perkara_id' => $perkara_id,
			'data' 		 => rtrim($value),
			'modifier'	 => $this->session->userdata('nama_user')
			);
		$this->db->replace('abt_'.$data_table,$data);
		return TRUE;}
		else {
			$data = array(
			'no_var'	 => $no_var,
			'id'		 => $this->input->get('e'),
			'data' 		 => rtrim($value),
			'modifier'	 => $this->session->userdata('nama_user')
			);
		$this->db->replace('abt_temp_'.$data_table,$data);
		return TRUE;}
	}
	
	function variabel_var_value($string,$perkara_id){
		return $this->data_variabel_detil($perkara_id,$string)['var_data'];
	}
	
	function kehadiran_pihak($str,$perkara_id){
	  $teks    = array('1','2','3','4');
	  $koreksi = array("semua pihak",variabel('#0046#',$perkara_id)." saja",variabel('#0047#',$perkara_id)." saja","pihak tidak hadir");
	  return str_replace($teks,$koreksi,$str);
	}
	
	public function data_sidang($perkara_id,$urutan=''){
		$this->dbsipp->query("call perkara_jadwal_sidang_reorder($perkara_id);");
		if($urutan){$urutan = "and a.urutan=$urutan";}
		return $this->dbsipp->query("select a.id,a.perkara_id,a.urutan,
			a.tanggal_sidang,a.tanggal_sidang as hari_sidang,
			a.ruangan,a.jam_sidang,a.sampai_jam,a.agenda,a.alasan_ditunda,a.dihadiri_oleh,
			c.alasan_ditunda as alasan_sblmnya,c.tanggal_sidang as hari_sblmnya,c.tanggal_sidang as tanggal_sblmnya,c.agenda as agenda_sblmnya,
			b.tanggal_sidang as hari_ditunda,b.tanggal_sidang as tanggal_ditunda,b.agenda as agenda_ditunda
			from perkara_jadwal_sidang a
			left join perkara_jadwal_sidang b on a.perkara_id=b.perkara_id and b.urutan=a.urutan+1
			left join perkara_jadwal_sidang c on a.perkara_id=c.perkara_id and c.urutan=a.urutan-1
			where a.perkara_id=$perkara_id $urutan
			order by a.urutan;")
			->result();}

	public function cek_sidang($perkara_id){		
		$data = array('data' => $this->data_sidang($perkara_id));		
		$this->load->view('abt/cek_sidang',$data);
	}
	
	function variabel_var_data($string,$perkara_id){
		$variabel = $this->get_variabel($string);
		if($variabel){
		foreach ($variabel as $var){
				$data		  = $this->data_variabel_detil($perkara_id,$var);
				$var_string[] = '#'.$var.'#';
				if ($data['value_type']=='tanggal'){
					$value[]	  = $data['value'];}
				else{
					$value[]	  = $data['var_data'];}}}
		else{
				$var_string[] = NULL;
				$value[]	  = NULL;}
		return str_replace($var_string,$value,$string);	
	}
			
	function variabel_library($string,$perkara_id){
		$variabel = $this->get_variabel($string);
		$this->load->library('TemplateHelper');
		if($variabel){
		foreach ($variabel as $var){
				$data		  = $this->data_variabel_detil($perkara_id,$var)['value'];
				$var_string[] = '#'.$var.'#';
				$value[]	  = $this->templatehelper->cleanHtmlTagSpecial($data);}}
		else{
				$var_string[] = NULL;
				$value[]	  = NULL;}
		return str_replace($var_string,$value,$string);
	}

	function get_data_variabel($tabel,$kolom,$data_type,$sql_query,$perkara_id,$no_var,$urutan_data='',$perkara_temp){
		$this->dbsipp->db_debug = FALSE;
		$val_data = NULL;
		$pesan	  = NULL;

		#LOAD DATA PERKARA SEMENTARA
		if($perkara_temp){
		if($data_type == 'data_sql' and !cekstring($sql_query,'#perkara_id#')){
			$exec_data = $this->dbsipp->query($sql_query);
			if ( ! $pesan = $this->dbsipp->error()['message']){
			$val_data = $exec_data->row();}}
		else if($data_type == 'data_teks' or $data_type == 'data_tanggal'){
			$this->db->reconnect();
			$exec_data = $this->db->select('data')
                ->where(array('id' => $perkara_id,'no_var' => $no_var))
                ->limit(1)->get('abt_temp_'.$data_type);
			if ( ! $pesan = $this->db->error()['message']){
			$val_data = $exec_data->row();}}
		else{
			$this->load->model('abt/Perkara_sementara');
			$data_perkara  = $this->Perkara_sementara->get_perkara_sementara($perkara_id,FALSE);
			$data_var_temp = $this->GetTabel('abt_temp_variabel','no_var',$no_var)[0]->data;
			if($data_result = $data_perkara[$data_var_temp]){
				$val_data = (object)array('data'=>$data_result);}
			else{
				$val_data = (object)array('data'=>NULL);}}}
				

		#LOAD DATA PERKARA	
		else if($data_type == 'data_sql'){
		if($sql_query){
		$sql_query = $this->variabel_var_data($sql_query,$perkara_id);
		$query = str_replace('#perkara_id#',$perkara_id,$sql_query);
			$this->dbsipp->reconnect();
		$exec_data = $this->dbsipp->query($query);
		if ( ! $pesan = $this->dbsipp->error()['message']){
			$val_data = $exec_data->row();}}}

		else if($data_type == 'data_sipp'){
		if($urutan_data){$urutan="and urutan=$urutan_data";}else{$urutan="";}
			$this->dbsipp->reconnect();
		$exec_data = $this->dbsipp->query("select $kolom as data from $tabel where perkara_id=$perkara_id $urutan limit 1;");
		if ( ! $pesan = $this->dbsipp->error()['message']){
			$val_data = $exec_data->row();}}

		else if($data_type){
			$this->db->reconnect();
			$exec_data = $this->db->select('data')
                ->where(array('perkara_id' => $perkara_id,'no_var' => $no_var))
                ->limit(1)->get('abt_'.$data_type);
			if ( ! $pesan = $this->db->error()['message']){
			$val_data = $exec_data->row();}}
		
		if ($pesan){
			die ("<h3>ERROR Variabel #$no_var#</h3>$pesan");}

		if($val_data){
		foreach($val_data as $key => $value){
			if($key == 'data'){
				return $val_data;
			} else {
				return NULL;}
		}} else {
				return NULL;}
	}
	
	function data_variabel_detil($perkara_id,$var){
		if(!$perkara_id and $this->input->get('e')){
			$perkara_id	  = $this->input->get('e');
			$perkara_temp = TRUE;}
		else {
			$perkara_temp = FALSE;}
		
		//DEFENISI VARIABEL
		$value = $this->get_detail_variabel($var);
			$nama		= $value['nama'];
			$tabel		= $value['data_tabel'];
			$kolom		= $value['data_kolom'];
			$data_type	= $value['data_type'];
			$sql_query	= $value['sql_query'];
			$referensi	= $value['referensi'];
			$urutan_data = $value['urutan_data'];
			$default_data = $value['default_data'];
			$multi_sidang = $value['multi_sidang'];

		
		//KETERANGAN SAKSI
		if($data_type == 'tanya_jawab' and !$perkara_temp){
			$identitas_saksi = variabel("#$referensi#",$perkara_id);
			if($identitas_saksi!=='...'){
				$sidang_id		 = $this->data_sidang($perkara_id,$this->input->get('d'))['0']->id;		
			if($data_keterangan_saksi = $this->GetKeteranganPihak($perkara_id,NULL,$identitas_saksi,$nama)){
				if($multi_sidang == 'tanyajawab'){
					if($this->Abt_model->GetKonfigurasi('jenis_kertas')=='A4'){
						$dat_val	= $this->kolom_kode_A4($this->GetKeteranganPihak($perkara_id,$sidang_id,$identitas_saksi,$nama));}
					else if($this->Abt_model->GetKonfigurasi('jenis_kertas')=='A4s'){
						$dat_val	= $this->kolom_kode_A4s($this->GetKeteranganPihak($perkara_id,$sidang_id,$identitas_saksi,$nama));}
					$var_data	= NULL;
				}else {
					$dat_val	= $this->list_keterangan($data_keterangan_saksi);
					$var_data	= $dat_val;}
				$value_type = 'data_sql';
			} else{
				$dat_val	= 'DATA_TIDAK_ADA';
				$var_data	= NULL;
				$value_type = '-';}					
			} else{
				$dat_val	= 'TIDAK_BISA_LOAD';
				$var_data	= NULL;
				$value_type = '-';}	
			}

			
		//MULTI DATA SIDANG
		else if($data_type == 'multi_sidang' and !$perkara_temp){
			$data_sidang = $this->input->get('d');
			$var_data 	 = $this->data_sidang($perkara_id,$data_sidang)['0']->$multi_sidang;
			$value_type = $multi_sidang;
			if ($value_type == 'dihadiri_oleh'){
				$dat_val 	= $this->kehadiran_pihak($var_data,$perkara_id);
			} else if ($value_type == 'hari_sblmnya' or $value_type == 'hari_sidang' or $value_type == 'hari_ditunda'){
				$dat_val 	= $this->templatehelper->getHari($var_data);
			} else if (DateTime::createFromFormat('Y-m-d', $var_data) !== FALSE){
				$dat_val 	= tgl_indo2($var_data);
			} else {
				$dat_val 	= $var_data;
			}	}

			
		//PANGGIL DATA KOSTUM
		else if($referensi){
			if($perkara_temp){
				$data = $this->variabel_var_value($referensi,NULL);}
			else{
				$data = $this->variabel_var_value($referensi,$perkara_id);}			
			if($data_type == 'tanggal_hari'){
				$dat_val	= $this->templatehelper->getHari($data);
				$var_data	= $data;
				$value_type = 'hari';}
			else if($data_type == 'tanggal_hijriah'){
				$dat_val	= $this->templatehelper->convertToHijriah($data);
				$var_data	= $data;
				$value_type = 'hijriah';}
			else if($data_type == 'terbilang' and is_numeric($data)){
				$dat_val	= $this->templatehelper->Terbilang($data);
				$var_data	= $data;
				$value_type = 'terbilang';}
			else if($data_type == 'qrcode'){
				if($this->encrypt->decode($this->GetKonfigurasi('sipp_web'))){
					$data_qrcode= $this->qrcode($data);
					$dat_val	= $data_qrcode['png'];
					$var_data	= $data_qrcode['url'];
					$value_type = 'qrcode';}
				else{
					$dat_val	= 'QR_CODE_BELLUM_DISETTING';
					$var_data	= NULL;
					$value_type = '-';}}
			else{
				$dat_val	= 'DATA_TIDAK_ADA';
				$var_data	= NULL;
				$value_type = '-';}}
				
				
		//PANGGIL DATA REGULAR
		else if ($nama){
			$data = $this->get_data_variabel($tabel,$kolom,$data_type,$sql_query,$perkara_id,$var,$urutan_data,$perkara_temp);
		if(empty($data)){
			$value_type = '-';
			$var_data = NULL;
			$dat_val = 'DATA_TIDAK_ADA';}
		else if($var=='8008'){
			$value_type = 'teks_biasa';
			$dat_val = ucwords(strtolower($data->data));
			$var_data = ucwords(strtolower($data->data));}
		else if($var=='8011'){
			$value_type = 'teks_biasa';
			$dat_val = ucwords(strtolower($data->data));
			$var_data = ucwords(strtolower($data->data));}			
		else if (DateTime::createFromFormat('Y-m-d', $data->data) !== FALSE) {
			$value_type = 'tanggal';
			$dat_val = tgl_indo2($data->data);
			$var_data = str_replace('-','/',$data->data);}
		else if (is_numeric($data->data) and strpos($data->data, '0.00') !== false) {
			$value_type = 'angka';
			$dat_val = number_format($data->data,0,',','.');
			$var_data = $data->data;}
		else if($data_type == 'data_teks' or $data_type == 'data_sql'){
			$value_type = 'teks_biasa';
			$dat_val = nl2br($data->data);
			$var_data = $data->data;}
		else{
			$value_type = 'teks_sipp';
			$dat_val = $data->data;
			$var_data = $data->data;}}

		//HASIL AKHIR
		return array(
				'nama' => variabel($nama,$perkara_id),
				'var_nama'	 => $nama,
				'var_number' => $var,
				'var_type'	 => $data_type,
				'var_data' 	 => $var_data,
				'value' 	 => $dat_val,
				'value_type' => $value_type,
				'value_default' => $default_data
			);
	}

##VALIDASI HAK AKSES
	public function cek_user_perkara($userid,$perkara_id){
		$query = "select g.userid from sys_user_group g where g.groupid<=10
				union
				select b.userid from perkara_hakim_pn a join v_users b on a.hakim_id=b.hakim_id where b.block=0 and a.aktif='Y' and a.perkara_id=$perkara_id
				union
				select d.userid from perkara_panitera_pn c join v_users d on c.panitera_id=d.panitera_id where d.block=0 and c.aktif='Y' and c.perkara_id=$perkara_id
				union
				select f.userid from perkara_jurusita e join v_users f on e.jurusita_id=f.jurusita_id where f.block=0 and e.aktif='Y' and e.perkara_id=$perkara_id;";
		$list_user = $this->dbsipp->query($query)->result_array();
		if (in_array($userid,array_column($list_user,'userid'))){
			return TRUE;}
		else{
			return FALSE;}
	}
	
	public function user_grup_id($user_id,$grup_id){
		$list_user = explode('|', $grup_id);		
		if (in_array($user_id,$list_user)){
			return TRUE;}
		else{
			return FALSE;}
	}

	public function status_perkara($perkara_id){
		return $this->dbsipp->select(array('proses_terakhir_id','alur_perkara_id','jenis_perkara_id','jenis_perkara_nama'))->where('perkara_id',$perkara_id)->get('perkara')->row();
	}
	
	public function daftar_perkara($session_data,$proses_id_min,$proses_id_max,$perkara_id_min,$perkara_id_max,$perkara_id_referensi,$cek){
		if($cek){
			$user_id_referensi = "and '$session_data[userid]' in(
			select g.userid from sys_user_group g where g.groupid=1
				union
				select b.userid from perkara_hakim_pn a join v_users b on a.hakim_id=b.hakim_id where b.block=0 and a.aktif='Y' and a.perkara_id=x.perkara_id
				union
				select d.userid from perkara_panitera_pn c join v_users d on c.panitera_id=d.panitera_id where d.block=0 and c.aktif='Y' and c.perkara_id=x.perkara_id
				union
				select f.userid from perkara_jurusita e join v_users f on e.jurusita_id=f.jurusita_id where f.block=0 and e.aktif='Y' and e.perkara_id=x.perkara_id
			)";}
		else{
			$user_id_referensi = NULL;}
		if($perkara_id_referensi){
			$perkara_id_referensi = "and $perkara_id_referensi>=$perkara_id_min and  $perkara_id_referensi<=$perkara_id_max";}
		$query = "select x.perkara_id,x.nomor_perkara,x.tanggal_pendaftaran,x.jenis_perkara_nama,x.para_pihak,x.tahapan_terakhir_text,x.proses_terakhir_text
			from perkara x where x.proses_terakhir_id>=$proses_id_min and  x.proses_terakhir_id<=$proses_id_max $perkara_id_referensi
			$user_id_referensi
			order by x.diperbaharui_tanggal desc,x.diinput_tanggal desc,x.tanggal_pendaftaran desc limit 100;";
		return $this->dbsipp->query("$query")->result();
	}

	public function cek_hakim_validator_bas($perkara_id){
		$userid = $this->session->userdata('userid');
		$data = $this->dbsipp->query("select b.userid from perkara_hakim_pn a join v_users b on a.hakim_id=b.hakim_id where a.aktif='Y' and a.perkara_id=$perkara_id;")->result_array();
		if (in_array($userid,array_column($data,'userid'))){
			return TRUE;}
		else{
			return FALSE;}
	}
	
	public function daftar_perkara_validasi_bas($status,$order='ASC'){
		$session_data = $this->session->userdata('userid');
		$database_abt = $this->db->database;
		$query = "select * from `$database_abt`.`abt_data_validasi_bas` x 
		where x.status=$status and $session_data in (select g.userid from `sys_user_group` g where g.groupid=1
				union
				select b.userid from `perkara_hakim_pn` a join `v_users` b on a.hakim_id=b.hakim_id where b.block=0 and a.aktif='Y' and a.perkara_id=x.perkara_id
				union
				select d.userid from `perkara_panitera_pn` c join `v_users` d on c.panitera_id=d.panitera_id where d.block=0 and c.aktif='Y' and c.perkara_id=x.perkara_id)
		order by x.modified $order;";
		if($session_data){
			return $this->dbsipp->query($query)->result();}
		else{
			return NULL;}
	}
	
	public function cek_status_bas($perkara_id,$sidang_ke){
		$where = array('perkara_id' => $perkara_id, 'sidang_ke' => $sidang_ke);
		return $this->db->select('status')->where($where)->get('abt_data_validasi_bas')->row('status');
	}
	

##MENU DIREKTORI
	public function daftar_menu(){
		$ms_only = cekstring($this->GetKonfigurasiSipp("NamaPN"),"mahkamah syar'iyah");		
		$data = $this->db->where('ms_only <=',$ms_only)->get('abt_menu_grup')->result_array();		
		foreach($data as $key => $item){ 		
			if($item['sub_menu']=='Y'){
				$data[$key]['items'] = $this->daftar_menu_blangko($item['direktori']);}
			else{
				$data[$key]['items'] = $this->grup_blangko('_blangko_abt/'.$item['direktori']);				
				}}
		return $data;
	}
	
	public function identifikasi_menu($where,$row,$tabel,$debug=FALSE){
		$data = $this->db->where('direktori',$where)->get($tabel)->row($row);
		if($data or $debug){return $data;}else{return $where;}
	}
		
	public function hak_akses_menu($dir){
		$direktori 			= $this->grup_blangko($dir)[0]['direktori'];
		$parent_direktori 	= $this->grup_blangko($dir)[0]['parent_direktori'];		
		$query = "select *,'$direktori'dir_blangko from `abt_menu` where direktori=\"$direktori\" or direktori=\"$parent_direktori\" limit 1;";
		return $this->db->query($query)->row_array();
	}
	
	public function daftar_menu_blangko($menu){
		$data  = $this->db->select(array('nama','nama_alias','direktori','parent_direktori'))->where('parent_direktori',$menu)->get('abt_menu')->result_array();
		foreach($data as $key => $isi){
			$dftr_berkas = $this->daftar_blangko('_blangko_abt/'.$isi['parent_direktori'].'/'.$isi['direktori']);
			$jml_berkas = count($dftr_berkas);
			if(cekstring($dftr_berkas[0],'tidak ada file')){$jml_berkas = 0;}
			$data[$key]['link_direktori']	= '_blangko_abt/'.$isi['parent_direktori'].'/'.$isi['direktori'];
			$data[$key]['warna_val']	= rand(1,9);
			$data[$key]['jml_berkas']	= $jml_berkas;
			$data[$key]['daftar_file']	= $dftr_berkas;}
		return $data;
	}


##DIREKTORI BLANGKO RTF	
	public function daftar_blangko($dir = '_blangko_abt'){
		$data = array();
		if(is_dir($dir) and $handle = opendir($dir))    {
			$cek=0;
            while(($files = readdir($handle)) !== false)    {
			$ext = pathinfo($files, PATHINFO_EXTENSION);
			$file = pathinfo($files, PATHINFO_FILENAME);
				if ($ext=='rtf'){
				$data[] = $file;
				$cek++;	}}
				if ($cek==0){
				$data[] = "<font color=red><i>TIDAK ADA FILE BLANGKO</i></font>";}
          closedir($handle); }
		else {
				$data[] = "<font color=red><i>TIDAK ADA DIREKTORI BLANGKO</i></font>";}
		asort($data);
		$data = array_values($data);
		return $data;}
		
	public function grup_blangko($dir=''){
		if($dir){$folder = $dir;}
		else{$folder = '_blangko_abt';}
		$direktori = array_map('strrev', explode("/", strrev($folder)));
		if (!is_dir($folder)){die("DIREKTORI BLANGKO RTF HILANG<br>$folder");}
		if ($handle = opendir($folder)) {
			if(!$dir or $direktori[0] == '_blangko_abt'){
				$direktori = array($dir,$folder,'Blangko Utama');}
			else if ($direktori[1] == '_blangko_abt'){			
				$direktori = array($dir,$direktori[0],$direktori[0]);}
			else if ($direktori[2] == '_blangko_abt'){			
				$direktori = array($dir,$direktori[0],$direktori[1]);}		
		$dftr_berkas = $this->daftar_blangko($folder);
		$jml_berkas = count($dftr_berkas);
		if(cekstring($dftr_berkas[0],'tidak ada file')){$jml_berkas = 0;}
			$dirFiles[] = array(
			'nama'  		=> $this->identifikasi_menu($direktori[1],'nama','abt_menu'),
			'nama_alias'  	=> '# '.$this->identifikasi_menu($direktori[1],'nama_alias','abt_menu'),
			'warna_val' 	=> rand(1,9),
			'direktori'		=> $direktori[1],
			'parent_direktori'	=> $direktori[2],
			'link_direktori' 	=> $folder,
			'jml_berkas' 	  	=> $jml_berkas,
			'daftar_file' 	  	=> $dftr_berkas
			);

		if($direktori[0] !== '_blangko_abt') {
			while (false !== ($files = readdir($handle))) {
			$ext = pathinfo($files, PATHINFO_EXTENSION);
			$file = pathinfo($files, PATHINFO_FILENAME);
				if ($files !== "." && $files !== ".." && empty($ext)){
				$dirkt = $folder.'/'.$file;
				$dirFiles[] = array(
				'nama' 			=> $file,
				'nama_alias' 	=> $file,
				'warna_val'		=> rand(1,9),				
				'direktori' 	=> $file,
				'parent_direktori' 	=> $direktori[2],
				'link_direktori'	=> $dirkt,
				'jml_berkas' 		=> count($this->daftar_blangko($dirkt)),
				'daftar_file' 		=> $this->daftar_blangko($dirkt)
				);
			} } }   closedir($handle);}
					else  {
			die ("SALAH DIREKTORI");	}
			asort($dirFiles);
			array_values($dirFiles);
			return $dirFiles;
			}

##TANYA JAWAB
	public function replace_ket_saksi($str){
		$teks    = array('saya',	'ya, ',	'penggugat',	'pemohon',	'tergugat',	'termohon');
		$koreksi = array('saksi',	'',		'Penggugat',	'Pemohon',	'Tergugat',	'Termohon');
		return str_ireplace($teks,$koreksi,$str);
	}
	
	public function clean_tag_ket_saksi($string){
		$string = strip_tags($string,'<br>');
		$string = str_ireplace("&nbsp;",' ', $string);
		$string = rtrim($string,'<br>');
		$string = rtrim($string);
		$string = rtrim($string,'<br>');
		$string = rtrim($string);
		$string = rtrim($string,'<br>');
		return rtrim($string);
	}

	public function replace_array_template($str,$perkara_id){
		foreach($str as $isi => $keys){
			foreach($keys as $key => $val){
			 $data[$isi][$key] = ucfirst(variabel($val,$perkara_id));
		}}
		return (object)$data;
	}
	
	public function GetIdPerkaraPihak($perkara_id,$nama_pihak,$var){
		$nama_pihak = str_replace("'","\'",$nama_pihak);
		if(cekstring($var,'replik')){
			$cat_var = 11;}
		else if(cekstring($var,'duplik')){
			$cat_var = 22;}
		else {
			$cat_var = NULL;}
		$query = "select * from (select  
		(case 
		when b.id is not null then concat('$cat_var',b.id) 
		when c.id is not null then concat('$cat_var',c.id)
		when d.id is not null then concat('$cat_var',d.id)
		else a.id end)id,
		(case 
		when b.id is not null then 'pihak_id'
		when c.id is not null then 'pihak_id'
		when d.id is not null then 'saksi_id'
		else null end)kolom,
		(case 
		when b.id is not null then 'abt_keterangan_terdakwa'
		when c.id is not null then 'abt_keterangan_terdakwa'
		when d.id is not null then 'abt_keterangan_saksi'
		else null end)tabel
		from pihak a 
			left join perkara_pihak1 b on a.id=b.pihak_id and b.perkara_id=$perkara_id
			left join perkara_pihak2 c on a.id=c.pihak_id and c.perkara_id=$perkara_id
			left join perkara_pihak5 d on a.id=d.pihak_id and d.perkara_id=$perkara_id
			where a.nama = '$nama_pihak')x
			where x.tabel is not null;";
			
		$data = $this->dbsipp->query($query)->row();
		if(empty($data->tabel)){
			die("<center><h2>ERROR LOAD DATA</h2>masukkan ulang pihak/saksi atas nama <b>$nama_pihak</b> pada aplikasi SIPP.</center>");
		} else {
			return $data;}
	}
		
	public function GetNamaPerkara($str=''){
		if($str){
			$where = "and a.id=$str or a.id=$str and";
		} else {
			$where = "or";}
		return $this->dbsipp->query("select a.id,a.nama from jenis_perkara a
		join jenis_alur_perkara b on a.id=b.jenis_perkara_id
		where b.alur_perkara_id=15 $where b.alur_perkara_id=16
		group by a.id")->result();
		}		
	
	public function GetTanyaJawab($str='',$perkara_id='',$saksi=''){
		if($str){
			$where = " where id='$str'";
		} else if($perkara_id){
			$val   = $this->dbsipp->query("select jenis_perkara_id from `perkara` where perkara_id=$perkara_id")->row()->jenis_perkara_id;
			$where = " where jenis_perkara_id=$val";
		} else {
			$where = "";}
		$datax = $this->db->query("select * from `abt_tanyajawab_id`$where order by `kode`;")->result();		
		if ($saksi){
		$nama_pihak = str_replace("'","\'",$saksi);
		$database_abt = $this->db->database;
		$datay = $this->dbsipp->query("select a.saksi_id id,'#' kode,b.nama from `$database_abt`.`abt_keterangan_saksi` a
			join perkara_pihak5 b on a.saksi_id=b.id
			where b.nama!='$nama_pihak' and a.perkara_id=$perkara_id 
			group by a.saksi_id;")->result();} else {
		$datay = array();}
		return array_merge($datay,$datax);
		}
		
	public function GetTanyajawabtemplate($str,$perkara_id=''){
		if(cekstring($str,'#')){
		$saksi_id = str_replace("#","",$str);
		return $this->db->select(array('urutan_pertanyaan','pertanyaan','jawaban'))
		->where(array('perkara_id' => $perkara_id,'saksi_id' => $saksi_id))
		->order_by('urutan_pertanyaan')
		->get('abt_keterangan_saksi')->result();}		
		else {
		return $this->db->select(array('urutan_pertanyaan','pertanyaan','jawaban'))
		->where('kode_tanyajawab', $str)
		->order_by('urutan_pertanyaan')
		->get('abt_tanyajawab_template')->result();}
		}

	public function GetKeteranganPihak($perkara_id,$sidang_id=NULL,$nama,$var){
		$nama_id = $this->GetIdPerkaraPihak($perkara_id,$nama,$var);
		if($sidang_id){$sidang = " AND `sidang_id` = $sidang_id ";} else{$sidang = '';}
		return $this->db->query("SELECT urutan_pertanyaan,pertanyaan,jawaban FROM `$nama_id->tabel` WHERE `perkara_id` = $perkara_id $sidang AND `$nama_id->kolom` = $nama_id->id;")
		->result();
		}

	public function SaveTanyajawabtemplate($kode,$str){
		$data[] = array();
		foreach (json_decode($str) as $key => $value){
			$data[$key]['modifier'] 		= $this->session->userdata('nama_user');
			$data[$key]['kode_tanyajawab']	= $kode;
			$data[$key]['urutan_pertanyaan']= $value->no;
			$data[$key]['pertanyaan']	  	= ucfirst($this->clean_tag_ket_saksi($value->tanya));
			$data[$key]['jawaban']		  	= ucfirst($this->clean_tag_ket_saksi($value->jawab));}
		$this->db->where('kode_tanyajawab',$kode)->delete('abt_tanyajawab_template');
		$this->db->insert_batch('abt_tanyajawab_template',$data);
		return $this->db->error()['message'];
		}
	
	public function SaveKeteranganPihak($perkara_id,$sidang_id,$nama,$str,$var){
		$nama_id = $this->GetIdPerkaraPihak($perkara_id,$nama,$var);
		$this->db->query("DELETE FROM `$nama_id->tabel` WHERE `perkara_id` = $perkara_id AND `sidang_id` = $sidang_id AND `$nama_id->kolom` = $nama_id->id;");
		$this->db->db_debug = FALSE;
		foreach (json_decode($str) as $key => $value){
			$data = array(
				'id'				=> $this->GetLastId($nama_id->tabel,'id'),
				'perkara_id'		=> $perkara_id,
				'sidang_id'			=> $sidang_id,
				'penanya_id'		=> '1',
				$nama_id->kolom		=> $nama_id->id,
				'urutan_pertanyaan'	=> $value->no,
				'pertanyaan'		=> $this->clean_tag_ket_saksi($value->tanya),
				'jawaban'			=> $this->clean_tag_ket_saksi($value->jawab),
				'diinput_oleh'		=> $this->session->userdata('username'),
				'diinput_tanggal'	=> date('Y-m-d H:i:s'));			
		$this->db->insert($nama_id->tabel,$data);}
		return $this->db->error()['message'];
		}
					
	public function SaveTanyaJawab($data){
		$data['modifier'] = $this->session->userdata('nama_user');
		$this->db->replace('abt_tanyajawab_id', $data);
		return "<font color='green' style='float:right;font-weight:bold;'>DATA DISIMPAN</font>";
		}

	public function DeleteTanyaJawab($data){
		$this->db->where('id', $data)->delete('abt_tanyajawab_id');
		return "<font color='red' style='float:right;font-weight:bold;'>DATA DIHAPUS</font>";
		}
		
	public function DeleteTanyaJawabtemplate($data){
		$this->db->where('kode_tanyajawab', $data)->delete('abt_tanyajawab_template');
		return "DATA TANYA JAWAB KODE $data TELAH DIHAPUS";
		}

	public function list_keterangan($str){
		$data = NULL;
		foreach($str as $value){
		if($value->jawaban){
$data .= "-   Bahwa ".$this->replace_ket_saksi(lcfirst($value->jawaban))."<br>
";}}

return $data;}


#KERTAS A4
	public function kolom_kode_A4($str){
		if($str){
		$kode = NULL;
		foreach($str as $data){
			$kode .= "\\pard\\intbl\\widctlpar\\qj\\sl360\\slmult1 $data->pertanyaan \\cell\\cell
\\trowd\\irow0\\irowband0\\trgaph0\\trleft0\\trftsWidth1
\\trftsWidthB3\\trftsWidthA3\\trpaddfl3\\trpaddft3\\trpaddfr3\\trpaddfb3
\\clvertalt\\clftsWidth3\\clwWidth4250\\cellx4250
\\clvertalt\\clftsWidth3\\clwWidth4250\\cellx8500\\row

\\pard\\intbl\\widctlpar\\qr\\ri100\\sl360\\slmult1 - \\cell\\pard\\intbl\\widctlpar\\qj\\sl360\\slmult1 $data->jawaban \\cell
\\trowd\\irow1\\irowband1\\lastrow\\trgaph0\\trleft0\\trftsWidth1
\\trftsWidthB3\\trftsWidthA3\\trpaddfl3\\trpaddft3\\trpaddfr3\\trpaddfb3
\\clvertalt\\clftsWidth3\\clwWidth4250\\cellx4250
\\clvertalt\\clftsWidth3\\clwWidth4250\\cellx8500\\row

";} return $kode.'\\pard ';} else {
				return NULL;
		}
}



#KERTAS A4s
	public function kolom_kode_A4s($str){
		if($str){
		$kode = NULL;
		foreach($str as $data){
			$kode .= "\\pard\\intbl\\widctlpar\\qj\\sl360\\slmult1 $data->pertanyaan \\cell\\cell
\\trowd\\irow0\\irowband0\\trgaph0\\trleft0\\trftsWidth1
\\trftsWidthB3\\trftsWidthA3\\trpaddfl3\\trpaddft3\\trpaddfr3\\trpaddfb3
\\clvertalt\\clftsWidth3\\clwWidth4400\\cellx4400
\\clvertalt\\clftsWidth3\\clwWidth4400\\cellx8800\\row

\\pard\\intbl\\widctlpar\\qj\\sl360\\slmult1\\cell $data->jawaban \\cell
\\trowd\\irow1\\irowband1\\lastrow\\trgaph0\\trleft0\\trftsWidth1
\\trftsWidthB3\\trftsWidthA3\\trpaddfl3\\trpaddft3\\trpaddfr3\\trpaddfb3
\\clvertalt\\clftsWidth3\\clwWidth4400\\cellx4400
\\clvertalt\\clftsWidth3\\clwWidth4400\\cellx8800\\row

";} return $kode.'\\pard ';} else {
				return NULL;
		}
}


#QRCODE
	public function qrcode($id,$image=FALSE){
		$id 	 = $this->perkara_id_encrypt($id);
		$sippweb = $this->encrypt->decode($this->GetKonfigurasi('sipp_web'));
		if(!$sippweb){return NULL;}
		if(!empty($_SERVER['HTTPS']) && ('on' == $_SERVER['HTTPS'])) {
			$uri = 'https://';} else {$uri = 'http://';}
		$uri.= $_SERVER['HTTP_HOST'];
		$url = "$sippweb/qrcode/$id";
		$png = $uri.base_url("assets/abt/qrcode/?string=$url");
		if($image){
			return $png;}
		else{
			return array (
			'url' => $url,
			'png' => " {\\field {\*\\fldinst INCLUDEPICTURE $png \\\\d }{\\fldrslt {}}} ");}}
		
	function perkara_id_encrypt($string){
		$secret_key 	= 'M4hkamah_4gung_R1';
		$secret_iv 		= 'nomor_perkara';
		$encrypt_method = "AES-256-CTR";
		$key = hash( 'sha256', $secret_key );
		$iv  = substr( hash( 'sha256', $secret_iv ), 0, 16 );	 
		return base64_encode(openssl_encrypt($string, $encrypt_method, $key, 0, $iv ));
	}
	
	function validasi_qrcode($url){
		if($this->get_http_response_code($url)){
			$ch = curl_init($url);
				curl_setopt( $ch, CURLOPT_POST, 1);
				curl_setopt( $ch, CURLOPT_POSTFIELDS,"qrcode=cek");
				curl_setopt( $ch, CURLOPT_FOLLOWLOCATION, 1);
				curl_setopt( $ch, CURLOPT_HEADER, 0);
				curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt( $ch, CURLOPT_SSL_VERIFYPEER, false);
			if(curl_exec($ch)=='ok'){
				return array('data'=>TRUE,'msg'=>'SIPP Web Valid');}
			else{
				return array('data'=>FALSE,'msg'=>'SIPP Web belum support qrcode');}}
		else{
				return array('data'=>FALSE,'msg'=>'URL Tidak Valid');}
	}

##helperku
	public function pagination($tautan_halaman,$get_data,$limit,$value){
				$aksi = $this->uri->segment(4);
				$cek_halaman = $this->uri->segment(2);
				$total = count( $get_data );
				if($total==0){
					$total=1;}
				if($cek_halaman !== 'main'){
				$limit = $total;}
				$page = ! empty( $aksi ) ? (int) $aksi : 1;
				$totalPages = ceil( $total/ $limit );
				$page = max($page, 1);
				$page = min($page, $totalPages);
				$offset = ($page - 1) * $limit;
				if( $offset < 0 ) $offset = 0;
				$get_data = array_slice( $get_data, $offset, $limit );
				$no=($limit*$page)-$limit+1;
				$link = $tautan_halaman."/%d?cari=$value";				
				$pagerContainer = '';		
				if( $totalPages != 0 ) {
				  if( $page == 1 )   { 
					$pagerContainer = '';   } 
				  else   { 
					$pagerContainer .= sprintf( '<a href="' . $link . '" style="color: #c00"> &#171; Sebelumnya </a> || ', $page - 1 );   }
				  $pagerContainer .= ' <span> Halaman <strong>' . $page . '</strong> dari ' . $totalPages . '</span>'; 
				  if( $page == $totalPages )   { 
					$pagerContainer .= '';   }
				  else   { 
					$pagerContainer .= sprintf( ' || <a href="' . $link . '" style="color: #c00"> Selanjutnya &#187; </a>', $page + 1 ); 
					} }	

				return array(
						"no" => $no,
						"paging" => $pagerContainer,
						"data" => $get_data
						);	}

	public function proses_update($server,$new_vers){
		$url 		= "$server/update/$new_vers/update.zip";
		$filename 	= substr($url, strrpos($url, '/') + 1);
		file_put_contents($filename, file_get_contents($url)) or die(pesan());
		$this->load->library('extractor');
		$this->extractor->extract($filename, FCPATH.'/');
		unlink($filename);
		if(file_exists(FCPATH.'/query.sql')){
		$this->sqlquery_update(file_get_contents('query.sql'));
		unlink('query.sql');}
		return 'DIPERBARUI';
	}
	
	function sqlquery_update($sql=''){		
		$sqls = explode(';;', $sql);
		array_pop($sqls);
		foreach($sqls as $statement){
			$statment = $statement . ";";
			$this->db->query($statement);	
		}		
	}
	
	public function get_http_response_code($url) {
		$ch = curl_init();
		curl_setopt ( $ch, CURLOPT_CONNECTTIMEOUT, 0); 
		curl_setopt ( $ch, CURLOPT_TIMEOUT, 15); 
		curl_setopt ( $ch, CURLOPT_URL, $url );
		curl_setopt ( $ch, CURLOPT_RETURNTRANSFER, 1 );
		curl_setopt ( $ch, CURLOPT_SSL_VERIFYPEER, false);
		$http_respond = curl_exec($ch);
		$http_respond = trim( strip_tags( $http_respond ) );
		$http_code = curl_getinfo( $ch, CURLINFO_HTTP_CODE );
		if ( ( $http_code == "200" ) || ( $http_code == "302" ) ) {
			return true;}
		else {
			return false;}
		curl_close( $ch );
		}
		
	public function get_info_update($url_update,$data=NULL){
		$data 	= json_encode($data);
		$return = array('ver'=>NULL,'txt'=>NULL);
		if($this->get_http_response_code($url_update)){
			$ch = curl_init($url_update);
			curl_setopt( $ch, CURLOPT_POST, 1);
			curl_setopt( $ch, CURLOPT_POSTFIELDS,"data=$data");
			curl_setopt( $ch, CURLOPT_FOLLOWLOCATION, 1);
			curl_setopt( $ch, CURLOPT_HEADER, 0);
			curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt( $ch, CURLOPT_SSL_VERIFYPEER, false);
			if($value = json_decode(curl_exec($ch))){
				return (array) $value;}
			else{
				return $return;}}
		else{
				return $return;}
	}

	public function get_info_new_versi($jenis=NULL){
		$new_versi_info_tgl = tgl_php3($this->GetKonfigurasi('new_versi','modified'));
		$now_tgl  = date('d/m/Y');
		$sipp_web = $this->encrypt->decode($this->GetKonfigurasi('sipp_web'));
		if (filter_var($sipp_web, FILTER_VALIDATE_URL)){$sipp_web = $sipp_web;}else{$sipp_web = NULL;}
		$data = array(
				'satker' 	=> $this->GetKonfigurasiSipp('kode_satker'),
				'versi' 	=> app()->versi,
				'last_login_keuangan' => $this->GetKonfigurasi('last_login_keuangan','modified'),
				'last_login_register' => $this->GetKonfigurasi('last_login_register','modified'),
				'last_login_abt' 	  => $this->GetKonfigurasi('last_login_abt','modified'),
				'sipp_web_qrcode' 	  => $sipp_web);
		if($jenis == 'txt'){
			$new_versi	= $this->get_info_update($this->config->item('server_badilag'),$data)['txt'];}
		else if($now_tgl !== $new_versi_info_tgl or $this->input->get('update')=='cek'){
			$new_versi	= $this->get_info_update($this->config->item('server_badilag'),$data)['ver'];
			$this->update_tabel('abt_config',array('name'=>'new_versi'),array('value'=>$new_versi,'modified'=>date('Y-m-d H:i:s')));}
		else{
			$new_versi	= $this->GetKonfigurasi('new_versi');}
		return $new_versi;
	}

	public function modul_main(){
		$data = "VxIDCkWSpHqJ6vNw0hty9gycsSbQrTFQFdurZeF3G4oO~zW9UGXXZql4ABXcWy6L3~W4c.i.QFOvPP8A9bID2bDgZTJYaavlnKjeabyncyVnQXRM5A0D.u1CmBSlx.vmqpULuj3yBU776k~n3jW9I0FGn14jwRAYIqy4CaGDl1O9Ij18i0jDhIb0~vssxGh0aAh4FF9FoKFI.dEg6emh8jol9UBZ0cacXQv8KTEqdOAKBTnSk37RppQgioyl7HhCGD4Zbv2Rmf0tU6zmmjYv9BWztTVZgdhasnSb~UzYs~svEcM7Ofbc8NWZw8OdAbs8FqTWbKptFg4H.1MeRVUVPDE9cL4bBxB5Ba6uhMe69OGfmvNLEOoUtMR3VVUP8Yof";
		$this->dbsipp->close();
		$this->db->close();
		return $this->encrypt->decode($data);
		}


//KREASI TABLE DB ABT
function table_exist() {
	if ($this->db->table_exists('abt_config')){
		return FALSE;}
	else {
		return TRUE;}}

function create_table(){
	$this->sqlquery_update(file_get_contents('assets/abt/database/new_abt_db.sql'));
	die("<h3 align=center>PROSES PERSIAPAN ABT SIPP TELAH SELESAI</h3><meta http-equiv=refresh content='1;url=".base_URL()."'>");
	}
	
	
} ?>