<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class TemplateHelper{

	function getHari($tgl){
		if(empty($tgl))
			return '';
    	$namahari = array('Minggu','Senin', 'Selasa', 'Rabu', 'Kamis', 'Jumat', 'Sabtu');
    	$hari =date('w', strtotime($tgl));
    	return  $namahari[$hari];
	}
	
	function cleanHtmlTagSpecial($text){
		//by iwan
		$text = str_replace("’","'",$text);
		$text = str_replace("DATA_TIDAK_ADA","...",$text);
		$text = str_replace("TIDAK_BISA_LOAD","...",$text);
		$text = str_replace("QR_CODE_BELLUM_DISETTING","",$text);
		$text = str_replace("</p>","\\par",$text);
		$text = str_replace(" <p","<p",$text);
		$text = str_replace("-   ","-\\tab ",$text);
		$text = str_replace("-  ","-\\tab ",$text);
		$text = str_replace(".   ",".\\tab ",$text);
		$text = str_replace(".  ",".\\tab ",$text);
		$text = str_replace("    ","\\tab ",$text);
		$text = str_replace("   ","\\tab ",$text);
		$text = preg_replace('/\<br(\s*)?\/?\>/i', "\\par ", $text);
		
		$text = str_replace(chr(194),"",$text);
		$text = html_entity_decode($text, ENT_QUOTES, "UTF-8");
		$text = str_replace("  "," ",$text);
		$text = str_replace("<ol>","<ol type='1'> ",$text);		
		$text = str_replace("</li>","</li> \\par ",$text);
		$text = str_replace("<li>","<li> \\tab ",$text);
		$text = str_replace("<li >","<li> \\tab ",$text);
		$text = str_replace("</ol>","</ol> ",$text);
		$text = str_replace("<strong>","\b ",$text);
		$text = str_replace("</strong>","\b0 ",$text);	
		$text = filter_var($text, FILTER_SANITIZE_STRING);
		$text = str_replace('&#39;',"'",$text);
		$text = str_replace('&#34;','"',$text);
		$text = str_replace('&#160;',' ',$text);
		$text = str_replace(';','; ',$text);
	    $text = str_replace('&nsbp',' ',$text);
	    $text = str_replace("&nbsp; ","",$text);
	    $text = str_replace("</p>","",$text);
	    $text = str_replace('”'," ",$text);		
	    $text = str_replace('“'," ",$text);
		$text = trim($text);

		return $text;
	}
	
	function convertToHijriah($tanggal) {
		if(empty($tanggal)){
			return NULL;}
		
		$array_bulan = array("Muharram", "Safar", "Rabiul Awwal", "Rabiul Akhir","Jumadil Awwal","Jumadil Akhir", "Rajab", "Sya'ban","Ramadhan","Syawwal", "Zulqaidah", "Zulhijjah");
		$date = $this->makeInt(substr($tanggal,8,2));
		$month = $this->makeInt(substr($tanggal,5,2));
		$year = $this->makeInt(substr($tanggal,0,4));
		if (($year>1582)||(($year == "1582") && ($month > 10))||(($year == "1582") && ($month=="10")&&($date >14))) {
			$jd = $this->makeInt((1461*($year+4800+$this->makeInt(($month-14)/12)))/4)+
			$this->makeInt((367*($month-2-12*($this->makeInt(($month-14)/12))))/12)-
			$this->makeInt( (3*($this->makeInt(($year+4900+$this->makeInt(($month-14)/12))/100))) /4)+
			$date-32075;
		} else {
			$jd = 367*$year-$this->makeInt((7*($year+5001+$this->makeInt(($month-9)/7)))/4)+
			$this->makeInt((275*$month)/9)+$date+1729777;
		}

		$wd = $jd%7;
		$l = $jd-1948440+10632;
		$n=$this->makeInt(($l-1)/10631);
		$l=$l-10631*$n+354;
		$z=($this->makeInt((10985-$l)/5316))*($this->makeInt((50*$l)/17719))+($this->makeInt($l/5670))*($this->makeInt((43*$l)/15238));
		$l=$l-($this->makeInt((30-$z)/15))*($this->makeInt((17719*$z)/50))-($this->makeInt($z/16))*($this->makeInt((15238*$z)/43))+29;
		$m=$this->makeInt((24*$l)/709);
		$d=$l-$this->makeInt((709*$m)/24);
		$y=30*$n+$z-30;
		$g = ($m%12)-1;
		if ($g==-1){
			$g=11;
		}
		$final = "$d $array_bulan[$g] $y ";
		return $final;
	}

	public function Terbilang($x){
		if ($x==''){
			$x=0;}
			
		if ($x==0){
			return '';}
			
			$abil = array("", "satu", "dua", "tiga", "empat", "lima", "enam", "tujuh", "delapan", "sembilan", "sepuluh", "sebelas");
			if ($x < 12)
				return " " . $abil[$x];
			elseif ($x < 20)
    			return $this->Terbilang($x - 10) . " belas";
    		elseif ($x < 100)
    			return $this->Terbilang($x / 10) . " puluh" .$this->Terbilang($x % 10);
    		elseif ($x < 200)
    			return " seratus" .$this->Terbilang($x - 100);
    		elseif ($x < 1000)
    			return $this->Terbilang($x / 100) . " ratus" .$this->Terbilang($x % 100);
    		elseif ($x < 2000)
    			return " seribu" .$this->Terbilang($x - 1000);
    		elseif ($x < 1000000)
    			return $this->Terbilang($x / 1000) . " ribu" .$this->Terbilang($x % 1000);
    		elseif ($x < 1000000000)
    			return $this->Terbilang($x / 1000000) . " juta" .$this->Terbilang($x % 1000000);
	}
	
	function ambil_kecamatan($alamat) {
		 $A = explode(' ',trim($alamat));	     
	     for ($i=0; $i<=count($A)-1 ; $i++) {	      	
	      	 if (strtoupper($A[$i]) == 'KECAMATAN')  {
				 break;
	         }		       
		  }
	   
	      for ($i=$i; $i<=count($A)-1 ; $i++) { 	   	
	        if ((strtoupper($A[$i]) =='KABUPATEN') || (strtoupper($A[$i])== 'KOTA') || (strtoupper($A[$i])== 'KAB') || (strtoupper($A[$i]) == 'KAB.')) {
	      	 	break;
	         }
	     	  else {		        
		         if (strtoupper($A[$i])<>'KECAMATAN') {		     
		     // $kecamatan="kecamatan".$i." ".$A[$i];		       
		       return  "Kecamatan ".$A[$i];
		       }
	        }
		 }
	}

    
    function makeInt($angka) {
	if ($angka < -0.0000001) {
		return ceil($angka-0.0000001);
	} else {
		return floor($angka+0.0000001);
	}
}


	function ambil_kabupaten($alamat) {      
        $A = explode(' ',trim($alamat));
       for ($i=0; $i<=count($A)-1 ; $i++) {       	
      	 if (strtoupper($A[$i]) == 'KECAMATAN')  {
      	 	break;
         }	       
	  } 
   
      for ($i=$i; $i<=count($A)-1 ; $i++) {       	
        if ((strtoupper($A[$i]) =='KABUPATEN') || (strtoupper($A[$i])== 'KOTA') || (strtoupper($A[$i])== 'KAB') || (strtoupper($A[$i]) == 'KAB.')) {
      	 	break;
         }
     	  else {	        
	         if (strtoupper($A[$i])<>'KECAMATAN') {
	         	//echo "Kecamatan".$i." ".$A[$i]."<br>";
	         echo '';	
	       }
        }
	 }


	  for ($i=$i; $i<=count($A)-1 ; $i++) {
       if ((strtoupper($A[$i]) == 'KABUPATEN') || (strtoupper($A[$i]) == 'KOTA') || (strtoupper($A[$i]) == 'KAB') || (strtoupper($A[$i]) == 'KAB.')) {
         echo '';
       }
          else {
             	if ((strtoupper($A[$i]) <> 'KABUPATEN') || (strtoupper($A[$i]) <> 'KOTA') || (strtoupper($A[$i]) <> 'KAB') || (strtoupper($A[$i]) <> 'KAB.')) {     	 	   
	      	 	     if ((strtoupper($A[$i-1]) == 'KABUPATEN') || (strtoupper($A[$i-1]) == 'KAB')) {
	                    $kabupaten="Kabupaten ";
	      	 	     } else if (strtoupper($A[$i-1]) == 'KOTA') {
	                    $kabupaten="Kota ";
	      	 	     } 
      	 	         return $kabupaten." ".$A[$i];              
               }
          }
	 }
    }



}