<?php
defined('BASEPATH') OR exit('No direct script access allowed');
ini_set('max_execution_time', 0); 
ini_set('memory_limit','2048M');

class Tools extends CI_Controller {

	public function __construct(){
		parent::__construct();		
		$this->mymodel->squrity();
		$this->load->model('keuangan/api');
		//$this->mymodel->squrity();
	}	
	public function index()
	{
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/transaksi_harian/keuangan_transaksi_harian');
		$this->load->view('keuangan/page/footer');
	}
	public function trans_harian()
	{
		$sys = $this->mymodel->sys_config();
		$data['list_kategori'] = $this->mymodel->list_kategori();
		$data['NamaPN'] = $sys['NamaPN'];
		$this->load->view('keuangan/page/header');
		$data['title']="Transaksi Keuangan Jurnal Harian";
		$this->load->view('keuangan/transaksi_harian/v_trans_harian',$data);
		$this->load->view('keuangan/page/footer');
		
	}
	public function trans_harian_ajax()
	{
		$sys = $this->mymodel->sys_config();
		$data['NamaPN'] = $sys['NamaPN'];
		$this->load->model('keuangan/panjar');
		$tgl_start = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_start'));
		$tgl_finish = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_finish'));
		$tgl_start = date_format($tgl_start, "Y-m-d");		
		$tgl_finish = date_format($tgl_finish, "Y-m-d");		
		$kategori =  $this->input->post('kategori');	
		$kat = $this->panjar->kategori_id($kategori);
		$data['tgl_start'] = $tgl_start;
		$data['tgl_finish'] = $tgl_finish;
		if($kategori !== '99'){
			if($kategori == '0'){
				$data['title'] = "REKAP TRANSAKSI PENERIMAAN DAN PENGELUARAN";
			}
			else{
				$data['title'] = "REKAP TRANSAKSI ".strtoupper($kat['keterangan']);
			}
			$a = $this->panjar->trans_harian($tgl_start,$tgl_finish,$kategori);			
			$b = $this->panjar->trans_harian_ht($tgl_start,$tgl_finish,$kategori);	
			$q = array_merge($a->result_array(),$b->result_array());
			usort($q, function ($a, $b){
				$t1 = strtotime($a['tanggal_transaksi']);
				$t2 = strtotime($b['tanggal_transaksi']);
				$retfal = $t1 - $t2;
				return $retfal;});			
			$data['list_trans'] = $q;
			$this->load->view('keuangan/transaksi_harian/v_trans_harian_ajax',$data);
		}
		else{
			$data['title'] = "REKAP TRANSAKSI BIAYA HAK-HAK KEPANITERAAN LAINNYA ";
			
			$q = $this->panjar->trans_hhk_lain($tgl_start,$tgl_finish);		
			
			$data['list_trans'] = $q->result_array();
			$this->load->view('keuangan/transaksi_harian/v_trans_hhkl_ajax',$data);
		}
	}
	public function pnbp()
	{
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/transaksi_harian/transaksi_pnbp_harian');
		$this->load->view('keuangan/page/footer');
	}
	public function atk()
	{
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/transaksi_harian/transaksi_atk_harian');
		$this->load->view('keuangan/page/footer');
	}
	public function panggilan()
	{
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/transaksi_harian/transaksi_panggilan_harian');
		$this->load->view('keuangan/page/footer');
	}
	public function pemberitahuan()
	{
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/transaksi_harian/transaksi_pemberitahuan_harian');
		$this->load->view('keuangan/page/footer');
	}
	public function materai()
	{
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/transaksi_harian/transaksi_materai_harian');
		$this->load->view('keuangan/page/footer');
	}
	public function sisa()
	{
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/transaksi_harian/transaksi_sisa_panjar_harian');
		$this->load->view('keuangan/page/footer');
	}
	public function hhk()
	{
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/transaksi_harian/transaksi_hhk_harian');
		$this->load->view('keuangan/page/footer');
	}
	public function hhkl()
	{
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/transaksi_harian/transaksi_hhkl_harian');
		$this->load->view('keuangan/page/footer');
	}
	public function valid_hr()
	{
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/transaksi_harian/validasi_harian');
		$this->load->view('keuangan/page/footer');
	}
	public function valid_bl()
	{
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/transaksi_harian/validasi_bulanan');
		$this->load->view('keuangan/page/footer');
	}
	public function valid_th()
	{
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/transaksi_harian/validasi_tahunan');
		$this->load->view('keuangan/page/footer');
	}
/* 	public function verifikasi_harian()
	{
		$this->load->model('keuangan/api');
		$tgl_lht = $this->input->post('tgl_lht');
		$salin_data = $this->api->salin_data($tgl_lht);
			echo "<pre>";
			print_r($salin_data);
			echo "</pre>";
	} */
	
	public function verifikasi_harian(){
		$data['title'] = "Validasi dan Pengiriman Data Keuangan";			
		$sys = $this->mymodel->sys_config();
		$sys2 = $this->mymodel->get_config();
		$data['nm_satker'] = $sys['NamaPN'];
		$data['id_satker'] = $sys['id_satker'];
		$data['nm_pta'] = $sys['NamaPT'];
		$data['url_server_update'] = $sys2['url_server_update'];
		$data['url_alternative'] = $url = $this->config->item('server_update2');
		$tgl_lht = $this->input->post('tgl_lht');
		// $data['salin_data'] = $this->api->salin_data($tgl_lht);
		$data['tgl_lihat'] = $tgl_lht;
			// echo "<pre>";
			// print_r($data['salin_data']);
			// echo "</pre>";
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/transaksi_harian/v_kirim_data',$data);
		$this->load->view('keuangan/page/footer');	
	}
	public function salin_data(){
		$tgl_lht = $this->input->post('tgl_lht');
		if ($this->api->salin_data($tgl_lht)){
				echo json_encode(array('st'=>'1','msg'=>'Sukses, Data Sukses disalin'));
				return;
		}else{
				echo json_encode(array('st'=>'0','msg'=>'Error, Data Tidak Dapat Disimpan'));
				return;
		}
	}
	public function cek_data(){
		$tgl_lht = $this->input->post('tgl_lihat');
			
		$this->load->model('keuangan/api');	
		$data = $this->api->cek_data($tgl_lht)->result_array();
		echo json_encode($data);
		
		// echo "<pre>";
			// print_r($tgl_lht);
			// echo "</pre>";
	}
	
	public function get_data_keuangan($id){
		$sys = $this->mymodel->sys_config();

		$d2['id_satker'] = $sys['id_satker'];
		
		$this->load->model('keuangan/api');	
		$d = $this->api->get_data($id);
		$data = array_merge($d2,$d);

		
		echo json_encode($data);
	}
	public function get_data_keuangan2(){
		$tgl = $this->input->post('tgl_lihat');
		$sys = $this->mymodel->sys_config();

		$d2['id_satker'] = $sys['id_satker'];
		$d2['pengirim'] = $this->session->userdata('fullname');
		$d2['tanggal_transaksi'] = $tgl;
		
		
		$this->load->model('keuangan/api');	
		$d = $this->api->get_data3($tgl);
		$d2['total'] = count($d);
		if($d2['total']>0){
			$d2['data'] = json_encode($d);
		
			$c = $this->api->cek_data_validasi($tgl);
			if($c>0){
				$where = array('tanggal_transaksi' => $tgl);
				$this->mymodel->delete_data($where, 'keu_biaya');
			}
			if($this->db->insert_batch('keu_biaya',$d)){
				$d2['salin_data'] = 'Data Berhasil Di Salin Ke Lokal';				
			}else{
				$d2['salin_data'] = 'Gagal Menyalin Data';
			}
		}
		
			
		header("Content-type:application/json");
		echo json_encode($d2);
		// echo "<pre>";
			// print_r($insert);
			// echo "</pre>";
	}
	public function tes(){
		
		$sessid = '';
		while (strlen($sessid) < 32)
		{
			$sessid .= mt_rand(0, mt_getrandmax());
		}

		// To make the session ID even more secure we'll combine it with the user's IP
		$sessid .= $this->input->ip_address();
		
		
		echo "<pre>";
    		print_r($this->session->all_userdata());
    		print_r(time());
			echo "</pre>";
	}
	public function cetak_kwitansi(){
		$this->load->view('keuangan/transaksi_harian/kwitansi_hhkl_baru');
	}
	public function cek_selisih(){
		$this->load->view('keuangan/transaksi_harian/keuangan_valid_bulanan_cek');
	}
	public function cek_url($url){
		$handle = curl_init($url);
        curl_setopt($handle,  CURLOPT_RETURNTRANSFER, TRUE);

        $response = curl_exec($handle);
        $httpCode = curl_getinfo($handle, CURLINFO_HTTP_CODE);

        if($httpCode >= 200 && $httpCode <= 400) {
            return true;
        } else {
            return false;
        }

        curl_close($handle);
	}
}