<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Tambah_transaksi extends CI_Controller {

	public function index()
	{
		$data['list_trans'] = $this->mymodel->list_transaksi_bku();
		$data['title'] = "Tambah Transaksi";
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/v_tambah_transaksi',$data);
		$this->load->view('keuangan/page/footer');	
		//var_dump($data['list_trans']->row_array());
	}
	public function perkara()
	{
		$data['list_kategori'] = $this->mymodel->list_kategori_bku();
		$data['title'] = "Tambah Transaksi Perkara";
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/v_tambah_transaksi_perkara',$data);
		$this->load->view('keuangan/page/footer');	
		//var_dump($data['list_trans']->row_array());
	}
	public function list_jenis($id,$tahapan)
	{			
		$where = array('kategori_id' => $id, 'tahapan_id' => $tahapan);
		$q = $this->mymodel->get_data_where($where, 'keu_jenis_biaya_tambahan');
		foreach ($q->result_array() as $h){
			echo "<option value='".$h['id']."%".$h['nama']."%".$h['jenis_transaksi']."%".$h['kategori_id']."%".$h['tahapan_id']."'>".$h['nama']."</option>";
		}			
		//var_dump($data->result_array());
	}
	public function simpan_data()
	{
		$data['jumlah'] = str_replace(".","",$this->input->post('jumlah'));			
		$tgl = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_trans'));
		$data['tanggal_transaksi'] = date_format($tgl, "Y-m-d");		
		$jn =explode("%",$this->input->post('jenis_id'));
		$data['jenis_biaya_id'] = $jn[0];
		$data['uraian'] = $jn[1];
		$data['jenis_transaksi'] = $jn[2];
		$data['kategori_id'] = $jn[3];
		$kat_id = $data['kategori_id'];
		$data['tahapan_id'] = $jn[4];		
		$data['keterangan'] = $this->input->post('keterangan');	
		$data['diinput_tanggal'] = date("Y-m-d");	
		$res = $this->mymodel->insert_data('keu_perkara_biaya_tambahan',$data);
		if($res>=1){
			$this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Data Berhasil Disimpan</div>');
			echo "sukses";
		}
		else{
			$this->session->set_flashdata('msg', '<div class="alert alert-warning text-center">Input Gagal</div>');
			echo "gagal";
		}
		//var_dump($data);	
		if($kat_id == 100){
			redirect('/keuangan/buku_bantu/bank');
		}
		else if($kat_id < 100){
			$this->session->set_flashdata('tgl', $this->input->post('tgl_trans'));
			redirect('/keuangan/buku_bantu/menu/'.$kat_id);
		}
		else{
			redirect('/keuangan/monitoring/data_transaksi');
		}
		
		
	}
	public function simpan_data_perkara()
	{
		$tgl = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_trans'));
		$data['tanggal_pendaftaran'] = date_format($tgl, "Y-m-d");	
		$nomor = $this->input->post('no_perk');
		$pdt = $this->input->post('pdt');
		$thn = $this->input->post('thn');
		$sys = $this->mymodel->sys_config();
		$kdPN = $sys['KodePN'];
		$no_perk = $nomor."/Pdt.".$pdt."/".$thn."/".$kdPN;
		$data['nomor_perkara'] = $no_perk;
		$res = $this->mymodel->insert_data('keu_perkara_masuk',$data);
		$insert_id = '';
		if($res>=1){
			$this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Data Berhasil Disimpan</div>');
			$insert_id = $this->db->insert_id();
			echo "sukses </br>";
			echo $insert_id;
		}
		else{
			$this->session->set_flashdata('msg', '<div class="alert alert-warning text-center">Input Gagal</div>');
			echo "gagal";
		}
		$data2['jumlah'] = str_replace(".","",$this->input->post('jumlah'));	
		$data2['tanggal_transaksi'] = $data['tanggal_pendaftaran'];		
		$jn =explode("%",$this->input->post('jenis_id'));
		$data2['jenis_biaya_id'] = $jn[0];
		$data2['uraian'] = $jn[1];
		$data2['jenis_transaksi'] = $jn[2];
		$data2['kategori_id'] = $jn[3];
		$data2['tahapan_id'] = $jn[4];		
		$data2['keterangan'] = $this->input->post('keterangan');	
		$data2['diinput_tanggal'] = date("Y-m-d");	
		$data2['perkara_id'] = $insert_id;	
		$res2 = $this->mymodel->insert_data('keu_perkara_biaya_tambahan',$data2);
		if($res2>=1){
			$this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Data Berhasil Disimpan</div>');
			$insert_id = $this->db->insert_id();
			echo "sukses </br>";
			echo $insert_id;
		}
		else{
			$this->session->set_flashdata('msg', '<div class="alert alert-warning text-center">Input Gagal</div>');
			echo "gagal";
		}
		redirect('/keuangan/monitoring/data_transaksi');
	}	
	function myfunction($val)
	{
		$val = str_replace(',','.',str_replace('.','',$val));
		return($val);
	}	

}
