<?php
defined('BASEPATH') OR exit('No direct script access allowed');
ini_set('max_execution_time', 0); 
ini_set('memory_limit','2048M');
class Saldo_awal extends CI_Controller {

	public function index()
	{
		$this->db->order_by('saldo_awal_tanggal', 'DESC');
		$data['saldo_awal'] = $this->mymodel->get_data('keu_saldo_awal_bku');
		$data['title'] = "Saldo Awal Buku Kas Umum";
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/v_saldo_awal',$data);
		$this->load->view('keuangan/page/footer');		
	}
	public function tambah()
	{		
		$data['title'] = "Tambah Saldo Awal";
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/v_tambah_saldo_awal',$data);
		$this->load->view('keuangan/page/footer');		
	}
	public function edit($id)
	{		
		$where = array('id' => $id );
		$data['saldo_awal'] = $this->mymodel->get_data_where($where, 'keu_saldo_awal_bku');
		$data['title'] = "Edit Saldo Awal";
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/v_edit_saldo_awal',$data);
		$this->load->view('keuangan/page/footer');		
	}
	public function update()
	{
		$id =  $this->input->post('id');
		$new_row = array_map(array($this, 'myfunction'), $_POST);
		unset($new_row['id']);
		$where = array('id' => $id );
		$res = $this->mymodel->update_data($where,'keu_saldo_awal_bku',$new_row);
		if($res>=1){
			$this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Data Berhasil Disimpan</div>');
			echo "sukses";
		}
		else{
			$this->session->set_flashdata('msg', '<div class="alert alert-warning text-center">Input Gagal</div>');
			echo "gagal";
		}
		//var_dump($new_row);
		redirect('/keuangan/saldo_awal');
	}	
	public function simpan()
	{
		$new_row = array_map(array($this, 'myfunction'), $_POST);
		$res = $this->mymodel->insert_data('keu_saldo_awal_bku',$new_row);
		if($res>=1){
			$this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Data Berhasil Disimpan</div>');
			echo "sukses";
		}
		else{
			$this->session->set_flashdata('msg', '<div class="alert alert-warning text-center">Input Gagal</div>');
			echo "gagal";
		}
		redirect('/keuangan/saldo_awal');
	}	
	public function hapus($id)
	{
		
		$where = array('id' => $id );
		$res = $this->mymodel->delete_data($where,'keu_saldo_awal_bku');
		if($res>=1){
			$this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Data Berhasil Dihapus</div>');
			echo "sukses";
		}
		else{
			$this->session->set_flashdata('msg', '<div class="alert alert-warning text-center">Gagal dihapus</div>');
			echo "gagal";
		}
		redirect('/keuangan/saldo_awal');
	}
	public function get_sipp(){	
		$this->load->model('keuangan/panjar');
		$tgl =  $this->input->post('tgl');
		$d = strtotime("1 day", strtotime("$tgl"));
		$new_date = date('Y-m-d', $d);
		$saldo_panjar_pa = $this->panjar->saldo_panjar_sebelumnya($new_date);		
		$saldo_panjar_banding = $this->panjar->saldo_panjar_banding_sebelumnya($new_date);
		$saldo_panjar_kasasi= $this->panjar->saldo_panjar_kasasi_sebelumnya($new_date);
		$saldo_panjar_pk= $this->panjar->saldo_panjar_pk_sebelumnya($new_date);
		$a= $this->panjar->saldo_panjar_eksekusi_sebelumnya($new_date);
		$b= $this->panjar->saldo_panjar_eksekusi_ht($new_date);
		$saldo_panjar_eksekusi= $a+$b;
		$spj_pa= $this->panjar->saldo_spj_pa($new_date);
		$spj_banding= $this->panjar->saldo_spj_banding($new_date);
		$spj_kasasi= $this->panjar->saldo_spj_kasasi($new_date);
		$spj_pk= $this->panjar->saldo_spj_pk($new_date);
		$spj_eksekusi= $this->panjar->saldo_spj_eksekusi($new_date);
		$sub_total = $saldo_panjar_pa+$saldo_panjar_banding+$saldo_panjar_kasasi+$saldo_panjar_pk+$saldo_panjar_eksekusi+$spj_pa+$spj_banding+$spj_kasasi+$spj_pk+$spj_eksekusi;
		
		$data['saldo_panjar_pa']= number_format($saldo_panjar_pa,0,',','.');
		$data['saldo_panjar_banding']= number_format($saldo_panjar_banding,0,',','.');
		$data['saldo_panjar_kasasi']= number_format($saldo_panjar_kasasi,0,',','.');
		$data['saldo_panjar_pk']= number_format($saldo_panjar_pk,0,',','.');
		$data['saldo_panjar_eksekusi']= number_format($saldo_panjar_eksekusi,0,',','.');		
		$data['spj_pa']= number_format($spj_pa,0,',','.');
		$data['spj_banding']= number_format($spj_banding,0,',','.');
		$data['spj_kasasi']= number_format($spj_kasasi,0,',','.');
		$data['spj_pk']=number_format($spj_pk,0,',','.');
		$data['spj_eksekusi']= number_format($spj_eksekusi,0,',','.');
		$data['sub_total']= number_format($sub_total,0,',','.');
		
		header('Content-Type: application/json');
		echo json_encode($data);
	}
	
	function myfunction($val)
	{
		$val = str_replace(',','.',str_replace('.','',$val));
		return($val);
	}	
	
	public function cek_ba(){
		$tgl =  $this->input->post('tgl');
		$where = array('tgl_finish' => $tgl );
		$ba = $this->mymodel->get_data_where($where, 'keu_laporan_rekon')->row_array();
		$data['ba'] = $ba['tgl_finish'];
		header('Content-Type: application/json');
		echo json_encode($data);
	}
	public function get_ba(){
		$tgl =  $this->input->post('tgl');
		$where = array('tgl_finish' => $tgl );
		$ba = $this->mymodel->get_data_where($where, 'keu_laporan_rekon')->row_array();
		$data['uang_tunai']= number_format($ba['uang_tunai'],0,',','.');
		$data['uang_bank']= number_format($ba['uang_bank'],0,',','.');
		$data['materai']= number_format($ba['jml_materai'],0,',','.');
		$total_materai = $ba['jml_materai']*6000;
		$data['total_materai']= number_format($total_materai,0,',','.');
		$sub_totalA = $ba['uang_tunai']+$ba['uang_bank']+$total_materai;
		$data['sub_totalA']= number_format($sub_totalA,0,',','.');
		
		$data['saldo_panjar_pa']= number_format($ba['saldo_panjar_pa'],0,',','.');
		$data['saldo_panjar_banding']= number_format($ba['saldo_panjar_banding'],0,',','.');
		$data['saldo_panjar_kasasi']= number_format($ba['saldo_panjar_kasasi'],0,',','.');
		$data['saldo_panjar_pk']= number_format($ba['saldo_panjar_pk'],0,',','.');
		$data['saldo_panjar_eksekusi']= number_format($ba['saldo_panjar_eksekusi'],0,',','.');		
		$data['spj_pa']= number_format($ba['spj_pa'],0,',','.');
		$data['spj_banding']= number_format($ba['spj_banding'],0,',','.');
		$data['spj_kasasi']= number_format($ba['spj_kasasi'],0,',','.');
		$data['spj_pk']=number_format($ba['spj_pk'],0,',','.');
		$data['spj_eksekusi']= number_format($ba['spj_eksekusi'],0,',','.');
		$sub_totalB = $ba['saldo_panjar_pa']+$ba['saldo_panjar_banding']+$ba['saldo_panjar_kasasi']+$ba['saldo_panjar_pk']+$ba['saldo_panjar_eksekusi']+$ba['spj_pa']+$ba['spj_banding']+$ba['spj_kasasi']+$ba['spj_pk']+$ba['spj_eksekusi'];
		$data['sub_totalB']= number_format($sub_totalB,0,',','.');
		
		$data['saldo_atk']= number_format($ba['saldo_atk'],0,',','.');
		$data['saldo_panggilan']= number_format($ba['saldo_panggilan'],0,',','.');
		$data['saldo_hhk']= number_format($ba['saldo_hhk'],0,',','.');
		$data['saldo_iwadl']= number_format($ba['saldo_iwadl'],0,',','.');
		$data['saldo_konsignasi']= number_format($ba['saldo_konsignasi'],0,',','.');		
		$data['saldo_eksekusi']= number_format($ba['saldo_eksekusi'],0,',','.');
		$data['saldo_delegasi']= number_format($ba['saldo_delegasi'],0,',','.');
		$data['saldo_belum_daftar']= number_format($ba['saldo_belum_daftar'],0,',','.');
		$sub_totalC = $ba['saldo_atk']+$ba['saldo_panggilan']+$ba['saldo_hhk']+$ba['saldo_panjar_pk']+$ba['saldo_iwadl']+$ba['saldo_konsignasi']+$ba['saldo_eksekusi']+$ba['saldo_delegasi']+$ba['saldo_belum_daftar'];
		$data['sub_totalC']= number_format($sub_totalC,0,',','.');
		$sub_totalBC = $sub_totalB+$sub_totalC;
		$data['sub_totalBC']= number_format($sub_totalBC,0,',','.');
		
		header('Content-Type: application/json');
		echo json_encode($data);
	}

}
