<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Monitoring extends CI_Controller {

	public function index()
	{
		show_404();
	}
	public function data_transaksi()
	{
		if(!empty($_POST)){
			$tgl_start = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_start'));
			$tgl_start = date_format($tgl_start, "Y-m-d");
			$tgl_finish = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_finish'));
			$tgl_finish = date_format($tgl_finish, "Y-m-d");
			$kategori =  $this->input->post('kategori');
			if($kategori !== '0'){
				$where = array('tanggal_transaksi >=' =>  $tgl_start, 'tanggal_transaksi <=' =>  $tgl_finish, 'kategori_id' => $kategori );
			}
			else{
				$where = array('tanggal_transaksi >=' =>  $tgl_start, 'tanggal_transaksi <=' =>  $tgl_finish );
			}
			$data['list_trans'] = $this->mymodel->get_data_where($where,'keu_v_perkara_biaya');
			$data['tgl_start'] = $this->input->post('tgl_start');
			$data['tgl_finish'] = $this->input->post('tgl_finish');
		}
		else{
			$data['list_trans'] = $this->mymodel->get_data_where(array('tanggal_transaksi >=' =>  date('Y-m-d'), 'tanggal_transaksi <=' =>  date('Y-m-d')),'keu_v_perkara_biaya');
			$data['tgl_start'] = date('d/m/Y');
			$data['tgl_finish'] = date('d/m/Y');
		}
		$data['list_kategori'] = $this->mymodel->get_data_where(array('aktif' => 'Y'),'keu_kategori_biaya_tambahan');
		$data['title'] = "Data Transaksi Penerimaan dan Pengeluaran Buku Bantu";
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/v_daftar_transaksi',$data);
		$this->load->view('keuangan/page/footer');	
		// var_dump($_POST);
	}
	public function spj_belum_putus()
	{
		$data['list_trans'] = $this->mymodel->spj_belum_putus();
		$data['title'] = "Transaksi Pengembalian Sisa Panjar Belum Putus";
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/v_spj_belum_putus',$data);
		$this->load->view('keuangan/page/footer');	
		//var_dump($data['list_trans']->row_array());
	}
	public function materai_putusan()
	{
		$data['list_trans'] = $this->mymodel->materai_putusan();
		$data['title'] = "Transaksi Materai Tidak Sama Dengan Tanggal Putusan";
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/v_materai_putusan',$data);
		$this->load->view('keuangan/page/footer');	
		//var_dump($data['list_trans']->row_array());
	}
	public function transaksi_lain2()
	{
		$data['list_trans'] = $this->mymodel->transaksi_lain2();
		$data['title'] = "Transaksi Dengan Kategori Lain-lain";
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/v_transaksi_lain2',$data);
		$this->load->view('keuangan/page/footer');	
		//var_dump($data['list_trans']->row_array());
	}
	public function hapus_data_trans($id)
	{
		
		$where = array('id' => $id );		
		$q = $this->mymodel->get_data_where(array('id' => $id),'keu_v_perkara_biaya')->row_array();
		$res = $this->mymodel->delete_data($where,'keu_perkara_biaya_tambahan');
		if($res>=1){
			$this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Data Berhasil Dihapus</div>');
			echo "sukses";
		}
		else{
			$this->session->set_flashdata('msg', '<div class="alert alert-warning text-center">Gagal dihapus</div>');
			echo "gagal";
		}		
		if($q['kategori_id'] == 100){
			redirect('/keuangan/buku_bantu/bank');
		}
		else if($q['kategori_id'] < 100){
			if($q['tahapan_id'] == 60){
				redirect('/keuangan/jurnal/konsignasi_detil/'.$q['perkara_id']);
			}
			else{
				redirect('/keuangan/buku_bantu/menu/'.$q['kategori_id']);
			}
		}
		else{
			redirect('/keuangan/monitoring/data_transaksi');
		}
	}	
	function myfunction($val)
	{
		$val = str_replace(',','.',str_replace('.','',$val));
		return($val);
	}	
	public function edit_ajax($id)
	{
		$q = $this->mymodel->get_data_where(array('id' => $id),'keu_v_perkara_biaya')->row_array();
		$data['jumlah'] = number_format($q['jumlah'],0,',','.');
		$data['uraian'] = $q['uraian'];
		$data['keterangan'] = $q['keterangan'];
		$tgl = DateTime::createFromFormat('Y-m-d', $q['tanggal_transaksi']);
		$data['tanggal_transaksi'] = date_format($tgl, "d/m/Y");
		header('Content-Type: application/json');
		echo json_encode($data);
	}	
	public function edit_trans()
	{
		$this->load->helper('form');
		$id = $this->input->post('id');	
		$q = $this->mymodel->get_data_where(array('id' => $id),'keu_v_perkara_biaya')->row_array();
		$data['jumlah'] = str_replace(".","",$this->input->post('jumlah'));	
		$data['keterangan'] = $this->input->post('keterangan');	
		$tgl = DateTime::createFromFormat('d/m/Y', $this->input->post('tanggal_transaksi'));
		$data['tanggal_transaksi'] = date_format($tgl, "Y-m-d");;
		$res = $this->mymodel->update_data(array('id' => $id ),'keu_perkara_biaya_tambahan',$data);
		if($res>=1){
			$this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Data Berhasil Di Update</div>');
			$this->session->set_flashdata('tgl', $this->input->post('tanggal_transaksi'));
			echo "sukses";
		}
		else{
			$this->session->set_flashdata('msg', '<div class="alert alert-warning text-center">Input Gagal</div>');
			echo "gagal";
		}
		//var_dump($new_row);
		if($q['kategori_id'] == 100){
			redirect('/keuangan/buku_bantu/bank');
		}
		else if($q['kategori_id'] < 100){
			if($q['tahapan_id'] == 60){
				redirect('/keuangan/jurnal/konsignasi_detil/'.$q['perkara_id']);
			}
			else{
				redirect('/keuangan/buku_bantu/menu/'.$q['kategori_id']);
			}
		}
		else{
			redirect('/keuangan/monitoring/data_transaksi');
		}
		
	}

}
