<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Menu_jsp extends CI_Controller {
	public function __construct(){
		parent::__construct();
		$this->mymodel->squrity();
	}	
	public function index($bln="",$thn="")
	{
		$this->mymodel->squrity();
		$jsp_id = $this->session->userdata('jurusita_id');
		$data['title'] = "Dasboard";
		
		$this->load->view('keuangan/page/header_jsp');
		$this->load->view('keuangan/jsp/calendar',$data);
		$this->load->view('keuangan/page/footer');	
				// echo "<pre>";
				// print_r($bln);
				// echo "</pre>";	
	}
	public function get_data_sidang($bln,$thn)
	{
		$jsp_id = $this->session->userdata('jurusita_id');
		$q = $this->mymodel->list_perkara_jsp_date($bln,$thn,$jsp_id);		
		$list = array();
		$index = 0;
		foreach ($q->result_array() as $d){
			$index++;
			$row = array();
			$row['id'] = $index;
			$row['calendarId'] = '1';
			$row['category'] = 'allday';			
			$row['title'] = $d['jumlah']." Jadwal Sidang.";
			$row['start'] = $d['tanggal_sidang'];
			$row['end'] = $d['tanggal_sidang'];
			$row['bgColor'] = '#8a47e8';
			$row['color'] = '#fff';
			$list[]=$row;
		}
		header('Content-Type: application/json');
		echo json_encode($list);
	}
	public function get_data_rencana($bln,$thn)
	{
		$jsp_id = $this->session->userdata('jurusita_id');
		$q2 = $this->mymodel->list_rencana_by_bln($bln,$thn,$jsp_id);
		$list2 = array();
		$index = 0;
		foreach ($q2->result_array() as $d){
			$index++;
			$row = array();
			$row['id'] = $index;
			$row['calendarId'] = '2';
			$row['category'] = 'allday';			
			$row['title'] = $d['qt']." Rencana Pemanggilan";
			$row['start'] = $d['tgl_rencana'];
			$row['end'] = $d['tgl_rencana'];
			$row['bgColor'] = '#0ccc1c';
			$row['color'] = '#fff';
			$list2[]=$row;
		}
		header('Content-Type: application/json');
		echo json_encode($list2);
	}
	public function detil_sidang($tgl)
	{
		// echo $tgl;
		$tgl2 = DateTime::createFromFormat('Y-m-d', $tgl);
		$tgl2 = date_format($tgl2, "d/m/Y");
		$jsp_id = $this->session->userdata('jurusita_id');
		$q = $this->mymodel->list_perkara_jsp($jsp_id,$tgl);
		$list_sidang = array();
		foreach ($q->result_array() as $h){
			$row = array();
			$row['id'] = $h['id'];
			$row['nomor_perkara'] = $h['nomor_perkara'];
			$row['tanggal_sidang'] = $h['tanggal_sidang'];
			$row['agenda'] = $h['agenda'];
			$row['para_pihak'] = $h['para_pihak'];
			$row['jurusita_text'] = $h['jurusita_text'];
			$q2 = $this->mymodel->cek_rencana($h['id'])->result_array();
			$row['status'] = "<span class='bg-secondary text-white'>Belum dijadwalkan </span>";
			if(!empty($q2)){
				$row['status'] = "";
				foreach($q2 as $h){
					$nama_jsp = $this->mymodel->nama_jsp($h['jsp_id']);
					$kode_pgl = $this->mymodel->kode_pgl($h['jns_pgl']);
					if(empty($h['tgl_pelaksanaan'])){
						$row['status'] .= "<span class='bg-primary text-white'>Terjadwal ".$kode_pgl."-".$nama_jsp."</span> &nbsp;";
					}
					else{
						$row['status'] .= "<span class='bg-success text-white'> Terlaksana ".$kode_pgl."-".$nama_jsp."</span> &nbsp;";
					}
				}
			}
			// $row['tgl_rencana'] = $q2['tgl_rencana'];
			// $row['id_rencana'] = $q2['id_rencana'];
			$list_sidang[] = $row;
		}
		$data['list_sidang'] = $list_sidang;
		$data['title'] = "List Jadwal Sidang Tanggal ".$tgl2;
		$this->load->view('keuangan/page/header_jsp');
		$this->load->view('keuangan/jsp/daftar_sidang',$data);
		$this->load->view('keuangan/page/footer');	
		// echo "<pre>";
				// print_r($data);
				// echo "</pre>";
	}
	public function test()
	{
		$jsp_id = $this->session->userdata('jurusita_id');
		$q = $this->mymodel->list_perkara_jsp_date('1','2018',$jsp_id);
		$list = array();
		$index = 0;
		foreach ($q->result_array() as $d){
			$index++;
			$row = array();
			$row['id'] = $index;
			$row['calendar_id'] = '1';
			$row['category'] = 'allday';
			$row['title'] = "<a href='".base_url()."menu_jsp/detil_sidang/".$d['tanggal_sidang']."'>".$d['jumlah']." Jadwal Sidang </a>";
			$row['start'] = $d['tanggal_sidang'];
			$row['end'] = $d['tanggal_sidang'];
			$row['bgColor'] = 'red';
			$row['bgColor'] = '#fff';
			$list[]=$row;
		}
		header('Content-Type: application/json');
		echo json_encode($list);
	}
	public function tambah_rencana($id_sidang)
	{
		$jsp_id = $this->session->userdata('jurusita_id');
		$q = $this->mymodel->cek_id_sidang($id_sidang)->row_array();
		$data['perkara_id']= $perk_id = $q['perkara_id'];
		$data['no_perkara']=$q['nomor_perkara'];
		$data['id_sidang']=$id_sidang;
		$now = new DateTime();
		$tgl_sidang = new DateTime($q['tanggal_sidang']);
		$diff = $now->diff($tgl_sidang);
		$data['lama'] = $diff->days." hari";
		$data['tanggal_sidang']=date("d/m/Y", strtotime($q['tanggal_sidang']));
		$data['para_pihak']=$q['para_pihak'];		
		$data['saldo_keuangan'] = $this->mymodel->saldo_per_perkara($perk_id);
		
		$data['biaya_pgl'] =  $this->mymodel->biaya_pgl($perk_id);
		$data['jenis_pgl'] =  $this->mymodel->jenis_pgl();
		$data['radius'] =  $this->mymodel->get_data('keu_master_radius');
		$data['pihak_id'] =  $this->mymodel->pihak_id($perk_id);
		$q2 = $this->mymodel->cek_data_perkara($data['perkara_id'])->row_array();
				// echo "<pre>";
				// print_r($data);
				// echo "</pre>";	
		$data['title'] = "Tambah Rencana Pemanggilan";
		$this->load->view('keuangan/page/header_jsp');
		$this->load->view('keuangan/jsp/tambah_rencana',$data);
		$this->load->view('keuangan/page/footer');	
	}
	
	public function simpan_rencana()
	{
		$jsp_id = $this->session->userdata('jurusita_id');
		$data['biaya_panggilan'] = str_replace(".","",$this->input->post('biaya_pgl'));			
		$tgl_rencana = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_rencana'));
		$data['tgl_rencana'] = date_format($tgl_rencana, "Y-m-d");			
		$data['keterangan'] = $this->input->post('keterangan');	
		$data['jns_pgl'] = $this->input->post('jns_pgl');	
		$data['jsp_id'] = $jsp_id;	
		$data['sidang_id'] = $this->input->post('id_sidang');	
		$data['pihak_id'] = $this->input->post('pihak_id');	
		$data['diinput_tanggal'] = date("Y-m-d");	
		$res = $this->mymodel->insert_data('keu_rencana_pemanggilan',$data);
		if($res>=1){
			$this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Data Berhasil Disimpan</div>');
			echo "sukses";
		}
		else{
			$this->session->set_flashdata('msg', '<div class="alert alert-warning text-center">Input Gagal</div>');
			echo "gagal";
		}
		//var_dump($data);	
		redirect('/keuangan/menu_jsp/list_rencana_detil/'.$data['tgl_rencana']);
				// echo "<pre>";
				// print_r($data);
				// echo "</pre>";	
	}
	
	public function list_rencana()
	{
		$jsp_id = $this->session->userdata('jurusita_id');
		$data['list_rencana'] = $this->mymodel->list_rencana($jsp_id);
		$data['title'] = "Daftar Rencana Pemanggilan";
		$this->load->view('keuangan/page/header_jsp');
		$this->load->view('keuangan/jsp/list_rencana',$data);
		$this->load->view('keuangan/page/footer');	
	}
	public function master_radius()
	{
		$jsp_id = $this->session->userdata('jurusita_id');
		$data['list_radius'] = $this->mymodel->get_data('keu_master_radius');
		$data['title'] = "Master Radius Panggilan";
		$this->load->view('keuangan/page/header_jsp');
		$this->load->view('keuangan/jsp/master_radius',$data);
		$this->load->view('keuangan/page/footer');	
	}
	public function simpan_radius(){
		$data['nilai'] = str_replace(".","",$this->input->post('nilai'));	
		$data['nama'] = $this->input->post('nama');	
		$data['keterangan'] = $this->input->post('keterangan');	
			$res = $this->mymodel->insert_data('keu_master_radius',$data);
			if($res){
				$this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Data Berhasil Di simpan</div>');
			}
			else{
				$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Data Gagal Di simpan</div>');
			}
		redirect('/keuangan/menu_jsp/master_radius');
	}
	public function edit_radius(){
		$data['nilai'] = str_replace(".","",$this->input->post('nilai'));	
		$data['nama'] = $this->input->post('nama');	
		$data['keterangan'] = $this->input->post('keterangan');	
		$where = array('id' => $this->input->post('id_radius'));
			$res = $this->mymodel->update_data($where,'keu_master_radius',$data);
			if($res){
				$this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Data Berhasil Di simpan</div>');
			}
			else{
				$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Data Gagal Di simpan</div>');
			}
		redirect('/keuangan/menu_jsp/master_radius');
	}
	public function input_pelaksanaan(){
		$tgl_pelaksanaan = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_pelaksanaan'));
		$data['tgl_pelaksanaan'] = date_format($tgl_pelaksanaan, "Y-m-d");
		$data['ket_temu'] = $this->input->post('ket_temu');	
		$data['ket_pelaksanaan'] = $this->input->post('ket_pelaksanaan');		
		$where = array('id' => $this->input->post('id_rencana'));
			$res = $this->mymodel->update_data($where,'keu_rencana_pemanggilan',$data);
			if($res){
				$this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Data Berhasil Di Update</div>');
			}
			else{
				$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Data Gagal Di Update</div>');
			}
		redirect('/keuangan/menu_jsp/list_rencana_detil/'.$data['tgl_pelaksanaan']);
	}
	public function hapus_radius($id){
		$where = array('id' => $id);
			$res = $this->db->delete('keu_master_radius',$where);
			if($res){
				$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Data Berhasil Di hapus</div>');
			}
			else{
				$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Data Gagal Di hapus</div>');
			}
		redirect('/keuangan/menu_jsp/master_radius');
	}
	public function list_rencana_detil($tgl)
	{
		$jsp_id = $this->session->userdata('jurusita_id');
		$q = $this->mymodel->list_rencana_detil($jsp_id,$tgl)->result_array();
		$tgl2 = DateTime::createFromFormat('Y-m-d', $tgl);
		$tgl2 = date_format($tgl2, "d/m/Y");
		$data['title'] = "Daftar Rencana Pemanggilan Tanggal ".$tgl2;
		$list_rencana = array();
		$data['jml_rencana'] = count($q);
		$jml_terlaksana = 0;
		$jml_diajukan = 0;
		$jml_dibayar = 0;
		foreach ($q as $h){
			$row = array();
			$row['id'] = $h['id'];
			$row['id_sidang'] = $id_sidang = $h['sidang_id'];
			$q2 = $this->mymodel->cek_id_sidang($id_sidang)->row_array();
			$row['no_perkara'] = $q2['nomor_perkara'];
			$row['tgl_rencana'] = $h['tgl_rencana'];
			$row['kode_pgl'] = $this->mymodel->kode_pgl($h['jns_pgl']);
			$row['tanggal_sidang'] = $q2['tanggal_sidang'];
			$row['tgl_pelaksanaan'] = $h['tgl_pelaksanaan'];
			if(!empty($h['tgl_pelaksanaan'])){
				$jml_terlaksana++;
			}
			$row['biaya_panggilan'] = $h['biaya_panggilan'];
			$row['keterangan'] = $h['keterangan'];
			
			$st_pembayaran = $this->mymodel->cek_st_pembayaran($h['id']);
			if($st_pembayaran == 0)
			{
				$row['st_pembayaran'] = "<span class='bg-warning text-white'> Belum diminta </span>";
			}
			else if($st_pembayaran == 1){
				$row['st_pembayaran'] = "<span class='bg-primary text-white'> Sudah diminta </span>";
				$jml_diajukan++;
			}
			else if($st_pembayaran == 2){
				$row['st_pembayaran'] = "<span class='bg-success text-white'> Sudah dibayar </span>";
				$jml_diajukan++;
				$jml_dibayar++;
			}
		
			
			$list_rencana[] = $row;
		}
		
		$data['list_rencana'] = $list_rencana;
		$data['tgl'] = $tgl;
		$data['jml_terlaksana'] = $jml_terlaksana;
		$data['jml_diajukan'] = $jml_diajukan;
		$data['jml_dibayar'] = $jml_dibayar;
		$this->load->view('keuangan/page/header_jsp');
		$this->load->view('keuangan/jsp/list_rencana_detil',$data);
		$this->load->view('keuangan/page/footer');	
		
		// echo "<pre>";
				// print_r($data);
				// echo "</pre>";	
	}
	public function request_uang($tgl)
	{
		$jsp_id = $this->session->userdata('jurusita_id');
		$jsp_nama = $this->session->userdata('fullname');
		$q = $this->mymodel->list_rencana_detil($jsp_id,$tgl);
		$tgl2 = DateTime::createFromFormat('Y-m-d', $tgl);
		$tgl2 = date_format($tgl2, "d/m/Y");
		$sys = $this->mymodel->sys_config();
		$data['NamaPN'] = $sys['NamaPN'];
		$data['title'] = "Daftar Permintaan Biaya Panggilan <br> ".ucwords(strtolower($data['NamaPN']));
		$list_permintaan = array();
		$total = 0;
		$data['st1'] = 0;
		foreach ($q->result_array() as $h){
			$row = array();
			$st_pembayaran = $this->mymodel->cek_st_pembayaran($h['id']);
			if($st_pembayaran !== '2'){
				$data['st1'] = 1;
				$row['id'] = $h['id'];
				$row['id_sidang'] = $id_sidang = $h['sidang_id'];
				$row['tgl_permintaan'] = $tgl2;
				$q2 = $this->mymodel->cek_id_sidang($id_sidang)->row_array();
				$row['no_perkara'] = $q2['nomor_perkara'];
				$row['pihak_nama'] =  $this->mymodel->pihak_nama($h['pihak_id']);
				$row['tgl_rencana'] = $tgl2;
				$tanggal_sidang = DateTime::createFromFormat('Y-m-d', $q2['tanggal_sidang']);
				$tanggal_sidang = date_format($tanggal_sidang, "d/m/Y");
				$row['tanggal_sidang'] = $tanggal_sidang;
				
				if(!empty($h['tgl_pelaksanaan'])){
					$tgl_pelaksanaan = DateTime::createFromFormat('Y-m-d', $h['tgl_pelaksanaan']);
					$tgl_pelaksanaan = date_format($tgl_pelaksanaan, "d/m/Y");
					$row['tgl_pelaksanaan'] = $tgl_pelaksanaan;
				}
				else{
					$row['tgl_pelaksanaan'] = "-";
				}
				
				$row['kode_pgl'] = $this->mymodel->kode_pgl($h['jns_pgl']);					
				$row['biaya_panggilan'] = "Rp. ".number_format($h['biaya_panggilan'],0,',','.');
				$row['keterangan'] = $h['keterangan'];
				
				$total += $h['biaya_panggilan'];
				$new_row = array('status_pembayaran' => '1' );
				$where = array('id' => $row['id'], 'jsp_id' => $jsp_id);
				$this->mymodel->update_data($where,'keu_rencana_pemanggilan',$new_row);
				
				$list_permintaan[] = $row;
			}
			
		}
		$sys2 = $this->mymodel->sys_config2();
		$data['kota'] = $sys2['kota'];
		$data['nm_kasir'] = $sys2['nm_kasir'];
		$data['nip_kasir'] = $sys2['nip_kasir'];
		$data['list_permintaan'] = $list_permintaan;
		$data['total_biaya'] = "Rp. ".number_format($total,0,',','.');
		$data['terbilang'] = ucwords($this->terbilang($total))." Rupiah";
		$data['jsp_nama'] = $jsp_nama;
		$data['tgl_ttd'] = $this->tgl_ttd(date("Y-m-d"));
		$this->load->view('keuangan/page/header_jsp');
		$this->load->view('keuangan/jsp/request_biaya',$data);
		$this->load->view('keuangan/page/footer');	
		
		// echo "<pre>";
				// print_r($data);
				// echo "</pre>";	
	}
	
	public function hapus_rencana($id)
	{
		$where = array ('id' => $id);
		$data['status'] = 0;
			$res = $this->db->delete('keu_rencana_pemanggilan', $where);
			if($res){
				$this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Data Berhasil Di Hapus</div>');
				$data['status'] = 1;
			}
			else{
				$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Data Gagal Di Hapus</div>');
				$data['status'] = 2;
			}
		header('Content-Type: application/json');
		echo json_encode($data);
	}
	
	function penyebut($nilai) {
		$nilai = abs($nilai);
		$huruf = array("", "satu", "dua", "tiga", "empat", "lima", "enam", "tujuh", "delapan", "sembilan", "sepuluh", "sebelas");
		$temp = "";
		if ($nilai < 12) {
			$temp = " ". $huruf[$nilai];
		} else if ($nilai <20) {
			$temp = $this->penyebut($nilai - 10). " belas";
		} else if ($nilai < 100) {
			$temp = $this->penyebut($nilai/10)." puluh". $this->penyebut($nilai % 10);
		} else if ($nilai < 200) {
			$temp = " seratus" . $this->penyebut($nilai - 100);
		} else if ($nilai < 1000) {
			$temp = $this->penyebut($nilai/100) . " ratus" . $this->penyebut($nilai % 100);
		} else if ($nilai < 2000) {
			$temp = " seribu" . $this->penyebut($nilai - 1000);
		} else if ($nilai < 1000000) {
			$temp = $this->penyebut($nilai/1000) . " ribu" . $this->penyebut($nilai % 1000);
		} else if ($nilai < 1000000000) {
			$temp = $this->penyebut($nilai/1000000) . " juta" . $this->penyebut($nilai % 1000000);
		} else if ($nilai < 1000000000000) {
			$temp = $this->penyebut($nilai/1000000000) . " milyar" . $this->penyebut(fmod($nilai,1000000000));
		} else if ($nilai < 1000000000000000) {
			$temp = $this->penyebut($nilai/1000000000000) . " trilyun" . $this->penyebut(fmod($nilai,1000000000000));
		}     
		return $temp;
	}
 
	function terbilang($nilai) {
		if($nilai<0) {
			$hasil = "minus ". trim($this->penyebut($nilai));
		} else {
			$hasil = trim($this->penyebut($nilai));
		}     		
		return $hasil;
	}

	function tgl_ttd($tgl_finish)
	{
		$array_bulan = array(1=>'Januari','Februari','Maret','April','Mei','Juni','Juli','Agustus','September','Oktober','Novemer','Desember');
		$bulan = $array_bulan[date('n', strtotime($tgl_finish))];

		$tgl = date('j', strtotime($tgl_finish));
		$thn = date('Y', strtotime($tgl_finish));

		$tgl_indonesia = $tgl." ".$bulan." ".$thn;
		return $tgl_indonesia;
	}
}
