<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Jurnal extends CI_Controller {
	public function _construct(){
		parent::_construct();
		$this->mymodel->squrity();
	}
	public function index()
	{
		show_404();
	}
	public function gugatan()
	{
		$this->load->model('keuangan/jurnal_model');
		$tahun = date("Y");
		$saldo = '0';
		$temp =  $this->input->post('tahun');
		if(isset($temp)){
			$tahun = $this->input->post('tahun');
			$saldo = $this->input->post('saldo');
		}
		$data['list_jurnal'] = $this->jurnal_model->gugatan($tahun,$saldo);
		$data['title'] = "Jurnal Keuangan Perkara Gugatan";
		$data['tahun'] = $tahun;
		$data['saldo'] = $saldo;
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/jurnal/v_gugatan',$data);
		$this->load->view('keuangan/page/footer');	
			// echo "<pre>";
				// print_r($data);
				// echo "</pre>";
			// var_dump($_POST);
	}
	public function permohonan()
	{
		$this->load->model('keuangan/jurnal_model');
		$tahun = date("Y");
		$saldo = '0';
		$temp =  $this->input->post('tahun');
		if(isset($temp)){
			$tahun = $this->input->post('tahun');
			$saldo = $this->input->post('saldo');
		}
		$data['list_jurnal'] = $this->jurnal_model->permohonan($tahun,$saldo);
		$data['title'] = "Jurnal Keuangan Perkara Permohonan";
		$data['tahun'] = $tahun;
		$data['saldo'] = $saldo;
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/jurnal/v_gugatan',$data);
		$this->load->view('keuangan/page/footer');	

	}
	public function gugatan_sederhana()
	{
		$this->load->model('keuangan/jurnal_model');
		$tahun = date("Y");
		$saldo = '0';
		$temp =  $this->input->post('tahun');
		if(isset($temp)){
			$tahun = $this->input->post('tahun');
			$saldo = $this->input->post('saldo');
		}
		$data['list_jurnal'] = $this->jurnal_model->gugatan_sederhana($tahun,$saldo);
		$data['title'] = "Jurnal Keuangan Perkara Gugatan Sederhana";
		$data['tahun'] = $tahun;
		$data['saldo'] = $saldo;
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/jurnal/v_gugatan',$data);
		$this->load->view('keuangan/page/footer');	

	}
	public function banding()
	{
		$this->load->model('keuangan/jurnal_model');
		$tahun = '0';
		$saldo = '0';
		$temp =  $this->input->post('tahun');
		if(isset($temp)){
			$tahun = $this->input->post('tahun');
			$saldo = $this->input->post('saldo');
		}
		$data['list_jurnal'] = $this->jurnal_model->banding($tahun,$saldo,'20');
		$data['title'] = "Jurnal Keuangan Perkara Permohonan Banding";
		$data['tahun'] = $tahun;
		$data['saldo'] = $saldo;
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/jurnal/v_banding',$data);
		$this->load->view('keuangan/page/footer');	

	}
	public function kasasi()
	{
		$this->load->model('keuangan/jurnal_model');
		$tahun = '0';
		$saldo = '0';
		$temp =  $this->input->post('tahun');
		if(isset($temp)){
			$tahun = $this->input->post('tahun');
			$saldo = $this->input->post('saldo');
		}
		$data['list_jurnal'] = $this->jurnal_model->kasasi($tahun,$saldo,'30');
		$data['title'] = "Jurnal Keuangan Perkara Permohonan Kasasi";
		$data['tahun'] = $tahun;
		$data['saldo'] = $saldo;
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/jurnal/v_kasasi',$data);
		$this->load->view('keuangan/page/footer');	

	}
	public function pk()
	{
		$this->load->model('keuangan/jurnal_model');
		$tahun = '0';
		$saldo = '0';
		$temp =  $this->input->post('tahun');
		if(isset($temp)){
			$tahun = $this->input->post('tahun');
			$saldo = $this->input->post('saldo');
		}
		$data['list_jurnal'] = $this->jurnal_model->pk($tahun,$saldo,'40');
		$data['title'] = "Jurnal Keuangan Perkara Permohonan Peninjauan Kembali";
		$data['tahun'] = $tahun;
		$data['saldo'] = $saldo;
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/jurnal/v_pk',$data);
		$this->load->view('keuangan/page/footer');	

	}
	public function eksekusi()
	{
		$this->load->model('keuangan/jurnal_model');
		$tahun = '0';
		$saldo = '0';
		$temp =  $this->input->post('tahun');
		if(isset($temp)){
			$tahun = $this->input->post('tahun');
			$saldo = $this->input->post('saldo');
		}
		$data['list_jurnal'] = $this->jurnal_model->eksekusi($tahun,$saldo,'50');
		$data['title'] = "Jurnal Keuangan Perkara Permohonan Eksekusi";
		$data['tahun'] = $tahun;
		$data['saldo'] = $saldo;
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/jurnal/v_eksekusi',$data);
		$this->load->view('keuangan/page/footer');	

	}
	public function eksekusi_ht()
	{
		$this->load->model('keuangan/jurnal_model');
		$tahun = '0';
		$saldo = '0';
		$temp =  $this->input->post('tahun');
		if(isset($temp)){
			$tahun = $this->input->post('tahun');
			$saldo = $this->input->post('saldo');
		}
		$data['list_jurnal'] = $this->jurnal_model->eksekusi_ht($tahun,$saldo,'50');
		$data['title'] = "Jurnal Keuangan Perkara Permohonan Eksekusi";
		$data['tahun'] = $tahun;
		$data['saldo'] = $saldo;
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/jurnal/v_eksekusi_ht',$data);
		$this->load->view('keuangan/page/footer');	

	}
	public function konsignasi()
	{
		$this->load->model('keuangan/jurnal_model');
		$tahun = date("Y");
		$saldo = '0';
		$temp =  $this->input->post('tahun');
		if(isset($temp)){
			$tahun = $this->input->post('tahun');
			$saldo = $this->input->post('saldo');
		}
		$data['list_jurnal'] = $this->jurnal_model->konsignasi($tahun,$saldo,'60');
		$data['title'] = "Jurnal Keuangan Perkara Permohonan Konsignasi";
		$data['tahun'] = $tahun;
		$data['saldo'] = $saldo;
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/jurnal/v_konsignasi',$data);
		$this->load->view('keuangan/page/footer');	

	}
	public function gugatan_detil($perkara_id)
	{
		$this->load->model('keuangan/jurnal_model');
		$data['identitas'] = $this->jurnal_model->identitas($perkara_id)->row_array();
		$data['list_detil'] = $this->jurnal_model->gugatan_detil($perkara_id);
		$data['title'] = "Buku Jurnal Keuangan Tingkat Pertama";
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/jurnal/v_gugatan_detil',$data);
		$this->load->view('keuangan/page/footer');	
			// echo "<pre>";
				// print_r($data);
				// echo "</pre>";
			// var_dump($_POST);
	}
	public function banding_detil($perkara_id)
	{
		$this->load->model('keuangan/jurnal_model');
		$data['identitas'] = $this->jurnal_model->identitas($perkara_id)->row_array();
		$data['list_detil'] = $this->jurnal_model->banding_detil($perkara_id,'20');
		$data['title'] = "Buku Jurnal Keuangan Tingkat Banding";
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/jurnal/v_gugatan_detil',$data);
		$this->load->view('keuangan/page/footer');	
			// echo "<pre>";
				// print_r($data);
				// echo "</pre>";
			// var_dump($_POST);
	}
	public function kasasi_detil($perkara_id)
	{
		$this->load->model('keuangan/jurnal_model');
		$data['identitas'] = $this->jurnal_model->identitas($perkara_id)->row_array();
		$data['list_detil'] = $this->jurnal_model->banding_detil($perkara_id,'30');
		$data['title'] = "Buku Jurnal Keuangan Tingkat Kasasi";
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/jurnal/v_gugatan_detil',$data);
		$this->load->view('keuangan/page/footer');	
			// echo "<pre>";
				// print_r($data);
				// echo "</pre>";
			// var_dump($_POST);
	}
	public function pk_detil($perkara_id)
	{
		$this->load->model('keuangan/jurnal_model');
		$data['identitas'] = $this->jurnal_model->identitas($perkara_id)->row_array();
		$data['list_detil'] = $this->jurnal_model->banding_detil($perkara_id,'40');
		$data['title'] = "Buku Jurnal Keuangan Tingkat Peninjauan Kembali";
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/jurnal/v_gugatan_detil',$data);
		$this->load->view('keuangan/page/footer');	
			// echo "<pre>";
				// print_r($data);
				// echo "</pre>";
			// var_dump($_POST);
	}

	public function eksekusi_detil($perkara_id)
	{
		$this->load->model('keuangan/jurnal_model');
		$data['identitas'] = $this->jurnal_model->identitas_eks($perkara_id)->row_array();
		$data['list_detil'] = $this->jurnal_model->banding_detil($perkara_id,'50');
		$data['title'] = "Buku Jurnal Keuangan Tingkat Eksekusi";
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/jurnal/v_eksekusi_detil',$data);
		$this->load->view('keuangan/page/footer');	
			// echo "<pre>";
				// print_r($data);
				// echo "</pre>";
			// var_dump($_POST);
	}
	public function eksekusi_ht_detil($ht_id)
	{
		$this->load->model('keuangan/jurnal_model');
		$data['nomor_eks'] = $this->jurnal_model->nomor_eks_ht($ht_id);
		$data['pemohon'] = $this->jurnal_model->pemohon_eks_ht($ht_id);
		$data['list_detil'] = $this->jurnal_model->eksekusi_ht_detil($ht_id);
		$data['title'] = "Buku Jurnal Keuangan Tingkat Eksekusi Hak Tanggungan";
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/jurnal/v_eksekusi_ht_detil',$data);
		$this->load->view('keuangan/page/footer');	
			// echo "<pre>";
				// print_r($data);
				// echo "</pre>";
			// var_dump($_POST);
	}
	public function konsignasi_detil($perkara_id)
	{
		$this->load->model('keuangan/jurnal_model');
		$data['perkara_id'] = $perkara_id;
		$data['identitas'] = $this->jurnal_model->identitas2($perkara_id)->row_array();
		$data['list_detil'] = $this->jurnal_model->konsignasi_detil($perkara_id,'60');
		$data['title'] = "Buku Jurnal Keuangan Permohonan Konsignasi";
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/jurnal/v_konsignasi_detil',$data);
		$this->load->view('keuangan/page/footer');	
			// echo "<pre>";
				// print_r($data);
				// echo "</pre>";
			// var_dump($_POST);
	}
	
	public function tambah_konsignasi()
	{
		$this->load->model('keuangan/jurnal_model');
		$data['list_kategori'] = $this->mymodel->list_kategori_bku();
		$data['no_next'] = $this->jurnal_model->no_next();
		$data['title'] = "Tambah Permohonan Konsignasi";
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/jurnal/v_tambah_konsignasi',$data);
		$this->load->view('keuangan/page/footer');	
		//var_dump($data['list_trans']->row_array());
	}
	public function simpan_konsignasi_baru()
	{
			
		var_dump($_POST);
		$tgl = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_pendaftaran'));
		$data['tanggal_pendaftaran'] = date_format($tgl, "Y-m-d");	
		$nomor = $this->input->post('no_perk');
		$pdt = $this->input->post('pdt');
		$thn = $this->input->post('thn');
		$pemohon = $this->input->post('pemohon');
		$termohon = $this->input->post('termohon');
		$sys = $this->mymodel->sys_config();
		$kdPN = $sys['KodePN'];
		$no_perk = $nomor."/".$pdt."/".$thn."/".$kdPN;
		$data['nomor_perkara'] = $no_perk;
		$data['nomor_urut_perkara'] = $nomor;
		$data['tahun_perkara'] = $thn;
		$data['para_pihak'] = "Pemohon : " .$pemohon. "</br> Termohon :".$termohon ;
		$data['keterangan'] = $this->input->post('keterangan');	
		$res = $this->mymodel->insert_data('keu_perkara_masuk',$data);
		$insert_id = '';
		if($res>=1){
			$this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Data Berhasil Disimpan</div>');
			$this->session->set_flashdata('tgl_start',$this->input->post('tgl_pendaftaran'));
			$this->session->set_flashdata('tgl_finish', $this->input->post('tgl_pendaftaran'));
			$insert_id = $this->db->insert_id();
			echo "sukses </br>";
			echo $insert_id;
			$panjar = array(	'jumlah' => str_replace(".","",$this->input->post('panjar')), 
							'tanggal_transaksi' => $data['tanggal_pendaftaran'],
							'kategori_id' => '1',
							'jenis_biaya_id' => '1',
							'jenis_transaksi' => '1',
							'tahapan_id' => '60',
							'uraian' => 'Panjar Permohonan Konsignasi',
							'diinput_tanggal' => date("Y-m-d"),
							'perkara_id' => $insert_id
						
						);
			$pendaftaran = array(	'jumlah' => str_replace(".","",$this->input->post('pendaftaran')), 
							'tanggal_transaksi' => $data['tanggal_pendaftaran'],
							'kategori_id' => '11',
							'jenis_biaya_id' => '61',
							'jenis_transaksi' => '-1',
							'tahapan_id' => '60',
							'uraian' => 'Biaya Pendaftaran/PNBP',
							'diinput_tanggal' => date("Y-m-d"),
							'perkara_id' => $insert_id
						
						);
			$atk = array(	'jumlah' => str_replace(".","",$this->input->post('atk')), 
							'tanggal_transaksi' => $data['tanggal_pendaftaran'],
							'kategori_id' => '12',
							'jenis_biaya_id' => '155',
							'jenis_transaksi' => '-1',
							'tahapan_id' => '60',
							'uraian' => 'Biaya Pemberkasan/ATK',
							'diinput_tanggal' => date("Y-m-d"),
							'perkara_id' => $insert_id
						
						);
				
			$this->mymodel->insert_data('keu_perkara_biaya_tambahan',$panjar);
			$this->mymodel->insert_data('keu_perkara_biaya_tambahan',$pendaftaran);
			$this->mymodel->insert_data('keu_perkara_biaya_tambahan',$atk);
		}
		else{
			$this->session->set_flashdata('msg', '<div class="alert alert-warning text-center">Input Gagal</div>');
			echo "gagal";
		}
		
		
		redirect('/keuangan/jurnal/konsignasi');
	}
	
	public function tambah_trans_konsignasi($perkara_id)
	{
		$data['list_kategori'] = $this->mymodel->list_kategori_bku();
		$data['data_perkara'] = $this->mymodel->get_data_where(array('perkara_id' => $perkara_id),'keu_perkara_masuk')->row_array();
		$data['title'] = "Tambah Transaksi Permohonan Konsignasi";
		$data['perkara_id'] = $perkara_id;
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/jurnal/v_tambah_trans_konsignasi',$data);
		$this->load->view('keuangan/page/footer');	
		// var_dump($q);
	}
	public function simpan_trans_konsignasi()
	{
		$tgl = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_trans'));
		$tgl = date_format($tgl, "Y-m-d");
		$data2['jumlah'] = str_replace(".","",$this->input->post('jumlah'));	
		$data2['tanggal_transaksi'] = $tgl;		
		$jn =explode("%",$this->input->post('jenis_id'));
		$data2['jenis_biaya_id'] = $jn[0];
		$data2['uraian'] = $jn[1];
		$data2['jenis_transaksi'] = $jn[2];
		$data2['kategori_id'] = $jn[3];
		$data2['tahapan_id'] = '60';		
		$data2['keterangan'] = $this->input->post('keterangan');	
		$data2['diinput_tanggal'] = date("Y-m-d");	
		$data2['perkara_id'] = $this->input->post('perkara_id');	
		$res2 = $this->mymodel->insert_data('keu_perkara_biaya_tambahan',$data2);
		if($res2>=1){
			$this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Data Berhasil Disimpan</div>');
			$insert_id = $this->db->insert_id();
			echo "sukses </br>";
			echo $insert_id;
		}
		else{
			$this->session->set_flashdata('msg', '<div class="alert alert-warning text-center">Input Gagal</div>');
			echo "gagal";
		}
		redirect('/keuangan/jurnal/konsignasi_detil/'.$data2['perkara_id']);
	}
	public function hapus_perkara($id)
	{
		
		$where = array('perkara_id' => $id );		
		$q = $this->mymodel->get_data_where(array('id' => $id),'keu_v_perkara_biaya')->row_array();
		$res = $this->mymodel->delete_data($where,'keu_perkara_masuk');
		$res2 = $this->mymodel->delete_data($where,'keu_perkara_biaya_tambahan');
		if($res>=1){
			$this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Data Berhasil Dihapus</div>');
			echo "sukses";
		}
		else{
			$this->session->set_flashdata('msg', '<div class="alert alert-warning text-center">Gagal dihapus</div>');
			echo "gagal";
		}
		redirect('/keuangan/jurnal/konsignasi');
		
	}
}
