<?php
defined('BASEPATH') OR exit('No direct script access allowed');
ini_set('max_execution_time', 0); 
ini_set('memory_limit','2048M');
class Buku_bantu extends CI_Controller {
	
	public function __construct(){
		parent::__construct();
		$this->mymodel->squrity();
	}
	public function index()
	{
		$this->mymodel->squrity();
		redirect('/keuangan/bku');
		
	}	
	
	public function buku_bantu_ajax(){
		$sys = $this->mymodel->sys_config();
		$data['NamaPN'] = $sys['NamaPN'];
		$tgl_start = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_start'));
		$tgl_start = date_format($tgl_start, "Y-m-d");
		$tgl_finish = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_finish'));
		$tgl_finish = date_format($tgl_finish, "Y-m-d");
		$kategori =  $this->input->post('kategori');
		$saldo_awal_bku ='';
		$saldo = $this->mymodel->saldo_awal_bku($tgl_start)->row_array();
		switch($kategori){
			case 1: $data['title']="BUKU BANTU PANJAR PERKARA";break;
			
			case 2: $data['title']="PENGEMBALIAN SISA PANJAR";
					break;
			case 4: $data['title']="BUKU BANTU PANGGILAN DAN PEMBERITAHUAN";
					$saldo_awal_bku = $saldo['saldo_awal_uang_panggilan'];
					break;
			case 12: $data['title']="BUKU BANTU ALAT TULIS KANTOR";
					$saldo_awal_bku = $saldo['saldo_awal_atk'];
					break;
			case 13: $data['title']="BUKU BANTU HAK HAK KEPANITERAAN";
					$saldo_awal_bku = $saldo['saldo_awal_hhk_pnbp'];
					break;
			case 51: $data['title']="BUKU BANTU UANG IWADL";
					$saldo_awal_bku = $saldo['saldo_awal_iwadl'];
					break;
			case 52: $data['title']="BUKU BANTU UANG KONSIGNASI";
					$saldo_awal_bku = $saldo['saldo_awal_uang_konsignasi'];
					break;
			case 53: $data['title']="BUKU BANTU UANG EKSEKUSI";
					$saldo_awal_bku = $saldo['saldo_awal_uang_eksekusi'];
					break;
			case 54: $data['title']="BUKU BANTU UANG DELEGASI";
					$saldo_awal_bku = $saldo['saldo_awal_delegasi'];
					break;
			case 55: $data['title']="BUKU BANTU UANG BELUM DAFTAR";
					$saldo_awal_bku = $saldo['saldo_awal_perkara_belum_daftar'];
					break;
		}		
		$data['tgl_start'] = $tgl_start;
		$data['tgl_finish'] = $tgl_finish;
		$tgl_awal_saldo=$saldo['saldo_awal_tanggal'];
		
		//var_dump($saldo_awal);
		
		if($kategori == 1){
			$a = $this->mymodel->trans_panjar_debet($tgl_start,$tgl_finish);
			$b = $this->mymodel->trans_panjar_kredit($tgl_start,$tgl_finish);
			$c = $this->mymodel->trans_panjar_kredit2($tgl_start,$tgl_finish);
			$q = array_merge($a->result_array(),$b->result_array(),$c->result_array());
			usort($q, function ($a, $b){
				$t1 = strtotime($a['tanggal_transaksi']);
				$t2 = strtotime($b['tanggal_transaksi']);
				$retfal = $t1 - $t2;
				if($t1 == $t2){
					$retfal = $b['jenis_transaksi'] - $a['jenis_transaksi'];
				};
				return $retfal;});
			$data['list_transaksi'] = $q;	
			//echo "<pre>";
			//print_r($b);
			//echo "</pre>";
			$saldo = $this->mymodel->saldo_buku_panjar_sebelumnya($tgl_start);
			$data['saldo_awal'] = $saldo;
		
			$this->load->view('keuangan/template/buku_bantu_coba',$data);
		}
		else if($kategori == 2){
			$a = $this->mymodel->trans_sisa_panjar_debet($tgl_start,$tgl_finish);
			$c = $this->mymodel->trans_sisa_panjar_debet2($tgl_start,$tgl_finish);
			$b = $this->mymodel->trans_sisa_panjar_kredit($tgl_start,$tgl_finish);
			$q = array_merge($a->result_array(),$b->result_array(),$c->result_array());
			usort($q, function ($a, $b){
				$t1 = strtotime($a['tanggal_transaksi']);
				$t2 = strtotime($b['tanggal_transaksi']);
				$retfal = $t1 - $t2;
				if($t1 == $t2){
					$retfal = $b['jenis_transaksi'] - $a['jenis_transaksi'];
				};
				return $retfal;});
			$data['list_transaksi'] = $q;	
			//echo "<pre>";
			//print_r($b);
			//echo "</pre>";
			$saldo = $this->mymodel->saldo_sisa_panjar_sebelumnya($tgl_start);
			$data['saldo_awal'] = $saldo;
		
			$this->load->view('keuangan/template/buku_bantu_sisa_panjar',$data);
		}
		else if($kategori >= 50){
			$a = $this->mymodel->trans_buku_bantu_tambahan_debet($tgl_start,$tgl_finish,$kategori);
			$b = $this->mymodel->trans_buku_bantu_tambahan_kredit($tgl_start,$tgl_finish,$kategori);
			$q = array_merge($a->result_array(),$b->result_array());
			usort($q, function ($a, $b){
				$t1 = strtotime($a['tanggal_transaksi']);
				$t2 = strtotime($b['tanggal_transaksi']);
				$retfal = $t1 - $t2;
				if($t1 == $t2){
					$retfal = $b['jenis_transaksi'] - $a['jenis_transaksi'];
				};
				return $retfal;});
			$data['list_transaksi'] = $q;	
			$penerimaan_lalu = $this->mymodel->saldo_penerimaan_buku_bantu($tgl_awal_saldo,$tgl_start,$kategori);
			$pengeluaran_lalu = $this->mymodel->saldo_pengeluaran_buku_bantu($tgl_awal_saldo,$tgl_start,$kategori);
			$data['saldo_awal'] = $saldo_awal_bku+$penerimaan_lalu-$pengeluaran_lalu;
		
			$this->load->view('keuangan/template/buku_bantu_tambahan',$data);
		}
		else{
			$a = $this->mymodel->trans_bukubantu($tgl_start,$tgl_finish,$kategori);
			$b = $this->mymodel->trans_bukubantu_kredit($tgl_start,$tgl_finish,$kategori);
			$q = array_merge($a,$b->result_array());
			usort($q, function ($a, $b){
				$t1 = strtotime($a['tanggal_transaksi']);
				$t2 = strtotime($b['tanggal_transaksi']);
				$retfal = $t1 - $t2;
				if($t1 == $t2){
					$retfal = $a['jenis_transaksi'] - $b['jenis_transaksi'];
				};
				return $retfal;});
			$data['list_transaksi'] = $q;
			$data['saldo_awal'] = $saldo_awal_bku;
			
			if($saldo > 0){
			$tgl_awal = $saldo['saldo_awal_tanggal'];
			$tgl_awal2 = strtotime("-1 day", strtotime("$tgl_start"));
			$tgl_awal2 = date("Y-m-d", $tgl_awal2);
			$tgl_saldo2 = strtotime("1 day", strtotime("$tgl_awal"));
			$tgl_saldo2 = date("Y-m-d", $tgl_saldo2);
				if($tgl_awal !== $tgl_awal2 ){
					$temp = $this->mymodel->trans_bukubantu($tgl_saldo2,$tgl_awal2,$kategori);			
					$temp2 = $this->mymodel->trans_bukubantu_kredit($tgl_saldo2,$tgl_awal2,$kategori)->result_array();
					$temp_saldo = array_merge($temp,$temp2);
					foreach($temp_saldo as $h){
						if($h['jenis_transaksi']=='-1'){
									$data['saldo_awal'] += $h['jml'];
								}
								else{
									$data['saldo_awal'] -= $h['jml'];
								}
					}
				}
				
			}
			else{
					$data['saldo_awal'] = 0;
					$this->session->set_flashdata('msg2', '<div class="alert alert-warning text-center">Tidak ditemukan saldo awal BKU sebelum tanggal '.$this->input->post('tgl_start').', saldo 0</div>');				
				}
			//echo "<pre>";
			//print_r($kategori);
			//print_r($a);
			//echo "</pre>";
			$this->load->view('keuangan/template/buku_bantu',$data);
		}
		
		   
		
		
		//echo "<pre>";
		//print_r($q);
		//echo "</pre>";
	}		
	public function rekap($kat_id)
	{
		$sys = $this->mymodel->sys_config();
		$data['NamaPN'] = $sys['NamaPN'];
		$data['kat_id'] = $kat_id;
		$this->load->view('keuangan/page/header');
		if($kat_id == 1){
			$data['title']="Rekap Panjar Keuangan Perkara Berjalan";
			$this->load->view('keuangan/page/menu_panjar',$data);
			
		}
		else{
			$data['title']="Rekap Sisa Panjar Perkara (Putus Bersaldo)";
			$this->load->view('keuangan/page/menu_sisa_panjar',$data);
			
		}
		
		$this->load->view('keuangan/page/footer');
		
	}		
	public function panjar()
	{
		$sys = $this->mymodel->sys_config();
		$data['NamaPN'] = $sys['NamaPN'];
		$this->load->view('keuangan/page/header');
		$data['title']="Buku Bantu Panjar Keuangan Perkara";
		$this->load->view('keuangan/page/buku_bantu_panjar',$data);
		$this->load->view('keuangan/page/footer');
		
	}		
	public function sisa_panjar()
	{
		$sys = $this->mymodel->sys_config();
		$data['NamaPN'] = $sys['NamaPN'];
		$this->load->view('keuangan/page/header');
		$data['title']="Buku Bantu Sisa Panjar Keuangan Perkara";
		$this->load->view('keuangan/page/buku_bantu_sisa_panjar',$data);
		$this->load->view('keuangan/page/footer');
		
	}		
	public function bank()
	{
		$sys = $this->mymodel->sys_config();
		$data['NamaPN'] = $sys['NamaPN'];
		$this->load->view('keuangan/page/header');
		$data['title']="Buku Bantu Keuangan Kas Bank";
		$data['jenis']="1";
		$data['list_trans'] = $this->mymodel->list_tambah_trans('100');
		$this->load->view('keuangan/page/buku_bantu_bank',$data);
		$this->load->view('keuangan/page/footer');
		
	}		
	public function tunai()
	{
		$sys = $this->mymodel->sys_config();
		$data['NamaPN'] = $sys['NamaPN'];
		$this->load->view('keuangan/page/header');
		$data['title']="Buku Bantu Keuangan Kas Tunai";
		$data['jenis']="2";
		$data['list_trans'] = $this->mymodel->list_tambah_trans('100');
		$this->load->view('keuangan/page/buku_bantu_bank',$data);
		$this->load->view('keuangan/page/footer');
		
	}	
	public function materai()
	{
		$sys = $this->mymodel->sys_config();
		$data['NamaPN'] = $sys['NamaPN'];
		$this->load->view('keuangan/page/header');
		$data['title']="Buku Bantu Persediaan Materai";
		$data['jenis']="3";
		$data['list_trans'] = $this->mymodel->list_tambah_trans('101');
		$this->load->view('keuangan/page/buku_bantu_bank',$data);
		$this->load->view('keuangan/page/footer');
		
	}		
	public function bk_bank_ajax(){
		$sys = $this->mymodel->sys_config();
		$data['NamaPN'] = $sys['NamaPN'];
		$this->load->model('keuangan/panjar');
		$tgl_start = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_start'));
		$tgl_finish = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_finish'));
		$tgl_start = date_format($tgl_start, "Y-m-d");		
		$tgl_finish = date_format($tgl_finish, "Y-m-d");		
		$kategori =  $this->input->post('kategori');	
		$s = $this->mymodel->saldo_awal_bku($tgl_start)->row_array();
		$saldo_awal = 0;
		switch($kategori){
			case 1: $data['title']="Buku Bantu Keuangan Kas Bank";break;			
			case 2: $data['title']="Buku Bantu Keuangan Kas Tunai";break;
			case 3: $data['title']="Buku Bantu Materai";break;
			
		}		
		$data['tgl_start'] = $tgl_start;
		$data['tgl_finish'] = $tgl_finish;
		
		//var_dump($saldo_awal);
		
		if($kategori == 1){
			$st = '0';
			$ps_tmb = $this->mymodel->get_data_where(array('kd' => 'tambah_panjar' ),'keu_config')->row_array();
			if($ps_tmb['value'] == '0'){					
					$st = '1';
				}
			$a = $this->mymodel->trans_bank_debet($tgl_start,$tgl_finish,$st);
			$b = $this->mymodel->trans_penarikan_tunai($tgl_start,$tgl_finish);
			$c = $this->mymodel->trans_buku_bantu_tambahan_debet($tgl_start,$tgl_finish,'55');
			$d = $this->mymodel->trans_buku_bantu_tambahan_kredit($tgl_start,$tgl_finish,'55');
			$q = array_merge($a,$b->result_array(),$c->result_array(),$d->result_array());
			
			//cek_saldo_buku_bantu saldo_konsignasi
				$ps_kons= $this->mymodel->get_data_where(array('kd' => 'saldo_uang_konsignasi' ),'keu_config')->row_array();
				if($ps_kons['value'] == '1'){					
					$a = $this->mymodel->trans_buku_bantu_tambahan_kredit($tgl_start,$tgl_finish,'52');
					$q = array_merge($a->result_array(),$q);
					
				}
			//----
			if($s > 0){
				$tgl_awal = $s['saldo_awal_tanggal'];
				$saldo_awal += $s['saldo_awal_bank'];
				$tgl_awal = strtotime("1 day", strtotime("$tgl_awal"));
				$tgl_awal = date("Y-m-d", $tgl_awal);
				$tgl_awal2 = strtotime("-1 day", strtotime("$tgl_start"));
				$tgl_awal2 = date("Y-m-d", $tgl_awal2);
				if($s['saldo_awal_tanggal'] !== $tgl_awal2){			
					$a = $this->mymodel->trans_bank_debet($tgl_awal,$tgl_awal2,$st);
					foreach($a as $h){
						$saldo_awal += $h['jml'];	
					}
					$b = $this->mymodel->trans_penarikan_tunai($tgl_awal,$tgl_awal2)->result_array();
					foreach($b as $h){
						if($h['jenis_transaksi'] == 2) {
							$saldo_awal -= $h['jml'];
						}
						else {
							$saldo_awal += $h['jml'];
						}
							
					}
					$a = $this->mymodel->trans_buku_bantu_tambahan_debet($tgl_awal,$tgl_awal2,'55');
					foreach($a->result_array() as $h){
							$saldo_awal -= $h['jml'];	
						}
					$a = $this->mymodel->trans_buku_bantu_tambahan_kredit($tgl_awal,$tgl_awal2,'55');
					foreach($a->result_array() as $h){
							$saldo_awal += $h['jml'];	
						}
					if($ps_kons['value'] == '1'){
						$a = $this->mymodel->trans_buku_bantu_tambahan_kredit($tgl_awal,$tgl_awal2,'52');
						foreach($a->result_array() as $h){
							$saldo_awal += $h['jml'];	
						}
					}
					
				}
				$data['saldo_awal'] = $saldo_awal;
				
			}
			else{
				$data['saldo_awal'] = '0';
				$this->session->set_flashdata('msg2', '<div class="alert alert-warning text-center">Tidak ditemukan saldo awal BKU sebelum tanggal '.$this->input->post('tgl_start').', saldo awal yang digunakan adalah 0</div>');				
			}
			usort($q, function ($a, $b){
				$t1 = strtotime($a['tanggal_transaksi']);
				$t2 = strtotime($b['tanggal_transaksi']);
				$retfal = $t1 - $t2;
				if($t1 == $t2){
					$retfal = $b['jenis_transaksi'] - $a['jenis_transaksi'];
				};
				return $retfal;});
			$data['list_transaksi'] = $q;	
			$this->load->view('keuangan/template/buku_bantu_bank',$data);
		}
		else if($kategori == 2){
			$a = $this->mymodel->trans_penarikan_tunai($tgl_start,$tgl_finish);
			$b = $this->mymodel->trans_tunai_kredit($tgl_start,$tgl_finish);
			$b1 = $this->mymodel->trans_tunai_debet2($tgl_start,$tgl_finish);
			$c = $this->mymodel->trans_tunai_kredit2($tgl_start,$tgl_finish);
			$d = $this->mymodel->trans_buku_umum_debet2($tgl_start,$tgl_finish);
			$e = $this->mymodel->trans_buku_bantu_tambahan_debet($tgl_start,$tgl_finish,'52');
			$q = array_merge($a->result_array(),$b->result_array(),$b1,$c,$d->result_array(),$e->result_array());
			//cek_saldo_buku_bantu saldo_konsignasi
				$ps_kons= $this->mymodel->get_data_where(array('kd' => 'saldo_uang_konsignasi' ),'keu_config')->row_array();
				if($ps_kons['value'] == '0'){					
					$a = $this->mymodel->trans_buku_bantu_tambahan_kredit($tgl_start,$tgl_finish,'52');
					$q = array_merge($a->result_array(),$q);
					
				}
				$ps_tmb = $this->mymodel->get_data_where(array('kd' => 'tambah_panjar' ),'keu_config')->row_array();
				if($ps_tmb['value'] == '0'){					
						$a = $this->mymodel->trans_tunai_debet($tgl_start,$tgl_finish);
						$q = array_merge($a,$q);
					}
			//----
			usort($q, function ($a, $b){
				$t1 = strtotime($a['tanggal_transaksi']);
				$t2 = strtotime($b['tanggal_transaksi']);
				$retfal = $t1 - $t2;
				if($t1 == $t2){
					$retfal = $b['jenis_transaksi'] - $a['jenis_transaksi'];
				};
				return $retfal;});
			$data['list_transaksi'] = $q;	
			if($s > 0){
				$tgl_awal = $s['saldo_awal_tanggal'];
				$saldo_awal = $s['saldo_awal_kas_tunai'];
				$tgl_awal = strtotime("1 day", strtotime("$tgl_awal"));
				$tgl_awal = date("Y-m-d", $tgl_awal);
				$tgl_awal2 = strtotime("-1 day", strtotime("$tgl_start"));
				$tgl_awal2 = date("Y-m-d", $tgl_awal2);
				if($s['saldo_awal_tanggal'] !== $tgl_awal2){			
					$a = $this->mymodel->trans_penarikan_tunai($tgl_awal,$tgl_awal2);
					$b = $this->mymodel->trans_tunai_kredit($tgl_awal,$tgl_awal2);
					$b1 = $this->mymodel->trans_tunai_debet2($tgl_awal,$tgl_awal2);
					$c = $this->mymodel->trans_tunai_kredit2($tgl_awal,$tgl_awal2);
					$d = $this->mymodel->trans_buku_umum_debet2($tgl_awal,$tgl_awal2);
					$e = $this->mymodel->trans_buku_bantu_tambahan_debet($tgl_awal,$tgl_awal2,'52');
					$q2 = array_merge($a->result_array(),$b->result_array(),$b1,$c,$d->result_array(),$e->result_array());
					foreach($q2 as $h){
						if($h['kategori_id'] > 50 || $h['kategori_id'] == 1 || $h['tahapan_id'] < 200)
							{
								if($h['jenis_transaksi'] == 1)
								{
									if($h['kategori_id'] == 101){
										$saldo_awal -=$h['jml'];
									}
									else{
										$saldo_awal +=$h['jml'];
									}
									
								}

								else if($h['jenis_transaksi'] == 2){
									$saldo_awal +=$h['jml'];
									
								}
								
								else if($h['jenis_transaksi'] == -2){
									$saldo_awal -=$h['jml'];
									
								}

								else{
									$saldo_awal -=$h['jml'];
									
								}
							}
							else{
								if($h['jenis_transaksi'] == 1)
								{
									$saldo_awal -=$h['jml'];	
								}
								else{
									$saldo_awal +=$h['jml'];	
								}
							}
					
					}
				}
					if($ps_kons['value'] == '0'){
						$a = $this->mymodel->trans_buku_bantu_tambahan_kredit($tgl_awal,$tgl_awal2,'52');
						foreach($a->result_array() as $h){
							$saldo_awal += $h['jml'];	
						}
					}
					if($ps_tmb['value'] == '0'){
						$a = $this->mymodel->trans_tunai_debet($tgl_awal,$tgl_awal2);
						foreach($a as $h){
							$saldo_awal += $h['jml'];	
						}
					}
				$data['saldo_awal'] = $saldo_awal;
				
			}
			else{
				$data['saldo_awal'] = '0';
				$this->session->set_flashdata('msg2', '<div class="alert alert-warning text-center">Tidak ditemukan saldo awal BKU sebelum tanggal '.$this->input->post('tgl_start').', saldo awal yang digunakan adalah 0</div>');				
			}
			
			$this->load->view('keuangan/template/buku_bantu_tunai',$data);
		}
		else if($kategori == 3){
			$a = $this->mymodel->trans_materai_debet($tgl_start,$tgl_finish);
			$b = $this->mymodel->trans_materai_kredit($tgl_start,$tgl_finish);
			$c = $this->mymodel->trans_materai_kredit2($tgl_start,$tgl_finish);
			$q = array_merge($a->result_array(),$b,$c->result_array());
			usort($q, function ($a, $b){
				$t1 = strtotime($a['tanggal_transaksi']);
				$t2 = strtotime($b['tanggal_transaksi']);
				$retfal = $t1 - $t2;
				if($t1 == $t2){
					$retfal = $b['jenis_transaksi'] - $a['jenis_transaksi'];
				};
				return $retfal;});
			$data['list_transaksi'] = $q;	
			if($s > 0){
				$tgl_awal = $s['saldo_awal_tanggal'];
				$saldo_awal = $s['saldo_awal_meterai']*6000;
				$tgl_awal = strtotime("1 day", strtotime("$tgl_awal"));
				$tgl_awal = date("Y-m-d", $tgl_awal);
				$tgl_awal2 = strtotime("-1 day", strtotime("$tgl_start"));
				$tgl_awal2 = date("Y-m-d", $tgl_awal2);
				if($s['saldo_awal_tanggal'] !== $tgl_awal2){	
					$a = $this->mymodel->trans_materai_debet($tgl_awal,$tgl_awal2)->result_array();
					foreach($a as $h){
						$saldo_awal += $h['jml'];	
					}
					$b = $this->mymodel->trans_materai_kredit($tgl_awal,$tgl_awal2);
					foreach($b as $h){
						$saldo_awal -= $h['jml'];	
					}
					$c = $this->mymodel->trans_materai_kredit2($tgl_awal,$tgl_awal2)->result_array();
					foreach($c as $h){
						$saldo_awal -= $h['jml'];	
					}
					
				}
				$data['saldo_awal'] = $saldo_awal;
				
			}
			else{
				$data['saldo_awal'] = '0';
				$this->session->set_flashdata('msg2', '<div class="alert alert-warning text-center">Tidak ditemukan saldo awal BKU sebelum tanggal '.$this->input->post('tgl_start').', saldo awal yang digunakan adalah 0</div>');				
			}
			
			$this->load->view('keuangan/template/buku_bantu_materai',$data);
		}
		
		
	}			
	public function bk_panjar_ajax(){
		$sys = $this->mymodel->sys_config();
		$data['NamaPN'] = $sys['NamaPN'];
		$this->load->model('keuangan/panjar');
		$tgl_start = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_start'));
		$tgl_finish = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_finish'));
		$tgl_start = date_format($tgl_start, "Y-m-d");		
		$tgl_finish = date_format($tgl_finish, "Y-m-d");		
		$kategori =  $this->input->post('kategori');	
		$s = $this->mymodel->saldo_awal_bku($tgl_start)->row_array();
		switch($kategori){
			case 1: $data['title']="BUKU BANTU BIAYA PANJAR PERKARA TINGKAT PERTAMA";break;			
			case 3: $data['title']="BUKU BANTU BIAYA PANJAR PERKARA TINGKAT BANDING";break;
			case 4: $data['title']="BUKU BANTU BIAYA PANJAR PERKARA TINGKAT KASASI";break;
			case 5: $data['title']="BUKU BANTU BIAYA PANJAR PERKARA TINGKAT PENINJAUAN KEMBALI";break;
			case 6: $data['title']="BUKU BANTU BIAYA PANJAR PERKARA TINGKAT EKSEKUSI";break;
			case 7: $data['title']="BUKU BANTU BIAYA PANJAR PERMOHONAN KONSIGNASI";break;
			case 10: $data['title']="BUKU BANTU BIAYA PANJAR PERKARA";break;
			
		}		
		$data['tgl_start'] = $tgl_start;
		$data['tgl_finish'] = $tgl_finish;
		
		//var_dump($saldo_awal);
		
		if($kategori == 1){
			$a = $this->panjar->panjar_pa_debet($tgl_start,$tgl_finish);
			$b = $this->panjar->panjar_pa_kredit($tgl_start,$tgl_finish);
			$c = $this->panjar->panjar_pa_kredit2($tgl_start,$tgl_finish);
			$q = array_merge($a->result_array(),$b->result_array(),$c->result_array());
			usort($q, function ($a, $b){
				$t1 = strtotime($a['tanggal_transaksi']);
				$t2 = strtotime($b['tanggal_transaksi']);
				$retfal = $t1 - $t2;
				if($t1 == $t2){
					$retfal = $b['jenis_transaksi'] - $a['jenis_transaksi'];
				};
				return $retfal;});
			$data['list_transaksi'] = $q;	
			if($s > 0){
				$tgl_awal = $s['saldo_awal_tanggal'];
				$saldo_awal = $s['saldo_awal_panjar_pa'];
				$tgl_awal = strtotime("1 day", strtotime("$tgl_awal"));
				$tgl_awal = date("Y-m-d", $tgl_awal);
				$tgl_awal2 = strtotime("-1 day", strtotime("$tgl_start"));
				$tgl_awal2 = date("Y-m-d", $tgl_awal2);
				$a = $this->panjar->panjar_pa_debet($tgl_awal,$tgl_awal2)->result_array();
				foreach($a as $h){
					$saldo_awal += $h['jml'];	
				}
				$b = $this->panjar->panjar_pa_kredit($tgl_awal,$tgl_awal2)->result_array();
				foreach($b as $h){
					$saldo_awal -= $h['jml'];	
				}
				$c = $this->panjar->panjar_pa_kredit2($tgl_awal,$tgl_awal2)->result_array();
				foreach($c as $h){
					$saldo_awal -= $h['jml'];	
				}
				$data['saldo_awal'] = $saldo_awal;
			}
			else{
				$data['saldo_awal'] = $this->panjar->saldo_panjar_sebelumnya($tgl_start);
				$this->session->set_flashdata('msg2', '<div class="alert alert-warning text-center">Tidak ditemukan saldo awal BKU sebelum tanggal '.$this->input->post('tgl_start').', saldo awal yang digunakan adalah saldo Jurnal</div>');				
			}
			
			$this->load->view('keuangan/template/buku_bantu_panjar',$data);
		}
		else if($kategori == 3){
			$a = $this->panjar->panjar_banding_debet($tgl_start,$tgl_finish);
			$b = $this->panjar->panjar_banding_kredit($tgl_start,$tgl_finish);
			$c = $this->panjar->panjar_banding_kredit2($tgl_start,$tgl_finish);
			$q = array_merge($a->result_array(),$b->result_array(),$c->result_array());
			usort($q, function ($a, $b){
				$t1 = strtotime($a['tanggal_transaksi']);
				$t2 = strtotime($b['tanggal_transaksi']);
				$retfal = $t1 - $t2;
				if($t1 == $t2){
					$retfal = $b['jenis_transaksi'] - $a['jenis_transaksi'];
				};
				return $retfal;});
			$data['list_transaksi'] = $q;	
			
			if($s > 0){
				$tgl_awal = $s['saldo_awal_tanggal'];
				$saldo_awal = $s['saldo_awal_panjar_banding'];
				$tgl_awal = strtotime("1 day", strtotime("$tgl_awal"));
				$tgl_awal = date("Y-m-d", $tgl_awal);
				$tgl_awal2 = strtotime("-1 day", strtotime("$tgl_start"));
				$tgl_awal2 = date("Y-m-d", $tgl_awal2);
				$a = $this->panjar->panjar_banding_debet($tgl_awal,$tgl_awal2)->result_array();
				foreach($a as $h){
					$saldo_awal += $h['jml'];	
				}
				$b = $this->panjar->panjar_banding_kredit($tgl_awal,$tgl_awal2)->result_array();
				foreach($b as $h){
					$saldo_awal -= $h['jml'];	
				}
				$c = $this->panjar->panjar_banding_kredit2($tgl_awal,$tgl_awal2)->result_array();
				foreach($c as $h){
					$saldo_awal -= $h['jml'];	
				}
				$data['saldo_awal'] = $saldo_awal;
			}
			else{
				$data['saldo_awal'] = $this->panjar->saldo_panjar_banding_sebelumnya($tgl_start);
				$this->session->set_flashdata('msg2', '<div class="alert alert-warning text-center">Tidak ditemukan saldo awal BKU sebelum tanggal '.$this->input->post('tgl_start').', saldo awal yang digunakan adalah saldo Jurnal</div>');				
			}
			//$saldo = $this->panjar->saldo_panjar_banding_sebelumnya($tgl_start);
			//$data['saldo_awal'] = $s['saldo_awal_panjar_banding'];
		
			$this->load->view('keuangan/template/buku_bantu_panjar',$data);
		}
		else if($kategori == 4){
			$a = $this->panjar->panjar_kasasi_debet($tgl_start,$tgl_finish);
			$b = $this->panjar->panjar_kasasi_kredit($tgl_start,$tgl_finish);
			$c = $this->panjar->panjar_kasasi_kredit2($tgl_start,$tgl_finish);
			$q = array_merge($a->result_array(),$b->result_array(),$c->result_array());
			usort($q, function ($a, $b){
				$t1 = strtotime($a['tanggal_transaksi']);
				$t2 = strtotime($b['tanggal_transaksi']);
				$retfal = $t1 - $t2;
				if($t1 == $t2){
					$retfal = $b['jenis_transaksi'] - $a['jenis_transaksi'];
				};
				return $retfal;});
			$data['list_transaksi'] = $q;	
			
			if($s > 0){
				$tgl_awal = $s['saldo_awal_tanggal'];
				$saldo_awal = $s['saldo_awal_panjar_kasasi'];
				$tgl_awal = strtotime("1 day", strtotime("$tgl_awal"));
				$tgl_awal = date("Y-m-d", $tgl_awal);
				$tgl_awal2 = strtotime("-1 day", strtotime("$tgl_start"));
				$tgl_awal2 = date("Y-m-d", $tgl_awal2);
				$a = $this->panjar->panjar_kasasi_debet($tgl_awal,$tgl_awal2)->result_array();
				foreach($a as $h){
					$saldo_awal += $h['jml'];	
				}
				$b = $this->panjar->panjar_kasasi_kredit($tgl_awal,$tgl_awal2)->result_array();
				foreach($b as $h){
					$saldo_awal -= $h['jml'];	
				}
				$c = $this->panjar->panjar_kasasi_kredit2($tgl_awal,$tgl_awal2)->result_array();
				foreach($c as $h){
					$saldo_awal -= $h['jml'];	
				}
				$data['saldo_awal'] = $saldo_awal;
			}
			else{
				$data['saldo_awal'] = $this->panjar->saldo_panjar_kasasi_sebelumnya($tgl_start);
				$this->session->set_flashdata('msg2', '<div class="alert alert-warning text-center">Tidak ditemukan saldo awal BKU sebelum tanggal '.$this->input->post('tgl_start').', saldo awal yang digunakan adalah saldo Jurnal</div>');				
			}
			//$saldo = $this->panjar->saldo_panjar_kasasi_sebelumnya($tgl_start);
			//$data['saldo_awal'] = $s['saldo_awal_panjar_kasasi'];
		
			$this->load->view('keuangan/template/buku_bantu_panjar',$data);
		}
		else if($kategori == 5){
			$a = $this->panjar->panjar_pk_debet($tgl_start,$tgl_finish);
			$b = $this->panjar->panjar_pk_kredit($tgl_start,$tgl_finish);
			$c = $this->panjar->panjar_pk_kredit2($tgl_start,$tgl_finish);
			$q = array_merge($a->result_array(),$b->result_array(),$c->result_array());
			usort($q, function ($a, $b){
				$t1 = strtotime($a['tanggal_transaksi']);
				$t2 = strtotime($b['tanggal_transaksi']);
				$retfal = $t1 - $t2;
				if($t1 == $t2){
					$retfal = $b['jenis_transaksi'] - $a['jenis_transaksi'];
				};
				return $retfal;});
			$data['list_transaksi'] = $q;	
			
			if($s > 0){
				$tgl_awal = $s['saldo_awal_tanggal'];
				$saldo_awal = $s['saldo_awal_panjar_pk'];
				$tgl_awal = strtotime("1 day", strtotime("$tgl_awal"));
				$tgl_awal = date("Y-m-d", $tgl_awal);
				$tgl_awal2 = strtotime("-1 day", strtotime("$tgl_start"));
				$tgl_awal2 = date("Y-m-d", $tgl_awal2);
				$a = $this->panjar->panjar_pk_debet($tgl_awal,$tgl_awal2)->result_array();
				foreach($a as $h){
					$saldo_awal += $h['jml'];	
				}
				$b = $this->panjar->panjar_pk_kredit($tgl_awal,$tgl_awal2)->result_array();
				foreach($b as $h){
					$saldo_awal -= $h['jml'];	
				}
				$c = $this->panjar->panjar_pk_kredit2($tgl_awal,$tgl_awal2)->result_array();
				foreach($c as $h){
					$saldo_awal -= $h['jml'];	
				}
				$data['saldo_awal'] = $saldo_awal;
			}
			else{
				$data['saldo_awal'] = $this->panjar->saldo_panjar_pk_sebelumnya($tgl_start);
				$this->session->set_flashdata('msg2', '<div class="alert alert-warning text-center">Tidak ditemukan saldo awal BKU sebelum tanggal '.$this->input->post('tgl_start').', saldo awal yang digunakan adalah saldo Jurnal</div>');				
			}
			//$saldo = $this->panjar->saldo_panjar_pk_sebelumnya($tgl_start);
			//$data['saldo_awal'] = $s['saldo_awal_panjar_pk'];
		
			$this->load->view('keuangan/template/buku_bantu_panjar',$data);
		}
		else if($kategori == 6){
			$a = $this->panjar->panjar_eksekusi_debet($tgl_start,$tgl_finish);
			$b = $this->panjar->panjar_eksekusi_debet2($tgl_start,$tgl_finish);
			$c = $this->panjar->panjar_eksekusi_kredit($tgl_start,$tgl_finish);
			$d = $this->panjar->panjar_eksekusi_kredit2($tgl_start,$tgl_finish);
			$q = array_merge($a,$b->result_array(),$c,$d->result_array());
			usort($q, function ($a, $b){
				$t1 = strtotime($a['tanggal_transaksi']);
				$t2 = strtotime($b['tanggal_transaksi']);
				$retfal = $t1 - $t2;
				if($t1 == $t2){
					$retfal = $b['jenis_transaksi'] - $a['jenis_transaksi'];
				};
				return $retfal;});
			$data['list_transaksi'] = $q;	
			
			if($s > 0){
				$tgl_awal = $s['saldo_awal_tanggal'];
				$saldo_awal = $s['saldo_awal_panjar_eksekusi'];
				$tgl_awal = strtotime("1 day", strtotime("$tgl_awal"));
				$tgl_awal = date("Y-m-d", $tgl_awal);
				$tgl_awal2 = strtotime("-1 day", strtotime("$tgl_start"));
				$tgl_awal2 = date("Y-m-d", $tgl_awal2);
				$a = $this->panjar->panjar_eksekusi_debet($tgl_awal,$tgl_awal2);
				foreach($a as $h){
					$saldo_awal += $h['jml'];	
				}
				$aa = $this->panjar->panjar_eksekusi_debet2($tgl_awal,$tgl_awal2)->result_array();
				foreach($aa as $h){
					$saldo_awal += $h['jml'];	
				}
				$b = $this->panjar->panjar_eksekusi_kredit($tgl_awal,$tgl_awal2);
				foreach($b as $h){
					$saldo_awal -= $h['jml'];	
				}
				$c = $this->panjar->panjar_eksekusi_kredit2($tgl_awal,$tgl_awal2)->result_array();
				foreach($c as $h){
					$saldo_awal -= $h['jml'];	
				}
				$data['saldo_awal'] = $saldo_awal;
			}
			else{
				$s1 = $this->panjar->saldo_panjar_eksekusi_sebelumnya($tgl_start);
				$s2 = $this->panjar->saldo_panjar_eksekusi_sebelumnya2($tgl_start);
				$saldo = $s1+$s2;
				$data['saldo_awal'] = $saldo;
				$this->session->set_flashdata('msg2', '<div class="alert alert-warning text-center">Tidak ditemukan saldo awal BKU sebelum tanggal '.$this->input->post('tgl_start').', saldo awal yang digunakan adalah saldo Jurnal</div>');				
			}
			//$s1 = $this->panjar->saldo_panjar_eksekusi_sebelumnya($tgl_start);
			//$s2 = $this->panjar->saldo_panjar_eksekusi_sebelumnya2($tgl_start);
			//$saldo = $s1+$s2;
			//$data['saldo_awal'] = $s['saldo_awal_panjar_eksekusi'];
		
			$this->load->view('keuangan/template/buku_bantu_panjar',$data);
		}
		else if($kategori == 7){
			$a = $this->panjar->panjar_konsignasi($tgl_start,$tgl_finish)->result_array();
			$data['list_transaksi'] = $a;	
			
			if($s > 0){
				$tgl_awal = $s['saldo_awal_tanggal'];
				$saldo_awal = $s['saldo_awal_panjar_konsignasi'];
				$tgl_awal = strtotime("1 day", strtotime("$tgl_awal"));
				$tgl_awal = date("Y-m-d", $tgl_awal);
				$tgl_awal2 = strtotime("-1 day", strtotime("$tgl_start"));
				$tgl_awal2 = date("Y-m-d", $tgl_awal2);
				if($tgl_awal !== $tgl_awal2 ){
					$a = $this->panjar->panjar_konsignasi($tgl_awal,$tgl_awal2)->result_array();
					foreach($a as $h){
						if($h['jenis_transaksi'] == '1'){
							$saldo_awal += $h['jml'];
						}
						else if($h['jenis_transaksi'] == '-1'){
							$saldo_awal -= $h['jml'];
						}
					}
				}
				$data['saldo_awal'] = $saldo_awal;
			}
			else{
				$data['saldo_awal'] = 0;
				$this->session->set_flashdata('msg2', '<div class="alert alert-warning text-center">Tidak ditemukan saldo awal BKU sebelum tanggal '.$this->input->post('tgl_start').', saldo awal yang digunakan adalah 0</div>');				
			}
			//$s1 = $this->panjar->saldo_panjar_eksekusi_sebelumnya($tgl_start);
			//$s2 = $this->panjar->saldo_panjar_eksekusi_sebelumnya2($tgl_start);
			//$saldo = $s1+$s2;
			//$data['saldo_awal'] = $s['saldo_awal_panjar_eksekusi'];
		
			$this->load->view('keuangan/template/buku_bantu_panjar',$data);
		}
		else if($kategori == 10){
			$a = $this->panjar->panjar_pa_debet($tgl_start,$tgl_finish)->result_array();
			$b = $this->panjar->panjar_pa_kredit($tgl_start,$tgl_finish)->result_array();
			$c = $this->panjar->panjar_pa_kredit2($tgl_start,$tgl_finish)->result_array();
			$d = $this->panjar->panjar_banding_debet($tgl_start,$tgl_finish)->result_array();
			$e = $this->panjar->panjar_banding_kredit($tgl_start,$tgl_finish)->result_array();
			$f = $this->panjar->panjar_banding_kredit2($tgl_start,$tgl_finish)->result_array();
			$g = $this->panjar->panjar_kasasi_debet($tgl_start,$tgl_finish)->result_array();
			$h = $this->panjar->panjar_kasasi_kredit($tgl_start,$tgl_finish)->result_array();
			$i = $this->panjar->panjar_kasasi_kredit2($tgl_start,$tgl_finish)->result_array();
			$j = $this->panjar->panjar_pk_debet($tgl_start,$tgl_finish)->result_array();
			$k = $this->panjar->panjar_pk_kredit($tgl_start,$tgl_finish)->result_array();
			$l = $this->panjar->panjar_pk_kredit2($tgl_start,$tgl_finish)->result_array();
			$m = $this->panjar->panjar_eksekusi_debet($tgl_start,$tgl_finish);
			$n = $this->panjar->panjar_eksekusi_debet2($tgl_start,$tgl_finish)->result_array();
			$o = $this->panjar->panjar_eksekusi_kredit($tgl_start,$tgl_finish);
			$p = $this->panjar->panjar_eksekusi_kredit2($tgl_start,$tgl_finish)->result_array();
			$p1 = $this->panjar->panjar_konsignasi($tgl_start,$tgl_finish)->result_array();
			$q = array_merge($a,$b,$c,$d,$e,$f,$g,$h,$i,$j,$k,$l,$m,$n,$o,$p,$p1);
			usort($q, function ($a, $b){
				$t1 = strtotime($a['tanggal_transaksi']);
				$t2 = strtotime($b['tanggal_transaksi']);
				$retfal = $t1 - $t2;
				if($t1 == $t2){
					$retfal = $b['jenis_transaksi'] - $a['jenis_transaksi'];
				};
				return $retfal;});
			$data['list_transaksi'] = $q;
			
			if($s > 0){		
				$tgl_awal = $s['saldo_awal_tanggal'];
				$saldo_awal = $s['saldo_awal_panjar_eksekusi'];
				$tgl_awal = strtotime("1 day", strtotime("$tgl_awal"));
				$tgl_awal = date("Y-m-d", $tgl_awal);
				$tgl_awal2 = strtotime("-1 day", strtotime("$tgl_start"));
				$tgl_awal2 = date("Y-m-d", $tgl_awal2);
				$data['saldo_awal'] = $s['saldo_awal_panjar_pa']+$s['saldo_awal_panjar_banding']+$s['saldo_awal_panjar_kasasi']+$s['saldo_awal_panjar_pk']+$s['saldo_awal_panjar_eksekusi']+$s['saldo_awal_panjar_konsignasi'];
			$a = $this->panjar->panjar_pa_debet($tgl_awal,$tgl_awal2)->result_array();
			$b = $this->panjar->panjar_pa_kredit($tgl_awal,$tgl_awal2)->result_array();
			$c = $this->panjar->panjar_pa_kredit2($tgl_awal,$tgl_awal2)->result_array();
			$d = $this->panjar->panjar_banding_debet($tgl_awal,$tgl_awal2)->result_array();
			$e = $this->panjar->panjar_banding_kredit($tgl_awal,$tgl_awal2)->result_array();
			$f = $this->panjar->panjar_banding_kredit2($tgl_awal,$tgl_awal2)->result_array();
			$g = $this->panjar->panjar_kasasi_debet($tgl_awal,$tgl_awal2)->result_array();
			$h = $this->panjar->panjar_kasasi_kredit($tgl_awal,$tgl_awal2)->result_array();
			$i = $this->panjar->panjar_kasasi_kredit2($tgl_awal,$tgl_awal2)->result_array();
			$j = $this->panjar->panjar_pk_debet($tgl_awal,$tgl_awal2)->result_array();
			$k = $this->panjar->panjar_pk_kredit($tgl_awal,$tgl_awal2)->result_array();
			$l = $this->panjar->panjar_pk_kredit2($tgl_awal,$tgl_awal2)->result_array();
			$m = $this->panjar->panjar_eksekusi_debet($tgl_awal,$tgl_awal2);
			$n = $this->panjar->panjar_eksekusi_debet2($tgl_awal,$tgl_awal2)->result_array();
			$o = $this->panjar->panjar_eksekusi_kredit($tgl_awal,$tgl_awal2);
			$p = $this->panjar->panjar_eksekusi_kredit2($tgl_awal,$tgl_awal2)->result_array();
			$p1 = $this->panjar->panjar_konsignasi($tgl_awal,$tgl_awal2)->result_array();
			$qq = array_merge($a,$b,$c,$d,$e,$f,$g,$h,$i,$j,$k,$l,$m,$n,$o,$p,$p1);
			foreach($qq as $h){
				if($h['jenis_transaksi'] == '1'){
					$data['saldo_awal'] += $h['jml'];	
					}
				else if($h['jenis_transaksi'] == '-2'){
					$data['saldo_awal'] -= $h['jml'];	
					}	
				
				else if($h['jenis_transaksi'] == '-1'){
					$data['saldo_awal'] -= $h['jml'];	
					}	
				}
			}
			else{
				$saldo = $this->panjar->saldo_panjar_sebelumnya($tgl_start)+$this->panjar->saldo_panjar_banding_sebelumnya($tgl_start)+$this->panjar->saldo_panjar_kasasi_sebelumnya($tgl_start)+$this->panjar->saldo_panjar_pk_sebelumnya($tgl_start)+$this->panjar->saldo_panjar_eksekusi_sebelumnya($tgl_start);+$this->panjar->saldo_panjar_eksekusi_sebelumnya2($tgl_start);
				$data['saldo_awal'] = $saldo;
				$this->session->set_flashdata('msg2', '<div class="alert alert-warning text-center">Tidak ditemukan saldo awal BKU sebelum tanggal '.$this->input->post('tgl_start').', saldo awal yang digunakan adalah saldo Jurnal</div>');				
			}			
			//$saldo = $this->panjar->saldo_panjar_sebelumnya($tgl_start)+$this->panjar->saldo_panjar_banding_sebelumnya($tgl_start)+$this->panjar->saldo_panjar_kasasi_sebelumnya($tgl_start)+$this->panjar->saldo_panjar_pk_sebelumnya($tgl_start)+$this->panjar->saldo_panjar_eksekusi_sebelumnya($tgl_start);+$this->panjar->saldo_panjar_eksekusi_sebelumnya2($tgl_start);
			// $data['saldo_awal'] = $s['saldo_awal_panjar_pa']+$s['saldo_awal_panjar_banding']+$s['saldo_awal_panjar_kasasi']+$s['saldo_awal_panjar_pk']+$s['saldo_awal_panjar_eksekusi'];
		
			$this->load->view('keuangan/template/buku_bantu_panjar',$data);
		}
		
	}			
	public function bk_sisa_panjar_ajax(){
		$sys = $this->mymodel->sys_config();
		$data['NamaPN'] = $sys['NamaPN'];
		$this->load->model('keuangan/panjar');
		$tgl_start = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_start'));
		$tgl_finish = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_finish'));
		$tgl_start = date_format($tgl_start, "Y-m-d");		
		$tgl_finish = date_format($tgl_finish, "Y-m-d");		
		$kategori =  $this->input->post('kategori');	
		$s = $this->mymodel->saldo_awal_bku($tgl_start)->row_array();
		switch($kategori){
			case 1: $data['title']="BUKU BANTU SISA PANJAR PERKARA TINGKAT PERTAMA";break;			
			case 3: $data['title']="BUKU BANTU SISA PANJAR PERKARA TINGKAT BANDING";break;
			case 4: $data['title']="BUKU BANTU SISA PANJAR PERKARA TINGKAT KASASI";break;
			case 5: $data['title']="BUKU BANTU SISA PANJAR PERKARA TINGKAT PENINJAUAN KEMBALI";break;
			case 6: $data['title']="BUKU BANTU SISA PANJAR PERKARA TINGKAT EKSEKUSI";break;
			case 10: $data['title']="BUKU BANTU SISA PANJAR PERKARA";break;
			
		}		
		$data['tgl_start'] = $tgl_start;
		$data['tgl_finish'] = $tgl_finish;
		
		//var_dump($saldo_awal);
		
		if($kategori == 1){
			$a = $this->panjar->spj_pa_debet($tgl_start,$tgl_finish);
			$b = $this->panjar->spj_pa_debet2($tgl_start,$tgl_finish);
			$c = $this->panjar->spj_pa_kredit($tgl_start,$tgl_finish);
			$q = array_merge($a->result_array(),$b->result_array(),$c->result_array());
			usort($q, function ($a, $b){
				$t1 = strtotime($a['tanggal_transaksi']);
				$t2 = strtotime($b['tanggal_transaksi']);
				$retfal = $t1 - $t2;
				if($t1 == $t2){
					$retfal = $b['jenis_transaksi'] - $a['jenis_transaksi'];
				};
				return $retfal;});
			$data['list_transaksi'] = $q;	
			//$saldo = $this->panjar->saldo_spj_pa($tgl_start);
			if($s > 0){
				$tgl_awal = $s['saldo_awal_tanggal'];
				$saldo_awal = $s['saldo_awal_spj_pa'];
				$tgl_awal = strtotime("1 day", strtotime("$tgl_awal"));
				$tgl_awal = date("Y-m-d", $tgl_awal);
				$tgl_awal2 = strtotime("-1 day", strtotime("$tgl_start"));
				$tgl_awal2 = date("Y-m-d", $tgl_awal2);
				$a = $this->panjar->spj_pa_debet($tgl_awal,$tgl_awal2)->result_array();
				foreach($a as $h){
					$saldo_awal += $h['jml'];	
				}
				$b = $this->panjar->spj_pa_debet2($tgl_awal,$tgl_awal2)->result_array();
				foreach($b as $h){
					$saldo_awal += $h['jml'];	
				}
				$c = $this->panjar->spj_pa_kredit($tgl_awal,$tgl_awal2)->result_array();
				foreach($c as $h){
					$saldo_awal -= $h['jml'];	
				}
				$data['saldo_awal'] = $saldo_awal;
			}
			else{
				$data['saldo_awal'] = 0;
				$this->session->set_flashdata('msg2', '<div class="alert alert-warning text-center">Tidak ditemukan saldo awal BKU sebelum tanggal '.$this->input->post('tgl_start').', saldo awal yang digunakan adalah 0</div>');				
			}
		
			$this->load->view('keuangan/template/buku_bantu_sisa_panjar',$data);
		}
		else if($kategori == 3){
			$a = $this->panjar->spj_banding_debet($tgl_start,$tgl_finish);
			$b = $this->panjar->spj_banding_debet2($tgl_start,$tgl_finish);
			$c = $this->panjar->spj_banding_kredit($tgl_start,$tgl_finish);
			$q = array_merge($a->result_array(),$b->result_array(),$c->result_array());
			usort($q, function ($a, $b){
				$t1 = strtotime($a['tanggal_transaksi']);
				$t2 = strtotime($b['tanggal_transaksi']);
				$retfal = $t1 - $t2;
				if($t1 == $t2){
					$retfal = $b['jenis_transaksi'] - $a['jenis_transaksi'];
				};
				return $retfal;});
			$data['list_transaksi'] = $q;	
			//saldo = $this->panjar->saldo_spj_banding($tgl_start);
			// $data['saldo_awal'] = $s['saldo_awal_spj_banding'];
			if($s > 0){
				$tgl_awal = $s['saldo_awal_tanggal'];
				$saldo_awal = $s['saldo_awal_spj_banding'];
				$tgl_awal = strtotime("1 day", strtotime("$tgl_awal"));
				$tgl_awal = date("Y-m-d", $tgl_awal);
				$tgl_awal2 = strtotime("-1 day", strtotime("$tgl_start"));
				$tgl_awal2 = date("Y-m-d", $tgl_awal2);
				$a = $this->panjar->spj_banding_debet($tgl_awal,$tgl_awal2)->result_array();
				foreach($a as $h){
					$saldo_awal += $h['jml'];	
				}
				$b = $this->panjar->spj_banding_debet2($tgl_awal,$tgl_awal2)->result_array();
				foreach($b as $h){
					$saldo_awal += $h['jml'];	
				}
				$c = $this->panjar->spj_banding_kredit($tgl_awal,$tgl_awal2)->result_array();
				foreach($c as $h){
					$saldo_awal -= $h['jml'];	
				}
				$data['saldo_awal'] = $saldo_awal;
			}
			else{
				$data['saldo_awal'] = 0;
				$this->session->set_flashdata('msg2', '<div class="alert alert-warning text-center">Tidak ditemukan saldo awal BKU sebelum tanggal '.$this->input->post('tgl_start').', saldo awal yang digunakan adalah 0</div>');				
			}
		
			$this->load->view('keuangan/template/buku_bantu_sisa_panjar',$data);
		}
		else if($kategori == 4){
			$a = $this->panjar->spj_kasasi_debet($tgl_start,$tgl_finish);
			$b = $this->panjar->spj_kasasi_debet2($tgl_start,$tgl_finish);
			$c = $this->panjar->spj_kasasi_kredit($tgl_start,$tgl_finish);
			$q = array_merge($a->result_array(),$b->result_array(),$c->result_array());
			usort($q, function ($a, $b){
				$t1 = strtotime($a['tanggal_transaksi']);
				$t2 = strtotime($b['tanggal_transaksi']);
				$retfal = $t1 - $t2;
				if($t1 == $t2){
					$retfal = $b['jenis_transaksi'] - $a['jenis_transaksi'];
				};
				return $retfal;});
			$data['list_transaksi'] = $q;	
			//$saldo = $this->panjar->saldo_spj_kasasi($tgl_start);
			// $data['saldo_awal'] = $s['saldo_awal_spj_kasasi'];
			if($s > 0){
				$tgl_awal = $s['saldo_awal_tanggal'];
				$saldo_awal = $s['saldo_awal_spj_kasasi'];
				$tgl_awal = strtotime("1 day", strtotime("$tgl_awal"));
				$tgl_awal = date("Y-m-d", $tgl_awal);
				$tgl_awal2 = strtotime("-1 day", strtotime("$tgl_start"));
				$tgl_awal2 = date("Y-m-d", $tgl_awal2);
				$a = $this->panjar->spj_kasasi_debet($tgl_awal,$tgl_awal2)->result_array();
				foreach($a as $h){
					$saldo_awal += $h['jml'];	
				}
				$b = $this->panjar->spj_kasasi_debet2($tgl_awal,$tgl_awal2)->result_array();
				foreach($b as $h){
					$saldo_awal += $h['jml'];	
				}
				$c = $this->panjar->spj_kasasi_kredit($tgl_awal,$tgl_awal2)->result_array();
				foreach($c as $h){
					$saldo_awal -= $h['jml'];	
				}
				$data['saldo_awal'] = $saldo_awal;
			}
			else{
				$data['saldo_awal'] = 0;
				$this->session->set_flashdata('msg2', '<div class="alert alert-warning text-center">Tidak ditemukan saldo awal BKU sebelum tanggal '.$this->input->post('tgl_start').', saldo awal yang digunakan adalah 0</div>');				
			}
		
			$this->load->view('keuangan/template/buku_bantu_sisa_panjar',$data);
		}
		else if($kategori == 5){
			$a = $this->panjar->spj_pk_debet($tgl_start,$tgl_finish);
			$b = $this->panjar->spj_pk_debet2($tgl_start,$tgl_finish);
			$c = $this->panjar->spj_pk_kredit($tgl_start,$tgl_finish);
			$q = array_merge($a->result_array(),$b->result_array(),$c->result_array());
			usort($q, function ($a, $b){
				$t1 = strtotime($a['tanggal_transaksi']);
				$t2 = strtotime($b['tanggal_transaksi']);
				$retfal = $t1 - $t2;
				if($t1 == $t2){
					$retfal = $b['jenis_transaksi'] - $a['jenis_transaksi'];
				};
				return $retfal;});
			$data['list_transaksi'] = $q;	
			//$saldo = $this->panjar->saldo_spj_pk($tgl_start);
			// $data['saldo_awal'] = $s['saldo_awal_spj_pk'];
			if($s > 0){
				$tgl_awal = $s['saldo_awal_tanggal'];
				$saldo_awal = $s['saldo_awal_spj_pk'];
				$tgl_awal = strtotime("1 day", strtotime("$tgl_awal"));
				$tgl_awal = date("Y-m-d", $tgl_awal);
				$tgl_awal2 = strtotime("-1 day", strtotime("$tgl_start"));
				$tgl_awal2 = date("Y-m-d", $tgl_awal2);
				$a = $this->panjar->spj_pk_debet($tgl_awal,$tgl_awal2)->result_array();
				foreach($a as $h){
					$saldo_awal += $h['jml'];	
				}
				$b = $this->panjar->spj_pk_debet2($tgl_awal,$tgl_awal2)->result_array();
				foreach($b as $h){
					$saldo_awal += $h['jml'];	
				}
				$c = $this->panjar->spj_pk_kredit($tgl_awal,$tgl_awal2)->result_array();
				foreach($c as $h){
					$saldo_awal -= $h['jml'];	
				}
				$data['saldo_awal'] = $saldo_awal;
			}
			else{
				$data['saldo_awal'] = 0;
				$this->session->set_flashdata('msg2', '<div class="alert alert-warning text-center">Tidak ditemukan saldo awal BKU sebelum tanggal '.$this->input->post('tgl_start').', saldo awal yang digunakan adalah 0</div>');				
			}
			$this->load->view('keuangan/template/buku_bantu_sisa_panjar',$data);
		}
		else if($kategori == 6){
			$a = $this->panjar->spj_eksekusi_debet($tgl_start,$tgl_finish);
			$b = $this->panjar->spj_eksekusi_debet2($tgl_start,$tgl_finish);
			$c = $this->panjar->spj_eksekusi_kredit($tgl_start,$tgl_finish);
			$q = array_merge($a->result_array(),$b->result_array(),$c->result_array());
			usort($q, function ($a, $b){
				$t1 = strtotime($a['tanggal_transaksi']);
				$t2 = strtotime($b['tanggal_transaksi']);
				$retfal = $t1 - $t2;
				if($t1 == $t2){
					$retfal = $b['jenis_transaksi'] - $a['jenis_transaksi'];
				};
				return $retfal;});
			$data['list_transaksi'] = $q;	
			//$saldo = $this->panjar->saldo_spj_eksekusi($tgl_start);
			// $data['saldo_awal'] = $s['saldo_awal_spj_eksekusi'];
			if($s > 0){
				$tgl_awal = $s['saldo_awal_tanggal'];
				$saldo_awal = $s['saldo_awal_spj_eksekusi'];
				$tgl_awal = strtotime("1 day", strtotime("$tgl_awal"));
				$tgl_awal = date("Y-m-d", $tgl_awal);
				$tgl_awal2 = strtotime("-1 day", strtotime("$tgl_start"));
				$tgl_awal2 = date("Y-m-d", $tgl_awal2);
				$a = $this->panjar->spj_eksekusi_debet($tgl_awal,$tgl_awal2)->result_array();
				foreach($a as $h){
					$saldo_awal += $h['jml'];	
				}
				$b = $this->panjar->spj_eksekusi_debet2($tgl_awal,$tgl_awal2)->result_array();
				foreach($b as $h){
					$saldo_awal += $h['jml'];	
				}
				$c = $this->panjar->spj_eksekusi_kredit($tgl_awal,$tgl_awal2)->result_array();
				foreach($c as $h){
					$saldo_awal -= $h['jml'];	
				}
				$data['saldo_awal'] = $saldo_awal;
			}
			else{
				$data['saldo_awal'] = 0;
				$this->session->set_flashdata('msg2', '<div class="alert alert-warning text-center">Tidak ditemukan saldo awal BKU sebelum tanggal '.$this->input->post('tgl_start').', saldo awal yang digunakan adalah 0</div>');				
			}
			$this->load->view('keuangan/template/buku_bantu_sisa_panjar',$data);
		}
		else if($kategori == 10){
			$a = $this->panjar->spj_pa_debet($tgl_start,$tgl_finish)->result_array();
			$b = $this->panjar->spj_pa_debet2($tgl_start,$tgl_finish)->result_array();
			$c = $this->panjar->spj_pa_kredit($tgl_start,$tgl_finish)->result_array();
			$d = $this->panjar->spj_banding_debet($tgl_start,$tgl_finish)->result_array();
			$e = $this->panjar->spj_banding_debet2($tgl_start,$tgl_finish)->result_array();
			$f = $this->panjar->spj_banding_kredit($tgl_start,$tgl_finish)->result_array();
			$g = $this->panjar->spj_kasasi_debet($tgl_start,$tgl_finish)->result_array();
			$h = $this->panjar->spj_kasasi_debet2($tgl_start,$tgl_finish)->result_array();
			$i = $this->panjar->spj_kasasi_kredit($tgl_start,$tgl_finish)->result_array();
			$j = $this->panjar->spj_pk_debet($tgl_start,$tgl_finish)->result_array();
			$k = $this->panjar->spj_pk_debet2($tgl_start,$tgl_finish)->result_array();
			$l = $this->panjar->spj_pk_kredit($tgl_start,$tgl_finish)->result_array();
			$m = $this->panjar->spj_eksekusi_debet($tgl_start,$tgl_finish)->result_array();
			$n = $this->panjar->spj_eksekusi_debet2($tgl_start,$tgl_finish)->result_array();
			$o = $this->panjar->spj_eksekusi_kredit($tgl_start,$tgl_finish)->result_array();
			$q = array_merge($a,$b,$c,$d,$e,$f,$g,$h,$i,$j,$k,$l,$m,$n,$o);
			usort($q, function ($a, $b){
				$t1 = strtotime($a['tanggal_transaksi']);
				$t2 = strtotime($b['tanggal_transaksi']);
				$retfal = $t1 - $t2;
				if($t1 == $t2){
					$retfal = $b['jenis_transaksi'] - $a['jenis_transaksi'];
				};
				return $retfal;});
			$data['list_transaksi'] = $q;	
			//$saldo = $this->panjar->saldo_spj_pa($tgl_start)+$this->panjar->saldo_spj_banding($tgl_start)+$this->panjar->saldo_spj_kasasi($tgl_start)+$this->panjar->saldo_spj_pk($tgl_start)+$this->panjar->saldo_spj_eksekusi($tgl_start);
			$saldo = $s['saldo_awal_spj_pa']+$s['saldo_awal_spj_banding']+$s['saldo_awal_spj_kasasi']+$s['saldo_awal_spj_pk']+$s['saldo_awal_spj_eksekusi'];
			$data['saldo_awal'] = $saldo;
			if($s > 0){
				$tgl_awal = $s['saldo_awal_tanggal'];
				$saldo_awal = $s['saldo_awal_spj_pa']+$s['saldo_awal_spj_banding']+$s['saldo_awal_spj_kasasi']+$s['saldo_awal_spj_pk']+$s['saldo_awal_spj_eksekusi'];
				$tgl_awal = strtotime("1 day", strtotime("$tgl_awal"));
				$tgl_awal = date("Y-m-d", $tgl_awal);
				$tgl_awal2 = strtotime("-1 day", strtotime("$tgl_start"));
				$tgl_awal2 = date("Y-m-d", $tgl_awal2);
			$a = $this->panjar->spj_pa_debet($tgl_awal,$tgl_awal2)->result_array();
			$b = $this->panjar->spj_pa_debet2($tgl_awal,$tgl_awal2)->result_array();
			$c = $this->panjar->spj_pa_kredit($tgl_awal,$tgl_awal2)->result_array();
			$d = $this->panjar->spj_banding_debet($tgl_awal,$tgl_awal2)->result_array();
			$e = $this->panjar->spj_banding_debet2($tgl_awal,$tgl_awal2)->result_array();
			$f = $this->panjar->spj_banding_kredit($tgl_awal,$tgl_awal2)->result_array();
			$g = $this->panjar->spj_kasasi_debet($tgl_awal,$tgl_awal2)->result_array();
			$h = $this->panjar->spj_kasasi_debet2($tgl_awal,$tgl_awal2)->result_array();
			$i = $this->panjar->spj_kasasi_kredit($tgl_awal,$tgl_awal2)->result_array();
			$j = $this->panjar->spj_pk_debet($tgl_awal,$tgl_awal2)->result_array();
			$k = $this->panjar->spj_pk_debet2($tgl_awal,$tgl_awal2)->result_array();
			$l = $this->panjar->spj_pk_kredit($tgl_awal,$tgl_awal2)->result_array();
			$m = $this->panjar->spj_eksekusi_debet($tgl_awal,$tgl_awal2)->result_array();
			$n = $this->panjar->spj_eksekusi_debet2($tgl_awal,$tgl_awal2)->result_array();
			$o = $this->panjar->spj_eksekusi_kredit($tgl_awal,$tgl_awal2)->result_array();
			$qq = array_merge($a,$b,$c,$d,$e,$f,$g,$h,$i,$j,$k,$l,$m,$n,$o);
			foreach($qq as $h){
				if($h['jenis_transaksi'] == '2'){
					$saldo_awal += $h['jml'];	
					}
				else if($h['jenis_transaksi'] == '1'){
					$saldo_awal += $h['jml'];	
					}	
				
				else if($h['jenis_transaksi'] == '-1'){
					$saldo_awal -= $h['jml'];	
					}	
				}
			
				$data['saldo_awal'] = $saldo_awal;
			}
			else{
				$data['saldo_awal'] = 0;
				$this->session->set_flashdata('msg2', '<div class="alert alert-warning text-center">Tidak ditemukan saldo awal BKU sebelum tanggal '.$this->input->post('tgl_start').', saldo awal yang digunakan adalah 0</div>');				
			}
			$this->load->view('keuangan/template/buku_bantu_sisa_panjar',$data);
		}
		
	}		
	public function rekap_panjar_ajax(){
		$sys = $this->mymodel->sys_config();
		$data['NamaPN'] = $sys['NamaPN'];
		$tgl = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl'));
		$tgl = date_format($tgl, "Y-m-d");		
		$kategori =  $this->input->post('kategori');		
		switch($kategori){
			case 1: $data['title']="KEUANGAN PANJAR PERKARA BERJALAN TINGKAT PERTAMA";break;	
			case 3: $data['title']="KEUANGAN PANJAR PERKARA BERJALAN TINGKAT BANDING";break;
			case 4: $data['title']="KEUANGAN PANJAR PERKARA BERJALAN TINGKAT KASASI";break;
			case 5: $data['title']="KEUANGAN PANJAR PERKARA BERJALAN TINGKAT PENINJAUAN KEMBALI";break;
			
		}		
		$data['tgl'] = $tgl;
		
		//var_dump($saldo_awal);
		
		if($kategori == 1){
			$q = $this->mymodel->list_trans_perkara_berjalan($tgl);
			$data['list_transaksi'] = $q;			
			$this->load->view('keuangan/template/rekap_panjar',$data);
		}
		else{
			switch($kategori){
			case 3: $tahapan='20';break;			
			case 4: $tahapan='30';break;			
			case 5: $tahapan='40';break;
			}
			$q = $this->mymodel->list_trans_upaya_hukum($tgl,$tahapan,1); //jenis panjar :1 sisa:2
			$data['list_transaksi'] = $q;			
			$this->load->view('keuangan/template/rekap_panjar',$data);
		}
		//echo "<pre>";
		//print_r($q);
		//echo "</pre>";
	}		
	public function sisa_panjar_ajax(){
		$sys = $this->mymodel->sys_config();
		$data['NamaPN'] = $sys['NamaPN'];
		$tgl = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl'));
		$tgl = date_format($tgl, "Y-m-d");		
		$kategori =  $this->input->post('kategori');		
		switch($kategori){
			case 1: $data['title']="SISA PANJAR PERKARA TINGKAT PERTAMA";break;
			
			case 2: $data['title']="SISA PANJAR PERKARA TINGKAT PERTAMA";
					break;
			case 3: $data['title']="SISA PANJAR PERKARA TINGKAT BANDING";break;
			case 4: $data['title']="SISA PANJAR PERKARA TINGKAT KASASI";break;
			case 5: $data['title']="SISA PANJAR PERKARA TINGKAT PENINJAUAN KEMBALI";break;
			
		}		
		$data['tgl'] = $tgl;
		
		//var_dump($saldo_awal);
		
		if($kategori == 1){
			$q = $this->mymodel->list_trans_perkara_berjalan($tgl);
			$data['list_transaksi'] = $q;			
			$this->load->view('keuangan/template/rekap_panjar',$data);
		}
		else if($kategori == 2){
			$q = $this->mymodel->list_trans_perkara_putus_bersaldo($tgl);
			$data['list_transaksi'] = $q;			
			$data['tahapan'] = '10';
			$this->load->view('keuangan/template/rekap_sisa_panjar',$data);
		}
		else{
			switch($kategori){
			case 3: $tahapan='20';break;			
			case 4: $tahapan='30';break;			
			case 5: $tahapan='40';break;
			}
			$q = $this->mymodel->list_trans_upaya_hukum($tgl,$tahapan,2); //jenis panjar :1 sisa:2
			$data['list_transaksi'] = $q;		
			$data['tahapan'] = $tahapan;		
			$this->load->view('keuangan/template/rekap_sisa_panjar',$data);
		}
		//echo "<pre>";
		//print_r($q);
		//echo "</pre>";
	}
	public function sisa (){
// Start date
	
	$date = '2018-02-01';
	// End date
	$end_date = '2018-02-28';
	$tgl_start = DateTime::createFromFormat('d/m/Y', '08/05/2018');
	$jml = 0;
	while (strtotime($date) <= strtotime($end_date)) {
                //echo $date."<br>";
                $date = date ("Y-m-d", strtotime("+1 day", strtotime($date)));
				
	$q = $this->mymodel->sisa($date)->row_array();
		$jml += $q['jml'];
		
		
	}
	$tgl_start->modify('+1 day');
	echo $tgl_start->format("Y-m-d");
		echo "<pre>";
		print_r($tgl_start);
		echo "</pre>";
	}

	
	public function panjar2($kat_id)
	{
		$data['kat_id'] = $kat_id;
		$this->load->view('keuangan/page/header');
		if($kat_id == 1){
			$data['title']="Buku Bantu Panjar Keuangan Perkara";
			$this->load->view('keuangan/page/menu_panjar2',$data);
			
		}
		else{
			$data['title']="Buku Bantu Sisa Panjar Perkara (Putus Bersaldo)";
			$this->load->view('keuangan/page/menu_sisa_panjar2',$data);
			
		}
		
		$this->load->view('keuangan/page/footer');
		
	}	
			
	public function menu($kategori)
	{
		$sys = $this->mymodel->sys_config();
		$data['NamaPN'] = $sys['NamaPN'];	
		$tgl = $this->session->flashdata('tgl');
		if(!empty($_POST)){
			$tgl_start = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_start'));
			$tgl_start = date_format($tgl_start, "Y-m-d");
			$tgl_finish = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_finish'));
			$tgl_finish = date_format($tgl_finish, "Y-m-d");
			$data['tgl_start'] = $this->input->post('tgl_start');
			$data['tgl_finish'] = $this->input->post('tgl_finish');
		}	
		else if(!empty($tgl)){
			$data['tgl_start'] = $tgl;
			$data['tgl_finish'] = $tgl;
		}
		else{
			$data['tgl_start'] = date('d/m/Y');
			$data['tgl_finish'] = date('d/m/Y');
		}
		$data['list_kategori'] = $this->mymodel->get_data_where(array('aktif' => 'Y'),'keu_kategori_biaya_tambahan');
		switch($kategori){
			case 4: $data['title']="Buku Bantu Panggilan dan Pemberitahuan";break;
			case 12: $data['title']="Buku Bantu ATK";break;
			case 13: $data['title']="Buku Bantu HHK dan HHKL";break;
			case 51: $data['title']="Buku Bantu Uang Iwadl";break;
			case 52: $data['title']="Buku Bantu Uang Konsignasi";break;
			case 53: $data['title']="Buku Bantu Uang Eksekusi";break;
			case 54: $data['title']="Buku Bantu Uang Delegasi";break;
			case 55: $data['title']="Buku Bantu Uang Perkara Belum Didaftar";break;
		}
		$data['list_trans'] = $this->mymodel->list_tambah_trans($kategori);
		$data['kat_id'] = $kategori;
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/buku_bantu/buku_bantu_tambahan_v',$data);
		$this->load->view('keuangan/page/footer');
		
	}
	public function buku_bantu_tambahan_ajax()
	{
		$tgl_awal = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_start'));
		$tgl_start = date_format($tgl_awal, "Y-m-d");
		$tgl_mulai = date_format($tgl_awal, "d-m-Y");
		$tgl_finish = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_finish'));
		$tgl_finish = date_format($tgl_finish, "Y-m-d");		
		$kategori =  $this->input->post('kategori');	
		$jenis =  $this->input->post('jenis');	

		//$total_record = $this->mymodel->count_buku_tambahan($tgl_start,$tgl_finish,$kategori);
		$no = 1;
		//echo "<table>"
		$d = array();
		$s = $this->mymodel->saldo_awal_bku($tgl_start)->row_array();
		switch($kategori){
			case 4: $saldo_awal = $s['saldo_awal_uang_panggilan'];
					break;
			case 12: $saldo_awal = $s['saldo_awal_atk'];
					break;
			case 13: $saldo_awal = $s['saldo_awal_hhk_pnbp'];
					break;
			case 51: $saldo_awal = $s['saldo_awal_iwadl'];
					break;
			case 52: $saldo_awal = $s['saldo_awal_uang_konsignasi'];
					break;
			case 53: $saldo_awal = $s['saldo_awal_uang_eksekusi'];
					break;
			case 54: $saldo_awal = $s['saldo_awal_delegasi'];
					break;
			case 55: $saldo_awal = $s['saldo_awal_perkara_belum_daftar'];
					break;
		}
		$tgl_awal_saldo = $s['saldo_awal_tanggal'];
		$tgl_awal1 = strtotime("1 day", strtotime("$tgl_awal_saldo"));
		$tgl_awal1 = date("Y-m-d", $tgl_awal1);
		$tgl_awal2 = strtotime("-1 day", strtotime("$tgl_start"));
		$tgl_awal2 = date("Y-m-d", $tgl_awal2);
		if($kategori < 50){
			if($tgl_awal_saldo !== $tgl_start ){
				$a = $this->mymodel->trans_bukubantu($tgl_awal1,$tgl_awal2,$kategori);
				$b = $this->mymodel->trans_bukubantu_kredit($tgl_awal1,$tgl_awal2,$kategori);
				$q = array_merge($a,$b->result_array());
				foreach($q as $h){
					if($h['jenis_transaksi'] == '-1'){	
						$saldo_awal += $h['jml'];
					}
					else if($h['jenis_transaksi'] == '1'){	
						$saldo_awal -= $h['jml'];	
					}
				}
			}
			if($jenis == '1'){
				$a = $this->mymodel->trans_bukubantu_new($tgl_start,$tgl_finish,$kategori);
			}	
			else{
				$a = $this->mymodel->trans_bukubantu($tgl_start,$tgl_finish,$kategori);
			}	
			$b = $this->mymodel->trans_bukubantu_kredit($tgl_start,$tgl_finish,$kategori);
			$data = array_merge($a,$b->result_array());
			usort($data, function ($a, $b){
				$t1 = strtotime($a['tanggal_transaksi']);
				$t2 = strtotime($b['tanggal_transaksi']);
				$retfal = $t1 - $t2;
				if($t1 == $t2){
					$retfal = $a['jenis_transaksi'] - $b['jenis_transaksi'];
				};
				return $retfal;});
		}
		else{
			$q = $this->mymodel->buku_bantu_tambahan_ajax($tgl_awal1,$tgl_awal2,$kategori)->result_array();
			$data = $this->mymodel->buku_bantu_tambahan_ajax($tgl_start,$tgl_finish,$kategori)->result_array();
			foreach($q as $h){
				if($h['jenis_transaksi'] == '1'){	
					$saldo_awal += $h['jml'];
				}
				else if($h['jenis_transaksi'] == '-1'){	
					$saldo_awal -= $h['jml'];	
				}
			}
		}
		
		
		$row = array($no,$tgl_mulai,'-','Saldo Awal','-','-',number_format($saldo_awal, "0" , "," , "."),'-');
		$d[] = $row;
		$penerimaan = 0;
		$pengeluaran = 0;
		foreach($data as $h){
			$row = array();
			$no++;
			$row[] = $no;
			$row[] = date('d-m-Y', strtotime($h['tanggal_transaksi']));				
			$row[] = $h['jenis_biaya_kode'];
			$keterangan = '';
			if(!empty($h['keterangan'])){
				$keterangan = ' <span class="text-danger">'.$h['keterangan'].'</span>';
			}
			$row[] = $h['uraian'].' '.$keterangan;
			if($kategori < 50){
				if($h['jenis_transaksi'] == '-1'){	
					$saldo_awal += $h['jml'];
					$row[] = number_format($h['jml'], "0" , "," , ".");
					$row[] = '-';
					$penerimaan += $h['jml'];
				}
				else if($h['jenis_transaksi'] == '1'){	
					$saldo_awal -= $h['jml'];			
					$row[] = '-';
					$row[] = number_format($h['jml'], "0" , "," , ".");
					$pengeluaran += $h['jml'];
				}
			}
			else{
				if($h['jenis_transaksi'] == '1'){	
					$saldo_awal += $h['jml'];
					$row[] = number_format($h['jml'], "0" , "," , ".");
					$row[] = '-';
					$penerimaan += $h['jml'];
				}
				else if($h['jenis_transaksi'] == '-1'){	
					$saldo_awal -= $h['jml'];			
					$row[] = '-';
					$row[] = number_format($h['jml'], "0" , "," , ".");
					$pengeluaran += $h['jml'];
				}
			}
			$row[] = number_format($saldo_awal, "0" , "," , ".");
			if($h['sumber'] == '0'){
				$row[] = '<div class="btn-group" role="group" aria-label="Table row actions">
						<button type="button" class="btn btn-primary btn-sm" onclick="popup_edit('.$h['id'].')">
							<i class="fa fa-edit"></i>
						</button>
						<a href="#" class="btn btn-danger btn-sm" onclick="popup_hapus('.$h['id'].')">							  
							<i class="fa fa-trash"></i>
						</a>
						</div>';
			}
			else if($h['sumber'] == '1'){
				$row[] = '<div class="btn-group" role="group" aria-label="Table row actions">
						<a href="'.base_url().'keuangan/menu/link_sipp/1/'.$h['id'].'" class="btn btn-primary btn-sm" target="_blank">							  
							<i class="fas fa-paper-plane"> Link SIPP</i>
						</a>
						</div>';
			}
			else if($h['sumber'] == '2'){
				$row[] = '<div class="btn-group" role="group" aria-label="Table row actions">
						<a href="'.base_url().'keuangan/menu/link_sipp/2/'.$h['id'].'" class="btn btn-success btn-sm" target="_blank">							  
							<i class="fas fa-paper-plane"> Link SIPP</i>
						</a>
						</div>';
			}
			else if($h['sumber'] == '3'){
				$row[] = '-';
			}
			

			$d[] = $row;
		}
		$row = array('','','','','','','','');
		$d[] = $row;
		$output= array("data" => $d,
						"penerimaan" => number_format($penerimaan, "0" , "," , "."),
						"pengeluaran" => number_format($pengeluaran, "0" , "," , "."),
						"saldo_akhir" => number_format($saldo_awal, "0" , "," , "."));
		
		echo json_encode($output);
	}
	public function cetak(){
		$sys = $this->mymodel->sys_config();
		$data['NamaPN'] = $sys['NamaPN'];
		$tgl_start = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_start'));
		$tgl_start = date_format($tgl_start, "Y-m-d");
		$tgl_finish = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_finish'));
		$tgl_finish = date_format($tgl_finish, "Y-m-d");
		$kategori =  $this->input->post('kategori');
		$saldo_awal_bku ='';
		$saldo = $this->mymodel->saldo_awal_bku($tgl_start)->row_array();
		switch($kategori){
			case 1: $data['title']="BUKU BANTU PANJAR PERKARA";break;
			
			case 2: $data['title']="PENGEMBALIAN SISA PANJAR";
					break;
			case 4: $data['title']="BUKU BANTU PANGGILAN DAN PEMBERITAHUAN";
					$saldo_awal_bku = $saldo['saldo_awal_uang_panggilan'];
					break;
			case 12: $data['title']="BUKU BANTU ALAT TULIS KANTOR";
					$saldo_awal_bku = $saldo['saldo_awal_atk'];
					break;
			case 13: $data['title']="BUKU BANTU HAK HAK KEPANITERAAN";
					$saldo_awal_bku = $saldo['saldo_awal_hhk_pnbp'];
					break;
			case 51: $data['title']="BUKU BANTU UANG IWADL";
					$saldo_awal_bku = $saldo['saldo_awal_iwadl'];
					break;
			case 52: $data['title']="BUKU BANTU UANG KONSIGNASI";
					$saldo_awal_bku = $saldo['saldo_awal_uang_konsignasi'];
					break;
			case 53: $data['title']="BUKU BANTU UANG EKSEKUSI";
					$saldo_awal_bku = $saldo['saldo_awal_uang_eksekusi'];
					break;
			case 54: $data['title']="BUKU BANTU UANG DELEGASI";
					$saldo_awal_bku = $saldo['saldo_awal_delegasi'];
					break;
			case 55: $data['title']="BUKU BANTU UANG BELUM DAFTAR";
					$saldo_awal_bku = $saldo['saldo_awal_perkara_belum_daftar'];
					break;
		}		
		$data['tgl_start'] = $tgl_start;
		$data['tgl_finish'] = $tgl_finish;
		$tgl_awal_saldo=$saldo['saldo_awal_tanggal'];
		
		//var_dump($saldo_awal);
		
		if($kategori == 1){
			$a = $this->mymodel->trans_panjar_debet($tgl_start,$tgl_finish);
			$b = $this->mymodel->trans_panjar_kredit($tgl_start,$tgl_finish);
			$c = $this->mymodel->trans_panjar_kredit2($tgl_start,$tgl_finish);
			$q = array_merge($a->result_array(),$b->result_array(),$c->result_array());
			usort($q, function ($a, $b){
				$t1 = strtotime($a['tanggal_transaksi']);
				$t2 = strtotime($b['tanggal_transaksi']);
				$retfal = $t1 - $t2;
				if($t1 == $t2){
					$retfal = $b['jenis_transaksi'] - $a['jenis_transaksi'];
				};
				return $retfal;});
			$data['list_transaksi'] = $q;	
			//echo "<pre>";
			//print_r($b);
			//echo "</pre>";
			$saldo = $this->mymodel->saldo_buku_panjar_sebelumnya($tgl_start);
			$data['saldo_awal'] = $saldo;
		
			$this->load->view('keuangan/template/buku_bantu_coba',$data);
		}
		else if($kategori == 2){
			$a = $this->mymodel->trans_sisa_panjar_debet($tgl_start,$tgl_finish);
			$c = $this->mymodel->trans_sisa_panjar_debet2($tgl_start,$tgl_finish);
			$b = $this->mymodel->trans_sisa_panjar_kredit($tgl_start,$tgl_finish);
			$q = array_merge($a->result_array(),$b->result_array(),$c->result_array());
			usort($q, function ($a, $b){
				$t1 = strtotime($a['tanggal_transaksi']);
				$t2 = strtotime($b['tanggal_transaksi']);
				$retfal = $t1 - $t2;
				if($t1 == $t2){
					$retfal = $b['jenis_transaksi'] - $a['jenis_transaksi'];
				};
				return $retfal;});
			$data['list_transaksi'] = $q;	
			//echo "<pre>";
			//print_r($b);
			//echo "</pre>";
			$saldo = $this->mymodel->saldo_sisa_panjar_sebelumnya($tgl_start);
			$data['saldo_awal'] = $saldo;
		
			$this->load->view('keuangan/template/buku_bantu_sisa_panjar',$data);
		}
		else if($kategori >= 50){
			$a = $this->mymodel->trans_buku_bantu_tambahan_debet($tgl_start,$tgl_finish,$kategori);
			$b = $this->mymodel->trans_buku_bantu_tambahan_kredit($tgl_start,$tgl_finish,$kategori);
			$q = array_merge($a->result_array(),$b->result_array());
			usort($q, function ($a, $b){
				$t1 = strtotime($a['tanggal_transaksi']);
				$t2 = strtotime($b['tanggal_transaksi']);
				$retfal = $t1 - $t2;
				if($t1 == $t2){
					$retfal = $b['jenis_transaksi'] - $a['jenis_transaksi'];
				};
				return $retfal;});
			$data['list_transaksi'] = $q;	
			$penerimaan_lalu = $this->mymodel->saldo_penerimaan_buku_bantu($tgl_awal_saldo,$tgl_start,$kategori);
			$pengeluaran_lalu = $this->mymodel->saldo_pengeluaran_buku_bantu($tgl_awal_saldo,$tgl_start,$kategori);
			$data['saldo_awal'] = $saldo_awal_bku+$penerimaan_lalu-$pengeluaran_lalu;
		
			$this->load->view('keuangan/buku_bantu/buku_bantu_tambahan_cetak',$data);
		}
		else{
			$a = $this->mymodel->trans_bukubantu($tgl_start,$tgl_finish,$kategori);
			$b = $this->mymodel->trans_bukubantu_kredit($tgl_start,$tgl_finish,$kategori);
			$q = array_merge($a,$b->result_array());
			usort($q, function ($a, $b){
				$t1 = strtotime($a['tanggal_transaksi']);
				$t2 = strtotime($b['tanggal_transaksi']);
				$retfal = $t1 - $t2;
				if($t1 == $t2){
					$retfal = $a['jenis_transaksi'] - $b['jenis_transaksi'];
				};
				return $retfal;});
			$data['list_transaksi'] = $q;
			$data['saldo_awal'] = $saldo_awal_bku;
			
			if($saldo > 0){
			$tgl_awal = $saldo['saldo_awal_tanggal'];
			$tgl_awal2 = strtotime("-1 day", strtotime("$tgl_start"));
			$tgl_awal2 = date("Y-m-d", $tgl_awal2);
			$tgl_saldo2 = strtotime("1 day", strtotime("$tgl_awal"));
			$tgl_saldo2 = date("Y-m-d", $tgl_saldo2);
				if($tgl_awal !== $tgl_awal2 ){
					$temp = $this->mymodel->trans_bukubantu($tgl_saldo2,$tgl_awal2,$kategori);			
					$temp2 = $this->mymodel->trans_bukubantu_kredit($tgl_saldo2,$tgl_awal2,$kategori)->result_array();
					$temp_saldo = array_merge($temp,$temp2);
					foreach($temp_saldo as $h){
						if($h['jenis_transaksi']=='-1'){
									$data['saldo_awal'] += $h['jml'];
								}
								else{
									$data['saldo_awal'] -= $h['jml'];
								}
					}
				}
				
			}
			else{
					$data['saldo_awal'] = 0;
					$this->session->set_flashdata('msg2', '<div class="alert alert-warning text-center">Tidak ditemukan saldo awal BKU sebelum tanggal '.$this->input->post('tgl_start').', saldo 0</div>');				
				}
			//echo "<pre>";
			//print_r($kategori);
			//print_r($a);
			//echo "</pre>";
			$this->load->view('keuangan/buku_bantu/buku_bantu_cetak',$data);
		}
		
		   
		
		
		//echo "<pre>";
		//print_r($q);
		//echo "</pre>";
	}
	public function pdf(){
			$sys = $this->mymodel->sys_config();
			$sys2 = $this->mymodel->sys_config2();
			$data['NamaPN'] = $sys['NamaPN'];
			$data['KetuaPNNama'] = $sys['KetuaPNNama'];
			$data['PanSekNama'] = $sys['PanSekNama'];
			$data['KetuaPNNIP'] = $sys['KetuaPNNIP'];
			$data['PanSekNIP'] = $sys['PanSekNIP'];
			$data['kota'] = $sys2['kota'];
			$data['nm_kasir'] = $sys2['nm_kasir'];
			$tgl_start = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_start'));
			$tgl_start = date_format($tgl_start, "Y-m-d");
			$tgl_finish = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_finish'));
			$tgl_finish = date_format($tgl_finish, "Y-m-d");
			$kategori =  $this->input->post('kategori');
			$saldo_awal_bku ='';
			$saldo = $this->mymodel->saldo_awal_bku($tgl_start)->row_array();
			$html = '';
			switch($kategori){
				case 1: $data['title']="BUKU BANTU PANJAR PERKARA";
				$title_file = "Buku_bantu_panjar";break;
				
				case 2: $data['title']="PENGEMBALIAN SISA PANJAR";
				$title_file = "Buku_bantu_sisa_panjar";
				break;
				case 4: $data['title']="BUKU BANTU PANGGILAN DAN PEMBERITAHUAN";
				$title_file = "Buku_bantu_pgl";
				$saldo_awal_bku = $saldo['saldo_awal_uang_panggilan'];
				break;
				case 12: $data['title']="BUKU BANTU ALAT TULIS KANTOR";
				$title_file = "Buku_bantu_atk";
				$saldo_awal_bku = $saldo['saldo_awal_atk'];
				break;
				case 13: $data['title']="BUKU BANTU HAK HAK KEPANITERAAN";
				$title_file = "Buku_bantu_hhk";
				$saldo_awal_bku = $saldo['saldo_awal_hhk_pnbp'];
				break;
				case 51: $data['title']="BUKU BANTU UANG IWADL";
				$title_file = "Buku_bantu_iwadl";
				$saldo_awal_bku = $saldo['saldo_awal_iwadl'];
				break;
				case 52: $data['title']="BUKU BANTU UANG KONSIGNASI";
				$title_file = "Buku_bantu_konsignasi";
				$saldo_awal_bku = $saldo['saldo_awal_uang_konsignasi'];
				break;
				case 53: $data['title']="BUKU BANTU UANG EKSEKUSI";
				$title_file = "Buku_bantu_uang_eksekusi";
				$saldo_awal_bku = $saldo['saldo_awal_uang_eksekusi'];
				break;
				case 54: $data['title']="BUKU BANTU UANG DELEGASI";
				$title_file = "Buku_bantu_delegasi";
				$saldo_awal_bku = $saldo['saldo_awal_delegasi'];
				break;
				case 55: $data['title']="BUKU BANTU UANG BELUM DAFTAR";
				$title_file = "Buku_bantu_blm_daftar";
				$saldo_awal_bku = $saldo['saldo_awal_perkara_belum_daftar'];
				break;
			}		
			$data['tgl_start'] = $tgl_start;
			$data['tgl_finish'] = $tgl_finish;
			$tgl_awal_saldo=$saldo['saldo_awal_tanggal'];
			
			//var_dump($saldo_awal);
			
			if($kategori == 1){
				$a = $this->mymodel->trans_panjar_debet($tgl_start,$tgl_finish);
				$b = $this->mymodel->trans_panjar_kredit($tgl_start,$tgl_finish);
				$c = $this->mymodel->trans_panjar_kredit2($tgl_start,$tgl_finish);
				$q = array_merge($a->result_array(),$b->result_array(),$c->result_array());
				usort($q, function ($a, $b){
					$t1 = strtotime($a['tanggal_transaksi']);
					$t2 = strtotime($b['tanggal_transaksi']);
					$retfal = $t1 - $t2;
					if($t1 == $t2){
						$retfal = $b['jenis_transaksi'] - $a['jenis_transaksi'];
					};
				return $retfal;});
				$data['list_transaksi'] = $q;	
				//echo "<pre>";
				//print_r($b);
				//echo "</pre>";
				$saldo = $this->mymodel->saldo_buku_panjar_sebelumnya($tgl_start);
				$data['saldo_awal'] = $saldo;
				
				$this->load->view('keuangan/template/buku_bantu_coba',$data);
			}
			else if($kategori == 2){
				$a = $this->mymodel->trans_sisa_panjar_debet($tgl_start,$tgl_finish);
				$c = $this->mymodel->trans_sisa_panjar_debet2($tgl_start,$tgl_finish);
				$b = $this->mymodel->trans_sisa_panjar_kredit($tgl_start,$tgl_finish);
				$q = array_merge($a->result_array(),$b->result_array(),$c->result_array());
				usort($q, function ($a, $b){
					$t1 = strtotime($a['tanggal_transaksi']);
					$t2 = strtotime($b['tanggal_transaksi']);
					$retfal = $t1 - $t2;
					if($t1 == $t2){
						$retfal = $b['jenis_transaksi'] - $a['jenis_transaksi'];
					};
				return $retfal;});
				$data['list_transaksi'] = $q;	
				//echo "<pre>";
				//print_r($b);
				//echo "</pre>";
				$saldo = $this->mymodel->saldo_sisa_panjar_sebelumnya($tgl_start);
				$data['saldo_awal'] = $saldo;
				
				$this->load->view('keuangan/template/buku_bantu_sisa_panjar',$data);
			}
			else if($kategori >= 50){
				$a = $this->mymodel->trans_buku_bantu_tambahan_debet($tgl_start,$tgl_finish,$kategori);
				$b = $this->mymodel->trans_buku_bantu_tambahan_kredit($tgl_start,$tgl_finish,$kategori);
				$q = array_merge($a->result_array(),$b->result_array());
				usort($q, function ($a, $b){
					$t1 = strtotime($a['tanggal_transaksi']);
					$t2 = strtotime($b['tanggal_transaksi']);
					$retfal = $t1 - $t2;
					if($t1 == $t2){
						$retfal = $b['jenis_transaksi'] - $a['jenis_transaksi'];
					};
				return $retfal;});
				$data['list_transaksi'] = $q;	
				$penerimaan_lalu = $this->mymodel->saldo_penerimaan_buku_bantu($tgl_awal_saldo,$tgl_start,$kategori);
				$pengeluaran_lalu = $this->mymodel->saldo_pengeluaran_buku_bantu($tgl_awal_saldo,$tgl_start,$kategori);
				$data['saldo_awal'] = $saldo_awal_bku+$penerimaan_lalu-$pengeluaran_lalu;
				
				$html=$this->load->view('keuangan/buku_bantu/buku_bantu_tambahan_pdf',$data, true);
			}
			else{
				$a = $this->mymodel->trans_bukubantu($tgl_start,$tgl_finish,$kategori);
				$b = $this->mymodel->trans_bukubantu_kredit($tgl_start,$tgl_finish,$kategori);
				$q = array_merge($a,$b->result_array());
				usort($q, function ($a, $b){
					$t1 = strtotime($a['tanggal_transaksi']);
					$t2 = strtotime($b['tanggal_transaksi']);
					$retfal = $t1 - $t2;
					if($t1 == $t2){
						$retfal = $a['jenis_transaksi'] - $b['jenis_transaksi'];
					};
				return $retfal;});
				$data['list_transaksi'] = $q;
				$data['saldo_awal'] = $saldo_awal_bku;
				
				if($saldo > 0){
					$tgl_awal = $saldo['saldo_awal_tanggal'];
					$tgl_awal2 = strtotime("-1 day", strtotime("$tgl_start"));
					$tgl_awal2 = date("Y-m-d", $tgl_awal2);
					$tgl_saldo2 = strtotime("1 day", strtotime("$tgl_awal"));
					$tgl_saldo2 = date("Y-m-d", $tgl_saldo2);
					if($tgl_awal !== $tgl_awal2 ){
						$temp = $this->mymodel->trans_bukubantu($tgl_saldo2,$tgl_awal2,$kategori);			
						$temp2 = $this->mymodel->trans_bukubantu_kredit($tgl_saldo2,$tgl_awal2,$kategori)->result_array();
						$temp_saldo = array_merge($temp,$temp2);
						foreach($temp_saldo as $h){
							if($h['jenis_transaksi']=='-1'){
								$data['saldo_awal'] += $h['jml'];
							}
							else{
								$data['saldo_awal'] -= $h['jml'];
							}
						}
					}
					
				}
				else{
					$data['saldo_awal'] = 0;
					$this->session->set_flashdata('msg2', '<div class="alert alert-warning text-center">Tidak ditemukan saldo awal BKU sebelum tanggal '.$this->input->post('tgl_start').', saldo 0</div>');				
				}
				//echo "<pre>";
				//print_r($kategori);
				//print_r($a);
				//echo "</pre>";
				$html=$this->load->view('keuangan/buku_bantu/buku_bantu_pdf',$data, true);
			}
		//echo $html;
		$filename = $title_file."_".$tgl_start."_sd_".$tgl_finish;			
		$mpdf = new \Mpdf\Mpdf();
		$mpdf->AddPage(['format' => 'A4']);
		$mpdf->keep_table_proportions = true;
		$mpdf->WriteHTML($html);
		$mpdf->Output($filename, 'I');
			// echo "<pre>";
			// print_r($stylesheet);
			// echo "</pre>";
	}
	
}
