<?php
defined('BASEPATH') OR exit('No direct script access allowed');
ini_set('max_execution_time', 0); 
ini_set('memory_limit','2048M');
class Bkip extends CI_Controller {

	public function index()
	{
		$sys = $this->mymodel->sys_config();
		$data['NamaPN'] = $sys['NamaPN'];
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/bkip',$data);
		$this->load->view('keuangan/page/footer');
		
	}
	
	public function ringkas()
	{
		$sys = $this->mymodel->sys_config();
		$data['NamaPN'] = $sys['NamaPN'];
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/t_bikp_ringkas',$data);
		$this->load->view('keuangan/page/footer');
		
	}
	public function rekap()
	{
		$sys = $this->mymodel->sys_config();
		$data['NamaPN'] = $sys['NamaPN'];
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/t_bikp_rekap',$data);
		$this->load->view('keuangan/page/footer');
		
	}
	

	public function data_bkip_ajax()
	{
		$tgl_start = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_start'));
		$tgl_start = date_format($tgl_start, "Y-m-d");
		$tgl_finish = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_finish'));
		$tgl_finish = date_format($tgl_finish, "Y-m-d");
		$data = $this->mymodel->list_bkip($tgl_start,$tgl_finish);	
		$no = $_POST['start'];
		//echo "<table>"
		$d = array();
		foreach($data->result_array() as $h){
			$row = array();
			$tgl_trans = $h['tanggal_transaksi'];
			$id_perk = $h['perkara_id'];
			$noperk = $this->mymodel->select_noperk($id_perk);
			$no++;
			$row[] = $no;
			$row[] = date('d-m-Y', strtotime($tgl_trans));				
			$row[] = $noperk;
			$row[] = $this->mymodel->select_jml_panjar($id_perk,$tgl_trans,'1','224',true); //Panjar PA
			$row[] = $this->mymodel->select_jml_panjar($id_perk,$tgl_trans,'2','225',true); 
			$row[] = $this->mymodel->select_jml_panjar($id_perk,$tgl_trans,'4','226',true);
			$row[] = $this->mymodel->select_jml_panjar($id_perk,$tgl_trans,'6','227',true);
			$row[] = $this->mymodel->jml_sementera($id_perk,$tgl_trans,'1',true);; //Jumlah penerimaan
			$row[] = $this->mymodel->select_kode($id_perk,$tgl_trans,'4','-1');
			$row[] = $this->mymodel->select_jumlah($id_perk,$tgl_trans,'4','-1',true); //biaya panggilan
			$row[] = $this->mymodel->select_jumlah($id_perk,$tgl_trans,'10','-1',true); //biaya penerjemah
			$row[] = $this->mymodel->select_kode($id_perk,$tgl_trans,'5','-1');
			$row[] = $this->mymodel->select_jumlah($id_perk,$tgl_trans,'5','-1',true); //biaya sita
			$row[] = $this->mymodel->select_jumlah($id_perk,$tgl_trans,'7','-1',true); //pemeriksaan setempat
			$row[] = $this->mymodel->select_jumlah($id_perk,$tgl_trans,'9','-1',true); //sumpah
			$row[] = $this->mymodel->select_kode($id_perk,$tgl_trans,'6','-1');
			$row[] = $this->mymodel->select_jumlah($id_perk,$tgl_trans,'6','-1',true); //PBT
			$row[] = $this->mymodel->select_kode($id_perk,$tgl_trans,'3','-1');
			$row[] = $this->mymodel->select_jumlah($id_perk,$tgl_trans,'3','-1',true); //Pengiriman Biaya
			$row[] = $this->mymodel->select_jumlah($id_perk,$tgl_trans,'12','-1',true); //Biaya Proses
			$row[] = $this->mymodel->select_jumlah($id_perk,$tgl_trans,'14','-1',true); //Lain Lain
			$row[] = $this->mymodel->select_jumlah($id_perk,$tgl_trans,'8','-1',true); // Materai
			$jnshhk1 = $this->mymodel->select_kode($id_perk,$tgl_trans,'11','-1');
			$jnshhk2 = $this->mymodel->select_kode($id_perk,$tgl_trans,'13','-1');
			$row[] = $jnshhk1.$jnshhk2;
			$hhk1 = $this->mymodel->select_jumlah($id_perk,$tgl_trans,'11','-1'); //PENDAFTARAN/PNBP
			$hhk2 = $this->mymodel->select_jumlah($id_perk,$tgl_trans,'13','-1'); //HHK
			$jml_hhk = $hhk1+$hhk2; //HHK
			if($jml_hhk !== 0){
				$row[] = number_format($jml_hhk, "0" , "," , "."); //HHK
			}
			else{
				$row[] = null;
			}
			$row[] = $this->mymodel->select_jumlah($id_perk,$tgl_trans,'2','-1',true); //PSP
			$row[] = $this->mymodel->jml_sementera($id_perk,$tgl_trans,'-1',true);; //Jumlah pengeluaran
			$d[] = $row;
		}
		$output= array( "draw" => $_POST['draw'], 
						"recordsTotal" => $this->mymodel->count_all($tgl_start,$tgl_finish),
						"recordsFiltered" => $this->mymodel->count_all($tgl_start,$tgl_finish),
						"data" => $d);
		
		echo json_encode($output);
	}
	
	public function bikp_ringkas_ajax()
	{
		$tgl_start = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_start'));
		$tgl_start = date_format($tgl_start, "Y-m-d");
		$tgl_finish = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_finish'));
		$tgl_finish = date_format($tgl_finish, "Y-m-d");
		$data = $this->mymodel->bikp_ringkas($tgl_start,$tgl_finish);	
		$no = $_POST['start'];
		//echo "<table>"
		$d = array();
		foreach($data as $h){
			$row = array();
			$tgl_trans = $h['tanggal_transaksi'];
			$no++;
			$row[] = $no;
			$row[] = date('d-m-Y', strtotime($tgl_trans));				
			$row[] = $h['nomor_perkara'];
			$jns_panjar = '';
				if($h['tahapan_id'] < 20){
						$jns_panjar = 'Tk. Pertama';
					}
					else if($h['tahapan_id'] == 20){
						$jns_panjar = 'Tk. Banding';
					}
					else if($h['tahapan_id'] == 30){
						$jns_panjar = 'Tk. Kasasi';
					}
					else if($h['tahapan_id'] == 40){
						$jns_panjar = 'Tk. PK';
					}
					else if($h['tahapan_id'] == 50){
						$jns_panjar = 'Tk. Eksekusi';
					}
					else if($h['tahapan_id'] == 51){
						$jns_panjar = 'Tk. Eksekusi';
					}
					else if($h['tahapan_id'] == 60){
						$jns_panjar = 'Konsignasi';
					}
			$jml_pengeluaran = $h['pgl']+$h['pnj']+$h['jst']+$h['pst']+$h['smp']+$h['pbt']+$h['krb']+$h['atk']+$h['mtr']+$h['hhk']+$h['eks']+$h['spjr'];	
			$row[] = $jns_panjar;
			$row[] = number_format($h['pjr'], "0" , "," , ".");
			$row[] = number_format($h['pgl'], "0" , "," , ".");
			$row[] = number_format($h['pnj'], "0" , "," , ".");
			$row[] = number_format($h['jst'], "0" , "," , ".");
			$row[] = number_format($h['pst'], "0" , "," , ".");
			$row[] = number_format($h['smp'], "0" , "," , ".");
			$row[] = number_format($h['pbt'], "0" , "," , ".");
			$row[] = number_format($h['krb'], "0" , "," , ".");
			$row[] = number_format($h['atk'], "0" , "," , ".");
			$row[] = number_format($h['mtr'], "0" , "," , ".");
			$row[] = number_format($h['hhk'], "0" , "," , ".");
			$row[] = number_format($h['eks'], "0" , "," , ".");
			$row[] = number_format($h['spjr'], "0" , "," , ".");
			$row[] = number_format($jml_pengeluaran, "0" , "," , ".");
			$d[] = $row;
		}
		$output= array( "draw" => $_POST['draw'], 
						"recordsTotal" => $this->mymodel->count_all($tgl_start,$tgl_finish),
						"recordsFiltered" => $this->mymodel->count_all($tgl_start,$tgl_finish),
						"data" => $d);
		
		echo json_encode($output);
	}
	public function saldo_ajax()
	{
		$this->load->model('keuangan/panjar');
		$tgl_start = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_start'));
		$tgl_start = date_format($tgl_start, "Y-m-d");
		$tgl_finish = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_finish'));
		$tgl_finish = date_format($tgl_finish, "Y-m-d");
		//$saldo_awal = $this->mymodel->saldo_bikp_sebelumnya($tgl_start);
		$s = $this->panjar->saldo_awal_bku($tgl_start)->row_array();
		if($s > 0){
			$saldo_awal = $s['saldo_awal_panjar_pa']+$s['saldo_awal_spj_pa']+$s['saldo_awal_panjar_banding']+$s['saldo_awal_spj_banding']+$s['saldo_awal_panjar_kasasi']+$s['saldo_awal_spj_kasasi']+$s['saldo_awal_panjar_pk']+$s['saldo_awal_spj_pk']+$s['saldo_awal_panjar_eksekusi']+$s['saldo_awal_spj_eksekusi']+$s['saldo_awal_panjar_konsignasi'];
				$tgl_awal = $s['saldo_awal_tanggal'];
				$tgl_awal = strtotime("1 day", strtotime("$tgl_awal"));
				$tgl_awal = date("Y-m-d", $tgl_awal);
				$tgl_awal2 = strtotime("-1 day", strtotime("$tgl_start"));
				$tgl_awal2 = date("Y-m-d", $tgl_awal2);
				if($s['saldo_awal_tanggal'] !== $tgl_awal2){
					$waktu2 = "tanggal_transaksi >= '".$tgl_awal."' AND tanggal_transaksi <= '".$tgl_awal2."'";
					$a = $this->panjar->lipa7($waktu2,'1');
					$saldo_awal += $a;	
					$b = $this->panjar->lipa7($waktu2,'-1');
					$saldo_awal -= $b;	
				}

			}
			else{
				$saldo_awal = 0;
				$this->session->set_flashdata('msg2', '<div class="alert alert-warning text-center">Tidak ditemukan saldo awal BKU sebelum tanggal '.$this->input->post('tgl_start').', saldo awal yang digunakan adalah 0</div>');				
			}
		$trans = $this->mymodel->total_transaksi_bikp($tgl_start,$tgl_finish);
		$trans1 = $this->mymodel->total_transaksi_bikp1($tgl_start,$tgl_finish);
		$trans2 = $this->mymodel->total_transaksi_bikp2($tgl_start,$tgl_finish);
		$saldo_akhir = $saldo_awal+$trans['penerimaan']-$trans['pengeluaran'];
		$saldo_akhir = $saldo_akhir+$trans1['penerimaan']-$trans1['pengeluaran'];
		$saldo_akhir = $saldo_akhir+$trans2['penerimaan']-$trans2['pengeluaran'];
		$penerimaan = $trans['penerimaan'] + $trans2['penerimaan'];
		$pengeluaran = $trans['pengeluaran'] + $trans2['pengeluaran'];
		echo "<p>Saldo Awal Tanggal ".date('d/m/Y', strtotime($tgl_start))." = <b>".number_format($saldo_awal, '0' , ',' , '.')."</b><br>";
		echo "Sub Total Penerimaan : <b>".number_format($penerimaan, '0' , ',' , '.')."</b> ";
		echo "&nbsp; Sub Total Pengeluaran = <b>".number_format($pengeluaran, '0' , ',' , '.')."</b><br> ";
		echo "Saldo Akhir Tanggal ".date('d/m/Y', strtotime($tgl_finish))." = <b>".number_format($saldo_akhir, '0' , ',' , '.')."</b><br> </p>";
	}
	public function bikp_rekap_ajax()
	{
		$tgl = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl'));
		$tgl = date_format($tgl, "Y-m-d");
		$tingkatan = $this->input->post('tingkatan');
		$jenis = $this->input->post('jenis');
		if($tingkatan == 0){
			$a = $this->mymodel->bikp_rekap($tgl,'10',$jenis)->result_array();	
			$b = $this->mymodel->bikp_rekap($tgl,'20',$jenis)->result_array();	
			$c = $this->mymodel->bikp_rekap($tgl,'30',$jenis)->result_array();	
			$d = $this->mymodel->bikp_rekap($tgl,'40',$jenis)->result_array();	
			$data = array_merge($a,$b,$c,$d);
			if($jenis !== 3){
				$e = $this->mymodel->bikp_rekap($tgl,'50',$jenis)->result_array();	
				$f = $this->mymodel->bikp_rekap_ht($tgl)->result_array();	
				$data = array_merge($data,$e,$f);
			}

		}
		else if($tingkatan == 50){
			$e = $this->mymodel->bikp_rekap($tgl,'50',$jenis)->result_array();	
			$f = $this->mymodel->bikp_rekap_ht($tgl)->result_array();	
			$data = array_merge($e,$f);

		}
		else{
			$data = $this->mymodel->bikp_rekap($tgl,$tingkatan,$jenis)->result_array();	
		}
		$no = 0;
		//echo "<table>"
		$d = array();
		foreach($data as $h){
			$row = array();
			$tgl_trans = $h['tanggal_putusan'];
			if($tgl_trans == null || $tgl_trans > $tgl){
				$tgl_cetak = '';
			}
			else{
				$tgl_cetak = date('d-m-Y', strtotime($tgl_trans));
			}
			$no++;
			$row[] = $no;
			$row[] = $tgl_cetak;				
			$row[] = $h['nomor_perkara'];
			$row[] = $h['kd_pjr'];
			$row[] = number_format($h['pjr'], "0" , "," , ".");
			$row[] = number_format($h['pgl'], "0" , "," , ".");
			$row[] = number_format($h['pnj'], "0" , "," , ".");
			$row[] = number_format($h['jst'], "0" , "," , ".");
			$row[] = number_format($h['pst'], "0" , "," , ".");
			$row[] = number_format($h['smp'], "0" , "," , ".");
			$row[] = number_format($h['pbt'], "0" , "," , ".");
			$row[] = number_format($h['krb'], "0" , "," , ".");
			$row[] = number_format($h['atk'], "0" , "," , ".");
			$row[] = number_format($h['mtr'], "0" , "," , ".");
			$row[] = number_format($h['hhk'], "0" , "," , ".");
			$row[] = number_format($h['spjr'], "0" , "," , ".");
			$row[] = number_format($h['pengeluaran'], "0" , "," , ".");
			$row[] = number_format($h['saldo'], "0" , "," , ".");
			$d[] = $row;
		}
		$output= array("data" => $d);
		
		echo json_encode($output);
	}
	public function saldo_rekap_ajax()
	{
		$tgl = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl'));
		$tgl = date_format($tgl, "Y-m-d");
		$tingkatan = $this->input->post('tingkatan');
		$jenis = $this->input->post('jenis');
		if($tingkatan == 0){
			$a = $this->mymodel->bikp_rekap($tgl,'10',$jenis)->result_array();	
			$b = $this->mymodel->bikp_rekap($tgl,'20',$jenis)->result_array();	
			$c = $this->mymodel->bikp_rekap($tgl,'30',$jenis)->result_array();	
			$d = $this->mymodel->bikp_rekap($tgl,'40',$jenis)->result_array();	
			$data = array_merge($a,$b,$c,$d);
			if($jenis !== 3){
				$e = $this->mymodel->bikp_rekap($tgl,'50',$jenis)->result_array();	
				$f = $this->mymodel->bikp_rekap_ht($tgl)->result_array();	
				$data = array_merge($data,$e,$f);
			}

		}
		else if($tingkatan == 50){
			$e = $this->mymodel->bikp_rekap($tgl,'50',$jenis)->result_array();	
			$f = $this->mymodel->bikp_rekap_ht($tgl)->result_array();	
			$data = array_merge($e,$f);

		}
		else{
			$data = $this->mymodel->bikp_rekap($tgl,$tingkatan,$jenis)->result_array();	
		}
		$saldo = 0;
		foreach($data as $h){
				$saldo += $h['saldo'];	
			}
		echo "Saldo Hingga ".$this->input->post('tgl')." = <b>".number_format($saldo, "0" , "," , ".")."</b><br>";
	}
	public function cetak_excel(){
		$sys = $this->mymodel->sys_config();
		require('./assets/phpexcel/PHPExcel/IOFactory.php');
		$objReader = PHPExcel_IOFactory::createReader('Excel5'); 
		$objPHPExcel = $objReader->load("./templates/bukuinduk.xls");
		
		$objPHPExcel->getActiveSheet()->setCellValue('A2', "PADA ".$sys['NamaPN']);
		
		$no=1;
			$index=1;
			$halaman=1;
			$baseRow = 10;
			$row = 10;
		$tgl_start = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_start'));
		$tgl_start = date_format($tgl_start, "Y-m-d");
		$tgl_finish = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_finish'));
		$tgl_finish = date_format($tgl_finish, "Y-m-d");	
		$saldo_awal = $this->mymodel->saldo_bikp_sebelumnya($tgl_start);
		$objPHPExcel->getActiveSheet() 
								->setCellValue('B9', "Saldo Lalu")
								->setCellValue('H9', $saldo_awal)
								->getRowDimension(9)->setRowHeight(25);		
		$styleArray = array(
						'borders' => array(
							'allborders' => array(
								'style' => PHPExcel_Style_Border::BORDER_THIN   
							),
						),
					);
		
		$data = $this->mymodel->list_bkip($tgl_start,$tgl_finish);
			foreach($data->result_array() as $h){
				
				$tgl_trans = $h['tanggal_transaksi'];
				$id_perk = $h['perkara_id'];
				$noperk = $this->mymodel->select_noperk($id_perk);
				
				$jmlpanjar=$this->mymodel->select_jml_panjar($id_perk,$tgl_trans,'1','224');
				$jmlbanding=$this->mymodel->select_jml_panjar($id_perk,$tgl_trans,'2','225');
				$jmlkasasi=$this->mymodel->select_jml_panjar($id_perk,$tgl_trans,'4','226');
				$jmlpk=$this->mymodel->select_jml_panjar($id_perk,$tgl_trans,'6','227');
			$jnspgl = $this->mymodel->select_kode($id_perk,$tgl_trans,'4','-1');
				$jmlpgl = $this->mymodel->select_jumlah($id_perk,$tgl_trans,'4','-1');
				$jmltrjm = $this->mymodel->select_jumlah($id_perk,$tgl_trans,'10','-1');
			$jnssita = $this->mymodel->select_kode($id_perk,$tgl_trans,'5','-1');
			$jmlsita = $this->mymodel->select_jumlah($id_perk,$tgl_trans,'5','-1');
			$jmlps = $this->mymodel->select_jumlah($id_perk,$tgl_trans,'7','-1');
			$jmlsumpah = $this->mymodel->select_jumlah($id_perk,$tgl_trans,'9','-1');
			$jenispbt = $this->mymodel->select_kode($id_perk,$tgl_trans,'6','-1');
			$jmlpbt = $this->mymodel->select_jumlah($id_perk,$tgl_trans,'6','-1');
			$jeniskrm= $this->mymodel->select_kode($id_perk,$tgl_trans,'3','-1');
			$jmlkrm = $this->mymodel->select_jumlah($id_perk,$tgl_trans,'3','-1');
			$jmlproses = $this->mymodel->select_jumlah($id_perk,$tgl_trans,'12','-1');
			$jmllain = $this->mymodel->select_jumlah($id_perk,$tgl_trans,'14','-1');
			$jmlmtr = $this->mymodel->select_jumlah($id_perk,$tgl_trans,'8','-1');
			$jenishhk1 = $this->mymodel->select_kode($id_perk,$tgl_trans,'11','-1');
			$jenishhk2 = $this->mymodel->select_kode($id_perk,$tgl_trans,'13','-1');
			$jenishhk = $jenishhk1.$jenishhk2;
			$hhk1 = $this->mymodel->select_jumlah($id_perk,$tgl_trans,'11','-1');
			$hhk2 = $this->mymodel->select_jumlah($id_perk,$tgl_trans,'13','-1');
			$jmlhhk = $hhk1+$hhk2;
			$jmlpsp = $this->mymodel->select_jumlah($id_perk,$tgl_trans,'2','-1');
				
				$row = $baseRow + $no;
				$objPHPExcel->getActiveSheet() 
								->setCellValue('A'.$row, $index) 
								->setCellValue('B'.$row, $tgl_trans) 
								->setCellValue('C'.$row, $noperk) 
								->setCellValue('D'.$row, $jmlpanjar)
								->setCellValue('E'.$row, $jmlbanding)
								->setCellValue('F'.$row, $jmlkasasi)
								->setCellValue('G'.$row, $jmlpk)
								->setCellValue('I'.$row, "=D".$row."+E".$row."+F".$row."+G".$row)								
								->setCellValue('J'.$row, $jnspgl)
								->setCellValue('K'.$row, $jmlpgl)
								->setCellValue('L'.$row, $jmltrjm)
								->setCellValue('M'.$row, $jnssita)
								->setCellValue('N'.$row, $jmlsita)
								->setCellValue('O'.$row, $jmlps)
								->setCellValue('P'.$row, $jmlsumpah)
								->setCellValue('Q'.$row, $jenispbt)
								->setCellValue('R'.$row, $jmlpbt)
								->setCellValue('S'.$row, $jeniskrm)
								->setCellValue('T'.$row, $jmlkrm)
								->setCellValue('U'.$row, $jmlproses)
								->setCellValue('V'.$row, $jmllain)
								->setCellValue('W'.$row, $jmlmtr)
								->setCellValue('X'.$row, $jenishhk)
								->setCellValue('Y'.$row, $jmlhhk)
								->setCellValue('Z'.$row, $jmlpsp)
								->setCellValue('AA'.$row, "=K".$row."+L".$row."+N".$row."+O".$row."+P".$row."+R".$row."+T".$row."+U".$row."+V".$row."+W".$row."+Y".$row."+Z".$row)
								
								->getRowDimension($row)->setRowHeight(25);
				$jmlbaris=27;
					if($index%$jmlbaris==0){
						$barisdi=$row+1;
						$barispi=$row+2;
						$aa=$jmlbaris+11;
						if($halaman==1){
						$rangeawal=9;
						$rangakhir=$jmlbaris+10;
						$jmlpenerimaan=$rangakhir+1;
						}
						else{
						$rangeawal=10+(($halaman-1)*($jmlbaris+2));
						$rangakhir=($jmlbaris+10)+(($halaman-1)*($jmlbaris+2));
						$aa=($jmlbaris+11)+(($halaman-1)*($jmlbaris+2));
						$jmlpenerimaan=$rangakhir+1;
						}
						$objPHPExcel->getActiveSheet() 
								->setCellValue('B'.$barisdi, "Saldo Dipindahkan")
								->setCellValue('D'.$barisdi, "=SUM(D".$rangeawal.":D".$rangakhir.")")
								->setCellValue('E'.$barisdi, "=SUM(E".$rangeawal.":E".$rangakhir.")")
								->setCellValue('F'.$barisdi, "=SUM(F".$rangeawal.":F".$rangakhir.")")
								->setCellValue('G'.$barisdi, "=SUM(G".$rangeawal.":G".$rangakhir.")")
								->setCellValue('H'.$barisdi, "=SUM(H".$rangeawal.":H".$rangakhir.")")
								->setCellValue('I'.$barisdi, "=SUM(D".$jmlpenerimaan.":H".$jmlpenerimaan.")")
								->setCellValue('K'.$barisdi, "=SUM(K".$rangeawal.":K".$rangakhir.")")
								->setCellValue('L'.$barisdi, "=SUM(L".$rangeawal.":L".$rangakhir.")")
								->setCellValue('N'.$barisdi, "=SUM(N".$rangeawal.":N".$rangakhir.")")
								->setCellValue('O'.$barisdi, "=SUM(O".$rangeawal.":O".$rangakhir.")")
								->setCellValue('P'.$barisdi, "=SUM(P".$rangeawal.":P".$rangakhir.")")
								->setCellValue('R'.$barisdi, "=SUM(R".$rangeawal.":R".$rangakhir.")")
								->setCellValue('T'.$barisdi, "=SUM(T".$rangeawal.":T".$rangakhir.")")
								->setCellValue('U'.$barisdi, "=SUM(U".$rangeawal.":U".$rangakhir.")")
								->setCellValue('V'.$barisdi, "=SUM(V".$rangeawal.":V".$rangakhir.")")
								->setCellValue('W'.$barisdi, "=SUM(W".$rangeawal.":W".$rangakhir.")")
								->setCellValue('Y'.$barisdi, "=SUM(Y".$rangeawal.":Y".$rangakhir.")")
								->setCellValue('Z'.$barisdi, "=SUM(Z".$rangeawal.":Z".$rangakhir.")")
								->setCellValue('AA'.$barisdi, "=SUM(AA".$rangeawal.":AA".$rangakhir.")")
								->getRowDimension($barisdi)->setRowHeight(25) ; 
						$objPHPExcel->getActiveSheet() 
								->setCellValue('B'.$barispi, "Saldo Pindahan")
								->setCellValue('D'.$barispi, "=D".$aa)
								->setCellValue('E'.$barispi, "=E".$aa)
								->setCellValue('F'.$barispi, "=F".$aa)
								->setCellValue('G'.$barispi, "=G".$aa)
								->setCellValue('H'.$barispi, "=H".$aa)
								->setCellValue('I'.$barispi, "=I".$aa)
								->setCellValue('K'.$barispi, "=K".$aa)
								->setCellValue('L'.$barispi, "=L".$aa)
								->setCellValue('N'.$barispi, "=N".$aa)
								->setCellValue('O'.$barispi, "=O".$aa)
								->setCellValue('P'.$barispi, "=P".$aa)
								->setCellValue('R'.$barispi, "=R".$aa)
								->setCellValue('T'.$barispi, "=T".$aa)
								->setCellValue('U'.$barispi, "=U".$aa)
								->setCellValue('V'.$barispi, "=V".$aa)
								->setCellValue('W'.$barispi, "=W".$aa)
								->setCellValue('Y'.$barispi, "=Y".$aa)
								->setCellValue('Z'.$barispi, "=Z".$aa)
								->setCellValue('AA'.$barispi, "=AA".$aa)
								->getRowDimension($barispi)->setRowHeight(25) ; 
					$no=$no+2;
					$halaman++;
					}
					$index++;
					$no++;
					
				}
				//row total
				$row=$row+1; 
				$totalawal=$rangeawal+($jmlbaris+2);
				$totalakhir=$row-1;
				$objPHPExcel->getActiveSheet() 
								->setCellValue('B'.$row, "Saldo Total")
								->setCellValue('D'.$row, "=SUM(D".$totalawal.":D".$totalakhir.")")
								->setCellValue('E'.$row, "=SUM(E".$totalawal.":E".$totalakhir.")")
								->setCellValue('F'.$row, "=SUM(F".$totalawal.":F".$totalakhir.")")
								->setCellValue('G'.$row, "=SUM(G".$totalawal.":G".$totalakhir.")")
								->setCellValue('H'.$row, "=SUM(H".$totalawal.":H".$totalakhir.")")
								->setCellValue('I'.$row, "=SUM(D".$row.":H".$row.")")
								->setCellValue('K'.$row, "=SUM(K".$totalawal.":K".$totalakhir.")")
								->setCellValue('L'.$row, "=SUM(L".$totalawal.":L".$totalakhir.")")
								->setCellValue('N'.$row, "=SUM(N".$totalawal.":N".$totalakhir.")")
								->setCellValue('O'.$row, "=SUM(O".$totalawal.":O".$totalakhir.")")
								->setCellValue('P'.$row, "=SUM(P".$totalawal.":P".$totalakhir.")")
								->setCellValue('R'.$row, "=SUM(R".$totalawal.":R".$totalakhir.")")
								->setCellValue('T'.$row, "=SUM(T".$totalawal.":T".$totalakhir.")")
								->setCellValue('U'.$row, "=SUM(U".$totalawal.":U".$totalakhir.")")
								->setCellValue('V'.$row, "=SUM(V".$totalawal.":V".$totalakhir.")")
								->setCellValue('W'.$row, "=SUM(W".$totalawal.":W".$totalakhir.")")
								->setCellValue('Y'.$row, "=SUM(Y".$totalawal.":Y".$totalakhir.")")
								->setCellValue('Z'.$row, "=SUM(Z".$totalawal.":Z".$totalakhir.")")
								->setCellValue('AA'.$row, "=SUM(AA".$totalawal.":AA".$totalakhir.")")
								->getRowDimension($row)->setRowHeight(25) ; 
				$totalrow=$row;
				//end row total
				
				IF($no<>1)
				{ 
				$objPHPExcel->getActiveSheet()->getStyle('A9:AB'.@$row)->applyFromArray($styleArray);
				}
				$row=$row+3;				
				
			
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		$file='assets/hasil/laporan.xlsx';
		$objWriter->save($file);
		echo "<a class='mb-2 btn btn-success mr-2' target='_blank'  href=".site_url().$file.">Download File Laporan</a>";
	}
	
	
	public function export_ringkas(){
		$sys = $this->mymodel->sys_config();
		$this->load->model('keuangan/panjar');
		require('./assets/phpexcel/PHPExcel/IOFactory.php');
		$objReader = PHPExcel_IOFactory::createReader('Excel5'); 
		$objPHPExcel = $objReader->load("./templates/bikp_ringkas.xls");
		
		$objPHPExcel->getActiveSheet()->setCellValue('A2', "PADA ".$sys['NamaPN']);
		
		$no=1;
			$index=1;
			$halaman=1;
			$baseRow = 10;
			$row = 10;
		$bold = array('font' => array('bold' => true));					
		$styleArray = array(
						'borders' => array(
							'allborders' => array(
								'style' => PHPExcel_Style_Border::BORDER_THIN   
							),
						),
					);
		$tgl_start = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_start'));
		$tgl_start = date_format($tgl_start, "Y-m-d");
		$tgl_finish = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_finish'));
		$tgl_finish = date_format($tgl_finish, "Y-m-d");			
		$data = $this->mymodel->bikp_ringkas($tgl_start,$tgl_finish);
		//$saldo_awal = $this->mymodel->saldo_bikp_sebelumnya($tgl_start);
		$s = $this->panjar->saldo_awal_bku($tgl_start)->row_array();
		if($s > 0){
			$saldo_awal = $s['saldo_awal_panjar_pa']+$s['saldo_awal_spj_pa']+$s['saldo_awal_panjar_banding']+$s['saldo_awal_spj_banding']+$s['saldo_awal_panjar_kasasi']+$s['saldo_awal_spj_kasasi']+$s['saldo_awal_panjar_pk']+$s['saldo_awal_spj_pk']+$s['saldo_awal_panjar_eksekusi']+$s['saldo_awal_spj_eksekusi']+$s['saldo_awal_panjar_konsignasi'];
				$tgl_awal = $s['saldo_awal_tanggal'];
				$tgl_awal = strtotime("1 day", strtotime("$tgl_awal"));
				$tgl_awal = date("Y-m-d", $tgl_awal);
				$tgl_awal2 = strtotime("-1 day", strtotime("$tgl_start"));
				$tgl_awal2 = date("Y-m-d", $tgl_awal2);
				if($s['saldo_awal_tanggal'] !== $tgl_awal2){
					$waktu2 = "tanggal_transaksi >= '".$tgl_awal."' AND tanggal_transaksi <= '".$tgl_awal2."'";
					$a = $this->panjar->lipa7($waktu2,'1');
					$saldo_awal += $a;	
					$b = $this->panjar->lipa7($waktu2,'-1');
					$saldo_awal -= $b;	
				}

			}
			else{
				$saldo_awal = 0;		
			}
			foreach($data as $h){
				$tgl_trans = $h['tanggal_transaksi'];
				$jns_panjar = '';
					if($h['tahapan_id'] < 20){
						$jns_panjar = 'Tk. Pertama';
					}
					else if($h['tahapan_id'] == 20){
						$jns_panjar = 'Tk. Banding';
					}
					else if($h['tahapan_id'] == 30){
						$jns_panjar = 'Tk. Kasasi';
					}
					else if($h['tahapan_id'] == 40){
						$jns_panjar = 'Tk. PK';
					}
					else if($h['tahapan_id'] == 50){
						$jns_panjar = 'Tk. EKSEKUSI';
					}
					else if($h['tahapan_id'] == 51){
						$jns_panjar = 'Tk. EKSEKUSI';
					}
					else if($h['tahapan_id'] == 60){
						$jns_panjar = 'Konsignasi';
					}
				$jml_pengeluaran = $h['pgl']+$h['pnj']+$h['jst']+$h['pst']+$h['smp']+$h['pbt']+$h['krb']+$h['atk']+$h['mtr']+$h['hhk']+$h['eks']+$h['spjr'];
				$row = $baseRow + $no;
				$objPHPExcel->getActiveSheet() 
								->setCellValue('B'.$baseRow, "Saldo Awal")
								->setCellValue('D'.$baseRow, $saldo_awal)
								->getRowDimension($row)->setRowHeight(25);
				$objPHPExcel->getActiveSheet()->getStyle('A'.$baseRow.':S'.$baseRow)->applyFromArray($bold);
				$objPHPExcel->getActiveSheet() 
								->setCellValue('A'.$row, $index) 
								->setCellValue('B'.$row, $tgl_trans) 
								->setCellValue('C'.$row, $h['nomor_perkara']) 
								->setCellValue('D'.$row, $jns_panjar)
								->setCellValue('E'.$row, $h['pjr'])
								->setCellValue('F'.$row, $h['pgl'])
								->setCellValue('G'.$row, $h['pnj'])
								->setCellValue('H'.$row, $h['jst'])
								->setCellValue('I'.$row, $h['pst'])
								->setCellValue('J'.$row, $h['smp'])
								->setCellValue('K'.$row, $h['pbt'])
								->setCellValue('L'.$row, $h['krb'])
								->setCellValue('M'.$row, $h['atk'])
								->setCellValue('N'.$row, $h['mtr'])
								->setCellValue('O'.$row, $h['hhk'])
								->setCellValue('P'.$row, $h['eks'])
								->setCellValue('Q'.$row, $h['spjr'])
								->setCellValue('R'.$row, $jml_pengeluaran)
								->getRowDimension($row)->setRowHeight(25);				
					$index++;
					$no++;
					
				}
				//row total
				$row=$row+1; 
				$totalawal=$baseRow+1;
				$totalakhir=$row-1;
				$objPHPExcel->getActiveSheet() 
								->setCellValue('B'.$row, "Sub Total")
								->setCellValue('E'.$row, "=SUM(E".$totalawal.":E".$totalakhir.")")
								->setCellValue('F'.$row, "=SUM(F".$totalawal.":F".$totalakhir.")")
								->setCellValue('G'.$row, "=SUM(G".$totalawal.":G".$totalakhir.")")
								->setCellValue('H'.$row, "=SUM(H".$totalawal.":H".$totalakhir.")")
								->setCellValue('I'.$row, "=SUM(I".$totalawal.":I".$totalakhir.")")
								->setCellValue('J'.$row, "=SUM(J".$totalawal.":J".$totalakhir.")")
								->setCellValue('K'.$row, "=SUM(K".$totalawal.":K".$totalakhir.")")
								->setCellValue('L'.$row, "=SUM(L".$totalawal.":L".$totalakhir.")")
								->setCellValue('M'.$row, "=SUM(M".$totalawal.":M".$totalakhir.")")
								->setCellValue('N'.$row, "=SUM(N".$totalawal.":N".$totalakhir.")")
								->setCellValue('O'.$row, "=SUM(O".$totalawal.":O".$totalakhir.")")
								->setCellValue('P'.$row, "=SUM(P".$totalawal.":P".$totalakhir.")")
								->setCellValue('Q'.$row, "=SUM(Q".$totalawal.":Q".$totalakhir.")")
								->setCellValue('R'.$row, "=SUM(R".$totalawal.":R".$totalakhir.")")
								->getRowDimension($row)->setRowHeight(25) ; 
				$totalrow=$row;
				//end row total
				$row=$row+1; 
				$totalakhir=$row-1;
				$objPHPExcel->getActiveSheet() 
								->setCellValue('B'.$row, "Saldo Akhir")
								->setCellValue('E'.$row, "=D".$baseRow."+E".$totalakhir."-R".$totalakhir)
								->getRowDimension($row)->setRowHeight(25) ; 
				$totalrow=$row;
				//end row total
				
				$objPHPExcel->getActiveSheet()->getStyle('A'.$row.':S'.$row)->applyFromArray($bold);
				IF($no<>1)
				{ 
				$objPHPExcel->getActiveSheet()->getStyle('A9:S'.@$row)->applyFromArray($styleArray);
				}
				$row=$row+3;				
				
			
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		$file='assets/hasil/bikp_ringkas_'.date("d-m-Y").'.xlsx';
		$objWriter->save($file);
		echo "<a class='mb-2 btn btn-success mr-2' target='_blank'  href=".site_url().$file.">Download File Laporan</a>";
	}
	
	public function excel_rekap(){
		$sys = $this->mymodel->sys_config();
		require('./assets/phpexcel/PHPExcel/IOFactory.php');
		$objReader = PHPExcel_IOFactory::createReader('Excel5'); 
		$objPHPExcel = $objReader->load("./templates/bikp_rekap.xls");		
		$jenis = $this->input->post('jenis');
		$tingkatan = $this->input->post('tingkatan');
		switch($tingkatan){
			case 0: 
			$jdul_tingkatan = "REKAP KEUANGAN PANJAR PERKARA ";break;
			case 1: 
			$jdul_tingkatan = "REKAP KEUANGAN PANJAR PERKARA TINGKAT PERTAMA ";break;
			case 20: 
			$jdul_tingkatan = "REKAP KEUANGAN PANJAR PERKARA TINGKAT BANDING ";break;
			case 30: 
			$jdul_tingkatan = "REKAP KEUANGAN PANJAR PERKARA TINGKAT KASASI ";break;
			case 40: 
			$jdul_tingkatan = "REKAP KEUANGAN PANJAR PERKARA TINGKAT PK ";break;
			case 50: 
			$jdul_tingkatan = "REKAP KEUANGAN PANJAR PERKARA TINGKAT EKSEKUSI ";break;
		}
		switch($jenis){
			case 1: 
			$jdul_jenis = "";break;
			case 2: 
			$jdul_jenis = "BERJALAN";break;
			case 3: 
			$jdul_jenis = "PUTUS BERSALDO";break;
		}			
		$objPHPExcel->getActiveSheet()->setCellValue('A1', $jdul_tingkatan." ".$jdul_jenis);
		$objPHPExcel->getActiveSheet()->setCellValue('A2', "PADA ".$sys['NamaPN']);
		$no=1;
			$index=1;
			$halaman=1;
			$baseRow = 10;
			$row = 10;
			
		$styleArray = array(
						'borders' => array(
							'allborders' => array(
								'style' => PHPExcel_Style_Border::BORDER_THIN   
							),
						),
					);
		$tgl = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl'));
		$tgl = date_format($tgl, "Y-m-d");
		if($tingkatan == 0){
			$a = $this->mymodel->bikp_rekap($tgl,'10',$jenis)->result_array();	
			$b = $this->mymodel->bikp_rekap($tgl,'20',$jenis)->result_array();	
			$c = $this->mymodel->bikp_rekap($tgl,'30',$jenis)->result_array();	
			$d = $this->mymodel->bikp_rekap($tgl,'40',$jenis)->result_array();	
			$data = array_merge($a,$b,$c,$d);
			if($jenis !== 3){
				$e = $this->mymodel->bikp_rekap($tgl,'50',$jenis)->result_array();	
				$f = $this->mymodel->bikp_rekap_ht($tgl)->result_array();	
				$data = array_merge($data,$e,$f);
			}

		}
		else if($tingkatan == 50){
			$e = $this->mymodel->bikp_rekap($tgl,'50',$jenis)->result_array();	
			$f = $this->mymodel->bikp_rekap_ht($tgl)->result_array();	
			$data = array_merge($e,$f);

		}
		else{
			$data = $this->mymodel->bikp_rekap($tgl,$tingkatan,$jenis)->result_array();	
		}
			foreach($data as $h){
				
				$tgl_trans = $h['tanggal_putusan'];
				$noperk = $h['tanggal_putusan'];
				
				$row = $baseRow + $no;
				$objPHPExcel->getActiveSheet() 
								->setCellValue('A'.$row, $index) 
								->setCellValue('B'.$row, $h['tanggal_putusan']) 
								->setCellValue('C'.$row, $h['nomor_perkara']) 
								->setCellValue('D'.$row, $h['kd_pjr'])
								->setCellValue('E'.$row, $h['pjr'])
								->setCellValue('F'.$row, $h['pgl'])
								->setCellValue('G'.$row, $h['pnj'])
								->setCellValue('H'.$row, $h['jst'])
								->setCellValue('I'.$row, $h['pst'])
								->setCellValue('J'.$row, $h['smp'])
								->setCellValue('K'.$row, $h['pbt'])
								->setCellValue('L'.$row, $h['krb'])
								->setCellValue('M'.$row, $h['atk'])
								->setCellValue('N'.$row, $h['mtr'])
								->setCellValue('O'.$row, $h['hhk'])
								->setCellValue('P'.$row, $h['spjr'])
								->setCellValue('Q'.$row, $h['pengeluaran'])
								->setCellValue('R'.$row, $h['saldo'])
								->getRowDimension($row)->setRowHeight(25);
				
					$index++;
					$no++;
					
				}
				//row total
				$row=$row+1; 
				$totalawal=$baseRow+1;
				$totalakhir=$row-1;
				$objPHPExcel->getActiveSheet() 
								->setCellValue('B'.$row, "Saldo Total")
								->setCellValue('E'.$row, "=SUM(E".$totalawal.":E".$totalakhir.")")
								->setCellValue('F'.$row, "=SUM(F".$totalawal.":F".$totalakhir.")")
								->setCellValue('G'.$row, "=SUM(G".$totalawal.":G".$totalakhir.")")
								->setCellValue('H'.$row, "=SUM(H".$totalawal.":H".$totalakhir.")")
								->setCellValue('I'.$row, "=SUM(I".$totalawal.":I".$totalakhir.")")
								->setCellValue('J'.$row, "=SUM(J".$totalawal.":J".$totalakhir.")")
								->setCellValue('K'.$row, "=SUM(K".$totalawal.":K".$totalakhir.")")
								->setCellValue('L'.$row, "=SUM(L".$totalawal.":L".$totalakhir.")")
								->setCellValue('M'.$row, "=SUM(M".$totalawal.":M".$totalakhir.")")
								->setCellValue('N'.$row, "=SUM(N".$totalawal.":N".$totalakhir.")")
								->setCellValue('O'.$row, "=SUM(O".$totalawal.":O".$totalakhir.")")
								->setCellValue('P'.$row, "=SUM(P".$totalawal.":P".$totalakhir.")")
								->setCellValue('Q'.$row, "=SUM(Q".$totalawal.":Q".$totalakhir.")")
								->setCellValue('R'.$row, "=SUM(R".$totalawal.":R".$totalakhir.")")
								->getRowDimension($row)->setRowHeight(25) ; 
				$totalrow=$row;
				//end row total
				
				IF($no<>1)
				{ 
				$objPHPExcel->getActiveSheet()->getStyle('A9:R'.@$row)->applyFromArray($styleArray);
				}
				$row=$row+3;				
				
			
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		$file='assets/hasil/bikp_rekap_'.date("d-m-Y").'.xlsx';
		$objWriter->save($file);
		echo "<a class='mb-2 btn btn-success mr-2' target='_blank'  href=".site_url().$file.">Download File Laporan</a>";
	}
	
	public function bku(){
		$tgl_start = '2018-01-02';
		$tgl_finish = '2018-01-02';
		$q = $this->mymodel->transaksi_bytanggal($tgl_start,$tgl_finish);
		$data['tgl_start'] = $tgl_start;
		$data['tgl_finish'] = $tgl_finish;
		$data['list_transaksi'] = $q;
		
		$this->load->view('keuangan/page/header');
		$this->load->view('keuangan/template/buku_bantu',$data);
		$this->load->view('keuangan/page/footer');
		//echo "<pre>";
		//print_r($q->result_array());
		//echo "</pre>";
	}
	public function haha(){
		$tgl_start = '2018-01-02';
		$tgl_finish = '2018-01-31';
		$sys = $this->mymodel->sys_config();
		$data = $this->mymodel->bikp_ringkas('2019-03-01','2019-03-31');
		echo "<pre>";
		print_r($data);
		echo "</pre>";
	}
}
