<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Register extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->model('register_model', '', TRUE);
	}
	function tanggal_kosong($tanggal='')
	{
		if($tanggal=='' OR $tanggal=='00 0000')
		{
			$tanggal='-';
		}
		return $tanggal;
	}
	function index()
	{
		$this->is_login();
		$this->load->helper('form');
		$this->install_db_versi_1();
		
		$sys			= $this->register_model->sys_config();
		$data['NamaPN'] = $sys['NamaPN'];
		$data['title']  = "Dasboard e-Register ";
		
		$tahun_perkara = date("Y");
		$bulan_perkara = date("m");
		$blnlalu		= intval($bulan_perkara - 1);
		$blndepan	  = intval($bulan_perkara + 1);
		if(strlen($blnlalu) == 1)
			$blnlalu = '0' . $blnlalu;
		if(strlen($bulan_perkara) == 1)
			$bulan_perkara = '0' . $bulan_perkara;
		if(strlen($blndepan) == 1)
			$blndepan = '0' . $blndepan;
		
		$bulanlalu  = $tahun_perkara . '-' . $blnlalu;
		$tahunlalu  = $tahun_perkara;
		$bulanini   = $tahun_perkara . '-' . $bulan_perkara;
		$tahunini   = $tahun_perkara;
		$bulandepan = $tahun_perkara . '-' . $blndepan;
		$tahundepan = $tahun_perkara;
		if($bulan_perkara == 12){
			$blndepan   = 1;
			$tahundepan = intval($tahun_perkara + 1);
			$bulandepan = $tahundepan . '-01';
		}
		if($bulan_perkara == '01'){
			$blnlalu   = 12;
			$tahunlalu = intval($tahun_perkara - 1);
			$bulanlalu = $tahunlalu . '-12';
		}
		
		$data['tahun_perkara'] = $this->register_model->tahun_perkara();
		
		
		$data['tahun_terpilih'] = $tahun_perkara;
		$data['bulan_terpilih'] = $bulan_perkara;
		$data['bulanini']		= $bulanini;
		$data['bulandepan']	 = $bulandepan;
		$data['nama_bulan']	 = array(
			'00' => 'Semua Bulan',
			'01' => 'Januari',
			'02' => 'Februari',
			'03' => 'Maret',
			'04' => 'April',
			'05' => 'Mei',
			'06' => 'Juni',
			'07' => 'Juli',
			'08' => 'Agustus',
			'09' => 'September',
			'10' => 'Oktober',
			'11' => 'November',
			'12' => 'Desember'
		);
		
		$this->load->vars($data);
		$this->load->view('register/register_header');
		$this->load->view('register/register_index');
		$this->load->view('register/register_footer');
	}
	function statistik_perkara()
	{
		$tahun_perkara = $this->input->post('tahun');
		$bulan_perkara = $this->input->post('bulan');
		
		$blndepan = intval($bulan_perkara + 1);
		if(strlen($bulan_perkara) == 1)
			$bulan_perkara = '0' . $bulan_perkara;
		if(strlen($blndepan) == 1)
			$blndepan = '0' . $blndepan;
		
		$tahunlalu  = $tahun_perkara;
		$bulanini   = $tahun_perkara . '-' . $bulan_perkara;
		$tahunini   = $tahun_perkara;
		$bulandepan = $tahun_perkara . '-' . $blndepan;
		$tahundepan = $tahun_perkara;
		if($bulan_perkara == 12){
			$blndepan   = 1;
			$tahundepan = intval($tahun_perkara + 1);
			$bulandepan = $tahundepan . '-01';
		}
		
		
		if($bulan_perkara == '00'){
			$data['data_keyindikator'] = $this->register_model->get_data_indikator_tahunan($tahun_perkara);
		} else{
			$data['data_keyindikator'] = $this->register_model->get_data_indikator($bulanini, $bulandepan);
		}
		$this->load->view('register/register_statistik_perkara', $data);
	}
	function statistik_register()
	{
		$tahun = $this->input->post('tahun');
		$bulan = $this->input->post('bulan');
		
		if($bulan == '00'){
			$jml_karakter			 = 4;
			$periode					= $tahun;
			$data['data_keyindikator'] = $this->register_model->get_data_register($periode, $jml_karakter);
		} else{
			$jml_karakter			 = 7;
			$periode					= $tahun . '-' . $bulan;
			$data['data_keyindikator'] = $this->register_model->get_data_register($periode, $jml_karakter);
		}
		$data['bulan']=(int)$bulan;
		$data['bulan']=$bulan;
		$data['tahun']=(int)$tahun;
		$this->load->view('register/register_statistik_register', $data);
	}
	function penutupan_register_bulanan()
	{
		$this->is_login(); 
		$data['title'] ="Penutupan Register Bulanan";$sys					  = $this->register_model->sys_config();
		$data['NamaPN']		   = $sys['NamaPN'];
 		$tahun_perkara = date("Y");
		$bulan_perkara = date("m");
		$data['nama_bulan']	 = array( 
			'01' => 'Januari',
			'02' => 'Februari',
			'03' => 'Maret',
			'04' => 'April',
			'05' => 'Mei',
			'06' => 'Juni',
			'07' => 'Juli',
			'08' => 'Agustus',
			'09' => 'September',
			'10' => 'Oktober',
			'11' => 'November',
			'12' => 'Desember'
		);
		$data['tahun_terpilih'] = $tahun_perkara;
		$data['bulan_terpilih'] = $bulan_perkara;
		$data['tahun_perkara'] = $this->register_model->tahun_perkara();
		$kriteria		 = "aktif='y' AND id IN (1,2,11) ";
		$data['register'] = $this->register_model->get_data_where1($kriteria, 'register_m_jenis_register', '-');

		$kriteria		 = " id=200 ";
		$data_petugas = $this->register_model->get_data_where1($kriteria, 'register_config', '-');
		//var_dump($data_petugas);
		$data['petugas']=$data_petugas[0]->value;
		//$data['panitera']=$this->register_model->get_data_where1("aktif='Y'","panitera_pn", $jenisdb);
		//$data['validasi'] =$this->register_model->validasi_data();
		$this->load->view('register/register_header', $data);
		$this->load->view('register/register_penutupan_bulanan');
		$this->load->view('register/register_footer');
	}
	function data_penutupan_register_bulanan_json()
	{
		$datane = $this->register_model->get_data_order('register_penutupan_bulanan','tahun DESC, bulan ASC, jenis_register_id ASC');
		$data		= array();
		$no		 = 0; 
		foreach ($datane as $row){
			$no++;
			$sub_array   = array();
			$sub_array['id'] =$row->id;
			$sub_array['no'] =$no;

			$sub_array['jenis_register_nama'] =$row->jenis_register_nama;
			$sub_array['bulan'] =$this->bulan_nama($row->bulan);
			$sub_array['tahun'] =$row->tahun;
			$sub_array['tanggal_penutupan'] =$this->tanggal_indonesia($row->tanggal_penutupan);
			$sub_array['sisa_bulan_lalu'] =$row->sisa_bulan_lalu; 
			$sub_array['masuk_bulan_ini'] =$row->masuk_bulan_ini; 
			$sub_array['putus_bulan_ini'] =$row->putus_bulan_ini; 
			$sub_array['sisa_bulan_ini'] =$row->sisa_bulan_ini; 
			$sub_array['petugas_register'] =$row->petugas_register;
			$sub_array['keterangan'] =$row->keterangan; 
			$sub_array['tombol'] ='<center><i style="cursor:pointer" title="detail" onclick="detail_penutupan_bulanan(' . $row->id . ')" class="success glyphicon glyphicon-eye-open"> </i></center>';
			$data[]=$sub_array;
		}
		$output = array(
			"data" => $data
		);
		echo json_encode($output);
	}
	function data_penutupan_bulanan()
	{
		$id 	=$this->input->post('id');
		$kriteria=" id=$id ";
		$datane = $this->register_model->get_data_where1($kriteria, 'register_penutupan_bulanan', '-');
		$data['id']=$datane[0]->id;
		$data['jenis_register_id']=$datane[0]->jenis_register_id;
		$data['jenis_register_nama']=$datane[0]->jenis_register_nama;
		$data['bulan']=$datane[0]->bulan;
		$data['tahun']=$datane[0]->tahun;
		$data['tanggal_penutupan']=$datane[0]->tanggal_penutupan;
		$data['sisa_bulan_lalu']=$datane[0]->sisa_bulan_lalu;
		$data['sisa_bulan_lalu_daftar']=$datane[0]->sisa_bulan_lalu_daftar;
		$data['masuk_bulan_ini']=$datane[0]->masuk_bulan_ini;
		$data['masuk_bulan_ini_daftar']=$datane[0]->masuk_bulan_ini_daftar;
		$data['putus_bulan_ini']=$datane[0]->putus_bulan_ini;
		$data['putus_bulan_ini_daftar']=$datane[0]->putus_bulan_ini_daftar;
		$data['sisa_bulan_ini']=$datane[0]->sisa_bulan_ini;
		$data['sisa_bulan_ini_daftar']=$datane[0]->sisa_bulan_ini_daftar;
		$data['petugas_register']=$datane[0]->petugas_register;
		$data['keterangan']=$datane[0]->keterangan;
		echo json_encode($data);
	}
	function hitung_data_penutupan_bulanan()
	{
		$bulan 				=$this->input->post('bulan');
		$tahun 				=$this->input->post('tahun');
		$tanggal_penutupan	=$this->input->post('tanggal_penutupan');
		$jenis_register_id	=$this->input->post('jenis_register_id');
		if($tanggal_penutupan>date("Y-m-d"))
		{
			echo "Error";
			exit;
		}
		if($jenis_register_id==1)
		{
			$alur_perkara_id=16;
		}else
		if($jenis_register_id==2)
		{
			$alur_perkara_id=15;
		}else
		if($jenis_register_id==11)
		{
			$alur_perkara_id=122;
		}
		//sisa lalu
		$data['sisa_bulan_lalu']=$this->register_model->sisa_lalu($alur_perkara_id,'bulanan',$bulan, $tahun);
		//masuk bulan ini
		$kriteria=" alur_perkara_id=$alur_perkara_id AND  LEFT (tanggal_pendaftaran,7)='".$tahun."-".$bulan."' AND tanggal_pendaftaran<='$tanggal_penutupan'";
		$data['masuk_bulan_ini']=$this->register_model->get_all_data_where_sipp('perkara',$kriteria);
		//putus bulan ini 
		$data['putus_bulan_ini']=$this->register_model->jumlah_putus($alur_perkara_id,'bulanan',$bulan, $tahun,$tanggal_penutupan);
		//sisa perkara bulan ini 
		$data['sisa_bulan_ini']=$this->register_model->jumlah_sisa_perkara($alur_perkara_id,'bulanan',$bulan, $tahun,$tanggal_penutupan);
		
		echo json_encode($data);
	}
	function simpan_data_penutupan_bulanan()
	{
		$id 						=$this->input->post('id');
		$data['petugas_register'] 				=$this->input->post('petugas');
		$data['bulan'] 				=$this->input->post('bulan');
		$data['tahun'] 				=$this->input->post('tahun');
		$data['tanggal_penutupan']	=$this->input->post('tanggal_penutupan');
		$data['jenis_register_id']	=$this->input->post('jenis_register_id');
		$data['sisa_bulan_lalu']	=$this->input->post('sisa_bulan_lalu');
		$data['masuk_bulan_ini']	=$this->input->post('masuk_bulan_ini');
		$data['putus_bulan_ini']	=$this->input->post('putus_bulan_ini');
		$data['sisa_bulan_ini']	=$this->input->post('sisa_bulan_ini');
		$data['keterangan']	=$this->input->post('keterangan');
		$informasi_register = $this->register_model->get_data_where('id=' . $this->input->post('jenis_register_id'), 'register_m_jenis_register', '-');
		$data['jenis_register_nama']	=$informasi_register['register_nama'];
		if($id=='')
		{
			$simpan = $this->register_model->insert_data('register_penutupan_bulanan', $data);
		}else
		{
			$whereconditon = "id=".$id;
			$simpan = $this->register_model->update_data($whereconditon,'register_penutupan_bulanan',$data);
		}
	}
	function hapus_data_penutupan_bulanan()
	{
		$id 						=$this->input->post('id');
		$tableName	 = 'register_penutupan_bulanan';
		$whereconditon = " id=$id ";
		$this->register_model->delete_data($whereconditon, $tableName);
	}
	function cetak_penutupan_register_bulanan($id)
	{
		$kriteria=" id=$id ";
		$datane = $this->register_model->get_data_where1($kriteria, 'register_penutupan_bulanan', '-');
		
		$datanya="<p align='center'><b>PENUTUPAN REGISTER<br>".strtoupper($datane[0]->jenis_register_nama)."<br> BULAN ".strtoupper($this->bulan_nama($datane[0]->bulan))." ".$datane[0]->tahun."</b></p><br><br>
				<p align='justify'>Pada hari ini ".$this->nama_hari($datane[0]->tanggal_penutupan)." tanggal ".$this->tanggal_indonesia($datane[0]->tanggal_penutupan)." ".$datane[0]->jenis_register_nama." ditutup dengan keadaan : </p>
				<table style='border:none' cellpadding='10' cellspacing='10'>
					<tr>
						<td style='border:none;margin:8px'>Sisa Bulan Lalu </td>
						<td style='border:none;margin:8px''>:</td>
						<td style='border:none;text-align:right;margin:8px'>".$datane[0]->sisa_bulan_lalu." perkara</td>
					</tr>
					<tr>
						<td style='border:none;margin:8px'>Masuk Bulan ini </td>
						<td style='border:none;margin:8px'>:</td>
						<td style='border:none;text-align:right;margin:8px'>".$datane[0]->masuk_bulan_ini." perkara</td>
					</tr>
					<tr>
						<td style='border:none;margin:8px'>Putus Bulan ini </td>
						<td style='border:none;margin:8px'>:</td>
						<td style='border:none;text-align:right;margin:8px'>".$datane[0]->putus_bulan_ini." perkara</td>
					</tr>
					<tr>
						<td style='border:none;margin:8px'>Sisa Bulan ini </td>
						<td style='border:none;margin:8px'>:</td>
						<td style='border:none;text-align:right;margin:8px'>".$datane[0]->sisa_bulan_ini." perkara</td>
					</tr>
				</table>
				<p>".$datane[0]->keterangan."</p><br><br>
				<table style='border:none;width:100%'>
					<tr>
						<td style='border:none;width:50%'></td><td style='border:none;width:50%'>Petugas Register<br><br><br><br><br>".$datane[0]->petugas_register."</td> 
					</tr> 
				</table>
				";
		$data['isi']=$datanya;
		$data['cetak'] = 1;
		$data['nama_file']="Penutupan " .$datane[0]->jenis_register_nama." ".$this->bulan_nama($datane[0]->bulan)." ".$datane[0]->tahun ;
		
		
		
		$this->load->view('register/register_cetak_html', $data);
	}
	function penutupan_register_tahunan()
	{
		$this->is_login(); 
		$data['title'] ="Penutupan Register Tahunan";
 		$sys					  = $this->register_model->sys_config();
		$data['NamaPN']		   = $sys['NamaPN'];
			$tahun_perkara = date("Y");
		$bulan_perkara = date("m");
		$data['nama_bulan']	 = array( 
			'01' => 'Januari',
			'02' => 'Februari',
			'03' => 'Maret',
			'04' => 'April',
			'05' => 'Mei',
			'06' => 'Juni',
			'07' => 'Juli',
			'08' => 'Agustus',
			'09' => 'September',
			'10' => 'Oktober',
			'11' => 'November',
			'12' => 'Desember'
		);
		$data['tahun_terpilih'] = $tahun_perkara;
		$data['bulan_terpilih'] = $bulan_perkara;
		$data['tahun_perkara'] = $this->register_model->tahun_perkara();
		$kriteria		 = "aktif='y' AND id IN(1,2,3,4,5,11)  ";
		$data['register'] = $this->register_model->get_data_where1($kriteria, 'register_m_jenis_register', '-');

		//pejabat66,67, 68,, 99
		$kriteria_ketua= " id IN (64, 93, 97)  AND value<>'' ";
		$data['ketua'] = $this->register_model->get_data_where1($kriteria_ketua, 'sys_config', 'dbsipp');
		$kriteria_panitera= " id IN (68, 95, 99)  AND value<>'' ";
		$data['panitera'] = $this->register_model->get_data_where1($kriteria_panitera, 'sys_config', 'dbsipp');
		 
		//pejabat
		//$data['validasi'] =$this->register_model->validasi_data();
		$this->load->view('register/register_header', $data);
		$this->load->view('register/register_penutupan_tahunan');
		$this->load->view('register/register_footer');
	}

	function hitung_data_penutupan_tahunan()
	{
		$tahun 				=$this->input->post('tahun');
		$tanggal_penutupan	=$this->input->post('tanggal_penutupan');
		$jenis_register_id	=$this->input->post('jenis_register_id');
		if($tanggal_penutupan>date("Y-m-d"))
		{
			echo "Error";
			exit;
		}

		$bulan='01';
		if($jenis_register_id==1 OR $jenis_register_id==2 OR $jenis_register_id==11)
		{	
			if($jenis_register_id==1)
			{
				$alur_perkara_id=16;
			}else
			if($jenis_register_id==2)
			{
				$alur_perkara_id=15;
			}else
			if($jenis_register_id==11)
			{
				$alur_perkara_id=122;
			}
			//sisa lalu
			$data['sisa_tahun_lalu']=$this->register_model->sisa_lalu($alur_perkara_id,'tahunan',$bulan, $tahun);
			//masuk bulan ini
			$kriteria=" alur_perkara_id=$alur_perkara_id AND  LEFT (tanggal_pendaftaran,4)='".$tahun."'";
			$data['masuk_tahun_ini']=$this->register_model->get_all_data_where_sipp('perkara',$kriteria);
			//putus bulan ini 
			$data['putus_tahun_ini']=$this->register_model->jumlah_putus($alur_perkara_id,'tahunan',$bulan, $tahun);
			//sisa perkara bulan ini 
			$data['sisa_tahun_ini']=$this->register_model->jumlah_sisa_perkara($alur_perkara_id,'tahun',$bulan, $tahun,$tanggal_penutupan);
			$data['sisa_tahun_ini_sudah_dikirim']='';
			$data['sisa_tahun_ini_belum_dikirim']='';
		}else
		if($jenis_register_id==3 OR $jenis_register_id==4 OR $jenis_register_id==5 )
		{
			if($jenis_register_id==3){$upaya='banding';}
			if($jenis_register_id==4){$upaya='kasasi';}
			if($jenis_register_id==5){$upaya='pk';}
			//sisa lalu
			$data['sisa_tahun_lalu']=$this->register_model->sisa_lalu_upaya_hukum($upaya,'tahunan',$bulan, $tahun);
			//masuk bulan ini
			$tanggal_pendaftaran_upaya_hukum="permohonan_".$upaya;
			$nama_tabel='perkara_'.$upaya;
			$kriteria_masuk="LEFT ($tanggal_pendaftaran_upaya_hukum,4)='".$tahun."' AND $tanggal_pendaftaran_upaya_hukum <= '".$tanggal_penutupan."'";
			$data['masuk_tahun_ini']=$this->register_model->get_all_data_where_sipp($nama_tabel,$kriteria_masuk);
			//putus bulan ini 
			$data['putus_tahun_ini']=$this->register_model->jumlah_putus_upaya_hukum($upaya,'tahunan',$bulan, $tahun, $tanggal_penutupan);
			//sisa perkara bulan ini 
			$data['sisa_tahun_ini']=$this->register_model->jumlah_sisa_perkara_upaya_hukum($upaya,'tahun',$bulan, $tahun,$tanggal_penutupan);
			$data['sisa_tahun_ini_sudah_dikirim']=$this->register_model->jumlah_sisa_perkara_upaya_hukum_sudah_dikirim($upaya,'tahun',$bulan, $tahun,$tanggal_penutupan);
			$data['sisa_tahun_ini_belum_dikirim']=$this->register_model->jumlah_sisa_perkara_upaya_hukum_belum_dikirim($upaya,'tahun',$bulan, $tahun,$tanggal_penutupan);
		}
		
		
		echo json_encode($data);
	}

	function simpan_data_penutupan_tahunan()
	{
		$id 									=$this->input->post('id');
		
		
		$data['tahun'] 							=$this->input->post('tahun');
		$data['tanggal_penutupan']				=$this->input->post('tanggal_penutupan');
		//ditandatangani
		$ditandatangani_oleh					=$this->input->post('ditandatangani_oleh');
		$data['ditandatangani_oleh_jabatan']	=explode("^", $ditandatangani_oleh)[0];	
		$data['ditandatangani_oleh_nama']		=explode("^", $ditandatangani_oleh)[1];	
		//ditandatangani
		//diketahui
		$diketahui_oleh							=$this->input->post('diketahui_oleh');
		$data['diketahui_oleh_jabatan']			=explode("^", $diketahui_oleh)[0];	
		$data['diketahui_oleh_nama']			=explode("^", $diketahui_oleh)[1];	
		//diketahui
		
		$data['jenis_register_id']				=$this->input->post('jenis_register_id');
		$data['sisa_tahun_lalu']				=$this->input->post('sisa_tahun_lalu');
		$data['masuk_tahun_ini']				=$this->input->post('masuk_tahun_ini');
		$data['putus_tahun_ini']				=$this->input->post('putus_tahun_ini');
		$data['sisa_tahun_ini']					=$this->input->post('sisa_tahun_ini');
		$data['sisa_tahun_ini_sudah_dikirim']	=$this->input->post('sisa_tahun_ini_sudah_dikirim');
		$data['sisa_tahun_ini_belum_dikirim']	=$this->input->post('sisa_tahun_ini_belum_dikirim');
		$data['keterangan']						=$this->input->post('keterangan');
		$informasi_register 					= $this->register_model->get_data_where('id=' . $this->input->post('jenis_register_id'), 'register_m_jenis_register', '-');
		$data['jenis_register_nama']	=$informasi_register['register_nama'];
		if($id=='')
		{
			$simpan = $this->register_model->insert_data('register_penutupan_tahunan', $data);
		}else
		{
			$whereconditon = "id=".$id;
			$simpan = $this->register_model->update_data($whereconditon,'register_penutupan_tahunan',$data);
		}
	}
	function hapus_data_penutupan_tahunan()
	{
		$id 						=$this->input->post('id');
		$tableName	 = 'register_penutupan_tahunan';
		$whereconditon = " id=$id ";
		$this->register_model->delete_data($whereconditon, $tableName);
	}

	function cetak_penutupan_register_tahunan($id)
	{
		$kriteria=" id=$id ";
		$datane = $this->register_model->get_data_where1($kriteria, 'register_penutupan_tahunan', '-');
		
		$datanya="<p align='center'><b>PENUTUPAN REGISTER<br>".strtoupper($datane[0]->jenis_register_nama)."<br> TAHUN ".$datane[0]->tahun."</b></p><br><br>
				<p align='justify;line-height:200%'>Pada hari ini ".$this->nama_hari($datane[0]->tanggal_penutupan)." tanggal ".$this->tanggal_indonesia($datane[0]->tanggal_penutupan)." ".$datane[0]->jenis_register_nama." ditutup dengan keadaan : </p>
				<table style='border:none' cellpadding='10' cellspacing='10'>
					<tr>
						<td style='border:none;margin:8px'>- </td>
						<td style='border:none;margin:8px'>Sisa Tahun Lalu </td>
						<td style='border:none;margin:8px''>:</td>
						<td style='border:none;text-align:right;margin:8px'>".$datane[0]->sisa_tahun_lalu." perkara</td>
					</tr>
					<tr>
						<td style='border:none;margin:8px'>- </td>
						<td style='border:none;margin:8px'>Masuk Tahun ini </td>
						<td style='border:none;margin:8px'>:</td>
						<td style='border:none;text-align:right;margin:8px'>".$datane[0]->masuk_tahun_ini." perkara</td>
					</tr>
					<tr>
						<td style='border:none;margin:8px'>- </td>
						<td style='border:none;margin:8px'>Putus Tahun ini </td>
						<td style='border:none;margin:8px'>:</td>
						<td style='border:none;text-align:right;margin:8px'>".$datane[0]->putus_tahun_ini." perkara</td>
					</tr>";
		if($datane[0]->jenis_register_id==3 OR $datane[0]->jenis_register_id==4 OR $datane[0]->jenis_register_id==5 )
		{
			$datanya.="
					<tr>
						<td style='border:none;margin:8px'>- </td>
						<td style='border:none;margin:8px'>Sisa Tahun ini </td>
						<td style='border:none;margin:8px'>:</td>
						<td style='border:none;text-align:right;margin:8px'></td>
					</tr><tr>
						<td style='border:none;margin:8px'></td>
						<td style='border:none;margin:8px'>1. Sudah Dikirim </td>
						<td style='border:none;margin:8px'>:</td>
						<td style='border:none;text-align:right;margin:8px'>".$datane[0]->sisa_tahun_ini_sudah_dikirim." perkara</td>
					</tr><tr>
						<td style='border:none;margin:8px'></td>
						<td style='border:none;margin:8px'>2. Belum Dikirim </td>
						<td style='border:none;margin:8px'>:</td>
						<td style='border:none;text-align:right;margin:8px'>".$datane[0]->sisa_tahun_ini_belum_dikirim." perkara</td>
					</tr>";
		}else
		{
			$datanya.="
					<tr>
						<td style='border:none;margin:8px'>- </td>
						<td style='border:none;margin:8px'>Sisa Tahun ini </td>
						<td style='border:none;margin:8px'>:</td>
						<td style='border:none;text-align:right;margin:8px'>".$datane[0]->sisa_tahun_ini." perkara</td>
					</tr>";
		}
		$datanya.="</table>
				<p>".$datane[0]->keterangan."</p><br><br>
				<table style='border:none;width:100%'>
					<tr>
						<td style='border:none;width:50%;text-align:center'>".$datane[0]->diketahui_oleh_jabatan."</td>
						<td style='border:none;width:50%;text-align:center'>".$datane[0]->ditandatangani_oleh_jabatan."</td> 
					</tr>
					
					<tr>
						<td colspan='2' style='border:none'><br><br><br><br><br></td> 
					</tr>

					<tr>
						<td style='border:none;width:50%;text-align:center'>".$datane[0]->diketahui_oleh_nama."</td>
						<td style='border:none;width:50%;text-align:center'>".$datane[0]->ditandatangani_oleh_nama."</td> 
					</tr> 
				</table>
				";
		$data['isi']=$datanya;
		$data['cetak'] = 1;
		$data['nama_file']="Penutupan " .$datane[0]->jenis_register_nama." Tahun ".$datane[0]->tahun ;
		
		
		
		$this->load->view('register/register_cetak_html', $data);
	}
	function data_penutupan_register_tahunan_json()
	{
		  
		$datane = $this->register_model->get_data_order('register_penutupan_tahunan','tahun DESC,  tanggal_penutupan ASC, jenis_register_id ASC');
		$data		= array();
		$no		 = 0;

		foreach ($datane as $row){
			$no++;
			$sub_array   = array();
			$sub_array['id'] =$row->id;
			$sub_array['no'] =$no;

			$sub_array['jenis_register_nama'] =$row->jenis_register_nama; 
			$sub_array['jenis_register_id'] =$row->jenis_register_id; 
			$sub_array['tahun'] =$row->tahun;
			$sub_array['tanggal_penutupan'] =$this->tanggal_indonesia($row->tanggal_penutupan);
			$sub_array['sisa_tahun_lalu'] =$row->sisa_tahun_lalu;

			$sub_array['masuk_tahun_ini'] =$row->masuk_tahun_ini;

			$sub_array['putus_tahun_ini'] =$row->putus_tahun_ini;

			$sub_array['sisa_tahun_ini'] =$row->sisa_tahun_ini;
			$keadaan_register='belum dirumuskan';
			if($row->jenis_register_id==1 OR $row->jenis_register_id==2 OR $row->jenis_register_id==11 OR $row->jenis_register_id==13 OR $row->jenis_register_id==14 OR $row->jenis_register_id==3 OR $row->jenis_register_id==4 OR $row->jenis_register_id==5)
			{
				$keadaan_register="	Sisa tahun lalu : ".$row->sisa_tahun_lalu." perkara<br>
									Masuk tahun ini : ".$row->masuk_tahun_ini." perkara<br>
									Putus tahun ini : ".$row->putus_tahun_ini." perkara<br>
									Sisa tahun ini  : ".$row->sisa_tahun_ini." perkara";
			}
			if($row->jenis_register_id==3 OR $row->jenis_register_id==4 OR $row->jenis_register_id==5)
			{
				$keadaan_register.="<br> 1. Sudah Dikirim  : ".$row->sisa_tahun_ini_sudah_dikirim." perkara<br>
								   2. Belum Dikirim : ".$row->sisa_tahun_ini_belum_dikirim." perkara";
			}
			$sub_array['keadaan_register'] =$keadaan_register;
 
			$sub_array['keterangan'] =$row->keterangan;

			
			$sub_array['tombol'] ='<center><i style="cursor:pointer" title="detail" onclick="detail_penutupan_tahunan('.$row->jenis_register_id.',' . $row->id . ')" class="success glyphicon glyphicon-eye-open"> </i></center>';
			$data[]=$sub_array;
		}
		$output = array(
			"data" => $data
		);
		echo json_encode($output);
	}

	function data_penutupan_tahunan()
	{
		$id 	=$this->input->post('id');
		$kriteria=" id=$id ";
		$datane = $this->register_model->get_data_where1($kriteria, 'register_penutupan_tahunan', '-');
		$data['id']=$datane[0]->id;
		$data['jenis_register_id']=$datane[0]->jenis_register_id;
		$data['jenis_register_nama']=$datane[0]->jenis_register_nama;
		$data['tahun']=$datane[0]->tahun;
		
		$data['tanggal_penutupan']=$datane[0]->tanggal_penutupan;
		$data['sisa_tahun_lalu']=$datane[0]->sisa_tahun_lalu; 
		$data['masuk_tahun_ini']=$datane[0]->masuk_tahun_ini; 
		$data['putus_tahun_ini']=$datane[0]->putus_tahun_ini; 
		$data['sisa_tahun_ini']=$datane[0]->sisa_tahun_ini; 
		$data['sisa_tahun_ini_sudah_dikirim']=$datane[0]->sisa_tahun_ini_sudah_dikirim; 
		$data['sisa_tahun_ini_belum_dikirim']=$datane[0]->sisa_tahun_ini_belum_dikirim; 
		$data['ditandatangani_oleh']=$datane[0]->ditandatangani_oleh_jabatan.'^'.$datane[0]->ditandatangani_oleh_nama;
		$data['diketahui_oleh']=$datane[0]->diketahui_oleh_jabatan.'^'.$datane[0]->diketahui_oleh_nama;
		
		$data['keterangan']=$datane[0]->keterangan;
		echo json_encode($data);
	}
	function penyitaan($jenis_penyitaan_id=1)
	{
		$this->is_login();
		$sys					  = $this->register_model->sys_config();
		$data['NamaPN']		   = $sys['NamaPN'];
		$data['KetuaPNNama']	  = $sys['KetuaPNNama'];
		$data['KetuaPNNIP']		= $sys['KetuaPNNIP'];
		$data['WakilKetuaPNNama'] = $sys['WakilKetuaPNNama'];
		$data['WakilKetuaPNNIP']  = $sys['WakilKetuaPNNIP'];
		$data['PanSekNama']		= $sys['PanSekNama'];
		$data['PanSekNIP']		= $sys['PanSekNIP'];
		$data['WaPanNama']		= $sys['WaPanNama'];
		$data['WaPanNIP']		 = $sys['WaPanNIP'];
		//	$whereconditon			= ' block=0 AND group_id IN(1010,430,1000)';
		//	$table					= 'v_users';
		//	$jenisdb				 = 'dbsipp';
		//	$data['panmud']		   = $this->register_model->get_data_where1($whereconditon, $table, $jenisdb);
		//var_dump($data['panmud']);
		$kriteria='jenis_penyitaan_id='.$jenis_penyitaan_id;
		$data_informasi_register = $this->register_model->get_data_where1($kriteria, 'register_m_jenis_penyitaan', '-');
		//var_dump($data_informasi_register);exit;
		$data['jenis_penyitaan_id'] = $data_informasi_register[0]->jenis_penyitaan_id;

		$data['jenis_penyitaan_nama'] = $data_informasi_register[0]->jenis_penyitaan_nama;
		 //$data['hakim']=$this->register_model->get_data_where1("aktif='Y'","hakim_pn", $jenisdb);
		//$data['panitera']=$this->register_model->get_data_where1("aktif='Y'","panitera_pn", $jenisdb);
		//$data['validasi'] =$this->register_model->validasi_data();
		$this->load->view('register/register_header', $data);
		$this->load->view('register/register_penyitaan');
		$this->load->view('register/register_footer');
	}
	function penyitaan_tambah($jenis_penyitaan_id)
	{
		$kriteria='jenis_penyitaan_id='.$jenis_penyitaan_id;
		$data_informasi_register = $this->register_model->get_data_where1($kriteria, 'register_m_jenis_penyitaan', '-'); 
		$data['jenis_penyitaan_id'] = $data_informasi_register[0]->jenis_penyitaan_id; 
		$data['jenis_penyitaan_nama'] = $data_informasi_register[0]->jenis_penyitaan_nama;

		$table		= "register_penyitaan"; 
		$kriteria 	="left(tanggal_penetapan_sita,4)=".date('Y')." AND jenis_penyitaan_id=".$jenis_penyitaan_id;
		//echo $kriteria;exit;
		$nomor_urut= $this->register_model->get_all_data_where('register_penyitaan',$kriteria);
		$nomor_urut++;
		$data['nomor_urut']=$nomor_urut;
		$data['jurusita']=$this->register_model->get_data_where1("aktif='Y'","jurusita", 'dbsipp');
		$this->load->view('register/register_penyitaan_tambah', $data); 
	}
	function penyitaan_edit($id)
	{
		$kriteria='id='.$id;
		$data_informasi_register = $this->register_model->get_data_where1($kriteria, 'register_penyitaan', '-'); 
		$data['id'] = $data_informasi_register[0]->id;
		$data['nomor_urut'] = $data_informasi_register[0]->nomor_urut;
		$data['tingkat'] = $data_informasi_register[0]->tingkat;
		$data['nomor_perkara'] = $data_informasi_register[0]->nomor_perkara;
		$data['nama_para_pihak'] = $data_informasi_register[0]->nama_para_pihak;
		$data['jenis_penyitaan_id'] = $data_informasi_register[0]->jenis_penyitaan_id;
		$data['jenis_penyitaan_nama'] = $data_informasi_register[0]->jenis_penyitaan_nama;
		$data['tanggal_penetapan_sita'] = $data_informasi_register[0]->tanggal_penetapan_sita;
		$data['nama_barang_yang_disita'] = $data_informasi_register[0]->nama_barang_yang_disita;
		$data['tanggal_pelaksanaan_sita'] = $data_informasi_register[0]->tanggal_pelaksanaan_sita;
		$data['status_barang_sitaan'] = $data_informasi_register[0]->status_barang_sitaan;
		$data['penyimpan_barang_sitaan'] = $data_informasi_register[0]->penyimpan_barang_sitaan;
		$data['nama_js'] = $data_informasi_register[0]->nama_js;
		$data['tanggal_pendaftaran_penyitaan'] = $data_informasi_register[0]->tanggal_pendaftaran_penyitaan;
		$data['keterangan'] = $data_informasi_register[0]->keterangan;

 
		$data['jurusita']=$this->register_model->get_data_where1("aktif='Y'","jurusita", 'dbsipp');
		$this->load->view('register/register_penyitaan_edit', $data); 
	}
	function penyitaan_informasi_perkara()
	{
		$nomor_perkara= $this->input->post('nomor_perkara');
		$tingkat = trim($this->input->post('tingkat'));
		$data=$this->register_model->data_json_informasi_perkara_penyitaan($nomor_perkara, $tingkat);
		$identitas_p=$this->sebutan_pihak($nomor_perkara,$data[0]->identitas_p);
		$identitas_t=$this->sebutan_pihak($nomor_perkara,$data[0]->identitas_t);
		$kuasa_p=$data[0]->kuasa_p;
		$kuasa_t=$data[0]->kuasa_t;
		if($kuasa_p<>'')
		{
			$kuasa_p=' (Kuasa Hukum '.$kuasa_p.')';
		}
		if($kuasa_t<>'')
		{
			$kuasa_t=' (Kuasa Hukum '.$kuasa_t.')';
		}
		$output['nama_para_pihak']=$identitas_p.$kuasa_p.chr(13).'melawan'.chr(13).$identitas_t.$kuasa_t;
		$output['tanggal_penetapan_sita']=$data['tanggal_penetapan_sita'];
		$output['jenis_penyitaan_nama']=$data['jenis_penyitaan_nama'];
		$output['nama_js']=$data['nama_js'];

		echo json_encode($output);

	}
	function penyitaan_simpan()
	{
		
		$data['nomor_urut']=$this->input->post('nomor_urut');
		$data['tingkat']=$this->input->post('tingkat');
		$data['nomor_perkara']=$this->input->post('nomor_perkara');
		$data['nama_para_pihak']=$this->input->post('nama_para_pihak');

		$data['jenis_penyitaan_id']=$this->input->post('jenis_penyitaan_id');
		$data['jenis_penyitaan_nama']=$this->input->post('jenis_penyitaan_nama');
		$data['tanggal_penetapan_sita']=$this->input->post('tanggal_penetapan_sita');
		$data['nama_barang_yang_disita']=$this->input->post('nama_barang_yang_disita');
		$data['tanggal_pelaksanaan_sita']=$this->input->post('tanggal_pelaksanaan_sita');
		$data['status_barang_sitaan']=$this->input->post('status_barang_sitaan');
		$data['penyimpan_barang_sitaan']=$this->input->post('penyimpan_barang_sitaan');
		$data['nama_js']=$this->input->post('nama_js');
		$data['tanggal_pendaftaran_penyitaan']=$this->input->post('tanggal_pendaftaran_penyitaan');
		$data['keterangan']=$this->input->post('keterangan');
		 
			$simpan = $this->register_model->insert_data('register_penyitaan', $data);

			$whereconditon = "tanggal_pendaftaran_penyitaan='0000-00-00'";
			$data_update=array('tanggal_pendaftaran_penyitaan=NULL');
			$simpan = $this->register_model->update_data($whereconditon,'register_penyitaan',$data_update);	
			$whereconditon = "tanggal_pelaksanaan_sita='0000-00-00'";
			$data_update=array('tanggal_pelaksanaan_sita=NULL');
			$simpan = $this->register_model->update_data($whereconditon,'register_penyitaan',$data_update);	
			
			$whereconditon = "tanggal_pendaftaran_penyitaan='0000-00-00'";
			$data_update=array('tanggal_pendaftaran_penyitaan=NULL');
			$simpan = $this->register_model->update_data($whereconditon,'register_penyitaan',$data_update);	
		 
	}
	function penyitaan_edit_simpan()
	{
		$id=$this->input->post('id');
		$data['id']=$this->input->post('id');
		$data['nomor_urut']=$this->input->post('nomor_urut');
		$data['tingkat']=$this->input->post('tingkat');
		$data['nomor_perkara']=$this->input->post('nomor_perkara');
		$data['nama_para_pihak']=$this->input->post('nama_para_pihak');

		$data['jenis_penyitaan_id']=$this->input->post('jenis_penyitaan_id');
		$data['jenis_penyitaan_nama']=$this->input->post('jenis_penyitaan_nama');
		$data['tanggal_penetapan_sita']=$this->input->post('tanggal_penetapan_sita');
		$data['nama_barang_yang_disita']=$this->input->post('nama_barang_yang_disita');
		$data['tanggal_pelaksanaan_sita']=$this->input->post('tanggal_pelaksanaan_sita');
		$data['status_barang_sitaan']=$this->input->post('status_barang_sitaan');
		$data['penyimpan_barang_sitaan']=$this->input->post('penyimpan_barang_sitaan');
		$data['nama_js']=$this->input->post('nama_js');
		$data['tanggal_pendaftaran_penyitaan']=$this->input->post('tanggal_pendaftaran_penyitaan');
		$data['keterangan']=$this->input->post('keterangan');
	 	$whereconditon = "id=".$id;
		$simpan = $this->register_model->update_data($whereconditon,'register_penyitaan',$data);
		 
			$whereconditon = "tanggal_pendaftaran_penyitaan='0000-00-00'";
			$data_update=array('tanggal_pendaftaran_penyitaan=NULL');
			$simpan = $this->register_model->update_data($whereconditon,'register_penyitaan',$data_update);	
			$whereconditon = "tanggal_pelaksanaan_sita='0000-00-00'";
			$data_update=array('tanggal_pelaksanaan_sita=NULL');
			$simpan = $this->register_model->update_data($whereconditon,'register_penyitaan',$data_update);	
			$whereconditon = "tanggal_pendaftaran_penyitaan='0000-00-00'";
			$data_update=array('tanggal_pendaftaran_penyitaan=NULL');
			$simpan = $this->register_model->update_data($whereconditon,'register_penyitaan',$data_update);	
		 	
		 
	}

	function hapus_penyitaan()
	{
		$id 						=$this->input->post('id');
		$tableName	 = 'register_penyitaan';
		$whereconditon = " id=$id ";
		$this->register_model->delete_data($whereconditon, $tableName);
	}
	function datapenyitaanjson($jenis_penyitaan_id=1)
	{
		$table		 = "register_penyitaan"; //table yang ingin di tampilkan
		
		$kriteria='jenis_penyitaan_id='.$jenis_penyitaan_id;
		$datane = $this->register_model->get_data_where1($kriteria, 'register_penyitaan','-');
		$data		= array();
		$no		 = 0;

		foreach ($datane as $row){
			$no++;
			$sub_array   = array();
			$sub_array['id'] =$row->id;
			$sub_array['nomor_urut'] =$row->nomor_urut;
			$sub_array['nomor_perkara'] =$row->nomor_perkara;
			$sub_array['nama_para_pihak'] =$row->nama_para_pihak;
			$sub_array['jenis_penyitaan_id'] =$row->jenis_penyitaan_id;
			$sub_array['jenis_penyitaan_nama'] =$row->jenis_penyitaan_nama;
			$sub_array['tanggal_penetapan_sita'] =$row->tanggal_penetapan_sita;
			$sub_array['nama_barang_yang_disita'] =$row->nama_barang_yang_disita;
			$sub_array['tanggal_pelaksanaan_sita'] =$row->tanggal_pelaksanaan_sita;
			$sub_array['status_barang_sitaan'] =$row->status_barang_sitaan;
			$sub_array['penyimpan_barang_sitaan'] =$row->penyimpan_barang_sitaan;
			$sub_array['nama_js'] =$row->nama_js;
			$sub_array['tanggal_pendaftaran_penyitaan'] =$row->tanggal_pendaftaran_penyitaan;
			$sub_array['keterangan'] =$row->keterangan;
			$sub_array['tombol'] ='<center><p><a href="'.base_url('register/penyitaan_edit/'). $row->id .'"  class="btn btn-primary btn-xs edit  glyphicon glyphicon-edit"> </a></p></center>';
			$data[]=$sub_array;
		}
		$output = array(
			"data" => $data
		);
		echo json_encode($output);
	}
	function irh()
	{
		$this->is_login();
		$sys					  = $this->register_model->sys_config();
		$data['NamaPN']		   = $sys['NamaPN'];
		$data['KetuaPNNama']	  = $sys['KetuaPNNama'];
		$data['KetuaPNNIP']		= $sys['KetuaPNNIP'];
		$data['WakilKetuaPNNama'] = $sys['WakilKetuaPNNama'];
		$data['WakilKetuaPNNIP']  = $sys['WakilKetuaPNNIP'];
		$data['PanSekNama']		= $sys['PanSekNama'];
		$data['PanSekNIP']		= $sys['PanSekNIP'];
		$data['WaPanNama']		= $sys['WaPanNama'];
		$data['WaPanNIP']		 = $sys['WaPanNIP'];
		$whereconditon			= ' block=0 AND group_id IN(1010,430,1000)';
		$table					= 'v_users';
		$jenisdb				 = 'dbsipp';
		$data['panmud']		   = $this->register_model->get_data_where1($whereconditon, $table, $jenisdb);
		//var_dump($data['panmud']);
		
		$data['title'] = "Register Itsbat Rukyat Hilal Dan Pemberian Nasehat / Keterangan Tentang Perbedaan Penentuan Arah Kiblat Dan Penentuan Awal Waktu Shalat";
		$data['hakim']=$this->register_model->get_data_where1("aktif='Y'","hakim_pn", $jenisdb);
		$data['panitera']=$this->register_model->get_data_where1("aktif='Y'","panitera_pn", $jenisdb);
		//$data['validasi'] =$this->register_model->validasi_data();
		$this->load->view('register/register_header', $data);
		$this->load->view('register/register_irh');
		$this->load->view('register/register_footer');
	}
	function irh_data_json()
	{
		$data = $this->register_model->irh_data_json();
		$this->output->set_content_type('application/json');
		$this->output->set_output(json_encode($data));
	}
	function register_irh_proses()
	{
		$this->is_login();
		$sys			= $this->register_model->sys_config();
		$data['NamaPN'] = $sys['NamaPN'];
		$data['NamaPN'] = $sys['NamaPN'];
		$whereconditon  = " year(tanggal_pendaftaran)=" . date('Y'); 
		$urutan		 = $this->register_model->get_all_data_where('register_permohonan_penetapan_ikrh', $whereconditon);
		$urutan++;
		$data['nomor_permohonan'] = $urutan . "/" . date('Y') . "/" . $sys['KodePN'];
		$data['title']			= "Tambah Register Itsbat Rukyat Hilal Dan Pemberian Nasehat / Keterangan Tentang Perbedaan Penentuan Arah Kiblat Dan Penentuan Awal Waktu Shalat ";
		$data['urutan']		   = $urutan;
		//$data['tanggal_indonesia'] =$this->tanggal_indonesia($tanggal);
		//cek apakah sudah di validasi sebelumnya
		
		//$data['validasi'] =$this->register_model->validasi_harian_1($tanggal); 
		$this->load->view('register/register_irh_proses', $data);
		
		//cek apakah sudah di validasi sebelumnya
	}
	function register_irh_edit()
	{
		$this->is_login();
		$id= trim($this->input->post('id')); 
		$data['title']			= "Edit Register Itsbat Rukyat Hilal Dan Pemberian Nasehat / Keterangan Tentang Perbedaan Penentuan Arah Kiblat Dan Penentuan Awal Waktu Shalat ";
		
		$whereconditon  = " id=" . id; 
		$datanya		 = $this->register_model->get_data_where( $whereconditon,'register_permohonan_penetapan_ikrh','-') ;
		
		$data['id'] 					= $datanya['id'];
		$data['urutan'] 				= $datanya['urutan'];
		$data['nomor_permohonan'] 		= $datanya['nomor_permohonan'];
		$data['tanggal_pendaftaran'] 	= $datanya['tanggal_pendaftaran'];
		$data['nama_pemohon'] 			= $datanya['nama_pemohon'];
		$data['keterangan_singkat_isi_permohonan'] 			= $datanya['keterangan_singkat_isi_permohonan'];
		$data['tanggal_penetapan_hakim']= $datanya['tanggal_penetapan_hakim'];
		$data['nama_hakim']				= $datanya['nama_hakim'];
		$data['nama_panitera']			= $datanya['nama_panitera'];
		$data['tanggal_pelaksanaan']	= $datanya['tanggal_pelaksanaan'];
		$data['tempat_pelaksanaan']		= $datanya['tempat_pelaksanaan'];
		$data['tanggal_penetapan']		= $datanya['tanggal_penetapan'];
		$data['isi_penetapan']			= $datanya['isi_penetapan'];
		$data['keterangan']				= $datanya['keterangan'];
		
		
		$this->load->view('register/register_irh_edit', $data);
		
		//cek apakah sudah di validasi sebelumnya
	}
	function register_irh_proses_simpan()
	{
		$this->is_login();
		$urutan						   = $this->input->post('urutan');
		$nomor_permohonan				 = $this->input->post('nomor_permohonan');
		$tanggal_pendaftaran			  = $this->input->post('tanggal_pendaftaran');
		$nama_pemohon					  = $this->input->post('nama_pemohon');
		$keterangan_singkat_isi_permohonan = $this->input->post('keterangan_singkat_isi_permohonan');
		if($this->input->post('tanggal_penetapan_hakim') == ""){
			$tanggal_penetapan_hakim = NULL;
		} else{
			$tanggal_penetapan_hakim = $this->input->post('tanggal_penetapan_hakim');
		}
		
		if($this->input->post('tanggal_pelaksanaan') == ""){
			$tanggal_pelaksanaan = NULL;
		} else{
			$tanggal_pelaksanaan = $this->input->post('tanggal_pelaksanaan');
		}
		if($this->input->post('tanggal_penetapan') == ""){
			$tanggal_penetapan = NULL;
		} else{
			$tanggal_penetapan = $this->input->post('tanggal_penetapan');
		}
		
		$tempat_pelaksanaan = $this->input->post('tempat_pelaksanaan');
		$nama_hakim		 = $this->input->post('nama_hakim');
		$nama_panitera	  = $this->input->post('nama_panitera');
		$isi_penetapan	  = $this->input->post('isi_penetapan');
		$keterangan		 = $this->input->post('keterangan');
		
		
		//var_dump($this->input->post());
		
		
		
		$whereconditon_masuk = "tanggal_pendaftaran='" . $tanggal . "'";
		$whereconditon_putus = "tanggal_putusan='" . $tanggal . "'";
		$data			   = array(
			'urutan' => $urutan,
			'nomor_permohonan' => $nomor_permohonan,
			'tanggal_pendaftaran' => $tanggal_pendaftaran,
			'nama_pemohon' => $nama_pemohon,
			'keterangan_singkat_isi_permohonan' => $keterangan_singkat_isi_permohonan,
			'tanggal_penetapan_hakim' => $tanggal_penetapan_hakim,
			'nama_hakim' => $nama_hakim,
			'nama_panitera' => $nama_panitera,
			'tanggal_pelaksanaan' => $tanggal_pelaksanaan,
			'tempat_pelaksanaan' => $tempat_pelaksanaan,
			'tanggal_penetapan' => $tanggal_penetapan,
			'isi_penetapan' => $isi_penetapan,
			'keterangan' => $keterangan
		);
		
		$simpan = $this->register_model->insert_data('register_permohonan_penetapan_ikrh', $data);
	}
	function register_irh_proses_simpan_edit()
	{
		$this->is_login();
		$id						   		= $this->input->post('id');
		$urutan						   = $this->input->post('urutan');
		$nomor_permohonan				 = $this->input->post('nomor_permohonan');
		$tanggal_pendaftaran			  = $this->input->post('tanggal_pendaftaran');
		$nama_pemohon					  = $this->input->post('nama_pemohon');
		$keterangan_singkat_isi_permohonan = $this->input->post('keterangan_singkat_isi_permohonan');
		if($this->input->post('tanggal_penetapan_hakim') == ""){
			$tanggal_penetapan_hakim = NULL;
		} else{
			$tanggal_penetapan_hakim = $this->input->post('tanggal_penetapan_hakim');
		}
		
		if($this->input->post('tanggal_pelaksanaan') == ""){
			$tanggal_pelaksanaan = NULL;
		} else{
			$tanggal_pelaksanaan = $this->input->post('tanggal_pelaksanaan');
		}
		if($this->input->post('tanggal_penetapan') == ""){
			$tanggal_penetapan = NULL;
		} else{
			$tanggal_penetapan = $this->input->post('tanggal_penetapan');
		}
		
		$tempat_pelaksanaan = $this->input->post('tempat_pelaksanaan');
		$nama_hakim		 = $this->input->post('nama_hakim');
		$nama_panitera	  = $this->input->post('nama_panitera');
		$isi_penetapan	  = $this->input->post('isi_penetapan');
		$keterangan		 = $this->input->post('keterangan');
		
		
		//var_dump($this->input->post());
		
		
		
		
		
		$data			   = array(
			'urutan' => $urutan,
			'nomor_permohonan' => $nomor_permohonan,
			'tanggal_pendaftaran' => $tanggal_pendaftaran,
			'nama_pemohon' => $nama_pemohon,
			'keterangan_singkat_isi_permohonan' => $keterangan_singkat_isi_permohonan,
			'tanggal_penetapan_hakim' => $tanggal_penetapan_hakim,
			'nama_hakim' => $nama_hakim,
			'nama_panitera' => $nama_panitera,
			'tanggal_pelaksanaan' => $tanggal_pelaksanaan,
			'tempat_pelaksanaan' => $tempat_pelaksanaan,
			'tanggal_penetapan' => $tanggal_penetapan,
			'isi_penetapan' => $isi_penetapan,
			'keterangan' => $keterangan
		);

		$whereconditon = "id=".$id;
		$simpan = $this->register_model->update_data($whereconditon,'register_permohonan_penetapan_ikrh',$data);
	}
	function datairhjson()
	{
		
		$table		 = "register_permohonan_penetapan_ikrh"; //table yang ingin di tampilkan
		$select_column = array(
			"id",
			"convert_tanggal_indonesia(tanggal_pendaftaran) AS tanggal_indonesia ",
			"tanggal_pendaftaran",
			"nomor_permohonan",
			"nama_pemohon", 
			"tempat_pelaksanaan",
			"convert_tanggal_indonesia(tanggal_pelaksanaan) AS pelaksanaan "
		); //sesuaikan dengan nama field table
		$order_column  = array(
			"tanggal_pendaftaran",
			"nomor_permohonan",
			null,
			null,
			null,
			null
		);
		
		$fetch_data = $this->register_model->make_datatables_irh($table, $select_column, $order_column);
		$data		= array();
		$no		 = 0;
		foreach ($fetch_data as $row){
			$no++;
			$sub_array   = array();
			$sub_array[] = $row->tanggal_indonesia;
			$sub_array[] = $row->nomor_permohonan;
			$sub_array[] = $row->nama_pemohon;
			$sub_array[] = $row->pelaksanaan;
			$sub_array[] = $row->tempat_pelaksanaan;
			$sub_array[] = '<center><button type="button" name="edit" onclick="edit_irh(' . $row->id . ')" class="btn btn-primary btn-xs edit"><span class="glyphicon glyphicon-edit"></span> Edit</button> <button type="button" name="update" onclick="cetak_irh(' . $row->id . ')" class="btn btn-success btn-xs update"><span class="glyphicon glyphicon-print"></span> Cetak</button> <button type="button" name="delete" onclick="hapus_irh(' . $row->id . ')" class="btn btn-danger btn-xs delete"><span class="glyphicon glyphicon-trash"></span> Hapus</button></center>';
			$data[]	  = $sub_array;
		}
		if(isset($_POST["draw"])){
			$draw = intval($_POST["draw"]);
		} else{
			$draw = 1;
		}
		$output = array(
			"draw" => $draw,
			"recordsTotal" => $this->register_model->get_all_data($table),
			"recordsFiltered" => $this->register_model->get_filtered_data_irh($table, $select_column, $order_column),
			"data" => $data
		);
		echo json_encode($output);
	}
	function register_irh_hapus()
	{
		$this->is_login();
		$id = trim($this->input->post('id'));
		
		$tableName	 = 'register_permohonan_penetapan_ikrh';
		$whereconditon = "id=" . $id;
		$this->register_model->delete_data($whereconditon, $tableName);
	} 
	function validasi_data_json()
	{
		$data = $this->register_model->validasi_data_json();
		$this->output->set_content_type('application/json');
		$this->output->set_output(json_encode($data));
	}  
	function register_validasi_harian_proses()
	{
		$this->is_login();
		$tanggal = trim($this->input->post('tanggal'));
		
		$sys					   = $this->register_model->sys_config();
		$data['NamaPN']			= $sys['NamaPN'];
		$data['title']			= "Validasi e-Register";
		$data['tanggal_indonesia'] = $this->tanggal_indonesia($tanggal);
		//cek apakah sudah di validasi sebelumnya
		$whereconditon			= "tanggal='" . $tanggal . "'";
		//echo $this->register_model->get_all_data_where('register_validasi',$where_condition);exit;
		if($this->register_model->get_all_data_where('register_validasi', $whereconditon) == 1){
			$data['validasi']		= $this->register_model->validasi_harian_1($tanggal);
			$hasil_validasi		 = $this->register_model->get_data_where($whereconditon, 'register_validasi', '-');
			//var_dump($hasil_validasi['catatan']);exit;
			$data['hasil_validasi'] = $hasil_validasi['catatan'];
			$this->load->view('register/register_validasi_proses_hasil', $data);
		} else{
			$data['validasi'] = $this->register_model->validasi_harian_1($tanggal);
			$this->load->view('register/register_validasi_proses', $data);
		}
		//cek apakah sudah di validasi sebelumnya
	}
	function validasi()
	{
		$this->is_login();
		
		$sys					  = $this->register_model->sys_config();
		$data['NamaPN']		   = $sys['NamaPN'];
		$data['KetuaPNNama']	  = $sys['KetuaPNNama'];
		$data['KetuaPNNIP']		= $sys['KetuaPNNIP'];
		$data['WakilKetuaPNNama'] = $sys['WakilKetuaPNNama'];
		$data['WakilKetuaPNNIP']  = $sys['WakilKetuaPNNIP'];
		$data['PanSekNama']		= $sys['PanSekNama'];
		$data['PanSekNIP']		= $sys['PanSekNIP'];
		$data['WaPanNama']		= $sys['WaPanNama'];
		$data['WaPanNIP']		 = $sys['WaPanNIP'];
		$whereconditon			= ' block=0 AND group_id IN(1010,430,1000)';
		$table					= 'v_users';
		$jenisdb				 = 'dbsipp';
		$data['panmud']		   = $this->register_model->get_data_where1($whereconditon, $table, $jenisdb);
		//var_dump($data['panmud']);
		
		$data['title'] = "Validasi e-Register";
		
		//$data['validasi'] =$this->register_model->validasi_data();
		$this->load->view('register/register_header', $data);
		$this->load->view('register/register_validasi');
		$this->load->view('register/register_footer');
	}
	function register_validasi_harian_cetak()
	{
		$this->is_login();
		$id			= trim($this->input->post('id_cetak'));
		$dibuat		 = trim($this->input->post('dibuat'));
		$pecah_dibuat   = explode("^", trim($this->input->post('dibuat')));
		$data['dibuat'] = $pecah_dibuat[0] . "<br><br><br><br>" . $pecah_dibuat[1];
		if(trim($this->input->post('mengetahui')) == ""){
			$data['mengetahui'] = '';
		} else{
			
			$pecah_mengetahui   = explode("^", trim($this->input->post('mengetahui')));
			$data['mengetahui'] = 'Mengetahui<br>' . $pecah_mengetahui[0] . "<br><br><br><br>" . $pecah_mengetahui[1];
		}
		
		
		$sys			= $this->register_model->sys_config();
		$data['NamaPN'] = $sys['NamaPN'];
		$data['title']  = "Validasi e-Register";
		//$data['tanggal'] =$this->tanggal_indonesia($tanggal);
		//cek apakah sudah di validasi sebelumnya
		$whereconditon  = "id=" . $id;
		//echo $this->register_model->get_all_data_where('register_validasi',$where_condition);exit;
		if($this->register_model->get_all_data_where('register_validasi', $whereconditon) == 1){
			$hasil_validasi		 = $this->register_model->get_data_where($whereconditon, 'register_validasi', '-');
			//var_dump($hasil_validasi['catatan']);exit;
			$data['hasil_validasi'] = $hasil_validasi['catatan'];
			$data['tanggal']		= $this->tanggal_indonesia($hasil_validasi['tanggal']);
			$this->load->view('register/register_validasi_cetak', $data);
		} else{
			redirect('register/validasi');
		}
		//cek apakah sudah di validasi sebelumnya
	}
	function register_validasi_harian_proses_simpan()
	{
		$this->is_login();
		$tanggal		= trim($this->input->post('tanggal'));
		$hasil_validasi = $this->input->post('hasil_validasi');
		//var_dump($this->input->post());
		
		
		
		$whereconditon_masuk = "tanggal_pendaftaran='" . $tanggal . "'";
		$whereconditon_putus = "tanggal_putusan='" . $tanggal . "'";
		$data			   = array(
			'waktu_validasi' => date("Y-m-d H:i:s", time()),
			'validator_id' => $this->session->userdata('userid'),
			'validator_username' => $this->session->userdata('nama_user'),
			'validator_nama' => $this->session->userdata('fullname'),
			'validator_jabatan' => $this->session->userdata('group_name'),
			'catatan' => $hasil_validasi,
			'tanggal' => $tanggal,
			'perkara_masuk' => $this->register_model->get_all_data_where_sipp('perkara', $whereconditon_masuk),
			'perkara_diputus' => $this->register_model->get_all_data_where_sipp('perkara_putusan', $whereconditon_putus)
		);
		
		$simpan = $this->register_model->insert_data('register_validasi', $data);
		//echo $this->db->insert_id();
		
		$simpan_list_masuk = $this->register_model->insert_validasi_harian('perkara', 'perkara_id,tanggal_pendaftaran,nomor_urut_register,nomor_urut_perkara,nomor_perkara,nomor_indeks,para_pihak,jenis_perkara_id', 'tanggal_pendaftaran', $tanggal, 'register_perkara_masuk');
		$simpan_list_putus = $this->register_model->insert_validasi_harian('perkara_putusan', 'perkara_id,tanggal_putusan', 'tanggal_putusan', $tanggal, 'register_perkara_putus');
		
		//echo "<div class='w3-'"
		//$data['tanggal_indonesia'] =$this->tanggal_indonesia($tanggal);
		//$data['title'] = "Validasi e-Register";
		
		//$this->load->view('register/register_validasi_proses',$data);
	}
	function register_validasi_harian_hapus()
	{
		$this->is_login();
		$tanggal = trim($this->input->post('tanggal'));
		
		$tableName				= 'register_validasi';
		$whereconditon			= "tanggal='" . $tanggal . "'";
		//backup data
		$data					  = $this->register_model->get_data_where($whereconditon, $tableName, '-');
		$data['waktu_penghapusan'] = date("Y-m-d H:i:s", time());
		$this->register_model->insert_data('register_validasi_backup', $data);
		//backup data
		$this->register_model->delete_data($whereconditon, $tableName);
		
		$tableName	 = 'register_perkara_masuk';
		$whereconditon = "tanggal_pendaftaran='" . $tanggal . "'";
		$this->register_model->delete_data($whereconditon, $tableName);
		
		$tableName	 = 'register_perkara_putus';
		$whereconditon = "tanggal_putusan='" . $tanggal . "'";
		$this->register_model->delete_data($whereconditon, $tableName);
	}
	function monitoring()
	{
		$this->is_login();
		
		$sys			= $this->register_model->sys_config();
		$data['NamaPN'] = $sys['NamaPN'];
		
		$data['title'] = "Dasboard";
		
		$this->load->view('register/register_header', $data);
		$this->load->view('register/register_footer');
	}
	function cetak()
	{
		$this->is_login();
		
		$data			= $this->register_model->sys_config();
		$data['NamaPN']   = $data['NamaPN'];
		$kriteria		 = "aktif='y'";
		$data['register'] = $this->register_model->get_data_where1($kriteria, 'register_m_jenis_register', '-');
		$data['title']	= "Cetak Register";
		$this->load->view('register/register_header', $data);
		$this->load->view('register/register_cetak');
		
		$this->load->view('register/register_footer');
		// echo "<pre>";
		// print_r($bln);
		// echo "</pre>";	
	}
	function klasik()
	{
		
		$this->is_login();
		$this->load->helper('form');
		
		$sys			= $this->register_model->sys_config();
		$data['NamaPN'] = $sys['NamaPN'];
		$data['title']  = "Register Perkara Klasik";
		
		$tahun_perkara = date("Y");
		$bulan_perkara = date("m");
		$blnlalu		= intval($bulan_perkara - 1);
		$blndepan	  = intval($bulan_perkara + 1);
		if(strlen($blnlalu) == 1)
			$blnlalu = '0' . $blnlalu;
		if(strlen($bulan_perkara) == 1)
			$bulan_perkara = '0' . $bulan_perkara;
		if(strlen($blndepan) == 1)
			$blndepan = '0' . $blndepan;
		
		$bulanlalu  = $tahun_perkara . '-' . $blnlalu;
		$tahunlalu  = $tahun_perkara;
		$bulanini   = $tahun_perkara . '-' . $bulan_perkara;
		$tahunini   = $tahun_perkara;
		$bulandepan = $tahun_perkara . '-' . $blndepan;
		$tahundepan = $tahun_perkara;
		if($bulan_perkara == 12){
			$blndepan   = 1;
			$tahundepan = intval($tahun_perkara + 1);
			$bulandepan = $tahundepan . '-01';
		}
		if($bulan_perkara == '01'){
			$blnlalu   = 12;
			$tahunlalu = intval($tahun_perkara - 1);
			$bulanlalu = $tahunlalu . '-12';
		}
		
		$data['tahun_perkara'] = $this->register_model->tahun_perkara();
		
		
		$data['tahun_terpilih'] = $tahun_perkara;
		$data['bulan_terpilih'] = $bulan_perkara;
		$data['bulanini']		= $bulanini;
		$data['bulandepan']	 = $bulandepan;
		$data['nama_bulan']	 = array(
			'00' => 'Semua Bulan',
			'01' => 'Januari',
			'02' => 'Februari',
			'03' => 'Maret',
			'04' => 'April',
			'05' => 'Mei',
			'06' => 'Juni',
			'07' => 'Juli',
			'08' => 'Agustus',
			'09' => 'September',
			'10' => 'Oktober',
			'11' => 'November',
			'12' => 'Desember'
		);
		$kriteria		 = "aktif='y'";
		$data['register'] = $this->register_model->get_data_where1($kriteria, 'register_m_jenis_register', '-');
		$this->load->vars($data);
		$this->load->view('register/register_header', $data);
		$this->load->view('register/register_klasik');
		$this->load->view('register/register_footer'); 
	}
	function elektronik()
	{
		$this->is_login();
		$this->load->helper('form');
		$sys			= $this->register_model->sys_config();
		$data['NamaPN'] = $sys['NamaPN'];
		$data['title']  = "Register Perkara Elektronik";
		$tahun_perkara = date("Y");
		$bulan_perkara = date("m");
		$blnlalu		= intval($bulan_perkara - 1);
		$blndepan	  = intval($bulan_perkara + 1);
		if(strlen($blnlalu) == 1)
			$blnlalu = '0' . $blnlalu;
		if(strlen($bulan_perkara) == 1)
			$bulan_perkara = '0' . $bulan_perkara;
		if(strlen($blndepan) == 1)
			$blndepan = '0' . $blndepan;
		
		$bulanlalu  = $tahun_perkara . '-' . $blnlalu;
		$tahunlalu  = $tahun_perkara;
		$bulanini   = $tahun_perkara . '-' . $bulan_perkara;
		$tahunini   = $tahun_perkara;
		$bulandepan = $tahun_perkara . '-' . $blndepan;
		$tahundepan = $tahun_perkara;
		if($bulan_perkara == 12){
			$blndepan   = 1;
			$tahundepan = intval($tahun_perkara + 1);
			$bulandepan = $tahundepan . '-01';
		}
		if($bulan_perkara == '01'){
			$blnlalu   = 12;
			$tahunlalu = intval($tahun_perkara - 1);
			$bulanlalu = $tahunlalu . '-12';
		}
		
		$data['tahun_perkara'] = $this->register_model->tahun_perkara();
		
		
		$data['tahun_terpilih'] = $tahun_perkara;
		$data['bulan_terpilih'] = $bulan_perkara;
		$data['bulanini']		= $bulanini;
		$data['bulandepan']	 = $bulandepan;
		$data['nama_bulan']	 = array(
			'00' => 'Semua Bulan',
			'01' => 'Januari',
			'02' => 'Februari',
			'03' => 'Maret',
			'04' => 'April',
			'05' => 'Mei',
			'06' => 'Juni',
			'07' => 'Juli',
			'08' => 'Agustus',
			'09' => 'September',
			'10' => 'Oktober',
			'11' => 'November',
			'12' => 'Desember'
		);
		$kriteria		 = "aktif='y'";
		$data['register'] = $this->register_model->get_data_where1($kriteria, 'register_m_jenis_register', '-');
		$this->load->vars($data);
		$this->load->view('register/register_header', $data);
		$this->load->view('register/register_elektronik');
		$this->load->view('register/register_footer'); 
	}
	function daftar_perkara()
	{
		$nomor_perkara  = trim($this->input->post('nomor_perkara'));
		$jenis_register = trim($this->input->post('jenis_register'));
		
		//$data['json'] = $this->register_model->data_json_perkara($nomor_perkara, $jenis_register); 
		echo json_encode($this->register_model->data_json_perkara($nomor_perkara, $jenis_register));
	}
	function daftar_perkara_penyitaan()
	{
		$nomor_perkara  = trim($this->input->post('nomor_perkara'));
		$tingkat = trim($this->input->post('tingkat'));
		
		//$data['json'] = $this->register_model->data_json_perkara($nomor_perkara, $jenis_register); 
		echo json_encode($this->register_model->data_json_perkara_penyitaan($nomor_perkara, $tingkat));
	}
	function register_manual()
	{
		$jenis_register = $this->uri->segment(3);
		$tahun		  = $this->uri->segment(4);
		$bulan		  = $this->uri->segment(5);
		$tahapan		= $this->uri->segment(6);
		//echo $tahun.'-'.$tahapan;exit;
		
		$nama_model_register_manual = "register_" . $jenis_register;
		$data['register']		   = $this->register_model->$nama_model_register_manual($tahun, $bulan, $tahapan);
		$config					 = $this->register_model->sys_config();
		$data['NamaPN']			= $config['NamaPN'];
		$nm_bulan					= array(
			'1' => 'Januari',
			'2' => 'Pebruari',
			'3' => 'Maret',
			'4' => 'April',
			'5' => 'Mei',
			'6' => 'Juni',
			'7' => 'Juli',
			'8' => 'Agustus',
			'9' => 'September',
			'10' => 'Oktober',
			'11' => 'Nopember',
			'12' => 'Desember'
		);
		$informasi_register		 = $this->register_model->get_data_where('id=' . $jenis_register, 'register_m_jenis_register', '-');
		$data['register_nama']	  = strtoupper($informasi_register['register_nama']);
		if($bulan == 0){
			$data['subjudul'] = strtoupper("Tahun " . $tahun);
			$data['title']	= $informasi_register['register_nama'] . ' ' . $tahun;
		} else{
			$data['subjudul'] = strtoupper("Bulan " . $nm_bulan[$bulan] . " Tahun " . $tahun);
			$data['title']	= $informasi_register['register_nama'] . ' ' . $nm_bulan[$bulan] . " Tahun " . $tahun;
		}
		$kriteria		 = "aktif='y'";
		$data['jenis_register'] = $this->register_model->get_data_where1($kriteria, 'register_m_jenis_register', '-');
		$data['register_terpilih'] =$jenis_register;
		$data['tahun_terpilih'] =$tahun;
		$data['bulan_terpilih'] =$bulan;
		$data['tahun_perkara'] = $this->register_model->tahun_perkara();
		
		
		//$data['title'] = "Cetak Register";
		$data['tujuan_switch_nama']='cetak_register_html';
		$data['buka_jenis_register'] = 'buka_register_manual';
		$data['tujuan_switch_keterangan']='Pindah Tampilan Register Elektronik';
		$nama_view_register_manual='register_'.$jenis_register;
		$this->load->view('register/' . $nama_view_register_manual, $data);
	} 
	function cetak_irh($id)
	{
		$jenis_register = 14;
		
		$sys = $this->register_model->sys_config();
		
		$informasi_register = $this->register_model->get_data_where('id=' . $id, 'register_permohonan_penetapan_ikrh', '-');
		$nama_template	  = "14.rtf";
		$real_alamat_url	= "http://" . $_SERVER['SERVER_NAME'] . dirname($_SERVER["REQUEST_URI"] . '?') . '/';
		//$real_alamat_url=str_replace("/".$this->uri->segment(4), "", $real_alamat_url);
		//$real_alamat_url=str_replace("/".$this->uri->segment(3), "", $real_alamat_url);
		$real_alamat_url	= str_replace("cetak_irh", "", $real_alamat_url);
		$real_alamat_url	= str_replace("/register/", "", $real_alamat_url);
		$source_file		= $real_alamat_url . "/templates/register/14.rtf";
		
		$template = file_get_contents($source_file);
		
		$template = str_replace('#1#', $informasi_register['urutan'], $template);
		$template = str_replace('#2#', $informasi_register['nomor_permohonan'], $template);
		$template = str_replace('#3#', $this->tanggal_indonesia($informasi_register['tanggal_pendaftaran']), $template);
		$template = str_replace('#4#', $informasi_register['nama_pemohon'], $template);
		$template = str_replace('#5#', $informasi_register['keterangan_singkat_isi_permohonan'], $template);
		$template = str_replace('#6#', $this->tanggal_indonesia($informasi_register['tanggal_penetapan_hakim']), $template);
		$template = str_replace('#7#', $informasi_register['nama_hakim'], $template);
		$template = str_replace('#8#', $informasi_register['nama_panitera'], $template);
		$template = str_replace('#9#', $this->tanggal_indonesia($informasi_register['tanggal_pelaksanaan']), $template);
		$template = str_replace('#10#', $informasi_register['tempat_pelaksanaan'], $template);
		$template = str_replace('#11#', $this->tanggal_indonesia($informasi_register['tanggal_penetapan']), $template);
		$template = str_replace('#12#', $this->amar($informasi_register['isi_penetapan']), $template);
		$template = str_replace('#13#', $informasi_register['keterangan'], $template);
		$template = str_replace('#NamaPN#', $sys['NamaPN'], $template);
		$data	 = array(
			'source_file' => $source_file,
			'register_nama' => 'Register IRH',
			'nomorperkara' => $informasi_register['nomor_permohonan'],
			'template' => $template
		);
		$this->load->view('register/register_cetak_word_semua', $data);
	}
	function cetak_register_html($jenis_register = 0, $tahun = 0,$bulan='00',$tahapan=0,$cetak=0, $perkara_id='')
	{
		$sys = $this->register_model->sys_config();
		$nama_model_register='register_'.$jenis_register;
		if($bulan=='00')
		{
			$periode='TAHUN '.$tahun; 
		}else
		{
			$periode='BULAN '.strtoupper($this->bulan_indonesia($tahun.'-'.$bulan));
		}
		if($perkara_id<>''){$periode="";}

		if($jenis_register == 1)
		{
			$register = $this->register_model->$nama_model_register($tahun, $bulan, $tahapan,$perkara_id);
			$datanya=''; 
			for ($i = 0; $i < count($register); ++$i) 
			{				
				$datanya.='<p style="text-align:center;margin:0 0 0 0;paddding:0 0 0 0">REGISTER INDUK PERKARA PERMOHONAN<br>'.$sys['NamaPN'].'<br>'.$periode.'</p><p style=text-align:right;margin:0 0 0 0;paddding:0 0 0 0>R1.PA 1P</p>';$datanya.='<table align=center> <tbody> <tr> <td width="45" valign="top"><p>1.</p></td> <td width="231" colspan="2" valign="top"><p>Nomor Urut</p></td> <td width="398" colspan="3" valign="top"><p>'.$register[$i]->nomor_urut_register.'</p></td> </tr> <tr> <td width="45" valign="top"><p>2.</p></td> <td width="231" colspan="2" valign="top"><p>Nomor Perkara</p></td> <td width="398" colspan="3" valign="top"><p><a style="text-decoration:none;color:#000" title="Cetak Register" href="'.base_url().'register/cetak_register_html/'.$jenis_register.'/'.$tahun.'/'.$bulan.'/'.$tahapan.'/1/'.$register[$i]->perkara_id.'">'.$register[$i]->nomor_perkara.'</a></p></td> </tr> <tr> <td width="45" valign="top"><p>3.</p></td> <td width="231" colspan="2" valign="top"><p>Tanggal Pendaftaran</p></td> <td width="398" colspan="3" valign="top"><p>'.$register[$i]->tanggal_pendaftaran_indonesia.'</p></td> </tr> <tr> <td width="45" rowspan="4" valign="top"><p>4.</p></td> <td width="231" colspan="2" valign="top"><p>Identitas Para Pihak Dan Kuasa Hukum</p></td> <td width="398" colspan="3" valign="top"><p>&nbsp;</p></td> </tr> <tr> <td width="45" valign="top"> <p>A.</p></td> <td width="186" valign="top"> <p>Nama, Umur, Agama, Pendidikan, Pekerjaan dan Tempat Tinggal</p></td> <td width="398" colspan="3" valign="top"> '.$this->sebutan_pihak($register[$i]->nomor_perkara,$register[$i]->identitas_p).'</td> </tr> <tr> <td width="45" valign="top"> <p>B.</p></td> <td width="186" valign="top"> <p>Tanggal Surat Kuasa Khusus</p></td> <td width="398" colspan="3" rowspan=2 valign="top"> <p>'.$this->sebutan_pihak($register[$i]->nomor_perkara,$register[$i]->tgl_nama_kuasa).'</p></td> </tr> <tr> <td width="45" valign="top"> <p>C.</p></td> <td width="186" valign="top"> <p>Nama Kuasa Hukum</p></td> </tr> <tr> <td width="45" valign="top"> <p>5.</p></td> <td width="231" colspan="2" valign="top"> <p>Petitum</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->petitum.'</p></td> </tr> <tr> <td width="45" rowspan="2" valign="top"> <p>6.</p></td> <td width="45" valign="top"> <p>A.</p></td> <td width="186" valign="top"> <p>Tanggal Penetapan Majelis Hakim</p></td> <td width="398" valign="top" colspan=3 rowspan=2><p>'; $this->dbsipp = $this->load->database("dbsipp", true); $q=$this->dbsipp->query("SELECT DISTINCT(convert_tanggal_indonesia(tanggal_penetapan)) AS penetapan,tanggal_penetapan, group_concat(CONCAT(jabatan_hakim_nama,' : ',hakim_nama) ORDER BY urutan SEPARATOR '<br>') AS HK FROM perkara_hakim_pn WHERE perkara_id=".$register[$i]->perkara_id." GROUP BY perkara_id, tahapan_id, tanggal_penetapan "); foreach ($q->result_array() as $d) { $datanya.= "<ol type='A'><li>".$d['penetapan']."</li><li>".$d['HK'].""; $q=$this->dbsipp->query("SELECT group_concat(panitera_nama ORDER BY urutan SEPARATOR '<br>') AS pp FROM perkara_panitera_pn WHERE perkara_id=".$register[$i]->perkara_id." AND tanggal_penetapan='".$d['tanggal_penetapan']."' GROUP BY perkara_id, tahapan_id, tanggal_penetapan "); foreach ($q->result_array() as $pp) { $datanya.= "<br>Panitera Pengganti : ".$pp['pp']; } $datanya.= "</ol>"; } $datanya.= '</p></td></tr> <tr> <td width="45" valign="top"> <p>B.</p></td> <td width="186" valign="top"> <p>Susunan Majelis Hakim/Panitera Pengganti</p></td> </tr> <tr> <td width="45" rowspan="2" valign="top"> <p>7.</p></td> <td width="45" valign="top"> <p>A.</p></td> <td width="186" valign="top"> <p>Tanggal Penetapan Hari Sidang</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->phs.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>B.</p></td> <td width="186" valign="top"> <p>Tanggal Sidang Pertama</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->sidangpertama.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>8.&nbsp;</p></td> <td width="231" colspan="2" valign="top"> <p>Tanggal Penundaan Sidang<br>A. Tanggal Tunda<br>B. Agenda</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penundaan_sidang.'</p></td> </tr> <tr> <td width="45" rowspan="2" valign="top"> <p>9.</p></td> <td width="45" valign="top"> <p>A.</p></td> <td width="186" valign="top"> <p>Tanggal Penetapan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->tanggalputusan.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>B.</p></td> <td width="186" valign="top"> <p>Amar Penetapan Lengkap</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->amar_putusan.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>10.</p></td> <td width="231" colspan="2" valign="top"> <p>Tanggal Minutasi</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->tanggalminutasi.'</p></td> </tr> <tr> <td width="45" rowspan="14" valign="top"> <p>11.</p></td> <td width="629" colspan="5" valign="top"> <p><strong>KASASI&nbsp;</strong></p></td> </tr> <tr> <td width="45" valign="top"> <p>A.</p></td> <td width="186" valign="top"> <p>Tanggal Akta Permohonan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->permohonan_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>B.</p></td> <td width="186" valign="top"> <p>Tanggal Surat Kuasa Khusus</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->tanggal_kuasa_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>C.</p></td> <td width="186" valign="top"> <p>Nama Kuasa Hukum</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->nama_kuasa_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>D.</p></td> <td width="186" valign="top"> <p>Tanggal Pemberitahuan Kepada Pihak Lawan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->pemberitahuan_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>E.</p></td> <td width="186" valign="top"> <p>Tanggal Penerimaan Memori</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penerimaan_memori_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>F.</p></td> <td width="186" valign="top"> <p>Tanggal Penyerahan Memori Kepada Pihak Lawan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penyerahan_memori_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>G.</p></td> <td width="186" valign="top"> <p>Tanggal Penerimaan Kontra Memori</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penerimaan_kontra_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>H.</p></td> <td width="186" valign="top"> <p>Tanggal Pengiriman Berkas</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->pengiriman_berkas_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>I.</p></td> <td width="186" valign="top"> <p>Tanggal Penerimaan Kembali Berkas</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penerimaan_berkas_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>J.</p></td> <td width="186" valign="top"> <p>Tanggal Pemberitahuan Putusan Kepada Para Pihak</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->pemberitahuan_putusan_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>K.</p></td> <td width="186" valign="top"> <p>Nomor Putusan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->nomor_putusan_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>L.</p></td> <td width="186" valign="top"> <p>Tanggal Putusan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->putusan_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>M.</p></td> <td width="186" valign="top"> <p>Amar Lengkap Putusan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->amar_putusan_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>12.</p></td> <td width="231" colspan="2" valign="top"> <p>BHT Tanggal</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->tanggal_bht.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>13.</p></td> <td width="231" colspan="2" valign="top"> <p>Jenis Perkara</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->jenis_perkara_nama.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>14.</p></td> <td width="231" colspan="2" valign="top"> <p>Keterangan / lain-Lain</p></td> <td width="398" colspan="3" valign="top"> <p>&nbsp;</p></td> </tr> </tbody> </table><p style="paddding:0 0 0 0;margin:0 0 0 0;page-break-before:always">&nbsp;</p>';
			}
		}else
		if($jenis_register == 2){
			$register = $this->register_model->$nama_model_register($tahun, $bulan, $tahapan,$perkara_id);
			for ($i = 0; $i < count($register); ++$i) 
			{				
				$datanya.='<p style="text-align:center;margin:0 0 0 0;padding:0 0 0 0">REGISTER INDUK PERKARA GUGATAN<br>'.$sys['NamaPN'].'<br>'.$periode.'</p><p style=text-align:right;margin:0 0 0 0;padding:0 0 0 0">R1.PA 1G</p>';
				$datanya.='<table align=center> <tbody> <tr> <td width="45" valign="top"> <p>1.</p></td> <td width="231" colspan="2" valign="top"> <p>Nomor Urut</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->nomor_urut_register.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>2.</p></td> <td width="231" colspan="2" valign="top"> <p>Nomor Perkara</p></td> <td width="398" colspan="3" valign="top"> <p><a style="text-decoration:none;color:#000" title="Cetak Register" href="'.base_url().'register/cetak_register_html/'.$jenis_register.'/'.$tahun.'/'.$bulan.'/'.$tahapan.'/1/'.$register[$i]->perkara_id.'">'.$register[$i]->nomor_perkara.'</a></p></td> </tr> <tr> <td width="45" valign="top"> <p>3.</p></td> <td width="231" colspan="2" valign="top"> <p>Tanggal Pendaftaran</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->tanggal_pendaftaran_indonesia.'</p></td> </tr> <tr> <td width="45" rowspan="4" valign="top"> <p>4.</p></td> <td width="231" colspan="2" valign="top"> <p>Identitas Para Pihak Dan Kuasa Hukum</p></td> <td width="398" colspan="3" valign="top"> <p>&nbsp;</p></td> </tr> <tr> <td width="45" valign="top"> <p>A.</p></td> <td width="186" valign="top"> <p>Nama, Umur, Agama, Pendidikan, Pekerjaan dan Tempat Tinggal</p></td> <td width="398" colspan="3" valign="top"> '.$this->sebutan_pihak($register[$i]->nomor_perkara,$register[$i]->identitas_p.'</p><center>melawan</center><p>'. $register[$i]->identitas_t).'</td> </tr> <tr> <td width="45" valign="top"> <p>B.</p></td> <td width="186" valign="top"> <p>Tanggal Surat Kuasa Khusus</p></td> <td width="398" colspan="3" rowspan=2 valign="top"> <p>'.$this->sebutan_pihak($register[$i]->nomor_perkara,$register[$i]->tgl_nama_kuasa).'</p></td> </tr> <tr> <td width="45" valign="top"> <p>C.</p></td> <td width="186" valign="top"> <p>Nama Kuasa Hukum</p></td> </tr> <tr> <td width="45" valign="top"> <p>5.</p></td> <td width="231" colspan="2" valign="top"> <p>Petitum</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->petitum.'</p></td> </tr> <tr> <td width="45" rowspan="2" valign="top"> <p>6.</p></td> <td width="45" valign="top"> <p>A.</p></td> <td width="186" valign="top"> <p>Tanggal Penetapan Majelis Hakim</p></td> <td width="398" valign="top" colspan=3 rowspan=2><p>';
				$this->dbsipp = $this->load->database("dbsipp", true); 
				$q=$this->dbsipp->query("SELECT DISTINCT(convert_tanggal_indonesia(tanggal_penetapan)) AS penetapan,tanggal_penetapan, group_concat(CONCAT(jabatan_hakim_nama,' : ',hakim_nama) ORDER BY urutan SEPARATOR '<br>') AS HK FROM perkara_hakim_pn WHERE perkara_id=".$register[$i]->perkara_id." GROUP BY perkara_id, tahapan_id, tanggal_penetapan "); 
				foreach ($q->result_array() as $d) 
					{
						$datanya.= "<ol type='A'><li>".$d['penetapan']."</li><li>".$d['HK']."";
						$q=$this->dbsipp->query("SELECT group_concat(panitera_nama ORDER BY urutan SEPARATOR '<br>') AS pp FROM perkara_panitera_pn WHERE perkara_id=".$register[$i]->perkara_id." AND tanggal_penetapan='".$d['tanggal_penetapan']."' GROUP BY perkara_id, tahapan_id, tanggal_penetapan "); 
						foreach ($q->result_array() as $pp) {
							$datanya.= "<br>Panitera Pengganti : ".$pp['pp']; } $datanya.= "</ol>"; 
						}
						$datanya.= '</p></td></tr> <tr> <td width="45" valign="top"> <p>B.</p></td> <td width="186" valign="top"> <p>Susunan Majelis Hakim/Panitera Pengganti</p></td> </tr> <tr> <td width="45" rowspan="2" valign="top"> <p>7.</p></td> <td width="45" valign="top"> <p>A.</p></td> <td width="186" valign="top"> <p>Tanggal Penetapan Hari Sidang</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->phs.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>B.</p></td> <td width="186" valign="top"> <p>Tanggal Sidang Pertama</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->sidangpertama.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>8.&nbsp;</p></td> <td width="231" colspan="2" valign="top"> <p>Tanggal Penundaan Sidang<br>A. Tanggal Tunda<br>B. Agenda</p></td> <td width="398" colspan="3" valign="top"> <p><ol type=1>'.$register[$i]->penundaan_sidang.'</ol></p></td> </tr> <tr> <td width="45" rowspan="6" valign="top"> <p>9.</p></td> <td width="231" colspan="2" valign="top"> <p>Mediasi</p></td> <td width="398" colspan="3" valign="top"> </td> </tr> <tr> <td width="45" valign="top"> <p>A.</p></td> <td width="186" valign="top"> <p>Tanggal Penunjukan Mediator</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penetapan_penunjukan_mediator.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>B.</p></td> <td width="186" valign="top"> <p>Nama Mediator</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->nama_gelar_mediator.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>C.</p></td> <td width="186" valign="top"> <p>Nomor/Tanggal Sertifikat Mediator</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->no_sertifikasi.'<br>'.$register[$i]->tgl_sertifikasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>D.</p></td> <td width="186" valign="top"> <p>Tanggal Laporan Mediator</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->tgl_laporan_mediator.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>E.</p></td> <td width="186" valign="top"> <p>Hasil Mediasi</p></td> <td width="398" colspan="3" valign="top"> <p>'.$this->hasil_mediasi($register[$i]->hasil_mediasi).'</p></td> </tr> <tr> <td width="45" rowspan="3" valign="top"> <p>10.</p></td> <td width="45" valign="top"> <p>A.</p></td> <td width="186" valign="top"> <p>Tanggal Putusan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->tanggalputusan.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>B.</p></td> <td width="186" valign="top"> <p>Tanggal Pemberitahuan Putusan (Dalam Hal Pihak-Pihak Tidak Hadir)</p></td> <td width="398" colspan="3" valign="top"> <p>'.$this->sebutan_pihak($register[$i]->nomor_perkara, $register[$i]->pemberitahuan_isi_putusan).'</p></td> </tr> <tr> <td width="45" valign="top"> <p>C.</p></td> <td width="186" valign="top"> <p>Amar Lengkap Putusan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->amar_putusan.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>11&nbsp;</p></td> <td width="231" colspan="2" valign="top"> <p>Tanggal Minutasi</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->tanggalminutasi.'</p></td> </tr> <tr> <td width="45" rowspan="4" valign="top"> <p>12.</p></td> <td width="231" colspan="2" valign="top"> <p>Verzet (Perlawanan)</p></td> <td width="398" colspan="3" valign="top"> <p>&nbsp;</p></td> </tr> <tr> <td width="45" valign="top"> <p>A.</p></td> <td width="186" valign="top"> <p>Tanggal Pendaftaran Verzet</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->tanggalpendaftaranverzet.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>B.</p></td> <td width="186" valign="top"> <p>Tanggal Penetapan Hari Sidang Verzet</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->tanggalpenetapansidangverzet.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>C.</p></td> <td width="186" valign="top"> <p>Tanggal Sidang Pertama</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->tanggalsidangpertamaverzet.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>13.</p></td> <td width="231" colspan="2" valign="top"> <p>Penundaan Sidang<br>A. Tanggal Tunda<br>B. Agenda</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penundaan_sidang_verzet.'</p></td> </tr> <tr> <td width="45" rowspan="2" valign="top"> <p>14.</p> <p>&nbsp;</p></td> <td width="45" valign="top"> <p>A.</p></td> <td width="186" valign="top"> <p>Tanggal Putusan Perlawanan (Verzet)</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->putusanverzet.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>B.</p></td> <td width="186" valign="top"> <p>Amar Lengkap Putusan Perlawanan (Verzet)</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->amar_putusan_verzet.'</p></td> </tr> <tr> <td width="45" rowspan="16" valign="top"> <p>15.</p></td> <td width="629" colspan="5" valign="top"> <p><strong>BANDING</strong></p></td> </tr> <tr> <td width="45" valign="top"> <p>A.</p></td> <td width="186" valign="top"> <p>Tanggal Akta Permohonan Banding</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->permohonan_banding.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>B.</p></td> <td width="186" valign="top"> <p>Tanggal Surat Kuasa Khusus</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->tanggal_kuasa_banding.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>C.</p></td> <td width="186" valign="top"> <p>Nama Kuasa Hukum</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->nama_kuasa_banding.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>D.</p></td> <td width="186" valign="top"> <p>Tanggal Pemberitauan Kepada Pihak Lawan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->pemberitahuan_permohonan_banding.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>E.</p></td> <td width="186" valign="top"> <p>Tanggal Penerimaan Memori</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penerimaan_memori_banding.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>F.</p></td> <td width="186" valign="top"> <p>Tanggal Penyerahan Memori Kepada Lawan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penyerahan_memori_banding.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>G.</p></td> <td width="186" valign="top"> <p>Tanggal Penerimaan Kontra Memori</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penerimaan_kontra_banding.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>H.</p></td> <td width="186" valign="top"> <p>Tanggal Pemberitahuan Kontra Memori Banding</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penyerahan_kontra_banding.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>I.</p></td> <td width="186" valign="top"> <p>Tanggal Inzage</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->pelaksanaan_inzage.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>J.</p></td> <td width="186" valign="top"> <p>Tanggal Pengiriman Berkas</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->pengiriman_berkas_banding.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>K.</p></td> <td width="186" valign="top"> <p>Tanggal Penerimaan Berkas</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penerimaan_kembali_berkas_banding.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>L.</p></td> <td width="186" valign="top"> <p>Tanggal Pemberitahuan Putusan Kepada Pihak-Pihak</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->pemberitahuan_putusan_banding.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>M.</p></td> <td width="186" valign="top"> <p>Nomor Putusan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->nomor_putusan_banding.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>N.</p></td> <td width="186" valign="top"> <p>Tanggal Putusan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->putusan_banding.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>0.</p></td> <td width="186" valign="top"> <p>&nbsp;Amar Lengkap Putusan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->amar_putusan_banding.'</p></td> </tr> <tr> <td width="45" rowspan="14" valign="top"> <p>16.</p></td> <td width="629" colspan="5" valign="top"> <p><strong>KASASI&nbsp;</strong></p></td> </tr> <tr> <td width="45" valign="top"> <p>A.</p></td> <td width="186" valign="top"> <p>Tanggal Akta Permohonan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->permohonan_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>B.</p></td> <td width="186" valign="top"> <p>Tanggal Surat Kuasa Khusus</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->tanggal_kuasa_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>C.</p></td> <td width="186" valign="top"> <p>Nama Kuasa Hukum</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->nama_kuasa_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>D.</p></td> <td width="186" valign="top"> <p>Tanggal Pemberitahuan Kepada Pihak Lawan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->pemberitahuan_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>E.</p></td> <td width="186" valign="top"> <p>Tanggal Penerimaan Memori</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penerimaan_memori_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>F.</p></td> <td width="186" valign="top"> <p>Tanggal Penyerahan Memori Kepada Pihak Lawan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penyerahan_memori_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>G.</p></td> <td width="186" valign="top"> <p>Tanggal Penerimaan Kontra Memori</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penerimaan_kontra_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>H.</p></td> <td width="186" valign="top"> <p>Tanggal Pengiriman Berkas</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->pengiriman_berkas_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>I.</p></td> <td width="186" valign="top"> <p>Tanggal Penerimaan Kembali Berkas</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penerimaan_berkas_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>J.</p></td> <td width="186" valign="top"> <p>Tanggal Pemberitahuan Putusan Kepada Para Pihak</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->pemberitahuan_putusan_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>K.</p></td> <td width="186" valign="top"> <p>Nomor Putusan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->nomor_putusan_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>L.</p></td> <td width="186" valign="top"> <p>Tanggal Putusan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->putusan_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>M.</p></td> <td width="186" valign="top"> <p>Amar Lengkap Putusan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->amar_putusan_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>17.</p></td> <td width="231" colspan="2" valign="top"> <p>BHT Tanggal</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->tanggal_bht.'</p></td> </tr> <tr> <td width="45" rowspan="15" valign="top"> <p>18.</p></td> <td width="629" colspan="5" valign="top"> <p><strong>PENINJAUAN KEMBALI (PK)</strong></p></td> </tr> <tr> <td width="45" valign="top"> <p>A.</p></td> <td width="186" valign="top"> <p>Tanggal Akta Permohonan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->permohonan_pk.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>B.</p></td> <td width="186" valign="top"> <p>Tanggal Surat Kuasa Khusus</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->tanggal_kuasa_pk.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>C.</p></td> <td width="186" valign="top"> <p>&nbsp;Nama Kuasa Hukum</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->nama_kuasa_pk.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>D.</p></td> <td width="186" valign="top"> <p>Tanggal Pemberitahuan Kepada Pihak Lawan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->pemberitahuan_pk.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>E.</p></td> <td width="186" valign="top"> <p>Tanggal Penerimaan Risalah PK</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penerimaan_memori_pk.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>F.</p></td> <td width="186" valign="top"> <p>Tanggal Penyerahan Risalah PK Kepada Pihak Lawan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penyerahan_memori_pk.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>G.</p></td> <td width="186" valign="top"> <p>&nbsp;Tanggal Penerimaan Jawaban</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penerimaan_kontra_pk.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>H.</p></td> <td width="186" valign="top"> <p>Tanggal Penyumpahan Novum</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->tanggal_penyumpahan_novum.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>I.</p></td> <td width="186" valign="top"> <p>Tanggal Pengiriman Berkas</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->pengiriman_berkas_pk.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>J.</p></td> <td width="186" valign="top"> <p>Tanggal Penerimaan Kembali Berkas</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penerimaan_berkas_pk.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>K.</p></td> <td width="186" valign="top"> <p>Tanggal Pemberitahuan Putusan Kepada Para Pihak</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->pemberitahuan_putusan_pk.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>L.</p></td> <td width="186" valign="top"> <p>Nomor Putusan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->nomor_putusan_pk.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>M.</p></td> <td width="186" valign="top"> <p>Tanggal Putusan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->putusan_pk.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>N.</p></td> <td width="186" valign="top"> <p>Amar Lengkap Putusan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->amar_putusan_pk.'</p></td> </tr> <tr> <td width="45" rowspan="5" valign="top"> <p>19.</p> <p>&nbsp;</p> <p>&nbsp;</p> <p>&nbsp;</p></td> <td width="629" colspan="5" valign="top"> <p><strong>EKSEKUSI</strong></p></td> </tr> <tr> <td width="45" valign="top"> <p>A.</p></td> <td width="186" valign="top"> <p>Tanggal Permohonan Eksekusi</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->permohonan_eksekusi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>B.</p></td> <td width="186" valign="top"> <p>Tanggal Penetapan (Aanmaning)</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penetapan_teguran_eksekusi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>C.</p></td> <td width="186" valign="top"> <p>Tanggal Penegoran (Aanmaning)</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->pelaksanaan_teguran_eksekusi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>D.</p></td> <td width="186" valign="top"> <p>Tanggal Pelaksanaan Eksekusi</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->pelaksanaan_sita_eksekusi.'</p></td> </tr> <tr> <td width="45" rowspan="7" valign="top"> <p>20.</p> <td width="629" colspan="5" valign="top"> <p><strong>IKRAR TALAK</strong></p></td> </tr> <tr> <td width="45" valign="top"> <p>A.</p></td> <td width="186" valign="top"> <p>Tanggal Penetapan Majelis Hakim</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penetapan_majelis_hakim_ikrar.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>B.</p></td> <td width="186" valign="top"> <p>Tanggal Penetapan Hari Sidang</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->tanggal_penetapan_sidang_ikrar.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>C.</p></td> <td width="186" valign="top"> <p>Tanggal Sidang Menurut Penetapan Hari Sidang</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->tanggal_sidang_pertama_ikrar.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>D.</p></td> <td width="186" valign="top"> <p>Tanggal Pengucapan Ikrar Talak</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->tgl_ikrar_talak.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>E.</p></td> <td width="186" valign="top"> <p>Amar Ikrar Talak</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->amar_ikrar_talak.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>F.</p></td> <td width="186" valign="top"> <p>Tanggal Penetapan Ikrar Talak</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->tanggal_penetapan_sidang_ikrar.'</p></td> </tr> <tr> <td width="45" rowspan="4" valign="top"> <p>21.</p> <p>&nbsp;</p> <p>&nbsp;</p> <p>&nbsp;</p></td> <td width="629" colspan="5" valign="top"> <p><strong>AKTA CERAI</strong></p></td> </tr> <tr> <td width="45" valign="top"> <p>A.</p></td> <td width="186" valign="top"> <p>Tanggal Akta Cerai</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->tglaktacerai.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>B.</p></td> <td width="186" valign="top"> <p>&nbsp;Nomor Akta Cerai</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->nomor_akta_cerai.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>C.</p></td> <td width="186" valign="top"> <p>Nomor Seri</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->no_seri_akta_cerai.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>22.</p></td> <td width="231" colspan="2" valign="top"> <p>Jenis Perkara</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->jenis_perkara_nama.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>23.</p></td> <td width="231" colspan="2" valign="top"> <p>Keterangan / lain-Lain</p></td> <td width="398" colspan="3" valign="top"> <p>&nbsp;</p></td> </tr> </tbody> </table><p style="page-break-before:always;margin:0 0 0 0;padding:0 0 0 0">&nbsp;</p>';
			}
		}else		
		if($jenis_register == 3){
			$register = $this->register_model->$nama_model_register($tahun, $bulan, 0);
			$datanya=''; 
			for ($i = 0; $i < count($register); ++$i) 
			{				
				$datanya.='<p style="text-align:center;margin:0px 0px 0px 0px"><b>REGISTER PERMOHONAN BANDING<br>'.$sys['NamaPN'].'<br>'.$periode.'</b></p><p style="text-align:right;margin:0px 0px 0px 0px"><b>R1.PA 2</b></p>';
				$datanya.='<table align=center> <tbody> <tr> <td width="37" valign="top"> <p>1.&nbsp;&nbsp;</p> </td> <td width="281" colspan="2" valign="top"> <p>Nomor Urut</p> </td> <td width="348" valign="top"> <p></p> </td> </tr> <tr> <td width="37" valign="top"> <p>2.</p> </td> <td width="281" colspan="2" valign="top"> <p>Tanggal Permohonan Banding</p> </td> <td width="348" valign="top"> <p>'.$register[$i]->permohonan_banding.'</p> </td> </tr> <tr> <td width="37" rowspan="4" valign="top"> <p>3.</p> </td> <td width="281" colspan="2" valign="top"> <p>Identitas Para Pihak Dan Kuasa Hukumnya</p> </td> <td width="348" valign="top"> </td> </tr> <tr> <td width="29" valign="top"> <p>A.</p> </td> <td width="252" valign="top"> <p>Nama, Umur, Agama, Pendidikan,&nbsp;Pekerjaan dan Tempat Tinggal</p> </td> <td width="348" valign="top"> <p>'.$register[$i]->pemohon_banding.'</p> </td> </tr> <tr> <td width="29" valign="top"> <p>B.</p> </td> <td width="252" valign="top"> <p>Tanggal Surat Kuasa Khusus</p> </td> <td width="348" valign="top"> <p>'.$register[$i]->tanggal_kuasa_banding.'</p> </td> </tr> <tr> <td width="29" valign="top"> <p>C.</p> </td> <td width="252" valign="top"> <p>Nama Kuasa Hukum</p> </td> <td width="348" valign="top"> <p>'.$register[$i]->nama_kuasa_banding.'</p> </td> </tr> <tr> <td width="37" valign="top"> <p>4.&nbsp;</p> </td> <td width="281" colspan="2" valign="top"> <p>Susunan Majelis Hakim / Panitera Pengganti</p> </td> <td width="348" valign="top"> <p>'.$register[$i]->majelis_hakim_nama.'</p> </td> </tr> <tr> <td width="37" rowspan="4" valign="top"> <p>5.</p> </td> <td width="281" colspan="2" valign="top"> <p>Putusan PA / Msy</p> </td> <td width="348" valign="top"> <p>&nbsp;</p> </td> </tr> <tr> <td width="29" valign="top"> <p>A.</p> </td> <td width="252" valign="top"> <p>Nomor</p> </td> <td width="348" valign="top"> <p><a style="text-decoration:none;color:#000" title="Cetak Register" href="'.base_url().'register/cetak_register_html/'.$jenis_register.'/'.$tahun.'/'.$bulan.'/'.$tahapan.'/1/'.$register[$i]->perkara_id.'">'.$register[$i]->nomor_perkara_pn.'</a></p> </td> </tr> <tr> <td width="29" valign="top"> <p>B.</p> </td> <td width="252" valign="top"> <p>Tanggal</p> </td> <td width="348" valign="top"> <p>'.$register[$i]->putusan_pn.'</p> </td> </tr> <tr> <td width="29" valign="top"> <p>C.</p> </td> <td width="252" valign="top"> <p>Tanggal Pemberitahuan</p> </td> <td width="348" valign="top"> <p>'.$register[$i]->pemberitahuan_putusan_pn.'</p> </td> </tr> <tr> <td width="37" valign="top"> <p>6.&nbsp;&nbsp;</p> </td> <td width="281" colspan="2" valign="top"> <p>Tanggal Pemberitahuan banding</p> </td> <td width="348" valign="top"> <p>'.$register[$i]->pemberitahuan_permohonan_banding.'</p> </td> </tr> <tr> <td width="37" rowspan="4" valign="top"> <p>7.</p> </td> <td width="281" colspan="2" valign="top"> <p>Memori Banding /Kontra Memori Banding</p> </td> <td width="348" valign="top"> <p>&nbsp;</p> </td> </tr> <tr> <td width="29" valign="top"> <p>A.</p> </td> <td width="252" valign="top"> <p>Tanggal Diterima</p> </td> <td width="348" valign="top"> <p>'.$register[$i]->penerimaan_memori_banding.'</p> </td> </tr> <tr> <td width="29" valign="top"> <p>B.</p> </td> <td width="252" valign="top"> <p>Tanggal penyampaian</p> </td> <td width="348" valign="top"> <p>'.$register[$i]->penyerahan_memori_banding.'</p> </td> </tr> <tr> <td width="29" valign="top"> <p>C.</p> </td> <td width="252" valign="top"> <p>Tanggal Penerimaan Kontra Memori</p> </td> <td width="348" valign="top"> <p>'.$register[$i]->penerimaan_kontra_banding.'</p> </td> </tr> <tr> <td width="37" valign="top"> <p>8.</p> </td> <td width="281" colspan="2" valign="top"> <p>Tanggal Selesai Minutasi</p> </td> <td width="348" valign="top"> <p>'.$register[$i]->minutasi_banding.'</p> </td> </tr> <tr> <td width="37" valign="top"> <p>9.</p> </td> <td width="281" colspan="2" valign="top"> <p>Tanggal Membaca / memeriksa (Inzage)</p> </td> <td width="348" valign="top"> <p></p> </td> </tr> <tr> <td width="37" valign="top"> <p>&nbsp;</p> </td> <td width="629" colspan="3" valign="top"> <p><strong>Berkas Banding </strong></p> </td> </tr> <tr> <td width="37" valign="top"> <p>10.</p> </td> <td width="281" colspan="2" valign="top"> <p>Nomor / Tanggal Surat Pengiriman</p> </td> <td width="348" valign="top"> <p>'.$register[$i]->nomor_surat_pengiriman_berkas_banding.'<br>'.$register[$i]->pengiriman_berkas_banding.'</p> </td> </tr> <tr> <td width="37" valign="top"> <p>11.&nbsp;</p> </td> <td width="281" colspan="2" valign="top"> <p>Tanggal Penerimaan Kembali</p> </td> <td width="348" valign="top"> <p>'.$register[$i]->penerimaan_kembali_berkas_banding.'</p> </td> </tr> <tr> <td width="37" rowspan="4" valign="top"> <p>12.</p> </td> <td width="281" colspan="2" valign="top"> <p>Putusan Banding</p> </td> <td width="348" valign="top"> <p>&nbsp;</p> </td> </tr> <tr> <td width="29" valign="top"> <p>A.</p> </td> <td width="252" valign="top"> <p>Nomor</p> </td> <td width="348" valign="top"> <p>'.$register[$i]->nomor_putusan_banding.'</p> </td> </tr> <tr> <td width="29" valign="top"> <p>B.</p> </td> <td width="252" valign="top"> <p>Tanggal</p> </td> <td width="348" valign="top"> <p>'.$register[$i]->putusan_banding.'</p> </td> </tr> <tr> <td width="29" valign="top"> <p>C.</p> </td> <td width="252" valign="top"> <p>Amar Lengkap Putusan</p> </td> <td width="348" valign="top"> <p>'.$register[$i]->amar_putusan_banding.'</p> </td> </tr> <tr> <td width="37" valign="top"> <p>13.</p> </td> <td width="281" colspan="2" valign="top"> <p>Susunan Majelis Hakim Tingkat Banding</p> </td> <td width="348" valign="top"> <p>'.$register[$i]->majelis_hakim_banding.'</p> </td> </tr> <tr> <td width="37" valign="top"> <p>14.</p> </td> <td width="281" colspan="2" valign="top"> <p>Tanggal Pemberitahuan Putusan Banding</p> </td> <td width="348" valign="top"> <p>'.$register[$i]->pemberitahuan_putusan_banding.'</p> </td> </tr> <tr> <td width="37" valign="top"> <p>15&nbsp;</p> </td> <td width="281" colspan="2" valign="top"> <p>Jenis Perkara</p> </td> <td width="348" valign="top"> <p>'.$register[$i]->jenis_perkara_nama.'</p> </td> </tr> <tr> <td width="37" valign="top"> <p>16.</p> </td> <td width="281" colspan="2" valign="top"> <p>Keterangan / Lain-Lain</p> </td> <td width="348" valign="top"> <p>&nbsp;</p> </td> </tr> </tbody> </table><br style="page-break-before:always">';
			}
		}else
		if($jenis_register == 4){
			$register = $this->register_model->$nama_model_register($tahun, $bulan, 0);
			$datanya=''; 
			for ($i = 0; $i < count($register); ++$i) 
			{				
				$datanya.='<p style="text-align:center">REGISTER PERMOHONAN KASASI<br>'.$sys['NamaPN'].'<br>'.$periode.'</p><p style=text-align:right>R1.PA 3</p>';
				$datanya.='<table align=center> <tbody> <tr> <td width="38" valign="top"> <p>1.</p> </td> <td width="289" colspan="2" valign="top"> <p>Nomor Urut</p> </td> <td width="313" valign="top"> <p></p> </td> </tr> <tr> <td width="38" valign="top"> <p>2.</p> </td> <td width="289" colspan="2" valign="top"> <p>Tanggal Permohonan Kasasi</p> </td> <td width="313" valign="top"> <p>'.$register[$i]->permohonan_kasasi.'</p> </td> </tr> <tr> <td width="38" rowspan="4" valign=top> <p>3.</p>  </td> <td colspan="3" width="602" valign=top> <p>Identitas Dan Kuasa Hukumnya</p> </td> </tr> <tr> <td width="29" valign=top> <p>A.</p> </td> <td width="260" valign=top> <p>Nama, Umur, Agama, Pendidikan,&nbsp;Pekerjaan dan Tempat Tinggal</p> </td> <td width="313" valign="top"> <p>'.$register[$i]->pemohon_kasasi.''.$register[$i]->termohon_kasasi.'</p> </td> </tr> <tr> <td width="29" valign="top"> <p>B.</p> </td> <td width="260" valign="top"> <p>Tanggal Surat Kuasa Khusus</p> </td> <td width="313" valign="top"> <p>'.$register[$i]->tanggal_kuasa_kasasi.'</p> </td> </tr> <tr> <td width="29" valign="top"> <p>C.</p> </td> <td width="260" valign="top"> <p>Nama Kuasa Hukum</p> </td> <td width="313" valign="top"> <p>'.$register[$i]->nama_kuasa_kasasi.'</p> </td> </tr> <tr> <td width="38" rowspan="4" valign="top"> <p>4.</p>  </td> <td width="602" colspan="3" valign="top"> <p>Putusan PA / Msy</p> </td> </tr> <tr> <td width="29" valign="top"> <p>A.</p> </td> <td width="260" valign="top"> <p>Nomor</p> </td> <td width="313" valign="top"> <p>'.$register[$i]->nomor_perkara.'</p> </td> </tr> <tr> <td width="29" valign="top"> <p>B.</p> </td> <td width="260" valign="top"> <p>Tanggal</p> </td> <td width="313" valign="top"> <p>'.$register[$i]->putusan_pn.'</p> </td> </tr> <tr> <td width="29" valign="top"> <p>C.</p> </td> <td width="260" valign="top"> <p>Tanggal Pemberitahuan</p> </td> <td width="313" valign="top"> <p>'.$register[$i]->pemberitahuan_putusan.'</p> </td> </tr> <tr> <td width="38" rowspan="4" valign="top"> <p>5.</p>  </td> <td width="602" colspan="3" valign="top"> <p>Putusan PTA / Ms Aceh</p> </td> </tr> <tr> <td width="29" valign="top"> <p>A.</p> </td> <td width="260" valign="top"> <p>Nomor</p> </td> <td width="313" valign="top"> <p>'.$register[$i]->nomor_perkara_banding.'</p> </td> </tr> <tr> <td width="29" valign="top"> <p>B.</p> </td> <td width="260" valign="top"> <p>Tanggal</p> </td> <td width="313" valign="top"> <p>'.$register[$i]->putusan_banding.'</p> </td> </tr> <tr> <td width="29" valign="top"> <p>C.</p> </td> <td width="260" valign="top"> <p>Tanggal Pemberitahuan</p> </td> <td width="313" valign="top"> <p>'.$register[$i]->pemberitahuan_putusan_banding.'</p> </td> </tr> <tr> <td width="38" valign="top"> <p>6.</p> </td> <td width="289" colspan="2" valign="top"> <p>Tanggal Pemberitahuan Pernyataan Kasasi Kepada Lawan</p> </td> <td width="313" valign="top"> <p>'.$register[$i]->pemberitahuan_kasasi.'</p> </td> </tr> <tr> <td width="38" valign="top"> <p>7.</p> </td> <td width="289" colspan="2" valign="top"> <p>Tanggal Penerimaan&nbsp;Memori Kasasi</p> </td> <td width="313" valign="top"> <p>'.$register[$i]->penerimaan_memori_kasasi.'</p> </td> </tr> <tr> <td width="38" valign="top"> <p>8.</p> </td> <td width="289" colspan="2" valign="top"> <p>Tanggal Penyerahan Memori Kasasi kepada Pihak Lawan</p> </td> <td width="313" valign="top"> <p>'.$register[$i]->penyerahan_memori_kasasi.'</p> </td> </tr> <tr> <td width="38" valign="top"> <p>9.</p> </td> <td width="289" colspan="2" valign="top"> <p>Tanggal Penerimaan Kontra</p> </td> <td width="313" valign="top"> <p>'.$register[$i]->penerimaan_kontra_kasasi.'</p> </td> </tr> <tr> <td width="38" valign="top"> <p>10.</p> </td> <td width="289" colspan="2" valign="top"> <p>Nomor / Tanggal Surat Pengiriman Berkas Kasasi</p> </td> <td width="313" valign="top"> <p>'.$register[$i]->nomor_surat_pengiriman_berkas_kasasi.'<br>'.$register[$i]->pengiriman_berkas_kasasi.'</p> </td> </tr> <tr> <td width="38" valign="top"> <p>11.</p> </td> <td width="289" colspan="2" valign="top"> <p>Tanggal Penerimaan Kembali</p> </td> <td width="313" valign="top"> <p>'.$register[$i]->penerimaan_berkas_kasasi.'</p> </td> </tr> <tr> <td width="38" rowspan="4" valign="top"> <p>12.</p>   </td> <td width="602" colspan="3" valign="top"> <p><strong>Putusan Kasasi </strong></p> </td> </tr> <tr> <td width="29" valign="top"> <p>A.</p> </td> <td width="260" valign="top"> <p>Nomor</p> </td> <td width="313" valign="top"> <p>'.$register[$i]->nomor_putusan_kasasi.'</p> </td> </tr> <tr> <td width="29" valign="top"> <p>B.</p> </td> <td width="260" valign="top"> <p>Tanggal</p> </td> <td width="313" valign="top"> <p>'.$register[$i]->putusan_kasasi.'</p> </td> </tr> <tr> <td width="29" valign="top"> <p>C.&nbsp;</p> </td> <td width="260" valign="top"> <p>Amar Lengkap Putusan</p> </td> <td width="313" valign="top"> <p>'.$register[$i]->amar_putusan_kasasi.'</p> </td> </tr> <tr> <td width="38" valign="top"> <p>13.</p> </td> <td width="289" colspan="2" valign="top"> <p>Susunan Majelis Hakim</p> </td> <td width="313" valign="top"> <p>'.$register[$i]->majelis_hakim_kasasi.'</p> </td> </tr> <tr> <td width="38" valign="top"> <p>14.</p> </td> <td width="289" colspan="2" valign="top"> <p>Tanggal Pemberitahuan</p> </td> <td width="313" valign="top"> <p>'.$register[$i]->pemberitahuan_putusan_kasasi.'</p> </td> </tr> <tr> <td width="38" valign="top"> <p>15.</p> </td> <td width="289" colspan="2" valign="top"> <p>Keterangan</p> </td> <td width="313" valign="top">&nbsp;</td> </tr> </tbody> </table><br>';
			}
		}else
		if($jenis_register == 5){
			$register = $this->register_model->$nama_model_register($tahun, $bulan, 0);
			$datanya=''; 
			for ($i = 0; $i < count($register); ++$i) 
			{				
				$datanya.='<p style="text-align:center;margin:0 0 0 0;paddding:0 0 0 0">REGISTER PERMOHONAN PENINJAUAN KEMBALI<br>'.$sys['NamaPN'].'<br>'.$periode.'</p><p style=text-align:right;margin:0 0 0 0;paddding:0 0 0 0>R1.PA 4</p>';
				$datanya.='  <table align=center><tbody> <tr> <td width="38" valign="top"> <p>1.&nbsp;</p> </td> <td width="308" colspan="2" valign="top"> <p>Nomor Urut</p> </td> <td width="331" valign="top"> <p></p> </td> </tr> <tr valign="top"> <td width="38" valign="top"> <p>2.&nbsp;</p> </td> <td width="308" colspan="2" valign="top"> <p>Tanggal Permohonan PK</p> </td> <td width="331" valign="top"> <p>'.$register[$i]->permohonan_pk.'</p> </td> </tr> <tr> <td width="38" rowspan="4" valign="top"> <p>3</p> </td> <td width="308" colspan="2" valign="top"> <p>Permohon Peninjauan Kembali Dan Kuasa Hukumnya</p> </td> <td width="331" valign="top"> <p>&nbsp;</p> </td> </tr> <tr> <td width="29" valign="top"> <p>A.</p> </td> <td width="279" valign="top"> <p>Nama, Umur, Agama, Pendidikan, Pekerjaan dan Tempat Tinggal</p> </td> <td width="331" valign="top"> <p align="justify">'.$register[$i]->pemohon_pk.'</p> </td> </tr> <tr> <td width="29" valign="top"> <p>B.</p> </td> <td width="279" valign="top"> <p>Tanggal Surat Kuasa Khusus</p> </td> <td width="331" valign="top"> <p>'.$register[$i]->tanggal_kuasa_pk.'</p> </td> </tr> <tr> <td width="29" valign="top"> <p>C.</p> </td> <td width="279" valign="top"> <p>Nama Kuasa Hukum</p> </td> <td width="331" valign="top"> <p>'.$register[$i]->nama_kuasa_pk.'</p> </td> </tr> <tr> <td width="38" rowspan="4" valign="top" > <p>4.</p> </td> <td width="308" colspan="2" valign="top"> <p>Nomor Perkara</p> </td> <td width="331" valign="top"> <p>&nbsp;</p> </td> </tr> <tr> <td width="29" valign="top"> <p>A.</p> </td> <td width="279" valign="top"> <p>PA / Msy</p> </td> <td width="331" valign="top"> <p>'.$register[$i]->nomor_perkara_pn.'</p> </td> </tr> <tr> <td width="29" valign="top"> <p>B.</p> </td> <td width="279" valign="top"> <p>PT / Ms Aceh</p> </td> <td width="331" valign="top"> <p>'.$register[$i]->nomor_putusan_banding.'</p> </td> </tr> <tr> <td width="29" valign="top"> <p>C.</p> </td> <td width="279" valign="top"> <p>Mahkamah Agung</p> </td> <td width="331" valign="top"> <p>'.$register[$i]->nomor_putusan_kasasi.'</p> </td> </tr> <tr> <td width="38" rowspan="4" valign="top"> <p>5.</p></td> <td width="308" colspan="2"> <p>Termohon Peninjauan Kembali Dan Kuasa Hukumnya</p> </td> <td width="331"> <p>&nbsp;</p> </td> </tr> <tr> <td width="29" valign="top"> <p>A.</p> </td> <td width="279" valign="top"> <p>Nama, Umur, Agama, Pendidikan,&nbsp;Pekerjaan dan Tempat Tinggal</p> </td> <td width="331" valign="top"> <p  align="justify">'.$register[$i]->termohon_pk.'</p> </td> </tr> <tr> <td width="29" valign="top"> <p>B.</p> </td> <td width="279" valign="top"> <p>Tanggal Surat Kuasa Khusus</p> </td> <td width="331" valign="top"> <p>'.$register[$i]->tanggal_kuasa_pk_t.'</p> </td> </tr> <tr> <td width="29" valign="top"> <p>C.</p> </td> <td width="279" valign="top"> <p>Nama Kuasa Hukum</p> </td> <td width="331" valign="top"> <p>'.$register[$i]->nama_kuasa_pk_t.'</p> </td> </tr> <tr> <td width="38" valign="top"> <p>6. </p> </td> <td width="308" colspan="2" valign="top"> <p>Tanggal Pemberitahuan Putusan Yang Telah Mempunyai Kekuatan Hukum</p> </td> <td width="331" valign="top"> <p>'.$register[$i]->pemberitahuan_putusan_kasasi.'</p> </td> </tr> <tr> <td width="38" valign="top"> <p>7. </p> </td> <td width="308" colspan="2" valign="top"> <p>Alasan Peninjauan Kembali</p> </td> <td width="331" valign="top"> <p>'.$register[$i]->alasan_pk.'</p> </td> </tr> <tr> <td width="38" valign="top"> <p>8. &nbsp;</p> </td> <td width="308" colspan="2" valign="top"> <p>Tanggal Pemberitahuan Permohonan PK dan Risalah PK</p> </td> <td width="331" valign="top"> <p>'.$register[$i]->pemberitahuan_pk.'</p> </td> </tr> <tr> <td width="38" valign="top"> <p>9.</p> </td> <td width="308" colspan="2" valign="top"> <p>Tanggal Penerimaan Jawaban Risalah PK</p> </td> <td width="331" valign="top"> <p>'.$register[$i]->penerimaan_memori_pk.'</p> </td> </tr> <tr> <td width="38" rowspan="3" valign="top"> <p>10.</p> </td> <td width="308" colspan="2" valign="top"> <p>Berkas PK</p> </td> <td width="331" valign="top"> <p>&nbsp;</p> </td> </tr> <tr> <td width="29" valign="top"> <p>A.</p> </td> <td width="279" valign="top"> <p>Nomor Pengiriman</p> </td> <td width="331" valign="top"> <p>'.$register[$i]->nomor_surat_pengiriman_berkas_pk.'</p> </td> </tr> <tr> <td width="29" valign="top"> <p>B.</p> </td> <td width="279" valign="top"> <p>Tanggal Pengiriman</p> </td> <td width="331" valign="top"> <p>'.$register[$i]->pengiriman_berkas_pk.'</p> </td> </tr> <tr> <td width="38" valign="top"> <p>11.&nbsp;&nbsp;</p> </td> <td width="308" colspan="2"> <p>Tanggal Penerimaan Kembali</p> </td> <td width="331"> <p>'.$register[$i]->penerimaan_berkas_pk.'</p> </td> </tr> <tr> <td width="38" rowspan="4" valign="top"> <p>12.&nbsp;</p></td> <td width="308" colspan="2"> <p>Putusan Peninjauan Kembali (PK)</p> </td> <td width="331"> <p>&nbsp;</p> </td> </tr> <tr> <td width="29" valign="top"> <p>A.</p> </td> <td width="279" valign="top"> <p>Nomor</p> </td> <td width="331" valign="top"> <p>'.$register[$i]->nomor_putusan_pk.'</p> </td> </tr> <tr> <td width="29" valign="top"> <p>B.</p> </td> <td width="279" valign="top"> <p>Tanggal</p> </td> <td width="331" valign="top"> <p>'.$register[$i]->putusan_pk.'</p> </td> </tr> <tr> <td width="29" valign="top"> <p>C.&nbsp;</p> </td> <td width="279" valign="top"> <p>Amar Lengkap Putusan</p> </td> <td width="331" valign="top"> <p>'.$register[$i]->amar_putusan_pk.'</p> </td> </tr> <tr> <td width="38" valign="top"> <p>13.</p> </td> <td width="308" colspan="2" valign="top"> <p>Susunan Majelis Hakim</p> </td> <td width="331" valign="top"> <p>'.$register[$i]->majelis_hakim_pk.'</p> </td> </tr> <tr> <td width="38" valign="top"> <p>14.&nbsp;</p> </td> <td width="308" colspan="2" valign="top"> <p>Tanggal Pemberitahuan Amar Putusan</p> </td> <td width="331" valign="top"> <p>'.$register[$i]->pemberitahuan_putusan_pk.'</p> </td> </tr> <tr> <td width="38" valign="top"> <p>15.&nbsp;</p> </td> <td width="308" colspan="2" valign="top"> <p>Keterangan</p> </td> <td width="331" valign="top"> <p>'.$register[$i]->catatan_putusan_pk.'</p> </td> </tr> </tbody> </table> <p style="page-break-before:always;margin:0 0 0 0;paddding:0 0 0 0">&nbsp;</p>';
			}
		}else
		if($jenis_register == 8){
			$register = $this->register_model->$nama_model_register($tahun, $bulan, 0);
			$datanya='<table style="border:none;width:100%"><tr><td style="border:none;text-align:center"><b>REGISTER KUASA KHUSUS</b><br><b>'.$sys['NamaPN'].'</b><br><b>'.$periode.'</b></td></tr><tr><td style="border:none;text-align:right"><b>R1.PA.7</b></td></tr></table>';
			
			for ($i = 0; $i < count($register); ++$i) 
			{
				$datanya.='<table border="1"  style="font-size: 12pt" style="width: 100%"><tr><td style="width:5%">1.</td><td style="width:40%">Nomor</td><td style="width:45%">'.$register[$i]->nomor_kuasa.'</td></tr><tr><td valign=top valign=top>2.</td><td valign=top>Tanggal Pendaftaran Surat Kuasa </td><td valign=top>'.$register[$i]->tgl.'</td></tr><tr><td valign=top>3.</td><td valign=top>Identitas Pemberi Kuasa</td><td valign=top>'.$register[$i]->nama_p.'</td></tr><tr><td valign=top valign=top>4.</td><td valign=top>Identitas Penerima Kuasa</td><td>'.$register[$i]->nama.'</td></tr><tr><td>5.</td><td>Status Penerima Kuasa</td><td>'.$register[$i]->pekerjaan.'</td></tr><tr><td valign=top>6.</td><td valign=top>Tingkat Pengadilan PA / Msy / PTA / Msy.P / MA </td><td valign=top>'.$register[$i]->nomor_perkara.'</td></tr><tr><td valign=top>7.</td><td valign=top>Tanggal Surat Kuasa</td><td>'.$register[$i]->tanggal_kuasa.'</td></tr><tr><td>8.</td><td>Keterangan</td><td>'.$register[$i]->keterangan .'</td></tr></table><br>';
			}
		}else
		if($jenis_register == 9){
			$perkara_id=str_replace("_","/", $perkara_id);
			$register = $this->register_model->$nama_model_register($tahun, $bulan, 0,$perkara_id);
			$datanya='<table style="border:none;width:100%"><tr><td style="border:none;text-align:center"><b>REGISTER PERMOHONAN EKSEKUSI</b><br><b>'.$sys['NamaPN'].'</b><br><b>'.$periode.'</b></td></tr><tr><td style="border:none;text-align:right"><b>R1.PA.8</b></td></tr></table>';
			
			for ($i = 0; $i < count($register); ++$i) 
			{
				$datanya.='<table style="border:none;width:100%"> <tbody><tr valign="top"> <td width="37"> <p>1. </p> </td> <td width="271" colspan="2"> <p>Nomor Urut</p> </td> <td width="352"> <p>'.$register[$i]->nomor_register_eksekusi.'</p> </td> </tr> <tr valign="top"> <td width="37"> <p>2. </p> </td> <td width="271" colspan="2"> <p>Tanggal Pendaftaran</p> </td> <td width="352"> <p>'.$register[$i]->permohonan_eksekusi.'</p> </td> </tr> <tr valign="top"> <td width="37"> <p>3. </p> </td> <td width="271" colspan="2"> <p>Identitas Pemohon dan Termohon</p> </td> <td width="352"> <p>'.$register[$i]->identitas_p.'<br><br>'.$register[$i]->identitas_t.'</p> </td> </tr> <tr valign="top"> <td width="37"> <p>4.</p> </td> <td width="271" colspan="2"> <p>Jenis Eksekusi</p> </td> <td width="352"> <p>'.$register[$i]->jenis_ht_text.'</p> </td> </tr> <tr valign="top"> <td width="37" rowspan="7"> <p>5.</p> </td> <td width="271" colspan="2"> <p>Nomor dan Tanggal</p> </td> <td width="352"> <p>&nbsp;</p> </td> </tr> <tr> <td width="44"> <p>A.</p> </td> <td width="228"> <p>Putusan PA / Msy</p> </td> <td width="352"> <p>'.$register[$i]->nomor_perkara_pn.'</p> <p>'.$this->tanggal_kosong($register[$i]->putusan_pn).'</p> </td> </tr> <tr> <td width="44"> <p>B.</p> </td> <td width="228"> <p>Putusan PTA / Msy.P</p> </td> <td width="352"> <p>'.$register[$i]->nomor_perkara_banding.'</p> <p>'.$this->tanggal_kosong($register[$i]->putusan_banding).'</p> </td> </tr> <tr> <td width="44"> <p>C.</p> </td> <td width="228"> <p>Putusan Kasasi</p> </td> <td width="352"> <p>'.$register[$i]->nomor_perkara_kasasi.'<br>'.$this->tanggal_kosong($register[$i]->putusan_kasasi).'</p> </td> </tr> <tr> <td width="44"> <p>D.</p> </td> <td width="228"> <p>Putusan Peninjauan Kembali</p> </td> <td width="352"> <p>'.$register[$i]->nomor_perkara_pk.'<br>'.$this->tanggal_kosong($register[$i]->putusan_pk).'</p> </td> </tr> <tr> <td width="44"> <p>E.</p> </td> <td width="228"> <p>Hak Tanggungan</p> </td> <td width="352"> <p>-</p> </td> </tr> <tr> <td width="44"> <p>F.</p> </td> <td width="228"> <p>Arbitrase Dan Pendaftaran</p> </td> <td width="352"> <p>&nbsp;-</p> </td> </tr> <tr valign="top"> <td width="37"> <p>6.&nbsp;</p> </td> <td width="271" colspan="2"> <p>Objek Eksekusi</p> </td> <td width="352"> <p>'.$register[$i]->eksekusi_amar_putusan.'</p> </td> </tr> <tr valign="top"> <td width="37"> <p>7. &nbsp;</p> </td> <td width="271" colspan="2"> <p>Tanggal Penetapan Aanmaning</p> </td> <td width="352"> <p>'.$this->tanggal_kosong($register[$i]->penetapan_teguran_eksekusi).'</p> </td> </tr> <tr valign="top"> <td width="37"> <p>8. &nbsp;</p> </td> <td width="271" colspan="2"> <p>Tanggal Aanmaning</p> </td> <td width="352"> <p>'.$this->tanggal_kosong($register[$i]->pelaksanaan_teguran_eksekusi).'</p> </td> </tr> <tr valign="top"> <td width="37"> <p>9. &nbsp;</p> </td> <td width="271" colspan="2"> <p>Penetapan Eksekusi</p> </td> <td width="352"> <p>'.$this->tanggal_kosong($register[$i]->penetapan_sita_eksekusi).'</p> </td> </tr> <tr valign="top"> <td width="37"> <p>10.</p> </td> <td width="271" colspan="2"> <p>Eksekusi</p> </td> <td width="352"> <p>&nbsp;</p> </td> </tr> <tr valign="top"> <td width="37"> <p>&nbsp;</p> </td> <td width="44"> <p>A.</p> </td> <td width="228"> <p>Eksekusi riil/ pengosongan</p> </td> <td width="352"> <p>'.$this->tanggal_kosong($register[$i]->pelaksanaan_eksekusi_rill).'</p> </td> </tr> <tr valign="top"> <td width="37"> <p>&nbsp;</p> </td> <td width="44"> <p>B.</p> </td> <td width="228"> <p>Eksekusi Lelang</p> </td> <td width="352"> <p>&nbsp;</p> </td> </tr> <tr valign="top"> <td width="37"> <p>&nbsp;</p> </td> <td width="44"> <p>&nbsp;</p> </td> <td width="228"> <p>1. &nbsp; Tanggal Penetapan Sita Eksekusi</p> </td> <td width="352"> <p>'.$this->tanggal_kosong($register[$i]->pelaksanaan_eksekusi_rill).'</p> </td> </tr> <tr valign="top"> <td width="37"> <p>&nbsp;</p> </td> <td width="44"> <p>&nbsp;</p> </td> <td width="228"> <p>2. &nbsp; Tanggal Pelaksanaan Sita</p> </td> <td width="352"> <p>'.$this->tanggal_kosong($register[$i]->pelaksanaan_sita_eksekusi).'</p> </td> </tr> <tr valign="top"> <td width="37"> <p>&nbsp;</p> </td> <td width="44"> <p>&nbsp;</p> </td> <td width="228"> <p>3. &nbsp; Tanggal Pendaftaran Sita</p> </td> <td width="352"> <p>&nbsp;</p> </td> </tr> <tr valign="top"> <td width="37"> <p>'.$this->tanggal_kosong($register[$i]->pendaftaran_sita).'</p> </td> <td width="44"> <p>&nbsp;</p> </td> <td width="228"> <p>4. &nbsp; Tanggal Penetapan Lelang</p> </td> <td width="352"> <p>'.$this->tanggal_kosong($register[$i]->penetapan_sita_eksekusi).'</p> </td> </tr> <tr valign="top"> <td width="37"> <p>&nbsp;</p> </td> <td width="44"> <p>&nbsp;</p> </td> <td width="228"> <p>5. &nbsp; Tanggal Pelaksanaan Lelang</p> </td> <td width="352"> <p>'.$this->tanggal_kosong($register[$i]->pelaksanaan_eksekusi_lelang).'</p> </td> </tr> <tr valign="top"> <td width="37"> <p>&nbsp;</p> </td> <td width="44"> <p>&nbsp;</p> </td> <td width="228"> <p>6. &nbsp; Tanggal Penyerahan Hasil Lelang</p> </td> <td width="352"> <p>'.$this->tanggal_kosong($register[$i]->penyerahan_hasil_lelang).'</p> </td> </tr> <tr valign="top"> <td width="37"> <p>&nbsp;</p> </td> <td width="44"> <p>&nbsp;</p> </td> <td width="228"> <p>7. &nbsp; Tanggal Permohonan Pengosongan</p> </td> <td width="352"> <p>'.$register[$i]->permohonan_pengosongan.'</p> </td> </tr> <tr valign="top"> <td width="37"> <p>&nbsp;</p> </td> <td width="44"> <p>&nbsp;</p> </td> <td width="228"> <p>8. &nbsp; Tanggal Penetapan Pengosongan</p> </td> <td width="352"> <p>'.$register[$i]->penetapan_pengosongan.'</p> </td> </tr> <tr valign="top"> <td width="37"> <p>&nbsp;</p> </td> <td width="44"> <p>&nbsp;</p> </td> <td width="228"> <p>9. &nbsp; Tanggal Pelaksanaan Pengosongan</p> </td> <td width="352"> <p>'.$register[$i]->pelaksanaan_pengosongan.'</p> </td> </tr> <tr valign="top"> <td width="37"> <p>&nbsp;</p> </td> <td width="44"> <p>C.</p> </td> <td width="228"> <p>Eksekusi Hak Tanggungan</p> </td> <td width="352"> <p>&nbsp;</p> </td> </tr> <tr valign="top"> <td width="37"> <p>&nbsp;</p> </td> <td width="44"> <p>&nbsp;</p> </td> <td width="228"> <p>1. &nbsp; Tanggal Penetapan Sita Eksekusi Lelang</p> </td> <td width="352"> <p>'.$this->tanggal_kosong($register[$i]->penetapan_perintah_eksekusi_lelang_ht).'</p> </td> </tr> <tr valign="top"> <td width="37"> <p>&nbsp;</p> </td> <td width="44"> <p>&nbsp;</p> </td> <td width="228"> <p>2. &nbsp; Tanggal Pelaksanaan Sita</p> </td> <td width="352"> <p>'.$this->tanggal_kosong($register[$i]->pelaksanaan_eksekusi_lelang_ht).'</p> </td> </tr> <tr valign="top"> <td width="37"> <p>&nbsp;</p> </td> <td width="44"> <p>&nbsp;</p> </td> <td width="228"> <p>3. &nbsp; Tanggal Pendaftaran Sita</p> </td> <td width="352"> <p>'.$this->tanggal_kosong($register[$i]->pendaftaran_sita_ht).'</p> </td> </tr> <tr valign="top"> <td width="37"> <p>&nbsp;</p> </td> <td width="44"> <p>&nbsp;</p> </td> <td width="228"> <p>4. &nbsp; Tanggal Penetapan Lelang</p> </td> <td width="352"> <p>'.$this->tanggal_kosong($register[$i]->penetapan_perintah_eksekusi_lelang_ht).'</p> </td> </tr> <tr valign="top"> <td width="37"> <p>&nbsp;</p> </td> <td width="44"> <p>&nbsp;</p> </td> <td width="228"> <p>5. &nbsp; Tanggal Pelaksanaan Lelang</p> </td> <td width="352"> <p>'.$this->tanggal_kosong($register[$i]->pelaksanaan_eksekusi_lelang_ht).'</p> </td> </tr> <tr valign="top"> <td width="37"> <p>&nbsp;</p> </td> <td width="44"> <p>&nbsp;</p> </td> <td width="228"> <p>6. Tanggal Penyerahan Hasil Lelang</p> </td> <td width="352"> <p>'.$this->tanggal_kosong($register[$i]->penyerahan_hasil_lelang_ht).'</p> </td> </tr> <tr valign="top"> <td width="37"> <p>11.</p> </td> <td width="271" colspan="2"> <p>Tanggal Pengangkatan Sita</p> </td> <td width="352"> <p>'.$register[$i]->pengangkatan_sita.'</p> </td> </tr> <tr valign="top"> <td width="37"> <p>12.</p> </td> <td width="271" colspan="2"> <p>Keterangan</p> </td> <td width="352"> <p>'.$register[$i]->catatan_eksekusi.'</p> </td> </tr> </tbody> </table>';
			}
		}else
		if($jenis_register == 10){
			$register = $this->register_model->$nama_model_register($tahun, $bulan, 0);
			$datanya='';
			$datanya.='<table style="border:none;font-size: 12pt; width: 100%"><tr><td style="border:none;text-align:center">REGISTER AKTA CERAI<br>'.$sys['NamaPN'].'<br>'.$periode.'</td></tr><tr><td style="text-align:right;border:none">R1.PA9</td></tr></table>';
			for ($i = 0; $i < count($register); ++$i) 
			{
				if(strlen($register[$i]->nomorkasasi)<>0 AND strlen($register[$i]->nomorpk)<>0)
				{
					$kolom_putusan_ma="Kasasi<br>".$register[$i]->nomorkasasi."<br>".$register[$i]->putusankasasi."<br>Peninjauan Kembali<br>".$register[$i]->nomorpk."<br>".$register[$i]->putusanpk;
				}else
				if(strlen($register[$i]->nomorkasasi)<>0 AND strlen($register[$i]->nomorpk)==0)
				{
					$kolom_putusan_ma="Kasasi<br>".$register[$i]->nomorkasasi."<br>".$register[$i]->putusankasasi;
				}else 
				{
					$kolom_putusan_ma="-";
				}
				if($register[$i]->bain_raji=="cari")
				{
							//amar
					$amar_putusan=strtolower(strip_tags($register[$i]->amar_putusan));
					$amar_putusan=str_replace("   ", ' ', strip_tags($amar_putusan));
					$amar_putusan=str_replace("  ", ' ', strip_tags($amar_putusan));
					$amar_putusan=str_replace("'", "", strip_tags($amar_putusan));
						   // $amar_putusan=strtolower($amar_putusan);
					$amar_putusan = preg_replace('/[^a-z]/i','',$amar_putusan);
					$amar_putusan=str_replace(" ", "", strip_tags($amar_putusan));

					if(stristr($amar_putusan, 'khuli') !== false OR stristr($amar_putusan, 'khulu') !== false  OR stristr($amar_putusan, 'taliktalak') !== false  OR stristr($amar_putusan, 'takliktalak') !== false  )
					{
						$keterangan_perceraian='Khulu';
					}else
					if(stristr($amar_putusan, 'insughra') !== false OR stristr($amar_putusan, 'insugrho') !== false OR stristr($amar_putusan, 'insugro') !== false OR stristr($amar_putusan, 'insugra') !== false OR stristr($amar_putusan, 'bainshugra') !== false OR stristr($amar_putusan, 'inshughro') !== false  OR stristr($amar_putusan, 'inshughra') !== false )   
					{
						$keterangan_perceraian='Ba\'in Sughra';
					}else
					{
						$keterangan_perceraian='Ba\'in Kubra';
					}
				}else
				{
					$keterangan_perceraian='Raj\'i';
				}
				
				$datanya.='<table border="1"  style="font-size: 12p;width: 100%"><tr><td style="width:5%">1.</td><td style="width:40%">No Urut </td><td style="width:45%">'.$register[$i]->nomor_urut_akta_cerai.'</td></tr><tr><td valign=top>2.</td><td valign=top>Nama Penggugat / Pemohon</td><td>'.$register[$i]->nama_p.'</td></tr><tr><td valign=top>3.</td><td valign=top>Nama Tergugat / Termohon</td><td>'.$register[$i]->nama_t.'</td></tr><tr><td rowspan=2  valign=top>4.</td><td>A. Tanggal BHT PTSN CG </td><td>'.$register[$i]->bht_indo.'</td></tr><tr><td>B. Tanggal Ikrar Talak </td><td>'.$register[$i]->ikrar_indo.'</td></tr><tr><td valign=top>5.</td><td valign=top>Nomor Dan Tanggal Akta Cerai </td><td valign=top>'.$register[$i]->nomor_akta_cerai.'<br>'.$register[$i]->tgl_akta_indo.'<br></td></tr><tr><td valign=top>6.</td><td valign=top>Nomor Dan Tanggal Putusan PA / Msy  </td><td valign=top>'.$register[$i]->nomor_perkara.'<br>'.$register[$i]->tanggal_putusan_indo.'</td></tr><tr><td valign=top>7.</td><td valign=top>Nomor Dan Tanggal Putusan PTA / Ms. Aceh </td><td>'.$register[$i]->nomorbanding.'<br>'.$register[$i]->putusan_banding_indo.'</td></tr><tr><td valign=top valign=top>8.</td><td valign=top>Nomor Dan Tanggal Putusan MA-RI</td><td valign=top>'.$kolom_putusan_ma."</td> </tr><tr><td valign=top>9.</td><td>Nomor Seri Akta Cerai</td><td>".$no_seri_akta_cerai."</td> </tr><tr><td valign=top>10.</td><td>Talak Roj'i / Bain Sughro / Bain Kubro / Khu'lu</td><td valign=top>".$keterangan_perceraian."</td> </tr><tr><td valign=top>11.</td><td>Talak Ke-1 , 2 , 3</td><td>".$register[$i]->perceraian_ke."</td> </tr><tr><td valign=top rowspan=2>12.</td><td valign=top>A. Nomor dan Tanggal Duplikat/Kutipan Akta Nikah</td><td valign=top>".$register[$i]->no_kutipan_akta_nikah."<br>".$register[$i]->kutipan_indo."</td> </tr><tr><td valign=top>B. Diterbitkan oleh KUA</td><td valign=top>".$register[$i]->kua_tempat_nikah."</td> </tr><tr><td valign=top>13.</td><td valign=top>Tanggal Penyerahan</td><td>P:".$register[$i]->penyerahan_p_indo."<br>T:".$register[$i]->penyerahan_t_indo."</td> </tr><tr><td valign=top>14.</td><td>Keterangan</td><td></td> </tr></table><p style='page-break-before:always'>&nbsp;</p>";
			}
			//$datanya='';
		}else
		if($jenis_register == 11){
			$register = $this->register_model->$nama_model_register($tahun, $bulan, 0);
			$datanya='';
			for ($i = 0; $i < count($register); ++$i) 
			{

				$datanya.='<table style="border:none;font-size: 12pt; width: 100%"><tr><td style="border:none;text-align:center">REGISTER INDUK PERKARA JINAYAT MAHKAMAH SYAR\'IYAH <br>'.$sys['NamaPN'].'<br>'.$periode.'</td></tr><tr><td style="text-align:right;border:none">R.Msy</td></tr></table>';
				 
				$datanya.="<table cellspacing='0' cellpadding='0' align='center'> <tr> <td width='40' valign='top'><p>1. </p></td> <td width='240' colspan='2' valign='top'><p>No Urut </p></td> <td width='324' valign='top'><p>".$register[$i]->nomor_urut_register."</p></td> </tr> <tr> <td width='40' valign='top'><p>2. </p></td> <td width='240' colspan='2' valign='top'><p>No Perkara </p></td> <td width='324' valign='top'><p>".$register[$i]->nomor_perkara."</p></td> </tr> <tr> <td width='40' valign='top'><p>3. </p></td> <td width='240' colspan='2' valign='top'><p>Nama, Umur, Tgl Lahir, Jenis Kelamin, Kebangsaan, Tempat Tinggal, Agama, dan Pekerjaan Terdakwa </p></td> <td width='324' valign='top'><p align='justify'>".$register[$i]->identitas_terdakwa."</p></td> </tr> <tr> <td width='40' valign='top' rowspan='2'><p>4. </p></td> <td width='36' valign='top'><p>A. </p></td> <td width='204' valign='top'><p>Tanggal Penerimaan Berkas dari Kejaksaan </p></td> <td width='324' valign='top'><p>".$register[$i]->tanggal_surat."</p></td> </tr> <tr> <td width='36' valign='top'><p>B. </p></td> <td width='204' valign='top'><p>Isi Singkat Dakwaan/ Pasal-Pasal Yang Menjadi Dasar Dakwaan </p></td> <td width='324' valign='top'><p>".$register[$i]->dakwaan."</p></td> </tr> <tr> <td width='40' valign='top' rowspan='6'><p>5. </p></td> <td width='240' colspan='2' valign='top'><p>Tanggal Penahanan </p></td> <td width='324' valign='top'><p>&nbsp;</p></td> </tr> <tr> <td width='36' valign='top'><p>A. </p></td> <td width='204' valign='top'><p>Penyidik </p></td> <td width='324' valign='top'><p>".$register[$i]->penahanan_penyidik."</p></td> </tr> <tr> <td width='36' valign='top'><p>B. </p></td> <td width='204' valign='top'><p>Penuntut Umum </p></td> <td width='324' valign='top'><p>".$register[$i]->penahanan_pu."</p></td> </tr> <tr> <td width='36' valign='top'><p>C. </p></td> <td width='204' valign='top'><p>Mahkamah Syar'iyah </p></td> <td width='324' valign='top'><p>".$register[$i]->penahanan_ms."</p></td> </tr> <tr> <td width='36' valign='top'><p>D. </p></td> <td width='204' valign='top'><p>Mahkamah Syar'iyah Aceh </p></td> <td width='324' valign='top'><p>".$register[$i]->penahanan_msa."</p></td> </tr> <tr> <td width='36' valign='top'><p>E. </p></td> <td width='204' valign='top'><p>Mahkamah Agung </p></td> <td width='324' valign='top'><p>".$register[$i]->penahanan_ma."</p></td> </tr> <tr> <td width='40' valign='top' rowspan='3'><p>6. </p></td> <td width='36' valign='top'><p>A. </p></td> <td width='204' valign='top'><p>Tanggal Penetapan Majelis Hakim </p></td> <td width='324' valign='top'><p>".$register[$i]->penetapan_majelis_hakim."</p></td> </tr> <tr> <td width='36' valign='top'><p>B. </p></td> <td width='204' valign='top'><p>Nama Susunan Majelis Hakim, Panitera Pengganti </p></td> <td width='324' valign='top'><p>".$register[$i]->majelis_hakim_text."<br>".$register[$i]->panitera_pengganti_text."</p></td> </tr> <tr> <td width='36' valign='top'><p>C. </p></td> <td width='204' valign='top'><p>Tanggal/ Batasan Waktu Yang Diperintahkan </p></td> <td width='324' valign='top'><p>".$register[$i]->nomorbanding."</p></td> </tr> <tr> <td width='40' valign='top' rowspan='3'><p>7. </p></td> <td width='36' valign='top'><p>A. </p></td> <td width='204' valign='top'><p>Tanggal Penetepan Hari Sidang </p></td> <td width='324' valign='top'><p>".$register[$i]->penetapan_hari_sidang."</p></td> </tr> <tr> <td width='36' valign='top'><p>B. </p></td> <td width='204' valign='top'><p>Tanggal Sidang Pertama </p></td> <td width='324' valign='top'><p>".$register[$i]->sidang_pertama."</p></td> </tr> <tr> <td width='36' valign='top'><p>C. </p></td> <td width='204' valign='top'><p>Tanggal / Alasan Penundaan </p></td> <td width='324' valign='top'><p>".$register[$i]->tundaan."</p></td> </tr> <tr> <td width='40' valign='top' rowspan='2'><p>8. </p></td> <td width='36' valign='top'><p>A. </p></td> <td width='204' valign='top'><p>Tanggal Tuntutan Jaksa/ Penuntut Umum </p></td> <td width='324' valign='top'><p>".$register[$i]->tanggal_penuntutan."</p></td> </tr> <tr> <td width='36' valign='top'><p>B. </p></td> <td width='204' valign='top'><p>Isi Tuntutan Jaksa/ Penuntut Umum </p></td> <td width='324' valign='top'><p>".$register[$i]->isi_penuntutan."</p></td> </tr> <tr> <td width='40' valign='top' rowspan='2'><p>9. </p></td> <td width='36' valign='top'><p>A. </p></td> <td width='204' valign='top'><p>Tanggal Putusan </p></td> <td width='324' valign='top'><p>".$register[$i]->tanggal_putusan."</p></td> </tr> <tr> <td width='36' valign='top'><p>B. </p></td> <td width='204' valign='top'><p>Diktum Lengkap </p></td> <td width='324' valign='top'><p>".$register[$i]->amar_putusan."</p></td> </tr> <tr> <td width='40' valign='top'><p>10. </p></td> <td width='240' colspan='2' valign='top'><p>Tanggal Penyampaian Petikan Putusan Mahkamah Syar'iyah Kepada Terdakwa/ Penasehat Hukum </p></td> <td width='324' valign='top'><p>".$register[$i]->tanggal_kirim_salinan_putusan."</p></td> </tr> <tr> <td width='40' valign='top'><p>11. </p></td> <td width='240' colspan='2' valign='top'><p>Tanggal Menerima Baik Putusan Terdakwa/Jaksa </p></td> <td width='324' valign='top'><p>".$register[$i]->tanggal_menerima_putusan."</p></td> </tr> <tr> <td width='40' valign='top'><p>12. </p></td> <td width='240' colspan='2' valign='top'><p>Tanggal Pengiriman Putusan Kepada Jaksa </p></td> <td width='324' valign='top'><p>".$register[$i]->tanggal_kirim_ke_jaksa."</p></td> </tr> <tr> <td width='40' valign='top'><p>13. </p></td> <td width='240' colspan='2' valign='top'><p>Tanggal Penyelesaian Berkas (Minutasi) </p></td> <td width='324' valign='top'><p>".$register[$i]->tanggal_minutasi."</p></td> </tr> <tr> <td width='40' valign='top'><p>&nbsp; </p></td> <td width='240' colspan='2' valign='top'><p>BANDING </p></td> <td width='324' valign='top'><p>&nbsp; </p></td> </tr> <tr> <td width='40' valign='top' rowspan='3'><p>14. </p></td> <td width='36' valign='top'><p>A. </p></td> <td width='204' valign='top'><p>Tanggal Permohonan Dan Nama Pembanding </p></td> <td width='324' valign='top'><p>".$register[$i]->permohonan_banding."</p></td> </tr> <tr> <td width='36' valign='top'><p>B. </p></td> <td width='204' valign='top'><p>Tanggal Pemberitahuan Permohonan </p></td> <td width='324' valign='top'><p>".$register[$i]->pemberitahuan_permohonan_banding."</p></td> </tr> <tr> <td width='36' valign='top'><p>C. </p></td> <td width='204' valign='top'><p>Tanggal Penerimaan Memori </p></td> <td width='324' valign='top'><p>".$register[$i]->penerimaan_memori_banding."</p></td> </tr> <tr> <td width='40' valign='top' rowspan='3'><p>15. </p></td> <td width='36' valign='top'><p>A. </p></td> <td width='204' valign='top'><p>Tanggal Penyerahan Memori </p></td> <td width='324' valign='top'><p>".$register[$i]->penyerahan_memori_banding."</p></td> </tr> <tr> <td width='36' valign='top'><p>B. </p></td> <td width='204' valign='top'><p>Tanggal Penerimaan Kontra Memori </p></td> <td width='324' valign='top'><p>".$register[$i]->penerimaan_kontra_banding."</p></td> </tr> <tr> <td width='36' valign='top'><p>C. </p></td> <td width='204' valign='top'><p>Tanggal Penyerahan Kontra Memori </p></td> <td width='324' valign='top'><p>".$register[$i]->penyerahan_kontra_banding."</p></td> </tr> <tr> <td width='40' valign='top' rowspan='2'><p>16. </p></td> <td width='36' valign='top'><p>A. </p></td> <td width='204' valign='top'><p>Tanggal Membaca/ Memeriksa (Inzage) </p></td> <td width='324' valign='top'><p>".$register[$i]->pelaksanaan_inzage."</p></td> </tr> <tr> <td width='36' valign='top'><p>B. </p></td> <td width='204' valign='top'><p>Tanggal Dan Pengiriman Berkas </p></td> <td width='324' valign='top'><p>".$register[$i]->tanggal_nomor_kirim."</p></td> </tr> <tr> <td width='40' valign='top'><p>17. </p></td> <td width='240' colspan='2' valign='top'><p>Tanggal Penerimaan Kembali Berkas </p></td> <td width='324' valign='top'><p>".$register[$i]->penerimaan_kembali_berkas_banding."</p></td> </tr> </table><p style='page-break-before:always'>&nbsp;</p>";
			}
			//$datanya='';
		}else
		if($jenis_register == 12){
			$register = $this->register_model->$nama_model_register($tahun, $bulan, 0);
			$datanya='';
			for ($i = 0; $i < count($register); ++$i) 
			{

				$datanya.='<table style="border:none;font-size: 12pt; width: 100%"><tr><td style="border:none;text-align:center"><b>REGISTER PERMOHONAN PENYELESAIAN PEMBAGIAN HARTA PENINGGALAN<br>DILUAR SENGKETA (P3HP)<br>'.$sys['NamaPN'].'<br>'.$periode.'</b></td></tr><tr><td style="text-align:right;border:none">R1-PA11</td></tr></table>';
				 
				$datanya.='<table cellspacing="0" cellpadding="0" align="center"> <tr> <td width="34" valign="top"><p>1. </p></td> <td width="241" valign="top"><p>No Urut </p></td> <td width="379" valign="top"><p>'.$register[$i]->kolom_0.' </p></td> </tr> <tr> <td width="34" valign="top"><p>2.  </p></td> <td width="241" valign="top"><p>Nama Dan Tempat Tinggal Para Pemohon </p></td> <td width="379" valign="top"><p align="justify">'.$register[$i]->kolom_2.' </p></td> </tr> <tr> <td width="34" valign="top"><p>3.  </p></td> <td width="241" valign="top"><p>Tanggal Permohonan </p></td> <td width="379" valign="top"><p>'.$register[$i]->kolom_3.' </p></td> </tr> <tr> <td width="34" valign="top"><p>4. </p></td> <td width="241" valign="top"><p>Jenis Harta Peninggalan </p></td> <td width="379" valign="top"><p>'.$register[$i]->kolom_4.' </p></td> </tr> <tr> <td width="34" valign="top"><p>5. </p></td> <td width="241" valign="top"><p>Tanggal, Nomor Dan Isi Akta </p></td> <td width="379" valign="top"><p>'.$register[$i]->kolom_5a.' </p></td> </tr> <tr> <td width="34" valign="top"><p>6. </p></td> <td width="241"><p>Keterangan </p></td> <td width="379" valign="top"><p>'.$register[$i]->kolom_6.' </p></td> </tr> </table> <p style="page-break-before:always">&nbsp;</p>';
			}
			//$datanya='';
		}else
		if($jenis_register == 13){
			$register = $this->register_model->$nama_model_register($tahun, $bulan, 0);
			for ($i = 0; $i < count($register); ++$i) 
			{				
				$datanya.='<p style="text-align:center">REGISTER EKONOMI SYARIAH<br>'.$sys['NamaPN'].'<br>'.$periode.'</p><p style=text-align:right>R1.PA 14</p>';
				$datanya.='<table align=center cellspacing=0 cellpadding=0> <tbody> <tr> <td width="45" valign="top"> <p>1.</p></td> <td width="231" colspan="2" valign="top"> <p>Nomor Urut</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->nomor_urut_register.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>2.</p></td> <td width="231" colspan="2" valign="top"> <p>Nomor Perkara</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->nomor_perkara.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>3.</p></td> <td width="231" colspan="2" valign="top"> <p>Tanggal Pendaftaran</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->tanggal_pendaftaran_indonesia.'</p></td> </tr> <tr> <td width="45" rowspan="4" valign="top"> <p>4.</p></td> <td width="231" colspan="2" valign="top"> <p>Identitas Para Pihak Dan Kuasa Hukum</p></td> <td width="398" colspan="3" valign="top"> <p>&nbsp;</p></td> </tr> <tr> <td width="45" valign="top"> <p>A.</p></td> <td width="186" valign="top"> <p>Nama, Umur, Agama, Pendidikan, Pekerjaan dan Tempat Tinggal</p></td> <td width="398" colspan="3" valign="top"> '.$this->sebutan_pihak($register[$i]->nomor_perkara,$register[$i]->identitas_p.'</p><center>melawan</center><p>'. $register[$i]->identitas_t).'</td> </tr> <tr> <td width="45" valign="top"> <p>B.</p></td> <td width="186" valign="top"> <p>Tanggal Surat Kuasa Khusus</p></td> <td width="398" colspan="3" rowspan=2 valign="top"> <p>'.$this->sebutan_pihak($register[$i]->nomor_perkara,$register[$i]->tgl_nama_kuasa).'</p></td> </tr> <tr> <td width="45" valign="top"> <p>C.</p></td> <td width="186" valign="top"> <p>Nama Kuasa Hukum</p></td> </tr> <tr> <td width="45" valign="top"> <p>5.</p></td> <td width="231" colspan="2" valign="top"> <p>Petitum</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->petitum.'</p></td> </tr> <tr> <td width="45" rowspan="2" valign="top"> <p>6.</p></td> <td width="45" valign="top"> <p>A.</p></td> <td width="186" valign="top"> <p>Tanggal Penetapan Majelis Hakim</p></td> <td width="398" valign="top" colspan=3 rowspan=2><p>';
				$this->dbsipp = $this->load->database("dbsipp", true); 
				$q=$this->dbsipp->query("SELECT DISTINCT(convert_tanggal_indonesia(tanggal_penetapan)) AS penetapan,tanggal_penetapan, group_concat(CONCAT(jabatan_hakim_nama,' : ',hakim_nama) ORDER BY urutan SEPARATOR '<br>') AS HK FROM perkara_hakim_pn WHERE perkara_id=".$register[$i]->perkara_id." AND tahapan_id<16 GROUP BY perkara_id, tahapan_id, tanggal_penetapan "); 
				foreach ($q->result_array() as $d) 
					{
						$datanya.= "<ol type='A'><li>".$d['penetapan']."</li><li>".$d['HK']."";
						$q=$this->dbsipp->query("SELECT group_concat(panitera_nama ORDER BY urutan SEPARATOR '<br>') AS pp FROM perkara_panitera_pn WHERE perkara_id=".$register[$i]->perkara_id." AND tanggal_penetapan='".$d['tanggal_penetapan']."' GROUP BY perkara_id, tahapan_id, tanggal_penetapan "); 
						foreach ($q->result_array() as $pp) {
							$datanya.= "<br>Panitera Pengganti : ".$pp['pp']; } $datanya.= "</ol>"; 
						}
						$datanya.= '</p></td></tr> <tr> <td width="45" valign="top"> <p>B.</p></td> <td width="186" valign="top"> <p>Susunan Majelis Hakim/Panitera Pengganti</p></td> </tr> <tr> <td width="45" rowspan="2" valign="top"> <p>7.</p></td> <td width="45" valign="top"> <p>A.</p></td> <td width="186" valign="top"> <p>Tanggal Penetapan Hari Sidang</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->phs.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>B.</p></td> <td width="186" valign="top"> <p>Tanggal Sidang Pertama</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->sidangpertama.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>8.&nbsp;</p></td> <td width="231" colspan="2" valign="top"> <p>Tanggal Penundaan Sidang</p></td> <td width="398" colspan="3" valign="top"><table style="width:100%;border:none" cellpadding=0 cellspacing=0><tr><td colspan=2 style=border:none>Tanggal Tunda</td><td style=border:none>Agenda</td></tr>'.$register[$i]->penundaan_sidang.'</table></td> </tr> <tr> <td width="45" rowspan="6" valign="top"> <p>9.</p></td> <td width="231" colspan="2" valign="top"> <p>Mediasi</p></td> <td width="398" colspan="3" valign="top"> </td> </tr> <tr> <td width="45" valign="top"> <p>A.</p></td> <td width="186" valign="top"> <p>Tanggal Penunjukan Mediator</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penetapan_penunjukan_mediator.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>B.</p></td> <td width="186" valign="top"> <p>Nama Mediator</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->nama_gelar_mediator.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>C.</p></td> <td width="186" valign="top"> <p>Nomor/Tanggal Sertifikat Mediator</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->no_sertifikasi.'<br>'.$register[$i]->tgl_sertifikasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>D.</p></td> <td width="186" valign="top"> <p>Tanggal Laporan Mediator</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->tgl_laporan_mediator.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>E.</p></td> <td width="186" valign="top"> <p>Hasil Mediasi</p></td> <td width="398" colspan="3" valign="top"> <p>'.$this->hasil_mediasi($register[$i]->hasil_mediasi).'</p></td> </tr> <tr> <td width="45" rowspan="3" valign="top"> <p>10.</p></td> <td width="45" valign="top"> <p>A.</p></td> <td width="186" valign="top"> <p>Tanggal Putusan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->tanggalputusan.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>B.</p></td> <td width="186" valign="top"> <p>Tanggal Pemberitahuan Putusan (Dalam Hal Pihak-Pihak Tidak Hadir)</p></td> <td width="398" colspan="3" valign="top"> <p>'.$this->sebutan_pihak($register[$i]->nomor_perkara, $register[$i]->pemberitahuan_isi_putusan).'</p></td> </tr> <tr> <td width="45" valign="top"> <p>C.</p></td> <td width="186" valign="top"> <p>Amar Lengkap Putusan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->amar_putusan.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>11&nbsp;</p></td> <td width="231" colspan="2" valign="top"> <p>Tanggal Minutasi</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->tanggalminutasi.'</p></td> </tr> <tr> <td width="45" rowspan="4" valign="top"> <p>12.</p></td> <td width="231" colspan="2" valign="top"> <p>Verzet (Perlawanan)</p></td> <td width="398" colspan="3" valign="top"> <p>&nbsp;</p></td> </tr> <tr> <td width="45" valign="top"> <p>A.</p></td> <td width="186" valign="top"> <p>Tanggal Pendaftaran Verzet</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->tanggalpendaftaranverzet.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>B.</p></td> <td width="186" valign="top"> <p>Tanggal Penetapan Hari Sidang Verzet</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->tanggalpenetapansidangverzet.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>C.</p></td> <td width="186" valign="top"> <p>Tanggal Sidang Pertama</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->tanggalsidangpertamaverzet.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>13.</p></td> <td width="231" colspan="2" valign="top"> <p>Penundaan Sidang<br>A. Tanggal Tunda<br>B. Agenda</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penundaan_sidang_verzet.'</p></td> </tr> <tr> <td width="45" rowspan="2" valign="top"> <p>14.</p> <p>&nbsp;</p></td> <td width="45" valign="top"> <p>A.</p></td> <td width="186" valign="top"> <p>Tanggal Putusan Perlawanan (Verzet)</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->putusanverzet.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>B.</p></td> <td width="186" valign="top"> <p>Amar Lengkap Putusan Perlawanan (Verzet)</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->amar_putusan_verzet.'</p></td> </tr> <tr> <td width="45" rowspan="16" valign="top"> <p>15.</p></td> <td width="629" colspan="5" valign="top"> <p><strong>BANDING</strong></p></td> </tr> <tr> <td width="45" valign="top"> <p>A.</p></td> <td width="186" valign="top"> <p>Tanggal Akta Permohonan Banding</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->permohonan_banding.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>B.</p></td> <td width="186" valign="top"> <p>Tanggal Surat Kuasa Khusus</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->tanggal_kuasa_banding.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>C.</p></td> <td width="186" valign="top"> <p>Nama Kuasa Hukum</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->nama_kuasa_banding.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>D.</p></td> <td width="186" valign="top"> <p>Tanggal Pemberitauan Kepada Pihak Lawan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->pemberitahuan_permohonan_banding.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>E.</p></td> <td width="186" valign="top"> <p>Tanggal Penerimaan Memori</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penerimaan_memori_banding.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>F.</p></td> <td width="186" valign="top"> <p>Tanggal Penyerahan Memori Kepada Lawan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penyerahan_memori_banding.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>G.</p></td> <td width="186" valign="top"> <p>Tanggal Penerimaan Kontra Memori</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penerimaan_kontra_banding.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>H.</p></td> <td width="186" valign="top"> <p>Tanggal Pemberitahuan Kontra Memori Banding</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penyerahan_kontra_banding.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>I.</p></td> <td width="186" valign="top"> <p>Tanggal Inzage</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->pelaksanaan_inzage.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>J.</p></td> <td width="186" valign="top"> <p>Tanggal Pengiriman Berkas</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->pengiriman_berkas_banding.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>K.</p></td> <td width="186" valign="top"> <p>Tanggal Penerimaan Berkas</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penerimaan_kembali_berkas_banding.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>L.</p></td> <td width="186" valign="top"> <p>Tanggal Pemberitahuan Putusan Kepada Pihak-Pihak</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->pemberitahuan_putusan_banding.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>M.</p></td> <td width="186" valign="top"> <p>Nomor Putusan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->nomor_putusan_banding.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>N.</p></td> <td width="186" valign="top"> <p>Tanggal Putusan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->putusan_banding.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>0.</p></td> <td width="186" valign="top"> <p>&nbsp;Amar Lengkap Putusan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->amar_putusan_banding.'</p></td> </tr> <tr> <td width="45" rowspan="14" valign="top"> <p>16.</p></td> <td width="629" colspan="5" valign="top"> <p><strong>KASASI&nbsp;</strong></p></td> </tr> <tr> <td width="45" valign="top"> <p>A.</p></td> <td width="186" valign="top"> <p>Tanggal Akta Permohonan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->permohonan_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>B.</p></td> <td width="186" valign="top"> <p>Tanggal Surat Kuasa Khusus</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->tanggal_kuasa_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>C.</p></td> <td width="186" valign="top"> <p>Nama Kuasa Hukum</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->nama_kuasa_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>D.</p></td> <td width="186" valign="top"> <p>Tanggal Pemberitahuan Kepada Pihak Lawan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->pemberitahuan_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>E.</p></td> <td width="186" valign="top"> <p>Tanggal Penerimaan Memori</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penerimaan_memori_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>F.</p></td> <td width="186" valign="top"> <p>Tanggal Penyerahan Memori Kepada Pihak Lawan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penyerahan_memori_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>G.</p></td> <td width="186" valign="top"> <p>Tanggal Penerimaan Kontra Memori</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penerimaan_kontra_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>H.</p></td> <td width="186" valign="top"> <p>Tanggal Pengiriman Berkas</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->pengiriman_berkas_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>I.</p></td> <td width="186" valign="top"> <p>Tanggal Penerimaan Kembali Berkas</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penerimaan_berkas_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>J.</p></td> <td width="186" valign="top"> <p>Tanggal Pemberitahuan Putusan Kepada Para Pihak</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->pemberitahuan_putusan_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>K.</p></td> <td width="186" valign="top"> <p>Nomor Putusan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->nomor_putusan_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>L.</p></td> <td width="186" valign="top"> <p>Tanggal Putusan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->putusan_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>M.</p></td> <td width="186" valign="top"> <p>Amar Lengkap Putusan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->amar_putusan_kasasi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>17.</p></td> <td width="231" colspan="2" valign="top"> <p>BHT Tanggal</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->tanggal_bht.'</p></td> </tr> <tr> <td width="45" rowspan="15" valign="top"> <p>18.</p></td> <td width="629" colspan="5" valign="top"> <p><strong>PENINJAUAN KEMBALI (PK)</strong></p></td> </tr> <tr> <td width="45" valign="top"> <p>A.</p></td> <td width="186" valign="top"> <p>Tanggal Akta Permohonan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->permohonan_pk.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>B.</p></td> <td width="186" valign="top"> <p>Tanggal Surat Kuasa Khusus</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->tanggal_kuasa_pk.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>C.</p></td> <td width="186" valign="top"> <p>&nbsp;Nama Kuasa Hukum</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->nama_kuasa_pk.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>D.</p></td> <td width="186" valign="top"> <p>Tanggal Pemberitahuan Kepada Pihak Lawan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->pemberitahuan_pk.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>E.</p></td> <td width="186" valign="top"> <p>Tanggal Penerimaan Risalah PK</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penerimaan_memori_pk.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>F.</p></td> <td width="186" valign="top"> <p>Tanggal Penyerahan Risalah PK Kepada Pihak Lawan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penyerahan_memori_pk.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>G.</p></td> <td width="186" valign="top"> <p>&nbsp;Tanggal Penerimaan Jawaban</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penerimaan_kontra_pk.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>H.</p></td> <td width="186" valign="top"> <p>Tanggal Penyumpahan Novum</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->tanggal_penyumpahan_novum.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>I.</p></td> <td width="186" valign="top"> <p>Tanggal Pengiriman Berkas</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->pengiriman_berkas_pk.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>J.</p></td> <td width="186" valign="top"> <p>Tanggal Penerimaan Kembali Berkas</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penerimaan_berkas_pk.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>K.</p></td> <td width="186" valign="top"> <p>Tanggal Pemberitahuan Putusan Kepada Para Pihak</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->pemberitahuan_putusan_pk.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>L.</p></td> <td width="186" valign="top"> <p>Nomor Putusan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->nomor_putusan_pk.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>M.</p></td> <td width="186" valign="top"> <p>Tanggal Putusan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->putusan_pk.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>N.</p></td> <td width="186" valign="top"> <p>Amar Lengkap Putusan</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->amar_putusan_pk.'</p></td> </tr> <tr> <td width="45" rowspan="5" valign="top"> <p>19.</p> <p>&nbsp;</p> <p>&nbsp;</p> <p>&nbsp;</p></td> <td width="629" colspan="5" valign="top"> <p><strong>EKSEKUSI</strong></p></td> </tr> <tr> <td width="45" valign="top"> <p>A.</p></td> <td width="186" valign="top"> <p>Tanggal Permohonan Eksekusi</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->permohonan_eksekusi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>B.</p></td> <td width="186" valign="top"> <p>Tanggal Penetapan (Aanmaning)</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->penetapan_teguran_eksekusi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>C.</p></td> <td width="186" valign="top"> <p>Tanggal Penegoran (Aanmaning)</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->pelaksanaan_teguran_eksekusi.'</p></td> </tr> <tr> <td width="45" valign="top"> <p>D.</p></td> <td width="186" valign="top"> <p>Tanggal Pelaksanaan Eksekusi</p></td> <td width="398" colspan="3" valign="top"> <p>'.$register[$i]->pelaksanaan_sita_eksekusi.'</p></td> </tr></tbody> </table><br>';
			}
		}else	
		if($jenis_register == 14){
			$register = $this->register_model->$nama_model_register($tahun, $bulan, 0);
			$datanya='';
			$datanya.='<table style="border:none;font-size: 12pt; width: 100%"><tr><td style="border:none;text-align:center">REGISTER  ITSBAT RUKYAT HILAL DAN PEMBERIAN NASEHAT / KETERANGAN<br> TENTANG PERBEDAAN PENENTUAN ARAH KIBLAT DAN PENENTUAN AWAL WAKTU SHALAT <br>'.$sys['NamaPN'].'<br>'.$periode.'</td></tr><tr><td style="text-align:right;border:none">R1.PA12</td></tr></table>';
			for ($i = 0; $i < count($register); ++$i) 
			{	
				$datanya.='<table border="1"  style="font-size: 12p;width: 100%">
				<tr><td style="width:5%">1.</td><td colspan=2 style="width:40%">No Urut </td><td style="width:45%">'.$register[$i]->urutan.'</td></tr>
				<tr><td valign=top>2.</td><td colspan=2 valign=top>Nomor Permohonan</td><td>'.$register[$i]->nomor_permohonan.'</td></tr>
				<tr><td valign=top>3.</td><td  colspan=2 valign=top>Tanggal Pendaftaran</td><td>'.$register[$i]->tanggal_pendaftaran.'</td></tr>
				<tr><td valign=top>4.</td><td colspan=2 valign=top>Nama Pemohon </td><td>'.$register[$i]->nama_pemohon.'</td></tr>
				<tr><td valign=top>5.</td><td valign=top colspan=2>Keterangan Singkat Isi Permohonan</td><td valign=top>'.$register[$i]->keterangan_singkat_isi_permohonan.'</td></tr>
				<tr><td valign=top rowspan=3>6.</td><td valign=top>A.</td><td valign=top>Tanggal Penetapan Majelis</td><td valign=top>'.$register[$i]->tanggal_penetapan_hakim.'</td></tr>
				<tr><td valign=top>B.</td><td valign=top>Nama Hakim</td><td valign=top>'.$register[$i]->nama_hakim.'</td></tr>
				<tr><td valign=top>C.</td><td valign=top>Nama Panitera Pengganti</td><td valign=top>'.$register[$i]->nama_panitera.'</td></tr>
				<tr><td valign=top rowspan=2>7.</td><td valign=top>A.</td><td valign=top>Tanggal Pelaksanaan</td><td valign=top>'.$register[$i]->tanggal_pelaksanaan.'</td></tr>
				<tr><td valign=top>B.</td><td valign=top>Tempat Pelaksanaan</td><td valign=top>'.$register[$i]->tempat_pelaksanaan.'</td></tr> 
				<tr><td valign=top rowspan=2>8.</td><td valign=top>A.</td><td valign=top>Tanggal Penetapan</td><td valign=top>'.$register[$i]->tanggal_penetapan.'</td></tr>
				<tr><td valign=top>B.</td><td valign=top>Isi Penetapan</td><td valign=top>'.$register[$i]->isi_penetapan.'</td></tr> 
				<tr><td valign=top>9.</td><td colspan=2 valign=top>Keterangan</td><td>'.$register[$i]->keterangan.'</td></tr></table><p style="page-break-before:always">&nbsp;</p>';
			}
			//$datanya='';
		}else
		if($jenis_register == 16){
			$register = $this->register_model->$nama_model_register($tahun, $bulan, 0);
			$datanya='';
			for ($i = 0; $i < count($register); ++$i) 
			{	

			$datanya.='<table style="border:none;font-size: 12pt; width: 100%"><tr><td style="border:none;text-align:center">BUKU REGISTER MEDIASI <br>'.$sys['NamaPN'].'<br>'.$periode.'</td></tr><tr><td style="text-align:right;border:none">R1.PA13</td></tr></table>';
				$datanya.='<table cellspacing="0" cellpadding="0" align="center"> <tr> <td width="645" colspan="5" valign="bottom"><p><strong>MEDIASI </strong></p></td> </tr> <tr> <td width="51" valign="top"><p>1.</p></td> <td width="187" colspan="3" valign="top"><p>Nomor Urut </p></td> <td width="407" valign="top"><p>'.$register[$i]->urut.'</p></td> </tr> <tr> <td width="51" valign="top" rowspan="2"><p>2.&nbsp; </p></td> <td width="32" colspan="2" valign="top"><p>A </p></td> <td width="154" valign="top"><p>Nomor Perkara </p></td> <td width="407" valign="top"><p>'.$register[$i]->nomor_perkara.'</p></td> </tr> <tr> <td width="32" colspan="2" valign="top"><p>B </p></td> <td width="154" valign="top"><p>Jenis Perkara </p></td> <td width="407" valign="top"><p>'.$register[$i]->jenis_perkara.'</p></td> </tr> <tr> <td width="51" valign="top"><p>3.&nbsp; </p></td> <td width="187" colspan="3" valign="top"><p>Identitas Para Pihak </p></td> <td width="407" valign="top"><p>&nbsp;</p> </td> </tr> <tr> <td width="51" rowspan="3" valign="top"><p>4.</p> </td> <td width="187" colspan="3" valign="top"><p>Nama </p></td> <td width="407" valign="top"><p>&nbsp; </p></td> </tr> <tr> <td width="29" valign="top"><p>A. </p></td> <td width="158" colspan="2" valign="top"><p>Majelis Hakim </p></td> <td width="407" valign="top"><p>'.$register[$i]->majelis_hakim.'</p></td> </tr> <tr> <td width="29" valign="top"><p>B. </p></td> <td width="158" colspan="2" valign="top"><p>Panitera Pengganti </p></td> <td width="407" valign="top"><p>'.$register[$i]->panitera_pengganti.'</p></td> </tr> <tr> <td width="51" rowspan="2" valign="top"><p>5. </p> </td> <td width="29" valign="top"><p>A </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Penetapan Penunjukkan Mediator </p></td> <td width="407" valign="top"><p>'.$register[$i]->penunjukan_mediator.'</p></td> </tr> <tr> <td width="29" valign="top"><p>B </p></td> <td width="158" colspan="2" valign="top"><p>Nama Mediator/ Ko Mediator </p></td> <td width="407" valign="top"><p>'.$register[$i]->mediator.'</p></td> </tr> <tr> <td width="51" rowspan="2" valign="top"><p>6. </p> </td> <td width="29" valign="top"><p>A </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Mediasi </p></td> <td width="407" valign="top"><p>'.$register[$i]->jadwal_mediasi.'</p></td> </tr> <tr> <td width="29" valign="top"><p>B </p></td> <td width="158" colspan="2" valign="top"><p>Jadwal Mediasi </p></td> <td width="407" valign="top"><p>'.$register[$i]->jadwal_mediasi.'</p></td> </tr> <tr> <td width="51" rowspan="2" valign="top"><p>7. </p> </td> <td width="29" valign="top"><p>A </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Laporan Mediator </p></td> <td width="407" valign="top"><p>'.$register[$i]->tgl_laporan_mediator.'</p></td> </tr> <tr> <td width="29" valign="top"><p>B </p></td> <td width="158" colspan="2" valign="top"><p>Berhasil Seluruhnya Tidak Berhasil/ Tidak Dapat Dilaksanakan </p></td> <td width="407" valign="top"><p>'.$register[$i]->hasil_mediasi.'</p></td> </tr> <tr> <td width="51" rowspan="2" valign="top"><p>8. </p> </td> <td width="29" valign="top"><p>A </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Akta Perdamaian/ Tanggal Penetapan Pencabutan/ Tanggal Putusan </p></td> <td width="407" valign="top"><p>'.$register[$i]->tanggal_akta_or_cabut.'</p></td> </tr> <tr> <td width="29" valign="top"><p>B </p></td> <td width="158" colspan="2" valign="top"><p>Isi Kesepakatan Perdamaian </p></td> <td width="407" valign="top"><p>'.$register[$i]->isi_akta_perdamaian.'</p></td> </tr> <tr> <td width="51" rowspan="2" valign="top"><p>9. </p> </td> <td width="29" valign="top"><p>A </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Akta Perdamaian/ Tanggal Penetapan Pencabutan </p></td> <td width="407" valign="top"><p>'.$register[$i]->tanggal_akta_or_cabut.'</p></td> </tr> <tr> <td width="29" valign="top"><p>B </p></td> <td width="158" colspan="2" valign="top"><p>Isi Kesepakatan Perdamaian </p></td> <td width="407" valign="top"><p>'.$register[$i]->isi_akta_perdamaian.'</p></td> </tr> <tr> <td width="645" colspan="5" valign="top"><p>MEDIASI PADA TAHAP PEMERIKSAAN PERKARA </p></td> </tr> <tr> <td width="51" valign="top" rowspan="2"><p>10.</p></td> <td width="29" valign="top"><p>A </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Penetapan Penunjukkan Mediator </p></td> <td width="407" valign="top"><p>'.$register[$i]->tanggal_penunjukan_mediator2.' </p></td> </tr> <tr> <td width="29" valign="top"><p>B </p></td> <td width="158" colspan="2" valign="top"><p>Nama Mediator/ Ko Mediator </p></td> <td width="407" valign="top"><p>'.$register[$i]->mediator2.' </p></td> </tr> <tr> <td width="51" valign="top" rowspan="4"><p>11. </p></td> <td width="29" valign="top"><p>A </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Laporan Mediator </p></td> <td width="407" valign="top"><p>'.$register[$i]->tgl_laporan_mediator2.' </p></td> </tr> <tr> <td width="29" valign="top"><p>B </p></td> <td width="158" colspan="2" valign="top"><p>Berhasil/ Tidak Berhasil/ Tidak Dapat Dilaksanakan </p></td> <td width="407" valign="top"><p>'.$register[$i]->hasil_mediasi2.' </p></td> </tr> <tr> <td width="29" valign="top"><p>C </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Kesepakatan Perdamaian </p></td> <td width="407" valign="top"><p>'.$register[$i]->tanggal_akta_or_cabut2.' </p></td> </tr> <tr> <td width="29" valign="top"><p>D </p></td> <td width="158" colspan="2" valign="top"><p>Isi Kesepakatan Perdamaian </p></td> <td width="407" valign="top"><p>'.$register[$i]->isi_akta_perdamaian2.' </p></td> </tr> <tr> <td width="51" valign="top" rowspan="2"><p>12 </p></td> <td width="29" valign="top"><p>A </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Akta Perdamaian/ Tanggal Penetapan Pencabutan/ Tanggal Putusan </p></td> <td width="407" valign="top"><p>'.$register[$i]->tanggal_akta_or_cabut2.' </p></td> </tr> <tr> <td width="29" valign="top"><p>B </p></td> <td width="158" colspan="2" valign="top"><p>Isi Kesepakatan Perdamaian </p></td> <td width="407" valign="top"><p>'.$register[$i]->isi_akta_perdamaian2.' </p></td> </tr> <tr> <td width="51" valign="top" rowspan="3"><p>13 </p></td> <td width="29" valign="top"><p>A </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Pernyataan Banding </p></td> <td width="407" valign="top"><p>'.$register[$i]->permohonan_banding.' </p></td> </tr> <tr> <td width="29" valign="top"><p>B </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Registrasi Banding </p></td> <td width="407" valign="top"><p>'.$register[$i]->permohonan_banding.' </p></td> </tr> <tr> <td width="29" valign="top"><p>C </p></td> <td width="158" colspan="2" valign="top"><p>Nomor Perkara Banding </p></td> <td width="407" valign="top"><p>'.$register[$i]->nomor_perkara_banding.' </p></td> </tr> <tr> <td width="645" colspan="5" valign="top"><p><strong>BANDING </strong></p></td> </tr> <tr> <td width="51" valign="top" rowspan="4"><p>14. </p></td> <td width="29" valign="top"><p>A </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Permohonan Mediasi </p></td> <td width="407" valign="top"><p>&nbsp; </p></td> </tr> <tr> <td width="29" valign="top"><p>B </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Penetapan Penunjukkan Mediator </p></td> <td width="407" valign="top"><p>&nbsp; </p></td> </tr> <tr> <td width="29" valign="top"><p>C </p></td> <td width="158" colspan="2" valign="top"><p>Nama Mediator </p></td> <td width="407" valign="top"><p>&nbsp; </p></td> </tr> <tr> <td width="29" valign="top"><p>D </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Pemberitahuan KPN/KPA kepada PT/PTA </p></td> <td width="407" valign="top"><p>&nbsp; </p></td> </tr> <tr> <td width="51" valign="top" rowspan="5"><p>15 </p></td> <td width="29" valign="top"><p>A </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Laporan Mediator </p></td> <td width="407" valign="top"><p>&nbsp; </p></td> </tr> <tr> <td width="29" valign="top"><p>B </p></td> <td width="158" colspan="2" valign="top"><p>Berhasil/ Tidak Berhasil/ Tidak Dapat Dilaksanakan </p></td> <td width="407" valign="top"><p>&nbsp; </p></td> </tr> <tr> <td width="29" valign="top"><p>C </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Pengiriman Kesepakatan ke PT/PTA </p></td> <td width="407" valign="top"><p>&nbsp; </p></td> </tr> <tr> <td width="29" valign="top"><p>D </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Kesepakatan Perdamaian </p></td> <td width="407" valign="top"><p>&nbsp; </p></td> </tr> <tr> <td width="29" valign="top"><p>E </p></td> <td width="158" colspan="2" valign="top"><p>Isi Kesepakatan Perdamaian </p></td> <td width="407" valign="top"><p>&nbsp; </p></td> </tr> <tr> <td width="51" valign="top" rowspan="3"><p>16 </p></td> <td width="29" valign="top"><p>A </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Akta Perdamaian </p></td> <td width="407" valign="top"><p>&nbsp; </p></td> </tr> <tr> <td width="29" valign="top"><p>B </p></td> <td width="158" colspan="2" valign="top"><p>Penetapan Pencabutan Perkara </p></td> <td width="407" valign="top"><p>&nbsp; </p></td> </tr> <tr> <td width="29" valign="top"><p>C </p></td> <td width="158" colspan="2" valign="top"><p>Isi Akta Perdamaian </p></td> <td width="407" valign="top"><p>&nbsp; </p></td> </tr> <tr> <td width="645" colspan="5" valign="top"><p><strong>KASASI </strong></p></td> </tr> <tr> <td width="51" valign="top" rowspan="3"><p>17 </p></td> <td width="29" valign="top"><p>A </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Pernyataan Kasasi </p></td> <td width="407" valign="top"><p>'.$register[$i]->permohonan_kasasi.' </p></td> </tr> <tr> <td width="29" valign="top"><p>B </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Register Kasasi </p></td> <td width="407" valign="top"><p>'.$register[$i]->permohonan_kasasi.' </p></td> </tr> <tr> <td width="29" valign="top"><p>C </p></td> <td width="158" colspan="2" valign="top"><p>Nomor Perkara Kasasi </p></td> <td width="407" valign="top"><p>'.$register[$i]->nomor_perkara_kasasi.' </p></td> </tr> <tr> <td width="51" valign="top" rowspan="4"><p>18. </p></td> <td width="29" valign="top"><p>A </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Kesepakatan Perdamaian </p></td> <td width="407" valign="top"><p>&nbsp; </p></td> </tr> <tr> <td width="29" valign="top"><p>B </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Pengajuan Kesepakatan Perdamaian </p></td> <td width="407" valign="top"><p>&nbsp; </p></td> </tr> <tr> <td width="29" valign="top"><p>C </p></td> <td width="158" colspan="2" valign="top"><p>Nama Mediator </p></td> <td width="407" valign="top"><p>&nbsp; </p></td> </tr> <tr> <td width="29" valign="top"><p>D </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Pemberitahuan ke MA </p></td> <td width="407" valign="top"><p>&nbsp; </p></td> </tr> <tr> <td width="51" valign="top" rowspan="4"><p>19. </p></td> <td width="29" valign="top"><p>A </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Laporan Mediator </p></td> <td width="407" valign="top"><p>&nbsp; </p></td> </tr> <tr> <td width="29" valign="top"><p>B </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Register Kasasi </p></td> <td width="407" valign="top"><p>&nbsp; </p></td> </tr> <tr> <td width="29" valign="top"><p>C </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Pengiriman Kesepakatan ke MA </p></td> <td width="407" valign="top"><p>&nbsp; </p></td> </tr> <tr> <td width="29" valign="top"><p>D </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Kesepakatan Perdamaian </p></td> <td width="407" valign="top"><p>&nbsp; </p></td> </tr> <tr> <td width="51" valign="top" rowspan="2"><p>20 </p></td> <td width="29" valign="top"><p>A </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Akta Perdamaian </p></td> <td width="407" valign="top"><p>&nbsp; </p></td> </tr> <tr> <td width="29" valign="top"><p>B </p></td> <td width="158" colspan="2" valign="top"><p>Isi Akta Perdamaian </p></td> <td width="407" valign="top"><p>&nbsp; </p></td> </tr> <tr> <td width="645" colspan="5" valign="top"><p><strong>PENINJUAN KEMBALI </strong></p></td> </tr> <tr> <td width="51" valign="top" rowspan="2"><p>21 </p></td> <td width="29" valign="top"><p>A </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Pernyataan PK </p></td> <td width="407" valign="top"><p>&nbsp; </p></td> </tr> <tr> <td width="29" valign="top"><p>B </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Regiser PK </p></td> <td width="407" valign="top"><p>&nbsp; </p></td> </tr> <tr> <td width="51" valign="top" rowspan="4"><p>22 </p></td> <td width="29" valign="top"><p>A </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Permohonan Mediasi </p></td> <td width="407" valign="top"><p>&nbsp; </p></td> </tr> <tr> <td width="29" valign="top"><p>B </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Penetapan Penunjukkan Mediator </p></td> <td width="407" valign="top"><p>&nbsp; </p></td> </tr> <tr> <td width="29" valign="top"><p>C </p></td> <td width="158" colspan="2" valign="top"><p>Nama Mediator </p></td> <td width="407" valign="top"><p>&nbsp; </p></td> </tr> <tr> <td width="29" valign="top"><p>D </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Pemberitahuan ke MA </p></td> <td width="407" valign="top"><p>&nbsp; </p></td> </tr> <tr> <td width="51" valign="top" rowspan="5"><p>23 </p></td> <td width="29" valign="top"><p>A </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Laporan Mediator </p></td> <td width="407" valign="top"><p>&nbsp; </p></td> </tr> <tr> <td width="29" valign="top"><p>B </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Register Kasasi </p></td> <td width="407" valign="top"><p>&nbsp; </p></td> </tr> <tr> <td width="29" valign="top"><p>C </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Pengiriman Kesepakatan ke MA </p></td> <td width="407" valign="top"><p>&nbsp; </p></td> </tr> <tr> <td width="29" valign="top"><p>D </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Kesepakatan Perdamaian </p></td> <td width="407" valign="top"><p>&nbsp; </p></td> </tr> <tr> <td width="29" valign="top"><p>E </p></td> <td width="158" colspan="2" valign="top"><p>Isi Akta Perdamaian </p></td> <td width="407" valign="top"><p>&nbsp; </p></td> </tr> <tr> <td width="51" valign="top" rowspan="2"><p>24 </p></td> <td width="29" valign="top"><p>A </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Akta Perdamaian </p></td> <td width="407" valign="top"><p>'.$register[$i]->akta_perdamaian_pk.' </p></td> </tr> <tr> <td width="29" valign="top"><p>B </p></td> <td width="158" colspan="2" valign="top"><p>Isi Akta Perdamaian </p></td> <td width="407" valign="top"><p>'.$register[$i]->isi_akta_perdamaian.' </p></td> </tr> <tr> <td width="645" colspan="5" valign="top"><p><strong>EKSEKUSI </strong></p></td> </tr> <tr> <td width="51" valign="top" rowspan="7"><p>25 </p></td> <td width="29" valign="top"><p>A </p></td> <td width="158" colspan="2" valign="top"><p>Tanggal Pendaftaran Permohonan </p></td> <td width="407" valign="top"><p>'.$register[$i]->permohonan_ek.' </p></td> </tr> <tr> <td width="29" valign="top"><p>B </p></td> <td width="158" colspan="2" valign="top"><p>Penetapan Teguran </p></td> <td width="407" valign="top"><p>'.$register[$i]->penetapan_teguran_ek.' </p></td> </tr> <tr> <td width="29" valign="top"><p>C </p></td> <td width="158" colspan="2" valign="top"><p>Teguran </p></td> <td width="407" valign="top"><p>'.$register[$i]->teguran_ek.' </p></td> </tr> <tr> <td width="29" valign="top"><p>D </p></td> <td width="158" colspan="2" valign="top"><p>Penetapan dan Nomor Penetapan Sita </p></td> <td width="407" valign="top"><p>'.$register[$i]->penetapan_sita_ek.' <br> '.$register[$i]->nomor_penetapan_ek.' </p></td> </tr> <tr> <td width="29" valign="top"><p>E </p></td> <td width="158" colspan="2" valign="top"><p>Pelaksanaan Sita </p></td> <td width="407" valign="top"><p>'.$register[$i]->pelaksanaan_sita_ek.' </p></td> </tr> <tr> <td width="29" valign="top"><p>F </p></td> <td width="158" colspan="2" valign="top"><p>Penetapan Eksekusi </p></td> <td width="407" valign="top"><p>'.$register[$i]->penetapan_ek.' </p></td> </tr> <tr> <td width="29" valign="top"><p>G </p></td> <td width="158" colspan="2" valign="top"><p>Pelaksanaan </p></td> <td width="407" valign="top"><p>'.$register[$i]->pelaksanaan_ek.' </p></td> </tr> <tr> <td width="51" valign="top"><p>26. </p></td> <td width="187" colspan="3" valign="top"><p>Keterangan </p></td> <td width="407" valign="top">&nbsp;</td> </tr> </table> <p style="page-break-before:always">&nbsp;</p>';
			}
			//$datanya='';
		}
		$informasi_register = $this->register_model->get_data_where('id=' . $jenis_register, 'register_m_jenis_register', '-');
		$data['isi']=$datanya;
		
		$kriteria="aktif='y'";
		$data['jenis_register'] = $this->register_model->get_data_where1($kriteria, 'register_m_jenis_register', '-');
		
		$data['tahun_perkara'] = $this->register_model->tahun_perkara();
		$data['register_terpilih'] =$jenis_register;
		$data['tahun_terpilih'] =$tahun;
		$data['tahapan'] =$tahapan;
		$data['bulan_terpilih'] =$bulan;
		$data['tahun_perkara'] = $this->register_model->tahun_perkara();
		$data['cetak'] = $cetak;
		$data['perkara_id'] = $perkara_id;
		$data['buka_jenis_register'] = 'buka_register_elektronik';

		$data['nama_file']=$informasi_register['register_nama'].'_'.$periode;
		$data['tujuan_switch_nama']='register_manual';
		$data['tujuan_switch_keterangan']='Pindah Tampilan Register Manual';
		
		$this->load->view('register/register_cetak_html', $data);
	}
	function cetak_register_word_semua($jenis_register = 0, $nomor_perkara = 0)
	{
		//$this->is_login(); 
		//var_dump($this->input->post());
		//$jenis_register	=$this->uri->segment(4);
		if($jenis_register==0)
		{
			$jenis_register = $this->input->post('nama_register_perperkara');
			$nomor_perkara  = $this->input->post('nomor_perkara');
		}else
		{
			$jenis_register = (int)$jenis_register;
			$nomor_perkara  = str_replace("_", "/", $nomor_perkara);
		}
		//echo $jenis_register.'-'.$nomor_perkara;exit;
		$nomorperkara  = str_replace("/", "_", $nomor_perkara);
		///$nomor_perkara	= $this->uri->segment(3); 
		//$nomor_perkara	= str_replace("+", "/", trim($nomor_perkara));
		//$nomorperkara   = str_replace("/", "_", $nomor_perkara);
		
		$sys = $this->register_model->sys_config();
		
		$informasi_register = $this->register_model->get_data_where('id=' . $jenis_register, 'register_m_jenis_register', '-');
		$nama_template	  = $informasi_register['id'] . ".rtf";
		$real_alamat_url	= "http://" . $_SERVER['SERVER_NAME'] . dirname($_SERVER["REQUEST_URI"] . '?') . '/';
		//$real_alamat_url=str_replace("/".$this->uri->segment(4), "", $real_alamat_url);
		$real_alamat_url=str_replace($jenis_register."/", "", $real_alamat_url);

		$real_alamat_url	= str_replace("cetak_register_word_semua", "", $real_alamat_url);
		$real_alamat_url	= str_replace("/register/", "", $real_alamat_url);
		$source_file		= $real_alamat_url . "/templates/register/" . $nama_template;
		
		$template = file_get_contents($source_file);
		
		if($jenis_register == 1){
			$register		   = $this->register_model->register_cetak_1($nomor_perkara);
			$perkara_id		 = $register[0]->perkara_id;
			$sidang_pertama	 = $register[0]->sidang_pertama;
			$tanggal_putusannya = $register[0]->tanggal_putusan;
			
			$template	 = str_replace('#nomor_perkara#', $register[0]->nomor_perkara, $template);
			$template	 = str_replace('#nomor_urut_register#', $this->isi($register[0]->nomor_urut_register), $template);
			$template	 = str_replace('#nomor_perkara#', $this->tanggal_indonesia($register[0]->nomor_perkara), $template);
			$template	 = str_replace('#tanggal_pendaftaran#', $this->tanggal_indonesia($register[0]->tanggal_pendaftaran), $template);
			$template	 = str_replace('#petitum#', $this->amar($register[0]->petitum), $template);
			//echo $this->amar($register[0]->petitum);exit;
			$template	 = str_replace('#penetapan_hari_sidang#', $this->tanggal_indonesia($register[0]->penetapan_hari_sidang), $template);
			$template	 = str_replace('#sidang_pertama#', $this->tanggal_indonesia($register[0]->sidang_pertama), $template);
			////////////////////////////////// 
			$template	 = str_replace('#tanggal_putusan#', $this->tanggal_indonesia($register[0]->tanggal_putusan), $template);
			//pbt
			$this->dbsipp = $this->load->database("dbsipp", TRUE);
			
			$tanggale_pemberitahuan_putusan = '';
			
			//tanggale_pemberitahuan_putusan================================= 
			$sqle = "SELECT convert_tanggal_indonesia(tanggal_pemberitahuan_putusan) AS tanggal_pemberitahuan_putusan 
			FROM perkara_putusan_pemberitahuan_putusan WHERE perkara_id=" . $perkara_id . "  AND tanggal_pemberitahuan_putusan IS NOT NULL";
			//echo $sqle;exit;
			$q	= $this->dbsipp->query($sqle);
			
			foreach ($q->result_array() as $d){
				$tanggale_pemberitahuan_putusan .= $d['tanggal_pemberitahuan_putusan'] . '  \\par ';
			}
			
			$template = str_replace('#pemberitahuan_putusan#', $tanggale_pemberitahuan_putusan, $template);
			//tanggale_pemberitahuan_putusan=================================
			$template = str_replace('#amar_putusan#', $this->amar($register[0]->amar_putusan), $template);
			$template = str_replace('#tanggal_minutasi#', $this->tanggal_indonesia($register[0]->tanggal_minutasi), $template);
			$template = str_replace('#permohonan_kasasi#', $this->tanggal_indonesia($register[0]->permohonan_kasasi), $template);
			$template = str_replace('#pemberitahuan_kasasi#', $this->tanggal_indonesia($register[0]->pemberitahuan_kasasi), $template);
			$template = str_replace('#penerimaan_memori_kasasi#', $this->tanggal_indonesia($register[0]->penerimaan_memori_kasasi), $template);
			$template = str_replace('#penyerahan_memori_kasasi#', $this->tanggal_indonesia($register[0]->penyerahan_memori_kasasi), $template);
			$template = str_replace('#penerimaan_kontra_kasasi#', $this->tanggal_indonesia($register[0]->penerimaan_kontra_kasasi), $template);
			$template = str_replace('#pengiriman_berkas_kasasi#', $this->tanggal_indonesia($register[0]->pengiriman_berkas_kasasi), $template);
			$template = str_replace('#penerimaan_berkas_kasasi#', $this->tanggal_indonesia($register[0]->penerimaan_berkas_kasasi), $template);
			$template = str_replace('#pemberitahuan_putusan_kasasi#', $this->tanggal_indonesia($register[0]->pemberitahuan_putusan_kasasi), $template);
			$template = str_replace('#nomor_perkara_kasasi#', $this->isi($register[0]->nomor_perkara_kasasi), $template);
			$template = str_replace('#putusan_kasasi#', $this->tanggal_indonesia($register[0]->putusan_kasasi), $template);
			$template = str_replace('#amar_putusan_kasasi#', $this->amar($register[0]->amar_putusan_kasasi), $template);
			$template = str_replace('#tanggal_bht#', $this->tanggal_indonesia($register[0]->tanggal_bht), $template);
			$template = str_replace('#jenis_perkara_nama#', $this->isi($register[0]->jenis_perkara_nama), $template);
			$template = str_replace('#identitas_p#', $this->sebutan_pihak($nomor_perkara, $this->isi($register[0]->identitas_p)), $template);
			
			//==============kuasa
			$tanggal_kuasa_p = $this->register_model->tanggal_surat_kuasa($nomor_perkara, 1);
			$kuasa_p		 = $tanggal_kuasa_p[0]->tanggal_kuasa;
			if($kuasa_p <> NULL){
				$tanggal_surat_kuasa_khusus = $kuasa_p;
				$template					= str_replace('#tanggal_surat_kuasa_khusus#', $tanggal_surat_kuasa_khusus, $template);
			} else{
				$template = str_replace('#tanggal_surat_kuasa_khusus#', '-', $template);
			}
			$nama_kuasa_p = $this->register_model->nama_kuasa_hukum($nomor_perkara, 1);
			$nama_kuasa_p = $nama_kuasa_p[0]->nama_kuasa_hukum;
			
			if($nama_kuasa_p == NULL){
				$template = str_replace('#nama_kuasa_hukum#', '-', $template);
			} else{
				$nama_kuasa_hukum = $nama_kuasa_p;
				$template		 = str_replace('#nama_kuasa_hukum#', $nama_kuasa_hukum, $template);
			}
			//==============kuasa
			
			//pmh
			$penetapan_majelis_hakim = '';
			$this->dbsipp			= $this->load->database("dbsipp", TRUE);
			$q					   = $this->dbsipp->query("SELECT DISTINCT(convert_tanggal_indonesia(tanggal_penetapan)) AS penetapan,tanggal_penetapan, group_concat(hakim_nama ORDER BY urutan SEPARATOR ' \\\\par \\\\tab \\\\tab \\\\tab ')  AS HK
				FROM perkara_hakim_pn WHERE perkara_id=" . $perkara_id . " GROUP BY perkara_id, tahapan_id, tanggal_penetapan   ");
			$no					  = 0;
			foreach ($q->result_array() as $d){
			   //echo "<ol style='margin-left: -25px;' type='A'><li>".$d['penetapan']."</li><li>".$d['HK']."";
				$no++;
				$nomore = $no - 1;
				if($no == 1){
					$penetapan_majelis_hakim .= 'A. \\tab ' . $d['penetapan'] . ' \\tab B. \\tab ' . $d['HK'] . ' \\par ';
				} else{
					$penetapan_majelis_hakim .= 'A' . $nomore . '. \\tab ' . $d['penetapan'] . ' \\tab B' . $nomore . '. \\tab ' . $d['HK'] . ' \\par ';
				}
				$q = $this->dbsipp->query("SELECT group_concat(panitera_nama ORDER BY urutan SEPARATOR '<br>')  AS pp
					FROM perkara_panitera_pn WHERE perkara_id=" . $perkara_id . " AND tanggal_penetapan='" . $d['tanggal_penetapan'] . "' GROUP BY perkara_id, tahapan_id, tanggal_penetapan   ");
				foreach ($q->result_array() as $pp){
					$penetapan_majelis_hakim .= ' \\tab  \\tab  \\tab ' . $pp['pp'] . ' \\par ';
					//	echo "<br>".$pp['pp']; 
				}
			   //echo "</li></ol>";
			}
			//$penetapan_majelis_hakim.='A. \\tab Tanggal Penetapan Majelis Hakim \\tab B \\tab Susunan Majelis Hakim/Panitera Pengganti \\par ';
			$template = str_replace('#penetapan_majelis_hakim#', $penetapan_majelis_hakim, $template);
			//pmh
			
			//tundaan=================================
			$tundaan_sidang = '';
			$q			 = $this->dbsipp->query("SELECT convert_tanggal_indonesia(tanggal_sidang) AS tanggal_sidang, agenda 
				FROM perkara_jadwal_sidang WHERE perkara_id=" . $perkara_id . "  AND tanggal_sidang <> '$sidang_pertama' AND ikrar_talak='T' AND verzet='T' ");
			foreach ($q->result_array() as $d){
				$tundaan_sidang .= $d['tanggal_sidang'] . ' \\tab ' . $d['agenda'] . ' \\par ';
			}
			$template = str_replace('#tanggal_penundaan_sidang#', $tundaan_sidang, $template);
			//echo $tundaan_sidang;exit;
			//tundaan=================================
			
			
			$tanggal_kuasa_kasasi = $this->register_model->tanggal_surat_kuasa_upaya_hukum($perkara_id, 'perkara_kasasi_detil');
			$template			= str_replace('#tanggal_surat_kuasa_khusus_kasasi#', $this->isi($tanggal_kuasa_kasasi[0]->tanggal_surat_kuasa_upaya_hukum), $template);
			
			$nama_kuasa_kasasi = $this->register_model->nama_kuasa_upaya_hukum($perkara_id, 'perkara_kasasi_detil');
			$template		  = str_replace('#nama_kuasa_hukum_kasasi#', $this->isi($nama_kuasa_kasasi[0]->nama_kuasa_hukum_upaya_hukum), $template);
			
			//kuasa banding
			$template = str_replace('#NamaPN#', $sys['NamaPN'], $template);
			
		} else if($jenis_register == 2){
			$register = $this->register_model->register_cetak_2($nomor_perkara);
			//var_dump($register);
			//exit;
			
			$perkara_id	 = $register[0]->perkara_id;
			$sidang_pertama = $register[0]->sidang_pertama;
			$template		= str_replace('#nomor_perkara#', $register[0]->nomor_perkara, $template);
			$template		= str_replace('#nomor_urut_register#', $this->isi($register[0]->nomor_urut_register), $template);
			$template		= str_replace('#nomor_perkara#', $this->tanggal_indonesia($register[0]->nomor_perkara), $template);
			$template		= str_replace('#tanggal_pendaftaran#', $this->tanggal_indonesia($register[0]->tanggal_pendaftaran), $template);
			$template		= str_replace('#petitum#', $this->amar($register[0]->petitum), $template);
			$template		= str_replace('#penetapan_hari_sidang#', $this->tanggal_indonesia($register[0]->penetapan_hari_sidang), $template);
			$template		= str_replace('#sidang_pertama#', $this->tanggal_indonesia($register[0]->sidang_pertama), $template);
			$template		= str_replace('#penetapan_penunjukan_mediator#', $this->tanggal_indonesia($register[0]->penetapan_penunjukan_mediator), $template);
			$template		= str_replace('#mediator_text#', $this->isi($register[0]->mediator_text), $template);
			$template		= str_replace('#tgl_sertifikasi#', $this->tanggal_indonesia($register[0]->tgl_sertifikasi), $template);
			$template		= str_replace('#no_sertifikasi#', $this->isi($register[0]->no_sertifikasi), $template);
			$template		= str_replace('#tgl_laporan_mediator#', $this->tanggal_indonesia($register[0]->tgl_laporan_mediator), $template);
			$template		= str_replace('#hasil_mediasi#', $this->hasil_mediasi($register[0]->hasil_mediasi), $template);
			$template		= str_replace('#tanggal_putusan#', $this->tanggal_indonesia($register[0]->tanggal_putusan), $template);
			//pbt
			$this->dbsipp   = $this->load->database("dbsipp", TRUE);
			
			$tanggale_pemberitahuan_putusan = '';
			
			//tanggale_pemberitahuan_putusan================================= 
			$sqle = "SELECT convert_tanggal_indonesia(tanggal_pemberitahuan_putusan) AS tanggal_pemberitahuan_putusan 
			FROM perkara_putusan_pemberitahuan_putusan WHERE perkara_id=" . $perkara_id . "  AND tanggal_pemberitahuan_putusan IS NOT NULL";
			//echo $sqle;exit;
			$q	= $this->dbsipp->query($sqle);
			
			foreach ($q->result_array() as $d){
				$tanggale_pemberitahuan_putusan .= $d['tanggal_pemberitahuan_putusan'] . '  \\par ';
			}
			
			$template = str_replace('#pemberitahuan_putusan#', $tanggale_pemberitahuan_putusan, $template);
			//tanggale_pemberitahuan_putusan=================================
			
			$template = str_replace('#amar_putusan#', $this->amar($register[0]->amar_putusan), $template);
			$template = str_replace('#tanggal_minutasi#', $this->tanggal_indonesia($register[0]->tanggal_minutasi), $template);
			$template = str_replace('#tanggal_pendaftaran_verzet#', $this->tanggal_indonesia($register[0]->tanggal_pendaftaran_verzet), $template);
			$template = str_replace('#tanggal_penetapan_sidang_verzet#', $this->tanggal_indonesia($register[0]->tanggal_penetapan_sidang_verzet), $template);
			$template = str_replace('#tanggal_sidang_pertama_verzet#', $this->tanggal_indonesia($register[0]->tanggal_sidang_pertama_verzet), $template);
			$template = str_replace('#putusan_verzet#', $this->tanggal_indonesia($register[0]->putusan_verzet), $template);
			$template = str_replace('#amar_putusan_verzet#', $this->amar($register[0]->amar_putusan_verzet), $template);
			$template = str_replace('#permohonan_banding#', $this->tanggal_indonesia($register[0]->permohonan_banding), $template);
			$template = str_replace('#pemberitahuan_permohonan_banding#', $this->tanggal_indonesia($register[0]->pemberitahuan_permohonan_banding), $template);
			$template = str_replace('#penerimaan_memori_banding#', $this->tanggal_indonesia($register[0]->penerimaan_memori_banding), $template);
			$template = str_replace('#penyerahan_memori_banding#', $this->tanggal_indonesia($register[0]->penyerahan_memori_banding), $template);
			$template = str_replace('#penerimaan_kontra_banding#', $this->tanggal_indonesia($register[0]->penerimaan_kontra_banding), $template);
			$template = str_replace('#penyerahan_kontra_banding#', $this->tanggal_indonesia($register[0]->penyerahan_kontra_banding), $template);
			$template = str_replace('#pemberitahuan_inzage_pembanding#', $this->tanggal_indonesia($register[0]->pemberitahuan_inzage_pembanding), $template);
			$template = str_replace('#pemberitahuan_inzage_terbanding#', $this->tanggal_indonesia($register[0]->pemberitahuan_inzage_terbanding), $template);
			$template = str_replace('#pengiriman_berkas_banding#', $this->tanggal_indonesia($register[0]->pengiriman_berkas_banding), $template);
			$template = str_replace('#penerimaan_kembali_berkas_banding#', $this->tanggal_indonesia($register[0]->penerimaan_kembali_berkas_banding), $template);
			$template = str_replace('#pemberitahuan_putusan_banding_pembanding#', $this->tanggal_indonesia($register[0]->pemberitahuan_putusan_banding_pembanding), $template);
			$template = str_replace('#pemberitahuan_putusan_banding_terbanding#', $this->tanggal_indonesia($register[0]->pemberitahuan_putusan_banding_terbanding), $template);
			$template = str_replace('#nomor_perkara_banding#', $this->isi($register[0]->nomor_perkara_banding), $template);
			$template = str_replace('#putusan_banding#', $this->tanggal_indonesia($register[0]->putusan_banding), $template);
			$template = str_replace('#amar_putusan_banding#', $this->amar($register[0]->amar_putusan_banding), $template);
			$template = str_replace('#permohonan_kasasi#', $this->tanggal_indonesia($register[0]->permohonan_kasasi), $template);
			$template = str_replace('#pemberitahuan_kasasi#', $this->tanggal_indonesia($register[0]->pemberitahuan_kasasi), $template);
			$template = str_replace('#penerimaan_memori_kasasi#', $this->tanggal_indonesia($register[0]->penerimaan_memori_kasasi), $template);
			$template = str_replace('#penyerahan_memori_kasasi#', $this->tanggal_indonesia($register[0]->penyerahan_memori_kasasi), $template);
			$template = str_replace('#penerimaan_kontra_kasasi#', $this->tanggal_indonesia($register[0]->penerimaan_kontra_kasasi), $template);
			$template = str_replace('#pengiriman_berkas_kasasi#', $this->tanggal_indonesia($register[0]->pengiriman_berkas_kasasi), $template);
			$template = str_replace('#penerimaan_berkas_kasasi#', $this->tanggal_indonesia($register[0]->penerimaan_berkas_kasasi), $template);
			$template = str_replace('#pemberitahuan_putusan_kasasi_pihak1#', $this->tanggal_indonesia($register[0]->pemberitahuan_putusan_kasasi_pihak1), $template);
			$template = str_replace('#pemberitahuan_putusan_kasasi_pihak2#', $this->tanggal_indonesia($register[0]->pemberitahuan_putusan_kasasi_pihak2), $template);
			$template = str_replace('#nomor_perkara_kasasi#', $this->isi($register[0]->nomor_perkara_kasasi), $template);
			$template = str_replace('#putusan_kasasi#', $this->tanggal_indonesia($register[0]->putusan_kasasi), $template);
			$template = str_replace('#amar_putusan_kasasi#', $this->amar($register[0]->amar_putusan_kasasi), $template);
			$template = str_replace('#tanggal_bht#', $this->tanggal_indonesia($register[0]->tanggal_bht), $template);
			$template = str_replace('#permohonan_pk#', $this->tanggal_indonesia($register[0]->permohonan_pk), $template);
			$template = str_replace('#pemberitahuan_pk#', $this->tanggal_indonesia($register[0]->pemberitahuan_pk), $template);
			$template = str_replace('#penerimaan_memori_pk#', $this->tanggal_indonesia($register[0]->penerimaan_memori_pk), $template);
			$template = str_replace('#penyerahan_memori_pk#', $this->tanggal_indonesia($register[0]->penyerahan_memori_pk), $template);
			$template = str_replace('#penerimaan_kontra_pk#', $this->tanggal_indonesia($register[0]->penerimaan_kontra_pk), $template);
			$template = str_replace('#tanggal_penyumpahan#', $this->tanggal_indonesia($register[0]->tanggal_penyumpahan), $template);
			$template = str_replace('#pengiriman_berkas_pk#', $this->tanggal_indonesia($register[0]->pengiriman_berkas_pk), $template);
			$template = str_replace('#penerimaan_berkas_pk#', $this->tanggal_indonesia($register[0]->penerimaan_berkas_pk), $template);
			$template = str_replace('#pemberitahuan_putusan_pk_pihak1#', $this->tanggal_indonesia($register[0]->pemberitahuan_putusan_pk_pihak1), $template);
			$template = str_replace('#pemberitahuan_putusan_pk_pihak2#', $this->tanggal_indonesia($register[0]->pemberitahuan_putusan_pk_pihak2), $template);
			$template = str_replace('#nomor_putusan_pk#', $this->isi($register[0]->nomor_putusan_pk), $template);
			$template = str_replace('#putusan_pk#', $this->isi($register[0]->putusan_pk), $template);
			$template = str_replace('#amar_putusan_pk#', $this->amar($register[0]->amar_putusan_pk), $template);
			$template = str_replace('#permohonan_eksekusi#', $this->tanggal_indonesia($register[0]->permohonan_eksekusi), $template);
			$template = str_replace('#penetapan_teguran_eksekusi#', $this->tanggal_indonesia($register[0]->penetapan_teguran_eksekusi), $template);
			$template = str_replace('#pelaksanaan_teguran_eksekusi#', $this->tanggal_indonesia($register[0]->pelaksanaan_teguran_eksekusi), $template);
			$template = str_replace('#pelaksanaan_sita_eksekusi#', $this->tanggal_indonesia($register[0]->pelaksanaan_sita_eksekusi), $template);
			//
			$template = str_replace('#penetapan_majelis_hakim_ikrar#', $this->tanggal_indonesia($register[0]->penetapan_majelis_hakim_ikrar), $template);
			$template = str_replace('#tanggal_penetapan_sidang_ikrar#', $this->tanggal_indonesia($register[0]->tanggal_penetapan_sidang_ikrar), $template);
			$template = str_replace('#tanggal_sidang_pertama_ikrar#', $this->tanggal_indonesia($register[0]->tanggal_sidang_pertama_ikrar), $template);
			$template = str_replace('#tgl_ikrar_talak#', $this->tanggal_indonesia($register[0]->tgl_ikrar_talak), $template);
			$template = str_replace('#amar_ikrar_talak#', $this->amar($register[0]->amar_ikrar_talak), $template);
			$template = str_replace('#tgl_akta_cerai#', $this->tanggal_indonesia($register[0]->tgl_akta_cerai), $template);
			$template = str_replace('#nomor_akta_cerai#', $this->isi($register[0]->nomor_akta_cerai), $template);
			$template = str_replace('#no_seri_akta_cerai#', $this->isi($register[0]->no_seri_akta_cerai), $template);
			$template = str_replace('#jenis_perkara_nama#', $this->isi($register[0]->jenis_perkara_nama), $template);
			$template = str_replace('#identitas_p#', $this->sebutan_pihak($nomor_perkara, $this->isi($register[0]->identitas_p)), $template);
			$template = str_replace('#identitas_t#', $this->sebutan_pihak($nomor_perkara, $this->isi($register[0]->identitas_t)), $template);
			
			//==============kuasa
			$tanggal_kuasa_p = $this->register_model->tanggal_surat_kuasa($nomor_perkara, 1);
			$kuasa_p		 = $tanggal_kuasa_p[0]->tanggal_kuasa;
			$tanggal_kuasa_t = $this->register_model->tanggal_surat_kuasa($nomor_perkara, 2);
			$kuasa_t		 = $tanggal_kuasa_t[0]->tanggal_kuasa;
			if($kuasa_p == NULL AND $kuasa_t == NULL){
				$template = str_replace('#tanggal_surat_kuasa_khusus#', '', $template);
			} else if($kuasa_p <> NULL AND $kuasa_t == NULL){
				$tanggal_surat_kuasa_khusus = $kuasa_p;
				$template					= str_replace('#tanggal_surat_kuasa_khusus#', $tanggal_surat_kuasa_khusus, $template);
			} else if($kuasa_p == NULL AND $kuasa_t <> NULL){
				$tanggal_surat_kuasa_khusus = "T :" . $kuasa_t;
				$template					= str_replace('#tanggal_surat_kuasa_khusus#', $tanggal_surat_kuasa_khusus, $template);
			} else{
				$tanggal_surat_kuasa_khusus = "P :" . $kuasa_p . "  \par T :" . $kuasa_t;
				$template					= str_replace('#tanggal_surat_kuasa_khusus#', $tanggal_surat_kuasa_khusus, $template);
			}
			
			
			
			$nama_kuasa_p = $this->register_model->nama_kuasa_hukum($nomor_perkara, 1);
			$nama_kuasa_p = $nama_kuasa_p[0]->nama_kuasa_hukum;
			$nama_kuasa_t = $this->register_model->nama_kuasa_hukum($nomor_perkara, 2);
			$nama_kuasa_t = $nama_kuasa_t[0]->nama_kuasa_hukum;
			if($nama_kuasa_p == NULL AND $kuasa_t == NULL){
				$template = str_replace('#nama_kuasa_hukum#', '-', $template);
			} else if($nama_kuasa_p <> NULL AND $nama_kuasa_t == NULL){
				$nama_kuasa_hukum = $nama_kuasa_p;
				$template		 = str_replace('#nama_kuasa_hukum#', $nama_kuasa_hukum, $template);
			} else if($nama_kuasa_p == NULL AND $nama_kuasa_t <> NULL){
				$nama_kuasa_hukum = "T :" . $nama_kuasa_t;
				$template		 = str_replace('#nama_kuasa_hukum#', $nama_kuasa_hukum, $template);
			} else{
				$nama_kuasa_hukum = "P :" . $nama_kuasa_p . "  \par T :" . $nama_kuasa_p;
				$template		 = str_replace('#nama_kuasa_hukum#', $nama_kuasa_hukum, $template);
			}
			//==============kuasa
			
			//pmh
			$penetapan_majelis_hakim = '';
			$q					   = $this->dbsipp->query("SELECT DISTINCT(convert_tanggal_indonesia(tanggal_penetapan)) AS penetapan,tanggal_penetapan, group_concat(hakim_nama ORDER BY urutan SEPARATOR ' \\\\par \\\\tab \\\\tab \\\\tab ')  AS HK
				FROM perkara_hakim_pn WHERE perkara_id=" . $perkara_id . " GROUP BY perkara_id, tahapan_id, tanggal_penetapan   ");
			$no					  = 0;
			foreach ($q->result_array() as $d){
			   //echo "<ol style='margin-left: -25px;' type='A'><li>".$d['penetapan']."</li><li>".$d['HK']."";
				$no++;
				$nomore = $no - 1;
				if($no == 1){
					$penetapan_majelis_hakim .= 'A. \\tab ' . $d['penetapan'] . ' \\tab B. \\tab ' . $d['HK'] . ' \\par ';
				} else{
					$penetapan_majelis_hakim .= 'A' . $nomore . '. \\tab ' . $d['penetapan'] . ' \\tab B' . $nomore . '. \\tab ' . $d['HK'] . ' \\par ';
				}
				$q = $this->dbsipp->query("SELECT group_concat(panitera_nama ORDER BY urutan SEPARATOR '<br>')  AS pp
					FROM perkara_panitera_pn WHERE perkara_id=" . $perkara_id . " AND tanggal_penetapan='" . $d['tanggal_penetapan'] . "' GROUP BY perkara_id, tahapan_id, tanggal_penetapan   ");
				foreach ($q->result_array() as $pp){
					$penetapan_majelis_hakim .= ' \\tab  \\tab  \\tab ' . $pp['pp'] . ' \\par ';
					//	echo "<br>".$pp['pp']; 
				}
			   //echo "</li></ol>";
			}
			//$penetapan_majelis_hakim.='A. \\tab Tanggal Penetapan Majelis Hakim \\tab B \\tab Susunan Majelis Hakim/Panitera Pengganti \\par ';
			$template = str_replace('#penetapan_majelis_hakim#', $penetapan_majelis_hakim, $template);
			//pmh
			
			//tundaan=================================
			$tundaan_sidang = '';
			$sqle		   = "SELECT convert_tanggal_indonesia(tanggal_sidang) AS tanggal_sidang, agenda 
			FROM perkara_jadwal_sidang WHERE perkara_id=" . $perkara_id . "  AND tanggal_sidang <> '$sidang_pertama' AND ikrar_talak='T' AND verzet='T' ";
			//echo $sqle;exit;
			$q			 = $this->dbsipp->query($sqle);
			
			foreach ($q->result_array() as $d){
				$tundaan_sidang .= $d['tanggal_sidang'] . ' \\tab ' . $d['agenda'] . ' \\par ';
			}
			$template = str_replace('#tanggal_penundaan_sidang#', $tundaan_sidang, $template);
			//echo "-".$tundaan_sidang;exit;
			//tundaan=================================
			
			//tundaan verzet=================================
			$tundaan_sidang_verzet = '';
			$q					 = $this->dbsipp->query("SELECT convert_tanggal_indonesia(tanggal_sidang) AS tanggal_sidang, agenda 
				FROM perkara_jadwal_sidang WHERE perkara_id=" . $perkara_id . "  AND tanggal_sidang <> '$sidang_pertama' AND ikrar_talak='T' AND verzet='Y' AND ditunda='Y'");
			foreach ($q->result_array() as $d){
				$tundaan_sidang_verzet .= $d['tanggal_sidang'] . ' \\tab ' . $d['agenda'] . ' \\par ';
			}
			$template = str_replace('#penundaan_sidang_verzet#', $tundaan_sidang_verzet, $template);
			//tundaan verzet=================================
			
			
			//kuasa banding
			
			$tanggal_kuasa_banding = $this->register_model->tanggal_surat_kuasa_upaya_hukum($perkara_id, 'perkara_banding_detil');
			$template			 = str_replace('#tanggal_surat_kuasa_banding#', $this->isi($tanggal_kuasa_banding[0]->tanggal_surat_kuasa_upaya_hukum), $template);
			
			$nama_kuasa_banding = $this->register_model->nama_kuasa_upaya_hukum($perkara_id, 'perkara_banding_detil');
			$template		   = str_replace('#nama_kuasa_hukum_banding#', $this->isi($nama_kuasa_banding[0]->nama_kuasa_hukum_upaya_hukum), $template);
			
			
			
			$tanggal_kuasa_kasasi = $this->register_model->tanggal_surat_kuasa_upaya_hukum($perkara_id, 'perkara_kasasi_detil');
			$template			= str_replace('#tanggal_surat_kuasa_khusus_kasasi#', $this->isi($tanggal_kuasa_kasasi[0]->tanggal_surat_kuasa_upaya_hukum), $template);
			
			$nama_kuasa_kasasi = $this->register_model->nama_kuasa_upaya_hukum($perkara_id, 'perkara_kasasi_detil');
			$template		  = str_replace('#nama_kuasa_hukum_kasasi#', $this->isi($nama_kuasa_kasasi[0]->nama_kuasa_hukum_upaya_hukum), $template);
			
			
			$tanggal_kuasa_pk = $this->register_model->tanggal_surat_kuasa_upaya_hukum($perkara_id, 'perkara_pk_detil');
			$template		 = str_replace('#tanggal_surat_kuasa_khusus_pk#', $this->isi($tanggal_kuasa_pk[0]->tanggal_surat_kuasa_upaya_hukum), $template);
			
			$nama_kuasa_pk = $this->register_model->nama_kuasa_upaya_hukum($perkara_id, 'perkara_pk_detil');
			$template	  = str_replace('#nama_kuasa_hukum_pk#', $this->isi($nama_kuasa_pk[0]->nama_kuasa_hukum_upaya_hukum), $template);
			
			
			//kuasa banding
			$template = str_replace('#NamaPN#', $sys['NamaPN'], $template);
			
		} else if($jenis_register == 3){
			$register = $this->register_model->register_cetak_3($nomor_perkara);
			
			$perkara_id = $register[0]->perkara_id;
			
			$template = str_replace('#permohonan_banding#', $this->tanggal_indonesia($register[0]->permohonan_banding), $template);
			
			$br		= array(
				"<br>",
				"<br/>",
				"<br />",
				"</br>"
			);
			$template = str_replace('#majelis_hakim_nama#', str_replace($br, ' \par ', $this->isi($register[0]->majelis_hakim_nama)), $template);
			$template = str_replace('#pp#', str_replace($br, ' \par ', $this->isi($register[0]->majelis_hakim_nama)), $template);
			$template = str_replace('#panitera_pengganti_text#', $this->amar($register[0]->panitera_pengganti_text), $template);
			
			//echo $this->isi($register[0]->panitera_pengganti_text);exit;
			
			$template = str_replace('#nomor_perkara_pn#', $this->isi($register[0]->nomor_perkara_pn), $template);
			$template = str_replace('#putusan_pn#', $this->tanggal_indonesia($register[0]->putusan_pn), $template);
			$template = str_replace('#pemberitahuan_putusan_pn#', $this->tanggal_indonesia($register[0]->pemberitahuan_putusan_pn), $template);
			$template = str_replace('#pemberitahuan_permohonan_banding#', $this->tanggal_indonesia($register[0]->pemberitahuan_permohonan_banding), $template);
			
			$template = str_replace('#penerimaan_memori_banding#', $this->tanggal_indonesia($register[0]->penerimaan_memori_banding), $template);
			$template = str_replace('#penyerahan_memori_banding#', $this->tanggal_indonesia($register[0]->penyerahan_memori_banding), $template);
			$template = str_replace('#penerimaan_kontra_banding#', $this->tanggal_indonesia($register[0]->penerimaan_kontra_banding), $template);
			$template = str_replace('#minutasi_banding#', $this->tanggal_indonesia($register[0]->minutasi_banding), $template);
			$template = str_replace('#pelaksanaan_inzage_pembanding#', $this->tanggal_indonesia($register[0]->pelaksanaan_inzage_pembanding), $template);
			$template = str_replace('#pelaksanaan_inzage_terbanding#', $this->tanggal_indonesia($register[0]->pelaksanaan_inzage_terbanding), $template);
			
			$template  = str_replace('#nomor_surat_pengiriman_berkas_banding#', $this->isi($register[0]->nomor_surat_pengiriman_berkas_banding), $template);
			$template  = str_replace('#pengiriman_berkas_banding#', $this->tanggal_indonesia($register[0]->pengiriman_berkas_banding), $template);
			$template  = str_replace('#penerimaan_kembali_berkas_banding#', $this->tanggal_indonesia($register[0]->penerimaan_kembali_berkas_banding), $template);
			$template  = str_replace('#nomor_putusan_banding#', $this->isi($register[0]->nomor_putusan_banding), $template);
			$template  = str_replace('#putusan_banding#', $this->tanggal_indonesia($register[0]->putusan_banding), $template);
			$template  = str_replace('#amar_putusan_banding#', $this->amar($register[0]->amar_putusan_banding), $template);
			$nama_nama = array(
				"Hakim Ketua:",
				"Hakim Anggota:"
			);
			$template  = str_replace('#majelis_hakim_banding#', str_replace($nama_nama, '', str_replace($br, ' \par ', $this->isi($register[0]->majelis_hakim_banding))), $template);
			$template  = str_replace('#panitera_pengganti_banding#', $this->isi($register[0]->panitera_pengganti_banding), $template);
			$template  = str_replace('#pemberitahuan_putusan_banding_pembanding#', $this->tanggal_indonesia($register[0]->pemberitahuan_putusan_banding_pembanding), $template);
			$template  = str_replace('#pemberitahuan_putusan_banding_terbanding#', $this->tanggal_indonesia($register[0]->pemberitahuan_putusan_banding_terbanding), $template);
			$template  = str_replace('#jenis_perkara_nama#', $this->isi($register[0]->jenis_perkara_nama), $template);
			
			
			//kuasa banding
			$tanggal_kuasa_banding = $this->register_model->tanggal_surat_kuasa_upaya_hukum($perkara_id, 'perkara_banding_detil');
			$template			 = str_replace('#tanggal_surat_kuasa_banding#', $this->isi($tanggal_kuasa_banding[0]->tanggal_surat_kuasa_upaya_hukum), $template);
			
			$nama_kuasa_banding = $this->register_model->nama_kuasa_upaya_hukum($perkara_id, 'perkara_banding_detil');
			$template		   = str_replace('#nama_kuasa_hukum_banding#', $this->isi($nama_kuasa_banding[0]->nama_kuasa_hukum_upaya_hukum), $template);
			
			//kuasa banding
			$template = str_replace('#NamaPN#', $sys['NamaPN'], $template);
			
			$pembanding = $register[0]->pemohon_banding;
			$terbanding = $register[0]->termohon_banding;
			if($terbanding == ""){
				$identitas_para_pihak = $pembanding;
			} else{
				$identitas_para_pihak = $pembanding . ' \par ' . $terbanding;
			}
			$template = str_replace('#identitas_para_pihak#', $identitas_para_pihak, $template);
			//$template=str_replace('﻿#mumet#', $this->isi($register[0]->panitera_pengganti_text), $template);
			$urutan   = $this->register_model->no_urut_upaya_banding($nomor_perkara);
			//var_dump($urutan);exit;
			//echo $urutan[0]->$urut;exit;
			$template = str_replace('#nomor_urut_register#', $urutan[0]->urut, $template);
			
		} else
		/////////////register banding//////////
		
		/////////////register kasasi//////////
		if($jenis_register == 4){
			$register = $this->register_model->register_cetak_4($nomor_perkara);
			
			$perkara_id = $register[0]->perkara_id;
			
			$template = str_replace('#permohonan_kasasi#', $this->tanggal_indonesia($register[0]->permohonan_kasasi), $template);
			$template = str_replace('#nomor_perkara_pn#', $this->isi($register[0]->nomor_perkara_pn), $template);
			$template = str_replace('#putusan_pn#', $this->tanggal_indonesia($register[0]->putusan_pn), $template);
			$template = str_replace('#pemberitahuan_putusan_pn#', $this->tanggal_indonesia($register[0]->pemberitahuan_putusan_pn), $template);
			$template = str_replace('#nomor_perkara_banding#', $this->isi($register[0]->nomor_perkara_banding), $template);
			$template = str_replace('#putusan_banding#', $this->tanggal_indonesia($register[0]->putusan_banding), $template);
			$template = str_replace('#pemberitahuan_putusan_banding#', $this->tanggal_indonesia($register[0]->pemberitahuan_putusan_banding), $template);
			$template = str_replace('#pemberitahuan_kasasi#', $this->tanggal_indonesia($register[0]->pemberitahuan_kasasi), $template);
			$template = str_replace('#penerimaan_memori_kasasi#', $this->tanggal_indonesia($register[0]->penerimaan_memori_kasasi), $template);
			$template = str_replace('#penyerahan_memori_kasasi#', $this->tanggal_indonesia($register[0]->penyerahan_memori_kasasi), $template);
			$template = str_replace('#penerimaan_kontra_kasasi#', $this->tanggal_indonesia($register[0]->penerimaan_kontra_kasasi), $template);
			$template = str_replace('#nomor_surat_pengiriman_berkas_kasasi#', $this->isi($register[0]->nomor_surat_pengiriman_berkas_kasasi), $template);
			$template = str_replace('#pengiriman_berkas_kasasi#', $this->tanggal_indonesia($register[0]->pengiriman_berkas_kasasi), $template);
			$template = str_replace('#penerimaan_berkas_kasasi#', $this->tanggal_indonesia($register[0]->penerimaan_berkas_kasasi), $template);
			$template = str_replace('#nomor_putusan_kasasi#', $this->tanggal_indonesia($register[0]->nomor_putusan_kasasi), $template);
			$template = str_replace('#putusan_kasasi#', $this->tanggal_indonesia($register[0]->putusan_kasasi), $template);
			$template = str_replace('#amar_putusan_kasasi#', $this->amar($register[0]->amar_putusan_kasasi), $template);
			
			$br		= array(
				"<br>",
				"<br/>",
				"<br />",
				"</br>"
			);
			$nama_nama = array(
				"Hakim Ketua : ",
				"Hakim Anggota 1 : ",
				"Hakim Anggota 2 : ",
				"Hakim Anggota 3 : "
			);
			
			$majelis_hakim_kasasi = str_replace($nama_nama, '', str_replace($br, ' \par ', $this->isi($register[0]->majelis_hakim_kasasi)));
			//$$majelis_hakim_kasasi=
			$template			= str_replace('#majelis_hakim_kasasi#', $majelis_hakim_kasasi, $template);
			$template			= str_replace('#panitera_pengganti_kasasi#', $this->isi($register[0]->panitera_pengganti_kasasi), $template);
			$template			= str_replace('#pemberitahuan_putusan_kasasi_pihak1#', $this->tanggal_indonesia($register[0]->pemberitahuan_putusan_kasasi_pihak1), $template);
			$template			= str_replace('#pemberitahuan_putusan_kasasi_pihak2#', $this->tanggal_indonesia($register[0]->pemberitahuan_putusan_kasasi_pihak2), $template);
			
			//kuasa kasasi
			$tanggal_kuasa_kasasi = $this->register_model->tanggal_surat_kuasa_upaya_hukum($perkara_id, 'perkara_kasasi_detil');
			$template			= str_replace('#tanggal_surat_kuasa_kasasi#', $this->isi($tanggal_kuasa_kasasi[0]->tanggal_surat_kuasa_upaya_hukum), $template);
			
			$nama_kuasa_kasasi = $this->register_model->nama_kuasa_upaya_hukum($perkara_id, 'perkara_kasasi_detil');
			$template		  = str_replace('#nama_kuasa_hukum_kasasi#', $this->isi($nama_kuasa_kasasi[0]->nama_kuasa_hukum_upaya_hukum), $template);
			
			//kuasa kasasi
			$template = str_replace('#NamaPN#', $sys['NamaPN'], $template);
			
			$pemohon  = $register[0]->pemohon_kasasi;
			$termohon = $register[0]->termohon_kasasi;
			if($termohon == ""){
				$identitas_para_pihak = $pemohon;
			} else{
				$identitas_para_pihak = $pemohon . ' \par ' . $termohon;
			}
			$template = str_replace('#identitas_para_pihak#', $identitas_para_pihak, $template);
			//$template=str_replace('﻿#mumet#', $this->isi($register[0]->panitera_pengganti_text), $template);
			$urutan   = $this->register_model->no_urut_upaya_banding($nomor_perkara);
			//var_dump($urutan);exit;
			//echo $urutan[0]->$urut;exit;
			$template = str_replace('#nomor_urut_register#', $urutan[0]->urut, $template);
			
		} else
		/////////////register kasasi//////////
		
		/////////////register pk//////////
		if($jenis_register == 5){
			$register = $this->register_model->register_cetak_5($nomor_perkara);
			
			$perkara_id = $register[0]->perkara_id;
			
			$template = str_replace('#permohonan_pk#', $this->tanggal_indonesia($register[0]->permohonan_pk), $template);
			$template = str_replace('#nomor_perkara_pn#', $this->isi($register[0]->nomor_perkara_pn), $template);
			$template = str_replace('#nomor_perkara_banding#', $this->isi($register[0]->nomor_perkara_banding), $template);
			$template = str_replace('#nomor_perkara_kasasi#', $this->isi($register[0]->nomor_perkara_kasasi), $template);
			$template = str_replace('#pemberitahuan_putusan_kasasi#', $this->tanggal_indonesia($register[0]->pemberitahuan_putusan_kasasi), $template);
			$template = str_replace('#alasan_pk#', $this->isi($register[0]->alasan_pk), $template);
			$template = str_replace('#pemberitahuan_pk#', $this->tanggal_indonesia($register[0]->pemberitahuan_pk), $template);
			$template = str_replace('#penerimaan_memori_pk#', $this->tanggal_indonesia($register[0]->penerimaan_memori_pk), $template);
			
			$template = str_replace('#nomor_surat_pengiriman_berkas_pk#', $this->isi($register[0]->nomor_surat_pengiriman_berkas_pk), $template);
			$template = str_replace('#pengiriman_berkas_pk#', $this->tanggal_indonesia($register[0]->pengiriman_berkas_pk), $template);
			$template = str_replace('#penerimaan_berkas_pk#', $this->tanggal_indonesia($register[0]->penerimaan_berkas_pk), $template);
			
			$template = str_replace('#nomor_putusan_pk#', $this->isi($register[0]->nomor_putusan_pk), $template);
			$template = str_replace('#putusan_pk#', $this->tanggal_indonesia($register[0]->putusan_pk), $template);
			$template = str_replace('#amar_putusan_pk#', $this->amar($register[0]->amar_putusan_pk), $template);
			
			$template = str_replace('#pemberitahuan_putusan_pk_pihak1#', $this->tanggal_indonesia($register[0]->pemberitahuan_putusan_pk_pihak1), $template);
			$template = str_replace('#pemberitahuan_putusan_pk_pihak2#', $this->tanggal_indonesia($register[0]->pemberitahuan_putusan_pk_pihak2), $template);
			$template = str_replace('#catatan_putusan_pk#', $this->isi($register[0]->catatan_putusan_pk), $template);
			
			
			$br		= array(
				"<br>",
				"<br/>",
				"<br />",
				"</br>"
			);
			$nama_nama = array(
				"Hakim Ketua : ",
				"Hakim Anggota 1 : ",
				"Hakim Anggota 2 : ",
				"Hakim Anggota 3 : "
			);
			
			$majelis_hakim_pk = str_replace($nama_nama, '', str_replace($br, ' \par ', $this->isi($register[0]->majelis_hakim_pk)));
			//$$majelis_hakim_kasasi=
			$template		 = str_replace('#majelis_hakim_pk#', $majelis_hakim_pk, $template);
			$template		 = str_replace('#panitera_pengganti_pk#', $this->isi($register[0]->panitera_pengganti_pk), $template);
			
			//kuasa kasasi
			$tanggal_kuasa_pk = $this->register_model->tanggal_surat_kuasa_upaya_hukum_pk($perkara_id, 1);
			$template		 = str_replace('#tanggal_surat_kuasa_pk#', $this->isi($tanggal_kuasa_pk[0]->tanggal_surat_kuasa_upaya_hukum), $template);
			
			$nama_kuasa_pk = $this->register_model->nama_kuasa_upaya_hukum_pk($perkara_id, 1);
			$template	  = str_replace('#nama_kuasa_hukum_pk#', $this->isi($nama_kuasa_pk[0]->nama_kuasa_hukum_upaya_hukum), $template);
			
			
			$tanggal_kuasa_pk_t = $this->register_model->tanggal_surat_kuasa_upaya_hukum_pk($perkara_id, 4);
			$template		   = str_replace('#tanggal_surat_kuasa_pk_t#', $this->isi($tanggal_kuasa_pk_t[0]->tanggal_surat_kuasa_upaya_hukum), $template);
			
			$nama_kuasa_pk_t = $this->register_model->nama_kuasa_upaya_hukum_pk($perkara_id, 4);
			$template		= str_replace('#nama_kuasa_hukum_pk_t#', $this->isi($nama_kuasa_pk_t[0]->nama_kuasa_hukum_upaya_hukum), $template);
			//kuasa kasasi
			
			$template = str_replace('#NamaPN#', $sys['NamaPN'], $template);
			
			$pemohon  = $register[0]->pemohon_pk;
			$template = str_replace('#nama_pemohon_pk#', $pemohon, $template);
			$termohon = $register[0]->termohon_pk;
			$template = str_replace('#nama_pemohon_pk_t#', $termohon, $template);
			
			//$template=str_replace('﻿#mumet#', $this->isi($register[0]->panitera_pengganti_text), $template);
			$urutan   = $this->register_model->no_urut_upaya_banding($nomor_perkara);
			//var_dump($urutan);exit;
			//echo $urutan[0]->$urut;exit;
			$template = str_replace('#nomor_urut_register#', $urutan[0]->urut, $template);
			
		}
		/////////////register pk//////////
		else
		/////////////// KUASA
			if($jenis_register == 8){
				$register = $this->register_model->register_cetak_8($nomor_perkara);
				$template = str_replace('#1#', $this->isi($register[0]->nomor_kuasa), $template);
				$template = str_replace('#2#', $this->isi($register[0]->tgl), $template);
				$template = str_replace('#3#', $this->isi($register[0]->nama_p), $template);
				$template = str_replace('#4#', $this->isi($register[0]->nama), $template);
				$template = str_replace('#5#', 'Pengacara', $template);
				$template = str_replace('#6#', $this->isi($register[0]->nomor_perkara), $template);
				$template = str_replace('#7#', $this->isi($register[0]->tanggal_kuasa), $template);
				$template = str_replace('#8#', $this->isi($register[0]->keterangan), $template);
				$template = str_replace('#NamaPN#', $sys['NamaPN'], $template);
				$template = str_replace('#PERIODE#', '', $template);
				
			}
		/////////////register KUASA //////////	
		/////////////// eksekusi
			if($jenis_register == 9 or $jenis_register == 6 or $jenis_register == 7){
				$register = $this->register_model->register_cetak_9($nomor_perkara);
				$template = str_replace('#permohonan_eksekusi#', $this->tanggal_indonesia($register[0]->permohonan_eksekusi), $template);
				$template = str_replace('#jenis_ht_text#', $this->isi($register[0]->jenis_ht_text), $template);
				$template = str_replace('#nomor_perkara_pn#', $this->isi($register[0]->nomor_perkara_pn), $template);
				$template = str_replace('#putusan_pn#', $this->tanggal_indonesia($register[0]->putusan_pn), $template);
				$template = str_replace('#nomor_perkara_banding#', $this->isi($register[0]->nomor_perkara_banding), $template);
				$template = str_replace('#putusan_banding#', $this->tanggal_indonesia($register[0]->putusan_banding), $template);
				$template = str_replace('#nomor_perkara_kasasi#', $this->isi($register[0]->nomor_perkara_kasasi), $template);
				$template = str_replace('#putusan_kasasi#', $this->tanggal_indonesia($register[0]->putusan_kasasi), $template);
				$template = str_replace('#nomor_perkara_pk#', $this->isi($register[0]->nomor_perkara_pk), $template);
				$template = str_replace('#putusan_pk#', $this->tanggal_indonesia($register[0]->putusan_pk), $template);
				$template = str_replace('#eksekusi_amar_putusan#', $this->tanggal_indonesia($register[0]->eksekusi_amar_putusan), $template);
				$template = str_replace('#penetapan_teguran_eksekusi#', $this->tanggal_indonesia($register[0]->penetapan_teguran_eksekusi), $template);
				$template = str_replace('#pelaksanaan_teguran_eksekusi #', $this->tanggal_indonesia($register[0]->pelaksanaan_teguran_eksekusi), $template);
				$template = str_replace('#penetapan_sita_eksekusi#', $this->tanggal_indonesia($register[0]->penetapan_sita_eksekusi), $template);
				$template = str_replace('#pelaksanaan_eksekusi_rill#', $this->tanggal_indonesia($register[0]->pelaksanaan_eksekusi_rill), $template);
				$template = str_replace('#penetapan_sita_eksekusi#', $this->tanggal_indonesia($register[0]->penetapan_sita_eksekusi), $template);
				$template = str_replace('#pelaksanaan_sita_eksekusi#', $this->tanggal_indonesia($register[0]->pelaksanaan_sita_eksekusi), $template);
				$template = str_replace('#penetapan_perintah_eksekusi_lelang#', $this->tanggal_indonesia($register[0]->penetapan_perintah_eksekusi_lelang), $template);
				$template = str_replace('#pelaksanaan_eksekusi_lelang#', $this->tanggal_indonesia($register[0]->pelaksanaan_eksekusi_lelang), $template);
				$template = str_replace('#penyerahan_hasil_lelang#', $this->tanggal_indonesia($register[0]->penyerahan_hasil_lelang), $template);
				$template = str_replace('#penetapan_sita_eksekusi#', $this->tanggal_indonesia($register[0]->penetapan_sita_eksekusi), $template);
				$template = str_replace('#pelaksanaan_sita_eksekusi#', $this->tanggal_indonesia($register[0]->pelaksanaan_sita_eksekusi), $template);
				$template = str_replace('#penetapan_perintah_eksekusi_lelang#', $this->tanggal_indonesia($register[0]->penetapan_perintah_eksekusi_lelang), $template);
				$template = str_replace('#pelaksanaan_eksekusi_lelang#', $this->tanggal_indonesia($register[0]->pelaksanaan_eksekusi_lelang), $template);
				$template = str_replace('#penyerahan_hasil_lelang#', $this->tanggal_indonesia($register[0]->penyerahan_hasil_lelang), $template);
				
				$template = str_replace('#catatan_eksekusi#', $this->isi($register[0]->catatan_eksekusi), $template);
				
				$template = str_replace('#nomor_urut_register#', $nomor_perkara, $template);
				$template = str_replace('#periode#', 'BULAN ' . strtoupper($this->bulan_indonesia($register[0]->permohonan_eksekusi)), $template);
				$template = str_replace('#NamaPN#', $sys['NamaPN'], $template);
			//penyitaan bergerak
				
				$template = str_replace('#PERIODE#', '', $template);
				$template = str_replace('#nomor_urut#', '', $template);
				$template = str_replace('#barang_yang_disita#', '', $template);
				$template = str_replace('#status_barang_sitaan#', '', $template);
				$template = str_replace('#penyimpanan_barang_sitaan#', '', $template);
				$template = str_replace('#jurusita_nama#', $this->isi($register[0]->jurusita_nama), $template);
				$template = str_replace('#tanggal_pendaftaran_penyitaan#', '', $template);
				$template = str_replace('#keterangan#', $this->isi($register[0]->catatan_eksekusi), $template);
			//penyitaan bergerak
				
				$id_eksekusi = $register[0]->id_eksekusi;
				$tabel		= $register[0]->tabel;
				$field		= $register[0]->field;
				
			//pihak ekseksui 
		/*	$pemohon  = $this->register_model->nama_pihak_eksekusi($id_eksekusi, $tabel, $field, 1);
			$pemohon  = str_replace('#sebagai_pihak1#', 'Pemohon', $pemohon[0]->pihak);
			$termohon = $this->register_model->nama_pihak_eksekusi($id_eksekusi, $tabel, $field, 2);
			$termohon = str_replace('#sebagai_pihak2#', 'Termohon', $termohon[0]->pihak);*/
			$template = str_replace('#identitas_pihak#', str_replace("<br>",' \par ',$register[0]->identitas_p) . ' \par						  melawan \par ' .  str_replace("<br>",' \par ',$register[0]->identitas_t), $template);
			
			//pihak ekseksui 
		}
		/////////////register eksekusi //////////	
		else
		/////////////// ac
			if($jenis_register == 10){
				$register = $this->register_model->register_cetak_10($nomor_perkara);
				$template = str_replace('#nomor_urut_akta_cerai#', $this->isi($register[0]->nomor_urut_akta_cerai), $template);
				$template = str_replace('#nama_p#', $this->isi($register[0]->nama_p), $template);
				$template = str_replace('#nama_t#', $this->isi($register[0]->nama_t), $template);
				$template = str_replace('#tanggal_bht#', $this->tanggal_indonesia($register[0]->tanggal_bht), $template);
				$template = str_replace('#tgl_ikrar_talak#', $this->tanggal_indonesia($register[0]->tgl_ikrar_talak), $template);
				$template = str_replace('#nomor_akta_cerai#', $this->isi($register[0]->nomor_akta_cerai), $template);
				$template = str_replace('#tgl_akta_cerai#', $this->tanggal_indonesia($register[0]->tgl_akta_cerai), $template);
				$template = str_replace('#nomor_perkara#', $this->isi($register[0]->nomor_perkara), $template);
				$template = str_replace('#tanggal_putusan#', $this->tanggal_indonesia($register[0]->tanggal_putusan), $template);
				$template = str_replace('#nomor_perkara_banding#', $this->isi($register[0]->nomor_putusan_banding), $template);
				$template = str_replace('#putusan_banding#', $this->tanggal_indonesia($register[0]->putusan_banding), $template);
				$template = str_replace('#nomor_perkara_kasasi#', $this->isi($register[0]->nomor_putusan_kasasi), $template);
				$template = str_replace('#putusan_kasasi#', $this->tanggal_indonesia($register[0]->putusan_kasasi), $template);
				$template = str_replace('#no_seri_akta_cerai#', $this->isi($register[0]->no_seri_akta_cerai), $template);
				$template = str_replace('#perceraian_ke#', $this->isi($register[0]->perceraian_ke), $template);
				$template = str_replace('#no_kutipan_akta_nikah#', $this->isi($register[0]->no_kutipan_akta_nikah), $template);
				$template = str_replace('#tgl_kutipan_akta_nikah#', $this->tanggal_indonesia($register[0]->tgl_kutipan_akta_nikah), $template);
				$template = str_replace('#kua_tempat_nikah#', $this->isi($register[0]->kua_tempat_nikah), $template);
				$template = str_replace('#tgl_penyerahan_akta_cerai#', $this->tanggal_indonesia($register[0]->tgl_penyerahan_akta_cerai), $template);
				$template = str_replace('#tgl_penyerahan_akta_cerai_pihak2#', $this->tanggal_indonesia($register[0]->tgl_penyerahan_akta_cerai_pihak2), $template);
				
				$talak_bain   = $register[0]->bain_raji;
				$amar_putusan = $register[0]->amar_putusan;
				
				if($talak_bain == 'cari'){
					$talak_bain = $this->talak_bain($amar_putusan);
				}
				$template = str_replace('#talak_bain#', $talak_bain, $template);
				$template = str_replace('#NamaPN#', $sys['NamaPN'], $template);
				
			}
		/////////////register ac //////////	else
			else
		/////////////// arbritrase
				
		/////////////// p3hp
				if($jenis_register == 12){
					$register   = $this->register_model->register_cetak_2($nomor_perkara);
					$perkara_id = $register[0]->perkara_id;
			//echo $register[0]->identitas_p;exit;
					$template   = str_replace('#no_urut#', '', $template);
					$template   = str_replace('#nama_dan_alamat_p#', $this->sebutan_pihak($nomor_perkara, $register[0]->identitas_p), $template);
			//echo $sebutan_pihak;
					$template   = str_replace('#tanggal_pendaftaran#', $this->tanggal_indonesia($register[0]->tanggal_pendaftaran), $template);
					$template   = str_replace('#jenis_harta_peninggalan#', 'Bergerak / Tidak Bergerak', $template);
					$template   = str_replace('#tanggal_putusan#', $this->tanggal_indonesia($register[0]->tanggal_putusan), $template);
					$template   = str_replace('#tanggal_nomor_dan_isi_akta#', $this->tanggal_indonesia($register[0]->tanggal_pendaftaran) . ' \\par ' . $register[0]->nomor_perkara . ' \\par ' . $this->amar($register[0]->amar_putusan), $template);
					
					$template = str_replace('#NamaPN#', $sys['NamaPN'], $template);
					$template = str_replace('#keterangan#', '', $template);
					
				}
		/////////////p3hp
				else if($jenis_register == 15 OR $jenis_register == 14){
					
					$template = str_replace('#NamaPN#', $sys['NamaPN'], $template);
					
				}
		/////////////arbritrase //////////	
				else
		//jinayah
					if($jenis_register == 11){
						$register = $this->register_model->register_cetak_11($nomor_perkara);
						
						$perkara_id		 = $register[0]->perkara_id;
						$sidang_pertama	 = $register[0]->sidang_pertama;
						$tanggal_putusannya = $register[0]->tanggal_putusan;
						$template		   = str_replace('#NamaPN#', $sys['NamaPN'], $template);
						$template		   = str_replace('#1#', $register[0]->nomor_urut_register, $template);
						$template		   = str_replace('#2#', $register[0]->nomor_perkara, $template);
						
						$template = str_replace('#3#', $register[0]->identitas_terdakwa, $template);
						
						$template		= str_replace('#4#', $this->tanggal_indonesia($register[0]->tanggal_surat), $template);
						$template		= str_replace('#5#', $this->amar($register[0]->dakwaan), $template);
						$template		= str_replace('#6#', $register[0]->penahanan_penyidik, $template);
						$template		= str_replace('#7#', $register[0]->penahanan_pu, $template);
						$template		= str_replace('#8#', $register[0]->penahanan_ms, $template);
						$template		= str_replace('#9#', $register[0]->penahanan_msa, $template);
						$template		= str_replace('#10#', $register[0]->penahanan_ma, $template);
						$template		= str_replace('#11#', $this->tanggal_indonesia($register[0]->penetapan_majelis_hakim), $template);
						$template		= str_replace('#12#', str_replace(":", ' \\tab : \\tab ', str_replace("</br>", ' \\par ', $register[0]->majelis_hakim_text . ' \\par ' . $register[0]->panitera_pengganti_text)), $template);
						$template		= str_replace('#13#', 'belum ada data', $template);
						$template		= str_replace('#14#', $this->tanggal_indonesia($register[0]->penetapan_hari_sidang), $template);
						$template		= str_replace('#15#', $this->tanggal_indonesia($register[0]->sidang_pertama), $template);
			//tundaan=================================
						$tundaan_sidang = '';
						$sql_sidang	 = "SELECT convert_tanggal_indonesia(tanggal_sidang) AS tanggal_sidang, alasan_ditunda 
						FROM perkara_jadwal_sidang WHERE perkara_id=" . $perkara_id . "  AND tanggal_sidang <> '" . $register[0]->sidang_pertama . "' AND ikrar_talak='T' AND verzet='T' AND ditunda='Y' ";
			//	echo $sql_sidang;exit;
						$this->dbsipp   = $this->load->database("dbsipp", TRUE);
						
						$q = $this->dbsipp->query($sql_sidang);
						foreach ($q->result_array() as $d){
							$tundaan_sidang .= $d['tanggal_sidang'] . ' \\tab ' . $d['alasan_ditunda'] . ' \\par ';
						}
						$template = str_replace('#16#', $tundaan_sidang, $template);
			//echo $tundaan_sidang;exit;
			//tundaan=================================
						$template = str_replace('#17#', $this->tanggal_indonesia($register[0]->tanggal_penuntutan), $template);
						$template = str_replace('#18#', $this->amar($register[0]->isi_penuntutan), $template);
						$template = str_replace('#19#', $this->tanggal_indonesia($register[0]->tanggal_putusan), $template);
						$template = str_replace('#20#', $this->amar($register[0]->amar_putusan), $template);
						$template = str_replace('#21#', $this->tanggal_indonesia($register[0]->tanggal_kirim_salinan_putusan), $template);
						$template = str_replace('#22#', $this->tanggal_indonesia($register[0]->tanggal_menerima_putusan), $template);
						$template = str_replace('#23#', $this->tanggal_indonesia($register[0]->tanggal_kirim_ke_jaksa), $template);
						$template = str_replace('#24#', $this->tanggal_indonesia($register[0]->tanggal_minutasi), $template);
						$template = str_replace('#25#', $register[0]->permohonan_banding, $template);
						$template = str_replace('#26#', $register[0]->pemberitahuan_permohonan_banding, $template);
						$template = str_replace('#27#', $register[0]->penerimaan_memori_banding, $template);
						$template = str_replace('#28#', $register[0]->penyerahan_memori_banding, $template);
						$template = str_replace('#29#', $register[0]->penerimaan_kontra_banding, $template);
						$template = str_replace('#30#', $register[0]->penyerahan_kontra_banding, $template);
						$template = str_replace('#31#', $register[0]->pelaksanaan_inzage, $template);
						$template = str_replace('#32#', $register[0]->tanggal_nomor_kirim, $template);
						$template = str_replace('#33#', $this->tanggal_indonesia($register[0]->penerimaan_kembali_berkas_banding), $template);
			//kurang banding
						
			//kurang banding
						
					}
		//jinayah	
					else
		//eko syar
						if($jenis_register == 13){
							$register = $this->register_model->register_cetak_2($nomor_perkara);
			//var_dump($register);
			//exit;
							
							$perkara_id	 = $register[0]->perkara_id;
							$sidang_pertama = $register[0]->sidang_pertama;
							$template		= str_replace('#nomor_perkara#', $register[0]->nomor_perkara, $template);
							$template		= str_replace('#nomor_urut_register#', $this->isi($register[0]->nomor_urut_register), $template);
							$template		= str_replace('#nomor_perkara#', $this->tanggal_indonesia($register[0]->nomor_perkara), $template);
							$template		= str_replace('#tanggal_pendaftaran#', $this->tanggal_indonesia($register[0]->tanggal_pendaftaran), $template);
							$template		= str_replace('#petitum#', $this->amar($register[0]->petitum), $template);
							$template		= str_replace('#penetapan_hari_sidang#', $this->tanggal_indonesia($register[0]->penetapan_hari_sidang), $template);
							$template		= str_replace('#sidang_pertama#', $this->tanggal_indonesia($register[0]->sidang_pertama), $template);
							$template		= str_replace('#penetapan_penunjukan_mediator#', $this->tanggal_indonesia($register[0]->penetapan_penunjukan_mediator), $template);
							$template		= str_replace('#mediator_text#', $this->isi($register[0]->mediator_text), $template);
							$template		= str_replace('#tgl_sertifikasi#', $this->tanggal_indonesia($register[0]->tgl_sertifikasi), $template);
							$template		= str_replace('#no_sertifikasi#', $this->isi($register[0]->no_sertifikasi), $template);
							$template		= str_replace('#tgl_laporan_mediator#', $this->tanggal_indonesia($register[0]->tgl_laporan_mediator), $template);
							$template		= str_replace('#hasil_mediasi#', $this->hasil_mediasi($register[0]->hasil_mediasi), $template);
							$template		= str_replace('#tanggal_putusan#', $this->tanggal_indonesia($register[0]->tanggal_putusan), $template);
			//pbt
							$this->dbsipp   = $this->load->database("dbsipp", TRUE);
							
							$tanggale_pemberitahuan_putusan = '';
							
			//tanggale_pemberitahuan_putusan================================= 
							$sqle = "SELECT convert_tanggal_indonesia(tanggal_pemberitahuan_putusan) AS tanggal_pemberitahuan_putusan 
							FROM perkara_putusan_pemberitahuan_putusan WHERE perkara_id=" . $perkara_id . "  AND tanggal_pemberitahuan_putusan IS NOT NULL";
			//echo $sqle;exit;
							$q	= $this->dbsipp->query($sqle);
							
							foreach ($q->result_array() as $d){
								$tanggale_pemberitahuan_putusan .= $d['tanggal_pemberitahuan_putusan'] . '  \\par ';
							}
							
							$template = str_replace('#pemberitahuan_putusan#', $tanggale_pemberitahuan_putusan, $template);
			//tanggale_pemberitahuan_putusan=================================
							
							$template = str_replace('#amar_putusan#', $this->amar($register[0]->amar_putusan), $template);
							$template = str_replace('#tanggal_minutasi#', $this->tanggal_indonesia($register[0]->tanggal_minutasi), $template);
							$template = str_replace('#tanggal_pendaftaran_verzet#', $this->tanggal_indonesia($register[0]->tanggal_pendaftaran_verzet), $template);
							$template = str_replace('#tanggal_penetapan_sidang_verzet#', $this->tanggal_indonesia($register[0]->tanggal_penetapan_sidang_verzet), $template);
							$template = str_replace('#tanggal_sidang_pertama_verzet#', $this->tanggal_indonesia($register[0]->tanggal_sidang_pertama_verzet), $template);
							$template = str_replace('#putusan_verzet#', $this->tanggal_indonesia($register[0]->putusan_verzet), $template);
							$template = str_replace('#amar_putusan_verzet#', $this->amar($register[0]->amar_putusan_verzet), $template);
							$template = str_replace('#permohonan_banding#', $this->tanggal_indonesia($register[0]->permohonan_banding), $template);
							$template = str_replace('#pemberitahuan_permohonan_banding#', $this->tanggal_indonesia($register[0]->pemberitahuan_permohonan_banding), $template);
							$template = str_replace('#penerimaan_memori_banding#', $this->tanggal_indonesia($register[0]->penerimaan_memori_banding), $template);
							$template = str_replace('#penyerahan_memori_banding#', $this->tanggal_indonesia($register[0]->penyerahan_memori_banding), $template);
							$template = str_replace('#penerimaan_kontra_banding#', $this->tanggal_indonesia($register[0]->penerimaan_kontra_banding), $template);
							$template = str_replace('#penyerahan_kontra_banding#', $this->tanggal_indonesia($register[0]->penyerahan_kontra_banding), $template);
							$template = str_replace('#pemberitahuan_inzage_pembanding#', $this->tanggal_indonesia($register[0]->pemberitahuan_inzage_pembanding), $template);
							$template = str_replace('#pemberitahuan_inzage_terbanding#', $this->tanggal_indonesia($register[0]->pemberitahuan_inzage_terbanding), $template);
							$template = str_replace('#pengiriman_berkas_banding#', $this->tanggal_indonesia($register[0]->pengiriman_berkas_banding), $template);
							$template = str_replace('#penerimaan_kembali_berkas_banding#', $this->tanggal_indonesia($register[0]->penerimaan_kembali_berkas_banding), $template);
							$template = str_replace('#pemberitahuan_putusan_banding_pembanding#', $this->tanggal_indonesia($register[0]->pemberitahuan_putusan_banding_pembanding), $template);
							$template = str_replace('#pemberitahuan_putusan_banding_terbanding#', $this->tanggal_indonesia($register[0]->pemberitahuan_putusan_banding_terbanding), $template);
							$template = str_replace('#nomor_perkara_banding#', $this->isi($register[0]->nomor_perkara_banding), $template);
							$template = str_replace('#putusan_banding#', $this->tanggal_indonesia($register[0]->putusan_banding), $template);
							$template = str_replace('#amar_putusan_banding#', $this->amar($register[0]->amar_putusan_banding), $template);
							$template = str_replace('#permohonan_kasasi#', $this->tanggal_indonesia($register[0]->permohonan_kasasi), $template);
							$template = str_replace('#pemberitahuan_kasasi#', $this->tanggal_indonesia($register[0]->pemberitahuan_kasasi), $template);
							$template = str_replace('#penerimaan_memori_kasasi#', $this->tanggal_indonesia($register[0]->penerimaan_memori_kasasi), $template);
							$template = str_replace('#penyerahan_memori_kasasi#', $this->tanggal_indonesia($register[0]->penyerahan_memori_kasasi), $template);
							$template = str_replace('#penerimaan_kontra_kasasi#', $this->tanggal_indonesia($register[0]->penerimaan_kontra_kasasi), $template);
							$template = str_replace('#pengiriman_berkas_kasasi#', $this->tanggal_indonesia($register[0]->pengiriman_berkas_kasasi), $template);
							$template = str_replace('#penerimaan_berkas_kasasi#', $this->tanggal_indonesia($register[0]->penerimaan_berkas_kasasi), $template);
							$template = str_replace('#pemberitahuan_putusan_kasasi_pihak1#', $this->tanggal_indonesia($register[0]->pemberitahuan_putusan_kasasi_pihak1), $template);
							$template = str_replace('#pemberitahuan_putusan_kasasi_pihak2#', $this->tanggal_indonesia($register[0]->pemberitahuan_putusan_kasasi_pihak2), $template);
							$template = str_replace('#nomor_perkara_kasasi#', $this->isi($register[0]->nomor_perkara_kasasi), $template);
							$template = str_replace('#putusan_kasasi#', $this->tanggal_indonesia($register[0]->putusan_kasasi), $template);
							$template = str_replace('#amar_putusan_kasasi#', $this->amar($register[0]->amar_putusan_kasasi), $template);
							$template = str_replace('#tanggal_bht#', $this->tanggal_indonesia($register[0]->tanggal_bht), $template);
							$template = str_replace('#permohonan_pk#', $this->tanggal_indonesia($register[0]->permohonan_pk), $template);
							$template = str_replace('#pemberitahuan_pk#', $this->tanggal_indonesia($register[0]->pemberitahuan_pk), $template);
							$template = str_replace('#penerimaan_memori_pk#', $this->tanggal_indonesia($register[0]->penerimaan_memori_pk), $template);
							$template = str_replace('#penyerahan_memori_pk#', $this->tanggal_indonesia($register[0]->penyerahan_memori_pk), $template);
							$template = str_replace('#penerimaan_kontra_pk#', $this->tanggal_indonesia($register[0]->penerimaan_kontra_pk), $template);
							$template = str_replace('#tanggal_penyumpahan#', $this->tanggal_indonesia($register[0]->tanggal_penyumpahan), $template);
							$template = str_replace('#pengiriman_berkas_pk#', $this->tanggal_indonesia($register[0]->pengiriman_berkas_pk), $template);
							$template = str_replace('#penerimaan_berkas_pk#', $this->tanggal_indonesia($register[0]->penerimaan_berkas_pk), $template);
							$template = str_replace('#pemberitahuan_putusan_pk_pihak1#', $this->tanggal_indonesia($register[0]->pemberitahuan_putusan_pk_pihak1), $template);
							$template = str_replace('#pemberitahuan_putusan_pk_pihak2#', $this->tanggal_indonesia($register[0]->pemberitahuan_putusan_pk_pihak2), $template);
							$template = str_replace('#nomor_putusan_pk#', $this->isi($register[0]->nomor_putusan_pk), $template);
							$template = str_replace('#putusan_pk#', $this->isi($register[0]->putusan_pk), $template);
							$template = str_replace('#amar_putusan_pk#', $this->amar($register[0]->amar_putusan_pk), $template);
							$template = str_replace('#permohonan_eksekusi#', $this->tanggal_indonesia($register[0]->permohonan_eksekusi), $template);
							$template = str_replace('#penetapan_teguran_eksekusi#', $this->tanggal_indonesia($register[0]->penetapan_teguran_eksekusi), $template);
							$template = str_replace('#pelaksanaan_teguran_eksekusi#', $this->tanggal_indonesia($register[0]->pelaksanaan_teguran_eksekusi), $template);
							$template = str_replace('#pelaksanaan_sita_eksekusi#', $this->tanggal_indonesia($register[0]->pelaksanaan_sita_eksekusi), $template);
			//
							$template = str_replace('#penetapan_majelis_hakim_ikrar#', $this->tanggal_indonesia($register[0]->penetapan_majelis_hakim_ikrar), $template);
							$template = str_replace('#tanggal_penetapan_sidang_ikrar#', $this->tanggal_indonesia($register[0]->tanggal_penetapan_sidang_ikrar), $template);
							$template = str_replace('#tanggal_sidang_pertama_ikrar#', $this->tanggal_indonesia($register[0]->tanggal_sidang_pertama_ikrar), $template);
							$template = str_replace('#tgl_ikrar_talak#', $this->tanggal_indonesia($register[0]->tgl_ikrar_talak), $template);
							$template = str_replace('#amar_ikrar_talak#', $this->amar($register[0]->amar_ikrar_talak), $template);
							$template = str_replace('#tgl_akta_cerai#', $this->tanggal_indonesia($register[0]->tgl_akta_cerai), $template);
							$template = str_replace('#nomor_akta_cerai#', $this->isi($register[0]->nomor_akta_cerai), $template);
							$template = str_replace('#no_seri_akta_cerai#', $this->isi($register[0]->no_seri_akta_cerai), $template);
							$template = str_replace('#jenis_perkara_nama#', $this->isi($register[0]->jenis_perkara_nama), $template);
							$template = str_replace('#identitas_p#', $this->sebutan_pihak($nomor_perkara, $this->isi($register[0]->identitas_p)), $template);
							$template = str_replace('#identitas_t#', $this->sebutan_pihak($nomor_perkara, $this->isi($register[0]->identitas_t)), $template);
							
			//==============kuasa
							$tanggal_kuasa_p = $this->register_model->tanggal_surat_kuasa($nomor_perkara, 1);
							$kuasa_p		 = $tanggal_kuasa_p[0]->tanggal_kuasa;
							$tanggal_kuasa_t = $this->register_model->tanggal_surat_kuasa($nomor_perkara, 2);
							$kuasa_t		 = $tanggal_kuasa_t[0]->tanggal_kuasa;
							if($kuasa_p == NULL AND $kuasa_t == NULL){
								$template = str_replace('#tanggal_surat_kuasa_khusus#', '', $template);
							} else if($kuasa_p <> NULL AND $kuasa_t == NULL){
								$tanggal_surat_kuasa_khusus = $kuasa_p;
								$template					= str_replace('#tanggal_surat_kuasa_khusus#', $tanggal_surat_kuasa_khusus, $template);
							} else if($kuasa_p == NULL AND $kuasa_t <> NULL){
								$tanggal_surat_kuasa_khusus = "T :" . $kuasa_t;
								$template					= str_replace('#tanggal_surat_kuasa_khusus#', $tanggal_surat_kuasa_khusus, $template);
							} else{
								$tanggal_surat_kuasa_khusus = "P :" . $kuasa_p . "  \par T :" . $kuasa_t;
								$template					= str_replace('#tanggal_surat_kuasa_khusus#', $tanggal_surat_kuasa_khusus, $template);
							}
							
							
							
							$nama_kuasa_p = $this->register_model->nama_kuasa_hukum($nomor_perkara, 1);
							$nama_kuasa_p = $nama_kuasa_p[0]->nama_kuasa_hukum;
							$nama_kuasa_t = $this->register_model->nama_kuasa_hukum($nomor_perkara, 2);
							$nama_kuasa_t = $nama_kuasa_t[0]->nama_kuasa_hukum;
							if($nama_kuasa_p == NULL AND $kuasa_t == NULL){
								$template = str_replace('#nama_kuasa_hukum#', '-', $template);
							} else if($nama_kuasa_p <> NULL AND $nama_kuasa_t == NULL){
								$nama_kuasa_hukum = $nama_kuasa_p;
								$template		 = str_replace('#nama_kuasa_hukum#', $nama_kuasa_hukum, $template);
							} else if($nama_kuasa_p == NULL AND $nama_kuasa_t <> NULL){
								$nama_kuasa_hukum = "T :" . $nama_kuasa_t;
								$template		 = str_replace('#nama_kuasa_hukum#', $nama_kuasa_hukum, $template);
							} else{
								$nama_kuasa_hukum = "P :" . $nama_kuasa_p . "  \par T :" . $nama_kuasa_p;
								$template		 = str_replace('#nama_kuasa_hukum#', $nama_kuasa_hukum, $template);
							}
			//==============kuasa
							
			//pmh
							$penetapan_majelis_hakim = '';
							$q					   = $this->dbsipp->query("SELECT DISTINCT(convert_tanggal_indonesia(tanggal_penetapan)) AS penetapan,tanggal_penetapan, group_concat(hakim_nama ORDER BY urutan SEPARATOR ' \\\\par \\\\tab \\\\tab \\\\tab ')  AS HK
								FROM perkara_hakim_pn WHERE perkara_id=" . $perkara_id . " GROUP BY perkara_id, tahapan_id, tanggal_penetapan   ");
							$no					  = 0;
							foreach ($q->result_array() as $d){
			   //echo "<ol style='margin-left: -25px;' type='A'><li>".$d['penetapan']."</li><li>".$d['HK']."";
								$no++;
								$nomore = $no - 1;
								if($no == 1){
									$penetapan_majelis_hakim .= 'A. \\tab ' . $d['penetapan'] . ' \\tab B. \\tab ' . $d['HK'] . ' \\par ';
								} else{
									$penetapan_majelis_hakim .= 'A' . $nomore . '. \\tab ' . $d['penetapan'] . ' \\tab B' . $nomore . '. \\tab ' . $d['HK'] . ' \\par ';
								}
								$q = $this->dbsipp->query("SELECT group_concat(panitera_nama ORDER BY urutan SEPARATOR '<br>')  AS pp
									FROM perkara_panitera_pn WHERE perkara_id=" . $perkara_id . " AND tanggal_penetapan='" . $d['tanggal_penetapan'] . "' GROUP BY perkara_id, tahapan_id, tanggal_penetapan   ");
								foreach ($q->result_array() as $pp){
									$penetapan_majelis_hakim .= ' \\tab  \\tab  \\tab ' . $pp['pp'] . ' \\par ';
					//	echo "<br>".$pp['pp']; 
								}
			   //echo "</li></ol>";
							}
			//$penetapan_majelis_hakim.='A. \\tab Tanggal Penetapan Majelis Hakim \\tab B \\tab Susunan Majelis Hakim/Panitera Pengganti \\par ';
							$template = str_replace('#penetapan_majelis_hakim#', $penetapan_majelis_hakim, $template);
			//pmh
							
			//tundaan=================================
							$tundaan_sidang = '';
							$sqle		   = "SELECT convert_tanggal_indonesia(tanggal_sidang) AS tanggal_sidang, agenda 
							FROM perkara_jadwal_sidang WHERE perkara_id=" . $perkara_id . "  AND tanggal_sidang <> '$sidang_pertama' AND ikrar_talak='T' AND verzet='T' ";
			//echo $sqle;exit;
							$q			 = $this->dbsipp->query($sqle);
							
							foreach ($q->result_array() as $d){
								$tundaan_sidang .= $d['tanggal_sidang'] . ' \\tab ' . $d['agenda'] . ' \\par ';
							}
							$template = str_replace('#tanggal_penundaan_sidang#', $tundaan_sidang, $template);
			//echo "-".$tundaan_sidang;exit;
			//tundaan=================================
							
			//tundaan verzet=================================
							$tundaan_sidang_verzet = '';
							$q					 = $this->dbsipp->query("SELECT convert_tanggal_indonesia(tanggal_sidang) AS tanggal_sidang, agenda 
								FROM perkara_jadwal_sidang WHERE perkara_id=" . $perkara_id . "  AND tanggal_sidang <> '$sidang_pertama' AND ikrar_talak='T' AND verzet='Y' AND ditunda='Y'");
							foreach ($q->result_array() as $d){
								$tundaan_sidang_verzet .= $d['tanggal_sidang'] . ' \\tab ' . $d['agenda'] . ' \\par ';
							}
							$template = str_replace('#penundaan_sidang_verzet#', $tundaan_sidang_verzet, $template);
			//tundaan verzet=================================
							
							
			//kuasa banding
							
							$tanggal_kuasa_banding = $this->register_model->tanggal_surat_kuasa_upaya_hukum($perkara_id, 'perkara_banding_detil');
							$template			 = str_replace('#tanggal_surat_kuasa_banding#', $this->isi($tanggal_kuasa_banding[0]->tanggal_surat_kuasa_upaya_hukum), $template);
							
							$nama_kuasa_banding = $this->register_model->nama_kuasa_upaya_hukum($perkara_id, 'perkara_banding_detil');
							$template		   = str_replace('#nama_kuasa_hukum_banding#', $this->isi($nama_kuasa_banding[0]->nama_kuasa_hukum_upaya_hukum), $template);
							
							
							
							$tanggal_kuasa_kasasi = $this->register_model->tanggal_surat_kuasa_upaya_hukum($perkara_id, 'perkara_kasasi_detil');
							$template			= str_replace('#tanggal_surat_kuasa_khusus_kasasi#', $this->isi($tanggal_kuasa_kasasi[0]->tanggal_surat_kuasa_upaya_hukum), $template);
							
							$nama_kuasa_kasasi = $this->register_model->nama_kuasa_upaya_hukum($perkara_id, 'perkara_kasasi_detil');
							$template		  = str_replace('#nama_kuasa_hukum_kasasi#', $this->isi($nama_kuasa_kasasi[0]->nama_kuasa_hukum_upaya_hukum), $template);
							
							
							$tanggal_kuasa_pk = $this->register_model->tanggal_surat_kuasa_upaya_hukum($perkara_id, 'perkara_pk_detil');
							$template		 = str_replace('#tanggal_surat_kuasa_khusus_pk#', $this->isi($tanggal_kuasa_pk[0]->tanggal_surat_kuasa_upaya_hukum), $template);
							
							$nama_kuasa_pk = $this->register_model->nama_kuasa_upaya_hukum($perkara_id, 'perkara_pk_detil');
							$template	  = str_replace('#nama_kuasa_hukum_pk#', $this->isi($nama_kuasa_pk[0]->nama_kuasa_hukum_upaya_hukum), $template);
							
							
			//kuasa banding
							$template = str_replace('#NamaPN#', $sys['NamaPN'], $template);
							
						}
		//eko syar
						else
		//mediasi
							if($jenis_register == 16){
								$register = $this->register_model->register_cetak_16($nomor_perkara);
			//var_dump($register);
			//exit;
								
								$perkara_id	 = $register[0]->perkara_id;
								$sidang_pertama = $register[0]->sidang_pertama;
								$template		= str_replace('#nomor_perkara#', $register[0]->nomor_perkara, $template);
								$template		= str_replace('#nomor_urut_register#', $this->isi($register[0]->nomor_urut_register), $template);
								$template		= str_replace('#nomor_perkara#', $this->tanggal_indonesia($register[0]->nomor_perkara), $template);
								$template		= str_replace('#tanggal_pendaftaran#', $this->tanggal_indonesia($register[0]->tanggal_pendaftaran), $template);
								$template		= str_replace('#petitum#', $this->amar($register[0]->petitum), $template);
								$template		= str_replace('#penetapan_hari_sidang#', $this->tanggal_indonesia($register[0]->penetapan_hari_sidang), $template);
								$template		= str_replace('#sidang_pertama#', $this->tanggal_indonesia($register[0]->sidang_pertama), $template);
								$template		= str_replace('#penetapan_penunjukan_mediator#', $this->tanggal_indonesia($register[0]->penetapan_penunjukan_mediator), $template);
								$template		= str_replace('#mediator_text#', $this->isi($register[0]->mediator_text), $template);
								$template		= str_replace('#tgl_sertifikasi#', $this->tanggal_indonesia($register[0]->tgl_sertifikasi), $template);
								$template		= str_replace('#no_sertifikasi#', $this->isi($register[0]->no_sertifikasi), $template);
								$template		= str_replace('#tgl_laporan_mediator#', $this->tanggal_indonesia($register[0]->tgl_laporan_mediator), $template);
								$template		= str_replace('#hasil_mediasi#', $this->hasil_mediasi($register[0]->hasil_mediasi), $template);
								$template		= str_replace('#tanggal_putusan#', $this->tanggal_indonesia($register[0]->tanggal_putusan), $template);
			//pbt
								$this->dbsipp   = $this->load->database("dbsipp", TRUE);
								
								$tanggale_pemberitahuan_putusan = '';
								
			//tanggale_pemberitahuan_putusan================================= 
								$sqle = "SELECT convert_tanggal_indonesia(tanggal_pemberitahuan_putusan) AS tanggal_pemberitahuan_putusan 
								FROM perkara_putusan_pemberitahuan_putusan WHERE perkara_id=" . $perkara_id . "  AND tanggal_pemberitahuan_putusan IS NOT NULL";
			//echo $sqle;exit;
								$q	= $this->dbsipp->query($sqle);
								
								foreach ($q->result_array() as $d){
									$tanggale_pemberitahuan_putusan .= $d['tanggal_pemberitahuan_putusan'] . '  \\par ';
								}
								
								$template = str_replace('#pemberitahuan_putusan#', $tanggale_pemberitahuan_putusan, $template);
			//tanggale_pemberitahuan_putusan=================================
								
								$template = str_replace('#amar_putusan#', $this->amar($register[0]->amar_putusan), $template);
								$template = str_replace('#tanggal_minutasi#', $this->tanggal_indonesia($register[0]->tanggal_minutasi), $template);
								$template = str_replace('#tanggal_pendaftaran_verzet#', $this->tanggal_indonesia($register[0]->tanggal_pendaftaran_verzet), $template);
								$template = str_replace('#tanggal_penetapan_sidang_verzet#', $this->tanggal_indonesia($register[0]->tanggal_penetapan_sidang_verzet), $template);
								$template = str_replace('#tanggal_sidang_pertama_verzet#', $this->tanggal_indonesia($register[0]->tanggal_sidang_pertama_verzet), $template);
								$template = str_replace('#putusan_verzet#', $this->tanggal_indonesia($register[0]->putusan_verzet), $template);
								$template = str_replace('#amar_putusan_verzet#', $this->amar($register[0]->amar_putusan_verzet), $template);
								$template = str_replace('#permohonan_banding#', $this->tanggal_indonesia($register[0]->permohonan_banding), $template);
								$template = str_replace('#pemberitahuan_permohonan_banding#', $this->tanggal_indonesia($register[0]->pemberitahuan_permohonan_banding), $template);
								$template = str_replace('#penerimaan_memori_banding#', $this->tanggal_indonesia($register[0]->penerimaan_memori_banding), $template);
								$template = str_replace('#penyerahan_memori_banding#', $this->tanggal_indonesia($register[0]->penyerahan_memori_banding), $template);
								$template = str_replace('#penerimaan_kontra_banding#', $this->tanggal_indonesia($register[0]->penerimaan_kontra_banding), $template);
								$template = str_replace('#penyerahan_kontra_banding#', $this->tanggal_indonesia($register[0]->penyerahan_kontra_banding), $template);
								$template = str_replace('#pemberitahuan_inzage_pembanding#', $this->tanggal_indonesia($register[0]->pemberitahuan_inzage_pembanding), $template);
								$template = str_replace('#pemberitahuan_inzage_terbanding#', $this->tanggal_indonesia($register[0]->pemberitahuan_inzage_terbanding), $template);
								$template = str_replace('#pengiriman_berkas_banding#', $this->tanggal_indonesia($register[0]->pengiriman_berkas_banding), $template);
								$template = str_replace('#penerimaan_kembali_berkas_banding#', $this->tanggal_indonesia($register[0]->penerimaan_kembali_berkas_banding), $template);
								$template = str_replace('#pemberitahuan_putusan_banding_pembanding#', $this->tanggal_indonesia($register[0]->pemberitahuan_putusan_banding_pembanding), $template);
								$template = str_replace('#pemberitahuan_putusan_banding_terbanding#', $this->tanggal_indonesia($register[0]->pemberitahuan_putusan_banding_terbanding), $template);
								$template = str_replace('#nomor_perkara_banding#', $this->isi($register[0]->nomor_perkara_banding), $template);
								$template = str_replace('#putusan_banding#', $this->tanggal_indonesia($register[0]->putusan_banding), $template);
								$template = str_replace('#amar_putusan_banding#', $this->amar($register[0]->amar_putusan_banding), $template);
								$template = str_replace('#permohonan_kasasi#', $this->tanggal_indonesia($register[0]->permohonan_kasasi), $template);
								$template = str_replace('#pemberitahuan_kasasi#', $this->tanggal_indonesia($register[0]->pemberitahuan_kasasi), $template);
								$template = str_replace('#penerimaan_memori_kasasi#', $this->tanggal_indonesia($register[0]->penerimaan_memori_kasasi), $template);
								$template = str_replace('#penyerahan_memori_kasasi#', $this->tanggal_indonesia($register[0]->penyerahan_memori_kasasi), $template);
								$template = str_replace('#penerimaan_kontra_kasasi#', $this->tanggal_indonesia($register[0]->penerimaan_kontra_kasasi), $template);
								$template = str_replace('#pengiriman_berkas_kasasi#', $this->tanggal_indonesia($register[0]->pengiriman_berkas_kasasi), $template);
								$template = str_replace('#penerimaan_berkas_kasasi#', $this->tanggal_indonesia($register[0]->penerimaan_berkas_kasasi), $template);
								$template = str_replace('#pemberitahuan_putusan_kasasi_pihak1#', $this->tanggal_indonesia($register[0]->pemberitahuan_putusan_kasasi_pihak1), $template);
								$template = str_replace('#pemberitahuan_putusan_kasasi_pihak2#', $this->tanggal_indonesia($register[0]->pemberitahuan_putusan_kasasi_pihak2), $template);
								$template = str_replace('#nomor_perkara_kasasi#', $this->isi($register[0]->nomor_perkara_kasasi), $template);
								$template = str_replace('#putusan_kasasi#', $this->tanggal_indonesia($register[0]->putusan_kasasi), $template);
								$template = str_replace('#amar_putusan_kasasi#', $this->amar($register[0]->amar_putusan_kasasi), $template);
								$template = str_replace('#tanggal_bht#', $this->tanggal_indonesia($register[0]->tanggal_bht), $template);
								$template = str_replace('#permohonan_pk#', $this->tanggal_indonesia($register[0]->permohonan_pk), $template);
								$template = str_replace('#pemberitahuan_pk#', $this->tanggal_indonesia($register[0]->pemberitahuan_pk), $template);
								$template = str_replace('#penerimaan_memori_pk#', $this->tanggal_indonesia($register[0]->penerimaan_memori_pk), $template);
								$template = str_replace('#penyerahan_memori_pk#', $this->tanggal_indonesia($register[0]->penyerahan_memori_pk), $template);
								$template = str_replace('#penerimaan_kontra_pk#', $this->tanggal_indonesia($register[0]->penerimaan_kontra_pk), $template);
								$template = str_replace('#tanggal_penyumpahan#', $this->tanggal_indonesia($register[0]->tanggal_penyumpahan), $template);
								$template = str_replace('#pengiriman_berkas_pk#', $this->tanggal_indonesia($register[0]->pengiriman_berkas_pk), $template);
								$template = str_replace('#penerimaan_berkas_pk#', $this->tanggal_indonesia($register[0]->penerimaan_berkas_pk), $template);
								$template = str_replace('#pemberitahuan_putusan_pk_pihak1#', $this->tanggal_indonesia($register[0]->pemberitahuan_putusan_pk_pihak1), $template);
								$template = str_replace('#pemberitahuan_putusan_pk_pihak2#', $this->tanggal_indonesia($register[0]->pemberitahuan_putusan_pk_pihak2), $template);
								$template = str_replace('#nomor_putusan_pk#', $this->isi($register[0]->nomor_putusan_pk), $template);
								$template = str_replace('#putusan_pk#', $this->isi($register[0]->putusan_pk), $template);
								$template = str_replace('#amar_putusan_pk#', $this->amar($register[0]->amar_putusan_pk), $template);
								$template = str_replace('#permohonan_eksekusi#', $this->tanggal_indonesia($register[0]->permohonan_eksekusi), $template);
								$template = str_replace('#penetapan_teguran_eksekusi#', $this->tanggal_indonesia($register[0]->penetapan_teguran_eksekusi), $template);
								$template = str_replace('#pelaksanaan_teguran_eksekusi#', $this->tanggal_indonesia($register[0]->pelaksanaan_teguran_eksekusi), $template);
								$template = str_replace('#pelaksanaan_sita_eksekusi#', $this->tanggal_indonesia($register[0]->pelaksanaan_sita_eksekusi), $template);
			//
								$template = str_replace('#penetapan_majelis_hakim_ikrar#', $this->tanggal_indonesia($register[0]->penetapan_majelis_hakim_ikrar), $template);
								$template = str_replace('#tanggal_penetapan_sidang_ikrar#', $this->tanggal_indonesia($register[0]->tanggal_penetapan_sidang_ikrar), $template);
								$template = str_replace('#tanggal_sidang_pertama_ikrar#', $this->tanggal_indonesia($register[0]->tanggal_sidang_pertama_ikrar), $template);
								$template = str_replace('#tgl_ikrar_talak#', $this->tanggal_indonesia($register[0]->tgl_ikrar_talak), $template);
								$template = str_replace('#amar_ikrar_talak#', $this->amar($register[0]->amar_ikrar_talak), $template);
								$template = str_replace('#tgl_akta_cerai#', $this->tanggal_indonesia($register[0]->tgl_akta_cerai), $template);
								$template = str_replace('#nomor_akta_cerai#', $this->isi($register[0]->nomor_akta_cerai), $template);
								$template = str_replace('#no_seri_akta_cerai#', $this->isi($register[0]->no_seri_akta_cerai), $template);
								$template = str_replace('#jenis_perkara_nama#', $this->isi($register[0]->jenis_perkara_nama), $template);
								$template = str_replace('#identitas_p#', $this->sebutan_pihak($nomor_perkara, $this->isi($register[0]->identitas_p)), $template);
								$template = str_replace('#identitas_t#', $this->sebutan_pihak($nomor_perkara, $this->isi($register[0]->identitas_t)), $template);
								
			//==============kuasa
								$tanggal_kuasa_p = $this->register_model->tanggal_surat_kuasa($nomor_perkara, 1);
								$kuasa_p		 = $tanggal_kuasa_p[0]->tanggal_kuasa;
								$tanggal_kuasa_t = $this->register_model->tanggal_surat_kuasa($nomor_perkara, 2);
								$kuasa_t		 = $tanggal_kuasa_t[0]->tanggal_kuasa;
								if($kuasa_p == NULL AND $kuasa_t == NULL){
									$template = str_replace('#tanggal_surat_kuasa_khusus#', '', $template);
								} else if($kuasa_p <> NULL AND $kuasa_t == NULL){
									$tanggal_surat_kuasa_khusus = $kuasa_p;
									$template					= str_replace('#tanggal_surat_kuasa_khusus#', $tanggal_surat_kuasa_khusus, $template);
								} else if($kuasa_p == NULL AND $kuasa_t <> NULL){
									$tanggal_surat_kuasa_khusus = "T :" . $kuasa_t;
									$template					= str_replace('#tanggal_surat_kuasa_khusus#', $tanggal_surat_kuasa_khusus, $template);
								} else{
									$tanggal_surat_kuasa_khusus = "P :" . $kuasa_p . "  \par T :" . $kuasa_t;
									$template					= str_replace('#tanggal_surat_kuasa_khusus#', $tanggal_surat_kuasa_khusus, $template);
								}
								
								
								
								$nama_kuasa_p = $this->register_model->nama_kuasa_hukum($nomor_perkara, 1);
								$nama_kuasa_p = $nama_kuasa_p[0]->nama_kuasa_hukum;
								$nama_kuasa_t = $this->register_model->nama_kuasa_hukum($nomor_perkara, 2);
								$nama_kuasa_t = $nama_kuasa_t[0]->nama_kuasa_hukum;
								if($nama_kuasa_p == NULL AND $kuasa_t == NULL){
									$template = str_replace('#nama_kuasa_hukum#', '-', $template);
								} else if($nama_kuasa_p <> NULL AND $nama_kuasa_t == NULL){
									$nama_kuasa_hukum = $nama_kuasa_p;
									$template		 = str_replace('#nama_kuasa_hukum#', $nama_kuasa_hukum, $template);
								} else if($nama_kuasa_p == NULL AND $nama_kuasa_t <> NULL){
									$nama_kuasa_hukum = "T :" . $nama_kuasa_t;
									$template		 = str_replace('#nama_kuasa_hukum#', $nama_kuasa_hukum, $template);
								} else{
									$nama_kuasa_hukum = "P :" . $nama_kuasa_p . "  \par T :" . $nama_kuasa_p;
									$template		 = str_replace('#nama_kuasa_hukum#', $nama_kuasa_hukum, $template);
								}
			//==============kuasa
								
			//pmh untuk mediasi
								$majelis_hakim	  = '';
								$panitera_pengganti = '';
								$q				 = $this->dbsipp->query("SELECT majelis_hakim_text, panitera_pengganti_text FROM perkara_penetapan WHERE perkara_id=" . $perkara_id);
								$no				= 0;
								foreach ($q->result_array() as $d){
			   //echo "<ol style='margin-left: -25px;' type='A'><li>".$d['penetapan']."</li><li>".$d['HK']."";
									$no++;
									
									$majelis_hakim	  = str_replace("<br />", ' \\par ', str_replace("<br/>", ' \\par ', str_replace("<br>", ' \\par ', str_replace("</br>", ' \\par ', $d['majelis_hakim_text']))));
									$panitera_pengganti = str_replace("<br />", ' \\par ', str_replace("<br/>", ' \\par ', str_replace("<br>", ' \\par ', str_replace("</br>", ' \\par ', $d['panitera_pengganti_text']))));
									
									
									
			   //echo "</li></ol>";
								}
			//$penetapan_majelis_hakim.='A. \\tab Tanggal Penetapan Majelis Hakim \\tab B \\tab Susunan Majelis Hakim/Panitera Pengganti \\par ';
								$template = str_replace('#majelis_hakim#', $majelis_hakim, $template);
								$template = str_replace('#panitera_pengganti#', $panitera_pengganti, $template);
			//pmh untuk mediasi
								
			// untuk mediasi pertama
								$catatan_mediasi			= '';
								$tgl_kesepakatan_perdamaian = '';
								$isi_kesepakatan_perdamaian = '';
								$tanggal_mediasi			= '';
								$jadwal_mediasi			= '';
								$q						 = $this->dbsipp->query("SELECT * FROM perkara_mediasi WHERE perkara_id=" . $perkara_id . " AND tahapan_id=10 LIMIT 1");
								$no						= 0;
								foreach ($q->result_array() as $d){
			   //echo "<ol style='margin-left: -25px;' type='A'><li>".$d['penetapan']."</li><li>".$d['HK']."";
									$catatan_mediasi			= $d['catatan_mediasi'];
									$tgl_kesepakatan_perdamaian = $this->tanggal_indonesia($d['tgl_kesepakatan_perdamaian']);
									$isi_kesepakatan_perdamaian = $d['isi_kesepakatan_perdamaian'];
									$mediasi_id				= $d['mediasi_id'];
									$jadwale_mediasi			= $this->dbsipp->query("SELECT * FROM perkara_jadwal_mediasi WHERE mediasi_id=" . $mediasi_id);
									foreach ($jadwale_mediasi->result_array() as $data_jadwal){
										$jadwal_mediasi .= $this->tanggal_indonesia($data_jadwal['tanggal_mediasi']) . ' \\par ';
										if($data_jadwal['dihadiri_oleh'] == 1){
											$tanggal_mediasi .= $this->tanggal_indonesia($data_jadwal['tanggal_mediasi']) . ' \\par ';
										}
									}
									
									
									
									
			   //echo "</li></ol>";
								}
			//$penetapan_majelis_hakim.='A. \\tab Tanggal Penetapan Majelis Hakim \\tab B \\tab Susunan Majelis Hakim/Panitera Pengganti \\par ';
								$template = str_replace('#catatan_mediasi#', $catatan_mediasi, $template);
								$template = str_replace('#tgl_kesepakatan_perdamaian#', $tgl_kesepakatan_perdamaian, $template);
								$template = str_replace('#isi_kesepakatan_perdamaian#', $this->amar($isi_kesepakatan_perdamaian), $template);
								$template = str_replace('#jadwal_mediasi#', $jadwal_mediasi, $template);
								$template = str_replace('#tanggal_mediasi#', $tanggal_mediasi, $template);
			// untuk mediasi pertama
								
			//tundaan=================================
								$tundaan_sidang = '';
								$sqle		   = "SELECT convert_tanggal_indonesia(tanggal_sidang) AS tanggal_sidang, agenda 
								FROM perkara_jadwal_sidang WHERE perkara_id=" . $perkara_id . "  AND tanggal_sidang <> '$sidang_pertama' AND ikrar_talak='T' AND verzet='T' ";
			//echo $sqle;exit;
								$q			 = $this->dbsipp->query($sqle);
								
								foreach ($q->result_array() as $d){
									$tundaan_sidang .= $d['tanggal_sidang'] . ' \\tab ' . $d['agenda'] . ' \\par ';
								}
								$template = str_replace('#tanggal_penundaan_sidang#', $tundaan_sidang, $template);
			//echo "-".$tundaan_sidang;exit;
			//tundaan=================================
								
			//tundaan verzet=================================
								$tundaan_sidang_verzet = '';
								$q					 = $this->dbsipp->query("SELECT convert_tanggal_indonesia(tanggal_sidang) AS tanggal_sidang, agenda 
									FROM perkara_jadwal_sidang WHERE perkara_id=" . $perkara_id . "  AND tanggal_sidang <> '$sidang_pertama' AND ikrar_talak='T' AND verzet='Y' AND ditunda='Y'");
								foreach ($q->result_array() as $d){
									$tundaan_sidang_verzet .= $d['tanggal_sidang'] . ' \\tab ' . $d['agenda'] . ' \\par ';
								}
								$template = str_replace('#penundaan_sidang_verzet#', $tundaan_sidang_verzet, $template);
			//tundaan verzet=================================
								
								
			//kuasa banding
								
								$tanggal_kuasa_banding = $this->register_model->tanggal_surat_kuasa_upaya_hukum($perkara_id, 'perkara_banding_detil');
								$template			 = str_replace('#tanggal_surat_kuasa_banding#', $this->isi($tanggal_kuasa_banding[0]->tanggal_surat_kuasa_upaya_hukum), $template);
								
								$nama_kuasa_banding = $this->register_model->nama_kuasa_upaya_hukum($perkara_id, 'perkara_banding_detil');
								$template		   = str_replace('#nama_kuasa_hukum_banding#', $this->isi($nama_kuasa_banding[0]->nama_kuasa_hukum_upaya_hukum), $template);
								
								
								
								$tanggal_kuasa_kasasi = $this->register_model->tanggal_surat_kuasa_upaya_hukum($perkara_id, 'perkara_kasasi_detil');
								$template			= str_replace('#tanggal_surat_kuasa_khusus_kasasi#', $this->isi($tanggal_kuasa_kasasi[0]->tanggal_surat_kuasa_upaya_hukum), $template);
								
								$nama_kuasa_kasasi = $this->register_model->nama_kuasa_upaya_hukum($perkara_id, 'perkara_kasasi_detil');
								$template		  = str_replace('#nama_kuasa_hukum_kasasi#', $this->isi($nama_kuasa_kasasi[0]->nama_kuasa_hukum_upaya_hukum), $template);
								
								
								$tanggal_kuasa_pk = $this->register_model->tanggal_surat_kuasa_upaya_hukum($perkara_id, 'perkara_pk_detil');
								$template		 = str_replace('#tanggal_surat_kuasa_khusus_pk#', $this->isi($tanggal_kuasa_pk[0]->tanggal_surat_kuasa_upaya_hukum), $template);
								
								$nama_kuasa_pk = $this->register_model->nama_kuasa_upaya_hukum($perkara_id, 'perkara_pk_detil');
								$template	  = str_replace('#nama_kuasa_hukum_pk#', $this->isi($nama_kuasa_pk[0]->nama_kuasa_hukum_upaya_hukum), $template);
								
								
			//kuasa banding
								$template = str_replace('#NamaPN#', $sys['NamaPN'], $template);
								$template = str_replace('#nomor_urut#', '', $template);
								
							}
		//mediasi
							$data = array(
								'source_file' => $source_file,
								'register_nama' => $informasi_register['register_nama'],
								'nomorperkara' => $nomorperkara,
								'template' => $template
							);
							$this->load->view('register/register_cetak_word_semua', $data);
						}
						
						function isi($isi)
						{
							if($isi == "" OR $isi == NULL){
								return '-';
							} else{
								return $isi;
							}
						}
						function amar($isi)
						{
							if($isi == "" OR $isi == NULL){
								return '-';
							} else{
								$isi = strip_tags(@$isi, '');
								
			//preg_replace("/[^A-Za-z0-9 ]/", "", $text);
								
								$isi = preg_replace('/[^a-zA-Z0-9 ,-;.-: )(]/s', '', $isi);
								$isi = str_replace("MENETAPKAN", " ", @$isi);
								$isi = str_replace("M E N E T A P K A N", " ", @$isi);
								$isi = str_replace("MENGADILI", " ", @$isi);
								$isi = str_replace("M E N G A D I L I", " ", @$isi);
								$isi = str_replace("  ", " ", @$isi);
								$isi = str_replace("   ", " ", @$isi);
								$isi = str_replace("  ", " ", @$isi);
								$isi = str_replace("&#39;", "'", @$isi);
								$isi = str_replace("&#39;", "'", @$isi);
								$isi = str_replace(";39;", "'", @$isi);
								$isi = html_entity_decode($isi, ENT_QUOTES, "UTF-8");
								$isi = str_replace(";", '; \par ', @$isi);
								$isi = str_replace(":", '; \par ', @$isi);
								$isi = str_replace("--", "", @$isi);
								$isi = str_replace("---", "", @$isi);
								$isi = str_replace("---", "", @$isi);
								$isi = str_replace("39; \par ", "'", @$isi);
								
								return $isi;
							}
						}
						function talak_bain($amar)
						{
							$keterangan_perceraian = '';
							$amar_putusan		  = strtolower(strip_tags($amar));
							$amar_putusan		  = str_replace("   ", ' ', strip_tags($amar_putusan));
							$amar_putusan		  = str_replace("  ", ' ', strip_tags($amar_putusan));
							$amar_putusan		  = str_replace("'", "", strip_tags($amar_putusan));
		// $amar_putusan=strtolower($amar_putusan);
							$amar_putusan		  = preg_replace('/[^a-z]/i', '', $amar_putusan);
							$amar_putusan		  = str_replace(" ", "", strip_tags($amar_putusan));
							
							if(stristr($amar_putusan, 'khuli') !== false OR stristr($amar_putusan, 'khulu') !== false OR stristr($amar_putusan, 'taliktalak') !== false OR stristr($amar_putusan, 'takliktalak') !== false){
								$keterangan_perceraian = "Khu'lu";
							} else if(stristr($amar_putusan, 'insughra') !== false OR stristr($amar_putusan, 'insugrho') !== false OR stristr($amar_putusan, 'insugro') !== false OR stristr($amar_putusan, 'insugra') !== false OR stristr($amar_putusan, 'bainshugra') !== false OR stristr($amar_putusan, 'inshughro') !== false OR stristr($amar_putusan, 'inshughra') !== false){
								$keterangan_perceraian = 'Ba\'in Sughra';
							} else{
								$keterangan_perceraian = 'Ba\'in Kubra';
							}
							return $keterangan_perceraian;
						}
						function hasil_mediasi($hasil)
						{
							if($hasil == "Y1"){
								return "Berhasil Dengan Kesepatakan";
							} else if($hasil == "Y2"){
								return "Berhasil Dengan Pencabutan";
							} else if($hasil == "S"){
								return "Berhasil Sebagian";
							} else if($hasil == "T"){
								return "Tidak Berhasil";
							} else if($hasil == "D"){
								return "Tidak dapat dilaksanakan";
							} else{
								return '-';
							}
						}
						function nama_hari($tanggal)
						{
		//date_default_timezone_set("Asia/Jakarta");
							if($tanggal == "" OR $tanggal == NULL){
								return '-';
								exit;
							}
							$array_hari = array(
								1 => 'Senin',
								'Selasa',
								'Rabu',
								'Kamis',
								'Jumat',
								'Sabtu',
								'Minggu'
							);
							$hari		= $array_hari[date('N', strtotime($tanggal))];
							return $hari;
							}

						function tanggal_indonesia($tanggal)
						{
		//date_default_timezone_set("Asia/Jakarta");
							if($tanggal == "" OR $tanggal == NULL){
								return '-';
								exit;
							}
							$array_hari = array(
								1 => 'Senin',
								'Selasa',
								'Rabu',
								'Kamis',
								'Jumat',
								'Sabtu',
								'Minggu'
							);
							$hari		= $array_hari[date('N', strtotime($tanggal))];
							
							$array_bulan = array(
								1 => 'Januari',
								'Februari',
								'Maret',
								'April',
								'Mei',
								'Juni',
								'Juli',
								'Agustus',
								'September',
								'Oktober',
								'November',
								'Desember'
							);
							$bulan		= $array_bulan[date('n', strtotime($tanggal))];
							
							$tgl = date('j', strtotime($tanggal));
							$thn = date('Y', strtotime($tanggal));
							
							$tgl_indonesia = $tgl . " " . $bulan . " " . $thn;
							return $tgl_indonesia;
						}
						function bulan_indonesia($tanggal)
						{
		//date_default_timezone_set("Asia/Jakarta");
							if($tanggal == "" OR $tanggal == NULL){
								return '-';
								exit;
							}
							
							$array_bulan = array(
								1 => 'Januari',
								'Februari',
								'Maret',
								'April',
								'Mei',
								'Juni',
								'Juli',
								'Agustus',
								'September',
								'Oktober',
								'November',
								'Desember'
							);
							$bulan		= $array_bulan[date('n', strtotime($tanggal))];
							$thn		 = date('Y', strtotime($tanggal));
							
							$tgl_indonesia = $bulan . " " . $thn;
							return $tgl_indonesia;
						}
						function bulan_nama($bulan)
						{
		//date_default_timezone_set("Asia/Jakarta");
							if($bulan == "" OR $bulan == NULL){
								return '-';
								exit;
							}
							
							$array_bulan = array(
								'01' => 'Januari',
								'02' =>'Februari',
								'03' =>'Maret',
								'04' =>'April',
								'05' =>'Mei',
								'06' =>'Juni',
								'07' =>'Juli',
								'08' =>'Agustus',
								'09' =>'September',
								'10' =>'Oktober',
								'11' =>'November',
								'12' =>'Desember'
							);
							$bulan		= $array_bulan[$bulan]; 
							return $bulan;
						}
						function arr2md5($arrinput)
						{
							$hasil = '';
							foreach ($arrinput as $val){
								if($hasil == ''){
									$hasil = md5($val);
								} else{
									$code = md5($val);
									for ($hit = 0; $hit < min(array(
										strlen($code),
										strlen($hasil)
									)); $hit++){
										$hasil[$hit] = chr(ord($hasil[$hit]) ^ ord($code[$hit]));
									}
								}
							}
							return (md5($hasil));
						}
						function is_login()
						{
							if($this->session->userdata('userid') == NULL OR $this->session->userdata('userid') == ""){
								$this->session->sess_destroy();
								redirect('login');
							}
						}
						function login()
						{
							
							$data		   = $this->register_model->sys_config();
							$data['NamaPN'] = $data['NamaPN'];
							$data['title']  = "Login Aplikasi e-Register";
							$this->load->view('register/login', $data);
						}
						function install_db_versi_1()
						{
							$table='information_schema.TABLES';
							$whereconditon=$table.".TABLE_SCHEMA='".$this->db->database."' AND ". $table.".TABLE_NAME='register_m_jenis_register'"; 
							$data = $this->register_model->get_all_data_where($table, $whereconditon);
							if($data==0)
							{
								$this->db->query("CREATE TABLE `register_m_jenis_register` ( `id` int(11) NOT NULL AUTO_INCREMENT,   `register_kode` varchar(10) NOT NULL,   `register_nama` varchar(200) NOT NULL,   `keterangan` varchar(500) NOT NULL,   `aktif` char(1) NOT NULL,   PRIMARY KEY (`id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");  
								$this->db->query("INSERT INTO `register_m_jenis_register` (`id`, `register_kode`, `register_nama`, `keterangan`, `aktif`) VALUES (1,	'RI-PA1P',	'Register Induk Perkara Permohonan',	'',	'y'), (2,	'RI-PA1G',	'Register Induk Perkara Gugatan',	'',	'y'),(3,	'RI-PA2',	'Register permohonan Banding',	'',	'y'), (4,	'RI-PA3',	'Register Permohonan Kasasi',	'',	'y'), (5,	'RI-PA4',	'Register Permohonan Peninjauan Kembali',	'',	'y'), (6,	'RI-PA5',	'Register Penyitaan Barang Bergerak',	'',	'y'), (7,	'RI-PA6',	'Register Penyitaan Barang Tidak Bergerak',	'',	'y'), (8,	'RI-PA7',	'Register Surat Kuasa Khusus',	'',	'y'), (9,	'RI-PA8',	'Register Eksekusi',	'',	'y'), (10,	'RI-PA9',	'Register Akta Cerai',	'',	'y'), (11,	'RI-PA10',	'Register Perkara Jinayah',	'',	'y'), (12,	'RI-PA11',	'Register P3HP',	'',	'y'), (13,	'RI-PA12',	'Register Ekonomi Syari\'ah',	'',	'y'), (14,	'RI-PA13',	'Register Istbat Rukyat Hilal dan Pemberian Nasehat/Keterangan tentang Perbedaan Penentuan Arah Kiblat dan Penentuan Awal Waktu Shalat',	'',	'y'), (15,	'RI-PA14',	'Register Eksekusi Putusan Arbitrase Syariah',	'',	'y'), (16,	'RI-PA15',	'Register Mediasi',	'',	'y');");
								$this->db->query("CREATE TABLE `register_perkara_masuk` ( `perkara_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary key (by system)', `tanggal_pendaftaran` date DEFAULT NULL COMMENT 'Tanggal Pendaftaran: isian tanggal', `nomor_urut_register` int(11) unsigned DEFAULT NULL COMMENT 'Nomor Urut Buku Register: Reset per bulan', `nomor_urut_perkara` int(11) unsigned DEFAULT NULL COMMENT 'Nomor Urut Perkara: reset per tahun untuk tiap alur_perkara_id (manual/by system)', `tahun_perkara` int(11) DEFAULT NULL, `nomor_perkara` varchar(50) NOT NULL COMMENT 'Nomor Perkara: (manual/by system)', `nomor_indeks` varchar(50) DEFAULT NULL COMMENT 'Nomor Indeks Perkara: untuk keperluan pengurutan data berdasarkan tahun,alur perkara dan nomor urut perkara (by system)', `para_pihak` text, `jenis_perkara_id` int(10) DEFAULT NULL, `keterangan` varchar(50) DEFAULT NULL, PRIMARY KEY (`perkara_id`), UNIQUE KEY `nomor_perkara` (`nomor_perkara`), KEY `nomor_indeks` (`nomor_indeks`), KEY `tanggal_pendaftaran` (`tanggal_pendaftaran`) ) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='Data Induk Perkara';");
								$this->db->query("CREATE TABLE `register_perkara_putus` ( `perkara_id` bigint(20) unsigned NOT NULL COMMENT 'Primary key (by system)', `tanggal_putusan` date NOT NULL, PRIMARY KEY (`perkara_id`,`tanggal_putusan`), KEY `tanggal_putusan` (`tanggal_putusan`) ) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='Data Putusan Perkara';");
								$this->db->query("CREATE TABLE `register_permohonan_penetapan_ikrh` ( `id` bigint(20) NOT NULL AUTO_INCREMENT, `urutan` int(11) NOT NULL, `nomor_permohonan` varchar(50) NOT NULL, `tanggal_pendaftaran` date NOT NULL, `nama_pemohon` varchar(500) NOT NULL, `keterangan_singkat_isi_permohonan` mediumtext, `tanggal_penetapan_hakim` date DEFAULT NULL, `nama_hakim` varchar(500) DEFAULT NULL, `nama_panitera` varchar(500) DEFAULT NULL, `tanggal_pelaksanaan` date DEFAULT NULL, `tempat_pelaksanaan` varchar(250) DEFAULT NULL, `tanggal_penetapan` date DEFAULT NULL, `isi_penetapan` mediumtext, `keterangan` varchar(250) DEFAULT NULL, PRIMARY KEY (`id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");
								$this->db->query("CREATE TABLE `register_validasi` ( `id` bigint(20) NOT NULL AUTO_INCREMENT, `tanggal` date NOT NULL, `validator_id` int(11) NOT NULL, `validator_username` varchar(100) NOT NULL, `validator_nama` varchar(100) NOT NULL, `validator_jabatan` varchar(100) NOT NULL, `perkara_masuk` int(10) unsigned NOT NULL, `perkara_diputus` int(10) unsigned NOT NULL, `catatan` mediumtext NOT NULL, `waktu_validasi` datetime NOT NULL, PRIMARY KEY (`id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");
								$this->db->query("CREATE TABLE `register_validasi_backup` ( `id` bigint(20) NOT NULL AUTO_INCREMENT, `tanggal` date NOT NULL, `validator_id` int(11) NOT NULL, `validator_username` varchar(100) NOT NULL, `validator_nama` varchar(100) NOT NULL, `validator_jabatan` varchar(100) NOT NULL, `catatan` mediumtext NOT NULL, `perkara_masuk` varchar(1000) DEFAULT NULL, `perkara_diputus` varchar(1000) DEFAULT NULL, `waktu_validasi` datetime NOT NULL, `waktu_penghapusan` datetime NOT NULL, PRIMARY KEY (`id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");
								$this->db->query("CREATE FUNCTION `bulan_romawi`(bln INT(2)) RETURNS varchar(4) CHARSET latin1 RETURN CASE WHEN bln = 1 THEN 'I' WHEN bln = 2 THEN 'II' WHEN bln = 3 THEN 'III' WHEN bln = 4 THEN 'IV' WHEN bln = 5 THEN 'V' WHEN bln = 6 THEN 'VI' WHEN bln = 7 THEN 'VII' WHEN bln = 8 THEN 'VIII' WHEN bln = 9 THEN 'IX' WHEN bln = 10 THEN 'X' WHEN bln = 11 THEN 'XI' WHEN bln = 12 THEN 'XII' END;");
								$this->db->query("CREATE FUNCTION `convert_tanggal_indonesia`(tmp DATE) RETURNS varchar(18) CHARSET latin1 RETURN CONCAT_WS(' ',RIGHT(tmp,2),nama_bulan(SUBSTRING(tmp,6,2)),LEFT(tmp,4));");
								$this->db->query("CREATE FUNCTION `nama_bulan`(bln INT(2)) RETURNS varchar(10) CHARSET latin1 RETURN CASE WHEN bln = 1 THEN 'Januari' WHEN bln = 2 THEN 'Februari' WHEN bln = 3 THEN 'Maret' WHEN bln = 4 THEN 'April' WHEN bln = 5 THEN 'Mei' WHEN bln = 6 THEN 'Juni' WHEN bln = 7 THEN 'Juli' WHEN bln = 8 THEN 'Agustus' WHEN bln = 9 THEN 'September' WHEN bln = 10 THEN 'Oktober' WHEN bln = 11 THEN 'November' WHEN bln = 12 THEN 'Desember' END");
								$this->db->query("CREATE FUNCTION `nama_hari`(tanggal DATE) RETURNS varchar(10) CHARSET latin1 RETURN CASE WEEKDAY(tanggal) WHEN 0 THEN 'Senin' WHEN 1 THEN 'Selasa' WHEN 2 THEN 'Rabu' WHEN 3 THEN 'Kamis' WHEN 4 THEN 'Jumat' WHEN 5 THEN 'Sabtu' WHEN 6 THEN 'Minggu' END;");
							} 
						}
						function sebutan_pihak($nomor_perkara, $isi)
						{
							
							$data = $this->register_model->sebutan_pihak($nomor_perkara);

							if($data['alur_perkara_id'] == 16 OR $data['jenis_perkara_id'] == 341 OR $data['jenis_perkara_id'] == 346)
							{
								$sebutan_pihak1 = "Pemohon";
								$sebutan_pihak2 = "Termohon";
							}else
							{
								$sebutan_pihak1 = "Penggugat";
								$sebutan_pihak2 = "Tergugat";	
							}
							$isi = trim($isi);
							$isi = str_replace("   ", " ", $isi);
							$isi = str_replace("  ", " ", $isi);
							$isi = str_replace("   ", " ", $isi);
							$isi = str_replace("  ", " ", $isi);
							$isi = str_replace(" ,", ",", $isi);
							$isi = str_replace("#sebutan_pihak1#", $sebutan_pihak1, $isi);
							$isi = str_replace("#sebutan_pihak2#", $sebutan_pihak2, $isi);
							return $isi;
						}
						function login_proses()
						{
							$userName = trim($this->input->post('username'));
							$password = trim($this->input->post('password'));
							
							
							$q			  = $this->register_model->processLogin($userName, $password);
							$h			  = $q->row_array();
							$code_activation = $h['code_activation'];
							$kata_sandi	  = $h['kata_sandi'];
							$cek			= $this->arr2md5(array(
								$code_activation,
								$password
							));
							if($cek == $kata_sandi && $cek <> ''){
								$query = $q->result();
								$user  = array(
									'userid' => $query[0]->userid,
									'nama_user' => $query[0]->nama_user,
									'fullname' => $query[0]->fullname,
									'group_name' => $query[0]->group_name,
									'group_id' => $query[0]->group_id
								);
								
								$this->session->set_userdata($user);
								redirect('register');
								
							} else{
								redirect('login');
							}
						}
						function logout()
						{
							$this->session->sess_destroy();
							redirect('login');
						}
						function datavalidasijson()
						{
							
		$table		 = "register_validasi"; //table yang ingin di tampilkan
		$select_column = array(
			"id",
			"convert_tanggal_indonesia(tanggal) AS tanggal_indonesia ",
			"tanggal",
			"validator_nama",
			"validator_jabatan",
			"perkara_masuk",
			"perkara_diputus"
		); //sesuaikan dengan nama field table
		$order_column  = array(
			null,
			"validator_nama",
			"validator_nama",
			"perkara_masuk",
			null,
			"perkara_diputus",
			null,
			null
		);
		
		$fetch_data = $this->register_model->make_datatables($table, $select_column, $order_column);
		$data		= array();
		$no		 = 0;
		foreach ($fetch_data as $row){
			$no++;
			$sub_array	 = array();
			$sub_array[]   = $row->tanggal_indonesia;
			$sub_array[]   = $row->validator_nama;
			$sub_array[]   = $row->validator_jabatan;
			$sub_array[]   = $row->perkara_masuk;
			$tabele		= 'perkara';
			$whereconditon = "tanggal_pendaftaran='" . $row->tanggal . "'";
			$sub_array[]   = $this->register_model->get_all_data_where_sipp($tabele, $whereconditon);
			$sub_array[]   = $row->perkara_diputus;
			$tabele		= 'perkara_putusan';
			$whereconditon = "tanggal_putusan='" . $row->tanggal . "'";
			$sub_array[]   = $this->register_model->get_all_data_where_sipp($tabele, $whereconditon);
			$tanggale	  = "'" . $row->tanggal . "'";
			$sub_array[]   = '<center><button type="button" name="update" onclick="cetak_validasi(' . $row->id . ')" class="btn btn-success btn-xs update"><span class="glyphicon glyphicon-print"></span> Cetak</button></center>';
			$sub_array[]   = '<center><button type="button" name="detail" onclick="lihat_validasi(' . $tanggale . ')" class="btn btn-primary btn-xs update">Detail</button></center>';
			$sub_array[]   = '<center><button type="button" name="delete" onclick="hapus_validasi(' . $tanggale . ')" class="btn btn-danger btn-xs delete"><span class="glyphicon glyphicon-trash"></span> Hapus</button></center>';
			$data[]		= $sub_array;
		}
		if(isset($_POST["draw"])){
			$draw = intval($_POST["draw"]);
		} else{
			$draw = 1;
		}
		$output = array(
			"draw" => $draw,
			"recordsTotal" => $this->register_model->get_all_data($table),
			"recordsFiltered" => $this->register_model->get_filtered_data($table, $select_column, $order_column),
			"data" => $data
		);
		echo json_encode($output);
	}
	//////register tampil
	
	//data tables
	function registerindukperkara($alur_perkara_id)
	{
		$this->is_login();
		$sys					  = $this->register_model->sys_config();
		$data['NamaPN']		   = $sys['NamaPN'];
		$data['KetuaPNNama']	  = $sys['KetuaPNNama'];
		$data['KetuaPNNIP']		= $sys['KetuaPNNIP'];
		$data['WakilKetuaPNNama'] = $sys['WakilKetuaPNNama'];
		$data['WakilKetuaPNNIP']  = $sys['WakilKetuaPNNIP'];
		$data['PanSekNama']		= $sys['PanSekNama'];
		$data['PanSekNIP']		= $sys['PanSekNIP'];
		$data['WaPanNama']		= $sys['WaPanNama'];
		$data['WaPanNIP']		 = $sys['WaPanNIP'];
		$whereconditon			= ' block=0 AND group_id IN(1010,430,1000)';
		$table					= 'v_users';
		$jenisdb				 = 'dbsipp';
		$data['panmud']		   = $this->register_model->get_data_where1($whereconditon, $table, $jenisdb);
		if($alur_perkara_id == 16){
			$data['title'] = "Register Induk Perkara Permohonan";
		} else if($alur_perkara_id == 15){
			$data['title'] = "Register Induk Perkara Gugatan";
		} else if($alur_perkara_id == 122){
			$data['title'] = "Register Induk Perkara Jinayah";
		} else if($alur_perkara_id == 370){
			$data['title'] = "Register Ekonomi Syari'ah";
		} else if($alur_perkara_id == 371){
			$data['title'] = "Register P3HP";
		}
		$data[alur_perkara_id] = $alur_perkara_id;
		//$data['validasi'] =$this->register_model->validasi_data();
		$this->load->view('register/register_header', $data);
		$this->load->view('register/register_induk_perkara');
		$this->load->view('register/register_footer');
	}
	function dataregisterindukperkara_json($alur_perkara_id)
	{
		if($alur_perkara_id == 15 OR $alur_perkara_id == 16 OR $alur_perkara_id == 122){
			$where = array(
				'alur_perkara_id' => $alur_perkara_id
			);
			if($alur_perkara_id==15){$register_id=2;}else
			if($alur_perkara_id==16){$register_id=1;}else
			if($alur_perkara_id==122){$register_id=11;}
		} else if($alur_perkara_id == 370 OR $alur_perkara_id == 371){
			$where = array(
				'jenis_perkara_id' => $alur_perkara_id
			);

			if($alur_perkara_id==370){$register_id=13;}else
			if($alur_perkara_id==371){$register_id=12;} 
		}
		$table		 = "perkara"; //table yang ingin di tampilkan
		$select_column = array(
			"perkara_id",
			"convert_tanggal_indonesia(tanggal_pendaftaran) AS tanggal_indonesia ",
			"tanggal_pendaftaran",
			"nomor_perkara",
			"para_pihak",
			"jenis_perkara_nama",
			"tahapan_terakhir_text",
			"proses_terakhir_text"
		); //sesuaikan dengan nama field table
		$order_column  = array(
			"perkara_id",
			"tanggal_pendaftaran",
			"jenis_perkara_nama",
			null,
			"tahapan_terakhir_id",
			"proses_terakhir_id",
			null
		);
		$default_sort  = 'tanggal_pendaftaran';
		$fetch_data	= $this->register_model->make_datatables_where($table, $select_column, $order_column, $where, $default_sort);
		$data		  = array();
		$no			= 0;
		foreach ($fetch_data as $row){
			$no++;
			$sub_array   = array();
			$sub_array[] = $no;
			$sub_array[] = $row->nomor_perkara;
			$sub_array[] = $row->tanggal_indonesia;
			$sub_array[] = $row->jenis_perkara_nama;
			$sub_array[] = $row->para_pihak;
			$sub_array[] = $row->tahapan_terakhir_text;
			$sub_array[] = $row->proses_terakhir_text;
			$sub_array[] = '<a href="'.base_url('register/cetak_register_html/'.$register_id.'/0/0/0/0/'.$row->perkara_id).'">detail</a>';
			$data[]	  = $sub_array;
		}
		if(isset($_POST["draw"])){
			$draw = intval($_POST["draw"]);
		} else{
			$draw = 1;
		}
		$output = array(
			"draw" => $draw,
			"recordsTotal" => $this->register_model->get_all_data_where_sipp($table, $where),
			"recordsFiltered" => $this->register_model->get_filtered_data_where($table, $select_column, $order_column, $where, $default_sort),
			"data" => $data
		);
		echo json_encode($output);
	}
	//upaya Hukum
	function registerupayahukum($alur_perkara_id)
	{
		$this->is_login();
		$sys					  = $this->register_model->sys_config();
		$data['NamaPN']		   = $sys['NamaPN'];
		$data['KetuaPNNama']	  = $sys['KetuaPNNama'];
		$data['KetuaPNNIP']		= $sys['KetuaPNNIP'];
		$data['WakilKetuaPNNama'] = $sys['WakilKetuaPNNama'];
		$data['WakilKetuaPNNIP']  = $sys['WakilKetuaPNNIP'];
		$data['PanSekNama']		= $sys['PanSekNama'];
		$data['PanSekNIP']		= $sys['PanSekNIP'];
		$data['WaPanNama']		= $sys['WaPanNama'];
		$data['WaPanNIP']		 = $sys['WaPanNIP'];
		$whereconditon			= ' block=0 AND group_id IN(1010,430,1000)';
		$table					= 'v_users';
		$jenisdb				 = 'dbsipp';
		$data['panmud']		   = $this->register_model->get_data_where1($whereconditon, $table, $jenisdb);
		if($alur_perkara_id == 20){
			$data['title']	= "Register Permohonan Banding";
			$data['tambahan'] = "Banding";
			$tabel			= 'perkara_banding';
		} else if($alur_perkara_id == 30){
			$data['title']	= "Register Permohonan Kasasi";
			$data['tambahan'] = "Kasasi";
			$tabel			= 'perkara_kasasi';
		} else if($alur_perkara_id == 40){
			$data['title'] = "Register Permohonan Peninjauan Kembali";
			
			$data['tambahan'] = "Peninjauan Kembali";
			$tabel			= 'perkara_pk';
		}
		$data[alur_perkara_id] = $alur_perkara_id;
		//$data['validasi'] =$this->register_model->validasi_data();
		$this->load->view('register/register_header', $data);
		$this->load->view('register/register_upayahukum');
		$this->load->view('register/register_footer');
	}
	function dataregisterupayahukum_json($alur_perkara_id)
	{
		if($alur_perkara_id == 20){
			$table		 = 'perkara_banding';
			$select_column = array(
				"perkara_id",
				"CONCAT(convert_tanggal_indonesia(permohonan_banding),'<br>',pemohon_banding) AS tanggal_indonesia ",
				"permohonan_banding AS daftar",
				"nomor_perkara_pn AS nomor_perkara",
				"convert_tanggal_indonesia(pengiriman_berkas_banding) AS pengiriman_berkas",
				"convert_tanggal_indonesia(penerimaan_kembali_berkas_banding) as penerimaan_kembali",
				"convert_tanggal_indonesia(pemberitahuan_putusan_banding) AS pemberitahuan_putusan",
				"status_banding_text AS status",
				"convert_tanggal_indonesia(putusan_banding) AS putus",
				"nomor_perkara_banding as nomor_upaya_hukum"
			);
			$order_column  = array(
				"perkara_id",
				"permohonan_banding",
				"pengiriman_berkas_banding",
				"putusan_banding",
				"nomor_perkara_banding",
				"penerimaan_kembali_berkas_banding",
				"pemberitahuan_putusan_banding",
				"status_banding_id",
				NULL
			);
			$default_sort  = 'permohonan_banding';
		} else if($alur_perkara_id == 30){
			$table		 = 'perkara_kasasi';
			$select_column = array(
				"perkara_id",
				"CONCAT(convert_tanggal_indonesia(permohonan_kasasi),'<br>',pemohon_kasasi) AS tanggal_indonesia ",
				"permohonan_kasasi AS daftar",
				"nomor_perkara_pn AS nomor_perkara",
				"convert_tanggal_indonesia(pengiriman_berkas_kasasi) AS pengiriman_berkas",
				"convert_tanggal_indonesia(penerimaan_berkas_kasasi) as penerimaan_kembali",
				"convert_tanggal_indonesia(pemberitahuan_putusan_kasasi) AS pemberitahuan_putusan",
				"status_kasasi_text AS status",
				"convert_tanggal_indonesia(putusan_kasasi) AS putus",
				"nomor_perkara_kasasi as nomor_upaya_hukum"
			);
			$order_column  = array(
				"perkara_id",
				"permohonan_kasasi",
				"pengiriman_berkas_kasasi",
				"putusan_kasasi",
				"nomor_perkara_kasasi",
				"penerimaan_berkas_kasasi",
				"pemberitahuan_putusan_kasasi",
				"status_kasasi_id",
				NULL
			);
			$default_sort  = 'permohonan_kasasi';
		} else if($alur_perkara_id == 40){
			$table		 = 'perkara_pk';
			$select_column = array(
				"perkara_id",
				"CONCAT(convert_tanggal_indonesia(permohonan_pk),'<br>',pemohon_pk) AS tanggal_indonesia ",
				"permohonan_pk AS daftar",
				"nomor_perkara_pn AS nomor_perkara",
				"convert_tanggal_indonesia(pengiriman_berkas_pk) AS pengiriman_berkas",
				"convert_tanggal_indonesia(penerimaan_berkas_pk) as penerimaan_kembali",
				"convert_tanggal_indonesia(pemberitahuan_putusan_pk) AS pemberitahuan_putusan",
				"status_pk_text AS status",
				"convert_tanggal_indonesia(putusan_pk) AS putus",
				"nomor_perkara_pk as nomor_upaya_hukum"
			);
			$order_column  = array(
				"perkara_id",
				"permohonan_pk",
				"pengiriman_berkas_pk",
				"putusan_pk",
				"nomor_perkara_pk",
				"penerimaan_berkas_pk",
				"pemberitahuan_putusan_pk",
				"status_pk_id",
				NULL
			);
			$default_sort  = 'permohonan_pk';
		}
		$where = 'perkara_id IS NOT NULL';
		//$table = "perkara";  //table yang ingin di tampilkan
		
		$fetch_data = $this->register_model->make_datatables_where($table, $select_column, $order_column, $where, $default_sort);
		$data		= array();
		$no		 = 0;
		foreach ($fetch_data as $row){
			$no++;
			$sub_array   = array();
			$sub_array[] = $row->nomor_perkara;
			$sub_array[] = $row->tanggal_indonesia;
			$sub_array[] = $row->pengiriman_berkas;
			$sub_array[] = $row->putus;
			$sub_array[] = $row->nomor_upaya_hukum;
			$sub_array[] = $row->penerimaan_kembali;
			$sub_array[] = $row->pemberitahuan_putusan;
			$sub_array[] = $row->status;
			$sub_array[] = '';
			$data[]	  = $sub_array;
		}
		if(isset($_POST["draw"])){
			$draw = intval($_POST["draw"]);
		} else{
			$draw = 1;
		}
		$output = array(
			"draw" => $draw,
			"recordsTotal" => $this->register_model->get_all_data_where_sipp($table, $where),
			"recordsFiltered" => $this->register_model->get_filtered_data_where($table, $select_column, $order_column, $where, $default_sort),
			"data" => $data
		);
		echo json_encode($output);
	}
	//upaya Hukum
	
	//akta cerai
	function registeraktacerai()
	{
		$this->is_login();
		$sys		   = $this->register_model->sys_config();
		$data['title'] = "Register Akta Cerai";
		
		$data[alur_perkara_id] = $alur_perkara_id;
		//$data['validasi'] =$this->register_model->validasi_data();
		$this->load->view('register/register_header', $data);
		$this->load->view('register/register_induk_akta_cerai');
		$this->load->view('register/register_footer');
	}
	function dataregisteraktacerai_json()
	{
		
		$table		 = 'perkara_akta_cerai';
		$select_column = array(
			"perkara_id",
			"nomor_urut_akta_cerai",
			"nomor_akta_cerai",
			"tgl_akta_cerai",
			"CONCAT(nomor_akta_cerai,'<br>',convert_tanggal_indonesia(tgl_akta_cerai)) AS tanggal_indonesia ",
			"(SELECT CONCAT(pihak1_text,'<br>',pihak2_text) FROM perkara where perkara_id=perkara_akta_cerai.perkara_id) AS pihak",
			"CONCAT((SELECT  nomor_perkara from perkara where perkara_id=perkara_akta_cerai.perkara_id), '<br>', (SELECT  convert_tanggal_indonesia(tanggal_putusan) from perkara_putusan where perkara_id=perkara_akta_cerai.perkara_id)) AS nomor_perkara",
			"no_seri_akta_cerai",
			"convert_tanggal_indonesia(tgl_penyerahan_akta_cerai) as penyerahan_p",
			"convert_tanggal_indonesia(tgl_penyerahan_akta_cerai_pihak2) as penyerahan_t",
			"jenis_cerai"
		);
		$order_column  = array(
			"no_seri_akta_cerai",
			NULL,
			NULL,
			NULL,
			NULL,
			NULL,
			NULL
		);
		$default_sort  = 'tgl_akta_cerai';
		
		$where = 'nomor_akta_cerai IS NOT NULL';
		//$table = "perkara";  //table yang ingin di tampilkan
		
		$fetch_data = $this->register_model->make_datatables_where($table, $select_column, $order_column, $where, $default_sort);
		$data		= array();
		$no		 = 0;
		foreach ($fetch_data as $row){
			$no++;
			$sub_array   = array();
			$sub_array[] = $row->nomor_urut_akta_cerai;
			$sub_array[] = $row->pihak;
			$sub_array[] = $row->tanggal_indonesia;
			$sub_array[] = $row->nomor_perkara;
			$sub_array[] = $row->no_seri_akta_cerai;
			$sub_array[] = $row->perceraian_ke;
			$sub_array[] = 'A.' . $row->penyerahan_p . '<br>B.' . $row->penyerahan_t;
			$data[]	  = $sub_array;
		}
		if(isset($_POST["draw"])){
			$draw = intval($_POST["draw"]);
		} else{
			$draw = 1;
		}
		$output = array(
			"draw" => $draw,
			"recordsTotal" => $this->register_model->get_all_data_where_sipp($table, $where),
			"recordsFiltered" => $this->register_model->get_filtered_data_where($table, $select_column, $order_column, $where, $default_sort),
			"data" => $data
		);
		echo json_encode($output);
	}
	//akta cerai
	
	//data tables
	//////register tampil
}