<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Abt extends CI_Controller {
	function __construct() {
		parent::__construct();
		if($this->session->userdata('userid')==NULL OR $this->session->userdata('userid')==""){
			$this->session->sess_destroy();
			redirect('login');}
		$this->load->helper('abt_helper');
		$this->load->library('encrypt');
		$this->load->library('MY_Encrypt');
		$this->load->library('TemplateHelper');
		$this->load->model('abt/Abt_model');
	}
	
	function page($string){
		if ($string == 'variabel'){
			$judul	 	= 'Daftar Variabel';
			$main 		= $this->html_variabel($judul);}
		else if ($string == 'cari'){
			$judul	 	= 'Masukkan Nomor Perkara';
			$main 		= $this->html_cari_perkara($judul);}
		else if ($string == 'view'){
			$judul	 	= 'Blangko';
			$main 		= $this->html_view($judul);}
		else if ($string == 'about'){
			$judul	 	= 'Tentang Aplikasi';
			$main 		= $this->html_about($judul);}
		else if ($string == 'tanyajawab_template'){
			$judul	 	= 'Pengaturan Tanya Jawab';
			$main 		= $this->html_tanyajawab_template($judul);}
		else if ($string == 'backup'){
			$judul	 	= 'Backup Data Perkara Aplikasi';
			$main 		= $this->html_backup($judul);}
		else if ($string == 'validasi_bas'){
			$judul	 	= 'Validasi Data Berita Acara Sidang';
			$main 		= $this->html_validasi_bas($judul);}
		else if ($string == 'qrcode_setting'){
			$judul	 	= 'Pengaturan Kode QR Perkara';
			$main 		= $this->html_qrcode_setting($judul);}
		else if ($string == 'qrcode'){
			$judul	 	= 'Kode QR Perkara';
			$main 		= $this->html_qrcode($judul);}
		else if ($string == 'anonim'){
			$judul	 	= 'Anonimisasi File Putusan';
			$main 		= $this->html_anonim($judul);}
		else if ($string == 'dirput'){
			$judul 		= 'Monitoring Publikasi Putusan';
			$main 		= $this->html_dirput_perkara($judul);}
		else {
			$judul	 	= 'Beranda';
			$main 		= $this->html_beranda($judul);}
	return array(
				"judul" => $judul,
				"main" => $main
						);}
	
	public function index() {
			$this->main();
	}

	public function main($v='') {
		$main = $this->page($v);
		$data = array(
		"modul_menu" => NULL,
		"modul_menu" => $this->html_menu(),
		"modul_main" => $this->Abt_model->modul_main(),
		"modul_index" => $main['main']
		);
		$this->load->view('abt/index',$data);
	}
	
		
	public function html_menu() {
		$data = array(
		"validasi_bas" 	=> $this->Abt_model->GetKonfigurasi('validasi_data_bas'),
		"count_bas" 	=> count($this->Abt_model->daftar_perkara_validasi_bas(0)),
		"session_data" 	=> $this->session->userdata(),
		"_blangko_rtf"	=> $this->Abt_model->daftar_menu()
		);
		return $this->load->view("abt/modul_menu",$data,TRUE);
	}	

	public function edit_var() {
		$novar		= $this->input->get('no_var');	
		$aksi		= $this->input->post('aksi');
		$novar_edit	= $this->input->post('no_var');
		
		//definisi data
		$data_type	  = $this->input->post('data_type');
		$data_tabel	  = $this->input->post('data_tabel');
		$data_kolom	  = $this->input->post('data_kolom');
		$urutan_data  = $this->input->post('urutan_data');
		$referensi	  = $this->input->post('referensi');
		$sql_query	  = $this->input->post('sql_query');
		$default_data = $this->input->post('default_data');
		if($data_type=='multi_sidang' or $data_type=='tanya_jawab'){$multi_sidang = $this->input->post('multi_sidang');}
		if($novar_edit==$referensi){$referensi = 9999;}
		$data = array(
               'nama' 		  => $this->input->post('nama'),
               'data_type'	  => (!empty($data_type)) ? $data_type : NULL,
               'data_tabel'	  => (!empty($data_tabel)) ? $data_tabel : NULL,
               'data_kolom'	  => (!empty($data_kolom)) ? $data_kolom : NULL,
               'urutan_data'  => (!empty($urutan_data)) ? $urutan_data : NULL,
               'referensi'	  => (!empty($referensi)) ? $referensi : NULL,
               'sql_query'	  => (!empty($sql_query)) ? $sql_query : NULL,
               'default_data' => (!empty($default_data)) ? $default_data : NULL,
               'multi_sidang' => (!empty($multi_sidang)) ? $multi_sidang : NULL
            );
		
		//aksi data
		if($aksi=='Simpan'){
		if($this->Abt_model->update_tabel('abt_variabel',array('no_var'=>$novar_edit),$data)==TRUE){
			echo "<font color='green' style='float:right;font-weight:bold;'>VARIABEL DISIMPAN</font>";}
			else {
		echo "<font color='red' style='float:right;font-weight:bold;'>VARIABEL TIDAK TERSIMPAN</font>";}}
		else if($aksi=='Hapus'){
		if($this->Abt_model->delete_tabel('abt_variabel',array('no_var'=>$novar_edit))==TRUE){
			die("<font color='red' style='float:right;font-weight:bold;'>VARIABEL DIHAPUS</font>");}
			else {
		echo "<font color='red' style='float:right;font-weight:bold;'>VARIABEL TIDAK TERHAPUS</font>";}}
		
		//menuju ke view
		$data = array(
		"tipe"  =>  $this->Abt_model->GetTabel('abt_variabel_tipe'),
		"data"  =>  $this->Abt_model->get_variabel_id($novar),
		'info'  => "display:none;"
		);
		$this->load->view('abt/popup_variabel',$data);
	}
	
	public function add_var() {
		$no_var = $this->input->post('no_var');
		if(empty($no_var)){
			$no_var = $this->Abt_model->GetLastId('abt_variabel','no_var');}
		
		//definisi data
		$data_type	  = $this->input->post('data_type');
		$data_tabel	  = $this->input->post('data_tabel');
		$data_kolom	  = $this->input->post('data_kolom');
		$urutan_data  = $this->input->post('urutan_data');
		$referensi	  = $this->input->post('referensi');
		$sql_query	  = $this->input->post('sql_query');
		$default_data = $this->input->post('default_data');
		if($data_type=='multi_sidang' or $data_type=='tanya_jawab'){$multi_sidang = $this->input->post('multi_sidang');}
		if($no_var==$referensi){$referensi = 9999;}
		$data_post = array(
               'no_var' 	  => $no_var,
               'nama' 		  => $this->input->post('nama'),
               'data_type'	  => (!empty($data_type)) ? $data_type : NULL,
               'data_tabel'	  => (!empty($data_tabel)) ? $data_tabel : NULL,
               'data_kolom'	  => (!empty($data_kolom)) ? $data_kolom : NULL,
               'urutan_data'  => (!empty($urutan_data)) ? $urutan_data : NULL,
               'referensi'	  => (!empty($referensi)) ? $referensi : NULL,
               'sql_query'	  => (!empty($sql_query)) ? $sql_query : NULL,
               'default_data' => (!empty($default_data)) ? $default_data : NULL,
               'multi_sidang' => (!empty($multi_sidang)) ? $multi_sidang : NULL,
               'locked' 	  => NULL
            );
		
		$aksi = $this->input->post('aksi');		
		if($aksi=='Simpan'){
		if($this->Abt_model->insert_tabel('abt_variabel',$data_post)==TRUE){
			die ("<font color='green' style='float:right;font-weight:bold;'>VARIABEL DISIMPAN</font>");}
			else {
		echo "<font color='red' style='float:right;font-weight:bold;'>VARIABEL TIDAK TERSIMPAN</font>";}}
		
		$dat_null[0] = (object)$data_post;
		$data = array(
		"tipe"  =>  $this->Abt_model->GetTabel('abt_variabel_tipe'),
		"data" => $dat_null,
		'info' => NULL
		);
		$this->load->view('abt/popup_variabel',$data);
	}	
	
	public function edit_data() {
		$perkara_id	 = $this->input->get('perkara_id');
		$no_var	 	 = $this->input->get('no_var');
		$aksi		 = $this->input->post('aksi');
		$value		 = $this->input->post('value');
		$data_table	 = $this->input->post('var_type');
		if($aksi=='Simpan'){
			if($data_table=='data_tanggal'){
				$value = tgl_sql($value);}
		if($this->Abt_model->update_data($data_table,$no_var,$perkara_id,$value)==TRUE){
			echo "<font color='green' style='float:right;font-weight:bold;'>DATA DISIMPAN</font>";}
		else {
			echo "<font color='red' style='float:right;font-weight:bold;'>DATA TIDAK TERSIMPAN</font>";}}
		$data = array(
			"data"  	  =>  $this->Abt_model->data_variabel_detil($perkara_id,$no_var),
			"perkara_id"  =>  $perkara_id,
			"no_var"  	  =>  $no_var);
		$this->load->view('abt/popup_data',$data);
	}	
	
	public function popup_perk_temp($nomor_sementara=NULL){
		$data = array();
		$data_get = $this->input->get('t');
		$this->load->model('abt/Perkara_sementara');
		
		if($this->input->post('aksi')=='ubah_nomor' and $this->input->post('id') and $this->input->post('perkara_id') and $data_get=='no_sipp'){
			if($this->Perkara_sementara->ubah_ke_no_sipp($this->input->post('id'),$this->input->post('perkara_id'))){
				die("<font color='green' style='float:right;font-weight:bold;'>PROSES PEMINDAHAN DATA BERHASIL</font>");}
			else{
				echo "<font color='red' style='float:right;font-weight:bold;'>PROSES TIDAK BERHASIL</font>";}}	
		else if($this->input->post('id') and $this->input->post('pihak_id') and $this->input->post('urutan') and $this->input->post('pihak_ke') and $data_get=='pihak'){
			$this->Abt_model->insert_tabel('abt_temp_data_pihak',$this->input->post());}
		else if($this->input->post('aksi')=='delete' and $data_get=='pihak'){
			$this->Abt_model->delete_tabel('abt_temp_data_pihak',array('id'=>$this->input->post('id'),'pihak_ke'=>$this->input->post('pihak_ke'),'urutan'=>$this->input->post('urutan')));}
		else if($this->input->post('aksi')=='Hapus' and $this->input->post('id')){
			if($this->Abt_model->delete_tabel('abt_temp_data_perkara',array('id'=>$this->input->post('id')))){
				die("<font color='red' style='float:right;font-weight:bold;'>DATA DIHAPUS</font>");}}
		else if($this->input->post('aksi')=='Simpan' and $this->input->post('id')){
			$this->Abt_model->update_tabel('abt_temp_data_perkara',array('id'=>$this->input->post('id')),array('tanggal_surat'=>tgl_sql($this->input->post('tanggal'))));}
		else if($this->input->post('aksi')=='Simpan'){			
			$this->Perkara_sementara->get_urut_perkara($this->input->post('alur'));
			$nomor_sementara = $this->Perkara_sementara->get_urut_perkara($this->input->post('alur'))."_".$this->input->post('kategori_perkara')."_".date('Ymdhis');
			$data_simpan = array(
				'nomor_sementara' => $nomor_sementara,
				'alur_perkara_id' => $this->input->post('alur'),
				'tanggal_surat'	  => tgl_sql($this->input->post('tanggal')),
				'jenis_perkara_nama' => $this->input->post('jenis_perkara_nama'),
				'jenis_perkara_id'	 => $this->input->post('jenis'),
				'kategori_perkara'	 => $this->input->post('kategori_perkara'));
			$this->Abt_model->insert_tabel('abt_temp_data_perkara',$data_simpan,TRUE);
			redirect("abt/popup_perk_temp/$nomor_sementara");}

		if($nomor_sementara){
			$data = (array)$this->Abt_model->GetTabel('abt_temp_data_perkara','nomor_sementara',$nomor_sementara)[0];}
		else{
			$data = array(
				'id' => NULL,
				'nomor_sementara' => NULL,
				'alur_perkara_id' => NULL,
				'jenis_perkara_id' => NULL,
				'jenis_perkara_nama' => NULL,
				'kategori_perkara' => NULL,
				'tanggal_surat' => NULL);}
		if($nomor_sementara and $data_get=='no_sipp'){
			$data['data_sipp']   = $this->Perkara_sementara->get_nomor_sipp($data['id'],$data['alur_perkara_id'],$data['jenis_perkara_id']);
			$data['form_pihak']  = FALSE;
			$data['form_no_sipp']= TRUE;}
		else if($nomor_sementara and $data_get=='pihak'){
			$data['data_pihak']  = $this->Perkara_sementara->get_pihak_perkara($data['id']);
			$data['form_pihak']  = TRUE;
			$data['form_no_sipp']= FALSE;}
		else{
			$data['form_pihak']  = FALSE;
			$data['form_no_sipp']= FALSE;}
		$this->load->view('abt/popup_perk_temp',$data);
	}


	public function html_beranda($judul) {
		$dir  		  = $this->encrypt->decode($this->input->get('a'));
		$perkara_id	  = $this->input->get('c');
		$data_blangko = $this->Abt_model->grup_blangko($dir)[0];
		if($dir){
			$judul = $data_blangko['nama'];}
		if($perkara_id){
			$nomor_perkara = '<br>'.variabel('#0048#',$perkara_id).' - '.variabel('#0001#',$perkara_id);}
		else {
			$nomor_perkara = NULL;}
		$data = array(
		"dir" 			  => $dir,
		"judul" 		  => $judul,
		"data_blangko"	  => $data_blangko,
		"daftar_blangko"  => $this->Abt_model->daftar_menu(),
		"perkara_id"	  => $perkara_id,
		"nomor_perkara"	  => $nomor_perkara,
		"new_versi"	  	  => $this->Abt_model->get_info_new_versi(),
		"now_versi"	  	  => $this->config->item('app_version'));
		return $this->load->view("abt/beranda",$data,TRUE);
	}

	public function html_cari_perkara($judul) {
		$flash = $this->session->flashdata("data");
		if($flash){
			$dir		= $this->encrypt->decode($flash['a']);
			$file		= $this->encrypt->decode($flash['b']);
			$perkara_id	= $flash['c'];
			$perk_temp	= $flash['e'];
			$msg		= $flash['msg'];}
		else {
			$dir		= $this->encrypt->decode($this->input->post('a'));
			$file		= $this->encrypt->decode($this->input->post('b'));
			$perkara_id	= $this->input->post('c');
			$perk_temp	= $this->input->post('e');
			$msg   		= NULL;}

		if(empty($dir) or empty($file)){
			redirect('abt');}
		else{
			$validation_data = $this->Abt_model->hak_akses_menu($dir);
			$session_data = $this->session->userdata();
			$user  		  = strtoupper($session_data['group_name']);
			$nama_user    = $session_data['fullname'];}
		
		if($perkara_id){
			$nomor_perk	= variabel('#0001#',$perkara_id);}
		else{
			$nomor_perk	= NULL;}
		
		#top user
		if($this->Abt_model->user_grup_id($session_data['group_id'],$validation_data['user_top_id'])){
				$akses = TRUE;}

		#user perkara saja
		else if($user_grup_id = $validation_data['user_grup_id'] and $validation_data['user_cek']==3 and $perkara_id){
			if(($this->Abt_model->user_grup_id($session_data['group_id'],$user_grup_id)) and ($this->Abt_model->cek_user_perkara($session_data['userid'],$perkara_id))){
				$akses = TRUE;}
			else{
				$msg		= "<h5 style='color:red;font-weight:bold;text-align:center;margin:20px;'>User $nama_user<br>Tidak Ada Akses dengan Perkara Nomor $nomor_perk</h5>";}}
		
		#user tsb dan user perkara tanpa user grup
		else if($user_grup_id = $validation_data['user_grup_id'] and $validation_data['user_cek']==2 and $perkara_id){
			if(($this->Abt_model->user_grup_id($session_data['group_id'],$user_grup_id)) or ($this->Abt_model->cek_user_perkara($session_data['userid'],$perkara_id))){
				$akses = TRUE;}
			else{
				$msg		= "<h5 style='color:red;font-weight:bold;text-align:center;margin:20px;'>User $nama_user<br>Tidak Ada Akses dengan Perkara Nomor $nomor_perk</h5>";}}
		
		#user tsb dan user perkara berdasarkan user grup
		else if($user_grup_id = $validation_data['user_grup_id'] and $validation_data['user_cek']==1 and $perkara_id){
			if(($this->Abt_model->user_grup_id($session_data['group_id'],$user_grup_id)) and ($this->Abt_model->cek_user_perkara($session_data['userid'],$perkara_id))){
				$akses = TRUE;}
			else{
				$msg		= "<h5 style='color:red;font-weight:bold;text-align:center;margin:20px;'>User $nama_user<br>Tidak Ada Akses dengan Perkara Nomor $nomor_perk</h5>";}}
		
		#semua user tsb
		else if(($validation_data['user_grup_id']) and ($this->Abt_model->user_grup_id($session_data['group_id'],$validation_data['user_grup_id']))){
				$akses = TRUE;}
		
		#semua user
		else if(!$validation_data['user_grup_id']){
			$akses = TRUE;}				
		else {
			$msg	 = "<h3 style='color:red;font-weight:bold;text-align:center;margin:50px;'>USER $user<br>TIDAK ADA AKSES MENGGUNAKAN BLANGKO INI</h3>";
			$msg	.= "<meta http-equiv=refresh content='3;url=".base_url('abt')."'>";}


		if($validation_data['direktori']=='1_gugatan_permohonan'){
			$this->load->model('abt/Perkara_sementara');
			$perkara_temp		= TRUE;
			$dftr_perkara_temp 	= $this->Perkara_sementara->get_perkara_sementara();}
		else{
			$perkara_temp		= FALSE;
			$dftr_perkara_temp 	= NULL;}
		
		#CEK STATUS PERKARA
		if($akses and $perkara_id){
		$status_perkara = $this->Abt_model->status_perkara($perkara_id);
			if(($validation_data['proses_id_min'] <= $status_perkara->proses_terakhir_id) and ($status_perkara->proses_terakhir_id <= $validation_data['proses_id_max'])){
				$proses_akses = TRUE;}
			else{
				$proses_akses = FALSE;
				$msg = "<h5 style='color:red;font-weight:bold;text-align:center;margin:20px;'>NOMOR PERKARA $nomor_perk<br>TIDAK DAPAT MENGGUNAKAN BLANGKO INI</h5>";}
			if($referensi = $validation_data['perkara_id_referensi']){
				if(($validation_data['perkara_id_min'] <= $status_perkara->$referensi) and ($status_perkara->$referensi <= $validation_data['perkara_id_max'])){
					$status_akses = TRUE;}
				else{
					$status_akses = FALSE;
					$msg = "<h5 style='color:red;font-weight:bold;text-align:center;margin:20px;'>JENIS PERKARA ".strtoupper($status_perkara->jenis_perkara_nama)."<br>TIDAK DAPAT MENGGUNAKAN BLANGKO INI</h5>";}}
			else{
				$status_akses = TRUE;}
				
				
				
				

		if($status_akses and $proses_akses){redirect("abt/main/view?b=".$this->encrypt->encode($file)."&c=$perkara_id&a=".$this->encrypt->encode($dir));}}
		else if($akses and $perk_temp){redirect("abt/main/view?b=".$this->encrypt->encode($file)."&e=$perk_temp&a=".$this->encrypt->encode($dir));}
				
		$daftar_perkara	 = $this->Abt_model->daftar_perkara($session_data,$validation_data['proses_id_min'],$validation_data['proses_id_max'],$validation_data['perkara_id_min'],$validation_data['perkara_id_max'],$validation_data['perkara_id_referensi'],$validation_data['user_cek']);
		$ms_only		 = $this->Abt_model->identifikasi_menu(explode('/',$dir)[1],'ms_only','abt_menu_grup',TRUE);		
		$data = array(
			"judul" 			=> $judul,
			"dir" 				=> $dir,
			"msg" 				=> $msg,
			"file" 				=> $file,
			"ms_only" 			=> $ms_only,
			"perkara_temp"		=> $perkara_temp,
			"dftr_perkara_temp" => $dftr_perkara_temp,
			"daftar_perkara" 	=> $daftar_perkara,
			"KodePN" 			=> $this->Abt_model->GetKonfigurasiSipp('KodePN'));
		return $this->load->view("abt/cari_perkara",$data,TRUE);
	}	
		
	public function cari() {
		$dir	= $this->input->get('a');
		$file	= $this->input->get('b');
		$value1 = addslashes($this->input->post('nomor'));
		$value2 = addslashes($this->input->post('kode'));
		$value3 = addslashes($this->input->post('tahun'));
		$dat_value  = $this->Abt_model->get_perkara_id($value1.'/'.$value2.'/'.$value3);
		if($dat_value){
			$data = array(
				'msg'=> NULL,
				'e'	 => NULL,
				'a'  => $dir,
				'b'	 => $file,
				'c'	 => $dat_value);}
		else {
			$data = array(
				'msg'=> "<p style='color:red;font-weight:bold;text-align:center;'>NOMOR PERKARA TIDAK DITEMUKAN</p>",
				'e'	 => NULL,
				'a'  => $dir,
				'b'	 => $file,
				'c'	 => NULL);}
		$this->session->set_flashdata("data",$data);
		redirect("abt/main/cari");
	}

	public function html_variabel($judul) {
		if($this->session->userdata('group_id')>9){
			redirect("abt");}
		$value = addslashes($this->input->get('aksi'));
		if($value=='Tambah Variabel'){
			die();}
		$value = addslashes($this->input->get('cari'));
		$tautan_halaman 		= base_URL('abt/main/variabel');
		$item_perhalaman 		= $this->Abt_model->GetKonfigurasi('item_perhalaman');
		$data_pagination 		= $this->Abt_model->pagination($tautan_halaman,$this->Abt_model->get_variabel_id($value),$item_perhalaman,$value);
			$data['content'] 		= $data_pagination['data'];
			$data['no']				= $data_pagination['no'];
			$data['pagerContainer']	= $data_pagination['paging'];
			$data['judul']			= $judul;
			$data['value']			= $value;
		return $this->load->view("abt/variabel",$data,TRUE);
	}	
	
	public function html_about($judul) {
		$data = array(
			"judul" 	=> $judul,
			"new_versi"	=> $this->Abt_model->get_info_new_versi(),
			"now_versi" => $this->config->item('app_version')
			);
		return $this->load->view("abt/about",$data,TRUE);
	}	
	
	public function html_tanyajawab_template($judul) {
		if($hapus = $this->input->get('hapus')){
			$info = $this->Abt_model->DeleteTanyaJawabTemplate($hapus);}
		else if($jenis_kertas = $this->input->post('jenis_kertas')){
			$this->Abt_model->update_tabel('abt_config',array('name'=>'jenis_kertas'),array('value'=>$jenis_kertas));}
		else {
			$info = NULL;}	
		$data = array(
		"info" 	  => $info,
		"judul"   => $judul,
		"jenis_kertas" => $this->Abt_model->GetKonfigurasi('jenis_kertas'),
		"content" => $this->Abt_model->GetTanyaJawab()		
		);
		return $this->load->view("abt/tanyajawab",$data,TRUE);
	}
	
	public function tanyajawab_template_edit() {
		$aksi = $this->input->get('aksi');
		$kode = $this->input->get('kode');
		if ($aksi == 'simpan'){
			$data = $this->input->post('data');
			if($pesan = $this->Abt_model->SaveTanyajawabTemplate($kode,$data)){
				die('ERROR : '.$pesan);}
			else {
				die('Template Tanya Jawab Disimpan');}}
		$link_simpan = base_url('abt/tanyajawab_template_edit')."?aksi=simpan&kode=$kode";	
			
		$data = array(
		"kode" => $kode,
		"link_simpan" => $link_simpan,
		"templates" => NULL,
		"judul" => "SIPP Plus - Template Tanya Jawab",
		"keterangan" => "Edit Template Tanya Jawab : <b>Kode $kode</b>",
		"link_parent" => base_URL().'abt/main/tanyajawab_template',
		"content" => $this->Abt_model->GetTanyaJawabTemplate($kode)
		);
	$this->load->view('abt/load_tanyajawab',$data);
	}
		
	public function tanyajawab_perkara_edit() {
		$enc_dir 		= $this->input->get('a');
		$enc_file_name	= $this->input->get('b');
		$perkara_id 	= $this->input->get('c');
		$data_sidang 	= $this->input->get('d');
		$no_var			= $this->input->get('no_var');

		$sidang_id 	 = $this->Abt_model->data_sidang($perkara_id,$data_sidang)['0']->id;
		$data_variabel = $this->Abt_model->get_detail_variabel($no_var);
		$pihak		 = $data_variabel['referensi'];
		$name_var	 = $data_variabel['nama'];
		$nama_var	 = variabel($name_var,$perkara_id);
		$nama_pihak	 = variabel("#$pihak#",$perkara_id);
		$nomor_perk	 = variabel('#0001#',$perkara_id);
		
		$template	 = $this->input->post('load_template');
		if($template){
			$content = $this->Abt_model->replace_array_template($this->Abt_model->GetTanyaJawabTemplate($template,$perkara_id),$perkara_id);
		} else {
			$content = $this->Abt_model->GetKeteranganPihak($perkara_id,$sidang_id,$nama_pihak,$name_var);}
		
		if ($this->input->get('aksi') == 'simpan'){
			$data = $this->input->post('data');
			if($pesan = $this->Abt_model->SaveKeteranganPihak($perkara_id,$sidang_id,$nama_pihak,$data,$name_var)){
				die($pesan);}
			else {
				die('Tanya Jawab Disimpan');}}
				
		$link_simpan = base_url('abt/tanyajawab_perkara_edit')."?aksi=simpan&no_var=$no_var&a=$enc_dir&b=$enc_file_name&c=$perkara_id&d=$data_sidang";
		
		$data = array(
		"kode" => NULL,
		"link_simpan" => $link_simpan,
		"templates" => $this->Abt_model->GetTanyaJawab(NULL,$perkara_id,$nama_pihak),
		"judul" => "SIPP Plus - Tanya Jawab ".variabel('#0001#',$perkara_id),
		"keterangan" => "<b><big>$nomor_perk</big></b> - $nama_var : <b>$nama_pihak</b>",
		"link_parent" => base_URL('abt/main/view')."?a=$enc_dir&b=$enc_file_name&c=$perkara_id&d=$data_sidang#$no_var",
		"content" => $content
		);
	$this->load->view('abt/load_tanyajawab',$data);
	}	
	
	public function tanyajawab_form() {
		$id   = $this->input->get('id');
		$aksi = $this->input->post('aksi');
		if ($aksi == 'Simpan'){
			$data = array(
				'id' 	=> $this->input->post('id'),
				'jenis_perkara_id'  => $this->input->post('jenis_perkara_id'),
				'kode'  => $this->input->post('kode'),
				'nama'  => $this->input->post('nama'));
			echo $this->Abt_model->SaveTanyaJawab($data);}
		else if ($aksi == 'Hapus'){
			$info = $this->Abt_model->DeleteTanyaJawab($this->input->post('id'));
			die($info);}
		if($id){
			$content = $this->Abt_model->GetTanyaJawab($id)[0];
		} else {
			$content = (object) array(
				"id" 	=> $this->Abt_model->GetLastId('abt_tanyajawab_id','id'),
				"kode" 	=> NULL,
				"nama" 	=> NULL,
				"jenis_perkara_id" 	=> NULL				
				);}
				
		$data = array(
		"content" 	=> $content,
		"jenis_perk" => $this->Abt_model->GetNamaPerkara()		
		);
		$this->load->view('abt/popup_tanyajawab',$data);
		}	

	public function html_view($judul) {
		$dir		= $this->encrypt->decode($this->input->get('a'));
		$file		= $this->encrypt->decode($this->input->get('b'));
		$perkara_id	= $this->input->get('c');
		$perk_temp  = $this->input->get('e');
		if($perkara_id){$view = TRUE;}
		else if($perk_temp){$view = TRUE;}
		else{$view = FALSE;}
		$perkara_no	= variabel('#0001#',$perkara_id);
		if(empty($dir) or empty($file) or !$view){
			redirect("abt");}
		$content 	= $this->Abt_model->show_variabel_rtf($dir,$file,$perkara_id);
		$validation = $this->Abt_model->hak_akses_menu($dir);
		$cek_sidang = $this->input->get('d');	
		if($validation['user_validator']){
			$cek_valid['cek'] 	   = TRUE;
			$cek_valid['data']	   = $this->Abt_model->cek_status_bas($perkara_id,$cek_sidang);
			$cek_valid['validator']= $this->Abt_model->cek_hakim_validator_bas($perkara_id);
			}
		else{
			$cek_valid['cek'] = FALSE;}
		$data = array(
		"judul" 	 => $judul.' '.$file.' - '.$perkara_no,
		"dir_blangko"=> $validation['dir_blangko'],
		"validation" => $validation,
		"dir" 		 => $dir,
		"file" 		 => $file,
		"perkara_id" => $perkara_id,
		"perkara_no" => $perkara_no,
		"enc_dir" 	 => $this->input->get('a'),
		"enc_file"	 => $this->input->get('b'),
		"perk_temp"  => $perk_temp,
		"cek_sidang" => $cek_sidang,
		"cek_valid"	 => $cek_valid,
		"checked" 	 => $this->Abt_model->GetKonfigurasi('validasi_data_bas'),
		"content"	 => $content
		);
		return $this->load->view('abt/view', $data,TRUE);
	}
		
	public function html_validasi_bas($judul) {
		if($this->input->post('aksi')=='ubah_validasi'){
			$this->Abt_model->update_tabel('abt_config',array('name'=>'validasi_data_bas'),array('value'=>$this->input->post('value')));}
		else if($this->input->get('aksi')=='tambah_data' and $this->input->post('perkara_id')){
			$this->Abt_model->insert_tabel('abt_data_validasi_bas',$this->input->post(),TRUE);}
		else if($this->input->get('aksi')=='valid_data' and $this->input->post('perkara_id')){
			$session_data = $this->session->userdata();
			$this->Abt_model->update_tabel('abt_data_validasi_bas',$this->input->post(),array('status'=>1,'validasi_oleh'=>"$session_data[fullname]<br>$session_data[group_name]"),'validasi_tanggal');}
		if($this->input->get('aksi')=='hapus_data' and $this->input->post('perkara_id')){
			$this->Abt_model->delete_tabel('abt_data_validasi_bas',$this->input->post());}
		$data = array(
		"check" => $this->Abt_model->GetKonfigurasi('validasi_data_bas'),
		"data"	=> $this->Abt_model->daftar_perkara_validasi_bas(0),
		"judul" => $judul
		);
		return $this->load->view("abt/validasi_bas",$data,TRUE);
	}	
		
	public function html_qrcode($judul) {
		$domain 	= FALSE;
		$sipp_web	= $this->encrypt->decode($this->Abt_model->GetKonfigurasi('sipp_web'));
		if (filter_var($sipp_web, FILTER_VALIDATE_URL)){$sipp_web = $sipp_web;}else{$sipp_web = NULL;}		
		if($sipp_web){
			$domain = TRUE;}
		else if($this->input->post('sipp_web')){
			$sipp_web = $this->input->post('sipp_web');}
		else{
			$sipp_web = 'http://sipp.'.$this->input->post('domain').'.go.id';}
		
		if($noperk = $this->input->post('nomor_perkara')){
		   $qrcode = $this->Abt_model->qrcode($noperk,TRUE);}
		else {
		   $qrcode = NULL;}		
		   $data = array(
			"judul" 		  => $judul,
			"sipp_web"		  => $sipp_web,
			"domain"	 	  => $domain,
			"noperk"		  => $noperk,
			"qrcode"		  => $qrcode,
			"generate" 		  => TRUE,
			"validasi_domain" => FALSE);
		return $this->load->view("abt/qrcode",$data,TRUE);
	}	
		
	public function html_qrcode_setting($judul) {
		if($this->session->userdata('group_id')>9){
			redirect("abt");}
		$domain 	= FALSE;
		$sipp_web	= $this->encrypt->decode($this->Abt_model->GetKonfigurasi('sipp_web'));
		if (filter_var($sipp_web, FILTER_VALIDATE_URL)){$sipp_web = $sipp_web;}else{$sipp_web = NULL;}
		if($sipp_web){
			$domain = TRUE;}
		else if($this->input->post('sipp_web')){
			$sipp_web = $this->input->post('sipp_web');}
		else{
			$sipp_web = 'http://sipp.'.$this->input->post('domain').'.go.id';}
		
		if($this->input->post('aksi')=='Validasi'){
			$validasi_domain = $this->Abt_model->get_http_response_code($sipp_web);}
		else if($this->input->post('aksi')=='Simpan'){
			$validasi_domain = TRUE;
			$this->Abt_model->update_tabel('abt_config',array('name'=>'sipp_web'),array('value'=>$this->encrypt->encode($sipp_web)));
			$domain = TRUE;}
		else {
			$validasi_domain = FALSE;}			
		if($noperk = $this->input->post('nomor_perkara')){
			$qrcode = $this->Abt_model->qrcode($noperk,TRUE);}
		else {
			$qrcode = NULL;}		
		$data = array(
		"judul" 		  => $judul,
		"sipp_web"		  => $sipp_web,
		"domain"	 	  => $domain,
		"noperk"		  => $noperk,
		"qrcode"		  => $qrcode,
		"generate" 		  => FALSE,
		"validasi_domain" => $validasi_domain
		);
		return $this->load->view("abt/qrcode",$data,TRUE);
	}	

	public function preview() {
		$dir		= $this->encrypt->decode($this->input->get('a'));
		$file		= $this->encrypt->decode($this->input->get('b'));
		$perkara_id	= $this->input->get('c');
		$perk_temp	= $this->input->get('e');
		
		
		if($perkara_id){$view = TRUE;}
			else if($perk_temp){$view = TRUE;}
			else{$view = FALSE;}
		$perkara_no	= variabel('#0001#',$perkara_id);
		if(empty($dir) or empty($file) or !$view){
			redirect("abt");}
		
	
		$data = array(
		"dir" 		=> $dir,
		"file_name"	=> $file,
		"perkara_id" => $perkara_id
		);
		$this->load->view('abt/preview', $data);
	}

	public function html_backup($judul) {
		if($this->session->userdata('group_id')>9){
			redirect("abt");}

		$no_awal	= $this->input->post('no_awal');
		$no_akhir	= $this->input->post('no_akhir');
		$kode		= $this->input->post('kode');
		$tahun		= $this->input->post('tahun');
		$this->load->model('abt/Generate_backup');
		
		if(empty($tahun)){
			$data['judul'] 		= $judul;
			$data['nama_db'] 	= $this->Generate_backup->GetDbName();			
		return	$this->load->view("abt/backup_s",$data,TRUE);	
		} else {
			
		$data['data'] 		= $this->Generate_backup->sql_query($no_awal,$no_akhir,$kode,$tahun);
		$data['nama_file']	= "backup_".$no_awal."-".$no_akhir."_".$kode."_".$tahun.".sql";
		$this->load->view('abt/backup',$data);}
	}
	
	public function html_anonim($judul) {
		$this->load->model('abt/Anonimisasi');
		if($perkara_id = $this->input->post('perkara_id') and $perkara_no = $this->input->post('perkara_no')){
			$data_pihak	   = $this->Anonimisasi->info_perkara_pihak($perkara_id);
			$proses_anonim = $this->Anonimisasi->upload_putusan($perkara_no,$data_pihak);
			if($proses_anonim['convert']){
				$color		= $proses_anonim['color'];
				$msg		= $proses_anonim['msg'];
				$this->load->view('abt/anonim_do',$proses_anonim['data']);}
			else{
				$color		= $proses_anonim['color'];
				$msg		= $proses_anonim['msg'];}
			$nomor_perk = $perkara_no;}
		else if($perkara_id = $this->input->post('perkara_id')){
			$data_pihak = $this->Anonimisasi->info_perkara_pihak($perkara_id);
			$color		= '#00bcd4';
			$msg		= 'Pastikan Identitas Pihak sesuai dengan File Putusan yang ingin dianonim.';
			$nomor_perk = $data_pihak[0]['nomor_perkara'];}
		else{
			$data_pihak = NULL;
			$color		= NULL;
			$msg		= NULL;
			$nomor_perk = NULL;}
		$data = array(
		"judul" => $judul,
		"msg"   => $msg,
		"color" => $color,
		"perkara_no" => $nomor_perk,
		"perkara_id" => $perkara_id,
		"data_pihak" => $data_pihak
		);
		return	$this->load->view("abt/anonim",$data,TRUE);
	}

	public function html_dirput_perkara($judul) {
		$this->load->model('abt/Dirput');
		if($this->input->post('aksi')=='ubah_nama_pa'){
			$this->Abt_model->update_tabel('abt_config',array('name'=>'nama_pengadilan'),array('value'=>$this->input->post('nama_pengadilan')));}
		elseif($this->input->get('aksi')=='KOSONGKAN' and $this->input->get('year')){
			$this->Dirput->kosongkan_dirput($this->input->get('year'));}
		$data = array(
			"nama_pengadilan" => $this->Abt_model->GetKonfigurasi('nama_pengadilan'),
			"judul" 	=> $judul,
			);	
		return $this->load->view('abt/daftar_dirput',$data,true);	
	}	
	
	public function get_nomor_perkara() {
		$this->load->model('abt/Anonimisasi');
		$string	= $this->input->post('noperk',TRUE);	
		$data	=  array();
        foreach ($this->Anonimisasi->get_nomor_perkara($string,'20') as $key => $d) {
			$data[$key]['perkara_id'] = $d->perkara_id;
			$data[$key]['value'] = $d->nomor_perkara;
			$data[$key]['label'] = $d->nomor_perkara." : ".$d->jenis_perkara_nama;}		
		echo json_encode($data);
	}

	public function get_nomor_perkara_putus() {
		$this->load->model('abt/Anonimisasi');
		$string	= $this->input->post('noperk',TRUE);	
		$data	=  array();
        foreach ($this->Anonimisasi->get_nomor_perkara_putus($string,'20') as $key => $d) {
			$data[$key]['perkara_id'] = $d->perkara_id;
			$data[$key]['value'] = $d->nomor_perkara;
			$data[$key]['label'] = $d->nomor_perkara." : ".$d->jenis_perkara_nama." : ".ucwords(strtolower($d->status_putusan));}		
		echo json_encode($data);
	}
	
	public function get_jenis_perkara() {
		$this->load->model('abt/Perkara_sementara');
		$string	= $this->input->post('jnsperk',TRUE);	
		$data	=  array();
        foreach ($this->Perkara_sementara->get_jenis_perkara($string,'10') as $key => $d) {
			$data[$key]['alur']	 = $d->alur_perkara_id;
			$data[$key]['kode']	 = $d->kode;
			$data[$key]['jenis'] = $d->jenis_perkara_id;
			$data[$key]['value'] = $d->jns_perk;
			$data[$key]['label'] = ucwords(strtolower($d->ket))." (".$d->kode.") : ".$d->jns_perk;}		
		echo json_encode($data);
	}
		
	public function get_referensi_pihak() {
		$this->load->model('abt/Perkara_sementara');
		$string	= $this->input->post('string',TRUE);		
		$data	=  array();
        foreach ($this->Perkara_sementara->get_data_pihak(NULL,NULL,$string) as $key => $d) {
			if($d->tempat_lahir and $d->nomor_indentitas){$label = $d->nama.' | NIK: '.$d->nomor_indentitas.' | TTL: '.$d->tempat_lahir.', '.$d->tanggal_lahir;}
			else {$label = $d->nama.' | Alamat: '.$d->alamat;}
			$data[$key]['pihak_id'] = $d->pihak_id;
			$data[$key]['value'] = $d->nama;
			$data[$key]['label'] = $label;}
		echo json_encode($data);
	}
	
	public function logout(){
		$this->session->sess_destroy();
		redirect('login');
	}

}
