<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Redirect_view extends CI_Controller {
	public function __construct() {
        parent::__construct();
        $this->load->model('default/validated', 'val');
		$this->val->setup_language();
    }

    function redir_antrian(){
		$this->nativesession->set_flash_session('url_requested', current_url());
		$this->setParams();
		redirect('antrian');
	}

    function redir_arsip_list(){
		$this->setParams('arsip');
		$this->keyword='';$this->enc='';
		$this->nativesession->set('main_url_requested', current_url());
		if ($this->keyword!=''){
			$this->nativesession->set_flash_session('url_requested', base_url(uri_string().'/'.$this->keyword.'/'.$this->enc));
		}else{
			$this->nativesession->set_flash_session('url_requested', base_url(uri_string()));	
		}
		redirect('arsip');
	}

	function redir_arsip_detail(){
		$this->nativesession->set_flash_session('url_requested', current_url());
		$this->setParams();
		$this->nativesession->set_flash_session('enc', $this->uri->segment(2));
		redirect('arsip_detail');
	}
	function redir_perkara_list(){
		$this->keyword='';$this->enc='';
		$this->setParams();
		if ($this->keyword!=''){
			//$this->keyword = $this->encrypt->decode(base64_decode($this->keyword));
			$this->nativesession->set_flash_session('url_requested', base_url(uri_string().'/'.$this->keyword.'/'.$this->enc));
		}else{
			$this->nativesession->set_flash_session('url_requested', base_url(uri_string()));	
		} 
		redirect('main');
	}
	#07-10-2015
	function redir_perkara_list_tun(){
		$this->keyword='';$this->enc='';
		$this->setParams();
		if ($this->keyword!=''){
			$this->nativesession->set_flash_session('url_requested', base_url(uri_string().'/'.$this->keyword.'/'.$this->enc));
		}else{
			$this->nativesession->set_flash_session('url_requested', base_url(uri_string()));	
		}
		redirect('main');
	}

	#09-10-2015
	function redir_pemeriksaan_persiapan_tab(){
		$this->setParams();
		$this->nativesession->set_flash_session('enc', $this->uri->segment(2));
		$this->nativesession->set_flash_session('perkara_id', $this->encrypt->decode(base64_decode($this->uri->segment(2))));
		redirect('tab_pemeriksaan_persiapan');
	}

	
		##13022018
	function redir_perbaikan_gugatan_tab(){
		$this->setParams();
		$this->nativesession->set_flash_session('enc', $this->uri->segment(2));
		$this->nativesession->set_flash_session('perkara_id', $this->encrypt->decode(base64_decode($this->uri->segment(2))));
		redirect('tab_perbaikan_gugatan');
	}
		
	##roby###########
	function redir_perkara_task_list(){
		$keyword =$this->input->post('search',true);
		$this->setParams();
		if ($this->keyword!=''){
			$this->nativesession->set_flash_session('url_requested', base_url(uri_string().'/'.$this->keyword.'/'.$this->enc));
		}else{
			$this->nativesession->set_flash_session('url_requested', base_url(uri_string()));	
		}
		redirect('perkara_task_list');
	}

	function redir_perkara_tab_dashboard(){
		
		$this->nativesession->set('main_url_requested', current_url());
		$this->setParams();
		redirect('perkara_tab_dashboard_list');
	}

	function redir_perkara_tab_status(){
		$this->nativesession->set_flash_session('url_requested', current_url());
		$this->setParams();
		redirect('perkara_tab_status_list');		
	}

	function redir_perkara_tab_penahanan(){
		$this->nativesession->set_flash_session('main_url_penahanan', current_url());
		$this->setParams();
		redirect('perkara_tab_status_penahanan_list');
	}

	function redir_perkara_tab_jurnal_keuangan(){
		$this->nativesession->set_flash_session('url_requested', current_url());
		$this->setParams();
		redirect('perkara_tab_jurnal_keuangan_list');
	}
	##end roby#####

	function redir_perkara_list_banding(){
		$this->setParams('banding_list');
		$this->nativesession->set('main_url_requested', current_url());
		redirect('banding');
	}

	function redir_perkara_list_kasasi(){
		$this->setParams();
		$this->nativesession->set('main_url_requested', current_url());
		redirect('kasasi');
	}

	function redir_perkara_list_pk(){
		$this->setParams();
		$this->nativesession->set('main_url_requested', current_url());
		redirect('pk');
	}

	function redir_perkara_list_grasi(){
		$this->setParams();
		$this->nativesession->set('main_url_requested', current_url());
		redirect('grasi');
	}

	function redir_perkara_list_eksekusi(){
		$this->keyword='';$this->enc='';
		$this->setParams('eksekusi_list');
		if ($this->keyword!=''){
			$this->nativesession->set_flash_session('url_requested', base_url(uri_string().'/'.$this->keyword.'/'.$this->enc));
		}else{
			$this->nativesession->set_flash_session('url_requested', base_url(uri_string()));	
		}
		redirect('eksekusi');
	}

	function redir_audittrail(){
		$this->setParams();
		$this->nativesession->set('main_url_requested', current_url());
		redirect('audittrail_c');
	}

	function redir_saldo_awal(){
		$this->setParams();
		$this->nativesession->set('main_url_requested', current_url());
		redirect('saldo_awal');
	}

	function redir_hakim_pn(){
		$this->setParams();
		$this->nativesession->set('main_url_requested', current_url());
		redirect('hakim_pn');
	}

	###testing dev
		function redir_testing_dev(){
		$this->setParams();
		$this->nativesession->set('main_url_requested', current_url());
		redirect('testing_dev');
	}
	###

	function redir_hakim_pt(){
		$this->setParams();
		$this->nativesession->set('main_url_requested', current_url());
		redirect('hakim_pt');
	}

	function redir_hakim_ma(){
		$this->setParams();
		$this->nativesession->set('main_url_requested', current_url());
		redirect('hakim_ma');
	}

	function redir_panitera_pn(){
		$this->setParams();
		$this->nativesession->set('main_url_requested', current_url());
		redirect('panitera_pn');
	}

	function redir_panitera_pt(){
		$this->setParams();
		$this->nativesession->set('main_url_requested', current_url());
		redirect('panitera_pt');
	}

	function redir_panitera_ma(){
		$this->setParams();
		$this->nativesession->set('main_url_requested', current_url());
		redirect('panitera_ma');
	}

	function redir_jurusita(){
		$this->setParams();
		$this->nativesession->set('main_url_requested', current_url());
		redirect('jurusita');
	}

	function redir_mediator(){
		$this->setParams();
		$this->nativesession->set('main_url_requested', current_url());
		redirect('mediator');
	}
	function redir_ruang_sidang(){
		$this->setParams();
		$this->nativesession->set('main_url_requested', current_url());
		redirect('ruang_sidang');
	}
	function redir_template_amar(){
		$this->setParams();
		$this->nativesession->set('main_url_requested', current_url());
		redirect('template_amar');
	}
	function redir_template_keterangan_saksi(){
		$this->setParams();
		$this->nativesession->set('main_url_requested', current_url());
		redirect('template_keterangan_saksi');
	}
	#Catur
	function redir_ref_biaya_perkara(){
	 	$this->setParams();
	 	$this->nativesession->set('main_url_requested', current_url());
		redirect('ref_biaya_perkara_list');
	}

	function redir_barang_bukti_list(){
		$this->setParams();
		$this->nativesession->set('main_url_requested', current_url());
		redirect('perkara_list_barang_bukti');
	} 
	function redir_perkara_tab_barang_bukti(){
		$this->setParams();
		redirect('tab_barang_bukti_c');
	}
	#End Catur

	function redir_perkara_tab_grasi(){
		$this->setParams();
		redirect('perkara_grasi/show_data_grasi_tab');
	}
	

	function redir_hari_libur(){
		$this->setParams();
		$this->nativesession->set('main_url_requested', current_url());
		redirect('hari_libur');
	}

	function redir_pesan_keluar(){
		$this->setParams();
		$this->nativesession->set('main_url_requested', current_url());
		redirect('pesan_keluar');
	}

	function redir_pesan_masuk(){
		$this->setParams();
		$this->nativesession->set('main_url_requested', current_url());
		redirect('pesan_masuk');
	}

	function redir_reminder_perkara(){
		$this->setParams();
		$this->nativesession->set('main_url_requested', current_url());
		redirect('reminder');
	}
    function jadwal_sidang_list(){
		$this->setParams('jadwal_sidang_list');
		$this->nativesession->set('main_url_requested', current_url());
		redirect('sidang_list');
	}
	function redir_perkara_penyitaan_list(){
		$this->setParams();
		$this->nativesession->set('main_url_requested', current_url());
		redirect('managePenyitaan');
	}
    #puji
	function redir_tab_biaya_perkara(){
		$this->setParams();
		#$this->nativesession->set('main_url_requested', current_url());
		redirect('tab_biaya_perkara_c');
	}
	function redir_perkara_penyegelan_list(){
		$this->setParams();
		$this->nativesession->set('main_url_requested', current_url());
		redirect('managePenyegelan');
	}
	
	function redir_perkara_rehabilitasi_list(){
		$this->setParams();
		$this->nativesession->set('main_url_requested', current_url());
		redirect('manageRehabilitasi');
	}
	
	function redir_perkara_action_paulina(){
		$this->setParams();
		$this->nativesession->set('main_url_requested', current_url());
		redirect('manageActioPauliana');
	}

	function redir_perkara_harta_pailit(){
		$this->setParams();
		$this->nativesession->set('main_url_requested', current_url());
		redirect('manageHartaPailit');
	}

	function redir_perkara_banding_pidana(){
		$this->setParams();
		redirect('add_perdata_banding');
	}

	function redir_perkara_list_eksekusi_ht(){
		$this->keyword='';$this->enc='';
		$this->setParams('eksekusi_list');
		if ($this->keyword!=''){
			$this->nativesession->set('main_url_requested', base_url(uri_string().'/'.$this->keyword.'/'.$this->enc));
		}else{
			$this->nativesession->set('main_url_requested', base_url(uri_string()));
		}
		
		redirect('eksekusi_ht');
	}


//atria
	function redir_penetapan(){
		$this->setParams();
		$this->nativesession->set_flash_session('enc', $this->uri->segment(2));
		$this->nativesession->set_flash_session('perkara_id', $this->encrypt->decode(base64_decode($this->uri->segment(2))));
		redirect('tab_penetapan_c');
	}

	function redir_diversi(){
		$this->setParams();
		$this->nativesession->set_flash_session('enc', $this->uri->segment(2));
		$this->nativesession->set_flash_session('perkara_id', $this->encrypt->decode(base64_decode($this->uri->segment(2))));
		redirect('tab_diversi_c');
	}

	function redir_verzet(){
		$this->setParams();
		$this->nativesession->set_flash_session('enc', $this->uri->segment(2));
		$this->nativesession->set_flash_session('perkara_id', $this->encrypt->decode(base64_decode($this->uri->segment(2))));
		redirect('tab_verzet_c');
	}

	function redir_ikrar(){
		$this->setParams();
		$this->nativesession->set_flash_session('enc', $this->uri->segment(2));
		$this->nativesession->set_flash_session('perkara_id', $this->encrypt->decode(base64_decode($this->uri->segment(2))));
		redirect('tab_ikrar_talak_c');
	}

	function redir_akta_cerai(){
		$this->setParams();
		$this->nativesession->set_flash_session('enc', $this->uri->segment(2));
		$this->nativesession->set_flash_session('perkara_id', $this->encrypt->decode(base64_decode($this->uri->segment(2))));
		redirect('tab_ikrar_akta_cerai_c');
	}

	#SCC
	function redir_keberatan(){
		$this->setParams();
		$this->nativesession->set_flash_session('enc', $this->uri->segment(2));
		$this->nativesession->set_flash_session('perkara_id', $this->encrypt->decode(base64_decode($this->uri->segment(2))));
		redirect('tab_keberatan_c');
	}

	function redir_penahanan_list(){
		$this->setParams();
		$this->nativesession->set('main_url_requested', current_url());
		$this->nativesession->set('main_url_penahanan', current_url());
		redirect('penahanan');
	}
	
	function redir_tampil_detil_penahanan(){
		$this->nativesession->set_flash_session('url_requested', current_url());
		$this->setParams();
		$this->nativesession->set_flash_session('enc_terdakwa_id', $this->uri->segment(2));
		redirect('penahanan_detail');
	}

	function redir_tampil_detil_penahanan_dataumum(){
		$this->setParams();
		$this->nativesession->set_flash_session('enc_terdakwa_id', $this->uri->segment(2));
		//$this->nativesession->set_flash_session('enc', $this->uri->segment(3));
		redirect('penahanan_detail');
	}

	function redir_add_penahanan(){
		$history= $this->nativesession->get_flash_session('url_requested');
		$this->setParams();
		$this->nativesession->set_flash_session('url_requested1', $history);
		redirect('addPenahanan_c');
	}

	//endofatria

	//adityo
	function redir_saksi(){
		$this->setParams();
		$this->nativesession->set_flash_session('enc', $this->uri->segment(2));
		redirect('tab_saksi_c');
	}
	//endofadityo

	//catur

	function redir_list_delegasi(){
		$this->setParams();
		$this->nativesession->set('url_requested', current_url());
		redirect('perkara_list_delegasi');
	}

	function manage_users_list() {
		$this->setParams();
		redirect('users_list');
	}

	//diversi
	function redir_list_anak_korban(){
		$this->setParams();
		$this->nativesession->set('url_requested', current_url());
		redirect('manage_register_anak_korban_saksi');
	}

	function redir_list_anak_blm_12tahun(){
		$this->setParams();
		$this->nativesession->set('url_requested', current_url());
		redirect('manage_register_anak_blm_12tahun');
	}

	function redir_register_diversi_list(){
		$this->setParams();
		$this->nativesession->set('url_requested', current_url());
		redirect('manage_register_diversi');
	}


	//end diversi

	function redir_user_online(){
		$this->setParams();
		$this->nativesession->set('main_url_requested', current_url());
		redirect('user_on');
	}

	function setParams($form=''){
		$segment = $this->uri->segment_array();
		$this->nativesession->set_flash_session('security', TRUE);
		$this->nativesession->set_flash_session('segment', $segment);
		$this->nativesession->set_flash_session('function', $this->uri->segment(2));
		$this->nativesession->set_flash_session('perkara_id', $this->encrypt->decode(base64_decode($this->uri->segment(2))));
		
		if($this->uri->segment(2)=='sort'){
			$this->nativesession->set_flash_session('col', $this->uri->segment(3));
			$this->nativesession->set_flash_session('enc', $this->uri->segment(4));
			$keyword = $this->encrypt->decode(base64_decode(rawurldecode($this->uri->segment(5))));
			$this->nativesession->set_flash_session('keyword', $keyword);
		}elseif($this->uri->segment(2)=='type'){
			$this->nativesession->set_flash_session('enc', $this->uri->segment(3));
		}elseif($this->uri->segment(2)=='page'){
			$this->nativesession->set_flash_session('page', $this->uri->segment(3));
			$this->nativesession->set_flash_session('enc', $this->uri->segment(4));
			$tmp = explode("=", $this->uri->segment(5));
			if($tmp>0 AND $tmp[0]=="col"){
				$this->nativesession->set_flash_session('col', $tmp[1]);
				$this->nativesession->set_flash_session('keyword','');
			}else{
				$keyword = $this->encrypt->decode(base64_decode(rawurldecode($this->uri->segment(5))));
				$this->nativesession->set_flash_session('keyword', $keyword);
				//$this->nativesession->set_flash_session('keyword', rawurldecode($this->uri->segment(5)));
				$this->nativesession->set_flash_session('col', $this->uri->segment(6));
			}
		}elseif($this->uri->segment(2)=='search'){
			if($this->input->post('search')){
				$this->nativesession->set_flash_session('keyword', $this->input->post('search'));
				$this->keyword = $this->input->post('search');
				$this->keyword = base64_encode($this->encrypt->encode($this->keyword));
			}else{
				$keyword = $this->uri->segment(3);
				if(empty($keyword))
					$this->session->set_userdata('asc_desc','DESC');
				$keyword = $this->encrypt->decode(base64_decode(rawurldecode($this->uri->segment(3))));
				$this->nativesession->set_flash_session('keyword', $keyword);
				$this->keyword = ($this->uri->segment(3));
				//$this->
			}
			if($this->input->post('enc')){
				$this->nativesession->set_flash_session('enc', $this->input->post('enc'));
				$this->enc=$this->input->post('enc');
			}else{
				$this->nativesession->set_flash_session('enc', $this->uri->segment(4));
				$this->enc=$this->uri->segment(4);
			}
			$this->nativesession->set_flash_session('page', '');
		}elseif($this->uri->segment(2)=='search_detail'){
			if($this->input->post('enc')){
				$this->nativesession->set_flash_session('enc', $this->input->post('enc'));
			}else{
				$this->nativesession->set_flash_session('enc', $this->uri->segment(4));
			}
			$this->nativesession->set_flash_session('page', '');
			if ($form!='arsip'){
				$this->parsePostValue($form);	
			}else{
				$this->parsePostArsip();	
			}
			
		}else{
			$this->nativesession->set_flash_session('enc', $this->uri->segment(3));
			$this->nativesession->set_flash_session('encdiversi', $this->uri->segment(4));
		}
	}

	function parsePostArsip(){
		$where='';

		if($this->input->post('from_tgl_masuk_berkas',TRUE)){
			if(!empty($where)){
					$where .= ' AND ';
			}
			$where .= $this->parseWhereOnTanggal($where,'from_tgl_masuk_berkas','to_tgl_masuk_berkas','tgl_masuk_berkas_select','tanggal_masuk_arsip');
		}
		if($this->input->post('nomor_perkara',TRUE) != ''){
			if(!empty($where)){
					$where .= ' AND ';
			}
			$where .= " (nomor_perkara like '%".$this->input->post('nomor_perkara',TRUE)."%') ";
		}
		if($this->input->post('nomor_arsip',TRUE) != ''){
			if(!empty($where)){
					$where .= ' AND ';
			}
			$where .= " (nomor_arsip like '%".$this->input->post('nomor_arsip',TRUE)."%') ";
		}
		if($this->input->post('no_ruang',TRUE) != ''){
			if(!empty($where)){
					$where .= ' AND ';
			}
			$where .= " (no_ruang like '%".$this->input->post('no_ruang',TRUE)."%') ";
		}
		if($this->input->post('no_lemari',TRUE) != ''){
			if(!empty($where)){
					$where .= ' AND ';
			}
			$where .= " (no_lemari like '%".$this->input->post('no_lemari',TRUE)."%') ";
		}
		if($this->input->post('no_rak',TRUE) != ''){
			if(!empty($where)){
					$where .= ' AND ';
			}
			$where .= " (no_rak like '%".$this->input->post('no_rak',TRUE)."%') ";
		}
		if($this->input->post('no_berkas',TRUE) != ''){
			if(!empty($where)){
					$where .= ' AND ';
			}
			$where .= " (no_berkas like '%".$this->input->post('no_berkas',TRUE)."%') ";
		}

		$this->nativesession->set_flash_session('where', $where);
	}

	function parsePostValue($form=''){
		$where = '';

		if($this->input->post('id_alur_perkara',TRUE) OR $this->input->post('enc',TRUE)){
			$enc = '';
			if ($this->input->post('enc',TRUE)!=''){
				$enc = $this->input->post('enc',TRUE);
				$idalurperkara = $this->encrypt->decode(base64_decode($enc));
			}elseif($this->input->post('id_alur_perkara',TRUE)){
				if ($this->input->post('id_alur_perkara',TRUE)!=''){
					$enc = $this->input->post('enc',TRUE);
					$idalurperkara = $this->encrypt->decode(base64_decode($enc));
				}
			}
			if(!empty($enc)){
				$where .= ' (alur_perkara_id IN ('.$idalurperkara.')) ';
			}
		}

		if($form=='banding_list'){
			if($this->input->post('no_perkara',TRUE)){
				if(!empty($where) AND $this->input->post('no_perkara',TRUE)!=''){
					$where .= ' AND ';
				}
				if($this->input->post('no_perkara_select',TRUE)==8){
					$where .= " (nomor_perkara_pn LIKE '%".$this->input->post('no_perkara',TRUE)."%') ";
				}else{
					$where .= " (nomor_perkara_pn ='".$this->input->post('no_perkara',TRUE)."') ";
				}
			}
			if($this->input->post('from_tgl_putusan_pn',TRUE)){
				$where .= $this->parseWhereOnTanggal($where,'from_tgl_putusan_pn','to_tgl_putusan_pn','tgl_putusan_pn_select','putusan_pn');
			}
			if($this->input->post('from_tgl_permohonan',TRUE)){
				$where .= $this->parseWhereOnTanggal($where,'from_tgl_permohonan','to_tgl_permohonan','tgl_permohonan_select','permohonan_banding');
			}
			if ($this->input->post('permohonan_banding')){
				if(!empty($where) AND $this->input->post('permohonan_banding',TRUE)!=''){
					$where .= ' AND ';
				}
				if($this->input->post('permohonan_banding_select',TRUE)==8){
					$where .= " (pemohon_banding LIKE '%".$this->input->post('permohonan_banding',TRUE)."%') ";
				}else{
					$where .= " (pemohon_banding ='".$this->input->post('permohonan_banding',TRUE)."') ";
				}
			}
			if ($this->input->post('status_prodeo')){
				if(!empty($where) AND $this->input->post('status_prodeo',TRUE)!=-1){
					$where .= ' AND ';
				}
			}
			if($this->input->post('status_prodeo',TRUE) != -1){
				$where .= " (prodeo_banding ='".$this->input->post('status_prodeo',TRUE)."') ";
			}
			if($this->input->post('from_tgl_pengiriman_berkas_banding',TRUE)){
				$where .= $this->parseWhereOnTanggal($where,'from_tgl_pengiriman_berkas_banding','to_tgl_pengiriman_berkas_banding','tgl_pengiriman_berkas_banding_select','pengiriman_berkas_banding');
			}
			if($this->input->post('from_tgl_penerimaan_berkas_banding',TRUE)){
				$where .= $this->parseWhereOnTanggal($where,'from_tgl_penerimaan_berkas_banding','to_tgl_penerimaan_berkas_banding','tgl_penerimaan_berkas_banding_select','penerimaan_kembali_berkas_banding');
			}
			if($this->input->post('from_tgl_putusan_banding',TRUE)){
				$where .= $this->parseWhereOnTanggal($where,'from_tgl_putusan_banding','to_tgl_putusan_banding','tgl_putusan_banding_select','putusan_banding');
			}
			if($this->input->post('nomor_putusan_banding',TRUE)){
				if(!empty($where) AND $this->input->post('nomor_putusan_banding',TRUE)!=''){
					$where .= ' AND ';
				}
				if($this->input->post('nomor_putusan_banding_select',TRUE)==8){
					$where .= " (nomor_putusan_banding LIKE '%".$this->input->post('nomor_putusan_banding',TRUE)."%') ";
				}else{
					$where .= " (nomor_putusan_banding ='".$this->input->post('nomor_putusan_banding',TRUE)."') ";
				}
			}
			if($this->input->post('from_tgl_pengarsipan_banding',TRUE)){
				$where .= $this->parseWhereOnTanggal($where,'from_tgl_pengarsipan_banding','to_tgl_pengarsipan_banding','tgl_pengarsipan_banding_select','minutasi_banding');
			}
			if($this->input->post('from_tgl_pemberitahuan_pembanding',TRUE)){
				$where .= $this->parseWhereOnTanggal($where,'from_tgl_pemberitahuan_pembanding','to_tgl_pemberitahuan_pembanding','tgl_pemberitahuan_pembanding_select','pemberitahuan_putusan_banding_pembanding');
			}
			if($this->input->post('from_tgl_pemberitahuan_terbanding',TRUE)){
				$where .= $this->parseWhereOnTanggal($where,'from_tgl_pemberitahuan_terbanding','to_tgl_pemberitahuan_terbanding','tgl_pemberitahuan_terbanding_select','pemberitahuan_putusan_banding_terbanding');
			}
			if($this->input->post('status_cabut',TRUE)=='on'){
				if(!empty($where) AND $this->input->post('status_cabut',TRUE)!=''){
					$where .= ' AND ';
				}
				$where .= " (tanggal_cabut != '' or tanggal_cabut IS NOT NULL) ";
			}
			if($this->input->post('status_banding',TRUE)){
				if(!empty($where) AND $this->input->post('status_banding',TRUE)!=''){
					$where .= ' AND ';
				}
				$where .= " (status_banding_id = '".$this->encrypt->decode(base64_decode($this->input->post('status_banding',TRUE)))."' ) ";
			}
		}else if ($form=='eksekusi_list'){
			if($this->input->post('no_perkara',TRUE)){
				if(!empty($where) AND $this->input->post('no_perkara',TRUE)!=''){
					$where .= ' AND ';
				}
				if($this->input->post('no_perkara_select',TRUE)==8){
					$where .= " (nomor_perkara LIKE '%".$this->input->post('no_perkara',TRUE)."%') ";
				}else{
					$where .= " (nomor_perkara ='".$this->input->post('no_perkara',TRUE)."') ";
				}
			}
			if($this->input->post('pemohon_eksekusi',TRUE)){
				if(!empty($where) AND $this->input->post('pemohon_eksekusi',TRUE)!=''){
					$where .= ' AND ';
				}
				if($this->input->post('pemohon_eksekusi_select',TRUE)==8){
					$where .= " (pemohon_eksekusi LIKE '%".$this->input->post('pemohon_eksekusi',TRUE)."%') ";
				}else{
					$where .= " (pemohon_eksekusi ='".$this->input->post('pemohon_eksekusi',TRUE)."') ";
				}
			}
			if($this->input->post('from_tgl_penetapan_teguran',TRUE)){
				$where .= $this->parseWhereOnTanggal($where,'from_tgl_penetapan_teguran','to_tgl_penetapan_teguran','tgl_penetapan_teguran_select','penetapan_teguran_eksekusi');
			}
			if($this->input->post('no_penetapan_teguran',TRUE)){
				if(!empty($where) AND $this->input->post('no_penetapan_teguran',TRUE)!=''){
					$where .= ' AND ';
				}
				if($this->input->post('no_penetapan_teguran_select',TRUE)==8){
					$where .= " (nomor_penetapan_teguran_eksekusi LIKE '%".$this->input->post('no_penetapan_teguran',TRUE)."%') ";
				}else{
					$where .= " (nomor_penetapan_teguran_eksekusi ='".$this->input->post('no_penetapan_teguran',TRUE)."') ";
				}
			}
			if($this->input->post('from_tgl_pelaksanaan_teguran',TRUE)){
				$where .= $this->parseWhereOnTanggal($where,'from_tgl_pelaksanaan_teguran','to_tgl_pelaksanaan_teguran','tgl_pelaksanaan_teguran_select','pelaksanaan_teguran_eksekusi');
			}
			if($this->input->post('from_tgl_penetapan_sita',TRUE)){
				$where .= $this->parseWhereOnTanggal($where,'from_tgl_penetapan_sita','to_tgl_penetapan_sita','tgl_penetapan_sita_select','penetapan_sita_eksekusi');
			}
			if($this->input->post('no_penetapan_sita',TRUE)){
				if(!empty($where) AND $this->input->post('no_penetapan_sita',TRUE)!=''){
					$where .= ' AND ';
				}
				if($this->input->post('no_penetapan_sita_select',TRUE)==8){
					$where .= " (nomor_penetapan_sita_eksekusi LIKE '%".$this->input->post('no_penetapan_sita',TRUE)."%') ";
				}else{
					$where .= " (nomor_penetapan_sita_eksekusi ='".$this->input->post('no_penetapan_sita',TRUE)."') ";
				}
			}
			if($this->input->post('from_tgl_sita_eksekusi',TRUE)){
				$where .= $this->parseWhereOnTanggal($where,'from_tgl_sita_eksekusi','to_tgl_sita_eksekusi','tgl_sita_eksekusi_select','pelaksanaan_sita_eksekusi');
			}
		}else{
			if($this->input->post('no_perkara',TRUE)){
				if(!empty($where) AND $this->input->post('no_perkara',TRUE)!=''){
					$where .= ' AND ';
				}
				if($this->input->post('no_perkara_select',TRUE)==8){
					$where .= " (nomor_perkara LIKE '%".$this->input->post('no_perkara',TRUE)."%') ";
				}else{
					$where .= " (nomor_perkara ='".$this->input->post('no_perkara',TRUE)."') ";
				}
			}
			if ($form==''){
				if($this->input->post('from_tgl_pendaftaran',TRUE)){
					$where .= $this->parseWhereOnTanggal($where,'from_tgl_pendaftaran','to_tgl_pendaftaran','tgl_pendaftaran_select','tanggal_pendaftaran');
				}
				if($this->input->post('klasifikasi_perkara',TRUE)){
					if(!empty($where) AND $this->input->post('klasifikasi_perkara',TRUE)!=-1){
						$where .= ' AND ';
					}
					if($this->input->post('klasifikasi_perkara',TRUE) != -1){
						$where .= " (jenis_perkara_id ='".$this->input->post('klasifikasi_perkara',TRUE)."') ";
					}
				}

				if($this->input->post('para_pihak',TRUE)){
					$where .= $this->parseWhereOnPihak($where,'para_pihak','para_pihak');
				}

				if($this->input->post('pihak1',TRUE)){
					$where .= $this->parseWhereOnPihak($where,'pihak1','pihak1_text');
				}

				if($this->input->post('pihak2',TRUE)){
					$where .= $this->parseWhereOnPihak($where,'pihak2','pihak2_text');
				}

				if($this->input->post('pihak3',TRUE)){
					$where .= $this->parseWhereOnPihak($where,'pihak3','pihak3_text');
				}

				if($this->input->post('from_tgl_pen_hakim',TRUE)){
					$where .= $this->parseWhereOnTanggal($where,'from_tgl_pen_hakim','to_tgl_pen_hakim','pen_hakim_select','penetapan_majelis_hakim');
				}

				if($this->input->post('from_tgl_pen_sidang',TRUE)){
					$where .= $this->parseWhereOnTanggal($where,'from_tgl_pen_sidang','to_tgl_pen_sidang','pen_sidang_select','penetapan_hari_sidang');
				}

				if($this->input->post('from_tgl_sidang1',TRUE)){
					$where .= $this->parseWhereOnTanggal($where,'from_tgl_sidang1','to_tgl_sidang1','tgl_sidang_select','sidang_pertama');
				}

				if($this->input->post('from_tgl_putusan',TRUE)){
					$where .= $this->parseWhereOnTanggal($where,'from_tgl_putusan','to_tgl_putusan','putusan_select','tanggal_putusan');
				}

				if($this->input->post('from_tgl_minutasi',TRUE)){
					$where .= $this->parseWhereOnTanggal($where,'from_tgl_minutasi','to_tgl_minutasi','minutasi_select','tanggal_minutasi');
				}

				if($this->input->post('id_putusan',TRUE)){
					if(!empty($where) AND $this->input->post('id_putusan',TRUE)!=-1){
						$where .= ' AND ';
					}
					if($this->input->post('id_putusan',TRUE) != -1){
						if($this->input->post('id_putusan',TRUE)>7){
							$where .= " (status_putusan_id ='".$this->input->post('id_putusan',TRUE)."') ";
						}else{
							$where .= " (status_putusan_id LIKE '%".$this->input->post('id_putusan',TRUE)."%') ";
						}
					}
				}

				if($this->input->post('prodeo',TRUE)){
					if(!empty($where) AND $this->input->post('prodeo',TRUE)!=-1){
						$where .= ' AND ';
					}
					if($this->input->post('prodeo',TRUE) != -1){
						$where .= " (prodeo ='".$this->input->post('prodeo',TRUE)."') ";
					}
				}

				if($this->input->post('id_tahapan',TRUE)){
					if(!empty($where) AND $this->input->post('id_tahapan',TRUE)!=-1){
						$where .= ' AND ';
					}
					if($this->input->post('id_tahapan',TRUE) != -1){
						$cond = $this->getSimbolValue($this->input->post('tahapan_select',TRUE));
						$where .= " (tahapan_terakhir_id ".$cond." '".$this->input->post('id_tahapan',TRUE)."') ";
					}
				}

				if($this->input->post('id_proses',TRUE)){
					if(!empty($where) AND $this->input->post('id_proses',TRUE)!=-1){
						$where .= ' AND ';
					}
					if($this->input->post('id_proses',TRUE) != -1){
						$cond = $this->getSimbolValue($this->input->post('proses_select',TRUE));
						$where .= " (proses_terakhir_id ".$cond." '".$this->input->post('id_proses',TRUE)."') ";
					}
				}

				if($this->input->post('mediator',TRUE)){
					if(!empty($where) AND $this->input->post('mediator',TRUE)!=-1){
						$where .= ' AND ';
					}
					if($this->input->post('mediator',TRUE) != -1){
						$where .= " (mediator_id ='".$this->input->post('mediator',TRUE)."') ";
					}
				}
			}else if($form=='jadwal_sidang_list'){
				if($this->input->post('from_tgl_sidang',TRUE)){
					$where .= $this->parseWhereOnTanggal($where,'from_tgl_sidang','to_tgl_sidang','tgl_sidang_select','tanggal_sidang');
				}
				if ($this->input->post('ruangan', true)){
					if(!empty($where) AND $this->input->post('ruangan',TRUE)!=-1){
						$where .= ' AND ';
					}
					if($this->input->post('ruangan',TRUE) != -1){
						$where .= " (ruangan_id = '".$this->input->post('ruangan',TRUE)."') ";
					}
				}
				if($this->input->post('para_pihak',TRUE)){
					if(!empty($where) AND $this->input->post('para_pihak',TRUE)!=''){
						$where .= ' AND ';
					}
					$where .= "(para_pihak like '%".$this->input->post('para_pihak',TRUE)."%')";
				}
			}
		}

		if($this->input->post('sidang_keliling',TRUE)){
			if(!empty($where) AND $this->input->post('sidang_keliling',TRUE)!=-1){
				$where .= ' AND ';
			}
			if($this->input->post('sidang_keliling',TRUE) != -1){
				$where .= " (sidang_keliling ='".$this->input->post('sidang_keliling',TRUE)."') ";
			}
		}

		if($this->input->post('hakim',TRUE)){
			if(!empty($where) AND $this->input->post('hakim',TRUE)!=-1){
				$where .= ' AND ';
			}
			if($this->input->post('hakim',TRUE) != -1){
				$where .= " (majelis_hakim_id LIKE '".$this->input->post('hakim',TRUE).",%' OR majelis_hakim_id LIKE '".$this->input->post('hakim',TRUE)."' OR majelis_hakim_id LIKE '%,".$this->input->post('hakim',TRUE)."' OR majelis_hakim_id LIKE '%,".$this->input->post('hakim',TRUE).",%') ";
			}
		}

		if($this->input->post('panitera',TRUE)){
			if(!empty($where) AND $this->input->post('panitera',TRUE)!=-1){
				$where .= ' AND ';
			}
			if($this->input->post('panitera',TRUE) != -1){
				$where .= " (panitera_pengganti_id LIKE '".$this->input->post('panitera',TRUE).",%' OR panitera_pengganti_id LIKE '".$this->input->post('panitera',TRUE)."' OR panitera_pengganti_id LIKE '%,".$this->input->post('panitera',TRUE)."' OR panitera_pengganti_id LIKE '%,".$this->input->post('panitera',TRUE).",%') ";
			}
		}

		if($this->input->post('jurusita',TRUE)){
			if(!empty($where) AND $this->input->post('jurusita',TRUE)!=-1){
				$where .= ' AND ';
			}
			if($this->input->post('jurusita',TRUE) != -1){
				$where .= " (jurusita_id LIKE '".$this->input->post('jurusita',TRUE).",%' OR jurusita_id LIKE '".$this->input->post('jurusita',TRUE)."' OR jurusita_id LIKE '%,".$this->input->post('jurusita',TRUE)."' OR jurusita_id LIKE '%,".$this->input->post('jurusita',TRUE).",%') ";
			}
		}

		$this->nativesession->set_flash_session('where', $where);
	}

	function parseWhereOnPihak($where,$pihakNo,$col){
		if($this->input->post($pihakNo,TRUE)){
			$wheres='';
			if(!empty($where) AND $this->input->post($pihakNo,TRUE)!=''){
				$wheres .= ' AND ';
			}
			if($this->input->post($pihakNo,TRUE) != ''){
				$wheres .= " (".$col." LIKE '%".$this->input->post($pihakNo,TRUE)."%') ";
			}
		}
		return $wheres;
	}
	
	function parseWhereOnTanggal($where,$from,$to,$select,$col){
		if($this->input->post($from,TRUE)){
			$wheres='';
			if(!empty($where) AND $this->input->post($from,TRUE)!=''){
				$wheres .= ' AND ';
			}
			if($this->input->post($select,TRUE)==6){
				if($this->input->post($to,TRUE)==''){
					$date = $this->tanggalhelper->convertToMysqlDate($this->input->post($from,TRUE));
					$wheres .= " (".$col." ='".$date."') ";
				}else{
					$dateFrom = $this->tanggalhelper->convertToMysqlDate($this->input->post($from,TRUE));
					$dateTo = $this->tanggalhelper->convertToMysqlDate($this->input->post($to,TRUE));
					$wheres .= " (".$col." >='".$dateFrom."' AND ".$col." <= '".$dateTo."') ";
				}
			}else{
				$date = $this->tanggalhelper->convertToMysqlDate($this->input->post($from,TRUE));
				$cond = $this->getSimbolValue($this->input->post($select,TRUE));
				$wheres .= " (".$col." ".$cond." '".$date."') ";
			}
		}
		return $wheres;
	}
	
	function getColumnName($val){
		if($val=='alur'){
			return "alur_perkara_id";
		}elseif($val=='klasifikasi_perkara'){
			return "jenis_perkara_id";
		}elseif($val=='prodeo'){
			return "prodeo";
		}elseif($val=='id_proses'){
			return "proses_terakhir_id";
		}elseif($val=='id_tahapan'){
			return "tahapan_terakhir_id";
		}elseif($val=='pihak1'){
			return "pihak1_text";
		}elseif($val=='pihak2'){
			return "pihak2_text";
		}elseif($val=='pihak3'){
			return "pihak3_text";
		}
	}

	function getSimbolValue($val){
		if($val<0 OR $val>8 OR $val==1){
			return " = ";
		}elseif ($val==2) {
			return " > ";
		}elseif ($val==3) {
			return " >= ";
		}elseif ($val==4) {
			return " < ";
		}elseif ($val==5) {
			return " <= ";
		}elseif ($val==6) {
			return " AND ";
		}elseif ($val==7) {
			return " != ";
		}elseif ($val==8) {
			return " LIKE ";
		}
	}
}

?>
