<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_jurnal_harian extends CI_Model {
	function get_konfigurasi($id){
		try {
			$query = $this->db->query("SELECT id,name, value FROM sys_config WHERE id=".$id."");
			foreach ($query->result() as $row) {
				return $row->value;
			}
			return $query;
		} catch (Exception $e) {
			return FALSE;
		}
	}
	function getNamaPihak($perkara_id){
		try {
			if(!is_numeric($perkara_id)){
				return '';
			}
			$sql = "SELECT nomor_perkara,pihak1_text,pihak2_text,jenis_perkara_id FROM perkara WHERE perkara_id='".$perkara_id."'";
			return $this->db->query($sql);
		} catch (Exception $e) {
			return '';
		}
	}
	function get_biaya_perkara($perkara_id){
		
		try {
		$sql = "SELECT B.nomor_perkara,	B.tanggal_pendaftaran,
					A.jenis_biaya_id,
					B.jenis_perkara_nama,
					B.pihak1_text,
					B.pihak2_text,
					B.alur_perkara_id,
					A.tahapan_id,
					A.jenis_transaksi,
					A.tanggal_transaksi,
					A.uraian,
					A.jumlah,
					A.keterangan
					FROM perkara_biaya A
						left join perkara B ON A.perkara_id=B.perkara_id
					WHERE A.perkara_id=".$perkara_id." ORDER BY A.tahapan_id ASC,A.tanggal_transaksi ASC,A.jenis_transaksi DESC";
			return $this->db->query($sql);
			
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function cek_saldo($pertanggal){
		try {
			$this->db->where('tahun_saldo','YEAR("'.$pertanggal.'")',FALSE);
			$query=$this->db->get('saldo_awal');
			if($query->num_rows()>0){
				return 1;
			}else{
				return 0;
			}
		} catch (Exception $e) {
			log_message('error',$e);
		}
	}

	function get_saldo_sisa($pertanggal){
		try {
				$this->db->query("SELECT jumlah_saldo_awal FROM saldo_awal WHERE tahun_saldo=YEAR('$pertanggal') INTO @s;");
				return $this->db->query("
									SELECT
									tanggal_transaksi,
									@s AS saldo_awal,
									@a:=peneriman AS penerimaan,
									@b:=pengeluaran AS pengeluaran,
									@s:=@s+peneriman-pengeluaran AS sisa
									FROM v_transaksi WHERE year(tanggal_transaksi)=year('$pertanggal')
									ORDER BY tanggal_transaksi ASC");
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_biaya_perkara_pertanggal($tgl_pendaftaran){
		
		try {
		$sql = "SELECT B.nomor_perkara,	B.tanggal_pendaftaran,
					B.jenis_perkara_nama,
	     				A.jenis_transaksi,
					A.tanggal_transaksi,
					A.uraian,
					A.jumlah,
					A.keterangan
					FROM perkara_biaya A
						LEFT JOIN perkara B ON A.perkara_id=B.perkara_id
					WHERE A.tanggal_transaksi='".$tgl_pendaftaran."'
				UNION
				SELECT B.eksekusi_nomor_perkara AS nomor_perkara,B.permohonan_eksekusi AS tanggal_pendaftaran,
					'Eksekusi HT'  AS jenis_perkara_nama,
	     				A.jenis_transaksi,
					A.tanggal_transaksi,
					A.uraian COLLATE latin1_general_ci,
					A.jumlah,
					A.keterangan COLLATE latin1_general_ci
					FROM perkara_biaya_ht A
						LEFT JOIN perkara_eksekusi_ht B ON A.ht_id=B.ht_id
					WHERE A.tanggal_transaksi='".$tgl_pendaftaran."'";
			return $this->db->query($sql);
			
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	function get_biaya_perkara_pertanggal_meterai($tgl_pendaftaran,$kategori){
		
		try {
		$sql = "SELECT B.nomor_perkara,	B.tanggal_pendaftaran,
					B.jenis_perkara_nama,
					B.pihak1_text,
					B.pihak2_text,
					B.alur_perkara_id,
					A.jenis_biaya_id,
					A.jenis_transaksi,
					A.tanggal_transaksi,
					A.uraian,
					A.jumlah,
					A.keterangan
					FROM perkara_biaya A
						left join perkara B ON A.perkara_id=B.perkara_id
					WHERE A.tanggal_transaksi='".$tgl_pendaftaran."' AND A.kategori_id='".$kategori."' ORDER BY A.tahapan_id ASC,A.tanggal_transaksi ASC,A.jenis_transaksi DESC";
			return $this->db->query($sql);
			
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	function get_kategori_biaya($pilih_transaksi){
		if($pilih_transaksi=='transaksi'){
			$where = 'WHERE aktif="y"';
		}else{
			$where = "WHERE aktif='y' and id=".$pilih_transaksi;
		}
		try {
			$sql = "SELECT id,nama, keterangan,urutan FROM kategori_biaya ".$where." ORDER BY urutan ASC;";
			return $this->db->query($sql);
		} catch (Exception $e) {
			return '';
		}
	}
	function getdataskum($perkara_id,$perkara_biaya_id){
		try {
			if(!is_numeric($perkara_id)){
				return '';
			}
			$sql="SELECT 
						a.perkara_id,
						a.nomor_perkara,
						b.tanggal_transaksi, 
						b.jumlah,
						CONCAT(b.uraian, IF(b.tahapan_id=10,' Tingkat Pertama', '')) AS uraian,	
						IF(b.pihak_id IS NULL ,p1.nama,	p.nama) AS nama,
						CASE
							WHEN b.tahapan_id=10 THEN 
								CASE
									WHEN a.alur_perkara_id=16 THEN IF(b.pihak_ke=2,'Termohon','Pemohon')
									WHEN a.alur_perkara_id=15 AND a.jenis_perkara_id=346 THEN IF(b.pihak_ke=2,'Termohon','Pemohon')
									ELSE IF(b.pihak_ke=2,'Tergugat','Penggugat')
								END
							WHEN b.tahapan_id=20 THEN IF(b.pihak_ke=2,'Terbanding','Pembanding')
							WHEN b.tahapan_id=30 THEN IF(b.pihak_ke=2,'Termohon Kasasi','Pemohon Kasasi')
							WHEN b.tahapan_id=40 THEN IF(b.pihak_ke=2,'Termohon PK','Pemohon PK')
						END AS sebagai
					FROM perkara AS a
					LEFT JOIN (SELECT 
						@pihak_id:=`pihak_id`,
						x.*
					FROM perkara_biaya AS x WHERE id='".$perkara_biaya_id."') AS b ON a.`perkara_id`=b.`perkara_id`
					LEFT JOIN (SELECT id AS pihakid, nama FROM pihak WHERE id = @pihak_id) AS p ON b.`pihak_id`=p.pihakid
					LEFT JOIN (SELECT * FROM perkara_pihak1 WHERE perkara_id='".$perkara_id."' AND urutan=1) AS p1 ON a.`perkara_id`=p1.`perkara_id`
					WHERE a.perkara_id='".$perkara_id."'";
			return $this->db->query($sql);
			} catch (Exception $e) {
				return '';
		}
	}

	function getsatker(){
		try {
			$sql = "SELECT `value` AS nama_satker, REPLACE(REPLACE(VALUE,'PENGADILAN AGAMA ',''),'MAHKAMAH SYAR''IYAH ','') AS kota_satker FROM sys_config WHERE id=62;";
			return $this->db->query($sql);
		} catch (Exception $e) {
			return '';
		}
	}
	
	function getalamatsatker(){
		try {
			$sql = "SELECT `value` AS alamat_satker FROM sys_config WHERE id=63;";
			return $this->db->query($sql);
		} catch (Exception $e) {
			return '';
		}
	}

	function getkasir(){
		try {
			$sql = "SELECT b.`fullname` AS nama_kasir, '' AS nip_kasir 
					FROM sys_user_group AS a
					JOIN sys_users b ON a.`userid`=b.`userid`
					WHERE a.`groupid`=702 AND b.`block`=0;";
			return $this->db->query($sql);
		} catch (Exception $e) {
			return '';
		}
	}
	function get_biaya_perkara_psp_6_bulan($pertanggal){
		
		try {
			$sql = "SELECT a.nomor_perkara,c.tanggal_putusan,DATEDIFF('".$pertanggal."',c.tanggal_putusan) AS hari,b.uraian,
					SUM(CASE b.jenis_transaksi WHEN 1 THEN jumlah ELSE 0 END)-SUM(CASE  b.jenis_transaksi WHEN -1 THEN jumlah ELSE 0 END) AS jumlah 
					FROM perkara a LEFT JOIN perkara_biaya b ON a.perkara_id=b.perkara_id 
					LEFT JOIN perkara_putusan c ON a.perkara_id = c.perkara_id 
					WHERE b.tahapan_id=10 AND c.tanggal_putusan IS NOT NULL AND DATEDIFF('".$pertanggal."',c.tanggal_putusan) >=180 GROUP BY b.perkara_id 
					HAVING SUM(CASE b.jenis_transaksi WHEN 1 THEN jumlah ELSE 0 END)-SUM(CASE  b.jenis_transaksi WHEN -1 THEN jumlah ELSE 0 END) > 0;";
			return $this->db->query($sql);
		} catch (Exception $e) {
			return '';
		}
	}
}									
?>