<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Manage_court_calendar extends CI_Controller {
	function index(){
		
		$sec = $this->nativesession->get_flash_session('security');

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$this->show_data();

	}

	function edit_cc(){
		$segment = $this->uri->segment_array();
		$act = $this->uri->segment(2);
		$data['enc'] = $this->uri->segment(3);
		$data['enc_cc'] = $this->uri->segment(4);
		$data['act']=$act;
		
		$perkaraid =$this->encrypt->decode(base64_decode($this->uri->segment(3)));
		$idcc = $this->encrypt->decode(base64_decode($data['enc_cc']));
		
   		if(empty($perkaraid) OR intval($perkaraid)<0){
			show_404();
		}

		$this->load->model('perkara/court_calendar_m');

		$data['previous'] = $this->nativesession->get_flash_session('url_requested');
		$data_perkara = $this->court_calendar_m->getInfoPerkara($perkaraid);
		if($data_perkara->num_rows>0){
			foreach ($data_perkara->result() as $row) {
				$data['nomor_perkara'] = $row->nomor_perkara;
				$data['jenis_perkara'] = $row->jenis_perkara_nama;
				$data['tgl_pendaftaran'] = $this->tanggalhelper->convertDayDate($row->tanggal_pendaftaran);
			}
		}else{
			$data['nomor_perkara'] = '';
			$data['jenis_perkara'] = '';
			$data['tgl_pendaftaran'] = '';
		}

		if($act=='tambah'){
			$data['enc_cc'] ='';
			$data['rencana_tanggal'] = '';
			$data['jam_sidang'] =  '';
			$data['rencana_agenda'] = '';
			$data['keterangan'] = '';
		}elseif ($act=='edit') {
			$data_cc = $this->court_calendar_m->court_calendar_view($perkaraid,$idcc);

			if($data_cc->num_rows>0){
			foreach ($data_cc->result() as $row) {
				$data['enc_cc'] = base64_encode($this->encrypt->encode($row->id));
				$data['rencana_tanggal'] = $this->tanggalhelper->convertToInputDate($row->rencana_tanggal);
				$data['jam_sidang'] =  $row->rencana_jam;
				$data['rencana_agenda'] = $row->rencana_agenda;
				$data['keterangan'] = $row->keterangan;
				}
			}	
		}
		
		$data['current_date'] = date('d/m/Y');
		$data['previous']=$this->nativesession->get('main_url_requested');
		$this->load->vars($data);
		$this->load->view('court_calendar/court_calendar_v');
	}
	

   
	function validateInput(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		
		$this->form_validation->set_rules('nomor_perkara', 'Nomor Perkara', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tgl_sidang', 'Tanggal Persidangan', 'required|xss_clean');
		$this->form_validation->set_rules('jamSidang', 'Jam Persidangan', 'required|xss_clean');
		$this->form_validation->set_rules('agenda_sidang', 'Jadwal/Agenda Sidang', 'trim|required|xss_clean');		

		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara) <1){
			echo json_encode(array('st'=>0,'msg'=>'Data Perkara Tidak Ditemukan.'));
			return;
		}		

		$tglSidang = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_sidang',TRUE));
		$jamSidang = $this->input->post('jamSidang',TRUE);
		$agendaSidang = $this->input->post('agenda_sidang',TRUE);
		$keterangan = $this->input->post('keterangan',TRUE);

		if(!empty($tglSidang)){
			$tglSidang = $tglSidang;
		}else{
			$tglSidang = NULL;
		}
		
		$data_cc = array(
				'perkara_id'=>intval($idperkara),
				'rencana_tanggal'=>$tglSidang,
				'rencana_jam' => $jamSidang,
				'rencana_agenda' => $agendaSidang,
				'keterangan' => $keterangan,
				'diinput_oleh' => $this->session->userdata('username'),
				'diinput_tanggal' => date("Y-m-d h:i:s",time())
			);
		
		$curr_date = date('Y-m-d');
		$todayDate = date('m/d/Y');

		$dayname = $this->tanggalhelper->getDayName($tglSidang);
		if($dayname=='Saturday' OR $dayname=='Sunday'){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Dihari Libur, Sabtu dan Minggu.'));
			return;
		}

		$tglpendaftaran = $this->tanggalhelper->getTanggalPendaftaran($idperkara);
		$selisih = $this->tanggalhelper->getSelisihHari($tglpendaftaran,$tglSidang);
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Rencana Sidang tidak boleh kurang dari tanggal pendaftaran.'));
			return;
		}

		if($this->db->insert('perkara_court_calendar',$data_cc)){
			echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Database Error, Tambah Agenda/Rencana Sidang Tidak Berhasil'));
		}	
	}



	function validateEdit(){
		if(empty($_POST)){
			show_404();
		}
		$data['previous']=base_url(uri_string());

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$enc_cc=$this->encrypt->decode(base64_decode($this->input->post('enc_cc',TRUE)));
		if(!is_numeric($enc_cc) OR intval($enc_cc)<1){
			echo json_encode(array('st'=>0,'msg'=>'Data Rencana Sidang Tidak Ditemukan.'));
			return;
		}

		$idperkara=$this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Data Rencana Sidang Tidak Ditemukan.'));
			return;
		}
		

		$this->form_validation->set_rules('nomor_perkara', 'Nomor Perkara', 'trim|required|xss_clean');
		
		$this->form_validation->set_rules('tgl_sidang', 'Tanggal Rencana Sidang', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('jamSidang', 'Jam Persidangan', 'required|xss_clean');
		$this->form_validation->set_rules('agenda_sidang', 'Rencana Sidang', 'trim|required|xss_clean');

		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}

		
		$tglSidang= $this->input->post('tgl_sidang',TRUE);
		$curr_date = date('Y-m-d');
		$todayDate = date('m/d/Y');
		$tglSidang = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_sidang',TRUE));

		if($tglSidang==false){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
			return;
		}

		$dayname = $this->tanggalhelper->getDayName($tglSidang);
		if($dayname=='Saturday' OR $dayname=='Sunday'){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penerimaan Dihari Libur, Sabtu dan Minggu.'));
			return;
		}
		$tglpendaftaran = $this->tanggalhelper->getTanggalPendaftaran($idperkara);
		$selisih = $this->tanggalhelper->getSelisihHari($tglpendaftaran,$tglSidang);
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Terima Barang Tidak Boleh Kurang dari Tanggal Berkas Dilimpahkan.'));
			return;
		}
		$noPerkara = $this->input->post('nomor_perkara',TRUE);
		$tglSidang= $this->input->post('tgl_sidang',TRUE);
		$jamSidang= $this->input->post('jamSidang',TRUE);
		$agenda_sidang= $this->input->post('agenda_sidang',TRUE);
		$keterangan= $this->input->post('keterangan',TRUE);
		

		$where_array = array(
               $id => $enc_cc,
               $perkara_id => $idperkara
              ); 

		$data_cc = array(
				'perkara_id'=>$idperkara,
				'rencana_tanggal'=> $this->tanggalhelper->convertToMysqlDate($tglSidang),
				'rencana_agenda' => $agenda_sidang,
				'keterangan' => $keterangan
			);

		// $this->db->where($where_array);
		// $this->db->update('perkara_court_calendar', $data_bb);
		$sql="update perkara_court_calendar set rencana_tanggal='".$this->tanggalhelper->convertToMysqlDate($tglSidang)."' , 
			   rencana_jam = '".$jamSidang."', 
			   rencana_agenda='".$agenda_sidang."',
			   keterangan='".$keterangan."',
			   diperbaharui_oleh='".$this->session->userdata('username')."',
			   diperbaharui_tanggal='".date("Y-m-d h:i:s",time())."'
			   where Id ='".$enc_cc."' AND perkara_id ='".$idperkara."' ";

		$this->db->query($sql);

		
		if(!empty($tglSidang)){
			$tglSidang = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_sidang',TRUE));	
			if($tglSidang==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tglSidang);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Dihari Libur, Sabtu dan Minggu.'));
				return;
			}
			$data_bb['rencana_tanggal'] = $tglSidang;
		}
		if($this->db->query($sql)){
			echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Database Error, Tambah Rencana Sidang Tidak Berhasil'));
		}	
	}

	function hapus_cc(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc')));
		$id = $this->encrypt->decode(base64_decode($this->input->post('enc_cc')));
		if(!is_numeric($idperkara) OR !intval($idperkara)>0){
			echo json_encode(array('st'=>0,'msg'=>'Tidak ditemukan barang bukti yang dihapus.'));
			return;
		}
		
		$this->load->model('perkara/court_calendar_m');
		$sql="DELETE FROM perkara_court_calendar where id ='".$id."'  ";
		$this->db->query($sql);

		if($this->db->query($sql)){
			echo json_encode(array('st'=>1,'msg'=>'Rencana sidang telah dihapus'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'));
			return;
		}
	}

	function cetak() {      
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }

        $segment = $this->uri->segment_array();
        $data['enc'] = $segment[3];
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }        

        $this->load->model('perkara/court_calendar_m');
        $detilperkara = $this->court_calendar_m->getDataPrint($idperkara);
        $data['detil_cc'] = $this->court_calendar_m->get_info_court_calendar($idperkara);

        if($detilperkara->num_rows>0){
			foreach ($detilperkara->result() as $row) {
				$data['nomor_perkara'] = $row->nomor_perkara;
				$data['pihak1_text'] = $row->pihak1_text;
				$data['pihak2_text'] = $row->pihak2_text;
				$data['alur_perkara_id'] = $row->alur_perkara_id;
				$data['pengacara_pihak1'] = $row->pengacara_pihak1;
				$data['pengacara_pihak2'] = $row->pengacara_pihak2;
				if(!empty($row->pengacara_pihak1)){
					$data['kuasa_p'] = 'Kuasa';
				}else{
					$data['kuasa_p'] = '';
				}
				if(!empty($row->pengacara_pihak2)){
					$data['kuasa_t'] = 'Kuasa';
				}else{
					$data['kuasa_t'] = '';
				}
			}
		}
		$data_majelis = $this->court_calendar_m->getDataMajelis($idperkara);
		if($data_majelis->num_rows>0){
			foreach ($data_majelis->result() as $row) {
				$data['panitera_pengganti'] = $row->nama_gelar;
			}
		}
		$data['hakim'] = $this->court_calendar_m->getDataHakim($idperkara);
		$data['pengacara1'] = $this->court_calendar_m->getDataPengacara($idperkara,1);
		$data['pengacara2'] = $this->court_calendar_m->getDataPengacara($idperkara,2);
		$data['pihak1'] = $this->court_calendar_m->getDataPihak($idperkara,1);
		$data['pihak2'] = $this->court_calendar_m->getDataPihak($idperkara,2);

        $this->load->view('court_calendar/cetak',$data,FALSE);  
    }
}