<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class ManagePutusanAkhir extends CI_Controller {
	function index(){
		if($this->nativesession->get_flash_session('security')==FALSE){
			redirect('main');
		}
		$sec = $this->nativesession->get_flash_session('security');
		$this->nativesession->get_flash_session('url_requested');
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$idperkara = $this->nativesession->get_flash_session('perkara_id');
		if(!is_numeric($idperkara)){
			show_404();
		}
		$act = $this->nativesession->get_flash_session('action');
		$actparams = $this->nativesession->get_flash_session('actionparams');
		if($act=='tambah'){
			$this->edit_data($idperkara,$act,$actparams);
		} elseif ($act=='update') {
			$this->edit_data($idperkara,$act);
		} else if ($act=='diversi'){
			$this->edit_data_diversi($idperkara,$act);
		}elseif ($act=='tambah_sppa') {
			$this->edit_data($idperkara,$act);
		}else{
			$this->show_data($idperkara);
		}	
	}

	function pemberitahuan(){
		if($this->nativesession->get_flash_session('security')==FALSE){
			redirect('main');
		}
		$sec = $this->nativesession->get_flash_session('security');

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$idperkara = $this->nativesession->get_flash_session('perkara_id');
		if(!is_numeric($idperkara)){
			show_404();
		}
		$act = $this->nativesession->get_flash_session('action');
		if($act=='tambah'){
			$this->edit_pemberitahuan($idperkara,$act);
		}elseif ($act=='update') {
			$this->edit_pemberitahuan($idperkara,$act);
		}else{
			$this->show_data($idperkara);
		}	
	}

	function show_data($idperkara){
		$data['enc'] = $this->nativesession->get_flash_session('enc',TRUE);
		$this->load->model('putusan/data_putusan_akhir','putusan');
        $this->load->model('perkara/info_perkara_agama','agama');
        $data['is_islam_ikrar']=$this->agama->getInfoAgamaPeCT($idperkara);
		$data['tgl_pendaftaran'] = $this->tanggalhelper->getTanggalPendaftaran($idperkara);
		$data['idalurperkara'] = $this->putusan->getAlurPerkara($idperkara);		
		$data['putusan'] = $this->putusan->getDataPutusanAkhir($idperkara);
		$data['status_putusan'] = $this->putusan->getPutusanTerdakwa($idperkara);
		$data['pihak_pertama'] = $this->putusan->getPihak($idperkara,1);
		$data['pihak_kedua'] = $this->putusan->getPihak($idperkara,2);
		$data['pihak_ketiga'] = '';
		$data['pihak_keempat'] = '';
		$data['verstek'] = '';
		if($data['putusan']->num_rows()>0){
			$data['verstek'] = $data['putusan']->row()->putusan_verstek;
		}
		if($data['idalurperkara']<100 AND $data['idalurperkara']!=8 AND $data['idalurperkara']!=2){
			$data['pihak_ketiga'] = $this->putusan->getPihak($idperkara,3);
			$data['pihak_keempat'] = $this->putusan->getPihak($idperkara,4);
		}
	
		$faktorCerai = $this->putusan->getPerkaraFaktorPercerian($idperkara);
		if($faktorCerai!=''){
			if($faktorCerai->num_rows>0){
				foreach ($faktorCerai->result() as $row) {
					$data['faktor_penyebab'] = $row->nama;
					$keadaan_istri_id = $row->keadaan_istri;
					if($keadaan_istri_id==1){
						$data['keadaan_istri']='Suci';
					}elseif ($keadaan_istri_id==2){
						$data['keadaan_istri']='Haid';
					}elseif ($keadaan_istri_id==3){
						$data['keadaan_istri']='Hamil';
					}elseif ($keadaan_istri_id==4) {
						$data['keadaan_istri']='Tidak Diketahui';
					}
				}
			}
		}		
		$data['isi'] = FALSE;
		$data['idperkara'] = $idperkara;
		if($data['putusan']->num_rows>0){
			$data['isi'] = TRUE;
		}
		$data['alur_perkara_id']=$data['idalurperkara'];
		$data['status_diversi'] = $this->putusan->getStatusDiversi($idperkara);
		
		$this->load->vars($data);
		$this->load->view('putusan/putusan_akhir'); 
	}



	function edit_data_diversi($idperkara,$act){
		if($this->session->userdata('is_logged_in')==FALSE){ redirect('login'); }
		$data['error'] = FALSE;
		$data['error_message'] = '';

		if(!is_numeric($idperkara) OR intval($idperkara) <1){
			$data['error'] = TRUE;
			$data['error_message'] = '404';
		}

		$data['current_date'] = date('d/m/Y');
		$this->load->model('putusan/data_putusan_akhir','putusan');
		$data['act'] = base64_encode($this->encrypt->encode($act));
		$data['enc'] = $this->nativesession->get_flash_session('enc',TRUE);
		
		$alur_perkara = $this->putusan->getAlurPerkara($idperkara);
		
		$data['idalurperkara'] = $alur_perkara;
		$data['idperkara'] = $idperkara;
		$data['enc_alur'] = base64_encode($this->encrypt->encode($alur_perkara));
		
		$data['status_putusan'] = $this->putusan->getPutusanTerdakwa($idperkara);
		$data['verstek'] = '';
		
		$data['pihak_pertama'] = $this->putusan->getPihak($idperkara,1);
		$data['idhakim'] = '';

		$putusan = $this->putusan->getDataPutusanAkhir($idperkara);

		$data['tanggal_putusan'] = (!empty($putusan->row()->tanggal_putusan) ? $this->tanggalhelper->convertToInputDate($putusan->row()->tanggal_putusan) : '');		
		$data['status_putusan_id'] = (!empty($putusan->row()->status_putusan_id) ? $putusan->row()->status_putusan_id : '');
		$data['tgl_minutasi'] = (!empty($putusan->row()->tanggal_minutasi) ? $this->tanggalhelper->convertToInputDate($putusan->row()->tanggal_minutasi) : '');
		$data['keterangan'] = (!empty($putusan->row()->catatan_putusan) ? $putusan->row()->catatan_putusan : '');
		$data['edoc_putusan'] = (!empty($putusan->row()->amar_putusan_dok) ? $putusan->row()->amar_putusan_dok : '');
		
		if(!empty($putusan->row()->amar_putusan)){
			$data['amar'] =	$putusan->row()->amar_putusan;
		}else{
			$data_terdakwa = $this->putusan->getPutusanTerdakwa($idperkara)->result();
			$jml_data_terdakwa = $this->putusan->getPutusanTerdakwa($idperkara)->num_rows();
			if($jml_data_terdakwa>1){
				$info_jml = 'dan kawan-kawan';
				$terdakwa = 'Para Terdakwa';
			}elseif($jml_data_terdakwa<=1){
				$info_jml = '';
				$terdakwa = 'Terdakwa';
			}
			$nama_terdakwa = $this->templatehelper->standradnaming($data_terdakwa[0]->nama);
			$status_penahanan = $this->putusan->getStatusPenahanan($idperkara);
			if(!empty($status_penahanan)){
				$penahanan = '<li>Memerintahkan Anak tersebut dikeluarkan dari tahanan;</li>';
			}else{
				$penahanan = '';
			}
			$data['amar'] = '<ol type="1">
							<li>Menghentikan proses pemeriksaan perkara Anak '.$nama_terdakwa.' '.$info_jml.';</li>'.$penahanan.'
							<li>Memerintahkan Panitera mengirimkan salinan penetapan ini kepada Penuntut Umum dan Anak/Orangtua/Wali</li>
								</ol>';
		}
		

		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-','RemoveFormat','-', 'Blockquote',
					'-','JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '100%';
		$this->ckeditor->config['height'] = '250px';

		$data['list_amar'] = $this->putusan->getTemplateAmar(); 
		$this->load->model('diversi/diversi_m');
		$data['detail_diversi']	=	$this->diversi_m->get_data_diversi($idperkara);
		$data['namahalaman']="DATA PENETAPAN PENGHENTIAN PEMERIKSAAN PERKARA";
		$this->load->vars($data);
		$this->load->view('putusan/edit_putusan_akhir_diversi');
	}


	function edit_data($idperkara,$act,$actparams=NULL){

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['error'] = FALSE;
		$data['error_message'] = '';

		if(!is_numeric($idperkara) OR intval($idperkara) <1){
			$data['error'] = TRUE;
			$data['error_message'] = '404';
		}
		$data['current_date'] = date('d/m/Y');
		$this->load->model('putusan/data_putusan_akhir','putusan');
        $this->load->model('perkara/info_perkara_agama','agama');
		if($act=='tambah_sppa'){
			$aksi='tambah';
		}elseif($act=='tambah'){
			$aksi='tambah';
		}else{
			$aksi='update';
		}
		$data['act'] = base64_encode($this->encrypt->encode($aksi));
		$data['actparams'] = base64_encode($this->encrypt->encode($actparams));
		$data['enc'] = $this->nativesession->get_flash_session('enc',TRUE);
		
		
		$alur_perkara = $this->putusan->getAlurPerkara($idperkara);
		$data['idalurperkara'] = $alur_perkara;
		$data['idperkara'] = $idperkara;
		$data['enc_alur'] = base64_encode($this->encrypt->encode($alur_perkara));
		if($alur_perkara<100 OR $alur_perkara==119 OR $alur_perkara==123){
			$data['status_putusan'] = $this->putusan->getDataStatusPutusan($alur_perkara);
			$data['sumber_hukum'] = $this->putusan->getDataSumberHukum();
			if($alur_perkara==3){
				$data['hakim'] = $this->putusan->getListHakim();
				$data['kurator'] = $this->putusan->getListKurator();
			}

			if($alur_perkara==15)
				$data['faktor_percerian'] = $this->putusan->getDataFaktorPercerian();
				$keadaan_istri= $this->putusan->getKeadaanIstri($idperkara);
                $data['is_islam_ikrar']=$this->agama->getInfoAgamaPeCT($idperkara);
				if (!empty($keadaan_istri)){
					if ($keadaan_istri->num_rows>0){
						foreach ($keadaan_istri->result() as $row) {
							$data['keadaan_istri_id']=$row->keadaan_istri;
						}
						
					}
				}
			$data['verstek'] = ''; 
			$data['sumber_hukum_put'] = '';
			$data['faktor_percerian_put'] = '';
		}elseif($alur_perkara>100){
			$data['status_putusan'] = $this->putusan->getPutusanTerdakwa($idperkara);
			$data['verstek'] = '';
		}
		if($alur_perkara==9 OR $alur_perkara==15 OR $alur_perkara==16 OR $alur_perkara==120 OR $alur_perkara==121){
			$data['statusBHT'] = $this->putusan->getTanggalBHT($idperkara);
		}
		$data['pihak_pertama'] = $this->putusan->getPihak($idperkara,1);
		$data['pihak_kedua'] = $this->putusan->getPihak($idperkara,2);

		$this->load->model('generate_template/m_template_penetapan','template');
		$data_satker = $this->template->getDataPN()->result();
		if(!empty($data_satker) OR $data_satker!=''){
			$nama_satker = $this->templatehelper->standradnaming($data_satker[0]->NamaPN);			
		}else{
			$nama_satker = 'Pengadilan Negeri .....';
		}
		if($alur_perkara>100){
			$data_terdakwa = $this->putusan->getPutusanTerdakwa($idperkara)->result();
			$jml_data_terdakwa = $this->putusan->getPutusanTerdakwa($idperkara)->num_rows();
			if($jml_data_terdakwa>1){
				$info_jml = 'dan kawan-kawan';
				$terdakwa = 'Para Terdakwa';
			}elseif($jml_data_terdakwa<=1){
				$info_jml = '';
				$terdakwa = 'Terdakwa';
			}
			$nama_terdakwa = $this->templatehelper->standradnaming($data_terdakwa[0]->nama);
		}
		if($act=='tambah_sppa' AND $alur_perkara==118){
			$data['amar'] = '<ol type="1">
								<li>Menghentikan proses pemeriksaan perkara Anak '.$nama_terdakwa.' '.$info_jml.';</li>
								<li>Menyerahkan kembali berkas perkara kepada Ketua '.$nama_satker.' untuk dialihkan dalam pemeriksaan perkara dewasa;</li>
							</ol>';
		}elseif($act=='tambah_sppa' AND $alur_perkara!=118){
			$data['amar'] = '<ol type="1">
								<li>Menghentikan proses pemeriksaan perkara '.$terdakwa.' '.$nama_terdakwa.' '.$info_jml.';</li>
								<li>Menyerahkan kembali berkas perkara kepada Ketua '.$nama_satker.' untuk dialihkan dalam pemeriksaan perkara Anak;</li>
							</ol>';
		}else{
			$data['amar'] = '';
		}		
		$data['edoc_putusan'] = '';
		$data['idhakim'] = '';
		$data['status_putusan_id'] = '';
		$putusan = $this->putusan->getDataPutusanAkhir($idperkara);
		if($alur_perkara==15){
			$faktorCerai = $this->putusan->getPerkaraFaktorPercerian($idperkara);
			if($faktorCerai!=''){
				if($faktorCerai->num_rows>0){
					foreach ($faktorCerai->result() as $row) {
						$data['faktor_percerian_put'] = $row->faktor_perceraian_id;
					}
				}
			}
		}
		if($putusan !=''){
			if($putusan->num_rows()>0){
				foreach ($putusan->result() as $row) {
					$data['tanggal_putusan'] = $this->tanggalhelper->convertToInputDate($row->tanggal_putusan);
					$data['amar'] = $row->amar_putusan;
					$data['status_putusan_id'] = $row->status_putusan_id;
					$data['tgl_minutasi'] = $this->tanggalhelper->convertToInputDate($row->tanggal_minutasi);
					if($alur_perkara<100){
						$data['tglANKUM'] = $this->tanggalhelper->convertToInputDate($row->pemberitahuan_putusan_ankum);
						$data['tglPEPERA'] = $this->tanggalhelper->convertToInputDate($row->pemberitahuan_putusan_pepera);
						$data['verstek'] = $row->putusan_verstek;
						$data['sumber_hukum_put'] = $row->sumber_hukum_id;
						$data['idhakim'] = $row->hakim_pengawas_id;
						$data['idkurator'] = $row->kurator_id;
						$data['nilai_ganti_sengketa'] = $row->nilai_ganti_kerugian;
						$data['penHakim'] = $this->tanggalhelper->convertToInputDate($row->penetapan_hakim_pengawas);
						$data['tglBerita'] = $this->tanggalhelper->convertToInputDate($row->tanggal_berita_putusan);
						$data['tglSuratKabar'] = $this->tanggalhelper->convertToInputDate($row->tanggal_surat_kabar_putusan);
						$data['namaSurat'] = $row->nama_surat_kabar_putusan;
					}
					if($alur_perkara==114){
						$data['verstek'] = $row->putusan_verstek;
					}
					$data['keterangan'] = $row->catatan_putusan;
					$data['edoc_putusan'] = $row->amar_putusan_dok;
				}
			}
		}
		$data['sidang_terakhir'] = $this->tanggalhelper->convertToInputDate($this->putusan->getTanggalSidangAkhir($idperkara));
		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-','RemoveFormat','-', 'Blockquote',
					'-','JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '100%';
		$this->ckeditor->config['height'] = '250px';
	
		$jenis_perkara= $this->putusan->getPerkara($idperkara);
				if (!empty($jenis_perkara)){
					if ($jenis_perkara->num_rows>0){
						foreach ($jenis_perkara->result() as $row) {
							$jenis_perkara_id=$row->jenis_perkara_id;
						}
						
					}
				}
		$data['list_amar'] = $this->putusan->getTemplateAmar_agama($jenis_perkara_id); 
		


		$this->load->vars($data);
		$this->load->view('putusan/edit_putusan_akhir');
	}

	function getAmar(){
		$this->load->model('putusan/data_putusan_akhir','putusan');
		$id_template = $this->input->post('selected');
		if(intval($id_template)<=0){
			echo '';
			return;
		}else{
			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			if(intval($idperkara)<=0){
				echo '';
				return;
			}
			$template = '';
			$res = $this->putusan->getContentTemplateAmar($id_template);
			if(!empty($res)){
				if($res->num_rows()>0){
					$template = $res->row()->template;
				}
			}
			$datakecamatan_pihak1= $this->putusan->get_data_alamat_pihak1($idperkara)->row();
			$datakecamatan_pihak2= $this->putusan->get_data_alamat_pihak2($idperkara)->row();
			$datapernikahan= $this->putusan->get_data_pernikahan($idperkara)->row();
			$template = str_replace('#kua_tempat_nikah#', $rowdatapernikahan->kua_tempat_nikah, $template);
			$template = str_replace('#kua_kecamatan_pihak1#', $this->templatehelper->ambil_kecamatan($datakecamatan_pihak1->alamat), $template);
			$template = str_replace('#kua_kabupaten_pihak1#', $this->templatehelper->ambil_kabupaten($datakecamatan_pihak1->alamat), $template);
			$template = str_replace('#kua_kecamatan_pihak2#', $this->templatehelper->ambil_kecamatan($datakecamatan_pihak2->alamat), $template);
			$template = str_replace('#kua_kabupaten_pihak2#', $this->templatehelper->ambil_kabupaten($datakecamatan_pihak2->alamat), $template);
			$template = str_replace('#tanggal_nikah#', $this->templatehelper->convertKeTglIndo($datapernikahan->tgl_nikah), $template);
			$biaya= $this->putusan->get_var_biaya($idperkara);
			foreach ($biaya->result() as $row){
				$biaya = $row->biaya_proses;
				$pendaftaran = $row->biaya_pendaftaran;
				$panggilan = $row->biaya_panggilan;
				$redaksi = $row->biaya_redaksi;
				$meterai = $row->biaya_meterai;
				$leges = $row->biaya_leges;
				$pemeriksaan = $row->biaya_pemeriksaan;
				$sita = $row->biaya_sita;
			}
			
			$total_biaya = $biaya + $pendaftaran + $panggilan  + $redaksi + $meterai;
			 if ($this->session->userdata('jenis_pengadilan')==1){
				$total_biaya += $pemeriksaan + $sita;
			}elseif($this->session->userdata('jenis_pengadilan')==3){
				$total_biaya += $leges;
			} 
			$terbilang= $this->templatehelper->Terbilang(intval(str_replace('.', '',intval($total_biaya))));
			$template = str_replace('#angka_biaya#', $total_biaya, $template); 
			$template = str_replace('#terbilang_biaya#',$terbilang, $template); 
			
		
		 	$dataperkara= $this->putusan->getDataPihak1_pihak2($idperkara);
	
		 	$dataperkara= $this->putusan->getDataPihak1_pihak2($idperkara);
			foreach ($dataperkara->result() as $row){
				 
				 $template = str_replace('#nomor_perkara#', $row->nomor_perkara, $template);
				 $template = str_replace('#nama_pihak1#', $row->nama_pihak1, $template);
				 $template = str_replace('#nama_pihak2#', $row->nama_pihak2, $template); 
				 $template = str_replace('#nama_satker#', ucwords(strtolower($this->session->userdata('namaPN'))) , $template);
				 
				 if(($row->jenis_perkara_id==346 AND $row->alur_perkara_id==15) OR ($row->alur_perkara_id>1 AND $row->alur_perkara_id<7)){
					$template = str_replace('#permohonan/gugatan#', 'Permohonan', $template);
					$template = str_replace('#penggugat/pemohon#', 'Pemohon', $template);
				}elseif($row->alur_perkara_id==16){
					$template = str_replace('#permohonan/gugatan#', 'Permohonan', $template);
					$template = str_replace('#penggugat/pemohon#', '<b>Pemohon/penggugat Bukan Perkara Cerai</b>', $template);
				}else{
					$template = str_replace('#permohonan/gugatan#', 'Gugatan', $template);
					$template = str_replace('#penggugat/pemohon#', 'Penggugat', $template);
					$template = str_replace('#tergugat/termohon#', 'Tergugat', $template);	
				}
			 }
			 
			//str_replace disini ya
			echo $template;
			return;
		}

	}
	     function ambil_kabupaten($alamat) {


		 $A = explode(' ',trim($row->alamat));
	     
	     for ($i=0; $i<=count($A)-1 ; $i++) { 
	      	
	      	 if (strtoupper($A[$i]) == 'KECAMATAN')  {
	      	 	break;
	         }
		       
		  } 

	   
	      for ($i=$i; $i<=count($A)-1 ; $i++) { 
	   	
	        if ((strtoupper($A[$i]) =='KABUPATEN') || (strtoupper($A[$i])== 'KOTA') || (strtoupper($A[$i])== 'KAB') || (strtoupper($A[$i]) == 'KAB.')) {
	      	 	break;
	         }
	     	  else {
		        
		         if (strtoupper($A[$i])<>'KECAMATAN') {
		     
		      echo '';
		      

		       }
	        }

		 }


        
	  for ($i=$i; $i<=count($A)-1 ; $i++) { 
      	
       if ((strtoupper($A[$i]) == 'KABUPATEN') || (strtoupper($A[$i]) == 'KOTA') || (strtoupper($A[$i]) == 'KAB') || (strtoupper($A[$i]) == 'KAB.')) {
        echo '';
       }
          else {

             	if ((strtoupper($A[$i]) <> 'KABUPATEN') || (strtoupper($A[$i]) <> 'KOTA') || (strtoupper($A[$i]) <> 'KAB') || (strtoupper($A[$i]) <> 'KAB.')) {
      	 	$kabupaten="Kabupaten".$i." ".$A[$i];
           }


          }

	 return $kabupaten;

	 }
	}
	//inserted by mashen 24/11/2017
	function ambil_kecamatan($alamat) {


		 $A = explode(' ',trim($row->alamat));
	     
	     for ($i=0; $i<=count($A)-1 ; $i++) { 
	      	
	      	 if (strtoupper($A[$i]) == 'KECAMATAN')  {
	      	 	break;
	         }
		       
		  } 

	   
	      for ($i=$i; $i<=count($A)-1 ; $i++) { 
	   	
	        if ((strtoupper($A[$i]) =='KABUPATEN') || (strtoupper($A[$i])== 'KOTA') || (strtoupper($A[$i])== 'KAB') || (strtoupper($A[$i]) == 'KAB.')) {
	      	 	break;
	         }
	     	  else {
		        
		         if (strtoupper($A[$i])<>'KECAMATAN') {
		     
		      $kecamatan="kecamatan".$i." ".$A[$i];
		       return  $kecamatan;

		       }
	        }

		 }

	}
	
	function edit_pemberitahuan($idperkara,$act){

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['error'] = FALSE;
		$data['error_message'] = '';

		if(!is_numeric($idperkara) OR intval($idperkara) <1){
			$data['error'] = TRUE;
			$data['error_message'] = '404';
		}
		$data['current_date'] = date('d/m/Y');
		$this->load->model('putusan/data_putusan_akhir','putusan');
		$data['act'] = base64_encode($this->encrypt->encode($act));
		$data['enc'] = $this->nativesession->get_flash_session('enc',TRUE);
		
		$data['pihak_pertama'] = $this->putusan->getPihak($idperkara,1);
		$data['pihak_kedua'] = $this->putusan->getPihak($idperkara,2);
		$alur_perkara = $this->putusan->getAlurPerkara($idperkara);
		$data['idalurperkara'] = $alur_perkara;
		$data['pihak_ketiga'] = '';
		$data['pihak_keempat'] = '';
		if($alur_perkara<100){
			$data['pihak_ketiga'] = $this->putusan->getPihak($idperkara,3);
			$data['pihak_keempat'] = $this->putusan->getPihak($idperkara,4);
		}
		$data['idperkara'] = $idperkara;
		$data['enc_alur'] = base64_encode($this->encrypt->encode($alur_perkara));
		$putusan = $this->putusan->getDataPutusanAkhir($idperkara);
		if($putusan !=''){
			if($putusan->num_rows>0){
				foreach ($putusan->result() as $row) {
					$data['tglANKUM'] = $this->tanggalhelper->convertToInputDate($row->pemberitahuan_putusan_ankum);
					$data['tglPEPERA'] = $this->tanggalhelper->convertToInputDate($row->pemberitahuan_putusan_pepera);
					$data['tanggal_putusan'] = $this->tanggalhelper->convertDayDate($row->tanggal_putusan);
					$data['amar'] = $row->amar_putusan;
					$data['status_putusan_id'] = $row->status_putusan_id;
					$data['tgl_kirim_salinan_penyidik']= $this->tanggalhelper->convertToInputDate($row->kirim_salinan_putusan_penyidik);
					$data['tgl_minutasi'] = $this->tanggalhelper->convertToInputDate($row->tanggal_minutasi);
					if($alur_perkara<100 OR $alur_perkara==119 OR $alur_perkara==123){
						$data['tglANKUM'] = $this->tanggalhelper->convertToInputDate($row->pemberitahuan_putusan_ankum);
						$data['tglPEPERA'] = $this->tanggalhelper->convertToInputDate($row->pemberitahuan_putusan_pepera);
						$data['verstek'] = $row->putusan_verstek;
						$data['sumber_hukum_put'] = $row->sumber_hukum_id;
						$data['idhakim'] = $row->hakim_pengawas_id;
						$data['idkurator'] = $row->kurator_id;
					}
					$data['keterangan'] = $row->catatan_putusan;
				}
			}
		}
		$data['status_diversi'] = $this->putusan->getStatusDiversi($idperkara);
		$this->load->vars($data);
		$this->load->view('putusan/edit_pemberitahuan');
	}



	function validateInputDiversi(){
		if(empty($_POST)){ show_404(); }

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		
		$alurperkara = $this->encrypt->decode(base64_decode($this->input->post('enc_alur',TRUE)));
		
		$this->form_validation->set_rules('amar_text', 'Amar Putusan', 'trim|required|xss_clean|min_length[50]');
		$this->form_validation->set_rules('tgl_putusan', 'Tanggal Putusan', 'trim|required|xss_clean|exact_length[10]');
		
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			if(!is_numeric($idperkara) OR intval($idperkara) <1){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Perkara Tidak Diketahui.'));
				return;
			}
			$this->load->model('putusan/data_putusan_akhir','putusan');					

			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');
			
			$tgl_putusan = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_putusan',TRUE));
			
			$selisih = $this->tanggalhelper->getSelisihHari($tgl_putusan,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Putusan Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($date_sidang,$tgl_putusan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Putusan Tidak Boleh Kurang dari Tanggal Sidang Terakhir ('.$this->tanggalhelper->convertDayDate($date_sidang).').'));
				return;
			}						
				
			$dayname = $this->tanggalhelper->getDayName($tgl_putusan);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Putusan Dihari Libur, Sabtu dan Minggu.'));
				return;
			}
			$amar = trim($this->input->post('amar_text',TRUE));
			$amar = str_replace("&nbsp;", " ", $amar);
			
			if(strlen($amar)<50){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Amar Putusan Tidak Boleh kurang dari 50 Karakter'));
				return;
			}

			$data_putusan = array(
				'perkara_id' => $idperkara,
				'tanggal_putusan' => $tgl_putusan,
				'status_putusan_id' => 91,
				'amar_putusan' => $amar,
				'catatan_putusan' => $this->input->post('keterangan'),
				'tanggal_bht' => $tgl_putusan,
				'diinput_oleh' => $this->session->userdata('username'),
				'diinput_tanggal' => date("Y-m-d h:i:s",time()),

			);

			$namahalaman=$this->input->post('namahalaman',TRUE);
			$query = $this->putusan->add_putusan_diversi($idperkara,$data_putusan,$namahalaman,'INSERT');			

			$this->load->model('riwayatperkara/riwayat_perkara_m');
			$this->riwayat_perkara_m->updateproses($idperkara,'213',$tgl_putusan,'',$namahalaman,'1');
			
			if($query==1){
				echo json_encode(array('st'=>1,'msg'=>' Data Putusan Berhasil Disimpan'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>' Data Putusan Tidak Berhasil Disimpan'));
				return;
			}
		}
	}


	function validateInput(){
		if(empty($_POST)){ show_404();
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		
		$alurperkara = $this->encrypt->decode(base64_decode($this->input->post('enc_alur',TRUE)));
		
		$this->form_validation->set_rules('amar_text', 'Amar Putusan', 'trim|required|xss_clean|min_length[50]');
		$this->form_validation->set_rules('tgl_putusan', 'Tanggal Putusan', 'trim|required|xss_clean|exact_length[10]');
		
		if($alurperkara<100 AND $alurperkara==119 AND $alurperkara==123){
			$this->form_validation->set_rules('status_putusan', 'Status Putusan', 'trim|required|xss_clean');
			$this->form_validation->set_rules('sumber_hukum', 'Sumber Hukum', 'trim|required|xss_clean');
			if($alurperkara!=10 AND $alurperkara!=11){
				$this->form_validation->set_rules('verstek', 'Apakah Putusan Verstek', 'trim|required|xss_clean');
			}			
		}

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			if(!is_numeric($idperkara) OR intval($idperkara) <1){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Perkara Tidak Diketahui.'));
				return;
			}
			$this->load->model('putusan/data_putusan_akhir','putusan');
            $this->load->model('perkara/info_perkara_agama','agama');
            $is_islam_ikrar=$this->agama->getInfoAgamaPeCT($idperkara);
			$date_sidang = $this->putusan->getSidangPertama($idperkara);
			$statusPutusan = intval($this->input->post('status_putusan',TRUE));
			$cekStatusPutusanTerdakwa = $this->putusan->getStatusPutusanTerdakwa($idperkara);
			if($alurperkara==120 AND $cekStatusPutusanTerdakwa==90){
				$statusPutusan = 90;
			}

			if(empty($date_sidang)  AND $statusPutusan!=7 AND $statusPutusan!=37 AND $statusPutusan!=67 AND $cekStatusPutusanTerdakwa!=79 AND $cekStatusPutusanTerdakwa!=80 AND $cekStatusPutusanTerdakwa!=81 AND $cekStatusPutusanTerdakwa!=82 AND $cekStatusPutusanTerdakwa!=83 AND $cekStatusPutusanTerdakwa!=90){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memasukan Data Putusan. Jadwal Sidang Pertama Masih Kosong.'));
				return;
			}
			
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');
			

			## Validasi Tanggal Putusan
			$tgl_putusan = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_putusan',TRUE));
			
			$selisih = $this->tanggalhelper->getSelisihHari($tgl_putusan,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Putusan Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($date_sidang,$tgl_putusan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Putusan Tidak Boleh Kurang dari Tanggal Sidang Terakhir ('.$this->tanggalhelper->convertDayDate($date_sidang).').'));
				return;
			}			

			if($alurperkara>100 AND $alurperkara!=119 AND $alurperkara!=123){
				$tglPutusanTerdakwa = $this->putusan->getTanggalMinPutusanTerdakwa($idperkara);
				if(empty($tglPutusanTerdakwa)){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Putusan Terdakwa Dan Vonis Terhadap Terdakwa Belum Diisikan.'));
					return;
				}
				if($tglPutusanTerdakwa!=(string)$tgl_putusan){
					$tglPutusanTerdakwa = $this->tanggalhelper->convertToInputDate($tglPutusanTerdakwa);
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Putusan Sekurang Kurangnya Harus Sama Dengan Tanggal Putusan Terdakwa Yang Telah Diputus Pertama.'.$tglPutusanTerdakwa));
					return;
				}
				
			}
			$dayname = $this->tanggalhelper->getDayName($tgl_putusan);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Putusan Dihari Libur, Sabtu dan Minggu.'));
				return;
			}
			$amar = trim($this->input->post('amar_text',TRUE));
			$amar = str_replace("&nbsp;", " ", $amar);
			//$amar=mysql_real_escape_string($amar);
			
			if(strlen($amar)<50){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Amar Putusan Tidak Boleh kurang dari 50 Karakter'));
				return;
			}

			
			$data_putusan = array(
				'perkara_id' => $idperkara,
				'tanggal_putusan' => $tgl_putusan,
				'status_putusan_id' => $statusPutusan,
				'amar_putusan' => $amar,
				'catatan_putusan' => $this->input->post('keterangan',TRUE)
			);
			if($alurperkara<100){
				$nilai_ganti_kerugian = trim($this->input->post('nilai_ganti_sengketa',TRUE));
				$nilai_ganti_kerugian = str_replace('.','',$nilai_ganti_kerugian);
				if(!empty($nilai_ganti_kerugian)){
					$data_putusan['nilai_ganti_kerugian'] = $nilai_ganti_kerugian;
				}
				if(empty($statusPutusan) OR intval($statusPutusan)<1){
					if($statusPutusan==-1){
						echo json_encode(array('st'=>0,'msg'=>'Error <br> Status Putusan Wajib Dipilih.'));
						return;
					}
					echo json_encode(array('st'=>0,'msg'=>'Error <br> Status Putusan Tidak Valid.'));
					return;
				}

					$sumberHukum = implode(',',$this->input->post('sumber_hukum',TRUE));
					if(empty($sumberHukum)){
						if(strlen($sumberHukum)<0){
							echo json_encode(array('st'=>0,'msg'=>'Error <br> Sumber Hukum Wajib Dipilih.'));
							return;
						}
						echo json_encode(array('st'=>0,'msg'=>'Error <br> Sumber Hukum Tidak Valid.'));
						return;
					}
					$data_putusan['sumber_hukum_id'] = $sumberHukum;
				if($statusPutusan!= 5 AND $statusPutusan !=6 AND $statusPutusan!=7){					
					if($alurperkara!=9 AND $alurperkara!=2 AND $alurperkara!=10 AND $alurperkara!=11){
						$verstek = $this->input->post('verstek',TRUE);
						if(empty($verstek) OR ($verstek!='Y' AND $verstek!='T')){
							echo json_encode(array('st'=>0,'msg'=>'Error <br> Status Verstek Tidak Valid.'));
							return;
						}
						$data_putusan['putusan_verstek'] = $verstek;
					}
				}elseif($statusPutusan==5 OR $statusPutusan==6 OR $statusPutusan==7){
					$data_putusan['putusan_verstek'] = NULL;
				}
				if($alurperkara==15 AND $statusPutusan ==62 AND ($this->tanggalhelper->getIDJenisPerkara($idperkara)==347 OR $this->tanggalhelper->getIDJenisPerkara($idperkara)==346)){
					$faktor_percerian = $this->input->post('faktor_cerai',TRUE);
					if(intval($faktor_percerian)<1){
						echo json_encode(array('st'=>0,'msg'=>'Error <br> Faktor Penyebab Percerian Wajib Dipilih.'));
						return;
					}
				}

				if($alurperkara==15 AND $statusPutusan ==62 AND ($this->tanggalhelper->getIDJenisPerkara($idperkara)==347 or ($this->tanggalhelper->getIDJenisPerkara($idperkara)==346 and
                            $is_islam_ikrar>1) )){ // and $statusPutusan ==62
					$keadaan_istri = $this->input->post('keadaan_istri',TRUE);
					if(intval($keadaan_istri)<1){
						echo json_encode(array('st'=>0,'msg'=>'Error <br> Keadaan Istri Wajib Dipilih.'));
						return;
					}
				}
				
				if($alurperkara==3){
					$tglPenHakim = $this->input->post('tgl_penetapan_pengawas',TRUE);
					$tglPenHakim = $this->tanggalhelper->convertToMysqlDate($tglPenHakim);
					$dayname = $this->tanggalhelper->getDayName($tglPenHakim);
					if($dayname=='Saturday' OR $dayname=='Sunday'){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penetapan Hakim Dihari Libur, Sabtu dan Minggu.'));
						return;
					}
					$selisih = $this->tanggalhelper->getSelisihHari($tgl_putusan,$tglPenHakim);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Hakim Tidak Boleh Kurang dari Tanggal Putusan.'));
						return;
					}
					$data_putusan['penetapan_hakim_pengawas'] = $tglPenHakim;

					$idhakim = $this->encrypt->decode(base64_decode($this->input->post('hakim_pengawas',TRUE)));
					if(empty($idhakim) OR intval($idhakim)<1){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Pengawas Belum Dipilih.'));
						return;
					}
					$data_putusan['hakim_pengawas_id'] = $idhakim;
					/* disable sementara karena tidak ada contoh kurator
					$idkurator = $this->encrypt->decode(base64_decode($this->input->post('kurator',TRUE)));
					if(empty($idkurator) OR intval($idkurator)<1){
						echo json_encode(array('st'=>0,'msg'=>'Kurator Belum Dipilih.'));
						return;
					}
					$data_putusan['kurator_id'] = $idkurator;
					*/
					$tglPengumumanBeritaRI = $this->input->post('tgl_berita',TRUE);
					if(!empty($tglPengumumanBeritaRI)){
						$tglPengumumanBeritaRI = $this->tanggalhelper->convertToMysqlDate($tglPengumumanBeritaRI);
						$dayname = $this->tanggalhelper->getDayName($tglPengumumanBeritaRI);
						if($dayname=='Saturday' OR $dayname=='Sunday'){
							echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pengumuman Dalam Berita RI Dihari Libur, Sabtu dan Minggu.'));
							return;
						}

						$selisih = $this->tanggalhelper->getSelisihHari($tgl_putusan,$tglPengumumanBeritaRI);
						if($selisih<0){
							echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pengumuman Dalam Berita RI Tidak Boleh Kurang dari Tanggal Putusan.'));
							return;
						}

						$data_putusan['tanggal_berita_putusan'] = $tglPengumumanBeritaRI;
					}

					$tglPengumumanSuratKabarRI = $this->input->post('tgl_surat_kabar',TRUE);
					if(!empty($tglPengumumanSuratKabarRI)){
						$tglPengumumanSuratKabarRI = $this->tanggalhelper->convertToMysqlDate($tglPengumumanSuratKabarRI);
						$dayname = $this->tanggalhelper->getDayName($tglPengumumanSuratKabarRI);
						if($dayname=='Saturday' OR $dayname=='Sunday'){
							echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pengumuman Dalam Surat Kabar Dihari Libur, Sabtu dan Minggu.'));
							return;
						}

						$selisih = $this->tanggalhelper->getSelisihHari($tgl_putusan,$tglPengumumanSuratKabarRI);
						if($selisih<0){
							echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pengumuman Dalam Surat Kabar Tidak Boleh Kurang dari Tanggal Putusan.'));
							return;
						}
						$data_putusan['tanggal_surat_kabar_putusan'] = $tglPengumumanSuratKabarRI;
					}

					$namaSuratKabar = $this->input->post('nama_surat_kabar',TRUE);
					if(!empty($tglPengumumanSuratKabarRI)){
						$data_putusan['nama_surat_kabar_putusan'] = $namaSuratKabar;
					}
				}
			}
			#04062016
			if($alurperkara==114){
				$verstek = $this->input->post('verstek',TRUE);
				$data_putusan['putusan_verstek'] = $verstek;
			}#end
			$act = $this->encrypt->decode(base64_decode($this->input->post('act',TRUE)));
			if($act=='update'){
				$dt = $this->putusan->getTimestamp($idperkara);
				if($dt->num_rows>0){
					foreach ($dt->result() as $row) {
						$data_putusan['diinput_oleh'] = $row->diinput_oleh;
						$data_putusan['diinput_tanggal'] = $row->diinput_tanggal;
					}
				}
				$data_putusan['diperbaharui_oleh'] = $this->session->userdata('username');
				$data_putusan['diperbaharui_tanggal'] = date("Y-m-d h:i:s",time());
			}elseif($act=='tambah'){
				$data_putusan['diinput_oleh'] = $this->session->userdata('username');
				$data_putusan['diinput_tanggal'] = date("Y-m-d h:i:s",time());
				$ada_enggak_ptsan = $this->db->query("SELECT amar_putusan FROM perkara_putusan WHERE perkara_id=".$idperkara)->result();
				if(!empty($ada_enggak_ptsan[0]->amar_putusan)){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Data Putusan Sudah Ada, tidak bisa menyimpan data.'));
						return;
				}
			}
			

			$addData = $this->putusan->add($data_putusan,$act);			
			$ada_faktor_perceraian = $this->putusan->getInfoPenyebabCerai($idperkara);
			
			if($addData==TRUE){
				if($alurperkara==15 AND $statusPutusan ==62 AND ($this->tanggalhelper->getIDJenisPerkara($idperkara)==347 OR $this->tanggalhelper->getIDJenisPerkara($idperkara)==346)){					
					if($ada_faktor_perceraian==0 AND $act=='update')
						$addData == $this->putusan->addFaktorPenyebab($faktor_percerian,$idperkara,$statusPutusan);					
					elseif($ada_faktor_perceraian==0 AND $act=='tambah')
						$addData == $this->putusan->addFaktorPenyebab($faktor_percerian,$idperkara,$statusPutusan);
					elseif ($ada_faktor_perceraian==1 AND $act=='update') {
						$addData == $this->putusan->updateFaktorPenyebab($faktor_percerian,$idperkara,$statusPutusan);
					}
				}


				if($alurperkara==15 AND $statusPutusan ==62 AND ($this->tanggalhelper->getIDJenisPerkara($idperkara)==347 or ($this->tanggalhelper->getIDJenisPerkara($idperkara)==346 and
                            $is_islam_ikrar>1))){

					if($act=='tambah')
						$addData == $this->putusan->updateKeadaanIstri($keadaan_istri,$idperkara);
					elseif ($act=='update') {
						$addData == $this->putusan->updateKeadaanIstri($keadaan_istri,$idperkara);
					}
				}
				if($addData==TRUE){
					echo json_encode(array('st'=>1,'msg'=>' Data Putusan Berhasil Disimpan'));
					return;
				}else{
					echo json_encode(array('st'=>0,'msg'=>' Data Putusan Tidak Berhasil Disimpan'));
					return;
				}
			}else{
				echo json_encode(array('st'=>0,'msg'=>' Data Putusan Tidak Berhasil Disimpan'));
				return;
			}
		}
	}

	function validateInputPemberitahuan(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$act = $this->encrypt->decode(base64_decode($this->input->post('act',TRUE)));
		$alurperkara = $this->encrypt->decode(base64_decode($this->input->post('enc_alur',TRUE)));
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara) <1){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Perkara Tidak Diketahui.'));
			return;
		}	
		$this->load->model('putusan/data_putusan_akhir','putusan');
		
		$jenis_perkara= $this->putusan->getPerkara($idperkara);
			if (!empty($jenis_perkara)){
				if ($jenis_perkara->num_rows>0){
					foreach ($jenis_perkara->result() as $row) {
							$jenis_perkara_id=$row->jenis_perkara_id;
					}	
				}
			}
		
		$pihak_pertama = $this->putusan->getPihak($idperkara,1);		
		if($alurperkara!=114){
			$pemberitahuan_pihak_pertama = '';
			$data_salin_pihak_pertam = '';
			if($pihak_pertama !=''){
				if($pihak_pertama->num_rows>0){
					$i = 0;
					foreach ($pihak_pertama->result() as $row) {
						$tglpemberitahuan = $this->input->post('pem_pihak_1_'.$row->id,TRUE);
						if(!empty($tglpemberitahuan)){
							$tanggal_pemberitahuan = $this->tanggalhelper->convertToMysqlDate($tglpemberitahuan);
						}else{
							$tanggal_pemberitahuan = NULL;
						}
						$data_pihak_pertama = array(
							'perkara_id' =>$idperkara,
							'putusan_akhir' =>2,
							'pihak' => 1,
							'nama' => $row->nama,
							'pihak_id' => $row->id,
							'tanggal_pemberitahuan_putusan' => $tanggal_pemberitahuan
						);							
						if($alurperkara>100){
							$tgl_menerima_pts = $this->tanggalhelper->convertToMysqlDate($this->input->post('terima_pihak_1_'.$row->id,TRUE));
							if(!empty($tgl_menerima_pts)){
								$tanggal_menerima_pts = $tgl_menerima_pts;
							}else{
								$tanggal_menerima_pts = NULL;
							}
							$tgl_menerima_salinan = $this->tanggalhelper->convertToMysqlDate($this->input->post('salin_pihak_1_'.$row->id,TRUE));
							if(!empty($tgl_menerima_salinan)){
								$tanggal_menerima_salinan = $tgl_menerima_salinan;
							}else{
								$tanggal_menerima_salinan = NULL;
							}
							$data_pihak_pertama['tanggal_menerima_putusan'] = $tanggal_menerima_pts;
							$data_pihak_pertama['tanggal_kirim_salinan_putusan'] = $tanggal_menerima_salinan;
						}
						$pemberitahuan_pihak_pertama[$i] =$data_pihak_pertama;													
						$i++;
					}
				}else{
					echo json_encode(array('st'=>0,'msg'=>'Error <br> Data Pihak Tidak Ditemukan.'));
					return;
				}
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Error <br> Data Pihak Tidak Ditemukan.'));
				return;
			}
		}		
		
		$pihak_kedua = $this->putusan->getPihak($idperkara,2);
		$pemberitahuan_pihak_kedua ="";
		$kirim_salin_pihak_kedua = '';
		if($pihak_kedua !=''){
			if($pihak_kedua->num_rows>0 OR ($alurperkara==10 AND $jenis_perkara_id==334)){
				$i = 0;
				foreach ($pihak_kedua->result() as $row) {
					$tglpemberitahuan = $this->input->post('pem_pihak_2_'.$row->id,TRUE);
					if(!empty($tglpemberitahuan)){
						$tanggal_pemberitahuan = $this->tanggalhelper->convertToMysqlDate($tglpemberitahuan);
					}else{
						$tanggal_pemberitahuan = NULL;
					}					
					$data_pihak_kedua = array(
						'perkara_id' =>$idperkara,
						'putusan_akhir' =>2,
						'pihak' => 2,
						'nama' => $row->nama,
						'pihak_id' => $row->id,
						'tanggal_pemberitahuan_putusan' => $tanggal_pemberitahuan
					);
					if($alurperkara>100){
						$tgl_menerima_pts = $this->tanggalhelper->convertToMysqlDate($this->input->post('terima_pihak_2_'.$row->id,TRUE));
						if(!empty($tgl_menerima_pts)){
							$tanggal_menerima_pts = $tgl_menerima_pts;
						}else{
							$tanggal_menerima_pts = NULL;
						}
						$tgl_menerima_salinan = $this->tanggalhelper->convertToMysqlDate($this->input->post('salin_pihak_2_'.$row->id,TRUE));
						if(!empty($tgl_menerima_salinan)){
							$tanggal_menerima_salinan = $tgl_menerima_salinan;
						}else{
							$tanggal_menerima_salinan = NULL;
						}
						$data_pihak_kedua['tanggal_menerima_putusan'] = $tanggal_menerima_pts;
						$data_pihak_kedua['tanggal_kirim_salinan_putusan'] = $tanggal_menerima_salinan;
					}
					$pemberitahuan_pihak_kedua[$i] = $data_pihak_kedua;
					$i++;
				}
			}elseif($alurperkara!=2 AND $alurperkara!=16){
				echo json_encode(array('st'=>0,'msg'=>'Error <br> Data Pihak Tidak Ditemukan.'));
				return;
			}
		}elseif($alurperkara!=2 AND $alurperkara!=16){
			echo json_encode(array('st'=>0,'msg'=>'Error <br> Data Pihak Tidak Ditemukan.'));
			return;
		}
		
		if($alurperkara<100){
			if($alurperkara!=2){
				$pihak_ketiga = $this->putusan->getPihak($idperkara,3);
				$pemberitahuan_pihak_ketiga ="";
				if($pihak_ketiga !=''){
					if($pihak_ketiga->num_rows>0){
						$i = 0;
						foreach ($pihak_ketiga->result() as $row) {
							$tglpemberitahuan = $this->input->post('pem_pihak_3_'.$row->id,TRUE);
							if(!empty($tglpemberitahuan)){
								$data_pihak_ketiga = array(
									'perkara_id' =>$idperkara,
									'putusan_akhir' =>2,
									'pihak' => 3,
									'nama' => $row->nama,
									'pihak_id' => $row->id,
									'tanggal_pemberitahuan_putusan' => $this->tanggalhelper->convertToMysqlDate($tglpemberitahuan)
								);
									
								$pemberitahuan_pihak_ketiga[$i] = $data_pihak_ketiga;
								$i++;
							}
						}
					}
				}
				$pihak_keempat = $this->putusan->getPihak($idperkara,4);
				$pemberitahuan_pihak_keempat ="";
				if($pihak_keempat !=''){
					if($pihak_keempat->num_rows>0){
						$i = 0;
						foreach ($pihak_keempat->result() as $row) {
							$tglpemberitahuan = $this->input->post('pem_pihak_4_'.$row->id,TRUE);
							if(!empty($tglpemberitahuan)){
								$data_pihak_keempat = array(
									'perkara_id' =>$idperkara,
									'putusan_akhir' =>2,
									'pihak' => 4,
									'nama' => $row->nama,
									'pihak_id' => $row->id,
									'tanggal_pemberitahuan_putusan' => $this->tanggalhelper->convertToMysqlDate($tglpemberitahuan)
								);
									
								$pemberitahuan_pihak_keempat[$i] = $data_pihak_keempat;
								$i++;
							}
						}
					}
				}
			}
		}else{
			$continue = True;
			if($alurperkara>100 AND $alurperkara<=122 AND $alurperkara!=119 AND $alurperkara!=123 ){
				$list_terdakwa = $this->putusan->getPutusanTerdakwa($idperkara);
			}else if($alurperkara==119 OR $alurperkara==123){			
				$list_terdakwa = $this->putusan->getDataPutusanAkhir($idperkara);
			}
			if($list_terdakwa !=''){
				if($list_terdakwa->num_rows>0){
					foreach ($list_terdakwa->result() as $row) {
						if(empty($row->tanggal_putusan)){							
							$continue = False;
						}
					}
				}else{
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br>Terdakwa Tidak Ditemukan.'));
					return;
				}
			}else{
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br>Terdakwa Tidak Ditemukan.'));
				return;
			}
            if($alurperkara!=118){
				if($continue == False){
					echo json_encode(array('st'=>0,'msg'=>'Status Putusan Terdakwa Masih Kosong. Mohon Mengisikan Status Putusan Terdakwa.'));
					return;
				}
            }
		}
			
		$curr_date = date('Y-m-d');
		$todayDate = date('d/m/Y');

		$tglMinut = $this->input->post('tgl_minutasi',TRUE);
		$tgl_putusan = $this->tanggalhelper->getTanggalPutusan($idperkara);
		$data_putusan = array(
			'perkara_id' => $idperkara,
			'catatan_putusan' => $this->input->post('keterangan'),
			'diperbaharui_oleh' => $this->session->userdata('username'),
			'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
		);

		if($alurperkara==120||$alurperkara==121){
			$data_putusan['pemberitahuan_putusan_ankum'] = $this->tanggalhelper->convertToMysqlDate($this->input->post('tglANKUM',TRUE));
			$data_putusan['pemberitahuan_putusan_pepera'] =  $this->tanggalhelper->convertToMysqlDate($this->input->post('tglPEPERA',TRUE));
		}

		if($this->session->userdata('idgroup')!=600){
			if(!empty($tglMinut)){
				$status_putusan_id = $this->putusan->getStatusPutusanAkhir($idperkara);
				$tgl_minutasi = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_minutasi',TRUE));
				$dayname = $this->tanggalhelper->getDayName($tgl_minutasi);
				if($dayname=='Saturday' OR $dayname=='Sunday'){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Minutasi Dihari Libur, Sabtu dan Minggu.'));
					return;
				}
				$selisih = $this->tanggalhelper->getSelisihHari($tgl_minutasi,$curr_date);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Minutasi Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
					return;
				}
				$date_sidang = $this->putusan->getTanggalSidangPertama($idperkara);
				$selisih = $this->tanggalhelper->getSelisihHari($date_sidang,$tgl_minutasi);
				$status_putusan_id = $this->putusan->ambilStatusPutusanID($idperkara);			
				if($status_putusan_id!=7 AND $status_putusan_id!=37 AND $status_putusan_id!=67 AND $status_putusan_id!=79 AND $status_putusan_id!=80 AND $status_putusan_id!=81 AND $status_putusan_id!=82 AND $status_putusan_id!=83){
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Minutasi Tidak Boleh Kurang dari Tanggal Sidang Pertama.'));
						return;
					}
				}

				$selisih = $this->tanggalhelper->getSelisihHari($tgl_putusan,$tgl_minutasi);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Minutasi Tidak Boleh Kurang dari Tanggal Putusan.'));
					return;
				}

				$cekProdeo = $this->putusan->isProdeo($idperkara);
				$isProdeo = $cekProdeo->row()->prodeo;
				if($alurperkara<100 AND $isProdeo==0 AND $status_putusan_id!=6 AND $status_putusan_id!=38 AND $status_putusan_id!=65){
					$hasRedaksiMaterai = $this->putusan->hasBiayaRedaksi($idperkara);
					if(!$hasRedaksiMaterai){
						echo json_encode(array('st'=>0,'msg'=>'<b><strong>Peringatan:</strong></b><br /> Biaya Redaksi dan Materai Belum Dimasukan.'));
						return;
					}
				}
				$jenis_pengadilan = $this->session->userdata('jenis_pengadilan');
				if($jenis_pengadilan>1){
					$tgl_pendaftaran = $this->tanggalhelper->getTanggalPendaftaran($idperkara);
					$selisih = $this->tanggalhelper->getSelisihHari($tgl_minutasi,'2016-01-01');
					if($selisih>0){
						$petitumDakwaan = $this->putusan->getPetitumDakwaan($idperkara,$alurperkara);
						if(empty($petitumDakwaan) OR strlen($petitumDakwaan)<50){
							$msge = ($alurperkara<100)? 'Petitum':'Dakwaan';
							echo json_encode(array('st'=>0,'msg'=>'<b><strong>Peringatan:</strong></b><br /> Tolong Lengkapi '.$msge.' Terlebih Dahulu.'));
							return;
						}
						$jenisperkara = $this->tanggalhelper->getIDJenisPerkara($idperkara);
						if($jenisperkara==346 OR $jenisperkara==347){
							$aktanikah = $this->putusan->getDataAktaNikah($idperkara);
							if(!empty($aktanikah)){
								if($aktanikah->num_rows>0){
									foreach ($aktanikah->result() as $row) {
										if(empty($row->tgl_nikah)){
											echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Data Tanggal Pernikahan Belum Dilengkapi.'));
											return;
										}
										if(empty($row->tgl_kutipan_akta_nikah)){
											echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Data Tanggal Kutipan Akta Pernikahan Belum Dilengkapi.'));
											return;
										}
										if(empty($row->no_kutipan_akta_nikah)){
											echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Data Nomor Kutipan Akta Pernikahan Belum Dilengkapi.'));
											return;
										}
										if(empty($row->kua_tempat_nikah)){
											echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Data KUA Penerbit Buku Nikah Belum Dilengkapi.'));
											return;
										}
									}
								}
							}else{
								echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Data Pernikahan Belum Dilengkapi.'));
								return;
							}
						}
					}
				}
				
				$data_putusan['tanggal_minutasi'] = $tgl_minutasi;
			}else{
				$data_putusan['tanggal_minutasi'] = NULL;
			}
		}
			
		if($alurperkara>100){
			$tglKirimPenyidik = $this->input->post('tgl_kirim_salinan_penyidik',TRUE);
			if(!empty($tglKirimPenyidik)){
				$tglKirimPenyidik = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_kirim_salinan_penyidik',TRUE));
				$dayname = $this->tanggalhelper->getDayName($tglKirimPenyidik);
				if($dayname=='Saturday' OR $dayname=='Sunday'){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Kirim Salinan Kepada Penyidik Dihari Libur, Sabtu dan Minggu.'));
					return;
				}
				$selisih = $this->tanggalhelper->getSelisihHari($tglKirimPenyidik,$curr_date);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Kirim Salinan Kepada Penyidik Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
					return;
				}
				$selisih = $this->tanggalhelper->getSelisihHari($date_sidang,$tglKirimPenyidik);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Kirim Salinan Kepada Penyidik Tidak Boleh Kurang dari Tanggal Sidang Pertama.'));
					return;
				}

				$selisih = $this->tanggalhelper->getSelisihHari($tgl_putusan,$tglKirimPenyidik);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Kirim Salinan Kepada Penyidik Tidak Boleh Kurang dari Tanggal Putusan.'));
					return;
				}				
				$data_putusan['kirim_salinan_putusan_penyidik'] = $tglKirimPenyidik;
			}else{
				$data_putusan['kirim_salinan_putusan_penyidik'] = NULL;
			}
		}
		$validate = TRUE;
		if(!empty($pemberitahuan_pihak_pertama)){
			$validate = $this->validateTanggalInput($pemberitahuan_pihak_pertama,$alurperkara,$tglMinut,$tgl_putusan);
			if($validate==FALSE){
				return;
			}
		}

		if(!empty($pemberitahuan_pihak_kedua)){
			$validate = $this->validateTanggalInput($pemberitahuan_pihak_kedua,$alurperkara,$tglMinut,$tgl_putusan);
			if($validate==FALSE){
				return;
			}
		}		
		
		if($alurperkara<100){
			if(!empty($pemberitahuan_pihak_ketiga)){
				$validate = $this->validateTanggalInput($pemberitahuan_pihak_ketiga,$alurperkara,$tglMinut,$tgl_putusan);
				if($validate==FALSE){
					return;
				}
			}	
			if(!empty($pemberitahuan_pihak_keempat)){
				$validate = $this->validateTanggalInput($pemberitahuan_pihak_keempat,$alurperkara,$tglMinut,$tgl_putusan);
				if($validate==FALSE){
					return;
				}
			}
		}
		$status=TRUE;
		$isEmpty = TRUE;
		$addData = $this->putusan->updateDataPemberitahuan($data_putusan,$idperkara);
		if($addData==TRUE){
			$isEmpty = TRUE;
			if(!empty($pemberitahuan_pihak_pertama) AND count($pemberitahuan_pihak_pertama)>0){
				foreach ($pemberitahuan_pihak_pertama as $data){
					unset($data['nama']);
					$addData = $this->putusan->addPemberitahuan($data,$act);
					if($addData==TRUE){
						$status = TRUE;
					}else{
						$status = FALSE;
					}
					if(!empty($data['tanggal_pemberitahuan_putusan'])||!empty($data['tanggal_kirim_salinan_putusan'])){
						$isEmpty = FALSE;
					}
				}
			}
			if(!empty($pemberitahuan_pihak_kedua) AND count($pemberitahuan_pihak_kedua)>0){
				foreach ($pemberitahuan_pihak_kedua as $data){
					unset($data['nama']);
					$addData = $this->putusan->addPemberitahuan($data,$act);
					if($addData==TRUE){
						$status = TRUE;
					}else{
						$status = FALSE;
					}
					if(!empty($data['tanggal_pemberitahuan_putusan'])||!empty($data['tanggal_kirim_salinan_putusan'])){
						$isEmpty = FALSE;
					}
				}
			}			

			if($alurperkara<100){
				if(!empty($pemberitahuan_pihak_ketiga) AND count($pemberitahuan_pihak_ketiga)>0){
					foreach ($pemberitahuan_pihak_ketiga as $data){
						unset($data['nama']);
						$addData = $this->putusan->addPemberitahuan($data,$act);
						if($addData==TRUE){
							$status = TRUE;
						}else{
							$status = FALSE;
						}
						if(!empty($data['tanggal_pemberitahuan_putusan'])){
							$isEmpty = FALSE;
						}
					}
				}
				if(!empty($pemberitahuan_pihak_keempat) AND count($pemberitahuan_pihak_keempat)>0){
					foreach ($pemberitahuan_pihak_keempat as $data){
						unset($data['nama']);
						$addData = $this->putusan->addPemberitahuan($data,$act);
						if($addData==TRUE){
							$status = TRUE;
						}else{
							$status = FALSE;
						}
						if(!empty($data['tanggal_pemberitahuan_putusan'])){
							$isEmpty = FALSE;
						}
					}
				}				
			}			
			if($this->session->userdata('idgroup')!=600){
				if(!empty($data_putusan['tanggal_minutasi']))
					$isEmpty = FALSE;
				if($isEmpty==TRUE){
					$this->putusan->deletePerkaraProses($idperkara);
				}
			}
			if($status==TRUE){
				echo json_encode(array('st'=>1,'msg'=>' Data Berhasil Disimpan'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>' Data Tidak Berhasil Disimpan'));
				return;
			}
		}else{
			echo json_encode(array('st'=>0,'msg'=>' Data Tidak Berhasil Disimpan'));
			return;
		}
	}

	function validateTanggalInput($data,$alurperkara,$tglMinut,$tgl_putusan){
		$curr_date = date('Y-m-d');
		$todayDate = date('d/m/Y');
		foreach ($data as $info){
				if(!empty($info['tanggal_pemberitahuan_putusan'])){
					
					$dayname = $this->tanggalhelper->getDayName($info['tanggal_pemberitahuan_putusan']);
					if($dayname=='Saturday' OR $dayname=='Sunday'){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pemberitahuan Putusan Dihari Libur, Sabtu dan Minggu.'));
						return;
					}

					$selisih = $this->tanggalhelper->getSelisihHari($info['tanggal_pemberitahuan_putusan'],$curr_date);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Putusan Kepada '.$info['nama'].', Tidak Boleh Lebih Dari Tanggal Hari ini. Tanggal Hari ini, '.$todayDate));
						return FALSE;
					}
					
					$selisih = $this->tanggalhelper->getSelisihHari($tgl_putusan,$info['tanggal_pemberitahuan_putusan']);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Putusan Kepada '.$info['nama'].', Tidak Boleh Kurang dari Tanggal Putusan.'));
						return FALSE;
					}	
				}
				if($alurperkara>100){
					if(!empty($info['tanggal_menerima_putusan'])){
						if(empty($info['tanggal_pemberitahuan_putusan'])){
							echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tgl. Menerima Putusan Sudah Terisi Tetapi Tgl. Pemberitahuan Putusan Masih Kosong.'));
							return FALSE;
						}
						
						$dayname = $this->tanggalhelper->getDayName($info['tanggal_menerima_putusan']);
						if($dayname=='Saturday' OR $dayname=='Sunday'){
							echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Menerima Putusan Dihari Libur, Sabtu dan Minggu.'));
							return;
						}

						$selisih = $this->tanggalhelper->getSelisihHari($info['tanggal_menerima_putusan'],$curr_date);
						if($selisih<0){
							echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Menerima Putusan Kepada '.$info['nama'].', Tidak Boleh Lebih Dari Tanggal Hari ini. Tanggal Hari ini, '.$todayDate));
							return FALSE;
						}
							
						$selisih = $this->tanggalhelper->getSelisihHari($tgl_putusan,$info['tanggal_menerima_putusan']);
						if($selisih<0){
							echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Menerima Putusan Oleh '.$info['nama'].', Tidak Boleh Kurang dari Tanggal Putusan.'));
							return FALSE;
						}
					}

					if(!empty($info['tanggal_kirim_salinan_putusan'])){																		
						$dayname = $this->tanggalhelper->getDayName($info['tanggal_kirim_salinan_putusan']);
						if($dayname=='Saturday' OR $dayname=='Sunday'){
							echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Kirim Salinan Putusan Dihari Libur, Sabtu dan Minggu.'));
							return;
						}

						$selisih = $this->tanggalhelper->getSelisihHari($info['tanggal_kirim_salinan_putusan'],$curr_date);
						if($selisih<0){
							echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Kirim Putusan Kepada '.$info['nama'].', Tidak Boleh Lebih Dari Tanggal Hari ini. Hari ini Tanggal, '.$todayDate));
							return FALSE;
						}
						
						$selisih = $this->tanggalhelper->getSelisihHari($tgl_putusan,$info['tanggal_kirim_salinan_putusan']);
						if($selisih<0){
							echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Kirim Putusan Kepada '.$info['nama'].', Tidak Boleh Kurang dari Tanggal Putusan.'));
							return FALSE;
						}
					}
				}
				unset($info['nama']);
			}
			return TRUE;
	}

	function fetchTanggalPemberitahuan($data,$data_putusan,$alurperkara,$pihakke){
		foreach ($data as $info){
			if(!empty($info['tanggal_pemberitahuan_putusan'])){
				if($pihakke==1){
					$data_putusan['pemberitahuan_putusan'] = $info['tanggal_pemberitahuan_putusan'];
				}
				$data_putusan['pemberitahuan_putusan_pihak'.$pihakke] = $info['tanggal_pemberitahuan_putusan'];
			}
			if($alurperkara>100){
				if(!empty($info['tanggal_menerima_putusan'])){
					$data_putusan['menerima_putusan_pihak'.$pihakke] = $info['tanggal_menerima_putusan'];
				}
				if(!empty($info['tanggal_kirim_salinan_putusan'])){
					$data_putusan['kirim_salinan_putusan_pihak'.$pihakke] = $info['tanggal_kirim_salinan_putusan'];
				}
			}
			unset($info['nama']);
		}
		return $data_putusan;
	}

	function validateDelete(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$act = $this->encrypt->decode(base64_decode($this->input->post('act',TRUE)));
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(empty($idperkara) OR intval($idperkara)<1 OR !is_numeric($idperkara)){
			echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Something Bad Happen. Refresh Your Browser'));
			return;
		}
		if(($act=='update')||($act=='diversi')){
			// ===== Script ini disesuaikan dengan yang ada di fileupload_c =====
			$this->load->model('fileupload/fileupload_m');
			$idkirim=$idperkara;
			$from="put";
			$namadokumen=$this->fileupload_m->get_nama_dok($idkirim,$from);

			//check file and directory to delete
			$arrdirectory=explode('/',$namadokumen);
			array_pop($arrdirectory);
			$direktori=implode("/",$arrdirectory);
			$arrparentdirectory=explode('/',$direktori);
			array_pop($arrparentdirectory);
			$parentdirektori=implode("/",$arrparentdirectory);
			
			//delete the file
			@unlink($namadokumen);
			//delete the directories if empty. if at least one file inside, this script is passed automaticaly
			@rmdir($direktori); 
			@rmdir($parentdirektori); 

			// ===================================================================

			$this->load->model('putusan/data_putusan_akhir','putusan');
			$delete = $this->putusan->delData($idperkara);

			$namahalaman=$this->input->post('namahalaman',TRUE);
			$this->load->model('riwayatperkara/riwayat_perkara_m');
			$this->riwayat_perkara_m->updateproses($idperkara,'213','','',$namahalaman,'2');
			if($delete==TRUE){
				echo json_encode(array('st'=>1,'msg'=>'Data Putusan Berhasil Dihapus.'));
				return;
			}
			echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Data Putusan Tidak Berhasil Dihapus. Terjadi kesalahan pada DATABASE.'));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Something Bad Happen.'));
			return;
		}

	}
	function tambah_data($idperkara,$act){
		$data['error'] = FALSE;
		$data['error_message'] = '';

		if(!is_numeric($idperkara) OR intval($idperkara) <1){
			$data['error'] = TRUE;
			$data['error_message'] = '404';
		}
		$data['current_date'] = date('d/m/Y');
		$this->load->model('putusan/data_putusan_akhir','putusan');
		$data['act'] = base64_encode($this->encrypt->encode($act));
		$data['enc'] = $this->nativesession->get_flash_session('enc',TRUE);
		
		
		$alur_perkara = $this->putusan->getAlurPerkara($idperkara);
		$data['idalurperkara'] = $alur_perkara;
		$data['enc_alur'] = base64_encode($this->encrypt->encode($alur_perkara));
		
		if($alur_perkara<100 OR $alur_perkara==119 OR $alur_perkara==123){
			$data['status_putusan'] = $this->putusan->getDataStatusPutusan($alur_perkara);
			$data['sumber_hukum'] = $this->putusan->getDataSumberHukum();
			$data['sumber_hukum_tun'] = $this->putusan->getDataSumberHukumTun();
			if($alur_perkara==3){
				$data['hakim'] = $this->putusan->getListHakim();
				$data['kurator'] = $this->putusan->getListKurator();
			}
			$data['verstek'] = '';
			$data['sumber_hukum_put'] = '';
		}elseif($alur_perkara>100 AND $alur_perkara!=119 AND $alur_perkara!=123){
			$data['status_putusan'] = $this->putusan->getPutusanTerdakwa($idperkara);
		}

		$data['pihak_pertama'] = $this->putusan->getPihak($idperkara,1);
		$data['pihak_kedua'] = $this->putusan->getPihak($idperkara,2);
		$data['amar'] = '';
		$data['status_putusan_id'] = '';
		$data['tanggal_putusan'] = '';
		$data['amar'] = '';
		$data['status_putusan_id'] = '';
		$data['tgl_minutasi'] = '';
		$data['verstek'] = '';
		$data['sumber_hukum_put'] = '';
		$data['keterangan'] = '';
		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-','RemoveFormat','-', 'Blockquote',
					'-','JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '98%';
		$this->ckeditor->config['height'] = '250px';
		$this->load->vars($data);
		$this->load->view('putusan/edit_putusan_akhir');
	}

	 function upload(){
		 if(empty($_POST)){
			 show_404();
		 }

		 if($this->session->userdata('is_logged_in')===FALSE){
			 echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			 return;
		 }
		 $namafileori 	= $_FILES['edoc_putusan']['name'];
		 $idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc')));
		 $tgldaftar = $this->tanggalhelper->getTanggalPendaftaran($idperkara);
		 $nomor_perkara = $this->tanggalhelper->getNomorPerkara($idperkara);
		 $arr = explode("/", $nomor_perkara);

		 $splittgldaftar=explode("-",$tgldaftar);
		 $direktori="resources/file/doc/".$splittgldaftar[0]."/".$splittgldaftar[1]."/";
		 try {
			 chmod($direktori, 0777);
			 @mkdir($direktori,0777,true);
			 $extension	= pathinfo($namafileori);
			 $extension	= $extension['extension'];
			 $fileName 	= $arr[3]."_".$arr[2]."_".$arr[1]."_".$arr[0]."_Putusan_Akhir.".$extension;
			 $fileName = str_replace(' ', '_', $fileName);
			echo $fileName;
		 } catch (Exception $e) {
			 echo json_encode(array('st'=>0,'msg'=>'E-Doc TIDAK Berhasil Disimpan.'));
			 return;
		 }
		
		 $upload_config = array(
			 'upload_path' => $direktori,
			 'allowed_types' => 'pdf|doc|docx|rtf',
			 'max_size' => '10240',
			 'overwrite' => TRUE,
			 'file_name' =>$fileName);
		 $this->load->library('upload', $upload_config);

		 if (!$this->upload->do_upload('edoc_putusan')){
			 echo json_encode(array('st'=>0,'msg'=>'E-Doc Tidak Berhasil Disimpan. '.$this->upload->display_errors('<span>', '</span>')));
			 return;
		 }else{
			 $upload_data = $this->upload->data('edoc_putusan');
			 chmod($direktori, 0755);
			 $this->load->model('putusan/data_putusan_akhir','putusan');
			 $fileName 	= $arr[3]."_".$arr[2]."_".$arr[1]."_".$arr[0]."_Putusan_Akhir.".$extension;
			 $fileName = str_replace(' ', '_', $fileName);
			 echo $fileName;
			 $data = array('amar_putusan_dok' => $direktori.$fileName);
			 $this->putusan->updateEdoc($idperkara,$data);
			 echo json_encode(array('st'=>1,'msg'=>'DATA Berhasil Disimpan.'));
			 return;
		 }
	 }

	// function doDownload($param){
		// $idperkara = $this->encrypt->decode(base64_decode($param));
		// if(!is_numeric($idperkara) OR intval($idperkara)<1){
			// show_404();
			// exit();
		// }
		// $this->load->model('putusan/data_putusan_akhir','putusan');
		// $path = $this->putusan->getEdocPath($idperkara);
		// $tmp = explode("/", $path);
		// $filename = $tmp[5];
		// $this->load->helper('download');
		// $data = file_get_contents($path);
		// force_download($filename, $data);
	// }

	// function doDelete(){
		// $idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		// if(!is_numeric($idperkara) OR intval($idperkara)<1){
			// show_404();
			// exit();
		// }
		// $this->load->model('putusan/data_putusan_akhir','putusan');
		// $path = $this->putusan->getEdocPath($idperkara);
		// try {
			// @unlink($path);
			// $data = array('amar_putusan_dok' => NULL);
			// $this->putusan->updateEdoc($idperkara,$data);
			// echo json_encode(array('st'=>1,'msg'=>'Data Putusan Berhasil Dihapus'));
			// return;
		// } catch (Exception $e) {
			// echo json_encode(array('st'=>0,'msg'=>'Data Putusan Tidak Berhasil Dihapus'));
			// return;
		// }
	// }
}
/* End of file ManagePutusanAkhir.php */
/* Location: ./application/controllers/ManagePutusanAkhir.php */