<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class C_payment extends CI_Controller {
	public function __construct() {
        parent::__construct();
		// $this->load->model('api/m_delegasi','delegasi_api');
		// $this->load->model('delegasi/d_delegasi_m');
		$this->load->model('efiling/epayment','epayment');
    }
    function index() {

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}else{
			$this->dashboard_efiling();
			$this->nativesession->set_flash_session('url_requested',current_url());	
		}
	}

	function dashboard_efiling(){
		$data['previous'] = $this->nativesession->get_flash_session('url_requested');
		$data['epayment_blm_bayar']=$this->epayment->epayment_va(FALSE,0);
		$data['epayment_sudah_bayar']=$this->epayment->epayment_va(FALSE,1);
        $this->load->view('header');
        $this->load->view('efiling/list_epayment',$data);
        $this->load->view('footer');

	}

	function tambah_va(){	
		$data['tampil_alur'] = 	$this->epayment->tampil_alurperkara();		
		$this->load->view('efiling/add_va',$data);
	}

	function cari(){
		// tangkap variabel keyword dari URL		
		$keyword = $this->uri->segment(2);
		// $keyword = $this->input->post('nomor_perkara');

		// cari di database
		$data = $this->epayment->cari($keyword);

		// format keluaran di dalam array
		foreach($data->result() as $row)
		{
			$arr['query'] = $keyword;
			$arr['suggestions'][] = array(
				'value'	=>$row->nomor_perkara
			);
		}
		// minimal PHP 5.2
		echo json_encode($arr);
	}

	function fetchData(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Please Refresh Your Page'));
			return;
		}
		$nomorperkara = trim($this->input->post('val',TRUE));
		if(empty($nomorperkara)){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}		

		$data_pihak = $this->epayment->cari_data_pihak($nomorperkara);								
		
		if($data_pihak->num_rows()==0){
			echo json_encode(array('st'=>0,
				'status'=>1,
				'msg'=>'Error, PIHAK TIDAK DITEMUKAN'));
			return;
		}else{
			foreach ($data_pihak->result() as $row) {
				$perkara_id = base64_encode($this->encrypt->encode($row->perkara_id));
				$nama_alur = $row->nama_alur;
				$alur_perkara_id = $row->alur_perkara_id;
				$nama_pemohon = $row->nama;
				$email_pemohon = !empty($row->email)?$row->email:'-';
				$tlp_pemohon = !empty($row->telepon)?$row->telepon:'-';
			}
		}
				
		echo json_encode(array(
			'st'=>1,
			'enc_perkara_id'=>$perkara_id,
			'nama_alur'=>$nama_alur,
			'alur_perkara_id'=>$alur_perkara_id,
			'nama_pemohon'=>$nama_pemohon,
			'email_pemohon'=>$email_pemohon,
			'tlp_pemohon'=>$tlp_pemohon			
		));
		return;
	}

	function show_hasil_pencarian(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		
		// pencarian yang status bayar nya 0 (belum dibayarkan)
		// harus mengikutkan parameter status
		if(isset($_POST['status']) && $this->input->post('status',TRUE)==0){
			
			echo json_encode(array('st'=>0,'msg'=>'Undefined command.'));
			return;
			
		}else{
			//pencarian yang statusnya 1 (sudah dibayarkan)
			$search=$this->input->post('search',TRUE);
			if($search!=""){
				$cari_efiling_m=$this->epayment->epayment_va($search, 1);
				if($cari_efiling_m->num_rows()>0){
					$hslcari = "<div class='box'>
									<div class='box-header with-border'>
									<h3 class='box-title red'><strong>Hasil Pencarian ( List Panjar Yang Sudah Dibayar )</strong<small></small></h3>
									</div>";
					$hslcari .= "<div class='box-body'>
									  <table class='table table-bordered table-hover' style='font-size: 14px;'>
										<tr>
										  <th style='width: 3%;text-align:center'>No.</th>
										  <th style='width: 12%'>Tanggal Pembuatan</th>
										  <th style='width: 12%'>Tanggal Kedaluwarsa</th>
										  <th style='width: 17%'>Data Pihak</th>
										  <th style='width: 17%'>Nomor Virtual Account</th>
										  <th style='width: 10%'>Jumlah Panjar</th>
										  <th style='width: 5%'>Aksi</th>
										</tr>
										";
					$i=1;
					foreach ($cari_efiling_m->result() as $row) {				                    				
						$hslcari .="
						  <tr>
							<td>".$i."</td>
							<td>".$this->tanggalhelper->convertDayDate($row->tgl_rekam)."<br> Jam :".$row->jam_rekam."</td>
							<td>".$this->tanggalhelper->convertDayDate($row->tgl_hbs)."<br> Jam :".$row->jam_hbs."</td>
							<td>".$row->customer_name."<br> ".$row->email."<br> ".$row->telepon."</td>
							<td>".$row->va_id."</td>
							<td> Rp. ".number_format($row->nominal,2,',','.')."</td>
							<td><a href=\"'.base_url().'add_perdata_online/'.base64_encode($this->encrypt->encode($row->alur_perkara_id)).'/'.base64_encode($this->encrypt->encode(10)).'/'.base64_encode($this->encrypt->encode($row->epayment_id)).'/'.$row->nominal.'/0\" class=\"btn btn-success btn-sm\" href=\"#\"><i class=\"fa fa-send\"></i> Register </a></td>
						  </tr>";
						$i++;
					}         			
					$hslcari .= "</div>";
					$hslcari.= "</table>";
				}else{
					$hslcari = "";
				}

				echo json_encode(array('st'=>1,'hasil_cari'=>$hslcari));
				return;
			}else{
				echo json_encode(array('st'=>0));
				return;
			}
			
		}
		
		
	}

	function form_add_biaya(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();
		$enc = $this->uri->segment(2);
		$idperkara = $this->encrypt->decode(base64_decode($enc));
		if(empty($idperkara) OR intval($idperkara)<0){
			show_404();
		}
		$api = $this->uri->segment(3);
		$alur_perkara = $this->encrypt->decode(base64_decode($api));
		if(empty($alur_perkara) OR intval($alur_perkara)<0){
			show_404();
		}

		$tti = $this->uri->segment(4);
		$tahapan = $this->encrypt->decode(base64_decode($tti));
		if(empty($tahapan) OR intval($tahapan)<0){
			show_404();
		}

		$nominal = $this->uri->segment(5);
		$nmr_va = $this->uri->segment(6);		
		
		if($tahapan<20){
			$tahapan=10;
		}

		$this->tampil_form_add_biaya($idperkara,$alur_perkara,$tahapan,$nominal,$nmr_va);
	}

	function tampil_form_add_biaya($idperkara,$alur_perkara,$tahapan,$nominal,$nmr_va){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$data['idperkara']=base64_encode($this->encrypt->encode($idperkara));
		$data['alur_perkara']=base64_encode($this->encrypt->encode($alur_perkara));
		$data['tahapan']=base64_encode($this->encrypt->encode($tahapan));
		$data['thp']=$tahapan;
		$data['aksi']='';
		$data['idbiayaperkara']='';
		$data['id_kategori_biaya']=1;
		$data['id_jenis_biaya']=224;
		$data['pihak_ke']='';
		$data['pihak_id']='';
		$data['tgl_sekarang'] = date('d/m/Y');
		$data['previous'] = $this->nativesession->get_flash_session('url_requested');
		
		$this->load->model('biaya_perkara/biaya_perkara_m','biaya');
		$data['data_perkara'] = $this->biaya->data_perkara($data['idperkara']);
		$data['data_kategori_biaya'] = $this->biaya->get_kategori_biaya_all($alur_perkara,$tahapan);
		$data['data_jenis_biaya'] = $this->biaya->get_jenis_biaya_all($tahapan,$alur_perkara);
		$data['data_jurusita'] = $this->biaya->get_jurusita($idperkara);

		$detil_pembiayaan=$this->biaya->get_detil_biaya($idperkara);
		foreach ($detil_pembiayaan->result() as $row) {
				$id_pembiayaan=$row->id_pembiayaan;
		}
		$data['jenis_pembiayaan']=$id_pembiayaan;
		$data['jumlah'] = $nominal;		
		$data['uraian'] = 'Tambahan Panjar Biaya Perkara';
		$data['keterangan'] = 'Nomor VA '.$nmr_va;
		$data['nomor_va'] = $nmr_va;
		if($idperkara!=''){
			$result_data_perkara = $this->biaya->data_perkara($idperkara);
			if($result_data_perkara!=''){
				if($result_data_perkara->num_rows()>0){
					foreach ($result_data_perkara->result() as $row) {
						$data['nomor_perkara'] = $row->nomor_perkara;
						$data['tanggal_pendaftaran'] = $row->tanggal_pendaftaran;
						$data['pihak1_text'] = $row->pihak1_text;
						$data['pihak2_text'] = $row->pihak2_text;
						$data['prodeo'] = $row->prodeo;
						$data['alur_perkara_id'] = $row->alur_perkara_id;
						$data['tahapan_terakhir_id'] = $row->tahapan_terakhir_id;
					}
				}else{
					$this->error_page->show_error_msg('Error Found','Tidak ada Perkara');
					exit();
				}
			}else{
				$this->error_page->show_error_msg('Error Found','Something the right happen. Perkada ID Not Found');
				exit();
			}
		}

		if($idperkara!=''){
			$data['pihak_pembayar'] = $this->biaya->pihak_pembayar($idperkara);
			}else{
				$this->error_page->show_error_msg('Error Found','Something the right happen. Perkada ID Not Found');
				exit();
		}
		$this->load->vars($data);
		$this->load->view('jurnal_perkara/add_biaya_form');
	}

	function cetak_bayar() {      
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }

        $segment = $this->uri->segment_array();
        $data['enc_va'] = $segment[3];
        $epayment_id=$this->encrypt->decode(base64_decode($data['enc_va']));
        if(!is_numeric($epayment_id) OR !intval($epayment_id)>0){
            show_404();
            exit();
        }           
       
        $filenya = 'peradilan_umum/perdata/relaas/KUITANSI_VA.rtf';
        $data_id=array(
                    'source_file'=>$filenya,
                    'epayment_id'=>$epayment_id);   
        $this->load->model('generate_template/var_template','var_template');
        $this->var_template->kirim_variabel($data_id);  
    }
}
