<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class verzet_m extends CI_Model {

	function getDataSumberHukum(){
		try {
			$jenis_pengadilan = $this->session->userdata('jenis_pengadilan');

			return $this->db->query('SELECT id,nama FROM sumber_hukum WHERE aktif="Y" AND jenis_pengadilan = '.$jenis_pengadilan.' ORDER BY nama ASC;');
		} catch (Exception $e) {
			
		}
	}

	function getLastSidang($idperkara){
		try {
			$query = $this->db->query("SELECT max(tanggal_sidang) as tglSidang FROM perkara_jadwal_sidang WHERE perkara_id = ".$idperkara.";");
			if($query->num_rows>0){
				return $query->row()->tglSidang;
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function get_status_putusan(){
		try {
			$jenis_pengadilan = $this->session->userdata('jenis_pengadilan');
			$query_tambahan = ' ';
			if($jenis_pengadilan==3){
				$query_tambahan = 'AND urutan IN (1,2,4,5) ';
			}
			return $this->db->query("SELECT id, kode, nama FROM status_putusan WHERE jenis_perkara_id=1 AND jenis_pengadilan = ".$jenis_pengadilan." ".$query_tambahan." ORDER BY nama ASC;");
		} catch (Exception $e) {
			return '';
		}
	}
	
	function getStatusPutusanNama($id){
		try {
			$query = $this->db->query("SELECT nama FROM status_putusan WHERE jenis_perkara_id=1 AND id = ".$id.";");
			if($query->num_rows>0){
				return $query->row()->nama;
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function getTanggalDismissal($idperkara){
		try {
			$query = $this->db->query("SELECT tanggal_penetapan FROM perkara_dismissal WHERE perkara_id = ".$idperkara.";");
			if($query->num_rows>0){
				return $query->row()->tanggal_penetapan;
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function get_no_perkara($perkara_id){
		try {
			$query = $this->db->query("SELECT p.nomor_perkara, p.alur_perkara_id,p.jenis_perkara_id,p.proses_terakhir_id,pp.tanggal_putusan,st.nama AS sumber_hukum_text, pv.*,pp.* 
										FROM perkara p 
											LEFT JOIN (SELECT perkara_id,tanggal_putusan FROM perkara_putusan WHERE perkara_id=".$perkara_id.") pp ON pp.perkara_id=p.perkara_id
											LEFT JOIN (SELECT * FROM perkara_verzet WHERE perkara_id=".$perkara_id.") pv ON p.perkara_id=pv.perkara_id
											LEFT JOIN sumber_hukum AS st
											ON pv.sumber_hukum_id = st.id
										WHERE p.perkara_id=".$perkara_id.";");
			if($query->num_rows>0){
				return $query->row();
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function add_verzet($perkara_id, $datanya, $tahapan_id, $proses_id, $proses_nama, $tanggal){
		try {
			$this->db->insert('perkara_verzet', $datanya);
			$title = "Tambah table <b>perkara_verzet</b> dari halaman <b>Tambah Data Verzet</b> dengan Primary Key [perkara_id=".$datanya['perkara_id']."]";
			$descrip = $this->fetch_description($title,$datanya);
			$this->add_audittrail("INSERT",$title,$descrip,'perkara_verzet');
			if($this->session->userdata('jenis_pengadilan')==3)
				$tahapan_nama = "Perlawanan";
			else
				$tahapan_nama = "Verzet";
			$this->db->simple_query("CALL perkara_proses_update(".$perkara_id.", ".$tahapan_id.", '".$tahapan_nama."', ".$proses_id.", '".$proses_nama."', '".$tanggal."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			$this->db->simple_query("CALL perkara_update_status(".$perkara_id.");");
		} catch (Exception $e) {
			return '';
		}	
	}

	function edit_verzet($perkara_id, $datanya, $tahapan_id, $proses_id, $proses_nama, $tanggal){
		try {
			$this->db->where('perkara_id', $perkara_id);
			$this->db->update('perkara_verzet', $datanya);
			$title = "Update table <b>perkara_verzet</b> dari halaman <b>Edit Data Verzet</b> dengan Primary Key [perkara_id=".$datanya['perkara_id']."]";
			$descrip = $this->fetch_description($title,$datanya);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara_verzet');

			$this->db->simple_query("CALL perkara_proses_update(".$perkara_id.", ".$tahapan_id.", 'Verzet', ".$proses_id.", '".$proses_nama."', '".$tanggal."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			$this->db->simple_query("CALL perkara_update_status(".$perkara_id.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}	
	}

	function addRiwayatPerkara($perkara_id,$tahapan_id, $proses_id, $proses_nama, $tanggal){
		try {
			$this->db->simple_query("CALL perkara_proses_update(".$perkara_id.", ".$tahapan_id.", 'Verzet', ".$proses_id.", '".$proses_nama."', '".$tanggal."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			$this->db->simple_query("CALL perkara_update_status(".$perkara_id.");");
		} catch (Exception $e) {
			
		}
	}

	function delRiwayatPerkara($idperkara,$idproses){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->where('proses_id',$idproses);
			$this->db->delete('perkara_proses');
			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
		} catch (Exception $e) {
			
		}
	}

	function addJadwalSidang($data){
		try {
			$id = $this->db->query("SELECT IFNULL(max(id)+1,1) as id FROM perkara_jadwal_sidang")->row()->id;
			$data['id'] = $id;
			$urutan = $this->db->query("SELECT IFNULL(max(urutan)+1,1) as id FROM perkara_jadwal_sidang WHERE perkara_id =".$data['perkara_id'])->row()->id;
			$data['urutan'] = $urutan;
			$this->db->insert('perkara_jadwal_sidang', $data);
			return $id;
		} catch (Exception $e) {
			return 0;
		}
	}

	

	function getSidangPertamaVerzet($idperkara){
		try {
			return $this->db->query('SELECT id, min(tanggal_sidang) FROM perkara_jadwal_sidang WHERE perkara_id = '.$idperkara.' AND verzet = "Y";');
		} catch (Exception $e) {
			
		}
	}

	function updateJadwalSidangPertama($data){
		try {
			$this->db->where('id',$data['id']);
			$this->db->update('perkara_jadwal_sidang',$data);
		} catch (Exception $e) {
			
		}
	}
	function exec_simple_query($query){
		try {
			$this->db->simple_query($query);
		} catch (Exception $e) {
			return '';
		}	
	}

	function fetch_description($title,$data){
		$descrip = '<br><table style="vertical-align:top" cellspacing="0" cellpadding="1" border="1">';
		$descrip .= '<tr><th>Nama Kolom</th><th>Nilai</th></tr>';
		foreach ($data as $key => $value) {
			$descrip .= '<tr>';
			$descrip .= '<td>'.$key.'</td>';
			$descrip .= '<td>'.$value.'</td>';
			$descrip .= '</tr>';
		}
		$descrip .= '</table>';
		return $descrip;
	}
	
	function add_audittrail($action,$title,$descrip,$tablename){
		try {
			$data = array(
				'datetime' => date("Y-m-d H:i:s"),
				'ipaddress' => $this->input->ip_address(),
				'username' => $this->session->userdata('username'),
				'tablename' => $tablename,
				'formname' => 'add/edit verzet',
				'action' => $action,
				'title' => $title,
				'description' => $descrip
			);
			$this->db->insert('sys_audittrail', $data);
		} catch (Exception $e) {
			
		}
	}

	function deleteData($idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->delete('perkara_verzet');
			$title = "DELETE DATA VERZET dari halaman <b>EDIT DATA VERZET</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$this->add_audittrail("DELETE",$title,'DELETE DATA VERZET','perkara_verzet');

			$this->db->where('perkara_id',$idperkara);
			$this->db->where('verzet','Y');
			$this->db->delete('perkara_jadwal_sidang');

			$this->db->where('perkara_id',$idperkara);
			$this->db->where('tahapan_id',16);
			$this->db->delete('perkara_proses');
			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function hasSidangPertama($idperkara){
		try {
			$query = $this->db->query("SELECT tanggal_sidang_pertama_verzet FROM perkara_verzet WHERE perkara_id = ".$idperkara.";");
			if(!empty($query->row()->tanggal_sidang_pertama_verzet)){
				return TRUE;
			}else{
				return FALSE;
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function getListHakim(){
		try {
			return $this->db->query('SELECT id,nama_gelar FROM hakim_pn WHERE aktif="Y" ORDER BY nama ASC;');
		} catch (Exception $e) {
			
		}
	}

	function getTanggalPermohonan($idperkara){
		try {
			$query = $this->db->query("SELECT tanggal_pendaftaran_verzet FROM perkara_verzet WHERE perkara_id = ".$idperkara.";");
			if($query->num_rows>0){
				return $query->row()->tanggal_pendaftaran_verzet;
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function getHakimNama($idhakim){
		try {
			$query = $this->db->query("SELECT nama_gelar FROM hakim_pn WHERE id = ".$idhakim.";");
			if($query->num_rows>0){
				return $query->row()->nama_gelar;
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function updateDataPenetapanMajelis($idperkara,$dataPenetapan,$datahakim=NULL){
		try {
			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_verzet', $dataPenetapan);

			$title = "UPDATE TABLE <b>perkara_verzet</b> dari halaman <b>PENETAPAN MAJELIS HAKIM</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$descrip = $this->fetch_description($title,$dataPenetapan);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara_verzet');

			if($this->session->userdata('jenis_pengadilan')==3){
				$tahapan_id = 13;
				$this->db->simple_query("CALL perkara_proses_update(".$idperkara.", 13, 'Perlawanan', 111, 'Penetapan Majelis Hakim/Hakim Perlawanan', '".$dataPenetapan['penetapan_majelis_hakim']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			}else{
				$tahapan_id = 16;
				$this->db->simple_query("CALL perkara_proses_update(".$idperkara.", 16, 'Verzet', 241, 'Penetapan Majelis Hakim/Hakim (Verzet)', '".$dataPenetapan['penetapan_majelis_hakim']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			}
			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");

			if(!empty($datahakim)){
				$this->db->where('perkara_id',$idperkara);
				$this->db->where('tahapan_id',$tahapan_id);
				$this->db->delete('perkara_hakim_pn');
				$this->db->insert_batch('perkara_hakim_pn',$datahakim);
			}
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function getOldPenetapanMajelis($idperkara){
		try {
			return $this->db->query('SELECT penetapan_majelis_hakim,majelis_hakim_id,majelis_hakim_nama,majelis_hakim_text FROM perkara_penetapan WHERE perkara_id ='.$idperkara);
		} catch (Exception $e) {
			
		}
	}

	function getListPanitera(){
		try {
			return $this->db->query('SELECT id,nama_gelar FROM panitera_pn WHERE aktif="Y" ORDER BY nama ASC;');
		} catch (Exception $e) {
			
		}
	}

	function getPaniteraNama($idpanitera){
		try {
			$query = $this->db->query("SELECT nama_gelar FROM panitera_pn WHERE id = ".$idpanitera.";");
			if($query->num_rows>0){
				return $query->row()->nama_gelar;
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function getOldPenetapanPanitera($idperkara){
		try {
			return $this->db->query('SELECT penetapan_panitera_pengganti,panitera_pengganti_id,panitera_pengganti_text FROM perkara_penetapan WHERE perkara_id ='.$idperkara);
		} catch (Exception $e) {
			
		}
	}

	function updateDataPenetapanPanitera($idperkara,$dataPenetapan,$datapanitera=NULL){
		try {
			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_verzet', $dataPenetapan);

			$title = "UPDATE TABLE <b>perkara_verzet</b> dari halaman <b>PENETAPAN PANITERA PENGGANTI</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$descrip = $this->fetch_description($title,$dataPenetapan);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara_verzet');

			if($this->session->userdata('jenis_pengadilan')==3){
				$tahapan_id = 13;
				$this->db->simple_query("CALL perkara_proses_update(".$idperkara.", 13, 'Perlawanan', 112, 'Penetapan Panitera Pengganti Perlawanan', '".$dataPenetapan['penetapan_panitera_pengganti']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			}else{
				$tahapan_id = 16;
				$this->db->simple_query("CALL perkara_proses_update(".$idperkara.", 16, 'Verzet', 242, 'Penetapan Panitera Pengganti Verzet', '".$dataPenetapan['penetapan_panitera_pengganti']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			}
			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			if(!empty($datapanitera)){
				$this->db->where('perkara_id',$idperkara);
				$this->db->where('tahapan_id',$tahapan_id);
				$this->db->delete('perkara_panitera_pn');
				$this->db->insert_batch('perkara_panitera_pn',$datapanitera);
			}			
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function getListJurusita(){
		try {
			return $this->db->query('SELECT id,nama_gelar FROM jurusita WHERE aktif="Y" ORDER BY nama ASC;');
		} catch (Exception $e) {
			
		}
	}

	function getJurusitaNama($idpanitera){
		try {
			$query = $this->db->query("SELECT nama_gelar FROM jurusita WHERE id = ".$idpanitera.";");
			if($query->num_rows>0){
				return $query->row()->nama_gelar;
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function getOldPenetapanJurusita($idperkara){
		try {
			return $this->db->query('SELECT penetapan_jurusita,jurusita_id,jurusita_text FROM perkara_penetapan WHERE perkara_id ='.$idperkara);
		} catch (Exception $e) {
			
		}
	}

	function updateDataPenetapanJurusita($idperkara,$dataPenetapan){
		try {
			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_verzet', $dataPenetapan);

			$title = "UPDATE TABLE <b>perkara_verzet</b> dari halaman <b>PENETAPAN JURUSITA</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$descrip = $this->fetch_description($title,$dataPenetapan);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara_verzet');

			if($this->session->userdata('jenis_pengadilan')==3){
				$this->db->simple_query("CALL perkara_proses_update(".$idperkara.", 13, 'Perlawanan', 113, 'Penetapan Jurusita Perlawanan', '".$dataPenetapan['penetapan_jurusita']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			}else{
				$this->db->simple_query("CALL perkara_proses_update(".$idperkara.", 16, 'Verzet', 243, 'Penetapan Jurusita Verzet', '".$dataPenetapan['penetapan_jurusita']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			}
			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function updateDataPenetapanSidang($idperkara,$dataPenetapan){
		try {
			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_verzet', $dataPenetapan);

			$title = "UPDATE TABLE <b>perkara_verzet</b> dari halaman <b>PENETAPAN SIDANG PERTAMA</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$descrip = $this->fetch_description($title,$dataPenetapan);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara_verzet');
			if($this->session->userdata('jenis_pengadilan')==3){
				$this->db->simple_query("CALL perkara_proses_update(".$idperkara.", 13, 'Perlawanan', 114, 'Penetapan Jadwal Sidang Perlawanan', '".$dataPenetapan['tanggal_penetapan_sidang_verzet']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			}else{
				$this->db->simple_query("CALL perkara_proses_update(".$idperkara.", 16, 'Verzet', 250, 'Penetapan Jadwal Sidang Verzet', '".$dataPenetapan['tanggal_penetapan_sidang_verzet']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			}
			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function deleteDataSidang($idperkara,$idsidang){
		try {
			$dataverzet['sidang_id'] = NULL;
			$dataverzet['tanggal_penetapan_sidang_verzet'] = NULL;
			$dataverzet['tanggal_sidang_pertama_verzet'] = NULL;
			$dataverzet['diperbaharui_oleh'] = $this->session->userdata('username');
			$dataverzet['diperbaharui_tanggal'] = date('Y-m-d H:i:s');

			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_verzet', $dataverzet);

			$title = "DELETE DATA PENETAPAN SIDANG PERTAMA VERZET dari halaman <b>PENETAPAN SIDANG PERTAMA VERZET</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$this->add_audittrail("DELETE",$title,'DELETE DATA PENETAPAN SIDANG PERTAMA VERZET','perkara_verzet');

			$this->db->where('perkara_id',$idperkara);
			$this->db->where('id',$idsidang);
			$this->db->delete('perkara_jadwal_sidang');

			$this->db->where('perkara_id',$idperkara);
			if($this->session->userdata('jenis_pengadilan')==3){
				$this->db->where('proses_id',114);
			}else{
				$this->db->where('proses_id',250);
			}
			$this->db->delete('perkara_proses');

			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function deleteDataPenJurusita($idperkara){
		try {
			$dataverzet['penetapan_jurusita'] = NULL;
			$dataverzet['jurusita_id'] = NULL;
			$dataverzet['jurusita_text'] = NULL;
			$dataverzet['diperbaharui_oleh'] = $this->session->userdata('username');
			$dataverzet['diperbaharui_tanggal'] = date('Y-m-d H:i:s');

			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_verzet', $dataverzet);

			$title = "DELETE DATA PENETAPAN JURUSITA VERZET dari halaman <b>PENETAPAN JURUSITA VERZET</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$this->add_audittrail("DELETE",$title,'DELETE DATA PENETAPAN JURUSITA VERZET','perkara_verzet');

			$this->db->where('perkara_id',$idperkara);
			if($this->session->userdata('jenis_pengadilan')==3){
				$this->db->where('proses_id',113);
			}else{
				$this->db->where('proses_id',243);
			}
			$this->db->delete('perkara_proses');

			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function deleteDataPenPanitera($idperkara){
		try {
			$dataverzet['penetapan_panitera_pengganti'] = NULL;
			$dataverzet['panitera_pengganti_id'] = NULL;
			$dataverzet['panitera_pengganti_text'] = NULL;
			$dataverzet['diperbaharui_oleh'] = $this->session->userdata('username');
			$dataverzet['diperbaharui_tanggal'] = date('Y-m-d H:i:s');

			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_verzet', $dataverzet);

			$title = "DELETE DATA PENETAPAN PANITERA PENGGANTI VERZET dari halaman <b>PENETAPAN PANITERA PENGGANTI VERZET</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$this->add_audittrail("DELETE",$title,'DELETE DATA PENETAPAN PANITERA PENGGANTI VERZET','perkara_verzet');

			$this->db->where('perkara_id',$idperkara);
			if($this->session->userdata('jenis_pengadilan')==3){
				$this->db->where('proses_id',112);
			}else{
				$this->db->where('proses_id',242);
			}
			$this->db->delete('perkara_proses');

			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function deleteDataPenHakim($idperkara){
		try {
			$dataverzet['penetapan_majelis_hakim'] = NULL;
			$dataverzet['majelis_hakim_id'] = NULL;
			$dataverzet['majelis_hakim_nama'] = NULL;
			$dataverzet['majelis_hakim_text'] = NULL;
			$dataverzet['diperbaharui_oleh'] = $this->session->userdata('username');
			$dataverzet['diperbaharui_tanggal'] = date('Y-m-d H:i:s');

			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_verzet', $dataverzet);

			$title = "DELETE DATA PENETAPAN MAJELIS HAKIM VERZET dari halaman <b>PENETAPAN MAJELIS HAKIM VERZET</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$this->add_audittrail("DELETE",$title,'DELETE DATA PENETAPAN MAJELIS HAKIM VERZET','perkara_verzet');

			$this->db->where('perkara_id',$idperkara);
			if($this->session->userdata('jenis_pengadilan')==3){
				$this->db->where('proses_id',111);
			}else{
				$this->db->where('proses_id',241);
			}
			$this->db->delete('perkara_proses');

			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function updateDataPutusan($idperkara,$dataPutusan){
		try {
			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_verzet', $dataPutusan);

			$title = "UPDATE TABLE <b>perkara_verzet</b> dari halaman <b>PUTUSAN VERZET</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$descrip = $this->fetch_description($title,$dataPutusan);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara_verzet');

			if($this->session->userdata('jenis_pengadilan')==3){
				$this->db->query(" DELETE FROM perkara_proses WHERE tahapan_id=15 AND proses_id <=217 AND perkara_id=".$idperkara);
				if($dataPutusan['status_putusan_verzet_id']==35){
					$proses_id = 217;
					$proses_nama = 'Putusan Perlawanan Ditolak';
				}elseif($dataPutusan['status_putusan_verzet_id']==34){
					$proses_id = 17;
					$proses_nama = 'Putusan Perlawanan Diterima';
				}elseif($dataPutusan['status_putusan_verzet_id']==37){
					$proses_id = 211;
					$proses_nama = 'Pencabutan Perkara';
				}elseif($dataPutusan['status_putusan_verzet_id']==38){
					$proses_id = 212;
					$proses_nama = 'Pernyataan Gugur';
				}
				$this->db->simple_query("CALL perkara_proses_update(".$idperkara.", 15, 'Putusan', ".$proses_id.", '".$proses_nama."', '".$dataPutusan['putusan_verzet']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
				$this->db->query("UPDATE perkara SET tahapan_terakhir_id = 15, tahapan_terakhir_text = 'Putusan', proses_terakhir_id = ".$proses_id.", proses_terakhir_text = '".$proses_nama."' WHERE perkara_id=".$idperkara);
				
			}else{
				$this->db->simple_query("CALL perkara_proses_update(".$idperkara.", 16, 'Verzet', 270, 'Putusan Perlawanan Verzet', '".$dataPutusan['putusan_verzet']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
				$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			}
			
			
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function getTglPutusanVerzet($idperkara){
		try {
			$query = $this->db->query("SELECT putusan_verzet FROM perkara_verzet WHERE perkara_id = ".$idperkara.";");
			if($query->num_rows>0){
				return $query->row()->putusan_verzet;
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function updateDataPemberitahuan($idperkara,$dataPemberitahuan){
		try {
			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_verzet', $dataPemberitahuan);

			$title = "UPDATE TABLE <b>perkara_verzet</b> dari halaman <b>PUTUSAN PEMBERITAHUAN</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$descrip = $this->fetch_description($title,$dataPemberitahuan);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara_verzet');

			if($this->session->userdata('jenis_pengadilan')==3){
				$this->db->simple_query("CALL perkara_proses_update(".$idperkara.", 15, 'Putusan', 218, 'Pemberitahuan Putusan', '".$dataPemberitahuan['pemberitahuan_putusan']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			}else{
				$this->db->simple_query("CALL perkara_proses_update(".$idperkara.", 16, 'Verzet', 280, 'Pemberitahuan Hasil Putusan Verzet', '".$dataPemberitahuan['pemberitahuan_putusan']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			}
			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function deleteDataPemberitahuan($idperkara){
		try {
			$dataverzet['pemberitahuan_putusan'] = NULL;
			$dataverzet['pemberitahuan_putusan_verzet_pihak1'] = NULL;
			$dataverzet['pemberitahuan_putusan_verzet_pihak2'] = NULL;
			$dataverzet['diperbaharui_oleh'] = $this->session->userdata('username');
			$dataverzet['diperbaharui_tanggal'] = date('Y-m-d H:i:s');

			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_verzet', $dataverzet);

			$title = "DELETE DATA PEMBERITAHUAN PUTUSAN VERZET dari halaman <b>PEMBERITAHUAN PUTUSAN VERZET</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$this->add_audittrail("DELETE",$title,'DELETE DATA PEMBERITAHUAN PUTUSAN VERZET','perkara_verzet');

			$this->db->where('perkara_id',$idperkara);
			if($this->session->userdata('jenis_pengadilan')==3){
				$this->db->where('proses_id',218);
				$this->db->or_where('proses_id',17);
			}else{
				$this->db->where('proses_id',280);
			}
			$this->db->delete('perkara_proses');

			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function deleteDataPutusan($idperkara){
		try {
			$dataverzet['putusan_verzet'] = NULL;
			$dataverzet['status_putusan_verzet_id'] = NULL;
			$dataverzet['status_putusan_verzet_text'] = NULL;
			$dataverzet['sumber_hukum_id'] = NULL;
			$dataverzet['amar_putusan_verzet'] = NULL;
			$dataverzet['diperbaharui_oleh'] = $this->session->userdata('username');
			$dataverzet['diperbaharui_tanggal'] = date('Y-m-d H:i:s');

			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_verzet', $dataverzet);

			$title = "DELETE DATA PUTUSAN VERZET/PERLAWANAN dari halaman <b>EDIT PUTUSAN VERZET/PERLAWANAN</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$this->add_audittrail("DELETE",$title,'DELETE DATA PUTUSAN VERZET/PERLAWANAN','perkara_verzet');

			$this->db->where('perkara_id',$idperkara);
			if($this->session->userdata('jenis_pengadilan')==3){
				$this->db->where('proses_id',217);
				$this->db->or_where('proses_id',17);
			}else{
				$this->db->where('proses_id',270);
			}
			$this->db->delete('perkara_proses');

			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function getTglPemberitahuanPihak1($idperkara){
		try {
			$query = $this->db->query("SELECT pemberitahuan_putusan_verzet_pihak1 FROM perkara_verzet WHERE perkara_id = ".$idperkara.";");
			if($query->num_rows>0){
				return $query->row()->pemberitahuan_putusan_verzet_pihak1;
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function getTglPemberitahuanPihak2($idperkara){
		try {
			$query = $this->db->query("SELECT pemberitahuan_putusan_verzet_pihak2 FROM perkara_verzet WHERE perkara_id = ".$idperkara.";");
			if($query->num_rows>0){
				return $query->row()->pemberitahuan_putusan_verzet_pihak2;
			}
		} catch (Exception $e) {
			return '';
		}
	}


	function getTanggalMinutasiVerzet($idperkara){
		try {
			$query = $this->db->query("SELECT tanggal_minutasi_verzet FROM perkara_verzet WHERE perkara_id = ".$idperkara.";");
			if($query->num_rows>0){
				return $query->row()->tanggal_minutasi_verzet;
			}
		} catch (Exception $e) {
			return '';
		}
	}



	function updateDataMinutasi($idperkara,$tanggalminutasiverzet){
		try {
			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_verzet', $tanggalminutasiverzet);

			$title = "UPDATE TABLE <b>perkara_verzet</b> dari halaman <b>Data Minutasi</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$descrip = $this->fetch_description($title,$tanggalminutasiverzet);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara_verzet');
							
			$this->db->simple_query("CALL perkara_proses_update(".$idperkara.", 15, 'Putusan', 220, 'Tanggal Minutasi', '".$tanggalminutasiverzet['tanggal_minutasi_verzet']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");			
			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function deleteDataMinutasi($idperkara){
		try {
			$dataverzet['tanggal_minutasi_verzet'] = NULL;
			$dataverzet['diperbaharui_oleh'] = $this->session->userdata('username');
			$dataverzet['diperbaharui_tanggal'] = date('Y-m-d H:i:s');

			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_verzet', $dataverzet);

			$title = "DELETE DATA MINUTASI PERLAWANAN dari halaman <b>DATA MINUTASI </b> dengan Primary Key [perkara_id=".$idperkara."]";
			$this->add_audittrail("DELETE",$title,'DELETE DATA MINUTASI PERLAWANAN','perkara_verzet');

			$this->db->where('perkara_id',$idperkara);			
			if($this->session->userdata('jenis_pengadilan')==3){
				$this->db->where('proses_id',220);
				$this->db->delete('perkara_proses');
				$this->db->simple_query("UPDATE perkara SET tahapan_terakhir_id = 15, tahapan_terakhir_text = 'Putusan', proses_terakhir_id = 218, proses_terakhir_text = 'Pemberitahuan Putusan' WHERE perkara_id=".$idperkara);								
			}else{
				$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			}									
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}


	function getTglMinutasiVerzet($idperkara){
		try {
			$query = $this->db->query("SELECT tanggal_minutasi_verzet FROM perkara_verzet WHERE perkara_id = ".$idperkara.";");
			if($query->num_rows>0){
				return $query->row()->tanggal_minutasi_verzet;
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function isAlreadyBanding($idperkara){
		try {
			$query = $this->db->query("SELECT count(perkara_id) as idperkara FROM perkara_banding WHERE perkara_id = ".$idperkara.";");
			if($query->num_rows>0){
				return $query->row()->idperkara;
			}
		} catch (Exception $e) {
			return '';
		}
	}

	#mediasi verzet 25052016
	function get_jadwal_mediasi_terakhir($idmediasi){
		if(empty($idmediasi)){
				return '';
		}
		try {
			$qry="SELECT tanggal_mediasi FROM perkara_jadwal_mediasi 
					WHERE mediasi_id='$idmediasi' AND urutan=(SELECT MAX(urutan) FROM perkara_jadwal_mediasi WHERE mediasi_id='$idmediasi');";			
			$tgljmediasiterakhir=$this->db->query($qry);
			$jumhasil=$tgljmediasiterakhir->num_rows();
			if ($jumhasil>0){
				$tgljmediasiterakhir=$tgljmediasiterakhir->row()->tanggal_mediasi;
				return $tgljmediasiterakhir;
			}
		} catch (Exception $e) {
			return FALSE;
		}
	}
	function getDataMediasiVerzet($perkara_id){
		try {
			return $this->db->query("SELECT * FROM perkara_mediasi WHERE perkara_id = $perkara_id AND tahapan_id=16 ORDER BY mediasi_id ASC");
		} catch (Exception $e) {
			log_message('error',$e);
		}
	}

	function cek_data_dukung_mediasi($idperkara,$mediasi_id){
		if(!intval($idperkara)||$idperkara==null){
			show_404();
			exit();
		}
		
		try{
			return $this->db->query("select 
									id 			AS id,
									perkara_id 	AS perkara_id,
									mediasi_id 	AS mediasi_id,
									identifier 	AS identifier 
									from perkara_data_dukung_mediasi
									where perkara_id=$idperkara AND identifier='#pilih_mediator#'");
		}catch(Exception $e){
			log_message('error',$e);
		}
	}
	
	function data_dukung_mediasi($mediasi_id){
		if(empty($mediasi_id)){
			return '';
		}
		if(!intval($mediasi_id)){
			show_404();
		}

		try {
			$this->db->where('mediasi_id',$mediasi_id);
			$this->db->order_by('mediasi_id','ASC');
			return $this->db->get('perkara_data_dukung_mediasi');
		} catch (Exception $e) {
			log_message('error',$e);
		}
	}

	function get_date_tanggal($perkara_id){
		if(empty($perkara_id)){ 
				return '';
		}

		try {
			return $this->db->query("SELECT DISTINCT diinput_tanggal FROM perkara_mediator WHERE perkara_id=$perkara_id")->result();
		} catch (Exception $e) {
			log_message('error', $e);	
		}
	}

	function add_data_dukung_mediasi($data_dukung_mediasi){
		if(empty($data_dukung_mediasi)){
			return '';
		}
		try {
			$this->db->insert('perkara_data_dukung_mediasi', $data_dukung_mediasi);
			$title = "Tambah Data Dukung Mediasi <br />Tambah table <b>perkara_data_dukung_mediasi</b> dari halaman <b>Mediasi</b> dengan Primary Key [mediasi_id=".$data_dukung_mediasi['mediasi_id']."]";
			$descrip = $this->fetch_description($title,$data_add);
			$this->add_audittrail("INSERT",$title,$descrip,'perkara_mediasi');
			return TRUE;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function update_data_dukung_mediasi($data_dukung_mediasi,$mediasi_id,$idperkara){
		if(empty($data_dukung_mediasi)){
			return '';
		}
		if(!intval($mediasi_id)){
			return '';
		}

		try {
			$this->db->where('mediasi_id',$mediasi_id);
			$this->db->where('perkara_id',$idperkara);
			$this->db->where('identifier',$data_dukung_mediasi['identifier']);
			$this->db->update('perkara_data_dukung_mediasi',$data_dukung_mediasi);
			return TRUE;
		} catch (Exception $e) {
			log_message('error',$e);
		}
	}

	function getDataMediator(){
		try {
			return $this->db->query('SELECT id, 
				CASE WHEN status_mediator="N" THEN "Mediator Umum" 
					WHEN status_mediator="H" THEN "Hakim" 
					WHEN status_mediator="P" THEN "Pegawai" END AS status_mediator, 
					nama_gelar FROM mediator WHERE aktif = "Y"');
		} catch (Exception $e) {
			return '';
		}
	}
	function getDataVerzet($idperkara){
		try {
			return $this->db->query('SELECT 
									  a.perkara_id,
									  a.tanggal_pendaftaran_verzet,
									  b.nomor_perkara,
									  a.tanggal_sidang_pertama_verzet
									FROM
									  perkara_verzet AS a 
									  LEFT JOIN perkara AS b 
									    ON a.perkara_id = b.perkara_id 
									WHERE a.perkara_id ='.$idperkara);
		} catch (Exception $e) {
			return '';
		}
	}
	function infoMediator($idmediator){
		try {
			return $this->db->query('SELECT id, status_mediator, nama_gelar FROM mediator WHERE id='.$idmediator);
		} catch (Exception $e) {
			return '';
		}
	}
	function get_maxid_mediasi(){
		try {
			$query = $this->db->query('SELECT MAX(mediasi_id) AS maxid  FROM perkara_mediasi');
			return $query;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	function get_urutan_jadwal_mediasi_terakhir($mediasi_id){
		$this->db->select_max('urutan');
		$this->db->where('mediasi_id',$mediasi_id);
		$result=$this->db->get('perkara_jadwal_mediasi');
		return $result;
	}
	function get_id_jadwal_mediasi_terakhir(){
		$this->db->select_max('id');
		$result=$this->db->get('perkara_jadwal_mediasi');
		return $result;
	}
	function update_data_mediasi($datamediasi,$id){
		try {
			$this->db->where('mediasi_id',$id);
			$this->db->update('perkara_mediasi', $datamediasi);

			$title = "UPDATE Hasil Mediasi <br /> UPDATE table <b>perkara_mediasi</b> dari halaman <b>HASIL MEDIASI</b> dengan Primary Key [id=".$id."]";
			$descrip = $this->fetch_description($title,$datamediasi);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara_mediasi');
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function delete_update($perkara_id){
		try {
			$this->db->where('perkara_id',$perkara_id);
			$this->db->delete('perkara_mediator');
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_mediator_edit($perkara_id){
		if(intval($perkara_id)<0){
			show_404();
		}

		try {
			return $this->db->query("SELECT 
									mediator_id,
									status_mediator,
									nama_mediator
									FROM perkara_mediator WHERE perkara_id=$perkara_id AND aktif='Y'");
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_perkara_mediator(){
		try {
			$query = $this->db->query('SELECT MAX(id) AS maxid FROM perkara_mediator');
			return $query->row()->maxid;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function add_perkara_mediator($data_mediator){
		if(empty($data_mediator)){
				return '';
		}
		try {
			$this->db->insert('perkara_mediator', $data_mediator);
			return TRUE;
		} catch (Exception $e){
			log_message('error', $e);
		}
	}

	function add_data_mediasi($datamediasi){
		try {
			$this->db->insert('perkara_mediasi', $datamediasi);
			$title = "INSERT Perkara Mediasi <br /> INSERT table <b>perkara_mediasi</b> dari halaman <b>PENETAPAN MEDIATOR</b> dengan Primary Key [id=".$datamediasi['mediasi_id']."]";
			$descrip = $this->fetch_description($title,$datamediasi);
			$this->add_audittrail("INSERT",$title,$descrip,'perkara_mediasi');
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}
	function add_data_jadwal_mediasi($jadwalmediasi){
		try {
			$this->db->insert('perkara_jadwal_mediasi', $jadwalmediasi);
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}
	function get_detil_jadwal_mediasi($idjadwalmediasi){
		if(empty($idjadwalmediasi)) {
			return '';
		}
		try {
			$this->db->where('id',$idjadwalmediasi);
			$query=$this->db->get('perkara_jadwal_mediasi');
			return $query->result();
		}catch (Exception $e) {
			log_message('error', $e);
		}
	}
	function update_jadwal_mediasi($id_jadwal_mediasi,$data_diupdate,$id_mediasi){
		try {
			$this->db->where('id',$id_jadwal_mediasi);
			$this->db->update('perkara_jadwal_mediasi',$data_diupdate);
			$datamediasi=array('keputusan_mediasi'=>$data_diupdate['tanggal_mediasi']);
			$this->db->where('mediasi_id',$id_mediasi);
			$this->db->update('perkara_mediasi',$datamediasi);			
		}
		 catch (Exception $e) {
			return FALSE;
		}
	}
	function tunda_mediasi($datainsert,$dataupdate1,$dataupdate2,$idmediasi){
		try {
			$this->db->where('id',$idmediasi);
			$this->db->update('perkara_jadwal_mediasi',$dataupdate1);

			$title = "UPDATE Jadwal Mediasi <br /> UPDATE table <b>perkara_jadwal_mediasi</b> dari halaman <b>PENUNDAAN JADWAL MEDIASI</b> dengan Primary Key [id=".$idmediasi."]";
			$descrip = $this->fetch_description($title,$dataupdate1);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara_jadwal_mediasi');

			$this->db->insert('perkara_jadwal_mediasi', $datainsert);

			$title = "INSERT Jadwal Mediasi <br /> INSERT table <b>perkara_jadwal_mediasi</b> dari halaman <b>PENUNDAAN JADWAL MEDIASI</b> dengan Primary Key [id=".$datainsert['id']."]";
			$descrip = $this->fetch_description($title,$datainsert);
			$this->add_audittrail("INSERT",$title,$descrip,'perkara_jadwal_mediasi');

			$this->db->where('mediasi_id',$idmediasi);
			$this->db->update('perkara_mediasi',$dataupdate2);

			$title = "UPDATE Tanggal Kesepakatan Mediasi <br /> UPDATE table <b>perkara_mediasi</b> dari halaman <b>PENUNDAAN JADWAL MEDIASI</b> dengan Primary Key [id=".$idmediasi."]";
			$descrip = $this->fetch_description($title,$dataupdate2);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara_mediasi');			
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}
	function hapus_jadwal_mediasi($id_jadwal_mediasi){
		try {
			$tgljmediasisebelum="SELECT mediasi_id,tanggal_mediasi 
								 FROM perkara_jadwal_mediasi 
								 WHERE mediasi_id=(SELECT mediasi_id FROM perkara_jadwal_mediasi WHERE id='$id_jadwal_mediasi')
								 AND urutan=(SELECT MAX(urutan)-1 FROM perkara_jadwal_mediasi WHERE mediasi_id=(SELECT mediasi_id FROM perkara_jadwal_mediasi WHERE id='$id_jadwal_mediasi'));";
			$tgljmediasisebelum=$this->db->query($tgljmediasisebelum)->row();
			$updatemediasi="UPDATE perkara_mediasi SET keputusan_mediasi='$tgljmediasisebelum->tanggal_mediasi' WHERE mediasi_id='$tgljmediasisebelum->mediasi_id'";
			$this->db->query($updatemediasi);
			$this->db->where('id',$id_jadwal_mediasi);
			$this->db->delete('perkara_jadwal_mediasi');
			$title = "DELETE Jadwal Mediasi <br /> DELETE table <b>perkara_jadwal_mediasi</b> dari halaman <b>EDIT JADWAL MEDIASI</b> dengan Primary Key [id=".$id_jadwal_mediasi."]";
			$descrip = '';
			$this->add_audittrail("DELETE",$title,$descrip,'perkara_jadwal_mediasi');		
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}		
	}	
	function hapus_penetapan_mediasi_verzet($idperkara,$mediasi_id){
		try {			
			$this->db->where('mediasi_id',$mediasi_id);
			$this->db->where('tahapan_id',16);
			$this->db->where('perkara_id',$idperkara);
			$this->db->delete('perkara_mediasi');
			
			$this->db->where('perkara_id',$idperkara);
			$this->db->delete('perkara_mediator');

			$title = "DELETE Perkara Mediasi <br /> DELETE table <b>perkara_mediasi dan perkara_mediator</b> dari halaman <b>EDIT PENETAPAN MEDIASI</b> dengan Primary Key [id=".$mediasi_id."]";
			$descrip = '';
			$this->add_audittrail("DELETE",$title,$descrip,'perkara_mediasi');		
			return TRUE;
		} catch (Exception $e) {
			log_message('error', $e);
		}		
	}
}

