<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Update_database extends CI_Model{
	function __construct(){
		$this->run_this();
	}

	function isColumnExist($table_name,$column_name){
		try {
			$result = $this->db->query('
				SELECT COLUMN_NAME AS colname
			    FROM information_schema.columns 
			    WHERE TABLE_NAME = "'.$table_name.'"
			    AND COLUMN_NAME = "'.$column_name.'" AND TABLE_SCHEMA = "'.$this->db->database.'" 
			    GROUP BY column_name;
				');
			if($result->num_rows>0){
				return $result->row()->colname;
			}else{
				return '';
			}
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function run_this(){
		//script update database disini

        
        $this->db->query("SET FOREIGN_KEY_CHECKS=0;");
        $this->db->query("SET SQL_MODE='ALLOW_INVALID_DATES';");
 		
 		$this->db->query("REPLACE INTO `jenis_alur_perkara` (`alur_perkara_id`, `jenis_perkara_id`) values ('10','333'),('10','334');");
 		$this->db->query("DELETE FROM jenis_alur_perkara WHERE alur_perkara_id = '10' AND jenis_perkara_id = '331';");
 		$this->db->query("DELETE FROM jenis_alur_perkara WHERE alur_perkara_id = '9' AND jenis_perkara_id = '331';");
 		$this->db->query("DELETE FROM jenis_alur_perkara WHERE alur_perkara_id = '9' AND jenis_perkara_id = '333';");
 		$this->db->query("DELETE FROM jenis_alur_perkara WHERE alur_perkara_id = '9' AND jenis_perkara_id = '334';");
 		$this->db->query("UPDATE alur_perkara SET kode = 'G/KI' WHERE id = '11';");
 		$this->db->query("UPDATE alur_perkara SET kode = 'P/FP' WHERE id = '12';");
 		$this->db->query("UPDATE alur_perkara SET kode = 'P/PW' WHERE id = '13';");
 		$this->db->query("UPDATE alur_perkara SET kode = 'G/PU' WHERE id = '14';");
 		$this->db->query("UPDATE jenis_perkara SET format_nomor = '#nomor_urut_perkara#/G/PU/#tahun#/PTUN.#kode_pn#' WHERE id = '332';");
 		$this->db->query("UPDATE jenis_perkara SET format_nomor = '#nomor_urut_perkara#/P/FP/#tahun#/PTUN.#kode_pn#' WHERE id = '333';");
 		$this->db->query("UPDATE jenis_perkara SET format_nomor = '#nomor_urut_perkara#/P/PW/#tahun#/PTUN.#kode_pn#' WHERE id = '334';");
 		$this->db->query("UPDATE alur_perkara SET kode = 'P' WHERE id = '10';");
 		$this->db->query("UPDATE alur_perkara SET aktif = 'Y' WHERE id = '10';");
  		$this->db->query("UPDATE alur_perkara SET nama = 'Gugatan Keberatan (KIP)', keterangan = 'Gugatan Keberatan (KIP)', aktif = 'Y' WHERE id = '11';");
  		$this->db->query("UPDATE jenis_biaya SET nama = REPLACE(nama,'Materai','Meterai');");
   		$this->db->query("UPDATE kategori_biaya SET nama = REPLACE(nama,'Materai','Meterai'), keterangan = REPLACE(keterangan,'Materai','Meterai');");
  		$this->db->query("UPDATE perkara_biaya SET uraian = REPLACE(uraian,'Materai','Meterai');");
  		$this->db->query("UPDATE perkara_biaya SET uraian = REPLACE(uraian,'MATERAI','METERAI');");

  		$this->db->query("REPLACE INTO perkara_penetapan(
						perkara_id,
						penetapan_majelis_hakim,
						nomor_sk_penetapan_majelis_hakim,
						majelis_hakim_id,
						majelis_hakim_kode,
						majelis_hakim_nama,
						majelis_hakim_text,
						penetapan_panitera_pengganti,
						nomor_sk_penetapan_panitera_pengganti,
						panitera_pengganti_id,
						panitera_pengganti_text,
						penetapan_jurusita,
						nomor_sk_penetapan_jurusita,
						jurusita_id,
						jurusita_text,
						diinput_oleh,
						diinput_tanggal)
						SELECT 
						hakim_1.`perkara_id` 								AS perkara_id, 
						hakim_1.`tanggal_penetapan` 						AS penetapan_majelis_hakim,
						hakim_1.`nomor_sk_penetapan` 						AS nomor_sk_penetapan_majelis_hakim,
						CONCAT(hakim_1.`hakim_id`,IF(hakim_2.`id` IS NULL,'',CONCAT(',',hakim_2.`hakim_id`,',',hakim_3.`hakim_id`))) AS majelis_hakim_id,
						CONCAT(hakim_1.`hakim_kode`,IF(hakim_2.`id` IS NULL,'',CONCAT(',',hakim_2.`hakim_kode`,',',hakim_3.`hakim_kode`))) AS majelis_hakim_kode,
						CONCAT(hakim_1.`hakim_nama`,IF(hakim_2.`id` IS NULL,'',CONCAT('<br/>',hakim_2.`hakim_nama`,'<br/>',hakim_3.`hakim_nama`))) AS majelis_hakim_nama,
						CONCAT(hakim_1.`jabatan_hakim_nama`,' : ',hakim_1.`hakim_nama`,IF(hakim_2.`id` IS NULL,'',CONCAT('<br/>',hakim_2.`jabatan_hakim_nama`,' ',hakim_2.`urutan` - '1',' : ',hakim_2.`hakim_nama`,'<br/>',hakim_3.`jabatan_hakim_nama`,' ',hakim_3.`urutan` - '1',' : ',hakim_3.`hakim_nama`))) AS majelis_hakim_text,
						IF(pp.`id` IS NULL,NULL,pp.`tanggal_penetapan`) 	AS penetapan_panitera_pengganti,
						IF(pp.`id` IS NULL,NULL,pp.`nomor_sk_penetapan`) 	AS nomor_sk_penetapan_panitera_pengganti,
						IF(pp.`id` IS NULL,NULL,pp.`panitera_id`) 			AS panitera_pengganti_id,
						IF(pp.`id` IS NULL,NULL,pp.`panitera_nama`) 		AS panitera_pengganti_text,
						IF(js.`id` IS NULL,NULL,js.`tanggal_penetapan`) 	AS penetapan_jurusita,
						IF(js.`id` IS NULL,NULL,js.`nomor_sk_penetapan`) 	AS nomor_sk_penetapan_jurusita,
						IF(js.`id` IS NULL,NULL,js.`jurusita_id`) 			AS jurusita_id,
						IF(js.`id` IS NULL,NULL,js.`jurusita_nama`) 		AS jurusita_text,
						'System' 					AS diinput_oleh,
						NOW() 						AS diinput_tanggal	
						FROM 		
						(SELECT a.`perkara_id` 
						FROM 
						(SELECT a.`perkara_id` FROM perkara_hakim_pn a JOIN perkara b ON a.`perkara_id`=b.`perkara_id` AND (b.`alur_perkara_id`='15' OR b.`alur_perkara_id`='16') 
						GROUP BY a.`perkara_id`) AS a
						LEFT JOIN (SELECT perkara_id AS id FROM perkara_penetapan) AS b ON a.`perkara_id` = b.`id` WHERE b.`id` IS NULL) AS src
						LEFT JOIN 	(SELECT * FROM perkara_hakim_pn WHERE urutan = '1' AND aktif = 'Y') AS hakim_1 ON src.`perkara_id` = hakim_1.`perkara_id`
						LEFT JOIN 	(SELECT * FROM perkara_hakim_pn WHERE urutan = '1' AND aktif = 'Y') AS hakim_2 ON hakim_1.`perkara_id` = hakim_2.`perkara_id`
						LEFT JOIN 	(SELECT * FROM perkara_hakim_pn WHERE urutan = '1' AND aktif = 'Y') AS hakim_3 ON hakim_1.`perkara_id` = hakim_3.`perkara_id`
						LEFT JOIN 	(SELECT * FROM perkara_panitera_pn WHERE aktif = 'Y' GROUP BY perkara_id ORDER BY urutan DESC) AS pp ON hakim_1.`perkara_id` = pp.`perkara_id`
						LEFT JOIN 	(SELECT * FROM perkara_jurusita WHERE aktif = 'Y' GROUP BY perkara_id ORDER BY urutan DESC) AS js ON hakim_1.`perkara_id` = js.`perkara_id`;");

 		$this->db->query("UPDATE perkara_penetapan AS src 
 						JOIN perkara AS dst ON src.perkara_id=dst.perkara_id AND (dst.`alur_perkara_id`='15' OR dst.`alur_perkara_id`='16')
						LEFT JOIN (SELECT * FROM perkara_hakim_pn WHERE urutan='1' AND aktif='Y') AS hakim_1 ON src.`perkara_id`= hakim_1.`perkara_id`
						LEFT JOIN (SELECT * FROM perkara_hakim_pn WHERE urutan='1' AND aktif='Y') AS hakim_2 ON hakim_1.`perkara_id`= hakim_2.`perkara_id`
						LEFT JOIN (SELECT * FROM perkara_hakim_pn WHERE urutan='1' AND aktif='Y') AS hakim_3 ON hakim_1.`perkara_id`= hakim_3.`perkara_id`
						SET 
						src.`majelis_hakim_id` = CONCAT(hakim_1.`hakim_id`,IF(hakim_2.`id` IS NULL,'',CONCAT(',',hakim_2.`hakim_id`,',',hakim_3.`hakim_id`))),
						src.`majelis_hakim_kode` = CONCAT(hakim_1.`hakim_kode`,IF(hakim_2.`id` IS NULL,'',CONCAT(',',hakim_2.`hakim_kode`,',',hakim_3.`hakim_kode`)))
						WHERE src.`majelis_hakim_nama` IS NOT NULL AND src.`majelis_hakim_nama` !='' AND src.`majelis_hakim_id` IS NULL;");

 		$this->db->query("UPDATE perkara_penetapan AS src
						JOIN perkara AS dst ON src.perkara_id=dst.perkara_id AND (dst.alur_perkara_id='15' OR dst.alur_perkara_id='16')
						LEFT JOIN (SELECT * FROM perkara_panitera_pn WHERE aktif = 'Y' GROUP BY perkara_id ORDER BY urutan DESC) AS pp ON src.perkara_id=pp.perkara_id
						SET src.panitera_pengganti_id= IF(pp.id IS NULL,NULL,pp.panitera_id)
						WHERE src.panitera_pengganti_text IS NOT NULL AND src.panitera_pengganti_text !='' AND src.panitera_pengganti_id IS NULL;");

 		$this->db->query("UPDATE perkara_penetapan AS src
						JOIN perkara AS dst ON src.`perkara_id`=dst.`perkara_id` AND (dst.`alur_perkara_id`='15' OR dst.`alur_perkara_id`='16')
						LEFT JOIN (SELECT * FROM perkara_jurusita WHERE aktif = 'Y' GROUP BY perkara_id ORDER BY urutan DESC) AS js ON src.`perkara_id`=js.`perkara_id`
						SET src.`jurusita_id`= IF(js.`id` IS NULL,NULL,js.`jurusita_id`)
						WHERE src.`jurusita_text` IS NOT NULL AND src.`jurusita_text` !='' AND src.`jurusita_id` IS NULL;");

 		$this->db->query("REPLACE INTO `template_dokumen` (`id`,`alur_perkara_id`, `tahapan_id`, `proses_id`, `nomor`, `kode`, `nama`) 
						SELECT * FROM (SELECT '2088','15', '10' AS tahap, '10' AS proses, '1', 'PDT_15_10_10_1', 'SKUM') AS tmp
						WHERE NOT EXISTS (SELECT id FROM template_dokumen WHERE id = '2088') LIMIT 1;");

 		$this->db->query("UPDATE proses_alur_perkara SET batas_waktu = '30' , nama_tabel_dari = 'perkara_persiapan' , nama_kolom_dari = 'tanggal_penetapan_persiapan' 
 						WHERE alur_perkara_id = '9' AND tahapan_id = '12' AND proses_id = '80';");

		$this->db->query("UPDATE proses_alur_perkara SET batas_waktu = '60' WHERE alur_perkara_id = '9' AND tahapan_id = '42' AND proses_id = '370';");

 		$this->db->query("REPLACE INTO jenis_perkara (`id`, `parent_id`, `nama`, `nama_lengkap`) 
						VALUES ('621', '337', 'Ketidakhadiran Tanpa Ijin', 'Ketidakhadiran Tanpa Ijin');"); 

		$this->db->query("UPDATE jenis_perkara SET format_nomor = '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#' WHERE `id` = '621'; ");
 		
 		$this->db->query("REPLACE INTO `jenis_alur_perkara` (`alur_perkara_id`, `jenis_perkara_id`) 
						VALUES ('120', '621'); ");

 		$this->db->query("UPDATE pengadilan_negeri SET `alamat` = 'Jl. Pomorouw No. 66 Manado' WHERE `id` = '376';");


 		$this->db->query("REPLACE INTO `biaya_perkara` (alur_perkara_id,jenis_biaya_id,jumlah,keterangan) 
 						VALUES ('8','343','3000.00','Uang Leges'),('10','343','3000.00','Uang Leges'),('11','343','3000.00','Uang Leges'), 
 						('15','343','3000.00','Uang Leges'),('16','343','3000.00','Uang Leges');");

  		$this->db->query("REPLACE INTO `sys_groups` (`groupid`,`parent_id`,`level`,`lft`,`rgt`,`name`,`description`,`ordering`) 
  						VALUES ('650','30','5','75','76','Koordinator Delegasi','Koordinator Delegasi','14');");
  		

 		$this->db->query("REPLACE INTO `sys_group_rule` (`groupid`, `ruleid`) 
 						values ('650','44'),('650','45'),('650','46'),('650','47'),('650','62'),('650','63'),('650','64'),('650','65'),('650','83'),('650','88'),('650','89'),('650','90'),
 						('650','91'),('650','92'),('650','93'),('650','105'),('650','106'),('650','121'),('650','122'),('650','129'),('650','130'),('650','131'),('650','132'),('650','133'),
 						('650','134'),('650','135'),('650','136'),('650','137'),('650','145'),('650','148'),('650','151'),('650','154'),('650','190'),('650','193'),('650','196'),
 						('650','217'),('650','220'),('650','223'),('650','226'),('650','258'),('650','261'),('650','284'),('650','287'),('650','290'),('650','330'),('650','332'),
 						('650','333'),('650','334'),('650','335'),('650','336'),('650','338'),('650','340'),('650','341'),('650','342'),('650','344'),('650','345'),('650','346'),
 						('650','347'),('650','348'),('650','364'),('650','367'),('650','370'),('650','373'),('650','379'),('650','385'),('650','388'),('650','394'),('650','397'),
 						('650','400'),('650','403'),('650','477'),('650','526');");

  		$this->db->query("REPLACE INTO `sumber_hukum` (`id`,`kode`,`nama`,`jenis_pengadilan`) 
  						VALUES ('14','Yurisprudensi','Yurisprudensi','1'),('15','RV','RV','1'),('16','Yurisprudensi','Yurisprudensi','4');");
  		
  		$this->db->query("UPDATE perkara SET proses_terakhir_text='Minutasi' WHERE proses_terakhir_text='Pembuatan Minutasi';");

  		$this->db->query("UPDATE perkara_proses SET proses_nama='Minutasi' WHERE proses_nama='Pembuatan Minutasi';");

  		$this->db->query("UPDATE proses_alur_perkara SET proses_nama='Minutasi' WHERE proses_nama='Pembuatan Minutasi';");

  		$this->db->query("UPDATE proses SET STATUS='Minutasi' WHERE STATUS='Pembuatan Minutasi';");
  		
  		$this->db->query("DELETE FROM sys_groups WHERE groupid >= '470' AND groupid <= '483';");

  		$this->db->query("REPLACE INTO jenis_perkara (id,parent_id,nama,nama_lengkap,format_nomor,urutan,level,lft,rgt,diinput_oleh,diinput_tanggal) 
						VALUES('622','119','Keberatan atas ganti kerugian pengadaan tanah bagi pembangunan untuk kepentingan umum','Objek Sengketa Bukan Tanah/Keberatan atas ganti kerugian pengadaan tanah bagi pembangunan untuk kepentingan umum','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PN #kode_pn#','10','4','87','88','admin2','2016-10-03 11:50:31');");

  		$this->db->query("REPLACE INTO jenis_alur_perkara (`alur_perkara_id`,`jenis_perkara_id`) VALUES ('1','622');");

  		$this->db->query("REPLACE INTO jenis_perkara (id, parent_id, nama, nama_lengkap, format_nomor, urutan, level, lft, rgt, diinput_oleh, diinput_tanggal) 
						VALUES('623','119','Keterbukaan Informasi Publik','Objek Sengketa Bukan Tanah/Keterbukaan Informasi Publik','#nomor_urut_perkara#/Pdt.Sus-KIP/#tahun#/PN #kode_pn#','11','4','89','90','admin2','2016-10-03 11:50:31');");

  		$this->db->query("REPLACE INTO jenis_alur_perkara (`alur_perkara_id`, `jenis_perkara_id`) VALUES ('1', '623');");

  		$this->db->query("UPDATE jenis_perkara SET format_nomor = '#nomor_urut_perkara#/Pdt.G/LH/#tahun#/PN #kode_pn#' WHERE parent_id = '372';");

  		$this->db->query("UPDATE jenis_perkara SET format_nomor = '#nomor_urut_perkara#/Pid.B/LH/#tahun#/PN #kode_pn#' WHERE parent_id = '392';");

  		$this->db->query("REPLACE INTO `jenis_biaya` (`id`,`tahapan_id`,`jenis_transaksi`,`kategori_id`,`kode`,`nama`,`jumlah`,`keterangan`,`aktif`,`diedit_oleh`,`diedit_tanggal`,`diinput_oleh`,`diinput_tanggal`,`diperbaharui_oleh`,`diperbaharui_tanggal`) 
						VALUES('377','50','-1','7','PST A1','Pemeriksaan Setempat','0.00','Biaya Pemeriksaan Setempat','Y','',NULL,'system','2016-10-11 10:44:17','admin','2016-10-11 23:03:48');");

  		$this->db->query("REPLACE INTO biaya_perkara (alur_perkara_id,jenis_biaya_id,jumlah)
						VALUES ('1','377','0.00'),('2','377','0.00'),('3','377','0.00'),('4','377','0.00'),('5','377','0.00'),('6','377','0.00'),('7','377','0.00'),
						('8','377','0.00'),('9','377','0.00'),('10','377','0.00'),('11','377','0.00'),('15','377','0.00'),('16','377','0.00');");

  		$this->db->query("REPLACE INTO `jenis_biaya` (`id`, `tahapan_id`, `jenis_transaksi`, `kategori_id`, `nama`, `jumlah`, `keterangan`,  `diinput_oleh`, `diinput_tanggal`) 
  						VALUES ('378','50','-1','4','Biaya Panggilan Pemohon','0.00','Biaya Panggilan Pemohon','system','2016-11-09 10:32:28'), 
  						('379','50','-1','4','Biaya Panggilan Termohon','0.00','Biaya Panggilan Termohon','system','2016-11-09 10:32:57');");

  		$this->db->query("REPLACE INTO biaya_perkara (alur_perkara_id,jenis_biaya_id,jumlah) 
  						VALUES ('1','378','0.00'),('2','378','0.00'),('3','378','0.00'),('4','378','0.00'),('5','378','0.00'),('6','378','0.00'),('7','378','0.00'),
  						('8','378','0.00'),('9','378','0.00'),('10','378','0.00'),('11','378','0.00'),('15','378','0.00'),('16','378','0.00'),('1','379','0.00'),
  						('2','379','0.00'),('3','379','0.00'),('4','379','0.00'),('5','379','0.00'),('6','379','0.00'),('7','379','0.00'),('8','379','0.00'),
  						('9','379','0.00'),('10','379','0.00'),('11','379','0.00'),('15','379','0.00'),('16','379','0.00');");

  		$this->db->query("REPLACE INTO status_putusan (`id`, `jenis_perkara_id`, `nama`, `urutan`, `satuan`, `jenis_pengadilan`) 
						VALUES ('84', '2', 'Putusan NO', '19', '3', '2');");


  		$cekkolom = $this->isColumnExist('perkara_putusan','sumber_hukum');
        if(!$cekkolom){
		$this->db->query("ALTER TABLE `perkara_putusan` CHANGE sumber_hukum_id sumber_hukum_id VARCHAR(20) NULL COMMENT 'Diputus Dengan: pilihan (KUH Perdata,KUH Dagang, Adat, UU/PP)';");
        }   

  		$this->db->query("UPDATE `biaya_perkara` SET jumlah='6000' WHERE jenis_biaya_id='152' OR jenis_biaya_id='167' OR jenis_biaya_id='182' OR jenis_biaya_id='197' OR jenis_biaya_id='212'");

  		$this->db->query("DROP VIEW IF EXISTS `viewperkaralalulintasweb`;"); 
  		$this->db->query("CREATE VIEW `viewperkaralalulintasweb` AS SELECT perkara_id AS IDPerkara,
						(CASE 
							WHEN ditilang_oleh='1' THEN 'Polisi'
							WHEN ditilang_oleh='2' THEN 'Dinas Perhubungan'
							ELSE 'Lainnya'
						END) AS ditilangOleh,
						nomor_tilang AS nomorTilang,
						(CASE
							WHEN jenis_kendaraan_id='1' THEN 'Sepeda Motor'
							WHEN jenis_kendaraan_id='2' THEN 'Mobil Pick Up'
							WHEN jenis_kendaraan_id='3' THEN 'Mobil Penumpang Pribadi'
							WHEN jenis_kendaraan_id='4' THEN 'Mobil Penumpang Umum'
							WHEN jenis_kendaraan_id='5' THEN 'Bus'
							WHEN jenis_kendaraan_id='6' THEN 'Truk'
							WHEN jenis_kendaraan_id='7' THEN 'Truk Gandeng'
							ELSE 'Lainnya'
						END) AS jenisKendaraan,
						nomor_polisi AS nomorPolisi,
						(CASE
							WHEN bukti_tilang_id='10' THEN 'SIM C'
							WHEN bukti_tilang_id='11' THEN 'SIM A'
							WHEN bukti_tilang_id='12' THEN 'SIM BI'
							WHEN bukti_tilang_id='13' THEN 'SIM A UMUM'
							WHEN bukti_tilang_id='14' THEN 'SIM BI UMUM'
							WHEN bukti_tilang_id='15' THEN 'SIM BII UMUM'
							WHEN bukti_tilang_id='20' THEN 'STNK'
							WHEN bukti_tilang_id='30' THEN 'SIM & STNK'
							WHEN bukti_tilang_id='40' THEN 'Kendaraan'
							WHEN bukti_tilang_id='50' THEN 'Buku KIR'
							ELSE 'Lainnya'
						END) AS buktiTilang
						FROM perkara_lalulintas;");

  		$this->db->query("DROP TABLE IF EXISTS `perkaralalulintasweb`;");

  		$this->db->query("CREATE TABLE `perkaralalulintasweb` (  
  						IDPerkara BIGINT(20) NOT NULL,
  						ditilangOleh VARCHAR(100),
  						nomorTilang VARCHAR(50),
  						jenisKendaraan VARCHAR(100),
  						nomorPolisi VARCHAR(50),
  						buktiTilang VARCHAR(100),
  						PRIMARY KEY (IDPerkara)
						) ENGINE=INNODB;");

  		$this->db->query("DROP TABLE IF EXISTS `delegasiproseskeluarweb`;");

  		$this->db->query("CREATE TABLE `delegasiproseskeluarweb` AS SELECT * FROM `viewdelegasiproseskeluarweb`;");

  		$cekkolum = $this->isColumnExist('delegasiproseskeluarweb','IDDelegasi');  		
        if($cekkolum){
		$this->db->query("ALTER TABLE `delegasiproseskeluarweb` ADD PRIMARY KEY (IDDelegasi,IDPerkara,idPNAsal), ENGINE=INNODB;");
        }   

  		$this->db->query("DROP TABLE IF EXISTS `delegasiprosesmasukweb`;");

  		$this->db->query("CREATE TABLE `delegasiprosesmasukweb` AS SELECT * FROM `viewdelegasiprosesmasukweb`;");

  		$periksakolom = $this->isColumnExist('delegasiprosesmasukweb','IDDelegasi');
        if($periksakolom){
		$this->db->query("ALTER TABLE `delegasiprosesmasukweb` ADD PRIMARY KEY (IDDelegasi,IDPerkara,idPNAsal), ENGINE=INNODB;");
        }   

  		$this->db->query("ALTER VIEW `viewbarangbuktiweb` AS SELECT
  						A.`id` 			       	 AS IDBarangBukti,
  						A.`perkara_id`  	   	 AS IDPerkara,
  						A.`nomor_perkara`      	 AS noPerkara,
  						A.`tanggal_penerimaan`   AS tglPenerimaan,
  						(CASE WHEN B.`pihak_dipublikasikan`='T' THEN 'Disamarkan' ELSE A.`jenis_barang_bukti` END) AS jenisBB,
  						A.`tempat_penyimpanan`   AS tempatSimpan,
  						A.`tempat_penyerahan`    AS tempatPenyerahan,
  						A.`nama_penerima`        AS penerima,
  						A.`tanggal_penyerahan`   AS tglPenyerahan,
  						A.`catatan_barang_bukti` AS Catatan
						FROM perkara_barang_bukti AS A
						LEFT JOIN perkara AS B ON B.`perkara_id`=A.`perkara_id`;");

  		$this->db->query("ALTER VIEW `viewpihakweb` AS SELECT 
						'1' AS pihak_ke,
						p1.`pihak_id` AS ID,
						p1.`perkara_id` AS IDPerkara,
						(CASE 
    						WHEN p.`alur_perkara_id`= '1' AND p.`jenis_perkara_id`= '64' AND p1.`nama` IS NOT NULL AND p1.`nama` <> '' THEN 'Disamarkan'
    						WHEN p.`alur_perkara_id`= '1' AND p.`jenis_perkara_id`= '137' AND p1.`nama` IS NOT NULL AND p1.`nama` <> '' THEN 'Disamarkan' 
    						WHEN p.`alur_perkara_id`= '15' AND p.`jenis_perkara_id`= '346' AND p1.`nama` IS NOT NULL AND p1.`nama` <> '' THEN 'Disamarkan'
    						WHEN p.`alur_perkara_id`= '15' AND p.`jenis_perkara_id`= '347' AND p1.`nama` IS NOT NULL AND p1.`nama` <> '' THEN 'Disamarkan'
    						WHEN p.`pihak_dipublikasikan` = 'Y' THEN p1.`nama` 
    						WHEN p.`pihak_dipublikasikan` = 'T' AND p1.`nama` IS NOT NULL AND p1.`nama` <> '' THEN 'Disamarkan' 
    						ELSE p1.`nama` 
						END ) AS nama,
						(CASE WHEN pihak.`tanggal_lahir` IS NOT NULL THEN TIMESTAMPDIFF(YEAR,pihak.`tanggal_lahir`,p.`tanggal_pendaftaran`) ELSE NULL END) AS umur,
						pihak.`jenis_kelamin`,
						p1.`urutan` AS urutan 
						FROM perkara_pihak1 AS p1 
						LEFT JOIN perkara AS p ON p.`perkara_id` = p1.`perkara_id`
						LEFT JOIN pihak ON pihak.`id`=p1.`pihak_id`
						UNION ALL
						SELECT 
						'2' AS pihak_ke,
						p2.`pihak_id` AS ID,
						p2.`perkara_id` AS IDPerkara,
						(CASE
    						WHEN p.`alur_perkara_id` = '118' AND p2.`nama` IS NOT NULL AND p2.`nama` <> '' THEN CONVERT(CONCAT('Anak Berhadapan Dengan Hukum',p2.`urutan`) USING latin1) 
    						WHEN p.`jenis_perkara_id` = '98' AND p2.`nama` IS NOT NULL AND p2.`nama` <> '' THEN 'Terdakwa' 
    						WHEN p.`alur_perkara_id` = '1' AND p.`jenis_perkara_id` = '64' AND p2.`nama` IS NOT NULL AND p2.`nama` <> '' THEN 'Disamarkan' 
    						WHEN p.`alur_perkara_id` = '1' AND p.`jenis_perkara_id` = '137' AND p2.`nama` IS NOT NULL AND p2.`nama` <> '' THEN 'Disamarkan' 
    						WHEN p.`alur_perkara_id` = '15' AND p.`jenis_perkara_id` = '346' AND p2.`nama` IS NOT NULL AND p2.`nama` <> '' THEN 'Disamarkan' 
    						WHEN p.`alur_perkara_id` = '15' AND p.`jenis_perkara_id` = '347' AND p2.`nama` IS NOT NULL AND p2.`nama` <> '' THEN 'Disamarkan' 
    						WHEN p.`pihak_dipublikasikan` = 'T' AND p2.`nama` IS NOT NULL AND p2.`nama` <> '' THEN 'Disamarkan' 
    						ELSE p2.`nama` 
						END) AS nama,
						(CASE WHEN pihak.`tanggal_lahir` IS NOT NULL THEN TIMESTAMPDIFF(YEAR,pihak.`tanggal_lahir`,p.`tanggal_pendaftaran`) ELSE NULL END) AS umur,
						pihak.`jenis_kelamin`,
						p2.`urutan` AS urutan 
						FROM perkara_pihak2 AS p2 
						LEFT JOIN perkara AS p ON p.`perkara_id` = p2.`perkara_id`
						LEFT JOIN pihak ON pihak.`id`=p2.`pihak_id`
						UNION ALL 
						SELECT 
						'3' AS pihak_ke,
						p3.`pihak_id` AS ID,
						p3.`perkara_id` AS IDPerkara,
						(CASE
    						WHEN p.`alur_perkara_id` = '1' AND p.`jenis_perkara_id` = '64' AND p3.`nama` IS NOT NULL AND p3.`nama` <> '' THEN 'Disamarkan' 
    						WHEN p.`alur_perkara_id` = '1' AND p.`jenis_perkara_id` = '137' AND p3.`nama` IS NOT NULL AND p3.`nama` <> '' THEN 'Disamarkan' 
    						WHEN p.`alur_perkara_id` = '15' AND p.`jenis_perkara_id` = '346' AND p3.`nama` IS NOT NULL AND p3.`nama` <> '' THEN 'Disamarkan' 
    						WHEN p.`alur_perkara_id` = '15' AND p.`jenis_perkara_id` = '347' AND p3.`nama` IS NOT NULL AND p3.`nama` <> '' THEN 'Disamarkan' 
    						WHEN p.`pihak_dipublikasikan` = 'T' AND p3.`nama` IS NOT NULL AND p3.`nama` <> '' THEN 'Disamarkan' 
    						ELSE p3.`nama` 
						END) AS nama,
						(CASE WHEN pihak.`tanggal_lahir` IS NOT NULL THEN TIMESTAMPDIFF(YEAR,pihak.`tanggal_lahir`,p.`tanggal_pendaftaran`) ELSE NULL END) AS umur,
						pihak.`jenis_kelamin`,
						p3.`urutan` AS urutan 
						FROM perkara_pihak3 AS p3 
						LEFT JOIN perkara AS p ON p.`perkara_id` = p3.`perkara_id`
						LEFT JOIN pihak ON pihak.`id` = p3.`pihak_id`
						UNION ALL 
						SELECT 
						'4' AS pihak_ke,
						p4.`pihak_id` AS ID,
						p4.`perkara_id` AS IDPerkara,
						(CASE 
    						WHEN p.`alur_perkara_id` = '1' AND p.`jenis_perkara_id` = '64' AND p4.`nama` IS NOT NULL AND p4.`nama` <> '' THEN 'Disamarkan' 
    						WHEN p.`alur_perkara_id` = '1' AND p.`jenis_perkara_id` = '137' AND p4.`nama` IS NOT NULL AND p4.`nama` <> '' THEN 'Disamarkan' 
    						WHEN p.`alur_perkara_id` = '15' AND p.`jenis_perkara_id` = '346' AND p4.`nama` IS NOT NULL AND p4.`nama` <> '' THEN 'Disamarkan' 
    						WHEN p.`alur_perkara_id` = '15' AND p.`jenis_perkara_id` = '347' AND p4.`nama` IS NOT NULL AND p4.`nama` <> '' THEN 'Disamarkan' 
    						WHEN p.`pihak_dipublikasikan` = 'T' AND p4.`nama` IS NOT NULL AND p4.`nama` <> '' THEN 'Disamarkan' 
    						ELSE p4.`nama` 
						END ) AS nama,
						(CASE WHEN pihak.`tanggal_lahir` IS NOT NULL THEN TIMESTAMPDIFF(YEAR,pihak.`tanggal_lahir`,p.`tanggal_pendaftaran`) ELSE NULL END) AS umur,
						pihak.`jenis_kelamin`,
						p4.`urutan` AS urutan 
						FROM `perkara_pihak4` AS p4 
						LEFT JOIN `perkara` AS p ON p.`perkara_id` = p4.`perkara_id`
						LEFT JOIN pihak ON pihak.`id` = p4.`pihak_id`;");

  		$periksakolum = $this->isColumnExist('pihakweb','umur');
        if(!$periksakolum){
		$this->db->query("ALTER TABLE `pihakweb` ADD COLUMN umur INT(3) NULL AFTER nama, ADD COLUMN jenisKelamin VARCHAR(1) NULL AFTER umur, 
						CHANGE urutan urutan INT(20) NULL AFTER jenisKelamin;");
        }    		 				 

  		$this->db->query("DROP VIEW IF EXISTS `viewbandingdetilweb`;");

  		$this->db->query("DROP VIEW IF EXISTS `viewbandingweb`;");

  		$this->db->query("CREATE VIEW `viewbandingweb` AS SELECT
  						A.`perkara_id`                               AS IDPerkara,
  						A.`nomor_perkara_banding`           		 AS noPerkarabanding,
  						A.`permohonan_banding`                       AS tglPermohonanBanding,
  						A.`pemohon_banding`                          AS pemohonBanding,
  						A.`pemberitahuan_permohonan_banding`         AS tglPemberitahuanPermohonan,
  						A.`penerimaan_memori_banding`                AS tglPenerimaanMemori,
  						A.`penyerahan_memori_banding`                AS tglPenyerahanMemori,
  						A.`penerimaan_kontra_banding`                AS tglPenerimaanKontra,
  						A.`penyerahan_kontra_banding`                AS tglPenyerahanKontra,
  						A.`pemberitahuan_inzage_pembanding`          AS tglPemberitahuanInzagePembanding,
  						A.`pemberitahuan_inzage_terbanding`          AS tglPemberitahuanInzageTerbanding,
  						A.`pelaksanaan_inzage_pembanding`            AS tglPelaksanaanInzagePembanding,
  						A.`pelaksanaan_inzage_terbanding`            AS tglPelaksanaanInzageTerbanding,
  						A.`pengiriman_berkas_banding`                AS tglPengirimanBerkas,
  						A.`nomor_surat_pengiriman_berkas_banding`    AS nomorSuratPengiriman,
  						A.`penerimaan_kembali_berkas_banding`        AS tglPenerimaanKembaliBerkas,
  						A.`hakim1_banding`                           AS hakimPertama,
  						A.`hakim2_banding`                           AS hakimKedua,
  						A.`hakim3_banding`                           AS hakimKetiga,
  						A.`hakim4_banding`                           AS hakimKeempat,
  						A.`hakim5_banding`                           AS hakimKelima,
  						A.`panitera_pengganti_banding`               AS paniteraPengganti,
  						A.`putusan_banding`                          AS tglPutusan,
  						A.`nomor_putusan_banding`                    AS noPutusanBanding,
  						(CASE 
							WHEN A.`alur_perkara_id` = '118' THEN 'Disamarkan'
							WHEN B.`jenis_perkara_id` IN ('64','98','242','346','347','248','312','349','350','352') THEN 'Disamarkan'
							ELSE A.`amar_putusan_banding` 
						END) AS amarPutusan,
  						A.`minutasi_banding`                         AS tglMinutasi,
  						A.`pemberitahuan_putusan_banding_pembanding` AS tglPemberitahuanPutusanPembanding,
  						A.`pemberitahuan_putusan_banding_terbanding` AS tglPemberitahuanPutusanTerbanding,
  						A.`catatan_banding`                          AS keterangan
						FROM perkara_banding AS A
						LEFT JOIN perkara AS B ON B.`perkara_id`=A.`perkara_id`;"); 		

  		$this->db->query("CREATE VIEW `viewbandingdetilweb` AS SELECT
  						b.`id`                               AS ID,
  						b.`perkara_id`                       AS IDPerkara,
  						(CASE 
  							WHEN ((b.`alur_perkara_id` = '118') AND (b.`pihak_asal` = '2')) THEN 'Anak Berhadapan Dengan Hukum' 
  							WHEN (p.`jenis_perkara_id` IN ('64','98','242','346','347','248','312','349','350','352')) THEN 'Disamarkan' ELSE b.`pihak_nama` 
  						END) AS nama,
  						b.`status_pihak_id`                  AS IDStatusPihak,
  						CONCAT(IFNULL(b.`status_pihak_text`,''),' (',b.`pihak_asal_text`,')') AS statusPihak,
  						(CASE 
  							WHEN ((b.`alur_perkara_id` = '118') AND (b.`pihak_asal` = '2')) THEN 'Anak Berhadapan Dengan Hukum' 
  							WHEN (p.`jenis_perkara_id` IN ('64','98','242','346','347','248','312','349','350','352')) THEN 'Disamarkan' ELSE b.`pihak_nama` 
  						END) AS pihakNama,
  						b.`pihak_diwakili`                   AS pihakDiwakili,
  						b.`pemohon_nama`                     AS pemohonNama,
  						b.`permohonan_banding`               AS tglPermohonan,
  						b.`pemberitahuan_permohonan_banding` AS tglPemberitahuanPermohonan,
  						b.`penerimaan_memori_banding`        AS tglPenerimaanMemori,
  						b.`penyerahan_memori_banding`        AS tglPenyerahanMemori,
 						b.`penerimaan_kontra_banding`        AS tglPenerimaanKontra,
  						b.`penyerahan_kontra_banding`        AS tglPenyerahanKontra,
  						b.`pemberitahuan_inzage`             AS tglPemberitahuanInzage,
  						b.`pelaksanaan_inzage`               AS tglPelaksanaanInzage,
  						b.`pemberitahuan_putusan_banding`    AS tglPemberitahuanPutusanBanding,
  						b.`tanggal_cabut`                    AS tglCabut,
  						b.`keterangan`                       AS keterangan
						FROM perkara_banding_detil AS b
						LEFT JOIN perkara AS p ON p.`perkara_id` = b.`perkara_id`;"); 	

  		$this->db->query("DROP TABLE IF EXISTS bandingdetilweb;"); 	

  		$this->db->query("DROP TABLE IF EXISTS bandingweb;"); 	

  		$this->db->query("CREATE TABLE `bandingweb` AS SELECT * FROM `viewbandingweb`;"); 	

  		$checkkolum = $this->isColumnExist('bandingweb','IDPerkara');
        if($checkkolum){
		$this->db->query("ALTER TABLE `bandingweb` ADD PRIMARY KEY (IDPerkara);");
        }  

  		$this->db->query("CREATE TABLE `bandingdetilweb` AS SELECT * FROM viewbandingdetilweb;"); 	

  		$checkcols = $this->isColumnExist('bandingdetilweb','ID');
        if($checkcols){
		$this->db->query("ALTER TABLE `bandingdetilweb` ADD PRIMARY KEY (ID,IDPerkara);");
        }  

  		$this->db->query("DROP VIEW IF EXISTS `viewkasasiweb`;"); 	

  		$this->db->query("DROP VIEW IF EXISTS `viewkasasidetilweb`;"); 	

  		$this->db->query("CREATE VIEW `viewkasasiweb` AS SELECT
  						A.`perkara_id`                           AS IDPerkara,
  						A.`nomor_perkara_kasasi`                 AS noPerkaraKasasi,
  						A.`permohonan_kasasi`                    AS tglPermohonankasasi,
  						A.`pemohon_kasasi`                       AS pemohonkasasi,
  						A.`pengiriman_berkas_kasasi`             AS tglPengirimanBerkas,
  						A.`nomor_surat_pengiriman_berkas_kasasi` AS noSuratPengiriman,
  						A.`penerimaan_berkas_kasasi`             AS tglPenerimaanKembaliBerkas,
  						A.`hakim1_kasasi`                        AS hakimPertama,
  						A.`hakim2_kasasi`                        AS hakimKedua,
  						A.`hakim3_kasasi`                        AS hakimKetiga,
  						A.`hakim4_kasasi`                        AS hakimKeempat,
  						A.`hakim5_kasasi`                        AS hakimKelima,
  						A.`panitera_pengganti_kasasi`            AS paniteraPengganti,
  						A.`putusan_kasasi`                       AS tglPutusan,
  						A.`nomor_putusan_kasasi`                 AS noPutusankasasi,
  						(CASE 
							WHEN A.`alur_perkara_id` = '118' THEN 'Disamarkan'
							WHEN B.`jenis_perkara_id` IN ('64','98','242','346','347','248','312','349','350','352') THEN 'Disamarkan'
							ELSE A.`amar_putusan_kasasi` 
						END) AS amarPutusan,
  						A.`minutasi_kasasi`                      AS tglMinutasi,
  						A.`tanggal_berita_putusan_kasasi`        AS tglBeritaPutusan,
  						A.`nama_media_berita_putusan_kasasi`     AS namaMediaBerita,
  						A.`tanggal_surat_kabar_putusan_kasasi`   AS tglSuratKabar,
  						A.`nama_surat_kabar_putusan_kasasi`      AS namaSuratKabar,
  						A.`prodeo_kasasi`                        AS prodeo,
  						A.`catatan_putusan_kasasi`               AS keterangan
						FROM perkara_kasasi AS A
						LEFT JOIN perkara AS B ON B.`perkara_id`=A.`perkara_id`;"); 	

  		$this->db->query("CREATE VIEW `viewkasasidetilweb` AS SELECT
  						k.`id`                           AS ID,
  						k.`perkara_id`                   AS IDPerkara,
  						(CASE 
  							WHEN ((p.`jenis_perkara_id` IN ('248','312')) AND (k.`pihak_asal` = '2')) THEN 'Anak Berhadapan Dengan Hukum' 
  							WHEN (p.`jenis_perkara_id` IN ('64','98','242','346','347','349','350','352')) THEN 'Disamarkan' ELSE k.`pihak_nama` 
  						END) AS nama,
  						k.`status_pihak_id`              AS IDStatusPihak,
  						CONCAT(IFNULL(k.`status_pihak_text`,''),' (',k.`pihak_asal_text`,')') AS statusPihak,
  						(CASE 
  							WHEN ((p.`jenis_perkara_id` IN ('248','312')) AND (k.`pihak_asal` = '2')) THEN 'Anak Berhadapan Dengan Hukum' 
  							WHEN (p.`jenis_perkara_id` IN ('64','98','242','346','347','349','350','352')) THEN 'Disamarkan' ELSE k.`pihak_nama` 
  						END) AS pihak_nama,
  						k.`pihak_diwakili`               AS pihak_diwakili,
  						k.`pemohon_nama`                 AS pemohon_nama,
  						k.`permohonan_kasasi`            AS tglPermohonan,
  						k.`pemberitahuan_kasasi`         AS tglPemberitahuanPermohonan,
  						k.`penerimaan_memori_kasasi`     AS tglPenerimaanMemori,
  						k.`penyerahan_memori_kasasi`     AS tglPenyerahanMemori,
  						k.`penerimaan_kontra_kasasi`     AS tglPenerimaanKontra,
  						k.`penyerahan_kontra_kasasi`     AS tglPenyerahanKontra,
  						k.`pemberitahuan_inzage_kasasi`  AS tglPemberitahuanInzage,
  						k.`pelaksanaan_inzage_kasasi`    AS tglPelaksanaanInzage,
  						k.`pemberitahuan_putusan_kasasi` AS tglPemberitahuanPutusanKasasi,
  						k.`tanggal_cabut`                AS tglCabut
						FROM perkara_kasasi_detil AS k
						LEFT JOIN perkara AS p ON p.`perkara_id` = k.`perkara_id`;"); 	

  		$this->db->query("DROP TABLE IF EXISTS `kasasidetilweb`;"); 	

  		$this->db->query("DROP TABLE IF EXISTS `kasasiweb`;"); 	

  		$this->db->query("CREATE TABLE `kasasiweb` AS SELECT * FROM `viewkasasiweb`;"); 	

  		$checkcolumns = $this->isColumnExist('kasasiweb','IDPerkara');
        if($checkcolumns){
		$this->db->query("ALTER TABLE `kasasiweb` ADD PRIMARY KEY (IDPerkara);");
        }  

  		$this->db->query("CREATE TABLE `kasasidetilweb` AS SELECT * FROM viewkasasidetilweb;"); 

  		$checkcolumn = $this->isColumnExist('kasasidetilweb','ID');
        if($checkcolumn){
		$this->db->query("ALTER TABLE `kasasidetilweb` ADD PRIMARY KEY (ID,IDPerkara);");
        }  	

  		$this->db->query("ALTER VIEW `viewjenisperkaraweb` AS SELECT
  						jenis_perkara.`id`   AS id,
  						alur_perkara.`id`    AS idalurperkara,
  						(CASE WHEN sys_config.`value` = '1'
						THEN (CASE WHEN alur_perkara.`id` < 100 THEN CONCAT('[PERDATA] ',jenis_perkara.`nama_lengkap`) ELSE CONCAT('[PIDANA] ',jenis_perkara.`nama_lengkap`) END)
						ELSE jenis_perkara.`nama` END
						) AS namaKU
						FROM jenis_perkara
						LEFT JOIN jenis_alur_perkara ON jenis_perkara.`id` = jenis_alur_perkara.`jenis_perkara_id`
						LEFT JOIN alur_perkara ON jenis_alur_perkara.`alur_perkara_id` = alur_perkara.`id`
						LEFT JOIN sys_config ON alur_perkara.`jenis_pengadilan`= sys_config.`value`
						WHERE sys_config.`id` = '83'
						AND alur_perkara.`aktif` = 'Y'
						GROUP BY jenis_perkara.`id`
						ORDER BY jenis_perkara.`nama`;"); 	

  		$periksa = $this->isColumnExist('dataumumweb','nilai_sengketa');
        if($periksa){
		$this->db->query("ALTER TABLE dataumumweb CHANGE nilai_sengketa nilai_sengketa BIGINT(20) NULL;");
        }
        $isthere = FALSE;
		$result = $this->db->query("SHOW INDEXES FROM dataumumweb WHERE Key_name = 'jenisPerkara'");
		if(!empty($result)){
		    if($result->num_rows>0){
		        $isthere = TRUE;
		    }
		}
		if($isthere){
			$this->db->query("ALTER TABLE dataumumweb DROP INDEX jenisPerkara, ENGINE=INNODB;");
		}  	  		

        $periksa2 = $this->isColumnExist('perkaraputusanweb','nilaiGantiRugi');
        if($periksa2){
		$this->db->query("ALTER TABLE perkaraputusanweb CHANGE nilaiGantiRugi nilaiGantiRugi BIGINT(20) NULL;");
        }  	  		

		$periksa3 = $this->isColumnExist('biaya_perkara','jumlah');
        if($periksa3){
		$this->db->query("ALTER TABLE biaya_perkara MODIFY COLUMN jumlah DECIMAL(16,2) UNSIGNED NOT NULL;");
        } 

        $periksa4 = $this->isColumnExist('jenis_biaya','jumlah');
        if($periksa4){
		$this->db->query("ALTER TABLE jenis_biaya MODIFY COLUMN jumlah DECIMAL(16,2) UNSIGNED DEFAULT 0.00 NOT NULL COMMENT 'Jumlah Nominal: (dalam rupiah)';");
        } 

        $periksa5 = $this->isColumnExist('perkara_biaya','jumlah');
        if($periksa5){
		$this->db->query("ALTER TABLE perkara_biaya MODIFY COLUMN jumlah DECIMAL(16,2) UNSIGNED NOT NULL COMMENT 'Jumlah nominal tansaksi(dalam Rp)', MODIFY COLUMN sisa DECIMAL(16,2) UNSIGNED NULL  COMMENT 'Jumlah Nominal Sisa: isian bilangan (Rp)';");
        } 

        $periksa6 = $this->isColumnExist('perkara_biaya_ht','jumlah');
        if($periksa6){
		$this->db->query("ALTER TABLE perkara_biaya_ht MODIFY COLUMN jumlah DECIMAL(16,2) UNSIGNED NOT NULL, MODIFY COLUMN sisa  DECIMAL(16,2) UNSIGNED NULL;");
        } 

        $this->db->query("UPDATE `penahanan_terdakwa` SET lama_penahanan=(DATEDIFF(sampai,mulai) + 1);");

  		$this->db->query("DROP FUNCTION IF EXISTS `GetListPengacaraPihak4Text`;");
		$this->db->query("CREATE FUNCTION `GetListPengacaraPihak4Text`(var_id BIGINT(20)) RETURNS VARCHAR(3000) CHARSET latin1
						BEGIN
						  DECLARE listpihak VARCHAR(3000);
						  	SELECT IF(COUNT(perkara_id)>1, GROUP_CONCAT(CONCAT(CAST(urutan AS CHAR(2)),'.', nama) ORDER BY urutan SEPARATOR '<br />'),nama ) INTO listpihak FROM 
							perkara_pengacara 
							WHERE perkara_id=var_id AND pihak_ke=4
							GROUP BY perkara_id;
						  RETURN listpihak;
						END");

		$this->db->query("REPLACE INTO `sys_groups` (`groupid`, `parent_id`, `level`, `lft`, `rgt`, `name`, `description`, `enable`, `ordering`, `lock_by`, `lock_on`, `created_by`, `created_on`, `modified_by`, `modified_on`) values
					('470','30','5','54','61','Panmud Pidana Khusus Perikanan','Panitera Muda Pidana Khusus Perikanan','1','7','',NULL,'system','2012-09-04 19:44:29','','2012-11-15 20:50:41'),
					('471','470','6','55','56','Admin Panmud Pidana Khusus Perikanan','Admin Panitera Muda Pidana Khusus Perikanan','0','1','',NULL,'system','2012-09-04 20:04:36','','2012-11-15 20:11:54'),
					('472','470','6','57','58','Meja I Pidana Khusus Perikanan','Meja I Pidana Khusus Perikanan','1','2','',NULL,'system','2012-09-04 20:05:12','','2012-09-04 23:11:38'),
					('473','470','6','59','60','Meja II Pidana Khusus Perikanan','Meja II Pidana Khusus Perikanan','1','3','',NULL,'system','2012-09-04 20:05:47','','2012-09-05 18:26:18');");		
		$this->db->query("REPLACE INTO `sys_group_rule` (`groupid`, `ruleid`) values
					('470','1'),('470','6'),('470','80'),('470','229'),('470','338'),('470','340'),('470','341'),('470','342'),('470','378'),
					('470','379'),('470','384'),('470','385'),('470','387'),('470','388'),('470','390'),('470','391'),('470','477'),('470','490'),
					('471','338'),('471','340'),('471','341'),('471','342'),('471','379'),('471','385'),('471','388'),('471','391'),('471','477'),
					('472','338'),('472','340'),('472','341'),('472','342'),('472','477'),('473','338'),('473','340'),('473','341'),('473','342'),
					('473','477');");

		$cekdata = $this->isColumnExist('perkaraputusanterdakwa','ID');
        if($cekdata){
			$this->db->query("RENAME TABLE perkaraputusanterdakwa TO perkaraputusanterdakwaweb;");
        }
		
		$this->db->query("DROP VIEW IF EXISTS viewperkaraputusanterdakwa;");
		$this->db->query("DROP VIEW IF EXISTS viewperkaraputusanterdakwaweb;");
		$this->db->query("CREATE VIEW viewperkaraputusanterdakwaweb AS 
							SELECT
							  p.id                      AS ID,
							  p.perkara_id              AS IDPerkara,
							  pp.status_putusan_id      AS IDStatusPutusan,
							  (CASE WHEN (v_perkara.pihak_dipublikasikan = 'T') THEN CONVERT(CONCAT('Terdakwa',p.urutan) USING latin1) WHEN (v_perkara.alur_perkara_id = 118) THEN CONVERT(CONCAT('Anak Berhadapan Dengan Hukum ',p.urutan) USING latin1) ELSE p.nama END) AS nama,
							  pp.durasi_nominal         AS durasiNominal,
							  v_perkara.tanggal_putusan AS tglPutusan,
							  s.nama                    AS statusPutusan,
							  pp.satuan                 AS satuan
							FROM perkara_pihak2 AS p
							LEFT JOIN perkara_putusan_terdakwa AS pp ON pp.perkara_id=p.perkara_id AND pp.pihak2_id=p.id
							LEFT JOIN status_putusan AS s ON s.id=pp.status_putusan_id
							LEFT JOIN v_perkara ON v_perkara.perkara_id=pp.perkara_id
							WHERE v_perkara.alur_perkara_id>100
							ORDER BY p.urutan;");

		$this->db->query("DROP VIEW IF EXISTS viewpkweb;");		
		$this->db->query("CREATE VIEW viewpkweb AS 
							SELECT
							  perkara_pk.perkara_id                       AS IDPerkara,
							  perkara_pk.nomor_perkara_pk                 AS noPerkarapk,
							  perkara_pk.permohonan_pk                    AS tglPermohonan,
							  perkara_pk.pemohon_pk                       AS pemohon,
							  perkara_pk.pemberitahuan_pk                 AS tglPemberitahuanPermohonan,
							  perkara_pk.penerimaan_memori_pk             AS tglPenerimaanMemori,
							  perkara_pk.penyerahan_memori_pk             AS tglPenyerahanMemori,
							  perkara_pk.penerimaan_kontra_pk             AS tglPenerimaanKontra,
							  perkara_pk.penyerahan_kontra_pk             AS tglPenyerahanKontra,
							  perkara_pk.pemberitahuan_inzage_pemohon_pk  AS tglPemberitahuanInzagePihak1,
							  perkara_pk.pemberitahuan_inzage_termohon_pk AS tglPemberitahuanInzagePihak2,
							  perkara_pk.pelaksanaan_inzage_pemohon_pk    AS tglPelaksanaanInzagePihak1,
							  perkara_pk.pelaksanaan_inzage_termohon_pk   AS tglPelaksanaanInzagePihak2,
							  perkara_pk.pengiriman_berkas_pk             AS tglPengirimanBerkas,
							  perkara_pk.nomor_surat_pengiriman_berkas_pk AS nomorSuratPengiriman,
							  perkara_pk.penerimaan_berkas_pk             AS tglPenerimaanKembaliBerkas,
							  perkara_pk.majelis_hakim_pk                 AS majelisHakim,
							  perkara_pk.panitera_pengganti_pk            AS paniteraPengganti,
							  perkara_pk.putusan_pk                       AS tglPutusan,
							  perkara_pk.nomor_putusan_pk                 AS noPutusanPK,
							  perkara_pk.amar_putusan_pk                  AS amarPutusan,
							  perkara_pk.minutasi_pk                      AS tglMinutasi,
							  perkara_pk.pemberitahuan_putusan_pk_pihak1  AS tglPemberitahuanPutusanPihak1,
							  perkara_pk.pemberitahuan_putusan_pk_pihak2  AS tglPemberitahuanPutusanPihak2
							FROM perkara_pk;");
		
		$this->db->query("DROP VIEW IF EXISTS viewpkdetilweb;");
		$this->db->query("CREATE VIEW viewpkdetilweb AS 
							SELECT
							  pk.id                       AS ID,
							  pk.perkara_id               AS IDPerkara,
							  (CASE WHEN ((p.jenis_perkara_id IN (248,312)) AND (pk.pihak_asal = 2)) THEN 'Anak Berhadapan dengan Hukum' WHEN (p.jenis_perkara_id IN (64,98,242,346,347,349,350,352)) THEN 'disamarkan' ELSE pk.pihak_nama END) AS nama,
							  pk.status_pihak_id          AS IDStatusPihak,
							  CONCAT(IFNULL(pk.status_pihak_text,''),' (',pk.pihak_asal_text,')') AS statusPihak,
							  (CASE WHEN ((p.jenis_perkara_id IN (248,312)) AND (pk.pihak_asal = 2)) THEN 'Anak Berhadapan dengan Hukum' WHEN (p.jenis_perkara_id IN (64,98,242,346,347,349,350,352)) THEN 'disamarkan' ELSE pk.pihak_nama END) AS pihak_nama,
							  pk.pihak_diwakili           AS pihak_diwakili,
							  pk.pemohon_nama             AS pemohon_nama,
							  pk.permohonan_pk            AS tglPermohonan,
							  pk.pemberitahuan_pk         AS tglPemberitahuanPermohonan,
							  pk.penerimaan_memori_pk     AS tglPenerimaanMemori,
							  pk.penyerahan_memori_pk     AS tglPenyerahanMemori,
							  pk.penerimaan_kontra_pk     AS tglPenerimaanKontra,
							  pk.penyerahan_kontra_pk     AS tglPenyerahanKontra,
							  pk.pemberitahuan_inzage_pk  AS tglPemberitahuanInzage,
							  pk.pelaksanaan_inzage_pk    AS tglPelaksanaanInzage,
							  pk.pemberitahuan_putusan_pk AS tglPemberitahuanPutusan,
							  pk.tanggal_cabut            AS tglCabut
							FROM perkara_pk_detil AS pk
							LEFT JOIN perkara AS p ON p.perkara_id=pk.perkara_id;");
		
		$this->db->query("DROP TABLE IF EXISTS pkweb;");
		$this->db->query("CREATE TABLE pkweb AS SELECT * FROM viewpkweb;");

		$cekdata = $this->isColumnExist('pkweb','IDPerkara');
        if($cekdata){
		$this->db->query("ALTER TABLE pkweb ADD PRIMARY KEY (IDPerkara);");
        }

        $this->db->query("DROP TABLE IF EXISTS pkdetilweb;"); 
		$this->db->query("CREATE TABLE pkdetilweb AS SELECT * FROM viewpkdetilweb;");
		$cekdata = $this->isColumnExist('pkdetilweb','ID');
        if($cekdata){
		$this->db->query("ALTER TABLE pkdetilweb ADD PRIMARY KEY (ID);");
        }

        $this->db->query("DROP VIEW vieweksekusidetilweb;");
        $this->db->query("CREATE VIEW vieweksekusidetilweb AS
							SELECT
							  perkara_eksekusi_detil.id                  AS ID,
							  perkara_eksekusi_detil.perkara_id          AS IDPerkara,
							  perkara_eksekusi_detil.pihak_nama          AS nama,
							  perkara_eksekusi_detil.status_pihak_id     AS IDStatusPihak,
							  CONCAT(perkara_eksekusi_detil.status_pihak_text,'(',perkara_eksekusi_detil.pihak_asal_text,')') AS statusPihak,
							  IF((perkara_eksekusi_detil.pihak_diwakili = 'Y'),perkara_eksekusi_detil.pemohon_nama,NULL) AS pihakDimohonkan,
							  perkara_eksekusi_detil.permohonan_eksekusi AS tglPemberitahuanPermohonan
							FROM perkara_eksekusi_detil;");

        $this->db->query("DROP VIEW vieweksekusiweb;");
        $this->db->query("CREATE VIEW vieweksekusiweb AS
							SELECT
								perkara_eksekusi.perkara_id AS IDPerkara,
								perkara_eksekusi.alur_perkara_id AS IDAlurPerkara,
								perkara_eksekusi.nomor_perkara_pn AS noPerkaraPN,
								perkara_eksekusi.putusan_pn AS PutusanPN,
								perkara_eksekusi.nomor_perkara_banding AS noPerkaraBanding,
								perkara_eksekusi.putusan_banding AS putusanBanding,
								perkara_eksekusi.nomor_perkara_kasasi AS noPerkaraKasasi,
								perkara_eksekusi.putusan_kasasi AS putusanKasasi,
								perkara_eksekusi.nomor_perkara_pk AS noPerkaraPK,
								perkara_eksekusi.putusan_pk AS putusanPK,
								perkara_eksekusi.eksekusi_putusan AS eksekusiPutusan,
								perkara_eksekusi.eksekusi_nomor_perkara AS eksekusiNomorPerkara,
								perkara_eksekusi.eksekusi_amar_putusan AS eksekusiAmarPutusan,
								perkara_eksekusi.pihak_pemohon_eksekusi AS pihakPemohonEksekusi,
								perkara_eksekusi.permohonan_eksekusi AS permohonanEsekusi,
								perkara_eksekusi.pemohon_eksekusi AS pemohonEksekusi,
								perkara_eksekusi.para_pihak AS paraPihak,
								perkara_eksekusi.penetapan_teguran_eksekusi AS penetapanTeguranEksekusi,
								perkara_eksekusi.nomor_penetapan_teguran_eksekusi AS nomorPenetapanTeguranEksekusi,
								perkara_eksekusi.pelaksanaan_teguran_eksekusi AS pelaksanaanTeguranEksekusi,
								perkara_eksekusi.penetapan_sita_eksekusi AS penetapanSitaEksekusi,
								perkara_eksekusi.nomor_penetapan_sita_eksekusi AS nomorPenetapanSitaEksekusi,
								perkara_eksekusi.pelaksanaan_sita_eksekusi AS pelaksanaanSitaEksekusi,
								perkara_eksekusi.jurusita_nama AS jurusitaNama,
								perkara_eksekusi.penetapan_perintah_eksekusi_lelang AS penetapanPerintahEksekusiLelang,
								perkara_eksekusi.pelaksanaan_eksekusi_lelang AS pelaksanaanEksekusiLelang,
								perkara_eksekusi.penyerahan_hasil_lelang AS penyerahanHasilLelang,
								perkara_eksekusi.penetapan_perintah_eksekusi_rill AS penetapanPerintahEksekusiRill,
								perkara_eksekusi.pelaksanaan_eksekusi_rill AS pelaksanaanEksekusiRill,
								perkara_eksekusi.penetapan_noneksekusi AS penetapanNoneksekusi,
								perkara_eksekusi.diterima_permohonan AS diterimaPermohonan,
								perkara_eksekusi.panggilan_parapihak AS panggilanParapihak,
								perkara_eksekusi.penetapan_ketua AS penetapanKetua,
								perkara_eksekusi.sk_objek_tidak_punya_kekuatan_hukum AS skObjekTidakPunyaKekuatanHukum,
								perkara_eksekusi.surat_tergugat_objek_non_executable AS suratTergugatObjekNonExecutable,
								perkara_eksekusi.panggilan_pihak_non_executable AS panggilanPihakNonExecutable,
								perkara_eksekusi.upaya_kesepakatan_kompensasi AS upayaKesepakatanKompensasi,
								perkara_eksekusi.penetapan_ketua_kompensasi AS penetapanKetuaKompensasi,
								perkara_eksekusi.upaya_hukum_kma AS upayaHukumKma,
								perkara_eksekusi.penetapan_kma_kompensasi AS penetapanKmaKompensasi,
								perkara_eksekusi.uangpaksa_putusan_hakim AS uangpaksaPutusanHakim,
								perkara_eksekusi.uangpaksa_penetapan_ketua AS uangpaksaPenetapanKetua,
								perkara_eksekusi.surat_ketua_tergugat_uangpaksa AS suratKetuaTergugatUangpaksa,
								perkara_eksekusi.surat_peringatan_uangpaksa AS suratPeringatanUangpaksa,
								perkara_eksekusi.perintah_ketua_saksi_administratif AS perintahKetuaSaksiAdministratif,
								perkara_eksekusi.sanksi_administratif_dari_pejabat AS sanksiAministratifDariPejabat,
								perkara_eksekusi.pengumuman_ketua_panitera_js AS pengumumanKetuaPaniteraJs,
								perkara_eksekusi.pengumuman_media AS pengumumanMedia,
								perkara_eksekusi.surat_presiden AS surat_Pesiden,
								perkara_eksekusi.surat_lembaga_perwakilan_rakyat AS suratLembagaPerwakilanRakyat,
								perkara_eksekusi.alasan_eksekusi AS alasanEksekusi,
								perkara_eksekusi.catatan_eksekusi AS catatanEksekusi,
								perkara_eksekusi.prodeo_eksekusi AS prodeoEksekusi,
								perkara_eksekusi.status_eksekusi_text AS statusEksekusiText,
								perkara.prodeo AS prodeo,
								perkara.tanggal_pendaftaran AS tglPendaftaranAction
							FROM perkara_eksekusi
							LEFT JOIN perkara ON perkara_eksekusi.perkara_id=perkara.perkara_id;");
		
		$this->db->query("DROP TABLE IF EXISTS eksekusidetilweb;");
		$this->db->query("CREATE TABLE eksekusidetilweb AS SELECT * FROM vieweksekusidetilweb;");

		$cekdata = $this->isColumnExist('eksekusidetilweb','ID');
        if($cekdata){
		$this->db->query("ALTER TABLE eksekusidetilweb ADD PRIMARY KEY (ID);");
        }

		$this->db->query("DROP TABLE IF EXISTS eksekusiweb;");
		$this->db->query("CREATE TABLE eksekusiweb AS SELECT * FROM vieweksekusiweb;");
		$cekdata = $this->isColumnExist('eksekusiweb','IDPerkara');
        if($cekdata){
		$this->db->query("ALTER TABLE eksekusiweb ADD PRIMARY KEY (IDPerkara);");
        }

		$this->db->query("DROP PROCEDURE IF EXISTS updateTable;");
		$this->db->query("CREATE PROCEDURE updateTable()
							BEGIN
								DELETE FROM dataumumweb;
								REPLACE INTO dataumumweb SELECT * FROM viewdataumumweb;
								DELETE FROM jenisperkaraweb;
								REPLACE INTO jenisperkaraweb SELECT * FROM viewjenisperkaraweb;
								DELETE FROM pihakweb;
								REPLACE INTO pihakweb SELECT * FROM viewpihakweb;
								DELETE FROM pengacaraweb;
								REPLACE INTO pengacaraweb SELECT * FROM viewpengacaraweb;
								DELETE FROM hakimweb;
								REPLACE INTO hakimweb SELECT * FROM viewhakimweb;
								DELETE FROM ppweb;
								REPLACE INTO ppweb SELECT * FROM viewppweb;
								DELETE FROM jurusitaweb;
								REPLACE INTO jurusitaweb SELECT * FROM viewjurusitaweb;
								DELETE FROM mediasiweb;
								REPLACE INTO mediasiweb SELECT * FROM viewmediasiweb;
								DELETE FROM jadwalsidangweb;
								REPLACE INTO jadwalsidangweb SELECT * FROM viewjadwalsidangweb;
								DELETE FROM perkarabiayaweb;
								REPLACE INTO perkarabiayaweb SELECT * FROM viewperkarabiayaweb ORDER BY idperkara,tgltransaksi ASC;
								DELETE FROM verzetweb;
								REPLACE INTO verzetweb SELECT * FROM viewverzetweb;
								DELETE FROM penahananweb;
								REPLACE INTO penahananweb SELECT * FROM viewpenahananweb;
								DELETE FROM putusanselaweb;
								REPLACE INTO putusanselaweb SELECT * FROM viewputusanselaweb;
								DELETE FROM pihakintervensiweb;
								REPLACE INTO pihakintervensiweb SELECT * FROM viewpihakintervensiweb;
								DELETE FROM bandingweb;
								REPLACE INTO bandingweb SELECT * FROM viewbandingweb;
								DELETE FROM bandingdetilweb;
								REPLACE INTO bandingdetilweb SELECT * FROM viewbandingdetilweb;
								DELETE FROM diversiweb;
								REPLACE INTO diversiweb SELECT * FROM viewdiversiweb;
								DELETE FROM eksekusiweb;
								REPLACE INTO eksekusiweb SELECT * FROM vieweksekusiweb;
								DELETE FROM eksekusidetilweb;
								REPLACE INTO eksekusidetilweb SELECT * FROM vieweksekusidetilweb; 
								DELETE FROM kasasiweb;	
								REPLACE INTO kasasiweb SELECT * FROM viewkasasiweb;
								DELETE FROM kasasidetilweb;
								REPLACE INTO kasasidetilweb SELECT * FROM viewkasasidetilweb;
								DELETE FROM pkweb;
								REPLACE INTO pkweb SELECT * FROM viewpkweb;
								DELETE FROM pkdetilweb;
								REPLACE INTO pkdetilweb SELECT * FROM viewpkdetilweb;
								DELETE FROM prosesweb;
								REPLACE INTO prosesweb SELECT * FROM viewprosesweb;
								DELETE FROM grasiweb;
								REPLACE INTO grasiweb SELECT * FROM viewgrasiweb;
								DELETE FROM perkarapenuntutanweb;
								REPLACE INTO perkarapenuntutanweb SELECT * FROM viewperkarapenuntutanweb;   
								DELETE FROM actiopaulianaweb;
								REPLACE INTO actiopaulianaweb SELECT * FROM viewactiopaulianaweb;
								DELETE FROM perkaraprosesweb;
								REPLACE INTO perkaraprosesweb SELECT * FROM viewperkaraprosesweb;
								DELETE FROM perkarakeberatanweb;
								REPLACE INTO perkarakeberatanweb SELECT * FROM viewperkarakeberatanweb;
								DELETE FROM perkaraeksekusihtweb;
								REPLACE INTO perkaraeksekusihtweb SELECT * FROM viewperkaraeksekusihtweb;
								DELETE FROM putusanpemberitahuanweb;
								REPLACE INTO putusanpemberitahuanweb SELECT * FROM viewputusanpemberitahuanweb;
								DELETE FROM barangbuktiweb;
								REPLACE INTO barangbuktiweb SELECT * FROM viewbarangbuktiweb;
								DELETE FROM perkaralalulintasweb;
								REPLACE INTO perkaralalulintasweb SELECT * FROM viewperkaralalulintasweb;
								DELETE FROM perkaraputusanweb;
								REPLACE INTO perkaraputusanweb SELECT * FROM viewperkaraputusanweb;
								DELETE FROM perkaraputusanterdakwaweb;
								REPLACE INTO perkaraputusanterdakwaweb SELECT * FROM viewperkaraputusanterdakwaweb;
								DELETE FROM rekonvensiweb;
								REPLACE INTO rekonvensiweb SELECT * FROM viewrekonvensiweb;
								DELETE FROM alurperkaraweb;
								REPLACE INTO alurperkaraweb SELECT * FROM viewalurperkaraweb;
								DELETE FROM statuspihakweb;
								REPLACE INTO statuspihakweb SELECT * FROM viewstatuspihakweb;
								DELETE FROM ikrarweb;
								REPLACE INTO ikrarweb SELECT * FROM viewikrarweb;
								DELETE FROM perkaramatraweb;
								REPLACE INTO perkaramatraweb SELECT * FROM viewperkaramatraweb;
								DELETE FROM panggilandismissalweb;
								REPLACE INTO panggilandismissalweb SELECT * FROM viewpanggilandismissalweb;
								DELETE FROM penetapandismissalweb;
								REPLACE INTO penetapandismissalweb SELECT * FROM viewpenetapandismissalweb;
								DELETE FROM sidangpertamaweb;
								REPLACE INTO sidangpertamaweb SELECT * FROM viewsidangpertamaweb;
								DELETE FROM penetapanpersiapanweb;
								REPLACE INTO penetapanpersiapanweb SELECT * FROM viewpenetapanpersiapanweb;
								DELETE FROM penetapanpersiapanprosesweb;
								REPLACE INTO penetapanpersiapanprosesweb SELECT * FROM viewpenetapanpersiapanprosesweb;
								DELETE FROM statusputusanweb;
								REPLACE INTO statusputusanweb SELECT * FROM viewstatusputusanweb;
								DELETE FROM jenisperkaraweb;
								REPLACE INTO jenisperkaraweb SELECT * FROM viewjenisperkaraweb;
								DELETE FROM delegasikeluarweb;
								REPLACE INTO delegasikeluarweb SELECT * FROM viewdelegasikeluarweb;
								DELETE FROM delegasimasukweb;
								REPLACE INTO delegasimasukweb SELECT * FROM viewdelegasimasukweb;
								DELETE FROM delegasiproseskeluarweb;
								REPLACE INTO delegasiproseskeluarweb SELECT * FROM viewdelegasiproseskeluarweb;
								DELETE FROM delegasiprosesmasukweb;
								REPLACE INTO delegasiprosesmasukweb SELECT * FROM viewdelegasiprosesmasukweb;
							END");
		#314 end
		#315
		$this->db->query("REPLACE into `jenis_perkara` (`id`, `nama`, `nama_lengkap`, `format_nomor`, `diinput_oleh`, `diinput_tanggal`) VALUES('624','Gugatan Memperoleh Akta Perdamaian Atas Kesepakatan Perdamaian di Luar Pengadilan','Gugatan Memperoleh Akta Perdamaian Atas Kesepakatan Perdamaian di Luar Pengadilan','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PN #kode_pn#','admin2','2016-11-24 16:21:26');");

		$this->db->query("REPLACE INTO `jenis_alur_perkara` (alur_perkara_id,jenis_perkara_id) VALUES (1,624),(15,624);");

		$this->db->query("REPLACE INTO `jenis_biaya` (id,tahapan_id,jenis_transaksi,kategori_id,nama,keterangan,diinput_oleh, diinput_tanggal) VALUES (380,10,-1,4,'Biaya Panggilan Mediasi Penggugat','Biaya Panggilan Mediasi Penggugat','admin','2016-11-24 10:32:57'),(381,10,-1,4,'Biaya Panggilan Mediasi Tergugat','Biaya Panggilan Mediasi Tergugat','admin','2016-11-24 10:32:57');");

		$this->db->query("REPLACE INTO `biaya_perkara` (alur_perkara_id,jenis_biaya_id,jumlah) VALUES (1,380,'0.00'),(1,381,'0.00'),(7,380,'0.00'),(7,381,'0.00'),(15,380,'0.00'),(15,381,'0.00');");

		$this->db->query("REPLACE INTO status_putusan (id,jenis_perkara_id,nama,urutan,jenis_pengadilan,diinput_oleh, diinput_tanggal) VALUES (85,1,'Perdamaian',7,4,'admin','2016-11-29 20:37:31');");

		$this->db->query("UPDATE sys_menus SET params = 'varlist_alur_perkara_id=1,2,7,8' WHERE id = '207';");
		$this->db->query("REPLACE INTO `sys_menus` (`id`,`menutype`, `parent_id`, `title`, `link`, `published`,`ordering`) VALUES ('6005','mainmenu', '107', 'Blanko Template', 'blanko_template', '1','4');");
		$this->db->query("REPLACE INTO `status_putusan` (`id`, `jenis_perkara_id`, `nama`, `urutan`, `satuan`, `diinput_oleh`, `diinput_tanggal`) VALUES ('86', '2', 'Terdakwa Meninggal Dunia', '19', '3', 'admin', '2016-12-04 11:18:50'),
			('87', '2', 'Terdakwa Melarikan Diri', '20', '3', 'admin', '2016-12-04 11:19:48');");
		$this->db->query("DELETE FROM `status_penahanan` WHERE `id` = '5';");
		$this->db->query("REPLACE INTO `sys_menus` (`id`,`menutype`, `parent_id`, `title`, `link`, `published`,`ordering`) VALUES ('6004','mainmenu', '702', 'Blanko Template', 'blanko_template', '1','8');");
		$this->db->query("REPLACE into `sys_menus` (`id`, `menutype`, `parent_id`, `level`, `title`, `link`, `params`, `published`, `ordering`) VALUES ('6006','mainmenu',NULL,'1','About','',NULL,'0','0'),('6007','mainmenu','6006','1','Buku Panduan','buku_panduan','fa-edit','0','0'),('6008','mainmenu','6006','1','Tentang SIPP','tentang_sipp','fa-exclamation-circle ','1','0');");
		$this->db->query("REPLACE INTO `sys_menus` (id,menutype,parent_id,LEVEL,title,link,params,published) VALUES (6010,'mainmenu','6006','1','Catatan Pembaruan','release_note','fa-gear','1');");
		$this->db->query("REPLACE into `template_dokumen` (`id`, `alur_perkara_id`, `tahapan_id`, `proses_id`, `nomor`, `kode`, `nama`) VALUES('2089','0',NULL,NULL,NULL,'I_02','Pernyataan Pihak Tentang Penjelasan Mediasi'),
					('2090','0',NULL,NULL,NULL,'I_03','Penetapan Mediasi dan Penunjukkan Mediator'),
					('2091','1','14','200','363','PDT_1_14_200_363','Berita Acara Sidang Pertama (Penjelasan Majelis Hakim tentang Mediasi)'),
					('2092','0',NULL,NULL,NULL,'I_05','Relaas Panggilan Mediasi Kepada Penggugat'),
					('2093','0',NULL,NULL,NULL,'I_06','Relaas Panggilan Mediasi Kepada Tergugat'),
					('2094','0',NULL,NULL,NULL,'I_07','Blanko Jadwal Mediasi'),
					('2095','0',NULL,NULL,NULL,'I_08','Blanko Resume Perkara'),
					('2096','0',NULL,NULL,NULL,'I_09','Kesepakatan Perdamaian'),
					('2097','0',NULL,NULL,NULL,'I_10','Kesepakatan Perdamaian Sebagian Pihak/Subjek'),
					('2098','0',NULL,NULL,NULL,'I_11','Kesepakatan Perdamaian Sebagian Tuntutan Hukum/Objek'),
					('2099','0',NULL,NULL,NULL,'I_12','Pernyataan Para Pihak Yang Diwakili Oleh Kuasa Hukum Tentang Persetujuan Atas Kesepakatan Perdamaian'),
					('2100','0',NULL,NULL,1,'I_13','Blanko Kesepakatan Perdamanan (diluar Pengadilan) untuk dikukuhkan dengan Akta'),
					('2101','0',NULL,NULL,1,'I_14','Blanko Gugatan Memperoleh Akta Perdamaian di Luar Pengadilan'),
					('2102','0',NULL,NULL,NULL,'I_15','Akta Perdamaian'),
					('2103','0',NULL,NULL,NULL,'I_16','Laporan Mediator Kepada Hakim Pemeriksa Perkara Tentang Hasil Mediasi'),
					('2104','0',NULL,NULL,NULL,'I_17','Pernyataan Para Pihak Tentang Hasil Mediasi'),
					('2105','0',NULL,NULL,NULL,'I_18','Laporan Mediator Tentang Hasil Mediasi (Pihak Beritikad Tidak Baik)'),
					('2106','0',NULL,NULL,NULL,'I_19','Putusan Akhir (Penggugat tidak beritikad baik)'),
					('2107','0',NULL,NULL,NULL,'I_20','Penetapan (Tergugat yang tidak beritikad baik)'),
					('2108','0',NULL,NULL,NULL,'I_21','Putusan (Gugatan ditolak tetapi Tergugat tidak beritikad baik dalam mediasi dan dihukum membayar biaya mediasi)'),
					('2109','0',NULL,NULL,NULL,'I_15_1','Akta Perdamaian'),
					('2110','0',NULL,NULL,NULL,'I_01','Formulir Kata-kata Penjelasan Mediasi oleh Ketua Majelis');");

		$cekkolum = $this->isColumnExist('perkara_mediasi','jenis_mediasi');  		
        if($cekkolum){
			$this->db->query("ALTER TABLE `perkara_mediasi` CHANGE `jenis_mediasi` `jenis_mediasi` TINYINT(1) DEFAULT 1  NULL  COMMENT '1:mediasi wajib, 2:mediasi sukarela 3:mediasi diluar pengadilan';");
        }

        $cekkolum = $this->isColumnExist('perkara_jadwal_mediasi','dihadiri_oleh');  		
        if(!$cekkolum){
        	$this->db->query("ALTER TABLE `perkara_jadwal_mediasi` ADD COLUMN `dihadiri_oleh` CHAR(1) NULL  COMMENT '1. Semua Pihak, 2.Penggugat Saja, 3.Tergugat Saja, 4.Semua Pihak Tidak Hadir' AFTER `tempat`;");
        }

        $cekkolum = $this->isColumnExist('perkara_jadwal_mediasi','jam_mediasi');  		
        if(!$cekkolum){
        	$this->db->query("ALTER TABLE `perkara_jadwal_mediasi` ADD COLUMN `jam_mediasi` TIME NULL AFTER `tanggal_mediasi`,
  				ADD COLUMN `sampai_jam` TIME NULL AFTER `jam_mediasi`;");
        }

        $cekkolum = $this->isColumnExist('perkara_mediasi','hasil_mediasi');  		
        if($cekkolum){
        	$this->db->query("ALTER TABLE `perkara_mediasi` 
  			CHANGE `hasil_mediasi` `hasil_mediasi` CHAR(2) CHARSET latin1 COLLATE latin1_swedish_ci NULL COMMENT 'Hasil Mediasi: pilihan (Y1=Berhasil Dengan Kesepatakan; Y2:Berhasil Dengan Pencabutan, S=Berhasil Sebagian; T=Tidak Berhasil; D=Tidak dapat dilaksanakan)';");
        }
        $cekkolum = $this->isColumnExist('perkara_mediasi','status_mediator');  		
        if($cekkolum){
        	$this->db->query("ALTER TABLE `perkara_mediasi` 
  			CHANGE status_mediator status_mediator VARCHAR(50) CHARSET latin1 COLLATE latin1_swedish_ci NULL COMMENT 'Status Mediator: merujuk ke tabel perkara_mediasi kolom status_mediator (by system)';");
        }
        $cekkolum = $this->isColumnExist('perkara_mediasi','tgl_kesepakatan_perdamaian');  		
        if(!$cekkolum){
        	$this->db->query("ALTER TABLE `perkara_mediasi` 
  			ADD COLUMN `tgl_kesepakatan_perdamaian` DATE NULL AFTER `mediasi_berhasil`;");
        }
        $cekkolum = $this->isColumnExist('perkara_mediasi','tgl_pengajuan_kesepakatan');  		
        if(!$cekkolum){
        	$this->db->query("ALTER TABLE `perkara_mediasi` 
  			ADD COLUMN `tgl_pengajuan_kesepakatan` DATE NULL AFTER `tgl_kesepakatan_perdamaian`;");
        }
        $cekkolum = $this->isColumnExist('perkara_mediasi','isi_kesepakatan_perdamaian');  		
        if(!$cekkolum){
        	$this->db->query("ALTER TABLE `perkara_mediasi` 
  			ADD COLUMN `isi_kesepakatan_perdamaian` LONGTEXT NULL AFTER `tgl_pengajuan_kesepakatan`;");
        }

        $this->db->query("DROP TABLE IF EXISTS `perkara_data_dukung_mediasi`;");
  		$this->db->query("CREATE TABLE `perkara_data_dukung_mediasi` (
						  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
						  `perkara_id` bigint(20) DEFAULT NULL,
						  `mediasi_id` bigint(20) NOT NULL COMMENT 'fk perkara_mediasi',
						  `identifier` varchar(30) NOT NULL COMMENT 'varibel template',
						  `kode_template` varchar(30) NOT NULL COMMENT 'kode template',
						  `uraian` longtext NOT NULL COMMENT 'isi variabel',
						  `nilai` int(11) DEFAULT NULL COMMENT 'jika ada',
						  PRIMARY KEY (`id`),
						  KEY `mediasi_id` (`mediasi_id`),
						  CONSTRAINT `perkara_data_dukung_mediasi_ibfk_1` FOREIGN KEY (`mediasi_id`) REFERENCES `perkara_mediasi` (`mediasi_id`) ON DELETE CASCADE
						) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=latin1;");

  		$cekkolum = $this->isColumnExist('mediator','tempat_lahir');  		
        if(!$cekkolum){
        	$this->db->query("ALTER TABLE `mediator` ADD COLUMN `tempat_lahir` VARCHAR(50) DEFAULT   NULL AFTER `nama_gelar`;");
        }
        $cekkolum = $this->isColumnExist('mediator','tgl_lahir');  		
        if(!$cekkolum){
        	$this->db->query("ALTER TABLE `mediator` ADD COLUMN `tgl_lahir` DATE NULL AFTER `tempat_lahir`;");
        }
        $cekkolum = $this->isColumnExist('mediator','pendidikan_id');  		
        if(!$cekkolum){
        	$this->db->query("ALTER TABLE `mediator` ADD COLUMN `pendidikan_id` INT(11) NULL  COMMENT 'Id Tingkat Pendidikan Terakhir: merujuk ke tabel tingkat_pendidikan kolom id' AFTER `tgl_lahir`;");
        }
        $cekkolum = $this->isColumnExist('mediator','pendidikan');  		
        if(!$cekkolum){
        	$this->db->query("ALTER TABLE `mediator` ADD COLUMN `pendidikan` VARCHAR(50) NULL AFTER `pendidikan_id`;");
        }
        $cekkolum = $this->isColumnExist('mediator','keahlian');  		
        if(!$cekkolum){
        	$this->db->query("ALTER TABLE `mediator` ADD COLUMN `keahlian` TEXT NULL  COMMENT 'keahlian / pengalaman' AFTER `lembaga_sertifikasi`;");
        }
        $cekkolum = $this->isColumnExist('mediator','foto');  		
        if(!$cekkolum){
        	$this->db->query("ALTER TABLE `mediator` ADD COLUMN `foto` VARCHAR(100) CHARSET latin1 COLLATE latin1_swedish_ci NULL AFTER `aktif`;");
        }
        $cekkolum = $this->isColumnExist('mediator','alamat');  		
        if(!$cekkolum){
        	$this->db->query("ALTER TABLE `mediator` ADD COLUMN `alamat` VARCHAR(255) NULL AFTER `pendidikan`;");
        }
        $cekkolum = $this->isColumnExist('mediator','nomor_sk_ketua');  		
        if(!$cekkolum){
        	$this->db->query("ALTER TABLE `mediator` ADD COLUMN `nomor_sk_ketua` VARCHAR(50) NULL  COMMENT 'nomor SK Penetapan Mediator oleh Ketua' AFTER `keahlian`;");
        }
        $cekkolum = $this->isColumnExist('mediator','tgl_sk_ketua');  		
        if(!$cekkolum){
        	$this->db->query("ALTER TABLE `mediator` ADD COLUMN `tgl_sk_ketua` DATE NULL  COMMENT 'tanggal SK Penetapan Mediator oleh Ketua' AFTER `nomor_sk_ketua`;");
        }
        $cekkolum = $this->isColumnExist('mediator','keterangan');  		
        if($cekkolum){
        	$this->db->query("ALTER TABLE `mediator` CHANGE `keterangan` `keterangan` TEXT CHARSET latin1 COLLATE latin1_general_ci NULL  COMMENT 'Keterangan: isian bebas';");
        }

        $cekkolum = $this->isColumnExist('perkara_banding','putusan_pn');  		
        if($cekkolum){
        	$this->db->query("ALTER TABLE `perkara_banding` CHANGE `putusan_pn` `putusan_pn` DATE NULL  COMMENT 'Tanggal Putusan PN/Putusan Verzet';");
        }

        $cekkolum = $this->isColumnExist('perkara_putusan_sela','is_keberatan_diterima');  		
        if(!$cekkolum){
        	$this->db->query("ALTER TABLE `perkara_putusan_sela` ADD COLUMN `is_keberatan_diterima` CHAR(1)  NULL  COMMENT 'Untuk Alur perkara 111, 1. Keberatan Diterima 2. Keberatan Ditolak' AFTER `tanggal_putusan_sela`;");
        }

        $this->db->query("DROP TABLE IF EXISTS `updates_catatan`;");
        $this->db->query("CREATE TABLE `updates_catatan` (
						  `id` bigint(20) NOT NULL AUTO_INCREMENT,
						  `update_id` int(11) NOT NULL,
						  `deskripsi` text,
						  PRIMARY KEY (`id`),
						  KEY `update_id` (`update_id`),
						  CONSTRAINT `updates_catatan_ibfk_1` FOREIGN KEY (`update_id`) REFERENCES `updates` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
						) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=latin1");

        $this->db->query("REPLACE INTO updates_catatan (id,update_id,deskripsi) VALUES 
					(1,1,'Prasyarat Pihak Tergugat/Terdakwa. Menghilangkan Prasyarat Tanggal Lahir dan Umur'),
					(2,1,'Menampilkan Link Edit Penahanan di Data Umum untuk Hak akses Sebagai PP'),
					(3,1,'Validasi Jurnal Biaya, Menghindari Panjar Biaya agar tidak dapat dihapus.'),
					(4,1,'Perbaikan Pada Pencatatan Riwayat Perkara Mediasi'),
					(5,1,'Perbaikan Validasi BHT. Menghapus Pengecekan Tanggal Minutasi pada input BHT'),
					(6,1,'Menghapus Validasi pengecekan tgl Minutasi pada Banding'),
					(7,1,'MenghapusValidasi pengecekan tgl Minutasi pada Kasasi'),
					(8,1,'Menghapus Validasi umur <12 atau >21 pd alur 118 pd korban dan saksi'),
					(9,1,'Perbaikan Pada Hak Akses PANMUD sebagai Panitera Pengganti'),
					(10,1,'Perbaikan Pada Laporan pidana anak'),
					(11,1,'Perbaikan Pada Laporan praperadilan'),
					(12,1,'Menghapus Informasi Mediasi Pada Tab Banding Perkara Pidana'),
					(13,1,'Perbaikan pada Template Penetapan Majelis Hakim/Hakim oleh Ketua Pengadilan pada perkara pidana.'),
					(14,1,'Perbaikan Validasi Jadwal Sidang'),
					(15,1,'Perbaikan Hari pada template Penetapan Hari Sidang Pertama Gugatan'),
					(16,1,'Perbaikan Pencatatan Jam Pada template Penetapan Hari Sidang Pertama Pidana'),
					(17,1,'Perbaikan pada Tambah pihak di kasasi perdata nama lengkap, Mengizinkan Karakter Titik dan Koma'),
					(18,1,'Perbaikan Pada Menu Cabut Kasasi'),
					(19,1,'Perbaikan Pada Template pidana banding'),
					(20,1,'Perbaikan Pada Jurnal Biaya, Jumlah Tambahan Panjar Biaya Perkara.'),
					(21,1,'Perbaikan Pada Menu Penahanan'),
					(22,1,'Perbaikan Status Perkara diversi berhasil'),
					(23,1,'Perbaikan Pada Sisa pidana anak Yang tidak tampil untuk perkara yang tidak diversi'),
					(24,1,'Perbaikan Penamaan Terdakwa Pada template penetapan hari sidang, jika terdakwa lebih dari 1'),
					(25,1,'Perbaikan pada jumlah hari penahanan'),
					(26,1,'Perbaikan export excell pada Laporan'),
					(27,1,'Perbaikan Hak Akses Meja 1 Tipikor dan PANMUD tipikor untuk Data Penahanan pada saat pendaftaran perkara tipikor'),
					(28,1,'Perbaikan Vaidasi Pihak Terdakwa Pada Peradilan Militer'),
					(29,1,'Perbaikan List Majelis Hakim Pada Slide Jadwal Sidang'),
					(30,1,'Mengizinkan User Panitera/Wapan untuk update/tambah saksi'),
					(31,1,'Perbaikan Pada Status perkara di dasboard Perkara Yang Belum Pemberitahuan Permohonan Banding'),
					(32,1,'Perbaikan Pada auto / manual format pidana'),
					(33,1,'Perbaikan Pada Jurnal permohonan kasasi utk Perdata Permohonan'),
					(34,1,'Perbaikan Pada cetak excel buku induk keuangan perdata umum'),
					(35,1,'Perbaikan Pada cetak excel daftar pesan keluar'),
					(36,1,'Perbaikan Pada Informasi Detil Perkara Lalu Lintas'),
					(37,1,'Perbaikan Pada Template Penetapan MH Pidana'),
					(38,1,'Perbaikan Pada Menu Template BA dengan jenisnya tergugat tidak hadir'),
					(39,1,'Perbaikan Pada perkara PHI prodeo, notifikasi materai dan redaksi muncul saat input minutasi'),
					(40,1,'Perbaikan Status perkara di dasboard Perkara Yang Belum Penyerahan Memori Kasasi Gugatan'),
					(41,1,'Perbaikan Pada key indikator perkara di dashboard'),
					(42,1,'Perbaikan Pada status terakhir pemberitahuan banding'),
					(43,1,'Perbaikan Pada Template AKTA PENERIMAAN MEMORI KASASI'),
					(44,1,'Perbaikan Pada Template AKTA PENERIMAAN MEMORI KASASI dan Kontra Memori Kasasi'),
					(45,1,'Perbaikan Pada Template Penyerahan Memori Kasasi '),
					(46,1,'Perbaikan Pada Data Umum Militer pada data hasil Migrasi'),
					(47,1,'Perbaikan Validasi edit e-doc Data Umum pada Pengadilan Tata Usaha'),
					(48,1,'Perbaikan group users'),
					(49,1,'Perbaikan Pada Menu Delegasi'),
					(50,1,'Perbaikan Pada Menu kasasi and PK untuk pihak diwakili'),
					(51,1,'Perbaikan Search pada cari pihak kasasi diwakilkan'),
					(52,1,'Perbaikan Pada Salah (typo) Tanggal Pemberitahuan Penyerahan Memori Kasasi'),
					(53,1,'Perbaikan Laporan Kegiatan Hakim, nama double dan tidak sesuai progres bulan'),
					(54,1,'Perbaikan Pada Perkara yg di cabut, Untuk status perkara berubah yang berubah Penetapan Hari Sidang Pertama'),
					(55,1,'Perbaikan Pada Menu Saldo Awal'),
					(56,1,'Perbaikan Pada Jenis pendidikan SLTA muncul di priview Sekolah Lanjutan Tingkat Menengah, BAS pertama dan seluruh relaas panggilan dan PBTs'),
					(57,1,'Perbaikan Pada Error  upload dokumen dengan Ekstensi .RTF'),
					(58,1,'Perbaikan Pada Menu Penetapan Majelis Hakim Peradilan Agama, utk perkara cerai talak'),
					(59,1,'Perbaikan Pada Perkara gugur saat disimpan minta data faktor penyebab perceraian'),
					(60,1,'Perbaikan Pada search buku induk'),
					(61,1,'Perbaikan Hak Akses user panmud (agama) terkair BAS'),
					(62,1,'Perbaikan Untuk Mediasi Yang Tidak Keluar jika terdapat data mediasi lebih dari 1'),
					(63,1,'Perbaikan Pada Penetapan Hakim Pid.C, jika terdakwa Perempuan, jenis kelamin tertulis P, seharusnya Perempuan'),
					(64,1,'Perbaikan Pada Penetapan sidang pertama keberatan'),
					(65,1,'Perbaikan Pada Rekam data banding pidana status perkara menjadi Penetapan Majelis Hakim Ikrar Talak pada detil perkara'),
					(66,1,'Menampilkan Cetak template Gugatan Sederhana sebelum data putusan akhir di entry'),
					(67,1,'Menampilkan Buku Induk Gugatan Sederhana'),
					(68,1,'Menampilkan Buku Induk HHK Pdt.G.S'),
					(69,1,'Perbaikan nama jenis pihak putusan sela'),
					(70,1,'perbaikan penamaan pihak intervensi'),
					(71,1,'Perbaikan tampilan form pengacara'),
					(72,1,'Perbaikan Pada Putusan akhir terkait sumber hukum yang tidak keluar utk perdata and pemberitahuan untuk Pengadilan Militer'),
					(73,1,'Menampilkan Hak Ases Panmud untuk menyimpan data saksi'),
					(74,1,'Perbaikan type detil eksekusi dan grasi tab '),
					(75,1,'Perbaikan Pada Tab penetapan tidak keluar setelah ada data diversi'),
					(76,1,'Perbaikan Pada Template Putusan Terbukti'),
					(77,1,'Perbaikan Putusan Pidana Format Lepas'),
					(78,1,'Perbaikan Pada Menu Prodeo untuk Upaya Hukum Banding and Kasasi'),
					(79,1,'Perbaikan BA Hakim tunggal dan tampil penahanan pada BA Pertama'),
					(80,2,'Perbaikan Pada Detil Delegasi page not found'),
					(81,2,'Penambahan Jenis Perkara Permohonan UU AP dan Gugatan Keberatan KIP TUN'),
					(82,2,'Eksekusi HT Lelang'),
					(83,2,'Handler Pada Tanggal Minutasi untuk perkara lalu lintas diwabah tahun 2016'),
					(84,2,'Perbaikan Pada Eksekusi Perkara Gugatan Sederhana'),
					(85,2,'Penambahan Kewenangan Panitera dan Wapan untuk perkara yang ditangani, simpan saksi dan putusan akhir'),
					(86,3,'Tanggal Minutasi tdk bisa tersimpan bila sudah mengeluarkan biaya materai dan redaksi utk putusan sela'),
					(87,3,'Menu Delegasi:<li>Perbaikan Sorting kolom, searching dan paging di list perkara delegasi</li><li>Perbaikan Pada Validasi data yang wajib di isi (required)</li><li>Perbaikan Pada Pesan Warning Tanggal Pengiriman Berkas tidak boleh kosong seharusnya Tanggal Pelaksanaan Delegasi tidak boleh kosong</li>'),
					(88,3,'Untuk Tab biaya - Penambahan kolom sisa dan kekurangan biaya pelaksanaan'),
					(89,3,'Tab penunjukan jurusita - Perbaikan Pada Perkara yang tidak dapat memilih jurusita'),
					(90,3,'Perbaikan Pada Jurnal biaya BTH tingkat pertama yang Tidak Tampil'),
					(91,3,'Peradilan TUN:<li>Panggilan Persiapan TUN 2 kali tidak hadir gugur (tampil link putusan akhir)</li><li>Menu BHT untuk perlawanan TUN bila ditolak, gugur, cabut</li>'),
					(92,3,'Perbaikan detil jurnal perkara'),
					(93,3,'Perbaikan Pada perkara yg gugur karena Tidak dapat menambah Biaya panjar sehingga minutasi tidak dapat disimpan'),
					(94,3,'Perbaikan Penunjukan PP dan Jurusita oleh Panitera pada verzet'),
					(95,3,'Perbaikan menu Verzet terhadap perkara BTH'),
					(96,3,'Perbaikan Perkara BTH pk dan eksekusi'),
					(97,3,'Menampilkan Menu Putusan Akhir pada perkara Pidana Singkat dengan 1 kali sidang.'),
					(98,3,'Menghilangkan validasi wajib diisi pada Pihak turut tergugat'),
					(99,3,'Menghilangkan wajib mediasi pada jenis Perkara BPSK,PARPOL,KPPU'),
					(100,3,'Perbaikan warning atau pesan pada perkara kasasi dan pk'),
					(101,4,'Update setting pendaftaran/PNBP upaya hukum sesuai PP53 2008'),
					(102,4,'Perbaikan tabel delegasimasukweb dan delegasikeluarweb (tidak ada primary key)'),
					(103,4,'Update Alter table perkara_banding menyesuaikan dgn table perkara_banding PT'),
					(104,4,'Update Penahanan Pidana Anak sesuai UU No 11 Tahun 2012 dan update table proses Pembuatan minutasi menjadi minutasi'),
					(105,4,'Penambahan jenis perkara agama'),
					(106,4,'Perbaikan Delegasi Keluar, panggilan sidang masih ada warning tanggal sidang blm di isi'),
					(107,4,'-validasi tgl pelaksanaan delegasi masih bisa lebih dari hari ini, sehingga lama proses ada yang minus '),
					(108,4,'-pengadilan negeri asal delegasi masuk masih salah'),
					(109,4,'-turut tergugat delegasi'),
					(110,4,'-penunjukan jurusita/jurusita pengganti yg aktif saja'),
					(111,4,'-Perbaikan laporan keadaan perkara, penambahan nomor 5 Putus Bulan ini'),
					(112,4,'-PP yg ditunjuk dlm verzet tidak bisa tunda jadwal sidang'),
					(113,4,'-Perubaan Status Perkara Penundaan sidang verset masih Persidangan. Harusnya Persidangan Verzet'),
					(114,4,'-Edit Sidang Pertama Verzet masih ada Delete nya (Harusnya hanya bisa di hapus melalui penetapan sidang pertama verzet)'),
					(115,4,'Update mediasi pada perkara verzet'),
					(116,4,'Perbaikan prodeo murni upaya hukum tdk bisa disimpan dan status prodeo di jurnal'),
					(117,4,'Perbaikan : kewenangan jurusita utk pelaksanaan delegasi masuk'),
					(118,4,'Perbaikan : tidak bisa input kuasa hukum tergugat II intervensi ketika sama dengan kuasa hukum tergugat, muncul pesan : Kuasa hukum intervensi sudah terdaftar mewakili pihak lain di perkara yang sama'),
					(119,4,'Perbaikan : Cetak Dokumen Penetapan Panitera (TUN) pilih TandaTanganOleh masih Panitera Sekretaris'),
					(120,4,'Perkara LL : Saat tgl penunjukan panitera > dari tgl penetapan hari sidang, muncul (di firebug) tanggal penetapan hari sidang tidak boleh sebelum dari tanggal penetapan hakim (informasinya salah dan tidak muncul sebagai alert)'),
					(121,4,'Perkara LL : Form tanggal apabila ditulis manual tidak langsung muncul / di antara hari dan bulan atau bulan dan tahun'),
					(122,4,'Perkara LL : Bila kolom jumlah perkara tidak diisi, tidak muncul peringatan keharusan mengisi'),
					(123,4,'Perkara LL : Alert tidak muncul, sehingga bila terjadi kesalahan tidak ada informasi yang diperlihatkan ke user'),
					(124,4,'Perkara LL :  Maxlength di form tanggal > 10'),
					(125,4,'Perbaikan : cetak draft putusan pidana anak'),
					(126,4,'Perbaikan : tdk bisa edit, hapus saksi utk PP'),
					(127,4,'Perbaikan status banding: di sipp pn, sering muncul Penetapan Majelis Hakim Ikrar Talak'),
					(128,4,'Perbaikan : saldo awal belum mempengaruhi laporan keuangan perkara TUN'),
					(129,4,'Perbaikan : Pidana anak yg telah diversi tdk bisa membuka tab penetapan'),
					(130,4,'Perbaikan : perbaikan referensi panitera pt'),
					(131,4,'Perbaikan : hapus inzage di kasasi'),
					(132,4,'Perbaikan : 1 kali sidang utk prapid'),
					(133,4,'Update : status kehadiran termohon pada prapid blm ada'),
					(134,4,'Perbaikan : Update proses Pembuatan Minutasi -> Minutasi'),
					(135,4,'Penamaan pihak intervensi untuk pengadilan tun :'),
					(136,4,'Penggugat: Penggugat II Intervensi I, Penggugat II Intervensi II, dst'),
					(137,4,'Tergugat: Tergugat II Intervensi I, Tergugat II Intervensi II, dst'),
					(138,4,'urutan pihak intervensi masih salah, misal dalam satu perkara terdapat Tergugat II Intervensi I, Tergugat II Intervensi II, kemudian akan ditambahkan pihak intervensi yang tergabung ke Penggugat, maka seharusnya : Penggugat II Intervensi I, tetapi yg keluar adalah Pengugat II Intervensi III '),
					(139,4,'Penetapan Pengadilan Tidak Berwenang oleh Ketua (link cetak template tdk berwenang)'),
					(140,4,'Putusan Pengadilan Tidak Berwenang oleh Majelis (link Tidak Berwenang)'),
					(141,4,'Perbaikan tampilan tab detil perkara agama'),
					(142,5,'Permohonan Pertanahan, diganti jadi Pengadaan Tanah Untuk Kepentingan Umum'),
					(143,5,'Permohonan Keberatan (KIP), diganti jadi Keterbukaan Informasi Publik (KIP)'),
					(144,5,'Hapus jenis perkara  Permohonan Keberatan (KIP) dari Jurnal Induk Perkara TUN'),
					(145,5,'Perbaikan Pembuatan Minutasi menjadi Minutasi'),
					(146,5,'Perbaikan format Klasifikasi perkara BPSK, KPPU, PARPOL'),
					(147,5,'Penambahan View untuk Kewenangan Hakim'),
					(148,5,'Perbaikan delegasi keluar,delegasi masuk dan tgl/nmr Resi tdk wajib'),
					(149,5,'Penambahan minutasi pada penetapan dismissal gugatan sederhana'),
					(150,5,'Perbaikan 1 kali persidangan Lalu Lintas, verstek, status pihak kedua kirim salinan putusan'),
					(151,5,'Perbaikan Putusan sela hanya perlu biaya materai saja, tanpa ada biaya redaksi, pengisian materai dan redaksi sendiri-sendiri'),
					(152,5,'Perbaikan minutasi verzet yang tidak tampil'),
					(153,5,'Perbaikan penamaan NO (Tidak dapat Diterima) untuk template putusan perdata'),
					(154,5,'DESC Nomor Urut Perkara untuk perkara Tilang'),
					(155,5,'Menambahkan Minutasi Keberatan Gugatan Sederhana'),
					(156,5,'Perbaikan pada Lalu Lintas Tanggal Sidang Tidak Boleh Sebelum Dari Tanggal Pendaftaran'),
					(157,6,'Perbaikan penomoran klasifikasi perkara : Fiktif positif'),
					(158,6,'Perbaikan penomoran klasifikasi perkara : Penyalahgunaan Wewenang '),
					(159,6,'Perbaikan penomoran klasifikasi perkara : Pengadaan Tanah Untuk Kepentingan Umum'),
					(160,6,'Mengganti Materai menjad Meterai'),
					(161,6,'Menambah kewenangan Koordinator Delegasi sesuai SEMA 6 Tahun 2014 Angka 7 Poin i'),
					(162,6,'Mengganti batas waktu PHS dan batas waktu Pengiriman Berkas Banding pada PTUN'),
					(163,6,'Menambah klasifikasi perkara KUHPM -- Ketidakhadiran Tanpa Ijin'),
					(164,6,'Perbaikan alamat kantor PTUN Menado'),
					(165,6,'Perbaikan Biaya Leges Gugatan Sederhana dan Permohonan pada PTUN dan PA'),
					(166,6,'Perbaikan penetapan hasil migrasi'),
					(167,6,'Menambah Kewenangan Grup Koordinator Delegasi'),
					(168,6,'Menambah sumber hukum Yurisprudensi dan RV'),
					(169,6,'Meng-update tabel perkara_putusan kolom sumber_hukum_id (varchar 20)'),
					(170,6,'Menampilkan Permohonan UU AP dan Gugatan Keberatan (KIP) di dasboard'),
					(171,6,'Menambah klasifikasi perkara perdata gugatan : Keberatan atas ganti kerugian pengadaan tanah bagi pembangunan untuk kepentingan umum'),
					(172,6,'Perbaikan format penomoran lingkungan hidup tingkat pertama x/Pid.B/LH/Tahun/KodePN untuk pidana dan x/Pid.G/LH/Tahun/KodePN untuk perdata, di SIPP menggunakan Pid.Sus-LH (37/KMA/SK/III/2015)'),
					(173,6,'Merubah procedure updateTable agar data di SIPP Web dan SIPP Lokal sama'),
					(174,6,'Menambah pemeriksaan setempat dan panggilan pada jurnal eksekusi'),
					(175,6,'Menambah viewperkaralalulintasweb, tabel perkaralalulintasweb, menambah tabel di procedure updateTable'),
					(176,6,'Perbaikan tabel delegasiprosesmasukweb dan delegasiproseskeluarweb (tambah primary key dan ubah tabel ke innodb)'),
					(177,6,'Menambah klasifikasi Keterbukaan Informasi Publik (KIP) utk Perdata Gugatan'),
					(178,6,'Perbaikan viewpihakweb dan tabel pihakweb, tambah umur dan jenis kelamin (untuk statistik di SIPP Web)'),
					(179,6,'Perbaikan vieweksekusidetilweb dan vieweksekusiweb (nama tabel terbalik)'),
					(180,6,'Perbaikan perhitungan lama proses di Perkara List untuk perkara yang ditangani'),
					(181,6,'Perbaikan Status Perkara untuk Upaya Hukum di dashboard'),
					(182,6,'Perbaikan perkara cabut di dashboard (kalau diisi minutasinya malah jadi sisa)'),
					(183,6,'Menambah validasi tujuan satker delegasi keluar dan untuk satker nya sendiri masih bisa dipilih'),
					(184,6,'Perbaikan search pesan masuk'),
					(185,6,'Mengedit authorization agar PP/Ketua Majelis bisa input/edit/tunda jadwal sidang perlawanan'),
					(186,6,'Perbaikan Pidana Tipiring (tambah penyidik atas kuasa PU, yg muncul jaksa, harusnya penyidik, termasuk pekerjaan, kantor)'),
					(187,6,'Perbaikan Cetak Akta Permohonan Kasasi Pidana'),
					(188,6,'Perbaikan selisih penerimaan memori, penyerahan memori dan minutasi keberatan'),
					(189,6,'Menampilkan link tambah keberatan untuk user meja III perdata dan panmud'),
					(190,6,'Menghapus tanggal sumpah pada PK Pidana,'),
					(191,6,' Menghapus tanggal dan isi pendapat penggugat dan hakim pada PK Perdata'),
					(192,6,'Menambah kewenangan meja 3 perdata untuk keberatan'),
					(193,6,'Menambah kewenangan/grup koordinator Delegasi'),
					(194,6,'Perbaikan Itsbat Nikah Contentius tanpa mediasi (pasal 4 ayat 2 huruf D PERMA NO 1 2016)'),
					(195,6,'Perbaikan field sumber hukum putusan akhir untuk PTUN yang tidak keluar, akibatnya tidak bisa menyimpan putusan akhir'),
					(196,6,'Link akta pengembalian berkas / tidak berwenang tidak mengubah status perkara pada detail perkara atw statistik di dashboard (Militer)'),
					(197,6,'Perbaikan kondisi agar 1x sidang dapat muncul link putusan akhir'),
					(198,6,'List Perbaikan Agama A.7'),
					(199,6,'List Perbaikan Agama B.1.2'),
					(200,6,'List Perbaikan Agama A.11'),
					(201,6,'List Perbaikan Agama B.5'),
					(202,6,'Perbaikan draft putusan (seharusnya tidak dibatasi jenis putusan)'),
					(203,6,'Perbaikan kondisi Jenis Biaya PNBP(pendaftaran, redaksi, leges) untuk perkara prodeo Dipa nilainya = nihil'),
					(204,6,'Perbaikan urutan Laporan LIPA1 (ada perkara yang tidak urut dari kecil ke besar)'),
					(205,6,'Perbaikan Laporan LIPA 8 (cabut sebelum sidang)'),
					(206,6,'Perbaikan LIPA 6 (hanya menampilkan hakim bukan nama majelis seluruhnya'),
					(207,6,'Perbaikan kondisi dimana Tanggal Surat Pelimpahan bisa sama dengan Tanggal Surat Dakwaan (Militer)'),
					(208,6,'Perbaikan LIPA 9 (yang ditampilkan jumlah PNS/TNI/POLRI/BUMND saja bukan secara keseluruhan)'),
					(209,6,'Perbaikan status Putusan Verstek di tab Putusan Akhir'),
					(210,6,'Perbaikan tanggal Kirim Salinan Putusan Kepada Penyidik di tab Putusan Akhir -> Edit Pemberitahuan Putusan'),
					(211,6,'Menambah status putusan kasasi dan PK = Ditolak'),
					(212,6,'Perbaikan Pencabutan Perkara Setelah ada Penetapan Hari Sidang Pertama (waktu simpan minutasi muncul warning tgl minutasi tdk boleh kurang dari tgl sidang pertama)'),
					(213,6,'Perbaikan Cetak Excel di daftar Status Perkara dari tab Dashboard Status Perkara'),
					(214,6,'Perbaikan kondisi Sumber Hukum menjadi bisa lebih dari satu sumber hukum'),
					(215,6,'Menambah sumber hukum untuk link dicabut'),
					(216,6,'List Perbaikan Agama B.3'),
					(217,6,'Skum Agama'),
					(218,6,'Perbaikan tampilan pemberitahuan putusan pada user jurusita'),
					(219,6,'Perbaikan keterangan verstek di tab putusan akhir'),
					(220,6,'Mengubah kondisi perkara gugatan 1 kali sidang putus (PA)'),
					(221,6,'Perbaikan Pihak Turut Tergugat yang belum muncul pada detil jurnal (untuk upaya hukum apabila pihak turut tergugat yang membayar panjar)'),
					(222,6,'Perbaikan kewenangan meja 1 dan 2 pidana khusus (HAM dan Perikanan)'),
					(223,6,'Perbaikan kategori pengiriman, panggilan dan pemeriksaan setempat yang tidak muncul di jurnal eksekusi'),
					(224,6,'Perbaikan validasi tanggal putusan pada status terdakwa (tidak boleh kurang dari tanggal sidang terakhir)'),
					(225,6,'Mengedit data permohonan kasasi perdata nomor perkara dan tanggal putusan PN (terbalik)'),
					(226,6,'Perbaikan warning pada pelaksanaan delegasi Tanggal Surat Pengantar Tidak Boleh Kurang Dari Tanggal Pelaksanaan Delegasi'),
					(227,6,'Perbaikan Template Akta Cerai Baru'),
					(228,6,'Perbaikan hasil cetak excel di list perkara (menampilkan nama PP dan hakim dan link detil dihapus)'),
					(229,6,'Perbaikan Meja 1 pidana untuk menambah penahanan anak di data umum'),
					(230,6,'Perbaikan kondisi Panitera/Wapan yang tidak bisa edit/tunda jadwal sidang (seharusnya bisa)'),
					(231,6,'Perbaikan List Perkara SIPP Web total perkara dan list perkara yang tampil tidak sama'),
					(232,6,'Perbaikan kondisi Tanggal BHT menjadi tidak boleh kurang dari tanggal putusan '),
					(233,6,'Perbaikan urutan majelis pada template putusan pidana format biasa terbukti'),
					(234,6,'Perbaikan kondisi perkara kasasi yg TMS tidak bisa menambahkan grasi, mulcul pesan error perkara masih dalam upaya hukum kasasi'),
					(235,6,'Perbaikan kondisi pada detil perkara pidana, tab kasasi dan PK yang masih muncul mediasi'),
					(236,6,'Perbaikan kuasa hukum intervensi/turut tergugat tidak bisa sama dengan kuasa hukum tergugat (seharusnya bisa)'),
					(237,6,'Perbaikan Nomor Akta Cerai (dimanualkan)'),
					(238,6,'Perbaikan penomoran PTUN (PTUN-#kode_pn# diganti dengan PTUN.#kode_pn#)'),
					(239,6,'Perbaikan pagination tidak sesuai dengan total data perkara di SIPP WEB'),
					(240,6,'Perbaikan session nama pengadilan negeri yang tidak otomatis ter-load pada saat membuka pertama kali di SIPP WEB'),
					(241,6,'Perbaikan versi sipp pada footer SIPP WEB tidak mengambil data dari db'),
					(242,6,'Perbaikan error pihak not found pada list perkara LL dan Permohonan di SIPP WEB'),
					(243,6,'Perbaikan status tanggal pembaharuan di SIPP WEB + Perbaikan file sinkronisasinya'),
					(244,6,'Perbaikan list perkara, kolom durasi, jika tanggal pemberitahuan lebih besar dari tanggal minutasi maka counter akan terus menghitung sampai waktu sekarang di SIPP WEB'),
					(245,6,'Perbaikan tanggal sidang pertama yang sama dengan tanggal penetapan sidang (seharusnya beda) di SIPP WEB'),
					(246,6,'Perbaikan menu Jadwal sidang yang jika di klik banyak yang lambat atau bahkan error saat memunculkan hasilnya di SIPP WEB'),
					(247,6,'Perbaikan template resume tun, penetapan hari sidang pertama'),
					(248,6,'Perbaikan setiap huruf G pada template yg otomatis berubah menjadi PEN-PP, PEN-HS/PLW, PEN-MH/PLW, PEN-EKS, PEN-DIS, PEN-MH, PEN-HS, seharusnya hanya untuk penomoran penetapannya saja'),
					(249,6,'Perbaikan Panitera Sekretaris dirubah menjadi Panitera pada template yg ber ttd Panitera'),
					(250,6,'Perbaikan Panmud Perikanan, Meja 1 Perikanan, Meja 2 Perikanan'),
					(251,6,'Perbaikan perkara perdata prodeo'),
					(252,6,'Perbaikan penambahan klasifikasi Lingkungan Hidup di Pidana ');");
		
		$this->db->query("REPLACE INTO `proses_alur_perkara` (id,alur_perkara_id,tahapan_id,tahapan_nama,proses_id,proses_nama)
						VALUES (1654,9,13,'Perlawanan',116,'Persidangan Perlawanan');");
		$this->db->query("REPLACE INTO `proses` (id,tahapan_id,kode,nama,keterangan)
						VALUES(116,13,13,'Persidangan Perlawanan','Persidangan Perlawanan');");

		$this->db->query("REPLACE INTO updates_catatan (id,update_id,deskripsi)VALUES
					(253,7,'Perbaikan Jurnal Gugatan Sederhana,BTH telah diinput tapi tidak muncul pada register buku induk keuangan'),
					(254,7,'Tambah status putusan Terdakwa Meninggal dan Terdakwa Melarikan Diri'),
					(255,7,'Perbaikan Jurnal Gugatan Sederhana,BHT telah diinput tapi tidak muncul pada register buku induk keuangan'),
					(256,7,'Pilihan Dibebaskan di hapus dari register penahanan'),
					(257,7,'Penambahan Template, proses bisnis untuk Mediasi sesuai Perma No 1 Tahun 2016 dan SK KMA Nomor 108 2016 tentang tata kelola Mediasi di Pengadilan'),
					(258,7,'Tambah Biaya Panggilan Mediasi Penggugat/Tergugat'),
					(259,7,'Tambah kehadiran pihak pada jadwal mediasi'),
					(260,7,'Tambah status putusan : Perdamaian untuk putusan Peradilan Agama'),
					(261,7,'Perbaikan perkara yg sudah putusan tp blm minutasi kemudian mengajukan banding/kasasi baru kemudian minutasi di input, tab banding/kasasi hilang'),
					(262,7,'Perkara dicabut sebelum proses persidangan tidak keluar tab putusan akhir (Perkara TUN), sehingga tidak bisa isi tanggal minutasi karena minutasi ada di tab putusan akhir (sedangkan sipp pengadilan umum keluar tab putusan akhir)'),
					(263,7,'Tambah data saksi di field yang menghadirkan belum ada pilihan intervensi'),
					(264,7,'Perbaikan pada perkara penyalahgunaan wewenang (P/PW) pihak termohon tidak wajib ada'),
					(265,7,'Tambah aktifitas hapus data perkara yang tidak tercatat di audittrail'),
					(266,7,'Perbaikan pengajuan upaya hukum, mengacunya pada tanggal putusan apabila tgl pemberitahuan kosong, bila tgl pemberitahuan ada isinya mengacu pada pemberitahuan putusan ke pihak '),
					(267,7,'Putusan Sela Pidana bila Keberatan Diterima tdk ada Tuntutan langsung putusan akhir'),
					(268,7,'Menambahkan tombol hapus pada setiap pengisian tanggal dan putusan di detil upaya hukum (banding,kasasi dan PK)'),
					(269,7,'Menambahkan link tambah barang bukti pada Tab Barang Bukti di Detil Perkara'),
					(270,7,'Pilihan Tidak Ditahan pada register penahanan, tgl mulai, tgl sampai dan jumlah hari tdk wajib '),
					(271,7,'Perbaikan pemberitahuan putusan pidana (kirim salinan putusan)'),
					(272,7,'Untuk klasifikasi perkara : Gugatan Memperoleh Akta Perdamaian Atas Kesepakatan Perdamaian di Luar Pengadilan tab Mediasi diluar Pengadilan wajib di isi untuk menampilkan link penepatan Majelis'),
					(273,7,'Jumlah mediator pada Mediasi sesuai Perma No 1 2016 bisa lebih dari 1 mediator'),
					(274,7,'Penambahan Kehadiran dan Jam pada Jadwal Mediasi'),
					(275,7,'Penambahan pengisian Tgl dan Isi Kesepakatan pada Mediasi'),
					(276,7,'Pada saat edit Jadwal Sidang dan Kehadiran Pihak dipilih : Semua Pihak, maka link tunda tdk akan muncul bila tdk menambah data mediasi melalui link Mediasi'),
					(277,7,'Hasil Mediasi Sesuai Perma No 1 2016 : 1. Berhasil Dengan Akta Perdamaian, 2. Berhasil Dengan Pencabutan, 3. Berhasil Sebagian, 4. Tidak Berhasil, 5. Tidak Dapat Dilaksanakan'),
					(278,7,'Mediasi pada tahapan Verzet'),
					(279,7,'Mediasi pada tahapan upaya hukum (yg dicatat hanya yg berhasil mediasi)'),
					(280,7,'Penambahan informasi pada Referensi Mediator sesuai Perma No 1 2016'),
					(281,7,'Perkara yg tdk wajib mediasi : Perdata Khusus, Perkara BPSK, KPPU, Parta Politik (peradilan Umum)'),
					(282,7,'Perkara yg tdk wajib mediasi : Isbat Nikah, Pembatalan Perkawinan, Penolakan Kawin Campuran'),
					(283,7,'Penambahan Menu Blanko Template'),
					(284,7,'Penambahan Menu Help berisi tentang 1. Buku Panduan (ttg manual book), 2. Catatan Pembaharuan (ttg perbaikan/update versi sipp), 3. Tentang SIPP (info versi)'),
					(285,7,'Penyesuaian data Mediasi SIPP WEB dgn SIPP Local'),
					(286,7,'Update Laporan Mediasi'),
					(287,7,'Update perhitungan lama proses perkara di kurangi dengan masa mediasi'),
					(288,7,'Perbaikan Form putusan banding Perkara Pidana Anak yang bisa Hakim Tunggal atau Majelis'),
					(289,7,'Perbaikan status perkara, pada saat tunda jadwal sidang perlawanan pada perkara TUN'),
					(290,7,'Perbaikan validasi tanggal permohonan banding perdata'),
					(291,7,'Perbaikan hak akses Koordinator Delegasi'),
					(292,7,'Perbaikan data double di laporan lipa 6'),
					(293,7,'Tombol Tunda Ubah Ke SKORS pada menu antrian sidang'),
					(294,7,'Tambah Template Delegasi Keluar');");

		#sippweb
		$this->db->query("DROP VIEW IF EXISTS `v_mediasi`;");
		$this->db->query("CREATE VIEW `v_mediasi` AS (
							SELECT
							  `v`.`perkara_id`                    AS `perkara_id`,
							  `v`.`mediasi_id`                    AS `mediasi_id`,
							  `p`.`nomor_perkara`                 AS `nomor_perkara`,
							  `p`.`jenis_perkara_id`              AS `jenis_perkara_id`,
							  `p`.`jenis_perkara_nama`            AS `jenis_perkara_nama`,
							  `p`.`alur_perkara_id`               AS `alur_perkara_id`,
							  `put`.`tanggal_putusan`             AS `tanggal_putusan`,
							  `put`.`status_putusan_id`           AS `status_putusan_id`,
							  `v`.`penetapan_penunjukan_mediator` AS `penetapan_penunjukan_mediator`,
							  `v`.`dimulai_mediasi`               AS `dimulai_mediasi`,
							  `v`.`keputusan_mediasi`             AS `keputusan_mediasi`,
							  `v`.`tgl_laporan_mediator`          AS `tgl_laporan_mediator`,
							  `v`.`hasil_mediasi`                 AS `hasil_mediasi`,
							  `v`.`akta_perdamaian`               AS `akta_perdamaian`
							FROM (((`perkara_mediasi` `v`
							     LEFT JOIN `perkara_jadwal_mediasi` `jm`
							       ON (((`v`.`mediasi_id` = `jm`.`mediasi_id`)
							            AND (`jm`.`urutan` = 1))))
							    JOIN `perkara` `p`
							      ON ((`v`.`perkara_id` = `p`.`perkara_id`)))
							   LEFT JOIN `perkara_putusan` `put`
							     ON ((`v`.`perkara_id` = `put`.`perkara_id`))))");

		$this->db->query("DROP FUNCTION IF EXISTS `split_string`");
		$this->db->query("CREATE FUNCTION `split_string`(str VARCHAR(255), delim VARCHAR(12), pos INT) RETURNS VARCHAR(255) CHARSET latin1
						    DETERMINISTIC
						RETURN
						    REPLACE(
						        SUBSTRING(
						            SUBSTRING_INDEX(str, delim, pos),
						            LENGTH(SUBSTRING_INDEX(str, delim, pos-1)) + 1
						        ),
						        delim, ''
						    )");

		$this->db->query("DROP VIEW IF EXISTS `v_mediator_n`");
		$this->db->query("CREATE VIEW `v_mediator_n` AS (
						SELECT `v`.`mediasi_id` AS `mediasi_id`,`med`.`id` AS `id_mediator`,`med`.`status_mediator` AS `status_mediator`,`med`.`nama_gelar` AS `nama_mediator`,`med`.`bersertifikat` AS `bersertifikat`,`med`.`aktif` AS `aktif` FROM ((`perkara_mediasi` `v` JOIN `sys_month_name` `m` ON(((`m`.`id` - 1) <= (CHAR_LENGTH(`v`.`mediator_id`) - CHAR_LENGTH(REPLACE(`v`.`mediator_id`,',','')))))) JOIN `mediator` `med` ON((`split_string`(`v`.`mediator_id`,',',`m`.`id`) = `med`.`id`))))");

		$this->db->query("DROP VIEW IF EXISTS tmediasi");
		$this->db->query("CREATE VIEW tmediasi AS 
						SELECT 
						  perkara_mediasi.mediasi_id AS IDMediasi,
						  perkara_mediasi.jenis_mediasi AS jenisMediasi,
						  perkara_mediasi.tahapan_id AS IDTahapan,
						  perkara_mediasi.perkara_id AS IDPerkara,
						  perkara_mediasi.penetapan_penunjukan_mediator AS tglPenetapan,
						  perkara_mediasi.nomor_sk_penetapan_mediator AS SKPenetapan,
						  perkara_mediasi.mediator_id AS IDMediator,
						  perkara_mediasi.status_mediator AS profesi,
						  perkara_mediasi.mediator_text AS nama_gelar,
						  perkara_mediasi.dimulai_mediasi AS tglMediasi,
						  perkara_mediasi.keputusan_mediasi AS tglPutusan,
						  (CASE
						    WHEN (perkara_mediasi.hasil_mediasi = 'Y') THEN 'Berhasil' 
						    WHEN (perkara_mediasi.hasil_mediasi = 'Y1') THEN 'Berhasil Dengan Akta Perdamaian' 
						    WHEN (perkara_mediasi.hasil_mediasi ='Y2') THEN 'Berhasil Dengan Pencabutan' 
						    WHEN (perkara_mediasi.hasil_mediasi  = 'S') THEN 'Berhasil Sebagian' 
						    WHEN (perkara_mediasi.hasil_mediasi  = 'T') THEN 'Tidak Berhasil' 
						    WHEN (perkara_mediasi.hasil_mediasi  = 'D') THEN 'Tidak dapat dilaksanakan' 
						    END) AS  hasil,
						   perkara_mediasi.hasil_mediasi                  AS  jenis_hasil_mediasi,
						   perkara_mediasi.tgl_kesepakatan_perdamaian     AS  tglKesepakatan,
						   perkara_mediasi.tgl_pengajuan_kesepakatan      AS  tglPengajuanSepakat,
						   perkara_mediasi.akta_perdamaian                AS  tglAkta,
						   perkara_mediasi.isi_akta_perdamaian            AS  isiAkta,
						   perkara_mediasi.tgl_permohonan_uh              AS  tglPermohonanMediasi,
						   perkara_mediasi.tgl_pemberitahuan_ke_ptma      AS  tglBeritahu,
						   perkara_mediasi.tgl_laporan_mediator           AS  tglLaporan,
						   perkara_mediasi.tgl_kirim_kesepakatan_ke_ptma  AS  tglKirimKesepakatan 
						FROM  perkara_mediasi");

		$this->db->query("DROP VIEW IF EXISTS `viewmediasiweb`");
		$this->db->query("CREATE VIEW `viewmediasiweb` AS 
						SELECT
						  `tmediasi`.`IDMediasi`            AS `IDMediasi`,
						  `tmediasi`.`IDTahapan`            AS `IDTahapan`,
						  `tmediasi`.`IDPerkara`            AS `IDPerkara`,
						  `tmediasi`.`jenisMediasi`         AS `jenisMediasi`,
						  `tmediasi`.`tglPenetapan`         AS `tglPenetapan`,
						  `tmediasi`.`SKPenetapan`          AS `SKPenetapan`,
						  `tmediasi`.`IDMediator`           AS `IDMediator`,
						  `tmediasi`.`profesi`             AS `statusMediator`,
						  `tmediasi`.`nama_gelar`          AS `nama`,
						  `tmediasi`.`tglMediasi`           AS `tglMediasi`,
						  `tmediasi`.`tglPutusan`           AS `tglPutusan`,
						  `tmediasi`.`hasil`                AS `hasil`,
						  `tmediasi`.`jenis_hasil_mediasi`  AS `jenis_hasil_mediasi`,
						  `tmediasi`.`tglKesepakatan`       AS `tglKesepakatan`,
						  `tmediasi`.`tglPengajuanSepakat`  AS `tglPengajuanSepakat`,
						  `tmediasi`.`tglAkta`              AS `tglAkta`,
						  `tmediasi`.`isiAkta`              AS `isiAkta`,
						  `tmediasi`.`tglPermohonanMediasi` AS `tglPermohonanMediasi`,
						  `tmediasi`.`tglBeritahu`          AS `tglBeritahu`,
						  `tmediasi`.`tglLaporan`           AS `tglLaporan`,
						  `tmediasi`.`tglKirimKesepakatan`  AS `tglKirimKesepakatan`
						FROM `tmediasi`
						ORDER BY `tmediasi`.`IDMediasi`");

		$cekkolum = $this->isColumnExist('mediasiweb','tglKesepakatan');  		
        if(!$cekkolum){
        	$this->db->query("ALTER TABLE `mediasiweb` ADD COLUMN `tglKesepakatan` DATE NULL AFTER `jenisHasilMediasi`;");
        }
        $cekkolum = $this->isColumnExist('mediasiweb','tglPengajuanSepakat');  		
        if(!$cekkolum){
        	$this->db->query("ALTER TABLE `mediasiweb` ADD COLUMN `tglPengajuanSepakat` DATE NULL AFTER `tglKesepakatan`;");
        }


		$this->db->query("UPDATE sys_config SET `value` = '3.1.5' WHERE id = '80';");
		
		//update table update patch 3.1.5
		$data = array('updated' => 1,'updated_stamp'=>date("Y-m-d H:i:s"));
		$this->db->where('patch_ver', '3.1.5');
		$this->db->update('updates', $data); 
		
		$this->db->query("SET FOREIGN_KEY_CHECKS=1;");

		return true;
	}

}