<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Report_mediasi_hasil_tahunan extends CI_Model{
	
	function get_info_pn(){
		try {
			$this->db->select('*');
			$this->db->where('id >=', 61); 
			return $this->db->get('sys_config');
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	function getJenisPerkara($idalurperkara){
		if(empty($idalurperkara)) return '';
		try {
			$this->db->where('id',$idalurperkara);
			return $this->db->get('alur_perkara')->row()->nama;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_tahun($idalurperkara){
		try {
			return $this->db->query('SELECT YEAR(min(tanggal_pendaftaran)) AS years FROM perkara WHERE alur_perkara_id IN ('.$idalurperkara.');');
		} catch (Exception $e) {
			
		}
	}

	function get_rekap($idalurperkara,$tahun){
		try {
			$sql="SELECT 	
					bln.bulan_nama
			    	,@sisa_perkara:=(SELECT COUNT(*) FROM v_perkara WHERE alur_perkara_id ='".$idalurperkara."' AND LEFT(tanggal_pendaftaran,7)<months AND (LEFT(tanggal_putusan,7) IS NULL OR LEFT(tanggal_putusan,7)>=months)) AS sisa_perkara
					,@perkara_diterima:=(SELECT COUNT(*) FROM v_perkara WHERE alur_perkara_id ='".$idalurperkara."' AND LEFT(tanggal_pendaftaran,7) = months) AS perkara_diterima
					,@total_beban:=@sisa_perkara+@perkara_diterima AS total_beban
					,@sisa_mediasi:=(SELECT COUNT(*) FROM  v_perkara WHERE alur_perkara_id ='".$idalurperkara."' AND LEFT(dimulai_mediasi,7) < months  AND (LEFT(keputusan_mediasi,7) IS NULL OR LEFT(keputusan_mediasi,7)>= months)) AS sisa_mediasi
					,@perkara_mediasi:=(SELECT COUNT(*)  FROM v_perkara WHERE alur_perkara_id ='".$idalurperkara."' AND LEFT(dimulai_mediasi,7) = months ) AS perkara_mediasi
					,@total_mediasi:=@sisa_mediasi+@perkara_mediasi AS total_mediasi
					,IF(IFNULL(@total_mediasi,0)=0 OR IFNULL(@total_beban,0)=0,0,CONCAT(ROUND(@total_mediasi/@total_beban*100),'%')) AS persen_mediasi
					,@mediasi_berhasil_akta:=(SELECT COUNT(*) FROM  v_perkara WHERE alur_perkara_id ='".$idalurperkara."' AND  LEFT(keputusan_mediasi,7) = months AND (hasil_mediasi ='Y' OR hasil_mediasi ='Y1') AND (tanggal_putusan IS NULL OR (tanggal_putusan IS NOT NULL OR status_putusan_id NOT IN (7,37,67)))) AS mediasi_berhasil_akta
					,IF(IFNULL(@total_mediasi,0)=0 OR IFNULL(@mediasi_berhasil_akta,0)=0,0,CONCAT(ROUND(@mediasi_berhasil_akta/@total_mediasi*100),'%')) AS persen_mediasi_berhasil_akta
					,@mediasi_berhasil_sebagian:=(SELECT COUNT(*) FROM v_perkara WHERE alur_perkara_id ='".$idalurperkara."' AND LEFT(keputusan_mediasi,7) = months AND hasil_mediasi ='S') AS mediasi_berhasil_sebagian
					,IF(IFNULL(@total_mediasi,0)=0 OR IFNULL(@mediasi_berhasil_sebagian,0)=0,0,CONCAT(ROUND(@mediasi_berhasil_sebagian/@total_mediasi*100),'%')) AS persen_mediasi_berhasil_sebagian
					,@mediasi_berhasil_pencabutan:=(SELECT COUNT(*) FROM v_perkara WHERE alur_perkara_id ='".$idalurperkara."' AND LEFT(keputusan_mediasi,7) = months AND (hasil_mediasi ='Y' OR hasil_mediasi ='Y2') AND (tanggal_putusan IS NULL OR (tanggal_putusan IS NOT NULL OR status_putusan_id IN (7,37,67)))) AS mediasi_berhasil_pencabutan
					,IF(IFNULL(@total_mediasi,0)=0 OR IFNULL(@mediasi_berhasil_pencabutan,0)=0,0,CONCAT(ROUND(@mediasi_berhasil_pencabutan/@total_mediasi*100),'%')) AS persen_mediasi_berhasil_pencabutan
					,@mediasi_berhasil:=(@mediasi_berhasil_akta+@mediasi_berhasil_sebagian+@mediasi_berhasil_pencabutan)AS mediasi_berhasil
					,IF(IFNULL(@total_mediasi,0)=0 OR IFNULL(@mediasi_berhasil,0)=0,0,CONCAT(ROUND(@mediasi_berhasil/@total_mediasi*100),'%')) AS persen_mediasi_berhasil
					,@mediasi_tdk_berhasil:=(SELECT COUNT(*) FROM v_perkara WHERE alur_perkara_id ='".$idalurperkara."' AND LEFT(keputusan_mediasi,7) = months AND hasil_mediasi ='T') AS mediasi_tdk_berhasil
					,IF(IFNULL(@total_mediasi,0)=0 OR IFNULL(@mediasi_tdk_berhasil,0)=0,0,CONCAT(ROUND(@mediasi_tdk_berhasil/@total_mediasi*100),'%')) AS persen_mediasi_tdk_berhasil
					,@mediasi_tdk_dpt_dilaksanakan:=(SELECT COUNT(*) FROM v_perkara WHERE alur_perkara_id ='".$idalurperkara."' AND LEFT(keputusan_mediasi,7) = months AND hasil_mediasi ='D') AS mediasi_tdk_dpt_dilaksanakan
					,IF(IFNULL(@total_mediasi,0)=0 OR IFNULL(@mediasi_tdk_dpt_dilaksanakan,0)=0,0,CONCAT(ROUND(@mediasi_tdk_dpt_dilaksanakan/@total_mediasi*100),'%')) AS persen_mediasi_tdk_dpt_dilaksanakan
					,@pending_mediasi:=(@total_mediasi-(@mediasi_berhasil_akta+@mediasi_berhasil_sebagian+@mediasi_berhasil_pencabutan+@mediasi_tdk_berhasil+@mediasi_tdk_dpt_dilaksanakan))AS pending_mediasi
					,IF(IFNULL(@total_mediasi,0)=0 OR IFNULL(@pending_mediasi,0)=0,0,CONCAT(ROUND(@pending_mediasi/@total_mediasi*100),'%')) AS persen_pending
				FROM (SELECT b.id AS id,b.name_id AS bulan_nama, CONCAT('".$tahun."','-',RIGHT(CONCAT('0',b.id),2)) AS months
				        FROM sys_month_name AS b) AS bln
						WHERE months <= LEFT(CURRENT_DATE(),7)
				ORDER BY bln.id";
			return $this->db->query($sql);
		} catch (Exception $e) {
			
		}
	}

	function get_stat_perkara($period,$idalurperkara){
		try {
			return $this->db->query("
				SELECT alur_perkara_id,alur_perkara_nama,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>='".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' THEN 1
						ELSE 0
						END
					) AS sisa,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
						ELSE 0
						END
					) AS putus_blm_minut,
				SUM(
					CASE 
						WHEN (keputusan_mediasi IS NOT NULL AND LEFT(keputusan_mediasi,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') AND hasil_mediasi='Y' THEN 1
						ELSE 0
						END
					) AS med_blm_minut,
				SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) = '".$period."' THEN 1
						ELSE 0
						END
					) AS masuk,
				SUM(
					CASE 
						WHEN (penetapan_majelis_hakim IS NULL OR LEFT(penetapan_majelis_hakim,7)>'".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS blm_majelis,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS putus,
				SUM(
					CASE 
						WHEN (tanggal_minutasi IS NOT NULL AND LEFT(tanggal_minutasi,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS minut,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>'".$period."') THEN 1
						WHEN (LEFT(mediasi_berhasil,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
						ELSE 0
						END
					) AS blm_minut,
				SUM(
					CASE 
						WHEN (tanggal_cabut IS NOT NULL AND LEFT(tanggal_cabut,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS cabut,
				SUM(
					CASE 
						WHEN (tanggal_gugur IS NOT NULL AND LEFT(tanggal_gugur,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS gugur,
				SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) <= '".$period."' AND hasil_mediasi='Y' AND status_mediator='H' AND LEFT(mediasi_berhasil,7) = '".$period."'  THEN 1
						ELSE 0
						END
					) AS mediator_hakim_berhasil,
					SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) <= '".$period."' AND hasil_mediasi='N' AND status_mediator='H' AND LEFT(mediasi_berhasil,7) = '".$period."'  THEN 1
						ELSE 0
						END
					) AS mediator_hakim_gagal
				FROM v_perkara
				WHERE alur_perkara_id IN (".$idalurperkara.")
				AND LEFT(tanggal_pendaftaran,7) <='".$period."';
				");
		} catch (Exception $e) {
			
		}
	}

	function get_stat_perkara_bln($period,$idalurperkara){
		try {
			return $this->db->query("
				SELECT jenis_perkara_id,jenis_perkara_nama,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>='".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' THEN 1
						ELSE 0
						END
					) AS sisa,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
						ELSE 0
						END
					) AS putus_blm_minut,
				SUM(
					CASE 
						WHEN (keputusan_mediasi IS NOT NULL AND LEFT(keputusan_mediasi,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') AND hasil_mediasi='Y' THEN 1
						ELSE 0
						END
					) AS med_blm_minut,
				SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) = '".$period."' THEN 1
						ELSE 0
						END
					) AS masuk,
				SUM(
					CASE 
						WHEN (penetapan_majelis_hakim IS NULL OR LEFT(penetapan_majelis_hakim,7)>'".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS blm_majelis,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS putus,
				SUM(
					CASE 
						WHEN (tanggal_minutasi IS NOT NULL AND LEFT(tanggal_minutasi,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS minut,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>'".$period."') THEN 1
						WHEN (LEFT(mediasi_berhasil,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
						ELSE 0
						END
					) AS blm_minut,
				SUM(
					CASE 
						WHEN (tanggal_cabut IS NOT NULL AND LEFT(tanggal_cabut,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS cabut,
				SUM(
					CASE 
						WHEN (tanggal_gugur IS NOT NULL AND LEFT(tanggal_gugur,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS gugur,
				SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) <= '".$period."' AND hasil_mediasi='Y' AND LEFT(mediasi_berhasil,7) = '".$period."'  THEN 1
						ELSE 0
						END
					) AS mediasi_berhasil,
					SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) <= '".$period."' AND hasil_mediasi='N' AND LEFT(mediasi_berhasil,7) = '".$period."'  THEN 1
						ELSE 0
						END
					) AS mediasi_gagal
				FROM v_perkara
				WHERE alur_perkara_id IN (".$idalurperkara.")
				AND LEFT(tanggal_pendaftaran,7) <='".$period."'
				GROUP BY jenis_perkara_id;");
		} catch (Exception $e) {
			
		}
	}
	function get_lap_perkara($period,$idalurperkara){
		try {
			return $this->db->query("SELECT 
									  jp.id,
									  jp.nama, 
									  vsum.* FROM jenis_perkara AS jp
									        LEFT JOIN (SELECT p.jenis_perkara_id
									       ,SUM(LEFT(dimulai_mediasi,7)='".$period."')  AS perkara_mediasi
									       ,SUM(LEFT(keputusan_mediasi,7)='".$period."' AND hasil_mediasi='Y' AND tanggal_cabut IS NULL) AS berhasil_akta
									       ,((SUM(LEFT(keputusan_mediasi,7)='".$period."' AND hasil_mediasi='Y' AND tanggal_cabut IS NULL)/SUM(LEFT(dimulai_mediasi,7)='".$period."'))*100) AS persen_akta
									       ,SUM(LEFT(keputusan_mediasi,7)='".$period."' AND hasil_mediasi='S') AS berhasil_sebagian
									       ,((SUM(LEFT(keputusan_mediasi,7)='".$period."' AND hasil_mediasi='S')/SUM(LEFT(dimulai_mediasi,7)='".$period."'))*100) AS persen_sebagian
									       ,SUM(LEFT(keputusan_mediasi,7)='".$period."' AND hasil_mediasi='Y' AND status_putusan_id=7 AND tanggal_cabut IS NOT NULL) AS berhasil_cabut
									       ,((SUM(LEFT(keputusan_mediasi,7)='".$period."' AND hasil_mediasi='Y' AND status_putusan_id=7 AND tanggal_cabut IS NOT NULL)/SUM(LEFT(dimulai_mediasi,7)='".$period."'))*100) AS persen_dicabut
									       ,SUM(LEFT(keputusan_mediasi,7)='".$period."' AND hasil_mediasi='T') AS tidak_berhasil
									       ,((SUM(LEFT(keputusan_mediasi,7)='".$period."' AND hasil_mediasi='T')/SUM(LEFT(dimulai_mediasi,7)='".$period."'))*100) AS persen_tdk_berhasil
									       ,SUM(LEFT(keputusan_mediasi,7)='".$period."' AND hasil_mediasi='D') AS tidak_dpt_dilaksanakan
									       ,((SUM(LEFT(keputusan_mediasi,7)='".$period."' AND hasil_mediasi='D')/SUM(LEFT(dimulai_mediasi,7)='".$period."'))*100) AS persen_tdk_laksana
									       FROM 
									       v_mediasi AS p WHERE p.alur_perkara_id = '".$idalurperkara."' GROUP BY p.jenis_perkara_id) AS vsum
									        ON jp.id =  vsum.jenis_perkara_id

									        WHERE jp.aktif='Y'
									        AND jp.id IN (SELECT ja.jenis_perkara_id FROM jenis_alur_perkara AS ja WHERE ja.alur_perkara_id='".$idalurperkara."')
									        ORDER BY jp.lft;
				");
		} catch (Exception $e) {
			
		}
	}
}