<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Mediasi_luar_m extends CI_Model{

	
	function get_data_mediasi($perkara_id){
		if(empty($perkara_id)){ 
				return '';
		}
		try{
			return $this->db->query("SELECT 
									mediasi.*,
									data_dukung.identifier 		AS identifier,
									data_dukung.kode_template	AS kode_template,
									data_dukung.uraian 			AS uraian
									FROM perkara_mediasi AS mediasi
										LEFT JOIN perkara_data_dukung_mediasi AS data_dukung
											ON mediasi.mediasi_id = data_dukung.mediasi_id 
									WHERE mediasi.perkara_id = $perkara_id AND mediasi.tahapan_id = 10 AND mediasi.jenis_mediasi=3
									ORDER BY mediasi.mediasi_id ASC");
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_date_tanggal($perkara_id){
		if(empty($perkara_id)){ 
				return '';
		}

		try {
			return $this->db->query("SELECT DISTINCT diinput_tanggal FROM perkara_mediator WHERE perkara_id=$perkara_id")->result();
		} catch (Exception $e) {
			log_message('error', $e);	
		}
	}

	function fetch_description($title,$data){
		$descrip = '<br><table style="vertical-align:top" cellspacing="0" cellpadding="1" border="1">';
		$descrip .= '<tr><th>Nama Kolom</th><th>Nilai</th></tr>';
		foreach ($data as $key => $value) {
			$descrip .= '<tr>';
			$descrip .= '<td>'.$key.'</td>';
			$descrip .= '<td>'.$value.'</td>';
			$descrip .= '</tr>';
		}
		$descrip .= '</table>';
		return $descrip;
	}

	function add_audittrail($action,$title,$descrip,$tablename){
		try {
			$data = array(
				'datetime' => date("Y-m-d H:i:s"),
				'ipaddress' => $this->input->ip_address(),
				'username' => $this->session->userdata('username'),
				'tablename' => $tablename,
				'formname' => 'Add Mediasi',
				'action' => $action,
				'title' => $title,
				'description' => $descrip
			);
			$this->db->insert('sys_audittrail', $data);
		} catch (Exception $e) {
			
		}
	}		

	function get_perkara_mediator(){
		try {
			$query = $this->db->query('SELECT MAX(id) AS maxid FROM perkara_mediator');
			return $query->row()->maxid;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_mediator(){
		try {
			$qry="SELECT id,nama,no_sertifikasi,status_mediator FROM mediator WHERE status_mediator='N' AND aktif='Y' ORDER BY status_mediator;";
			return $this->db->query($qry);
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}


	function get_mediator_edit($perkara_id){
		if(intval($perkara_id)<0){
			show_404();
		}

		try {
			return $this->db->query("SELECT 
									mediator_id,
									status_mediator,
									nama_mediator
									FROM perkara_mediator WHERE perkara_id=$perkara_id");
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getInfoPerkara($idperkara){
		try {			
			return $this->db->query('SELECT nomor_perkara,tanggal_pendaftaran FROM v_perkara 
				WHERE perkara_id='.$idperkara.';');			
		} catch (Exception $e) {
			return '';
		}
	}

	function get_maxid_mediasi(){
		try {
			$query = $this->db->query('SELECT IFNULL(MAX(mediasi_id)+1,1) AS maxid FROM perkara_mediasi');
			return $query;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function delete_update($perkara_id){
		try {
			$this->db->where('perkara_id',$perkara_id);
			$this->db->delete('perkara_mediator');
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function addmediator($data_mediator,$action){
		try {
			$this->db->insert('perkara_mediator', $data_mediator);
			if($action=='add'){
				$title = "Tambah table <b>perkara_mediator</b> dari halaman <b>Tambah Data Mediasi Luar</b> dengan Primary Key [perkara_id=".$data_mediator['perkara_id']."]";
				$descrip = $this->fetch_description($title,$datamediasi);
				$this->add_audittrail("INSERT",$title,$descrip,'perkara_mediator');
			}elseif($action=='edit'){
				$title = "UPDATE Tanggal Data Mediasi Diluar Pengadilan <br /> UPDATE table <b>perkara_mediator</b> dari halaman <b>Tambah Data Mediasi Luar</b> dengan Primary Key [perkara_id=".$data_mediator['perkara_id']."]";
				$descrip = $this->fetch_description($title,$datamediasi);
				$this->add_audittrail("UPDATE",$title,$descrip,'perkara_mediasi');
			}
			return TRUE;
		}
		 catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function addmediasi($datamediasi,$action,$perkara_id){
		try {
			if($action=='add')
			{
				//insert
				$this->db->insert('perkara_mediasi', $datamediasi);

				//insert audittrail
				$title = "Tambah table <b>perkara_mediasi</b> dari halaman <b>Tambah Data Mediasi Luar</b> dengan Primary Key [perkara_id=".$datamediasi['perkara_id']."]";
				$descrip = $this->fetch_description($title,$datamediasi);
				$this->add_audittrail("INSERT",$title,$descrip,'perkara_mediasi');
			}
			elseif($action=='edit')
			{
				//update);
				$this->db->where('perkara_id',$perkara_id);
				$this->db->update('perkara_mediasi',$datamediasi);

				//update audittrail
				$title = "UPDATE Tanggal Kesepatan Mediasi <br /> UPDATE table <b>perkara_mediasi</b> dari halaman <b>Tambah Data Mediasi Luar</b> dengan Primary Key [perkara_id=".$datamediasi['perkara_id']."]";
				$descrip = $this->fetch_description($title,$datamediasi);
				$this->add_audittrail("UPDATE",$title,$descrip,'perkara_mediasi');
			}
			return TRUE;
		}
		 catch (Exception $e) {
			return FALSE;
		}
	}
	
	function total_mediator(){
		try {
			return $this->db->query("SELECT COUNT(*) AS total FROM mediator");
		} catch (Exception $e) {
			log_message('error', $e);	
		}
	}

	function hapus_kesepakatan($idperkara){
		try {			
			$this->db->where('perkara_id',$idperkara);
			$this->db->delete('perkara_mediasi');

			$this->db->where('perkara_id',$idperkara);
			$this->db->delete('perkara_mediator');
			# insert audittrail
			$title = "DELETE Kesepakatan Mediasi di Luar Pengadilan <br /> DELETE table <b>perkara_mediasi</b> dari halaman <b>EDIT TANGGAL KESEPAKATAN MEDIASI</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$descrip = '';
			$this->add_audittrail("DELETE",$title,$descrip,'perkara_mediasi');
			return TRUE;
		} catch (Exception $e) {
			log_message('error', $e);
		}
		
	}

}