<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Sys_config extends CI_Controller {
	function index(){
		if ($this->session->userdata('idgroup')){
			if($this->session->userdata('idgroup')>2){
				redirect('login');
			}else{
				$this->showData();
			}
		}else{
			redirect('login');
		}
	}

	function showData(){
		$this->load->model('sistem/sistem_config');
		$data['page_title'] = 'KONFIGURASI SYSTEM ';
		$data['main_body'] = 'sistem/sys_config';
		$data['page_url'] = 'system';

		$data['list_pt'] = $this->sistem_config->get_list_pt();
		$data['list_pn'] = $this->sistem_config->get_list_pn();
		$data['info_pn'] = $this->sistem_config->get_info_pn();
		$id_pn = '';
		$data['id_pt'] = '';
		foreach ($data['info_pn']->result() as $row) {
			if ($row->id==81){
				$id_pn=$row->value;
			}
		}
		
		if(!empty($id_pn)){
			$res = $this->sistem_config->get_id_pt($id_pn)->result();
			$data['id_pt'] = $res[0]->pt_id;
		}
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_edit');
	}

	function validate_input(){
		# make sure that id pt and id pn match.
		# 
		
		if($this->input->post('kode_pn',TRUE)==-1){
			echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tidak Berhasil, Pilih Nama Pengadilan'));
			return;
		}

		if($this->input->post('pt',TRUE)==-1){
			echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tidak Berhasil, Pilih Nama Pengadilan Tingkat Banding'));
			return;
		}

		$this->form_validation->set_rules('pt', 'Nama Pengadilan Tingkat Banding', 'trim|required|xss_clean');
		$this->form_validation->set_rules('pn', 'Nama Pengadilan', 'trim|required|xss_clean');
		$this->form_validation->set_rules('kode_satker', 'Kode Satuan Kerja', 'trim|required|xss_clean|min_length[3]|max_length[7]|numeric');
		$this->form_validation->set_rules('kode_pn', 'Kode Pengadilan', 'trim|required|xss_clean|max_length[12]');
		$this->form_validation->set_rules('almt', 'Alamat Kantor Pengadilan', 'trim|required|xss_clean|min_length[5]');
		$this->form_validation->set_rules('ketua', 'Nama Ketua Pengadilan', 'trim|required|xss_clean|min_length[5]');
		$this->form_validation->set_rules('wakil_ketua', 'Nama Wakil Ketua Pengadilan', 'trim|required|xss_clean|min_length[5]');
		$this->form_validation->set_rules('pansek', 'Nama Panitera Sekretaris Pengadilan', 'trim|required|xss_clean|min_length[5]');
		$this->form_validation->set_rules('wapan', 'Nama Wakil Panitera Pengadilan', 'trim|required|xss_clean|min_length[5]');
		$this->form_validation->set_rules('wasek', 'Nama Wakil Sekretaris Pengadilan', 'trim|required|xss_clean|min_length[5]');
		$this->form_validation->set_rules('nip_ketua', 'NIP Ketua Pengadilan', 'trim|required|xss_clean|min_length[5]|max_length[18]');
		$this->form_validation->set_rules('nip_wakil_ketua', 'NIP Wakil Ketua Pengadilan', 'trim|required|xss_clean|min_length[5]|max_length[18]');
		$this->form_validation->set_rules('nip_pansek', 'NIP Panitera Sekretaris Pengadilan', 'trim|required|xss_clean|min_length[5]|max_length[18]');
		$this->form_validation->set_rules('nip_wapan', 'NIP Wakil Panitera Pengadilan', 'trim|required|xss_clean|min_length[5]|max_length[18]|numeric');
		$this->form_validation->set_rules('nip_wasek', 'NIP Wakil Sekretaris Pengadilan', 'trim|required|xss_clean|min_length[5]|max_length[18]|numeric');
		$this->form_validation->set_rules('zona', 'Zona Waktu', 'trim|required|xss_clean|min_length[3]|max_length[4]');

		if($this->input->post('dirjen')=='2'){
			$this->form_validation->set_rules('pangkat_ketua', 'Pangkat Korps Kepala', 'trim|required|xss_clean|min_length[5]');
			$this->form_validation->set_rules('pangkat_wakil_ketua', 'Pangkat Korps Wakil Kepala', 'trim|required|xss_clean|min_length[5]');
			$this->form_validation->set_rules('pangkat_panitera', 'Pangkat Korps Panitera', 'trim|required|xss_clean|min_length[5]');
			$this->form_validation->set_rules('pangkat_wakil_panitera', 'Pangkat Korps Wakil Panitera', 'trim|required|xss_clean|min_length[5]');
		}
		
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tidak Berhasil. '.validation_errors()));
		}else{
			$this->load->model('sistem/sistem_config');
			$arr_id_pn=explode("##", $this->input->post('pn',TRUE));
			$nama_pn = $this->sistem_config->get_pn_name($arr_id_pn[0]);
			$id_pn_dbase=$arr_id_pn[1];
			$nama_pt=$this->sistem_config->get_nama_pt($id_pn_dbase)->row()->nama;
			$alamat_pt='';
			if(empty($nama_pn)){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tidak Berhasil. Something wrong with your input.'));
			}
			$data = array(
				array(
					'id' =>61,
					'col_name' =>'value',
					'value' => $this->input->post('kode_pn',TRUE)
					),
				array(
					'id' =>62,
					'col_name' =>'value',
					'value' => $nama_pn
					),
				array(
					'id' =>63,
					'col_name' =>'value',
					'value' => $this->input->post('almt',TRUE)
					),
				array(
					'id' =>64,
					'col_name' =>'value',
					'value' => $this->input->post('ketua',TRUE)
					),
				array(
					'id' =>65,
					'col_name' =>'value',
					'value' => $this->input->post('nip_ketua',TRUE)
					),
				array(
					'id' =>66,
					'col_name' =>'value',
					'value' => $this->input->post('wakil_ketua',TRUE)
					),
				array(
					'id' =>67,
					'col_name' =>'value',
					'value' => $this->input->post('nip_wakil_ketua',TRUE)
					),
				array(
					'id' =>68,
					'col_name' =>'value',
					'value' => $this->input->post('pansek',TRUE)
					),
				array(
					'id' =>69,
					'col_name' =>'value',
					'value' => $this->input->post('nip_pansek',TRUE)
					),
				array(
					'id' =>70,
					'col_name' =>'value',
					'value' => $this->input->post('wapan',TRUE)
					),
				array(
					'id' =>71,
					'col_name' =>'value',
					'value' => $this->input->post('nip_wapan',TRUE)
					),
				array(
					'id' =>72,
					'col_name' =>'value',
					'value' => $this->input->post('wasek',TRUE)
					),
				array(
					'id' =>73,
					'col_name' =>'value',
					'value' => $this->input->post('nip_wasek',TRUE)
					),
				array(
					'id' =>75,
					'col_name' =>'value',
					'value' => $this->input->post('zona',TRUE)
					),
				array(
					'id' =>81,
					'col_name' =>'value',
					'value' => $arr_id_pn[1]
					),
				array(
					'id' =>82,
					'col_name' =>'value',
					'value' => $arr_id_pn[0]
					),
				array(
					'id' =>83,
					'col_name' =>'value',
					'value' => $this->input->post('dirjen',TRUE)
					),
				array(
					'id' =>84,
					'col_name' =>'value',
					'value' => $this->input->post('pangkat_ketua',TRUE)
					),
				array(
					'id' =>85,
					'col_name' =>'value',
					'value' => $this->input->post('pangkat_wakil_ketua',TRUE)
					),
				array(
					'id' =>86,
					'col_name' =>'value',
					'value' => $this->input->post('pangkat_panitera',TRUE)
					),
				array(
					'id' =>87,
					'col_name' =>'value',
					'value' => $this->input->post('pangkat_wakil_panitera',TRUE)
					),
				array(
					'id' =>76,
					'col_name' =>'value',
					'value' => $nama_pt
					),
				array(
					'id' =>77,
					'col_name' =>'value',
					'value' => $alamat_pt
					)
				);
			
			
			$menulisttun = '100,1,600,603,604,605,608,609,610,611,601,613,614,615,619,620,621,636,602,622,623,84,624,630,64,118,158,159,160,119,239,240,241,120,238,157,630,631,632,265,5000,5001';
			$menulistmiliter = '100,1,401,402,84,2020,2021,157,2022,2023,64,118,158,159,160,119,239,240,241,5000,5001';
			$menulistumum = '100,1,107,118,119,120,121,146,108,266,147,84,132,2012,133,134,137,140,141,142,268,270,157,158,159,160,135,238,239,240,241,252,253,136,64,2016,265,5000,5001,6000';
			$menulistagama = '100,1,84,64,120,121,119,118,238,157,158,159,160,265,239,240,241,1003,700,701,703,702,704,705,706,707,708,709,710,711,712,713,714,715,716,717,2016,718,719,720,721,722,723,724,5000,5001,2024,2025,2026,6000';
			if($this->input->post('dirjen')==1){
				$groupUser = '1,10,20,30,410,412,413,414,420,422,423,430,431,440,442,443,444,454,450,452,453,460,462,463,470,472,473,480,482,483,500,600,650,702,900,901';
				$activemenu = $menulistumum;
				$nonactive = $menulistmiliter.','.$menulisttun.$menulistagama;
			}elseif($this->input->post('dirjen')==2){
				$groupUser = '1,10,20,30,420,422,423,430,431,500,900,901';
				$activemenu = $menulistmiliter;
				$nonactive = $menulistumum.','.$menulisttun.$menulistagama;
			}elseif ($this->input->post('dirjen')==3) {
				$groupUser = '1,10,20,30,1030,1032,1033,1034,430,431,500,600,650,702,900,901';
				$activemenu = $menulisttun;
				$nonactive = $menulistumum.','.$menulisttun.$menulistagama;
			}elseif ($this->input->post('dirjen')==4) {
				$groupUser = '1,10,20,30,430,431,500,600,650,702,900,901,1000,1001,1002,1003,1010,1011,1012,1013,1020,1022,1023';
				$activemenu = $menulistagama;
				$nonactive = $menulistumum.','.$menulisttun.$menulistmiliter;
			}
			$update = $this->sistem_config->update_data($data,$activemenu,$nonactive,$groupUser);
			if($update===TRUE){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tidak Berhasil,'.$update));
			}
		}
	}
}