<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Laporan_Mediasi extends CI_Controller {

	function index(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$idalurperkara = 1;
		$this->load->model('report/report');
		$year = array(date("Y",time()));
		$tahun_sekarang = date("Y",time());
		$min_tahun = $tahun_sekarang;
		 $query = $this->report->get_tahun($idalurperkara);
		 if($query->num_rows==1){
		 	foreach ($query->result() as $row) {
		 		$min_tahun = $row->years;
		 	}
		 }
		$tmp = $tahun_sekarang;
		if($min_tahun<$tahun_sekarang AND !empty($min_tahun)){
			while (TRUE) {
				$tmp--;
				if($tmp<$min_tahun){
					break;
				}
				array_push($year, $tmp);
			}
		}

		$idalurperkara='';
		$list_perkara='';
		$data['list_perkara'] = $list_perkara;
		$data['jenis_laporan'] = $this->fetch_jenis_laporan($idalurperkara);
		$data['rekap_laporan'] = $this->fetch_rekap_laporan($idalurperkara);
		$data['tahun'] = $year;
		$data['page_title'] = 'LAPORAN MEDIASI';

		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('laporan/laporan_mediasi');
		$this->load->view('footer');
	}

	function fetch_jenis_laporan($idalurperkara){
		$jenis_laporan = array(
			array('nama'=>'REKAPITULASI HASIL MEDIASI BERDASARKAN KLASIFIKASI',
				'id' => '1',
				'lap_mediasi' => '1',
				'tahapan' => '10'),
			array('nama'=>'REKAPITULASI MEDIATOR',
				'id' => '1',
				'lap_mediasi' => '2',
				'tahapan' => '10'),
			array('nama'=>'REKAPITULASI HASIL MEDIASI BERDASARKAN STATUS MEDIATOR',
				'id' => '1',
				'lap_mediasi' => '3',
				'tahapan' => '10'),
			array('nama'=>'REKAPITULASI JUMLAH MEDIASI BERDASARKAN MEDIATOR',
				'id' => '1',
				'lap_mediasi' => '4',
				'tahapan' => '10'),
			array('nama'=>'LAPORAN MEDIASI BULANAN',
				'id' => '1',
				'lap_mediasi' => '5',
				'tahapan' => '10'),
			);

	return $jenis_laporan;
	}

	function fetch_rekap_laporan($idalurperkara){
		$rekap_laporan = array(
			array('nama'=>'REKAPITULASI JUMLAH PERKARA MEDIASI DAN HASIL MEDIASI',
				'id' => '1',
				'idalur' => '1',
				'tahapan' => '10'),
			array('nama'=>'REKAPITULASI HASIL MEDIASI BERDASARKAN KLASIFIKASI',
				'id' => '2',
				'idalur' => '1',
				'tahapan' => '10'),
			array('nama'=>'REKAPITULASI HASIL MEDIASI BERDASARKAN KLASIFIKASI PER PERIODE',
				'id' => '3',
				'idalur' => '1',
				'tahapan' => '10'),
			array('nama'=>'REKAPITULASI MEDIATOR',
				'id' => '4',
				'idalur' => '1',
				'tahapan' => '10'),
			array('nama'=>'REKAPITULASI MEDIATOR PER PERIODE',
				'id' => '5',
				'idalur' => '1',
				'tahapan' => '10'),
			array('nama'=>'REKAPITULASI HASIL MEDIASI BERDASARKAN STATUS MEDIATOR',
				'id' => '6',
				'idalur' => '1',
				'tahapan' => '10'),
			array('nama'=>'REKAPITULASI HASIL MEDIASI BERDASARKAN STATUS MEDIATOR PER PERIODE',
				'id' => '7',
				'idalur' => '1',
				'tahapan' => '10'),
			array('nama'=>'REKAPITULASI JUMLAH MEDIASI BERDASARKAN MEDIATOR',
				'id' => '8',
				'idalur' => '1',
				'tahapan' => '10'),
			array('nama'=>'REKAPITULASI JUMLAH MEDIASI BERDASARKAN PIHAK',
				'id' => '9',
				'idalur' => '1',
				'tahapan' => '10'),
			array('nama'=>'REKAPITULASI PERKARA MEDIASI',
				'id' => '10',
				'idalur' => '1',
				'tahapan' => '10'),
			);

	return $rekap_laporan;
	}

}