<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Cabut_perkara_c extends CI_Controller {
	function index(){

		if($this->nativesession->get_flash_session('security')==FALSE){
			#redirect('main');
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$segment = $this->uri->segment_array();
		$enc = $this->uri->segment(2);
		$idperkara = $this->encrypt->decode(base64_decode($enc));
		if(empty($idperkara) OR intval($idperkara)<1){
			show_404();
		}
		$this->tampil_form($idperkara);

	}

	function tampil_form($idperkara){
		$data['enc']=base64_encode($this->encrypt->encode($idperkara));
		$data['tgl_sekarang'] = date('d/m/Y');
		$data['isi_cabut']='';

		$this->load->model('putusan/data_putusan_akhir','putusan');
		$data['sumber_hukum'] = $this->putusan->getDataSumberHukum();
		$putusan = $this->putusan->getDataPutusanAkhir($idperkara);
		if($putusan !=''){
			if($putusan->num_rows()>0){
				foreach ($putusan->result() as $row) {
					$data['sumber_hukum_put'] = $row->sumber_hukum_id;
				}
			}
		}	

		$data['sumber_hukum_put'] = $row->sumber_hukum_id;
		$this->load->model('perkara/cabut_perkara','cabut');

		$result = $this->cabut->get_data_perkara($idperkara);
		if($result!=''){
			if($result->num_rows()>0){
				foreach ($result->result() as $row) {
					$data['nomor_perkara'] = $row->nomor_perkara;
					$data['tanggal_pendaftaran'] = $row->tanggal_pendaftaran;
				}
			}else{
				$this->error_page->show_error_msg('Error Found','Tidak ada Perkara');
				exit();
			}
		}
	
		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '800px';
		$this->ckeditor->config['height'] = '200px';

		$this->load->vars($data);
		$this->load->view('Cabut/cabut_perkara');
	}

	function validateInput(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$this->form_validation->set_rules('tgl_cabut', 'Tanggal Cabut', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('isi_cabut_text', 'Amar Pencabutan', 'trim|required|xss_clean|min_length[50]');

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));	
			$isi_amar = trim($this->input->post('isi_cabut_text',TRUE));
			
			if(!is_numeric($idperkara)){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tidak Berhasil Perkara Tidak ditemukan. Code Error = 194.'));
				return;
			}else{

				$curr_date = date('Y-m-d');
				$todayDate = date('m/d/Y');

				$sumberHukum = implode(',',$this->input->post('sumber_hukum',TRUE));
				if(empty($sumberHukum)){
					if(strlen($sumberHukum)<0){
						echo json_encode(array('st'=>0,'msg'=>'Error <br> Sumber Hukum Wajib Dipilih.'));
						return;
					}
					echo json_encode(array('st'=>0,'msg'=>'Error <br> Sumber Hukum Tidak Valid.'));
					return;
				}
				
				$tgl_cabut = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_cabut',TRUE));
				
				$selisih = $this->tanggalhelper->getSelisihHari($tgl_cabut,$curr_date);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tanggal Pencabutan Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
					return;
				}

				$dayname = $this->tanggalhelper->getDayName($tgl_cabut);
				if($dayname=='Saturday' OR $dayname=='Sunday'){
					echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tidak Dapat Memilih Tanggal Pencabutan Dihari Libur, Sabtu dan Minggu.'));
					return;
				}

				$tglpendaftaran = $this->tanggalhelper->getTanggalPendaftaran($idperkara);

				$selisih = $this->tanggalhelper->getSelisihHari($tglpendaftaran,$tgl_cabut);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tanggal Pencabutan Tidak Boleh Kurang dari Tanggal Pendaftaran Perkara.'));
					return;
				}

				$this->load->model('perkara/cabut_perkara','cabut');
				$data_add = array(
						'perkara_id' => $idperkara,
						'tanggal_putusan' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_cabut',TRUE)),
						'sumber_hukum_id' => 0,						
						'status_putusan_id' => 7,
						'sumber_hukum_id' => $sumberHukum,						
						'status_putusan_nama' => 'Dicabut',
						'status_putusan_text' => 'Dicabut',		
						'tanggal_cabut' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_cabut',TRUE)),																												
						'amar_putusan' => $isi_amar,
						'diinput_oleh' => $this->session->userdata('username'),
						'diinput_tanggal' => date("Y-m-d h:i:s",time())
					);


				$data_edit = array(
						'tahapan_terakhir_id' => 15,
						'tahapan_terakhir_text' => 'Putusan',
						'proses_terakhir_id' => 211,
						'proses_terakhir_text' => 'Perkara Dicabut',						
						'diperbaharui_oleh' => $this->session->userdata('username'),
						'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
					);

				if(!empty($idperkara)){
					$result = $this->cabut->add_cabut($data_add);
					$result = $this->cabut->edit_cabut($data_edit,$idperkara);
				}

				if($result===FALSE){
					echo json_encode(array('st'=>0,'msg'=>'Gagal Menyimpan'));
					return;
				}
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
				return;
			}
		}
	}



}