<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Buku_induk_keuangan extends CI_Controller {
	function parseParam($params){
		$data = array();
		$idalurperkara = '';
		$tahapan_id = '';
		$tmp = explode(";", $params);
		if(count($tmp)>0){
			$tmp_var = explode("=", $tmp[0]);
			if(count($tmp_var)>0){
				$data['idalurperkara'] = $tmp_var[1];
			}
		}
		return $data;
	}
	function index(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$this->load->model('default/defaults');
		$segment = $this->uri->segment_array();

		$pagenumber = 0;
		$keyword = "";
		$col ="";
		if($this->uri->segment(2)=='page'){
			$pagenumber = $this->uri->segment(3);
			$param = $this->uri->segment(4);
			$tmp = explode("=", $this->uri->segment(5));
			if($tmp>0 AND $tmp[0]=="col"){
				$col = $tmp[1];
			}else{
				$keyword = rawurldecode($this->uri->segment(5));
				$col = $this->uri->segment(6);
			}
		}elseif($this->uri->segment(2)=='search'){
			$param = $this->input->post('enc');
			$keyword = $this->input->post('search');
			$this->session->set_userdata('total_rows',-1);
		}elseif($this->uri->segment(2)=='sort'){
			$col = $this->uri->segment(3);
			$param = $this->uri->segment(4);
			$this->sort($col,$param,$keyword);
			return;
		}else{
			$this->session->set_userdata('asc_desc','DESC');
			$param = $this->uri->segment(4);
			$this->session->set_userdata('total_rows',-1);
		}
		
		if(empty($param)){
			show_404();
		}

		$this->showData($param,$pagenumber,$keyword,$col);
	}

	function sort($col=null,$enc=null,$keyword=null){
		if($this->session->userdata('asc_desc')){
			if($this->session->userdata('asc_desc')=="DESC"){
				$this->session->set_userdata('asc_desc','ASC');
			}else{
				$this->session->set_userdata('asc_desc','DESC');
			}
		}else{
			$this->session->set_userdata('asc_desc','ASC');
		}
		$this->showData($enc,0,$keyword,$col);
	}

	function showData($param,$pagenumber=0,$keyword='',$col=2){
		$asc_desc = $this->session->userdata('asc_desc');
		if($pagenumber>0){
			$begin_limit = ($pagenumber-1)*50;
		}else{
			$begin_limit = 0;
			$pagenumber = 1;
		}
		$params = $this->encrypt->decode(base64_decode($param));
		$data = $this->parseParam($params);

		$enc = base64_encode($this->encrypt->encode($data['idalurperkara']));
		$idalurperkara = $this->encrypt->decode(base64_decode($enc));
		$this->load->model('jurnal/jurnal_buku_induk','jurnal');
		
		$data['params'] = $params;
		$data['enc'] = $param;
		$data['idalurperkara'] = $idalurperkara;
		$data['list_jurnal_biaya'] = $this->jurnal->getJurnalList($data['idalurperkara'],$begin_limit,$keyword,$col,$asc_desc);
		
		
		if($this->session->userdata('total_rows')){
			if($this->session->userdata('total_rows')==-1){
				$data['total_rows'] = $this->jurnal->fecth_data_num($idalurperkara,$keyword);
				$this->session->set_userdata('total_rows',$data['total_rows']);
			}else{
				$data['total_rows'] = $this->session->userdata('total_rows');
			}
		}else{
			$data['total_rows'] = $this->jurnal->fecth_data_num($idalurperkara,$keyword);
			$this->session->set_userdata('total_rows',$data['total_rows']);
		}
		$data['page_active'] = $begin_limit+1;
		$data['page_number'] = $pagenumber;

		$title_perkara = ''; 

		if($data['total_rows']>0){
				$firstrow = $data['list_jurnal_biaya']->first_row('array');
				$totalmoney = $this->jurnal->getTotalMoney($firstrow['tanggal_transaksi'])->first_row('array');
				$data['totalTerima'] = $totalmoney['penerimaan'];
				$data['totalKeluar'] = $totalmoney['pengeluaran'];
		}

		if($data['idalurperkara']=='1,2,7,8'){
			$data['page_title'] = 'BUKU INDUK KEUANGAN PERKARA PERDATA UMUM';
		}elseif($data['idalurperkara']=='3,4'){
			$data['page_title'] = 'BUKU INDUK KEUANGAN PERKARA KEPAILTAN & PKPU';
		}elseif($data['idalurperkara']=='5'){
			$data['page_title'] = 'BUKU INDUK KEUANGAN PERKARA HAK KEKAYAAN INTELEKTUAL';
		}elseif($data['idalurperkara']=='6'){
			$data['page_title'] = 'BUKU INDUK KEUANGAN PERKARA PENGADILAN HUBUNGAN INDUSTRIAL';
		}elseif($data['idalurperkara']=='9,10,11,12,13,14'){
			$data['page_title'] = 'BUKU INDUK KEUANGAN PERKARA PENGADILAN TATA USAHA NEGARA';
		}elseif($data['idalurperkara']=='15,16'){
			$data['page_title'] = "BUKU INDUK KEUANGAN PERKARA PENGADILAN AGAMA / MAHKAMAH SYAR'IYAH";
		}
		
		$data['main_body'] = 'jurnal_perkara/jurnal_buku_induk';
		$data['page_url'] = 'jurnal_induk_list';
		$data['keyword'] = $keyword;
		$data['column_sorted'] = $col;
		$this->load->vars($data);

		$this->load->view('header');
		$this->load->view('body/body');
	}

	function add_biaya($idperkara){
		$this->load->view('add_biaya');
	}
}