<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Add_pk extends CI_Controller {
	function index(){
		#prevent direct access to page
		#the user should only access the page through menu
		if($this->nativesession->get_flash_session('security')==FALSE){
			redirect('main');
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$idalurperkara = $this->nativesession->get_flash_session('alur_perkara_id');
		$idtahapan = $this->nativesession->get_flash_session('tahapan_id');
		$this->show_data($idalurperkara);
	}
	function show_data($idalurperkara){
		$this->load->model('perkara/new_pk','pk');
		if($idalurperkara=='111,112,113'){
			$nama = 'PIDANA';
			$idalurperkara = 200;
		}elseif ($idalurperkara==122) {
			$nama = 'JINAYAT';
			$idalurperkara = 200;
		}else{
			$nama = $this->pk->getJenisPerkara($idalurperkara);
		}

		$data['biaya'] = '';
		if($idalurperkara<100){
			$data['biaya'] = $this->pk->getBiayaPerkara($idalurperkara,40);
		}
		
		$data['page_title'] = 'TAMBAH - PERMOHONAN PENINJAUAN KEMBALI PERKARA '.strtoupper($nama);
		$data['main_body'] = 'perkara/new_pk';
		#$data['previous'] = $this->nativesession->get_flash_session('url_requested')
		$data['jenis_pengadilan']=$this->session->userdata('jenis_pengadilan');
		$data['enc_alur'] = base64_encode($this->encrypt->encode($idalurperkara));
		$data['idalurperkara'] = $idalurperkara;
		$data['lang_tglput']=$this->nativesession->getLangguage('tanggal_putusan');	
		$data['current_date'] = date('d/m/Y');
		$data['history'] = $this->nativesession->get_flash_session('main_url_requested');
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}

	function fetchData(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Please Refresh Your Page'));
			return;
		}
		$nomorperkara = trim($this->input->post('val',TRUE));
		if(empty($nomorperkara)){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$enc_alur = $this->input->post('enc_alur',TRUE);
		$idalurperkara = $this->encrypt->decode(base64_decode($enc_alur));
		$this->load->model('perkara/new_pk',"pk");
		$dataPerkara = $this->pk->getInfoPutusan($nomorperkara);
		if($dataPerkara->num_rows>0){
			foreach ($dataPerkara->result() as $row) {
				$tglPutusanPN = $this->tanggalhelper->convertDayDate($row->tanggal_putusan);
				$tglPutusan = $this->tanggalhelper->convertToInputDate($row->tanggal_putusan);
				$idperkara = $row->perkara_id;
				$idalurperkaradb = $row->alur_perkara_id;
				$jenisperkaraid = $row->jenis_perkara_id;
				$tglPutusanPNOri = $row->tanggal_putusan;
				$tglBHT = $row->tanggal_bht;
			}
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		if(empty($tglPutusanPNOri)){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Dapat Dimohonkan PK Karena Belum Putus.'));
			return;
		}

		if(empty($tglBHT)){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Dapat Dimohonkan PK Karena Belum BHT.'));
			return;
		}

		if($idalurperkara!=$idalurperkaradb){
			if($idalurperkaradb>100 AND $idalurperkara!=200){
				echo json_encode(array('st'=>0,'msg'=>'Mohon Menambah Permohonan Peninjauan Kembali Pidana Melalui Menu Register Permohonan Peninjauan Kembali Pidana'));
				return;
			}elseif($idalurperkaradb<100 AND $idalurperkara==200){
				echo json_encode(array('st'=>0,'msg'=>'Mohon Menambah Permohonan Peninjauan Kembali Perdata Melalui Menu Jurnal Permohonan Peninjauan Kembali'));
				return;
			}elseif($idalurperkara<200 AND $idalurperkaradb>100){
				echo json_encode(array('st'=>0,'msg'=>$idalurperkara.'-'.$idalurperkaradb.'Mohon Menambah Permohonan Peninjauan Kembali Pada Menu Yang Sesuai'));
				return;
			}
			if($idalurperkaradb==2 OR $idalurperkaradb==3 OR $idalurperkaradb==4 OR $idalurperkaradb==5 OR $idalurperkaradb==6){
				echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Dapat Melakukan Upaya Hukum Peninjauan Kembali'));
				return;
			}
		}
		if($jenisperkaraid==624){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Dapat Melakukan Upaya Hukum Peninjauan Kembali'));
			return;
		}

		if($idalurperkara!=$idalurperkaradb){
			if($idalurperkaradb>100 AND $idalurperkara!=200){
				if($idalurperkara==118){
					echo json_encode(array('st'=>0,'msg'=>'Mohon Menambah Permohonan PK Hanya Untuk Perkara Anak'));
					return;
				}
				echo json_encode(array('st'=>0,'msg'=>'Mohon Menambah Permohonan PK Pidana Melalui Menu Register Permohonan PK Pidana'));
				return;
			}elseif($idalurperkaradb<100 AND $idalurperkara==200){
				echo json_encode(array('st'=>0,'msg'=>'Mohon Menambah Permohonan PK Perdata Melalui Menu Jurnal Permohonan PK'));
				return;
			}elseif($idalurperkara<200 AND $idalurperkaradb>100){
				echo json_encode(array('st'=>0,'msg'=>'Mohon Menambah Permohonan PK Pada Menu Yang Sesuai'));
				return;
			}
			if($idalurperkaradb==2 OR $idalurperkaradb==3 OR $idalurperkaradb==4 OR $idalurperkaradb==5 OR $idalurperkaradb==6){
				echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Dapat Melakukan Upaya Hukum PK'));
				return;
			}
		}
		$stpihak = $this->pk->getStatusPihak($idalurperkaradb);

		if($stpihak!=''){
			if($stpihak->num_rows>0){
				foreach ($stpihak->result() as $row) {
					$statuspihak[$row->pihak_ke] = $row->nama;
				}
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Something Bad Happened, Please Refresh Your Browser.'));
				return;
			}
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Something Bad Happened, Please Refresh Your Browser.'));
			return;
		}

		$bandingStatus = FALSE;
		$isAllBanding = FALSE;
		
		
		$result = $this->pk->getPihak($idperkara,1);
		if($result->num_rows()==0){
			echo json_encode(array('st'=>0,
				'status'=>1,
				'msg'=>'Error, PIHAK TIDAK DITEMUKAN'));
			return;
		}
		$pihakPertama = $this->parse($result,1,$idalurperkaradb,$statuspihak);
		$allBandingPihak1 = $this->parseJmlhBanding($result);

		$result = $this->pk->getPihak($idperkara,2);
		$pihakKedua = '';
		$allBandingPihak2 = TRUE;
		if($result->num_rows()==0 && $idalurperkaradb!=2 && $idalurperkaradb!=16){
			echo json_encode(array('st'=>0,
				'status'=>1,
				'msg'=>'Error, PIHAK TIDAK DITEMUKAN'));
			return;
		}else{
			$pihakKedua = $this->parse($result,2,$idalurperkaradb,$statuspihak);
			$allBandingPihak2 = $this->parseJmlhBanding($result);
		}		

		$pihakKetiga = '';
		$pihakKeempat = '';
		if($idalurperkaradb<100){
			$result = $this->pk->getPihak($idperkara,3);
			if(!empty($result)){
				if($result->num_rows>0){
					$pihakKetiga = $this->parse($result,3,$idalurperkaradb,$statuspihak);
					$allBandingPihak3 = $this->parseJmlhBanding($result);
				}
			}

			$result = $this->pk->getPihak($idperkara,4);
			if(!empty($result)){
				if($result->num_rows>0){
					$pihakKeempat = $this->parse($result,4,$idalurperkaradb,$statuspihak);
					$allBandingPihak4 = $this->parseJmlhBanding($result);
				}
			}
			
		}

		$tglDaftar = $this->input->post('tglDaftar',TRUE);
		$stTgl = 1;
		$stTglMsg ='';
		if($allBandingPihak1==TRUE AND $allBandingPihak2==TRUE){
			$isAllBanding = TRUE;
		}

		if(!empty($pihakKetiga)){
			if($isAllBanding==TRUE AND $allBandingPihak3==TRUE){
				$isAllBanding = TRUE;
			}elseif($isAllBanding==TRUE AND $allBandingPihak3==FALSE){
				$isAllBanding = FALSE;
			}
		}

		if(!empty($pihakKeempat)){
			if($isAllBanding==TRUE AND $allBandingPihak4==TRUE){
				$isAllBanding = TRUE;
			}elseif($isAllBanding==TRUE AND $allBandingPihak4==FALSE){
				$isAllBanding = FALSE;
			}
		}

		if(!empty($tglDaftar)){
			$tglputusanbanding = $this->pk->getTanggalBanding($idperkara);
			$tglputusankasasi = $this->pk->getTanggalKasasi($idperkara);
			$tglDaftar = $this->tanggalhelper->convertToMysqlDate($tglDaftar);
			if(!empty($tglputusankasasi)){
				$selisih = $this->tanggalhelper->getSelisihHari($tglputusankasasi,$tglDaftar);
				if($selisih<0){
					$stTgl = 0;
					$stTglMsg = ' Tanggal Permohonan Kurang dari Tanggal Putusan Kasasi';
				}elseif($selisih>14){
					$stTgl = 0;
					$stTglMsg = 'Permohonan Peninjauan Kembali Telah Melebihi 14 Hari Setelah Putusan Kasasi. Mohon Untuk Melihat kembali permohonan yang diajukan untuk menjadi catatan.';
				}
			}elseif(!empty($tglputusanbanding)){
				$selisih = $this->tanggalhelper->getSelisihHari($tglputusanbanding,$tglDaftar);
				if($selisih<0){
					$stTgl = 0;
					$stTglMsg = ' Tanggal Permohonan Kurang dari Tanggal Putusan Banding';
				}elseif($selisih>14){
					$stTgl = 0;
					$stTglMsg = 'Permohonan Peninjauan Kembali Telah Melebihi 14 Hari Setelah Putusan Banding. Mohon Untuk Melihat kembali permohonan yang diajukan untuk menjadi catatan.';
				}
			}else{
				$selisih = $this->tanggalhelper->getSelisihHari($tglPutusanPNOri,$tglDaftar);
				if($selisih<0){
					$stTgl = 0;
					$stTglMsg = ' Tanggal Permohonan Kurang dari Tanggal Putusan';
				}elseif($selisih>14){
					$stTgl = 0;
					$stTglMsg = 'Permohonan Peninjauan Kembali Telah Melebihi 14 Hari Setelah Putusan Tingkat Pertama. Mohon Untuk Melihat kembali permohonan yang diajukan untuk menjadi catatan.';
				}
			}
		}
		
		if($isAllBanding==TRUE){
			echo json_encode(array('st'=>0,
				'status'=>1,
				'msg'=>'Semua Pihak Telah Melakukan Upaya Hukum PK'));
			return;
		}
		echo json_encode(array(
			'st'=>1,
			'tglPutusanPN'=>$tglPutusanPN,
			'pihakPertama'=>$pihakPertama,
			'pihakKedua'=>$pihakKedua,
			'pihakKeempat'=>$pihakKeempat,
			'enc'=>base64_encode($this->encrypt->encode($idperkara)),
			'enc_alur'=>base64_encode($this->encrypt->encode($idalurperkaradb)),
			'tglPutusan'=> $tglPutusan,
			'stTgl'=>$stTgl,
			'stTglMsg'=>$stTglMsg,
			'isBanding'=>$bandingStatus,
			'isAllBanding'=>$isAllBanding
		));
		return;
	}

	function parse($pihak,$pihakke,$idalurperkara,$statuspihak){
		if($pihakke==1){
			$namaPihak = $statuspihak[1];
		}elseif($pihakke==2){
			$namaPihak = $statuspihak[2];
		}elseif($pihakke==3){
			$namaPihak = $statuspihak[3];
		}elseif($pihakke==4){
			$namaPihak = $statuspihak[4];
		}
		$totalPihak = $pihak->num_rows();
		$hasil = '';
		$jmlhBanding = 0;
		if($pihak->num_rows>0){
			$x = 0;
			foreach ($pihak->result() as $row) {
				$hasil .= '<tr class="tr_pihak'.$pihakke.'">';
				if($x==0){
					$hasil .= '<td style="vertical-align:top;" rowspan="'.$totalPihak.'">'.$namaPihak.'</td>';
				}
				if(!empty($row->permohonan_pk)){
					$jmlhBanding++;
					$this->kasasiStatus = TRUE;
					$hasil .= '	<td style="padding:0px;padding-left:5px;background-color:snow;">
								'.$row->nama.'
								</td>
								<td style="padding:0px;padding-left:5px;background-color:snow;">';
					$hasil .= $row->status_pihak_text.' Ke '.$row->urutan;
					$hasil .='</td>
							</tr>';
				}else{
					$hasil .= '	<td style="padding:0px;padding-left:5px;background-color:snow;">
								<input status ="ck_pihak'.$pihakke.'" class="checkbox_status" identify="pihak_'.$row->pihak_id.'" id="no_'.$row->pihak_id.'" type="checkbox" name="para_pihak'.$pihakke.'[]" value="'.base64_encode($this->encrypt->encode($row->pihak_id)).'" nama_pihak = "'.$row->nama.'"> '.$row->nama.'
							</td>
							<td style="display:none;" id="pihak_no_'.$row->pihak_id.'" class ="ck_pihak'.$pihakke.'">
								<span class="custom-dropdown custom-dropdown--emerald" style="width:150px;">
									<select name="pihak_'.$row->pihak_id.'" id="pihak_'.$row->pihak_id.'" style="width:150px;" pihak="'.base64_encode($this->encrypt->encode($row->pihak_id)).'" class="pembanding custom-dropdown__select custom-dropdown__select--white">';
					
					if($idalurperkara>100){
						$hasil .= '<option class="status_pihak" name="pembanding_'.$pihakke.'" value="1" id="pihak_'.$row->pihak_id.'" pihak="'.base64_encode($this->encrypt->encode($row->pihak_id)).'">Pemohon Ke-1</option>';
					}else{
						$hasil .= '<option class="status_pihak" name="pembanding_'.$pihakke.'" value="-1" id="pihak_'.$row->pihak_id.'" >Pilih Urutan</option>';
						for ($i=0; $i < $totalPihak; $i++) { 
							$hasil .= '<option class="status_pihak" name="pembanding_'.$pihakke.'" value="'.($i+1).'" id="pihak_'.$row->pihak_id.'" pihak="'.base64_encode($this->encrypt->encode($row->pihak_id)).'">Pemohon Ke-'.($i+1).'</option>';
						}
					}
					
					$hasil .='
										</select>
									</span>
								</td>
							</tr>';
				}
				$x++;
			}
		}
		if($totalPihak==$jmlhBanding AND $pihakke==1){
			$this->allBandingPihak1 = TRUE;
		}
		if($totalPihak==$jmlhBanding AND $pihakke==2){
			$this->allBandingPihak2 = TRUE;
		}
		return $hasil;
	}

	function parseJmlhBanding($pihak){
		$totalPihak = $pihak->num_rows();
		$jmlhBanding = 0;
		if($pihak->num_rows>0){
			foreach ($pihak->result() as $row) {
				if(!empty($row->permohonan_pk)){
					$jmlhBanding++;
				}
			}
		}
		if($totalPihak==$jmlhBanding){
			return TRUE;
		}
		return FALSE;
	}

	function fetchDataPemohon(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Silahkan Login Terlebih Dahulu'));
			return;
		}
		$idpihak = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idpihak) OR intval($idpihak)<0){
			echo json_encode(array('st'=>0,'msg'=>'Pihak Tidak Ditemukan.'.$idpihak));
			return;
		}
		$this->load->model('perkara/new_pk','pk');
		$data = $this->pk->getPemohon($idpihak);
		if($data!=""){
			if($data->num_rows>0){
				foreach ($data->result() as $row) {
					$enc_pihak = $row->id;
					$nama = $row->nama;
					$alamat = $row->alamat;
					$pekerjaan = $row->pekerjaan;
				}
			}
			echo json_encode(array(
				'st'=>1,
				'pekerjaan'=>$pekerjaan,
				'nama'=>$nama,
				'alamat'=>$alamat,
				'enc_pihak'=>base64_encode($this->encrypt->encode($enc_pihak))
			));
			return;
		}
		echo json_encode(array('st'=>0,'msg'=>'Pihak Tidak Ditemukan.'));
		return;
	}
	function validateInput(){
		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		if(empty($_POST)){
			show_404();
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$enc_alur = $this->input->post('enc_alur',TRUE);
		$idalurperkara = $this->encrypt->decode(base64_decode($enc_alur));
		if(!is_numeric($idalurperkara) OR intval($idalurperkara)<0){
			echo json_encode(array('st'=>0,'msg'=>'Something Bad Happened, Please Refresh Your Browser.'));
			return;
		}
		$this->load->model('perkara/new_pk','pk');

		$this->form_validation->set_rules('tgl_pendaftaran', 'Tanggal Pendaftaran', 'trim|required|xss_clean|exact_length[10]');
		
		$diwakilkan = $this->input->post('diwakilkan',TRUE);
		if(($diwakilkan!=0 AND $diwakilkan!=1)){
			echo json_encode(array('st'=>0,'msg'=>'Something Bad Happened, Kolom Pihak Diwakilkan Tidak diketemukan.'));
			return;
		}elseif($diwakilkan==1){
			$this->form_validation->set_rules('nama_pemohon', 'Nama Pemohon', 'trim|required|xss_clean');
		}
		$this->form_validation->set_rules('no_perkara', 'Nomor Perkara', 'trim|required|xss_clean');

		$isAlreadyBanding = $this->pk->isPerkaraExist($idperkara);
		if($idalurperkara<100){
			$this->form_validation->set_rules('prodeo', 'Prodeo', 'trim|required|xss_clean');
			$prodeo = $this->input->post('prodeo',TRUE);
			if($prodeo==1){
				$this->form_validation->set_rules('jenis_prodeo', 'Jenis Prodeo', 'trim|required|xss_clean');
				$jenis_prodeo = $this->input->post('jenis_prodeo',TRUE);
				if($jenis_prodeo!=2 AND $jenis_prodeo!=3){
					echo json_encode(array('st'=>0,'msg'=>'Silahkan Pilih Jenis Prodeo'));
					return;
				}
				$id_pembiayaan = $jenis_prodeo;
			}else{
				$id_pembiayaan = 1;
			}
			$this->form_validation->set_rules('b_panjar', 'Biaya Panjar Perkara', 'trim|required|xss_clean');
			
			if($isAlreadyBanding==FALSE){
				$this->form_validation->set_rules('b_pendaftaran', 'Biaya Pendaftaran Perkara', 'trim|required|xss_clean');
				$this->form_validation->set_rules('b_atk', 'Biaya Alat Tulis Kantor', 'trim|required|xss_clean');
			}
		}
		
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$permohonanbanding = $this->pk->getPermohonanBandingPihak($idperkara);
			$validate = 1;
			$bandingIsExists = FALSE;
			if($permohonanbanding->num_rows>0){
				foreach ($permohonanbanding->result() as $row) {
					if(empty($row->permohonan_pk)){
						$validate = 0;
					}else{
						$bandingIsExists = TRUE;
					}
				}
			}else{
				$validate = 0;
			}

			if($validate==1){
				echo json_encode(array('st'=>0,'msg'=>'Semua Pihak Telah Mengajukan Kasasi.'));
				return;
			}
			$stpihak = $this->pk->getStatusPihak($idalurperkara);

			if($stpihak!=''){
				if($stpihak->num_rows>0){
					foreach ($stpihak->result() as $row) {
						$statuspihak[$row->pihak_ke] = $row->nama;
					}
				}else{
					echo json_encode(array('st'=>0,'msg'=>'Something Bad Happened, Please Refresh Your Browser.'));
					return;
				}
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Something Bad Happened, Please Refresh Your Browser.'));
				return;
			}


			$tglPendaftaran = $this->input->post('tgl_pendaftaran',TRUE);
			$tglPendaftaran = $this->tanggalhelper->convertToMysqlDate($tglPendaftaran);
			if($tglPendaftaran==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$selisih = $this->tanggalhelper->getSelisihHari($tglPendaftaran,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Permohonan Peninjauan Kembali Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tglPendaftaran);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pendaftaran Dihari Libur, Sabtu dan Minggu.'));
				return;
			}
			
			$tglcabut = '';
			$tglPutusanPN = '';
			$dataputusan = $this->pk->getTanggalPutusan($idperkara);
			if($dataputusan->num_rows>0){
				foreach ($dataputusan->result() as $row) {
					$tglPutusanPN = $row->tanggal_putusan;
					$tglcabut = $row->tanggal_cabut;
				}
			}
			if(!empty($tglcabut)){
				echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Dapat Dimohonkan PK Karena Telah Dicabut.'));
				return;
			}

			if(empty($tglPutusanPN)){
				echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Dapat Dimohonkan PK Karena Belum Putus.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusanPN,$tglPendaftaran);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pendaftaran Tidak Boleh Kurang Dari Tanggal Putusan'));
				return;
			}

			$nomorperkara = $this->pk->getNomorPerkara($idperkara);
			if(empty($nomorperkara)){
				echo json_encode(array('st'=>0,'msg'=>'Nomor Perkara Tidak Ditemukan.'));
				return;
			}
			$databanding = array(
				'perkara_id' => $idperkara,
				'jenis_pk' => 1,
				'alur_perkara_id' => $idalurperkara,
				'nomor_perkara_pn' => $nomorperkara,
				'putusan_pn' => $tglPutusanPN,
				'permohonan_pk' => $tglPendaftaran,
				'status_pk_id' => 510,
				'status_pk_text' => 'Permohonan PK',
				'diinput_oleh' => $this->session->userdata('username'),
				'diinput_tanggal' => date("Y-m-d h:i:s",time())
			);
			
			$idpemohon = $this->encrypt->decode(base64_decode($this->input->post('enc_pemohon',TRUE)));
			if($diwakilkan==1){
				if($idalurperkara>100){
					$pihakpertama = $this->input->post('para_pihak1',TRUE);
					if(!empty($pihakpertama)){
						echo json_encode(array('st'=>0,'msg'=>'Pihak Jaksa Tidak Dapat Diwakilkan.'));
						return;
					}
				}
				$diwakili = 'Y';
				$pemohon = $this->pk->getPemohon($idpemohon);
				if($pemohon!=''){
					if($pemohon->num_rows>0){
						foreach ($pemohon->result_array() as $row) {
							$datapemohon = $row;
						}
					}else{
						echo json_encode(array('st'=>0,'msg'=>'Data Pemohon Tidak Ditemukan.'));
						return;
					}
				}else{
					echo json_encode(array('st'=>0,'msg'=>'Data Pemohon Tidak Ditemukan.'));
					return;
				}
				$datapemohon['idpemohon'] = $idpemohon;
				$databanding['pemohon_pk'] = $datapemohon['nama'].'. Kuasa dari ';
			}else{
				$diwakili = 'T';
				$databanding['pemohon_pk'] = '';
			}

			if($isAlreadyBanding==TRUE){
				$update = $this->parseUpdate($databanding,1,$diwakilkan,$diwakili,$idalurperkara,$datapemohon);
				if($update!=TRUE){
					echo json_encode(array('st'=>0,'msg'=>'Database Error, Pendaftaran Perkara Tidak Berhasil'));
					return;
				}

				$update = $this->parseUpdate($databanding,2,$diwakilkan,$diwakili,$idalurperkara,$datapemohon);
				if($update!=TRUE){
					echo json_encode(array('st'=>0,'msg'=>'Database Error, Pendaftaran Perkara Tidak Berhasil'));
					return;
				}
				if($idalurperkara<100){
					$result = $this->pk->getPihak($idperkara,3);
					if(!empty($result)){
						if($result->num_rows>0){
							$update = $this->parseUpdate($databanding,3,$diwakilkan,$diwakili,$idalurperkara,$datapemohon);
							if($update!=TRUE){
								echo json_encode(array('st'=>0,'msg'=>'Database Errors, Pendaftaran Permohonan Tidak Berhasil'));
								return;
							}
						}
					}

					$result = $this->pk->getPihak($idperkara,4);
					if(!empty($result)){
						if($result->num_rows>0){
							$update = $this->parseUpdate($databanding,4,$diwakilkan,$diwakili,$idalurperkara,$datapemohon);
							if($update!=TRUE){
								echo json_encode(array('st'=>0,'msg'=>'Database Errors, Pendaftaran Permohonan Tidak Berhasil'));
								return;
							}
						}
					}
					
				}
			}else{
				$datapihak = '';
				$i=0;
				$listpihakpertama = $this->pk->getPihak($idperkara,1);
				if($listpihakpertama!=''){
					if($listpihakpertama->num_rows>0){
						$pihak_list = $this->input->post('para_pihak1',TRUE);
						if(empty($pihak_list)){
							$isterbanding=TRUE;
						}else{
							$isterbanding=FALSE;
							$databanding['pemohon_pk'] .= $statuspihak[1].':<br>';
						}
						
						$urt = 1;
						foreach ($listpihakpertama->result() as $row) {
							if($isterbanding==TRUE){
								if($row->status_pihak_id==3){
									$status_pihak_id = 4;
									$status_pihak_text = 'Termohon';
								}elseif($row->status_pihak_id==1){
									$status_pihak_id = 2;
									$status_pihak_text = 'Pemohon/Termohon';
								}elseif($row->status_pihak_id==5){
									$status_pihak_id = 5;
									$status_pihak_text = 'Termohon/Pemohon';
								}elseif(empty($row->status_pihak_id)){
									$status_pihak_id = 4;
									$status_pihak_text = 'Termohon';
								}else{
									$status_pihak_id = 4;
									$status_pihak_text = 'Termohon';
								}
								$pihak = array(
										'perkara_id' => $idperkara,
										'alur_perkara_id' => $idalurperkara,
										'status_pihak_id' => $status_pihak_id,
										'status_pihak_text' => $status_pihak_text,
										'pihak_asal' => 1,
										'pihak_asal_text' => $statuspihak[1],
										'pihak_id' => $row->pihak_id,
										'pihak_nama' => $row->nama,
										'pihak_diwakili' => 'T',
										'urutan_pk' => $urt
								);
								if($bandingIsExists == FALSE){
									$pihak['diinput_oleh'] = $this->session->userdata('username');
									$pihak['diinput_tanggal'] = date("Y-m-d h:i:s",time());
								}else{
									$pihak['diperbaharui_oleh'] = $this->session->userdata('username');
									$pihak['diperbaharui_tanggal'] = date("Y-m-d h:i:s",time());
								}
								$datapihak[$i] = $pihak;
								$i++;
								$urt++;
							}else{
								$databanding['pihak_pemohon_pk'] = 1;
								$isthere = $this->parsePihak($pihak_list,$row->pihak_id,$idalurperkara);
								if($isthere==TRUE){
									if($row->status_pihak_id==3){
										$status_pihak_id = 1;
										$status_pihak_text = 'Pemohon';
									}elseif($row->status_pihak_id==4){
										$status_pihak_id = 5;
										$status_pihak_text = 'Termohon/Pemohon';
									}elseif($row->status_pihak_id==5){
										$status_pihak_id = 5;
										$status_pihak_text = 'Termohon/Pemohon';
									}elseif(empty($row->status_pihak_id)){
										$status_pihak_id = 1;
										$status_pihak_text = 'Pemohon';
									}else{
										$status_pihak_id = 1;
										$status_pihak_text = 'Pemohon';
									}
									if($idalurperkara<100){
										$urutan = $this->input->post('pihak_'.$row->pihak_id,TRUE);
									}else{
										$urutan = 1;
									}
									
									$pihak = array(
											'perkara_id' => $idperkara,
											'alur_perkara_id' => $idalurperkara,
											'status_pihak_id' => $status_pihak_id,
											'status_pihak_text' => $status_pihak_text,
											'urutan_pk' => $urutan,
											'permohonan_pk' => $tglPendaftaran,
											'pihak_asal' => 1,
											'pihak_asal_text' => $statuspihak[1],
											'pihak_id' => $row->pihak_id,
											'pihak_nama' => $row->nama,
											'pihak_diwakili' => $diwakili
									);
									if($bandingIsExists == FALSE){
										$pihak['diinput_oleh'] = $this->session->userdata('username');
										$pihak['diinput_tanggal'] = date("Y-m-d h:i:s",time());
									}else{
										$pihak['diperbaharui_oleh'] = $this->session->userdata('username');
										$pihak['diperbaharui_tanggal'] = date("Y-m-d h:i:s",time());
									}
									if($diwakilkan==1){
										$pihak['pemohon_id'] = $idpemohon;
										$pihak['pemohon_nama'] = $datapemohon['nama'];
										$pihak['pemohon_alamat'] = $datapemohon['alamat'];
										$pihak['pemohon_pekerjaan'] = $datapemohon['pekerjaan'];
										$tglsuratkuasa = $this->input->post('tgl_surat_kuasa',TRUE);
										if(!empty($tglsuratkuasa)){
											$pihak['pemohon_tanggal_surat'] = $this->tanggalhelper->convertToMysqlDate($tglsuratkuasa);
										}
										$pihak['pemohon_nomor_surat'] = $this->input->post('no_kuasa',TRUE);
										$databanding['pemohon_pk'] .= $row->nama.'<br>';
									}elseif($diwakilkan==0){
										$pihak['pemohon_id'] = $row->pihak_id;
										$pihak['pemohon_nama'] = $row->nama;
										$pihak['pemohon_alamat'] = $row->alamat;
										$databanding['pemohon_pk'] .= $row->nama.'<br>';
									}
									$datapihak[$i] = $pihak;
									$i++;
								}elseif($idalurperkara<100){
									if(empty($row->status_pihak_id)){
										$status_pihak_id = 3;
										$status_pihak_text = 'Turut Termohon';
									}else{
										$status_pihak_id = $row->status_pihak_id;
										$status_pihak_text = $row->status_pihak_text;
									}
									$pihak = array(
											'perkara_id' => $idperkara,
											'alur_perkara_id' => $idalurperkara,
											'status_pihak_id' => $status_pihak_id,
											'status_pihak_text' => $status_pihak_text,
											'pihak_asal' => 1,
											'pihak_asal_text' => $statuspihak[2],
											'pihak_id' => $row->pihak_id,
											'pihak_nama' => $row->nama,
											'pihak_diwakili' => 'T',
											'urutan_pk' => $urt,
											'diinput_oleh' => $this->session->userdata('username'),
											'diinput_tanggal' => date("Y-m-d h:i:s",time())
									);
									$datapihak[$i] = $pihak;
									$i++;
									$urt++;
								}
							}
						}
					}
				}
				$listpihakkedua = $this->pk->getPihak($idperkara,2);
				if($listpihakkedua!=''){
					if($listpihakkedua->num_rows>0){
						$pihak_list = $this->input->post('para_pihak2',TRUE);
						if(empty($pihak_list)){
							$isterbanding=TRUE;
						}else{
							$isterbanding=FALSE;
							$databanding['pemohon_pk'] .= $statuspihak[2].': ';
						}
						$urt = 1;
						foreach ($listpihakkedua->result() as $row) {
							if($isterbanding==TRUE){
								if($row->status_pihak_id==3){
									$status_pihak_id = 4;
									$status_pihak_text = 'Termohon';
								}elseif($row->status_pihak_id==1){
									$status_pihak_id = 2;
									$status_pihak_text = 'Pemohon/Termohon';
								}elseif($row->status_pihak_id==5){
									$status_pihak_id = 5;
									$status_pihak_text = 'Termohon/Pemohon';
								}elseif(empty($row->status_pihak_id)){
									$status_pihak_id = 4;
									$status_pihak_text = 'Termohon';
								}else{
									$status_pihak_id = 4;
									$status_pihak_text = 'Termohon';
								}
								$pihak = array(
										'perkara_id' => $idperkara,
										'alur_perkara_id' => $idalurperkara,
										'status_pihak_id' => $status_pihak_id,
										'status_pihak_text' => $status_pihak_text,
										'pihak_asal' => 2,
										'pihak_asal_text' => $statuspihak[2],
										'pihak_id' => $row->pihak_id,
										'pihak_nama' => $row->nama,
										'pihak_diwakili' => 'T',
										'urutan_pk' => $urt
								);
								if($bandingIsExists == FALSE){
									$pihak['diinput_oleh'] = $this->session->userdata('username');
									$pihak['diinput_tanggal'] = date("Y-m-d h:i:s",time());
								}else{
									$pihak['diperbaharui_oleh'] = $this->session->userdata('username');
									$pihak['diperbaharui_tanggal'] = date("Y-m-d h:i:s",time());
								}
								$datapihak[$i] = $pihak;
								$i++;
								$urt++;
							}else{
								$databanding['pihak_pemohon_pk'] = 2;
								$isthere = $this->parsePihak($pihak_list,$row->pihak_id,$idalurperkara);
								if($isthere==TRUE){
									if($row->status_pihak_id==3){
										$status_pihak_id = 1;
										$status_pihak_text = 'Pemohon';
									}elseif($row->status_pihak_id==4){
										$status_pihak_id = 5;
										$status_pihak_text = 'Termohon/Pemohon';
									}elseif($row->status_pihak_id==5){
										$status_pihak_id = 5;
										$status_pihak_text = 'Termohon/Pemohon';
									}elseif(empty($row->status_pihak_id)){
										$status_pihak_id = 1;
										$status_pihak_text = 'Pemohon';
									}else{
										$status_pihak_id = 1;
										$status_pihak_text = 'Pemohon';
									}
									if($idalurperkara<100){
										$urutan = $this->input->post('pihak_'.$row->pihak_id,TRUE);
									}else{
										$urutan = 1;
									}
									$pihak = array(
											'perkara_id' => $idperkara,
											'alur_perkara_id' => $idalurperkara,
											'status_pihak_id' => $status_pihak_id,
											'status_pihak_text' => $status_pihak_text,
											'urutan_pk' => $urutan,
											'permohonan_pk' => $tglPendaftaran,
											'pihak_asal' => 2,
											'pihak_asal_text' => $statuspihak[2],
											'pihak_id' => $row->pihak_id,
											'pihak_nama' => $row->nama,
											'pihak_diwakili' => $diwakili,
											'diinput_oleh' => $this->session->userdata('username'),
											'diinput_tanggal' => date("Y-m-d h:i:s",time())
											
									);
									if($diwakilkan==1){
										$idpemohon = $this->encrypt->decode(base64_decode($this->input->post('enc_pemohon',TRUE)));
										$pihak['pemohon_id'] = $idpemohon;
										$pihak['pemohon_nama'] = $datapemohon['nama'];
										$pihak['pemohon_alamat'] = $datapemohon['alamat'];
										$pihak['pemohon_pekerjaan'] = $datapemohon['pekerjaan'];
										$tglsuratkuasa = $this->input->post('tgl_surat_kuasa',TRUE);
										if(!empty($tglsuratkuasa)){
											$pihak['pemohon_tanggal_surat'] = $this->tanggalhelper->convertToMysqlDate($tglsuratkuasa);
										}
										$pihak['pemohon_nomor_surat'] = $this->input->post('no_kuasa',TRUE);
										$databanding['pemohon_pk'] .= $row->nama.'<br>';
									}elseif($diwakilkan==0){
										$pihak['pemohon_id'] = $row->pihak_id;
										$pihak['pemohon_nama'] = $row->nama;
										$pihak['pemohon_alamat'] = $row->alamat;									
										$databanding['pemohon_pk'] .= $row->nama.'<br>';
									}
									$datapihak[$i] = $pihak;
									$i++;
								}elseif($idalurperkara<100){
									if(empty($row->status_pihak_id)){
										$status_pihak_id = 3;
										$status_pihak_text = 'Turut Termohon';
									}else{
										$status_pihak_id = $row->status_pihak_id;
										$status_pihak_text = $row->status_pihak_text;
									}
									$pihak = array(
											'perkara_id' => $idperkara,
											'alur_perkara_id' => $idalurperkara,
											'status_pihak_id' => $status_pihak_id,
											'status_pihak_text' => $status_pihak_text,
											'pihak_asal' => 2,
											'pihak_asal_text' => $statuspihak[2],
											'pihak_id' => $row->pihak_id,
											'pihak_nama' => $row->nama,
											'pihak_diwakili' => 'T',
											'urutan_pk' => $urt,
											'diinput_oleh' => $this->session->userdata('username'),
											'diinput_tanggal' => date("Y-m-d h:i:s",time())
									);
									$datapihak[$i] = $pihak;
									$i++;
									$urt++;
								}
							}
						}
					}
				}

				if($idalurperkara<100){
					$listpihakketiga = $this->pk->getPihak($idperkara,3);
					if($listpihakketiga!=''){
						if($listpihakketiga->num_rows>0){
							$pihak_list = $this->input->post('para_pihak3',TRUE);
							if(empty($pihak_list)){
								$isterbanding=TRUE;
							}else{
								$isterbanding=FALSE;
								$databanding['pemohon_pk'] .= $statuspihak[3].': ';
							}
							$urt = 1;
							foreach ($listpihakketiga->result() as $row) {
								if($isterbanding==TRUE){
									if($row->status_pihak_id==3){
										$status_pihak_id = 4;
										$status_pihak_text = 'Termohon';
									}elseif($row->status_pihak_id==1){
										$status_pihak_id = 2;
										$status_pihak_text = 'Pemohon/Termohon';
									}elseif($row->status_pihak_id==5){
										$status_pihak_id = 5;
										$status_pihak_text = 'Termohon/Pemohon';
									}elseif(empty($row->status_pihak_id)){
										$status_pihak_id = 4;
										$status_pihak_text = 'Termohon';
									}else{
										$status_pihak_id = 4;
										$status_pihak_text = 'Termohon';
									}
									$pihak = array(
											'perkara_id' => $idperkara,
											'alur_perkara_id' => $idalurperkara,
											'status_pihak_id' => $status_pihak_id,
											'status_pihak_text' => $status_pihak_text,
											'pihak_asal' => 3,
											'pihak_asal_text' => $statuspihak[3],
											'pihak_id' => $row->pihak_id,
											'pihak_nama' => $row->nama,
											'pihak_diwakili' => 'T',
											'urutan_pk' => $urt
									);
									if($bandingIsExists == FALSE){
										$pihak['diinput_oleh'] = $this->session->userdata('username');
										$pihak['diinput_tanggal'] = date("Y-m-d h:i:s",time());
									}else{
										$pihak['diperbaharui_oleh'] = $this->session->userdata('username');
										$pihak['diperbaharui_tanggal'] = date("Y-m-d h:i:s",time());
									}
									$datapihak[$i] = $pihak;
									$i++;
									$urt++;
								}else{
									$databanding['pihak_pemohon_pk'] = 3;
									$isthere = $this->parsePihak($pihak_list,$row->pihak_id,$idalurperkara);
									if($isthere==TRUE){
										if($row->status_pihak_id==3){
											$status_pihak_id = 1;
											$status_pihak_text = 'Pemohon';
										}elseif($row->status_pihak_id==4){
											$status_pihak_id = 5;
											$status_pihak_text = 'Termohon/Pemohon';
										}elseif($row->status_pihak_id==5){
											$status_pihak_id = 5;
											$status_pihak_text = 'Termohon/Pemohon';
										}elseif(empty($row->status_pihak_id)){
											$status_pihak_id = 1;
											$status_pihak_text = 'Pemohon';
										}else{
											$status_pihak_id = 1;
											$status_pihak_text = 'Pemohon';
										}
										if($idalurperkara<100){
											$urutan = $this->input->post('pihak_'.$row->pihak_id,TRUE);
										}else{
											$urutan = 1;
										}
										$pihak = array(
												'perkara_id' => $idperkara,
												'alur_perkara_id' => $idalurperkara,
												'status_pihak_id' => $status_pihak_id,
												'status_pihak_text' => $status_pihak_text,
												'urutan_pk' => $urutan,
												'permohonan_pk' => $tglPendaftaran,
												'pihak_asal' => 3,
												'pihak_asal_text' => $statuspihak[3],
												'pihak_id' => $row->pihak_id,
												'pihak_nama' => $row->nama,
												'pihak_diwakili' => $diwakili,
												'diinput_oleh' => $this->session->userdata('username'),
												'diinput_tanggal' => date("Y-m-d h:i:s",time())
												
										);
										if($diwakilkan==1){
											$idpemohon = $this->encrypt->decode(base64_decode($this->input->post('enc_pemohon',TRUE)));
											$pihak['pemohon_id'] = $idpemohon;
											$pihak['pemohon_nama'] = $datapemohon['nama'];
											$pihak['pemohon_alamat'] = $datapemohon['alamat'];
											$pihak['pemohon_pekerjaan'] = $datapemohon['pekerjaan'];
											$tglsuratkuasa = $this->input->post('tgl_surat_kuasa',TRUE);
											if(!empty($tglsuratkuasa)){
												$pihak['pemohon_tanggal_surat'] = $this->tanggalhelper->convertToMysqlDate($tglsuratkuasa);
											}
											$pihak['pemohon_nomor_surat'] = $this->input->post('no_kuasa',TRUE);
											$databanding['pemohon_pk'] .= $row->nama.'<br>';
										}elseif($diwakilkan==0){
											$pihak['pemohon_id'] = $row->pihak_id;
											$pihak['pemohon_nama'] = $row->nama;
											$pihak['pemohon_alamat'] = $row->alamat;									
											$databanding['pemohon_pk'] .= $row->nama.'<br>';
										}
										$datapihak[$i] = $pihak;
										$i++;
									}elseif($idalurperkara<100){
										if(empty($row->status_pihak_id)){
											$status_pihak_id = 3;
											$status_pihak_text = 'Turut Termohon';
										}else{
											$status_pihak_id = $row->status_pihak_id;
											$status_pihak_text = $row->status_pihak_text;
										}
										$pihak = array(
												'perkara_id' => $idperkara,
												'alur_perkara_id' => $idalurperkara,
												'status_pihak_id' => $status_pihak_id,
												'status_pihak_text' => $status_pihak_text,
												'pihak_asal' => 3,
												'pihak_asal_text' => $statuspihak[3],
												'pihak_id' => $row->pihak_id,
												'pihak_nama' => $row->nama,
												'pihak_diwakili' => 'T',
												'urutan_pk' => $urt,
												'diinput_oleh' => $this->session->userdata('username'),
												'diinput_tanggal' => date("Y-m-d h:i:s",time())
										);
										$datapihak[$i] = $pihak;
										$i++;
										$urt++;
									}
								}
							}
						}
					}
					$listpihakkeempat = $this->pk->getPihak($idperkara,4);
					if($listpihakkeempat!=''){
						if($listpihakkeempat->num_rows>0){
							$pihak_list = $this->input->post('para_pihak4',TRUE);
							if(empty($pihak_list)){
								$isterbanding=TRUE;
							}else{
								$isterbanding=FALSE;
								$databanding['pemohon_pk'] .= $statuspihak[4].': ';
							}
							$urt = 1;
							foreach ($listpihakkeempat->result() as $row) {
								if($isterbanding==TRUE){
									if($row->status_pihak_id==3){
										$status_pihak_id = 4;
										$status_pihak_text = 'Termohon';
									}elseif($row->status_pihak_id==1){
										$status_pihak_id = 2;
										$status_pihak_text = 'Pemohon/Termohon';
									}elseif($row->status_pihak_id==5){
										$status_pihak_id = 5;
										$status_pihak_text = 'Termohon/Pemohon';
									}elseif(empty($row->status_pihak_id)){
										$status_pihak_id = 4;
										$status_pihak_text = 'Termohon';
									}else{
										$status_pihak_id = 4;
										$status_pihak_text = 'Termohon';
									}
									$pihak = array(
											'perkara_id' => $idperkara,
											'alur_perkara_id' => $idalurperkara,
											'status_pihak_id' => $status_pihak_id,
											'status_pihak_text' => $status_pihak_text,
											'pihak_asal' => 4,
											'pihak_asal_text' => $statuspihak[4],
											'pihak_id' => $row->pihak_id,
											'pihak_nama' => $row->nama,
											'pihak_diwakili' => 'T',
											'urutan_pk' => $urt
									);
									if($bandingIsExists == FALSE){
										$pihak['diinput_oleh'] = $this->session->userdata('username');
										$pihak['diinput_tanggal'] = date("Y-m-d h:i:s",time());
									}else{
										$pihak['diperbaharui_oleh'] = $this->session->userdata('username');
										$pihak['diperbaharui_tanggal'] = date("Y-m-d h:i:s",time());
									}
									$datapihak[$i] = $pihak;
									$i++;
									$urt++;
								}else{
									$databanding['pihak_pemohon_pk'] = 4;
									$isthere = $this->parsePihak($pihak_list,$row->pihak_id,$idalurperkara);
									if($isthere==TRUE){
										if($row->status_pihak_id==3){
											$status_pihak_id = 1;
											$status_pihak_text = 'Pemohon';
										}elseif($row->status_pihak_id==4){
											$status_pihak_id = 5;
											$status_pihak_text = 'Termohon/Pemohon';
										}elseif($row->status_pihak_id==5){
											$status_pihak_id = 5;
											$status_pihak_text = 'Termohon/Pemohon';
										}elseif(empty($row->status_pihak_id)){
											$status_pihak_id = 1;
											$status_pihak_text = 'Pemohon';
										}else{
											$status_pihak_id = 1;
											$status_pihak_text = 'Pemohon';
										}
										if($idalurperkara<100){
											$urutan = $this->input->post('pihak_'.$row->pihak_id,TRUE);
										}else{
											$urutan = 1;
										}
										$pihak = array(
												'perkara_id' => $idperkara,
												'alur_perkara_id' => $idalurperkara,
												'status_pihak_id' => $status_pihak_id,
												'status_pihak_text' => $status_pihak_text,
												'urutan_pk' => $urutan,
												'permohonan_pk' => $tglPendaftaran,
												'pihak_asal' => 4,
												'pihak_asal_text' => $statuspihak[4],
												'pihak_id' => $row->pihak_id,
												'pihak_nama' => $row->nama,
												'pihak_diwakili' => $diwakili,
												'diinput_oleh' => $this->session->userdata('username'),
												'diinput_tanggal' => date("Y-m-d h:i:s",time())
												
										);
										if($diwakilkan==1){
											$idpemohon = $this->encrypt->decode(base64_decode($this->input->post('enc_pemohon',TRUE)));
											$pihak['pemohon_id'] = $idpemohon;
											$pihak['pemohon_nama'] = $datapemohon['nama'];
											$pihak['pemohon_alamat'] = $datapemohon['alamat'];
											$pihak['pemohon_pekerjaan'] = $datapemohon['pekerjaan'];
											$tglsuratkuasa = $this->input->post('tgl_surat_kuasa',TRUE);
											if(!empty($tglsuratkuasa)){
												$pihak['pemohon_tanggal_surat'] = $this->tanggalhelper->convertToMysqlDate($tglsuratkuasa);
											}
											$pihak['pemohon_nomor_surat'] = $this->input->post('no_kuasa',TRUE);
											$databanding['pemohon_pk'] .= $row->nama.'<br>';
										}elseif($diwakilkan==0){
											$pihak['pemohon_id'] = $row->pihak_id;
											$pihak['pemohon_nama'] = $row->nama;
											$pihak['pemohon_alamat'] = $row->alamat;									
											$databanding['pemohon_pk'] .= $row->nama.'<br>';
										}
										$datapihak[$i] = $pihak;
										$i++;
									}elseif($idalurperkara<100){
										if(empty($row->status_pihak_id)){
											$status_pihak_id = 3;
											$status_pihak_text = 'Turut Termohon';
										}else{
											$status_pihak_id = $row->status_pihak_id;
											$status_pihak_text = $row->status_pihak_text;
										}
										$pihak = array(
												'perkara_id' => $idperkara,
												'alur_perkara_id' => $idalurperkara,
												'status_pihak_id' => $status_pihak_id,
												'status_pihak_text' => $status_pihak_text,
												'pihak_asal' => 4,
												'pihak_asal_text' => $statuspihak[4],
												'pihak_id' => $row->pihak_id,
												'pihak_nama' => $row->nama,
												'pihak_diwakili' => 'T',
												'urutan_pk' => $urt,
												'diinput_oleh' => $this->session->userdata('username'),
												'diinput_tanggal' => date("Y-m-d h:i:s",time())
										);
										$datapihak[$i] = $pihak;
										$i++;
										$urt++;
									}
								}
							}
						}
					}
				}
			}

			$data_keuangan_perkara = '';
			if($idalurperkara<100){
				$no_ref = $this->input->post('no_ref',TRUE);
				$b_panjar = str_replace('.','',$this->input->post('b_panjar',TRUE));
				$b_pendaftaran = str_replace('.','',$this->input->post('b_pendaftaran',TRUE));
				$b_atk = str_replace('.','',$this->input->post('b_atk',TRUE));
				if($jenis_prodeo==1 OR $jenis_prodeo==2){#didik
					if($b_panjar<($b_pendaftaran+$b_atk)){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Biaya Panjar Tidak Boleh Kurang dari Biaya Pendaftaran ditambah Biaya ATK'));
						return;
					}elseif ($b_panjar==0) {
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Biaya Panjar Tidak Boleh Kosong'));
						return;
					}
				}
				if($isAlreadyBanding==FALSE){
					$data_keuangan_perkara = array(
						array(
							'id_pembiayaan' => $id_pembiayaan,
							'perkara_id' => $idperkara,
							'tahapan_id' => 40,
							'kategori_id' => 1,
							'jenis_biaya_id' => 6,
							'urutan' => 1,
							'jenis_transaksi' => 1,
							'tanggal_transaksi' => $tglPendaftaran,
							'uraian' => 'Panjar Biaya Perkara PK',
							'jumlah' => $b_panjar,
							'diinput_oleh' => $this->session->userdata('username'),
							'diinput_tanggal' => date("Y-m-d h:i:s",time())
						),
						array(
							'id_pembiayaan' => $id_pembiayaan,
							'perkara_id' => $idperkara,
							'tahapan_id' => 40,
							'kategori_id' => 11,
							'jenis_biaya_id' => 64,
							'urutan' => 2,
							'jenis_transaksi' => -1,
							'tanggal_transaksi' => $tglPendaftaran,
							'uraian' => 'Biaya Pendaftaran/PNBP',
							'jumlah' => $b_pendaftaran,
							'diinput_oleh' => $this->session->userdata('username'),
							'diinput_tanggal' => date("Y-m-d h:i:s",time())
						),
						array(
							'id_pembiayaan' => $id_pembiayaan,
							'perkara_id' => $idperkara,
							'tahapan_id' => 40,
							'kategori_id' => 12,
							'jenis_biaya_id' => 200,
							'urutan' => 3,
							'jenis_transaksi' => -1,
							'tanggal_transaksi' => $tglPendaftaran,
							'uraian' => 'Biaya Pemberkasan/ATK',
							'jumlah' => $b_atk,
							'diinput_oleh' => $this->session->userdata('username'),
							'diinput_tanggal' => date("Y-m-d h:i:s",time())
						)
					);
				}else{
					$data_keuangan_perkara = array(
					array(
						'id_pembiayaan' => $id_pembiayaan,
						'perkara_id' => $idperkara,
						'tahapan_id' => 40,
						'kategori_id' => 1,
						'jenis_biaya_id' => 6,
						'urutan' => 1,
						'jenis_transaksi' => 1,
						'tanggal_transaksi' => $tglPendaftaran,
						'uraian' => 'Panjar Biaya Perkara PK',
						'jumlah' => $b_panjar,
						'diinput_oleh' => $this->session->userdata('username'),
						'diinput_tanggal' => date("Y-m-d h:i:s",time())
					));
				}
				
			}
			$result = TRUE;
			if($isAlreadyBanding==TRUE AND $idalurperkara<100){
				$result = $this->pk->addDataKeuangan($data_keuangan_perkara,$nomorperkara);
			}elseif($isAlreadyBanding==FALSE){
				$result = $this->pk->add_data($databanding,$data_keuangan_perkara,$datapihak);
				$this->pk->updatePerkaraStatus($idperkara);
			}
			if($result){
				echo json_encode(array('st'=>1,'msg'=>'Berhasil Disimpan'));
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Database Error, Pendaftaran Perkara Tidak Berhasil'));
			}	
		}
	}

	function parsePihak($listpihak,$idpihak){
		foreach ($listpihak as $key) {
			$idpihakpemohon = $this->encrypt->decode(base64_decode($key));
			if($idpihak==$idpihakpemohon){
				return TRUE;
			}
		}
		return FALSE;
	}

	function parsePihakPerwakilan($listpihak){
		foreach ($listpihak as $key) {
			$idpihakpemohon = $this->encrypt->decode(base64_decode($key));
			$urutan = $this->input->post('pihak_'.$idpihakpemohon,TRUE);
			if($urutan==1){
				return $idpihakpemohon;
			}
		}
		return '';
	}

	function parseUpdate($data,$pihakke,$diwakilkan,$diwakili,$idalurperkara,$datapemohon){
		$this->load->model('perkara/new_pk','pk');
		$datapihak = '';
		$i=0;
		$insert = FALSE;
		$listpihakpertama = $this->pk->getPihak($data['perkara_id'],$pihakke);
		if($listpihakpertama!=''){
			if($listpihakpertama->num_rows>0){
				$pihak_list = $this->input->post('para_pihak'.$pihakke,TRUE);
				if(empty($pihak_list)){
					$isterbanding=TRUE;
				}else{
					$isterbanding=FALSE;
				}
				$urt = 1;
				foreach ($listpihakpertama->result() as $row) {
					if($isterbanding==TRUE){
						if($row->status_pihak_id==3){
							$status_pihak_id = 4;
							$status_pihak_text = 'Termohon';
						}elseif($row->status_pihak_id==1){
							$status_pihak_id = 2;
							$status_pihak_text = 'Pemohon/Termohon';
						}elseif($row->status_pihak_id==5){
							$status_pihak_id = 5;
							$status_pihak_text = 'Termohon/Pemohon';
						}elseif(empty($row->status_pihak_id)){
							$status_pihak_id = 4;
							$status_pihak_text = 'Termohon';
						}else{
							$status_pihak_id = 4;
							$status_pihak_text = 'Termohon';
						}

						$pihak = array(
							'perkara_id' => $data['perkara_id'],
							'pihak_id' =>$row->pihak_id,
							'pihak' => array(
								'status_pihak_id' => $status_pihak_id,
								'status_pihak_text' => $status_pihak_text,
								'diperbaharui_oleh' => $this->session->userdata('username'),
								'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
							)
						);
						
						$datapihak[$i] = $pihak;
						if($idalurperkara>100 AND $pihakke==2 AND empty($row->status_pihak_id)){
							$insert = TRUE;
							$datatambah = array(
								'perkara_id' => $data['perkara_id'],
								'pihak_id' =>$row->pihak_id,
								'status_pihak_id' => $status_pihak_id,
								'status_pihak_text' => $status_pihak_text,
								'pihak_asal' => 2,
								'pihak_asal_text' => 'Terdakwa',
								'pihak_id' => $row->pihak_id,
								'pihak_nama' => $row->nama,
								'diperbaharui_oleh' => $this->session->userdata('username'),
								'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
							);
							$datapihaktambah[$i] = $datatambah;
						}
						$i++;
					}else{
						$isthere = $this->parsePihak($pihak_list,$row->pihak_id);
						if($isthere==TRUE){
							if($row->status_pihak_id==3){
								$status_pihak_id = 1;
								$status_pihak_text = 'Pemohon';
							}elseif($row->status_pihak_id==4){
								$status_pihak_id = 5;
								$status_pihak_text = 'Termohon/Pemohon';
							}elseif($row->status_pihak_id==5){
								$status_pihak_id = 5;
								$status_pihak_text = 'Termohon/Pemohon';
							}elseif(empty($row->status_pihak_id)){
								$status_pihak_id = 1;
								$status_pihak_text = 'Pemohon';
							}else{
								$status_pihak_id = 1;
								$status_pihak_text = 'Pemohon';
							}
							$urutan = $this->input->post('pihak_'.$row->pihak_id,TRUE);
							
							if($diwakilkan==1){
								$tmp['pemohon_id'] = $datapemohon['idpemohon'];
								$tmp['pemohon_nama'] = $datapemohon['nama'];
								$tmp['pemohon_alamat'] = $datapemohon['alamat'];
								$tmp['pemohon_pekerjaan'] = $datapemohon['pekerjaan'];
								$tglsuratkuasa = $this->input->post('tgl_surat_kuasa',TRUE);
								if(!empty($tglsuratkuasa)){
									$tmp['pemohon_tanggal_surat'] = $this->tanggalhelper->convertToMysqlDate($tglsuratkuasa);
								}
								$tmp['pemohon_nomor_surat'] = $this->input->post('no_kuasa',TRUE);
								$data['pemohon_pk'] .= $row->nama.'<br>';
							}elseif($diwakilkan==0){
								$tmp['pemohon_id'] = $row->pihak_id;
								$tmp['pemohon_nama'] = $row->nama;
								$tmp['pemohon_alamat'] = $row->alamat;
								$data['pemohon_pk'] .= $row->nama.'<br>';
								$tmp['pemohon_pekerjaan'] = '';
							}
							$pihak = array(
								'perkara_id' => $data['perkara_id'],
								'pihak_id' =>$row->pihak_id,
								'pihak' => array(
									'status_pihak_id' => $status_pihak_id,
									'status_pihak_text' => $status_pihak_text,
									'pihak_diwakili' => $diwakili,
									'urutan_pk' => $urutan,
									'permohonan_pk' => $data['permohonan_pk'],
									'pemohon_id' => $tmp['pemohon_id'],
									'pemohon_nama' => $tmp['pemohon_nama'],
									'pemohon_alamat' => $tmp['pemohon_alamat'],
									'pemohon_pekerjaan' => $tmp['pemohon_pekerjaan'],
									'diperbaharui_oleh' => $this->session->userdata('username'),
									'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
								)
							);
							$datapihak[$i] = $pihak;

							if($idalurperkara>100 AND $pihakke==2 AND empty($row->status_pihak_id)){
								$insert = TRUE;
								$datatambah = array(
									'perkara_id' => $data['perkara_id'],
									'pihak_id' =>$row->pihak_id,
									'status_pihak_id' => $status_pihak_id,
									'status_pihak_text' => $status_pihak_text,
									'pihak_asal' => 2,
									'pihak_asal_text' => 'Terdakwa',
									'pihak_id' => $row->pihak_id,
									'pihak_nama' => $row->nama,
									'diperbaharui_oleh' => $this->session->userdata('username'),
									'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
								);
								$datapihaktambah[$i] = $datatambah;
							}
							$i++;
						}else{
							if(empty($row->status_pihak_id)){
								$status_pihak_id = 3;
								$status_pihak_text = 'Turut Termohon';
							}else{
								$status_pihak_id = $row->status_pihak_id;
								$status_pihak_text = $row->status_pihak_text;
							}
							$pihak = array(
								'status_pihak_id' => $status_pihak_id,
								'status_pihak_text' => $status_pihak_text,
								'diperbaharui_oleh' => $this->session->userdata('username'),
								'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
							);
							$pihak = array(
								'perkara_id' => $data['perkara_id'],
								'pihak_id' =>$row->pihak_id,
								'pihak' => array(
									'status_pihak_id' => $status_pihak_id,
									'status_pihak_text' => $status_pihak_text,
									'diperbaharui_oleh' => $this->session->userdata('username'),
									'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
								)
							);
							$datapihak[$i] = $pihak;
							$i++;
							$urt++;
						}
					}
				}
				if($insert==TRUE){
					$this->pk->insertNewData($datapihaktambah);
				}
				return $this->pk->update_data($datapihak);
			}
		}
		return FALSE;
	}
}