<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

#07-10-2015
class Info_perkara_tun extends CI_Model{
	function getInfoPerkara($idperkara){
		try {
			
			return $this->db->query('SELECT nomor_perkara,jenis_perkara_id,jenis_perkara_nama,alur_perkara_id,
			tanggal_pendaftaran,tanggal_putusan,tanggal_minutasi,
			pihak1_text,pihak2_text,nomor_urut_register,tanggal_surat,nomor_surat,pihak_dipublikasikan,
			is_mediasi,keputusan_mediasi,petitum,nilai_sengketa, petitum_dok,prodeo, tanggal_penuntutan, tanggal_putusan_sela, dakwaan, dakwaan_dok,
			tahapan_terakhir_id, tahapan_terakhir_text,proses_terakhir_id, proses_terakhir_text, tanggal_bht
				FROM v_perkara 
				WHERE perkara_id='.$idperkara.';');
			
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	#09-10-2015
	function getDataPemeriksaanPersiapan($idperkara){
		try{
			$this->db->where('perkara_id',$idperkara);
			return $this->db->get('perkara_persiapan');
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	#29-10-2015 didik
	function getDataAcaraSidang($idperkara){
		try{
			$this->db->where('perkara_id',$idperkara);
			$this->db->where('jenis_acara',1);
			$this->db->select('jenis_acara');
			$result = $this->db->get('perkara_penetapan');
			if($result->num_rows>0){
				return 1;
			}else{
				return 0;
			}
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}


	function getInfoPihakPertama($idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->select('id,pihak_id,nama,alamat,urutan');
			$this->db->order_by('urutan', "ASC");
			return $this->db->get('perkara_pihak1');
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getKlasifikasiPerkara($idalurperkara){
		if(empty($idalurperkara)) return '';
		if($idalurperkara<0) return '';
		try {
			$query = $this->db->query("SELECT alur_perkara_id, jenis_perkara_id AS id,nama_lengkap AS nama
				FROM jenis_alur_perkara AS j, jenis_perkara AS p
				WHERE j.jenis_perkara_id = p.id AND j.alur_perkara_id = ".$idalurperkara."
				ORDER BY nama_lengkap ASC");
			return $query;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getJenisPerkaraNama($id){
		if(empty($id)) return '';
		try {
			$this->db->where('id',$id);
			$this->db->select('kode,nama,nama_lengkap');
			return $this->db->get('jenis_perkara');
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getStatusPihak($idalurperkara){
		try {
			$this->db->where('tahapan_id',10);
			$this->db->where('aktif','Y');
			$this->db->where('alur_perkara_id',$idalurperkara);
			$this->db->select('pihak_ke,nama');
			return $this->db->get('status_pihak');
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	
	function getInfoPengacara($idperkara,$pihakke,$idalurperkara){
		try {
			if(!is_numeric($idperkara) OR !is_numeric($pihakke)){
				return "";
			}

			if($idalurperkara<100)
				$kuasa = 'Kuasa Hukum';
			else
				$kuasa = 'Penasihat Hukum';
			return $this->db->query("SELECT pen.id,perkara_id,pihak_ke,pengacara_id,urutan,
				CONCAT(pen.nama, '<br/> ".$kuasa." Dari: <br/>',p.nama) AS nama, pen.alamat, aktif, pihak_id
				FROM perkara_pengacara AS pen, pihak AS p 
				WHERE perkara_id = ".$idperkara." AND pihak_ke =".$pihakke." AND pen.pihak_id = p.id;
				");
		} catch (Exception $e) {
		}
	}

	function getInfoPerkaraAnak($idperkara){
		try {
			return $this->db->query("SELECT pp.id AS id, pp.urutan, pp.perkara_id, pp.nama,pp.pihak_id AS pihak_id, pp.alamat,ortu.id_orang_tua,p.nama AS wali
					FROM perkara_pihak2 AS pp
					LEFT JOIN 
					(SELECT * FROM perkara_pihak_orang_tua  WHERE jenis_pihak_anak = 0) AS ortu
					ON pp.pihak_id = ortu.id_anak AND pp.perkara_id = ortu.perkara_id
					LEFT JOIN
					pihak AS p
					ON p.id = ortu.id_orang_tua
					WHERE pp.perkara_id=".$idperkara." ORDER BY pp.urutan ASC;");
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getInfoKorbanAnak($idperkara){
		try {
			return $this->db->query("SELECT pp.id AS id, pp.urutan, pp.perkara_id, pp.nama,pp.pihak_id AS pihak_id, pp.alamat,ortu.id_orang_tua,p.nama AS wali
					FROM perkara_pihak_korban AS pp
					LEFT JOIN 
					(SELECT * FROM perkara_pihak_orang_tua  WHERE jenis_pihak_anak = 1) AS ortu
					ON pp.pihak_id = ortu.id_anak AND pp.perkara_id = ortu.perkara_id
					LEFT JOIN
					pihak AS p
					ON p.id = ortu.id_orang_tua
					WHERE pp.perkara_id=".$idperkara." ORDER BY pp.urutan ASC;");
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getInfoPihakKedua($idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->select('id,pihak_id,nama,alamat,urutan,perkara_id,nrp,jabatan,pangkat,kesatuan');
			$this->db->order_by('urutan', "ASC");
			return $this->db->get('perkara_pihak2');
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	
	function getInfoPihakKeempat($idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->select('id,pihak_id,nama,alamat,urutan');
			$this->db->order_by('urutan', "ASC");
			return $this->db->get('perkara_pihak4');
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	
	function getInfoIntervensi($idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->select('perkara_id');
			$this->db->from('perkara_pihak3');
			return $this->db->get()->num_rows();
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getInfoDiversi($idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->select('perkara_id');
			$this->db->from('perkara_diversi');
			return $this->db->get()->num_rows();
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getInfoEksekusi($idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->select('perkara_id');
			$this->db->from('perkara_eksekusi');
			return $this->db->get()->num_rows();
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getInfoBanding($idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->select('perkara_id');
			$this->db->from('perkara_banding');
			return $this->db->get()->num_rows();
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getInfoSidang($idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->select('perkara_id');
			$this->db->from('perkara_jadwal_sidang');
			return $this->db->get()->num_rows();
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getInfoPenetapan($idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->select('perkara_id');
			$this->db->from('perkara_penetapan');
			return $this->db->get()->num_rows();
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getInfoSidangPertama($idperkara){
		try {
			$query = $this->db->query('SELECT perkara_id FROM perkara_penetapan WHERE penetapan_hari_sidang IS NOT NULL AND perkara_id = '.$idperkara);
			return $query->num_rows();
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getInfoPutusanPerlawanan($idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->select('status_putusan_verzet_id');
			$this->db->from('perkara_verzet');
			$query = $this->db->get();
			if($query->num_rows()>0){
				if($query->row()->status_putusan_verzet_id==34)
					return 1;
				else
					return 2;
			}
			return 0;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getInfoKasasi($idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->select('perkara_id');
			$this->db->from('perkara_kasasi');
			return $this->db->get()->num_rows();
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getInfoPK($idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->select('perkara_id');
			$this->db->from('perkara_pk');
			return $this->db->get()->num_rows();
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getInfoGrasi($idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->select('perkara_id');
			$this->db->from('perkara_grasi');
			return $this->db->get()->num_rows();
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getInfoVerzet($idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->select('perkara_id');
			$this->db->from('perkara_verzet');
			return $this->db->get()->num_rows();
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
 
	function getInfoKeberatan($idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->select('perkara_id');
			$this->db->from('perkara_keberatan');
			return $this->db->get()->num_rows();
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getInfoPutusan($idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->select('tanggal_putusan');
			$result = $this->db->get('perkara_putusan');
			if($result->num_rows>0){
				return 1;
			}else{
				return 0;
			}
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getInfoPerkaraDismissal($idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->select('perkara_id');
			$result = $this->db->get('perkara_dismissal');
			if($result->num_rows>0){
				return $result->row()->perkara_id;
			}else{
				return 0;
			}
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}


	function getHasilDismissal($idperkara){
		try{
			$this->db->where('perkara_id',$idperkara);
			$this->db->select('hasil');
			return $this->db->get('perkara_dismissal');
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}


	function getInfoPanggilDismissal($idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->select('perkara_id');
			$result = $this->db->get('perkara_panggilan_dismissal');
			if($result->num_rows>0){
				return $result->row()->perkara_id;
			}else{
				return 0;
			}
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

    function getTglBht($idperkara){
		try {			
				$sql=('SELECT tanggal_bht FROM perkara_verzet WHERE perkara_id = '.$idperkara);
				$result = $this->db->query($sql);
				if($result->num_rows>0){
					return $result->row()->tanggal_bht;
				}else{
					return 0;
				}			
			
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getPanggilanPersiapan($idperkara){
		try {			
				$sql=('SELECT SUM(dihadiri_oleh) as dihadiri_oleh FROM perkara_persiapan_proses WHERE perkara_id = '.$idperkara.' AND urutan<3;');
				$result = $this->db->query($sql);
				if($result->num_rows>0){
					return $result->row()->dihadiri_oleh;
				}else{
					return 0;
				}			
			
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	function getLastPanggilanPersiapan($idperkara){
		try {			
				$sql=('SELECT dihadiri_oleh FROM perkara_persiapan_proses WHERE perkara_id ='.$idperkara.' AND id=(SELECT MAX(id) FROM perkara_persiapan_proses WHERE perkara_id='.$idperkara.')');
				$result = $this->db->query($sql);
				if($result->num_rows>0){
					return $result->row()->dihadiri_oleh;
				}else{
					return 0;
				}			
			
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getPutusanPerlawanan($idperkara){
		try {			
				$sql=('SELECT status_putusan_verzet_id FROM perkara_verzet WHERE perkara_id = '.$idperkara.' AND status_putusan_verzet_id IN(35,37,38);');
				$result = $this->db->query($sql);
				if($result->num_rows>0){
					return $result->row()->status_putusan_verzet_id;
				}else{
					return 0;
				}			
			
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	function getInfoTerdakwaTidakHadir($idperkara, $keberatan=0){
		try {
			if ($keberatan==0){
				$sql=('SELECT perkara_id FROM perkara_jadwal_sidang WHERE perkara_id = '.$idperkara.' AND urutan <4 AND dihadiri_oleh = 2;');
				$result = $this->db->query($sql);
			return $result->num_rows();
			}else{
				$sql=('SELECT dihadiri_oleh FROM perkara_jadwal_sidang WHERE perkara_id = '.$idperkara.';');
				$result = $this->db->query($sql);
				if($result->num_rows>0){
					return $result->row()->dihadiri_oleh;
				}else{
					return 0;
				}
			}
			
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function updt_data($idperkara,$data){
		try {
			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara', $data);
			$title = "UPDATE Data Umum [perkara_id=<b>".$idperkara."</b>]<br />UPDATE table <b>perkara</b> dari halaman <b>EDIT DATA UMUM</b> dengan Primary Key [id=".$idperkara."]";
			$descrip = $this->fetch_description($title,$data);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara');
			return TRUE;
		} catch (Exception $e) {
			log_message('error', $e);
			return FALSE;
		}
	}


	function hapus_perkara_pn($idperkara){
		try {
			$this->db->simple_query("CALL perkara_Delete(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
			log_message('error', $e);
		}
	}

	function fetch_description($title,$data){
		$descrip = '<br><table style="vertical-align:top" cellspacing="0" cellpadding="1" border="1">';
		$descrip .= '<tr><th>Nama Kolom</th><th>Nilai</th></tr>';
		foreach ($data as $key => $value) {
			$descrip .= '<tr>';
			$descrip .= '<td>'.$key.'</td>';
			$descrip .= '<td>'.$value.'</td>';
			$descrip .= '</tr>';
		}
		$descrip .= '</table>';
		return $descrip;
	}

	function add_audittrail($action,$title,$descrip,$tablename){
		try {
			$data = array(
				'datetime' => date("Y-m-d H:i:s"),
				'ipaddress' => $this->input->ip_address(),
				'username' => $this->session->userdata('username'),
				'tablename' => $tablename,
				'formname' => 'Add Pihak',
				'action' => $action,
				'title' => $title,
				'description' => $descrip
			);
			$this->db->insert('sys_audittrail', $data);
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

/*adityo*/
	function get_detil_data_utama($perkara_id)
	{
	if(empty($perkara_id)) 
			{
				return '';
			}
		try 
		{
			$where="A.perkara_id = C.perkara_id AND A.perkara_id = $perkara_id";
			$this->db->select('A.perkara_id,A.nomor_perkara,A.tanggal_pendaftaran,MIN(C.tanggal_sidang) as tanggal_sidang,');
			$this->db->from('perkara A, perkara_jadwal_sidang C');
			$this->db->where($where);
			$query=$this->db->get();
			return $query->result();
		} 
			catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_nama_dok($perkara_id,$kolom)
	{
		if(empty($perkara_id)) 
			{
				return '';
			}
		try 
		{
			$this->db->where('perkara_id',$perkara_id);
			$query=$this->db->get('perkara')->row();
			return $query->$kolom;
		} 
			catch (Exception $e) {
			log_message('error', $e);
		}

	}

	function update_dataumum($perkara_id,$datadiupdate)
	{
	if(empty($perkara_id))  
		{
			return '';
		}
		
		try 
		{
			$this->db->where('perkara_id',$perkara_id);
			$this->db->update('perkara',$datadiupdate);
			return TRUE;
		} 
			catch (Exception $e) {
			return FALSE;
			log_message('error', $e);
		}
	}
	
	function get_jumlah_saksi($idperkara){
		if(empty($idperkara)){ 
				return '';
		}
		try{
			$qry="SELECT COUNT(*) AS jumsaksi FROM perkara_pihak5 WHERE perkara_id=$idperkara";
			$query=$this->db->query($qry)->row()->jumsaksi;
			return $query;
			} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	
	function repair_riwayat_perkara_sidang_pertama($idperkara){
		$qry1="SELECT COUNT(*) AS adaprocsidang FROM perkara_proses WHERE proses_id='80' AND perkara_id=$idperkara";
		$adaprocsidang=$this->db->query($qry1)->row()->adaprocsidang;
		$qry2="SELECT penetapan_hari_sidang,sidang_pertama,diinput_oleh,diinput_tanggal,diperbaharui_oleh, diperbaharui_tanggal FROM perkara_penetapan WHERE penetapan_hari_sidang IS NOT NULL AND perkara_id=$idperkara";
		$runqry2=$this->db->query($qry2);
		if ($runqry2->result()){
			$tanggal=$runqry2->row()->penetapan_hari_sidang;
			$tanggalspertama=$runqry2->row()->sidang_pertama;
			$penginput=$runqry2->row()->diperbaharui_oleh;
			$tglinput=$runqry2->row()->diperbaharui_tanggal;
			if (empty($penginput)||$penginput==NULL){
				$penginput=$runqry2->row()->diinput_oleh;
				$tglinput=$runqry2->row()->diinput_tanggal;
			}

			$adapensidang=count($tanggal);
			if (($adapensidang==1) && ($adaprocsidang==0)){
				$qry3="SELECT A.id AS tahapan_id, A.nama as tahapan_text, B.id AS proses_id, B.nama AS proses_text FROM tahapan_proses A, proses B WHERE A.id=B.tahapan_id AND B.id='80';";
				$hasil=$this->db->query($qry3);

				$data_insert['perkara_id']=$idperkara;
				$data_insert['tahapan_id']=$hasil->row()->tahapan_id;
				$data_insert['tahapan_nama']=$hasil->row()->tahapan_text;
				$data_insert['proses_id']=$hasil->row()->proses_id;
				$data_insert['proses_nama']=$hasil->row()->proses_text;
				$data_insert['tanggal']=$tanggal;
				$data_insert['diinput_oleh']=$penginput;
				$data_insert['diinput_tanggal']=$tglinput;

				$this->db->insert('perkara_proses',$data_insert);
				
				$qry4="SELECT A.id AS tahapan_id, A.nama as tahapan_text, B.id AS proses_id, B.nama AS proses_text FROM tahapan_proses A, proses B WHERE A.id=B.tahapan_id AND B.id='81';";
				$hasil2=$this->db->query($qry4);

				$data_insert2['perkara_id']=$idperkara;
				$data_insert2['tahapan_id']=$hasil2->row()->tahapan_id;
				$data_insert2['tahapan_nama']=$hasil2->row()->tahapan_text;
				$data_insert2['proses_id']=$hasil2->row()->proses_id;
				$data_insert2['proses_nama']=$hasil2->row()->proses_text;
				$data_insert2['tanggal']=$tanggalspertama;
				$data_insert2['diinput_oleh']=$penginput;
				$data_insert2['diinput_tanggal']=$tglinput;

				$this->db->insert('perkara_proses',$data_insert2);
			}
		}
	}

}
