<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
#07-10-2015
class detil_perkara_tun extends CI_Controller {
	function index(){
		if($this->nativesession->get_flash_session('security')==FALSE){
			redirect('main');
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$idperkara = $this->nativesession->get_flash_session('perkara_id');
		if(!is_numeric($idperkara)){
			redirect('main');
		}
		$isDataUmum = $this->nativesession->get_flash_session('open_dataumum');
		if($isDataUmum=="No"){
			$this->show_data($idperkara);
		}elseif($isDataUmum=="Yes"){
			$this->show_dataumum($idperkara);
		}
	}

	function show_data($idperkara){
		$this->load->model('perkara/info_perkara_tun','perkara');
		$this->perkara->repair_riwayat_perkara_sidang_pertama($idperkara);
		$data = $this->parseData($this->perkara->getInfoPerkara($idperkara));
		$data['ada_pemeriksaan_persiapan'] = 0;
		$persiapanPemeriksaan = $this->perkara->getDataPemeriksaanPersiapan($idperkara);
		if($persiapanPemeriksaan->num_rows!=0){
			$data['ada_pemeriksaan_persiapan'] = 1;
		}
		$data['gugur_persiapan'] = $this->perkara->getPanggilanPersiapan($idperkara);
		$data['bht_perlawanan'] = $this->perkara->getPutusanPerlawanan($idperkara);
		$data['last_panggilan_persiapan'] = $this->perkara->getLastPanggilanPersiapan($idperkara);		
		$data['ada_bht'] = $this->perkara->getTglBht($idperkara);
		$data['ada_acara_cepat'] = $this->perkara->getDataAcaraSidang($idperkara);
		$data['alur_perkara_id']=$data['idalurperkara'];
		$data['perkaraid']=$idperkara;
		$data['pihak_pertama'] = $this->perkara->getInfoPihakPertama($idperkara);
		$data['pihak_kedua'] = $this->perkara->getInfoPihakKedua($idperkara);
		$data["ada_data_saksi"] = $this->perkara->get_jumlah_saksi($idperkara);
		$data["ada_data_verzet"] = 0;
		$data["ada_data_intervensi"] = 0;
		$data["ada_data_diversi"] = 0;
		$data["ada_data_eksekusi"] = 0;
		$data['terdakwa_tidak_hadir'] = 0;
		$data["ada_data_banding"] = $this->perkara->getInfoBanding($idperkara);
		$data["ada_data_kasasi"] = $this->perkara->getInfoKasasi($idperkara);
		$data["ada_data_PK"] = $this->perkara->getInfoPK($idperkara);
		$data["ada_data_dismissal"] = 0;
		$data["ada_data_gugur"] = 0;
		$data['hasilDismissal'] = 0;
		$data["ada_data_verzet"] = $this->perkara->getInfoVerzet($idperkara);
		$data["ada_data_sidang"] = $this->perkara->getInfoSidang($idperkara);
		$data["ada_data_intervensi"] = $this->perkara->getInfoIntervensi($idperkara);
		$data["ada_data_eksekusi"] = $this->perkara->getInfoEksekusi($idperkara);
		$data["ada_data_penetapan"] = $this->perkara->getInfoPenetapan($idperkara);
		$data["ada_data_putusan"] = $this->perkara->getInfoPutusan($idperkara);
		$data['is_perlawanan_dikabulkan'] = $this->perkara->getInfoPutusanPerlawanan($idperkara);
		$data['ada_penetapan_sidang_pertama'] = $this->perkara->getInfoSidangPertama($idperkara);
		$infoDismissal = $this->perkara->getInfoPerkaraDismissal($idperkara);
		$infoPanggilDis = $this->perkara->getInfoPanggilDismissal($idperkara);		
		$hasilDismissal = $this->perkara->getHasilDismissal($idperkara);

		if((intval($infoDismissal)>0) || (intval($infoPanggilDis)>0)){
			$data["ada_data_dismissal"] = 1;
		}

		foreach($hasilDismissal->result() as $row){
			$data['hasilDismissal'] = $row->hasil;
		}
				
		$data["pengacara_pihak_pertama"] = $this->perkara->getInfoPengacara($idperkara,1,$data['idalurperkara']);
		$data["pengacara_pihak_kedua"] = $this->perkara->getInfoPengacara($idperkara,2,$data['idalurperkara']);
		
		$data['page_title'] = 'INFORMASI DETAIL PERKARA TATA USAHA NEGARA';
		$data['enc'] = base64_encode($this->encrypt->encode($idperkara));
		$data['main_body'] = 'perkara/detil_perkara_tun';
		$data['main_history'] = $this->nativesession->get('main_url_requested');
		$data['history'] = $this->nativesession->get_flash_session('url_requested');
		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '100%';
		$this->ckeditor->config['height'] = '250px';
		$this->ckeditor->config['readOnly'] = 'true';
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}

	function show_dataumum($idperkara){
		$data['history'] = $this->nativesession->get_flash_session('url_requested');
		$this->load->model('perkara/info_perkara','perkara');
		$data = $this->parseData($this->perkara->getInfoPerkara($idperkara));
		$data['perkaraid']=$idperkara;
		$data['pihak_pertama'] = $this->perkara->getInfoPihakPertama($idperkara);
		$data['pihak_kedua'] = $this->perkara->getInfoPihakKedua($idperkara);
		$data["pengacara_pihak_pertama"] = $this->perkara->getInfoPengacara($idperkara,1,$data['idalurperkara']);
		$data["pengacara_pihak_kedua"] = $this->perkara->getInfoPengacara($idperkara,2,$data['idalurperkara']);
		$data["ada_data_intervensi"] = $this->perkara->getInfoIntervensi($idperkara);
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['alur_perkara_id']=$this->tanggalhelper->getIDAlurPerkara($data['idperkara']);
		$this->load->vars($data);
		$this->load->view('perkara_tab/data_umum');
	}

	
	function parseData($info_perkara){
		if($info_perkara!=''){
			if($info_perkara->num_rows>0){
				foreach ($info_perkara->result() as $row) {
					$data['idalurperkara'] = $row->alur_perkara_id;
					$data['noPerkara'] = $row->nomor_perkara;
					$data['noUrut'] = $row->nomor_urut_register;
					$data['tglSurat'] = $row->tanggal_surat;
					$data['noSurat'] = $row->nomor_surat;
					$data['idProses'] = $row->proses_terakhir_id;
					$data['prosesText'] = $row->proses_terakhir_text;
					$data['idTahapan'] = $row->tahapan_terakhir_id;
					$data['tahapanText'] = $row->tahapan_terakhir_text;
					$data['pihak1'] = $row->pihak1_text;
					$data['pihak2'] = $row->pihak2_text;
					$data['tglPendaftaran'] = $row->tanggal_pendaftaran;
					$data['statuTerakhir'] = $row->proses_terakhir_text;
					$data['tglPutusan'] = $row->tanggal_putusan;
					$data['jenisPerkara'] = $row->jenis_perkara_nama;
					$data['idjenisperkara'] = $row->jenis_perkara_id;
					$data['isPublish'] = ($row->pihak_dipublikasikan=='Y')? 'Ya':'Tidak';
					$data['petitum'] = $row->petitum;
					$data['petitum_dok'] = $row->petitum_dok;
					$data['prodeo'] = ($row->prodeo=='1')? 'Ya':'Tidak';
					$data['ada_data_putusan_sela'] = !empty($row->tanggal_putusan_sela)?1:0;
					$data['sudah_putusan'] = !empty($row->tanggal_putusan)?1:0;
					$data['sudah_minutasi'] = !empty($row->tanggal_minutasi)?1:0;
					$data['ada_data_umum']=0;
					if (!empty($row->pihak1_text) && !empty($row->pihak2_text)){
						if (!empty($row->petitum)){
							$data['ada_data_umum']=1;
						}
						
					}
					if ($row->tanggal_bht!=''){
						$data['tgl_bht']=$this->tanggalhelper->convertDayDate($row->tanggal_bht);
					}else{
						if ($this->authorization->HasRuleAddBHT()){
							$data['tgl_bht']='Tambah';
						}else{
							$data['tgl_bht']='Belum BHT';
						}
					}
				}
			}
		}
		return $data;
	}

	function confirmasiHapusPemeriksaan(){
		if($this->session->userdata('is_logged_in')==FALSE){ redirect('login'); }
		$segment = $this->uri->segment_array();
		$data['enc'] = $segment[2];
		$idperkara = $this->encrypt->decode(base64_decode($segment[2]));
		if(empty($idperkara) OR intval($idperkara)<1){
			show_404();
		}
		// ===== Script ini disesuaikan dengan yang ada di fileupload_c =====
		

		// ===================================================================
		
		$this->load->vars($data);
		$this->load->view('perkara/hapus_pemeriksaan_persiapan');
	}


	function hapusPemeriksaan(){
		try {
			
			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			if(!is_numeric($idperkara) OR intval($idperkara)<1){
				echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
				return;
			}

			$this->load->model('fileupload/fileupload_m');
			$idkirim=$idperkara;
			$from="persiapan";
			$namadokumen=$this->fileupload_m->get_nama_dok($idkirim,$from);

			//check file and directory to delete
			$arrdirectory=explode('/',$namadokumen);
			array_pop($arrdirectory);
			$direktori=implode("/",$arrdirectory);
			$arrparentdirectory=explode('/',$direktori);
			array_pop($arrparentdirectory);
			$parentdirektori=implode("/",$arrparentdirectory);
			
			//delete the file
			@unlink($namadokumen);
			//delete the directories if empty. if at least one file inside, this script is passed automaticaly
			@rmdir($direktori); 
			@rmdir($parentdirektori); 


			$this->load->model('perkara/pemeriksaan_persiapan','perkara');
			$result = $this->perkara->hapusPemeriksaan($idperkara);
			
			if($result==TRUE){
				echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DIHAPUS.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'GAGAL MELAKUKAN DISIMPAN.'));
				return;
			}
		} catch (Exception $e) {
			
		}
	}

	function manage_bht($enc){
		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$data['enc']=$enc;
		$data['perkara_id']=$this->encrypt->decode(base64_decode($enc));
		$this->load->model('perkara/info_perkara','perkara');
		$result = $this->perkara->getInfoPerkara($data['perkara_id'])->result();
		$tgl_bht=($result[0]->tanggal_bht);
		if ($tgl_bht!=''){
			$data['act']='edit';
			$data['tgl_bht']=$tgl_bht;
		}else{
			$data['act']='add';
			$data['tgl_bht']='';
		}
		$this->load->view('perkara/edit_bht', $data);
	}

	function validation_tgl_bht($act){
		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$this->form_validation->set_rules('tgl_bht', 'Tanggal BHT', 'trim|required|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			//echo $act;
			$enc=$this->input->post('enc',true);
			$tgl_bht=$this->tanggalhelper->convertToMysqlDate(trim($this->input->post('tgl_bht',true)));
			if($tgl_bht==false){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}
			$perkara_id=$this->encrypt->decode(base64_decode($enc));
			$this->load->model('perkara/info_perkara','perkara');
			$result = $this->perkara->getInfoPerkara($perkara_id)->result();
			$tanggal_minutasi=($result[0]->tanggal_minutasi);
			if ($tgl_bht<$tanggal_minutasi){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tanggal BHT Tidak Boleh Kurang Dari Tanggal Minutasi'));
				return;
			}
			//print_r($this->input->post());
			if($this->perkara->update_bht($tgl_bht,$perkara_id)){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan tun'));
			}else{
				echo json_encode(array('st'=>0,'msg'=>'ERROR SIMPAN KE DATABASE'));
			}
		}
	}
}
/* End of file detil_perkara_tun.php */
/* Location: ./application/controllers/detil_perkara_tun.php */
