<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Report_gugatan_sederhana extends CI_Model{
	
	function get_info_pn(){
		try {
			$this->db->select('*');
			$this->db->where('id >=', 61); 
			return $this->db->get('sys_config');
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	function getJenisPerkara($idalurperkara){
		if(empty($idalurperkara)) return '';
		try {
			$this->db->where('id',$idalurperkara);
			return $this->db->get('alur_perkara')->row()->nama;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_tahun($idalurperkara){
		try {
			return $this->db->query('SELECT YEAR(min(tanggal_pendaftaran)) AS years FROM perkara WHERE alur_perkara_id IN ('.$idalurperkara.');');
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	

	function get_rekap($idalurperkara,$tahun){
		try {
			return $this->db->query('SELECT tanggal_pendaftaran, 
				left(tanggal_pendaftaran,7) AS tgl,
				tahun_pendaftaran,
				bulan_pendaftaran, 
				LEFT(tanggal_putusan,7) AS putusan, 
				LEFT(penetapan_majelis_hakim,7) AS majelis,
				hasil_mediasi,LEFT(tanggal_cabut,7) AS cabut,
				LEFT(keputusan_mediasi,7) AS mediasi, 
				LEFT(tanggal_gugur,7) AS gugur,LEFT(tanggal_minutasi,7) AS minutasi
				FROM v_perkara 
				WHERE alur_perkara_id IN ('.$idalurperkara.') AND tahun_pendaftaran<='.$tahun.';');
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}



	function get_stat_perkara_bln($period,$idalurperkara){
		try {
			return $this->db->query("SELECT 
					p.id AS idJenisPerkara,
					j.alur_perkara_id, 
					j.jenis_perkara_id AS id,
					p.nama AS nama,
					p.nama_lengkap AS namaLengkap,
					(SELECT COUNT(*) FROM perkara WHERE LEFT(tanggal_pendaftaran,7)<='".$period."' AND jenis_perkara_id=p.id AND alur_perkara_id='".$idalurperkara."' AND tahapan_terakhir_id < '10') AS sisaLalu,
					(SELECT COUNT(*) FROM perkara WHERE LEFT(tanggal_pendaftaran,7)='".$period."' AND jenis_perkara_id=p.id AND alur_perkara_id='".$idalurperkara."') AS jumlahMasuk,
					(SELECT COUNT(*) FROM perkara WHERE LEFT(tanggal_pendaftaran,7)<='".$period."' AND jenis_perkara_id=p.id AND alur_perkara_id='".$idalurperkara."' AND tahapan_terakhir_id = '10') AS jumlahPutus
					FROM jenis_alur_perkara AS j, jenis_perkara AS p
					WHERE j.jenis_perkara_id = p.id AND j.alur_perkara_id='".$idalurperkara."'
					GROUP BY p.id ASC");
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_lap_perkara($period,$idalurperkara){
		try {
			return $this->db->query("SELECT 
					p.id AS idJenisPerkara,
					j.alur_perkara_id, 
					j.jenis_perkara_id AS id,
					p.nama AS nama,
					p.nama_lengkap AS namaLengkap,
					(SELECT COUNT(*) FROM perkara WHERE LEFT(tanggal_pendaftaran,7)<='".$period."' AND jenis_perkara_id=p.id AND alur_perkara_id='".$idalurperkara."' AND tahapan_terakhir_id < '10') AS sisaLalu,
					(SELECT COUNT(*) FROM perkara WHERE LEFT(tanggal_pendaftaran,7)='".$period."' AND jenis_perkara_id=p.id AND alur_perkara_id='".$idalurperkara."') AS jumlahMasuk,
					(SELECT COUNT(*) FROM perkara WHERE LEFT(tanggal_pendaftaran,7)<='".$period."' AND jenis_perkara_id=p.id AND alur_perkara_id='".$idalurperkara."' AND tahapan_terakhir_id = '10') AS jumlahPutus
					FROM jenis_alur_perkara AS j, jenis_perkara AS p
					WHERE j.jenis_perkara_id = p.id AND j.alur_perkara_id='".$idalurperkara."'
					GROUP BY p.id ASC");
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	
}