<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Grasi extends CI_Model{
	
	function getJenisPerkara($idalurperkara){
		if(empty($idalurperkara)) return '';
		try {
			$this->db->where('id',$idalurperkara);
			return $this->db->get('alur_perkara')->row()->nama;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	
	function isNomorPerkara($txt){
		$re1='(\\d+)';	# Integer Number 1
		$re2='(\\/)';	# Any Single Character 1
		$re3='.*?';	# Non-greedy match on filler
		$re4='(\\/)';	# Any Single Character 2
		$re5='((?:(?:[1]{1}\\d{1}\\d{1}\\d{1})|(?:[2]{1}\\d{3})))(?![\\d])';	# Year 1
		$re6='(\\/)';	# Any Single Character 3
		$re7='(PN)';	# Variable Name 1
		if ($c=preg_match_all ("/".$re1.$re2.$re3.$re4.$re5.$re6.$re7."/is", $txt, $matches)){
		      $int1=$matches[1][0];
		      $c1=$matches[2][0];
		      $c2=$matches[3][0];
		      $year1=$matches[4][0];
		      $c3=$matches[5][0];
		      $var1=$matches[6][0];
		      return 1;
		}else{
			return 0;
		}
	}

	function parseOrderby($col){
		if($col==1){
			return "nomor_perkara_pn"; 
		}else if($col==2){
			return "permohonan_grasi"; 
		}else if($col==3){
			return "terdakwa_nama"; 
		}else if($col==4){
			return "pemohon_nama"; 
		}else if($col==5){
			return "pemberitahuan_putusan_tetap"; 
		}else if($col==6){
			return "pengiriman_pertimbangan_hakim_grasi"; 
		}else if($col==7){
			return "tanggal_putusan_grasi"; 
		}else if($col==8){
			return "tanggal_penerimaan_kembali_berkas_grasi"; 
		}else{
			return "permohonan_grasi";
		}
	}

	//DODON - Update select
	function getPerkaraList($idalurperkara='',$col=2,$type='DESC',$begin=0,$key=''){
		$orderby = $this->parseOrderby($col);
		$where = '';

		if($idalurperkara>0){
			$where = "AND alur_perkara_id IN (".$idalurperkara.")";
		}else{
			$where = "";
		}

		if(!empty($key)){
			if($this->isNomorPerkara($key)){
				$where_like = ' WHERE nomor_perkara_pn ="'.$key.' ';

			}else{
				$where_like = ' WHERE (nomor_perkara_pn LIKE "%'.$key.'%" 
					OR permohonan_grasi LIKE "%'.$key.'%"
					OR pemohon_nama LIKE "%'.$key.'%" 
					OR terdakwa_nama LIKE "%'.$key.'%") ';
			}
		}else{
			$where_like =" ";
			if($idalurperkara>0){
				$where = " WHERE alur_perkara_id IN (".$idalurperkara.")";
			}
		}
		try {
			$query = $this->db->query("SELECT SQL_CALC_FOUND_ROWS id,perkara_id, perkara_id,
				alur_perkara_id,
				nomor_perkara_pn,
				permohonan_grasi,
				terdakwa_nama,
				pemohon_nama,
				pemberitahuan_putusan_tetap,
				pengiriman_pertimbangan_hakim_grasi,
				tanggal_putusan_grasi,
				tanggal_penerimaan_kembali_berkas_grasi
				FROM perkara_grasi ".$where_like." ".$where." ORDER BY ".$orderby." ".$type." LIMIT ".$begin.",50");
			return $query;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}



	function fecth_data_num($idalurperkara,$key){
		$query = $this->db->query("SELECT FOUND_ROWS() as cnt;");
		if($query->num_rows>0){
			foreach ($query->result() as $row) {
				return $row->cnt;
			}
    		return $query->num_rows;
    	}else{
    		return 0;
    	}
	}


	function getPerkaraGrasiCetak($idalurperkara='',$key=''){
		$where = '';
		
		if($idalurperkara>0){
			$where = "AND alur_perkara_id IN (".$idalurperkara.")";
		}else{
			$where = "";
		}

		if(!empty($key)){
			if($this->isNomorPerkara($key)){
				$where_like = ' WHERE nomor_perkara_pn ="'.$key.' ';

			}else{
				$where_like = ' WHERE (nomor_perkara_pn LIKE "%'.$key.'%" 
					OR permohonan_grasi LIKE "%'.$key.'%"
					OR pemohon_nama LIKE "%'.$key.'%" 
					OR terdakwa_nama LIKE "%'.$key.'%") ';
			}
		}else{
			$where_like =" ";
			if($idalurperkara>0){
				$where = " WHERE alur_perkara_id IN (".$idalurperkara.")";
			}
		}
		try {
			$query = $this->db->query("select * FROM perkara_grasi ".$where_like." ".$where."");
			return $query;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}


	#09/02/2016
	function getDataProsesPerkara($proses_id,$alur_perkara_id){
		try{
			$this->db->where('proses_id', $proses_id);
			$this->db->where('alur_perkara_id', $alur_perkara_id);
			$query = $this->db->get('proses_alur_perkara');
			return $query;
		} catch (Exception $e) {
         	log_message('error', $e);
		}
	}



	##DODON
	function updateProsesPerkara($perkara_id){
		try{
			return $this->db->query('CALL perkara_update_status('.$perkara_id.')');
		} catch (Exception $e) {
           	log_message('error', $e);
		}
	}

	##DODON
	function data_putusan($perkara_id){
		try{
				$this->db->where('perkara_id', $perkara_id);
				$query = $this->db->get('perkara_putusan');
				return $query;
			} catch (Exception $e) {
            	log_message('error', $e);
		}
	}

	##DODON
	function data_banding($perkara_id){
		try{
				$this->db->where('perkara_id', $perkara_id);
				$query = $this->db->get('perkara_banding');
				return $query;
			} catch (Exception $e) {
            	log_message('error', $e);
		}
	}

	##DODON
	function data_kasasi($perkara_id){
		try{
				$this->db->where('perkara_id', $perkara_id);
				$query = $this->db->get('perkara_kasasi');
				return $query;
			} catch (Exception $e) {
            	log_message('error', $e);
		}
	}

	##DODON
	function data_pk($perkara_id){
		try{
				$this->db->where('perkara_id', $perkara_id);
				$query = $this->db->get('perkara_pk');
				return $query;
			} catch (Exception $e) {
            	log_message('error', $e);
		}
	}

	##DODON
	function getPerkara($nomorPerkara){
		try{
				$this->db->where('nomor_perkara',$nomorPerkara);
				$query = $this->db->get('perkara');
				return $query;
			} catch (Exception $e) {
            	log_message('error', $e);
		}
	}

	##DODON
	function getPerkaraGrasi($terdakwa_id){
		try{
			$this->db->where('terdakwa_id',$terdakwa_id);
			$query = $this->db->get('perkara_grasi');
			return $query;
		} catch (Exception $e) {
           	log_message('error', $e);
		}
	}


	
	##DODON
	function pihak2($perkara_id){
		try{
			$this->db->select('pihak.nama AS nama,pihak.id AS id,pihak.alamat,pihak.pekerjaan');
			$this->db->from('perkara_pihak2');
			$this->db->join('pihak', 'pihak.id=perkara_pihak2.pihak_id');
			$this->db->where('perkara_pihak2.perkara_id', $perkara_id);
			$query = $this->db->get();
			return $query;
		} catch (Exception $e) {
            log_message('error', $e);
		}
	}

	##DODON
	function getDataPihak2($pihak_id){
		try{
			$this->db->select('pihak.nama AS nama,pihak.id AS id,pihak.alamat,pihak.pekerjaan');
			$this->db->from('pihak');
			$this->db->where('id',$pihak_id);
			$query = $this->db->get();
			return $query;
		} catch (Exception $e) {
            log_message('error', $e);
		}
	}

	//DODON
	function updateTabelPerkara($perkaraId,$tahapanId,$tahapanText,$prosesId,$prosesText){
		try{
			$data = array(
               'tahapan_terakhir_id' => $tahapanId,
               'tahapan_terakhir_text' => $tahapanText,
               'proses_terakhir_id' => $prosesId,
               'proses_terakhir_text' => $prosesText
            );
			$this->db->where('perkara_id', $perkaraId);
			$this->db->update('perkara', $data); 
		} catch (Exception $e) {
            log_message('error', $e);
		}
	}

	#DODON 25/05/2015
	function mDetilGrasi($grasiId){
		try{
			$this->db->where('id', $grasiId);
			$query = $this->db->get('perkara_grasi');
			return $query;
		} catch (Exception $e) {
         	log_message('error', $e);
		}
	}


	function mDetilGrasiPerkaraId($perkaraId){
		try{
			$this->db->where('perkara_id', $perkaraId);
			$query = $this->db->get('perkara_grasi');
			return $query;
		} catch (Exception $e) {
         	log_message('error', $e);
		}
	}

	#DODON 25/05/2015
	function parsingTanggalView($date){
		if($date!=="0000-00-00"){
			return $this->templatehelper->convertKeTglIndo($date);
		}else{
			return '';
		}
	}

	#DODON 25/05/2015
	function parsingTanggalEdit($date){
		if($date!=="0000-00-00"){
			return $this->tanggalhelper->convertToInputDate($date);
		}else{
			return '';
		}
	}

	#DODON 25/05/2015
	function parsingSeleksi($jenisSeleksi,$seleksi){
		if($jenisSeleksi==1){
			$statusSeleksi1 = 'Ya';	
			$statusSeleksi2 = 'Tidak';
		} else {
			$statusSeleksi1 = 'Disimpan';	
			$statusSeleksi2 = 'Diuangkan';
		}
		if($seleksi=='Y'){
			return $statusSeleksi1;
		} else {
			return $statusSeleksi2;
		}
	}


	#UPDATE - DODON 08/02/2016
	function hapusDataPutusanPresiden($perkaraId){
		try{
			$data = array(
               	'tanggal_putusan_grasi' => '0000-00-00',
               	'nomor_putusan_grasi' => '',
               	'amar_putusan_grasi' => '',
               	'diperbaharui_oleh'=>$this->session->userdata('username'),
				'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
            );

			$this->db->where('perkara_id', $perkaraId);
			$this->db->update('perkara_grasi', $data); 

			$this->db->where('perkara_id',$perkaraId);
			$this->db->where('proses_id','680');
			$this->db->delete('perkara_proses');
			$this->db->simple_query("CALL perkara_update_status(".$perkaraId.");");
			return TRUE;
		} catch (Exception $e) {
         	log_message('error', $e);
         	return FALSE;
		} 
	}







	#DODON 25/05/2015
	function hapusData($tabel,$tabelId,$id){
		try{
			$this->db->where($tabelId,$id);
			$query = $this->db->delete($tabel); 
			return $query;
		} catch (Exception $e) {
         	log_message('error', $e);
		}
	}


	function hapusProses($perkaraId,$tahapanId){
		try{
			$this->db->where('perkara_id',$perkaraId);
			$this->db->where('tahapan_id',$tahapanId);
			$query = $this->db->delete('perkara_proses'); 
			return $query;
		} catch (Exception $e) {
         	log_message('error', $e);
		}	
	}

	function getPerkaraGrasibyID($id){
		try{
			$this->db->where('id',$id);
			$query = $this->db->get('perkara_grasi');
			return $query;
		} catch (Exception $e) {
           	log_message('error', $e);
		}
	}

	#DODON 26/05/2015
	function perkaraProses($perkaraId,$prosesId){
		try{
			
			$this->db->where('perkara_id',$perkaraId);
			$this->db->where('proses_id',$prosesId);
			$query = $this->db->get('perkara_proses'); 
			return $query;
		} catch (Exception $e) {
         	log_message('error', $e);
		}	
	}

	#DODON 26/05/2015
	function fetch_description($title,$data){
		$descrip = '<br><table style="vertical-align:top" cellspacing="0" cellpadding="1" border="1">';
		$descrip .= '<tr><th>Nama Kolom</th><th>Nilai</th></tr>';
		foreach ($data as $key => $value) {
			$descrip .= '<tr>';
			$descrip .= '<td>'.$key.'</td>';
			$descrip .= '<td>'.$value.'</td>';
			$descrip .= '</tr>';
		}
		$descrip .= '</table>';
		return $descrip;
	}

	#DODON 26/05/2015
	function add_audittrail($action,$title,$descrip,$tablename){
		try {
			$data = array(
				'datetime' => date("Y-m-d H:i:s"),
				'ipaddress' => $this->input->ip_address(),
				'username' => $this->session->userdata('username'),
				'tablename' => $tablename,
				'formname' => 'Add / Edit Perkara Grasi',
				'action' => $action,
				'title' => $title,
				'description' => $descrip
			);
			$this->db->insert('sys_audittrail', $data);
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}





}

?>