<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class tab_mediasi_c extends CI_Controller {

	function index(){
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['idperkara'] = $this->encrypt->decode(base64_decode($data['enc']));
		$this->load->model('mediasi/mediasi_m');
		$this->load->model('mediasi/jadwal_mediasi_m');
		$data['tab_mediasi']=$this->mediasi_m->get_data_mediasi($data['idperkara']);
		$data['tgl_pendaftaran']=$this->mediasi_m->get_nomor_perkara($data['idperkara'])->row()->tanggal_pendaftaran;
		$data['idalurperkara']=$this->mediasi_m->get_nomor_perkara($data['idperkara'])->row()->alur_perkara_id;

		$i=1;
		if (count($data['tab_mediasi']->result())>=1){
			foreach($data['tab_mediasi']->result() as $row){
				$jadwalmediasi="jadwalmediasi".$i;
				$mediasiid=$row->mediasi_id;

				$jumjmediasi=count($this->mediasi_m->get_jadwal_mediasi_terakhir($mediasiid));
				if ($jumjmediasi==0){
					$data_add['id']=$this->jadwal_mediasi_m->get_id_jadwal_mediasi_terakhir()->row()->id + 1;
					$data_add['mediasi_id']=$row->mediasi_id;
					$data_add['urutan']=1;
					$data_add['tanggal_mediasi']=$row->dimulai_mediasi;
					$data_add['tempat']="Ditentukan Kemudian";
					$data_add['ditunda']="Y";
					$data_add['diinput_oleh']=$this->session->userdata('username');
					$data_add['diinput_tanggal']=date("Y-m-d h:i:s",time());
					$this->jadwal_mediasi_m->add_jadwal_mediasi($data_add);
				}

				$listdata[$jadwalmediasi]=$this->jadwal_mediasi_m->get_data_jadwal_mediasi($mediasiid);
				$i++;
			}
		}else{
				$this->error_page->show_error_msg('Error Found','Terjadi Kesalahan Data. Edit Penetapan Sidang Pertama Terlebih Dahulu.');
				exit();
		}		
		$data['listjadwalmediasi']=$listdata; 
		$data['aksi']='';
		$this->load->vars($data);
		$this->load->view('perkara_tab/tab_mediasi_v');
	}

	function hapus_mediasi()
	{
		$segment = $this->uri->segment_array();
		$enc = $this->uri->segment(3);
		$idmediasi = $this->uri->segment(4);
		$urutan = $this->uri->segment(5);
		$idperkara = $this->encrypt->decode(base64_decode($enc));
		$id_mediasi = $this->encrypt->decode(base64_decode($idmediasi));

		$this->load->model('mediasi/mediasi_m');

		$datautama=$this->mediasi_m->get_nomor_perkara($idperkara);
		foreach ($datautama->result() as $datautama)
		{
			$tgldaftar=$datautama->tanggal_pendaftaran;
		}

		$namadokumen=$this->mediasi_m->get_nama_dok($id_mediasi);
		
		$jumslash=substr_count($namadokumen,"/");
		if(!empty($namadokumen)){
			$splittgldaftar=explode("-",$tgldaftar);
			$direktori="resources/file/doc/".$splittgldaftar[0]."/".$splittgldaftar[1];
			$parentdirektori="resources/file/doc/".$splittgldaftar[0];
			if($jumslash!=5){
				$filenya=$direktori."/".$namadokumen;
			}else{
				$filenya=$namadokumen;
			}
			@unlink($filenya);
			@rmdir($direktori); 
			@rmdir($parentdirektori); 
		}
		

		if($this->mediasi_m->hapus_mediasi($id_mediasi))
		{
			$this->mediasi_m->cancelproses($idperkara,200,$urutan);
			$this->mediasi_m->cancelproses($idperkara,181,$urutan);				
			$this->mediasi_m->cancelproses($idperkara,180,$urutan);
			$this->mediasi_m->cancelproses($idperkara,151,$urutan);
			$this->mediasi_m->cancelproses($idperkara,150,$urutan);
			$this->mediasi_m->cancelproses($idperkara,130,$urutan);	
			$this->mediasi_m->cancelproses($idperkara,121,$urutan);	
			$this->mediasi_m->cancelproses($idperkara,120,$urutan);	
			$this->mediasi_m->cancelproses($idperkara,110,$urutan);	
			
			echo json_encode(array('st'=>1,'msg'=>'Penghapusan Data Mediasi Berhasil'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'));
			return;
		}
	}

	function tambah_mediasi()
	{
		$segment = $this->uri->segment_array();
		$data['enc'] = $this->uri->segment(2);
		$data['jns']=$this->uri->segment(3);
		$data['urutan']=$this->uri->segment(4);

		$idperkara = $this->encrypt->decode(base64_decode($data['enc']));

		$this->load->model('mediasi/mediasi_m');

		$result = $this->mediasi_m->get_data_penetapan($idperkara);
		if($result!=''){
			if($result->num_rows()>0){
				foreach ($result->result() as $row) {
					$data['nomor_perkara'] = $row->nomor_perkara;
					$data['tanggal_penetapan_sidang_pertama'] = $row->penetapan_hari_sidang;
					$data['sidang_pertama'] = $row->sidang_pertama;
				}
			}else{
				$this->error_page->show_error_msg('Error Found','Belum Penetapan');
				exit();
			}
		}else{
			$this->error_page->show_error_msg('Error Found','Something the right happen. Perkara ID Not Found. Error Code = 188');
			exit();
		}

		$mediasi_sebelumnya = $this->mediasi_m->get_mediasi_sebelum($idperkara);
		foreach ($mediasi_sebelumnya->result() as $mediasi_sebelumnya){
			$data['keputusan_mediasi_sebelumnya']=$mediasi_sebelumnya->keputusan_mediasi;
			$data['hasil_mediasi_sebelumnya']=$mediasi_sebelumnya->hasil_mediasi;
		}

		if ($data['jns']==2){
			$data['mediatorsukarela']=$this->mediasi_m->get_majelis_untuk_mediator($idperkara);
		}

		$data['tgl_sekarang'] = date('d/m/Y');
		if ($data['jns']==1){
			$data['data_mediator'] = $this->mediasi_m->get_mediator();
		}else{
			$data['data_mediator'] = $this->mediasi_m->get_majelis_untuk_mediator($idperkara);
		}
		$data['id_mediator']='';
		$this->load->view('perkara_tab/tab_mediasi_tambah',$data);
	}

	function edit_penetapan_mediasi()
	{
		$segment = $this->uri->segment_array();
		$data['enc'] = $this->uri->segment(2);
		$id_mediasi = $this->uri->segment(3);
		$data['encmed']=$this->uri->segment(4);
		$data['urutan']=$this->uri->segment(5);
		$idperkara=$this->encrypt->decode(base64_decode($data['enc']));
		$id_mediasi=$this->encrypt->decode(base64_decode($id_mediasi));

		$this->load->model('mediasi/mediasi_m');

		$result = $this->mediasi_m->get_data_penetapan($idperkara);
		if($result!=''){
			if($result->num_rows()>0){
				foreach ($result->result() as $row) {
					$data['nomor_perkara'] = $row->nomor_perkara;
					$data['tanggal_penetapan_sidang_pertama'] = $row->penetapan_hari_sidang;
					$data['sidang_pertama'] = $row->sidang_pertama;
				}
			}else{
				$this->error_page->show_error_msg('Error Found','Belum Penetapan');
				exit();
			}
		}else{
			$this->error_page->show_error_msg('Error Found','Something the right happen. Perkara ID Not Found. Error Code = 188');
			exit();
		}

		 if($id_mediasi!=''){
			$result_v_mediasi = $this->mediasi_m->get_v_mediasi($id_mediasi);
			if($result_v_mediasi!=''){
				if($result_v_mediasi->num_rows()>0){
					foreach ($result_v_mediasi->result() as $row){
						if($data['urutan']==1){
							$data['id_mediator'] = $row->mediator_id;
						}else{
							$data['id_mediator'] = $row->hakim_id;
						}
						$data['mediasi_id'] = $row->mediasi_id;
						$data['penetapan_mediator'] = $row->penetapan_penunjukan_mediator;
						$data['nomor_sk_penetapan'] = $row->nomor_sk_penetapan_mediator;
						$data['status_mediator'] = $row->status_mediator;
						$data['nama_mediator'] = $row->mediator_text;
						$data['tgl_mediasi'] = $row->dimulai_mediasi;
					}
				}else{
					$this->error_page->show_error_msg('Error Found','Tidak ada ID Mediasi');
					exit();
				}
			}else{
				$this->error_page->show_error_msg('Error Found','Something the right happen. Mediasi ID Not Found. Error Code = 188');
				exit();
			}
		}		
		
		$data['tgl_sekarang'] = date('d/m/Y');
		if ($data['urutan']==1){
			$data['data_mediator'] = $this->mediasi_m->get_mediator();
		}else{
			$data['data_mediator'] = $this->mediasi_m->get_majelis_untuk_mediator($idperkara);
		}
		$this->load->view('perkara_tab/tab_mediasi_edit1',$data);
	}

	function edit_hasil_mediasi()
	{
		$segment = $this->uri->segment_array();
		$data['enc'] = $this->uri->segment(2);
		$id_mediasi = $this->uri->segment(3);
		$data['encmed']=$this->uri->segment(4);
		$data['urutan']=$this->uri->segment(5);
		$idperkara=$this->encrypt->decode(base64_decode($data['enc']));
		$id_mediasi=$this->encrypt->decode(base64_decode($id_mediasi));
		$this->load->model('mediasi/mediasi_m');

		 if($id_mediasi!=''){
			$result_v_mediasi = $this->mediasi_m->get_v_mediasi($id_mediasi);
			if($result_v_mediasi!=''){
				if($result_v_mediasi->num_rows()>0){
					foreach ($result_v_mediasi->result() as $row){
						$data['mediasi_id'] = $row->mediasi_id;
						$data['mediasi_id'];
						$data['tgl_mediasi'] = $row->dimulai_mediasi;
						$data['hasil_mediasi'] = $row->hasil_mediasi;
						$data['tgl_akta_perdamaian'] = $row->akta_perdamaian;
						$data['isi_akta_perdamaian'] = $row->isi_akta_perdamaian;
						$data['isi_akta_perdamaian_dok'] = $row->isi_akta_perdamaian_dok;
						$data['keterangan'] = $row->catatan_mediasi;
						$data['tgl_laporan_mediator'] = $row->tgl_laporan_mediator;
						$data['keputusan_mediasi']=$this->mediasi_m->get_jadwal_mediasi_terakhir($data['mediasi_id']);
					}
				}else{
					$this->error_page->show_error_msg('Error Found','Tidak ada ID Mediasi');
					exit();
				}
			}else{
				$this->error_page->show_error_msg('Error Found','Something the right happen. Mediasi ID Not Found. Error Code = 188');
				exit();
			}
		}		
		
		$this->ckeditor();
		$data['tgl_sekarang'] = date('d/m/Y');
		$this->load->view('perkara_tab/tab_mediasi_edit2',$data);
	}

	function insert_update_penetapan_mediasi()
	{
		$act=$this->input->post('act',TRUE);
		$jns=$this->input->post('jns',TRUE);
		$urutan=$this->input->post('urutan',TRUE);
		$mediasi_id=$this->input->post('mediasi_id',TRUE);
		$mediasi_id = $this->encrypt->decode(base64_decode($mediasi_id));

		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$this->form_validation->set_rules('tgl_penetapan_mediator', 'Tanggal Penetapan Mediator', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('sk_penetapan_mediator', 'SK Penetapan Mediator', 'trim|xss_clean');
		$this->form_validation->set_rules('mediator', 'Nama Mediator', 'trim|required|xss_clean|min_length[2]');		

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			$idmediator = $this->encrypt->decode(base64_decode($this->input->post('mediator',TRUE)));
			if(!is_numeric($idperkara)){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Perkara Tidak ditemukan. Code Error = 194.'));
				return;
			}else{
				$this->load->model('mediasi/mediasi_m','mediasi');
				if (($jns>1)or($urutan>1)){
					$idmediator=$this->mediasi->cek_hakim_di_mediator($idmediator);
				}

				$jml_perkara_mediator=($this->mediasi->get_perkara_mediator());
				$id_perkara_mediator=intval($jml_perkara_mediator+1);

				$maxid=$this->mediasi->get_maxid_mediasi()->row()->maxid;
				$id_mediasi_awal=$maxid;
				
				$result_mediator = $this->mediasi->get_detil_mediator($idmediator);
				$status_mediator='';
				$nama_mediator='';

				if($result_mediator!=''){
					if($result_mediator->num_rows()>0){
						foreach ($result_mediator->result() as $row){
							$status_mediator = $row->status_mediator;
							$nama_mediator = $row->nama;
						}
					}else{
						echo json_encode(array('st'=>0,'msg'=>'Data Mediator Tidak Ditemukan.'));
						return;
					}
				}else{
					echo json_encode(array('st'=>0,'msg'=>'Data Mediator Tidak Ditemukan.'));
					return;
				}

				$curr_date = date('Y-m-d');
				$todayDate = date('d/m/Y');

				$tanggal = $this->input->post('tgl_penetapan_mediator',TRUE);
				$sidang_pertama = $this->input->post('sidang_pertama',TRUE);
				$kesepakatan_mediasi_sebelumnya = $this->input->post('kesepakatan_mediasi_sebelumnya',TRUE);
				$tanggal = $this->tanggalhelper->convertToMysqlDate($tanggal);

				$selisih = $this->tanggalhelper->getSelisihHari($kesepakatan_mediasi_sebelumnya,$tanggal);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Mediator Tidak Boleh Sebelum Tanggal Kesepakatan Mediasi Sebelumnya'));
					return;
				}
				$selisih = $this->tanggalhelper->getSelisihHari($tanggal,$curr_date);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Mediator Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
					return;
				}
				$selisih = $this->tanggalhelper->getSelisihHari($sidang_pertama,$tanggal);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Mediator Tidak Boleh Kurang Dari Tanggal Sidang Pertama'));
					return;
				}

				$dayName = $this->tanggalhelper->getDayName($tanggal);
				if($dayName=="Sunday" OR $dayName=="Saturday"){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat memilih Tanggal Penetapan Mediator diluar hari kerja (Sabtu - Minggu).'));
					return;
				}
				$result = $this->mediasi->get_data_penetapan($idperkara);
				if($result!=''&&$result->num_rows()>0){
					foreach ($result->result() as $row){
						$tanggal_penetapan_sidang_pertama = $row->penetapan_hari_sidang;
						$sidang_pertama = $row->sidang_pertama;
					}
				}else{
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Data Penetapan Sidang Tidak Ditemukan.'));
					return;
				}

				if ($act=='e'){
					$jmediasikedua=$this->mediasi->get_jadwal_mediasi_kedua($mediasi_id);
					if (!empty($jmediasikedua)){
						$selisih = $this->tanggalhelper->getSelisihHari($tanggal,$jmediasikedua);
						if($selisih<0){
							echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Telah Terdapat Jadwal Mediasi Pada '.$this->tanggalhelper->convertDayDate($jmediasikedua).'. Tanggal Penetapan Mediator Tidak Boleh Melebihi Tanggal Tersebut'));
							return;
						}
					}
				}

				$data_add = array(
						'mediasi_id' => $id_mediasi_awal,
						'perkara_id' => $idperkara,
						'mediator_id' => $idmediator,
						'status_mediator' => $status_mediator,
						'mediator_text' => $nama_mediator,
						'nomor_sk_penetapan_mediator' => $this->input->post('sk_penetapan_mediator',TRUE),						
						'penetapan_penunjukan_mediator' => $tanggal,
						'dimulai_mediasi' => $tanggal,
						'diinput_oleh' => $this->session->userdata('username'),
						'diinput_tanggal' => date("Y-m-d h:i:s",time())
					);
				$data_edit = array(
						'mediator_id' => $idmediator,
						'status_mediator' => $status_mediator,
						'mediator_text' => $nama_mediator,
						'nomor_sk_penetapan_mediator' => $this->input->post('sk_penetapan_mediator',TRUE),						
						'penetapan_penunjukan_mediator' => $tanggal,
						'dimulai_mediasi' => $tanggal,
						'diperbaharui_oleh' => $this->session->userdata('username'),
						'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
					);
				$data_add1 = array(
						'id' => $id_perkara_mediator,
						'perkara_id' => $idperkara,
						'tanggal_penetapan' => $tanggal,
						'nomor_sk_penetapan' => $this->input->post('sk_penetapan_mediator',TRUE),						
						'mediator_id' => $idmediator,
						'status_mediator' => $status_mediator,
						'nama_mediator' => $nama_mediator,
						'aktif' => 'Y',
						'keterangan' => $this->input->post('keterangan',TRUE),								
						'diinput_oleh' => $this->session->userdata('username'),
						'diinput_tanggal' => date("Y-m-d h:i:s",time())
					);
				$data_edit1 = array(
						'tanggal_penetapan' => $tanggal,
						'nomor_sk_penetapan' => $this->input->post('sk_penetapan_mediator',TRUE),						
						'mediator_id' => $idmediator,
						'status_mediator' => $status_mediator,
						'nama_mediator' => $nama_mediator,
						'aktif' => 'Y',
						'keterangan' => $this->input->post('keterangan',TRUE),								
						'diperbaharui_oleh' => $this->session->userdata('username'),
						'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
					);
				$this->load->model('mediasi/jadwal_mediasi_m','jadwalmediasi');
				$urutanmax = $this->jadwalmediasi->get_urutan_jadwal_mediasi_terakhir($id_mediasi_awal);
				$urutanjadwal =  $urutanmax->row()->urutan + 1;

				$idmax = $this->jadwalmediasi->get_id_jadwal_mediasi_terakhir();
				$idjadwalberikutnya=$idmax->row()->id + 1;

				$data_jadwal=array(
						'id' => $idjadwalberikutnya,
						'mediasi_id' => $id_mediasi_awal,
						'urutan' => $urutanjadwal,
						'tanggal_mediasi' => $tanggal,
						'tempat' => 'Ditentukan Kemudian',
						'diinput_oleh' => $this->session->userdata('username'),
						'diinput_tanggal' => date("Y-m-d h:i:s",time())
					);

				if ($jns=='1'){
					$data_add['jenis_mediasi'] = 1;
				}elseif ($jns=='2'||$jns=='3'){
					$data_add['jenis_mediasi'] = 2;
				}


				if ($act=='e'){
					$result = $this->mediasi->edit_mediasi($data_edit,$mediasi_id);
					$result = $this->mediasi->edit_p_mediator($data_edit1,$mediasi_id);
				}else{
					$result = $this->mediasi->add_mediasi($data_add);
					$result = $this->mediasi->add_perkara_mediator($data_add1);
					$result = $this->jadwalmediasi->add_jadwal_mediasi($data_jadwal);
				}

				if($result==FALSE){
					echo json_encode(array('st'=>0,'msg'=>'GAGAL Menyimpan'));
					return;
				}else{
					if(!empty($idmediator)){
						$urutan=$this->input->post('urutan',TRUE);
						$this->mediasi->cancelproses($idperkara,110,$urutan);
						$this->mediasi->updateproses($idperkara,110,$tanggal,$urutan);

						$this->mediasi->cancelproses($idperkara,120,$urutan);
						$this->mediasi->updateproses($idperkara,120,$tanggal,$urutan);

						$this->mediasi->cancelproses($idperkara,121,$urutan);
						$this->mediasi->updateproses($idperkara,121,$tanggal,$urutan);
					}
				}
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
				return;
			}
		}
	}

	function update_hasil_mediasi(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$this->form_validation->set_rules('hasil_mediasi', 'Hasil Mediasi', 'trim|xss_clean|exact_length[1]');
		$this->form_validation->set_rules('keterangan', 'Keterangan', 'trim|xss_clean|min_length[5]');
		$this->form_validation->set_rules('tgl_laporan_mediator', 'Tanggal Laporan Mediator', 'trim|xss_clean|exact_length[10]');		

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$urutan=$this->input->post('urutan',TRUE);
			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			if(!is_numeric($idperkara)){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Perkara Tidak ditemukan. Code Error = 194.'));
				return;
			}else{
				$mediasi_id = $this->encrypt->decode(base64_decode($this->input->post('mediasi_id',TRUE)));
				$tgl_laporan_mediator = $this->input->post('tgl_laporan_mediator',TRUE);
				if (!empty($tgl_laporan_mediator)){
					$tgl_hasil_mediasi = $this->input->post('tgl_hasil_mediasi',TRUE);
				}else{
					$tgl_hasil_mediasi = NULL;
				}
				$hasil_mediasi = trim($this->input->post('hasil_mediasi',TRUE));

				$isi_akta_perdamaian_text = trim($this->input->post('isi_akta_perdamaian_text',TRUE));
				$isi_akta_perdamaian_text = str_replace("&nbsp;", " ", $isi_akta_perdamaian_text);
				$this->load->model('mediasi/mediasi_m','mediasi');
				$curr_date = date('Y-m-d');
				$todayDate = date('d/m/Y');

				$data_add = array(
						'keputusan_mediasi' => $tgl_hasil_mediasi,
						'catatan_mediasi' => $this->input->post('keterangan',TRUE),
						'diinput_oleh' => $this->session->userdata('username'),
						'diinput_tanggal' => date("Y-m-d h:i:s",time())
					);

				if (!empty($tgl_laporan_mediator)){
					$tgl_laporan_mediator = $this->tanggalhelper->convertToMysqlDate($tgl_laporan_mediator);

					$selisih = $this->tanggalhelper->getSelisihHari($tgl_laporan_mediator,$curr_date);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Laporan Mediator Tidak Boleh Melebihi Hari ini. Hari ini Tanggal '.$todayDate));
						return;
					}
			
					$selisih = $this->tanggalhelper->getSelisihHari($tgl_hasil_mediasi,$tgl_laporan_mediator);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Laporan Mediator Tidak Boleh Kurang Dari Tanggal Hasil Mediasi'));
						return;
					}

					if (empty($hasil_mediasi)){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Apabila Tanggal Laporan Mediator Terisi, Maka Harus Memilih Hasil Mediasi'));
						return;
					}
					
					$data_add['tgl_laporan_mediator'] = $tgl_laporan_mediator;
				}else{
					$data_add['tgl_laporan_mediator']=NULL;
				}

				if(!empty($hasil_mediasi) && $hasil_mediasi!='-'){
					if (empty($tgl_laporan_mediator)){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Laporan Mediator Tidak Boleh Kosong Apabila Telah Terdapat Hasil Mediasi'));
						return;
					}

					if ($hasil_mediasi==='Y'||$hasil_mediasi==='S'){
						$tglaktaperdamaian = $this->input->post('tgl_akta_perdamaian',TRUE);
						if (!empty($tglaktaperdamaian)){
							$tglaktaperdamaian = $this->tanggalhelper->convertToMysqlDate($tglaktaperdamaian);
							$selisih = $this->tanggalhelper->getSelisihHari($tgl_laporan_mediator,$tglaktaperdamaian);
							if($selisih<0){
								echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Akta Perdamaian Mediasi Tidak Boleh Kurang Dari Tanggal Laporan Mediator'));
								return;
							}

							$selisih = $this->tanggalhelper->getSelisihHari($tglaktaperdamaian,$curr_date);
							if($selisih<0){
								echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Akta Perdamaian Mediasi Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
								return;
							}

							$dayName = $this->tanggalhelper->getDayName($tglaktaperdamaian);
							if($dayName=="Sunday" OR $dayName=="Saturday"){
								echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat memilih Tanggal Akta Perdamaian Mediasi diluar hari kerja (Sabtu - Minggu).'));
								return;
							}

							if (empty($isi_akta_perdamaian_text)){
								echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Isi Akta Perdamaian Tidak Boleh Kosong Apabila Terdapat Tanggal Akta Perdamaian.'));
								return;
							}
						}else{
							$tglaktaperdamaian=NULL;
						}

						$data_add['akta_perdamaian'] = $tglaktaperdamaian;

						if (!empty($isi_akta_perdamaian_text)){
							if(strlen($isi_akta_perdamaian_text)<50){
								echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Isi Akta Perdamaian Tidak Boleh kurang dari 50 Karakter'));
								return;
							}elseif (empty($tglaktaperdamaian)){
								echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Akta Perdamaian Tidak Boleh Kosong Apabila Terdapat Isi Akta Perdamaian'));
								return;
							}
						}else{
							$isi_akta_perdamaian_text='';
						}	
						$data_add['isi_akta_perdamaian'] = $isi_akta_perdamaian_text;

						$keterangannya=$this->input->post('keterangan',TRUE);
						if (empty($tglaktaperdamaian)&&empty($isi_akta_perdamaian_text)&&empty($keterangannya)){
							echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Anda Tidak Mengisi Tanggal Dan Isi Akta Perdamaian.<br/><u>Berikan Penjelasan Pada Kolom Keterangan</u>.'));
							return;
						}
					}
				}

				$data_add['hasil_mediasi'] = $hasil_mediasi;

				if (empty($hasil_mediasi)||$hasil_mediasi==='D'||$hasil_mediasi==='T'){
					$data_add['akta_perdamaian']=NULL;
					$data_add['isi_akta_perdamaian']='';
					$data_add['isi_akta_perdamaian_dok']='';
				}

				$result = $this->mediasi->edit_mediasi($data_add,$mediasi_id);
				if($result==FALSE){
					echo json_encode(array('st'=>0,'msg'=>'GAGAL Menyimpan'));
					return;
				}else{
					$this->mediasi->cancelproses($idperkara,200,$urutan);
					$this->mediasi->cancelproses($idperkara,190,$urutan);
					$this->mediasi->cancelproses($idperkara,181,$urutan);
					$this->mediasi->cancelproses($idperkara,180,$urutan);
					$this->mediasi->cancelproses($idperkara,151,$urutan);
					$this->mediasi->cancelproses($idperkara,150,$urutan);
					$this->mediasi->cancelproses($idperkara,130,$urutan);							

					if (!empty($tgl_hasil_mediasi)){
						$this->mediasi->updateproses($idperkara,130,$tgl_hasil_mediasi,$urutan);
					}

					if($hasil_mediasi=='T'){
						$this->mediasi->updateproses($idperkara,150,$tgl_hasil_mediasi,$urutan);
						$this->mediasi->updateproses($idperkara,200,$tgl_hasil_mediasi,$urutan);
					}elseif($hasil_mediasi=='D'){
						$this->mediasi->updateproses($idperkara,151,$tgl_hasil_mediasi,$urutan);
						$this->mediasi->updateproses($idperkara,200,$tgl_hasil_mediasi,$urutan);
					}elseif($hasil_mediasi=='Y'){
						//$this->mediasi->cancelproses($idperkara,180,$urutan);
						$this->mediasi->updateproses($idperkara,180,$tgl_hasil_mediasi,$urutan);
					}elseif($hasil_mediasi=='S'){
						//$this->mediasi->cancelproses($idperkara,181,$urutan);
						$this->mediasi->updateproses($idperkara,181,$tgl_hasil_mediasi,$urutan);
					}
					
					if(!empty($tglaktaperdamaian)){
						$this->mediasi->updateproses($idperkara,190,$tglaktaperdamaian,$urutan);
					}
				}
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
				return;
			}
		}		
	}

	function ckeditor(){
		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '775px';
		$this->ckeditor->config['height'] = '250px';
	}
}