<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Pihak_list_up_ht_termohon extends CI_Controller {
	function index(){
		#add authorization check hak akses di pihak
		#
		if($this->session->userdata('is_logged_in')===FALSE){
			redirect('login');
		}
		$pageNumber = $this->nativesession->get_flash_session('pageNumber_pihak');
		if(empty($pageNumber)){
			$pageNumber = 1;
			$begin = 0;
		}else{
			$begin = ($pageNumber-1)*30;
		}
		$segment = $this->uri->segment_array();
		$data['isorangtuawali'] = 1;
		$data['enc_id'] = '';
		$data['enc_anak'] = '';
		$data['jenis_pihak'] = '';
		if(count($segment)==5){
			if($segment[3]=='ortu'){
				$data['enc_id'] = $segment[2];
				$data['enc_anak'] = $segment[4];
				$data['jenis_pihak'] = $segment[5];
				$data['isorangtuawali'] = 2;
			}
		}

		$keyword = $this->nativesession->get_flash_session('keyword_pihak');
		$this->load->model('pihak/list_pihak', 'pihak');
		$data['pihak'] = $this->pihak->getListPihak(9,'DESC',$begin,$keyword);
		$data['total_rows'] = $this->pihak->fecth_data_num();
		$data['page_number'] = $pageNumber;
		$data['current_date'] = date('d/m/Y');
		$data['counter'] = $begin;
		$data['keyword'] = $keyword;
		$data['country'] = $this->pihak->getListCountry();
		$data['agama'] = $this->pihak->getListAgama();
		$data['pendidikan'] = $this->pihak->getListPendidikan();
		$this->load->vars($data);
		$this->load->view('pihak/pihak_list_up_ht_termohon');
	}

	function addOrtu(){
		if(empty($_POST)){
			show_404();
		}
		$idPihak = $this->encrypt->decode(base64_decode($this->input->post('val',TRUE)));
		if(is_numeric($idPihak)){
			if($idPihak>0){
				$data = $this->fetchPihak(1);
				if($data['isFound']==0){
					echo json_encode(array('st'=>0,'msg'=>'Error, Data Tidak Ditemukan.'));
					return;
				}elseif($data['isLengkap']==0){
					echo json_encode(array('st'=>0,'msg'=>'Data Tidak Lengkap, Data <b>'.$data['notFill'].'</b> Tidak Ada. Silahkan Lengkapi terlebih dahulu. Klik Edit.'));
					return;
				}else{
					$idAnak = $this->encrypt->decode(base64_decode($this->input->post('enc_anak',TRUE)));
					
					if(!is_numeric($idAnak) OR empty($idAnak)){
						echo json_encode(array('st'=>0,'msg'=>'Error, Data Anak Tidak Ditemukan.'));
						return;
					}
					$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
					if(!is_numeric($idperkara) OR empty($idperkara)){
						echo json_encode(array('st'=>0,'msg'=>'Error, Data Perkara Tidak Ditemukan.'));
						return;
					}

					$jenisPihak = $this->input->post('jenis_pihak',TRUE);
					if(!is_numeric($jenisPihak)){
						echo json_encode(array('st'=>0,'msg'=>'Error, Data Jenis Pihak Tidak Ditemukan.'));
						return;
					}
					if($jenisPihak<0 AND $jenisPihak>1){
						echo json_encode(array('st'=>0,'msg'=>'Error, Data Jenis Pihak Tidak Sesuai.'));
						return;
					}
					$this->load->model('pihak/list_pihak', 'pihak');
					$data_ortu = array(
						'id_anak' => $idAnak,
						'id_orang_tua' => $idPihak,
						'perkara_id' => $idperkara,
						'jenis_pihak_anak' => $jenisPihak
					);
					$result = $this->pihak->add_data_ortu($data_ortu);
					if($result===TRUE){
						echo json_encode(array('st'=>1,'msg'=>'Orang Tua Wali Berhasil Disimpan'));
						return;
					}else{
						echo json_encode(array('st'=>0,'msg'=>'ERROR, Orang Tua Wali TIDAK Berhasil Disimpan'));
						return;
					}
				}
			}
		}
	}
	function fetchPihak($status=0){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Please Refresh Your Page'));
			return;
		}
		$idPihak = $this->encrypt->decode(base64_decode($this->input->post('val',TRUE)));
		if(is_numeric($idPihak)){
			if($idPihak>0){
				$this->load->model('pihak/list_pihak', 'pihak');
				$result = $this->pihak->getInfoPihak($idPihak);
				if($result!=''){
					if($result->num_rows()>0){
						foreach ($result->result() as $row) {
							$id = base64_encode($this->encrypt->encode($row->id));
							$nama = $row->nama;
							$alamat = $row->alamat;
							$pekerjaan = $row->pekerjaan;
							$tglLahir = $row->tanggal_lahir;
							$tempatLahir = $row->tempat_lahir;
							$jenisPihak = $row->jenis_pihak;
							$IDJenisPihak = $row->jenis_pihak_id;
							$jenisIdentitas = $row->jenis_indentitas;
							$noIdentitas = $row->nomor_indentitas;
							$golDarah = $row->golongan_darah;
							$agama = $row->agama;
							$IDAgama = $row->agama_id;
							$IDStatusKawin = $row->status_kawin_id;
							if($row->jenis_kelamin=='L'){
								$sex = 'Laki Laki';
								$IDSex = 1;
							}elseif($row->jenis_kelamin=='P'){
								$sex = 'Perempuan';
								$IDSex = 2;
							}else{
								$sex='';
								$IDSex = 0;
							}
							$wargaNegara = $row->warga_negara;
							$IDWargaNegara = $row->warga_negara_id;
							$kawin = $row->status_kawin;
							$pendidikan = $row->pendidikan;
							$IDPendidikan = $row->pendidikan_id;
							$keterangan = $row->keterangan;
							$difabel = $row->difabel;
							$difabel = ($difabel=='Y')? 'Ya':'Tidak';
							if(!empty($tglLahir)){
								$umur = $this->tanggalhelper->getSelisihTahun($tglLahir,date('Y-m-d'));
							}else{
								$umur = "";
							}
						}
						
						$isLengkap = 1;
						$notFill ='error';
						if(empty($id)){
							$isLengkap = 0;
							$notFill ='enc_id';
						}
						if(empty($jenisPihak)){
							$isLengkap = 0;
							$notFill ='Jenis Pihak';
						}
						if(empty($nama)){
							$isLengkap = 0;
							$notFill ='Nama';
						}
						if(empty($tempatLahir)){
							//$isLengkap = 0;
							$notFill ='Tempat Lahir';
						}
						if(empty($tglLahir)){
							//$isLengkap = 0;
							$notFill ='Tanggal Lahir';
						}
						if(empty($sex)){
							$isLengkap = 0;
							$notFill ='Jenis Kelamin';
						}
						if(empty($wargaNegara)){
							$isLengkap = 0;
							$notFill ='Warga Negara';
						}
						if(empty($alamat)){
							$isLengkap = 0;
							$notFill ='Alamat';
						}
						if(empty($pekerjaan)){
							$isLengkap = 0;
							$notFill ='Pekerjaan';
						}
						if(empty($pendidikan)){
							//$isLengkap = 0;
							$notFill ='Pendidikan';
						}
						if(empty($kawin)){
							$isLengkap = 0;
							$notFill ='Status Perkawinan';
						}

						if($status==1){
							$data['isFound'] = 1;
							$data['isLengkap'] = $isLengkap;
							$data['notFill'] = $notFill;
							$data['nama'] = $nama;
							return $data;
						}
						if($IDJenisPihak!=1){
							$isLengkap = 1;
						}
						echo json_encode(array(
							'st'=>1,
							'isLengkap'=>$isLengkap,
							'notFill'=>$notFill,
							'enc_pihak'=>$id,
							'nama'=>$nama,
							'jenisPihak'=>$jenisPihak,
							'IDJenisPihak'=>$IDJenisPihak,
							'tempatLahir'=>$tempatLahir,
							'tglLahir'=>(!empty($tglLahir))? $this->tanggalhelper->convertToInputDate($tglLahir):'',
							'umur'=>$umur,
							'sex'=>$sex,
							'IDSex'=>$IDSex,
							'pekerjaan'=>$pekerjaan,
							'kawin'=>$kawin,
							'statusKawin'=>$kawin,
							'IDStatusKawin'=>$IDStatusKawin,
							'pendidikan'=>$pendidikan,
							'IDPendidikan'=>$IDPendidikan,
							'keterangan'=>$keterangan,
							'jenisIdentitas'=>$jenisIdentitas,
							'noIdentitas'=>$noIdentitas,
							'agama'=>$agama,
							'IDAgama'=>$IDAgama,
							'wargaNegara'=>$wargaNegara,
							'IDWargaNegara'=>$IDWargaNegara,
							'alamat'=>$alamat,
							'difabel'=>$difabel,
							'golDarah'=>$golDarah,
							'enc_act' =>base64_encode($this->encrypt->encode('add'))
							));
						return;
					}
				}else{
					if($status==1){
						$data['isFound'] = 0;
						$data['isLengkap'] = 1;
						$data['notFill'] = '';
						$data['nama'] = 'Error';
						return $data;
					}
					echo json_encode(array('st'=>0,'msg'=>'Error, Data Tidak Ditemukan.'));
					return;
				}
			}
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error, Please Refresh Your Page'));
			return;
		}
	}


	function validateInput(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$nama = trim($this->input->post('pihak_fullname',TRUE));
		$_POST['pihak_fullname'] = str_replace(' ', '', $_POST['pihak_fullname']);
		
		$tempatLahir = trim($this->input->post('pihak_tempat_lahir',TRUE));
		$_POST['pihak_tempat_lahir'] = str_replace(' ', '', $_POST['pihak_tempat_lahir']);

		$this->form_validation->set_rules('pihak_jenis_pihak', 'Jenis Pihak', 'trim|required|numeric|xss_clean');
		$this->form_validation->set_rules('pihak_fullname', 'Nama Lengkap', 'trim|required|alpha|xss_clean|valid_naming');
		$this->form_validation->set_rules('pihak_tempat_lahir', 'Tempat Lahir', 'trim|required|alpha|min_length[5]|xss_clean');
		$this->form_validation->set_rules('pihak_tgl_lahir', 'Tanggal Lahir', 'trim|required|exact_length[10]|xss_clean');
		$this->form_validation->set_rules('pihak_umur', 'Umur Pihak', 'trim|numeric|xss_clean');
		
		$this->form_validation->set_rules('pihak_jenis_identitas', 'Jenis Identitas', 'trim|numeric|xss_clean');
		$this->form_validation->set_rules('pihak_no_identitas', 'No Identitas', 'trim|xss_clean');
		
		$this->form_validation->set_rules('pihak_jenis_kelamin', 'Jenis Kelamin', 'trim|required|numeric|xss_clean');
		$this->form_validation->set_rules('pihak_agama', 'Agama', 'trim|required|numeric|xss_clean');
		$this->form_validation->set_rules('pihak_warga_negara', 'Warga Negara', 'trim|required|numeric|xss_clean');
		$this->form_validation->set_rules('pihak_alamat', 'Alamat', 'trim|required|min_length[15]|xss_clean');
		$this->form_validation->set_rules('pihak_pekerjaan', 'Pekerjaan', 'trim|required|min_length[5]|xss_clean');
		$this->form_validation->set_rules('pihak_status_kawin', 'Status Kawin', 'trim|required|numeric|xss_clean');
		$this->form_validation->set_rules('pihak_pendidikan', 'Tingkat Pendidikan', 'trim|required|numeric|xss_clean');
		$this->form_validation->set_rules('pihak_keterangan', 'pihak_keterangan', 'trim|xss_clean');
		$this->form_validation->set_rules('pihak_email', 'Alamat Email', 'trim|valid_email|xss_clean');
		$this->form_validation->set_rules('pihak_no_tlp', 'No Telepon', 'trim|numeric|min_length[5]|xss_clean');
		
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$jenisPihak = $this->input->post('pihak_jenis_pihak',TRUE);
			if($jenisPihak<1 AND $jenisPihak>3){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Jenis Pihak Tidak Diketahui.'));
				return;
			}

			$sex = $this->input->post('pihak_jenis_kelamin',TRUE);
			if($sex<1 AND $sex>3){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Jenis Kelamin Tidak Diketahui.'));
				return;
			}

			if($sex==1){
				$sex='L';
			}elseif ($sex==2) {
				$sex='P';
			}

			$agama = $this->input->post('pihak_agama',TRUE);
			if($agama<1 AND $agama>7){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Agama Tidak Diketahui.'));
				return;
			}

			$pekerjaan = $this->input->post('pihak_pekerjaan',TRUE);
			/*
			if($pekerjaan<1 AND $pekerjaan>88){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Jenis Pekerjaan Tidak Diketahui.'));
				return;
			}*/

			$statusKawin = $this->input->post('pihak_status_kawin',TRUE);
			if($statusKawin<1 AND $statusKawin>4){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Status Kawin Tidak Diketahui.'));
				return;
			}

			$pendidikan = $this->input->post('pihak_pendidikan',TRUE);
			if($pendidikan<1 AND $pendidikan>11){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tingkat Pendidikan Tidak Diketahui.'));
				return;
			}
			


			$act = $this->input->post('act',TRUE);
			$tglLahir = $this->tanggalhelper->convertToMysqlDate($this->input->post('pihak_tgl_lahir',TRUE));
			$umur=$this->input->post('pihak_umur',TRUE);
			if($umur>100 OR $umur<5){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Periksa Kembali Umur Pihak.'.$umur));
				return;
			}

			$curr_date = date('Y-m-d');
			$selisih = $this->tanggalhelper->getSelisihHari($tglLahir,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Periksa Kembali Tanggal Lahir.'));
				return;
			}
			$data_pihak = array(
					'nama' => $nama,
					'jenis_pihak_id' => $jenisPihak,
					'jenis_indentitas' => $this->input->post('pihak_jenis_identitas',TRUE),
					'nomor_indentitas' => $this->input->post('pihak_no_identitas',TRUE),
					'tempat_lahir' => $tempatLahir,
					'tanggal_lahir' => $tglLahir,
					'jenis_kelamin' => $sex,
					'golongan_darah' => $this->input->post('pihak_gol_darah',TRUE),
					'alamat' => trim($this->input->post('pihak_alamat',TRUE)),
					'agama_id' => $agama,
					'status_kawin' => $statusKawin,
					'difabel' => trim($this->input->post('pihak_difabel',TRUE)),
					'pekerjaan' => trim($pekerjaan),
					'pendidikan_id' => $pendidikan,
					'telepon' => trim($this->input->post('pihak_no_tlp',TRUE)),
					'email' => trim($this->input->post('pihak_email',TRUE)),
					'keterangan' => trim($this->input->post('pihak_keterangan',TRUE)),
					'warga_negara_id' => $this->input->post('pihak_warga_negara',TRUE)
				);
			if($act==="add"){
				$data_pihak['diinput_oleh'] = $this->session->userdata('username');
				$data_pihak['diinput_tanggal'] = date("Y-m-d h:i:s",time());
				$this->load->model('pihak/list_pihak', 'pihak');
				$query = $this->pihak->add_data($data_pihak);
				if($query==TRUE){
					echo json_encode(array('st'=>1,'msg'=>'Berhasil<br /> Data Berhasil Disimpan.'));
					return;
				}else{
					echo json_encode(array('st'=>0,'msg'=>'Error<br /> Coba Ulangi Kembali. Error Code 198'));
					return;
				}
			}elseif ($act==="updt") {
				$idPihak = $this->encrypt->decode(base64_decode($this->input->post('pihak_id',TRUE)));
				if(!is_numeric($idPihak) OR empty($idPihak)){
					echo json_encode(array('st'=>0,'msg'=>'Error:<br /> System Error, Please refresh your browser.Error Code 199'));
				}else{
					$data_pihak['diperbaharui_oleh'] = $this->session->userdata('username');
					$data_pihak['diperbaharui_tanggal'] = date("Y-m-d h:i:s",time());
					$this->load->model('pihak/list_pihak', 'pihak');
					$query = $this->pihak->update_data($data_pihak,$idPihak);
					if($query==TRUE){
						echo json_encode(array('st'=>1,'msg'=>'Berhasil<br /> Data Berhasil Disimpan.'));
						return;
					}else{
						echo json_encode(array('st'=>0,'msg'=>'Error<br /> Coba Ulangi Kembali. Error Code 198'));
						return;
					}
				}
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> System Error, Please refresh your browser.Error Code 199'.$act));
			}
		}
	}

	function setPage(){
		if(empty($_POST)){
			show_404();
		}
		$pageNumber = $this->input->post('pageNumber',TRUE);
		$keyword = $this->input->post('keyword',TRUE);
		if(is_numeric($pageNumber) AND $pageNumber>0){
			$this->nativesession->set_flash_session('security', TRUE);
			$this->nativesession->set_flash_session('pageNumber_pihak', $pageNumber);
			$this->nativesession->set_flash_session('keyword_pihak', $keyword);
			echo json_encode(array('st'=>1));
		}else{
			show_404();
		}
	}

	function searchPage(){
		if(empty($_POST)){
			show_404();
		}
		$keyword = $this->input->post('keyword_pihak',TRUE);
		$column = $this->input->post('search_field',TRUE);
		$this->nativesession->set_flash_session('security', TRUE);
		$this->nativesession->set_flash_session('keyword_pihak', $keyword);
		$this->nativesession->set_flash_session('column', $column);
		echo json_encode(array('st'=>1));
	}
}