<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Perkara_grasi extends CI_Controller {

	#TAMPIL FORM GRASI - UPDATE 2/6/2015
	function add_grasi(){
		if($this->nativesession->is_flash_session('security')===FALSE){
			redirect('main');
		}
		$sec = $this->nativesession->get_flash_session('security');

		if($this->session->userdata('is_logged_in')===FALSE){
			redirect('login');
		}
		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '99%';
		$this->ckeditor->config['height'] = '200px';
		$data['page_title'] = 'TAMBAH PERMOHONAN GRASI';
		$data['main_body'] = 'perkara/new_grasi';
		$data['history'] = $this->nativesession->get_flash_session('main_url_requested');
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}

	function show_data_grasi_tab(){
		$perkara_id = $this->nativesession->get_flash_session('perkara_id');
			
		$this->load->model('perkara/grasi','perkara');
		$rowGrasi = $this->perkara->mDetilGrasiPerkaraId($perkara_id);
		if($rowGrasi->num_rows()==0){
			echo json_encode(array('st'=>0,'msg'=>'Kesalahan, Refresh Browser'));
			return;
		} else {
			#
			$data['id'] = base64_encode($this->encrypt->encode($rowGrasi->row()->id));
			$data['perkara_id'] = base64_encode($this->encrypt->encode($rowGrasi->row()->perkara_id));
			$data['nomor_perkara_pn'] = $rowGrasi->row()->nomor_perkara_pn;
			$data['putusan_pn'] = $this->perkara->parsingTanggalView($rowGrasi->row()->putusan_pn);
			$data['nomor_perkara_banding'] = $rowGrasi->row()->nomor_perkara_banding;
			$data['putusan_banding'] = $this->perkara->parsingTanggalView($rowGrasi->row()->putusan_banding);
			$data['nomor_perkara_kasasi'] = $rowGrasi->row()->nomor_perkara_kasasi;
			$data['putusan_kasasi'] = $this->perkara->parsingTanggalView($rowGrasi->row()->putusan_kasasi);
			$data['nomor_perkara_pk'] = $rowGrasi->row()->nomor_perkara_pk;
			$data['putusan_pk'] = $this->perkara->parsingTanggalView($rowGrasi->row()->putusan_pk);
			$data['permohonan_grasi'] = $this->perkara->parsingTanggalView($rowGrasi->row()->permohonan_grasi);
			$data['permohonan_penundaan_pidana'] = $this->perkara->parsingTanggalView($rowGrasi->row()->permohonan_penundaan_pidana);
			$data['terdakwa_id'] = base64_encode($this->encrypt->encode($rowGrasi->row()->terdakwa_id));
			$data['terdakwa_nama'] = $this->templatehelper->standradnaming($rowGrasi->row()->terdakwa_nama);
			$data['pemohon_id'] = base64_encode($this->encrypt->encode($rowGrasi->row()->pemohon_id));
			$data['pemohon_nama'] = $this->templatehelper->standradnaming($rowGrasi->row()->pemohon_nama);
			$data['pemohon_pangkat'] = $this->templatehelper->standradnaming($rowGrasi->row()->pemohon_pangkat);
			$data['pemohon_nrp'] = $this->templatehelper->standradnaming($rowGrasi->row()->pemohon_nrp);
			$data['pemohon_jabatan'] = $this->templatehelper->standradnaming($rowGrasi->row()->pemohon_jabatan);
			$data['pemohon_kesatuan'] = $this->templatehelper->standradnaming($rowGrasi->row()->pemohon_kesatuan);
			$data['pemohon_pekerjaan'] = $this->templatehelper->standradnaming($rowGrasi->row()->pemohon_pekerjaan);
			$data['pemohon_alamat'] = $rowGrasi->row()->pemohon_alamat;
			$data['pemohon_grasi'] = $rowGrasi->row()->pemohon_grasi;
			$data['pemberitahuan_putusan_tetap'] = $this->perkara->parsingTanggalView($rowGrasi->row()->pemberitahuan_putusan_tetap);
			$data['menjalani_pidana_pengganti'] = $this->perkara->parsingSeleksi('1',$rowGrasi->row()->menjalani_pidana_pengganti);
			$data['terpidana_dalam_tahanan'] = $this->perkara->parsingSeleksi('1',$rowGrasi->row()->terpidana_dalam_tahanan);
			$data['denda_dibayar'] = $this->perkara->parsingSeleksi('1',$rowGrasi->row()->denda_dibayar);
			$data['barang_rampasan'] = $this->perkara->parsingSeleksi('2',$rowGrasi->row()->barang_rampasan);
			$data['tanggal_pertimbangan_hakim'] = $this->perkara->parsingTanggalView($rowGrasi->row()->tanggal_pertimbangan_hakim);
			$data['isi_perimbangan_hakim'] = $rowGrasi->row()->isi_perimbangan_hakim;
			$data['pengiriman_berkas_grasi_ke_kejaksaan'] = $this->perkara->parsingTanggalView($rowGrasi->row()->pengiriman_berkas_grasi_ke_kejaksaan);
			$data['no_pengiriman_berkas_grasi_ke_kejaksaan'] = $rowGrasi->row()->no_pengiriman_berkas_grasi_ke_kejaksaan;
			$data['pengiriman_berkas_grasi_ke_ma'] = $this->perkara->parsingTanggalView($rowGrasi->row()->pengiriman_berkas_grasi_ke_ma);
			$data['pengiriman_pertimbangan_hakim_grasi'] = $this->perkara->parsingTanggalView($rowGrasi->row()->pengiriman_pertimbangan_hakim_grasi);
			$data['tanggal_penerimaan_kembali_berkas_grasi'] = $this->perkara->parsingTanggalView($rowGrasi->row()->tanggal_penerimaan_kembali_berkas_grasi);
			$data['tanggal_putusan_grasi'] = $this->perkara->parsingTanggalView($rowGrasi->row()->tanggal_putusan_grasi);
			$data['status_putusan_grasi_id'] = $rowGrasi->row()->status_putusan_grasi_id;
			$data['status_putusan_grasi_text'] = $rowGrasi->row()->status_putusan_grasi_text;
			$data['nomor_putusan_grasi'] = $rowGrasi->row()->nomor_putusan_grasi;
			$data['amar_putusan_grasi'] = $rowGrasi->row()->amar_putusan_grasi;
			$data['pemberitahuan_putusan_grasi'] = $this->perkara->parsingTanggalView($rowGrasi->row()->pemberitahuan_putusan_grasi);
			$data['pemberitahuan_tembusan_grasi'] = $this->perkara->parsingTanggalView($rowGrasi->row()->pemberitahuan_tembusan_grasi);
			$data['catatan_putusan_grasi'] = $rowGrasi->row()->catatan_putusan_grasi;
			$data['page_title'] = 'INFORMASI DETIL - PERMOHONAN GRASI';
			
			$this->load->vars($data);
			$this->load->view('perkara_tab/grasi');

		}
	}


	#UPDATE 08/02/2016
	function edit_grasi_pertimbangan_ma(){
		if($this->session->userdata('is_logged_in')===FALSE){
			show_404();
		}
		$grasiId = $this->nativesession->get_flash_session('perkara_id');
		$this->load->model('perkara/grasi','perkara');
		$rowGrasi = $this->perkara->mDetilGrasi($grasiId);
		if($rowGrasi->num_rows()==0){
			show_404();
		} else {
			
			$perkara_id = $rowGrasi->row()->perkara_id;
			$data['curr_date'] = date('d/m/Y');
			$data['id'] = base64_encode($this->encrypt->encode($rowGrasi->row()->id));
			$data['perkara_id'] = base64_encode($this->encrypt->encode($rowGrasi->row()->perkara_id));
			$data['nomor_perkara_pn'] = $rowGrasi->row()->nomor_perkara_pn;
			$data['putusan_pn'] = $this->perkara->parsingTanggalEdit($rowGrasi->row()->putusan_pn);
			$data['nomor_perkara_banding'] = $rowGrasi->row()->nomor_perkara_banding;
			$data['putusan_banding'] = $this->perkara->parsingTanggalEdit($rowGrasi->row()->putusan_banding);
			$data['nomor_perkara_kasasi'] = $rowGrasi->row()->nomor_perkara_kasasi;
			$data['putusan_kasasi'] = $this->perkara->parsingTanggalEdit($rowGrasi->row()->putusan_kasasi);
			$data['nomor_perkara_pk'] = $rowGrasi->row()->nomor_perkara_pk;
			$data['putusan_pk'] = $this->perkara->parsingTanggalEdit($rowGrasi->row()->putusan_pk);
			$data['permohonan_grasi'] = $rowGrasi->row()->permohonan_grasi;
			$data['tanggal_pertimbangan_hakim'] = $this->perkara->parsingTanggalEdit($rowGrasi->row()->tanggal_pertimbangan_hakim);
			$data['isi_perimbangan_hakim'] = $rowGrasi->row()->isi_perimbangan_hakim;
			#LOAD CKEDITOR
			$this->load->library('ckeditor');
			$this->ckeditor->basePath = base_url().'resources/ckeditor/';
			$this->ckeditor->config['toolbar'] = array(
				array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
					'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
						'-', 'RemoveFormat','-', 'Blockquote',
						'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
						'-','Undo','Redo','-','NumberedList','BulletedList','/',
						'-','Image'),
				array('-','Format', 'Font', 'FontSize',
					'-','TextColor', 'BGColor','Table',
					'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
					'-','Print','Preview'
					));
			$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
			$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
			$this->ckeditor->config['resize'] = 'false';
			$this->ckeditor->config['language'] = 'en';
			$this->ckeditor->config['width'] = '99%';
			$this->ckeditor->config['height'] = '200px';
			#
			$data['page_title'] = '';
			$data['judul_popup'] = 'EDIT PERMOHONAN GRASI - PERTIMBANGAN MAHKAMAH AGUNG';
			$data['main_body'] = 'perkara/grasi/edit_grasi_pertimbangan_ma';
			$data['previous'] = $this->nativesession->get_flash_session('url_requested');
			$this->load->vars($data);
			
			$this->load->view('body/body_new');
		}
	}

	#UPDATE 08/02/2016
	function validasiUpdateGrasiPertimbanganMA(){
		if(empty($_POST)){ show_404(); }
			
		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu'));
			return;
		}
		
		$this->form_validation->set_rules('id', 'ID Grasi', 'trim|required|xss_clean');
		$this->form_validation->set_rules('nomor_perkara_pn', 'Nomor Perkara Tingkat Pertama', 'trim|required|xss_clean');
		$this->form_validation->set_rules('perkara_id', 'ID Perkara', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tanggal_pertimbangan_ma', 'Tanggal Pertimbangan MA', 'trim|xss_clean');
		
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Kesalahan : Tidak Berhasil | '.validation_errors().'<br/>'));
		} else {
			$this->load->model('perkara/grasi','perkara');
				
			$pertimbangan_ma = filter_var($_POST['isi_petimbangan_ma_text'],FILTER_SANITIZE_STRING);
			$pertimbangan_ma = trim($pertimbangan_ma);
				
			$pertimbangan_ma = htmlentities($pertimbangan_ma, null, 'utf-8');
			$pertimbangan_ma = str_replace("&nbsp;", " ", $pertimbangan_ma);


			#VARIABEL
			$grasi_id = $this->encrypt->decode(base64_decode($this->input->post('id',TRUE)));
			$perkara_id = $this->encrypt->decode(base64_decode($this->input->post('perkara_id',TRUE)));
			$tanggal_pertimbangan_hakim = $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_pertimbangan_ma',TRUE));
			
			$dataGrasi = array(
				   'tanggal_pertimbangan_hakim' => $tanggal_pertimbangan_hakim,
				   'isi_perimbangan_hakim' => $pertimbangan_ma,
				   'diperbaharui_oleh' => $this->session->userdata('username'),
				   'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
				);
			$nomor_perkara_pn = $this->input->post('nomor_perkara_pn',TRUE);
			$this->db->where('id',$grasi_id);
			$this->db->update('perkara_grasi', $dataGrasi); 
			$title = "Edit DATA GRASI [Nomor Perkara=<b>".$nomor_perkara_pn."</b>]<br />Edit table <b>perkara_grasi</b> dari halaman <b>edit_grasi</b>";
			$descrip = $this->perkara->fetch_description($title,$_POST);
			$this->perkara->add_audittrail("INSERT",$title,$descrip,'perkara_grasi');
			echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Diperbaharui'));
			return;
		}
	}



	#UPDATE 08/02/2016
	function edit_grasi_putusan_presiden(){
		if($this->session->userdata('is_logged_in')===FALSE){
			show_404();
		}
		$grasiId = $this->nativesession->get_flash_session('perkara_id');
		$this->load->model('perkara/grasi','perkara');
		$rowGrasi = $this->perkara->mDetilGrasi($grasiId);
		if($rowGrasi->num_rows()==0){
			show_404();
		} else {
			$perkara_id = $rowGrasi->row()->perkara_id;
			$data['curr_date'] = date('d/m/Y');
			$data['id'] = base64_encode($this->encrypt->encode($rowGrasi->row()->id));
			$data['perkara_id'] = base64_encode($this->encrypt->encode($rowGrasi->row()->perkara_id));
			$data['tanggal_putusan_grasi'] = $this->perkara->parsingTanggalEdit($rowGrasi->row()->tanggal_putusan_grasi);
			$data['nomor_putusan_grasi'] = $rowGrasi->row()->nomor_putusan_grasi;
			$data['amar_putusan_grasi'] = $rowGrasi->row()->amar_putusan_grasi;
			$data['pemberitahuan_putusan_grasi'] = $rowGrasi->row()->pemberitahuan_putusan_grasi;
			$data['pemberitahuan_tembusan_grasi'] = $rowGrasi->row()->pemberitahuan_tembusan_grasi;

			#LOAD CKEDITOR
			$this->load->library('ckeditor');
			$this->ckeditor->basePath = base_url().'resources/ckeditor/';
			$this->ckeditor->config['toolbar'] = array(
				array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
					'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
						'-', 'RemoveFormat','-', 'Blockquote',
						'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
						'-','Undo','Redo','-','NumberedList','BulletedList','/',
						'-','Image'),
				array('-','Format', 'Font', 'FontSize',
					'-','TextColor', 'BGColor','Table',
					'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
					'-','Print','Preview'
					));
			$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
			$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
			$this->ckeditor->config['resize'] = 'false';
			$this->ckeditor->config['language'] = 'en';
			$this->ckeditor->config['width'] = '99%';
			$this->ckeditor->config['height'] = '200px';
			#
			$data['page_title'] = '';
			$data['judul_popup'] = 'EDIT PERMOHONAN GRASI - PUTUSAN PRESIDEN';
			$data['main_body'] = 'perkara/grasi/edit_grasi_putusan_presiden';
			$data['previous'] = $this->nativesession->get_flash_session('url_requested');
			$this->load->vars($data);
			$this->load->view('body/body_new');
		}
	}


	#UPDATE 08/02/2016
	function validasiUpdateGrasiPutusanPresiden(){
		if(empty($_POST)){ show_404(); }
			
		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu'));
			return;
		}
		
		$pemohon_pekerjaan = $this->input->post('pekerjaan_pemohon',TRUE);
		$this->form_validation->set_rules('id', 'ID Grasi', 'trim|required|xss_clean');
		$this->form_validation->set_rules('perkara_id', 'ID Perkara', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tanggal_putusan_presiden', 'Tanggal Putusan Presiden', 'trim|required|xss_clean');
		$this->form_validation->set_rules('nomor_putusan_presiden', 'Nomor Putusan Presiden', 'trim|required|xss_clean');
		
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Kesalahan : Tidak Berhasil <br/> '.validation_errors().'<br/>'));
		} else {
			$this->load->model('perkara/grasi','perkara');
				
			$putusan_presiden = filter_var($_POST['isi_putusan_presiden_text'],FILTER_SANITIZE_STRING);
			$putusan_presiden = trim($putusan_presiden);

			$putusan_presiden = htmlentities($putusan_presiden, null, 'utf-8');
			$putusan_presiden = str_replace("&nbsp;", " ", $putusan_presiden);

			#VARIABEL
			$grasi_id = $this->encrypt->decode(base64_decode($this->input->post('id',TRUE)));
			$perkara_id = $this->encrypt->decode(base64_decode($this->input->post('perkara_id',TRUE)));
			$tanggal_putusan_grasi = $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_putusan_presiden',TRUE));
			$nomor_putusan_grasi = $this->input->post('nomor_putusan_presiden',TRUE);
				
			$dataGrasi = array(
				   'tanggal_putusan_grasi' => $tanggal_putusan_grasi,
				   'nomor_putusan_grasi' => $nomor_putusan_grasi,
				   'amar_putusan_grasi' => $putusan_presiden,
				   'diperbaharui_oleh' => $this->session->userdata('username'),
				   'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			   );

			$this->db->where('id',$grasi_id);
			$this->db->update('perkara_grasi', $dataGrasi); 
			$title = "Edit DATA GRASI [id Perkara=<b>".$perkara_id."</b>]<br />Edit table <b>perkara_grasi</b> dari halaman <b>edit_grasi</b>";
			$descrip = $this->perkara->fetch_description($title,$_POST);
			$this->perkara->add_audittrail("INSERT",$title,$descrip,'perkara_grasi');
					
			$rowTanggalPutusanGrasi = $this->perkara->perkaraProses($perkara_id,'680');
			if($rowTanggalPutusanGrasi->num_rows==0){ 
				if(!empty($tanggal_putusan_grasi)) {
					$data=array(
						'perkara_id'=> $perkara_id,
						'tahapan_id'=> '60',
						'tahapan_nama'=> 'Grasi',
						'proses_id'=> '680',
						'proses_nama'=> 'Putusan Grasi',
						'tanggal'=>  $tanggal_putusan_grasi,
						'diinput_oleh'=> $this->session->userdata('username'),
						'diinput_tanggal'=> date("Y-m-d h:i:s",time()) 
					);
					$this->db->insert('perkara_proses',$data); 
					$this->perkara->updateTabelPerkara($perkara_id,'60','Grasi','680','Putusan Grasi');
				}
			} else {
				if(!empty($tanggal_putusan_grasi)) {
					$data=array(
						'tanggal'=>  $tanggal_putusan_grasi,
						'diperbaharui_oleh'=> $this->session->userdata('username'),
						'diperbaharui_tanggal'=> date("Y-m-d h:i:s",time()) 
					);
					$this->db->where('perkara_id',$perkara_id);
					$this->db->where('proses_id','680');
					$this->db->update('perkara_proses', $data);
				}
			}
			echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Diperbaharui'));
			#return;
		}
	}




	#UPDATE 2/6/2015
	function edit_grasi(){
		if($this->session->userdata('is_logged_in')===FALSE){
			show_404();
		}
		$grasiId = $this->nativesession->get_flash_session('perkara_id');
		$this->load->model('perkara/grasi','perkara');
		$rowGrasi = $this->perkara->mDetilGrasi($grasiId);
		if($rowGrasi->num_rows()==0){
			show_404();
		} else {
			
			$perkara_id = $rowGrasi->row()->perkara_id;
			$data['curr_date'] = date('d/m/Y');
			$data['id'] = base64_encode($this->encrypt->encode($rowGrasi->row()->id));
			$data['perkara_id'] = base64_encode($this->encrypt->encode($rowGrasi->row()->perkara_id));
			$data['alur_perkara_id'] = base64_encode($this->encrypt->encode($rowGrasi->row()->alur_perkara_id));
			$data['nomor_perkara_pn'] = $rowGrasi->row()->nomor_perkara_pn;
			$data['putusan_pn'] = $this->perkara->parsingTanggalEdit($rowGrasi->row()->putusan_pn);
			$data['nomor_perkara_banding'] = $rowGrasi->row()->nomor_perkara_banding;
			$data['putusan_banding'] = $this->perkara->parsingTanggalEdit($rowGrasi->row()->putusan_banding);
			$data['nomor_perkara_kasasi'] = $rowGrasi->row()->nomor_perkara_kasasi;
			$data['putusan_kasasi'] = $this->perkara->parsingTanggalEdit($rowGrasi->row()->putusan_kasasi);
			$data['nomor_perkara_pk'] = $rowGrasi->row()->nomor_perkara_pk;
			$data['putusan_pk'] = $this->perkara->parsingTanggalEdit($rowGrasi->row()->putusan_pk);
			$data['permohonan_grasi'] = $this->perkara->parsingTanggalEdit($rowGrasi->row()->permohonan_grasi);
			$data['permohonan_penundaan_pidana'] = $this->perkara->parsingTanggalEdit($rowGrasi->row()->permohonan_penundaan_pidana);
			$data['terdakwa_id'] = base64_encode($this->encrypt->encode($rowGrasi->row()->terdakwa_id));
			$data['terdakwa_nama'] = $this->templatehelper->standradnaming($rowGrasi->row()->terdakwa_nama);
			$data['pemohon_id'] = base64_encode($this->encrypt->encode($rowGrasi->row()->pemohon_id));
			$data['pemohon_nama'] = $this->templatehelper->standradnaming($rowGrasi->row()->pemohon_nama);
			$data['pemohon_pangkat'] = $this->templatehelper->standradnaming($rowGrasi->row()->pemohon_pangkat);
			$data['pemohon_nrp'] = $this->templatehelper->standradnaming($rowGrasi->row()->pemohon_nrp);
			$data['pemohon_jabatan'] = $this->templatehelper->standradnaming($rowGrasi->row()->pemohon_jabatan);
			$data['pemohon_kesatuan'] = $this->templatehelper->standradnaming($rowGrasi->row()->pemohon_kesatuan);
			$data['pemohon_pekerjaan'] = $this->templatehelper->standradnaming($rowGrasi->row()->pemohon_pekerjaan);
			$data['pemohon_alamat'] = $rowGrasi->row()->pemohon_alamat;
			$data['pemohon_grasi'] = $rowGrasi->row()->pemohon_grasi;
			$data['pemberitahuan_putusan_tetap'] = $this->perkara->parsingTanggalEdit($rowGrasi->row()->pemberitahuan_putusan_tetap);
			$data['menjalani_pidana_pengganti'] = $this->perkara->parsingSeleksi('1',$rowGrasi->row()->menjalani_pidana_pengganti);
			$data['terpidana_dalam_tahanan'] = $this->perkara->parsingSeleksi('1',$rowGrasi->row()->terpidana_dalam_tahanan);
			$data['denda_dibayar'] = $this->perkara->parsingSeleksi('1',$rowGrasi->row()->denda_dibayar);
			$data['barang_rampasan'] = $this->perkara->parsingSeleksi('2',$rowGrasi->row()->barang_rampasan);
			$data['tanggal_pertimbangan_hakim'] = $this->perkara->parsingTanggalEdit($rowGrasi->row()->tanggal_pertimbangan_hakim);
			$data['isi_perimbangan_hakim'] = $rowGrasi->row()->isi_perimbangan_hakim;
			$data['pengiriman_berkas_grasi_ke_kejaksaan'] = $this->perkara->parsingTanggalEdit($rowGrasi->row()->pengiriman_berkas_grasi_ke_kejaksaan);
			$data['no_pengiriman_berkas_grasi_ke_kejaksaan'] = $rowGrasi->row()->no_pengiriman_berkas_grasi_ke_kejaksaan;
			$data['pengiriman_berkas_grasi_ke_ma'] = $this->perkara->parsingTanggalEdit($rowGrasi->row()->pengiriman_berkas_grasi_ke_ma);
			$data['no_pengiriman_berkas_grasi_ke_ma'] = $rowGrasi->row()->no_pengiriman_berkas_grasi_ke_ma;
			$data['pengiriman_pertimbangan_hakim_grasi'] = $this->perkara->parsingTanggalEdit($rowGrasi->row()->pengiriman_pertimbangan_hakim_grasi);
			$data['tanggal_penerimaan_kembali_berkas_grasi'] = $this->perkara->parsingTanggalEdit($rowGrasi->row()->tanggal_penerimaan_kembali_berkas_grasi);
			$data['tanggal_putusan_grasi'] = $this->perkara->parsingTanggalEdit($rowGrasi->row()->tanggal_putusan_grasi);
			$data['status_putusan_grasi_id'] = $rowGrasi->row()->status_putusan_grasi_id;
			$data['status_putusan_grasi_text'] = $rowGrasi->row()->status_putusan_grasi_text;
			$data['nomor_putusan_grasi'] = $rowGrasi->row()->nomor_putusan_grasi;
			$data['amar_putusan_grasi'] = $rowGrasi->row()->amar_putusan_grasi;
			$data['pemberitahuan_putusan_grasi'] = $this->perkara->parsingTanggalEdit($rowGrasi->row()->pemberitahuan_putusan_grasi);
			$data['pemberitahuan_tembusan_grasi'] = $this->perkara->parsingTanggalEdit($rowGrasi->row()->pemberitahuan_tembusan_grasi);
			$data['catatan_putusan_grasi'] = $rowGrasi->row()->catatan_putusan_grasi;
			$data['terdakwa'] = $this->perkara->pihak2($perkara_id);
			#LOAD CKEDITOR
			$this->load->library('ckeditor');
			$this->ckeditor->basePath = base_url().'resources/ckeditor/';
			$this->ckeditor->config['toolbar'] = array(
				array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
					'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
						'-', 'RemoveFormat','-', 'Blockquote',
						'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
						'-','Undo','Redo','-','NumberedList','BulletedList','/',
						'-','Image'),
				array('-','Format', 'Font', 'FontSize',
					'-','TextColor', 'BGColor','Table',
					'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
					'-','Print','Preview'
					));
			$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
			$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
			$this->ckeditor->config['resize'] = 'false';
			$this->ckeditor->config['language'] = 'en';
			$this->ckeditor->config['width'] = '100%';
			$this->ckeditor->config['height'] = '200px';
			#
			$data['page_title'] = '';
			$data['judul_popup'] = 'EDIT PERMOHONAN GRASI';
			$data['main_body'] = 'perkara/grasi/edit_grasi';
			$data['previous'] = $this->nativesession->get_flash_session('url_requested');
			$this->load->vars($data);
			
			$this->load->view('body/body_new');
		}
	}

	#UPDATE 2/6/2015
	function validasiInsertGrasi(){
		if(empty($_POST)){ show_404(); }

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu'));
			return;
		}

		$this->load->model('perkara/grasi','perkara');
		$this->form_validation->set_rules('perkara_id', 'Perkara ID', 'trim|required|xss_clean');
		$this->form_validation->set_rules('alur_perkara_id', 'Alur Perkara ID', 'trim|required|xss_clean');
		$this->form_validation->set_rules('nomor_perkara', 'Nomor Perkara', 'trim|required|xss_clean');
		$this->form_validation->set_rules('putusan_pn', 'Putusan Tingkat Pertama', 'trim|xss_clean');
		$this->form_validation->set_rules('putusan_banding', 'Putusan Banding', 'trim|xss_clean');
		$this->form_validation->set_rules('nomor_perkara_banding', 'Nomor Perkara Banding', 'trim|xss_clean');
		$this->form_validation->set_rules('nomor_perkara_kasasi', 'Nomor Perkara Kasasi', 'trim|xss_clean');
		$this->form_validation->set_rules('putusan_kasasi', 'Putusan Kasasi', 'trim|xss_clean');
		$this->form_validation->set_rules('nomor_perkara_pk', 'Nomor Perkara PK', 'trim|xss_clean');
		$this->form_validation->set_rules('putusan_pk', 'Putusan PK', 'trim|xss_clean');
		$this->form_validation->set_rules('permohonan_grasi', 'Permohonan Grasi', 'trim|required|xss_clean');
		$this->form_validation->set_rules('permohonan_penundaan_pidana', 'Permohonan Penundaan Pidana', 'trim|xss_clean');
		$this->form_validation->set_rules('terdakwa_id', 'ID Terdakwa', 'trim|required|xss_clean');
		$this->form_validation->set_rules('enc_pemohon', 'ID Pemohon', 'trim|required|xss_clean');
		$this->form_validation->set_rules('nama_pemohon', 'Nama Pemohon', 'trim|required|xss_clean');
		$this->form_validation->set_rules('pekerjaan_pemohon', 'Pekerjaan Pemohon', 'trim|required|xss_clean');
		$this->form_validation->set_rules('alamat_pemohon', 'Alamat Pemohon', 'trim|required|xss_clean');
		$this->form_validation->set_rules('pemberitahuan_putusan_tetap', 'Pemberitahuan Putusan Tetap', 'trim|xss_clean');
		$this->form_validation->set_rules('status_pidana_pengganti', 'Status Pidana Pengganti', 'trim|required|xss_clean');
		$this->form_validation->set_rules('status_terpidana_tahanan', 'Status Tahanan', 'trim|required|xss_clean');
		$this->form_validation->set_rules('status_terpidana_denda', 'Status Denda', 'trim|required|xss_clean');
		$this->form_validation->set_rules('status_terpidana_barang_rampasan', 'Status Barang Rampasan', 'trim|xss_clean');
		$this->form_validation->set_rules('tanggal_pertimbangan_ma', 'Tanggal Pertimbangan MA', 'trim|xss_clean');
		$this->form_validation->set_rules('tanggal_pengiriman_berkas_kejaksaan', 'Tanggal Pengiriman Berkas ke Kejaksaan', 'trim|xss_clean');
		$this->form_validation->set_rules('nomor_pengiriman_berkas_kejaksaan', 'Nomor Pengiriman Berkas Ke Kejaksaan', 'trim|xss_clean');
		$this->form_validation->set_rules('tanggal_pengiriman_berkas_ma', 'Tanggal Pengiriman Berkas ke MA', 'trim|xss_clean');
		$this->form_validation->set_rules('nomor_pengiriman_berkas_ma', 'Nomor Pengiriman Berkas ke MA', 'trim|xss_clean');
		$this->form_validation->set_rules('tanggal_pengiriman_pertimbangan_hakim', 'Tanggal Pengiriman Pertimbangan Hakim', 'trim|xss_clean');
		$this->form_validation->set_rules('tanggal_putusan_presiden', 'Tanggal Putusan Presiden', 'trim|xss_clean');
		$this->form_validation->set_rules('nomor_putusan_presiden', 'Nomor Putusan Presiden', 'trim|xss_clean');
		$this->form_validation->set_rules('tanggal_penerimaan_kembali_berkas', 'Tanggal Penerimaan Kembali Berkas', 'trim|xss_clean');
		$this->form_validation->set_rules('tanggal_pemberitahuan_putusan_grasi', 'Tanggal Pemberitahuan Putusan Grasi', 'trim|xss_clean');
		$this->form_validation->set_rules('tanggal_terima_tembusan_pelaksanaan_putusan', 'Tanggal Terima Tembusan Pelaksanaan Putusan', 'trim|xss_clean');
		$this->form_validation->set_rules('keterangan', 'Keterangan', 'trim|xss_clean');
			
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Kesalahan : Tidak Berhasil | '.validation_errors().'<br/>'));
		} else {
						
			$pertimbangan_ma = filter_var($_POST['isi_petimbangan_ma'],FILTER_SANITIZE_STRING);
			$pertimbangan_ma = trim($pertimbangan_ma);
			
			$pertimbangan_ma = htmlentities($pertimbangan_ma, null, 'utf-8');
			$pertimbangan_ma = str_replace("&nbsp;", " ", $pertimbangan_ma);


			$putusan_presiden = filter_var($_POST['isi_putusan_presiden'],FILTER_SANITIZE_STRING);
			$putusan_presiden = trim($putusan_presiden);

			$putusan_presiden = htmlentities($putusan_presiden, null, 'utf-8');
			$putusan_presiden = str_replace("&nbsp;", " ", $putusan_presiden);

			$keterangan_grasi = filter_var($_POST['keterangan'],FILTER_SANITIZE_STRING);
			$keterangan_grasi = trim($keterangan_grasi);

			$keterangan_grasi = htmlentities($keterangan_grasi, null, 'utf-8');
			$keterangan_grasi = str_replace("&nbsp;", " ", $keterangan_grasi);

			#VARIABEL
			$terdakwa_id = $this->encrypt->decode(base64_decode($this->input->post('terdakwa_id',TRUE)));
			$perkara_id = $this->encrypt->decode(base64_decode($this->input->post('perkara_id',TRUE)));
			$pemohon_id = $this->encrypt->decode(base64_decode($this->input->post('enc_pemohon',TRUE)));
			$alur_perkara_id = $this->encrypt->decode(base64_decode($this->input->post('alur_perkara_id',TRUE)));
			$nomor_perkara_pn = $this->input->post('nomor_perkara',TRUE);
			$putusan_pn = $this->tanggalhelper->convertToMysqlDate($this->input->post('putusan_pn',TRUE));
			$nomor_perkara_banding = $this->input->post('nomor_perkara_banding',TRUE);
			$putusan_banding = $this->tanggalhelper->convertToMysqlDate($this->input->post('putusan_banding',TRUE));
			$nomor_perkara_kasasi = $this->input->post('nomor_perkara_kasasi',TRUE);
			$putusan_kasasi = $this->tanggalhelper->convertToMysqlDate($this->input->post('putusan_kasasi',TRUE));
			$nomor_perkara_pk = $this->input->post('nomor_perkara_pk',TRUE);
			$putusan_pk = $this->tanggalhelper->convertToMysqlDate($this->input->post('putusan_pk',TRUE));
			$pemohon_nama = $this->input->post('nama_pemohon',TRUE);
			$pemohon_pekerjaan = $this->input->post('pekerjaan_pemohon',TRUE);
			$pemohon_alamat = $this->input->post('alamat_pemohon',TRUE);
			$pemberitahuan_putusan_tetap = $this->tanggalhelper->convertToMysqlDate($this->input->post('pemberitahuan_putusan_tetap',TRUE));
			$menjalani_pidana_pengganti = $this->input->post('status_pidana_pengganti',TRUE);
			$terpidana_dalam_tahanan = $this->input->post('status_terpidana_tahanan',TRUE);
			$denda_dibayar = $this->input->post('status_terpidana_denda',TRUE);
			$barang_rampasan = $this->input->post('status_terpidana_barang_rampasan',TRUE);
			$tanggal_pertimbangan_hakim = $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_pertimbangan_ma',TRUE));
			$permohonan_grasi = $this->tanggalhelper->convertToMysqlDate($this->input->post('permohonan_grasi',TRUE));
			$permohonan_penundaan_pidana = $this->tanggalhelper->convertToMysqlDate($this->input->post('permohonan_penundaan_pidana',TRUE));
			$pengiriman_berkas_grasi_ke_kejaksaan = $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_pengiriman_berkas_kejaksaan',TRUE));
			$no_pengiriman_berkas_grasi_ke_kejaksaan = $this->input->post('nomor_pengiriman_berkas_kejaksaan',TRUE);
			$pengiriman_berkas_grasi_ke_ma = $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_pengiriman_berkas_ma',TRUE));
			$no_pengiriman_berkas_grasi_ke_ma = $this->input->post('nomor_pengiriman_berkas_ma',TRUE);
			$pengiriman_pertimbangan_hakim_grasi = $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_pengiriman_pertimbangan_hakim',TRUE));
			$tanggal_penerimaan_kembali_berkas_grasi = $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_penerimaan_kembali_berkas',TRUE));
			$tanggal_putusan_grasi = $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_putusan_presiden',TRUE));
			$nomor_putusan_grasi = $this->input->post('nomor_putusan_presiden',TRUE);
			$pemberitahuan_putusan_grasi = $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_pemberitahuan_putusan_grasi',TRUE));
			$pemberitahuan_tembusan_grasi = $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_terima_tembusan_pelaksanaan_putusan',TRUE));
			$terdakwa = $this->perkara->getDataPihak2($terdakwa_id);
			$terdakwa_nama = $this->templatehelper->standradnaming($terdakwa->row()->nama);

			$rowPerkara =  $this->perkara->getPerkaraGrasi($terdakwa_id);
			if($rowPerkara->num_rows >= 1){
				echo json_encode(array('st'=>0,'msg'=>'Kesalahan: Permohonan Grasi atas Nama Terdakwa '.$terdakwa_nama.' Sudah Diajukan'));
				return;
			}

			$rowPerkara =  $this->perkara->getPerkara($nomor_perkara_pn);
			$alur_perkara_id = $rowPerkara->row()->alur_perkara_id;
			$proses_terakhir_id = $rowPerkara->row()->proses_terakhir_id;
			if($alur_perkara_id < 100){
				echo json_encode(array('st'=>0,'msg'=>'Error; Perkara Perdata Tidak dapat dimohonkan Grasi'));
				return;
			}

			if(($proses_terakhir_id > 290)AND($proses_terakhir_id < 400)){
				echo json_encode(array('st'=>0,'msg'=>'Perkara Dalam Proses Upaya Hukum Banding Tidak dapat dimohonkan Grasi'));
				return;
			#Cek Tahapan Perkara Kasasi
			} else if (($proses_terakhir_id > 410)AND($proses_terakhir_id < 500)){
				echo json_encode(array('st'=>0,'msg'=>'Perkara Dalam Proses Upaya Hukum Kasasi Tidak dapat dimohonkan Grasi'));
				return;
			#Cek Tahapan Perkara Peninjauan Kembali
			} else if (($proses_terakhir_id > 510)AND($proses_terakhir_id < 590)){
				echo json_encode(array('st'=>0,'msg'=>'Perkara Dalam Proses Upaya Hukum Peninjauan Kembali Tidak dapat dimohonkan Grasi'));
				return;
			}
				
			#DATA GRASI
			$dataGrasi = array(
			   		'perkara_id' => $perkara_id,
			   		'alur_perkara_id' => $alur_perkara_id,
			   		'nomor_perkara_pn' => $nomor_perkara_pn,
					'putusan_pn' => $putusan_pn,
					'nomor_perkara_banding' => $nomor_perkara_banding,
					'putusan_banding' => $putusan_banding,
			    	'nomor_perkara_kasasi' => $nomor_perkara_kasasi,
					'putusan_kasasi' => $putusan_kasasi,
				   	'nomor_perkara_pk' => $nomor_perkara_pk,
				   	'putusan_pk' => $putusan_pk,
				   	'permohonan_grasi' => $permohonan_grasi,
				   	'permohonan_penundaan_pidana' => $permohonan_penundaan_pidana,
				  	'terdakwa_id' => $terdakwa_id,
				   	'terdakwa_nama' => $terdakwa_nama,
				   	'pemohon_id' => $pemohon_id,
				    'pemohon_nama' => $pemohon_nama,
				   	'pemohon_pekerjaan' => $pemohon_pekerjaan,
				   	'pemohon_alamat' => $pemohon_alamat,
				   	'pemberitahuan_putusan_tetap' => $pemberitahuan_putusan_tetap,
				   	'menjalani_pidana_pengganti' => $menjalani_pidana_pengganti,
				   	'terpidana_dalam_tahanan' => $terpidana_dalam_tahanan,
				   	'denda_dibayar' => $denda_dibayar,
				   	'barang_rampasan' => $barang_rampasan,
				   	'tanggal_pertimbangan_hakim' => $tanggal_pertimbangan_hakim,
				   	'isi_perimbangan_hakim' => $pertimbangan_ma,
				   	'pengiriman_berkas_grasi_ke_kejaksaan' => $pengiriman_berkas_grasi_ke_kejaksaan,
				   	'no_pengiriman_berkas_grasi_ke_kejaksaan' => $no_pengiriman_berkas_grasi_ke_kejaksaan,
				   	'pengiriman_berkas_grasi_ke_ma' => $pengiriman_berkas_grasi_ke_ma,
				   	'no_pengiriman_berkas_grasi_ke_ma' => $no_pengiriman_berkas_grasi_ke_ma,
				   	'pengiriman_pertimbangan_hakim_grasi' => $pengiriman_pertimbangan_hakim_grasi,
				   	'tanggal_penerimaan_kembali_berkas_grasi' => $tanggal_penerimaan_kembali_berkas_grasi,
				   	'tanggal_putusan_grasi' => $tanggal_putusan_grasi,
				   	'nomor_putusan_grasi' => $nomor_putusan_grasi,
				   	'amar_putusan_grasi' => $putusan_presiden,
				   	'pemberitahuan_putusan_grasi' => $pemberitahuan_putusan_grasi,
				   	'pemberitahuan_tembusan_grasi' => $pemberitahuan_tembusan_grasi,
				   	'catatan_putusan_grasi' => $keterangan_grasi,
				   	'diinput_oleh' => $this->session->userdata('username'),
				   	'diinput_tanggal' => date("Y-m-d h:i:s",time())
				);
				//DODON - INSERT TO TABEL PERKARA GRASI
				$this->db->insert('perkara_grasi', $dataGrasi); 
				$title = "Tambah DATA GRASI [Nomor Perkara=<b>".$this->input->post('nomor_perkara',TRUE)."</b>]<br />Tambah table <b>perkara_grasi</b> dari halaman <b>new_grasi</b>";
				$descrip = $this->perkara->fetch_description($title,$_POST);
				$this->perkara->add_audittrail("INSERT",$title,$descrip,'perkara_grasi');

				##DODON - 2/6/2015
				$data=array(
					'perkara_id'=> $perkara_id,
					'tahapan_id'=> '60',
					'tahapan_nama'=> 'Grasi',
					'proses_id'=> '650',
					'proses_nama'=> 'Permohonan Grasi',
					'tanggal'=>  $permohonan_grasi,
					'diinput_oleh'=> $this->session->userdata('username'),
					'diinput_tanggal'=> date("Y-m-d h:i:s",time())
				);
				$this->db->replace('perkara_proses',$data); 
				$this->perkara->updateTabelPerkara($perkara_id,'60','Grasi','650','Permohonan Grasi');
				
				##DODON - 2/6/2015
				if(!empty($pengiriman_berkas_grasi_ke_kejaksaan)) {
					$data=array(
						'perkara_id'=> $perkara_id,
						'tahapan_id'=> '60',
						'tahapan_nama'=> 'Grasi',
						'proses_id'=> '660',
						'proses_nama'=> 'Pengiriman salinan permohonan grasi berikut berkas putusan dari Tingkat Pertama ke Kejaksaan',
						'tanggal'=>  $pengiriman_berkas_grasi_ke_kejaksaan,
						'diinput_oleh'=> $this->session->userdata('username'),
						'diinput_tanggal'=> date("Y-m-d h:i:s",time()) 
					);
					$this->db->insert('perkara_proses',$data); 
					$this->perkara->updateTabelPerkara($perkara_id,'60','Grasi','660','Pengiriman salinan permohonan grasi berikut berkas putusan dari Tingkat Pertama ke Kejaksaan');
				}

				##DODON - 2/6/2015
				if(!empty($pengiriman_berkas_grasi_ke_ma)) {
					$data=array(
						'perkara_id'=> $perkara_id,
						'tahapan_id'=> '60',
						'tahapan_nama'=> 'Grasi',
						'proses_id'=> '662',
						'proses_nama'=> 'Pengiriman salinan permohonan grasi berikut berkas putusan ke MA',
						'tanggal'=>  $pengiriman_berkas_grasi_ke_ma,
						'diinput_oleh'=> $this->session->userdata('username'),
						'diinput_tanggal'=> date("Y-m-d h:i:s",time()) 
					);
					$this->db->insert('perkara_proses',$data); 
					$this->perkara->updateTabelPerkara($perkara_id,'60','Grasi','662','Pengiriman salinan permohonan grasi berikut berkas putusan ke MA');
				}

				##DODON - 2/6/2015
				if(!empty($pengiriman_pertimbangan_hakim_grasi)) {
					$data=array(
						'perkara_id'=> $perkara_id,
						'tahapan_id'=> '60',
						'tahapan_nama'=> 'Grasi',
						'proses_id'=> '665',
						'proses_nama'=> 'Pengiriman pertimbangan berikut berkas perkara dari MA ke Presiden',
						'tanggal'=>  $pengiriman_pertimbangan_hakim_grasi,
						'diinput_oleh'=> $this->session->userdata('username'),
						'diinput_tanggal'=> date("Y-m-d h:i:s",time()) 
					);
					$this->db->insert('perkara_proses',$data); 
					$this->perkara->updateTabelPerkara($perkara_id,'60','Grasi','665','Pengiriman pertimbangan berikut berkas perkara dari MA ke Presiden');
				}

				##DODON - 2/6/2015
				if(!empty($tanggal_penerimaan_kembali_berkas_grasi)) {
					$data=array(
						'perkara_id'=> $perkara_id,
						'tahapan_id'=> '60',
						'tahapan_nama'=> 'Grasi',
						'proses_id'=> '670',
						'proses_nama'=> 'Penerimaan Kembali Berkas Grasi',
						'tanggal'=>  $tanggal_penerimaan_kembali_berkas_grasi,
						'diinput_oleh'=> $this->session->userdata('username'),
						'diinput_tanggal'=> date("Y-m-d h:i:s",time()) 
					);
					$this->db->insert('perkara_proses',$data); 
					$this->perkara->updateTabelPerkara($perkara_id,'60','Grasi','670','Penerimaan Kembali Berkas Grasi');
				}

				##DODON - 2/6/2015
				if(!empty($tanggal_putusan_grasi)) {
					$data=array(
						'perkara_id'=> $perkara_id,
						'tahapan_id'=> '60',
						'tahapan_nama'=> 'Grasi',
						'proses_id'=> '680',
						'proses_nama'=> 'Putusan Grasi',
						'tanggal'=>  $tanggal_putusan_grasi,
						'diinput_oleh'=> $this->session->userdata('username'),
						'diinput_tanggal'=> date("Y-m-d h:i:s",time()) 
					);
					$this->db->insert('perkara_proses',$data); 
					$this->perkara->updateTabelPerkara($perkara_id,'60','Grasi','680','Putusan Grasi');
				}

				##DODON - 2/6/2015
				if(!empty($pemberitahuan_putusan_grasi)) {
					$data=array(
						'perkara_id'=> $perkara_id,
						'tahapan_id'=> '60',
						'tahapan_nama'=> 'Grasi',
						'proses_id'=> '690',
						'proses_nama'=> 'Pemberitahuan Putusan Grasi',
						'tanggal'=>  $pemberitahuan_putusan_grasi,
						'diinput_oleh'=> $this->session->userdata('username'),
						'diinput_tanggal'=> date("Y-m-d h:i:s",time()) 
					);
					$this->db->insert('perkara_proses',$data); 
					$this->perkara->updateTabelPerkara($perkara_id,'60','Grasi','690','Pemberitahuan Putusan Grasi');
				}

				##DODON - 2/6/2015
				if(!empty($pemberitahuan_tembusan_grasi)) {
					$data=array(
						'perkara_id'=> $perkara_id,
						'tahapan_id'=> '60',
						'tahapan_nama'=> 'Grasi',
						'proses_id'=> '700',
						'proses_nama'=> 'Pemberitahuan Tembusan Putusan Grasi',
						'tanggal'=>  $pemberitahuan_tembusan_grasi,
						'diinput_oleh'=> $this->session->userdata('username'),
						'diinput_tanggal'=> date("Y-m-d h:i:s",time()) 
					);
					$this->db->insert('perkara_proses',$data); 
					$this->perkara->updateTabelPerkara($perkara_id,'60','Grasi','700','Pemberitahuan Tembusan Putusan Grasi');
				}
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Ditambahkan'));
				return;	
			}	
			
	}


	#UPDATE - 08/02/2016
	function validasiUpdateGrasi(){
		if(empty($_POST)){ show_404(); }
			
		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu'));
			return;
		}
		
		$pemohon_pekerjaan = $this->input->post('pekerjaan_pemohon',TRUE);
		if ($this->session->userdata('jenis_pengadilan')==2 && $pemohon_pekerjaan=='Tentara Nasional Indonesia'){
			$this->form_validation->set_rules('nrp_pemohon', 'NRP Pemohon', 'trim|required|xss_clean');
			$this->form_validation->set_rules('pangkat_pemohon', 'Pangkat Pemohon', 'trim|required|xss_clean');
			$this->form_validation->set_rules('jabatan_pemohon', 'Jabatan Pemohon', 'trim|required|xss_clean');
			$this->form_validation->set_rules('kesatuan_pemohon', 'Kesatuan Pemohon', 'trim|required|xss_clean');
		}
		
		$this->form_validation->set_rules('id', 'ID Grasi', 'trim|required|xss_clean');
		$this->form_validation->set_rules('nomor_perkara_pn', 'Nomor Perkara Tingkat Pertama', 'trim|required|xss_clean');
		$this->form_validation->set_rules('perkara_id', 'ID Perkara', 'trim|required|xss_clean');
		$this->form_validation->set_rules('alur_perkara_id', 'ID Alur Perkara', 'trim|required|xss_clean');
		$this->form_validation->set_rules('permohonan_grasi', 'Permohonan Grasi', 'trim|required|xss_clean');
		$this->form_validation->set_rules('permohonan_penundaan_pidana', 'Permohonan Penundaan Pidana', 'trim|xss_clean');
		$this->form_validation->set_rules('terdakwa_id', 'ID Terdakwa', 'trim|required|xss_clean');
		$this->form_validation->set_rules('enc_pemohon', 'ID Pemohon', 'trim|required|xss_clean');
		$this->form_validation->set_rules('nama_pemohon', 'Nama Pemohon', 'trim|required|xss_clean');
		$this->form_validation->set_rules('pekerjaan_pemohon', 'Pekerjaan Pemohon', 'trim|required|xss_clean');
		$this->form_validation->set_rules('alamat_pemohon', 'Alamat Pemohon', 'trim|required|xss_clean');
		$this->form_validation->set_rules('pemberitahuan_putusan_tetap', 'Pemberitahuan Putusan Tetap', 'trim|xss_clean');
		$this->form_validation->set_rules('status_pidana_pengganti', 'Status Pidana Pengganti', 'trim|xss_clean');
		$this->form_validation->set_rules('status_terpidana_tahanan', 'Status Tahanan', 'trim|xss_clean');
		$this->form_validation->set_rules('status_terpidana_denda', 'Status Denda', 'trim|xss_clean');
		$this->form_validation->set_rules('status_terpidana_barang_rampasan', 'Status Barang Rampasan', 'trim|xss_clean');
		$this->form_validation->set_rules('tanggal_pengiriman_berkas_kejaksaan', 'Tanggal Pengiriman Berkas ke Kejaksaan', 'trim|xss_clean');
		$this->form_validation->set_rules('nomor_pengiriman_berkas_kejaksaan', 'Nomor Pengiriman Berkas Ke Kejaksaan', 'trim|xss_clean');
		$this->form_validation->set_rules('tanggal_pengiriman_berkas_ma', 'Tanggal Pengiriman Berkas ke MA', 'trim|xss_clean');
		$this->form_validation->set_rules('nomor_pengiriman_berkas_ma', 'Nomor Pengiriman Berkas ke MA', 'trim|xss_clean');
		$this->form_validation->set_rules('tanggal_pengiriman_pertimbangan_hakim', 'Tanggal Pengiriman Pertimbangan Hakim', 'trim|xss_clean');
		$this->form_validation->set_rules('tanggal_penerimaan_kembali_berkas', 'Tanggal Penerimaan Kembali Berkas', 'trim|xss_clean');
		$this->form_validation->set_rules('tanggal_pemberitahuan_putusan_grasi', 'Tanggal Pemberitahuan Putusan Grasi', 'trim|xss_clean');
		$this->form_validation->set_rules('tanggal_terima_tembusan_pelaksanaan_putusan', 'Tanggal Terima Tembusan Pelaksanaan Putusan', 'trim|xss_clean');
		
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Kesalahan : Tidak Berhasil | '.validation_errors().'<br/>'));
		} else {
			$this->load->model('perkara/grasi','perkara');
				
			$keterangan_grasi = filter_var($_POST['keterangan_text'],FILTER_SANITIZE_STRING);
			$keterangan_grasi = trim($keterangan_grasi);

			$keterangan_grasi = htmlentities($keterangan_grasi, null, 'utf-8');
			$keterangan_grasi = str_replace("&nbsp;", " ", $keterangan_grasi);

			#VARIABEL
			$grasi_id = $this->encrypt->decode(base64_decode($this->input->post('id',TRUE)));
			$terdakwa_id = $this->encrypt->decode(base64_decode($this->input->post('terdakwa_id',TRUE)));
			$perkara_id = $this->encrypt->decode(base64_decode($this->input->post('perkara_id',TRUE)));
			$pemohon_id = $this->encrypt->decode(base64_decode($this->input->post('enc_pemohon',TRUE)));
			$alur_perkara_id = $this->encrypt->decode(base64_decode($this->input->post('alur_perkara_id',TRUE)));
			$nomor_perkara_pn = $this->input->post('nomor_perkara_pn',TRUE);
			$pemohon_nama = $this->input->post('nama_pemohon',TRUE);
			$pemohon_pekerjaan = $this->input->post('pekerjaan_pemohon',TRUE);
			if ($this->session->userdata('jenis_pengadilan')==2 && $pemohon_pekerjaan=='Tentara Nasional Indonesia'){
				$pemohon_nrp = $this->input->post('nrp_pemohon',TRUE);
				$pemohon_pangkat = $this->input->post('pangkat_pemohon',TRUE);
				$pemohon_jabatan = $this->input->post('jabatan_pemohon',TRUE);
				$pemohon_kesatuan = $this->input->post('kesatuan_pemohon',TRUE);
			}else{
				$pemohon_nrp = '';
				$pemohon_pangkat = '';
				$pemohon_jabatan = '';
				$pemohon_kesatuan = '';
			}
			

			$pemohon_alamat = $this->input->post('alamat_pemohon',TRUE);
			$pemberitahuan_putusan_tetap = $this->tanggalhelper->convertToMysqlDate($this->input->post('pemberitahuan_putusan_tetap',TRUE));
			$menjalani_pidana_pengganti = $this->input->post('status_pidana_pengganti',TRUE);
			$terpidana_dalam_tahanan = $this->input->post('status_terpidana_tahanan',TRUE);
			$denda_dibayar = $this->input->post('status_terpidana_denda',TRUE);
			$barang_rampasan = $this->input->post('status_terpidana_barang_rampasan',TRUE);
			$permohonan_grasi = $this->tanggalhelper->convertToMysqlDate($this->input->post('permohonan_grasi',TRUE));
			$permohonan_penundaan_pidana = $this->tanggalhelper->convertToMysqlDate($this->input->post('permohonan_penundaan_pidana',TRUE));
			$pengiriman_berkas_grasi_ke_kejaksaan = $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_pengiriman_berkas_kejaksaan',TRUE));
			$no_pengiriman_berkas_grasi_ke_kejaksaan = $this->input->post('nomor_pengiriman_berkas_kejaksaan',TRUE);
			$pengiriman_berkas_grasi_ke_ma = $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_pengiriman_berkas_ma',TRUE));
			$no_pengiriman_berkas_grasi_ke_ma = $this->input->post('nomor_pengiriman_berkas_ma',TRUE);
			$pengiriman_pertimbangan_hakim_grasi = $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_pengiriman_pertimbangan_hakim',TRUE));
			$tanggal_penerimaan_kembali_berkas_grasi = $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_penerimaan_kembali_berkas',TRUE));
			$pemberitahuan_putusan_grasi = $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_pemberitahuan_putusan_grasi',TRUE));
			$pemberitahuan_tembusan_grasi = $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_terima_tembusan_pelaksanaan_putusan',TRUE));
			$terdakwa = $this->perkara->getDataPihak2($terdakwa_id);
			$terdakwa_nama = $this->templatehelper->standradnaming($terdakwa->row()->nama);
				
			$dataGrasi = array(
				'permohonan_grasi' => $permohonan_grasi,
				'permohonan_penundaan_pidana' => $permohonan_penundaan_pidana,
				'terdakwa_id' => $terdakwa_id,
				'terdakwa_nama' => $terdakwa_nama,
				'pemohon_id' => $pemohon_id,
				'pemohon_nama' => $pemohon_nama,
				'pemohon_nrp' => $pemohon_nrp,
				'pemohon_pangkat' => $pemohon_pangkat,
				'pemohon_jabatan' => $pemohon_jabatan,
				'pemohon_kesatuan' => $pemohon_kesatuan,
				'pemohon_pekerjaan' => $pemohon_pekerjaan,
				'pemohon_alamat' => $pemohon_alamat,
				'pemberitahuan_putusan_tetap' => $pemberitahuan_putusan_tetap,
				'menjalani_pidana_pengganti' => $menjalani_pidana_pengganti,
				'terpidana_dalam_tahanan' => $terpidana_dalam_tahanan,
				'denda_dibayar' => $denda_dibayar,
				'barang_rampasan' => $barang_rampasan,
				'pengiriman_berkas_grasi_ke_kejaksaan' => $pengiriman_berkas_grasi_ke_kejaksaan,
				'no_pengiriman_berkas_grasi_ke_kejaksaan' => $no_pengiriman_berkas_grasi_ke_kejaksaan,
				'pengiriman_berkas_grasi_ke_ma' => $pengiriman_berkas_grasi_ke_ma,
				'no_pengiriman_berkas_grasi_ke_ma' => $no_pengiriman_berkas_grasi_ke_ma,
				'pengiriman_pertimbangan_hakim_grasi' => $pengiriman_pertimbangan_hakim_grasi,
				'tanggal_penerimaan_kembali_berkas_grasi' => $tanggal_penerimaan_kembali_berkas_grasi,
				'pemberitahuan_putusan_grasi' => $pemberitahuan_putusan_grasi,
				'pemberitahuan_tembusan_grasi' => $pemberitahuan_tembusan_grasi,
				'catatan_putusan_grasi' => $keterangan_grasi,
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			);

			$this->db->where('id',$grasi_id);
			$this->db->update('perkara_grasi', $dataGrasi); 
			$title = "Edit DATA GRASI [Nomor Perkara=<b>".$nomor_perkara_pn."</b>]<br />Edit table <b>perkara_grasi</b> dari halaman <b>edit_grasi</b>";
			$descrip = $this->perkara->fetch_description($title,$_POST);
			$this->perkara->add_audittrail("INSERT",$title,$descrip,'perkara_grasi');

			
			if(!empty($pengiriman_berkas_grasi_ke_kejaksaan)){
				$dataProses = $this->perkara->getDataProsesPerkara('660',$alur_perkara_id);
				$tahapan_id = $dataProses->row()->tahapan_id;
				$tahapan_nama = $dataProses->row()->tahapan_nama;
				$proses_id = $dataProses->row()->proses_id;
				$proses_nama = $dataProses->row()->proses_nama;
				$keterangan = $dataProses->row()->keterangan;
				$tanggal = $pengiriman_berkas_grasi_ke_kejaksaan;

				$cekData = $this->perkara->perkaraProses($perkara_id,$proses_id);
				if($cekData->num_rows==0){				
					$data=array(
						'perkara_id'=> $perkara_id,
						'tahapan_id'=> $tahapan_id,
						'tahapan_nama'=> $tahapan_nama,
						'proses_id'=> $proses_id,
						'proses_nama'=> $proses_nama,
						'tanggal'=>  $tanggal,
						'diinput_oleh'=> $this->session->userdata('username'),
						'diinput_tanggal'=> date("Y-m-d h:i:s",time()) 
					);
					$this->db->insert('perkara_proses',$data); 
					$this->perkara->updateTabelPerkara($perkara_id,$tahapan_id,$tahapan_nama,$proses_id,$proses_nama);
				} else {
					$data=array(
						'tanggal'=>  $tanggal,
						'diperbaharui_oleh'=> $this->session->userdata('username'),
						'diperbaharui_tanggal'=> date("Y-m-d h:i:s",time()) 
					);
					$this->db->where('perkara_id',$perkara_id);
					$this->db->where('proses_id',$proses_id);
					$this->db->update('perkara_proses', $data);
				}	
			} else {
				$this->db->simple_query("CALL perkara_proses_delete(".$perkara_id.",660);");
				$this->db->simple_query("CALL perkara_update_status(".$perkara_id.");");
			}


			if(!empty($pengiriman_berkas_grasi_ke_ma)){
				$dataProses = $this->perkara->getDataProsesPerkara('662',$alur_perkara_id);
				$tahapan_id = $dataProses->row()->tahapan_id;
				$tahapan_nama = $dataProses->row()->tahapan_nama;
				$proses_id = $dataProses->row()->proses_id;
				$proses_nama = $dataProses->row()->proses_nama;
				$keterangan = $dataProses->row()->keterangan;
				$tanggal = $pengiriman_berkas_grasi_ke_ma;

				$cekData = $this->perkara->perkaraProses($perkara_id,$proses_id);
				if($cekData->num_rows==0){				
					$data=array(
						'perkara_id'=> $perkara_id,
						'tahapan_id'=> $tahapan_id,
						'tahapan_nama'=> $tahapan_nama,
						'proses_id'=> $proses_id,
						'proses_nama'=> $proses_nama,
						'tanggal'=>  $tanggal,
						'diinput_oleh'=> $this->session->userdata('username'),
						'diinput_tanggal'=> date("Y-m-d h:i:s",time()) 
					);
					$this->db->insert('perkara_proses',$data); 
					$this->perkara->updateTabelPerkara($perkara_id,$tahapan_id,$tahapan_nama,$proses_id,$proses_nama);
				} else {
					$data=array(
						'tanggal'=>  $tanggal,
						'diperbaharui_oleh'=> $this->session->userdata('username'),
						'diperbaharui_tanggal'=> date("Y-m-d h:i:s",time()) 
					);
					$this->db->where('perkara_id',$perkara_id);
					$this->db->where('proses_id',$proses_id);
					$this->db->update('perkara_proses', $data);
				}	
			} else {
				$this->db->simple_query("CALL perkara_proses_delete(".$perkara_id.",662);");
				$this->db->simple_query("CALL perkara_update_status(".$perkara_id.");");
			}


			if(!empty($pengiriman_pertimbangan_hakim_grasi)){
				$dataProses = $this->perkara->getDataProsesPerkara('665',$alur_perkara_id);
				$tahapan_id = $dataProses->row()->tahapan_id;
				$tahapan_nama = $dataProses->row()->tahapan_nama;
				$proses_id = $dataProses->row()->proses_id;
				$proses_nama = $dataProses->row()->proses_nama;
				$keterangan = $dataProses->row()->keterangan;
				$tanggal = $pengiriman_pertimbangan_hakim_grasi;

				$cekData = $this->perkara->perkaraProses($perkara_id,$proses_id);
				if($cekData->num_rows==0){				
					$data=array(
						'perkara_id'=> $perkara_id,
						'tahapan_id'=> $tahapan_id,
						'tahapan_nama'=> $tahapan_nama,
						'proses_id'=> $proses_id,
						'proses_nama'=> $proses_nama,
						'tanggal'=>  $tanggal,
						'diinput_oleh'=> $this->session->userdata('username'),
						'diinput_tanggal'=> date("Y-m-d h:i:s",time()) 
					);
					$this->db->insert('perkara_proses',$data); 
					$this->perkara->updateTabelPerkara($perkara_id,$tahapan_id,$tahapan_nama,$proses_id,$proses_nama);
				} else {
					$data=array(
						'tanggal'=>  $tanggal,
						'diperbaharui_oleh'=> $this->session->userdata('username'),
						'diperbaharui_tanggal'=> date("Y-m-d h:i:s",time()) 
					);
					$this->db->where('perkara_id',$perkara_id);
					$this->db->where('proses_id',$proses_id);
					$this->db->update('perkara_proses', $data);
				}	
			} else {
				$this->db->simple_query("CALL perkara_proses_delete(".$perkara_id.",665);");
				$this->db->simple_query("CALL perkara_update_status(".$perkara_id.");");
			}


			if(!empty($tanggal_penerimaan_kembali_berkas_grasi)){
				$dataProses = $this->perkara->getDataProsesPerkara('670',$alur_perkara_id);
				$tahapan_id = $dataProses->row()->tahapan_id;
				$tahapan_nama = $dataProses->row()->tahapan_nama;
				$proses_id = $dataProses->row()->proses_id;
				$proses_nama = $dataProses->row()->proses_nama;
				$keterangan = $dataProses->row()->keterangan;
				$tanggal = $tanggal_penerimaan_kembali_berkas_grasi;

				$cekData = $this->perkara->perkaraProses($perkara_id,$proses_id);
				if($cekData->num_rows==0){				
					$data=array(
						'perkara_id'=> $perkara_id,
						'tahapan_id'=> $tahapan_id,
						'tahapan_nama'=> $tahapan_nama,
						'proses_id'=> $proses_id,
						'proses_nama'=> $proses_nama,
						'tanggal'=>  $tanggal,
						'diinput_oleh'=> $this->session->userdata('username'),
						'diinput_tanggal'=> date("Y-m-d h:i:s",time()) 
					);
					$this->db->insert('perkara_proses',$data); 
					$this->perkara->updateTabelPerkara($perkara_id,$tahapan_id,$tahapan_nama,$proses_id,$proses_nama);
				} else {
					$data=array(
						'tanggal'=>  $tanggal,
						'diperbaharui_oleh'=> $this->session->userdata('username'),
						'diperbaharui_tanggal'=> date("Y-m-d h:i:s",time()) 
					);
					$this->db->where('perkara_id',$perkara_id);
					$this->db->where('proses_id',$proses_id);
					$this->db->update('perkara_proses', $data);
				}	
			} else {
				$this->db->simple_query("CALL perkara_proses_delete(".$perkara_id.",670);");
				$this->db->simple_query("CALL perkara_update_status(".$perkara_id.");");
			}


			if(!empty($pemberitahuan_putusan_grasi)){
				$dataProses = $this->perkara->getDataProsesPerkara('690',$alur_perkara_id);
				$tahapan_id = $dataProses->row()->tahapan_id;
				$tahapan_nama = $dataProses->row()->tahapan_nama;
				$proses_id = $dataProses->row()->proses_id;
				$proses_nama = $dataProses->row()->proses_nama;
				$keterangan = $dataProses->row()->keterangan;
				$tanggal = $pemberitahuan_putusan_grasi;

				$cekData = $this->perkara->perkaraProses($perkara_id,$proses_id);
				if($cekData->num_rows==0){				
					$data=array(
						'perkara_id'=> $perkara_id,
						'tahapan_id'=> $tahapan_id,
						'tahapan_nama'=> $tahapan_nama,
						'proses_id'=> $proses_id,
						'proses_nama'=> $proses_nama,
						'tanggal'=>  $tanggal,
						'diinput_oleh'=> $this->session->userdata('username'),
						'diinput_tanggal'=> date("Y-m-d h:i:s",time()) 
					);
					$this->db->insert('perkara_proses',$data); 
					$this->perkara->updateTabelPerkara($perkara_id,$tahapan_id,$tahapan_nama,$proses_id,$proses_nama);
				} else {
					$data=array(
						'tanggal'=>  $tanggal,
						'diperbaharui_oleh'=> $this->session->userdata('username'),
						'diperbaharui_tanggal'=> date("Y-m-d h:i:s",time()) 
					);
					$this->db->where('perkara_id',$perkara_id);
					$this->db->where('proses_id',$proses_id);
					$this->db->update('perkara_proses', $data);
				}	
			} else {
				$this->db->simple_query("CALL perkara_proses_delete(".$perkara_id.",690);");
				$this->db->simple_query("CALL perkara_update_status(".$perkara_id.");");
			}


			if(!empty($pemberitahuan_tembusan_grasi)){
				$dataProses = $this->perkara->getDataProsesPerkara('700',$alur_perkara_id);
				$tahapan_id = $dataProses->row()->tahapan_id;
				$tahapan_nama = $dataProses->row()->tahapan_nama;
				$proses_id = $dataProses->row()->proses_id;
				$proses_nama = $dataProses->row()->proses_nama;
				$keterangan = $dataProses->row()->keterangan;
				$tanggal = $pemberitahuan_tembusan_grasi;

				$cekData = $this->perkara->perkaraProses($perkara_id,$proses_id);
				if($cekData->num_rows==0){				
					$data=array(
						'perkara_id'=> $perkara_id,
						'tahapan_id'=> $tahapan_id,
						'tahapan_nama'=> $tahapan_nama,
						'proses_id'=> $proses_id,
						'proses_nama'=> $proses_nama,
						'tanggal'=>  $tanggal,
						'diinput_oleh'=> $this->session->userdata('username'),
						'diinput_tanggal'=> date("Y-m-d h:i:s",time()) 
					);
					$this->db->insert('perkara_proses',$data); 
					$this->perkara->updateTabelPerkara($perkara_id,$tahapan_id,$tahapan_nama,$proses_id,$proses_nama);
				} else {
					$data=array(
						'tanggal'=>  $tanggal,
						'diperbaharui_oleh'=> $this->session->userdata('username'),
						'diperbaharui_tanggal'=> date("Y-m-d h:i:s",time()) 
					);
					$this->db->where('perkara_id',$perkara_id);
					$this->db->where('proses_id',$proses_id);
					$this->db->update('perkara_proses', $data);
				}	
			} else {
				$this->db->simple_query("CALL perkara_proses_delete(".$perkara_id.",700);");
				$this->db->simple_query("CALL perkara_update_status(".$perkara_id.");");
			}


			echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Diperbaharui'));
			return;
		}
	}



	function hapus_grasi_putusan(){
		if($this->nativesession->is_flash_session('security')==FALSE){ redirect('main'); }
		if($this->session->userdata('is_logged_in')==FALSE){ redirect('login'); }
		
		$segment = $this->uri->segment_array();
		$enc = $this->uri->segment(3);
		$perkaraId = $this->encrypt->decode(base64_decode($enc));
		
		$this->load->model('perkara/grasi','perkara');
		$hapusData = $this->perkara->hapusDataPutusanPresiden($perkaraId);
		if($hapusData){
			echo json_encode(array('st'=>1,'msg'=>'Data Putusan Grasi Berhasil Dihapus'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Gagal Menghapus Putusan Grasi'));
			return;
		}
	}	



	function hapus_grasi(){
		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu'));
			return;
		}
		$grasiId = $this->nativesession->get_flash_session('perkara_id');
		$this->load->model('perkara/grasi','perkara');
		$rowPerkaraId = $this->perkara->getPerkaraGrasibyID($grasiId);
		$perkaraId = $rowPerkaraId->row()->perkara_id;
		$this->perkara->hapusData('perkara_grasi','id',$grasiId);
		$this->perkara->hapusProses($perkaraId,'60');	
		$this->perkara->updateProsesPerkara($perkaraId);
		redirect('main');
	}	

	


	//DODON - 2/06/2015
	function detil_grasi(){
		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu'));
			return;
		}

		$grasiId = $this->nativesession->get_flash_session('perkara_id');
		$this->load->model('perkara/grasi','perkara');
		$rowGrasi = $this->perkara->mDetilGrasi($grasiId);
		if($rowGrasi->num_rows()==0){
			echo json_encode(array('st'=>0,'msg'=>'Kesalahan, Refresh Browser'));
			return;
		} else {
			$data['id'] = base64_encode($this->encrypt->encode($rowGrasi->row()->id));
			$data['perkara_id'] = base64_encode($this->encrypt->encode($rowGrasi->row()->perkara_id));
			$data['nomor_perkara_pn'] = $rowGrasi->row()->nomor_perkara_pn;
			$data['putusan_pn'] = $this->perkara->parsingTanggalView($rowGrasi->row()->putusan_pn);
			$data['nomor_perkara_banding'] = $rowGrasi->row()->nomor_perkara_banding;
			$data['putusan_banding'] = $this->perkara->parsingTanggalView($rowGrasi->row()->putusan_banding);
			$data['nomor_perkara_kasasi'] = $rowGrasi->row()->nomor_perkara_kasasi;
			$data['putusan_kasasi'] = $this->perkara->parsingTanggalView($rowGrasi->row()->putusan_kasasi);
			$data['nomor_perkara_pk'] = $rowGrasi->row()->nomor_perkara_pk;
			$data['putusan_pk'] = $this->perkara->parsingTanggalView($rowGrasi->row()->putusan_pk);
			$data['permohonan_grasi'] = $this->perkara->parsingTanggalView($rowGrasi->row()->permohonan_grasi);
			$data['permohonan_penundaan_pidana'] = $this->perkara->parsingTanggalView($rowGrasi->row()->permohonan_penundaan_pidana);
			$data['terdakwa_id'] = base64_encode($this->encrypt->encode($rowGrasi->row()->terdakwa_id));
			$data['terdakwa_nama'] = $this->templatehelper->standradnaming($rowGrasi->row()->terdakwa_nama);
			$data['pemohon_id'] = base64_encode($this->encrypt->encode($rowGrasi->row()->pemohon_id));
			$data['pemohon_nama'] = $this->templatehelper->standradnaming($rowGrasi->row()->pemohon_nama);
			$data['pemohon_nrp'] = ($rowGrasi->row()->pemohon_nrp);
			$data['pemohon_pangkat'] = $this->templatehelper->standradnaming($rowGrasi->row()->pemohon_pangkat);
			$data['pemohon_jabatan'] = $this->templatehelper->standradnaming($rowGrasi->row()->pemohon_jabatan);
			$data['pemohon_kesatuan'] = $this->templatehelper->standradnaming($rowGrasi->row()->pemohon_kesatuan);
			$data['pemohon_pekerjaan'] = $this->templatehelper->standradnaming($rowGrasi->row()->pemohon_pekerjaan);
			$data['pemohon_alamat'] = $rowGrasi->row()->pemohon_alamat;
			$data['pemohon_grasi'] = $rowGrasi->row()->pemohon_grasi;
			$data['pemberitahuan_putusan_tetap'] = $this->perkara->parsingTanggalView($rowGrasi->row()->pemberitahuan_putusan_tetap);
			$data['menjalani_pidana_pengganti'] = $this->perkara->parsingSeleksi('1',$rowGrasi->row()->menjalani_pidana_pengganti);
			$data['terpidana_dalam_tahanan'] = $this->perkara->parsingSeleksi('1',$rowGrasi->row()->terpidana_dalam_tahanan);
			$data['denda_dibayar'] = $this->perkara->parsingSeleksi('1',$rowGrasi->row()->denda_dibayar);
			$data['barang_rampasan'] = $this->perkara->parsingSeleksi('2',$rowGrasi->row()->barang_rampasan);
			$data['tanggal_pertimbangan_hakim'] = $this->perkara->parsingTanggalView($rowGrasi->row()->tanggal_pertimbangan_hakim);
			$data['isi_perimbangan_hakim'] = $rowGrasi->row()->isi_perimbangan_hakim;
			$data['pengiriman_berkas_grasi_ke_kejaksaan'] = $this->perkara->parsingTanggalView($rowGrasi->row()->pengiriman_berkas_grasi_ke_kejaksaan);
			$data['no_pengiriman_berkas_grasi_ke_kejaksaan'] = $rowGrasi->row()->no_pengiriman_berkas_grasi_ke_kejaksaan;
			$data['pengiriman_berkas_grasi_ke_ma'] = $this->perkara->parsingTanggalView($rowGrasi->row()->pengiriman_berkas_grasi_ke_ma);
			$data['pengiriman_pertimbangan_hakim_grasi'] = $this->perkara->parsingTanggalView($rowGrasi->row()->pengiriman_pertimbangan_hakim_grasi);
			$data['tanggal_penerimaan_kembali_berkas_grasi'] = $this->perkara->parsingTanggalView($rowGrasi->row()->tanggal_penerimaan_kembali_berkas_grasi);
			$data['tanggal_putusan_grasi'] = $this->perkara->parsingTanggalView($rowGrasi->row()->tanggal_putusan_grasi);
			$data['status_putusan_grasi_id'] = $rowGrasi->row()->status_putusan_grasi_id;
			$data['status_putusan_grasi_text'] = $rowGrasi->row()->status_putusan_grasi_text;
			$data['nomor_putusan_grasi'] = $rowGrasi->row()->nomor_putusan_grasi;
			$data['amar_putusan_grasi'] = $rowGrasi->row()->amar_putusan_grasi;
			$data['pemberitahuan_putusan_grasi'] = $this->perkara->parsingTanggalView($rowGrasi->row()->pemberitahuan_putusan_grasi);
			$data['pemberitahuan_tembusan_grasi'] = $this->perkara->parsingTanggalView($rowGrasi->row()->pemberitahuan_tembusan_grasi);
			$data['catatan_putusan_grasi'] = $rowGrasi->row()->catatan_putusan_grasi;
			$data['page_title'] = 'INFORMASI DETIL PERMOHONAN GRASI';
			$data['main_body'] = 'perkara/grasi/detil_grasi';
			
			$data['main_history']=$this->nativesession->get('main_url_requested');
			$data['current_url'] = $this->nativesession->get_flash_session('url_requested');
			$this->load->vars($data);
			$this->load->view('header');
			$this->load->view('body/body_new');
		}
	}




	##DODON UPDATE 3/6/2015
	function showCekTerdakwa(){
		if(empty($_POST)){ show_404(); }

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu'));
			return;
		}

		$terdakwaId = trim($this->input->post('valTerdakwa',FALSE));
		if($terdakwaId=='-1'){
			echo json_encode(array('st'=>0,'msg'=>'Silahkan Isikan Nama Terdakwa Terlebih Dahulu'));
			return;
		}

		if(empty($terdakwaId)){
			echo json_encode(array('st'=>0,'msg'=>'Silahkan Isikan Nama Terdakwa Terlebih Dahulu'));
			return;
		}

		$terdakwa_id = $this->encrypt->decode(base64_decode($terdakwaId));
		
		$this->load->model('perkara/grasi','perkara');
		$rowPerkara =  $this->perkara->getPerkaraGrasi($terdakwa_id);
		if($rowPerkara->num_rows >= 1){
			$namaTerdakwa = $this->templatehelper->standradnaming($rowPerkara->row()->terdakwa_nama);
			echo json_encode(array('st'=>0,'msg'=>'Kesalahan: Permohonan Grasi atas Nama Terdakwa '.$namaTerdakwa.' Sudah Diajukan'));
		} else {
			echo json_encode(array('st'=>1,'msg'=>'Terdakwa Bisa Diajukan Grasi'));
		}
		return;
	}


	

	##DODON UPDATE 2/6/2015
	function showDetilGrasi(){
		if(empty($_POST)){ show_404(); }

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu'));
			return;
		}

		$nomorPerkara = trim($this->input->post('val',FALSE));
		if(empty($nomorPerkara)){
			echo json_encode(array('st'=>0,'msg'=>'Silahkan Isikan Nomor Perkara Terlebih Dahulu'));
			return;
		}


		$this->load->model('perkara/grasi','perkara');
		$rowPerkara =  $this->perkara->getPerkara($nomorPerkara);
		if($rowPerkara->num_rows==1){
			$proses_terakhir_id = $rowPerkara->row()->proses_terakhir_id;
			$alur_perkara_id = base64_encode($this->encrypt->encode($rowPerkara->row()->alur_perkara_id));
			#Cek Jenis Perkara
			if($this->encrypt->decode(base64_decode($alur_perkara_id)) < 100){
				echo json_encode(array('st'=>0,'msg'=>'Error; Perkara Perdata Tidak dapat dimohonkan Grasi'));
				return;
			} else {
				#Cek Tahapan Perkara Banding
				if(($proses_terakhir_id > 290)AND($proses_terakhir_id < 400)){
					echo json_encode(array('st'=>0,'msg'=>'Perkara Dalam Proses Upaya Hukum Banding Tidak dapat dimohonkan Grasi'));
					return;
				#Cek Tahapan Perkara Kasasi
				} else if (($proses_terakhir_id > 410)AND($proses_terakhir_id < 500)){
					echo json_encode(array('st'=>0,'msg'=>'Perkara Dalam Proses Upaya Hukum Kasasi Tidak dapat dimohonkan Grasi'));
					return;
				#Cek Tahapan Perkara Peninjauan Kembali
				} else if (($proses_terakhir_id > 510)AND($proses_terakhir_id < 590)){
					echo json_encode(array('st'=>0,'msg'=>'Perkara Dalam Proses Upaya Hukum Peninjauan Kembali Tidak dapat dimohonkan Grasi'));
					return;
				} else {
					$perkara_id = base64_encode($this->encrypt->encode($rowPerkara->row()->perkara_id));
					if(empty($perkara_id)){
						echo json_encode(array('st'=>0,'msg'=>':p'));
						return;
					} else {
						#Data Putusan PN
						$putusan = $this->perkara->data_putusan($this->encrypt->decode(base64_decode($perkara_id)));
						if($putusan->num_rows>0){
							$putusan = $this->tanggalhelper->convertToInputDate($putusan->row()->tanggal_putusan);
						}else{
							echo json_encode(array('st'=>0,'msg'=>'Perkara Belum Dapat Dimohonkan Grasi Karena Belum Putus'));
							return;
						}
						#Data Upaya Hukum Grasi
						$banding = $this->perkara->data_banding($this->encrypt->decode(base64_decode($perkara_id)));
						if($banding->num_rows>0){
							$nomorPerkaraBanding = $banding->row()->nomor_perkara_banding;
							$putusanBanding = $this->tanggalhelper->convertToInputDate($banding->row()->putusan_banding);
						} else {
							$nomorPerkaraBanding = "";
							$putusanBanding = "";
						}
						#Data Upaya Hukum Kasasi		
						$kasasi = $this->perkara->data_kasasi($this->encrypt->decode(base64_decode($perkara_id)));
						if($kasasi->num_rows()>0){
							$nomorPerkaraKasasi = $kasasi->row()->nomor_perkara_kasasi;
							$putusanKasasi = $this->tanggalhelper->convertToInputDate($kasasi->row()->putusan_kasasi);
						} else {
							$nomorPerkaraKasasi = "";
							$putusanKasasi = "";		
						}	
						#Data Upaya Hukum Peninjauan Kembali
						$pk = $this->perkara->data_pk($this->encrypt->decode(base64_decode($perkara_id)));	
						if($pk->num_rows()>0){
							$nomorPerkaraPK =$pk->$row->nomor_perkara_pk;
							$putusanPK = $pk->$row->putusan_pk;			
						} else {
							$nomorPerkaraPK = "";
							$putusanPK = "";
						}


						$pihakHtml ='<td style="padding:0px;padding-left:5px;" id="td_terdakwa">
						<span class="custom-dropdown custom-dropdown--emerald"  style="border:1px #ddd solid;  width:350px;">
				                            <select style="width:350px;" name="terdakwa_id" id="terdakwa_id" class="custom-dropdown__select custom-dropdown__select--white">
				                                <option value="-1">Pilih Nama Terdakwa</option>';
						$pihak = $this->perkara->pihak2($this->encrypt->decode(base64_decode($perkara_id)));
						if($pihak->num_rows>0){
							foreach ($pihak->result() as $row) {
								$pihakHtml .=' <option value="'.base64_encode($this->encrypt->encode($row->id)).'">'.$this->templatehelper->standradnaming($row->nama).'</option>';
							}
						}


						$current_date = date('d/m/Y');

						$pihakHtml .='</select></span></td>';
						echo json_encode(array(
							'st'=>1,
							'msg'=>'Perkara ditemukan',
							'tglPutusan'=>$putusan,
							'nomorPerkaraBanding'=>$nomorPerkaraBanding,
							'nomorPerkaraKasasi'=>$nomorPerkaraKasasi,
							'putusanKasasi'=>$putusanKasasi,
							'nomorPerkaraPK'=>$nomorPerkaraPK,
							'putusanPK'=>$putusanPK,
							'curr_date'=>$current_date,
							'perkaraId'=>$perkara_id,
							'pihakhtml' =>$pihakHtml,
							'putusanBanding'=>$putusanBanding,
							'alurPerkaraId' =>$alur_perkara_id
						));
						return;
					}
				}
			}
		}elseif($rowPerkara->num_rows>1){
			echo json_encode(array('st'=>0,'msg'=>'Error; Ditemukan Lebih dari satu nomor perkara '.$nomorPerkara.' yang anda masukan'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error Nomor Perkara Tidak Ditemukan'));
			return;
		}
	}

}