<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Report_tun extends CI_Model{
	
	function get_info_pn(){
		try {
			$this->db->select('*');
			$this->db->where('id >=', 61); 
			return $this->db->get('sys_config');
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	function getJenisPerkara($idalurperkara){
		if(empty($idalurperkara)) return '';
		try {
			$this->db->where('id',$idalurperkara);
			return $this->db->get('alur_perkara')->row()->nama;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_tahun($idalurperkara){
		try {
			return $this->db->query('SELECT YEAR(min(tanggal_pendaftaran)) AS years FROM perkara WHERE alur_perkara_id IN ('.$idalurperkara.');');
		} catch (Exception $e) {
			log_message('error', $e);
		}	
	}

	function get_rekap($idalurperkara,$tahun){
		try {
			return $this->db->query("SELECT b.id,b.name_id 
					,(SELECT COUNT(p.perkara_id)
					FROM `v_perkara` AS p WHERE p.alur_perkara_id IN (".$idalurperkara.") 
					AND LEFT(p.tanggal_pendaftaran,7) < CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) 
					AND (p.tanggal_putusan IS NULL OR LEFT(p.tanggal_putusan,7) >= CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))) 
					AND CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) <= CONCAT(YEAR(CURRENT_DATE),'-', RIGHT(CONCAT('0',CAST(MONTH(CURRENT_DATE) AS CHAR(2))),2))
					) AS BelumPutusBulanLalu
					,(SELECT COUNT(p.perkara_id)
					FROM `v_perkara` AS p WHERE p.alur_perkara_id IN (".$idalurperkara.") 
					AND LEFT(p.tanggal_pendaftaran,7) < CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) 
					AND (LEFT(p.tanggal_putusan,7) < CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))) 
					AND (p.tanggal_minutasi IS NULL OR LEFT(p.tanggal_minutasi,7) >= CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))) 
					AND CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) <= CONCAT(YEAR(CURRENT_DATE),'-', RIGHT(CONCAT('0',CAST(MONTH(CURRENT_DATE) AS CHAR(2))),2))
					) AS BelumMinutasiBulanLalu
					,(SELECT COUNT(p.perkara_id)
					FROM `v_perkara` AS p WHERE p.alur_perkara_id IN (".$idalurperkara.") 
					AND LEFT(p.tanggal_pendaftaran,7) = CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) 
					AND CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) <= CONCAT(YEAR(CURRENT_DATE),'-', RIGHT(CONCAT('0',CAST(MONTH(CURRENT_DATE) AS CHAR(2))),2))
					) AS MasukBulanIni
					,(SELECT COUNT(p.perkara_id)
					FROM `v_perkara` AS p WHERE p.alur_perkara_id IN (".$idalurperkara.") 
					AND LEFT(p.tanggal_pendaftaran,7) <= CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) 
					AND (LEFT(p.tanggal_putusan,7) = CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))) 
					AND CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) <= CONCAT(YEAR(CURRENT_DATE),'-', RIGHT(CONCAT('0',CAST(MONTH(CURRENT_DATE) AS CHAR(2))),2))
					) AS PutusBulanIni
					,(SELECT COUNT(p.perkara_id)
						FROM `v_perkara` AS p WHERE p.alur_perkara_id IN (".$idalurperkara.") 
						AND LEFT(p.tanggal_pendaftaran,7) <= CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) 
						AND (p.penetapan_majelis_hakim IS NULL OR LEFT(p.penetapan_majelis_hakim,7) > CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))) 
						AND CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) <= CONCAT(YEAR(CURRENT_DATE),'-', RIGHT(CONCAT('0',CAST(MONTH(CURRENT_DATE) AS CHAR(2))),2))
					) AS BelumPenetapan
					,(SELECT COUNT(p.perkara_id)
					FROM `v_perkara` AS p WHERE p.alur_perkara_id IN (".$idalurperkara.") 
					AND LEFT(p.tanggal_pendaftaran,7) <= CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) 
					AND (LEFT(p.tanggal_putusan,7) <= CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))) 
					AND (LEFT(p.tanggal_minutasi,7) = CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))) 
					AND CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) <= CONCAT(YEAR(CURRENT_DATE),'-', RIGHT(CONCAT('0',CAST(MONTH(CURRENT_DATE) AS CHAR(2))),2))
					) AS MinutasiBulanIni

					,(SELECT COUNT(ph.`id`)
					FROM perkara_pihak2 AS ph
					LEFT OUTER JOIN perkara_putusan_terdakwa AS pt ON ph.id = pt.pihak2_id 
					LEFT OUTER JOIN v_perkara AS pe ON ph.perkara_id = pe.perkara_id
					WHERE pe.alur_perkara_id IN (".$idalurperkara.") 
					AND CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) <= CONCAT(YEAR(CURRENT_DATE),'-', RIGHT(CONCAT('0',CAST(MONTH(CURRENT_DATE) AS CHAR(2))),2))
					AND 
					((LEFT(pe.tanggal_pendaftaran,7) < CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) 
						AND ((pe.tanggal_putusan IS NULL OR LEFT(pe.tanggal_putusan,7)>= CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))) 
					    	OR 
					    	(pe.tanggal_putusan IS NOT NULL AND LEFT(pe.tanggal_putusan,7)< CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) 
					    	AND (pe.tanggal_minutasi IS NULL OR LEFT(pe.tanggal_minutasi,7)>= CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))) 
					   		))) 
						OR(LEFT(pe.tanggal_pendaftaran,7) = CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))))
					) AS JumlahTerdakwa
					,(SELECT COUNT(ph.`id`)
					FROM perkara_pihak2 AS ph
					LEFT OUTER JOIN perkara_putusan_terdakwa AS pt ON ph.id = pt.pihak2_id 
					LEFT OUTER JOIN v_perkara AS pe ON ph.perkara_id = pe.perkara_id
					WHERE pe.alur_perkara_id IN (".$idalurperkara.") 
					AND CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) <= CONCAT(YEAR(CURRENT_DATE),'-', RIGHT(CONCAT('0',CAST(MONTH(CURRENT_DATE) AS CHAR(2))),2))
					AND pt.status_putusan_id>=11 AND pt.status_putusan_id<=17
					AND 
					(( LEFT(pe.tanggal_pendaftaran,7) < CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) 
						AND ((pe.tanggal_putusan IS NULL OR LEFT(pe.tanggal_putusan,7)>= CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))) 
					    	OR 
					    	(pe.tanggal_putusan IS NOT NULL AND LEFT(pe.tanggal_putusan,7)< CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) 
					    	AND (pe.tanggal_minutasi IS NULL OR LEFT(pe.tanggal_minutasi,7)>= CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))) 
					   		))) 
						OR(LEFT(pe.tanggal_pendaftaran,7) = CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))))
					) AS JumlahTerpidana
					FROM `sys_month_name` AS b
					ORDER BY b.id");
		} catch (Exception $e) {
			
		}
	}

	function get_stat_perkara($period,$idalurperkara){
		try {
			return $this->db->query("
				SELECT alur_perkara_id,alur_perkara_nama,
				SUM(CASE WHEN (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)='".$period."' ) AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1 ELSE 0 END ) AS blm_putus,
				SUM(CASE WHEN (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1 ELSE 0 END ) AS sisa,
				SUM(CASE WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND (tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1 ELSE 0 END ) AS putus_blm_minut,
				SUM(CASE WHEN LEFT(tanggal_pendaftaran,7)= '".$period."' THEN 1 ELSE 0 END) AS masuk,
				SUM(CASE WHEN penetapan_majelis_hakim IS NULL AND tanggal_cabut IS NULL AND LEFT(tanggal_pendaftaran,7)<= '".$period."' AND ((tanggal_minutasi IS NULL)OR(LEFT(tanggal_minutasi,7)>'".$period."')) THEN 1 ELSE 0 END) AS blm_majelis,
				SUM(CASE WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)>'".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' OR LEFT(tanggal_cabut,7) <= '".$period."' THEN 1 ELSE 0 END ) AS putus,
				SUM(CASE WHEN (tanggal_minutasi IS NOT NULL AND LEFT(tanggal_minutasi,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1 ELSE 0 END ) AS minut,
				SUM(CASE WHEN (perkara_dismissal.tanggal_penetapan IS NOT NULL AND LEFT(perkara_dismissal.tanggal_penetapan,7)='".$period."') AND LEFT(tanggal_pendaftaran,7)= '".$period."' THEN 1 ELSE 0 END ) AS dismissal,
				SUM(CASE WHEN (tanggal_cabut IS NOT NULL AND LEFT(tanggal_cabut,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1 ELSE 0 END ) AS cabutPerkara,
				SUM(CASE WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND (tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>'".$period."') THEN 1 ELSE 0 END) AS blm_minut
				FROM v_perkara
				LEFT JOIN perkara_dismissal ON perkara_dismissal.perkara_id=v_perkara.perkara_id
				WHERE alur_perkara_id IN ('9');
				");
		} catch (Exception $e) {
			
		}
	}

	function get_stat_perkara_bln($period,$idalurperkara){
		try {
			return $this->db->query("
					SELECT jenis_perkara_id,jenis_perkara_nama,
					SUM(
						CASE 
							WHEN (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>='".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' THEN 1
							ELSE 0
							END
						) AS sisa,
					SUM(
						CASE 
							WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
									(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
							ELSE 0
							END
						) AS putus_blm_minut,
					SUM(
						CASE 
							WHEN (keputusan_mediasi IS NOT NULL AND LEFT(keputusan_mediasi,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
									(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') AND hasil_mediasi='Y' THEN 1
							ELSE 0
							END
						) AS med_blm_minut,
					SUM(
						CASE 
							WHEN LEFT(tanggal_pendaftaran,7) = '".$period."' THEN 1
							ELSE 0
							END
						) AS masuk,
					SUM(
						CASE 
							WHEN (penetapan_majelis_hakim IS NULL OR LEFT(penetapan_majelis_hakim,7)>'".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
							ELSE 0
							END
						) AS blm_majelis,
					SUM(
						CASE 
							WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
							ELSE 0
							END
						) AS putus,
					SUM(
						CASE 
							WHEN (tanggal_minutasi IS NOT NULL AND LEFT(tanggal_minutasi,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
							ELSE 0
							END
						) AS minut,
					SUM(
						CASE 
							WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
									(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>'".$period."') THEN 1
							WHEN (LEFT(mediasi_berhasil,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
									(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
							ELSE 0
							END
						) AS blm_minut,
					SUM(
						CASE WHEN (perkara_dismissal.tanggal_penetapan IS NOT NULL AND LEFT(perkara_dismissal.tanggal_penetapan,7)='".$period."') AND LEFT(tanggal_pendaftaran,7)= '".$period."' THEN 1
						ELSE 0 END ) AS dismissal,
					SUM(
						CASE 
							WHEN (tanggal_cabut IS NOT NULL AND LEFT(tanggal_cabut,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
							ELSE 0
							END
						) AS cabutPerkara,
					SUM(
						CASE 
							WHEN (tanggal_gugur IS NOT NULL AND LEFT(tanggal_gugur,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
							ELSE 0
							END
						) AS gugur
					FROM v_perkara
					LEFT JOIN perkara_dismissal ON perkara_dismissal.perkara_id=v_perkara.perkara_id
					WHERE alur_perkara_id IN (".$idalurperkara.")
					AND LEFT(tanggal_pendaftaran,7) <='".$period."'
					GROUP BY jenis_perkara_id;");
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function listHakim(){
		try{
			return $this->db->query("SELECT nama,nama_gelar FROM hakim_pn WHERE aktif='Y'");
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function listPP(){
		try{
			return $this->db->query("SELECT nama,nama_gelar FROM panitera_pn WHERE aktif='Y'");
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_lap_perkara_belum_dibagi($period,$idalurperkara){
		try {
			return $this->db->query("SELECT nomor_perkara FROM v_perkara WHERE LEFT(tanggal_pendaftaran,7)<='".$period."' AND penetapan_majelis_hakim IS NULL AND alur_perkara_id IN (".$idalurperkara.")");
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_lap_perkara_belum_putus($period,$idalurperkara){
		try {
			return $this->db->query("SELECT nomor_perkara FROM v_perkara WHERE LEFT(tanggal_pendaftaran,7)<='".$period."' AND v_perkara.tanggal_putusan IS NULL AND alur_perkara_id IN (".$idalurperkara.")");
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_lap_perkara_belum_minut($period,$idalurperkara){
		try {
			return $this->db->query("SELECT nomor_perkara FROM v_perkara WHERE LEFT(tanggal_pendaftaran,7)<='".$period."' AND LEFT(tanggal_putusan,7) <='".$period."' AND tanggal_minutasi IS NULL AND alur_perkara_id='9'");
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}


	function get_lap_perkara($period,$idalurperkara){
		try {
			return $this->db->query("SELECT
				perkara.perkara_id,
				perkara.nomor_perkara,
				perkara.tanggal_pendaftaran,
				(SELECT VALUE FROM sys_config WHERE id='64') AS namaKetua,
				(SELECT VALUE FROM sys_config WHERE id='66') AS namaWakilKetua,
				(SELECT VALUE FROM sys_config WHERE id='68') AS namaPanses,
				(SELECT MIN(tanggal_panggilan) FROM perkara_panggilan_dismissal WHERE perkara_id=perkara.perkara_id) AS tanggalPanggilan,
				dismissal.tanggal_penetapan AS tanggalPenetapan,
				perkara_verzet.tanggal_pendaftaran_verzet AS tanggalPenerimaanPerlawanan,
				perkara_verzet.penetapan_majelis_hakim AS tglPenetapanHakimPerlawanan,
				perkara_verzet.penetapan_panitera_pengganti AS tglPenetapanPPPerlawanan,
				perkara_verzet.tanggal_sidang_pertama_verzet AS tglSidangPertamaPerlawanan,
				perkara_verzet.majelis_hakim_nama AS hakimPerlawanan,
				(SELECT nama FROM panitera_pn WHERE id=perkara_verzet.panitera_pengganti_id) AS paniteraPerlawanan,
				perkara_verzet.putusan_verzet AS tglPutusanPerlawanan,
				perkara_penetapan.penetapan_majelis_hakim AS tglPenetapanHakimBiasa,
				perkara_penetapan.penetapan_panitera_pengganti AS tglPenetapanPPBiasa,
				perkara_penetapan.majelis_hakim_nama AS hakimBiasa,
				(SELECT nama FROM panitera_pn WHERE id=perkara_penetapan.panitera_pengganti_id) AS paniteraBiasa,
				(SELECT tanggal_penetapan_persiapan FROM perkara_persiapan WHERE perkara_id=perkara.perkara_id) AS tglPenetapanPersiapan,
				perkara_penetapan.sidang_pertama AS sidangPertama,
				(SELECT tanggal_putusan FROM perkara_putusan WHERE perkara_id=perkara.perkara_id) AS tanggalPutusan,
				(CASE WHEN perkara.penetapan_majelis_hakim IS NULL AND perkara.tanggal_cabut IS  NULL THEN perkara.nomor_perkara ELSE '' END) AS belumDibagi,
				(CASE WHEN perkara.tanggal_putusan IS NULL OR perkara.tanggal_cabut IS NULL THEN perkara.nomor_perkara ELSE '' END) AS belumPutus
				FROM v_perkara AS perkara
				LEFT JOIN perkara_penetapan AS penetapan ON penetapan.perkara_id=perkara.perkara_id
				LEFT JOIN perkara_dismissal AS dismissal ON dismissal.perkara_id=perkara.perkara_id
				LEFT JOIN perkara_penetapan ON perkara_penetapan.perkara_id=perkara.perkara_id
				LEFT JOIN perkara_verzet ON perkara_verzet.perkara_id=perkara.perkara_id
				WHERE perkara.alur_perkara_id IN (9)
				AND LEFT(perkara.tanggal_pendaftaran,7)<='".$period."' 
				AND ((perkara.tanggal_minutasi IS NULL)OR(LEFT(perkara.tanggal_minutasi,7)>'".$period."'))
				ORDER BY tanggal_pendaftaran ASC");
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}



	function laporanJenisPerkaraTUN($period,$idalurperkara){
		try{
			return $this->db->query("SELECT
				jenisPerkara.id,
				jenisPerkara.nama_lengkap AS jenis_perkara_nama,
				(SELECT COUNT(*) FROM v_perkara 
					WHERE (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>='".$period."') 
					AND LEFT(tanggal_pendaftaran,7) <= '".$period."'
					AND alur_perkara_id='9'
					AND jenis_perkara_id=jenisPerkara.id) AS sisaBulanLalu,
				(SELECT COUNT(*) FROM v_perkara
					WHERE LEFT(tanggal_pendaftaran,7)='".$period."'
					AND alur_perkara_id='9'
					AND jenis_perkara_id=jenisPerkara.id) AS masukBulanIni,
				(SELECT COUNT(*) FROM v_perkara
					WHERE LEFT(tanggal_cabut,7)='".$period."'
					AND penetapan_hari_sidang IS NULL
					AND jenis_perkara_id=jenisPerkara.id) AS perkaraCabut1,
				(SELECT COUNT(DISTINCT(nomor_perkara)) FROM perkara 
					LEFT JOIN perkara_pihak1 ON perkara_pihak1.perkara_id=perkara.perkara_id
					WHERE perkara_pihak1.jenis_pihak_id='1'
					AND LEFT(perkara.tanggal_pendaftaran,7) = '".$period."'
					AND perkara.alur_perkara_id='9'
					AND perkara.jenis_perkara_id=jenisPerkara.id) AS penggugatPerorangan,
				(SELECT COUNT(DISTINCT(nomor_perkara)) FROM perkara 
					LEFT JOIN perkara_pihak1 ON perkara_pihak1.perkara_id=perkara.perkara_id
					WHERE perkara_pihak1.jenis_pihak_id='3'
					AND LEFT(perkara.tanggal_pendaftaran,7) = '".$period."'
					AND perkara.alur_perkara_id='9'
					AND perkara.jenis_perkara_id=jenisPerkara.id) AS penggugatBadanHukum,
				(SELECT COUNT(*) FROM perkara_pihak2 LEFT JOIN perkara ON perkara.perkara_id=perkara_pihak2.perkara_id
					WHERE perkara_pihak2.jenis_pihak_id='2'
					AND perkara.alur_perkara_id='9' 
					AND LEFT(perkara.tanggal_pendaftaran,7) = '".$period."'
					AND perkara.jenis_perkara_id=jenisPerkara.id) AS tergugatPusat,
				(SELECT COUNT(*) FROM perkara_pihak2 LEFT JOIN perkara ON perkara.perkara_id=perkara_pihak2.perkara_id
					WHERE perkara_pihak2.jenis_pihak_id='4' 
					AND perkara.alur_perkara_id='9'
					AND LEFT(tanggal_pendaftaran,7) = '".$period."'
					AND perkara.jenis_perkara_id=jenisPerkara.id) AS tergugatDaerah,
				(SELECT COUNT(*) FROM perkara_dismissal 
					LEFT JOIN perkara ON perkara.perkara_id=perkara_dismissal.perkara_id
					WHERE perkara_dismissal.tanggal_penetapan IS NOT NULL 
					AND perkara_dismissal.hasil='2'
					AND perkara.jenis_perkara_id=jenisPerkara.id
					AND LEFT(tanggal_penetapan,7)='".$period."') AS jumlahDismissal,
				(SELECT COUNT(*) FROM perkara_verzet 
					LEFT JOIN perkara ON perkara.perkara_id=perkara_verzet.perkara_id
					WHERE (perkara_verzet.putusan_verzet IS NOT NULL AND LEFT(perkara_verzet.putusan_verzet,7)='".$period."')
					AND perkara.jenis_perkara_id=jenisPerkara.id  
					AND perkara_verzet.status_putusan_verzet_id='35') AS perlawananDitolak,
				(SELECT COUNT(*) FROM perkara_verzet 
					LEFT JOIN perkara ON perkara.perkara_id=perkara_verzet.perkara_id
					WHERE (perkara_verzet.putusan_verzet IS NOT NULL AND LEFT(perkara_verzet.putusan_verzet,7)='".$period."')
					AND perkara.jenis_perkara_id=jenisPerkara.id  
					AND perkara_verzet.status_putusan_verzet_id='34') AS perlawananDiterima,
				(SELECT COUNT(*) FROM v_perkara WHERE tanggal_putusan IS NOT NULL 
					AND status_putusan_id='38' 
					AND LEFT(tanggal_putusan,7)='".$period."' 
					AND LEFT(tanggal_pendaftaran,7)<='".$period."'
					AND jenis_perkara_id=jenisPerkara.id) AS putusGugur,
				(SELECT COUNT(*) FROM v_perkara WHERE tanggal_putusan IS NOT NULL 
					AND status_putusan_id='37' 
					AND LEFT(tanggal_putusan,7)='".$period."' 
					AND LEFT(tanggal_pendaftaran,7)<='".$period."'
					AND jenis_perkara_id=jenisPerkara.id) AS perkaraCabut2,
				(SELECT COUNT(*) FROM v_perkara WHERE tanggal_putusan IS NOT NULL 
					AND status_putusan_id='35' 
					AND LEFT(tanggal_putusan,7)='".$period."' 
					AND LEFT(tanggal_pendaftaran,7)<='".$period."'
					AND jenis_perkara_id=jenisPerkara.id) AS putusDitolak,
				(SELECT COUNT(*) FROM v_perkara WHERE tanggal_putusan IS NOT NULL 
					AND status_putusan_id='36' 
					AND LEFT(tanggal_putusan,7)='".$period."' 
					AND LEFT(tanggal_pendaftaran,7)<='".$period."'
					AND jenis_perkara_id=jenisPerkara.id) AS putusNO,
				(SELECT COUNT(*) FROM v_perkara WHERE tanggal_putusan IS NOT NULL 
					AND status_putusan_id='34' 
					AND LEFT(tanggal_putusan,7)='".$period."' 
					AND LEFT(tanggal_pendaftaran,7)<='".$period."'
					AND jenis_perkara_id=jenisPerkara.id) AS putusDikabulkan,
				(SELECT COUNT(*) FROM v_perkara WHERE tanggal_putusan IS NOT NULL 
					AND status_putusan_id IS NOT NULL 
					AND status_putusan_id IN (34,35,36,37,38)
					AND LEFT(tanggal_putusan,7)='".$period."' 
					AND LEFT(tanggal_pendaftaran,7)<='".$period."'
					AND jenis_perkara_id=jenisPerkara.id) AS jumlahPutusan, 
				(SELECT COUNT(*) FROM perkara_banding 
					LEFT JOIN perkara ON perkara.perkara_id=perkara_banding.perkara_id
					WHERE permohonan_banding IS NOT NULL 
					AND LEFT(permohonan_banding,7)='".$period."'
					AND perkara.jenis_perkara_id=jenisPerkara.id) AS jumlahBanding,
				(SELECT COUNT(*) FROM perkara_kasasi 
					LEFT JOIN perkara ON perkara.perkara_id=perkara_kasasi.perkara_id
					WHERE permohonan_kasasi IS NOT NULL 
					AND LEFT(permohonan_kasasi,7)='".$period."'
					AND perkara.jenis_perkara_id=jenisPerkara.id) AS jumlahKasasi,
				(SELECT COUNT(*) FROM perkara_pk 
					LEFT JOIN perkara ON perkara.perkara_id=perkara_pk.perkara_id
					WHERE permohonan_pk IS NOT NULL 
					AND LEFT(permohonan_pk,7)='".$period."'
					AND perkara.jenis_perkara_id=jenisPerkara.id) AS jumlahPK,
				(SELECT COUNT(*) FROM perkara_banding 
					LEFT JOIN perkara ON perkara.perkara_id=perkara_banding.perkara_id
					WHERE penerimaan_kembali_berkas_banding IS NOT NULL 
					AND LEFT(penerimaan_kembali_berkas_banding,7)='".$period."'
					AND perkara.jenis_perkara_id=jenisPerkara.id) AS jumlahTerimaBanding,
				(SELECT COUNT(*) FROM perkara_kasasi 
					LEFT JOIN perkara ON perkara.perkara_id=perkara_kasasi.perkara_id
					WHERE penerimaan_berkas_kasasi IS NOT NULL 
					AND LEFT(penerimaan_berkas_kasasi,7)='".$period."'
					AND perkara.jenis_perkara_id=jenisPerkara.id) AS jumlahTerimaKasasi,
				(SELECT COUNT(*) FROM perkara_pk 
					LEFT JOIN perkara ON perkara.perkara_id=perkara_pk.perkara_id
					WHERE penerimaan_berkas_pk IS NOT NULL 
					AND LEFT(penerimaan_berkas_pk,7)='".$period."'
					AND perkara.jenis_perkara_id=jenisPerkara.id) AS jumlahTerimaPK,
				(SELECT COUNT(*) FROM perkara_eksekusi
					LEFT JOIN perkara ON perkara.perkara_id=perkara_eksekusi.perkara_id
					WHERE permohonan_eksekusi IS NOT NULL
					AND LEFT(permohonan_eksekusi,7)='".$period."'
					AND perkara.jenis_perkara_id=jenisPerkara.id) AS jumlahEksekusi
				FROM v_jenis_perkara AS jenisPerkara
				WHERE jenisPerkara.alur_perkara_id='9' AND aktif='Y'");
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function laporanBandingTUN($period,$idalurperkara){
		try{
			return $this->db->query("SELECT
				v_perkara_banding.perkara_id,
				v_perkara_banding.nomor_perkara_pn,
				perkara_penetapan.majelis_hakim_nama,
				(SELECT nama FROM panitera_pn WHERE id=perkara_penetapan.panitera_pengganti_id) AS panitera_pengganti_nama,
				v_perkara_banding.putusan_pn,
				v_perkara_banding.permohonan_banding,
				v_perkara_banding.pengiriman_berkas_banding
				FROM v_perkara_banding
				LEFT JOIN perkara_penetapan ON perkara_penetapan.perkara_id=v_perkara_banding.perkara_id
				WHERE v_perkara_banding.alur_perkara_id='".$idalurperkara."'
				AND LEFT(v_perkara_banding.permohonan_banding,7)<='".$period."';");
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function laporanKasasiTUN($period,$idalurperkara){
		try{
			return $this->db->query("SELECT
				perkara_id,
				nomor_perkara_pn,
				(SELECT penerimaan_kembali_berkas_banding FROM perkara_banding WHERE perkara_id=v_perkara_kasasi.perkara_id) AS penerimaan_berkas_PT,
				putusan_banding,
				pemberitahuan_putusan_banding,
				permohonan_kasasi,
				pengiriman_berkas_kasasi
				FROM v_perkara_kasasi
				WHERE LEFT(permohonan_kasasi,7)<='".$period."'
				AND alur_perkara_id='".$idalurperkara."';");
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}


	function laporanEksekusiTUN($period,$idalurperkara){
		try{
			return $this->db->query("SELECT 
				perkara_eksekusi.eksekusi_nomor_perkara,
				perkara_eksekusi.eksekusi_putusan,
				perkara.jenis_perkara_id,
				perkara.jenis_perkara_nama,
				perkara_putusan.pemberitahuan_putusan AS pemberitahuanPutusanPN,
				perkara_banding.pemberitahuan_putusan_banding AS pemberitahuanPutusanPT,
				perkara_kasasi.pemberitahuan_putusan_kasasi AS pemberitahuanPutusanKasasi,
				perkara_pk.pemberitahuan_putusan_pk AS pemberitahuanPutusanPK,
				perkara_eksekusi.permohonan_eksekusi,
				perkara_eksekusi.panggilan_parapihak,
				perkara_eksekusi.pelaksanaan_teguran_eksekusi,
				perkara_eksekusi.pengumuman_media,
				perkara_eksekusi.surat_presiden,
				perkara_eksekusi.surat_lembaga_perwakilan_rakyat
				FROM perkara_eksekusi
				LEFT JOIN perkara ON perkara.perkara_id=perkara_eksekusi.perkara_id
				LEFT JOIN perkara_putusan ON perkara_putusan.perkara_id=perkara_eksekusi.perkara_id
				LEFT JOIN perkara_banding ON perkara_banding.perkara_id=perkara_eksekusi.perkara_id
				LEFT JOIN perkara_kasasi ON perkara_kasasi.perkara_id=perkara_eksekusi.perkara_id
				LEFT JOIN perkara_pk ON perkara_pk.perkara_id=perkara_eksekusi.perkara_id
				WHERE LEFT(perkara_eksekusi.permohonan_eksekusi,7)='".$period."'
				AND perkara_eksekusi.alur_perkara_id='".$idalurperkara."'");
		}  catch (Exception $e) {
			log_message('error', $e);
		}
	}


	function laporanPKTUN($period,$idalurperkara){
		try{
			return $this->db->query("SELECT
				nomor_perkara_pn,
				nomor_perkara_banding,
				nomor_perkara_kasasi,
				permohonan_pk,
				pengiriman_berkas_pk,
				perkara_putusan.tanggal_bht
				FROM perkara_pk
				LEFT JOIN perkara ON perkara.perkara_id=perkara_pk.perkara_id
				LEFT JOIN perkara_putusan ON perkara_putusan.perkara_id=perkara_pk.perkara_id
				WHERE LEFT(permohonan_pk,7)<='".$period."'
				AND perkara.alur_perkara_id='".$idalurperkara."';");
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}




	function laporanProdeoTUN($period,$idalurperkara){
		try{
			return $this->db->query("SELECT 
				perkara.nomor_perkara,
				perkara.jenis_perkara_nama,
				(SELECT tanggal_putusan FROM perkara_putusan WHERE perkara_id=perkara_biaya.perkara_id) AS tanggalPutusan,
				perkara_biaya.jumlah
				FROM perkara_biaya
				LEFT JOIN perkara ON perkara.perkara_id=perkara_biaya.perkara_id
				WHERE LEFT(perkara.tanggal_pendaftaran,7)='".$period."'
				AND perkara.alur_perkara_id='".$idalurperkara."'
				AND perkara_biaya.tahapan_id='10'
				AND perkara_biaya.jenis_transaksi='1'
				AND perkara_biaya.urutan='1'
				AND perkara_biaya.id_pembiayaan='2'");
		}  catch (Exception $e) {
			log_message('error', $e);
		}	
	}

	function get_saldo_awal($period){
		try {
			return $this->db->query("SELECT SUM(IF('$period'>=LEFT(tanggal_saldo_awal,7),jumlah_saldo_awal,0)) AS saldo_awal, MAX(tanggal_saldo_awal) AS tgl_saldo_awal FROM saldo_awal WHERE alur_perkara_id IN (9,10,11,12,13,14);");
		} catch (Exception $e) {
			
		}
	}

	function laporanKeuanganTUN($period,$idalurperkara,$saldo_awal=0){
		try{

			return $this->db->query("SELECT
					'Sisa Awal' AS uraian,
					(if(penerimaanLalu is null,0,penerimaanLalu)-if(pengeluaranLalu is null,0,pengeluaranLalu))+(".$saldo_awal.") AS jml_penerimaan,
					0 AS jml_pengeluaran
				FROM
				(SELECT 
					SUM(IF(kategori_id=1,penerimaan,0)) AS penerimaanLalu,
					SUM(IF(kategori_id<>1,pengeluaran,0)) AS pengeluaranLalu 
				FROM v_perkara_biaya_detil
				WHERE LEFT(tanggal_transaksi,7)<'".$period."' 
				AND alur_perkara_id IN (9)
				AND jenis_biaya_id IS NOT NULL) AS sisa
				UNION
				SELECT
					'Penerimaaan Bulan ini' AS uraian,
					SUM(IF(kategori_id=1,penerimaan,0)) AS jml_penerimaan,
					SUM(IF(kategori_id=1,pengeluaran,0)) AS jml_pengeluaran	
				FROM (
				SELECT jenis_biaya_id,nama, biaya.kategori_id,penerimaan,pengeluaran
				FROM jenis_biaya AS jb
				LEFT JOIN (SELECT
					jenis_biaya_id,vb.kategori_id,
					SUM(penerimaan) AS penerimaan,
					SUM(pengeluaran) AS pengeluaran
					FROM v_perkara_biaya_detil AS vb
					WHERE LEFT(tanggal_transaksi,7)='".$period."'
					AND alur_perkara_id IN (9)
					GROUP BY jenis_biaya_id) AS biaya ON biaya.jenis_biaya_id=jb.id
				GROUP BY id
				) AS tabel_biaya
				UNION
				SELECT 
					'Biaya Panggilan' AS uraian,
					SUM(IF(kategori_id=4,penerimaan,0)) AS jml_penerimaan,
					SUM(IF(kategori_id=4,pengeluaran,0)) AS jml_pengeluaran	
				FROM (
				SELECT jenis_biaya_id,nama, biaya.kategori_id,penerimaan,pengeluaran
				FROM jenis_biaya AS jb
				LEFT JOIN (SELECT
					jenis_biaya_id,vb.kategori_id,
					SUM(penerimaan) AS penerimaan,
					SUM(pengeluaran) AS pengeluaran
					FROM v_perkara_biaya_detil AS vb
					WHERE LEFT(tanggal_transaksi,7)='".$period."'
					AND alur_perkara_id IN (9)
					GROUP BY jenis_biaya_id) AS biaya ON biaya.jenis_biaya_id=jb.id
				GROUP BY id
				) AS tabel_biaya
				UNION
				SELECT 
					'Biaya Pemberitahuan' AS uraian,
					SUM(IF(jenis_biaya_id IN (28,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,307,308,309,310,311,312,314,322,323,324,325),penerimaan,0)) AS jml_penerimaan,
					SUM(IF(jenis_biaya_id IN (28,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,307,308,309,310,311,312,314,322,323,324,325),pengeluaran,0)) AS jml_pengeluaran	
				FROM (
				SELECT jenis_biaya_id,nama, biaya.kategori_id,penerimaan,pengeluaran
				FROM jenis_biaya AS jb
				LEFT JOIN (SELECT
					jenis_biaya_id,vb.kategori_id,
					SUM(penerimaan) AS penerimaan,
					SUM(pengeluaran) AS pengeluaran
					FROM v_perkara_biaya_detil AS vb
					WHERE LEFT(tanggal_transaksi,7)='".$period."'
					AND alur_perkara_id IN (9)
					GROUP BY jenis_biaya_id) AS biaya ON biaya.jenis_biaya_id=jb.id
				GROUP BY id
				) AS tabel_biaya
				UNION
				SELECT 
					'Biaya Pemeriksaan Setempat' AS uraian,
					SUM(IF(kategori_id=7,penerimaan,0)) AS jml_penerimaan,
					SUM(IF(kategori_id=7,pengeluaran,0)) AS jml_pengeluaran	
				FROM (
				SELECT jenis_biaya_id,nama, biaya.kategori_id,penerimaan,pengeluaran
				FROM jenis_biaya AS jb
				LEFT JOIN (SELECT
					jenis_biaya_id,vb.kategori_id,
					SUM(penerimaan) AS penerimaan,
					SUM(pengeluaran) AS pengeluaran
					FROM v_perkara_biaya_detil AS vb
					WHERE LEFT(tanggal_transaksi,7)='".$period."'
					AND alur_perkara_id IN (9)
					GROUP BY jenis_biaya_id) AS biaya ON biaya.jenis_biaya_id=jb.id
				GROUP BY id
				) AS tabel_biaya
				UNION
				SELECT 
					'Biaya Pengumuman Media Masa Cetak' AS uraian,
					SUM(IF(jenis_biaya_id IN (29,313),penerimaan,0)) AS jml_penerimaan,
					SUM(IF(jenis_biaya_id IN (29,313),pengeluaran,0)) AS jml_pengeluaran	
				FROM (
				SELECT jenis_biaya_id,nama, biaya.kategori_id,penerimaan,pengeluaran
				FROM jenis_biaya AS jb
				LEFT JOIN (SELECT
					jenis_biaya_id,vb.kategori_id,
					SUM(penerimaan) AS penerimaan,
					SUM(pengeluaran) AS pengeluaran
					FROM v_perkara_biaya_detil AS vb
					WHERE LEFT(tanggal_transaksi,7)='".$period."'
					AND alur_perkara_id IN (9)
					GROUP BY jenis_biaya_id) AS biaya ON biaya.jenis_biaya_id=jb.id
				GROUP BY id
				) AS tabel_biaya
				UNION
				SELECT 
					'Biaya Penerjemah/Sumpah/Saksi' AS uraian,
					SUM(IF(kategori_id IN (9,10),penerimaan,0)) AS jml_penerimaan,
					SUM(IF(kategori_id IN (9,10),pengeluaran,0)) AS jml_pengeluaran	
				FROM (
				SELECT jenis_biaya_id,nama, biaya.kategori_id,penerimaan,pengeluaran
				FROM jenis_biaya AS jb
				LEFT JOIN (SELECT
					jenis_biaya_id,vb.kategori_id,
					SUM(penerimaan) AS penerimaan,
					SUM(pengeluaran) AS pengeluaran
					FROM v_perkara_biaya_detil AS vb
					WHERE LEFT(tanggal_transaksi,7)='".$period."'
					AND alur_perkara_id IN (9)
					GROUP BY jenis_biaya_id) AS biaya ON biaya.jenis_biaya_id=jb.id
				GROUP BY id
				) AS tabel_biaya
				UNION
				SELECT 
					'Pengiriman Biaya Perkara' AS uraian,
					SUM(IF(kategori_id IN (3),penerimaan,0)) AS jml_penerimaan,
					SUM(IF(kategori_id IN (3),pengeluaran,0)) AS jml_pengeluaran	
				FROM (
				SELECT jenis_biaya_id,nama, biaya.kategori_id,penerimaan,pengeluaran
				FROM jenis_biaya AS jb
				LEFT JOIN (SELECT
					jenis_biaya_id,vb.kategori_id,
					SUM(penerimaan) AS penerimaan,
					SUM(pengeluaran) AS pengeluaran
					FROM v_perkara_biaya_detil AS vb
					WHERE LEFT(tanggal_transaksi,7)='".$period."'
					AND alur_perkara_id IN (9)
					GROUP BY jenis_biaya_id) AS biaya ON biaya.jenis_biaya_id=jb.id
				GROUP BY id
				) AS tabel_biaya
				UNION
				SELECT 
					'Pemberkasan dan Pengiriman' AS uraian,
					SUM(IF(jenis_biaya_id IN (858,859.860),penerimaan,0)) AS jml_penerimaan,
					SUM(IF(jenis_biaya_id IN (858,859.860),pengeluaran,0)) AS jml_pengeluaran	
				FROM (
				SELECT jenis_biaya_id,nama, biaya.kategori_id,penerimaan,pengeluaran
				FROM jenis_biaya AS jb
				LEFT JOIN (SELECT
					jenis_biaya_id,vb.kategori_id,
					SUM(penerimaan) AS penerimaan,
					SUM(pengeluaran) AS pengeluaran
					FROM v_perkara_biaya_detil AS vb
					WHERE LEFT(tanggal_transaksi,7)='".$period."'
					AND alur_perkara_id IN (9)
					GROUP BY jenis_biaya_id) AS biaya ON biaya.jenis_biaya_id=jb.id
				GROUP BY id
				) AS tabel_biaya
				UNION
				SELECT 
					'Materai' AS uraian,
					SUM(IF(kategori_id IN (8),penerimaan,0)) AS jml_penerimaan,
					SUM(IF(kategori_id IN (8),pengeluaran,0)) AS jml_pengeluaran	
				FROM (
				SELECT jenis_biaya_id,nama, biaya.kategori_id,penerimaan,pengeluaran
				FROM jenis_biaya AS jb
				LEFT JOIN (SELECT
					jenis_biaya_id,vb.kategori_id,
					SUM(penerimaan) AS penerimaan,
					SUM(pengeluaran) AS pengeluaran
					FROM v_perkara_biaya_detil AS vb
					WHERE LEFT(tanggal_transaksi,7)='".$period."'
					AND alur_perkara_id IN (9)
					GROUP BY jenis_biaya_id) AS biaya ON biaya.jenis_biaya_id=jb.id
				GROUP BY id
				) AS tabel_biaya
				UNION
				SELECT 
					'Hak-Hak Kepaniteraan' AS uraian,
					SUM(IF(kategori_id IN (13),penerimaan,0)) AS jml_penerimaan,
					SUM(IF(kategori_id IN (13),pengeluaran,0)) AS jml_pengeluaran	
				FROM (
				SELECT jenis_biaya_id,nama, biaya.kategori_id,penerimaan,pengeluaran
				FROM jenis_biaya AS jb
				LEFT JOIN (SELECT
					jenis_biaya_id,vb.kategori_id,
					SUM(penerimaan) AS penerimaan,
					SUM(pengeluaran) AS pengeluaran
					FROM v_perkara_biaya_detil AS vb
					WHERE LEFT(tanggal_transaksi,7)='".$period."'
					AND alur_perkara_id IN (9)
					GROUP BY jenis_biaya_id) AS biaya ON biaya.jenis_biaya_id=jb.id
				GROUP BY id
				) AS tabel_biaya
				UNION
				SELECT 
					'Alat Tulis Kantor' AS uraian,
					SUM(IF(kategori_id IN (12),penerimaan,0)) AS jml_penerimaan,
					SUM(IF(kategori_id IN (12),pengeluaran,0)) AS jml_pengeluaran	
				FROM (
				SELECT jenis_biaya_id,nama, biaya.kategori_id,penerimaan,pengeluaran
				FROM jenis_biaya AS jb
				LEFT JOIN (SELECT
					jenis_biaya_id,vb.kategori_id,
					SUM(penerimaan) AS penerimaan,
					SUM(pengeluaran) AS pengeluaran
					FROM v_perkara_biaya_detil AS vb
					WHERE LEFT(tanggal_transaksi,7)='".$period."'
					AND alur_perkara_id IN (9)
					GROUP BY jenis_biaya_id) AS biaya ON biaya.jenis_biaya_id=jb.id
				GROUP BY id
				) AS tabel_biaya
				UNION
				SELECT 
					'Pengembalian Sisa Panjar Perkara' AS uraian,
					SUM(IF(jenis_biaya_id IN (151,166,181,196,211),penerimaan,0)) AS jml_penerimaan,
					SUM(IF(jenis_biaya_id IN (151,166,181,196,211),pengeluaran,0)) AS jml_pengeluaran	
				FROM (
				SELECT jenis_biaya_id,nama, biaya.kategori_id,penerimaan,pengeluaran
				FROM jenis_biaya AS jb
				LEFT JOIN (SELECT
					jenis_biaya_id,vb.kategori_id,
					SUM(penerimaan) AS penerimaan,
					SUM(pengeluaran) AS pengeluaran
					FROM v_perkara_biaya_detil AS vb
					WHERE LEFT(tanggal_transaksi,7)='".$period."'
					AND alur_perkara_id IN (9)
					GROUP BY jenis_biaya_id) AS biaya ON biaya.jenis_biaya_id=jb.id
				GROUP BY id
				) AS tabel_biaya
				UNION
				SELECT 
					'Penyetoran Kepada Negara' AS uraian,
					SUM(IF(jenis_biaya_id IN (338,339,340,341,342),penerimaan,0)) AS jml_penerimaan,
					SUM(IF(jenis_biaya_id IN (338,339,340,341,342),pengeluaran,0)) AS jml_pengeluaran	
				FROM (
				SELECT jenis_biaya_id,nama, biaya.kategori_id,penerimaan,pengeluaran
				FROM jenis_biaya AS jb
				LEFT JOIN (SELECT
					jenis_biaya_id,vb.kategori_id,
					SUM(penerimaan) AS penerimaan,
					SUM(pengeluaran) AS pengeluaran
					FROM v_perkara_biaya_detil AS vb
					WHERE LEFT(tanggal_transaksi,7)='".$period."'
					AND alur_perkara_id IN (9)
					GROUP BY jenis_biaya_id) AS biaya ON biaya.jenis_biaya_id=jb.id
				GROUP BY id
				) AS tabel_biaya");
		} catch (Exception $e) {
			log_message('error', $e);
		}	
	}

	function laporanKegiatanHakimTUN($period,$idalurperkara){
		try{
			return $this->db->query("SELECT
				hakim_pn.id,
				hakim_pn.nama_gelar,
				SUM(CASE WHEN (LEFT(v_perkara.tanggal_putusan,7) > '".$period."' OR v_perkara.tanggal_putusan IS NULL) AND LEFT(v_perkara.tanggal_pendaftaran,7) < '".$period."' THEN 1 ELSE 0 END ) AS beban,
				SUM(CASE WHEN LEFT(v_perkara.tanggal_pendaftaran,7) = '".$period."' THEN 1 ELSE 0 END) AS masuk,
				SUM(CASE WHEN LEFT(v_perkara.tanggal_putusan,7) ='".$period."' THEN 1 ELSE 0 END) AS putus,
				SUM(CASE WHEN LEFT(v_perkara.tanggal_minutasi,7) ='".$period."' THEN 1 ELSE 0 END) AS minutasi,
				SUM(CASE WHEN LEFT(v_perkara.tanggal_putusan,7) ='".$period."' AND v_perkara.tanggal_minutasi IS NULL THEN 1 ELSE 0 END) AS belumMinutasi
				FROM hakim_pn 
				LEFT JOIN (SELECT perkara_hakim_pn.* 
				FROM perkara_hakim_pn LEFT JOIN perkara ON perkara.perkara_id=perkara_hakim_pn.perkara_id 
				WHERE perkara.alur_perkara_id='".$idalurperkara."') AS perkara_hakim_pn ON perkara_hakim_pn.hakim_id=hakim_pn.id
				LEFT JOIN v_perkara ON v_perkara.perkara_id=perkara_hakim_pn.perkara_id
				WHERE hakim_pn.aktif='Y'
				GROUP BY hakim_pn.id");
		} catch (Exception $e) {
			log_message('error', $e);
		}	
	}


	function laporanKegiatanPPTUN($period,$idalurperkara){
		try{
			return $this->db->query("SELECT
				panitera_pn.id,
				panitera_pn.nama_gelar,
				SUM(CASE WHEN (LEFT(v_perkara.tanggal_putusan,7) > '".$period."' OR v_perkara.tanggal_putusan IS NULL) AND LEFT(v_perkara.tanggal_pendaftaran,7) < '".$period."' THEN 1 ELSE 0 END ) AS beban,
				SUM(CASE WHEN LEFT(v_perkara.tanggal_pendaftaran,7) = '".$period."' THEN 1 ELSE 0 END) AS masuk,
				SUM(CASE WHEN LEFT(v_perkara.tanggal_putusan,7) = '".$period."' THEN 1 ELSE 0 END) AS putus,
				SUM(CASE WHEN LEFT(v_perkara.tanggal_minutasi,7) = '".$period."' THEN 1 ELSE 0 END) AS minutasi,
				SUM(CASE WHEN LEFT(v_perkara.tanggal_putusan,7) = '".$period."' AND v_perkara.tanggal_minutasi IS NULL THEN 1 ELSE 0 END) AS belumMinutasi
				FROM panitera_pn 
				LEFT JOIN (SELECT perkara_panitera_pn.* FROM perkara_panitera_pn 
				LEFT JOIN perkara ON perkara.perkara_id=perkara_panitera_pn.perkara_id 
				WHERE perkara.alur_perkara_id='".$idalurperkara."') AS perkara_panitera ON perkara_panitera.panitera_id=panitera_pn.id
				LEFT JOIN v_perkara ON v_perkara.perkara_id=perkara_panitera.perkara_id
				WHERE panitera_pn.aktif='Y'
				GROUP BY panitera_pn.id");
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}


	function rekapPerkaraTahunTUN($period,$idalurperkara){
		try{
			return $this->db->query("SELECT 
				jap.jenis_perkara_id,
				jp.nama,
				hit.sisa,
				hit.masuk,
				hit.dismissal,
				hit.perlawanan,
				hit.cabut,
				hit.putusan,
				hit.belumminutasi,
				hit.banding,
				hit.kasasi,
				hit.pk,
				hit.eksekusi
			FROM jenis_alur_perkara AS jap
			LEFT JOIN jenis_perkara AS jp ON jp.id=jap.jenis_perkara_id
			LEFT JOIN (
				SELECT 
					t.jenis_perkara_id,
					SUM(IF(LEFT(t.tanggal_pendaftaran,4)<'".$period."' AND (t.tanggal_putusan IS NULL OR LEFT(t.tanggal_putusan,4) >= '".$period."'),1,0)) AS sisa,
					SUM(IF(LEFT(t.tanggal_pendaftaran,4)='".$period."',1,0)) AS masuk,
					SUM(IF(LEFT(dis.tanggal_penetapan,4)='".$period."',1,0)) AS dismissal,
					SUM(IF(LEFT(t.tanggal_pendaftaran_verzet,4)='".$period."',1,0)) AS perlawanan,
					SUM(IF(t.tanggal_cabut IS NOT NULL AND LEFT(t.tanggal_cabut,4)='".$period."',1,0)) AS cabut,
					SUM(IF(t.tanggal_putusan IS NOT NULL AND LEFT(t.tanggal_putusan,4)='".$period."',1,0)) AS putusan,
					SUM(IF(LEFT(t.tanggal_pendaftaran,4)<='".$period."' AND LEFT(t.tanggal_minutasi,4)='".$period."',1,0)) AS belumminutasi,
					SUM(IF(LEFT(banding.permohonan_banding,4)='".$period."',1,0)) AS banding,
					SUM(IF(LEFT(kasasi.permohonan_kasasi,4)='".$period."',1,0)) AS kasasi,
					SUM(IF(LEFT(pk.permohonan_pk,4)='".$period."',1,0)) AS pk,
					SUM(IF(LEFT(eksekusi.permohonan_eksekusi,4),1,0)) AS eksekusi
				FROM v_perkara AS t
				LEFT JOIN perkara_dismissal AS dis ON dis.perkara_id=t.perkara_id
				LEFT JOIN perkara_banding AS banding ON banding.perkara_id=t.perkara_id
				LEFT JOIN perkara_kasasi AS kasasi ON kasasi.perkara_id=t.perkara_id
				LEFT JOIN perkara_pk AS pk ON pk.perkara_id=t.perkara_id
				LEFT JOIN perkara_eksekusi AS eksekusi ON eksekusi.perkara_id=t.perkara_id
				WHERE t.alur_perkara_id='".$idalurperkara."'
				GROUP BY jenis_perkara_id
			) AS hit ON jap.jenis_perkara_id=hit.jenis_perkara_id
			WHERE jap.alur_perkara_id='".$idalurperkara."'");
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}


	function rekapPerkaraProsesTUN($period,$idalurperkara){
		try{
			return $this->db->query("SELECT 
				(CASE WHEN lamaProses<'3' THEN nomor_perkara ELSE '' END) AS equal3,
				(CASE WHEN lamaProses>='3' AND lamaProses<'5' THEN nomor_perkara ELSE '' END) AS equal5,
				(CASE WHEN lamaProses>='5' AND lamaProses<='12' THEN nomor_perkara ELSE '' END) AS equal12,
				(CASE WHEN lamaProses>'12' THEN nomor_perkara ELSE '' END) AS equal13
				FROM (SELECT nomor_perkara,tanggal_putusan,alur_perkara_id, TIMESTAMPDIFF(MONTH,tanggal_pendaftaran,tanggal_putusan) AS lamaProses FROM v_perkara) AS v_perkara
				WHERE LEFT(v_perkara.tanggal_putusan,4)='".$period."'
				AND v_perkara.alur_perkara_id='".$idalurperkara."'");
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}


	function rekapPutusanPTUN($period,$idalurperkara){
		try{
			return $this->db->query("SELECT
				nomor_perkara,
				status_putusan_id,
				(CASE WHEN status_putusan_id='35' THEN tanggal_putusan ELSE '' END) AS putusanDitolak,
				(CASE WHEN status_putusan_id='34' THEN tanggal_putusan ELSE '' END) AS putusanDikabulkan,
				(CASE WHEN status_putusan_id='36' THEN tanggal_putusan ELSE '' END) AS putusanNO,
				(SELECT COUNT(*) FROM v_perkara WHERE status_putusan_id='35' AND YEAR(tanggal_putusan)='".$period."' AND alur_perkara_id='9') AS jumlahDitolak,
				(SELECT COUNT(*) FROM v_perkara WHERE status_putusan_id='34' AND YEAR(tanggal_putusan)='".$period."' AND alur_perkara_id='9') AS jumlahDikabulkan,
				(SELECT COUNT(*) FROM v_perkara WHERE status_putusan_id='36' AND YEAR(tanggal_putusan)='".$period."' AND alur_perkara_id='9') AS jumlahNO,
				(SELECT COUNT(*) FROM v_perkara WHERE status_putusan_id IN (35,36,34) AND YEAR(tanggal_putusan)='".$period."' AND alur_perkara_id='9') AS jumlahPutusan
				FROM v_perkara
				WHERE LEFT(tanggal_putusan,4)='".$period."'
				AND alur_perkara_id='".$idalurperkara."'");
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}


	function rekapPutusanBandingTUN($period,$idalurperkara){
		try{
			return $this->db->query("SELECT
				nomor_perkara_pn,
				status_putusan_banding_id,
				(CASE WHEN status_putusan_banding_id='3' THEN putusan_banding ELSE '' END) AS putusanDitolak,
				(CASE WHEN status_putusan_banding_id='2' THEN putusan_banding ELSE '' END) AS putusanDikabulkan,
				(CASE WHEN status_putusan_banding_id='4' THEN putusan_banding ELSE '' END) AS putusanNO,
				(SELECT COUNT(*) FROM v_perkara_banding WHERE status_putusan_banding_id='3' AND YEAR(putusan_banding)='".$period."' AND alur_perkara_id='9') AS jumlahDitolak,
				(SELECT COUNT(*) FROM v_perkara_banding WHERE status_putusan_banding_id='2' AND YEAR(putusan_banding)='".$period."' AND alur_perkara_id='9') AS jumlahDikabulkan,
				(SELECT COUNT(*) FROM v_perkara_banding WHERE status_putusan_banding_id='4' AND YEAR(putusan_banding)='".$period."' AND alur_perkara_id='9') AS jumlahNO,
				(SELECT COUNT(*) FROM v_perkara_banding WHERE status_putusan_banding_id IN (3,2,4) AND YEAR(putusan_banding)='".$period."' AND alur_perkara_id='9') AS jumlahPutusan
				FROM v_perkara_banding
				WHERE LEFT(putusan_banding,4)='".$period."'
				AND alur_perkara_id='".$idalurperkara."'");
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}


	function rekapPutusanKasasiTUN($period,$idalurperkara){
		try{
			return $this->db->query("SELECT
				nomor_perkara_pn,
				status_putusan_kasasi_id,
				(CASE WHEN status_putusan_kasasi_id='3' THEN putusan_kasasi ELSE '' END) AS putusanDitolak,
				(CASE WHEN status_putusan_kasasi_id='2' THEN putusan_kasasi ELSE '' END) AS putusanDikabulkan,
				(CASE WHEN status_putusan_kasasi_id='4' THEN putusan_kasasi ELSE '' END) AS putusanNO,
				(SELECT COUNT(*) FROM v_perkara_kasasi WHERE status_putusan_kasasi_id='3' AND YEAR(putusan_kasasi)='".$period."' AND alur_perkara_id='9') AS jumlahDitolak,
				(SELECT COUNT(*) FROM v_perkara_kasasi WHERE status_putusan_kasasi_id='2' AND YEAR(putusan_kasasi)='".$period."' AND alur_perkara_id='9') AS jumlahDikabulkan,
				(SELECT COUNT(*) FROM v_perkara_kasasi WHERE status_putusan_kasasi_id='4' AND YEAR(putusan_kasasi)='".$period."' AND alur_perkara_id='9') AS jumlahNO,
				(SELECT COUNT(*) FROM v_perkara_kasasi WHERE status_putusan_kasasi_id IN (3,2,4) AND YEAR(putusan_kasasi)='".$period."' AND alur_perkara_id='9') AS jumlahPutusan
				FROM v_perkara_kasasi	
				WHERE LEFT(putusan_kasasi,4)='".$period."'
				AND alur_perkara_id='".$idalurperkara."'");
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}


	function rekapPutusanPKTUN($period,$idalurperkara){
		try{
			return $this->db->query("SELECT
				nomor_perkara_pn,
				status_putusan_pk_id,
				(CASE WHEN status_putusan_pk_id='3' THEN putusan_pk ELSE '' END) AS putusanDitolak,
				(CASE WHEN status_putusan_pk_id='2' THEN putusan_pk ELSE '' END) AS putusanDikabulkan,
				(CASE WHEN status_putusan_pk_id='4' THEN putusan_pk ELSE '' END) AS putusanNO,
				(SELECT COUNT(*) FROM v_perkara_pk WHERE status_putusan_pk_id='3' AND YEAR(putusan_pk)='".$period."' AND alur_perkara_id='9') AS jumlahDitolak,
				(SELECT COUNT(*) FROM v_perkara_pk WHERE status_putusan_pk_id='2' AND YEAR(putusan_pk)='".$period."' AND alur_perkara_id='9') AS jumlahDikabulkan,
				(SELECT COUNT(*) FROM v_perkara_pk WHERE status_putusan_pk_id='4' AND YEAR(putusan_pk)='".$period."' AND alur_perkara_id='9') AS jumlahNO,
				(SELECT COUNT(*) FROM v_perkara_pk WHERE status_putusan_pk_id IN (3,2,4) AND YEAR(putusan_pk)='".$period."' AND alur_perkara_id='9') AS jumlahPutusan
				FROM v_perkara_pk	
				WHERE LEFT(putusan_pk,4)='".$period."'
				AND alur_perkara_id='".$period."'");
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}







}