<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class data_putusan_akhir extends CI_Model{

	function isProdeo($idperkara){
		try{
			return $this->db->query("SELECT prodeo FROM perkara WHERE perkara_id='".$idperkara."'");
		}catch (Exception $e) {
			
		}
	}

	function getDataPutusanAkhir($idperkara){
		try {
			return $this->db->query('SELECT p.perkara_id,p.tanggal_putusan, p.putusan_verstek, s.nama AS sumber_hukum_nama,sp.nama AS status_putusan_nama,
				status_putusan_id,sumber_hukum_id,nilai_ganti_kerugian,pemberitahuan_putusan_ankum,pemberitahuan_putusan_pepera,
				tanggal_cabut,tanggal_gugur,amar_putusan,amar_putusan_dok,penetapan_hakim_pengawas,nomor_penetapan_hakim_pengawas,
				hakim_pengawas_id,kurator_id,tanggal_berita_putusan,nama_media_berita_putusan,tanggal_surat_kabar_putusan,nama_surat_kabar_putusan,
				tanggal_minutasi,pemberitahuan_putusan,pemberitahuan_putusan_pihak1,pemberitahuan_putusan_pihak2,pemberitahuan_putusan_pihak3,
				menerima_putusan_pihak1,menerima_putusan_pihak2,kirim_salinan_putusan_penyidik,catatan_putusan,
				k.nama AS kurator_nama, h.nama_gelar AS hakim_pengawas_nama FROM perkara_putusan AS p
				LEFT JOIN sumber_hukum AS s
				ON s.id = p.sumber_hukum_id
				LEFT JOIN status_putusan AS sp
				ON sp.id = p.status_putusan_id
				LEFT JOIN kurator AS k
				ON k.id = p.kurator_id
				LEFT JOIN hakim_pn AS h
				ON h.id = p.hakim_pengawas_id				
				WHERE perkara_id = '.$idperkara);#.' ORDER BY tanggal_putusan ASC');
		} catch (Exception $e) {
			
		}
	}

	function getAlurPerkara($idperkara){
		try {
			$result = $this->db->query('SELECT alur_perkara_id FROM perkara WHERE perkara_id ='.$idperkara);
			if($result->num_rows>0){
				return $result->row()->alur_perkara_id;
			}else{
				return '';
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function getDataStatusPutusan($alurperkara){
		try {
			if($alurperkara<100 OR $alurperkara==119){
				if($alurperkara<100){
				 	$alurperkara= 1;
				}elseif($alurperkara==119) {
					$alurperkara = 3;
				}
			}else{
				$alurperkara = 2;
			}

			$jenis_pengadilan=$this->session->userdata('jenis_pengadilan');
			
			return $this->db->query('SELECT id,nama,satuan FROM status_putusan WHERE aktif="Y" AND jenis_perkara_id ='.$alurperkara.' AND jenis_pengadilan='.$jenis_pengadilan.' and urutan<>0 ORDER BY urutan ASC');
		} catch (Exception $e) {
			
		}
	}

	function getDataSumberHukum(){
		try {
			return $this->db->query('SELECT id,nama FROM sumber_hukum WHERE aktif="Y" AND jenis_pengadilan='.$this->session->userdata('jenis_pengadilan').' ORDER BY nama ASC;');
		} catch (Exception $e) {
			
		}
	}

	function getDataFaktorPercerian(){
		try {
			return $this->db->query('SELECT id,nama FROM faktor_perceraian WHERE aktif="Y" ORDER BY nama ASC;');
		} catch (Exception $e) {
			
		}
	}
	function getKeadaanIstri($idperkara){
		try {
			return $this->db->query("SELECT keadaan_istri FROM perkara_akta_cerai WHERE perkara_id=$idperkara");
		} catch (Exception $e) {
			
		}
	}

	function getPerkaraFaktorPercerian($idperkara){
		try {
			return $this->db->query('SELECT pac.faktor_perceraian_id,pac.keadaan_istri,fp.nama FROM perkara_akta_cerai AS pac
							LEFT JOIN faktor_perceraian AS fp
							ON fp.id = pac.faktor_perceraian_id
							WHERE perkara_id='.$idperkara);
		} catch (Exception $e) {
			
		}
	}

	function getPihak($idperkara,$pihakke){
		try {
			$tergabung_ke = '';
			if($this->session->userdata('jenis_pengadilan')==3 AND $pihakke==3)
				$tergabung_ke = 'tergabung_ke_pihak,';
			
			$table_name = " perkara_pihak".$pihakke;
			return $this->db->query(' SELECT pp.perkara_id, pp.pihak_id,pp.id,ppp.pihak,urutan,nama,'.$tergabung_ke.'
				tanggal_pemberitahuan_putusan,tanggal_menerima_putusan,tanggal_kirim_salinan_putusan 
				FROM '.$table_name.' AS pp 
				LEFT JOIN perkara_putusan_pemberitahuan_putusan AS ppp
				ON ppp.perkara_id = pp.perkara_id AND ppp.pihak_id = pp.id AND ppp.pihak = '.$pihakke.'
				WHERE pp.perkara_id = '.$idperkara.' ORDER BY urutan;');
			echo $this->db->query;
		} catch (Exception $e) {
			
		}
	}

	function getPutusanTerdakwa($idperkara){
		try {
			return $this->db->query('SELECT p.id,p.perkara_id,p.urutan,p.pihak_id,p.nama,durasi_nominal,tanggal_putusan,
				s.nama AS status_putusan_text,pp.satuan,pp.status_putusan_id AS status_putusan_id,pp.pihak2_id 
				FROM perkara_pihak2 AS p 
				LEFT JOIN
				perkara_putusan_terdakwa AS pp
				ON pp.perkara_id = p.perkara_id AND pp.pihak2_id = p.id
				LEFT JOIN status_putusan AS s
				ON s.id = pp.status_putusan_id
				WHERE p.perkara_id = '.$idperkara.' ORDER BY p.urutan;');
		} catch (Exception $e) {
		}
	}

	function getTanggalPutusan($idpihak){
		try {
			$result = $this->db->query('SELECT tanggal_putusan FROM perkara_putusan_terdakwa WHERE pihak2_id ='.$idpihak);
			if($result->num_rows>0){
				return $result->row()->tanggal_putusan;
			}else{
				return '';
			}
		} catch (Exception $e) {
			return '';
		}
	}


	function getStatusPutusanAkhir($idperkara){
		try {
			$result = $this->db->query('SELECT status_putusan_id FROM perkara_putusan WHERE perkara_id='.$idperkara);
			if($result->num_rows>0){
				return $result->row()->status_putusan_id;
			}else{
				return '';
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function getTanggalBHT($idperkara){
		try {
			$result = $this->db->query('SELECT tanggal_bht FROM perkara_putusan WHERE perkara_id ='.$idperkara);
			if($result->num_rows>0){
				return $result->row()->tanggal_bht;
			}else{
				return '';
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function getTanggalMinPutusanTerdakwa($idperkara){
		try {
			$result = $this->db->query('SELECT min(tanggal_putusan) AS tanggal_putusan FROM perkara_putusan_terdakwa WHERE perkara_id ='.$idperkara);
			if($result->num_rows>0){
				return $result->row()->tanggal_putusan;
			}else{
				return '';
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function getIDPihak($id,$idperkara){
		try {
			$query = $this->db->query('SELECT pihak_id FROM perkara_pihak2 WHERE perkara_id ='.$idperkara.' AND id='.$id);
			if($query->num_rows>0){
				return $query->row()->pihak_id;
			}else{
				return 0;
			}
		} catch (Exception $e) {
			
		}
	}
	function getTanggalSidangPertama($idperkara){
		try {
			$result = $this->db->query('SELECT sidang_pertama AS tgl FROM v_perkara WHERE perkara_id = '.$idperkara);
			if($result->num_rows>0){
				return $result->row()->tgl;
			}else{
				return '';
			}
		} catch (Exception $e) {
			
		}
	}
	function getSidangPertama($idperkara){
		try {
			$result = $this->db->query("SELECT tanggal_sidang FROM perkara_jadwal_sidang WHERE verzet='T' AND keberatan='T' AND ikrar_talak='T' AND ditunda='T' AND perkara_id=".$idperkara);
			if($result->num_rows>0){
				return $result->row()->tanggal_sidang;
			}else{
				return '';
			}
		} catch (Exception $e) {
			
		}
	}

	function getListHakim(){
		try {
			return $this->db->query('SELECT id,nama_gelar FROM hakim_pn WHERE aktif="Y" ORDER BY nama ASC;');
		} catch (Exception $e) {
			
		}
	}

	function getListKurator(){
		try {
			return $this->db->query('SELECT pihak_id,nama FROM kurator ORDER BY nama ASC;');
		} catch (Exception $e) {
			
		}
	}

	function getTimestamp($idperkara){
		try {
			return $this->db->query('SELECT diinput_oleh,diinput_tanggal FROM perkara_putusan WHERE perkara_id = '.$idperkara);
		} catch (Exception $e) {
			
		}
	}

	function add($data,$act){
		try {
			if($act=='update'){
				$this->db->where('perkara_id',$data['perkara_id']);
				$this->db->update('perkara_putusan',$data);
			}else{
				$this->db->replace('perkara_putusan',$data);
			}
			
			$this->db->simple_query("CALL perkara_proses_update(".$data['perkara_id'].", 15, 'Putusan', 210, 'Putusan', '".$data['tanggal_putusan']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			$this->db->simple_query("CALL perkara_update_status(".$data['perkara_id'].");");
			$title = $act." Data Putusan Akhir <br />dengan perkara_id [id=".$data['perkara_id']."]";
			$descrip = $this->fetch_description($title,$data);
			$this->add_audittrail($act,$title,$descrip,'perkara_putusan');
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function addPemberitahuan($data,$act){
		try {
			$this->db->replace('perkara_putusan_pemberitahuan_putusan',$data);
			if(!empty($data['tanggal_pemberitahuan_putusan'])){
				$this->db->simple_query("CALL perkara_proses_update(".$data['perkara_id'].", 15, 'Putusan', 218, 'Pemberitahuan Putusan', '".$data['tanggal_pemberitahuan_putusan']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
				$this->db->simple_query("CALL perkara_update_status(".$data['perkara_id'].");");
			}
			$title = $act." Data Pemberitahuan Putusan Akhir <br />dengan perkara_id [id=".$data['perkara_id']."]";
			$descrip = $this->fetch_description($title,$data);
			$this->add_audittrail($act,$title,$descrip,'perkara_putusan_pemberitahuan_putusan');
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function deletePerkaraProses($idperkara){
		try {
			$this->db->where('perkara_id', $idperkara);
			$this->db->delete('perkara_putusan_pemberitahuan_putusan');
			$this->db->simple_query("CALL perkara_proses_delete(".$idperkara.", 218);");
			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
		} catch (Exception $e) {
			
		}

	}
	
	function updateDataPemberitahuan($data,$idperkara){
		try {
			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_putusan', $data);
			$status = 'UPDATE';

			if(empty($data['tanggal_kirim_salinan_putusan'])){
				$status = 'DELETE';
				$this->db->simple_query("CALL perkara_proses_delete(".$data['perkara_id'].", 219);");
				$this->db->simple_query("CALL perkara_update_status(".$data['perkara_id'].");");
			}else{
				$this->db->simple_query("CALL perkara_proses_update(".$data['perkara_id'].", 15, 'Putusan', 219, 'Kirim Salinan Putusan', '".$data['kirim_salinan_putusan_penyidik']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
				$this->db->simple_query("CALL perkara_update_status(".$data['perkara_id'].");");
			}

			if(empty($data['tanggal_minutasi'])){
				$status = 'DELETE';
				$this->db->simple_query("CALL perkara_proses_delete(".$data['perkara_id'].", 220);");
				$this->db->simple_query("CALL perkara_update_status(".$data['perkara_id'].");");
			}else{
				$this->db->simple_query("CALL perkara_proses_update(".$data['perkara_id'].", 15, 'Putusan', 220, 'Minutasi', '".$data['tanggal_minutasi']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
				$this->db->simple_query("CALL perkara_update_status(".$data['perkara_id'].");");
			}

			$title = $status." Data Minutasi <br/>dengan perkara_id [id=".$data['perkara_id']."]";
			$descrip = $this->fetch_description($title,$data);
			$this->add_audittrail($status,$title,$descrip,'perkara_putusan');
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}
	function fetch_description($title,$data){
		$descrip = '<br><table style="vertical-align:top" cellspacing="0" cellpadding="1" border="1">';
		$descrip .= '<tr><th>Nama Kolom</th><th>Nilai</th></tr>';
		foreach ($data as $key => $value) {
			$descrip .= '<tr>';
			$descrip .= '<td>'.$key.'</td>';
			$descrip .= '<td>'.$value.'</td>';
			$descrip .= '</tr>';
		}
		$descrip .= '</table>';
		return $descrip;
	}

	function add_audittrail($action,$title,$descrip,$tablename){
		try {
			$data = array(
				'datetime' => date("Y-m-d H:i:s"),
				'ipaddress' => $this->input->ip_address(),
				'username' => $this->session->userdata('username'),
				'tablename' => $tablename,
				'formname' => 'Add Perkara Perdata',
				'action' => $action,
				'title' => $title,
				'description' => $descrip
			);
			$this->db->insert('sys_audittrail', $data);
		} catch (Exception $e) {
			
		}
	}

	function isDataPutusanExists($idperkara){
		try {
			$result = $this->db->query('SELECT perkara_id FROM perkara_putusan WHERE perkara_id ='.$idperkara);
			if($result->num_rows>0){
				return TRUE;
			}else{
				return FALSE;
			}
		} catch (Exception $e) {
			return '';
		}
	}


	function addDataTerdakwa($data){
		try {
			$idperkara = '';
			foreach ($data as $row) {
				$idperkara = $row['perkara_id'];
				$this->db->replace('perkara_putusan_terdakwa',$row);
				$title = "Tambah Data Putusan Akhir Terdakwa <br />dengan perkara_id [id=".$idperkara."]";
				$descrip = $this->fetch_description($title,$row);
				$this->add_audittrail("INSERT",$title,$descrip,'perkara_putusan_terdakwa');
			}
			$this->updateTanggalPutusan($idperkara);
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function updateDataTerdakwa($data){
		try {
			$idperkara = '';
			foreach ($data as $row) {
				$idperkara = $row['perkara_id'];
				$data_user = $this->getUsernameInput($row['perkara_id'],$row['pihak2_id']);
				foreach ($data_user->result() as $info) {
					$row['diinput_oleh'] = $info->diinput_oleh;
					$row['diinput_tanggal'] = $info->diinput_tanggal;
				}
				$this->db->where('perkara_id', $row['perkara_id']);
				$this->db->where('pihak2_id', $row['pihak2_id']);
				$this->db->delete('perkara_putusan_terdakwa');
			}
			foreach ($data as $row) {
				$idperkara = $row['perkara_id'];
				$this->db->replace('perkara_putusan_terdakwa',$row);
				$title = "Update Data Putusan Akhir Terdakwa <br />dengan perkara_id [id=".$idperkara."]";
				$descrip = $this->fetch_description($title,$row);
				$this->add_audittrail("UPDATE",$title,$descrip,'perkara_putusan_terdakwa');
			}
			
			$this->updateTanggalPutusan($idperkara);
			return TRUE;
		} catch (Exception $e){
			return FALSE;
		}
	}

	function updateTanggalPutusan($idperkara){
		try {
			$data['perkara_id'] = $idperkara;
			$data['tanggal_putusan'] = $this->getTanggalMinPutusanTerdakwa($idperkara);
			if($this->isDataPutusanExists($idperkara)==FALSE){	
				$this->db->insert('perkara_putusan',$data);
			}else{
				$this->db->where('perkara_id', $idperkara);
				$this->db->update('perkara_putusan', $data);
			}
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function getUsernameInput($idperkara,$pihak2_id){
		try {
			return $this->db->query('SELECT diinput_oleh,diinput_tanggal FROM perkara_putusan_terdakwa 
				WHERE pihak2_id='.$pihak2_id.' AND perkara_id ='.$idperkara);
		} catch (Exception $e) {
			
		}
	}

	function delData($idperkara){
		try {
			$this->db->query("DELETE FROM perkara_putusan WHERE perkara_id =".$idperkara);
			$this->db->query("DELETE FROM perkara_putusan_terdakwa WHERE perkara_id =".$idperkara);
			$this->db->query("DELETE FROM perkara_putusan_pemberitahuan_putusan WHERE perkara_id =".$idperkara);
			$this->db->query("DELETE FROM perkara_akta_cerai WHERE perkara_id =".$idperkara);
			$this->db->query("DELETE FROM perkara_proses WHERE proses_id = 210 AND perkara_id =".$idperkara);
			#$this->db->simple_query("CALL perkara_proses_delete(".$idperkara.", 210);");
			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			$title = "Delete Data Putusan Akhir <br />dengan perkara_id [id=".$idperkara."] Oleh = ".$this->session->userdata('username');
			$this->add_audittrail("DELETE",$title,'DELETE DATA PUTUSAN','perkara_putusan');
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function addFaktorPenyebab($faktor_percerian,$idperkara,$status=''){
		try {
			if($status==62){
				$this->db->query('INSERT INTO perkara_akta_cerai (perkara_id,faktor_perceraian_id,diinput_oleh,diinput_tanggal)
									VALUES('.$idperkara.','.$faktor_percerian.',"'.$this->session->userdata('username').'","'.date("Y-m-d h:i:s",time()).'")');
			}else{
				$this->db->where('perkara_id',$idperkara);
				$this->db->delete('perkara_akta_cerai');
			}
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function updateFaktorPenyebab($faktor_percerian,$idperkara,$status=''){
		try {
			if($status==62){
			$this->db->query('UPDATE perkara_akta_cerai SET faktor_perceraian_id = '.$faktor_percerian.',diperbaharui_oleh = "'.$this->session->userdata('username').'",diperbaharui_tanggal = "'.date("Y-m-d h:i:s",time()).'" WHERE perkara_id = '.$idperkara.';');
			}else{
				$this->db->where('perkara_id',$idperkara);
				$this->db->delete('perkara_akta_cerai');
			}
			
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function addKeadaanIstri($keadaan_istri,$idperkara){
		try {
			$this->db->query('INSERT INTO perkara_akta_cerai (perkara_id,keadaan_istri,diinput_oleh,diinput_tanggal)
								VALUES('.$idperkara.','.$keadaan_istri.',"'.$this->session->userdata('username').'","'.date("Y-m-d h:i:s",time()).'")');
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function updateKeadaanIstri($keadaan_istri,$idperkara){
		try {
			$this->db->query('UPDATE perkara_akta_cerai SET keadaan_istri = '.$keadaan_istri.',diperbaharui_oleh = "'.$this->session->userdata('username').'",diperbaharui_tanggal = "'.date("Y-m-d h:i:s",time()).'" WHERE perkara_id = '.$idperkara.';');
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}
	function getInfoPenyebabCerai($idperkara){
		try {
			$result = $this->db->query('SELECT faktor_perceraian_id FROM perkara_akta_cerai WHERE perkara_id = '.$idperkara.';');
			if(!empty($result)){
				if($result->num_rows>0){
					if(!empty($result->row()->faktor_perceraian_id))
						return 1;
				}
			}
			return 0;
		} catch (Exception $e) {
			return '';
		}
	}
	function hasBiayaRedaksi($idperkara){
		try {
			$result = $this->db->query('SELECT perkara_id FROM perkara_biaya WHERE 
				(jenis_biaya_id = 157 OR jenis_biaya_id=152) AND perkara_id = '.$idperkara);
			if($result->num_rows>=2){
				return TRUE;
			}else{
				return FALSE;
			}
		} catch (Exception $e) {
			return -1;
		}
	}

	function getPetitumDakwaan($idperkara,$idalurperkara){
		try{
			$qry ="SELECT petitum,dakwaan FROM perkara WHERE perkara_id=$idperkara";
			$query=$this->db->query($qry);
			if($query->num_rows>0){
				if($idalurperkara<100)
					return $query->row()->petitum;
				else
					return $query->row()->dakwaan;
			}
			return null;
		}catch (Exception $e){
			return FALSE;
		}
	}

	function getDataAktaNikah($idperkara){
		try {
			$query = $this->db->query('SELECT * FROM perkara_data_pernikahan WHERE perkara_id='.$idperkara);
			return $query;
		} catch (Exception $e) {
			return FALSE;
		}
	}
	// function updateEdoc($idperkara,$data){
		// try {
			// $this->db->where('perkara_id',$idperkara);
			// $this->db->update('perkara_putusan',$data);
			// return TRUE;
		// } catch (Exception $e) {
			// return FALSE;
		// }
	// }

	// function getEdocPath($idperkara){
		// try {
			// $result = $this->db->query('SELECT amar_putusan_dok FROM perkara_putusan WHERE perkara_id ='.$idperkara);
			// if($result->num_rows>0){
				// return $result->row()->amar_putusan_dok;
			// }else{
				// return '';
			// }
		// } catch (Exception $e) {
			// return '';
		// }
	// }
}
/* End of file data_putusan_akhir.php */
/* Location: ./application/models/putusan/data_putusan_akhir.php */