<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Penetapan_gugur_scc extends CI_Model{
	
	function get_data_perkara($idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			return $this->db->get('perkara');
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function get_data_penetapan($idperkara){
		try {
			$this->db->select('tanggal_putusan,amar_putusan,amar_putusan_dok,tanggal_minutasi');
			$this->db->where('perkara_id',$idperkara);
			return $this->db->get('perkara_putusan');
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_maxid_perkara_putusan(){
		try {

			$query = $this->db->query('SELECT MAX(perkara_id)+1 AS maxidput  FROM perkara_putusan');
			return $query;
			
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	

	function add_penetapan($data_add){
		try {
				$this->db->replace('perkara_putusan', $data_add);
				$title = "Tambah Data Penetapan Gugur <br />Tambah table <b>perkara_putusan</b> dari halaman <b>Penetapan Gugur</b> dengan Primary Key [perkara_id=".$data_add['perkara_id']."]";
				$descrip = $this->fetch_description($title,$data_add);
				$this->add_audittrail("INSERT",$title,$descrip,'perkara_putusan');
				$this->db->simple_query("CALL perkara_proses_update(".$data_add['perkara_id'].", 15, 'Putusan', 212, 'Pernyataan Gugur', '".$data_add['tanggal_putusan']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
				$this->db->simple_query("CALL perkara_update_status(".$data_add['perkara_id'].");");
				return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function update_penetapan($idperkara,$data_add){
		try {
				$this->db->where('perkara_id',$idperkara);
				$this->db->update('perkara_putusan',$data_add);
				$title = "UPDATE Data Penetapan Gugur <br />Tambah table <b>perkara_putusan</b> dari halaman <b>Penetapan Gugur</b> dengan Primary Key [perkara_id=".$data_add['perkara_id']."]";
				$descrip = $this->fetch_description($title,$data_add);
				$this->add_audittrail("UPDATE",$title,$descrip,'perkara_putusan');
				$this->db->simple_query("CALL perkara_proses_update(".$data_add['perkara_id'].", 15, 'Putusan', 212, 'Pernyataan Gugur', '".$data_add['tanggal_putusan']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
				$this->db->simple_query("CALL perkara_update_status(".$data_add['perkara_id'].");");
				return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function update_minutasi($idperkara,$data_add){
		try {
				$this->db->where('perkara_id',$idperkara);
				$this->db->update('perkara_putusan',$data_add);
				$title = "UPDATE Data Minutasi <br />Tambah table <b>perkara_putusan</b> dari halaman <b>Pemberitahuan Penetapan Gugur</b> dengan Primary Key [perkara_id=".$data_add['perkara_id']."]";
				$descrip = $this->fetch_description($title,$data_add);
				$this->add_audittrail("UPDATE",$title,$descrip,'perkara_putusan');
				$this->db->simple_query("CALL perkara_proses_update(".$data_add['perkara_id'].", 15, 'Putusan', 220, 'Minutasi', '".$data_add['tanggal_minutasi']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
				$this->db->simple_query("CALL perkara_update_status(".$data_add['perkara_id'].");");
				return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function fetch_description($title,$data){
		$descrip = '<br><table style="vertical-align:top" cellspacing="0" cellpadding="1" border="1">';
		$descrip .= '<tr><th>Nama Kolom</th><th>Nilai</th></tr>';
		foreach ($data as $key => $value) {
			$descrip .= '<tr>';
			$descrip .= '<td>'.$key.'</td>';
			$descrip .= '<td>'.$value.'</td>';
			$descrip .= '</tr>';
		}
		$descrip .= '</table>';
		return $descrip;
	}

	function add_audittrail($action,$title,$descrip,$tablename){
		try {
			$data = array(
				'datetime' => date("Y-m-d H:i:s"),
				'ipaddress' => $this->input->ip_address(),
				'username' => $this->session->userdata('username'),
				'tablename' => $tablename,
				'formname' => 'Add Mediasi',
				'action' => $action,
				'title' => $title,
				'description' => $descrip
			);
			$this->db->insert('sys_audittrail', $data);
		} catch (Exception $e) {
			
		}
	}

	function deleteData($idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->delete('perkara_putusan');
			$title = "DELETE DATA PENETAPAN GUGUR dari halaman <b>EDIT DATA PENETAPAN GUGUR</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$this->add_audittrail("DELETE",$title,'DELETE DATA PENETAPAN GUGUR','perkara_putusan');

			$this->db->where('perkara_id',$idperkara);
			$this->db->where('tahapan_id',15);
			$this->db->delete('perkara_proses');
			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function getPihak($idperkara,$pihakke){
		try {
			$table_name = " perkara_pihak".$pihakke;
			return $this->db->query(' SELECT pp.perkara_id, pp.pihak_id,pp.id,ppp.pihak,urutan,nama,
				tanggal_pemberitahuan_putusan,tanggal_menerima_putusan,tanggal_kirim_salinan_putusan 
				FROM '.$table_name.' AS pp 
				LEFT JOIN perkara_putusan_pemberitahuan_putusan AS ppp
				ON ppp.perkara_id = pp.perkara_id AND ppp.pihak_id = pp.pihak_id
				WHERE pp.perkara_id = '.$idperkara.' ORDER BY urutan;');
		} catch (Exception $e) {
			
		}
	}

	function add_pemberitahuan_penetapan($data){
		try {
			foreach ($data as $data_add) {
				$this->db->replace('perkara_putusan_pemberitahuan_putusan', $data_add);
				$title = "Tambah Data Pemberitahuan Penetapan Gugur <br />Tambah table <b>perkara_putusan_pemberitahuan_putusan</b> dari halaman <b>Pemberitahuan Penetapan Gugur</b> dengan Primary Key [perkara_id=".$data_add['perkara_id']."]";
				$descrip = $this->fetch_description($title,$data_add);
				$this->add_audittrail("INSERT",$title,$descrip,'perkara_putusan_pemberitahuan_putusan');
			}	
			
			$this->db->simple_query("CALL perkara_proses_update(".$data_add['perkara_id'].", 15, 'Putusan', 218, 'Pemberitahuan Putusan', '".$data_add['tanggal_pemberitahuan_putusan']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			$this->db->simple_query("CALL perkara_update_status(".$data_add['perkara_id'].");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}
}

?>