<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class diversi_m extends CI_Model{
	
	function get_no_perkara($perkara_id){
		try {
			$query = $this->db->query("SELECT nomor_perkara, alur_perkara_id
				FROM perkara 
				WHERE perkara_id='".$perkara_id."';");
			return $query->result();
		} catch (Exception $e) {
			return '';
		}
	}

	function get_data_diversi($perkara_id){
		try {
			$this->db->where("perkara_id", $perkara_id);
			return $this->db->get('perkara_diversi')->row(0);
		} catch (Exception $e) {
			return '';
		}
	}

	function get_data_terdakwa($perkara_id){
		try {
			$query=$this->db->query("SELECT 
                                        anak.id 
                                        ,anak.urutan
                                        ,anak.nama as nama_anak
                                        ,anak.alamat 
                                        ,anak.pihak_id
                                        ,(SELECT a.nama FROM jenis_penahanan AS a WHERE a.id=anak.ditahan_oleh_id) AS ditahan_oleh
                                        ,(SELECT b.nama FROM status_penahanan AS b WHERE b.id=anak.status_penahanan_id) AS status_penahanan 
                                        ,(SELECT c.nama FROM jenis_tahanan AS c WHERE c.id=anak.jenis_tahanan_id) AS jenis_tahanan
                                        ,ot.id_orang_tua
                                        ,p.nama as nama_orang_tua           
                                    FROM perkara_pihak2 AS anak
                                    	LEFT JOIN perkara_pihak_orang_tua AS ot ON ot.id_anak=anak.pihak_id
                                        LEFT JOIN pihak p ON ot.id_orang_tua=p.id
                                    WHERE anak.perkara_id=".$perkara_id." ORDER BY anak.urutan");
			return $query->result();
		} catch (Exception $e) {
			return '';
		}
	}

	function get_data_korban($perkara_id){
		try {
			$query=$this->db->query("SELECT pp2.id, pp2.urutan, pp2.perkara_id, pp2.pihak_id AS id_anak, pp2.nama AS nama_anak, pot.id_orang_tua, p.nama AS nama_orang_tua 
									FROM (SELECT * FROM perkara_pihak_korban WHERE perkara_id=".$perkara_id.") AS pp2
										LEFT JOIN perkara_pihak_orang_tua pot ON pp2.pihak_id=pot.id_anak AND pot.jenis_pihak_anak=1
										LEFT JOIN pihak p ON p.id=pot.id_orang_tua;");
			return $query->result();
		} catch (Exception $e) {
			return '';
		}
	}

	function get_data_pembimbing($perkara_id){
		try {
			$this->db->where("perkara_id", $perkara_id);
			return $this->db->get('perkara_pihak_pembimbing_masyarakat')->result();
		} catch (Exception $e) {
			return '';
		}
	}

	function get_data_penyidik($perkara_id){
		try {
			$this->db->where("perkara_id", $perkara_id);
			return $this->db->get('perkara_pihak_penyidik')->result();
		} catch (Exception $e) {
			return '';
		}
	}

	function simpan_data_awal($perkara_id, $pihak_diversi, $no_reg_penyidik, $no_reg_penuntut_umum, $tgl_musyawarah, $tgl_penetapan_musyawarah){
		try {
			$data=array(
				"perkara_id" => $perkara_id,
	            "pihak_diversi" => $pihak_diversi,
	            "no_reg_penyidik" => $no_reg_penyidik,
	            "no_reg_penuntut_umum" => $no_reg_penuntut_umum,
	            "tgl_penetapan_musyawarah" => $tgl_penetapan_musyawarah,
	            "tgl_musyawarah" => $tgl_musyawarah,
	            "hasil_diversi" => -1
			);			
			$this->db->insert('perkara_diversi', $data);
			$title = "INSERT table <b>perkara_diversi</b> dari halaman <b>Tambah Data Diversi</b> dengan Primary Key [perkara_id=".$perkara_id."]";
			$descrip = $this->fetch_description($title,$data);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara');

			$data=array(
					'tahapan_terakhir_id'=> 12,
                    'tahapan_terakhir_text'=> 'Diversi',
                    'proses_terakhir_id'=> 75,
                    'proses_terakhir_text'=> 'Musyawarah Diversi',
                    'diperbaharui_oleh' => $this->session->userdata('username'),
					'diperbaharui_tanggal' => date('Y-m-d H:i:s')
			);
			$this->db->where('perkara_id', $perkara_id);
			$this->db->update('perkara', $data);
			$title = "UPDATE table <b>perkara</b> dari halaman <b>Tambah Data Diversi</b> dengan Primary Key [perkara_id=".$perkara_id."]";
			$descrip = $this->fetch_description($title,$data);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara');

			return $this->db->simple_query("CALL perkara_proses_update('".$perkara_id."','12','Musyawarah Diversi','75','Musyawarah Diversi',
                '".$tgl_musyawarah."','','".$this->session->userdata('username')."','".date("Y-m-d H:i:s")."');");

		} catch (Exception $e) {
			return false;
		}
	}

	function cek($perkara_id,$tahapan){
        $sql_cek=$this->db->query("SELECT tahapan_id from perkara_proses where perkara_id='".$perkara_id."' and tahapan_id='".$tahapan."'");
        return $sql_cek->first_row()->tahapan_id;
    }

	function edit_diversi_oleh_hakim($perkara_id, $pihak_diversi, $no_reg_penyidik, $no_reg_penuntut_umum, $tgl_musyawarah, $tgl_penetapan_musyawarah,
									$hasil_diversi, $tgl_kesepakatan_diversi, $tgl_laporan_hakim, $isi_singkat_diversi_text	){
		try {
			$data=array(
	            "pihak_diversi" => $pihak_diversi,
	            "no_reg_penyidik" => $no_reg_penyidik,
	            "no_reg_penuntut_umum" => $no_reg_penuntut_umum,
	            "tgl_penetapan_musyawarah" => $tgl_penetapan_musyawarah,
	            "tgl_musyawarah" => $tgl_musyawarah,
	            "hasil_diversi" => $hasil_diversi,
	            "tgl_kesepakatan_diversi" => $tgl_kesepakatan_diversi,
	            "tgl_laporan_hakim" => $tgl_laporan_hakim, 
	            "isi_singkat_diversi" => $isi_singkat_diversi_text
			);		
			$this->db->where('perkara_id', $perkara_id);	
			$this->db->update('perkara_diversi', $data);
			$title = "UPDATE table <b>perkara_diversi</b> dari halaman <b>EDIT Data Diversi</b> dengan Primary Key [perkara_id=".$perkara_id."]";
			$descrip = $this->fetch_description($title,$data);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara');

			if ($hasil_diversi==1){
				$data=array(
					'tahapan_terakhir_id'=> 15,
                    'tahapan_terakhir_text'=> 'Diversi',
                    'proses_terakhir_id'=> 213,
                    'proses_terakhir_text'=> 'Diversi Berhasil',
                    'diperbaharui_oleh' => $this->session->userdata('username'),
					'diperbaharui_tanggal' => date('Y-m-d H:i:s')
				);	
				$this->db->simple_query("CALL perkara_proses_update(".$perkara_id.",'15','Diversi','213','Diversi Berhasil',
                	'".$tgl_kesepakatan_diversi."','','".$this->session->userdata('username')."','".date("Y-m-d H:i:s")."');");
			}else if($hasil_diversi==0){
				$data=array(
					'tahapan_terakhir_id'=> 12,
                    'tahapan_terakhir_text'=> 'Diversi',
                    'proses_terakhir_id'=> 76,
                    'proses_terakhir_text'=> 'Diversi Gagal',
                    'diperbaharui_oleh' => $this->session->userdata('username'),
					'diperbaharui_tanggal' => date('Y-m-d H:i:s')
				);
				$this->db->simple_query("CALL perkara_proses_update(".$perkara_id.",'12','Diversi','76','Diversi Gagal',
                	'".$tgl_kesepakatan_diversi."','','".$this->session->userdata('username')."','".date("Y-m-d H:i:s")."');");
			}
			
			$this->db->where('perkara_id', $perkara_id);
			$this->db->update('perkara', $data);
			$title = "UPDATE table <b>perkara</b> dari halaman <b>EDIT Data Diversi</b> dengan Primary Key [perkara_id=".$perkara_id."]";
			$descrip = $this->fetch_description($title,$data);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara');

			return true;
		} catch (Exception $e) {
			return false;
		}
	}

	function edit_diversi_oleh_kpn($perkara_id, $tgl_penetapan_diversi, $no_penetapan_diversi, $tgl_pelaksanaan_isi_diversi, $tgl_minutasi){
		try {
			$data=array(
	            "tgl_penetapan_kesepakatan_diversi" => $tgl_penetapan_diversi,
	            "no_penetapan_kesepakatan" => $no_penetapan_diversi,
	            "tgl_pelaksanaan_isi_diversi" => $tgl_pelaksanaan_isi_diversi,
	            "tgl_minutasi" => $tgl_minutasi
			);		
			$this->db->where('perkara_id', $perkara_id);	
			$this->db->update('perkara_diversi', $data);
			$title = "UPDATE table <b>perkara_diversi</b> dari halaman <b>EDIT Data Diversi</b> dengan Primary Key [perkara_id=".$perkara_id."]";
			$descrip = $this->fetch_description($title,$data);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara');

			if ($tgl_minutasi!=''){
				$data=array(
					'tahapan_terakhir_id'=> 15,
                    'tahapan_terakhir_text'=> 'Diversi',
                    'proses_terakhir_id'=> 220,
                    'proses_terakhir_text'=> 'Minutasi',
                    'diperbaharui_oleh' => $this->session->userdata('username'),
					'diperbaharui_tanggal' => date('Y-m-d H:i:s')
				);	
				$this->db->where('perkara_id', $perkara_id);
				$this->db->update('perkara', $data);
				$title = "UPDATE table <b>perkara</b> dari halaman <b>EDIT Data Diversi</b> dengan Primary Key [perkara_id=".$perkara_id."]";
				$descrip = $this->fetch_description($title,$data);
				$this->add_audittrail("UPDATE",$title,$descrip,'perkara');

				//return $this->db->simple_query("CALL perkara_proses_update(".$perkara_id.",'15','Diversi','220','Pembuatan Minutasi',
                //	'".$tgl_minutasi."','','".$this->session->userdata('username')."','".date("Y-m-d H:i:s")."');");
                $data=array(
                		'perkara_id'=>$perkara_id,
                		'tahapan_id'=>'15',
                		'tahapan_nama'=>'Diversi',
                		'proses_id'=>'220',
                		'proses_nama'=>'Minutasi',
                		'tanggal'=>$tgl_minutasi,
                		'keterangan'=>'Pemeriksaan Perkara Dihentikan', 
                		'diinput_oleh'=>$this->session->userdata('username'),
						'diinput_tanggal'=>date('Y-m-d H:i:s')
                );
                $this->db->replace('perkara_proses', $data);
			}
			return true;
		} catch (Exception $e) {
			return false;
		}
	}

	function edit_diversi_dibuka($perkara_id, $tgl_dibuka_kembali, $no_dibuka_kembali, $tgl_lap_pembimbing_masyarakat, $hasil_diversi, $edit=0){
		try {
			$data=array(
	            "tgl_dibuka_kembali" => $tgl_dibuka_kembali,
	            "no_dibuka_kembali" => $no_dibuka_kembali,
	            "tgl_lap_pembimbing_masyarakat" => $tgl_lap_pembimbing_masyarakat,
	            "hasil_diversi" => $hasil_diversi,
	            "dibuka_kembali" => 1
			);		
			$this->db->where('perkara_id', $perkara_id);	
			$this->db->update('perkara_diversi', $data);
			$title = "UPDATE table <b>perkara_diversi</b> dari halaman <b>EDIT Data Diversi</b> dengan Primary Key [perkara_id=".$perkara_id."]";
			$descrip = $this->fetch_description($title,$data);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara');

			$data=array(
				'tahapan_terakhir_id'=> 12,
                'tahapan_terakhir_text'=> 'Diversi',
                'proses_terakhir_id'=> 76,
                'proses_terakhir_text'=> 'Diversi Gagal',
                'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date('Y-m-d H:i:s')
				);	
				$this->db->where('perkara_id', $perkara_id);
				$this->db->update('perkara', $data);
				$title = "UPDATE table <b>perkara</b> dari halaman <b>EDIT Data Diversi</b> dengan Primary Key [perkara_id=".$perkara_id."]";
				$descrip = $this->fetch_description($title,$data);
				$this->add_audittrail("UPDATE",$title,$descrip,'perkara');

                if ($edit==0){
	                $data=array(
	                		'tahapan_id'=>'12',
	                		'keterangan'=>'Pemeriksaan Perkara Dihentikan',
	                		'proses_id'=>'77'
	                );
	                $this->db->where('perkara_id', $perkara_id);
	                $this->db->where('proses_id', '213');
	                $this->db->update('perkara_proses', $data);
                }

                $data=array(
                		'tahapan_id'=>'12',
                		'keterangan'=>'Isi Kesepakatan tidak Dilaksanakan Sepenuhnya',
                		'proses_id'=>'78'
                );
                $this->db->where('perkara_id', $perkara_id);
                $this->db->where('proses_id', '220');
                $this->db->update('perkara_proses', $data);

				$data=array(
                		'perkara_id'=>$perkara_id,
                		'tahapan_id'=>'12',
                		'tahapan_nama'=>'Penetapan',
                		'proses_id'=>'79',
                		'proses_nama'=>'Diversi Dinyatakan Gagal',
                		'tanggal'=>$tgl_dibuka_kembali,
                		'keterangan'=>'Pemeriksaan Perkara Dilanjutkan',
                		'diinput_oleh'=>$this->session->userdata('username'),
						'diinput_tanggal'=>date('Y-m-d H:i:s')
                );
                $this->db->replace('perkara_proses', $data);
			
			return true;
		} catch (Exception $e) {
			return false;
		}
	}

	function fetch_description($title,$data){
		$descrip = '<br><table style="vertical-align:top" cellspacing="0" cellpadding="1" border="1">';
		$descrip .= '<tr><th>Nama Kolom</th><th>Nilai</th></tr>';
		foreach ($data as $key => $value) {
			$descrip .= '<tr>';
			$descrip .= '<td>'.$key.'</td>';
			$descrip .= '<td>'.$value.'</td>';
			$descrip .= '</tr>';
		}
		$descrip .= '</table>';
		return $descrip;
	}
	
	function add_audittrail($action,$title,$descrip,$tablename){
		try {
			$data = array(
				'datetime' => date("Y-m-d H:i:s"),
				'ipaddress' => $this->input->ip_address(),
				'username' => $this->session->userdata('username'),
				'tablename' => $tablename,
				'formname' => 'Tambah/Edit - Data Diversi',
				'action' => $action,
				'title' => $title,
				'description' => $descrip
			);
			$this->db->insert('sys_audittrail', $data);
		} catch (Exception $e) {
			
		}
	}
}

?>