<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class View_laporan_tun extends CI_Controller {
	
	function rekap(){
		if(empty($_POST)){ show_404(); }

		$event 		= trim($this->input->post('events',TRUE));
		$th_name 	= trim($this->input->post('th_name',TRUE));
		$tahun 		= trim($this->input->post('tahun_opt',TRUE));
		$type 		= trim($this->input->post('jenis',TRUE));
		$tahapan 	= trim($this->input->post('tahapan',TRUE));
		$status 	= FALSE;
		if(is_numeric($event)){
			if($event>0 AND $event<=12){
				$this->nativesession->set_flash_session('event','rekap_bulan');
				$this->nativesession->set_flash_session('month',$event);
				$status = TRUE;
			}
		}elseif($event=='tab'){
			$this->nativesession->set_flash_session('event','tab');
			$status = TRUE;
		}elseif($event=='graph'){
			$this->nativesession->set_flash_session('event','graph');
			$status = TRUE;
		}

		$this->nativesession->set_flash_session('idalurperkara',$th_name);

		if(is_numeric($tahun)){
			if($tahun>=0){
				$this->nativesession->set_flash_session('tahun',$tahun);
				$status = TRUE;
			}
		}else{
			$status = FALSE;
		}

		if(is_numeric($type)){
			if($type>0 AND $type<=6){
				$this->nativesession->set_flash_session('type',$type);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}

		if(is_numeric($tahapan)){
			if($tahapan==10 OR $tahapan==20 OR $tahapan==30 OR $tahapan==40 OR $tahapan==50 OR $tahapan==60 OR $tahapan==88 OR $tahapan==99){
				$this->nativesession->set_flash_session('tahapan',$tahapan);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}

		if($status===TRUE){
			$this->nativesession->set_flash_session('view','view_rekap_perkara');
			echo json_encode(array('st'=>1,'msg'=>'Done'));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Invalid Argument'));
		}
	}

	function rekap_bulan(){
		if(empty($_POST)){ show_404(); }

		$event 		= trim($this->input->post('events',TRUE));
		$th_name 	= trim($this->input->post('th_name',TRUE));
		$tahun 		= trim($this->input->post('tahun_opt',TRUE));
		$type 		= trim($this->input->post('jenis',TRUE));
		$tahapan 	= trim($this->input->post('tahapan',TRUE));
		$bulan 		= trim($this->input->post('bulan',TRUE));
		$status 	= FALSE;
		if(is_numeric($event)){
			if($event>0 AND $event<=12){
				$this->nativesession->set_flash_session('event','rekap_bulan');
				$this->nativesession->set_flash_session('month',$event);
				$status = TRUE;
			}
		}elseif($event=='tab'){
			$this->nativesession->set_flash_session('event','tab');
			$status = TRUE;
		}elseif($event=='graph'){
			$this->nativesession->set_flash_session('event','graph');
			$status = TRUE;
		}

		$this->nativesession->set_flash_session('idalurperkara',$th_name);

		if(is_numeric($tahun)){
			if($tahun>=0){
				$this->nativesession->set_flash_session('tahun',$tahun);
				$status = TRUE;
			}
		}else{
			$status = FALSE;
		}

		if(is_numeric($bulan)){
			if($bulan>=0){
				$this->nativesession->set_flash_session('bulan',$bulan);
				$status = TRUE;
			}
		}else{
			$status = FALSE;
		}

		if(is_numeric($type)){
			if($type>0 AND $type<=6){
				$this->nativesession->set_flash_session('type',$type);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}

		if(is_numeric($tahapan)){
			if($tahapan==10 OR $tahapan==20 OR $tahapan==30 OR $tahapan==40 OR $tahapan==50 OR $tahapan==60 OR $tahapan==88 OR $tahapan==99){
				$this->nativesession->set_flash_session('tahapan',$tahapan);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}

		if($status===TRUE){
			$this->nativesession->set_flash_session('view','view_rekap_perkara_bulan');
			echo json_encode(array('st'=>1,'msg'=>'Done'));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Invalid Argument'));
		}
	}

	function laporan_tun(){
		if(empty($_POST)){ show_404(); }
		$event 			= trim($this->input->post('month',TRUE));
		$jenis 			= trim($this->input->post('jenis',TRUE));
		$tahun 			= trim($this->input->post('tahun_opt',TRUE));
		$tahapan 		= trim($this->input->post('tahapan',TRUE));
		$IDalurPerkara 	= trim($this->input->post('idalurperkara',TRUE));
		$status 		= FALSE;
		if(is_numeric($event)){
			if($event>0 AND $event<=12){
				$this->nativesession->set_flash_session('event','laporan');
				$this->nativesession->set_flash_session('month',$event);
				$status = TRUE;
			}
		}

		if(is_numeric($tahapan)){
			if($tahapan==10 OR $tahapan==20 OR $tahapan==30 OR $tahapan==40 OR $tahapan==50 OR $tahapan==60 OR $tahapan==88 OR $tahapan==99){
				$this->nativesession->set_flash_session('tahapan',$tahapan);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}
		$this->nativesession->set_flash_session('idalurperkara',$IDalurPerkara);
		$this->nativesession->set_flash_session('jenis',$jenis);
		if(is_numeric($tahun)){
			if($tahun>=0){
				$this->nativesession->set_flash_session('tahun',$tahun);
				$status = TRUE;
			}
		}else{
			$status = FALSE;
		}

		if($status===TRUE){
			$this->nativesession->set_flash_session('view','view_laporan');
			echo json_encode(array('st'=>1,'msg'=>'Silahkan Membuka Laporan Pada Tab'));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Invalid Argument'));
		}
	}

	function index(){
		$act = $this->nativesession->get_flash_session('view');
		if($act==='view_rekap_perkara'){
			$this->view_rekap_perkara();
		}elseif($act==='view_laporan'){
			$this->view_laporan_perkara();
		}elseif($act==='view_rekap_perkara_bulan'){
			$this->view_rekap_perkara_bulan();
		}else{
			show_404();
		}
	}

	function view_rekap_perkara_bulan(){
		$idalurperkara 	= $this->nativesession->get_flash_session('idalurperkara');
		$tahun 			= $this->nativesession->get_flash_session('tahun');
		$bulan 			= $this->nativesession->get_flash_session('bulan');
		$type 			= $this->nativesession->get_flash_session('type');
		$tahapan = $this->nativesession->get_flash_session('tahapan');
		$data['bulan'] = $bulan;
		$bulan = ($bulan<10)? '0'.$bulan:$bulan;
		$periode = $tahun.'-'.$bulan;
		$this->load->model('report/report','report');
		$data['laporan'] = $this->report->get_stat_perkara_bln($periode,$idalurperkara);
		$data['tahun'] = $tahun;
		$data['idalurperkara'] = $idalurperkara;
		$data['perkara_nama'] = strtoupper($this->report->getJenisPerkara($idalurperkara));
		$query = $this->report->get_info_pn();
		foreach ($query->result() as $row) {
			if($row->id == 62){
				if(!empty($row->value)){
					$data['nama_pn'] = $row->value;
				}
			}
		}
		$data['view_lap'] = 'laporan/view_laporan_perkara_bulan';
		$this->load->vars($data);
		$this->load->view('laporan/view_laporan_perkara');
		$this->load->view('footer');
	}

	function view_rekap_perkara(){
		$idalurperkara 	= $this->nativesession->get_flash_session('idalurperkara');
		$tahun 			= $this->nativesession->get_flash_session('tahun');
		$type 			= $this->nativesession->get_flash_session('type');
		$tahapan 		= $this->nativesession->get_flash_session('tahapan');

		$this->load->model('report/report_tun','report');

		if($tahapan==10){
			if($type==1){
				$data['rekapPerkaraTUN'] = $this->report->rekapPerkaraTahunTUN($tahun,$idalurperkara);
				$data['view_lap'] = 'laporan/view_rekap_tun_perkara';
			} elseif ($type==2){
				$data['rekapPerkaraProsesTUN'] = $this->report->rekapPerkaraProsesTUN($tahun,$idalurperkara);
				$data['view_lap'] = 'laporan/view_rekap_tun_proses';
			}  elseif ($type==3){
				$data['rekapPutusanPTUN'] = $this->report->rekapPutusanPTUN($tahun,$idalurperkara);
				$data['view_lap'] = 'laporan/view_rekap_tun_putusan_pertama';
			} 
		} else if ($tahapan==20){
			if($type==1){
				$data['rekapPutusanBandingTUN'] = $this->report->rekapPutusanBandingTUN($tahun,$idalurperkara);
				$data['view_lap'] = 'laporan/view_rekap_tun_putusan_banding';
			}
		} else if ($tahapan==30){
			if($type==1){
				$data['rekapPutusanKasasiTUN'] = $this->report->rekapPutusanKasasiTUN($tahun,$idalurperkara);
				$data['view_lap'] = 'laporan/view_rekap_tun_putusan_kasasi';
			}
		} else if ($tahapan==40){
			if($type==1){
				$data['rekapPutusanPKTUN'] = $this->report->rekapPutusanPKTUN($tahun,$idalurperkara);
				$data['view_lap'] = 'laporan/view_rekap_tun_putusan_pk';
			}

		}
		
		$data['rekap'] = $this->report->get_rekap($idalurperkara,$tahun);
		$data['tahun'] = $tahun;
		
		$data['idalurperkara'] = $idalurperkara;
		$data['perkara_nama'] = strtoupper($this->report->getJenisPerkara($idalurperkara));
		$query = $this->report->get_info_pn();
		foreach ($query->result() as $row) {
			if($row->id == 62){
				if(!empty($row->value)){
					$data['nama_pn'] = $row->value;
				}
			}
		}
		$this->load->vars($data);
		$this->load->view('laporan/view_laporan_perkara');
		$this->load->view('footer');
	}




	function view_laporan_perkara(){
		$idalurperkara 	= $this->nativesession->get_flash_session('idalurperkara');
		$tahun 			= $this->nativesession->get_flash_session('tahun');
		$bulan 			= $this->nativesession->get_flash_session('month');
		$tahapan 		= $this->nativesession->get_flash_session('tahapan');
		$jenis 			= $this->nativesession->get_flash_session('jenis');
		$bln 			= ($bulan<10)? '0'.$bulan:$bulan;
		$period 		= $tahun.'-'.$bln;
		$this->load->model('report/report_tun','report');

			
		if($tahapan==10){
			if($idalurperkara=9){
				if($jenis==9){
					$data['statBulan'] = $this->report->get_stat_perkara($period,$idalurperkara);
					$data['get_lap_perkara_belum_dibagi'] = $this->report->get_lap_perkara_belum_dibagi($period,$idalurperkara);
					$data['get_lap_perkara_belum_putus'] = $this->report->get_lap_perkara_belum_putus($period,$idalurperkara);
					$data['get_lap_perkara_belum_minut'] = $this->report->get_lap_perkara_belum_minut($period,$idalurperkara);
					$data['listHakim'] = $this->report->listHakim();
					$data['listPP'] = $this->report->listPP();
					$data['view_lap'] = 'laporan/view_laporan_tun';
				} else if ($jenis==10){
					$data['laporanJenisPerkara'] = $this->report->laporanJenisPerkaraTUN($period,$idalurperkara);
					$data['view_lap'] = 'laporan/view_laporan_tun_jenis_perkara';
				} else if ($jenis==12){
					$data['listProdeo'] = $this->report->laporanProdeoTUN($period,$idalurperkara);
					$data['view_lap'] = 'laporan/view_laporan_tun_prodeo';
				} else if ($jenis==13){
					$data['listKegiatanHakimTUN'] = $this->report->laporanKegiatanHakimTUN($period,$idalurperkara);
					$data['view_lap'] = 'laporan/view_laporan_tun_hakim';
				} else if ($jenis==14){
					$data['laporanKegiatanPPTUN'] = $this->report->laporanKegiatanPPTUN($period,$idalurperkara);
					$data['view_lap'] = 'laporan/view_laporan_tun_pp';
				}
			}
			$data['perkara_nama'] = strtoupper($this->report->getJenisPerkara($idalurperkara));
		}else if($tahapan==20){
			if($idalurperkara=9){
				$data['listBanding'] = $this->report->laporanBandingTUN($period,$idalurperkara);
				$data['view_lap'] = 'laporan/view_laporan_tun_banding';
			}
			$data['perkara_nama'] = strtoupper($this->report->getJenisPerkara($idalurperkara));
		}else if($tahapan==30){
			if($idalurperkara=9){
				$data['listKasasi'] = $this->report->laporanKasasiTUN($period,$idalurperkara);
				$data['view_lap'] = 'laporan/view_laporan_tun_kasasi';
			}
		}else if($tahapan==40){
			if($idalurperkara=9){
				$data['listPK'] = $this->report->laporanPKTUN($period,$idalurperkara);
				$data['view_lap'] = 'laporan/view_laporan_tun_pk';
			}
		}else if($tahapan==50){
			if($idalurperkara=9){
				$data['listEksekusi'] = $this->report->laporanEksekusiTUN($period,$idalurperkara);
				$data['view_lap'] = 'laporan/view_laporan_tun_eksekusi';
			}
		}else if($tahapan==88){
			$saldo=$this->report->get_saldo_awal($period);
			foreach ($saldo->result() as $row) {
				$data['saldo_awal']=$row->saldo_awal;
				$data['tgl_saldo_awal']=$row->tgl_saldo_awal;
				$data['period_saldo_awal']=substr($data['tgl_saldo_awal'],0,7);
			}
			
			$data['listKeuangan'] = $this->report->laporanKeuanganTUN($period,$idalurperkara, $data['saldo_awal']);
			$data['view_lap'] = 'laporan/view_laporan_tun_keuangan';
		}else if($tahapan==99){
			$data['view_lap'] = 'laporan/view_laporan_tun_hhk';

		}
			

		$data['perkara_nama'] ='TATA USAHA NEGARA';
		$data['tahun'] = $tahun;
		$data['bulan'] = $bulan;
		$query = $this->report->get_info_pn();
		foreach ($query->result() as $row) {
			if($row->id == 62){
				if(!empty($row->value)){
					$data['nama_pn'] = $row->value;
				}
			}
		}
		
		$data['laporan'] = $this->report->get_lap_perkara($period,$idalurperkara);
		$data['stat'] = $this->report->get_stat_perkara($period,$idalurperkara);
		
		$this->load->vars($data);
		$this->load->view('laporan/view_laporan_perkara');
		$this->load->view('footer');
	}
}