<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class M_new_template_tun extends CI_Model {

	function get_var_general($data_id){
		// print_r($data_id);exit();
		$field_var = array_keys($data_id);
		$sql = "SET @pihak_id = NULL;";
		$query=$this->db->query($sql);
		$sql = "SET @jurusita_id = NULL;";
		$query=$this->db->query($sql);
		$sql = "SET @panggilan_dismissal_id = NULL;";
		$query=$this->db->query($sql);
		for($i = 0; $i <count($field_var) ; $i++) {
			if($data_id[$field_var[$i]]!='' or $field_var[$i]!='source_file'){
				if($field_var[$i]=='tanggal'){
					$data_id[$field_var[$i]]=$this->tanggalhelper->convertToMysqlDate($data_id[$field_var[$i]]);	
				}
				$sql = "SET @".$field_var[$i]." = '".$data_id[$field_var[$i]]."';";
				$query=$this->db->query($sql);
			}
        }

		try{
			$sql = "SELECT
						convert_tanggal_indonesia(now()) as tanggal_sekarang,
						nama_hari(now()) as hari_sekarang,
						(SELECT VALUE FROM sys_config WHERE id = 62) AS satker_kapital,
						(SELECT VALUE FROM sys_config WHERE id = 76) AS satker_tingkat_banding_kapital,
						(SELECT VALUE FROM sys_config WHERE id = 63) AS alamat_satker,
						(SELECT VALUE FROM sys_config WHERE id = 64) AS nama_ketua,
						(SELECT VALUE FROM sys_config WHERE id = 65) AS nip_ketua,
						(SELECT VALUE FROM sys_config WHERE id = 66) AS nama_wakil,
						(SELECT VALUE FROM sys_config WHERE id = 67) AS nip_wakil,
						@nama_panitera:=(SELECT VALUE FROM sys_config WHERE id = 68) AS nama_panitera,
						(SELECT VALUE FROM sys_config WHERE id = 69) AS nip_panitera,
						(SELECT VALUE FROM sys_config WHERE id = 70) AS nama_wapan, 
						(SELECT VALUE FROM sys_config WHERE id = 71) AS nip_wapan, 
						@zona_waktu:=(SELECT VALUE FROM sys_config WHERE id = 75) AS zona_waktu,
						@jenis_pengadilan:=(SELECT VALUE FROM sys_config WHERE id = 83) AS jenis_pengadilan,
						(SELECT VALUE FROM sys_config WHERE id = 84) AS pangkat_ketua,
						(SELECT VALUE FROM sys_config WHERE id = 85) AS pangkat_wakil,
						(SELECT VALUE FROM sys_config WHERE id = 86) AS pangkat_panitera,
						(SELECT VALUE FROM sys_config WHERE id = 87) AS pangkat_wapan,
						(SELECT CONCAT_WS(' ',split_string(VALUE,' ',1),split_string(VALUE,' ',2),IF((SELECT VALUE FROM sys_config WHERE id = 83)=2,split_string(VALUE,' ',3),'')) FROM sys_config WHERE id = 62) AS pengadilan_negeri_kapital,
						convert_tanggal_indonesia(now()) as tanggal_sekarang,
						nama_hari(now()) as hari_sekarang";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function get_tanggal_penetapan(){
		try{
			$sql = "SELECT 
						convert_tanggal_indonesia(penetapan_majelis_hakim) AS tanggal_pmh
						,nama_hari(penetapan_majelis_hakim) hari_pmh
						,convert_tanggal_indonesia(penetapan_panitera_pengganti) AS tanggal_penetapan_panitera
						,nama_hari(penetapan_panitera_pengganti) hari_penetapan_panitera
						,convert_tanggal_indonesia(penetapan_jurusita) AS tanggal_penetapan_jurusita
						,nama_hari(penetapan_jurusita) hari_penetapan_jurusita
						,convert_tanggal_indonesia(penetapan_hari_sidang) AS tanggal_phs
						,nama_hari(penetapan_hari_sidang) hari_phs
						,convert_tanggal_indonesia(sidang_pertama) AS tanggal_sidang_pertama
						,nama_hari(sidang_pertama) hari_sidang_pertama
						,CONCAT(DATE_FORMAT(b.jam_sidang , '%H.%i'),' ',@zona_waktu) AS jam_sidang_pertama
						,CONCAT(DATE_FORMAT(b.jam_sidang , '%H.%i'),' ',@zona_waktu) AS jam_sidang_phs
					FROM perkara_penetapan AS a
					LEFT JOIN (SELECT * FROM perkara_jadwal_sidang WHERE perkara_id = @perkara_id) AS b ON a.`perkara_id` = b.perkara_id AND a.sidang_pertama = b.tanggal_sidang
					WHERE a.perkara_id = @perkara_id";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function get_var_dismissal(){
		try{
			$sql = "SELECT 
						convert_tanggal_indonesia(tanggal_penetapan) AS tanggal_penetapan_dismissal
						,nama_hari(tanggal_penetapan) AS hari_penetapan_dismissal
						,amar AS amar_penetapan_dismissal
						,convert_tanggal_indonesia(pemberitahuan_penggugat) AS tanggal_pemberitahuan_dissmisal_pihak1
						,nama_hari(pemberitahuan_penggugat) AS hari_pemberitahuan_dissmisal_pihak1
						,convert_tanggal_indonesia(pemberitahuan_tergugat) AS tanggal_pemberitahuan_dissmisal_pihak2
						,nama_hari(pemberitahuan_tergugat) AS hari_pemberitahuan_dissmisal_pihak2
					FROM perkara_dismissal 
					WHERE perkara_id = @perkara_id";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function get_var_jadwal_dismissal(){
		try{
			$sql = "SELECT 
						convert_tanggal_indonesia(tanggal_panggilan) AS tanggal_panggilan_dismissal
						,CONCAT(DATE_FORMAT(waktu, '%H.%i'),' ',@zona_waktu) AS jam_panggilan_dismissal
						,nama_hari(tanggal_panggilan) AS hari_panggilan_dismissal
					FROM perkara_panggilan_dismissal WHERE perkara_id = @perkara_id 
					AND IF(@panggilan_dismissal_id IS NOT NULL ,id,1) = IF(@panggilan_dismissal_id IS NOT NULL ,@panggilan_dismissal_id,1)
					ORDER BY tanggal_panggilan_dismissal DESC LIMIT 1";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}


	function get_var_penetapan_persiapan(){
		try{
			$sql = "SELECT 
						convert_tanggal_indonesia(tanggal_penetapan_persiapan) AS tanggal_penetapan_pemeriksaan_persiapan
						,nama_hari(tanggal_penetapan_persiapan) AS hari_penetapan_pemeriksaan_persiapan
						,petitum AS petitum_penetapan_pemeriksaan_persiapan
					FROM perkara_persiapan 
					WHERE perkara_id = @perkara_id";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function get_var_penetapan_persiapan_proses(){
		try{
			$sql = "SELECT 
						convert_tanggal_indonesia(tanggal_musyawarah) AS tanggal_panggilan_pp
						,nama_hari(tanggal_musyawarah) AS hari_panggilan_pp
						,CONCAT(DATE_FORMAT(waktu_musyawarah , '%H.%i'),' ',@zona_waktu) AS jam_panggilan_pp
					FROM perkara_persiapan_proses
					WHERE perkara_id = @perkara_id";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function get_var_penahanan(){
		try{
			$sql = "SELECT 
						a.pihak_id,
						b.`nama` AS jenis_tahanan,
						convert_tanggal_indonesia(a.`mulai`) AS mulai_ditahan,
						nama_hari(a.mulai) AS hari_mulai_ditahan,
						convert_tanggal_indonesia(a.`sampai`) AS sampai_ditahan,
						nama_hari(a.sampai) AS hari_sampai_ditahan,
						(SELECT COUNT(*) FROM perkara_pihak2 WHERE perkara_id = @perkara_id)AS jumlah_terdakwa,
						IF(a.`jenis_tahanan_id`=0,'menghadirkan','menghadapkan') AS hadap_hadir,
						c.nama as jenis_penahanan
					FROM penahanan_terdakwa AS a
					JOIN jenis_tahanan AS b on a.jenis_tahanan_id = b.id
					JOIN jenis_penahanan AS c ON a.jenis_penahanan_id = c.id
					WHERE perkara_id = @perkara_id 
					-- AND pihak_id = @pihak_id
					AND jenis_tahanan_id IS NOT NULL
					-- AND mulai IS NOT NULL
					ORDER BY pihak_id,sampai ASC 
					-- LIMIT 1";
					// print_r($sql);exit();
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function get_var_penahanan_mil(){
		try{
			$sql = "SELECT 
						a.pihak_id,
						b.`nama` AS jenis_tahanan,
						convert_tanggal_indonesia(a.`mulai`) AS mulai_ditahan,
						nama_hari(a.mulai) AS hari_mulai_ditahan,
						convert_tanggal_indonesia(a.`sampai`) AS sampai_ditahan,
						nama_hari(a.sampai) AS hari_sampai_ditahan,
						(SELECT COUNT(*) FROM perkara_pihak2 WHERE perkara_id = @perkara_id)AS jumlah_terdakwa,
						IF(a.`jenis_tahanan_id`=0,'menghadirkan','menghadapkan') AS hadap_hadir,
						c.nama AS jenis_penahanan,
						aa.tanggal_surat AS tanggal_surat,
						aa.mulai AS mulai_surat,
						aa.sampai AS sampai_surat
					FROM (SELECT * FROM penahanan_terdakwa WHERE perkara_id = @perkara_id ) AS a
					JOIN (SELECT @tanggal:=tanggal_surat AS tanggal_surat ,mulai, sampai  FROM penahanan_terdakwa WHERE perkara_id = @perkara_id AND id = @penahanan_id) AS aa ON a.mulai < aa.tanggal_surat
					JOIN jenis_tahanan AS b ON a.jenis_tahanan_id = b.id
					JOIN jenis_penahanan AS c ON a.jenis_penahanan_id = c.id
					AND jenis_tahanan_id IS NOT NULL
					ORDER BY a.pihak_id, a.sampai ASC";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function get_var_penetapan_hakim(){
		try{
			$sql = "SELECT 
						a.perkara_id, 
						a.tahapan_id,
						convert_tanggal_indonesia(a.tanggal_penetapan) AS tanggal_pmh,
						nama_hari(a.tanggal_penetapan) AS hari_pmh,
						a.jabatan_hakim_id,
						a.jabatan_hakim_nama,
						-- IF((SELECT VALUE FROM sys_config WHERE id = 83) = 2,CONCAT_WS(' ',b.nama_gelar,b.pangkat,'NRP.',b.nip),b.nama_gelar) AS hakim_nama
						b.nama_gelar as hakim_nama,
						b.pangkat,
						b.nip as nip,
						a.keterangan as alasan_penetapan
					FROM perkara_hakim_pn AS a
					JOIN hakim_pn AS b ON a.`hakim_id` = b.id
					WHERE perkara_id = @perkara_id AND a.aktif = 'Y'
					ORDER BY urutan,jabatan_hakim_id, hakim_kode, hakim_id";
			// echo'<pre>';
			// print_r($sql);
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function get_var_penetapan_hakim_lama(){
		try{
			$sql = "SELECT 
						convert_tanggal_indonesia(a.tanggal_penetapan) AS tanggal_pmh_lama,
						nama_hari(a.tanggal_penetapan) AS hari_pmh_lama,
						a.jabatan_hakim_id as jabatan_hakim_id_lama,
						a.jabatan_hakim_nama as jabatan_hakim_nama_lama,
						b.nama_gelar AS hakim_nama_lama,
						b.pangkat AS pangkat_hakim_lama,
						b.nip AS nrp_hakim_lama 
					FROM perkara_hakim_pn AS a
					JOIN hakim_pn AS b ON a.`hakim_id` = b.id
					WHERE a.perkara_id = @perkara_id AND a.tanggal_penetapan = 
					(SELECT tanggal_penetapan FROM perkara_hakim_pn WHERE perkara_id = @perkara_id 
					AND aktif = 'T' 
					ORDER BY tanggal_penetapan DESC LIMIT 1)
					ORDER BY a.jabatan_hakim_id, a.hakim_kode, a.hakim_id";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function get_var_penetapan_panitera(){
		try{
			$sql = "SELECT 
						a.perkara_id, 
						a.tahapan_id,
						convert_tanggal_indonesia(a.tanggal_penetapan) AS tanggal_penunjukkan_pp,
						nama_hari(a.tanggal_penetapan) AS hari_penetapan_pp,
						-- IF((SELECT VALUE FROM sys_config WHERE id = 83) = 2,CONCAT_WS(' ',b.nama_gelar,b.pangkat,'NRP.',b.nip),b.nama_gelar) AS nama_pp,
						b.nama_gelar as nama_pp,
						b.pangkat as pangkat_pp,
						b.nip as nrp_pp,
						IF((REPLACE(REPLACE(REPLACE(@nama_panitera,' ',''),',',''),'.','')) = REPLACE(REPLACE(REPLACE(b.nama_gelar,' ',''),',',''),'.',''), 'Panitera Pengganti', 'Panitera Pengganti') AS jabatan_pp
					FROM perkara_panitera_pn AS a
					JOIN panitera_pn AS b ON a.panitera_id= b.id
					WHERE perkara_id = @perkara_id AND a.aktif = 'Y'
					ORDER BY panitera_kode, panitera_id";
			// echo'<pre>';
			// print_r($sql);
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function get_var_penetapan_panitera_lama(){
		try{
			$sql = "SELECT 
						convert_tanggal_indonesia(a.tanggal_penetapan) AS tanggal_penunjukkan_pp_lama,
						nama_hari(a.tanggal_penetapan) AS hari_penetapan_pp_lama,
						b.nama_gelar as nama_pp_lama,
						b.pangkat as pangkat_pp_lama,
						b.nip as nrp_pp_lama,
						IF((REPLACE(REPLACE(REPLACE(@nama_panitera,' ',''),',',''),'.','')) = REPLACE(REPLACE(REPLACE(b.nama_gelar,' ',''),',',''),'.',''), 'Panitera Pengganti', 'Panitera Pengganti') AS jabatan_pp_lama
					FROM perkara_panitera_pn AS a
					JOIN panitera_pn AS b ON a.panitera_id= b.id
					WHERE perkara_id = @perkara_id AND a.tanggal_penetapan = 
					(SELECT tanggal_penetapan FROM perkara_panitera_pn WHERE perkara_id = @perkara_id 
					AND aktif = 'T' 
					ORDER BY tanggal_penetapan DESC LIMIT 1)
					ORDER BY panitera_kode, panitera_id";
			// echo'<pre>';
			// print_r($sql);
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function get_var_penetapan_jurusita(){
		try{
			$sql = "SELECT 
						b.nama_gelar AS nama_jurusita,
						IF(b.jabatan=1,'Jurusita', 'Jurusita Pengganti') AS jurusita
					FROM perkara_jurusita AS a
					JOIN jurusita AS b ON a.jurusita_id= b.id
					WHERE perkara_id = @perkara_id AND a.aktif = 'Y'
					AND IF(@jurusita_id IS NOT NULL ,a.`jurusita_id`,1) = IF(@jurusita_id IS NOT NULL ,@jurusita_id,1)
					ORDER BY b.jabatan,jurusita_kode, jurusita_id";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function get_var_jurusita_plw(){
		try{
			$sql = "SELECT
					b.`nama_gelar` AS nama_jurusita
					FROM perkara_verzet AS a
					JOIN jurusita AS b ON a.jurusita_id= b.id
					WHERE perkara_id = '662'";
					$query=$this->db->query($sql);
					return $query;	
			}catch(Exception $e) { return false; }
	}

	function get_var_penetapan_hari_sidang(){
		try{
			$sql = "SELECT 
						convert_tanggal_indonesia(penetapan_majelis_hakim) AS tanggal_pmh
						,nama_hari(penetapan_majelis_hakim) hari_pmh
						,convert_tanggal_indonesia(penetapan_panitera_pengganti) AS tanggal_penetapan_panitera
						,nama_hari(penetapan_panitera_pengganti) hari_penetapan_panitera
						,convert_tanggal_indonesia(penetapan_jurusita) AS tanggal_penetapan_jurusita
						,nama_hari(penetapan_jurusita) hari_penetapan_jurusita
						,convert_tanggal_indonesia(penetapan_hari_sidang) AS tanggal_phs
						,nama_hari(penetapan_hari_sidang) hari_phs
						,convert_tanggal_indonesia(sidang_pertama) AS tanggal_sidang_pertama
						,nama_hari(sidang_pertama) hari_sidang_pertama
						,CONCAT(DATE_FORMAT(b.jam_sidang , '%H.%i'),' ',@zona_waktu) AS jam_sidang_pertama
						,CONCAT(DATE_FORMAT(b.jam_sidang , '%H.%i'),' ',@zona_waktu) AS jam_sidang_phs
						,b.ruangan as ruang_sidang_phs
					FROM perkara_penetapan AS a
					LEFT JOIN (SELECT * FROM perkara_jadwal_sidang WHERE perkara_id = @perkara_id) AS b ON a.`perkara_id` = b.perkara_id AND a.sidang_pertama = b.tanggal_sidang
					WHERE a.perkara_id = @perkara_id";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}
	
	function get_var_perkara(){
		try {
			$sql = "SELECT 
						alur_perkara_id
						,c.nama AS alur_perkara_text
						,jenis_perkara_id
						,jenis_perkara_nama AS jenis_perkara_text
						,jenis_perkara_nama AS jenis_perkara
						,tahapan_terakhir_id
						,tahapan_terakhir_text
						,proses_terakhir_id
						,proses_terakhir_text
						,nomor_perkara
						,trim(split_string(nomor_perkara,'/',1))AS no_perkara
						,CONCAT_WS('/',split_string(nomor_perkara,'/',(LENGTH(nomor_perkara) - LENGTH(REPLACE(nomor_perkara,'/','')))),split_string(nomor_perkara,'/',(LENGTH(nomor_perkara) - LENGTH(REPLACE(nomor_perkara,'/',''))+1)))AS tahun_satker
						,trim(CONCAT_WS('/',split_string(split_string(nomor_perkara,'/',1),'-',1),split_string(nomor_perkara,'/',2),split_string(nomor_perkara,'/',3))) AS no_perkara_mil
						,nomor_surat AS nomor_surat_gugatan
						,convert_tanggal_indonesia(tanggal_surat) AS tanggal_gugatan
						,nama_hari(tanggal_surat) as hari_gugatan
						,nomor_surat AS nomor_pelimpahan
						,convert_tanggal_indonesia(tanggal_surat) AS tanggal_pelimpahan
						,nama_hari(tanggal_surat) as hari_pelimpahan
						,convert_tanggal_indonesia(tanggal_pendaftaran) as tanggal_pendaftaran
						,nama_hari(tanggal_pendaftaran) as hari_pendaftaran
						,IF(a.alur_perkara_id IN (SELECT id FROM alur_perkara WHERE LOWER(nama) LIKE '%gugatan%')
							,IF(jenis_perkara_id=346 OR jenis_perkara_id=335,'Permohonan','Gugatan'),IF(a.alur_perkara_id IN (SELECT id FROM alur_perkara WHERE LOWER(nama) LIKE '%permohonan%'),'Permohonan','')) AS gugatan_permohonan
						,posita
						,petitum
						,dakwaan
						,b.pejabat_skeppera
						,b.nomor_skeppera
						,convert_tanggal_indonesia(b.tanggal_skeppera) AS tanggal_skeppera
						,nama_hari(b.tanggal_skeppera) as hari_skeppera
						,if(@jenis_pengadilan=2,b.nomor_surat_dakwaan, a.nomor_dakwaan) AS nomor_dakwaan
						,convert_tanggal_indonesia(if(@jenis_pengadilan=2,b.tanggal_surat_dakwaan, a.tanggal_dakwaan)) AS tanggal_dakwaan
						,nama_hari(if(@jenis_pengadilan=2,b.tanggal_surat_dakwaan,a.tanggal_dakwaan)) AS hari_dakwaan
						,b.berkas_dari
						,b.penyidik_mil AS penyidik_militer
						,b.no_bap_penyidik_mil as no_bap
						,convert_tanggal_indonesia(b.tgl_penyidik_mil) as tgl_bap
						,b.tanggal_kejadian as tanggal_kejadian_mil
						,b.tempat_kejadian as tempat_kejadian_mil
						,IF(d.ditilang_oleh=1,'Polisi',IF(d.ditilang_oleh=2,'Dishub',IF(d.ditilang_oleh=3,'Lainnya','.....'))) AS penindakan_oleh
						,(SELECT IF(COUNT(*)=1,'Lawan','Lawan:') FROM perkara_pihak1 WHERE perkara_id = @perkara_id) AS lawan
						,(SELECT IF(COUNT(*)=1,'pemohon','para permohon') FROM perkara_pihak1 WHERE perkara_id = @perkara_id) AS pemohon_parapemohon
						,if(e.perkara_id is null,0,1) as is_putusan_sela
					FROM perkara AS a
					LEFT JOIN (SELECT * FROM perkara_matra WHERE perkara_id = @perkara_id)AS b ON a.`perkara_id` = b.perkara_id 
					JOIN alur_perkara AS c ON a.`alur_perkara_id` =c.id 
					LEFT JOIN (SELECT * FROM perkara_lalulintas WHERE perkara_id = @perkara_id) AS d ON a.`perkara_id` = d.perkara_id 
					LEFT JOIN (SELECT * FROM perkara_putusan_sela WHERE perkara_id = @perkara_id limit 1) AS e ON a.`perkara_id` = e.perkara_id 
					WHERE a.perkara_id= @perkara_id";
			return $this->db->query($sql);
		} catch(PDOException $e) {		
		}
	}

	function get_var_pihak_dkk(){
		try{
			$sql = "SELECT 
						a.looping_nama_pihak1_dkk
						,b.looping_nama_pihak2_dkk
						,c.looping_nama_pihak3_dkk
						,d.looping_nama_pihak4_dkk
						,e.looping_nama_pihak5_dkk
					FROM			
					(SELECT 
						perkara_id, CONCAT_WS(' ',a.nama,IF(COUNT(*)=1,'','dkk'), 'sebagai #sebagai_pihak1#')AS looping_nama_pihak1_dkk
					FROM perkara_pihak1 AS a
					WHERE perkara_id = @perkara_id
					GROUP BY perkara_id) AS a
					LEFT JOIN 
					(SELECT 
						perkara_id, CONCAT_WS(' ',a.nama,IF(COUNT(*)=1,'','dkk'), 'sebagai #sebagai_pihak2#')AS looping_nama_pihak2_dkk
					FROM perkara_pihak2 AS a
					WHERE perkara_id = @perkara_id
					GROUP BY perkara_id) AS b ON a.perkara_id = b.perkara_id
					LEFT JOIN 
					(SELECT 
						perkara_id, CONCAT_WS(' ',a.nama,IF(COUNT(*)=1,'','dkk'), 'sebagai #sebagai_pihak3#')AS looping_nama_pihak3_dkk
					FROM perkara_pihak3 AS a
					WHERE perkara_id = @perkara_id
					GROUP BY perkara_id) AS c ON a.perkara_id = c.perkara_id
					LEFT JOIN 
					(SELECT 
						perkara_id, CONCAT_WS(' ',a.nama,IF(COUNT(*)=1,'','dkk'), 'sebagai #sebagai_pihak4#')AS looping_nama_pihak4_dkk
					FROM perkara_pihak4 AS a
					WHERE perkara_id = @perkara_id
					GROUP BY perkara_id) AS d ON a.perkara_id = d.perkara_id
					LEFT JOIN 
					(SELECT 
						perkara_id, CONCAT_WS(' ',a.nama,IF(COUNT(*)=1,'','dkk'), 'sebagai #sebagai_pihak5#')AS looping_nama_pihak5_dkk
					FROM perkara_pihak5 AS a
					WHERE perkara_id = @perkara_id
					GROUP BY perkara_id) AS e ON a.perkara_id = e.perkara_id";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function get_var_pihak_tok(){
		try{
			$sql = "SELECT IF(f.pengacara_id IS NOT NULL,f.nama,a.nama) AS nama_pihak, CONCAT(IF(f.pengacara_id IS NOT NULL,'Kuasa ',''),a.sebagai_pihak) AS sebagai_pihak FROM 
					(SELECT pihak_id, nama,  '#sebagai_pihak1#' AS sebagai_pihak FROM perkara_pihak1 WHERE perkara_id = @perkara_id AND pihak_id = @pihak_id UNION
					SELECT pihak_id, nama, '#sebagai_pihak2#' AS sebagai_pihak FROM perkara_pihak2 WHERE perkara_id = @perkara_id AND pihak_id = @pihak_id UNION
					SELECT pihak_id, nama, '#sebagai_pihak3#' AS sebagai_pihak FROM perkara_pihak3 WHERE perkara_id = @perkara_id AND pihak_id = @pihak_id UNION
					SELECT pihak_id, nama, '#sebagai_pihak4#' AS sebagai_pihak FROM perkara_pihak4 WHERE perkara_id = @perkara_id AND pihak_id = @pihak_id UNION
					SELECT pihak_id, nama, '#sebagai_pihak5#' AS sebagai_pihak FROM perkara_pihak5 WHERE perkara_id = @perkara_id AND pihak_id = @pihak_id) AS a
					LEFT JOIN (SELECT nama, pihak_id,pengacara_id FROM perkara_pengacara WHERE perkara_id = @perkara_id AND pihak_id = @pihak_id GROUP BY pihak_id ORDER BY pihak_id) AS f 
					ON a.pihak_id = f.pihak_id";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function get_var_kuasa($pihak){
		try{
			$sql = "SELECT 
						nama, 
						alamat, 
						nomor_kuasa, 
						convert_tanggal_indonesia(tanggal_kuasa) AS tanggal_kuasa
					FROM perkara_pengacara WHERE perkara_id = @perkara_id  AND pihak_ke = ".$pihak." AND aktif = 'Y' GROUP BY pengacara_id ORDER BY pihak_ke, urutan;";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function get_var_pihak($pihak,$is_relaas=0){
		try {
			$sql = "SELECT 
						a.perkara_id
						,a.urutan
						,a.jenis_pihak_id
						,a.pihak_id
						,a.nama
						,b.`tempat_lahir`
						,convert_tanggal_indonesia(b.`tanggal_lahir`) AS tanggal_lahir
						,get_umur(b.`tanggal_lahir`,g.tanggal_pendaftaran) AS umur
						,nama_hari(b.`tanggal_lahir`) AS `hari_lahir`
						,IF(b.`jenis_kelamin`= 'L','Laki-Laki','Perempuan') AS jenis_kelamin
						,IF(d.id IS NULL, b.`agama_nama`, d.nama) AS agama
						,IF(e.id IS NULL, b.`pendidikan`, e.nama) AS pendidikan
						,b.pekerjaan
						,IF(b.`warga_negara`='' OR b.`warga_negara` IS NULL, 'Indonesia', b.`warga_negara`) AS `warga_negara`
						,a.alamat
						,a.keterangan
						,f.pengacara_id AS id_kuasa
						,f.nama AS nama_kuasa
						,f.alamat AS alamat_kuasa
						,convert_tanggal_indonesia(f.tanggal_kuasa) AS tanggal_kuasa
						,nama_hari(f.tanggal_kuasa) AS hari_kuasa
						,nomor_kuasa AS nomor_kuasa
						,f.jumlah_pihak
						,f.jumlah_kuasa";
			switch ($pihak) {
			    case 2:
			    $sql.=",a.pangkat
						,a.nrp
						,a.jabatan
						,a.kesatuan";
			        break;
			    case 3:
			    $sql.=",a.tergabung_ke_pihak
						,a.jenis_intervensi_id
						,a.jenis_intervensi_nama
						,convert_tanggal_indonesia(a.tanggal_izin_intervensi) as tanggal_izin_intervensi
						,nama_hari(a.tanggal_izin_intervensi) as hari_izin_intervensi
						,a.isi_petitum";
			        break;
			    case 5:
			    $sql.=",a.saksi_pihak_ke
			    		,a.jenis_saksi
						,a.pangkat
						,a.nrp
						,a.jabatan
						,a.kesatuan";
			        break;
			}
			$sql.=" 
					FROM perkara_pihak".$pihak." AS a
						JOIN pihak AS b ON a.`pihak_id` = b.`id`
						LEFT JOIN 
							(SELECT 
								cb.pihak_id
								,cb.pengacara_id
								,cb.nama
								,cb.alamat
								,cb.tanggal_kuasa
								,cb.nomor_kuasa
								,a.jumlah_pihak
								,b.jumlah_kuasa
							FROM perkara_pengacara cb 
							LEFT JOIN 
								(SELECT pengacara_id, nama,COUNT(*) AS jumlah_pihak FROM perkara_pengacara 
								WHERE perkara_id = @perkara_id 
								GROUP BY pengacara_id ORDER BY pengacara_id) AS a ON cb.`pengacara_id` = a.pengacara_id
							LEFT JOIN 
								(SELECT pihak_id, nama,COUNT(*) AS jumlah_kuasa FROM perkara_pengacara 
								WHERE perkara_id = @perkara_id 
								GROUP BY pihak_id ORDER BY pihak_id) AS b ON cb.`pihak_id` = b.pihak_id
						WHERE perkara_id = @perkara_id
						GROUP BY pihak_id
						ORDER BY pihak_id) AS f ON a.pihak_id = f.pihak_id
						LEFT JOIN agama AS d ON b.agama_id = d.id
						LEFT JOIN tingkat_pendidikan AS e ON b.pendidikan_id = e.id
						join perkara as g on a.perkara_id = g.perkara_id
						WHERE a.perkara_id = @perkara_id";
			if($is_relaas==0){
				$sql.=" AND IF(@pihak_id IS NOT NULL ,a.`pihak_id`,1) = IF(@pihak_id IS NOT NULL ,@pihak_id,1)";	
			}
			return $this->db->query($sql);
		} catch(PDOException $e) {		
		}
	}

	function get_var_jadwal_sidang(){
		try{
			$sql = "SELECT @temp_tanggal:=tanggal_sidang FROM perkara_jadwal_sidang WHERE perkara_id = @perkara_id AND id = @jadwal_sidang_id";
			$query=$this->db->query($sql);

			$sql = "SELECT a.*, b.*, c.*
						,IF(d.perkara_id IS NULL, 0,1) AS is_perubahan_penahanan
						,IF(e.perkara_id IS NULL, 0,1) AS is_perubahan_majelis
						,IF(f.perkara_id IS NULL, 0,1) AS is_perubahan_panitera
					FROM 
					(SELECT 
						@perkara_id AS perkara_id,
						convert_tanggal_indonesia(tanggal_sidang) AS tanggal_sidang,
						nama_hari(tanggal_sidang) AS hari_sidang,
						CONCAT(DATE_FORMAT(jam_sidang , '%H.%i'),' ',@zona_waktu) AS jam_sidang,
						ruangan AS ruang_sidang,
						agenda AS agenda_sidang,
						IF(sifat_sidang='Y','terbuka','tertutup') AS terbuka_tertutup,
						alasan_ditunda AS alasan_tunda
					FROM perkara_jadwal_sidang WHERE perkara_id = @perkara_id AND id = @jadwal_sidang_id) AS a
					LEFT JOIN 
					(SELECT 
						@perkara_id AS perkara_id, 
						convert_tanggal_indonesia(tanggal_sidang) AS tanggal_tundaan, 
						nama_hari(tanggal_sidang) AS hari_tundaan, 
						CONCAT(DATE_FORMAT(jam_sidang , '%H.%i'),' ',@zona_waktu) AS jam_tundaan, 
						ruangan AS ruang_sidang_tundaan,
						agenda AS agenda_tundaan 
						FROM perkara_jadwal_sidang WHERE perkara_id = @perkara_id AND tanggal_sidang > @temp_tanggal
					ORDER BY tanggal_sidang LIMIT 1)AS b ON a.perkara_id = b.perkara_id
					LEFT JOIN 
					(SELECT 
						@perkara_id AS perkara_id,
						tanggal_sidang AS tanggal_sidang_sebelumnya,
						nama_hari(tanggal_sidang) AS hari_sidang_sebelumnya
					FROM perkara_jadwal_sidang WHERE perkara_id = @perkara_id AND tanggal_sidang < @temp_tanggal
					ORDER BY tanggal_sidang LIMIT 1) AS c ON a.perkara_id = c.perkara_id
					LEFT JOIN 
					(SELECT 
						perkara_id, 
						mulai 
					FROM penahanan_terdakwa 
					WHERE perkara_id = @perkara_id AND mulai < @temp_tanggal 
					GROUP BY mulai) AS d ON d.mulai > c.tanggal_sidang_sebelumnya
					LEFT JOIN 
					(SELECT 
						perkara_id, 
						tanggal_penetapan
					FROM perkara_hakim_pn
					WHERE perkara_id = @perkara_id AND tanggal_penetapan  < @temp_tanggal 
					GROUP BY tanggal_penetapan) AS e ON e.tanggal_penetapan > c.tanggal_sidang_sebelumnya
					LEFT JOIN 
					(SELECT 
						perkara_id, 
						tanggal_penetapan
					FROM perkara_panitera_pn
					WHERE perkara_id = @perkara_id AND tanggal_penetapan < @temp_tanggal 
					GROUP BY tanggal_penetapan) AS f ON f.tanggal_penetapan > c.tanggal_sidang_sebelumnya";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function get_var_putusan_akhir(){
		try{
			$sql = "SELECT 
						perkara_id
						,convert_tanggal_indonesia(tanggal_putusan) AS tanggal_putusan
						,convert_tanggal_indonesia(tanggal_putusan) AS tgl_putusan_pertama
						,tanggal_putusan AS tanggal_putusan_hijriah
						,nama_hari(tanggal_putusan) AS hari_putusan
						,status_putusan_id
						,status_putusan_nama AS jenis_putusan
						,amar_putusan AS amar_putusan
						,convert_tanggal_indonesia(tanggal_bht) AS tanggal_bht
						,nama_hari(tanggal_bht) AS hari_bht
						,convert_tanggal_indonesia(tanggal_minutasi) AS tanggal_minutasi
						,nama_hari(tanggal_minutasi) AS hari_minutasi
					FROM perkara_putusan WHERE perkara_id = @perkara_id";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function get_var_putusan_sela(){
		try{
			$sql = "SELECT 
						convert_tanggal_indonesia(tanggal_putusan_sela) AS tanggal_pts_sela
						,nama_hari(tanggal_putusan_sela) as hari_pts_sela
						,convert_tanggal_indonesia(tanggal_putusan_sela) AS tanggal_putusan_sela
						,nama_hari(tanggal_putusan_sela) as hari_putusan_sela
						,tanggal_putusan_sela AS tanggal_putusan_sela_hijriah
						,is_keberatan_diterima
						,IF(is_keberatan_diterima=1,'Keberatan Diterima',IF(is_keberatan_diterima=2,'Keberatan Ditolak','.....')) AS hasil_putusan_sela
						,amar_sela AS amar_putusan_sela
					FROM perkara_putusan_sela WHERE perkara_id = @perkara_id";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function get_var_ikrar_talak(){
		try{
			$sql = "SELECT 
						convert_tanggal_indonesia(tgl_ikrar_talak) AS tanggal_ikrar
						,nama_hari(tgl_ikrar_talak) AS hari_ikrar
						,tgl_ikrar_talak AS tanggal_ikrar_hijriah
						,amar_ikrar_talak AS amar_penetapan_ikrar
					FROM perkara_ikrar_talak WHERE perkara_id = @perkara_id";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function get_var_penetapan_hari_sidang_verzet(){
		try{
			$sql = "SELECT 
						convert_tanggal_indonesia(tanggal_sidang) AS tanggal_sidang_pertama_perlawanan
						,nama_hari(tanggal_sidang) AS hari_sidang_pertama_perlawanan
						,CONCAT(DATE_FORMAT(jam_sidang , '%H.%i'),' ',@zona_waktu) AS jam_sidang_pertama_perlawanan
					FROM perkara_jadwal_sidang 
					WHERE perkara_id =@perkara_id 
					AND verzet = 'Y'
					ORDER BY tanggal_sidang LIMIT 1";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function get_var_data_perlawanan(){
		try{
			return $this->db->query("SELECT *
									 FROM perkara_verzet
									 WHERE perkara_id=@perkara_id");
		}catch(Exception $e){ return false; }
	}

	function get_var_bukti(){
		try{
			$sql = "SELECT 
						convert_tanggal_indonesia(tanggal_penerimaan) AS tanggal_penerimaan_bukti
						,nama_hari(tanggal_penerimaan) AS nama_penerimaan_bukti
						,jenis_barang_bukti
						,tempat_penyimpanan AS tempat_penyimpanan_bukti
						,tempat_penyerahan AS tempat_penyerahan_bukti
						,nama_penerima AS nama_penerima_bukti
					FROM perkara_barang_bukti 
					WHERE perkara_id = @perkara_id";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function get_var_tanya_jawab_bas(){
		try{
			$sql = "SELECT 
						penanya_id
						,b.`pihak_id` AS saksi_id
						,pertanyaan
						,jawaban
					FROM perkara_keterangan_saksi AS a
					JOIN perkara_pihak5 AS b ON a.`saksi_id` = b.`id`
					WHERE a.perkara_id = @perkara_id AND a.sidang_id = @jadwal_sidang_id
					ORDER BY a.saksi_id, a.penanya_id, a.id";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function get_var_tanya_jawab_putusan(){
		try{
			$sql = "SELECT 
						penanya_id
						,b.`pihak_id` AS saksi_id
						,pertanyaan
						,jawaban
					FROM perkara_keterangan_saksi AS a
					JOIN perkara_pihak5 AS b ON a.`saksi_id` = b.`id`
					WHERE a.perkara_id = @perkara_id
					ORDER BY a.saksi_id, a.penanya_id, a.id";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function get_var_keterangan_terdakwa(){
		try{
			$sql = "SELECT 
						penanya_id
						,b.`pihak_id` AS saksi_id
						,pertanyaan
						,jawaban
					FROM perkara_keterangan_terdakwa AS a
					JOIN perkara_pihak2 AS b ON a.`pihak_id` = b.`id`
					WHERE a.perkara_id = @perkara_id AND a.sidang_id = @jadwal_sidang_id
					ORDER BY a.pihak_id, a.penanya_id, a.id";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function get_var_data_sidang(){
		try{
			$sql = "SELECT 
						REPLACE(LOWER(b.`nama_kolom`),' ','_') AS `nama_kolom`,
						GROUP_CONCAT(a.`uraian` SEPARATOR ' \\\\par ') AS uraian
					FROM referensi_kolom_data_template AS b
					LEFT JOIN perkara_data_template_sidang AS a ON a.`kolom_id` = b.id AND a.`perkara_id` = @perkara_id AND IF(@jadwal_sidang_id IS NOT NULL ,a.`sidang_id`,1) = IF(@jadwal_sidang_id IS NOT NULL ,@jadwal_sidang_id,1)
					GROUP BY b.id";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function get_var_pendapat_terdakwa(){
		try{
			$sql = "SELECT 
						b.pihak_id as pihak_id, 
						c.pihak_id as saksi_id, 
						a.pendapat 
					FROM perkara_pendapat_terdakwa AS a
					JOIN perkara_pihak2 AS b ON a.`pihak_id` = b.`id`
					JOIN perkara_pihak5 AS c ON a.`saksi_id` = c.`id`
					WHERE a.perkara_id = @perkara_id AND a.sidang_id = @jadwal_sidang_id 
					ORDER BY a.saksi_id, a.pihak_id";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}


	function get_var_mil(){
		try{
			$sql = "SELECT 
						CONCAT_WS('/',split_string(split_string(nomor_perkara,'/',1),'-',1),
							split_string(nomor_perkara,'/',2),
							split_string(nomor_perkara,'/',3),
							bulan_romawi(IF(@tanggal is NOT NULL, month(@tanggal),IF(@proses_id=20,b.bln, IF(@proses_id=30,c.bln, IF(@proses_id=80,d.bln, IF(@proses_id=210 or @proses_id=215 ,e.bln, month(a.tanggal_pendaftaran))))))),
							IF(@tanggal is NOT NULL, year(@tanggal),IF(@proses_id=20,b.thn, IF(@proses_id=30,c.thn, IF(@proses_id=80,d.thn, IF(@proses_id=210 or @proses_id=215 ,e.thn, year(a.tanggal_pendaftaran))))))
							) AS nomor_perkara_mil 
					FROM perkara AS a
					LEFT JOIN 
						(SELECT @perkara_id AS perkara_id, MONTH(tanggal_penetapan) AS bln, YEAR(tanggal_penetapan) AS thn FROM perkara_hakim_pn 
						WHERE perkara_id = @perkara_id AND aktif = 'Y' GROUP BY perkara_id) AS b ON a.`perkara_id` = b.perkara_id
					LEFT JOIN 
						(SELECT @perkara_id AS perkara_id, MONTH(tanggal_penetapan) AS bln, YEAR(tanggal_penetapan) AS thn FROM perkara_panitera_pn 
						WHERE perkara_id = @perkara_id AND aktif = 'Y' GROUP BY perkara_id) AS c ON a.`perkara_id` = c.perkara_id
					LEFT JOIN 
						(SELECT @perkara_id AS perkara_id, MONTH(penetapan_hari_sidang) AS bln, YEAR(penetapan_hari_sidang) AS thn FROM perkara_penetapan 
						WHERE perkara_id = @perkara_id GROUP BY perkara_id) AS d ON a.`perkara_id` = d.perkara_id
					LEFT JOIN 
						(SELECT @perkara_id AS perkara_id, MONTH(tanggal_putusan) AS bln, YEAR(tanggal_putusan) AS thn FROM perkara_putusan 
						WHERE perkara_id = @perkara_id GROUP BY perkara_id) AS e ON a.`perkara_id` = e.perkara_id
					WHERE a.perkara_id = @perkara_id;";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function get_var_hasil_relaas(){
		try{
			$sql = "SELECT 
						b.pihak_ke
						,convert_tanggal_indonesia(a.`tanggal_relaas`) AS tanggal_relaas
						,nama_hari(a.`tanggal_relaas`) AS hari_relaas
						,IF(a.`ket_temu`='Y','Ya', 'Tidak') AS bertemu
						,ket_hasil_relaas AS hasil_relaas
					FROM 
					(SELECT pihak_id, 'pihak1' AS pihak_ke FROM perkara_pihak1 WHERE perkara_id = @perkara_id UNION 
					SELECT pihak_id, 'pihak2' AS pihak_ke FROM perkara_pihak2 WHERE perkara_id = @perkara_id) AS b
					LEFT JOIN perkara_pelaksanaan_relaas AS a ON a.`pihak_id` = b.pihak_id AND a.sidang_id = @jadwal_sidang_id;";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function get_var_biaya(){
		try{
			$sql = "SELECT 
						REPLACE(SUM(IF(kategori_id=12,jumlah,0)),'.00','') AS biaya_proses,
						REPLACE(SUM(IF(kategori_id=11,jumlah,0)),'.00','') AS biaya_pendaftaran,
						REPLACE(SUM(IF(kategori_id=4,jumlah,0)),'.00','') AS biaya_panggilan,
						IF(id_pembiayaan=1,'5000',IF(id_pembiayaan = 2,'0','0')) AS biaya_redaksi,
						IF(id_pembiayaan=1,'6000',IF(id_pembiayaan = 2,'6000','0')) AS biaya_meterai,
						IF(id_pembiayaan=1,'3000',IF(id_pembiayaan = 2,'0','0')) AS biaya_leges,
						REPLACE(SUM(IF(kategori_id=7,jumlah,0)),'.00','') AS biaya_pemeriksaan,
						REPLACE(SUM(IF(kategori_id=5,jumlah,0)),'.00','') AS biaya_sita						
					FROM (SELECT perkara_id, id_pembiayaan,kategori_id, tanggal_transaksi, jumlah FROM perkara_biaya WHERE perkara_id = @perkara_id AND tahapan_id = 10)AS a 
					LEFT JOIN (SELECT perkara_id,tanggal_putusan FROM perkara_putusan WHERE perkara_id = @perkara_id) AS b ON a.perkara_id = b.perkara_id
					AND a.tanggal_transaksi <= IF(b.perkara_id IS NULL,NOW(),b.tanggal_putusan)";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}
}
