<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Tab_verzet_c extends CI_Controller {
	function index(){		
		$data=$this->load_data();
		$this->load->view('perkara_tab/verzet/tab_verzet_v', $data);
	}

	function load_data(){
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['perkara_id'] = $this->encrypt->decode(base64_decode($data['enc']));
		$data['idperkara'] = $data['perkara_id'];
		
		$this->load->model('verzet/verzet_m');
		$row=$this->verzet_m->get_no_perkara($data['perkara_id']);
		$data['nomor_perkara']=$row->nomor_perkara;
		$data['idalurperkara'] = $row->alur_perkara_id;
		$data['idjenisperkara'] = $row->jenis_perkara_id;
		$data['idproses'] = $row->proses_terakhir_id;

		if($data['idalurperkara']==9){
			$data['tahapan'] = 13;
			$data['tanggal_putusan']=$this->verzet_m->getTanggalDismissal($data['perkara_id']);
		}else{
			$data['tahapan'] = 16;
			$data['tanggal_putusan']=$row->tanggal_putusan;
		}
		$data['tanggal_pendaftaran_verzet']=$row->tanggal_pendaftaran_verzet;
		$data['tanggal_surat']=$row->tanggal_surat;
		$data['penetapan_majelis_hakim']=$row->penetapan_majelis_hakim;
		$data['majelis_hakim_id']=$row->majelis_hakim_id;
		$data['majelis_hakim_nama']=$row->majelis_hakim_nama;
		$data['majelis_hakim_text']=$row->majelis_hakim_text;
		$data['penetapan_panitera_pengganti']=$row->penetapan_panitera_pengganti;
		$data['panitera_pengganti_id']=$row->panitera_pengganti_id;
		$data['panitera_pengganti_text']=$row->panitera_pengganti_text;
		$data['penetapan_jurusita']=$row->penetapan_jurusita;
		$data['jurusita_id']=$row->jurusita_id;
		$data['jurusita_text']=$row->jurusita_text;
		$data['tanggal_penetapan_sidang_verzet']=$row->tanggal_penetapan_sidang_verzet;
		$data['tanggal_sidang_pertama_verzet']=$row->tanggal_sidang_pertama_verzet;
		$data['putusan_verzet']=$row->putusan_verzet;
		$data['status_putusan_verzet_id']=$row->status_putusan_verzet_id;
		$data['status_putusan_verzet_text']=$row->status_putusan_verzet_text;
		$data['amar_putusan_verzet']=$row->amar_putusan_verzet;
		$data['amar_putusan_verzet_dok']=$row->amar_putusan_verzet_dok;
		$data['pemberitahuan_putusan']=$row->pemberitahuan_putusan;
		$data['pemberitahuan_putusan_verzet']=$row->pemberitahuan_putusan_verzet;
		$data['pemberitahuan_putusan_verzet_pihak1']=$row->pemberitahuan_putusan_verzet_pihak1;
		$data['pemberitahuan_putusan_verzet_pihak2']=$row->pemberitahuan_putusan_verzet_pihak2;
		$data['catatan_putusan_verzet']=$row->catatan_putusan_verzet;
		$data['tanggal_minutasi_verzet'] = $row->tanggal_minutasi_verzet;
		$data['current_date'] = date('d/m/Y');
		$data['sumber_hukum_text'] = $row->sumber_hukum_text;
		$data['verstek'] = $row->putusan_verstek;
		$data['isAlreadyBanding'] = $this->verzet_m->isAlreadyBanding($data['perkara_id']);

		#$this->load->model('verzet/verzet_m');
		#$row=$this->verzet_m->getStatusPutusanVerzet($data['perkara_id']);
		$data['status_putusan_verzet_id'] = $row->status_putusan_verzet_id;
		$data['tanggalminutasiverzet'] = $row->tanggal_minutasi_verzet;
		#mediasi_verzet	
		$this->load->model('mediasi/jadwal_mediasi_m');
		$data['infomediasi'] = $this->verzet_m->getDataMediasiVerzet($data['perkara_id']);
		$infomediasi= $data['infomediasi']->result();
		$data['info_dukung_mediasi']=$this->verzet_m->data_dukung_mediasi($infomediasi[0]->mediasi_id);
		$i=1;
		foreach($data['infomediasi']->result() as $row){
			$jadwalmediasi 	="jadwalmediasi".$i;
			$mediasiid 		=$row->mediasi_id;			
			$listdata[$jadwalmediasi]=$this->jadwal_mediasi_m->get_data_jadwal_mediasi($mediasiid);
			$i++;
		}
		if(!empty($listdata)){
			$data['listjadwalmediasi']=$listdata; 
		}		
		return $data;
	}

	function add_verzet(){
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['perkara_id'] = $this->encrypt->decode(base64_decode($data['enc']));
		
		$this->load->model('verzet/verzet_m');
		$row= $this->verzet_m->get_no_perkara($data['perkara_id']);
		$data['nomor_perkara']=$row->nomor_perkara;
		
		$data['idalurperkara'] = $row->alur_perkara_id;

		if($data['idalurperkara']==9){
			$data['tahapan'] = 13;
			$data['tanggal_putusan']=$this->verzet_m->getTanggalDismissal($data['perkara_id']);
		}else{
			$data['tahapan'] = 16;
			$data['tanggal_putusan']=$row->tanggal_putusan;
		}
		
		$data['tanggal_pendaftaran_verzet']=$row->tanggal_pendaftaran_verzet;
		$data['tanggal_surat']=$row->tanggal_surat;
		$data['current_date'] = date('d/m/Y');
		$data['isAlreadyBanding'] = $this->verzet_m->isAlreadyBanding($data['perkara_id']);
		$data['verstek'] = '';
		$data['action']='add';
		$this->load->view('perkara_tab/verzet/form_verzet_v', $data);
	}

	function edit_verzet(){
		$data=$this->load_data();
		$data['action']='edit';
		$this->load->view('perkara_tab/verzet/form_verzet_v', $data);
	}

	function penetapan_majelis(){
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['perkara_id'] = $this->encrypt->decode(base64_decode($data['enc']));
		
		$this->load->model('verzet/verzet_m');
		$row=$this->verzet_m->get_no_perkara($data['perkara_id']);
		$data['nomor_perkara']	= $row->nomor_perkara;

		$data['idalurperkara'] = $row->alur_perkara_id;

		if($data['idalurperkara']==9){
			$data['tahapan'] = 13;
			$data['tanggal_putusan']=$this->verzet_m->getTanggalDismissal($data['perkara_id']);
		}else{
			$data['tahapan'] = 16;
			$data['tanggal_putusan']=$row->tanggal_putusan;
		}
		$data['majelis_hakim_id'] = $row->majelis_hakim_id;
		$data['tanggal_pendaftaran_verzet']	= $row->tanggal_pendaftaran_verzet;
		$data['penetapan_majelis_hakim']	= $row->penetapan_majelis_hakim;
		$data['current_date'] = date('d/m/Y');
		$data['listHakim'] = $this->verzet_m->getListHakim();
		$data['idketua'] = '';
		$data['idAnggota1'] = '';
		$data['idAnggota2'] = '';
		$tmp = explode(',', $data['majelis_hakim_id']);
		if(count($tmp)>2){
			$data['idketua'] = $tmp[0];
			$data['idAnggota1'] = $tmp[1];
			$data['idAnggota2'] = $tmp[2];
		}

		$this->load->view('perkara_tab/verzet/form_verzet_penetapan_h', $data);
	}

	function validateInputPenetapanHakim(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$status = $this->input->post('status', TRUE);

		if($status=='Y'){
			$this->load->model('verzet/verzet_m','verzet');
			$dataMajelisLama = $this->verzet->getOldPenetapanMajelis($idperkara);
			if($dataMajelisLama->num_rows()>0){
				foreach ($dataMajelisLama->result() as $row) {
					$dataPenetapan = array(
						'penetapan_majelis_hakim'=>$row->penetapan_majelis_hakim,
						'majelis_hakim_id'=>$row->majelis_hakim_id,
						'majelis_hakim_nama'=>$row->majelis_hakim_nama,
						'majelis_hakim_text'=>$row->majelis_hakim_text,
						'diperbaharui_oleh'=>$this->session->userdata('username'),
						'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
					);
				}
				$result = $this->verzet->updateDataPenetapanMajelis($idperkara,$dataPenetapan);
				if($result){
					echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
					return;
				}else{
					echo json_encode(array('st'=>0,'msg'=>'Error, Data Tidak Dapat Disimpan'));
					return;
				}
			}
		}

		$this->form_validation->set_rules('tgl_pen_majelis', 'Tanggal Penetapan Majelis Hakim', 'trim|required|max_length[10]|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;

		}else{
			$hakimKetua = $this->encrypt->decode(base64_decode($this->input->post('h_ketua', TRUE)));
			$hakimAnggota1 = $this->encrypt->decode(base64_decode($this->input->post('h_anggota1', TRUE)));
			$hakimAnggota2 = $this->encrypt->decode(base64_decode($this->input->post('h_anggota2', TRUE)));

			$tglPenetapan = $this->input->post('tgl_pen_majelis', TRUE);
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tglPenetapan = $this->tanggalhelper->convertToMysqlDate($tglPenetapan);
			if($tglPenetapan==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPenetapan,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tglPenetapan);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penetapan Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglPutusan = $this->tanggalhelper->getTanggalPutusan($idperkara);
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusan,$tglPenetapan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Kurang Dari Tanggal Putusan/Penetapan. '.$this->tanggalhelper->convertDayDate($tglPutusan)));
				return;
			}

			$this->load->model('verzet/verzet_m','verzet');
			$tglPermohonan = $this->verzet->getTanggalPermohonan($idperkara);

			$selisih = $this->tanggalhelper->getSelisihHari($tglPermohonan,$tglPenetapan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Kurang Dari Tanggal Permohonan '.$this->nativesession->getLangguage('verzet')));
				return;
			}

			if(intval($hakimKetua)<0){
				echo json_encode(array('st'=>0,'msg'=>'Error, Identitas Hakim Ketua Tidak Ditemukan.'));
				return;
			}elseif(empty($hakimKetua)){
				echo json_encode(array('st'=>0,'msg'=>'Error, Pilih Hakim Ketua.'));
				return;
			}
			if(intval($hakimAnggota1)<0){
				echo json_encode(array('st'=>0,'msg'=>'Error, Identitas Hakim Anggota I Tidak Ditemukan.'));
				return;
			}elseif(empty($hakimAnggota1)){
				echo json_encode(array('st'=>0,'msg'=>'Error, Pilih Hakim Anggota I.'));
				return;
			}

			if(intval($hakimAnggota2)<0){
				echo json_encode(array('st'=>0,'msg'=>'Error, Identitas Hakim Anggota II Tidak Ditemukan.'));
				return;
			}elseif(empty($hakimAnggota2)){
				echo json_encode(array('st'=>0,'msg'=>'Error, Pilih Hakim Anggota II.'));
				return;
			}
			if($hakimKetua==$hakimAnggota1 OR $hakimKetua== $hakimAnggota2 OR $hakimAnggota1==$hakimAnggota2){
				echo json_encode(array('st'=>0,'msg'=>'Error, Tidak Dapat Memilih Hakim Yang Sama.'));
				return;
			}
			$hakimKetuaNama = $this->verzet->getHakimNama($hakimKetua);
			$hakimAnggota1Nama = $this->verzet->getHakimNama($hakimAnggota1);
			$hakimAnggota2Nama = $this->verzet->getHakimNama($hakimAnggota2);
			$majelisHakimText = 'Hakim Ketua: '.$hakimKetuaNama.'</br>Hakim Anggota 1: '.$hakimAnggota1Nama.'</br>Hakim Anggota 2: '.$hakimAnggota2Nama;
			$majelisHakimID = $hakimKetua.','.$hakimAnggota1.','.$hakimAnggota2;
			$majelisHakimNamaText = $hakimKetuaNama.'</br>'.$hakimAnggota1Nama.'</br>'.$hakimAnggota2Nama;
			
			$dataPenetapan = array(
				'penetapan_majelis_hakim'=>$tglPenetapan,
				'majelis_hakim_id'=>$majelisHakimID,
				'majelis_hakim_nama'=>$majelisHakimNamaText,
				'majelis_hakim_text'=>$majelisHakimText,
				'diperbaharui_oleh'=>$this->session->userdata('username'),
				'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
				);
			if($this->session->userdata('jenis_pengadilan')==3){
				$tahapan = 13;
			}else{
				$tahapan = 16;
			}

			$datahakim=array(
				array(
					'perkara_id'=>$idperkara,
					'tahapan_id' => $tahapan,
					'tanggal_penetapan' =>$tglPenetapan,
					'urutan' => 1,
					'jabatan_hakim_id' => 1,
					'jabatan_hakim_nama' => 'Hakim Ketua',
					'hakim_id' => $hakimKetua,
					'hakim_nama' => $hakimKetuaNama,
					'aktif' => 'Y',
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
					),
				array(
					'perkara_id'=>$idperkara,
					'tahapan_id' => $tahapan,
					'tanggal_penetapan' =>$tglPenetapan,
					'urutan' => 2,
					'jabatan_hakim_id' => 2,
					'jabatan_hakim_nama' => 'Hakim Anggota',
					'hakim_id' => $hakimAnggota1,
					'hakim_nama' => $hakimAnggota1Nama,
					'aktif' => 'Y',
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
					),
				array(
					'perkara_id'=>$idperkara,
					'tahapan_id' => $tahapan,
					'tanggal_penetapan' =>$tglPenetapan,
					'urutan' => 3,
					'jabatan_hakim_id' => 2,
					'jabatan_hakim_nama' => 'Hakim Anggota',
					'hakim_id' => $hakimAnggota2,
					'hakim_nama' => $hakimAnggota2Nama,
					'aktif' => 'Y',
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
					)
				);
			$result = $this->verzet->updateDataPenetapanMajelis($idperkara,$dataPenetapan,$datahakim);
			if($result){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpanss'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Error, Data Tidak Dapat Disimpan'));
				return;
			}
			
		}
	}

	function penetapan_panitera(){
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['perkara_id'] = $this->encrypt->decode(base64_decode($data['enc']));
		
		$this->load->model('verzet/verzet_m');
		$row=$this->verzet_m->get_no_perkara($data['perkara_id']);
		$data['nomor_perkara']	= $row->nomor_perkara;
		$data['idalurperkara'] = $row->alur_perkara_id;

		if($data['idalurperkara']==9){
			$data['tahapan'] = 13;
			$data['tanggal_putusan']=$this->verzet_m->getTanggalDismissal($data['perkara_id']);
		}else{
			$data['tahapan'] = 16;
			$data['tanggal_putusan']=$row->tanggal_putusan;
		}
		$data['panitera_id'] = $row->panitera_pengganti_id;
		$data['tanggal_pendaftaran_verzet']	= $row->tanggal_pendaftaran_verzet;
		$data['tanggal_surat']	= $row->tanggal_surat;
		$data['penetapan_panitera_pengganti']	= $row->penetapan_panitera_pengganti;
		$data['current_date'] = date('d/m/Y');
		$data['listPanitera'] = $this->verzet_m->getListPanitera();
		$tmp = explode(',', $data['panitera_id']);
		if(count($tmp)>1){
			$data['idPanitera1'] = $tmp[0];
			$data['idPanitera2'] = $tmp[1];
		}else{
			$data['idPanitera1'] = $data['panitera_id'];
			$data['idPanitera2'] = '';
		}
		$this->load->view('perkara_tab/verzet/form_verzet_penetapan_pp', $data);
	}

	function validateInputPenetapanPanitera(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$status = $this->input->post('status', TRUE);

		if($status=='Y'){
			$this->load->model('verzet/verzet_m','verzet');
			$dataPaniteraLama = $this->verzet->getOldPenetapanPanitera($idperkara);
			if($dataPaniteraLama->num_rows()>0){
				foreach ($dataPaniteraLama->result() as $row) {
					$dataPenetapan = array(
						'penetapan_panitera_pengganti'=>$row->penetapan_panitera_pengganti,
						'panitera_pengganti_id'=>$row->panitera_pengganti_id,
						'panitera_pengganti_text'=>$row->panitera_pengganti_text,
						'diperbaharui_oleh'=>$this->session->userdata('username'),
						'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
					);
				}
				$result = $this->verzet->updateDataPenetapanPanitera($idperkara,$dataPenetapan);
				if($result){
					echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
					return;
				}else{
					echo json_encode(array('st'=>0,'msg'=>'Error, Data Tidak Dapat Disimpan'));
					return;
				}
			}
		}
		
		$this->form_validation->set_rules('tgl_pen_panitera', 'Tanggal Penetapan Panitera Pengganti', 'trim|required|max_length[10]|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;

		}else{
			$panitera1 = $this->encrypt->decode(base64_decode($this->input->post('panitera1', TRUE)));
			$panitera2 = $this->encrypt->decode(base64_decode($this->input->post('panitera2', TRUE)));

			$tglPenetapan = $this->input->post('tgl_pen_panitera', TRUE);
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tglPenetapan = $this->tanggalhelper->convertToMysqlDate($tglPenetapan);
			if($tglPenetapan==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPenetapan,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tglPenetapan);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penetapan Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglPutusan = $this->tanggalhelper->getTanggalPutusan($idperkara);
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusan,$tglPenetapan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Kurang Dari Tanggal Putusan. '.$this->tanggalhelper->convertDayDate($tglPutusan)));
				return;
			}

			$this->load->model('verzet/verzet_m','verzet');
			$tglPermohonan = $this->verzet->getTanggalPermohonan($idperkara);

			$selisih = $this->tanggalhelper->getSelisihHari($tglPermohonan,$tglPenetapan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Kurang Dari Tanggal Permohonan '.$this->nativesession->getLangguage('verzet')));
				return;
			}

			if(intval($panitera1)<0){
				echo json_encode(array('st'=>0,'msg'=>'Error, Identitas Panitera Pertama Tidak Ditemukan.'));
				return;
			}elseif(empty($panitera1)){
				echo json_encode(array('st'=>0,'msg'=>'Error, Pilih Panitera Pertama.'));
				return;
			}
			$panitera1Nama = $this->verzet->getPaniteraNama($panitera1);
			$paniteraID = $panitera1;
			$paniteraText = 'Panitera Pengganti: '.$panitera1Nama;

			if($this->session->userdata('jenis_pengadilan')==3){
				$tahapan = 13;
			}else{
				$tahapan = 16;
			}

			$datapanitera = array(
				array(
					'perkara_id'=>$idperkara,
					'tahapan_id' => $tahapan,
					'tanggal_penetapan' =>$tglPenetapan,
					'urutan' => 1,
					'panitera_id' => $panitera1,
					'panitera_nama' => $panitera1Nama,
					'aktif' => 'Y',
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
					)
				);

			if(!empty($panitera2)){
				if(intval($panitera2)<0){
					echo json_encode(array('st'=>0,'msg'=>'Error, Identitas Panitera Kedua Tidak Ditemukan.'));
					return;
				}elseif(empty($panitera2)){
					echo json_encode(array('st'=>0,'msg'=>'Error, Pilih Panitera Kedua.'));
					return;
				}

				if($panitera1==$panitera2){
					echo json_encode(array('st'=>0,'msg'=>'Error, Tidak Dapat Memilih Panitera Yang Sama.'));
					return;
				}

				$panitera2Nama 	= $this->verzet->getPaniteraNama($panitera2);
				$paniteraID 	.=  ','.$panitera2;
				$paniteraText 	.=  '</br>'.$panitera2Nama;

				$datapanitera[1] = array(
					'perkara_id'=>$idperkara,
					'tahapan_id' => $tahapan,
					'tanggal_penetapan' =>$tglPenetapan,
					'urutan' => 2,
					'panitera_id' => $panitera2,
					'panitera_nama' => $panitera2Nama,
					'aktif' => 'Y',
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
					);
			}
			
			$dataPenetapan = array(
				'penetapan_panitera_pengganti'=>$tglPenetapan,
				'panitera_pengganti_id'=>$paniteraID,
				'panitera_pengganti_text'=>$paniteraText,
				'diperbaharui_oleh'=>$this->session->userdata('username'),
				'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
			);
			$result = $this->verzet->updateDataPenetapanPanitera($idperkara,$dataPenetapan,$datapanitera);
			if($result){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Error, Data Tidak Dapat Disimpan'));
				return;
			}
			
		}
	}

	function penetapan_jurusita(){
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['perkara_id'] = $this->encrypt->decode(base64_decode($data['enc']));
		
		$this->load->model('verzet/verzet_m');
		$row=$this->verzet_m->get_no_perkara($data['perkara_id']);
		$data['nomor_perkara']	= $row->nomor_perkara;
		$data['idalurperkara'] = $row->alur_perkara_id;

		if($data['idalurperkara']==9){
			$data['tahapan'] = 13;
			$data['tanggal_putusan']=$this->verzet_m->getTanggalDismissal($data['perkara_id']);
		}else{
			$data['tahapan'] = 16;
			$data['tanggal_putusan']=$row->tanggal_putusan;
		}
		$data['jurusita_id'] = $row->jurusita_id;
		$data['tanggal_pendaftaran_verzet']	= $row->tanggal_pendaftaran_verzet;
		$data['penetapan_jurusita']	= $row->penetapan_jurusita;
		$data['current_date'] = date('d/m/Y');
		$data['listJurusita'] = $this->verzet_m->getListJurusita();
		$tmp = explode(',', $data['jurusita_id']);
		if(count($tmp)>1){
			$data['idJurusita1'] = $tmp[0];
			$data['idJurusita2'] = $tmp[1];
		}else{
			$data['idJurusita1'] = $data['jurusita_id'];
			$data['idJurusita2'] = '';
		}
		$this->load->view('perkara_tab/verzet/form_verzet_penetapan_jurusita', $data);
	}

	function validateInputPenetapanJurusita(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$status = $this->input->post('status', TRUE);

		if($status=='Y'){
			$this->load->model('verzet/verzet_m','verzet');
			$dataJuristaLama = $this->verzet->getOldPenetapanJurusita($idperkara);
			if($dataJuristaLama->num_rows()>0){
				foreach ($dataJuristaLama->result() as $row) {
					$dataPenetapan = array(
						'penetapan_jurusita'=>$row->penetapan_jurusita,
						'jurusita_id'=>$row->jurusita_id,
						'jurusita_text'=>$row->jurusita_text,
						'diperbaharui_oleh'=>$this->session->userdata('username'),
						'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
					);
				}
				$result = $this->verzet->updateDataPenetapanJurusita($idperkara,$dataPenetapan);
				if($result){
					echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
					return;
				}else{
					echo json_encode(array('st'=>0,'msg'=>'Error, Data Tidak Dapat Disimpan'));
					return;
				}
			}
		}

		$this->form_validation->set_rules('tgl_pen_js', 'Tanggal Penetapan Jurusita', 'trim|required|max_length[10]|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;

		}else{
			$jurusita1 = $this->encrypt->decode(base64_decode($this->input->post('jurusita1', TRUE)));
			$jurusita2 = $this->encrypt->decode(base64_decode($this->input->post('jurusita2', TRUE)));

			$tglPenetapan = $this->input->post('tgl_pen_js', TRUE);
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tglPenetapan = $this->tanggalhelper->convertToMysqlDate($tglPenetapan);
			if($tglPenetapan==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPenetapan,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tglPenetapan);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penetapan Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglPutusan = $this->tanggalhelper->getTanggalPutusan($idperkara);
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusan,$tglPenetapan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Kurang Dari Tanggal Putusan. '.$this->tanggalhelper->convertDayDate($tglPutusan)));
				return;
			}

			$this->load->model('verzet/verzet_m','verzet');
			$tglPermohonan = $this->verzet->getTanggalPermohonan($idperkara);

			$selisih = $this->tanggalhelper->getSelisihHari($tglPermohonan,$tglPenetapan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Kurang Dari Tanggal Permohonan '.$this->nativesession->getLangguage('verzet')));
				return;
			}

			if(intval($jurusita1)<0){
				echo json_encode(array('st'=>0,'msg'=>'Error, Identitas Jurusita Pertama Tidak Ditemukan.'));
				return;
			}elseif(empty($jurusita1)){
				echo json_encode(array('st'=>0,'msg'=>'Error, Pilih Jurusita Pertama.'));
				return;
			}
			$jurusita1Nama = $this->verzet->getJurusitaNama($jurusita1);
			$jurusitaID = $jurusita1;
			$jurusitaText = 'Juru Sita Pengganti: '.$jurusita1Nama;
			
			if($this->session->userdata('jenis_pengadilan')==3){
				$tahapan = 13;
			}else{
				$tahapan = 16;
			}
			$datajurusita = array(
				array(
					'perkara_id'=>$idperkara,
					'tahapan_id' => $tahapan,
					'tanggal_penetapan' =>$tglPenetapan,
					'urutan' => 1,
					'jurusita_id' => $jurusita1,
					'jurusita_nama' => $jurusita1Nama,
					'aktif' => 'Y',
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
					)
				);

			if(!empty($jurusita2)){
				if(intval($jurusita2)<0){
					echo json_encode(array('st'=>0,'msg'=>'Error, Identitas Jurusita Kedua Tidak Ditemukan.'));
					return;
				}elseif(empty($jurusita2)){
					echo json_encode(array('st'=>0,'msg'=>'Error, Pilih Jurusita Kedua.'));
					return;
				}

				if($jurusita1==$jurusita2){
					echo json_encode(array('st'=>0,'msg'=>'Error, Tidak Dapat Memilih Jurusita Yang Sama.'));
					return;
				}

				$jurusita2Nama 	= $this->verzet->getPaniteraNama($jurusita2);
				$jurusitaID 	.=  ','.$jurusita2;
				$jurusitaText 	.=  '</br>'.$jurusita2Nama;

				$datajurusita[1] = array(
					'perkara_id'=>$idperkara,
					'tahapan_id' => $tahapan,
					'tanggal_penetapan' =>$tglPenetapan,
					'urutan' => 2,
					'jurusita_id' => $jurusita2,
					'jurusita_nama' => $jurusita2Nama,
					'aktif' => 'Y',
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
					);
			}
			
			$dataPenetapan = array(
				'penetapan_jurusita'=>$tglPenetapan,
				'jurusita_id'=>$jurusitaID,
				'jurusita_text'=>$jurusitaText,
				'diperbaharui_oleh'=>$this->session->userdata('username'),
				'diperbaharui_tanggal'=>date('Y-m-d H:i:s')					
			);
			$result = $this->verzet->updateDataPenetapanJurusita($idperkara,$dataPenetapan);
			if($result){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Error, Data Tidak Dapat Disimpan'));
				return;
			}
			
		}
	}

	function penetapan_sidang(){
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['perkara_id'] = $this->encrypt->decode(base64_decode($data['enc']));
		
		$this->load->model('verzet/verzet_m');
		$row=$this->verzet_m->get_no_perkara($data['perkara_id']);
		$data['nomor_perkara']	= $row->nomor_perkara;
		$data['enc_sidang']	= base64_encode($this->encrypt->encode($row->sidang_id));
		$data['idalurperkara'] = $row->alur_perkara_id;

		if($data['idalurperkara']==9){
			$data['tahapan'] = 13;
			$data['tanggal_putusan']=$this->verzet_m->getTanggalDismissal($data['perkara_id']);
		}else{
			$data['tahapan'] = 16;
			$data['tanggal_putusan']=$row->tanggal_putusan;
		}
		$data['tanggal_pendaftaran_verzet']	= $row->tanggal_pendaftaran_verzet;
		$data['tanggal_penetapan_sidang_verzet']	= $row->tanggal_penetapan_sidang_verzet;
		$data['tanggal_sidang_pertama_verzet']	= $row->tanggal_sidang_pertama_verzet;
		$data['current_date'] = date('d/m/Y');
		$this->load->view('perkara_tab/verzet/form_verzet_penetapan_sidang', $data);
	}

	function validateInputPenetapanSidang(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		
		$this->form_validation->set_rules('tgl_pen_sidang', 'Tanggal Penetapan Sidang Pertama', 'trim|required|max_length[10]|xss_clean');
		$this->form_validation->set_rules('tgl_sidang', 'Tanggal Sidang Pertama', 'trim|required|max_length[10]|xss_clean');
		
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{

			$tglPenetapan = $this->input->post('tgl_pen_sidang', TRUE);
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tglPenetapan = $this->tanggalhelper->convertToMysqlDate($tglPenetapan);
			if($tglPenetapan==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPenetapan,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tglPenetapan);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penetapan Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglPutusan = $this->tanggalhelper->getTanggalPutusan($idperkara);
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusan,$tglPenetapan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Kurang Dari Tanggal Putusan. '.$this->tanggalhelper->convertDayDate($tglPutusan)));
				return;
			}

			$this->load->model('verzet/verzet_m','verzet');
			$tglPermohonan = $this->verzet->getTanggalPermohonan($idperkara);

			$selisih = $this->tanggalhelper->getSelisihHari($tglPermohonan,$tglPenetapan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Kurang Dari Tanggal Permohonan '.$this->nativesession->getLangguage('verzet')));
				return;
			}

			$tglSidang = $this->input->post('tgl_sidang', TRUE);
			$tglSidang = $this->tanggalhelper->convertToMysqlDate($tglSidang);
			if($tglSidang==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tglSidang);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Sidang Pertama Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglPutusan = $this->tanggalhelper->getTanggalPutusan($idperkara);
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusan,$tglSidang);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Sidang Pertama Tidak Boleh Kurang Dari Tanggal Putusan. '.$this->tanggalhelper->convertDayDate($tglPutusan)));
				return;
			}

			$this->load->model('verzet/verzet_m','verzet');
			$tglPermohonan = $this->verzet->getTanggalPermohonan($idperkara);

			$selisih = $this->tanggalhelper->getSelisihHari($tglPermohonan,$tglSidang);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Sidang Pertama Tidak Boleh Kurang Dari Tanggal Permohonan '.$this->nativesession->getLangguage('verzet')));
				return;
			}
			
			$dataPenetapan = array(
				'tanggal_penetapan_sidang_verzet'=>$tglPenetapan,
				'tanggal_sidang_pertama_verzet'=>$tglSidang,
				'diperbaharui_oleh'=>$this->session->userdata('username'),
				'diperbaharui_tanggal'=>date('Y-m-d H:i:s')			
			);
			
			
			$hasSidangPertama = $this->verzet->hasSidangPertama($idperkara);
			$lastSidang = $this->verzet->getLastSidang($idperkara);
			if ($tglSidang<$lastSidang){
				$lastSidang = $this->tanggalhelper->convertDayDate($lastSidang);
				echo json_encode(array('st'=>0,'msg'=>'Tanggal Sidang '.$this->nativesession->getLangguage('verzet').' Tidak Boleh sebelum Tanggal Sidang Terakhir. '.$lastSidang));
				return;
			}
			if($hasSidangPertama==FALSE){
				$dataSidang = array(
					'perkara_id'=>$idperkara, 
					'verzet'=>'Y',
					'tanggal_sidang'=>$tglSidang, 
					'jam_sidang'=>'09:00',
					'agenda'=>'SIDANG PERTAMA PERMOHONAN '.strtoupper($this->nativesession->getLangguage('verzet')),
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
				);
				$idjadwalsidang = $this->verzet->addJadwalSidang($dataSidang);
				$dataPenetapan['sidang_id'] = $idjadwalsidang;
			}else{
				$dataSidang = array(
					'perkara_id'=>$idperkara, 
					'verzet'=>'Y',
					'tanggal_sidang'=>$tglSidang, 
					'jam_sidang'=>'09:00',
					'agenda'=>'SIDANG PERTAMA PERMOHONAN '.strtoupper($this->nativesession->getLangguage('verzet')),
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
				);
				$datasidangpertama = $this->verzet->getSidangPertamaVerzet($idperkara);
				if($datasidangpertama!=''){
					foreach ($datasidangpertama->result() as $row) {
						$dataSidang['id'] = $row->id;
					}
					$idjadwalsidang = $this->verzet->updateJadwalSidangPertama($dataSidang);
				}else{
					$idjadwalsidang = $this->verzet->addJadwalSidang($dataSidang);
					$dataPenetapan['sidang_id'] = $idjadwalsidang;
				}
			}

			$result = $this->verzet->updateDataPenetapanSidang($idperkara,$dataPenetapan);
			if($result){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Error, Data Tidak Dapat Disimpan'));
				return;
			}
			
		}
	}

	function validateDeleteSidang(){
		if(empty($_POST)){
			show_404();
		}
		
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$idsidang = ($this->encrypt->decode(base64_decode($this->input->post('enc_sidang'))));
		if(empty($idsidang) OR intval($idsidang)<1){
			echo json_encode(array('st'=>0,'msg'=>'Data Tidak Ditemukan.'));
			return;
		}

		$this->load->model('verzet/verzet_m','verzet');
		$delData = $this->verzet->deleteDataSidang($idperkara,$idsidang);
		if($delData){
			echo json_encode(array('st'=>1,'msg'=>'Data Penetapan Sidang Pertama '.$this->nativesession->getLangguage('verzet').' Berhasil DiHapus.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Penghapusan Data Penetapan Sidang Pertama '.$this->nativesession->getLangguage('verzet').' Gagal.'));
			return;
		}
	}

	function validateDeleteJurusita(){
		if(empty($_POST)){
			show_404();
		}
		
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->load->model('verzet/verzet_m','verzet');
		$delData = $this->verzet->deleteDataPenJurusita($idperkara);
		if($delData){
			echo json_encode(array('st'=>1,'msg'=>'Data Penetapan Jurusita '.$this->nativesession->getLangguage('verzet').' Berhasil DiHapus.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Penghapusan Data Penetapan Jurusita '.$this->nativesession->getLangguage('verzet').' Gagal.'));
			return;
		}
	}

	function validateDeletePanitera(){
		if(empty($_POST)){
			show_404();
		}
		
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->load->model('verzet/verzet_m','verzet');
		$delData = $this->verzet->deleteDataPenPanitera($idperkara);
		if($delData){
			echo json_encode(array('st'=>1,'msg'=>'Data Penetapan Panitera Pengganti '.$this->nativesession->getLangguage('verzet').' Berhasil DiHapus.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Penghapusan Data Penetapan Panitera Pengganti '.$this->nativesession->getLangguage('verzet').' Gagal.'));
			return;
		}
	}

	function validateDeleteHakim(){
		if(empty($_POST)){
			show_404();
		}
		
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->load->model('verzet/verzet_m','verzet');
		$delData = $this->verzet->deleteDataPenHakim($idperkara);
		if($delData){
			echo json_encode(array('st'=>1,'msg'=>'Data Penetapan Majelis Hakim '.$this->nativesession->getLangguage('verzet').' Berhasil DiHapus.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Penghapusan Data Penetapan Majelis Hakim '.$this->nativesession->getLangguage('verzet').' Gagal.'));
			return;
		}
	}

	function verzet_putusan(){
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['perkara_id'] = $this->encrypt->decode(base64_decode($data['enc']));
		if(empty($data['perkara_id']) OR intval($data['perkara_id'])<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '1060px';
		$this->ckeditor->config['height'] = '280px';

		$this->load->model('verzet/verzet_m');
		$row=$this->verzet_m->get_no_perkara($data['perkara_id']);
		$data['nomor_perkara']	= $row->nomor_perkara;
		$data['idalurperkara'] = $row->alur_perkara_id;

		if($data['idalurperkara']==9){
			$data['tahapan'] = 13;
			$data['tanggal_putusan']=$this->verzet_m->getTanggalDismissal($data['perkara_id']);
		}else{
			$data['tahapan'] = 16;
			$data['tanggal_putusan']=$row->tanggal_putusan;
		}
		$data['tanggal_pendaftaran_verzet']	= $row->tanggal_pendaftaran_verzet;
		$data['tanggal_surat']=$row->tanggal_surat;
		$data['putusan_verzet']=$row->putusan_verzet;
		$data['idputusan']=$row->status_putusan_verzet_id;
		$data['statusputusan'] = $this->verzet_m->get_status_putusan();
		$data['amar_putusan_verzet']=$row->amar_putusan_verzet;
		$data['amar_putusan_verzet_dok']=$row->amar_putusan_verzet_dok;
		$data['current_date'] = date('d/m/Y');
		$data['verstek'] = $row->putusan_verstek;
		$data['sumber_hukum_put'] = $row->sumber_hukum_id;
		$data['sumber_hukum'] = $this->verzet_m->getDataSumberHukum();
		$this->load->view('perkara_tab/verzet/form_verzet_putusan', $data);
	}

	function validateInputPutusanVerzet(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$idstatusputusan = ($this->encrypt->decode(base64_decode($this->input->post('status_putusan'))));
		if(empty($idstatusputusan) OR intval($idstatusputusan)<1){
			echo json_encode(array('st'=>0,'msg'=>'Error, Invalid Data Status Putusan Found'));
			return;
		}

		$this->form_validation->set_rules('tgl_putusan_verzet', 'Tanggal Putusan '.$this->nativesession->getLangguage('verzet'), 'trim|required|max_length[10]|xss_clean');		
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{

			$tglPutusanVerzet = $this->input->post('tgl_putusan_verzet', TRUE);
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tglPutusanVerzet = $this->tanggalhelper->convertToMysqlDate($tglPutusanVerzet);
			if($tglPutusanVerzet==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusanVerzet,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Putusan '.$this->nativesession->getLangguage('verzet').' Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tglPutusanVerzet);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Putusan Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglPutusan = $this->tanggalhelper->getTanggalPutusan($idperkara);
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusan,$tglPutusanVerzet);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Putusan '.$this->nativesession->getLangguage('verzet').' Tidak Boleh Kurang Dari Tanggal Putusan. '.$this->tanggalhelper->convertDayDate($tglPutusan)));
				return;
			}

			$this->load->model('verzet/verzet_m','verzet');
			$data = $this->verzet->get_no_perkara($idperkara);
			$tglPermohonan = $data->tanggal_pendaftaran_verzet;
			$selisih = $this->tanggalhelper->getSelisihHari($tglPermohonan,$tglPutusanVerzet);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Putusan '.$this->nativesession->getLangguage('verzet').' Tidak Boleh Kurang Dari Tanggal Permohonan Verzet'));
				return;
			}

			$tanggal = $data->tanggal_penetapan_sidang_verzet;
			$selisih = $this->tanggalhelper->getSelisihHari($tanggal,$tglPutusanVerzet);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Putusan '.$this->nativesession->getLangguage('verzet').' Tidak Boleh Kurang Dari Tanggal Penetapan Sidang Pertama Verzet'));
				return;
			}

			$tanggal = $data->penetapan_jurusita;
			$selisih = $this->tanggalhelper->getSelisihHari($tanggal,$tglPutusanVerzet);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Putusan '.$this->nativesession->getLangguage('verzet').' Tidak Boleh Kurang Dari Tanggal Penetapan Jurusita'));
				return;
			}

			$tanggal = $data->penetapan_panitera_pengganti;
			$selisih = $this->tanggalhelper->getSelisihHari($tanggal,$tglPutusanVerzet);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Putusan '.$this->nativesession->getLangguage('verzet').' Tidak Boleh Kurang Dari Tanggal Penetapan Panitera Pengganti Verzet'));
				return;
			}

			$tanggal = $data->penetapan_majelis_hakim;
			$selisih = $this->tanggalhelper->getSelisihHari($tanggal,$tglPutusanVerzet);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Putusan '.$this->nativesession->getLangguage('verzet').' Tidak Boleh Kurang Dari Tanggal Penetapan Majelis Hakim Verzet'));
				return;
			}					

			$statusputusantext = $this->verzet->getStatusPutusanNama($idstatusputusan);
			if(empty($statusputusantext)){
				echo json_encode(array('st'=>0,'msg'=>'Error, Invalid Data Status Putusan Found'));
				return;
			}

			$amar = trim($this->input->post('amar_putusan_verzet_text',TRUE));
			$amar = str_replace("&nbsp;", " ", $amar);
			
			if(strlen($amar)<50){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Amar Putusan Tidak Boleh kurang dari 50 Karakter'));
				return;
			}
			$dataPutusan = array(
				'putusan_verzet'=>$tglPutusanVerzet,
				'status_putusan_verzet_id'=>$idstatusputusan,
				'status_putusan_verzet_text'=>$statusputusantext,
				'amar_putusan_verzet'=>$amar,
				'diperbaharui_oleh'=>$this->session->userdata('username'),
				'diperbaharui_tanggal'=>date('Y-m-d H:i:s')					
			);
			if($this->session->userdata('jenis_pengadilan')==3 AND $idstatusputusan!=34){
				$dataPutusan['tanggal_bht'] = $tglPutusanVerzet;
			}else{
				$dataPutusan['tanggal_bht'] = NULL;
			}
			$statusPutusan = $this->input->post('status_putusan',TRUE);
			if($idstatusputusan!= 5 AND $idstatusputusan!=7){
				$sumberHukum = $this->input->post('sumber_hukum',TRUE);
				if(empty($sumberHukum) OR intval($sumberHukum)<1){
					if($sumberHukum==-1){
						echo json_encode(array('st'=>0,'msg'=>'Error <br> Sumber Hukum Wajib Dipilih.'));
						return;
					}
					echo json_encode(array('st'=>0,'msg'=>'Error <br> Sumber Hukum Tidak Valid.'));
					return;
				}
				$dataPutusan['sumber_hukum_id'] = $sumberHukum;
				
				if($this->session->userdata('jenis_pengadilan')==2){
					$verstek = $this->input->post('verstek',TRUE);
					if(empty($verstek) OR ($verstek!='Y' AND $verstek!='T')){
						echo json_encode(array('st'=>0,'msg'=>'Error <br> Status Verstek Tidak Valid.'));
						return;
					}
					$dataPutusan['putusan_verstek'] = $verstek;
				}else{
					$dataPutusan['putusan_verstek'] = 'T';
				}
				
			}
			
			$result = $this->verzet->updateDataPutusan($idperkara,$dataPutusan);
			if($result){
				echo json_encode(array('st'=>1,'msg'=>'Data Putusan Berhasil Disimpan '));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Error, Data Tidak Dapat Disimpan'));
				return;
			}
		}
	}

	function verzet_pemberitahuan(){
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['perkara_id'] = $this->encrypt->decode(base64_decode($data['enc']));
		if(empty($data['perkara_id']) OR intval($data['perkara_id'])<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->load->model('verzet/verzet_m');
		$row=$this->verzet_m->get_no_perkara($data['perkara_id']);
		$data['nomor_perkara']	= $row->nomor_perkara;
		$data['idalurperkara'] = $row->alur_perkara_id;

		if($data['idalurperkara']==9){
			$data['tahapan'] = 13;
			$data['tanggal_putusan']=$this->verzet_m->getTanggalDismissal($data['perkara_id']);
		}else{
			$data['tahapan'] = 16;
			$data['tanggal_putusan']=$row->tanggal_putusan;
		}

		$data['tanggal_pendaftaran_verzet']	= $row->tanggal_pendaftaran_verzet;
		$data['putusan_verzet']=$row->putusan_verzet;
		$data['pemberitahuan_putusan_verzet_pihak1']=$row->pemberitahuan_putusan_verzet_pihak1;
		$data['pemberitahuan_putusan_verzet_pihak2']=$row->pemberitahuan_putusan_verzet_pihak2;
		$data['current_date'] = date('d/m/Y');
		$this->load->view('perkara_tab/verzet/form_verzet_pemberitahuan', $data);
	}

	function validateInputPemberitahuanVerzet(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$dataPemberitahuan = array(
			'diperbaharui_oleh'=>$this->session->userdata('username'),
			'diperbaharui_tanggal'=>date('Y-m-d H:i:s')					
		);

		$curr_date = date('Y-m-d');
		$todayDate = date('d/m/Y');
		$this->load->model('verzet/verzet_m','verzet');
		$tglPutusan = $this->verzet->getTglPutusanVerzet($idperkara);
		if(empty($tglPutusan)){
			echo json_encode(array('st'=>0,'msg'=>'Data Putusan Masih Kosong'));
			return;
		}
		$tglpemberitahuanpihak1 = $this->input->post('tgl_pemberitahuan_pihak1', TRUE);
		$tglpemberitahuanpihak2 = $this->input->post('tgl_pemberitahuan_pihak2', TRUE);
	
		$tglPemberitahuanPihak1 = $this->input->post('tgl_pemberitahuan_pihak1', TRUE);
		if(!empty($tglPemberitahuanPihak1)){
			$tglPemberitahuanPihak1 = $this->tanggalhelper->convertToMysqlDate($tglPemberitahuanPihak1);
			if($tglPemberitahuanPihak1==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPemberitahuanPihak1,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan '.$this->nativesession->getLangguage('verzet').' Kepada Pemohon Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tglPemberitahuanPihak1);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pemberitahuan '.$this->nativesession->getLangguage('verzet').' Kepada Pemohon Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusan,$tglPemberitahuanPihak1);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan '.$this->nativesession->getLangguage('verzet').' Kepada Pemohon Tidak Boleh Kurang Dari Tanggal Putusan. '.$this->tanggalhelper->convertDayDate($tglPutusan)));
				return;
			}
			$dataPemberitahuan['pemberitahuan_putusan'] = $tglPemberitahuanPihak1;
			$dataPemberitahuan['pemberitahuan_putusan_verzet_pihak1'] = $tglPemberitahuanPihak1;
		}
		
		$tglPemberitahuanPihak2 = $this->input->post('tgl_pemberitahuan_pihak2', TRUE);
		if(!empty($tglPemberitahuanPihak2)){
			
			$tglPemberitahuanPihak2 = $this->tanggalhelper->convertToMysqlDate($tglPemberitahuanPihak2);
			if($tglPemberitahuanPihak2==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPemberitahuanPihak2,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan '.$this->nativesession->getLangguage('verzet').' Kepada Termohon Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tglPemberitahuanPihak2);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pemberitahuan '.$this->nativesession->getLangguage('verzet').' Kepada Termohon Dihari Libur, Sabtu dan Minggu.'));
				return;
			}
			
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusan,$tglPemberitahuanPihak2);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan '.$this->nativesession->getLangguage('verzet').' Kepada Termohon Tidak Boleh Kurang Dari Tanggal Putusan. '.$this->tanggalhelper->convertDayDate($tglPutusan)));
				return;
			}

			$dataPemberitahuan['pemberitahuan_putusan_verzet_pihak2'] = $tglPemberitahuanPihak2;
			
			if(empty($tglpemberitahuanpihak1)){
				$dataPemberitahuan['pemberitahuan_putusan'] = $tglPemberitahuanPihak2;
			}else{
				$dataPemberitahuan['pemberitahuan_putusan'] = $tglPemberitahuanPihak1;
			}
		}
		
		if(empty($tglpemberitahuanpihak1) AND empty($tglpemberitahuanpihak2)){
			echo json_encode(array('st'=>0,'msg'=>'Mohon Mengisikan Data Tanggal Pemberitahuan'));
			return;
		}

		$result = $this->verzet->updateDataPemberitahuan($idperkara,$dataPemberitahuan);
		if($result){
			echo json_encode(array('st'=>1,'msg'=>'Data Pemberitahuan Berhasil Disimpan'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error, Data Tidak Dapat Disimpan'));
			return;
		}
	}

	function validateDeletePemberitahuan(){
		if(empty($_POST)){
			show_404();
		}
		
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->load->model('verzet/verzet_m','verzet');
		$delData = $this->verzet->deleteDataPemberitahuan($idperkara);
		if($delData){
			echo json_encode(array('st'=>1,'msg'=>'Data Pemberitahuan Putusan '.$this->nativesession->getLangguage('verzet').' Berhasil DiHapus.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Penghapusan Data Pemberitahuan Putusan '.$this->nativesession->getLangguage('verzet').' Gagal.'));
			return;
		}
	}

	function validateDeletePutusan(){
		if(empty($_POST)){
			show_404();
		}
		
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->load->model('verzet/verzet_m','verzet');
		$delData = $this->verzet->deleteDataPutusan($idperkara);
		if($delData){
			echo json_encode(array('st'=>1,'msg'=>'Data Putusan '.$this->nativesession->getLangguage('verzet').' Berhasil DiHapus.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Penghapusan Data Putusan '.$this->nativesession->getLangguage('verzet').' Gagal.'));
			return;
		}
	}

	
	function verzet_minutasi(){
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['perkara_id'] = $this->encrypt->decode(base64_decode($data['enc']));
		if(empty($data['perkara_id']) OR intval($data['perkara_id'])<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->load->model('verzet/verzet_m');
		$row=$this->verzet_m->get_no_perkara($data['perkara_id']);
		$data['nomor_perkara']	= $row->nomor_perkara;
		$data['idalurperkara'] = $row->alur_perkara_id;

		if($data['idalurperkara']==9){
			$data['tahapan'] = 13;
			$data['tanggal_putusan']=$this->verzet_m->getTanggalDismissal($data['perkara_id']);
		}else{
			$data['tahapan'] = 16;
			$data['tanggal_putusan']=$row->tanggal_putusan;
		}
		$data['tanggal_pendaftaran_verzet']	= $row->tanggal_pendaftaran_verzet;
		$data['putusan_verzet']=$row->putusan_verzet;
		$data['pemberitahuan_putusan_verzet_pihak1']=$row->pemberitahuan_putusan_verzet_pihak1;
		$data['pemberitahuan_putusan_verzet_pihak2']=$row->pemberitahuan_putusan_verzet_pihak2;
		$data['tanggal_minutasi_verzet']=$row->tanggal_minutasi_verzet;
		$data['current_date'] = date('d/m/Y');
		$this->load->view('perkara_tab/verzet/form_verzet_minutasi', $data);
		
	}

	function validateInputTanggalMinutasiVerzet(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}		

		$curr_date = date('Y-m-d');
		$todayDate = date('d/m/Y');
		$this->load->model('verzet/verzet_m','verzet');
		$tglPemberitahuanPihak1 = $this->verzet->getTglPemberitahuanPihak1($idperkara);
		$tglPemberitahuanPihak2 = $this->verzet->getTglPemberitahuanPihak2($idperkara);
		if(empty($tglPemberitahuanPihak1) AND empty($tglPemberitahuanPihak2)){
			echo json_encode(array('st'=>0,'msg'=>'Data Pemberitahuan Kepada Para Pihak Masih Kosong'));
			return;
		}
		
		$tanggalminutasiverzet = $this->input->post('tanggal_minutasi', TRUE);		
		if(empty($tanggalminutasiverzet)){
			echo json_encode(array('st'=>0,'msg'=>'Mohon Mengisikan Data Tanggal Minutasi'));
			return;
		}
		
		if(!empty($tanggalminutasiverzet)){
			$tanggalminutasiverzet = $this->tanggalhelper->convertToMysqlDate($tanggalminutasiverzet);
			if($tanggalminutasiverzet==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tanggalminutasiverzet,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Minutasi '.$this->nativesession->getLangguage('verzet').' Kepada Pemohon Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tanggalminutasiverzet);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Minutasi '.$this->nativesession->getLangguage('verzet').' Kepada Pemohon Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPemberitahuanPihak1, $tanggalminutasiverzet);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Minutasi '.$this->nativesession->getLangguage('verzet').' Tidak Boleh Kurang Dari Tanggal Pemberitahuan Putusan. '.$this->tanggalhelper->convertDayDate($tglPemberitahuanPihak1)));
				return;	
			}
			
			$selisih = $this->tanggalhelper->getSelisihHari($tglPemberitahuanPihak2, $tanggalminutasiverzet);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Minutasi '.$this->nativesession->getLangguage('verzet').' Tidak Boleh Kurang Dari Tanggal Pemberitahuan Putusan. '.$this->tanggalhelper->convertDayDate($tglPemberitahuanPihak2)));
				return;	
			}
			
			$dataPemberi = array(
				'tanggal_minutasi_verzet' => $tanggalminutasiverzet,
				'diperbaharui_oleh'=>$this->session->userdata('username'),
				'diperbaharui_tanggal'=>date('Y-m-d H:i:s')					
			);	
		}
		
			

		$result = $this->verzet->updateDataMinutasi($idperkara,$dataPemberi);
		if($result){
			echo json_encode(array('st'=>1,'msg'=>'Data Minutasi Berhasil Disimpan'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error, Data Tidak Dapat Disimpan'));
			return;
		}
	}

	function validateDeleteMinutasi(){
		if(empty($_POST)){
			show_404();
		}
		
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->load->model('verzet/verzet_m','verzet');
		$delData = $this->verzet->deleteDataMinutasi($idperkara);
		if($delData){
			echo json_encode(array('st'=>1,'msg'=>'Data Tanggal Minutasi '.$this->nativesession->getLangguage('verzet').' Berhasil DiHapus.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Penghapusan Data Minutasi '.$this->nativesession->getLangguage('verzet').' Gagal.'));
			return;
		}
	}

	#mediasi verzet
	function mediasi_verzet(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		
		$segment = $this->uri->segment_array();
		$data['enc'] = $segment[2];
		$data['idperkara'] = $this->encrypt->decode(base64_decode($segment[2]));
		if(empty($data['idperkara']) OR intval($data['idperkara'])<1){
			show_404();
		}
		$this->load->model('verzet/verzet_m','verzet');
		$func = $segment[3];
		if($func!='tambah' AND $func!='edit'){
			show_404();
		}
		$data['enc_id'] = '';
		if($func=='edit'){
			$data['enc_id'] = $segment[4];
		}
		$data['enc_act'] 			= base64_encode($this->encrypt->encode($func));	
		$data['history'] 			= base_url(uri_string());
		$data['current_date'] 		= date('d/m/Y');
		$data['data_mediator'] 		= $this->verzet->get_mediator_edit($data['idperkara']);
		$data['infomediasi'] 		= $this->verzet->getDataMediasiVerzet($data['idperkara']);
		$data_dukung 				= $data['infomediasi']->result();
		$data['info_data_dukung'] 	= $this->verzet->data_dukung_mediasi($data_dukung[0]->mediasi_id);
		$dataverzet 				= $this->verzet->getDataVerzet($data['idperkara']);
		if($dataverzet!=''){
			if($dataverzet->num_rows>0){
				foreach ($dataverzet->result() as $row) {
					$data['idperkara'] 				= base64_encode($this->encrypt->encode($row->perkara_id));
					$data['noperkarapn'] 			= $row->nomor_perkara;
					$data['tglpermohonan'] 			= $this->tanggalhelper->convertDayDate($row->tanggal_pendaftaran_verzet);					
					$data['tgl_sidang_verzet'] 		= $row->tanggal_sidang_pertama_verzet;
				}
			}else{
				show_404();
			}
		}else{
			show_404();
		}
		$tmp = explode('/', $data['noperkarapn']);        
        $kode = '/Pdt.Plw/';
        $data['nomorperkaraverzet'] = $tmp[0].$kode.$tmp[2].'/'.$tmp[3];
		
		if($func=='edit'){
			if(($data['infomediasi'])!=''){
				if($data['infomediasi']->num_rows>0){
					foreach ($data['infomediasi']->result() as $row) {					
						$data['idperkara'] 				= base64_encode($this->encrypt->encode($row->perkara_id));
						$data['idmediasi'] 				= base64_encode($this->encrypt->encode($row->mediasi_id));
						$data['tanggal_penetapan'] 		= $this->tanggalhelper->convertToInputDate($row->penetapan_penunjukan_mediator);
						$data['tgl_mediasi'] 			= $row->penetapan_penunjukan_mediator;
						$data['idmediator'] 			= $row->mediator_id;
						$data['nomor_sk_penetapan'] 	= $row->nomor_sk_penetapan_mediator;
					}
				}else{
					show_404();
				}
			}else{
				show_404();
			}			 
		}
		$this->load->vars($data);
		$this->load->view('perkara_tab/verzet/edit_mediasi_verzet');
	}
	
	function save_mediasi_verzet(){
		if(empty($_POST)){
			show_404();
		}
		
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
			return;
		}
		
		$jenis_penetapan_mediator = $this->input->post('jenis_pilih_mediator',TRUE);
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		
		$act = $this->encrypt->decode(base64_decode($this->input->post('enc_act',TRUE)));	
		if($act !='tambah' AND $act !='edit'){
			echo json_encode(array('st'=>0,'msg'=>'Something Wrong With Your Data.'));
			return;
		}

		if($act=='edit'){
			$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
			if(!is_numeric($id) OR intval($id)<1){
				echo json_encode(array('st'=>0,'msg'=>'Something Wrong With Your Data.'));
				return;
			}
			$mediasi_id = $this->encrypt->decode(base64_decode($this->input->post('mediasi_id',TRUE)));
			if(!is_numeric($mediasi_id) OR intval($mediasi_id)<1){
				echo json_encode(array('st'=>0,'msg'=>'Something Wrong With Your Data.'));
				return;
			}
		}	
		
		$this->form_validation->set_rules('jenis_pilih_mediator','Jenis Pilih Mediator','trim|required|xss_clean');
		$this->form_validation->set_rules('tanggal_penetapan', 'Tanggal Penetapan Mediator', 'trim|required|xss_clean');
		$this->form_validation->set_rules('jenis_pilih_mediator', 'Jenis Pilih Mediator', 'trim|required|xss_clean');
		
		$jml_mediator = count($_POST["mediator"]);
		for($i=0; $i<$jml_mediator; $i++){
			$this->form_validation->set_rules('mediator['.$i.']', 'Nama Mediator11111', 'trim|required|xss_clean');
		}

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{			
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');
			$this->load->model('verzet/verzet_m','verzet');
			$tgl_sidang_verzet = $this->input->post('tgl_sidang_verzet',TRUE);
			$tanggalPenetapan = $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_penetapan',TRUE));
			if(!empty($tanggalPenetapan) AND $tanggalPenetapan==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Penetapan Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisihPermohonan = $this->tanggalhelper->getSelisihHari($tanggalPenetapan,$curr_date);
			if($selisihPermohonan<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Mediator Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}
			
			if(!empty($tanggalPenetapan) AND $tanggalPenetapan<$tgl_sidang_verzet){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Mediator Tidak Boleh Kurang dari Tanggal Sidang Pertama Verzet'));
				return;
			}
			
			$dayname = $this->tanggalhelper->getDayName($tanggalPenetapan);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$arr_mediator_id 	= array();
			foreach($this->input->post('mediatorid') as $val){
				$arr_mediator_id[] = $this->encrypt->decode(base64_decode($val,TRUE));
			}
			$arr 				= $this->input->post('mediator');
			$arr_status			= $this->input->post('status');
			$mediator_text		= implode("<br/>", $arr);
			$status 			= implode(",",$arr_status);
			$mediator_id 		= implode(',',$arr_mediator_id);
			$datamediasi = array(
				'mediator_id'					=> $mediator_id,
				'perkara_id' 					=> $idperkara,
				'tahapan_id' 					=> 16,
				'dimulai_mediasi' 				=> $tanggalPenetapan,
				'jenis_mediasi' 				=> 1,
				'is_mediasi' 					=> 1,
				'status_mediator'				=> $status,
				'mediator_text'					=> $mediator_text,
				'penetapan_penunjukan_mediator' => $tanggalPenetapan,
				'nomor_sk_penetapan_mediator'	=>$this->input->post('sk_penetapan_mediator')				
			);

			$jumlah	= substr_count($mediator_id ,",");
			for($i=0; $i<$jumlah; $i++){
				if(!is_numeric($arr_mediator_id[$i])){
					echo json_encode(array('st'=>0,'msg'=>'Nama Mediator Tidak Ditemukan'));
					return;
				}
			}
			
			$data_dukung_mediasi = array(
										'perkara_id'	=> $idperkara,
										'identifier'	=> '#pilih_mediator#',
										'kode_template'	=> 'I_03',
										'uraian'		=> $jenis_penetapan_mediator
			);
			
			if($act=='tambah'){
				$jml_perkara_mediator	= ($this->verzet->get_perkara_mediator());
				$id_perkara_mediator	= intval($jml_perkara_mediator+1);
				for($i=0; $i< $jml_mediator; $i++){
					$data_mediator = array(
										'id'					=> $id_perkara_mediator,
										'perkara_id' 			=> $idperkara,
										'tanggal_penetapan' 	=> $tanggalPenetapan,
										'nomor_sk_penetapan' 	=> $this->input->post('sk_penetapan_mediator',TRUE),						
										'mediator_id' 			=> $this->encrypt->decode(base64_decode($_POST["mediatorid"][$i],TRUE)),
										'status_mediator' 		=> $_POST["status"][$i],
										'nama_mediator' 		=> $_POST["mediator"][$i],
										'aktif' 				=> 'Y',
										'diinput_oleh' 			=> $this->session->userdata('username'),
										'diinput_tanggal' 		=> date("Y-m-d h:i:s",time())
					);
					$result = $this->verzet->add_perkara_mediator($data_mediator);
					$id_perkara_mediator++;
				}

				$maxid 						= $this->verzet->get_maxid_mediasi()->result();
				$maxid_mediasi 				= $maxid[0]->maxid;
				$id_mediasi_akhir 			= intval($maxid_mediasi)+1;
				$datamediasi['mediasi_id'] 	= $id_mediasi_akhir;	
				$urutanmax 					= $this->verzet->get_urutan_jadwal_mediasi_terakhir($id_mediasi_akhir);
				$urutanjadwal 				= $urutanmax->row()->urutan + 1;
				$idmax 						= $this->verzet->get_id_jadwal_mediasi_terakhir();
				$idjadwalberikutnya 		= $idmax->row()->id + 1;
				$jadwalmediasi= array(
									'id' 				=> $idjadwalberikutnya,
									'mediasi_id' 		=> $id_mediasi_akhir,
									'urutan' 			=> $urutanjadwal,
									'tanggal_mediasi' 	=> $tanggalPenetapan,
									'tempat' 			=> 'Ditentukan Kemudian'
				);				
			}
			
			$diperbaharui_tanggal = $this->verzet->get_date_tanggal($idperkara);
			if($act=='edit'){
				$result 				= $this->verzet->delete_update($idperkara);
				$jml_perkara_mediator	= $this->verzet->get_perkara_mediator();
				$id_perkara_mediator	= intval($jml_perkara_mediator+1);
				for($i=0; $i< $jml_mediator; $i++){
					$edit_mediator = array(
										'id'					=> $id_perkara_mediator,
										'perkara_id' 			=> $idperkara,
										'tanggal_penetapan' 	=> $tanggalPenetapan,
										'nomor_sk_penetapan' 	=> $this->input->post('sk_penetapan_mediator',TRUE),						
										'mediator_id' 			=> $this->encrypt->decode(base64_decode($_POST["mediatorid"][$i],TRUE)),
										'status_mediator' 		=> $_POST["status"][$i],
										'nama_mediator' 		=> $_POST["mediator"][$i],
										'aktif' 				=> 'Y',							
										'diinput_oleh' 			=> $this->session->userdata('username'),
										'diinput_tanggal' 		=> $diperbaharui_tanggal[0]->diinput_tanggal,
										'diperbaharui_oleh'		=> $this->session->userdata('username'),
										'diperbaharui_tanggal' 	=> date("Y-m-d h:i:s",time())
					);
					$result = $this->verzet->add_perkara_mediator($edit_mediator);
					$id_perkara_mediator++;
				}
				$cek=NULL;
				$cek_data_dukung_mediasi=$this->verzet->cek_data_dukung_mediasi($idperkara,$mediasi_id);
				if($cek_data_dukung_mediasi->num_rows>0){
					$cek=1;
				}else{
					$cek=0;
				}
				
				$datamediasi['diperbaharui_tanggal']= $this->session->userdata('username');
				$datamediasi['diperbaharui_tanggal']= date("Y-m-d h:i:s",time());
				$result = $this->verzet->update_data_mediasi($datamediasi,$id);
				if($act=='edit'||$cek==0){
					$data_dukung_mediasi['mediasi_id']	= $id;
					$result = $this->verzet->add_data_dukung_mediasi($data_dukung_mediasi);
				}elseif($act=='edit'||$cek==1){
					$data_dukung_mediasi['mediasi_id'] 	= $id;
					$result = $this->verzet->update_data_dukung_mediasi($data_dukung_mediasi,$mediasi_id,$idperkara);
				}
				
			}else if($act=='tambah'){
				$datamediasi['diinput_oleh']=$this->session->userdata('username');
				$datamediasi['diinput_tanggal']= date("Y-m-d h:i:s",time());
				$jadwalmediasi['diinput_oleh']= $this->session->userdata('username');
				$jadwalmediasi['diinput_tanggal']= date("Y-m-d h:i:s",time());
				$result = $this->verzet->add_data_mediasi($datamediasi);
				$result = $this->verzet->add_data_jadwal_mediasi($jadwalmediasi);
				if($cek==0){
					$data_dukung_mediasi['mediasi_id']=$id_mediasi_akhir;
					$result = $this->verzet->add_data_dukung_mediasi($data_dukung_mediasi);
				}
			}

			if($result==TRUE){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Gagal Melakukan Penyimpanan.'));
				return;
			}
		}
	}

	function editjadwalmediasi(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$data['curr_date'] = date('d/m/Y');

		$data['enc']=$this->nativesession->get_flash_session('enc');
		$data['encmediasi']=$this->nativesession->get_flash_session('encmediasi');
		$data['encjadwalmediasi']=$this->nativesession->get_flash_session('encjadwalmediasi');

		$idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }

		$idmediasi=$this->encrypt->decode(base64_decode($data['encmediasi']));
        if(!is_numeric($idmediasi) OR !intval($idmediasi)>0){
            show_404();
            exit();
        }

		$idjadwalmediasi=$this->encrypt->decode(base64_decode($data['encjadwalmediasi']));
        if(!is_numeric($idjadwalmediasi) OR !intval($idjadwalmediasi)>0){
            show_404();
            exit();
        }

		$this->load->model('verzet/verzet_m','verzet');		
		if ($query=$this->verzet->get_detil_jadwal_mediasi($idjadwalmediasi)){
			$data['detjmediasi']=$query;
		}		
		$this->load->view('perkara_tab/verzet/jadwal_mediasi_verzet',$data);
	}
	function validateEdit(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc')));
		$idmediasi = $this->encrypt->decode(base64_decode($this->input->post('encmediasi')));
		$idjadwalmediasi = $this->encrypt->decode(base64_decode($this->input->post('encjadwalmediasi')));

		if(!is_numeric($idperkara) OR !intval($idperkara)>0){
			echo json_encode(array('st'=>0,'msg'=>'Data Perkara Tidak Ditemukan.'));
			return;
		}
		if(!is_numeric($idmediasi) OR !intval($idmediasi)>0){
			echo json_encode(array('st'=>0,'msg'=>'Data Mediasi Tidak Ditemukan.'));
			return;
		}
		if(!is_numeric($idjadwalmediasi) OR !intval($idjadwalmediasi)>0){
			echo json_encode(array('st'=>0,'msg'=>'Data Jadwal Mediasi Tidak Ditemukan.'));
			return;
		}
		
		$this->form_validation->set_rules('tempat', 'Tempat Pelaksanaan Mediasi', 'required|trim|xss_clean|max_length[500]|min_length[1]');

		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{

			$tanggal_mediasi=$this->input->post('tgl_mediasi',TRUE); 
			$tanggal_mediasi=$this->tanggalhelper->convertToMysqlDate($tanggal_mediasi); 
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');			

			$selisih = $this->tanggalhelper->getSelisihHari($tanggal_mediasi,$curr_date);
			if($selisih<=0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Mediasi Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			if($tanggal_mediasi==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}
			
			$dayname = $this->tanggalhelper->getDayName($tanggal_mediasi);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Mediasi Pada Hari Libur, Sabtu dan Minggu.'));
				exit();
			}

			$dihadiri_oleh=$this->input->post('dihadiri_oleh',TRUE);
			$data_ruangan=$this->input->post('tempat',TRUE);

			$data=array(
				'tanggal_mediasi'=>$tanggal_mediasi,
				'jam_mediasi'=>$this->input->post('jammulai',TRUE),				
				'sampai_jam'=>$this->input->post('jamselesai',TRUE),
				'tempat'=>$data_ruangan,
				'dihadiri_oleh' => $dihadiri_oleh,
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
				);

			$this->load->model('verzet/verzet_m','verzet');
			$this->verzet->update_jadwal_mediasi($idjadwalmediasi,$data,$idmediasi);
			echo json_encode(array('st'=>1,'msg'=>'Perubahan Data Mediasi Berhasil'));
			return;
		}
	}

	function tundajadwalmediasi(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$data['curr_date'] = date('d/m/Y'); // ini didunakan untuk validasi tanggal

		$data['enc']=$this->nativesession->get_flash_session('enc');
		$data['encmediasi']=$this->nativesession->get_flash_session('encmediasi');
		$data['encjadwalmediasi']=$this->nativesession->get_flash_session('encjadwalmediasi');

		$idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }

		$idmediasi=$this->encrypt->decode(base64_decode($data['encmediasi']));
        if(!is_numeric($idmediasi) OR !intval($idmediasi)>0){
            show_404();
            exit();
        }

		$idjadwalmediasi=$this->encrypt->decode(base64_decode($data['encjadwalmediasi']));
        if(!is_numeric($idjadwalmediasi) OR !intval($idjadwalmediasi)>0){
            show_404();
            exit();
        }

		$this->load->model('verzet/verzet_m','verzet');        
		if ($query=$this->verzet->get_detil_jadwal_mediasi($idjadwalmediasi)){
			$data['detjmediasi']=$query;
		}		
		$this->load->view('perkara_tab/verzet/jadwal_mediasi_verzet_tunda',$data);
	}
	function validateTunda(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc')));
		$idmediasi = $this->encrypt->decode(base64_decode($this->input->post('encmediasi')));
		$idjadwalmediasi = $this->encrypt->decode(base64_decode($this->input->post('encjadwalmediasi')));

		if(!is_numeric($idperkara) OR !intval($idperkara)>0){
			echo json_encode(array('st'=>0,'msg'=>'Data Perkara Tidak Ditemukan.'));
			return;
		}
		if(!is_numeric($idmediasi) OR !intval($idmediasi)>0){
			echo json_encode(array('st'=>0,'msg'=>'Data Mediasi Tidak Ditemukan.'));
			return;
		}
		if(!is_numeric($idjadwalmediasi) OR !intval($idjadwalmediasi)>0){
			echo json_encode(array('st'=>0,'msg'=>'Data Jadwal Mediasi Tidak Ditemukan.'));
			return;
		}

		$this->form_validation->set_rules('tempatsblm', 'Tempat Pelaksanaan Mediasi Sebelumnya', 'required|trim|xss_clean|max_length[500]|min_length[1]');
		$this->form_validation->set_rules('tempat', 'Tempat Pelaksanaan Mediasi', 'required|trim|xss_clean|max_length[500]|min_length[1]');
		$this->form_validation->set_rules('tgl_mediasi', 'Tanggal Mediasi', 'required|trim|xss_clean|exact_length[10]');
		
		$tanggaldipilih=$this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_mediasi',TRUE));
		if($tanggaldipilih==false){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Sidang Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
			return;
		}

		$tanggalsebelum=$this->input->post('tglmediasisblm',TRUE);		
		if($tanggalsebelum==false){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
			return;
		}

		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$selisih = $this->tanggalhelper->getSelisihHari($tanggalsebelum,$tanggaldipilih);
			if($selisih<=0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Sebelum Atau Tepat Pada Tanggal Sidang Sebelumnya.'));
				return;
			}								
		
			$dayname = $this->tanggalhelper->getDayName($tanggaldipilih);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Sidang Pada Hari Libur, Sabtu dan Minggu.'));
				return;
			}

			$this->load->model('verzet/verzet_m','verzet');

			$urutanmaxid=$this->verzet->get_urutan_jadwal_mediasi_terakhir($idmediasi);
			$urutanBaru =  $urutanmaxid->row()->urutan + 1;
			$idmax = $this->verzet->get_id_jadwal_mediasi_terakhir();
			$idjadwalberikutnya=$idmax->row()->id + 1;
			
			$data_ruangan_sebelumnya=$this->input->post('tempatsblm',TRUE);
			$data_ruangan=$this->input->post('tempat',TRUE);

			$data_update = array(
				'tempat'=>$data_ruangan_sebelumnya,
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			);

			$data_insert = array(
				'id'=>$idjadwalberikutnya,
				'mediasi_id'=>$idmediasi,
				'urutan'=>$urutanBaru,
				'tanggal_mediasi'=>$tanggaldipilih,
				'tempat'=>$data_ruangan,
				'diinput_oleh' => $this->session->userdata('username'),
				'diinput_tanggal' => date("Y-m-d h:i:s",time())
			);

			$data_update_tgl_kesepakatan = array(
				'keputusan_mediasi'=>$tanggaldipilih,
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			);

			$this->verzet->tunda_mediasi($data_insert,$data_update,$data_update_tgl_kesepakatan,$idmediasi);						

			echo json_encode(array('st'=>1,'msg'=>'Pengisian Data Tundaan Mediasi Berhasil'));
			return;
		}
	}

	function hapus_jadwal_mediasi(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc')));
		if(!is_numeric($idperkara) OR !intval($idperkara)>0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$idjadwalmediasi = $this->encrypt->decode(base64_decode($this->input->post('encjadwalmediasi')));
		if(!is_numeric($idjadwalmediasi) OR !intval($idjadwalmediasi)>0){
			echo json_encode(array('st'=>0,'msg'=>'Jadwal Mediasi Tidak Ditemukan.'));
			return;
		}
		
		$this->load->model('verzet/verzet_m','verzet');
		if($this->verzet->hapus_jadwal_mediasi($idjadwalmediasi)){			
			echo json_encode(array('st'=>1,'msg'=>'Penghapusan Data Jadwal Mediasi Berhasil'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'));
			return;
		}
	}

	function hasilmediasi(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();						
		$data['enc'] = $segment[2];
		$data['idperkara'] = $this->encrypt->decode(base64_decode($segment[2]));						
		if(empty($data['idperkara']) OR intval($data['idperkara'])<1){
			show_404();
		}
		$func = $segment[3];		
		if($func!='tambah' AND $func!='edit'){
			show_404();
		}
		$data['enc_id'] = '';
		if($func=='edit'){
			$data['enc_id'] = $segment[4];
		}		
		$data['enc_act'] = base64_encode($this->encrypt->encode($func));		
		$data['history'] = base_url(uri_string());
		$data['current_date'] =date('d/m/Y');
		$this->load->model('verzet/verzet_m','verzet');
		$data['infomediasi'] = $this->verzet->getDataMediasiVerzet($data['idperkara']);			
		$data['listmediator'] = $this->verzet->getDataMediator();		
		if(!empty($data['infomediasi'])){
			foreach ($data['infomediasi']->result() as $row) {
				$data['keterangan'] = $row->catatan_mediasi;
			}
		}

		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = 'aut0';
		$this->ckeditor->config['height'] = '150px';
		
		if($func=='edit'){
			if(($data['infomediasi'])!=''){
				if($data['infomediasi']->num_rows>0){
					foreach ($data['infomediasi']->result() as $row) {					
						$data['idperkara'] = base64_encode($this->encrypt->encode($row->perkara_id));
						$data['idmediasi'] = base64_encode($this->encrypt->encode($row->mediasi_id));
						$data['tgl_kesepakatan_perdamaian'] = $row->tgl_kesepakatan_perdamaian;
						$data['isi_kesepakatan_perdamaian'] = $row->isi_kesepakatan_perdamaian;						
						$data['tgl_lapor'] = $this->tanggalhelper->convertToInputDate($row->tgl_laporan_mediator);						
						$data['tgl_perdamaian_cabut'] = $this->tanggalhelper->convertToInputDate($row->akta_perdamaian);
						$data['nama_mediator'] = $row->mediator_text;
						$data['hasilmediasi'] = $row->hasil_mediasi;
						$data['isi_akta_perdamaian'] = $row->isi_akta_perdamaian;
						$mediasi_id = $row->mediasi_id;						
					}
					$data['keputusan_mediasi']=$this->verzet->get_jadwal_mediasi_terakhir($mediasi_id);
				}else{
					show_404();
				}
			}else{
				show_404();
			}			 
		}
		$this->load->vars($data);
		$this->load->view('perkara_tab/verzet/edit_hasil_mediasi_verzet');
	}
	function savehasilmediasi(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$act = $this->encrypt->decode(base64_decode($this->input->post('enc_act',TRUE)));		
		if($act !='tambah' AND $act !='edit'){
			echo json_encode(array('st'=>0,'msg'=>'Something Wrong With Your enc_act.'));
			return;
		}

		if($act=='edit'){
			$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
			if(!is_numeric($id) OR intval($id)<1){
				echo json_encode(array('st'=>0,'msg'=>'Something Wrong With Your Data enc_id.'));
				return;
			}
			$mediasi_id = $this->encrypt->decode(base64_decode($this->input->post('mediasi_id',TRUE)));
			if(!is_numeric($mediasi_id) OR intval($mediasi_id)<1){
				echo json_encode(array('st'=>0,'msg'=>'Something Wrong With Your Data mediasi_id.'));
				return;
			}
		}	
		
		$this->form_validation->set_rules('tgl_lapor', 'Tanggal Laporan Mediator', 'trim|xss_clean|exact_length[10]');		
		$this->form_validation->set_rules('st_hasil', 'Hasil Mediasi', 'trim|required|xss_clean');

		$st_hasil = trim($this->input->post('st_hasil',TRUE));
		if($st_hasil==='Y1'||$st_hasil==='Y2'||$st_hasil==='S'){
			$this->form_validation->set_rules('tgl_kesepakatan', 'Tanggal Kesepakatan Perdamaian', 'trim|xss_clean|required|exact_length[10]');		
			$this->form_validation->set_rules('isi_kesepakatan_text', 'Isi Kesepakatan Perdamaian', 'trim|xss_clean|required|min_length[50]');
		}				
				
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');						
			$tanggalLaporan = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_lapor',TRUE));			
			$tgl_kesepakatan = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_kesepakatan',TRUE));
			$tanggalPerdamaian = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_perdamaian_cabut',TRUE));

			if(!empty($tanggalLaporan) AND $tanggalLaporan==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Laporan Mediator Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}						
			if(!empty($tgl_kesepakatan) AND $tgl_kesepakatan==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Kesepakatan Perdamaian Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}
			if(!empty($tanggalPerdamaian) AND $tanggalPerdamaian==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Akta Perdamaian Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$this->load->model('verzet/verzet_m','verzet');			
			$infotglputusmediasi=$this->verzet->getDataMediasiVerzet($idperkara);
			if($infotglputusmediasi!=''){
				if($infotglputusmediasi->num_rows>0){
					foreach ($infotglputusmediasi->result() as $row) {						
						$tglputusmediasi = $row->keputusan_mediasi;												
					}
				}
			}			
			
			$selisihLaporan = $this->tanggalhelper->getSelisihHari($tanggalLaporan,$curr_date);
			if($selisihLaporan<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Laporan oleh Mediator Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}
			if(!empty($tanggalLaporan) AND $tanggalLaporan<$tglputusmediasi){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Laporan oleh Mediator Tidak Boleh Kurang dari Tanggal Hasil Mediasi'));
				return;
			}
			$selisihKesepakatan = $this->tanggalhelper->getSelisihHari($tgl_kesepakatan,$curr_date);
			if($selisihKesepakatan<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Kesepakatan Perdamaian Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}
			if(!empty($tgl_kesepakatan) AND $tgl_kesepakatan<$tglputusmediasi){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Kesepakatan Perdamaian Tidak Boleh Kurang dari Tanggal Hasil Mediasi'));
				return;
			}															
			$selisihPerdamaian = $this->tanggalhelper->getSelisihHari($tanggalPerdamaian,$curr_date);
			if($selisihPerdamaian<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Perdamaian Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}
			if(!empty($tanggalPerdamaian) AND $tanggalPerdamaian<$tglputusmediasi){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Akta Perdamaian Tidak Boleh Kurang dari Tanggal Hasil Mediasi'));
				return;
			}					

			if(!empty($tanggalLaporan)){
				$datamediasi = array();								
				$datamediasi['tgl_laporan_mediator'] = $tanggalLaporan;
				
				if($st_hasil!='Y1' AND $st_hasil!='Y2' AND $st_hasil!='T' AND $st_hasil!='S' AND $st_hasil!='D'){
					echo json_encode(array('st'=>0,'msg'=>'Hasil Mediasi Tidak Ditemukan.'));
					return;
				}
				$datamediasi['hasil_mediasi'] = $st_hasil;
				if($st_hasil=='Y1' ||$st_hasil=='Y2'||$st_hasil=='S' ){
					$sepakat = trim($this->input->post('isi_kesepakatan_text',TRUE));
					$sepakat = strip_tags($sepakat);
					$sepakat = htmlentities($sepakat, null, 'utf-8');
					$sepakat = str_replace("&nbsp;", " ", $sepakat);
					if(!empty($sepakat)){
						if(strlen($sepakat)<50){
							echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Isi Kesepakatan Tidak Boleh kurang dari 50 Karakter'));
							return;
						}
					}
					$datamediasi['isi_kesepakatan_perdamaian'] 	= $sepakat;					
					$datamediasi['tgl_kesepakatan_perdamaian'] 	= $tgl_kesepakatan;
				}else{
					$datamediasi['isi_kesepakatan_perdamaian'] 	= NULL;					
					$datamediasi['tgl_kesepakatan_perdamaian'] 	= NULL;
				}
				if($st_hasil=='Y1' || $st_hasil=='S'){					
					$amar = trim($this->input->post('isi_akta_perdamaian_text',TRUE));
					$amar = strip_tags($amar);
					$amar = htmlentities($amar, null, 'utf-8');
					$amar = str_replace("&nbsp;", " ", $amar);
					if(!empty($amar)){
						if(strlen($amar)<50){
							echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Isi Akta Perdamaian Tidak Boleh kurang dari 50 Karakter'));
							return;
						}
					}
					$datamediasi['isi_akta_perdamaian'] = $amar;					
					$datamediasi['akta_perdamaian'] = $tanggalPerdamaian;
					$datamediasi['catatan_mediasi'] = $keterangan;
				}else if($st_hasil=='Y2' || $st_hasil=='T' || $st_hasil=='D'){
					$keterangan = trim($this->input->post('keterangan',TRUE));
					$datamediasi['isi_akta_perdamaian'] = '';					
					$datamediasi['akta_perdamaian'] = NULL;
					$datamediasi['catatan_mediasi'] = $keterangan;
				}				
			}
			
			if($act=='edit'){
				$datamediasi['diperbaharui_tanggal'] = $this->session->userdata('username');
				$datamediasi['diperbaharui_tanggal'] = date("Y-m-d h:i:s",time());
				$result = $this->verzet->update_data_mediasi($datamediasi,$id);				
			}else if($act=='tambah'){
				$datamediasi['diinput_oleh'] = $this->session->userdata('username');
				$datamediasi['diinput_tanggal'] = date("Y-m-d h:i:s",time());
				$result = $this->verzet->add_data_mediasi($datamediasi);								
			}
			
			if($result==TRUE){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Gagal Melakukan Penyimpanan.'));
				return;
			}
		}
	}
	function hapus_mediasi_verzet(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR !intval($idperkara)>0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$idmediasi = $this->encrypt->decode(base64_decode($this->input->post('mediasi_id',TRUE)));
		if(!is_numeric($idmediasi) OR !intval($idmediasi)>0){
			echo json_encode(array('st'=>0,'msg'=>'Mediasi Tidak Ditemukan.'));
			return;
		}
		
		$this->load->model('verzet/verzet_m','verzet');
		if($this->verzet->hapus_penetapan_mediasi_verzet($idperkara,$idmediasi)){			
			echo json_encode(array('st'=>1,'msg'=>'Penghapusan Data Mediasi Berhasil'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'));
			return;
		}
	}
}












