<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Manage_delegasi_perkara extends CI_Controller {
	
	public function __construct(){
		parent::__construct();
		$this->load->model('perkara/delegasi','delegasi');
	}    
	function auto_complete($keyword){
		$data = $this->db->query('select perkara_id,nomor_perkara from perkara where alur_perkara_id not in (113,114) AND nomor_perkara like \''.$keyword.'/%\' limit 100');
		foreach($data->result() as $row)
		{
			$arr['query'] = $keyword;
			$arr['suggestions'][] = array(
				'value'	=>$row->nomor_perkara
			);
		}
		// minimal PHP 5.2
		echo json_encode($arr);
	}
	function tambah_delegasi_keluar(){
		$history = $this->nativesession->get_flash_session('url_requested');
		$data['jenis_pengadilan'] = $this->session->userdata('jenis_pengadilan');
		$idpnasal=$this->encrypt->decode(base64_decode($this->nativesession->get_flash_session('idpnasal'),TRUE));
		$idpntujuan=$this->encrypt->decode(base64_decode($this->nativesession->get_flash_session('idpntujuan'),TRUE));
		
		$data['list_pt'] = $this->delegasi->get_list_pt(0,$data['jenis_pengadilan']);
		$data['list_pn'] = $this->delegasi->get_list_pn();
		$data['jenis_delegasi'] = $this->delegasi->getJenisDelegasi();
		$data['data_pn_asal']=$this->delegasi->identitasPN();
		
		$data['idpt']='';
		$data['enc_delegasi']='';
		$data['alur_perkara_id']='';
		$data['perkara_id']='';
		$data['id_jenis_delegasi']='';
		$data['id_pn_asal']='';
		$data['idpn']='';
		$data['pn_asal_text']='';
		$data['pn_tujuan_text']='';
		$data['kode_satker_asal']='';
		$data['id_pn_tujuan']='';
		$data['tgl_surat']='';
		$data['tgl_delegasi']='';
		$data['nomor_surat']='';
		$data['tgl_sidang']='';
		$data['tgl_resi']='';
		$data['nomor_resi']='';
		$data['biaya']=0;
		$data['tgl_pengiriman']='';
		$data['para_pihak']='';
		$data['nomor_perkara']='';
		$data['catatan']='';
		$data['jenis_perkara']='';
		$data['tanggal_pendaftaran_perkara']='';
		$data['previous']=$this->nativesession->get_flash_session('previous');

		$data['dashboard']="";
		$data['judul'] = 'TAMBAH PERMOHONAN BANTUAN DELEGASI KELUAR';
		$data['edit']='';
		$data['idalur']=base64_encode($this->encrypt->encode('2'));
		$data['current_date'] = date('d/m/Y');
		$this->load->view('delegasi/add_delegasi',$data);

	}

	function detil_delegasi(){

		$segment = $this->uri->segment_array();
		$idalur=$this->encrypt->decode(base64_decode($this->uri->segment(3)));
		$iddelegasi=$this->encrypt->decode(base64_decode($this->uri->segment(4)));
		$idpnasal=$this->encrypt->decode(base64_decode($this->uri->segment(5)));
		$idpntujuan=$this->encrypt->decode(base64_decode($this->uri->segment(6)));
		$data['enc_alur']=$this->uri->segment(3);
		$jenis_pengadilan = $this->session->userdata('jenis_pengadilan');

		$data['delegasi_detil'] = $this->delegasi->get_detil_delegasi($idalur,$iddelegasi,$idpnasal,$idpntujuan);		
		$data['delegasi_proses'] = $this->delegasi->get_detil_proses($idalur,$iddelegasi,$idpnasal,$idpntujuan);
		$data['delegasi_file'] = $this->delegasi->get_file_delegasi($idalur,$iddelegasi);
		$data['delegasi_lampiran'] = $this->delegasi->get_file_lampiran($idalur,$iddelegasi);
		$data['delegasi_file_keluar'] = $this->delegasi->get_file_keluar($idalur,$iddelegasi);
		
		if ($data['delegasi_detil']->num_rows>=1) {
				foreach ($data['delegasi_detil']->result() as $row) {
						$data['enc_delegasi']=base64_encode($this->encrypt->encode($row->id));	
						$data['enc_perkara']=base64_encode($this->encrypt->encode($row->perkara_id));
						$data['nomor_perkara']=$row->nomor_perkara;
						$data['enc_pn_asal']=base64_encode($this->encrypt->encode($row->id_pn_asal));
						$data['kode_satker_asal']=$row->kode_satker_asal;
						$data['pn_asal_text']=$row->pn_asal_text;
						$data['enc_pn_tujuan']=base64_encode($this->encrypt->encode($row->id_pn_tujuan));
						$data['kode_satker_tujuan']=$row->kode_satker_tujuan;
						$data['pn_tujuan_text']=$row->pn_tujuan_text;
						$data['tgl_delegasi']=$this->tanggalhelper->convertDayDate($row->tgl_delegasi);
						$data['id_jenis_delegasi']=$row->id_jenis_delegasi;
						$data['tgl_sidang']=$this->tanggalhelper->convertDayDate($row->tgl_sidang);
						$data['jenis_delegasi_text']=$row->jenis_delegasi_text;
						$data['tgl_surat']=$this->tanggalhelper->convertDayDate($row->tgl_surat);
						$data['tgl_pengiriman']=$this->tanggalhelper->convertDayDate($row->tgl_pengiriman);
						$data['nomor_surat']=$row->nomor_surat;
						// $data['document_size']=$row->document_size;
						// $data['document_mime']=$row->document_mime;
						$data['tgl_resi']=$this->tanggalhelper->convertDayDate($row->tgl_resi);
						$data['nomor_resi']=$row->nomor_resi;
						$data['biaya']=$row->biaya;
						$data['para_pihak']=$row->pihak;
						$data['catatan']=$row->catatan;
						$data['status_kirim']=$row->status_kirim;
						// $data['keterangan_status_kirim']=$row->keterangan_status_kirim;
				}
			}else{
						$data['enc_delegasi']='';
						$data['enc_perkara']='';
						$data['nomor_perkara']='';
						$data['enc_pn_asal']='';
						$data['kode_satker_asal']='';
						$data['pn_asal_text']='';
						$data['enc_pn_tujuan']='';
						$data['kode_satker_tujuan']='';
						$data['pn_tujuan_text']='';
						$data['tgl_delegasi']='';
						$data['id_jenis_delegasi']='';
						$data['tgl_sidang']='';
						$data['jenis_delegasi_text']='';
						$data['tgl_surat']='';
						$data['tgl_pengiriman']='';
						$data['nomor_surat']='';
						// $data['document_size']='';
						// $data['document_mime']='';
						$data['tgl_resi']='';
						$data['nomor_resi']='';
						$data['biaya']='';
						$data['para_pihak']='';
						$data['catatan']='';
						$data['status_kirim']=0;
						// $data['keterangan_status_kirim']="";
		}

		if ($data['delegasi_proses']->num_rows>=1) {
				foreach ($data['delegasi_proses']->result() as $row) {
						$data['p_enc_delegasi']=base64_encode($this->encrypt->encode($row->delegasi_id));
						$data['p_tgl_surat_diterima']=$this->tanggalhelper->convertDayDate($row->tgl_surat_diterima);
						$data['p_enc_perkara']=base64_encode($this->encrypt->encode($row->perkara_id));
						$data['p_enc_jurusita']=base64_encode($this->encrypt->encode($row->jurusita_id));
						$data['p_tgl_penunjukan_jurusita']=$this->tanggalhelper->convertDayDate($row->tgl_penunjukan_jurusita);
						$data['p_jurusita_nama']=$row->jurusita_nama;
						$data['p_enc_pn_asal']=base64_encode($this->encrypt->encode($row->id_pn_asal));
						$data['p_pn_asal_text']=$row->pn_asal_text;
						$data['p_kode_satker_asal']=$row->kode_satker_asal;
						$data['p_enc_pn_tujuan']=base64_encode($this->encrypt->encode($row->id_pn_tujuan));
						$data['p_pn_tujuan_text']=$row->pn_tujuan_text;
						$data['p_kode_satker_tujuan']=$row->kode_satker_tujuan;
						$data['p_tgl_relaas']=$this->tanggalhelper->convertDayDate($row->tgl_relaas);
						$data['p_nomor_relaas']=$row->nomor_relaas;
						$data['p_tgl_pengiriman_relaas']=$this->tanggalhelper->convertDayDate($row->tgl_pengiriman_relaas);
						$data['p_nomor_surat_pengantar_relaas']=$row->nomor_surat_pengantar_relaas;
						$data['p_id_status_delegasi']=$row->id_status_delegasi;
						$data['p_status_delegasi']=$row->status_delegasi;
						// $data['p_document']=$row->document;
						// $data['p_document_size']=$row->document_size;
						// $data['p_document_mime']=$row->document_mime;
						$data['p_tgl_resi']=$this->tanggalhelper->convertDayDate($row->tgl_resi);
						$data['p_nomor_resi']=$row->nomor_resi;
						$data['p_biaya']=$row->biaya;
						$data['p_catatan']=$row->catatan;
					}
			}else{
						$data['p_enc_delegasi']='';
						$data['p_tgl_surat_diterima']='';
						$data['p_enc_perkara']='';
						$data['p_enc_jurusita']='';
						$data['p_tgl_penunjukan_jurusita']='';
						$data['p_jurusita_nama']='';
						$data['p_enc_pn_asal']='';
						$data['p_pn_asal_text']='';
						$data['p_kode_satker_asal']='';
						$data['p_enc_pn_tujuan']='';
						$data['p_pn_tujuan_text']='';
						$data['p_kode_satker_tujuan']='';
						$data['p_tgl_relaas']='';
						$data['p_nomor_relaas']='';
						$data['p_tgl_pengiriman_relaas']='';
						$data['p_nomor_surat_pengantar_relaas']='';
						$data['p_id_status_delegasi']='';
						if (empty($data['p_status_delegasi'])) {
							$data['p_status_delegasi']='Belum dilaksanakan';
						}
						// $data['p_document']='';
						// $data['p_document_size']='';
						// $data['p_document_mime']='';
						$data['p_tgl_resi']='';
						$data['p_nomor_resi']='';
						$data['p_biaya']='';
						$data['p_catatan']='';
			}

		if ($idalur==1) {
			$data['page_title'] = 'INFORMASI DETIL DELEGASI MASUK';
			$data['sumber']="Pengaju";
			$data['namaDelegasi']="MASUK";
			$data['namapn']=$data['pn_asal_text'];
			$data['idalur']=$idalur;
		}else{
			$data['page_title'] = 'INFORMASI DETIL DELEGASI KELUAR';
			$data['sumber']="Tujuan";
			$data['namaDelegasi']="KELUAR";
			$data['namapn']=$data['pn_tujuan_text'];
			$data['idalur']=$idalur;
		}

		foreach ($data['delegasi_detil']->result() as $key => $valdetil) {
			$$key=$valdetil;
		}

		$data['main_body'] = 'delegasi/detil_delegasi';
		$data['previous']=$this->nativesession->set_flash_session('previous',current_url());

		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}

	function downloadFile(){
			$segment = $this->uri->segment_array();
			$idalur=$this->encrypt->decode(base64_decode($segment[3]));
			$iddelegasi=$this->encrypt->decode(base64_decode($segment[4]));
			$idpnasal=$this->encrypt->decode(base64_decode($segment[5]));
			$idpntujuan=$this->encrypt->decode(base64_decode($segment[6]));

			$this->load->model('perkara/delegasi','delegasi');
			$datautama = $this->delegasi->get_detil_delegasi($idalur,$iddelegasi,$idpnasal,$idpntujuan);
			$datafile=$datautama->result();
				$data['filename']=$datafile[0]->namadokumen;
				$data['content']=$datafile[0]->document;
		       	$data['type']=$datafile[0]->document_mime;
		       	$data['size']=$datafile[0]->document_size;
	       	
	       	$this->output->set_header('Content-type: '.$data['type']);
			$this->output->set_output($data['content']);
	}

	function edit_data_umum(){
			$segment = $this->uri->segment_array();
			$idalur=$this->encrypt->decode(base64_decode($segment[3]));
			$iddelegasi=$this->encrypt->decode(base64_decode($segment[4]));
			$idpnasal=$this->encrypt->decode(base64_decode($segment[5]));
			$idpntujuan=$this->encrypt->decode(base64_decode($segment[6]));

			$this->load->model('perkara/delegasi','delegasi');
			$data['jenis_pengadilan'] = $this->session->userdata('jenis_pengadilan');
			$data['delegasi_detil'] = $this->delegasi->get_detil_delegasi($idalur,$iddelegasi,$idpnasal,$idpntujuan);
			$data['delegasi_proses'] = $this->delegasi->get_detil_proses($idalur,$iddelegasi,$idpnasal,$idpntujuan);
			$get_id_pt = $this->delegasi->get_id_pt($idpntujuan);
			if ($get_id_pt->num_rows > 0) {
				foreach ($get_id_pt->result() as $row) {
					$data['idpt']=$row->id;
				}
			}

			$data['list_pt'] = $this->delegasi->get_list_pt('',$data['jenis_pengadilan']);
			$data['list_pn'] = $this->delegasi->get_list_pn();
			$data['jenis_delegasi'] = $this->delegasi->getJenisDelegasi();
			$data['data_pn_asal']=$this->delegasi->identitasPN();
			
			$data['data_jurusita'] = $this->delegasi->getDataJurusita($idalur,$iddelegasi,$idpnasal,$idpntujuan);
			$data['data_pn_asal']=$this->delegasi->identitasPN();

							
			foreach ($data['delegasi_detil']->result() as $row) {
				$data['enc_delegasi']=base64_encode($this->encrypt->encode($row->id));	
				$data['enc_perkara']=base64_encode($this->encrypt->encode($row->perkara_id));
				$data['nomor_perkara']=$row->nomor_perkara;
				$data['enc_pn_asal']=base64_encode($this->encrypt->encode($row->id_pn_asal));
				$data['kode_satker_asal']=$row->kode_satker_asal;
				$data['pn_asal_text']=$row->pn_asal_text;
				$data['enc_pn_tujuan']=base64_encode($this->encrypt->encode($row->id_pn_tujuan));
				$data['kode_satker_tujuan']=$row->kode_satker_tujuan;
				$data['pn_tujuan_text']=$row->pn_tujuan_text;
				$data['tgl_delegasi']=$this->tanggalhelper->convertToInputDate($row->tgl_delegasi);
				$data['id_jenis_delegasi']=$row->id_jenis_delegasi;
				$data['jenis_delegasi_text']=$row->jenis_delegasi_text;
				$data['tgl_surat']=$this->tanggalhelper->convertToInputDate($row->tgl_surat);
				$data['tgl_pengiriman']=$this->tanggalhelper->convertToInputDate($row->tgl_pengiriman);
				$data['nomor_surat']=$row->nomor_surat;
				$data['namadokumen']=$row->namadokumen;
				$data['tgl_sidang']=$this->tanggalhelper->convertToInputDate($row->tgl_sidang);
				$data['document']=$row->document;
				$data['document_size']=$row->document_size;
				$data['document_mime']=$row->document_mime;
				$data['tgl_resi']=$this->tanggalhelper->convertToInputDate($row->tgl_resi);
				$data['nomor_resi']=$row->nomor_resi;
				$data['biaya']=$row->biaya;
				$data['para_pihak']=$row->pihak;
				$data['catatan']=$row->catatan;
			}

			$dataPerkara = $this->delegasi->fetchData($data['nomor_perkara'],'');
			if($dataPerkara->num_rows>0){
				foreach ($dataPerkara->result() as $row) {
					$data['enc_alur_perkara']=base64_encode($this->encrypt->encode($row->alur_perkara_id));
					$data['jenis_perkara']= $row->jenis_perkara_nama;
					$data['tanggal_pendaftaran_perkara']= $this->tanggalhelper->convertToInputDate($row->tanggal_pendaftaran);
				}
			}else{
						$data['enc_alur_perkara']='';
						$data['jenis_perkara']= "Jenis perkara tidak ditemukan";
						$data['tanggal_pendaftaran_perkara']= "tanggal pendaftaran tidak ditemukan";
			}


			if (empty($data['jenis_perkara'])){
				$data['jenis_perkara']='';
			}
			$data['previous']=$this->nativesession->get_flash_session('previous');
			$data['judul'] = 'EDIT PERMOHONAN BANTUAN DELEGASI KELUAR ';
			$data['edit']='edit';
			$data['enc_alur']=base64_encode($this->encrypt->encode('2'));
			$data['current_date'] = date('d/m/Y');
			$this->load->view('delegasi/add_delegasi',$data);
	}


	function simpan_data_umum(){
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$data['previous'] = $this->nativesession->get_flash_session('url_requested');
		$this->load->model('perkara/delegasi','delegasi');
		$this->form_validation->set_rules('nomor_perkara', 'Nomor Perkara', 'trim|required|xss_clean');
		$this->form_validation->set_rules('pn_tujuan_text', 'PN Tujuan', 'trim|required|xss_clean');
		$this->form_validation->set_rules('id_jenis_delegasi', 'Jenis Delegasi', 'trim|required|xss_clean');
		$this->form_validation->set_rules('para_pihak', 'Pihak / Para Pihak', 'trim|required|xss_clean');
		$this->form_validation->set_rules('kode_satker_asal','pada kode konfigurasi sistem belum di seting,','required|xss_clean');		
		$this->form_validation->set_rules('tgl_delegasi', 'Tanggal Permohonan Delegasi', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tgl_resi', 'Tanggal Resi Pengiriman', 'trim|xss_clean');
		$this->form_validation->set_rules('nomor_resi', 'Nomor Resi Pengiriman', 'trim|xss_clean');

		#313
		$id_jenis_delegasi=$this->input->post('id_jenis_delegasi',TRUE);
		if($id_jenis_delegasi==1){
			$this->form_validation->set_rules('tgl_sidang', 'Tanggal sidang', 'trim|required|xss_clean');
		}
		#end

		$edit=$this->input->post('is_edit',TRUE);
		if ($edit==''){
			$lastid = $this->delegasi->get_last_id();
			$id_pn_tujuan=$this->encrypt->decode(base64_decode($this->input->post('enc_pn_tujuan',TRUE)));
		}else{
			$this->form_validation->set_rules('enc_delegasi', 'Delegasi', 'trim|required|xss_clean');
			$lastid=$this->encrypt->decode(base64_decode($this->input->post('enc_delegasi',TRUE)));
			$id_pn_tujuan=$this->encrypt->decode(base64_decode($this->input->post('enc_pn_tujuan',TRUE)));
		}

		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tidak Berhasil'.validation_errors()));
			return;
		}
		$perkara_id=$this->encrypt->decode(base64_decode($this->input->post('enc_perkara',TRUE)));
		$id_pn_asal=$this->encrypt->decode(base64_decode($this->input->post('enc_pn_asal',TRUE)));
		$id_pn_tujuan_old=$this->encrypt->decode(base64_decode($this->input->post('enc_pn_tujuan',TRUE)));
		$kodeSatker= $this->delegasi->getKodeSatker($id_pn_tujuan);
		$jenisDelegasi= $this->delegasi->getJenisDelegasi($id_jenis_delegasi);

		foreach ($kodeSatker->result() as $row) {
			$kode_satker=$row->kode;
		}
		foreach ($jenisDelegasi->result() as $row) {
			$jenis_delegasi_text=$row->jenis_delegasi;
		}

		$pn_asal_text=$this->input->post('pn_asal_text',TRUE);
		$kode_satker_asal=$this->input->post('kode_satker_asal',TRUE);
		$pn_tujuan_text=$this->input->post('pn_tujuan_text',TRUE);
		$tgl_delegasi= $this->input->post('tgl_delegasi',TRUE);
		if ($tgl_delegasi=='') {
			$tgl_delegasi=NULL;
		}else{
			$tgl_delegasi= $this->tanggalhelper->convertToMysqlDate($tgl_delegasi);
		}
		$tgl_surat= $this->input->post('tgl_surat',TRUE);
		if ($tgl_surat=='') {
			$tgl_surat=NULL;
		}else{
			$tgl_surat= $this->tanggalhelper->convertToMysqlDate($tgl_surat);
		}
		$tgl_pengiriman= $this->input->post('tgl_pengiriman',TRUE);
		if ($tgl_pengiriman=='') {
			$tgl_pengiriman=NULL;
		}else{
			$tgl_pengiriman=$this->tanggalhelper->convertToMysqlDate($tgl_pengiriman);
		}
		$tgl_sidang= $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_sidang',TRUE));
		$nomor_surat = $this->input->post('nomor_surat',TRUE);
		$nomor_perkara = $this->input->post('nomor_perkara',TRUE);
		$catatan= $this->input->post('catatan',TRUE);
		$tmpbiaya=$this->input->post('biaya',TRUE);
		$tmpbiaya1=str_replace(',', '', $tmpbiaya);
		$biaya=intval(str_replace('.', '', $tmpbiaya1));
		$tgl_resi=$this->input->post('tgl_resi',TRUE);
		if ($tgl_resi=='') {
			$tgl_resi=NULL;
		}else{
			$tgl_resi=$this->tanggalhelper->convertToMysqlDate($tgl_resi);
		}
		$nomor_resi=$this->input->post('nomor_resi',TRUE);
		$para_pihak=$this->input->post('para_pihak',TRUE);

		$datainsert = array(
			'id'=>$lastid,
			'id_pn_asal'=>$id_pn_asal,
			'pn_asal_text'=>$this->session->userdata('namaPN'),
			'kode_satker_asal'=>$kode_satker_asal,
			'nomor_perkara'=>$nomor_perkara,
			'perkara_id'=>$perkara_id,
			'id_pn_tujuan' => $id_pn_tujuan,
			'kode_satker_tujuan'=>$kode_satker,
			'pn_tujuan_text' => $pn_tujuan_text,
			'tgl_delegasi' => $tgl_delegasi,
			'tgl_sidang' => $tgl_sidang,
			'id_jenis_delegasi' => $id_jenis_delegasi,
			'jenis_delegasi_text' => $jenis_delegasi_text,
			'tgl_surat'=>$tgl_surat,
			'tgl_pengiriman' => $tgl_pengiriman,
			'nomor_surat' => $nomor_surat,
			'catatan' => $catatan,
			'tgl_resi'=>$tgl_resi,
			'nomor_resi' => $nomor_resi,
			'nomor_surat' => $nomor_surat,
			'biaya' => intval($biaya),
			'pihak' => $para_pihak,
			'diinput_oleh' => $this->session->userdata('username'),
			'diinput_tanggal' => date("Y-m-d h:i:s",time()),
			'diperbaharui_oleh' => $this->session->userdata('username'),
			'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
		);
		if ($edit==''){
			if($this->delegasi->add_permohonan($datainsert)){
				if ($id_pn_asal==$id_pn_tujuan) {
					echo json_encode(array('st'=>0,'msg'=>'Pengadilan tujuan tidak boleh sama dengan pengadilan anda.'));
					return;
				}else{
				    $this->nativesession->set_flash_session('iddelegasi',$lastid);						
					echo json_encode(array('st'=>1,'msg'=>'Data berhasil disimpan, untuk mengirim ke Pengadilan tujuan klik tab E-Doc di detil delegasi.'));
					return;
				}
			}else{
					echo json_encode(array('st'=>0,'msg'=>'Database Error, Simpan Delegasi Tidak Berhasil'));
					return;
			}
		}else{
			$this->nativesession->set_flash_session('iddelegasi',$lastid);
			$edit_result=$this->delegasi->edit_permohonan($datainsert,$lastid,$id_pn_asal,$id_pn_tujuan_old);
			if ($edit_result==TRUE){
				if($id_pn_asal==$id_pn_tujuan) {
					echo json_encode(array('st'=>0,'msg'=>'Pengadilan tujuan tidak boleh sama dengan pengadilan anda.'));
					return;
				}else{
					echo json_encode(array('st'=>1,'msg'=>'Data berhasil disimpan, untuk mengirim ke Pengadilan tujuan klik tab E-Doc di detil delegasi.'));
					return;
				}
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Database Error, Edit Delegasi Tidak Berhasil'));
				return;
			}
		}	
	}


	function simpanDokumen($idalur,$enc_delegasi,$enc_perkara,$enc_pn_asal,$enc_pn_tujuan,$enc_nomor_perkara){
		$this->load->model('perkara/delegasi','delegasi');
		$delegasi_id=$this->encrypt->decode(base64_decode($enc_delegasi));
		$perkara_id=$this->encrypt->decode(base64_decode($enc_perkara));
		$id_pn_asal=$this->encrypt->decode(base64_decode($enc_pn_asal));
		$id_pn_tujuan=$this->encrypt->decode(base64_decode($enc_pn_tujuan));
		$nomor_perkara=$this->encrypt->decode(base64_decode($enc_nomor_perkara));


		if ($idalur=='1'){
			$folder="masuk";
			$status_file=2;
		}else{
			$folder="keluar";
			$status_file=1;
		}

		$tmpNomor=str_replace('/','_',$nomor_perkara);
		$tmpNomor1=str_replace('.','_',$tmpNomor);
		$nomor_perkara=str_replace(' ','',$tmpNomor1);

		$nama_file=$id_pn_asal.'_'.$id_pn_tujuan.'_'.$delegasi_id.'_'.$nomor_perkara.'_'.$this->acak_character(6);

		
		
		$config['allowed_types'] = 'gif|jpg|doc|docx|xls|xlsx|rtf|zip|rar|pdf';

		if (!empty($_FILES)) {
		    $tempFile = $_FILES['file']['tmp_name'];
		    $fileName = $_FILES['file']['name'];
		    $fileType = $_FILES['file']['type'];
		    $fileSize = $_FILES['file']['size'];
		    $targetPath = './resources/file/delegasi/'.$folder.'/';	    
		    $tmpExt = explode('.', $fileName);
			$ext = array_pop($tmpExt);
    		$newFileName = $nama_file.'.'.$ext;
		    $targetFile = $targetPath . $newFileName ;

		    $datainsert=array('delegasi_id'=>$delegasi_id,
							  'id_pn_asal'=>$id_pn_asal,
							  'id_pn_tujuan'=>$id_pn_tujuan,
							  'perkara_id'=>$perkara_id,
							  'file'=>$newFileName,
							  'status_file'=>$status_file,
							  'diinput_oleh' => $this->session->userdata('username'),
							  'diinput_tanggal' => date("Y-m-d h:i:s",time()),
							  'diperbaharui_oleh' => $this->session->userdata('username'),
							  'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
							  );

			if (move_uploaded_file($tempFile, $targetFile)){
					if ($this->db->insert('delegasi_file_'.$folder,$datainsert)){
				    	$this->session->set_userdata('tab_edoc',1);
				    	return array('st'=>1,'msg'=>'sukses');
				    }else{
				    	$this->session->set_userdata('tab_edoc',1);
				    	return array('s0'=>0,'msg'=>'gagal');
				    }
			}
		}

	}

	function hapus_file($enc_alur,$enc_id,$enc_file){
		$this->session->set_userdata('tab_edoc',1);
		$alur=$this->encrypt->decode(base64_decode($enc_alur));
		if ($alur=='1'){
			$alur="masuk";
		}else{
			$alur="keluar";
		}
		$id=$this->encrypt->decode(base64_decode($enc_id));
		$file=$this->encrypt->decode(base64_decode($enc_file));
		if($this->db->query('DELETE FROM delegasi_file_'.$alur.' WHERE id = '.$id)){
			unlink('./resources/file/delegasi/'.$alur.'/'.$file);
		}
		return;
	}

	function senddatato_delegasi(){
		$id_alur=$this->encrypt->decode(base64_decode($_POST['enc_alur']));
		$delegasi_id=$this->encrypt->decode(base64_decode($_POST['enc_delegasi']));
		$id_pn_asal=$this->encrypt->decode(base64_decode($_POST['enc_pn_asal']));
		$perkara_id=$this->encrypt->decode(base64_decode($_POST['enc_perkara']));
		$id_pn_tujuan=$this->encrypt->decode(base64_decode($_POST['enc_pn_tujuan']));
		$dataDelegasi=$this->delegasi->get_detil_delegasi($id_alur,$delegasi_id,$id_pn_asal,$id_pn_tujuan);
		$delegasiFile = $this->delegasi->get_file_delegasi($id_alur,$delegasi_id,'no')->result_object();

		if ($id_alur==1){
			$alur="masuk";
		}elseif($id_alur==2){
			$alur="keluar";	
		}
			if ($dataDelegasi->num_rows>=1) {
				foreach ($dataDelegasi->result() as $row) {
						$nomor_perkara=$row->nomor_perkara;
						$kode_satker_asal=$row->kode_satker_asal;
						$pn_asal_text=$row->pn_asal_text;
						$kode_satker_tujuan=$row->kode_satker_tujuan;
						$pn_tujuan_text=$row->pn_tujuan_text;
						$tgl_delegasi=$row->tgl_delegasi;
						$id_jenis_delegasi=$row->id_jenis_delegasi;
						$tgl_sidang=$row->tgl_sidang;
						$jenis_delegasi_text=$row->jenis_delegasi_text;
						$tgl_surat=$row->tgl_surat;
						$tgl_pengiriman=$row->tgl_pengiriman;
						$nomor_surat=$row->nomor_surat;
						$document=$row->document;
						$document_size=$row->document_size;
						$document_mime=$row->document_mime;
						$tgl_resi=$row->tgl_resi;
						$nomor_resi=$row->nomor_resi;
						$biaya=$row->biaya;
						$pihak=$row->pihak;
						$catatan=$row->catatan;
						$status_kirim=$row->status_kirim;
						$keterangan_status_kirim=$row->keterangan_status_kirim;
						$diinput_oleh=$row->diinput_oleh;
						$diinput_tanggal=$row->diinput_tanggal;
						$diperbaharui_oleh=$row->diperbaharui_oleh;
						$diperbaharui_tanggal=$row->diperbaharui_tanggal;
				}
			}
			if ($id_alur==2){
				$datasend = array(
							'delegasi_id'=>$delegasi_id,
							'id_pn_asal'=>$id_pn_asal,
							'pn_asal_text'=>$pn_asal_text,
							'kode_satker_asal'=>$kode_satker_asal,
							'nomor_perkara'=>$nomor_perkara,
							'perkara_id'=>$perkara_id,
							'id_pn_tujuan' => $id_pn_tujuan,
							'kode_satker_tujuan'=>$kode_satker_tujuan,
							'pn_tujuan_text' => $pn_tujuan_text,
							'tgl_delegasi' => $tgl_delegasi,
							'tgl_sidang' => $tgl_sidang,
							'id_jenis_delegasi' => $id_jenis_delegasi,
							'jenis_delegasi_text' => $jenis_delegasi_text,
							'tgl_surat'=>$tgl_surat,
							'tgl_pengiriman' => $tgl_pengiriman,
							'nomor_surat' => $nomor_surat,
							'catatan' => $catatan,
							'tgl_resi'=>$tgl_resi,
							'nomor_resi' => $nomor_resi,
							'nomor_surat' => $nomor_surat,
							'biaya' => intval($biaya),
							'pihak' => $pihak,
							'diinput_oleh' =>$diinput_oleh,
							'diinput_tanggal' =>$diinput_tanggal,
							'diperbaharui_oleh' =>$diperbaharui_oleh,
							'diperbaharui_tanggal' =>$diperbaharui_tanggal,
							'file'=>$delegasiFile,
						);
			}elseif($id_alur==1){
				$pelaksanaan = $this->delegasi->get_pelaksanaan($id_alur,$delegasi_id,$id_pn_asal,$id_pn_tujuan)->result_object();
				$datasend = array(
							'delegasi_id'=>$delegasi_id,
							'id_pn_asal'=>$id_pn_asal,
							'perkara_id'=>$perkara_id,
							'id_pn_tujuan' => $id_pn_tujuan,
							'file'=>$delegasiFile,
							'pelaksanaan'=>$pelaksanaan);
			}
				

			$index_perkara=$this->delegasi->get_index_perkara();
			$datasend=array_merge(array('id_alur'=>$id_alur),$datasend);		
			$datasend=array_merge(array('act'=>'insert'),$datasend);
			$datasend=array_merge(array('index_perkara'=>$index_perkara),$datasend);
		    $data_string = json_encode($datasend);
		    $curl = curl_init();
			curl_setopt_array($curl, array(
			  CURLOPT_URL => base_url_delegasi()."api/delegasi/send_delegasi",
			  CURLOPT_RETURNTRANSFER => true,
			  CURLOPT_HTTPHEADER => array(
			    'Content-Type: application/json',
			    'Content-Length: ' . strlen($data_string)),
			  CURLOPT_ENCODING => "",
			  CURLOPT_MAXREDIRS => 10,
			  CURLOPT_TIMEOUT => 6000000000,
			  CURLOPT_POSTFIELDS => $data_string,
			  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			  CURLOPT_CUSTOMREQUEST => "POST"));
			
			$response = curl_exec($curl);
			$err = curl_error($curl);
			curl_close($curl);

			if ($err) {
				$st=$err;
			} else {
		 		$st=$response;
			}

			$status=json_decode($st);
			if ($status->status_kirim==TRUE) {
				if ($this->sendfileto_delegasi($id_alur,$delegasi_id)){
					if ($id_alur==1){
						$this->db->query('UPDATE delegasi_masuk SET status_kirim = 1 WHERE id='.$delegasi_id.' AND status_kirim=0');
					}elseif($id_alur==2){
					 	$this->db->query('UPDATE delegasi_keluar SET status_kirim = 1 WHERE id='.$delegasi_id.' AND status_kirim=0');
					}
					 echo json_encode(array('status_kirim'=>'1'));
				}else{
					echo json_encode(array('status_kirim'=>'Tidak bisa mengirim file'));
				}
				$this->session->set_userdata('tab_edoc',1);
			}else {
				echo json_encode(array('status_kirim'=>'Tidak bisa mengirim data'));
				$this->session->set_userdata('tab_edoc',0);
			}
	}

	function sendfileto_delegasi($id_alur,$delegasi_id){
			if ($id_alur==1){
				$folder="masuk";
				$delegasiFile = $this->delegasi->get_file_pelaksanaan($id_alur,$delegasi_id,'yes');
			}
			if ($id_alur==2){
				$folder="keluar";	
				$delegasiFile = $this->delegasi->get_file_keluar($id_alur,$delegasi_id,'yes');
			}
			$index_perkara=$this->delegasi->get_index_perkara();	
		    if ($delegasiFile->num_rows > 0) {
		    	foreach ($delegasiFile->result() as $row) {
			    	if (file_exists(FCPATH."resources/file/delegasi/".$folder."/".$row->file) ){
					    $dir = FCPATH.'resources/file/delegasi/'.$folder.'/'.$row->file;
					    $curl = curl_init();
						
						if (intval(substr(phpversion(),3))>=5.5) {
							$cfile = curl_file_create($dir,'image/jpeg',$row->file);
					    	$postfields = array("filedata" => $cfile, "filename" => $row->file,'index_perkara'=>$index_perkara,'id_alur'=>$id_alur);
						}else{
							$postfields = array("filedata" => "@".$dir, "filename" => $row->file,'index_perkara'=>$index_perkara,'id_alur'=>$id_alur);
						}	

						curl_setopt_array($curl, array(
						  CURLOPT_URL => base_url_delegasi()."api/delegasi/send_file",
						  CURLOPT_RETURNTRANSFER => true,
						  CURLOPT_HTTPHEADER => array(
						    'Content-Type:multipart/form-data'),
						  CURLOPT_ENCODING => "",
						  CURLOPT_MAXREDIRS => 10,
						  CURLOPT_TIMEOUT => 3600,
						  CURLOPT_POSTFIELDS => $postfields,
						  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
						  CURLOPT_CUSTOMREQUEST => "POST"));
						
						$response = curl_exec($curl);
						$err = curl_error($curl);

						curl_close($curl);
					}
		    	}
		    	if ($err) {
					return false;
				} else {
			 		return true;
				}
			}else{
				return false;
			}
		 	
	}

	

	function get_delegasi_masuk(){
		$enc_pn_asal=$this->session->userdata('enc_id_pn');
		$id_pn_asal=$this->encrypt->decode(base64_decode($enc_pn_asal));
		$index_perkara=$this->delegasi->get_index_perkara();		
		$datasend=array('index_perkara'=>$index_perkara,'id_pn_asal'=>$id_pn_asal);
	    $data_string = json_encode($datasend);

	    $curl = curl_init();
		curl_setopt_array($curl, array(
		  CURLOPT_URL => base_url_delegasi()."api/delegasi/get_delegasi",
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_HTTPHEADER => array(
		    'Content-Type: application/json',
		    'Content-Length: ' . strlen($data_string)),
		  CURLOPT_ENCODING => "",
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 60,
		  CURLOPT_POSTFIELDS => $data_string,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => "POST"));
		
		$response = curl_exec($curl);
		$err = curl_error($curl);

		curl_close($curl);

		if ($err) {
			$st=$err;
		} else {
	 		$st=$response;
		}

		$status=json_decode($st);
		if ($status->status_kirim==TRUE) {
			echo json_encode(array('jumlah'=>count($status->msg)));
			for ($i=0; $i < count($status->msg) ; $i++) {
				$this->db->replace('delegasi_masuk',get_object_vars($status->msg[$i]));
			}

			for ($i=0; $i < count($status->lampiran) ; $i++) {
				$this->db->replace('delegasi_file_masuk',get_object_vars($status->lampiran[$i]));
			}
		}else {
			echo json_encode(array('jumlah'=>0,'msg'=>'0'));
		}
		$this->get_pelaksanaan($id_pn_asal);
	}

	function get_pelaksanaan($id_pn_asal){
		if (!isset($_POST)){
			$id_pn_asal=$this->encrypt->decode(base64_decode($_POST['enc_pn_asal']));
		}
		$index_perkara=$this->delegasi->get_index_perkara();		
		$datasend=array('index_perkara'=>$index_perkara,'id_pn_asal'=>$id_pn_asal);
	    $data_string = json_encode($datasend);
	    $curl = curl_init();
		curl_setopt_array($curl, array(
		  CURLOPT_URL => base_url_delegasi()."api/delegasi/get_pelaksanaan",
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_HTTPHEADER => array(
		    'Content-Type: application/json',
		    'Content-Length: ' . strlen($data_string)),
		  CURLOPT_ENCODING => "",
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 60,
		  CURLOPT_POSTFIELDS => $data_string,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => "POST"));
		
		$response = curl_exec($curl);
		$err = curl_error($curl);

		curl_close($curl);

		if ($err) {
			$st=$err;
		} else {
	 		$st=$response;
		}
		$status=json_decode($st);
		if ($status->status_kirim==TRUE) {
			for ($i=0; $i < count($status->msg) ; $i++) {
				$this->db->replace('delegasi_proses_keluar',get_object_vars($status->msg[$i]));
				$this->db->query('UPDATE delegasi_keluar set status_kirim=2 where id='.$status->msg[$i]->delegasi_id);
			}
			for ($i=0; $i < count($status->lampiran) ; $i++) {
				$this->db->replace('delegasi_file_keluar',get_object_vars($status->lampiran[$i]));
			}
			echo json_encode(array('jumlah'=>count($status->msg)));
		}else {
			echo json_encode(array('jumlah'=>0,'msg'=>$status->msg));
		}
	}

	function validateDelete(){
		if(empty($_POST)){
			show_404();
		}
		
		$iddelegasi=$this->encrypt->decode(base64_decode($this->input->post('enc_delegasi',TRUE)));
		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$this->load->model('perkara/delegasi','delegasi');
			$delData = $this->delegasi->del_data($iddelegasi);
		if($delData==TRUE){
			echo json_encode(array('st'=>1,'msg'=>'Data delegasi keluar berhasil dihapus.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Something Bad Happen.'));
			return;
		}
	}

	function fetchDataPerkara(){
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Please Refresh Your Page'));
			return;
		}
		
		$nomor_perkara=trim($this->input->post('val',TRUE));
		
		if(empty($nomor_perkara)){
			echo json_encode(array('st'=>0,'msg'=>'Nomor Perkara Masih Kosong.'));
			return;
		}

		$this->load->model('perkara/delegasi','delegasi_keluar');
		$dataPerkara = $this->delegasi_keluar->fetchData($nomor_perkara);

		if($dataPerkara->num_rows>0){
			foreach ($dataPerkara->result() as $row) {
				$perkara_id = $row->perkara_id;
				$alur_perkara_id=$row->alur_perkara_id;
				$jenis_perkara_nama= $row->jenis_perkara_nama;
				$tgl_sidang=$this->tanggalhelper->convertToInputDate($row->penetapan_hari_sidang);
				$tanggal_pendaftaran_perkara= $this->tanggalhelper->convertToInputDate($row->tanggal_pendaftaran);
			}
				if ($alur_perkara_id>=110){
					$sebagai_p="Penuntut";
					$sebagai_t="Terdakwa";
				}else{
					$sebagai_p="Penggugat";
					$sebagai_t="Tergugat";
				}
				$pihak1= $this->delegasi_keluar->get_data_pihak($perkara_id,'1');
				$nama_pihak1='';
				$counter=0;
				if($pihak1->num_rows>0){
							$nama_pihak1 = '<tr class="judul_tabel">
												<th style="border-right: 3px solid white;width:400px;height:30px;background-color: #008C4B;">'.$sebagai_p.'</th>
												<th style="width:400px;height:30px;background-color: #008C4B;">Kuasa Hukum</th>
											</tr>'
											;
											
						foreach ($pihak1->result() as $row) {
							$idpihak=$row->id_pihak;
							$identitas_pihak ='Nama  :'.$row->nama.'<br>Alamat : '.$row->alamat.'<br>Pekerjaan : '.$row->pekerjaan.'<br>';
							$nama_pihak1 .='<tr class="tr_chk_pihak">
												<td  style="background:#fff;color:#111;">
												<input value="'.$identitas_pihak.'" class="chk_pihak" name="chk_pihak" type="checkbox">'.$row->nama.'
												</td>
											'
											;
							if (!empty($row->id_kuasa)){
							$identitas_kuasa ='Nama  :'.$row->nama_kuasa.'<br>Alamat : '.$row->alamat_kuasa.'<br>Pekerjaan : Kuasa<br>';
							$nama_pihak1 .='
												<td  style="background:#fff:color:#111;">
												<input value="'.$identitas_kuasa.'" name="chk_pihak" type="checkbox">'.$row->nama_kuasa.'
												</td>
											</tr>'
											;
							}
							$counter++;
						}
				}else{
					echo json_encode(array(
						'st'=>0,
						'msg'=>'Pihak Tidak Ditemukan.'.$perkara_id
					));
					return;
				}

				$pihak2= $this->delegasi_keluar->get_data_pihak($perkara_id,'2');
				//print_r($pihak2->result());
				$nama_pihak2='';
				$counter=0;
				if($pihak2->num_rows>0){
							$nama_pihak2 = '<tr class="judul_tabel">
												<th style="border-right: 3px solid white;background-color: #008C4B;height:30px;">'.$sebagai_t.'</th>
												<th style="background-color: #008C4B;height:30px;">Kuasa Hukum</th>
											</tr>'
											;
						foreach ($pihak2->result() as $row) {
							$idpihak=$row->id_pihak;
							$identitas_pihak ='Nama  :'.$row->nama.'<br>Alamat : '.$row->alamat.'<br>Pekerjaan : '.$row->pekerjaan.'<br>';
							$nama_pihak2 .='<tr class="tr_chk_pihak">
											<td  style="background:#fff;width:290px;color:#111;">
											<input value="'.$identitas_pihak.'" class="chk_pihak" name="chk_pihak" type="checkbox">'.$row->nama.'
											</td>
											</tr>'
											;
							if (!empty($row->id_kuasa)){
							$identitas_kuasa ='Nama  :'.$row->nama_kuasa.'<br>Alamat : '.$row->alamat_kuasa.'<br>Pekerjaan : Kuasa<br>';
							$nama_pihak2 .='
												<td  style="background:#fff;color:#111;">
												<input value="'.$identitas_kuasa.'" name="chk_pihak" type="checkbox">'.$row->nama_kuasa.'
												</td>
											</tr>'
											;
							}
							$counter++;
						}
				}else{
					echo json_encode(array(
						'st'=>0,
						'msg'=>'Pihak Tidak Ditemukan.'
					));
					return;
				}				
				$pihak3= $this->delegasi_keluar->get_data_pihak($perkara_id,'3');
				$nama_pihak3='';
				$counter=0;
				if($pihak3->num_rows>0){
						$nama_pihak3 = '<tr class="judul_tabel">
												<th style="border-right: 3px solid white;background-color: #008C4B;height:30px;">Intervensi </th>
												<th style="background-color: #008C4B;height:30px;">Kuasa Hukum</th>
											</tr>'
											;
						foreach ($pihak3->result() as $row) {
							$idpihak=$row->id_pihak;
							$identitas_pihak ='Nama  :'.$row->nama.'<br>Alamat : '.$row->alamat.'<br>Pekerjaan : '.$row->pekerjaan.'<br>';
							$nama_pihak3 .='<tr class="tr_chk_pihak">
											<td  style="background:#fff;width:290px;color:#111;">
											<input value="'.$identitas_pihak.'" class="chk_pihak" name="chk_pihak" type="checkbox">'.$row->nama.'
											</td>
											</tr>'
											;
							if (!empty($row->id_kuasa)){
							$identitas_kuasa ='Nama  :'.$row->nama_kuasa.'<br>Alamat : '.$row->alamat_kuasa.'<br>Pekerjaan : Kuasa<br>';
							$nama_pihak3 .='
												<td  style="background:#fff;color:#111;">
												<input value="'.$identitas_kuasa.'" name="chk_pihak" type="checkbox">'.$row->nama_kuasa.'
												</td>
											</tr>'
											;
							}
							$counter++;
						}
				}
				$pihak4= $this->delegasi_keluar->get_data_pihak($perkara_id,'4');
				$nama_pihak4='';
				$counter=0;
				if($pihak4->num_rows>0){
							$nama_pihak4 = '<tr class="judul_tabel">
												<th style="border-right: 3px solid white;background-color: #008C4B;height:30px;">Turut Tergugat </th>
												<th style="background-color: #008C4B;height:30px;">Kuasa Hukum</th>
											</tr>'
											;
						foreach ($pihak4->result() as $row) {
							$idpihak=$row->id_pihak;
							$identitas_pihak ='Nama  :'.$row->nama.'<br>Alamat : '.$row->alamat.'<br>Pekerjaan : '.$row->pekerjaan.'<br>';
							$nama_pihak4 .='<tr class="tr_chk_pihak">
											<td  style="background:#fff;width:290px;color:#111;">
											<input value="'.$identitas_pihak.'" class="chk_pihak" name="chk_pihak" type="checkbox">'.$row->nama.'
											</td>
											</tr>'
											;
							if (!empty($row->id_kuasa)){
							$identitas_kuasa ='Nama  :'.$row->nama_kuasa.'<br>Alamat : '.$row->alamat_kuasa.'<br>Pekerjaan : Kuasa<br>';
							$nama_pihak4 .='
												<td  style="background:#fff;color:#111;">
												<input value="'.$identitas_kuasa.'" name="chk_pihak" type="checkbox">'.$row->nama_kuasa.'
												</td>
											</tr>'
											;
							}
							$counter++;
						}
				}
				echo json_encode(array(
				'st'=>1,
				'enc'=>base64_encode($this->encrypt->encode($perkara_id)),
				'alur_perkara_id'=>$alur_perkara_id,
				'nama_pihak1'=>$nama_pihak1,
				'nama_pihak2'=>$nama_pihak2,
				'nama_pihak3'=>$nama_pihak3,
				'nama_pihak4'=>$nama_pihak4,
				'alur_perkara_id'=>$alur_perkara_id ,
				'tgl_sidang'=>$tgl_sidang,
				'tanggal_pendaftaran_perkara'=>$tanggal_pendaftaran_perkara,
				'perkara_nama'=>$jenis_perkara_nama,
				'msg'=>'Perkara Ditemukan.'
				));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
	}


function popup_penunjukan_jurusita() {
		$this->load->model('perkara/delegasi','delegasi');
		$segment = $this->uri->segment_array();
		if 	($segment[3]!=''){
			$data['idalur']=$segment[3];
		}else {
			$data['idalur']=$this->encrypt->decode(base64_decode($this->nativesession->get_flash_session('idalur'),TRUE));
		}
		
		$data['iddelegasi']=$this->encrypt->decode(base64_decode($segment[4]));
		$data['idpnasal']=$this->encrypt->decode(base64_decode($segment[5]));
		$data['idpntujuan']=$this->encrypt->decode(base64_decode($segment[6]));



		if (count($segment)<=6){
			$judul="Penunjukan";
			$data['edit']=0;
		}else{
			$data['edit']=$segment[7];
    		$judul="Edit Penunjukan";
		}

		$data['delegasi_detil']=$this->delegasi->get_detil_delegasi($data['idalur'],$data['iddelegasi'],$data['idpnasal'],$data['idpntujuan']);
    	$data['delegasi_proses']=$this->delegasi->get_detil_proses($data['idalur'],$data['iddelegasi'],$data['idpnasal'],$data['idpntujuan']);
    	
    	foreach ($data['delegasi_detil']->result() as $row) {
			$data['p_tgl_delegasi']=$this->tanggalhelper->convertToInputDate($row->tgl_delegasi);
			$data['tgl_surat_pengantar']=$row->tgl_surat;
		}

		foreach ($data['delegasi_proses']->result() as $row) {
			$data['p_id_jurusita']=$row->jurusita_id;
			$data['p_tgl_penunjukan_jurusita']=$this->tanggalhelper->convertToInputDate($row->tgl_penunjukan_jurusita);
			$data['p_jurusita_nama']=$row->jurusita_nama;
		}

		$data['previous']=$this->nativesession->get_flash_session('previous');
		$data['judul']=$judul;
		$data['data_jurusita'] = $this->delegasi->getDataJurusita();
		$data['current_date'] = date('d/m/Y');
		$this->load->view('delegasi/edit_jurusita',$data);
	}


	function simpan_jurusita(){
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$user=$this->session->userdata('fullname');
		$this->form_validation->set_rules('id_jurusita_txt', 'Jurusita', 'trim|xss_clean|required');
		$this->form_validation->set_rules('jurusita_nama_txt', 'Jurusita', 'trim|xss_clean|required');
		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tidak Berhasil'.validation_errors()));
			return;
		}

		$this->load->model('perkara/delegasi','delegasi');
		$edit=$this->input->post('edit',TRUE);
		
		$id_delegasi=$this->input->post('iddelegasi',TRUE);
		$id_pn_asal=$this->input->post('idpnasal',TRUE);
		$id_pn_tujuan=$this->input->post('idpntujuan',TRUE);
		$jurusita_id=$this->input->post('id_jurusita_txt',TRUE);
		$jurusita_nama=$this->input->post('jurusita_nama_txt',TRUE);
		$tgl_jurusita=$this->input->post('tgl_jurusita',TRUE);

		#didik
		$tgl_surat_pengantar=$this->input->post('tgl_surat_pengantar',TRUE);
		$tgl_penunjukan_jurusita_delegasi = $this->tanggalhelper->convertToMysqlDate($tgl_jurusita);
		$selisih = $this->tanggalhelper->getSelisihHari($tgl_surat_pengantar,$tgl_penunjukan_jurusita_delegasi);		
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penunjukan Jurusita/Jurusita Pengganti Tidak Boleh Kurang Dari Tanggal Surat Pengantar Relaas Satker Asal. '.$this->tanggalhelper->convertDayDate($tgl_surat_pengantar)));
			return;
		}
		#end

		$dataPerkara = $this->delegasi->get_detil_delegasi('1',$id_delegasi,$id_pn_asal,$id_pn_tujuan);
		
		foreach ($dataPerkara->result() as $key => $valdetil) {
			$$key=$valdetil;
		}
		
		foreach ($valdetil as $key => $val){
				$$key=$val;	
		}

		$id_perkara=$perkara_id;
		if ($edit==TRUE) {
		$datainsert = array(
				'perkara_id'=>$id_perkara,
				'jurusita_id'=>$jurusita_id,
				'tgl_penunjukan_jurusita'=>$this->tanggalhelper->convertToMysqlDate($tgl_jurusita),
				'jurusita_nama'=>$jurusita_nama,
				'id_pn_asal'=>$id_pn_asal,
				'id_pn_tujuan'=>$id_pn_tujuan);
		}else{
		$datainsert = array(
				'delegasi_id'=>$id_delegasi,
				'perkara_id'=>$id_perkara,
				'jurusita_id'=>$jurusita_id,
				'tgl_penunjukan_jurusita'=>$this->tanggalhelper->convertToMysqlDate($tgl_jurusita),
				'jurusita_nama'=>$jurusita_nama,
				'id_pn_asal'=>$id_pn_asal,
				'id_pn_tujuan'=>$id_pn_tujuan,
				'id_status_delegasi'=>'0',
				'status_delegasi'=>'Penunjukan Jurusita');
		}

		if($this->delegasi->update_delegasi_proses($edit,$id_delegasi,$id_pn_asal,$id_pn_tujuan,$datainsert)){
			echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan!'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Data Tidak Berhasil Disimpan !!'));
			return;
		}
	}

	function update_pelaksanaan($enc_delegasi=NULL,$enc_pn_asal=NULL,$enc_pntujuan=NULL,$edit=NULL){
		
		$iddelegasi=$this->encrypt->decode(base64_decode($enc_delegasi));
		$idpnasal=$this->encrypt->decode(base64_decode($enc_pn_asal));
		$idpntujuan=$this->encrypt->decode(base64_decode($enc_pntujuan));

		$this->load->model('perkara/delegasi','delegasi');
		$idpt='';
		$jenis_pengadilan = $this->session->userdata('jenis_pengadilan');
		$data['delegasi_detil'] = $this->delegasi->get_detil_delegasi(1,$iddelegasi,$idpnasal,$idpntujuan);
		$data['delegasi_proses'] = $this->delegasi->get_detil_proses(1,$iddelegasi,$idpnasal,$idpntujuan);
		$data['data_jurusita'] = $this->delegasi->getDataJurusita(1,$iddelegasi,$idpnasal,$idpntujuan);
		$data['list_pt'] = $this->delegasi->get_list_pt(0,$jenis_pengadilan);
		$data['list_pn'] = $this->delegasi->get_list_pn($idpt);
		$data['jenis_delegasi'] = $this->delegasi->getJenisDelegasi();
		$data['data_pn_asal']=$this->delegasi->identitasPN();
		
			if ($data['delegasi_detil']->num_rows>=1) {
				foreach ($data['delegasi_detil']->result() as $row) {
						$data['delegasi_id']=$row->id;	
						$data['perkara_id']=$row->perkara_id;
						$data['p_perkara_id']=$row->perkara_id;
						$data['nomor_perkara']=$row->nomor_perkara;
						$data['pihak']=$row->pihak;
						$data['id_pn_asal']=$row->id_pn_asal;
						$data['kode_satker_asal']=$row->kode_satker_asal;
						$data['pn_asal_text']=$row->pn_asal_text;
						$data['id_pn_tujuan']=$row->id_pn_tujuan;
						$data['kode_satker_tujuan']=$row->kode_satker_tujuan;
						$data['pn_tujuan_text']=$row->pn_tujuan_text;
						$data['tgl_delegasi']=$this->tanggalhelper->convertDayDate($row->tgl_delegasi);
						$data['id_jenis_delegasi']=$row->id_jenis_delegasi;
						$data['jenis_delegasi_text']=$row->jenis_delegasi_text;
						$data['tgl_surat']=$this->tanggalhelper->convertDayDate($row->tgl_surat);
						$data['tgl_pengiriman']=$this->tanggalhelper->convertDayDate($row->tgl_pengiriman);
						$data['nomor_surat']=$row->nomor_surat;
						$data['namadokumen']=$row->namadokumen;
						$data['document']=$row->document;
						$data['document_size']=$row->document_size;
						$data['document_mime']=$row->document_mime;
						$data['tgl_sidang']=$this->tanggalhelper->convertDayDate($row->tgl_sidang);
						$data['tgl_resi']=$this->tanggalhelper->convertDayDate($row->tgl_resi);
						$data['nomor_resi']=$row->nomor_resi;
						$data['biaya']=$row->biaya;
						$data['catatan']=$row->catatan;
						$data['tgl_surat_relaas']=$row->tgl_surat;#didik
				}
			}else{
						$data['delegasi_id']='';
						$data['perkara_id']='';
						$data['nomor_perkara']='';
						$data['pihak']='';
						$data['id_pn_asal']='';
						$data['kode_satker_asal']='';
						$data['pn_asal_text']='';
						$data['id_pn_tujuan']='';
						$data['kode_satker_tujuan']='';
						$data['pn_tujuan_text']='';
						$data['tgl_delegasi']='';
						$data['id_jenis_delegasi']='';
						$data['jenis_delegasi_text']='';
						$data['tgl_sidang']='';
						$data['tgl_surat']='';
						$data['tgl_pengiriman']='';
						$data['nomor_surat']='';
						$data['namadokumen']='';
						$data['document']='';
						$data['document_size']='';
						$data['document_mime']='';
						$data['tgl_resi']='';
						$data['nomor_resi']='';
						$data['biaya']='';
						$data['catatan']='';
						$data['tgl_surat_relaas']='';#didik
			}
			
			if ($data['delegasi_proses']->num_rows>=1) {
				foreach ($data['delegasi_proses']->result() as $row) {
						$data['p_delegasi_id']=$row->delegasi_id;
						$data['p_tgl_surat_diterima']=$this->tanggalhelper->convertToInputDate($row->tgl_surat_diterima);
						$data['p_enc_jurusita']=$row->jurusita_id;
						$data['p_tgl_penunjukan_jurusita']=$this->tanggalhelper->convertDayDate($row->tgl_penunjukan_jurusita);
						$data['p_jurusita_nama']=$row->jurusita_nama;
						$data['p_id_pn_asal']=$row->id_pn_asal;
						$data['p_pn_asal_text']=$row->pn_asal_text;
						$data['p_kode_satker_asal']=$row->kode_satker_asal;
						$data['p_id_pn_tujuan']=$row->id_pn_tujuan;
						$data['p_pn_tujuan_text']=$row->pn_tujuan_text;
						$data['p_kode_satker_tujuan']=$row->kode_satker_tujuan;
						$data['p_tgl_relaas']=$this->tanggalhelper->convertToInputDate($row->tgl_relaas);
						$data['p_nomor_relaas']=$row->nomor_relaas;
						$data['p_tgl_pengiriman_relaas']=$this->tanggalhelper->convertToInputDate($row->tgl_pengiriman_relaas);
						$data['p_nomor_surat_pengantar_relaas']=$row->nomor_surat_pengantar_relaas;
						$data['p_id_status_delegasi']=$row->id_status_delegasi;
						$data['p_status_delegasi']=$row->status_delegasi;
						$data['p_namadokumen']=$row->namadokumen;
						$data['p_document']=$row->document;
						$data['p_document_size']=$row->document_size;
						$data['p_document_mime']=$row->document_mime;
						$data['p_tgl_resi']=$this->tanggalhelper->convertToInputDate($row->tgl_resi);
						$data['p_nomor_resi']=$row->nomor_resi;
						$data['p_biaya']=$row->biaya;
						$data['p_catatan']=$row->catatan;
						$data['tgl_penunjukan_jurusita']=$row->tgl_penunjukan_jurusita;#didik
					}
			}else{
						$data['p_delegasi_id']='';
						$data['p_tgl_surat_diterima']='';
						$data['p_perkara_id']='';
						$data['p_enc_jurusita']='';
						$data['p_tgl_penunjukan_jurusita']='';
						$data['p_jurusita_nama']='';
						$data['p_id_pn_asal']='';
						$data['p_pn_asal_text']='';
						$data['p_kode_satker_asal']='';
						$data['p_id_pn_tujuan']='';
						$data['p_pn_tujuan_text']='';
						$data['p_kode_satker_tujuan']='';
						$data['p_tgl_relaas']='';
						$data['p_nomor_relaas']='';
						$data['p_tgl_pengiriman_relaas']='';
						$data['p_nomor_surat_pengantar_relaas']='';
						$data['p_id_status_delegasi']='';
						$data['p_status_delegasi']='';
						$data['p_namadokumen']='';
						$data['p_document']='';
						$data['p_document_size']='';
						$data['p_document_mime']='';
						$data['p_tgl_resi']='';
						$data['p_nomor_resi']='';
						$data['p_biaya']='';
						$data['p_catatan']='';
						$data['tgl_penunjukan_jurusita']='';#didik
			}
	
		$data['page_title'] = "PELAKSANAAN DELEGASI MASUK";
		$data['judul']="Proses";
		$data['main_body'] = 'delegasi/update_pelaksanaan';	

		$data['jenis_pengadilan'] = $this->session->userdata('jenis_pengadilan');

		$data['previous']=$this->nativesession->get_flash_session('previous');
		$data['iddelegasi']=$iddelegasi;
		$data['idalur']='2';
		$data['idpnasal']=$idpnasal;
		$data['idpntujuan']=$idpntujuan;
		$data['edit']=$edit;
		
		$data['statusDelegasi']=array('Telah Dilaksanakan','Tidak dapat dilaksanakan');
		$data['diterimaOleh']=array('Langsung','Tidak Langsung');
		$data['current_date'] = date('d/m/Y');
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}

	function simpan_pelaksanaan(){
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$user=$this->session->userdata('fullname');
		$this->form_validation->set_rules('nomor_relaas', 'Nomor Relaas', 'required');
		$this->form_validation->set_rules('tgl_relaas', 'Tanggal Pelaksanaan Delegasi', 'required');
		$this->form_validation->set_rules('p_tgl_resi', 'Tanggal Resi Pengiriman', 'trim|xss_clean');
		$this->form_validation->set_rules('id_status_delegasi_txt', 'Status Delegasi', 'trim|xss_clean|required');
		$this->form_validation->set_rules('biaya', 'Biaya Panggilan', 'trim|xss_clean|required');
		$this->form_validation->set_rules('nomor_resi', 'Nomor Resi', 'trim|xss_clean');
		$this->form_validation->set_rules('tgl_pengiriman_relaas', 'Tanggal Surat Pengantar', 'trim|xss_clean|required');
		$this->form_validation->set_rules('nomor_surat_pengantar_relaas', 'Nomor Surat Pengantar Relaas', 'trim|xss_clean|required');

		$edit=$this->input->post('edit',TRUE);

		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Peringatan:<br /> Tidak Berhasil'.validation_errors()));
			return;
		}
		$biaya = str_replace(',','',$this->input->post('biaya',TRUE));
		if (intval($biaya)==0) {
			echo json_encode(array('st'=>0,'msg'=>'Biaya panggilan tidak boleh kosong'));
			return;;
		}
		$this->load->model('perkara/delegasi','delegasi');

		$catatan=$this->input->post('catatan_proses',TRUE);
		$id_delegasi=$this->input->post('delegasi_id',TRUE);
		$jurusita_id=$this->input->post('id_jurusita_txt',TRUE);
		$id_pn_asal=$this->input->post('id_pn_asal_txt',TRUE);
		$id_pn_tujuan=$this->input->post('id_pn_tujuan_txt',TRUE);
		$nomor_relaas=$this->input->post('nomor_relaas',TRUE);
		$nomor_resi=$this->input->post('nomor_resi',TRUE);
		$nomor_surat_pengantar_relaas=$this->input->post('nomor_surat_pengantar_relaas',TRUE);
		$jurusita_nama=$this->input->post('jurusita_nama_txt',TRUE);
		$id_status_delegasi=$this->input->post('id_status_delegasi_txt',TRUE);
		$status_delegasi=$this->input->post('status_delegasi_txt',TRUE);

		$tgl_surat_diterima=$this->input->post('tgl_surat_diterima',TRUE);		
		$tgl_relaas=$this->input->post('tgl_relaas',TRUE);
		$tgl_pengiriman_relaas=$this->input->post('tgl_pengiriman_relaas',TRUE);
		$tgl_resi=$this->input->post('p_tgl_resi',TRUE);		
		$id_perkara=$this->input->post('perkara_id',TRUE);
		
		$curr_date = date('Y-m-d');
		$todayDate = date('d/m/Y');
		
		$tgl_surat_diterima_delegasi = $this->tanggalhelper->convertToMysqlDate($tgl_surat_diterima);
		if($tgl_surat_diterima_delegasi==false){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Kolom Tanggal Relaas Diterima Tidak boleh kosong atau Format Tanggal Tidak Benar.'));
			return;
		}
		$tgl_relaas_delegasi = $this->tanggalhelper->convertToMysqlDate($tgl_relaas);
		if($tgl_relaas_delegasi==false){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Kolom Tanggal Pelaksaan Delegasi Tidak boleh kosong atau Format Tanggal Tidak Benar..'));
			return;
		}
		$tgl_pengiriman_relaas_delegasi = $this->tanggalhelper->convertToMysqlDate($tgl_pengiriman_relaas);
		if($tgl_pengiriman_relaas_delegasi==false){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Surat Pengantar Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
			return;
		}
		if(!empty($tgl_resi)){
			$tgl_resi_delegasi = $this->tanggalhelper->convertToMysqlDate($tgl_resi);
			if($tgl_resi_delegasi==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Resi Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}
		}
		
		#------
		$selisih4 = $this->tanggalhelper->getSelisihHari($tgl_surat_diterima_delegasi,$curr_date);
		if($selisih4<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Surat Pengantar Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
			return;
		}		
		$selisih2 = $this->tanggalhelper->getSelisihHari($tgl_relaas_delegasi,$curr_date);
		if($selisih2<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pelaksanaan Delegasi Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
			return;
		}
		$selisih1 = $this->tanggalhelper->getSelisihHari($tgl_pengiriman_relaas_delegasi,$curr_date);
		if($selisih1<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Relaas Diterima Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
			return;
		}
		if(!empty($tgl_resi_delegasi)){
			$selisih3 = $this->tanggalhelper->getSelisihHari($tgl_resi_delegasi,$curr_date);
			if($selisih3<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Resi Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}
		}
		
		
		#--------		
		$dayname = $this->tanggalhelper->getDayName($tgl_relaas_delegasi);
		if($dayname=='Saturday' OR $dayname=='Sunday'){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pelaksanaan Delegasi Dihari Libur, Sabtu dan Minggu.'));
			return;
		}
		if(!empty($tgl_resi_delegasi)){
			$dayname = $this->tanggalhelper->getDayName($tgl_resi_delegasi);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Resi Pengiriman Dihari Libur, Sabtu dan Minggu.'));
				return;
			}
		}
		$dayname = $this->tanggalhelper->getDayName($tgl_surat_diterima_delegasi);
		if($dayname=='Saturday' OR $dayname=='Sunday'){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Surat Pengantar Dihari Libur, Sabtu dan Minggu.'));
			return;
		}
		#--------Tidak Boleh Kurang Dari
		$tgl_surat_relaas = $this->input->post('tgl_surat_relaas',TRUE);
		$selisih = $this->tanggalhelper->getSelisihHari($tgl_surat_relaas,$tgl_surat_diterima_delegasi);
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Berkas Relaas Diterima Tidak Boleh Kurang Dari Tanggal Surat Pengantar Satker Asal. '.$this->tanggalhelper->convertDayDate($tgl_surat_relaas)));
			return;
		}
		$tgl_penunjukan_jsp = $this->input->post('tgl_penunjukan_jsp',TRUE);		
		$selisih = $this->tanggalhelper->getSelisihHari($tgl_penunjukan_jsp,$tgl_relaas_delegasi);		
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pelaksanaan Delegasi Tidak Boleh Kurang Dari Tanggal Penunjukan Jurusita. '.$this->tanggalhelper->convertDayDate($tgl_penunjukan_jsp)));
			return;
		}
		$selisih = $this->tanggalhelper->getSelisihHari($tgl_relaas_delegasi,$tgl_pengiriman_relaas_delegasi);			
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Surat Pengantar Tidak Boleh Kurang Dari Tanggal Pelaksanaan Delegasi. '.$this->tanggalhelper->convertDayDate($tgl_relaas_delegasi)));
			return;
		}
		if(!empty($tgl_resi_delegasi)){
			$selisih = $this->tanggalhelper->getSelisihHari($tgl_relaas_delegasi,$tgl_resi_delegasi);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Resi Pengiriman Tidak Boleh Kurang Dari Tanggal Pelaksanaan Delegasi. '.$this->tanggalhelper->convertDayDate($tgl_relaas_delegasi)));
				return;
			}
		}
				
		#END

		$identitasPNTujuan= $this->delegasi->getDataPN($id_pn_tujuan);
		foreach ($identitasPNTujuan->result() as $row) {
			$kode_satker_tujuan=$row->kode;
			$pn_tujuan_txt=$row->nama;
		}
		$identitasPNAsal= $this->delegasi->getDataPN($id_pn_asal);
		foreach ($identitasPNAsal->result() as $row) {
			$kode_satker_asal=$row->kode;
			$pn_asal_txt=$row->nama;
		}
		$datainsert = array(
				'tgl_surat_diterima'=>$this->tanggalhelper->convertToMysqlDate($tgl_surat_diterima),
				'perkara_id'=>$id_perkara,
				'jurusita_id'=>$jurusita_id,
				'jurusita_nama'=>$jurusita_nama,
				'id_pn_asal'=>$id_pn_asal,
				'pn_asal_text'=>$pn_asal_txt,
				'kode_satker_asal'=>$kode_satker_asal,
				'id_pn_tujuan'=>$id_pn_tujuan,
				'pn_tujuan_text'=>$pn_tujuan_txt,
				'kode_satker_tujuan'=>$kode_satker_tujuan,
				'tgl_relaas'=>$this->tanggalhelper->convertToMysqlDate($tgl_relaas),
				'nomor_relaas'=>$nomor_relaas,
				'tgl_pengiriman_relaas'=>$this->tanggalhelper->convertToMysqlDate($tgl_pengiriman_relaas),
				'nomor_surat_pengantar_relaas'=>$nomor_surat_pengantar_relaas,
				'id_status_delegasi'=>$id_status_delegasi,
				'status_delegasi'=>$status_delegasi,
				'diinput_oleh'=>$user,
				'diinput_tanggal'=>date('Y-m-d'),
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time()),
				'catatan'=>$catatan,
				'tgl_resi'=>$this->tanggalhelper->convertToMysqlDate($tgl_resi),
				'biaya'=>$biaya,
				'nomor_resi'=>$nomor_resi);


			$this->delegasi->update_delegasi_proses(TRUE,$id_delegasi,$id_pn_asal,$id_pn_tujuan,$datainsert);
			
			if($this->delegasi->update_delegasi_proses(TRUE,$id_delegasi,$id_pn_asal,$id_pn_tujuan,$datainsert)){
			 	echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan!'));
			 	return;
			 }else{
			 	echo json_encode(array('st'=>0,'msg'=>'Data Tidak Berhasil Disimpan !!'));
			 	return;
			}
	}


	function simpanFileproses(){
			$this->load->model('perkara/delegasi','delegasi');
			$edit="edit";
			$id_delegasi=$this->input->post('delegasi_id',TRUE);
			$id_pn_asal=$this->input->post('id_pn_asal_txt',TRUE);
			$id_pn_tujuan=$this->input->post('id_pn_tujuan_txt',TRUE);
			$config['allowed_types'] = 'gif|jpg|doc|docx|xls|xlsx|rtf|zip|rar|pdf';
			$filename=$_FILES['filedokumen']['name'];
			$mime=$_FILES['filedokumen']['type'];
			$size=$_FILES['filedokumen']['size'];		
			$datafile=file_get_contents($_FILES['filedokumen']['tmp_name']);

			$datainsert=array(
							'namadokumen'=>$filename,
							'document'=>$datafile,
							'document_size'=>$size,
							'document_mime'=>$mime
							);
			
			$this->delegasi->update_delegasi_proses($edit,$id_delegasi,$id_pn_asal,$id_pn_tujuan,$datainsert);
	}

	function cetak_surat_pengantar_keluar(){  
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }
			$segment = $this->uri->segment_array();
			$idalur=$this->encrypt->decode(base64_decode($segment[3]));
			$iddelegasi=$this->encrypt->decode(base64_decode($segment[4]));
			$idpnasal=$this->encrypt->decode(base64_decode($segment[5]));
			$idpntujuan=$this->encrypt->decode(base64_decode($segment[6]));
			$this->load->model('perkara/delegasi','delegasi');
			$data['jenis_pengadilan'] = $this->session->userdata('jenis_pengadilan');
			$data['delegasi_detil'] = $this->delegasi->get_detil_delegasi($idalur,$iddelegasi,$idpnasal,$idpntujuan);
			$data['delegasi_proses'] = $this->delegasi->get_detil_proses($idalur,$iddelegasi,$idpnasal,$idpntujuan);
			$get_id_pt = $this->delegasi->get_id_pt($idpntujuan);
			if ($get_id_pt->num_rows > 0) {
				foreach ($get_id_pt->result() as $row) {
					$data['idpt']=$row->id;
				}
			}

			$data['list_pt'] = $this->delegasi->get_list_pt(0,$data['jenis_pengadilan']);
			$data['list_pn'] = $this->delegasi->get_list_pn();
			$data['jenis_delegasi'] = $this->delegasi->getJenisDelegasi();
			$data['data_pn_asal']=$this->delegasi->identitasPN();
			
			$data['data_jurusita'] = $this->delegasi->getDataJurusita($idalur,$iddelegasi,$idpnasal,$idpntujuan);
			$data['data_pn_asal']=$this->delegasi->identitasPN();
							
			foreach ($data['delegasi_detil']->result() as $row) {
				$idperkara=$row->perkara_id;
				$data['enc_delegasi']=base64_encode($this->encrypt->encode($row->id));	
				$data['enc_perkara']=base64_encode($this->encrypt->encode($row->perkara_id));
				$data['nomor_perkara']=$row->nomor_perkara;
				$data['enc_pn_asal']=base64_encode($this->encrypt->encode($row->id_pn_asal));
				$data['kode_satker_asal']=$row->kode_satker_asal;
				$data['pn_asal_text']=$row->pn_asal_text;
				$data['enc_pn_tujuan']=base64_encode($this->encrypt->encode($row->id_pn_tujuan));
				$data['kode_satker_tujuan']=$row->kode_satker_tujuan;
				$data['pn_tujuan_text']=$row->pn_tujuan_text;
				$data['tgl_delegasi']=$this->tanggalhelper->convertToInputDate($row->tgl_delegasi);
				$data['id_jenis_delegasi']=$row->id_jenis_delegasi;
				$data['jenis_delegasi_text']=$row->jenis_delegasi_text;
				$data['tgl_surat']=$this->tanggalhelper->convertToInputDate($row->tgl_surat);
				$data['tgl_pengiriman']=$this->tanggalhelper->convertToInputDate($row->tgl_pengiriman);
				$data['nomor_surat']=$row->nomor_surat;
				$data['namadokumen']=$row->namadokumen;
				$data['tgl_sidang']=$this->tanggalhelper->convertToInputDate($row->tgl_sidang);
				$data['document']=$row->document;
				$data['document_size']=$row->document_size;
				$data['document_mime']=$row->document_mime;
				$data['tgl_resi']=$this->tanggalhelper->convertToInputDate($row->tgl_resi);
				$data['nomor_resi']=$row->nomor_resi;
				$data['biaya']=$row->biaya;
				$data['para_pihak']=$row->pihak;
				$data['catatan']=$row->catatan;
				$biayaterbilang=$row->biaya;
			}
			$data['perkara_detil'] = $this->delegasi->get_list_perkara($idperkara)->result();
			if (intval($biayaterbilang)!=0) {
							$data['terbilang']=$this->templatehelper->Terbilang($biayaterbilang);
							$biaya=number_format(strval($biayaterbilang),2,",",".");
						}else{
							$terbilang="";
							$biaya=0;
						}
		$data['datapengadilan'] = $this->delegasi->getDataPA();    
		
        $this->load->view('generate_template/peradilan_agama/cetak_pengantar_delegasi_keluar',$data,FALSE);
    }
	
	function acak_character($length=6){
			$characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
		    $result = '';
		    for ($i = 1; $i < $length; $i++)
		        $result .= $characters[mt_rand($length, 35)];
		     return $result;
	}

	function reset_session_delegasi(){
		$this->session->set_userdata('timer_cek_delegasi',date('Y-m-d H:i:s'));
	}

	function cek_delegasi_server_lokal(){
		$cari=$this->db->query('SELECT id from delegasi_masuk where status_kirim=0');
		if ($cari->num_rows > 0 ) {
			echo json_encode(array('st'=>1,'value'=> $cari->num_rows));
		}else{
			echo json_encode(array('st'=>0));
		}
	}
}