<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Jurnal_cetak extends CI_Controller {
	function parseParam($params){
		$data = array();
		$idalurperkara = '';
		$tahapan_id = '';
		$tmp = explode(";", $params);
		if(count($tmp)>0){
			$tmp_var = explode("=", $tmp[0]);
			if(count($tmp_var)>0){
				$data['idalurperkara'] = $tmp_var[1];
			}
			$tmp_var = explode("=", $tmp[1]);
			if(count($tmp_var)>0){
				$data['tahapan_id'] = $tmp_var[1];
			}
		}
		return $data;
	}


	function cetak(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$segment = $this->uri->segment_array();
		//print_r($segment);
		$jenis_cetak = intval($segment[3]);
		$param = $this->encrypt->decode(base64_decode($segment[4]));
		$keyword_segment = $this->encrypt->decode(base64_decode($segment[5]));
				
		$data = $this->parseParam($param);
		$alur_perkara_id = $data['idalurperkara'];
		$tahapan_id = $data['tahapan_id'];

		#Pencarian
		if($keyword_segment!==0){
			$keyword = $keyword_segment;
		} else {
			$keyword = "";
		}

		#Jurnal Perkara
		if($jenis_cetak==1){
			$this->load->model('jurnal/jurnal');
			$query = $this->jurnal->getJurnalListCetak($alur_perkara_id,$keyword,$tahapan_id);
		} else if ($jenis_cetak==2){
			$this->load->model('jurnal/jurnal_ht');
			$query = $this->jurnal_ht->getJurnalListCetak($alur_perkara_id,$keyword,$tahapan_id);
		}
		
		$data['list_jurnal_perkara'] = $query;
		$data['idalurperkara'] = $alur_perkara_id;
		$data['jenis_cetak'] = $jenis_cetak;
		
		$this->load->vars($data);
		$this->load->view('jurnal_perkara/jurnal_cetak');

	}
	function popup_cetak_jurnal_harian(){

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$tambah_tanggal = mktime(0,0,0,date('m')+2,date('d')+0,date('Y')+0); // angka 2,7,1 yang dicetak tebal bisa dirubah rubah
		$data['current_date'] = date('d/m/Y');
		//$data['current_date'] = date('d/m/Y');
		$this->load->model('generate_template/peradilan_agama/m_jurnal_harian');
		$data['kategori_biaya'] = $this->m_jurnal_harian->get_kategori_biaya('transaksi');
		$this->load->vars($data);
		$this->load->view('jurnal_perkara/popup_cetak_jurnal_harian');
	}

	function cetak_jurnal_harian(){
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		
		if(empty($_POST)){
			show_404();
		}

		$this->load->model('generate_template/peradilan_agama/m_jurnal_harian');
		$pertanggal 			= $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_transaksi',TRUE));
		$Pilihtransaksi 		= $this->input->post('pilih_transaksi',TRUE);
		$nama_transaksi 		= $this->m_jurnal_harian->get_kategori_biaya($Pilihtransaksi)->result();
		$data['namapanitera']	= $this->m_jurnal_harian->get_konfigurasi(68);
		$data['nippanitera']	= $this->m_jurnal_harian->get_konfigurasi(69);
		$data['namasatker']		= $this->m_jurnal_harian->get_konfigurasi(62);
		$data['kotasatker']		= $this->m_jurnal_harian->get_konfigurasi(62);
		$data['identitaskasir']	= $this->m_jurnal_harian->getkasir();
		$data['nama_transaksi']	= $nama_transaksi[0]->keterangan;
		$data['pertanggal']		= $pertanggal;
		if($Pilihtransaksi==0){
			$data['mbiayapertanggal'] = $this->m_jurnal_harian->get_biaya_perkara_pertanggal($pertanggal);
			$this->load->view('generate_template/peradilan_agama/cetak_jurnal_harian',$data,FALSE);
		}elseif($Pilihtransaksi==15){ 
			$data['mbiayapertanggal'] = $this->m_jurnal_harian->get_biaya_perkara_psp_6_bulan($pertanggal);
			$this->load->view('generate_template/peradilan_agama/cetak_jurnal_psp_6_bulan',$data,FALSE);
		}else{
			$data['mbiayapertanggal'] = $this->m_jurnal_harian->get_biaya_perkara_pertanggal_meterai($pertanggal,$Pilihtransaksi);
			$this->load->view('generate_template/peradilan_agama/cetak_jurnal_harian_meterai',$data,FALSE);
		}
	}
}
?>