<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Dismissal_c extends CI_Controller {
	function index(){

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$segment = $this->uri->segment_array();
		$enc = $this->uri->segment(2);
		$idperkara = $this->encrypt->decode(base64_decode($enc));
		if(empty($idperkara) OR intval($idperkara)<1){
			show_404();
		}
		if ($this->session->userdata('jenis_pengadilan')==1){
			$this->tampil_form($idperkara,'add');
		}else {
			$this->tampil_form_tun($idperkara,'add');
		}

	}

	function edit(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$segment = $this->uri->segment_array();
		$enc = $this->uri->segment(2);
		$idperkara = $this->encrypt->decode(base64_decode($enc));
		if(empty($idperkara) OR intval($idperkara)<1){
			show_404();
		}
		if($this->session->userdata('jenis_pengadilan')==1){
			$this->tampil_form($idperkara,'edit');
		}else{
			$this->tampil_form_tun($idperkara,'edit');
		}

	}	

	function tampil_form($idperkara,$status){
		$data['enc']=base64_encode($this->encrypt->encode($idperkara));
		$data['tgl_sekarang'] = date('d/m/Y');
		$data['status']=$status;
		$data['isi_dismissal']='';
		$data['nomor_perkara']='';
		$data['tanggal_pendaftaran']='';
		
		$this->load->model('perkara/dismissal','perkara');
		$result = $this->perkara->get_data_perkara($idperkara);
		if($result!=''){
			if($result->num_rows()>0){
				foreach ($result->result() as $row) {
					$data['nomor_perkara'] = $row->nomor_perkara;
					$data['tanggal_pendaftaran'] = $row->tanggal_pendaftaran;
				}
			}else{
				$this->error_page->show_error_msg('Error Found','Tidak ada Perkara');
				exit();
			}
		}
		
		$data['tgl_dismissal'] = '';
		$data['isi_dismissal'] = '
			<p>Menimbang  <span style="background-color: #FFFF00">------- isi pertimbangan disini-------</span></p>
			<p>Menimbang, bahwa setelah meneliti dan mempelajari gugatan <em>a quo</em>, hakim berpendapat gugatan tersebut tidak termasuk dalam gugatan sederhana.</p>
			<p>Menimbang, bahwa berdasarkan pertimbangan tersebut di atas, maka hakim perlu mengeluarkan penetapan.</p>
			<p>Mengingat, ketentuan Pasal 11 ayat (3) Peraturan Mahkamah Agung No. 2 Tahun 2015 tentang Pedoman Penyelesaian Gugatan Perkara Sederhana.</p>
			<p>MENETAPKAN:</p>
				<p>1. Menyatakan gugatan Penggugat bukan gugatan sederhana;</p>
				<p>2. Memerintahkan panitera untuk mencoret perkara No. '.$row->nomor_perkara.' dalam register perkara; dan</p>
				<p>3. Memerintahkan pengembalian sisa panjar biaya perkara kepada Penggugat.</p>';
		$result = $this->perkara->get_data_dismissal($idperkara);
		if($result!=''){
			if($result->num_rows()>0){
				foreach ($result->result() as $row) {
					$data['tgl_dismissal'] = $row->tanggal_putusan;
					if(!empty($row->amar_putusan)){
						$data['isi_dismissal'] = $row->amar_putusan;
					}
					$data['tgl_minutasi'] = $row->tanggal_minutasi;
				}
			}
		}
		
		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['extraAllowedContent'] = 'span{background-color};*{*}';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '800px';
		$this->ckeditor->config['height'] = '300px';

		$this->load->vars($data);
		$this->load->view('dismissal/dismissal_v');
	}

	function tampil_form_tun($idperkara,$status){
		$data['enc']=base64_encode($this->encrypt->encode($idperkara));
		$data['tgl_sekarang'] = date('d/m/Y');
		$data['status']=$status;
		$data['isi_dismissal']='';
		$data['nomor_perkara']='';
		$data['tanggal_pendaftaran']='';
		
		$this->load->model('perkara/dismissal','perkara');
		$result = $this->perkara->get_data_perkara($idperkara);
		if($result!=''){
			if($result->num_rows()>0){
				foreach ($result->result() as $row) {
					$data['nomor_perkara'] = $row->nomor_perkara;
					$data['tanggal_pendaftaran'] = $row->tanggal_pendaftaran;
				}				
			}else{
				$this->error_page->show_error_msg('Error Found','Tidak ada Perkara');
				exit();
			}
		}		
		
		$data['tgl_dismissal'] ='';
		$data['hasil_dismissal'] ='';
		$data['isi_dismissal'] ='';				

		$resulttun = $this->perkara->get_data_dismissal_tun($idperkara);
		if($resulttun!=''){
			if($resulttun->num_rows()>0){
				foreach ($resulttun->result() as $row) {
					$data['tgl_dismissal'] = $row->tanggal_penetapan;
					$data['hasil_dismissal'] = $row->hasil;
					$data['isi_dismissal'] = $row->amar;					
				}
			}
		}
		if($resulttun!=''){
			if($resulttun->num_rows()>0){
				$data['status'] = 'edit';
			}else{
				$data['status'] = 'add';
			}
		}
		$data['idpanggilan'] = '';
		$resultpanggil = $this->perkara->get_panggilan_dismissal_tun($idperkara);
		if($resultpanggil!=''){
			if($resultpanggil->num_rows()>0){
				foreach ($resultpanggil->result() as $row) {
					$data['idpanggilan'] = $row->id;
				}
			}
		}

		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['extraAllowedContent'] = 'span{background-color};*{*}';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '800px';
		$this->ckeditor->config['height'] = '300px';

		$this->load->vars($data);
		$this->load->view('dismissal/musyawarah_dismissal');
	}

	function tampil_panggilan_dismissal($enc,$encid){		
		$data['enc'] = $enc;
		$data['encid'] = $encid;
		$id = $this->encrypt->decode(base64_decode($encid));
		$data['tgl_sekarang'] = date('d/m/Y');
		$this->load->model('perkara/dismissal','perkara');
		$data['infos'] = 'edit';
		$data['tgl_dismissal'] = '';
		$data['status'] = '';
		$data['status_text'] = '';		
		$result = $this->perkara->get_panggilan_tun($id);		
		if($result!=''){
			if($result->num_rows()>0){
				foreach ($result->result() as $row) {
					$data['tgl_dismissal'] = $row->tanggal_panggilan;
					$data['waktuku'] = substr($row->waktu,0,5);
					$data['status'] = $row->status;
					$data['status_text'] = $row->status_text;					
				}
			}
		}
			
		$this->load->vars($data);				
		$this->load->view('dismissal/panggilan_dismissal_tun');		
	}

	function add_panggilan_dismissal($enc){		
		$data['enc'] = $enc;
		$data['encid'] = '';
		$idperkara = $this->encrypt->decode(base64_decode($enc));
		$data['tgl_sekarang'] = date('d/m/Y');
		$this->load->model('perkara/dismissal','perkara');
		$data['infos'] = 'tambah';
		$data['info_panggil'] = '';
		$data['info_status'] = '';
		$data['tgl_dismissal'] = '';
		$data['status'] = '';
		
		$result = $this->perkara->get_panggilan_dismissal_tun($idperkara);		
		if($result!=''){
			if($result->num_rows()>0){
				foreach ($result->result() as $row) {
					$data['info_panggil'] = $row->tanggal_panggilan;
					$data['info_status'] = $row->status;
					$data['waktu'] = substr($row->waktu,0,5);					
				}
			}
		}
		
		$this->load->vars($data);				
		$this->load->view('dismissal/panggilan_dismissal_tun');		
	}

	function validateInputPanggilTun(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Invalid Data.'));
			return;
		}		

		$infos = $this->input->post('infos',TRUE);			
		$info_status = $this->input->post('info_status',TRUE);
		if ($info_status==0 && $infos=="tambah"){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Pihak Yang Hadir Pada Penggilan Sebelumnya Belum Terisi.'));
			return;
		}
		
		
		$this->form_validation->set_rules('tgl_panggil', 'Tanggal Panggilan Dismissal', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('waktu_pelaksanaan', 'Waktu Panggilan Dismissal', 'trim|required|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$this->load->model('perkara/dismissal','perkara');		
			$tgl_panggilan_dismissal = $this->input->post('tgl_panggil',TRUE);
			$waktu_pelaksanaan = $this->input->post('waktu_pelaksanaan',TRUE);
			$dihadirioleh = $this->input->post('dihadiri',TRUE);
			if ($dihadirioleh=="" && $infos!="tambah"){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Pihak Yang Hadir Belum Terisi.'));
				return;
			}

			if(!empty($tgl_panggilan_dismissal) || !empty($dihadirioleh)){
				$curr_date = date('Y-m-d');
				$todayDate = date('d/m/Y');
				$tgl_panggilan = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_panggil',TRUE));			
				
				$dayname = $this->tanggalhelper->getDayName($tgl_panggilan);
				if($dayname=='Saturday' OR $dayname=='Sunday'){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Panggilan Dihari Libur, Sabtu dan Minggu.'));
					return;
				}						
				$tglpendaftaran = $this->tanggalhelper->getTanggalPendaftaran($idperkara);
				$selisih = $this->tanggalhelper->getSelisihHari($tglpendaftaran,$tgl_panggilan);				
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Panggilan Tidak Boleh Kurang dari Tanggal Pendaftaran Perkara.'));
					return;
				}
				if(!empty($dihadirioleh)){			
					if($dihadirioleh==1){
						$statustext = 'Semua Pihak';
					}elseif($dihadirioleh==2){
						$statustext = 'Penggugat Saja';
					}elseif($dihadirioleh==3){
						$statustext = 'Tergugat Saja';
					}elseif($dihadirioleh==4){
						$statustext = 'Para Pihak Tidak Hadir';
					}
				}else{
					$dihadirioleh=='';
					$statustext = '';
				}
				
				if($infos=='edit'){
					$id = $this->encrypt->decode(base64_decode($this->input->post('encid',TRUE)));
					if(empty($id) OR intval($id)<1){
						echo json_encode(array('st'=>0,'msg'=>'Invalid Data.'));
						return;
					}
					$data_add = array(
						'id' =>$id,
						'tanggal_panggilan' => $tgl_panggilan,
						'waktu' => $waktu_pelaksanaan,
						'status' => $dihadirioleh,
						'status_text' => $statustext,
						'diperbaharui_oleh' => $this->session->userdata('username'),
						'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
						);
				}elseif($infos=='tambah'){
					$idmax = $this->perkara->get_maxid_dismissal()->row()->maxid;
					$add_data = array(
						'id' => $idmax,
						'perkara_id' =>$idperkara,
						'tanggal_panggilan' => $tgl_panggilan,
						'waktu' => $waktu_pelaksanaan,
						'status' => $dihadirioleh,
						'status_text' => $statustext,
						'diperbaharui_oleh' => $this->session->userdata('username'),
						'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
						);
				}
				if($infos=='edit'){
					$result = $this->perkara->update_panggilan_dismissal($id,$data_add);
				}elseif($infos=='tambah'){
					$result = $this->perkara->insert_panggilan_dismissal($add_data);
				}
			}
		}		
		
		if($result===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Data Panggilan Dismissal Gagal Disimpan'));
			return;
		}
		echo json_encode(array('st'=>1,'msg'=>'Data Panggilan Dismissal Berhasil Disimpan'));
		return;
	}

	function validateInput(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$this->form_validation->set_rules('tgl_dismissal', 'Tanggal Dismissal', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('isi_dismissal_text', 'Amar Putusan', 'trim|required|xss_clean|min_length[50]');

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));	
			$isi_amar = trim($this->input->post('isi_dismissal_text',TRUE));
			
			if(!is_numeric($idperkara)){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Perkara Tidak ditemukan. Code Error = 194.'));
				return;
			}else{

				$curr_date = date('Y-m-d');
				$todayDate = date('m/d/Y');
				
				$tgl_dismissal = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_dismissal',TRUE));
				
				$selisih = $this->tanggalhelper->getSelisihHari($tgl_dismissal,$curr_date);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Dismissal Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
					return;
				}

				$dayname = $this->tanggalhelper->getDayName($tgl_dismissal);
				if($dayname=='Saturday' OR $dayname=='Sunday'){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Dismissal Dihari Libur, Sabtu dan Minggu.'));
					return;
				}

				$tglpendaftaran = $this->tanggalhelper->getTanggalPendaftaran($idperkara);

				$selisih = $this->tanggalhelper->getSelisihHari($tglpendaftaran,$tgl_dismissal);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Dismissal Tidak Boleh Kurang dari Tanggal Pendaftaran Perkara.'));
					return;
				}

				$data_add = array(
						'perkara_id' => $idperkara,
						'tanggal_putusan' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_dismissal',TRUE)),	
						'status_putusan_id' => 28,
						'amar_putusan' => $isi_amar,
						'diinput_oleh' => $this->session->userdata('username'),
						'diinput_tanggal' => date("Y-m-d h:i:s",time())
					);
				$this->load->model('perkara/dismissal','dismissal');
				$tgl_minutasi = $this->input->post('tgl_minutasi',TRUE);
				if(!empty($tgl_minutasi)){

					$tgl_minutasi = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_minutasi',TRUE));
					
					$selisih = $this->tanggalhelper->getSelisihHari($tgl_minutasi,$curr_date);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Minutasi Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
						return;
					}

					$dayname = $this->tanggalhelper->getDayName($tgl_minutasi);
					if($dayname=='Saturday' OR $dayname=='Sunday'){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Minutasi Dihari Libur, Sabtu dan Minggu.'));
						return;
					}

					$tglpendaftaran = $this->tanggalhelper->getTanggalPendaftaran($idperkara);

					$selisih = $this->tanggalhelper->getSelisihHari($tglpendaftaran,$tgl_minutasi);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Minutasi Tidak Boleh Kurang dari Tanggal Pendaftaran Perkara.'));
						return;
					}
					$data_add['tanggal_minutasi'] = $tgl_minutasi;
				}
				
				$status = $this->input->post('status',TRUE);
				if($status=='edit'){
					$data_add['diperbaharui_oleh'] = $this->session->userdata('username');
					$data_add['diperbaharui_tanggal'] = date("Y-m-d h:i:s",time());
					$result = $this->dismissal->update_dismissal($idperkara,$data_add);
				}elseif ($status=='add') {
					$data_add['diinput_oleh'] = $this->session->userdata('username');
					$data_add['diinput_tanggal'] = date("Y-m-d h:i:s",time());
					$result = $this->dismissal->add_dismissal($data_add);
				}else{
					echo json_encode(array('st'=>0,'msg'=>'Invalid Data Found.'));
					return;
				}
				
				if($result===FALSE){
					echo json_encode(array('st'=>0,'msg'=>'Penetapan Dismissal Gagal Disimpan'));
					return;
				}
				echo json_encode(array('st'=>1,'msg'=>'Penetapan Dismissal Berhasil Disimpan'));
				return;
			}
		}
	}

	function validateInputTun(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$this->form_validation->set_rules('tgl_panggilan', 'Tanggal Panggilan Dismissal', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('tgl_dismissal', 'Tanggal Penetapan Dismissal', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('isi_dismissal_text', 'Pertimbangan Penetapan Dismissal', 'trim|xss_clean');

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));	
			$isi_amar = trim($this->input->post('isi_dismissal_text',TRUE));
			
			if(!is_numeric($idperkara)){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Perkara Tidak ditemukan. Code Error = 194.'));
				return;
			}else{

				$curr_date = date('Y-m-d');
				$todayDate = date('m/d/Y');
				
				$tgl_panggilan = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_panggilan',TRUE));								
				$tgl_dismissal = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_dismissal',TRUE));

				$dayname = $this->tanggalhelper->getDayName($tgl_dismissal);
				if($dayname=='Saturday' OR $dayname=='Sunday'){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Dismissal Dihari Libur, Sabtu dan Minggu.'));
					return;
				}

				$tglpendaftaran = $this->tanggalhelper->getTanggalPendaftaran($idperkara);

				$selisih = $this->tanggalhelper->getSelisihHari($tglpendaftaran,$tgl_dismissal);
				if(!empty($tgl_dismissal)){
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Musyawarah Dismissal Tidak Boleh Kurang dari Tanggal Pendaftaran Perkara.'));
						return;
					}
				}
				if(!empty($tgl_panggilan)){
					$bedotanggal = $this->tanggalhelper->getSelisihHari($tglpendaftaran,$tgl_panggilan);
					if($bedotanggal<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Panggilan Tidak Boleh Kurang dari Tanggal Pendaftaran Perkara.'));
						return;
					}
				}
				
				$this->load->model('perkara/dismissal','dismissal');				
				
				$status = $this->input->post('status',TRUE);

				if($status=='add'){							
					$hasilnya = $this->input->post('hasil',TRUE);
					$tanggaltok = $this->input->post('tgl_dismissal',TRUE);
					if($hasilnya!='' AND $tanggaltok==''){						
						echo json_encode(array('st'=>0,'msg'=>'Tanggal Penetapan Dismissal Tidak Boleh Kosong.'));
						return;					
					}
					if($hasilnya=='' AND $tanggaltok=='' AND $this->input->post('tgl_panggilan',TRUE)==''){
						echo json_encode(array('st'=>0,'msg'=>'Data Tidak Lengkap.'));
						return;
					}

					if($hasilnya==2 AND empty($isi_amar)){
						echo json_encode(array('st'=>0,'msg'=>'Pertimbangan Dismissal Belum Diisikan.'));
						return;
					}elseif($hasilnya==1){
						$isi_amar = NULL;
					}
					if($tgl_dismissal!=''){
						$add_data = array(							
							'perkara_id' => $idperkara,
							'tanggal_penetapan' => $tgl_dismissal,
							'amar' => $isi_amar,
							'hasil' => $hasilnya										
						);
						$add_data['diinput_oleh'] = $this->session->userdata('username');
						$add_data['diinput_tanggal'] = date("Y-m-d h:i:s",time());
						$result = $this->dismissal->add_data_perkara_dismissal($add_data);
						if($hasilnya==1){
							$resultpkr = $this->dismissal->add_penetapan_dismissal_diterima($add_data);	
						}elseif($hasilnya==2){
							$resultpkr = $this->dismissal->add_penetapan_dismissal_ditolak($add_data);
						}	
					}
					if($tgl_panggilan!=''){
						$idmax = $this->dismissal->get_maxid_dismissal()->row()->maxid;													
						$jadwal= array(
							'id' => $idmax,
							'perkara_id' => $idperkara,						
							'tanggal_panggilan' => $tgl_panggilan,
							'diinput_oleh'=> $this->session->userdata('username'),
							'diinput_tanggal' => date("Y-m-d h:i:s",time())							
						);
						$result = $this->dismissal->add_data_panggilan_dismissal($jadwal);
						$resultpkr = $this->dismissal->add_panggil_dismissal($jadwal);
					}														
				}		
				if($status=='edit'){							
					$hasilnya = $this->input->post('hasil',TRUE);
					if($hasilnya==2 AND empty($isi_amar)){
						echo json_encode(array('st'=>0,'msg'=>'Pertimbangan Dismissal Belum Diisikan.'));
						return;
					}elseif($hasilnya==1){
						$isi_amar = NULL;
					}
					$add_data = array(						
						'perkara_id' => $idperkara,
						'tanggal_penetapan' => $tgl_dismissal,
						'amar' => $isi_amar,
						'hasil' => $hasilnya										
					);					
					$add_data['diperbaharui_tanggal'] = $this->session->userdata('username');
					$add_data['diperbaharui_tanggal'] = date("Y-m-d h:i:s",time());
					$result = $this->dismissal->update_perkara_dismissal($idperkara,$add_data);
					if($hasilnya==1){
						$result = $this->dismissal->add_proses_dis_hapus($add_data);
						$resultpkr = $this->dismissal->add_penetapan_dismissal_diterima($add_data);	
					}elseif($hasilnya==2){
						$resultpkr = $this->dismissal->add_penetapan_dismissal_ditolak($add_data);
					}				
				}
				
				if($result==TRUE || $resultpkr==TRUE){
					echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DISIMPAN.'));
					return;
				}else{
					echo json_encode(array('st'=>0,'msg'=>'GAGAL MELAKUKAN PENYIMPANAN.'));
					return;
				}
			}
		}
	}

	function showinfo($enc){
		$data['enc'] = $enc;
		$idperkara = $this->encrypt->decode(base64_decode($enc));
		if(empty($idperkara) OR intval($idperkara)<1){
			show_404();
		}
		$data['idperkara'] = $idperkara;
		$this->load->model('perkara/dismissal','perkara');
		if($this->session->userdata('jenis_pengadilan')==1){
			$data['tgl_dismissal'] = '';
			$data['isi_dismissal'] = '';
			$data['tgl_minutasi'] = '';
			$result = $this->perkara->get_data_dismissal($idperkara);
			if($result!=''){
				if($result->num_rows()>0){
					foreach ($result->result() as $row) {
						$data['tgl_dismissal'] = $row->tanggal_putusan;
						$data['isi_dismissal'] = $row->amar_putusan;
						$data['tgl_minutasi'] = $row->tanggal_minutasi;
					}
				}
			}
			$data['pihak_pertama'] = $this->perkara->getPihak($idperkara,1);
			$data['pihak_kedua'] = $this->perkara->getPihak($idperkara,2);
		}else{
			$data['encid'] = '';
			$data['tgl_dismissal'] ='';
			$data['hasil_dismissal'] ='';
			$data['isi_dismissal'] ='';
			$data['pemberitahuan_penggugat'] ='';
			$data['pemberitahuan_tergugat'] ='';
			$data['jadwal'] = $this->perkara->get_panggilan_dismissal_tun($idperkara);
			$infojadwal = $data['jadwal'];
			if($infojadwal!=''){
				if($infojadwal->num_rows()>0){
					foreach ($infojadwal->result() as $row) {
						$data['waktu'] = substr($row->waktu,0,5);
						$data['kehadiran'] = $row->status;
						$data['encid'] = $row->id;
					}					
				}
			}
			$result = $this->perkara->get_data_dismissal_tun($idperkara);
			$data['ada_perlawanan']=0;
			$ada_perlawanan = $this->perkara->get_data_perlawanan($idperkara);
			if(intval($ada_perlawanan)>0){
				$data['ada_perlawanan']=1;
			}
			if($result!=''){
				if($result->num_rows()>0){
					foreach ($result->result() as $row) {
						$data['tgl_dismissal'] = $row->tanggal_penetapan;
						$data['hasil_dismissal'] = $row->hasil;
						$data['isi_dismissal'] = $row->amar;
						$data['pemberitahuan_penggugat'] = $row->pemberitahuan_penggugat;
						$data['pemberitahuan_tergugat'] = $row->pemberitahuan_tergugat;
						$data['tgl_minutasi'] = $row->tanggal_minutasi;
					}
				}
			}			
		}
		$this->load->vars($data);
		$this->load->view('dismissal/dismissal_tab');
	}

	function validateDelete(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(empty($idperkara) OR intval($idperkara)<1){
			show_404();
		}
		
		$this->load->model('perkara/dismissal','perkara');
		$result = $this->perkara->deleteData($idperkara);
		if($result===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Penetapan Dismissal Gagal Dihapus'));
			return;
		}
		echo json_encode(array('st'=>1,'msg'=>'Penetapan Dismissal Berhasil Dihapus'));
		return;

	}
	function validatePanggilDelete(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$id = $this->encrypt->decode(base64_decode($this->input->post('encid',TRUE)));
		if(empty($id) OR intval($id)<1){
			show_404();
		}
		
		$this->load->model('perkara/dismissal','perkara');
		$info_last_panggilan = $this->perkara->get_panggilan_tun($id);
		if($info_last_panggilan!=''){
			if($info_last_panggilan->num_rows()<2){
				foreach ($info_last_panggilan->result() as $row) {
					$idperkara = $row->perkara_id;
				}
				$info_last_perkara_dis = $this->perkara->get_data_dismissal_tun($idperkara);
				if($info_last_perkara_dis!=''){
					if($info_last_perkara_dis->num_rows()<1){
						$data_add = array(
							'perkara_id' => $idperkara,							
							'diinput_oleh' => $this->session->userdata('username'),
							'diinput_tanggal' => date("Y-m-d h:i:s",time())					
						);
						$result = $this->perkara->add_panggil_hapus($data_add);	
					}
				}
			}
		}
		$result = $this->perkara->dell_data_panggilan_dismissal($id);
		if($result===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Panggilan Dismissal Gagal Dihapus'));
			return;
		}
		echo json_encode(array('st'=>1,'msg'=>'Panggilan Dismissal Berhasil Dihapus'));
		return;

	}

	function pen_pemberitahuan($enc){
		$data['enc'] = $enc;
		$idperkara = $this->encrypt->decode(base64_decode($enc));
		if(empty($idperkara) OR intval($idperkara)<1){
			show_404();
		}
		$data['idperkara'] = $idperkara;
		$idalurperkara = $this->tanggalhelper->getIDAlurPerkara($idperkara);
		$data['idalurperkara'] = $idalurperkara;
		$this->load->model('perkara/dismissal','perkara');
		$data['enc']=base64_encode($this->encrypt->encode($idperkara));
		$data['tgl_sekarang'] = date('d/m/Y');
		$data['nomor_perkara']='';
		$data['tanggal_pendaftaran']='';
		
		$result = $this->perkara->get_data_perkara($idperkara);
		if($result!=''){
			if($result->num_rows()>0){
				foreach ($result->result() as $row) {
					$data['nomor_perkara'] = $row->nomor_perkara;
					$data['tanggal_pendaftaran'] = $row->tanggal_pendaftaran;
				}
			}else{
				$this->error_page->show_error_msg('Error Found','Tidak ada Perkara');
				exit();
			}
		}
		$data['tgl_dismissal'] = '';
		$data['isi_dismissal'] = '';
		$data['tgl_minutasi'] = '';				
		if($idalurperkara==8){
			$result = $this->perkara->get_data_dismissal($idperkara);
			if($result!=''){
				if($result->num_rows()>0){
					foreach ($result->result() as $row) {
						$data['tgl_dismissal'] = $row->tanggal_putusan;
						$data['isi_dismissal'] = $row->amar_putusan;
						$data['tgl_minutasi'] = $row->tanggal_minutasi;
					}
				}
			}
		}elseif($idalurperkara==9){
			$result = $this->perkara->get_data_dismissal_tun($idperkara);
			$data['ada_perlawanan']=0;
			$ada_perlawanan = $this->perkara->get_data_perlawanan($idperkara);
			if(intval($ada_perlawanan)>0){
				$data['ada_perlawanan']=1;
			}
			$cek = $this->perkara->get_data_dismissal($idperkara)->result();
			if(!empty($cek)){
				$data['cekminutasi'] = $cek[0]->tanggal_putusan;
			}else{
				$data['cekminutasi'] = '';
			}						
			if($result!=''){
				if($result->num_rows()>0){
					foreach ($result->result() as $row) {
						$data['tgl_dismissal'] = $row->tanggal_penetapan;
						$data['isi_dismissal'] = $row->amar;
						$data['pemberitahuan_penggugat'] = $row->pemberitahuan_penggugat;
						$data['pemberitahuan_tergugat'] = $row->pemberitahuan_tergugat;
						$data['tgl_minutasi'] = $row->tanggal_minutasi;
					}
				}
			}
		}

		$data['pihak_pertama'] = $this->perkara->getPihak($idperkara,1);
		$data['pihak_kedua'] = $this->perkara->getPihak($idperkara,2);
		$this->load->vars($data);		
		if($idalurperkara==8){
			$this->load->view('dismissal/penetapan_dismissal_form_pemberitahuan');
		}elseif($idalurperkara==9){
			$this->load->view('dismissal/pemberitahuan_dismissal_tun');
		}
		
	}

	function validateDate($tanggal,$idperkara){
		$curr_date = date('Y-m-d');
		$todayDate = date('d/m/Y');

		$selisih = $this->tanggalhelper->getSelisihHari($tanggal,$curr_date);
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Penetapan Dismissal Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
			return;
		}

		$dayname = $this->tanggalhelper->getDayName($tanggal);
		if($dayname=='Saturday' OR $dayname=='Sunday'){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pemberitahuan Penetapan Dismissal Dihari Libur, Sabtu dan Minggu.'));
			return;
		}

		$tglpendaftaran = $this->tanggalhelper->getTanggalPendaftaran($idperkara);
		$selisih = $this->tanggalhelper->getSelisihHari($tglpendaftaran,$tanggal);
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Penetapan Dismissal Tidak Boleh Kurang dari Tanggal Pendaftaran Perkara.'));
			return;
		}
		return TRUE;
	}

	function validatePemberitahuanInput(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Invalid Data.'));
			return;
		}

		

		$this->load->model('perkara/dismissal','perkara');
		$i=0;
		
		$data_pemberitahuan = array();

		$pihak_pertama = $this->perkara->getPihak($idperkara,1);
		if($pihak_pertama->num_rows>0){
			foreach ($pihak_pertama->result() as $row) {
				$data_pemberitahuan[$i] = array(
					'perkara_id' =>$idperkara,
					'putusan_akhir' =>2,
					'pihak' =>1,
					'pihak_id' =>$row->id,

					);
				$input_name = 'pem_pihak_1_'.$row->id;
				$tgl_pemberitahuan = $this->input->post($input_name,TRUE);
				if(!empty($tgl_pemberitahuan)){
					$tgl_pemberitahuan = $this->tanggalhelper->convertToMysqlDate($tgl_pemberitahuan);
					if($this->validateDate($tgl_pemberitahuan,$idperkara)){
						$date = $tgl_pemberitahuan;
					}else{
						return;
					}
				}else{
					$date = NULL;
				}
				$data_pemberitahuan[$i] = array(
					'perkara_id' =>$idperkara,
					'putusan_akhir' =>2,
					'pihak' =>1,
					'pihak_id' =>$row->id,
					'tanggal_pemberitahuan_putusan' =>$date,
				);
				$i++;
			}
		}
		
		$pihak_kedua = $this->perkara->getPihak($idperkara,2);
		if($pihak_kedua->num_rows>0){
			foreach ($pihak_kedua->result() as $row) {
				$data_pemberitahuan[$i] = array(
					'perkara_id' =>$idperkara,
					'putusan_akhir' =>2,
					'pihak' =>2,
					'pihak_id' =>$row->id,

					);
				$input_name = 'pem_pihak_2_'.$row->id;
				$tgl_pemberitahuan = $this->input->post($input_name,TRUE);
				if(!empty($tgl_pemberitahuan)){
					$tgl_pemberitahuan = $this->tanggalhelper->convertToMysqlDate($tgl_pemberitahuan);
					if($this->validateDate($tgl_pemberitahuan,$idperkara)){
						$date = $tgl_pemberitahuan;
					}else{
						return;
					}
				}else{
					$date = NULL;
				}
				$data_pemberitahuan[$i] = array(
					'perkara_id' =>$idperkara,
					'putusan_akhir' =>2,
					'pihak' =>2,
					'pihak_id' =>$row->id,
					'tanggal_pemberitahuan_putusan' =>$date,
				);
				$i++;
			}
		}

		$tgl_minutasi = $this->input->post('tgl_minutasi',TRUE);
		if(!empty($tgl_minutasi)){
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');
			$tgl_minutasi = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_minutasi',TRUE));
			
			$selisih = $this->tanggalhelper->getSelisihHari($tgl_minutasi,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Minutasi Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tgl_minutasi);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Minutasi Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglpendaftaran = $this->tanggalhelper->getTanggalPendaftaran($idperkara);

			$selisih = $this->tanggalhelper->getSelisihHari($tglpendaftaran,$tgl_minutasi);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Minutasi Tidak Boleh Kurang dari Tanggal Pendaftaran Perkara.'));
				return;
			}
						
		}else{
			$tgl_minutasi = NULL;
		}	
		$data_add = array(
				'perkara_id' =>$idperkara,
				'tanggal_minutasi' => $tgl_minutasi,
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
				);

		$result = $this->perkara->update_minutasi($idperkara,$data_add);
		$result = $this->perkara->add_pemberitahuan_dismissal($data_pemberitahuan);
		
		if($result===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Data Pemberitahuan Dismissal Gagal Disimpan'));
			return;
		}
		echo json_encode(array('st'=>1,'msg'=>'Data Pemberitahuan Dismissal Berhasil Disimpan'));
		return;
	}

	function validatePemberitahuanInputTun(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Invalid Data.'));
			return;
		}
		$this->form_validation->set_rules('tgl_beritahuP', 'Tanggal Pemberitahuan Penggugat', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('tgl_beritahuT', 'Tanggal Pemberitahuan Tergugat', 'trim|required|xss_clean|exact_length[10]');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$this->load->model('perkara/dismissal','perkara');		
			$tgl_pemberitahuan_penggugat = $this->input->post('tgl_beritahuP',TRUE);
			$tgl_pemberitahuan_tergugat = $this->input->post('tgl_beritahuT',TRUE);
			if(!empty($tgl_pemberitahuan_penggugat) || !empty($tgl_pemberitahuan_tergugat)){
				$curr_date = date('Y-m-d');
				$todayDate = date('d/m/Y');
				$tgl_penggugat = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_beritahuP',TRUE));
				$tgl_tergugat = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_beritahuT',TRUE));

				$selisihP = $this->tanggalhelper->getSelisihHari($tgl_penggugat,$curr_date);
				if($selisihP<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Penggugat Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
					return;
				}
				$selisihT = $this->tanggalhelper->getSelisihHari($tgl_tergugat,$curr_date);
				if($selisihT<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Tergugat Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
					return;
				}

				$daynameP = $this->tanggalhelper->getDayName($tgl_penggugat);
				if($daynameP=='Saturday' OR $daynameP=='Sunday'){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pemberitahuan Penggugat Dihari Libur, Sabtu dan Minggu.'));
					return;
				}
				$daynameT = $this->tanggalhelper->getDayName($tgl_tergugat);
				if($daynameT=='Saturday' OR $daynameT=='Sunday'){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pemberitahuan Tergugat Dihari Libur, Sabtu dan Minggu.'));
					return;
				}

				$tglpendaftaran = $this->tanggalhelper->getTanggalPendaftaran($idperkara);

				$selisihP = $this->tanggalhelper->getSelisihHari($tglpendaftaran,$tgl_penggugat);
				if($selisihP<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Penggugat Tidak Boleh Kurang dari Tanggal Pendaftaran Perkara.'));
					return;
				}
				$selisihT = $this->tanggalhelper->getSelisihHari($tglpendaftaran,$tgl_tergugat);
				if($selisihT<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Tergugat Tidak Boleh Kurang dari Tanggal Pendaftaran Perkara.'));
					return;
				}
				$tgl_penetapan = $this->perkara->add_tgl_penetapan_dis($idperkara)->row()->tanggal_penetapan;
				$selisihP = $this->tanggalhelper->getSelisihHari($tgl_penetapan,$tgl_penggugat);
				
				if($selisihP<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Penggugat Tidak Boleh Kurang dari Tanggal Penetapan Dismissal.'));
					return;
				}
				$selisihT = $this->tanggalhelper->getSelisihHari($tgl_penetapan,$tgl_tergugat);
				if($selisihT<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Tergugat Tidak Boleh Kurang dari Tanggal Penetapan Dismissal.'));
					return;
				}			
				$data_add = array(
					'perkara_id' =>$idperkara,
					'pemberitahuan_penggugat' => $tgl_penggugat,
					'pemberitahuan_tergugat' => $tgl_tergugat,
					'diperbaharui_oleh' => $this->session->userdata('username'),
					'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
					);		
				$result = $this->perkara->update_pemberitahuan_dismissal($idperkara,$data_add);	
			}
			$tgl_minutasi = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_minut',TRUE));
			if(!empty($tgl_minutasi)){
				$curr_date = date('Y-m-d');
				$todayDate = date('d/m/Y');
				
				$selisih = $this->tanggalhelper->getSelisihHari($tgl_minutasi,$curr_date);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Minutasi Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
					return;
				}

				$dayname = $this->tanggalhelper->getDayName($tgl_minutasi);
				if($dayname=='Saturday' OR $dayname=='Sunday'){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Minutasi Dihari Libur, Sabtu dan Minggu.'));
					return;
				}

				$tglpendaftaran = $this->tanggalhelper->getTanggalPendaftaran($idperkara);

				$selisih = $this->tanggalhelper->getSelisihHari($tglpendaftaran,$tgl_minutasi);			
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Minutasi Tidak Boleh Kurang dari Tanggal Pendaftaran Perkara.'));
					return;
				}
				$tglputusandismissal = $this->perkara->add_tgl_penetapan_dis($idperkara)->result();
				
				$tambah = array(
					'perkara_id' =>$idperkara,
					'tanggal_putusan' =>$tglputusandismissal[0]->tanggal_penetapan,
					'tanggal_minutasi' => $tgl_minutasi,
					'diperbaharui_oleh' => $this->session->userdata('username'),
					'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
					);									
				$datadismissal = $this->perkara->get_data_dismissal($idperkara)->result();				
				if(!empty($datadismissal)){
					$result = $this->perkara->update_minutasi($idperkara,$tambah);
				}else{						
					$result = $this->perkara->add_data_minutasi_dismissal_tun($tambah);
				}
			}else{		
				$tglputusandismissal = $this->perkara->add_tgl_penetapan_dis($idperkara)->result();		
				$tambah = array(
					'perkara_id' =>$idperkara,					
					'tanggal_putusan' =>$tglputusandismissal[0]->tanggal_penetapan,
					'diperbaharui_oleh' => $this->session->userdata('username'),
					'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
					);													
				$result = $this->perkara->dell_data_pemberitahuan_dismissal($idperkara);
				$result = $this->perkara->update_proses_setelah_hapus_minut($tambah);
			}	
		}	
		
		if($result===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Data Pemberitahuan Dismissal Gagal Disimpan'));
			return;
		}else{
			echo json_encode(array('st'=>1,'msg'=>'Data Pemberitahuan Dismissal Berhasil Disimpan'));
			return;
		}
	}
}