<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class detil_perkara_agama extends CI_Controller {
	function index(){
		#prevent direct access to page
		#the user should only access the page through menu
		if($this->nativesession->get_flash_session('security')==FALSE){
			redirect('main');
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$idperkara = $this->nativesession->get_flash_session('perkara_id');
		$tab_no = $this->nativesession->get_flash_session('tab_no');
		$this->nativesession->set_flash_session('tab_no', '');
		if(!is_numeric($idperkara)){
			redirect('main');
		}
		$isDataUmum = $this->nativesession->get_flash_session('open_dataumum');
		if($isDataUmum=="No"){
			$this->show_data($idperkara,$tab_no);
		}elseif($isDataUmum=="Yes"){
			$this->show_dataumum($idperkara);
		}
	}

	function show_data($idperkara, $tabs_no=''){
		$this->load->model('perkara/info_perkara_agama','perkara');
		$this->perkara->repair_riwayat_perkara_sidang_pertama($idperkara);
		$data = $this->parseData($this->perkara->getInfoPerkara($idperkara));
		$data['ada_barang_bukti']=$this->perkara->get_barang_bukti($idperkara);
		$data['alur_perkara_id']=$data['idalurperkara'];
		$data['perkaraid']=$idperkara;
		$data['tabs_no'] = $tabs_no;
		$data['pihak_pertama'] = $this->perkara->getInfoPihakPertama($idperkara);
		$data["ada_data_verzet"] = 0;
		$data["ada_data_intervensi"] = 0;
		$data["ada_data_diversi"] = 0;
		$data["ada_data_eksekusi"] = 0;
		$data['terdakwa_tidak_hadir'] = 0;
		$data['ada_data_rekonvensi'] = 0;
		$data["ada_data_banding"] = $this->perkara->getInfoBanding($idperkara);
		$data["ada_data_kasasi"] = $this->perkara->getInfoKasasi($idperkara);
		$data["ada_data_PK"] = $this->perkara->getInfoPK($idperkara);
		$data["ada_data_grasi"] = '';
		$data['isVerstek'] = '';
		$data["ada_data_dismissal"] = 0;
		$data["ada_data_gugur"] = 0;
		$data['pihak_kedua'] = $this->perkara->getInfoPihakKedua($idperkara);
		$data['is_ikrar_talak'] = 0;
		$data['is_already_ikrar'] = 0;
		$data['is_islam_ikrar'] = 0;
		$data['ada_akta_cerai'] = 0;
		$data['ada_penyebab_cerai'] = 0;		
		$data['ada_keadaan_istri'] = 0;
		$data['statusIkrarTalak'] =0;
		$data['statusPutusan'] =0;
		$data["kehadiran_pihak"] = 0;
		$data['cekStatusPihakHadir'] = 0;
		if($data['idalurperkara']<100){			
			$data['pihak_keempat'] = $this->perkara->getInfoPihakKeempat($idperkara);
			$data["ada_data_verzet"] = $this->perkara->getInfoVerzet($idperkara);
			$data["ada_data_intervensi"] = $this->perkara->getInfoIntervensi($idperkara);
			$data["ada_data_eksekusi"] = $this->perkara->getInfoEksekusi($idperkara);
			if($data['idProses']>=200){
				$data['isVerstek'] = $this->perkara->getInfoVerstek($idperkara);
				$data['is_ikrar_talak'] = $this->perkara->getInfoIkrarTalak($idperkara);
				$data['is_already_ikrar'] = $this->perkara->getInfoTanggalIkrar($idperkara);
				$data['is_islam_ikrar'] = $this->perkara->getInfoAgamaPeCT($idperkara);
				$data['ada_akta_cerai'] = $this->perkara->getInfoTanggalAktaCerai($idperkara);
				$data['ada_penyebab_cerai'] = $this->perkara->getInfoPenyebabCerai($idperkara);
				$data['ada_keadaan_istri'] = $this->perkara->getInfoKeadaanIstri($idperkara);
				$data['statusPutusan'] = $this->perkara->getInfoPutusan($idperkara);
				$ikrarTalak = $this->perkara->getInfoPenetapanIkrarTalak($idperkara);
				
				if(!empty($ikrarTalak)){
					if($ikrarTalak->num_rows>0){
						foreach ($ikrarTalak->result() as $row) {
							$data['statusIkrarTalak'] = $row->status_penetapan_ikrar_talak_id;
						}
					}
                }

                if ($data['jenis_perkara_id']==346) {
                    if ($data['is_islam_ikrar'] <> 1) {
                        $data['statusIkrarTalak'] = 1;
                        $data['is_already_ikrar'] = 1;
                    }
                }
			}
			$data['terdakwa_tidak_hadir'] = $this->perkara->getInfoTerdakwaTidakHadir($idperkara,1);
			$data['ada_data_rekonvensi'] = $this->perkara->getInfoRekonvensi($idperkara);
			$statusPihakHadir = $this->perkara->cekStatusPihakHadir($idperkara);
			$lasStatusPihak = $statusPihakHadir->row(($statusPihakHadir->num_rows())-1);
			if(!empty($lasStatusPihak)){
				$data['cekStatusPihakHadir'] = $lasStatusPihak->dihadiri_oleh;								
			}
		}else{
			$data["is_dibuka_kembali"] = 0;
			$data["ada_data_diversi"] = $this->perkara->getInfoDiversi($idperkara);
			if($data["ada_data_diversi"]>0){
				$data["is_dibuka_kembali"] = $this->perkara->getStatusDiversi($idperkara);;
			}
			$data['terdakwa_tidak_hadir'] = $this->perkara->getInfoTerdakwaTidakHadir($idperkara);
			$data["ada_data_grasi"] = $this->perkara->getInfoGrasi($idperkara);
		}
		$data["kehadiran_pihak"] = $this->perkara->getInfoKehadiranPihak($idperkara);		
		$data["pengacara_pihak_pertama"] = $this->perkara->getInfoPengacara($idperkara,1,$data['idalurperkara']);
		$data["pengacara_pihak_kedua"] = $this->perkara->getInfoPengacara($idperkara,2,$data['idalurperkara']);
		$data["pengacara_pihak_keempat"] = $this->perkara->getInfoPengacara($idperkara,4,$data['idalurperkara']);
		$data["ada_data_saksi"] = $this->perkara->get_jumlah_saksi($idperkara);
		$data["is_jadwal_sidang"] = $this->perkara->is_jadwal_sidang($idperkara);
		
		$data['page_title'] = 'INFORMASI DETAIL PERKARA';
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		if($this->session->userdata('jenis_pengadilan')==1){
			$data['main_body'] = 'perkara/detil_perkara';
		} else if($this->session->userdata('jenis_pengadilan')==2){
			$data['main_body'] = 'perkara/detil_perkara_mil';
		} else if($this->session->userdata('jenis_pengadilan')==3){
			$data['main_body'] = 'perkara/detil_perkara_tun';
		} else if($this->session->userdata('jenis_pengadilan')==4){
			$data['main_body'] = 'perkara/detil_perkara_agama';
		} else {
			$data['main_body'] = 'perkara/detil_perkara';
		}
		$data['main_history'] = $this->nativesession->get('main_url_requested');
		$data['history'] = $this->nativesession->get_flash_session('url_requested');
		$data['info_ijin_cerai']=$this->perkara->info_ijin_cerai($idperkara);
		$info_pihak1=$this->perkara->getInfoPihakPertama($idperkara)->row();
		$data['pihak1_text']='';
		if (!empty($info_pihak1))$data['pihak1_text']=$info_pihak1->nama;
		// echo '<pre>';
		// print_r($data);
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}

	function show_dataumum($idperkara){
		$data['history'] = $this->nativesession->get_flash_session('url_requested');
		$this->load->model('perkara/info_perkara_agama','perkara');

		$data = $this->parseData($this->perkara->getInfoPerkara($idperkara));
		$data['ada_barang_bukti']=$this->perkara->get_barang_bukti($idperkara);
		$data['perkaraid']=$idperkara;		
		$data['pihak_pertama'] = $this->perkara->getInfoPihakPertama($idperkara);
		if($data['idalurperkara']==118){
			$data['pihak_kedua'] = $this->perkara->getInfoPerkaraAnak($idperkara);
			$data['pihak_korban'] = $this->perkara->getInfoKorbanAnak($idperkara);
		}else{
			$data['pihak_kedua'] = $this->perkara->getInfoPihakKedua($idperkara);
		}
		
		if($data['idalurperkara']<100){
			$data['pihak_keempat'] = $this->perkara->getInfoPihakKeempat($idperkara);
		}
		$data["pengacara_pihak_pertama"] = $this->perkara->getInfoPengacara($idperkara,1,$data['idalurperkara']);
		$data["pengacara_pihak_kedua"] = $this->perkara->getInfoPengacara($idperkara,2,$data['idalurperkara']);
		$data["pengacara_pihak_keempat"] = $this->perkara->getInfoPengacara($idperkara,4,$data['idalurperkara']);
		$data["ada_data_intervensi"] = $this->perkara->getInfoIntervensi($idperkara);
		$data["ada_data_diversi"] = $this->perkara->getInfoDiversi($idperkara);		

		
		if($data['idalurperkara']==15){				
			$data['info_ijin_cerai']=$this->perkara->info_ijin_cerai($idperkara);			
		}		

		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['alur_perkara_id']=$data['idalurperkara'];		
		$this->load->vars($data);
		$this->load->view('perkara_tab/data_umum');
	}

	function parseData($info_perkara){
		if($info_perkara!=''){
			if($info_perkara->num_rows>0){
				foreach ($info_perkara->result() as $row) {
					$data['idalurperkara'] = $row->alur_perkara_id;
					$data['jenis_perkara_id'] = $row->jenis_perkara_id;
					$data['noPerkara'] = $row->nomor_perkara;
					$data['noUrut'] = $row->nomor_urut_register;
					$data['tglSurat'] = $row->tanggal_surat;
					$data['noSurat'] = $row->nomor_surat;
					$data['idProses'] = $row->proses_terakhir_id;
					$data['prosesText'] = $row->proses_terakhir_text;
					$data['idTahapan'] = $row->tahapan_terakhir_id;
					$data['tahapanText'] = $row->tahapan_terakhir_text;
					$data['pihak1'] = $row->pihak1_text;
					$data['pihak2'] = $row->pihak2_text;
					$data['tglPendaftaran'] = $row->tanggal_pendaftaran;
					$data['statuTerakhir'] = $row->proses_terakhir_text;
					$data['tglPutusan'] = $row->tanggal_putusan;
					$data['jenisPerkara'] = $row->jenis_perkara_nama;
					$data['isPublish'] = ($row->pihak_dipublikasikan=='Y')? 'Ya':'Tidak';
					$data['petitum'] = $row->petitum;
					$data['posita'] = $row->posita;
					$data['nilai_sengketa'] = number_format($row->nilai_sengketa,2,",",".");
					$data['petitum_dok'] = $row->petitum_dok;
					$data['dakwaan'] = $row->dakwaan;
					$data['dakwaan_dok'] = $row->dakwaan_dok;
					$data['prodeo'] = ($row->prodeo=='1')? 'Ya':'Tidak';
					$data['ada_data_penuntutan'] = !empty($row->tanggal_penuntutan)?1:0;
					$data['ada_data_putusan_sela'] = !empty($row->tanggal_putusan_sela)?1:0;
					$data['sudah_putusan'] = 0;
					$data['ada_data_mediasi'] = !empty($row->is_mediasi)?1:0;
					$data['hasil_mediasi'] = !empty($row->keputusan_mediasi)?1:0;
					$data['ada_data_umum']=0;
					if(!empty($row->tanggal_putusan) && $row->amar_putusan!=''){
						$data['sudah_putusan']=1;
					}
					if (!empty($row->pihak1_text) && !empty($row->pihak2_text)){
						if ($row->alur_perkara_id<100){
							if (!empty($row->petitum)){
								$data['ada_data_umum']=1;
							}
						}else if ($row->alur_perkara_id==119 ){
							if (!empty($row->dakwaan)){
								$data['ada_data_umum']=1;
							}
						}else if ($row->alur_perkara_id>100){
							if (!empty($row->dakwaan) && !empty($row->tanggal_surat) && !empty($row->nomor_surat)){
								$data['ada_data_umum']=1;
							}
						}
					}else if($row->alur_perkara_id==16){
						if (!empty($row->petitum) && !empty($row->pihak1_text)){
								$data['ada_data_umum']=1;
							}
					}
					if ($row->tanggal_bht!=''){
						$data['tgl_bht']=$this->tanggalhelper->convertDayDate($row->tanggal_bht);
					}else{
						$data['tgl_bht']='';
					}
					
					if(!empty($row->tgl_nikah)){
						$data['tgl_nikah']=$this->tanggalhelper->convertDayDate($row->tgl_nikah);
					}else{
						$data['tgl_nikah']='';
					}
					if(!empty($row->tgl_kutipan_akta_nikah)){
						$data['tgl_kutipan_akta_nikah']=$this->tanggalhelper->convertDayDate($row->tgl_kutipan_akta_nikah);
					}else{
						$data['tgl_kutipan_akta_nikah']='';
					}
					if(!empty($row->no_kutipan_akta_nikah)){
						$data['no_kutipan_akta_nikah']=$row->no_kutipan_akta_nikah;
					}else{
						$data['no_kutipan_akta_nikah']='';
					}
					if(!empty($row->kua_tempat_nikah)){
						$data['kua_tempat_nikah']=$row->kua_tempat_nikah;
					}else{
						$data['kua_tempat_nikah']='';
					}
				}
			}
		}
		return $data;
	}

	function manage_bht($enc){
		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$data['enc']=$enc;
		$data['perkara_id']=$this->encrypt->decode(base64_decode($enc));
		$this->load->model('perkara/info_perkara','perkara');
		$result = $this->perkara->getInfoPerkara($data['perkara_id'])->result();
		$tgl_bht=($result[0]->tanggal_bht);
		if ($tgl_bht!=''){
			$data['act']='edit';
			$data['tgl_bht']=$tgl_bht;
		}else{
			$data['act']='add';
			$data['tgl_bht']='';
		}
		$this->load->view('perkara/edit_bht', $data);
	}

	function validation_tgl_bht($act){
		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$this->form_validation->set_rules('tgl_bht', 'Tanggal BHT', 'trim|required|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			//echo $act;
			$enc=$this->input->post('enc',true);
			$tgl_bht=$this->tanggalhelper->convertToMysqlDate(trim($this->input->post('tgl_bht',true)));
			if($tgl_bht==false){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}
			$perkara_id=$this->encrypt->decode(base64_decode($enc));
			$this->load->model('perkara/info_perkara','perkara');
			$result = $this->perkara->getInfoPerkara($perkara_id)->result();
			$tanggal_minutasi=($result[0]->tanggal_minutasi);
			if ($tgl_bht<$tanggal_minutasi){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tanggal BHT Tidak Boleh Kurang Dari Tanggal Minutasi'));
				return;
			}
			//print_r($this->input->post());
			if($this->perkara->update_bht($tgl_bht,$perkara_id)){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan yooooo'));
			}else{
				echo json_encode(array('st'=>0,'msg'=>'ERROR SIMPAN KE DATABASE'));
			}
		}
	}
}
/* End of file detil_perkara.php */
/* Location: ./application/controllers/detil_perkara.php */