<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Update_database extends CI_Model{
	function __construct(){
		$this->run_this();
	}

	function isColumnExist($table_name,$column_name){
		try {
			$result = $this->db->query('
				SELECT COLUMN_NAME AS colname
			    FROM information_schema.columns 
			    WHERE TABLE_NAME = "'.$table_name.'"
			    AND COLUMN_NAME = "'.$column_name.'" AND TABLE_SCHEMA = "'.$this->db->database.'" 
			    GROUP BY column_name;
				');
			if($result->num_rows>0){
				return $result->row()->colname;
			}else{
				return '';
			}
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function run_this(){
		//script update database disini

        
        $this->db->query("SET FOREIGN_KEY_CHECKS=0;");
        $this->db->query("SET SQL_MODE='ALLOW_INVALID_DATES';");
 		

		$this->db->query("UPDATE perkara_akta_cerai SET nomor_akta_cerai = CONCAT(split_string(nomor_akta_cerai,'/',1),'/AC/',split_string(nomor_akta_cerai,'/',3),'/',(SELECT VALUE FROM sys_config WHERE id = 61))
		WHERE nomor_akta_cerai IS NOT NULL AND nomor_akta_cerai NOT LIKE CONCAT('%',(SELECT VALUE FROM sys_config WHERE id = 61));");

  		$cekkolom = $this->isColumnExist('perkara_akta_cerai','blangko_akta_cerai');
        if(!$cekkolom){
			$this->db->query("ALTER TABLE `perkara_akta_cerai` ADD COLUMN `blangko_akta_cerai` TINYINT(1) DEFAULT 0 NULL AFTER `akta_cerai_dok`;");
        }  

  		$cekkolom = $this->isColumnExist('perkara_lalulintas','tanggal_penindakan');
        if(!$cekkolom){
			$this->db->query("ALTER TABLE perkara_lalulintas ADD COLUMN tanggal_penindakan DATE NULL  COMMENT 'Tanggal Kejadian Penilangan' AFTER ditilang_oleh;");
        }   

  		$cekkolom = $this->isColumnExist('perkara_lalulintas','form_tilang');
        if(!$cekkolom){
			$this->db->query("ALTER TABLE perkara_lalulintas ADD COLUMN form_tilang VARCHAR(6) NULL  COMMENT 'Warna Form Tilang (Merah, Biru)' AFTER masa_berlaku_stnk;");
        }   

  		$cekkolom = $this->isColumnExist('perkara_lalulintas','nomor_pembayaran');
        if(!$cekkolom){
			$this->db->query("ALTER TABLE perkara_lalulintas ADD COLUMN nomor_pembayaran VARCHAR(20) NULL  COMMENT 'Nomor BRI Virtual Account' AFTER form_tilang;");
        }   

  		$cekkolom = $this->isColumnExist('perkara_lalulintas','kode_satker_polri');
        if(!$cekkolom){
			$this->db->query("ALTER TABLE perkara_lalulintas ADD COLUMN kode_satker_polri VARCHAR(6) NULL  COMMENT 'Kode Satker Polri' AFTER nomor_pembayaran;");
        }   

  		$cekkolom = $this->isColumnExist('perkara_lalulintas','deskripsi_kantor_polisi');
        if(!$cekkolom){
			$this->db->query("ALTER TABLE perkara_lalulintas ADD COLUMN deskripsi_kantor_polisi VARCHAR(100) NULL  COMMENT 'Deskripsi Kantor Polisi' AFTER kode_satker_polri;");
        }   

  		$cekkolom = $this->isColumnExist('perkara_lalulintas','uang_titipan');
        if(!$cekkolom){
			$this->db->query("ALTER TABLE perkara_lalulintas ADD COLUMN uang_titipan DECIMAL(16,2) NULL  COMMENT 'Uang Titipan Pelanggar' AFTER deskripsi_kantor_polisi;");
        }   

  		$cekkolom = $this->isColumnExist('perkara_lalulintas','kode_satker_kejaksaan');
        if(!$cekkolom){
			$this->db->query("ALTER TABLE perkara_lalulintas ADD COLUMN kode_satker_kejaksaan VARCHAR(5) NULL  COMMENT 'Kode Satker Kejaksaan (2 digit depan Kejati, 2 digit belakang Kejari)' AFTER uang_titipan;");
        }   

  		$cekkolom = $this->isColumnExist('perkara_lalulintas','tanggal_bayar');
        if(!$cekkolom){
			$this->db->query("ALTER TABLE perkara_lalulintas ADD COLUMN tanggal_bayar DATE NULL  COMMENT 'Tanggal Pembayaran)' AFTER kode_satker_kejaksaan;");
        }
        
		$this->db->query("REPLACE INTO status_putusan (id,jenis_perkara_id,nama,keterangan,aktif,urutan,satuan,jenis_pengadilan) VALUES ('88','2','Biaya Perkara','Perkara Lalulintas','N','98','2','1');");

  		$this->db->query("DROP TABLE IF EXISTS kejaksaan_tinggi;");

  		$this->db->query("CREATE TABLE `kejaksaan_tinggi`(  
						  `id` INT NOT NULL AUTO_INCREMENT,
						  `kode` CHAR(3) NOT NULL,
						  `nama` VARCHAR(150),
						  `aktif` CHAR(1),
						  PRIMARY KEY (`id`, `kode`)
						) ENGINE=INNODB;");

		$this->db->query("REPLACE INTO kejaksaan_tinggi (id,kode,nama,aktif) VALUES (1,'01','KEJAKSAAN TINGGI ACEH','Y');");
		$this->db->query("REPLACE INTO kejaksaan_tinggi (id,kode,nama,aktif) VALUES (2,'02','KEJAKSAAN TINGGI SUMATERA UTARA','Y');");
		$this->db->query("REPLACE INTO kejaksaan_tinggi (id,kode,nama,aktif) VALUES (3,'03','KEJAKSAAN TINGGI SUMATERA BARAT','Y');");
		$this->db->query("REPLACE INTO kejaksaan_tinggi (id,kode,nama,aktif) VALUES (4,'04','KEJAKSAAN TINGGI RIAU','Y');");
		$this->db->query("REPLACE INTO kejaksaan_tinggi (id,kode,nama,aktif) VALUES (5,'05','KEJAKSAAN TINGGI JAMBI','Y');");
		$this->db->query("REPLACE INTO kejaksaan_tinggi (id,kode,nama,aktif) VALUES (6,'06','KEJAKSAAN TINGGI SUMATERA SELATAN','Y');");
		$this->db->query("REPLACE INTO kejaksaan_tinggi (id,kode,nama,aktif) VALUES (7,'07','KEJAKSAAN TINGGI BENGKULU','Y');");
		$this->db->query("REPLACE INTO kejaksaan_tinggi (id,kode,nama,aktif) VALUES (8,'08','KEJAKSAAN TINGGI LAMPUNG','Y');");
		$this->db->query("REPLACE INTO kejaksaan_tinggi (id,kode,nama,aktif) VALUES (9,'09','KEJAKSAAN TINGGI D.K.I JAKARTA','Y');");
		$this->db->query("REPLACE INTO kejaksaan_tinggi (id,kode,nama,aktif) VALUES (10,'10','KEJAKSAAN TINGGI JAWA BARAT','Y');");
		$this->db->query("REPLACE INTO kejaksaan_tinggi (id,kode,nama,aktif) VALUES (11,'11','KEJAKSAAN TINGGI JAWA TENGAH','Y');");
		$this->db->query("REPLACE INTO kejaksaan_tinggi (id,kode,nama,aktif) VALUES (12,'12','KEJAKSAAN TINGGI D.I. YOGYAKARTA','Y');");
		$this->db->query("REPLACE INTO kejaksaan_tinggi (id,kode,nama,aktif) VALUES (13,'13','KEJAKSAAN TINGGI JAWA TIMUR','Y');");
		$this->db->query("REPLACE INTO kejaksaan_tinggi (id,kode,nama,aktif) VALUES (14,'14','KEJAKSAAN TINGGI KALIMANTAN BARAT','Y');");
		$this->db->query("REPLACE INTO kejaksaan_tinggi (id,kode,nama,aktif) VALUES (15,'15','KEJAKSAAN TINGGI KALIMANTAN TENGAH','Y');");
		$this->db->query("REPLACE INTO kejaksaan_tinggi (id,kode,nama,aktif) VALUES (16,'16','KEJAKSAAN TINGGI KALIMANTAN SELATAN','Y');");
		$this->db->query("REPLACE INTO kejaksaan_tinggi (id,kode,nama,aktif) VALUES (17,'17','KEJAKSAAN TINGGI KALIMANTAN TIMUR','Y');");
		$this->db->query("REPLACE INTO kejaksaan_tinggi (id,kode,nama,aktif) VALUES (18,'18','KEJAKSAAN TINGGI SULAWESI UTARA','Y');");
		$this->db->query("REPLACE INTO kejaksaan_tinggi (id,kode,nama,aktif) VALUES (19,'19','KEJAKSAAN TINGGI SULAWESI TENGAH','Y');");
		$this->db->query("REPLACE INTO kejaksaan_tinggi (id,kode,nama,aktif) VALUES (20,'20','KEJAKSAAN TINGGI SULAWESI TENGGARA','Y');");
		$this->db->query("REPLACE INTO kejaksaan_tinggi (id,kode,nama,aktif) VALUES (21,'21','KEJAKSAAN TINGGI SULAWESI SELATAN','Y');");
		$this->db->query("REPLACE INTO kejaksaan_tinggi (id,kode,nama,aktif) VALUES (22,'22','KEJAKSAAN TINGGI BALI','Y');");
		$this->db->query("REPLACE INTO kejaksaan_tinggi (id,kode,nama,aktif) VALUES (23,'23','KEJAKSAAN TINGGI NUSA TENGGARA BARAT','Y');");
		$this->db->query("REPLACE INTO kejaksaan_tinggi (id,kode,nama,aktif) VALUES (24,'24','KEJAKSAAN TINGGI NUSA TENGGARA TIMUR','Y');");
		$this->db->query("REPLACE INTO kejaksaan_tinggi (id,kode,nama,aktif) VALUES (25,'25','KEJAKSAAN TINGGI MALUKU','Y');");
		$this->db->query("REPLACE INTO kejaksaan_tinggi (id,kode,nama,aktif) VALUES (26,'26','KEJAKSAAN TINGGI PAPUA','Y');");
		$this->db->query("REPLACE INTO kejaksaan_tinggi (id,kode,nama,aktif) VALUES (27,'27','KEJAKSAAN TINGGI MALUKU UTARA','Y');");
		$this->db->query("REPLACE INTO kejaksaan_tinggi (id,kode,nama,aktif) VALUES (28,'28','KEJAKSAAN TINGGI BANTEN','Y');");
		$this->db->query("REPLACE INTO kejaksaan_tinggi (id,kode,nama,aktif) VALUES (29,'29','KEJAKSAAN TINGGI KEPULAUAN BANGKA BELITUNG','Y');");
		$this->db->query("REPLACE INTO kejaksaan_tinggi (id,kode,nama,aktif) VALUES (30,'30','KEJAKSAAN TINGGI GORONTALO','Y');");
		$this->db->query("REPLACE INTO kejaksaan_tinggi (id,kode,nama,aktif) VALUES (31,'31','KEJAKSAAN TINGGI KEPULAUAN RIAU','Y');");

  		$this->db->query("DROP TABLE IF EXISTS kejaksaan_negeri;");

  		$this->db->query("CREATE TABLE `kejaksaan_negeri`(  
						  `id` INT(11) NOT NULL AUTO_INCREMENT,
						  `kode_kejati` CHAR(3),
						  `kode_kejari` CHAR(3),
						  `nama_instansi` VARCHAR(150),
						  `kode_satker_pn` VARCHAR(50),
						  `aktif` CHAR(1) NOT NULL DEFAULT 'Y',
						  `jenis_pengadilan` TINYINT(1) NOT NULL DEFAULT 1,
						  PRIMARY KEY (`id`, `aktif`, `jenis_pengadilan`)
						) ENGINE=INNODB;");


		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('01','01','KEJAKSAAN NEGERI BANDA ACEH','98441');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('01','02','KEJAKSAAN NEGERI SABANG','98455');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('01','03','KEJAKSAAN NEGERI PIDIE','98462');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('01','04','KEJAKSAAN NEGERI LHOKSEUMAWE','98497');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('01','05','KEJAKSAAN NEGERI LANGSA','98519');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('01','06','KEJAKSAAN NEGERI ACEH TENGAH','98502');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('01','07','KEJAKSAAN NEGERI ACEH BARAT','98565');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('01','08','KEJAKSAAN NEGERI ACEH SELATAN','98590');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('01','09','KEJAKSAAN NEGERI ACEH TENGGARA','98551');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('01','10','KEJAKSAAN NEGERI BIREUN','98476');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('01','11','KEJAKSAAN NEGERI ACEH UTARA','98480');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('01','12','KEJAKSAAN NEGERI ACEH TIMUR','98523');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('01','13','KEJAKSAAN NEGERI ACEH TAMIANG','98530');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('01','14','KEJAKSAAN NEGERI SIMEULU','98586');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('01','15','KEJAKSAAN NEGERI ACEH JAYA','98572');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('01','16','KEJAKSAAN NEGERI ACEH SINGKIL','98608');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('01','17','KEJAKSAAN NEGERI GAYO LUES','98544');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('01','18','KEJAKSAAN NEGERI ACEH BESAR','400415');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('01','19','KEJAKSAAN NEGERI ACEH BARAT DAYA','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('01','20','KEJAKSAAN NEGERI NAGAN RAYA','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('01','21','KEJAKSAAN NEGERI BENER MERIAH','673062');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('01','22','KEJAKSAAN NEGERI PIDIE JAYA','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('02','01','KEJAKSAAN NEGERI MEDAN','98629');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('02','02','KEJAKSAAN NEGERI BINJAI','98633');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('02','03','KEJAKSAAN NEGERI PEMATANG SIANTAR','98701');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('02','04','KEJAKSAAN NEGERI SIBOLGA','98739');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('02','05','KEJAKSAAN NEGERI DELI SERDANG ','400395');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('02','06','KEJAKSAAN NEGERI TEBING TINGGI','98682');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('02','07','KEJAKSAAN NEGERI TANJUNG BALAI ASAHAN','98640');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('02','08','KEJAKSAAN NEGERI LABUHAN BATU','98675');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('02','09','KEJAKSAAN NEGERI KARO','98661');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('02','10','KEJAKSAAN NEGERI DAIRI','98654');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('02','11','KEJAKSAAN NEGERI TAPANULI UTARA','98718');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('02','12','KEJAKSAAN NEGERI PADANG SIDEMPUAN','98722');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('02','13','KEJAKSAAN NEGERI GUNUNG SITOLI','98696');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('02','14','KEJAKSAAN NEGERI ASAHAN','400389');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('02','15','KEJAKSAAN NEGERI SIMALUNGUN','400370');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('02','16','KEJAKSAAN NEGERI LANGKAT','108025');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('02','17','KEJAKSAAN NEGERI BELAWAN','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('02','18','KEJAKSAAN NEGERI TOBA SAMOSIR','672910');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('02','19','KEJAKSAAN NEGERI MANDAILING NATAL','477399');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('02','20','KEJAKSAAN NEGERI SERDANG BEDAGAI','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('02','21','KEJAKSAAN NEGERI HUMBANG HASUNDUTAN','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('02','22','KEJAKSAAN NEGERI NIAS SELATAN','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('02','23','KEJAKSAAN NEGERI BATUBARA','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('02','24','KEJAKSAAN NEGERI SAMOSIR ','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('02','25','KEJAKSAAN NEGERI PADANG LAWAS UTARA','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('02','26','KEJAKSAAN NEGERI TAPANULI SELATAN','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('02','27','KEJAKSAAN NEGERI PADANG LAWAS','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('02','28','KEJAKSAAN NEGERI LABUHANBATU SELATAN','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('03','01','KEJAKSAAN NEGERI PADANG','98750');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('03','02','KEJAKSAAN NEGERI BUKIT TINGGI','98811');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('03','03','KEJAKSAAN NEGERI PAYAKUMBUH','98832');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('03','04','KEJAKSAAN NEGERI PARIAMAN','98792');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('03','05','KEJAKSAAN NEGERI SAWAHLUNTO','98764');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('03','06','KEJAKSAAN NEGERI SOLOK','98785');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('03','07','KEJAKSAAN NEGERI PADANG PANJANG','400188');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('03','08','KEJAKSAAN NEGERI TANAH DATAR','98771');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('03','09','KEJAKSAAN NEGERI PASAMAN','98828');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('03','10','KEJAKSAAN NEGERI PESISIR SELATAN','98807');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('03','11','KEJAKSAAN NEGERI SIJUNJUNG','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('03','12','KEJAKSAAN NEGERI AGAM','400333');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('03','13','KEJAKSAAN NEGERI KEPULAUAN MENTAWAI','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('03','14','KEJAKSAAN NEGERI PASAMAN BARAT','477352');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('03','15','KEJAKSAAN NEGERI DHARMAS RAYA','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('03','16','KEJAKSAAN NEGERI SOLOK SELATAN','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('04','01','KEJAKSAAN NEGERI PEKANBARU','98849');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('04','04','KEJAKSAAN NEGERI INDRAGIRI HULU','98860');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('04','05','KEJAKSAAN NEGERI DUMAI','400327');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('04','06','KEJAKSAAN NEGERI BENGKALIS','98853');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('04','07','KEJAKSAAN NEGERI INDRAGIRI HILIR','98874');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('04','08','KEJAKSAAN NEGERI KAMPAR','400141');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('04','09','KEJAKSAAN NEGERI ROKAN HULU','477255');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('04','10','KEJAKSAAN NEGERI SIAK','477343');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('04','13','KEJAKSAAN NEGERI KUANTAN SINGINGI','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('04','14','KEJAKSAAN NEGERI PELALAWAN','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('04','17','KEJAKSAAN NEGERI ROKAN HILIR','477261');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('04','18','KEJAKSAAN NEGERI KEPULAUAN MERANTI','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('05','01','KEJAKSAAN NEGERI JAMBI','98895');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('05','02','KEJAKSAAN NEGERI BATANGHARI','400430');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('05','03','KEJAKSAAN NEGERI BUNGO','98900');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('05','04','KEJAKSAAN NEGERI SUNGAI PENUH','98921');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('05','05','KEJAKSAAN NEGERI MERANGIN','400311');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('05','06','KEJAKSAAN NEGERI TANJUNG JABUNG BARAT','98917');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('05','07','KEJAKSAAN NEGERI SAROLANGUN','477374');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('05','08','KEJAKSAAN NEGERI TEBO','477368');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('05','09','KEJAKSAAN NEGERI TANJUNG JABUNG TIMUR','477400');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('05','10','KEJAKSAAN NEGERI MUARO JAMBI','663012');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('06','01','KEJAKSAAN NEGERI PALEMBANG','98942');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('06','02','KEJAKSAAN NEGERI OGAN KOMERING ILIR','98959');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('06','03','KEJAKSAAN NEGERI OGAN KOMERING ULU','98963');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('06','04','KEJAKSAAN NEGERI LAHAT','98984');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('06','05','KEJAKSAAN NEGERI LUBUK LINGGAU','98970');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('06','06','KEJAKSAAN NEGERI MUARA ENIM','98991');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('06','07','KEJAKSAAN NEGERI MUSI BANYUASIN','99003');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('06','08','KEJAKSAAN NEGERI PAGAR ALAM','672969');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('06','09','KEJAKSAAN NEGERI PRABUMULIH','672952');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('06','10','KEJAKSAAN NEGERI BANYUASIN','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('06','11','KEJAKSAAN NEGERI EMPAT LAWANG','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('06','13','KEJAKSAAN NEGERI PENUKAL ABAB LEMATANG ILIR','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('06','14','KEJAKSAAN NEGERI OGAN KOMERING ULU TIMUR','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('07','01','KEJAKSAAN NEGERI BENGKULU','400110');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('07','02','KEJAKSAAN NEGERI REJANG LEBONG','400126');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('07','03','KEJAKSAAN NEGERI BENGKULU UTARA','400239');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('07','04','KEJAKSAAN NEGERI BENGKULU SELATAN','400132');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('07','05','KEJAKSAAN NEGERI MUKOMUKO','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('07','06','KEJAKSAAN NEGERI SELUMA','673009');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('07','07','KEJAKSAAN NEGERI KAUR','672994');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('07','08','KEJAKSAAN NEGERI LEBONG','673055');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('07','09','KEJAKSAAN NEGERI KEPAHIANG','673041');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('08','01','KEJAKSAAN NEGERI BANDAR LAMPUNG','99031');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('08','02','KEJAKSAAN NEGERI LAMPUNG SELATAN ','400452');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('08','03','KEJAKSAAN NEGERI METRO','99045');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('08','04','KEJAKSAAN NEGERI LAMPUNG UTARA','99052');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('08','05','KEJAKSAAN NEGERI LAMPUNG BARAT','614883');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('08','06','KEJAKSAAN NEGERI LAMPUNG TENGAH','663030');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('08','07','KEJAKSAAN NEGERI LAMPUNG TIMUR','663047');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('08','08','KEJAKSAAN NEGERI WAY KANAN','663051');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('08','09','KEJAKSAAN NEGERI TULANG BAWANG','663026');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('08','10','KEJAKSAAN NEGERI TANGGAMUS','477306');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('09','01','KEJAKSAAN NEGERI JAKARTA PUSAT','97471');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('09','02','KEJAKSAAN NEGERI JAKARTA UTARA','400220');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('09','03','KEJAKSAAN NEGERI JAKARTA BARAT','97488');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('09','04','KEJAKSAAN NEGERI JAKARTA TIMUR','97492');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('09','05','KEJAKSAAN NEGERI JAKARTA SELATAN','400214');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('10','01','KEJAKSAAN NEGERI KOTA BANDUNG','97514');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('10','02','KEJAKSAAN NEGERI KOTA CIREBON','97670');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('10','03','KEJAKSAAN NEGERI KOTA BOGOR','97645');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('10','04','KEJAKSAAN NEGERI KOTA SUKABUMI','97652');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('10','05','KEJAKSAAN NEGERI PURWAKARTA','97603');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('10','06','KEJAKSAAN NEGERI GARUT','97542');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('10','07','KEJAKSAAN NEGERI KOTA TASIKMALAYA','97535');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('10','08','KEJAKSAAN NEGERI KOTA BEKASI','97610');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('10','09','KEJAKSAAN NEGERI KABUPATEN BOGOR','613519');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('10','10','KEJAKSAAN NEGERI KABUPATEN TASIKMALAYA','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('10','11','KEJAKSAAN NEGERI INDRAMAYU','97687');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('10','12','KEJAKSAAN NEGERI SUMEDANG','97521');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('10','13','KEJAKSAAN NEGERI KUNINGAN','97709');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('10','14','KEJAKSAAN NEGERI MAJALENGKA','97691');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('10','15','KEJAKSAAN NEGERI CIAMIS ','97556');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('10','16','KEJAKSAAN NEGERI KARAWANG','97624');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('10','17','KEJAKSAAN NEGERI CIANJUR','97666');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('10','18','KEJAKSAAN NEGERI SUBANG','97631');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('10','19','KEJAKSAAN NEGERI KABUPATEN CIREBON ','400477');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('10','20','KEJAKSAAN NEGERI KABUPATEN SUKABUMI','400409');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('10','21','KEJAKSAAN NEGERI DEPOK','477292');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('10','22','KEJAKSAAN NEGERI KABUPATEN BEKASI','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('10','23','KEJAKSAAN NEGERI KOTA BANJAR','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('10','24','KEJAKSAAN NEGERI KABUPATEN BANDUNG','400483');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('10','25','KEJAKSAAN NEGERI CIMAHI','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('11','01','KEJAKSAAN NEGERI KOTA SEMARANG','97720');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('11','02','KEJAKSAAN NEGERI SURAKARTA','97933');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('11','03','KEJAKSAAN NEGERI KOTA PEKALONGAN','97741');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('11','04','KEJAKSAAN NEGERI KOTA MAGELANG','97890');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('11','05','KEJAKSAAN NEGERI PURWOKERTO','98001');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('11','07','KEJAKSAAN NEGERI PATI','97762');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('11','08','KEJAKSAAN NEGERI CILACAP','98015');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('11','09','KEJAKSAAN NEGERI KUDUS','97755');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('11','10','KEJAKSAAN NEGERI KLATEN','97996');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('11','11','KEJAKSAAN NEGERI SALATIGA','97823');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('11','12','KEJAKSAAN NEGERI REMBANG','97865');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('11','13','KEJAKSAAN NEGERI PEMALANG','97780');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('11','14','KEJAKSAAN NEGERI PURBALINGGA','98036');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('11','15','KEJAKSAAN NEGERI PURWOREJO','97886');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('11','16','KEJAKSAAN NEGERI KEBUMEN','97908');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('11','17','KEJAKSAAN NEGERI SRAGEN','97940');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('11','18','KEJAKSAAN NEGERI KENDAL','97797');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('11','19','KEJAKSAAN NEGERI BLORA','97851');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('11','20','KEJAKSAAN NEGERI BOYOLALI','97982');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('11','21','KEJAKSAAN NEGERI BREBES','97776');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('11','22','KEJAKSAAN NEGERI DEMAK','97802');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('11','23','KEJAKSAAN NEGERI JEPARA','97844');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('11','24','KEJAKSAAN NEGERI KARANGANYAR','97975');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('11','25','KEJAKSAAN NEGERI SUKOHARJO','97961');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('11','26','KEJAKSAAN NEGERI WONOGIRI','97954');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('11','27','KEJAKSAAN NEGERI BANJAR NEGARA','98040');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('11','28','KEJAKSAAN NEGERI TEMANGGUNG','97912');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('11','29','KEJAKSAAN NEGERI WONOSOBO','97929');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('11','30','KEJAKSAAN NEGERI BANYUMAS','98022');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('11','31','KEJAKSAAN NEGERI BATANG','97872');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('11','32','KEJAKSAAN NEGERI GROBOGAN','97819');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('11','33','KEJAKSAAN NEGERI KABUPATEN SEMARANG','97830');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('11','34','KEJAKSAAN NEGERI KABUPATEN TEGAL','400565');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('11','35','KEJAKSAAN NEGERI KABUPATEN MAGELANG','400571');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('11','36','KEJAKSAAN NEGERI KOTA TEGAL','97734');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('11','37','KEJAKSAAN NEGERI KABUPATEN PEKALONGAN','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('12','01','KEJAKSAAN NEGERI YOGYAKARTA','98057');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('12','02','KEJAKSAAN NEGERI SLEMAN','98082');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('12','03','KEJAKSAAN NEGERI GUNUNG KIDUL ','98078');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('12','04','KEJAKSAAN NEGERI KULONPROGO','98061');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('12','05','KEJAKSAAN NEGERI BANTUL','400172');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','01','KEJAKSAAN NEGERI SURABAYA','98111');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','02','KEJAKSAAN NEGERI KOTA MALANG','98281');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','03','KEJAKSAAN NEGERI JEMBER','98200');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','04','KEJAKSAAN NEGERI KOTA KEDIRI','98235');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','05','KEJAKSAAN NEGERI KOTA MADIUN','400596');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','06','KEJAKSAAN NEGERI KOTA PASURUAN','98298');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','07','KEJAKSAAN NEGERI BOJONEGORO','98125');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','08','KEJAKSAAN NEGERI BONDOWOSO','98192');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','09','KEJAKSAAN NEGERI PAMEKASAN','98391');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','10','KEJAKSAAN NEGERI SIDOARJO','98167');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','11','KEJAKSAAN NEGERI KABUPATEN MOJOKERTO ','98171');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','12','KEJAKSAAN NEGERI KOTA PROBOLINGGO','98303');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','13','KEJAKSAAN NEGERI BANYUWANGI','98214');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','14','KEJAKSAAN NEGERI BLITAR','98277');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','15','KEJAKSAAN NEGERI JOMBANG','98188');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','16','KEJAKSAAN NEGERI PONOROGO','98352');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','17','KEJAKSAAN NEGERI GRESIK','98150');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','18','KEJAKSAAN NEGERI LUMAJANG','98310');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','19','KEJAKSAAN NEGERI TULUNG AGUNG','98256');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','20','KEJAKSAAN NEGERI TRENGGALEK','98260');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','21','KEJAKSAAN NEGERI NGANJUK','98242');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','22','KEJAKSAAN NEGERI MAGETAN','98387');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','23','KEJAKSAAN NEGERI TUBAN','98132');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','24','KEJAKSAAN NEGERI NGAWI','98370');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','25','KEJAKSAAN NEGERI SUMENEP','98409');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','26','KEJAKSAAN NEGERI LAMONGAN','98146');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','27','KEJAKSAAN NEGERI SAMPANG','98420');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','28','KEJAKSAAN NEGERI BANGKALAN','98413');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','29','KEJAKSAAN NEGERI PACITAN','98366');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','30','KEJAKSAAN NEGERI SITUBONDO','98221');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','31','KEJAKSAAN NEGERI KABUPATEN PASURUAN','98324');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','32','KEJAKSAAN NEGERI KABUPATEN PROBOLINGGO','98331');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','33','KEJAKSAAN NEGERI TANJUNG PERAK','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','34','KEJAKSAAN NEGERI KABUPATEN MALANG','626156');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','35','KEJAKSAAN NEGERI BATU','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','36','KEJAKSAAN NEGERI KABUPATEN KEDIRI','400580');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','38','KEJAKSAAN NEGERI KOTA MOJOKERTO','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('13','39','KEJAKSAAN NEGERI KABUPATEN MADIUN','98345');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('14','01','KEJAKSAAN NEGERI PONTIANAK','99066');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('14','02','KEJAKSAAN NEGERI SINGKAWANG','99070');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('14','03','KEJAKSAAN NEGERI SINTANG','99087');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('14','04','KEJAKSAAN NEGERI KETAPANG','99091');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('14','05','KEJAKSAAN NEGERI SANGGAU','99113');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('14','06','KEJAKSAAN NEGERI MEMPAWAH','99109');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('14','07','KEJAKSAAN NEGERI KAPUAS HULU ','400194');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('14','08','KEJAKSAAN NEGERI SAMBAS','670227');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('14','09','KEJAKSAAN NEGERI BENGKAYANG','670231');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('14','10','KEJAKSAAN NEGERI LANDAK','681450');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('14','11','KEJAKSAAN NEGERI SEKADAU','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('15','01','KEJAKSAAN NEGERI PALANGKARAYA','99120');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('15','02','KEJAKSAAN NEGERI KOTAWARINGIN TIMUR','99176');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('15','03','KEJAKSAAN NEGERI KAPUAS ','99155');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('15','04','KEJAKSAAN NEGERI BARITO UTARA','99141');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('15','05','KEJAKSAAN NEGERI KOTAWARINGIN BARAT','99134');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('15','06','KEJAKSAAN NEGERI BARITO SELATAN','99162');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('15','07','KEJAKSAAN NEGERI MURUNG RAYA','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('15','08','KEJAKSAAN NEGERI BARITO TIMUR','670191');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('15','09','KEJAKSAAN NEGERI GUNUNG MAS','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('15','10','KEJAKSAAN NEGERI PULANG PISAU','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('15','11','KEJAKSAAN NEGERI KATINGAN','672973');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('15','12','KEJAKSAAN NEGERI SERUYAN','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('15','13','KEJAKSAAN NEGERI SUKAMARA','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('15','14','KEJAKSAAN NEGERI LAMANDAU','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('16','01','KEJAKSAAN NEGERI BANJARMASIN','99197');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('16','02','KEJAKSAAN NEGERI HULU SUNGAI SELATAN','99202');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('16','03','KEJAKSAAN NEGERI KOTABARU','99219');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('16','04','KEJAKSAAN NEGERI KABUPATEN BANJAR','99230');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('16','05','KEJAKSAAN NEGERI HULU SUNGAI UTARA','99251');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('16','06','KEJAKSAAN NEGERI HULU SUNGAI TENGAH','99223');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('16','07','KEJAKSAAN NEGERI TABALONG','99244');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('16','08','KEJAKSAAN NEGERI TAPIN','99265');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('16','09','KEJAKSAAN NEGERI TANAH LAUT','400282');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('16','10','KEJAKSAAN NEGERI BARITO KUALA','400260');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('16','11','KEJAKSAAN NEGERI BANJARBARU','653458');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('16','12','KEJAKSAAN NEGERI TANAH BUMBU','670206');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('16','13','KEJAKSAAN NEGERI BALANGAN','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('17','01','KEJAKSAAN NEGERI BALIKPAPAN','99308');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('17','02','KEJAKSAAN NEGERI SAMARINDA','99286');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('17','03','KEJAKSAAN NEGERI KUTAI KARTANEGARA','99290');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('17','04','KEJAKSAAN NEGERI PASER','400302');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('17','05','KEJAKSAAN NEGERI BERAU ','400291');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('17','06','KEJAKSAAN NEGERI TARAKAN','99272');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('17','07','KEJAKSAAN NEGERI NUNUKAN','477270');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('17','08','KEJAKSAAN NEGERI BONTANG','662972');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('17','09','KEJAKSAAN NEGERI BULUNGAN','670170');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('17','10','KEJAKSAAN NEGERI KUTAI BARAT','477380');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('17','11','KEJAKSAAN NEGERI KUTAI TIMUR','662986');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('17','12','KEJAKSAAN NEGERI MALINAU','477286');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('17','13','KEJAKSAAN NEGERI PENAJAM PASER UTARA','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('18','01','KEJAKSAAN NEGERI MANADO','99329');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('18','02','KEJAKSAAN NEGERI MINAHASA','99354');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('18','03','KEJAKSAAN NEGERI KOTAMOBAGU','99333');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('18','04','KEJAKSAAN NEGERI KEPULAUAN SANGIHE','99340');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('18','05','KEJAKSAAN NEGERI BITUNG','568725');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('18','06','KEJAKSAAN NEGERI MINAHASA SELATAN','673034');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('18','07','KEJAKSAAN NEGERI TOMOHON','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('18','08','KEJAKSAAN NEGERI KEPULAUAN TALAUD','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('18','09','KEJAKSAAN NEGERI MINAHASA UTARA','670210');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('18','11','KEJAKSAAN NEGERI KEPULAUAN SIAU TAGULANDANG BIARO','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('18','13','KEJAKSAAN NEGERI BOLAANG MONGONDOW UTARA','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('19','01','KEJAKSAAN NEGERI PALU','99375');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('19','02','KEJAKSAAN NEGERI BANGGAI','99396');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('19','03','KEJAKSAAN NEGERI TOLI-TOLI','99382');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('19','04','KEJAKSAAN NEGERI POSO','99401');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('19','05','KEJAKSAAN NEGERI DONGGALA','477202');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('19','06','KEJAKSAAN NEGERI BANGGAI LAUT','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('19','07','KEJAKSAAN NEGERI PARIGI MOUTONG','672980');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('19','08','KEJAKSAAN NEGERI BUOL','670248');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('19','09','KEJAKSAAN NEGERI TOJO UNA-UNA','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('19','10','KEJAKSAAN NEGERI MOROWALI','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('20','01','KEJAKSAAN NEGERI KENDARI','99659');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('20','02','KEJAKSAAN NEGERI BAU-BAU','99663');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('20','03','KEJAKSAAN NEGERI KOLAKA','99684');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('20','04','KEJAKSAAN NEGERI MUNA','99670');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('20','05','KEJAKSAAN NEGERI KONAWE','477224');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('20','06','KEJAKSAAN NEGERI WAKATOBI','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('20','07','KEJAKSAAN NEGERI KOLAKA UTARA','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('20','08','KEJAKSAAN NEGERI KONAWE SELATAN','681440');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('20','09','KEJAKSAAN NEGERI BUTON','681444');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('20','10','KEJAKSAAN NEGERI BOMBANA','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('21','01','KEJAKSAAN NEGERI MAKASSAR','99422');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('21','02','KEJAKSAAN NEGERI PAREPARE','99492');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('21','03','KEJAKSAAN NEGERI BONE','99532');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('21','04','KEJAKSAAN NEGERI PALOPO','99600');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('21','05','KEJAKSAAN NEGERI GOWA ','99439');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('21','06','KEJAKSAAN NEGERI MAMUJU','99638');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('21','07','KEJAKSAAN NEGERI MAROS','99471');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('21','08','KEJAKSAAN NEGERI BANTAENG','99560');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('21','09','KEJAKSAAN NEGERI PINRANG','99528');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('21','10','KEJAKSAAN NEGERI WAJO','99553');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('21','11','KEJAKSAAN NEGERI SOPPENG','99549');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('21','12','KEJAKSAAN NEGERI BARRU','99450');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('21','13','KEJAKSAAN NEGERI BULUKUMBA','99581');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('21','14','KEJAKSAAN NEGERI JENEPONTO','99485');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('21','15','KEJAKSAAN NEGERI ENREKANG','99507');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('21','16','KEJAKSAAN NEGERI MAJENE','99621');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('21','17','KEJAKSAAN NEGERI TANA TORAJA','99617');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('21','18','KEJAKSAAN NEGERI PANGKAJENE KEPULAUAN','99443');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('21','19','KEJAKSAAN NEGERI SELAYAR','99595');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('21','20','KEJAKSAAN NEGERI POLEWALI MANDAR','99642');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('21','21','KEJAKSAAN NEGERI SIDENRENG-RAPPANG','99511');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('21','22','KEJAKSAAN NEGERI SINJAI','99574');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('21','23','KEJAKSAAN NEGERI TAKALAR','99464');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('21','24','KEJAKSAAN NEGERI LUWU UTARA','672927');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('21','25','KEJAKSAAN NEGERI MAMASA','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('21','26','KEJAKSAAN NEGERI LUWU','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('21','27','KEJAKSAAN NEGERI LUWU TIMUR','673013');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('21','28','KEJAKSAAN NEGERI MAMUJU UTARA','681422');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('22','01','KEJAKSAAN NEGERI DENPASAR','99780');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('22','02','KEJAKSAAN NEGERI BULELENG','99794');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('22','03','KEJAKSAAN NEGERI KLUNGKUNG','99816');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('22','04','KEJAKSAAN NEGERI BANGLI','99858');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('22','05','KEJAKSAAN NEGERI KARANGASEM','99837');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('22','06','KEJAKSAAN NEGERI GIANYAR','99841');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('22','07','KEJAKSAAN NEGERI JEMBRANA','99802');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('22','08','KEJAKSAAN NEGERI TABANAN','99820');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('23','01','KEJAKSAAN NEGERI MATARAM','99862');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('23','02','KEJAKSAAN NEGERI LOMBOK TENGAH','99912');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('23','03','KEJAKSAAN NEGERI LOMBOK TIMUR','99890');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('23','04','KEJAKSAAN NEGERI SUMBAWA','99883');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('23','05','KEJAKSAAN NEGERI BIMA','99879');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('23','06','KEJAKSAAN NEGERI DOMPU','99905');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('24','01','KEJAKSAAN NEGERI KOTA KUPANG','99926');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('24','02','KEJAKSAAN NEGERI TIMOR TENGAH SELATAN','99947');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('24','03','KEJAKSAAN NEGERI TIMOR TENGAH UTARA','99951');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('24','04','KEJAKSAAN NEGERI BELU','99930');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('24','05','KEJAKSAAN NEGERI ENDE','99989');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('24','06','KEJAKSAAN NEGERI SIKKA ','99993');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('24','07','KEJAKSAAN NEGERI FLORES TIMUR','400007');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('24','08','KEJAKSAAN NEGERI MANGGARAI','400013');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('24','09','KEJAKSAAN NEGERI NGADA','400157');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('24','10','KEJAKSAAN NEGERI SUMBA TIMUR','99968');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('24','11','KEJAKSAAN NEGERI SUMBA BARAT','99972');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('24','12','KEJAKSAAN NEGERI ALOR','400163');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('24','13','KEJAKSAAN NEGERI ROTE NDAO','477249');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('24','14','KEJAKSAAN NEGERI LEMBATA','477230');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('24','15','KEJAKSAAN NEGERI MANGARAI BARAT','673021');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('24','16','KEJAKSAAN NEGERI KABUPATEN KUPANG','681418');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('24','17','KEJAKSAAN NEGERI SABU RAIJUA','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('25','01','KEJAKSAAN NEGERI AMBON','99706');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('25','02','KEJAKSAAN NEGERI MALUKU TENGAH','99710');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('25','09','KEJAKSAAN NEGERI SERAM BAGIAN BARAT','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('25','03','KEJAKSAAN NEGERI MALUKU TENGGARA','99727');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('25','04','KEJAKSAAN NEGERI BURU','672931');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('25','05','KEJAKSAAN NEGERI MALUKU TENGGARA BARAT','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('25','06','KEJAKSAAN NEGERI KEPULAUAN ARU','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('26','01','KEJAKSAAN NEGERI JAYAPURA','400038');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('26','02','KEJAKSAAN NEGERI NUMFOR','400090');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('26','03','KEJAKSAAN NEGERI MANOKWARI','400069');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('26','04','KEJAKSAAN NEGERI SORONG','400075');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('26','05','KEJAKSAAN NEGERI FAK-FAK','400081');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('26','06','KEJAKSAAN NEGERI MERAUKE','400050');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('26','07','KEJAKSAAN NEGERI JAYAWIJAYA','400044');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('26','08','KEJAKSAAN NEGERI NABIRE','400101');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('26','09','KEJAKSAAN NEGERI KEPULAUAN YAPEN','400276');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('26','10','KEJAKSAAN NEGERI MIMIKA','614890');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('27','01','KEJAKSAAN NEGERI TERNATE','99731');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('27','02','KEJAKSAAN NEGERI TIDORE KEPULAUAN','99769');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('27','03','KEJAKSAAN NEGERI HALMAHERA SELATAN','99752');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('27','04','KEJAKSAAN NEGERI HALMAHERA UTARA','99748');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('27','05','KEJAKSAAN NEGERI KEPULAUAN SULA','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('27','06','KEJAKSAAN NEGERI HALMAHERA TENGAH','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('27','07','KEJAKSAAN NEGERI KEPULAUAN MOROTAI','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('27','08','KEJAKSAAN NEGERI HALMAHERA BARAT','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('28','01','KEJAKSAAN NEGERI SERANG','97560');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('28','02','KEJAKSAAN NEGERI KOTA TANGERANG','97598');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('28','03','KEJAKSAAN NEGERI PANDEGLANG','97581');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('28','04','KEJAKSAAN NEGERI LEBAK','97577');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('28','05','KEJAKSAAN NEGERI CILEGON','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('28','06','KEJAKSAAN NEGERI KABUPATEN TANGERANG','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('29','01','KEJAKSAAN NEGERI PANGKAL PINANG','99010');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('29','02','KEJAKSAAN NEGERI BANGKA','99024');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('29','03','KEJAKSAAN NEGERI BELITUNG ','400600');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('29','04','KEJAKSAAN NEGERI BANGKA BARAT','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('29','05','KEJAKSAAN NEGERI BELITUNG TIMUR','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('29','06','KEJAKSAAN NEGERI BANGKA SELATAN','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('29','07','KEJAKSAAN NEGERI BANGKA TENGAH','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('30','01','KEJAKSAAN NEGERI LIMBOTO','400208');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('30','02','KEJAKSAAN NEGERI GORONTALO','99361');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('30','03','KEJAKSAAN NEGERI BOALEMO','477218');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('30','04','KEJAKSAAN NEGERI BONE BOLANGO','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('30','05','KEJAKSAAN NEGERI POHUWATO','670185');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('30','06','KEJAKSAAN NEGERI GORONTALO UTARA','-');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('31','01','KEJAKSAAN NEGERI TANJUNG PINANG','98881');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('31','02','KEJAKSAAN NEGERI BATAM','108309');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('31','03','KEJAKSAAN NEGERI KARIMUN','663005');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('31','04','KEJAKSAAN NEGERI RANAI','672948');");
		$this->db->query("REPLACE INTO kejaksaan_negeri (kode_kejati,kode_kejari,nama_instansi,kode_satker_pn) VALUES('31','05','KEJAKSAAN NEGERI LINGGA','-');");


		$this->db->query("DROP VIEW IF EXISTS viewperkaralalulintasweb;");
		$this->db->query("CREATE VIEW viewperkaralalulintasweb AS
							SELECT
							  perkara_id AS IDPerkara,
							  (CASE 
							    WHEN ditilang_oleh='1' THEN 'Polisi' 
							    WHEN ditilang_oleh='2' THEN 'Dinas Perhubungan' 
							    ELSE 'Lainnya' END) AS ditilangOleh,
							  nomor_tilang AS nomorTilang,
							  (CASE 
							    WHEN jenis_kendaraan_id='1' THEN 'Sepeda Motor' 
							    WHEN jenis_kendaraan_id='2' THEN 'Mobil Pick Up' 
							    WHEN jenis_kendaraan_id='3' THEN 'Mobil Penumpang Pribadi' 
							    WHEN jenis_kendaraan_id='4' THEN 'Mobil Penumpang Umum' 
							    WHEN jenis_kendaraan_id='5' THEN 'Bus' 
							    WHEN jenis_kendaraan_id='6' THEN 'Truk' 
							    WHEN jenis_kendaraan_id='7' THEN 'Truk Gandeng' 
							    ELSE 'Lainnya' END) AS jenisKendaraan,
							  nomor_polisi AS nomorPolisi,
							  (CASE 
							    WHEN bukti_tilang_id='10' THEN 'SIM C' 
							    WHEN bukti_tilang_id='11' THEN 'SIM A' 
							    WHEN bukti_tilang_id='12' THEN 'SIM BI' 
							    WHEN bukti_tilang_id='13' THEN 'SIM A UMUM' 
							    WHEN bukti_tilang_id='14' THEN 'SIM BI UMUM' 
							    WHEN bukti_tilang_id='15' THEN 'SIM BII UMUM' 
							    WHEN bukti_tilang_id='20' THEN 'STNK' 
							    WHEN bukti_tilang_id='30' THEN 'SIM & STNK' 
							    WHEN bukti_tilang_id='40' THEN 'Kendaraan' 
							    WHEN bukti_tilang_id='50' THEN 'Buku KIR' 
							    ELSE 'Lainnya' END) AS buktiTilang,
							  tanggal_penindakan AS tanggalPenindakan,
							  form_tilang AS jenisTilang,
							  nomor_pembayaran AS nomorPembayaran
							FROM perkara_lalulintas;");

		$this->db->query("DROP TABLE IF EXISTS perkaralalulintasweb;");
		$this->db->query("CREATE TABLE perkaralalulintasweb AS SELECT * FROM viewperkaralalulintasweb;");

		$this->db->query("ALTER TABLE perkaralalulintasweb ADD PRIMARY KEY (IDPerkara), ENGINE=INNODB;");

		$this->db->query("DROP TABLE IF EXISTS mediatorweb;");
		$this->db->query("CREATE TABLE mediatorweb AS SELECT * FROM viewmediatorweb;");
		$this->db->query("ALTER TABLE mediatorweb ADD PRIMARY KEY (IDMediator), ENGINE=INNODB;");

		$this->db->query("DROP PROCEDURE IF EXISTS updateTable;");
		$this->db->query("CREATE PROCEDURE updateTable()
						BEGIN
							  DELETE FROM dataumumweb;
							  REPLACE INTO dataumumweb SELECT * FROM viewdataumumweb;
							  DELETE FROM jenisperkaraweb;
							  REPLACE INTO jenisperkaraweb SELECT * FROM viewjenisperkaraweb;
							  DELETE FROM pihakweb;
							  REPLACE INTO pihakweb SELECT * FROM viewpihakweb;
							  DELETE FROM pengacaraweb;
							  REPLACE INTO pengacaraweb SELECT * FROM viewpengacaraweb;
							  DELETE FROM hakimweb;
							  REPLACE INTO hakimweb SELECT * FROM viewhakimweb;
							  DELETE FROM ppweb;
							  REPLACE INTO ppweb SELECT * FROM viewppweb;
							  DELETE FROM jurusitaweb;
							  REPLACE INTO jurusitaweb SELECT * FROM viewjurusitaweb;
							  DELETE FROM mediasiweb;
							  REPLACE INTO mediasiweb SELECT * FROM viewmediasiweb;
							  DELETE FROM mediatorweb;
							  REPLACE INTO mediatorweb SELECT * FROM viewmediatorweb;
							  DELETE FROM jadwalsidangweb;
							  REPLACE INTO jadwalsidangweb SELECT * FROM viewjadwalsidangweb;
							  DELETE FROM perkarabiayaweb;
							  REPLACE INTO perkarabiayaweb SELECT * FROM viewperkarabiayaweb ORDER BY idperkara,tgltransaksi ASC;
							  DELETE FROM verzetweb;
							  REPLACE INTO verzetweb SELECT * FROM viewverzetweb;
							  DELETE FROM penahananweb;
							  REPLACE INTO penahananweb SELECT * FROM viewpenahananweb;
							  DELETE FROM putusanselaweb;
							  REPLACE INTO putusanselaweb SELECT * FROM viewputusanselaweb;
							  DELETE FROM pihakintervensiweb;
							  REPLACE INTO pihakintervensiweb SELECT * FROM viewpihakintervensiweb;
							  DELETE FROM bandingweb;
							  REPLACE INTO bandingweb SELECT * FROM viewbandingweb;
							  DELETE FROM bandingdetilweb;
							  REPLACE INTO bandingdetilweb SELECT * FROM viewbandingdetilweb;
							  DELETE FROM diversiweb;
							  REPLACE INTO diversiweb SELECT * FROM viewdiversiweb;
							  DELETE FROM eksekusiweb;
							  REPLACE INTO eksekusiweb SELECT * FROM vieweksekusiweb;
							  DELETE FROM eksekusidetilweb;
							  REPLACE INTO eksekusidetilweb SELECT * FROM vieweksekusidetilweb; 
							  DELETE FROM kasasiweb;  
							  REPLACE INTO kasasiweb SELECT * FROM viewkasasiweb;
							  DELETE FROM kasasidetilweb;
							  REPLACE INTO kasasidetilweb SELECT * FROM viewkasasidetilweb;
							  DELETE FROM pkweb;
							  REPLACE INTO pkweb SELECT * FROM viewpkweb;
							  DELETE FROM pkdetilweb;
							  REPLACE INTO pkdetilweb SELECT * FROM viewpkdetilweb;
							  DELETE FROM prosesweb;
							  REPLACE INTO prosesweb SELECT * FROM viewprosesweb;
							  DELETE FROM grasiweb;
							  REPLACE INTO grasiweb SELECT * FROM viewgrasiweb;
							  DELETE FROM perkarapenuntutanweb;
							  REPLACE INTO perkarapenuntutanweb SELECT * FROM viewperkarapenuntutanweb;   
							  DELETE FROM actiopaulianaweb;
							  REPLACE INTO actiopaulianaweb SELECT * FROM viewactiopaulianaweb;
							  DELETE FROM perkaraprosesweb;
							  REPLACE INTO perkaraprosesweb SELECT * FROM viewperkaraprosesweb;
							  DELETE FROM perkarakeberatanweb;
							  REPLACE INTO perkarakeberatanweb SELECT * FROM viewperkarakeberatanweb;
							  DELETE FROM perkaraeksekusihtweb;
							  REPLACE INTO perkaraeksekusihtweb SELECT * FROM viewperkaraeksekusihtweb;
							  DELETE FROM putusanpemberitahuanweb;
							  REPLACE INTO putusanpemberitahuanweb SELECT * FROM viewputusanpemberitahuanweb;
							  DELETE FROM barangbuktiweb;
							  REPLACE INTO barangbuktiweb SELECT * FROM viewbarangbuktiweb;
							  DELETE FROM perkaralalulintasweb;
							  REPLACE INTO perkaralalulintasweb SELECT * FROM viewperkaralalulintasweb;
							  DELETE FROM perkaraputusanweb;
							  REPLACE INTO perkaraputusanweb SELECT * FROM viewperkaraputusanweb;
							  DELETE FROM perkaraputusanterdakwaweb;
							  REPLACE INTO perkaraputusanterdakwaweb SELECT * FROM viewperkaraputusanterdakwaweb;
							  DELETE FROM rekonvensiweb;
							  REPLACE INTO rekonvensiweb SELECT * FROM viewrekonvensiweb;
							  DELETE FROM alurperkaraweb;
							  REPLACE INTO alurperkaraweb SELECT * FROM viewalurperkaraweb;
							  DELETE FROM statuspihakweb;
							  REPLACE INTO statuspihakweb SELECT * FROM viewstatuspihakweb;
							  DELETE FROM ikrarweb;
							  REPLACE INTO ikrarweb SELECT * FROM viewikrarweb;
							  DELETE FROM perkaramatraweb;
							  REPLACE INTO perkaramatraweb SELECT * FROM viewperkaramatraweb;
							  DELETE FROM panggilandismissalweb;
							  REPLACE INTO panggilandismissalweb SELECT * FROM viewpanggilandismissalweb;
							  DELETE FROM penetapandismissalweb;
							  REPLACE INTO penetapandismissalweb SELECT * FROM viewpenetapandismissalweb;
							  DELETE FROM sidangpertamaweb;
							  REPLACE INTO sidangpertamaweb SELECT * FROM viewsidangpertamaweb;
							  DELETE FROM penetapanpersiapanweb;
							  REPLACE INTO penetapanpersiapanweb SELECT * FROM viewpenetapanpersiapanweb;
							  DELETE FROM penetapanpersiapanprosesweb;
							  REPLACE INTO penetapanpersiapanprosesweb SELECT * FROM viewpenetapanpersiapanprosesweb;
							  DELETE FROM statusputusanweb;
							  REPLACE INTO statusputusanweb SELECT * FROM viewstatusputusanweb;
							  DELETE FROM jenisperkaraweb;
							  REPLACE INTO jenisperkaraweb SELECT * FROM viewjenisperkaraweb;
							  DELETE FROM delegasikeluarweb;
							  REPLACE INTO delegasikeluarweb SELECT * FROM viewdelegasikeluarweb;
							  DELETE FROM delegasimasukweb;
							  REPLACE INTO delegasimasukweb SELECT * FROM viewdelegasimasukweb;
							  DELETE FROM delegasiproseskeluarweb;
							  REPLACE INTO delegasiproseskeluarweb SELECT * FROM viewdelegasiproseskeluarweb;
							  DELETE FROM delegasiprosesmasukweb;
							  REPLACE INTO delegasiprosesmasukweb SELECT * FROM viewdelegasiprosesmasukweb;
						END;");

		$this->db->query("DROP FUNCTION IF EXISTS get_umur;");

		$this->db->query("CREATE FUNCTION get_umur(tanggal_lahir DATE, tanggal_hitung DATE)	RETURNS INT(4)
						BEGIN
							DECLARE i INT;
							SET i = YEAR(tanggal_hitung)-YEAR(tanggal_lahir)-(DATE_FORMAT(tanggal_hitung,'%m%d')<DATE_FORMAT(tanggal_lahir,'%m%d'));
						RETURN i;
						END;");


		$this->db->query("DROP FUNCTION IF EXISTS `ubah_nip`;");

		$this->db->query("CREATE FUNCTION `ubah_nip`(str VARCHAR(18)) RETURNS VARCHAR(21) CHARSET latin1 DETERMINISTIC
							RETURN
							    CONCAT(
							    LEFT(str,8),
							    ' ',
							    SUBSTRING(str,9,6),
							    ' ',
							    SUBSTRING(str,15,1),
							    ' ',
							    RIGHT(str,3)
							    );");

 		$this->db->query("REPLACE INTO updates_catatan (id,update_id,deskripsi)VALUES
						(306,10,'Penyesuaian Format Tilang Excel SIPP dengan Format Tilang e-Tilang POLRI'),
						(307,10,'Penambahan Kolom Formulir Tilang (Biru atau Merah), Nomor Pembayaran adalah Nomor BRI Virtual Account untuk pembayaran denda tilang melalui BRI dan Besar Uang Titipan'),
						(308,10,'Penambahan Template Dokumen Akta Cerai Blangko Baru'),
						(309,10,'Perbaikan kewenangan edit putusan keberatan gugatan sederhana'),
						(310,10,'Perbaikan tunda jadwal sidang'),
						(311,10,'Perbaikan kewenangan cetak template mediasi'),
						(312,10,'Perbaikan Pesan masuk dan keluar'),
						(313,10,'Perbaikan pilih mediator dengan karatker apostrophe'),
						(314,10,'SIPP WEB V315-3'),
						(315,10,'File Syncron SIPP WEB V315-3');");


		$this->db->query("UPDATE sys_config SET `value` = '3.1.5-3' WHERE id = '80';");
		//update table update patch 3.1.5-3
		$data = array('updated' => 1,'updated_stamp'=>date("Y-m-d H:i:s"));
		$this->db->where('patch_ver', '3.1.5-3');
		$this->db->update('updates', $data); 
		$this->db->query("SET FOREIGN_KEY_CHECKS=1;");
		return true;
	}

}