<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Authorization{
	public function __construct(){
		$this->CI =& get_instance();
		$this->CI->load->model('authorization/hak_akses_m');
    }
 
    public function hasAuthorizationForm($formName){
        $AuthorizationForm = $this->nativesession->get('AuthorizationForm');
        if(is_array($AuthorizationForm)){
			if(in_array($formName, $AuthorizationForm, true)){
				return TRUE;
			}
		}else{
			return FALSE;
		}
		return FALSE;
    }

    public function hasAuthorizationAction($actionName){
        $AuthorizationAction = $this->nativesession->get('getAuthorizationAction');
        if(is_array($AuthorizationAction)){
			if(in_array($actionName, $AuthorizationAction, true)){
				return TRUE;
			}
		}else{
			return FALSE;
		}
		return FALSE;
    }

    function getActionName($id_alur_perkara){
        $actionName = '';
        if($id_alur_perkara<111){
            if($id_alur_perkara==1 or $id_alur_perkara==7){
                $actionName = "JurnalGugatanManageAll";
            }elseif($id_alur_perkara==2){
                $actionName = "JurnalPermohonanManageAll";
            }elseif($id_alur_perkara==3){
                $actionName = "JurnalPailitManageAll";
            }elseif($id_alur_perkara==4){
                $actionName = "JurnalPKPUManageAll";
            }elseif($id_alur_perkara==5){
                $actionName = "JurnalHKIManageAll";
            }elseif($id_alur_perkara==6){
                $actionName = "JurnalPHIManageAll";
            }
        }else{
            if($id_alur_perkara==111 OR $id_alur_perkara==118 OR $id_alur_perkara==119 OR $id_alur_perkara==122 OR $id_alur_perkara==123){
                $actionName = "PidanaBiasaAdd";
            }elseif($id_alur_perkara==112){
                $actionName = "PidanaSingkatAdd";
            }elseif($id_alur_perkara==113){
                $actionName = "PidanaCepatAdd";
            }elseif($id_alur_perkara==114){
                $actionName = "PidanaLaluLintasAdd";
            }elseif($id_alur_perkara==115){
                $actionName = "TipikorAdd";
            }elseif($id_alur_perkara==116){
                $actionName = "PerikananAdd";
            }elseif($id_alur_perkara==117){
                $actionName = "HAMAdd";
            }elseif($id_alur_perkara==120){
                $actionName = "PidanaPenahananAdd";
            }
        }

        return $actionName;
    }

    public function hasAuthorizationAddPerkara($id_alur_perkara,$AuthorizationAction){
        if($id_alur_perkara<111){
            return FALSE;
        }else{
            $actionName = $this->getActionName($id_alur_perkara);
            return $this->isAuthorized($actionName,$AuthorizationAction);
        }
    }

    public function hasAuthorizationAddJurnal($id_alur_perkara,$AuthorizationAction){
        if($id_alur_perkara>=111){
            return FALSE;
        }else{
            $actionName = $this->getActionName($id_alur_perkara);
            return $this->isAuthorized($actionName,$AuthorizationAction);
        }
    }

    function isAuthorized($actionName,$AuthorizationAction){
        if(is_array($AuthorizationAction)){
            if(in_array($actionName, $AuthorizationAction, TRUE)){
                return TRUE;
            }
        }
        return FALSE;
    }

    function cek_proses_id($perkara_id, $proses_id){
        $resul = false;
        $ls=$this->CI->hak_akses_m->getInfoProsesId($perkara_id, $proses_id);
        if ($ls->num_rows>0){
            $resul = true;
        }
        return $resul;
    }
	
	function HasRuleAddPendaftaran($alurperkaraid=''){
		$resul = false;
        $username=$this->CI->session->userdata('username');
		$id_group=$this->CI->session->userdata('idgroup');
        if(isset($username) && $username !='' ){ 
            if ($id_group==10 || $id_group==1){
				$resul = true;
			}
            switch (true){
                case ($alurperkaraid<3 && ($id_group==410 || $id_group==412 || $id_group==702)):
                    $resul = true;
                break;
                case ($alurperkaraid==3 && ($id_group==450 || $id_group==452 || $id_group==702)):
                    $resul = true;
                break;
                case ($alurperkaraid==4 && ($id_group==450 || $id_group==452 || $id_group==702)):
                    $resul = true;
                break;
                case ($alurperkaraid==5 && ($id_group==410 || $id_group==412 || $id_group==702)):
                    $resul = true;
                break;
                case ($alurperkaraid==6 && ($id_group==440 || $id_group==442 || $id_group==702)):
                    $resul = true;
                break;
                case ($alurperkaraid==7 && ($id_group==410 || $id_group==412 || $id_group==702)):
                    $resul = true;
                break;
                case ($alurperkaraid==8 && ($id_group==410 || $id_group==412 || $id_group==702)):
                    $resul = true;
                break;
                case ($alurperkaraid==9 && ($id_group==1030 || $id_group==702)):
                    $resul = true;
                break;
                case ($alurperkaraid==10 && ($id_group==1030 || $id_group==702)):
                    $resul = true;
                break;
                case ($alurperkaraid==11 && ($id_group==1030 || $id_group==702)):
                    $resul = true;
                break;
                case ($alurperkaraid==15 && ($id_group==1000 || $id_group==1001 || $id_group==702)):
                    $resul = true;
                break;
                case ($alurperkaraid==16 && ($id_group==1010 || $id_group==1011 || $id_group==702)):
                    $resul = true;
                break;

                case ($alurperkaraid>100 && $alurperkaraid<115 && ($id_group==420 || $id_group==422)):
                    $resul = true;
                break;
                case ($alurperkaraid==115 && ($id_group==460 || $id_group==462)):
                    $resul = true;
                break;
                case ($alurperkaraid==116 && ($id_group==470 || $id_group==472)):
                    $resul = true;
                break;
                case ($alurperkaraid==117 && ($id_group==420 || $id_group==422)):
                    $resul = true;
                break;
                case ($alurperkaraid==118 && ($id_group==420 || $id_group==422)):
                    $resul = true;
                break;
                case ($alurperkaraid==119 && ($id_group==420 || $id_group==422)):
                    $resul = true;
                break;
                case ($alurperkaraid==120 && ($id_group==420 || $id_group==422)):
                    $resul = true;
                break;
                case ($alurperkaraid==121 && ($id_group==420 || $id_group==422)):
                    $resul = true;
                break;
                case ($alurperkaraid==122 && ($id_group==1020 || $id_group==1022)):
                    $resul = true;
                break;
                case ($alurperkaraid==123 && ($id_group==1020 || $id_group==1022)):
                    $resul = true;
                break;
            }
        }
        return $resul;
	}
	
	function HasRuleEditPemberitahuanPutusan($alurperkaraid='', $perkaraid=''){
		$resul = false;
        $username=$this->CI->session->userdata('username');
		$id_group=$this->CI->session->userdata('idgroup');
		$jurusita_id=$this->CI->session->userdata('jurusita_id');
        if(isset($username) && $username !='' ){ 
            if ($id_group==10 || $id_group==1){
				$resul = true;
			}
            switch (true){
                case ($alurperkaraid<3 && ($id_group==410 || $id_group==412 || $id_group==413)):
                    $resul = true;
                break;
                case ($alurperkaraid==3 && ($id_group==450 || $id_group==452 || $id_group==453)):
                    $resul = true;
                break;
                case ($alurperkaraid==4 && ($id_group==450 || $id_group==452 || $id_group==453)):
                    $resul = true;
                break;
                case ($alurperkaraid==5 && ($id_group==410 || $id_group==412 || $id_group==413)):
                    $resul = true;
                break;
                case ($alurperkaraid==6 && ($id_group==440 || $id_group==442 || $id_group==413)):
                    $resul = true;
                break;
                case ($alurperkaraid==7 && ($id_group==410 || $id_group==412 || $id_group==413)):
                    $resul = true;
                break;
                case ($alurperkaraid==8 && ($id_group==410 || $id_group==412 || $id_group==413)):
                    $resul = true;
                break;
                case ($alurperkaraid==9 && ($id_group==1030 || $id_group==1033 || $id_group==1034)):
                    $resul = true;
                break;                
                case ($alurperkaraid==10 && ($id_group==1030 || $id_group==1033 || $id_group==1034)):
                    $resul = true;
                break;
                case ($alurperkaraid==11 && ($id_group==1030 || $id_group==1033 || $id_group==1034)):
                    $resul = true;
                break;
                case ($alurperkaraid==15 && ($id_group==1003 || $id_group==1000 || $id_group==1001 || $id_group==1002 || $id_group==600)):
                    $resul = true;
                break;
                case ($alurperkaraid==16 && ($id_group==1013 || $id_group==1010 || $id_group==1011 || $id_group==1012 || $id_group==600)):
                    $resul = true;
                break;
                case ($alurperkaraid>100 && $alurperkaraid<115 && ($id_group==420 || $id_group==422 || $id_group==423)):
                    $resul = true;
                break;
                case ($alurperkaraid==115 && ($id_group==460 || $id_group==462 || $id_group==463)):
                    $resul = true;
                break;
                case ($alurperkaraid==116 && ($id_group==470 || $id_group==472 || $id_group==473)):
                    $resul = true;
                break;
                case ($alurperkaraid==117 && ($id_group==420 || $id_group==422 || $id_group==423)):
                    $resul = true;
                break;
                case ($alurperkaraid==118 && ($id_group==420 || $id_group==422 || $id_group==423)):
                    $resul = true;
                break;
                case ($alurperkaraid==119 && ($id_group==420 || $id_group==422 || $id_group==423)):
                    $resul = true;
                break;
                case ($alurperkaraid==120 && ($id_group==420 || $id_group==422 || $id_group==423)):
                    $resul = true;
                break;
                case ($alurperkaraid==121 && ($id_group==420 || $id_group==422 || $id_group==423)):
                    $resul = true;
                break;
                case ($alurperkaraid==122 && ($id_group==1020 || $id_group==1022 || $id_group==1023)):
                    $resul = true;
                break;
                case ($alurperkaraid==123 && ($id_group==1020 || $id_group==1022 || $id_group==1023)):
                    $resul = true;
                break;
            }
			if ($rx = $this->CI->hak_akses_m->get_hakim_panitera_jurusita_ids($perkaraid)) {
                    foreach ($rx->result() as $row) {
                        if ($jurusita_id!='' && (in_array($jurusita_id, explode(',',$row->jurusita_id)))){
							$resul=true;
						};
                    }
                }
        }
        return $resul;
	}

    function HasRuleDelegasiJurusita($delegasi_id=''){
        $resul = false;
        $username=$this->CI->session->userdata('username');
        $id_group=$this->CI->session->userdata('idgroup');
        $jurusita_id=$this->CI->session->userdata('jurusita_id');
        if(isset($username) && $username !='' ){ 
            if ($id_group==10 || $id_group==1){
                $resul = true;
            }
            switch (true){
                case ($id_group==30 || $id_group==410 || $id_group==420 || $id_group==650):
                    $resul = true;
                break;
            }
            if ($rx = $this->CI->hak_akses_m->get_jurusita_delegasi($delegasi_id)) {
                foreach ($rx->result() as $row) {
                    if ($jurusita_id!='' && (in_array($jurusita_id, explode(',',$row->jurusita_id)))){
                        $resul=true;
                    };
                }
            }
        }
        return $resul;
    }

	function HasRuleEditPendaftaran($alurperkaraid='', $perkaraid=''){
        $resul = false;
        $username=$this->CI->session->userdata('username');
		$id_group=$this->CI->session->userdata('idgroup');
        if(isset($username) && $username !='' ){ 
            if ($id_group==10 || $id_group==1){
				$resul = true;
			}
			if ($perkaraid!=''){
				$sudahputus=0;
				if ($this->CI->hak_akses_m->getInfoPerkara($perkaraid)->num_rows()>0) {
					$sudahputus = $this->CI->hak_akses_m->getInfoPerkara($perkaraid)->first_row()->tanggal_putusan!=''? 1: 0;
                }
                if ($sudahputus!=1){
            		switch (true){
                        case ($alurperkaraid<3 && ($id_group==410 || $id_group==412 || $id_group==413)):
                            $resul = true;
                        break;
                        case ($alurperkaraid==3 && ($id_group==450 || $id_group==452 || $id_group==453)):
                            $resul = true;
                        break;
                        case ($alurperkaraid==4 && ($id_group==450 || $id_group==452 || $id_group==453)):
                            $resul = true;
                        break;
                        case ($alurperkaraid==5 && ($id_group==410 || $id_group==412 || $id_group==413)):
                            $resul = true;
                        break;
                        case ($alurperkaraid==6 && ($id_group==440 || $id_group==442 || $id_group==413)):
                            $resul = true;
                        break;
                        case ($alurperkaraid==7 && ($id_group==410 || $id_group==412 || $id_group==413)):
                            $resul = true;
                        break;
                        case ($alurperkaraid==8 && ($id_group==410 || $id_group==412 || $id_group==413)):
                            $resul = true;
                        break;
                        case ($alurperkaraid==9 && ($id_group==1030 || $id_group==1032 || $id_group==1033)):
                            $resul = true;
                        break;
                        case ($alurperkaraid==10 && ($id_group==1030 || $id_group==1032 || $id_group==1033)):
                            $resul = true;
                        break;
                        case ($alurperkaraid==11 && ($id_group==1030 || $id_group==1032 || $id_group==1033)):
                            $resul = true;
                        break;
                        case ($alurperkaraid==12 && ($id_group==1030 || $id_group==1032 || $id_group==1033)):
                            $resul = true;
                        break;
                        case ($alurperkaraid==15 && ($id_group==1000 || $id_group==1001 || $id_group==1002)):
                            $resul = true;
                        break;
                        case ($alurperkaraid==16 && ($id_group==1010 || $id_group==1011 || $id_group==1012)):
                            $resul = true;
                        break;
                        case ($alurperkaraid>100 && $alurperkaraid<115 && ($id_group==420 || $id_group==422 || $id_group==423)):
                            $resul = true;
                        break;
                        case ($alurperkaraid==115 && ($id_group==460 || $id_group==462 || $id_group==463)):
                            $resul = true;
                        break;
                        case ($alurperkaraid==116 && ($id_group==470 || $id_group==472 || $id_group==473)):
                            $resul = true;
                        break;
                        case ($alurperkaraid==117 && ($id_group==420 || $id_group==422 || $id_group==423)):
                            $resul = true;
                        break;
                        case ($alurperkaraid==118 && ($id_group==420 || $id_group==422 || $id_group==423)):
                            $resul = true;
                        break;
                        case ($alurperkaraid==119 && ($id_group==420 || $id_group==422 || $id_group==423)):
                            $resul = true;
                        break;
                        case ($alurperkaraid==120 && ($id_group==420 || $id_group==422 || $id_group==423)):
                            $resul = true;
                        break;
                        case ($alurperkaraid==121 && ($id_group==420 || $id_group==422 || $id_group==423)):
                            $resul = true;
                        break;
                        case ($alurperkaraid==122 && ($id_group==1020 || $id_group==1022 || $id_group==1023)):
                            $resul = true;
                        break;
                        case ($alurperkaraid==123 && ($id_group==1020 || $id_group==1022 || $id_group==1023)):
                            $resul = true;
                        break;
                    }	
                }
			}
        }
        return $resul;
    }
	
	function HasRuleEditPendaftaranBackUp($perkaraid='',$alurperkaraid='',$paniteraid=''){
        $resul = false;
        $username=$this->CI->session->userdata('username');
        if(isset($username) && $username !='' ){ 
            $hakimids = '';
            $paniteraids = '';
            $jurusitaids = '';
            if($perkaraid !=''){ 
                $this->rsstaft = array();
                if ($rx = $this->CI->hak_akses_m->get_hakim_panitera_jurusita_ids($perkaraid)) {  
                    $y = 0;
                    $nm_count = $rx->num_rows();
                    foreach ($rx->result() as $row) {
                        $this->rsstaft[$y] [0] = $row->majelis_hakim_id;
                        $this->rsstaft[$y] [1] = $row->panitera_pengganti_id;
                        $this->rsstaft[$y] [2] = $row->jurusita_id;
                        $y++;
                    }
                }
                $hakimids = isset($this->rsstaft[0][0]) ? explode(',',$this->rsstaft[0][0]) :'';
                $paniteraids = isset($this->rsstaft[0][1]) ? explode(',',$this->rsstaft[0][1]) :'';
                $jurusitaids = isset($this->rsstaft[0][2]) ? explode(',',$this->rsstaft[0][2]) :'';
            }
            $ses_hakimid = $this->CI->session->userdata('hakim_id');
            $ses_paniteraid = $this->CI->session->userdata('panitera_id');
            $ses_jurusitaid = $this->CI->session->userdata('jurusita_id');
            $ses_hakimid = isset($ses_hakimid) ? $ses_hakimid:'0';
            $ses_paniteraid = isset($ses_paniteraid) ? $ses_paniteraid:'0';
            $ses_jurusitaid = isset($ses_jurusitaid) ? $ses_jurusitaid:'0';
            $has_hakimid = is_array($hakimids) &&  in_array($ses_hakimid, $hakimids) ? true :false;
            $has_paniteraid = is_array($paniteraids) &&  in_array($ses_paniteraid, $paniteraids) ? true :false;
            $has_jurusitaid = is_array($jurusitaids) &&  in_array($ses_jurusitaid, $jurusitaids) ? true :false;
                
            if($alurperkaraid ==1 && (in_array('GugatanAdd', $this->CI->nativesession->get('getAuthorizationAction')) || (in_array('GugatanEdit', $this->CI->nativesession->get('getAuthorizationAction')) && $ses_paniteraid==$paniteraid) || in_array('GugatanEditAll', $this->CI->nativesession->get('getAuthorizationAction'))) ){ 
                $resul = true;
            }else if($alurperkaraid ==2 && (in_array('PermohonanAdd', $this->CI->nativesession->get('getAuthorizationAction')) || (in_array('PermohonanEdit', $this->CI->nativesession->get('getAuthorizationAction')) && $ses_paniteraid==$paniteraid) || in_array('PermohonanEditAll', $this->CI->nativesession->get('getAuthorizationAction'))) ){ 
                $resul = true;
            }else if($alurperkaraid ==3 && (in_array('PailitAdd', $this->CI->nativesession->get('getAuthorizationAction')) || (in_array('PailitEdit', $this->CI->nativesession->get('getAuthorizationAction')) && $ses_paniteraid==$paniteraid) || in_array('PailitEditAll', $this->CI->nativesession->get('getAuthorizationAction'))) ){ 
                $resul = true;
            }else if($alurperkaraid ==4 && (in_array('PKPUAdd', $this->CI->nativesession->get('getAuthorizationAction')) || (in_array('PKPUEdit', $this->CI->nativesession->get('getAuthorizationAction')) && $ses_paniteraid==$paniteraid) || in_array('PKPUEditAll', $this->CI->nativesession->get('getAuthorizationAction'))) ){ 
                $resul = true;
            }else if($alurperkaraid ==5 && (in_array('HKIAdd', $this->CI->nativesession->get('getAuthorizationAction')) || (in_array('HKIEdit', $this->CI->nativesession->get('getAuthorizationAction')) && $ses_paniteraid==$paniteraid) || in_array('HKIEditAll', $this->CI->nativesession->get('getAuthorizationAction'))) )   { 
                $resul = true;
            }else if($alurperkaraid ==6 && (in_array('PHIAdd', $this->CI->nativesession->get('getAuthorizationAction')) || (in_array('PHIEdit', $this->CI->nativesession->get('getAuthorizationAction')) && $ses_paniteraid==$paniteraid) || in_array('PHIEditAll', $this->CI->nativesession->get('getAuthorizationAction'))) )   { 
                $resul = true;
            }else if($alurperkaraid ==7 && (in_array('PerlawananAdd', $this->CI->nativesession->get('getAuthorizationAction')) || (in_array('PerlawananEdit', $this->CI->nativesession->get('getAuthorizationAction')) && $ses_paniteraid==$paniteraid) || in_array('PerlawananEditAll', $this->CI->nativesession->get('getAuthorizationAction'))) )   { 
                $resul = true;
            }else if(($alurperkaraid ==111 || $alurperkaraid ==122) && (in_array('PidanaBiasaAdd', $this->CI->nativesession->get('getAuthorizationAction')) || (in_array('PidanaBiasaEdit', $this->CI->nativesession->get('getAuthorizationAction')) && $ses_paniteraid==$paniteraid) || in_array('PidanaBiasaEditAll', $this->CI->nativesession->get('getAuthorizationAction'))) ) { 
                $resul = true;
            }else if($alurperkaraid ==112 && (in_array('PidanaSingkatAdd', $this->CI->nativesession->get('getAuthorizationAction')) || (in_array('PidanaSingkatEdit', $this->CI->nativesession->get('getAuthorizationAction')) && $ses_paniteraid==$paniteraid) || in_array('PidanaSingkatEditAll', $this->CI->nativesession->get('getAuthorizationAction'))) )   { 
                $resul = true;
            }else if($alurperkaraid ==113 && (in_array('PidanaCepatAdd', $this->CI->nativesession->get('getAuthorizationAction')) || (in_array('PidanaCepatEdit', $this->CI->nativesession->get('getAuthorizationAction')) && $ses_paniteraid==$paniteraid) || in_array('PidanaCepatEditAll', $this->CI->nativesession->get('getAuthorizationAction'))) )   { 
                $resul = true;
            }else if($alurperkaraid ==114 && (in_array('PidanaLaluLintasAdd', $this->CI->nativesession->get('getAuthorizationAction')) || (in_array('PidanaLaluLintasEdit', $this->CI->nativesession->get('getAuthorizationAction')) && $ses_paniteraid==$paniteraid) || in_array('PidanaLaluLintasEditAll', $this->CI->nativesession->get('getAuthorizationAction'))) )   { 
                $resul = true;
            }else if($alurperkaraid ==115 && (in_array('TipikorAdd', $this->CI->nativesession->get('getAuthorizationAction')) || (in_array('TipikorEdit', $this->CI->nativesession->get('getAuthorizationAction')) && $ses_paniteraid==$paniteraid) || in_array('TipikorEditAll', $this->CI->nativesession->get('getAuthorizationAction'))) )  { 
                $resul = true;
            }else if($alurperkaraid ==116 && (in_array('PerikananAdd', $this->CI->nativesession->get('getAuthorizationAction')) || (in_array('PerikananEdit', $this->CI->nativesession->get('getAuthorizationAction')) && $ses_paniteraid==$paniteraid) || in_array('PerikananEditAll', $this->CI->nativesession->get('getAuthorizationAction'))) )  { 
                $resul = true;
            }else if($alurperkaraid ==117 && (in_array('HAMAdd', $this->CI->nativesession->get('getAuthorizationAction')) || (in_array('HAMEdit', $this->CI->nativesession->get('getAuthorizationAction')) && $ses_paniteraid==$paniteraid) || in_array('HAMEditAll', $this->CI->nativesession->get('getAuthorizationAction'))) )  { 
                $resul = true;
            }else if($alurperkaraid ==118 && (in_array('AnakAdd', $this->CI->nativesession->get('getAuthorizationAction')) || (in_array('AnakEdit', $this->CI->nativesession->get('getAuthorizationAction')) && $ses_paniteraid==$paniteraid) || in_array('AnakEditAll', $this->CI->nativesession->get('getAuthorizationAction'))) ) { 
                $resul = true;
            }
        }
        return $resul;
    }
	
	
	function HasRuleEditDataLama($alurperkaraid=''){
		$get_authorization=$this->CI->nativesession->get('getAuthorizationAction');
		if (!isset($this->sc_temp_sm_auth)) { $this->sc_temp_sm_auth = (isset($get_authorization)) ? $get_authorization : "";}
																																																																		 
			$resul = false;
			if(isset($this->sc_temp_sm_auth) && is_array($this->sc_temp_sm_auth) && in_array('PerkaraEditOldData', $get_authorization))
			{ 
				$resul = true;
			}
			return $resul;
		
		if (isset($this->sc_temp_sm_auth)) {  $get_authorization = $this->sc_temp_sm_auth;}

	}
	
	function HasRuleAddPenetapan(){																			
		$resul = false;
		$username=$this->CI->session->userdata('username');
		$id_group=$this->CI->session->userdata('idgroup');
		if(isset($username) && $username !='' )
		{ 
			if ($id_group==10 || $id_group==1){
				$resul = true;
			}
			
		}
		return $resul;
	}

    function HasRuleAddBHT($perkaraid='',$alurperkaraid=''){                                                                         
        $resul = false;
        $username=$this->CI->session->userdata('username');
        $id_group=$this->CI->session->userdata('idgroup');
        $panitera_id=$this->CI->session->userdata('panitera_id');
        //$alurperkaraid = $this->CI->tanggalhelper->getIDAlurPerkara($perkaraid);
        if(isset($username) && $username !='' ){ 
            if (($id_group==410 || $id_group==414) && ($alurperkaraid==1||$alurperkaraid==2||$alurperkaraid==7||$alurperkaraid==8)){
                $resul = true;
            }elseif(($id_group==420 || $id_group==423) && ($alurperkaraid==111 || $alurperkaraid==112|| $alurperkaraid==113|| $alurperkaraid==114|| $alurperkaraid==118 || $alurperkaraid==119 || $alurperkaraid==120 || $alurperkaraid==121)){
                $resul = true;
            }elseif(($id_group==440 || $id_group==443) && $alurperkaraid==6){
                $resul = true;
            }elseif(($id_group==450 || $id_group==453) && ($alurperkaraid==3||$alurperkaraid==4||$alurperkaraid==5)){
                $resul = true;
            }elseif(($id_group==460 || $id_group==463) && $alurperkaraid==115){
                $resul = true;
            }elseif(($id_group==470 || $id_group==473) && $alurperkaraid==116){
                $resul = true;
            }elseif(($id_group==420 || $id_group==423) && $alurperkaraid==117){
                $resul = true;
            }elseif(($id_group==1000 || $id_group==1003) && $alurperkaraid==15){
                $resul = true;
            }elseif(($id_group==1010 || $id_group==1013) && $alurperkaraid==16){
                $resul = true;
            }elseif(($id_group==1020 || $id_group==1023) && ($alurperkaraid==122||$alurperkaraid==123)){
                $resul = true;
            }elseif(($id_group==1030 || $id_group==1034) && $alurperkaraid==9||$alurperkaraid==10||$alurperkaraid==11){
                $resul = true;
            }elseif ($id_group==10 || $id_group==1){
                $resul = true;    
            }
                            
            if($perkaraid!=''){
                if ($rx = $this->CI->hak_akses_m->get_hakim_panitera_jurusita_ids($perkaraid)) {
                    foreach ($rx->result() as $row) {
                        if ($panitera_id!='' && (in_array($panitera_id, explode(',',$row->panitera_pengganti_id)))){
                            $resul=true;
                        };
                    }
                }
            }
        }
        return $resul;
    }

    function HasRulePanmudHukum(){                                                                         
        $resul = false;
        $username=$this->CI->session->userdata('username');
        $id_group=$this->CI->session->userdata('idgroup');
        if(isset($username) && $username !='' )
        { 
            if ($id_group==10 || $id_group==30 ||$id_group==1 || $id_group==430 || $id_group==431){
                $resul = true;
            }
        }
        return $resul;
    }
	
	function HasRuleAddPenetapanHakim(){
		$resul = false;
		$username=$this->CI->session->userdata('username');
		$id_group=$this->CI->session->userdata('idgroup');
		if(isset($username) && $username !='' )
		{ 
			if ($id_group==10 || $id_group==1){
				$resul = true;
			}
			
		}
		return $resul;
	}
	
	function HasRuleAddPenetapanPanitera($perkaraid='', $keberatan=0){
		$resul = false;
		$username=$this->CI->session->userdata('username');
		$id_group=$this->CI->session->userdata('idgroup');
        if(isset($username) && $username !='' ){ 
            if ($id_group==10 || $id_group==1){
				$resul = true;
			}
			if ($perkaraid!=''){
				$sudahputus=0;
				if ($keberatan==0){
					if ($this->CI->hak_akses_m->getInfoPerkara($perkaraid)->num_rows()>0) {
					   $sudahputus = $this->CI->hak_akses_m->getInfoPerkara($perkaraid)->first_row()->tanggal_putusan!=''? 1: 0;
	                }
				}else{
					if ($this->CI->hak_akses_m->getInfoPerkaraKeberatan($perkaraid)->num_rows()>0) {
					   $sudahputus = $this->CI->hak_akses_m->getInfoPerkaraKeberatan($perkaraid)->first_row()->putusan_keberatan!=''? 1: 0;
	                }
				}
                if ($sudahputus!=1){
                    if ($id_group==30){
                        $resul = true;
                    }       
                }
			}
        }
		return $resul;
	}
	
	function HasRuleAddPenetapanJurusita($alurperkaraid='',$perkaraid='', $keberatan=0){
		$resul = false;
		$username=$this->CI->session->userdata('username');
		$id_group=$this->CI->session->userdata('idgroup');
		if(isset($username) && $username !='' ){ 
			if ($id_group==1 || $id_group==30 || $id_group==10 ){
				if ($id_group==10 || $id_group==1){
					$resul = true;
				}
				if ($perkaraid!=''){
					$sudahputus=0;
                    if ($keberatan==0){
    					if ($this->CI->hak_akses_m->getInfoPerkara($perkaraid)->num_rows()>0) {
    						$sudahputus = $this->CI->hak_akses_m->getInfoPerkara($perkaraid)->first_row()->tanggal_putusan!=''? 1: 0;
    	                }
                    }else{
                        if ($this->CI->hak_akses_m->getInfoPerkaraKeberatan($perkaraid)->num_rows()>0) {
                           $sudahputus = $this->CI->hak_akses_m->getInfoPerkaraKeberatan($perkaraid)->first_row()->putusan_keberatan!=''? 1: 0;
                        }
                    }
                    if ($sudahputus!=1){
                        if ($alurperkaraid>100 && $id_group==420){
                            $resul = true;  
                        }
                        if ($alurperkaraid<100 && $id_group==410){
                            $resul = true;  
                        }
                        if ($id_group==1 || $id_group==30 || $id_group==10){
                            $resul = true;
                        } # tri
                    }
				}
			}
		}
		return $resul;
	}
	
	function HasRuleAddPenetapanSidangPertama($perkaraid='', $keberatan=0){
		$resul = false;
		$username=$this->CI->session->userdata('username');
		$id_group=$this->CI->session->userdata('idgroup');
		$hakim_id=$this->CI->session->userdata('hakim_id');
		if(isset($username) && $username !='' ){
			if ($perkaraid!=''){
				if ($id_group==1 || $id_group==10){
					$resul=true;
				}
                $sudahputus=0;
                if ($keberatan==0){
                    if ($this->CI->hak_akses_m->getInfoPerkara($perkaraid)->num_rows()>0) {
                        $sudahputus = $this->CI->hak_akses_m->getInfoPerkara($perkaraid)->first_row()->tanggal_putusan!=''? 1: 0;
                    }    
                    if ($sudahputus!=1){
                        if ($rx = $this->CI->hak_akses_m->get_hakim_panitera_jurusita_ids($perkaraid)) {
                            foreach ($rx->result() as $row) {
                                if ($hakim_id!='' && (in_array($hakim_id, explode(',',$row->majelis_hakim_id)))){
                                    $resul=true;
                                };
                                
                            }
                        }
                    }
                }elseif ($keberatan==-1){
                    # Verzet
                    if ($this->CI->hak_akses_m->getInfoPerkara($perkaraid)->num_rows()>0) {
                        $sudahputus = $this->CI->hak_akses_m->getInfoPerkaraVerzet($perkaraid)->first_row()->putusan_verzet!=''? 1: 0;
                    }
                    if ($sudahputus!=1){
                        if ($rx = $this->CI->hak_akses_m->get_hakim_panitera_jurusita_ids_verzet($perkaraid)) {
                            foreach ($rx->result() as $row) {
                                if ($hakim_id!='' && (in_array($hakim_id, explode(',',$row->majelis_hakim_id)))){
                                    $resul=true;
                                };
                                
                            }
                        }
                    }
                }else{
                    if ($this->CI->hak_akses_m->getInfoPerkaraKeberatan($perkaraid)->num_rows()>0) {
                       $sudahputus = $this->CI->hak_akses_m->getInfoPerkaraKeberatan($perkaraid)->first_row()->putusan_keberatan!=''? 1: 0;
                    }
                    if ($sudahputus!=1){
                        if ($rx = $this->CI->hak_akses_m->get_hakim_panitera_jurusita_ids_keberatan($perkaraid)) {
                            foreach ($rx->result() as $row) {
                                if ($hakim_id!='' && (in_array($hakim_id, explode(',',$row->majelis_hakim_id)))){
                                    $resul=true;
                                };
                                
                            }
                        }
                    }
                }
	            
			}
		}
		return $resul;
	}
	
	function HasRuleAddJadwalSidang($perkaraid='', $keberatan=0){
		$resul = false;
		$username=$this->CI->session->userdata('username');
		$id_group=$this->CI->session->userdata('idgroup');
		$hakim_id=$this->CI->session->userdata('hakim_id');
		$panitera_id=$this->CI->session->userdata('panitera_id');
		if(isset($username) && $username !='' ){
			if ($perkaraid!=''){
				if ($id_group==1 || $id_group==10){
					$resul=true;
				}
                $sudahputus=0;
                if ($keberatan==0){
                    $statusVerzet = $this->CI->hak_akses_m->getStatusVerzet($perkaraid)->first_row()->proses_terakhir_id;
                    if($statusVerzet >= 240 AND $statusVerzet < 270){
                        $sudahputus =1;
                    }
                    if ($this->CI->hak_akses_m->getInfoPerkara($perkaraid)->num_rows()>0) {
                        $sudahputus = $this->CI->hak_akses_m->getInfoPerkara($perkaraid)->first_row()->tanggal_putusan!=''? 1: 0;
                    }
                    if($statusVerzet >=290 AND $statusVerzet < 295){
                        $sudahputus = 0;
                    }
                    if ($sudahputus!=1){
                        if ($rx = $this->CI->hak_akses_m->get_hakim_panitera_jurusita_ids($perkaraid)) {
                            foreach ($rx->result() as $row) {
                                if ($hakim_id!='' && (in_array($hakim_id, explode(',',$row->majelis_hakim_id)))){
                                    $resul=true;
                                }else if ($panitera_id!='' && (in_array($panitera_id, explode(',',$row->panitera_pengganti_id)))){
                                    $resul=true;
                                };
                            }
                        }
                    }else{
                            if ($rx = $this->CI->hak_akses_m->get_hakim_panitera_jurusita_ids_verzet($perkaraid)) {
                                foreach ($rx->result() as $row) {
                                    if ($hakim_id!='' && (in_array($hakim_id, explode(',',$row->majelis_hakim_id)))){
                                        $resul=true;
                                    }else if ($panitera_id!='' && (in_array($panitera_id, explode(',',$row->panitera_pengganti_id)))){
                                        $resul=true;
                                    };
                                }
                            }
					}
                }elseif ($keberatan==-1){
                    $statusVerzet = $this->CI->hak_akses_m->getStatusVerzet($perkaraid)->first_row()->proses_terakhir_id;
                    if($statusVerzet >= 240 AND $statusVerzet < 270){
                        $sudahputus =1;
                    }
                    if ($this->CI->hak_akses_m->getInfoPerkara($perkaraid)->num_rows()>0) {
                        $sudahputus = $this->CI->hak_akses_m->getInfoPerkara($perkaraid)->first_row()->tanggal_putusan!=''? 1: 0;
                    }
                    if ($sudahputus==1){
                        if ($rx = $this->CI->hak_akses_m->get_hakim_panitera_jurusita_ids_verzet($perkaraid)) {
                            foreach ($rx->result() as $row) {
                                if ($hakim_id!='' && (in_array($hakim_id, explode(',',$row->majelis_hakim_id)))){
                                    $resul=true;
                                }else if ($panitera_id!='' && (in_array($panitera_id, explode(',',$row->panitera_pengganti_id)))){
                                    $resul=true;
                                };
                            }
                        }
                    }
                }elseif($keberatan==-2){
                    if ($this->CI->hak_akses_m->getInfoPerkaraIkrarTalak($perkaraid)->num_rows()>0) {
                       $sudahputus = $this->CI->hak_akses_m->getInfoPerkaraIkrarTalak($perkaraid)->first_row()->tgl_ikrar_talak!=''? 1: 0;
                    }
                    if ($sudahputus!=1){
                        if ($rx = $this->CI->hak_akses_m->get_hakim_panitera_jurusita_ids_ikrar($perkaraid)) {
                            foreach ($rx->result() as $row) {
                                if ($hakim_id!='' && (in_array($hakim_id, explode(',',$row->majelis_hakim_id)))){
                                    $resul=true;
                                }else if ($panitera_id!='' && (in_array($panitera_id, explode(',',$row->panitera_pengganti_id)))){
                                    $resul=true;
                                };
                            }
                        }
                    }
                }else{
                    if ($this->CI->hak_akses_m->getInfoPerkaraKeberatan($perkaraid)->num_rows()>0) {
                       $sudahputus = $this->CI->hak_akses_m->getInfoPerkaraKeberatan($perkaraid)->first_row()->putusan_keberatan!=''? 1: 0;
                    }
                    if ($sudahputus!=1){
                        if ($rx = $this->CI->hak_akses_m->get_hakim_panitera_jurusita_ids_keberatan($perkaraid)) {
                            foreach ($rx->result() as $row) {
                                if ($hakim_id!='' && (in_array($hakim_id, explode(',',$row->majelis_hakim_id)))){
                                    $resul=true;
                                }else if ($panitera_id!='' && (in_array($panitera_id, explode(',',$row->panitera_pengganti_id)))){
                                    $resul=true;
                                };
                            }
                        }
                    }
                }
                
			}
		}
		return $resul;
	}
	
	function HasRuleCetakRelaasSidang($perkaraid=''){
		return $this->HasRuleCetakDokumenPerkara($perkaraid);
	}

	function HasRuleCetakDokumenPerkara($perkaraid='',$keberatan=0){
		$resul = false;
		$username=$this->CI->session->userdata('username');
		$id_group=$this->CI->session->userdata('idgroup');
		$hakim_id=$this->CI->session->userdata('hakim_id');
		$panitera_id=$this->CI->session->userdata('panitera_id');
		$jurusita_id=$this->CI->session->userdata('jurusita_id');
		if(isset($username) && $username !='' ){
			if ($perkaraid!=''){
				if ($id_group==1 || $id_group==10 ){
					$resul=true;
				}else{
                    if ($keberatan==0){
                        if ($rx = $this->CI->hak_akses_m->get_hakim_panitera_jurusita_ids($perkaraid)) {
                            foreach ($rx->result() as $row) {
                                if ($hakim_id!='' && (in_array($hakim_id, explode(',',$row->majelis_hakim_id)))){
                                    $resul=true;
                                }else if ($panitera_id!='' && (in_array($panitera_id, explode(',',$row->panitera_pengganti_id)))){
                                    $resul=true;
                                }else if ($jurusita_id!='' && (in_array($jurusita_id, explode(',',$row->jurusita_id)))){
                                    $resul=true;
                                };
                            }
                        }    
                    }else{
                        if ($rx = $this->CI->hak_akses_m->get_hakim_panitera_jurusita_ids_keberatan($perkaraid)) {
                            foreach ($rx->result() as $row) {
                                if ($hakim_id!='' && (in_array($hakim_id, explode(',',$row->majelis_hakim_id)))){
                                    $resul=true;
                                }else if ($panitera_id!='' && (in_array($panitera_id, explode(',',$row->panitera_pengganti_id)))){
                                    $resul=true;
                                }else if ($jurusita_id!='' && (in_array($jurusita_id, explode(',',$row->jurusita_id)))){
                                    $resul=true;
                                };
                            }
                        } 
                        if ($id_group==30){
                            $resul=true;
                        }  
                    }
                }
			}
		}
		return $resul;
	}
	
	function HasRuleHakimPanitera($perkaraid=''){
		$resul = false;
		$username=$this->CI->session->userdata('username');
		$id_group=$this->CI->session->userdata('idgroup');
		$hakim_id=$this->CI->session->userdata('hakim_id');
		$panitera_id=$this->CI->session->userdata('panitera_id');
		if(isset($username) && $username !='' ){
			if ($perkaraid!=''){
				if ($id_group==1 || $id_group==10){
					$resul=true;
				}
                $sudahputus=0;
				if ($this->CI->hak_akses_m->getInfoPerkara($perkaraid)->num_rows()>0) {
					$sudahputus = $this->CI->hak_akses_m->getInfoPerkara($perkaraid)->first_row()->tanggal_putusan!=''? 1: 0;
	        	}
	            if ($sudahputus!=1){
					if ($rx = $this->CI->hak_akses_m->get_hakim_panitera_jurusita_ids($perkaraid)) {
	                    foreach ($rx->result() as $row) {
	                        if ($hakim_id!='' && (in_array($hakim_id, explode(',',$row->majelis_hakim_id)))){
								$resul=true;
							}else if ($panitera_id!='' && (in_array($panitera_id, explode(',',$row->panitera_pengganti_id)))){
								$resul=true;
							};
	                    }
	                }
                }
			}
		}
		return $resul;
	}

    function HasRuleFormHakimPanitera($perkaraid=''){
        $resul = false;
        $username=$this->CI->session->userdata('username');
        $id_group=$this->CI->session->userdata('idgroup');
        $hakim_id=$this->CI->session->userdata('hakim_id');
        $panitera_id=$this->CI->session->userdata('panitera_id');
        if(isset($username) && $username !='' ){
            if ($perkaraid!=''){
                if ($id_group==1 || $id_group==10){
                    $resul=true;
                }
                if ($rx = $this->CI->hak_akses_m->get_hakim_panitera_jurusita_ids($perkaraid)) {
                    foreach ($rx->result() as $row) {
                        if ($hakim_id!='' && (in_array($hakim_id, explode(',',$row->majelis_hakim_id)))){
                            $resul=true;
                        }else if ($panitera_id!='' && (in_array($panitera_id, explode(',',$row->panitera_pengganti_id)))){
                            $resul=true;
                        }
                    }
                }
                if($resul==false){
                    if ($rx = $this->CI->hak_akses_m->get_hakim_panitera_jurusita_ids_verzet($perkaraid)) {
                        foreach ($rx->result() as $row) {
                            if ($hakim_id!='' && (in_array($hakim_id, explode(',',$row->majelis_hakim_id)))){
                                $resul=true;
                            }else if ($panitera_id!='' && (in_array($panitera_id, explode(',',$row->panitera_pengganti_id)))){
                                $resul=true;
                            }
                        }
                    }
                }
                if($resul==false){
                    if ($rx = $this->CI->hak_akses_m->get_hakim_panitera_jurusita_ids_keberatan($perkaraid)) {
                        foreach ($rx->result() as $row) {
                            if ($hakim_id!='' && (in_array($hakim_id, explode(',',$row->majelis_hakim_id)))){
                                $resul=true;
                            }else if ($panitera_id!='' && (in_array($panitera_id, explode(',',$row->panitera_pengganti_id)))){
                                $resul=true;
                            }
                        }
                    }
                }
            }
        }
        return $resul;
    }

    function HasRuleHakimCetakPutusan($perkaraid=''){
        $resul = false;
        $username=$this->CI->session->userdata('username');
        $id_group=$this->CI->session->userdata('idgroup');
        $hakim_id=$this->CI->session->userdata('hakim_id');
        if(isset($username) && $username !='' ){
            if ($perkaraid!=''){
                $sudahputus=0;
                if ($this->CI->hak_akses_m->getInfoPerkara($perkaraid)->num_rows()>0) {
                    $sudahputus = $this->CI->hak_akses_m->getInfoPerkara($perkaraid)->first_row()->tanggal_putusan!=''? 1: 0;
                }
                if ($sudahputus!=1){
                    if ($rx = $this->CI->hak_akses_m->get_hakim_panitera_jurusita_ids($perkaraid)) {
                        foreach ($rx->result() as $row) {
                            if ($hakim_id!='' && (in_array($hakim_id, explode(',',$row->majelis_hakim_id)))){
                                $resul=true;
                            };
                        }
                    }
                }
            }
        }
        return $resul;
    }
	
	function HasRuleAddEditDiversiHakim($perkaraid=''){
		$resul = false;
		$username=$this->CI->session->userdata('username');
		$id_group=$this->CI->session->userdata('idgroup');
		$hakim_id=$this->CI->session->userdata('hakim_id');
		$panitera_id=$this->CI->session->userdata('panitera_id');
		if(isset($username) && $username !='' ){
			if ($perkaraid!=''){
				if ($id_group==1 || $id_group==10){
					$resul=true;
				}else if ($rx = $this->CI->hak_akses_m->get_hakim_panitera_jurusita_ids($perkaraid)) {
                    foreach ($rx->result() as $row) {
                        if ($hakim_id!='' && (in_array($hakim_id, explode(',',$row->majelis_hakim_id)))){
							$resul=true;
						}else if ($panitera_id!='' && (in_array($panitera_id, explode(',',$row->panitera_pengganti_id)))){
							$resul=true;
						};
                    }
                }
			}
		}
		return $resul;
	}
	
	function HasRuleAddEditDiversiKPN(){
		$resul = false;
		$username=$this->CI->session->userdata('username');
		$id_group=$this->CI->session->userdata('idgroup');
		if(isset($username) && $username !='' ){
			if ($id_group==1 || $id_group==10){
					$resul=true;
				}
		}
		return $resul;
	}

	function HasRuleAddMediasi($perkaraid=''){
		$resul = false;
		$username=$this->CI->session->userdata('username');
		$id_group=$this->CI->session->userdata('idgroup');
		$hakim_id=$this->CI->session->userdata('hakim_id');
		$panitera_id=$this->CI->session->userdata('panitera_id');
		if(isset($username) && $username !='' ){
			if ($perkaraid!=''){
				if ($id_group==1 || $id_group==10){
					$resul=true;
				}else if ($rx = $this->CI->hak_akses_m->get_hakim_panitera_jurusita_ids($perkaraid)) {
                    foreach ($rx->result() as $row) {
                        if ($hakim_id!='' && (in_array($hakim_id, explode(',',$row->majelis_hakim_id)))){
							$resul=true;
						}else if ($panitera_id!='' && (in_array($panitera_id, explode(',',$row->panitera_pengganti_id)))){
							$resul=true;
						};
                    }
                }
			}
		}
		return $resul;
	}

	function HasRuleAddIntervensi(){
		$resul = false;
		$username=$this->CI->session->userdata('username');
		$id_group=$this->CI->session->userdata('idgroup');
		if(isset($username) && $username !='' ){
			if ($id_group==1 || $id_group==10 || $id_group==410 || $id_group==412 || $id_group==413 || $id_group==1030 || $id_group==1032 || $id_group==1033 || $id_group==1000 || $id_group==1001 || $id_group==1002){
				$resul=true;
			}
		}
		return $resul;
	}
	
	function HasRuleAddJurnalBiaya(){
		$resul = false;
		$username=$this->CI->session->userdata('username');
		$id_group=$this->CI->session->userdata('idgroup');
		if(isset($username) && $username !='' ){
			if ($id_group==1 || $id_group==10 || $id_group==410 || $id_group==412 || $id_group==1030 || $id_group==1032 || $id_group==702 || $id_group==1000 || $id_group==1001 || $id_group==1010 || $id_group==1011){
					$resul=true;
				}
		}
		return $resul;
	}
	
	function HasRuleEditJurnalBiaya(){
		$resul = false;
		$username=$this->CI->session->userdata('username');
		$id_group=$this->CI->session->userdata('idgroup');
		if(isset($username) && $username !='' ){
			if ($id_group==1 || $id_group==10 || $id_group==410 || $id_group==412 || $id_group==1030 || $id_group==1032 || $id_group==702 || $id_group==1000 || $id_group==1001 || $id_group==1010 || $id_group==1011){
					$resul=true;
				}
		}
		return $resul;
	}
	
	function HasRuleManageIntervensi(){
		$resul = false;
		$username=$this->CI->session->userdata('username');
		$id_group=$this->CI->session->userdata('idgroup');
		if(isset($username) && $username !='' ){
			if ($id_group==1 || $id_group==10 || $id_group==410 || $id_group==412 || $id_group==413 || $id_group==1030 || $id_group==1032 || $id_group==1033 || $id_group==1000 || $id_group==1001 || $id_group==1002){
					$resul=true;
			}
		}
		return $resul;
	}
	
	function HasRuleAddVerzet(){
		$resul = false;
		$username=$this->CI->session->userdata('username');
		$id_group=$this->CI->session->userdata('idgroup');
		if(isset($username) && $username !='' ){
			if ($id_group==1 || $id_group==10 || $id_group==410 || $id_group==412 || $id_group==413 || $id_group==1030 || $id_group==1032 || $id_group==1033 || $id_group==1000 || $id_group==1001 || $id_group==1002){
					$resul=true;
			}
		}
		return $resul;
	}

    function HasRuleAddAktaCerai(){
        $resul = false;
        $username=$this->CI->session->userdata('username');
        $id_group=$this->CI->session->userdata('idgroup');
        if(isset($username) && $username !='' ){
            if ($id_group==1 || $id_group==10 || $id_group==410 || $id_group==414 || $id_group==1030 || $id_group==1034 || $id_group==1000 || $id_group==1003){
                    $resul=true;
            }
        }
        return $resul;
    }
	
	function HasRuleEditVerzet(){
		$resul = false;
		$username=$this->CI->session->userdata('username');
		$id_group=$this->CI->session->userdata('idgroup');
		if(isset($username) && $username !='' ){
			if ($id_group==1 || $id_group==10 || $id_group==410 || $id_group==412 || $id_group==413 || $id_group==414 || $id_group==1030 || $id_group==1032 || $id_group==1033 || $id_group==1034 || $id_group==1000 || $id_group==1001 || $id_group==1002 || $id_group==1003){
					$resul=true;
				}
		}
		return $resul;
	}
	
	function HasRuleEditBarangBukti(){
		$resul = false;
		$username=$this->CI->session->userdata('username');
		$id_group=$this->CI->session->userdata('idgroup');
		if(isset($username) && $username !='' ){
			if ($id_group==1 || $id_group==10 || $id_group==420 || $id_group==422 || $id_group==423 || $id_group==460 || $id_group==462 || $id_group==1020 || $id_group==1022){
					$resul=true;
				}
		}
		return $resul;
	}
	
	function HasRuleAddPenahanan($perkaraid=''){
		$resul = false;
		$username=$this->CI->session->userdata('username');
		$id_group=$this->CI->session->userdata('idgroup');
		$hakim_id=$this->CI->session->userdata('hakim_id');
		$panitera_id=$this->CI->session->userdata('panitera_id');
		if(isset($username) && $username !='' ){
			if ($perkaraid!=''){
				if ($id_group==1 || $id_group==10 || $id_group==420 || $id_group==422 || $id_group==423 || $id_group==460 || $id_group==462 || $id_group==463 || $id_group==461 || $id_group==1020 || $id_group==1022){
					$resul=true;
				}else if ($rx = $this->CI->hak_akses_m->get_hakim_panitera_jurusita_ids($perkaraid)) {
                    foreach ($rx->result() as $row) {
                        if ($hakim_id!='' && (in_array($hakim_id, explode(',',$row->majelis_hakim_id)))){
							$resul=true;
						}else if ($panitera_id!='' && (in_array($panitera_id, explode(',',$row->panitera_pengganti_id)))){
							$resul=true;
						};
                    }
                }
			}
		}
		return $resul;
	}
	
	function HasRuleEditPenahanan($perkaraid=''){
		$resul = false;
		$username=$this->CI->session->userdata('username');
		$id_group=$this->CI->session->userdata('idgroup');
		$hakim_id=$this->CI->session->userdata('hakim_id');
		$panitera_id=$this->CI->session->userdata('panitera_id');
		if(isset($username) && $username !='' ){
			if ($perkaraid!=''){
				if ($id_group==1 || $id_group==10 || $id_group==420 || $id_group==422 || $id_group==423 || $id_group==1020 || $id_group==1022 || $id_group==460 || $id_group==462 || $id_group==463 || $id_group==461){
					$resul=true;
				}else if ($rx = $this->CI->hak_akses_m->get_hakim_panitera_jurusita_ids($perkaraid)) {
                    foreach ($rx->result() as $row) {
                        if ($hakim_id!='' && (in_array($hakim_id, explode(',',$row->majelis_hakim_id)))){
							$resul=true;
						}else if ($panitera_id!='' && (in_array($panitera_id, explode(',',$row->panitera_pengganti_id)))){
							$resul=true;
						};
                    }
                }
			}
		}
		return $resul;
	}
	
	function HasRuleAddPendaftaranBanding($id_alur_perkara=''){
		$resul = false;
		$username=$this->CI->session->userdata('username');
		$id_group=$this->CI->session->userdata('idgroup');
		$tmp = explode(',', $id_alur_perkara);
        $alurperkaraid = $tmp[0];
		if(isset($username) && $username !='' && $alurperkaraid!=''){
			if ($id_group==1 || $id_group==10 || $id_group==902){
					$resul=true;
			}
			if ($alurperkaraid<100){
				switch($id_group){
					case 410:
						$resul = true;
					break;
                    case 414:
                        $resul = true;
                    break;
                    case 440:
                        $resul = true;
                    break;
                    case 444:
                        $resul = true;
                    break;
                    case 450:
                        $resul = true;
                    break;
                    case 454:
                        $resul = true;
                    break;					
                    case 1030:
                        $resul = true;
                    break;
                    case 1034:
                        $resul = true;
                    break;
                    case 1000:
                        $resul = true;
                    break;
                    case 1003:
                        $resul = true;
                    break;
					case 702:
						$resul = true;
					break;
				}
			}else if ($alurperkaraid>100){
				switch($id_group){
					case 420:
						$resul = true;
					break;					
					case 423:
						$resul = true;
					break;
                    case 460:
                        $resul = true;
                    break;
                    case 463:
                        $resul = true;
                    break;
                    case 470:
                        $resul = true;
                    break;
                    case 473:
                        $resul = true;
                    break;                                        
                    case 1020:
                        $resul = true;
                    break;
                    case 1023:
                        $resul = true;
                    break;
				}
			}
		}
		return $resul;
	}
	
	function HasRuleEditDataBanding($id_alur_perkara='', $perkaraid='', $keberatan=0){
		$resul = false;
		$username=$this->CI->session->userdata('username');
		$id_group=$this->CI->session->userdata('idgroup');
		$tmp = explode(',', $id_alur_perkara);
        $alurperkaraid = $tmp[0];
		if(isset($username) && $username !='' && $alurperkaraid!='' ){
			if ($id_group==1 || $id_group==10){
				$resul=true;
			}
			$sudahputus=0;
            if ($keberatan==0){
                if ($this->CI->hak_akses_m->getInfoPerkaraBanding($perkaraid)->num_rows()>0) {
                    $sudahputus = $this->CI->hak_akses_m->getInfoPerkaraBanding($perkaraid)->first_row()->putusan_banding!=''? 1: 0;
                }    
            }else{
                if ($this->CI->hak_akses_m->getInfoPerkaraKeberatan($perkaraid)->num_rows()>0) {
                   $sudahputus = $this->CI->hak_akses_m->getInfoPerkaraKeberatan($perkaraid)->first_row()->putusan_keberatan!=''? 1: 0;
                }
            }
			
	        if ($sudahputus!=1){
				if ($alurperkaraid<100){
					switch($id_group){
						case 410:
							$resul = true;
						break;						
						case 414:
                            $resul = true;
                        break;
                        case 440:
                            $resul = true;
                        break;
                        case 444:
                            $resul = true;
                        break;
                        case 450:
                            $resul = true;
                        break;
                        case 454:
                            $resul = true;
                        break;                        
                        case 1000:
                            $resul = true;
                        break;                        
                        case 1003:
                            $resul = true;
                        break;
                        case 1030:
                            $resul = true;
                        break;                        
                        case 1034:
                            $resul = true;
                        break;
					}
				}else if ($alurperkaraid>100){
					switch($id_group){
						case 420:
							$resul = true;
						break;						
						case 423:
							$resul = true;
						break;
                        case 460:
                            $resul = true;
                        break;
                        case 463:
                            $resul = true;
                        break;
                        case 470:
                            $resul = true;
                        break;
                        case 473:
                            $resul = true;
                        break;                                                
                        case 1020:
                        $resul = true;
                        break;
                        case 1023:
                            $resul = true;
                        break;
					}
				}
            }
		}
		return $resul;
	}

    function HasRuleEditDataPutusanBanding($id_alur_perkara='', $perkaraid='', $keberatan=0){
        $resul = false;
        $username=$this->CI->session->userdata('username');
        $id_group=$this->CI->session->userdata('idgroup');
        $tmp = explode(',', $id_alur_perkara);
        $alurperkaraid = $tmp[0];
        if(isset($username) && $username !='' && $alurperkaraid!='' ){
            if ($id_group==1 || $id_group==10){
                $resul=true;
            }
            $sudahputus=0;
            if ($keberatan==0){
                if ($this->CI->hak_akses_m->getInfoPerkaraBanding($perkaraid)->num_rows()>0) {
                    $sudahputus = $this->CI->hak_akses_m->getInfoPerkaraBanding($perkaraid)->first_row()->minutasi_banding!=''? 1: 0;
                }    
            }else{
                if ($this->CI->hak_akses_m->getInfoPerkaraKeberatan($perkaraid)->num_rows()>0) {
                   $sudahputus = $this->CI->hak_akses_m->getInfoPerkaraKeberatan($perkaraid)->first_row()->putusan_keberatan!=''? 1: 0;
                }
            }
                        
            if ($alurperkaraid<100){
                switch($id_group){
                    case 410:
                        $resul = true;
                    break;                      
                    case 414:
                        $resul = true;
                    break;
                    case 440:
                        $resul = true;
                    break;
                    case 444:
                        $resul = true;
                    break;
                    case 450:
                        $resul = true;
                    break;
                    case 454:
                        $resul = true;
                    break;                        
                    case 1000:
                        $resul = true;
                    break;                        
                    case 1003:
                        $resul = true;
                    break;
                    case 1030:
                        $resul = true;
                    break;                        
                    case 1034:
                        $resul = true;
                    break;
                }
            }else if ($alurperkaraid>100){
                switch($id_group){
                    case 420:
                        $resul = true;
                    break;                      
                    case 423:
                        $resul = true;
                    break;
                    case 460:
                        $resul = true;
                    break;
                    case 463:
                        $resul = true;
                    break;
                    case 470:
                        $resul = true;
                    break;
                    case 473:
                        $resul = true;
                    break;                                        
                    case 1020:
                    $resul = true;
                    break;
                    case 1023:
                        $resul = true;
                    break;
                }
            }
        }
        return $resul;
    }

    function HasRuleEditPemberitahuanPutusanBanding($id_alur_perkara='', $perkaraid='', $keberatan=0){
        $resul = false;
        $username=$this->CI->session->userdata('username');
        $id_group=$this->CI->session->userdata('idgroup');
        $tmp = explode(',', $id_alur_perkara);
        $alurperkaraid = $tmp[0];
        if(isset($username) && $username !='' && $alurperkaraid!='' ){
            if ($id_group==1 || $id_group==10 || $id_group==902){
                $resul=true;
            }
            $sudahputus=0;
            if ($keberatan==0){
                if ($this->CI->hak_akses_m->getInfoPerkaraBanding($perkaraid)->num_rows()>0) {
                    $sudahputus = $this->CI->hak_akses_m->getInfoPerkaraBanding($perkaraid)->first_row()->minutasi_banding!=''? 1: 0;
                }    
            }else{
                if ($this->CI->hak_akses_m->getInfoPerkaraKeberatan($perkaraid)->num_rows()>0) {
                   $sudahputus = $this->CI->hak_akses_m->getInfoPerkaraKeberatan($perkaraid)->first_row()->putusan_keberatan!=''? 1: 0;
                }
            }
            if ($alurperkaraid<100){
                switch($id_group){
                        case 410:
                            $resul = true;
                        break;                      
                        case 414:
                            $resul = true;
                        break;
                        case 440:
                            $resul = true;
                        break;
                        case 444:
                            $resul = true;
                        break;
                        case 450:
                            $resul = true;
                        break;
                        case 454:
                            $resul = true;
                        break;                        
                        case 1000:
                            $resul = true;
                        break;                        
                        case 1003:
                            $resul = true;
                        break;
                        case 1030:
                            $resul = true;
                        break;                        
                        case 1034:
                            $resul = true;
                        break;
                        case 600:
                            if ($rx = $this->CI->hak_akses_m->get_hakim_panitera_jurusita_ids($perkaraid)) {
                                foreach ($rx->result() as $row) {
                                    if ($jurusita_id!='' && (in_array($jurusita_id, explode(',',$row->jurusita_id)))){
                                        $resul=true;
                                    }
                                }
                            }
                        break;
                }
            }else if ($alurperkaraid>100){
                switch($id_group){
                        case 420:
                            $resul = true;
                        break;                      
                        case 423:
                            $resul = true;
                        break;
                        case 460:
                            $resul = true;
                        break;
                        case 463:
                            $resul = true;
                        break;
                        case 470:
                            $resul = true;
                        break;
                        case 473:
                            $resul = true;
                        break;                                                
                        case 1020:
                            $resul = true;
                        break;
                        case 1023:
                            $resul = true;
                        break;
                        case 600:
                            if ($rx = $this->CI->hak_akses_m->get_hakim_panitera_jurusita_ids($perkaraid)) {
                                foreach ($rx->result() as $row) {
                                    if ($jurusita_id!='' && (in_array($jurusita_id, explode(',',$row->jurusita_id)))){
                                        $resul=true;
                                    }
                                }
                            }
                        break;
                }
            }
        }
        return $resul;
    }
	
	function HasRuleHapusDataBanding($id_alur_perkara=''){
		$resul = false;
		$username=$this->CI->session->userdata('username');
		$id_group=$this->CI->session->userdata('idgroup');
		$tmp = explode(',', $id_alur_perkara);
        $alurperkaraid = $tmp[0];
		if(isset($username) && $username !='' && $alurperkaraid!='' ){
			if ($id_group==1 || $id_group==10){
					$resul=true;
			}
			if ($alurperkaraid<100){
				switch($id_group){
					case 410:
						$resul = true;
					break;
                    case 414:
                        $resul = true;
                    break;
                    case 440:
                        $resul = true;
                    break;
                    case 444:
                        $resul = true;
                    break;
                    case 450:
                        $resul = true;
                    break;
                    case 454:
                        $resul = true;
                    break;
                    case 1030:
                        $resul = true;
                        break;
                    case 1000:
                        $resul = true;
                    break;
				}
			}else if ($alurperkaraid>100){
				switch($id_group){
					case 420:
						$resul = true;
					break;
                    case 460:
                        $resul = true;
                    break;
                    case 470:
                        $resul = true;
                    break;                                        
                    case 1020:
                        $resul = true;
                    break;
				}
			}
		}
		return $resul;
	}

	function HasRuleEditDataKasasi($id_alur_perkara='', $perkaraid=''){
		$resul = false;
		$username=$this->CI->session->userdata('username');
		$id_group=$this->CI->session->userdata('idgroup');
		$tmp = explode(',', $id_alur_perkara);
        $alurperkaraid = $tmp[0];
		if(isset($username) && $username !='' && $alurperkaraid!='' ){
			if ($id_group==1 || $id_group==10 || $id_group==903){
					$resul=true;
			}
			$sudahputus=0;
			if ($this->CI->hak_akses_m->getInfoPerkaraKasasi($perkaraid)->num_rows()>0) {
				$sudahputus = $this->CI->hak_akses_m->getInfoPerkaraKasasi($perkaraid)->first_row()->putusan_kasasi!=''? 1: 0;
	        }
	        if ($sudahputus!=1){
				if ($alurperkaraid<100){
					switch($id_group){
						case 410:
                            $resul = true;
                        break;                      
                        case 414:
                            $resul = true;
                        break;
                        case 440:
                            $resul = true;
                        break;
                        case 444:
                            $resul = true;
                        break;
                        case 450:
                            $resul = true;
                        break;
                        case 454:
                            $resul = true;
                        break;
                        case 1030:
                            $resul = true;
                        break;
                        case 1032:
                            $resul = true;
                        break;
                        case 1034:
                            $resul = true;
                        break;
                        case 1000:
                            $resul = true;
                        break;
                        case 1001:
                            $resul = true;
                        break;
                        case 1003:
                            $resul = true;
                        break;
					}
				}else if ($alurperkaraid>100){
					switch($id_group){
						case 420:
                            $resul = true;
                        break;                      
                        case 423:
                            $resul = true;
                        break;
                        case 460:
                            $resul = true;
                        break;
                        case 463:
                            $resul = true;
                        break;                                                
                        case 1020:
                        $resul = true;
                        break;
                        case 1023:
                            $resul = true;
                        break;
					}
				}
            }
		}
		return $resul;
	}

    function HasRuleEditPutusanDataKasasi($id_alur_perkara='', $perkaraid=''){
        $resul = false;
        $username=$this->CI->session->userdata('username');
        $id_group=$this->CI->session->userdata('idgroup');
        $tmp = explode(',', $id_alur_perkara);
        $alurperkaraid = $tmp[0];
        if(isset($username) && $username !='' && $alurperkaraid!='' ){
            if ($id_group==1 || $id_group==10 || $id_group==903){
                    $resul=true;
            }
            $sudahputus=0;
            if ($this->CI->hak_akses_m->getInfoPerkaraKasasi($perkaraid)->num_rows()>0) {
                $sudahputus = $this->CI->hak_akses_m->getInfoPerkaraKasasi($perkaraid)->first_row()->minutasi_kasasi!=''? 1: 0;
            }            
            if ($alurperkaraid<100){
                switch($id_group){
                    case 410:
                        $resul = true;
                    break;                      
                    case 414:
                        $resul = true;
                    break;
                    case 440:
                        $resul = true;
                    break;
                    case 444:
                        $resul = true;
                    break;
                    case 450:
                        $resul = true;
                    break;
                    case 454:
                        $resul = true;
                    break;
                    case 1030:
                        $resul = true;
                    break;
                    case 1032:
                        $resul = true;
                    break;
                    case 1034:
                        $resul = true;
                    break;
                    case 1000:
                        $resul = true;
                    break;
                    case 1001:
                        $resul = true;
                    break;
                    case 1003:
                        $resul = true;
                    break;
                    case 1034:
                        $resul = true;
                    break;
                }
            }else if ($alurperkaraid>100){
                switch($id_group){
                    case 420:
                        $resul = true;
                    break;                      
                    case 423:
                        $resul = true;
                    break;
                    case 460:
                        $resul = true;
                    break;
                    case 463:
                        $resul = true;
                    break;
                    case 470:
                        $resul = true;
                    break;
                    case 473:
                        $resul = true;
                    break;                                        
                    case 1020:
                    $resul = true;
                    break;
                    case 1023:
                        $resul = true;
                    break;
                }
            }            
        }
        return $resul;
    }

    function HasRuleEditPemberitahuanPutusanKasasi($id_alur_perkara='', $perkaraid='', $keberatan=0){
        $resul = false;
        $username=$this->CI->session->userdata('username');
        $id_group=$this->CI->session->userdata('idgroup');
        $tmp = explode(',', $id_alur_perkara);
        $alurperkaraid = $tmp[0];
        if(isset($username) && $username !='' && $alurperkaraid!='' ){
            if ($id_group==1 || $id_group==10 || $id_group==902){
                $resul=true;
            }
            $sudahputus=0;
            if ($this->CI->hak_akses_m->getInfoPerkaraKasasi($perkaraid)->num_rows()>0) {
                $sudahputus = $this->CI->hak_akses_m->getInfoPerkaraKasasi($perkaraid)->first_row()->minutasi_kasasi!=''? 1: 0;
            }
       
            if ($alurperkaraid<100){
                switch($id_group){
                        case 410:
                            $resul = true;
                        break;                      
                        case 414:
                            $resul = true;
                        break;
                        case 440:
                            $resul = true;
                        break;
                        case 444:
                            $resul = true;
                        break;
                        case 450:
                            $resul = true;
                        break;
                        case 454:
                            $resul = true;
                        break;
                        case 1030:
                            $resul = true;
                        break;
                        case 1032:
                            $resul = true;
                        break;
                        case 1034:
                            $resul = true;
                        break;
                        case 1000:
                            $resul = true;
                        break;
                        case 1001:
                            $resul = true;
                        break;
                        case 1003:
                            $resul = true;
                        break;
                        case 600:
                            if ($rx = $this->CI->hak_akses_m->get_hakim_panitera_jurusita_ids($perkaraid)) {
                                foreach ($rx->result() as $row) {
                                    if ($jurusita_id!='' && (in_array($jurusita_id, explode(',',$row->jurusita_id)))){
                                        $resul=true;
                                    }
                                }
                            }
                        break;
                }
            }else if ($alurperkaraid>100){
                switch($id_group){
                        case 420:
                            $resul = true;
                        break;                      
                        case 423:
                            $resul = true;
                        break;
                        case 460:
                            $resul = true;
                        break;
                        case 463:
                            $resul = true;
                        break;
                        case 470:
                        $resul = true;
                        break;
                        case 473:
                            $resul = true;
                        break;                                                
                        case 1020:
                        $resul = true;
                        break;
                        case 1023:
                            $resul = true;
                        break;
                        case 600:
                            if ($rx = $this->CI->hak_akses_m->get_hakim_panitera_jurusita_ids($perkaraid)) {
                                foreach ($rx->result() as $row) {
                                    if ($jurusita_id!='' && (in_array($jurusita_id, explode(',',$row->jurusita_id)))){
                                        $resul=true;
                                    }
                                }
                            }
                        break;
                }
            }
        }
        return $resul;
    }

	function HasRuleEditDataPK($id_alur_perkara='', $perkaraid=''){
		$resul = false;
		$username=$this->CI->session->userdata('username');
		$id_group=$this->CI->session->userdata('idgroup');
		$tmp = explode(',', $id_alur_perkara);
        $alurperkaraid = $tmp[0];
		if(isset($username) && $username !='' && $alurperkaraid!='' ){
			if ($id_group==1 || $id_group==10){
					$resul=true;
			}
			$sudahputus=0;
			if ($this->CI->hak_akses_m->getInfoPerkaraPK($perkaraid)->num_rows()>0) {
				$sudahputus = $this->CI->hak_akses_m->getInfoPerkaraPK($perkaraid)->first_row()->putusan_pk!=''? 1: 0;
	        }
	        if ($sudahputus!=1){
				if ($alurperkaraid<100){
					switch($id_group){
						case 410:
                            $resul = true;
                        break;                      
                        case 414:
                            $resul = true;
                        break;
                        case 440:
                            $resul = true;
                        break;
                        case 444:
                            $resul = true;
                        break;
                        case 450:
                            $resul = true;
                        break;
                        case 454:
                            $resul = true;
                        break;
                        case 1030:
                            $resul = true;
                        break;
                        case 1032:
                            $resul = true;
                        break;
                        case 1034:
                            $resul = true;
                        break;
                        case 1000:
                            $resul = true;
                        break;
                        case 1001:
                            $resul = true;
                        break;
                        case 1003:
                            $resul = true;
                        break;
					}
				}else if ($alurperkaraid>100){
					switch($id_group){
						case 420:
                            $resul = true;
                        break;                      
                        case 423:
                            $resul = true;
                        break;
                        case 460:
                            $resul = true;
                        break;
                        case 463:
                            $resul = true;
                        break;
                        case 470:
                            $resul = true;
                        break;
                        case 473:
                            $resul = true;
                        break;                                                
                        case 1020:
                            $resul = true;
                        break;
                        case 1023:
                            $resul = true;
                        break;
					}
				}
            }
		}
		return $resul;
	}

    function HasRuleEditDataPutusanPK($id_alur_perkara='', $perkaraid=''){
        $resul = false;
        $username=$this->CI->session->userdata('username');
        $id_group=$this->CI->session->userdata('idgroup');
        $tmp = explode(',', $id_alur_perkara);
        $alurperkaraid = $tmp[0];
        if(isset($username) && $username !='' && $alurperkaraid!='' ){
            if ($id_group==1 || $id_group==10){
                    $resul=true;
            }
            $sudahputus=0;
            if ($this->CI->hak_akses_m->getInfoPerkaraPK($perkaraid)->num_rows()>0) {
                $sudahputus = $this->CI->hak_akses_m->getInfoPerkaraPK($perkaraid)->first_row()->minutasi_pk!=''? 1: 0;
            }            
            if ($alurperkaraid<100){
                switch($id_group){
                    case 410:
                        $resul = true;
                    break;                      
                    case 414:
                        $resul = true;
                    break;
                    case 440:
                        $resul = true;
                    break;
                    case 444:
                        $resul = true;
                    break;
                    case 450:
                        $resul = true;
                    break;
                    case 454:
                        $resul = true;
                    break;
                    case 1030:
                        $resul = true;
                    break;
                    case 1032:
                        $resul = true;
                    break;
                    case 1034:
                        $resul = true;
                    break;
                    case 1000:
                        $resul = true;
                    break;
                    case 1001:
                        $resul = true;
                    break;
                    case 1003:
                        $resul = true;
                    break;
                    case 1034:
                        $resul = true;
                    break;
                }
            }else if ($alurperkaraid>100){
                switch($id_group){
                    case 420:
                        $resul = true;
                    break;                      
                    case 423:
                        $resul = true;
                    break;
                    case 460:
                        $resul = true;
                    break;
                    case 463:
                        $resul = true;
                    break;
                    case 470:
                        $resul = true;
                    break;
                    case 473:
                        $resul = true;
                    break;                                        
                    case 1020:
                        $resul = true;
                    break;
                    case 1023:
                        $resul = true;
                    break;
                }
            }            
        }
        return $resul;
    }

    function HasRuleEditPemberitahuanPutusanPK($id_alur_perkara='', $perkaraid='', $keberatan=0){
        $resul = false;
        $username=$this->CI->session->userdata('username');
        $id_group=$this->CI->session->userdata('idgroup');
        $tmp = explode(',', $id_alur_perkara);
        $alurperkaraid = $tmp[0];
        if(isset($username) && $username !='' && $alurperkaraid!='' ){
            if ($id_group==1 || $id_group==10 || $id_group==902){
                $resul=true;
            }
            $sudahputus=0;
            if ($this->CI->hak_akses_m->getInfoPerkaraPK($perkaraid)->num_rows()>0) {
                $sudahputus = $this->CI->hak_akses_m->getInfoPerkaraPK($perkaraid)->first_row()->minutasi_pk!=''? 1: 0;
            }
       
            if ($sudahputus!=1 AND $alurperkaraid<100){
                switch($id_group){
                        case 410:
                            $resul = true;
                        break;                      
                        case 414:
                            $resul = true;
                        break;
                        case 440:
                            $resul = true;
                        break;
                        case 444:
                            $resul = true;
                        break;
                        case 450:
                            $resul = true;
                        break;
                        case 454:
                            $resul = true;
                        break;
                        case 1030:
                            $resul = true;
                        break;
                        case 1032:
                            $resul = true;
                        break;
                        case 1034:
                            $resul = true;
                        break;
                        case 1000:
                            $resul = true;
                        break;
                        case 1001:
                            $resul = true;
                        break;
                        case 1003:
                            $resul = true;
                        break;
                        case 600:
                            if ($rx = $this->CI->hak_akses_m->get_hakim_panitera_jurusita_ids($perkaraid)) {
                                foreach ($rx->result() as $row) {
                                    if ($jurusita_id!='' && (in_array($jurusita_id, explode(',',$row->jurusita_id)))){
                                        $resul=true;
                                    }
                                }
                            }
                        break;
                }
            }else if ($sudahputus!=1 AND $alurperkaraid>100){
                switch($id_group){
                        case 420:
                            $resul = true;
                        break;                      
                        case 423:
                            $resul = true;
                        break;
                        case 460:
                            $resul = true;
                        break;
                        case 463:
                            $resul = true;
                        break;
                        case 470:
                            $resul = true;
                        break;
                        case 473:
                            $resul = true;
                        break;                                                
                        case 1020:
                            $resul = true;
                        break;
                        case 1023:
                            $resul = true;
                        break;
                        case 600:
                            if ($rx = $this->CI->hak_akses_m->get_hakim_panitera_jurusita_ids($perkaraid)) {
                                foreach ($rx->result() as $row) {
                                    if ($jurusita_id!='' && (in_array($jurusita_id, explode(',',$row->jurusita_id)))){
                                        $resul=true;
                                    }
                                }
                            }
                        break;
                }
            }
        }
        return $resul;
    }

	function HasRuleAddPermohonanUpayaHukum($id_alur_perkara=''){
		$resul = false;
		$username=$this->CI->session->userdata('username');
		$id_group=$this->CI->session->userdata('idgroup');
		$tmp = explode(',', $id_alur_perkara);
        $alurperkaraid = $tmp[0];
		if(isset($username) && $username !='' && $alurperkaraid!=''){
			if ($id_group==1 || $id_group==10 || $id_group==904 || $id_group==903){
					$resul=true;
			}
			if ($alurperkaraid<100){
				switch($id_group){
					case 410:
						$resul = true;
					break;
					case 412:
						$resul = true;
					break;
                    case 1030:
                        $resul = true;
                    break;
                    case 1032:
                        $resul = true;
                    break;
                    case 1000:
                        $resul = true;
                    break;
                    case 1001:
                        $resul = true;
                    break;
                    case 1010:
                        $resul = true;
                    break;
                    case 1011:
                        $resul = true;
                    break;
					case 702:
						$resul = true;
					break;
                    case 905:
                        $resul = true;
                    break;
				}
			}else if ($alurperkaraid>100){
				switch($id_group){
					case 420:
						$resul = true;
					break;
					case 422:
						$resul = true;
					break;
					case 423:
						$resul = true;
					break;
                    case 463:
                        $resul = true;
                    break;
                    case 470:
                        $resul = true;
                    break;
                    case 473:
                        $resul = true;
                    break;
                    case 483:
                        $resul = true;
                    break;
                    case 1020:
                        $resul = true;
                    break;
                    case 1023:
                        $resul = true;
                    break;
				}
			}
		}
		return $resul;
	}

	function HasRuleHapusDataUpayaHukum($id_alur_perkara=''){
		$resul = false;
		$username=$this->CI->session->userdata('username');
		$id_group=$this->CI->session->userdata('idgroup');
		$tmp = explode(',', $id_alur_perkara);
        $alurperkaraid = $tmp[0];
		if(isset($username) && $username !='' && $alurperkaraid!='' ){
			if ($id_group==1 || $id_group==10){
					$resul=true;
			}
			if ($alurperkaraid<100){
				switch($id_group){
					case 410:
						$resul = true;
					break;
                    case 440:
                        $resul = true;
                    break;
                    case 450:
                        $resul = true;
                    break;
                    case 1030:
                        $resul = true;
                    break;
                    case 1000:
                        $resul = true;
                    break;
                    case 1010:
                        $resul = true;
                    break;
				}
			}else if ($alurperkaraid>100){
				switch($id_group){
					case 420:
						$resul = true;
					break;
                    case 460:
                        $resul = true;
                    break;
                    case 470:
                        $resul = true;
                    break;                                                            
                    case 1020:
                        $resul = true;
                    break;                    
				}
			}
		}
		return $resul;
	}

	function HasRuleCetakDokumenUpayaHukum($id_alur_perkara='', $perkaraid=''){
		$resul = false;
		$username=$this->CI->session->userdata('username');
		$id_group=$this->CI->session->userdata('idgroup');
		$tmp = explode(',', $id_alur_perkara);
        $alurperkaraid = $tmp[0];
		$jurusita_id=$this->CI->session->userdata('jurusita_id');
		if(isset($username) && $username !='' && $alurperkaraid!='' ){
			if ($id_group==1 || $id_group==10  || $id_group==904 || $id_group==903){
					$resul=true;
			}
			if ($alurperkaraid<100){
				switch($id_group){
					case 410:
						$resul = true;
					break;
					case 412:
						$resul = true;
					break;
					case 413:
						$resul = true;
					break;
                    case 1030:
                        $resul = true;
                    break;
                    case 1032:
                        $resul = true;
                    break;
                    case 1033:
                        $resul = true;
                    break;
                    case 1000:
                        $resul = true;
                    break;
                    case 1001:
                        $resul = true;
                    break;
                    case 1003:
                        $resul = true;
                    break;
                    case 1010:
                        $resul = true;
                    break;
                    case 1011:
                        $resul = true;
                    break;
                    case 1013:
                        $resul = true;
                    break;
					case 600:
						if ($rx = $this->CI->hak_akses_m->get_hakim_panitera_jurusita_ids($perkaraid)) {
                            foreach ($rx->result() as $row) {
                                if ($jurusita_id!='' && (in_array($jurusita_id, explode(',',$row->jurusita_id)))){
                                    $resul=true;
                                }
                            }
                        }
					break;
                    case 905:
                        $resul = true;
                    break;
				}
			}else if ($alurperkaraid>100){
				switch($id_group){
					case 420:
						$resul = true;
					break;
					case 422:
						$resul = true;
					break;
					case 423:
						$resul = true;
					break;
                    case 463:
                        $resul = true;
                    break;
                    case 470:
                        $resul = true;
                    break;
                    case 473:
                        $resul = true;
                    break;
                    case 483:
                        $resul = true;
                    break;
                    case 1020:
                        $resul = true;
                    break;
                    case 1023:
                        $resul = true;
                    break;
					case 600:
						if ($rx = $this->CI->hak_akses_m->get_hakim_panitera_jurusita_ids($perkaraid)) {
		                    foreach ($rx->result() as $row) {
		                        if ($jurusita_id!='' && (in_array($jurusita_id, explode(',',$row->jurusita_id)))){
									$resul=true;
								}
		                    }
		                }
					break;
				}
			}
		}
		return $resul;
	}
	
	function HasRuleAddPermohonanGrasi(){
		$resul = false;
		$username=$this->CI->session->userdata('username');
		$id_group=$this->CI->session->userdata('idgroup');
		if(isset($username) && $username !='' ){
			if ($id_group==1 || $id_group==10 || $id_group==420 || $id_group==422 || $id_group==423 || $id_group==463 || $id_group==470 || $id_group==473 || $id_group==483 || $id_group==1020 || $id_group==1023){
				$resul=true;
			}
		}
		return $resul;
	}
	
	function HasRuleEditDataGrasi(){
		$resul = false;
		$username=$this->CI->session->userdata('username');
		$id_group=$this->CI->session->userdata('idgroup');
		if(isset($username) && $username !='' ){
			if ($id_group==1 || $id_group==10 || $id_group==420 || $id_group==422 || $id_group==423 || $id_group==463 || $id_group==470 || $id_group==473 || $id_group==483 || $id_group==1020 || $id_group==1023){
				$resul=true;
			}
		}
		return $resul;
	}
	
	function HasRuleHapusDataGrasi(){
		$resul = false;
		$username=$this->CI->session->userdata('username');
		$id_group=$this->CI->session->userdata('idgroup');
		if(isset($username) && $username !='' ){
			if ($id_group==1 || $id_group==10 || $id_group==420 || $id_group==460 || $id_group==470 || $id_group==1023){
				$resul=true;
			}
		}
		return $resul;
	}
	
	function HasRuleCabutPerkara($perkaraid=''){
		$resul = false;
		$username=$this->CI->session->userdata('username');
		$id_group=$this->CI->session->userdata('idgroup');
		$hakim_id=$this->CI->session->userdata('hakim_id');
		$panitera_id=$this->CI->session->userdata('panitera_id');
		if(isset($username) && $username !='' ){
			if ($perkaraid!=''){
				if ($id_group==1 || $id_group==10 || $id_group==410 || $id_group==412 || $id_group==1030 || $id_group==1032 || $id_group==1000 || $id_group==1001 || $id_group==1010 || $id_group==1011){
					$resul=true;
				}else if ($rx = $this->CI->hak_akses_m->get_hakim_panitera_jurusita_ids($perkaraid)) {
                    foreach ($rx->result() as $row) {
                        if ($hakim_id!='' && (in_array($hakim_id, explode(',',$row->majelis_hakim_id)))){
							$resul=true;
						}else if ($panitera_id!='' && (in_array($panitera_id, explode(',',$row->panitera_pengganti_id)))){
							$resul=true;
						};
                    }
                }
			}
		}
		return $resul;
	}
	
	function HasRuleHapusPerkara(){
		$resul = false;
		$username=$this->CI->session->userdata('username');
		$id_group=$this->CI->session->userdata('idgroup');
		if(isset($username) && $username !='' ){
			if ($id_group==1 || $id_group==10){
				$resul=true;
			}
		}
		return $resul;
	}
}